// Auto-generated by avdl-compiler v1.3.25 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/stellar1/bundle.avdl

package stellar1

import (
	"errors"
	keybase1 "github.com/keybase/client/go/protocol/keybase1"
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
)

type BundleRevision uint64

func (o BundleRevision) DeepCopy() BundleRevision {
	return o
}

type EncryptedBundle struct {
	V   int                           `codec:"v" json:"v"`
	E   []byte                        `codec:"e" json:"e"`
	N   keybase1.BoxNonce             `codec:"n" json:"n"`
	Gen keybase1.PerUserKeyGeneration `codec:"gen" json:"gen"`
}

func (o EncryptedBundle) DeepCopy() EncryptedBundle {
	return EncryptedBundle{
		V: o.V,
		E: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.E),
		N:   o.N.DeepCopy(),
		Gen: o.Gen.DeepCopy(),
	}
}

type BundleVersion int

const (
	BundleVersion_V1 BundleVersion = 1
)

func (o BundleVersion) DeepCopy() BundleVersion { return o }

var BundleVersionMap = map[string]BundleVersion{
	"V1": 1,
}

var BundleVersionRevMap = map[BundleVersion]string{
	1: "V1",
}

func (e BundleVersion) String() string {
	if v, ok := BundleVersionRevMap[e]; ok {
		return v
	}
	return ""
}

type BundleSecretVersioned struct {
	Version__ BundleVersion   `codec:"version" json:"version"`
	V1__      *BundleSecretV1 `codec:"v1,omitempty" json:"v1,omitempty"`
}

func (o *BundleSecretVersioned) Version() (ret BundleVersion, err error) {
	switch o.Version__ {
	case BundleVersion_V1:
		if o.V1__ == nil {
			err = errors.New("unexpected nil value for V1__")
			return ret, err
		}
	}
	return o.Version__, nil
}

func (o BundleSecretVersioned) V1() (res BundleSecretV1) {
	if o.Version__ != BundleVersion_V1 {
		panic("wrong case accessed")
	}
	if o.V1__ == nil {
		return
	}
	return *o.V1__
}

func NewBundleSecretVersionedWithV1(v BundleSecretV1) BundleSecretVersioned {
	return BundleSecretVersioned{
		Version__: BundleVersion_V1,
		V1__:      &v,
	}
}

func (o BundleSecretVersioned) DeepCopy() BundleSecretVersioned {
	return BundleSecretVersioned{
		Version__: o.Version__.DeepCopy(),
		V1__: (func(x *BundleSecretV1) *BundleSecretV1 {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.V1__),
	}
}

type BundleVisibleV1 struct {
	Revision BundleRevision       `codec:"revision" json:"revision"`
	Prev     Hash                 `codec:"prev" json:"prev"`
	Accounts []BundleVisibleEntry `codec:"accounts" json:"accounts"`
}

func (o BundleVisibleV1) DeepCopy() BundleVisibleV1 {
	return BundleVisibleV1{
		Revision: o.Revision.DeepCopy(),
		Prev:     o.Prev.DeepCopy(),
		Accounts: (func(x []BundleVisibleEntry) []BundleVisibleEntry {
			if x == nil {
				return nil
			}
			ret := make([]BundleVisibleEntry, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Accounts),
	}
}

type BundleSecretV1 struct {
	VisibleHash Hash                `codec:"visibleHash" json:"visibleHash"`
	Accounts    []BundleSecretEntry `codec:"accounts" json:"accounts"`
}

func (o BundleSecretV1) DeepCopy() BundleSecretV1 {
	return BundleSecretV1{
		VisibleHash: o.VisibleHash.DeepCopy(),
		Accounts: (func(x []BundleSecretEntry) []BundleSecretEntry {
			if x == nil {
				return nil
			}
			ret := make([]BundleSecretEntry, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Accounts),
	}
}

type AccountMode int

const (
	AccountMode_NONE AccountMode = 0
	AccountMode_USER AccountMode = 1
)

func (o AccountMode) DeepCopy() AccountMode { return o }

var AccountModeMap = map[string]AccountMode{
	"NONE": 0,
	"USER": 1,
}

var AccountModeRevMap = map[AccountMode]string{
	0: "NONE",
	1: "USER",
}

func (e AccountMode) String() string {
	if v, ok := AccountModeRevMap[e]; ok {
		return v
	}
	return ""
}

type BundleVisibleEntry struct {
	AccountID AccountID   `codec:"accountID" json:"accountID"`
	Mode      AccountMode `codec:"mode" json:"mode"`
	IsPrimary bool        `codec:"isPrimary" json:"isPrimary"`
}

func (o BundleVisibleEntry) DeepCopy() BundleVisibleEntry {
	return BundleVisibleEntry{
		AccountID: o.AccountID.DeepCopy(),
		Mode:      o.Mode.DeepCopy(),
		IsPrimary: o.IsPrimary,
	}
}

type BundleSecretEntry struct {
	AccountID AccountID   `codec:"accountID" json:"accountID"`
	Signers   []SecretKey `codec:"signers" json:"signers"`
	Name      string      `codec:"name" json:"name"`
}

func (o BundleSecretEntry) DeepCopy() BundleSecretEntry {
	return BundleSecretEntry{
		AccountID: o.AccountID.DeepCopy(),
		Signers: (func(x []SecretKey) []SecretKey {
			if x == nil {
				return nil
			}
			ret := make([]SecretKey, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Signers),
		Name: o.Name,
	}
}

type Bundle struct {
	Revision BundleRevision `codec:"revision" json:"revision"`
	Prev     Hash           `codec:"prev" json:"prev"`
	OwnHash  Hash           `codec:"ownHash" json:"ownHash"`
	Accounts []BundleEntry  `codec:"accounts" json:"accounts"`
}

func (o Bundle) DeepCopy() Bundle {
	return Bundle{
		Revision: o.Revision.DeepCopy(),
		Prev:     o.Prev.DeepCopy(),
		OwnHash:  o.OwnHash.DeepCopy(),
		Accounts: (func(x []BundleEntry) []BundleEntry {
			if x == nil {
				return nil
			}
			ret := make([]BundleEntry, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Accounts),
	}
}

type BundleEntry struct {
	AccountID AccountID   `codec:"accountID" json:"accountID"`
	Mode      AccountMode `codec:"mode" json:"mode"`
	IsPrimary bool        `codec:"isPrimary" json:"isPrimary"`
	Signers   []SecretKey `codec:"signers" json:"signers"`
	Name      string      `codec:"name" json:"name"`
}

func (o BundleEntry) DeepCopy() BundleEntry {
	return BundleEntry{
		AccountID: o.AccountID.DeepCopy(),
		Mode:      o.Mode.DeepCopy(),
		IsPrimary: o.IsPrimary,
		Signers: (func(x []SecretKey) []SecretKey {
			if x == nil {
				return nil
			}
			ret := make([]SecretKey, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Signers),
		Name: o.Name,
	}
}

type BundleInterface interface {
}

func BundleProtocol(i BundleInterface) rpc.Protocol {
	return rpc.Protocol{
		Name:    "stellar.1.bundle",
		Methods: map[string]rpc.ServeHandlerDescription{},
	}
}

type BundleClient struct {
	Cli rpc.GenericClient
}
