// Auto-generated by avdl-compiler v1.3.25 (https://github.com/keybase/node-avdl-compiler)
//   Input file: avdl/chat1/remote.avdl

package chat1

import (
	"errors"
	gregor1 "github.com/keybase/client/go/protocol/gregor1"
	keybase1 "github.com/keybase/client/go/protocol/keybase1"
	"github.com/keybase/go-framed-msgpack-rpc/rpc"
	context "golang.org/x/net/context"
)

type MessageBoxed struct {
	Version          MessageBoxedVersion  `codec:"version" json:"version"`
	ServerHeader     *MessageServerHeader `codec:"serverHeader,omitempty" json:"serverHeader,omitempty"`
	ClientHeader     MessageClientHeader  `codec:"clientHeader" json:"clientHeader"`
	HeaderCiphertext SealedData           `codec:"headerCiphertext" json:"headerCiphertext"`
	BodyCiphertext   EncryptedData        `codec:"bodyCiphertext" json:"bodyCiphertext"`
	VerifyKey        []byte               `codec:"verifyKey" json:"verifyKey"`
	KeyGeneration    int                  `codec:"keyGeneration" json:"keyGeneration"`
}

func (o MessageBoxed) DeepCopy() MessageBoxed {
	return MessageBoxed{
		Version: o.Version.DeepCopy(),
		ServerHeader: (func(x *MessageServerHeader) *MessageServerHeader {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.ServerHeader),
		ClientHeader:     o.ClientHeader.DeepCopy(),
		HeaderCiphertext: o.HeaderCiphertext.DeepCopy(),
		BodyCiphertext:   o.BodyCiphertext.DeepCopy(),
		VerifyKey: (func(x []byte) []byte {
			if x == nil {
				return nil
			}
			return append([]byte{}, x...)
		})(o.VerifyKey),
		KeyGeneration: o.KeyGeneration,
	}
}

type MessageBoxedVersion int

const (
	MessageBoxedVersion_VNONE MessageBoxedVersion = 0
	MessageBoxedVersion_V1    MessageBoxedVersion = 1
	MessageBoxedVersion_V2    MessageBoxedVersion = 2
	MessageBoxedVersion_V3    MessageBoxedVersion = 3
	MessageBoxedVersion_V4    MessageBoxedVersion = 4
)

func (o MessageBoxedVersion) DeepCopy() MessageBoxedVersion { return o }

var MessageBoxedVersionMap = map[string]MessageBoxedVersion{
	"VNONE": 0,
	"V1":    1,
	"V2":    2,
	"V3":    3,
	"V4":    4,
}

var MessageBoxedVersionRevMap = map[MessageBoxedVersion]string{
	0: "VNONE",
	1: "V1",
	2: "V2",
	3: "V3",
	4: "V4",
}

func (e MessageBoxedVersion) String() string {
	if v, ok := MessageBoxedVersionRevMap[e]; ok {
		return v
	}
	return ""
}

type ThreadViewBoxed struct {
	Messages   []MessageBoxed `codec:"messages" json:"messages"`
	Pagination *Pagination    `codec:"pagination,omitempty" json:"pagination,omitempty"`
}

func (o ThreadViewBoxed) DeepCopy() ThreadViewBoxed {
	return ThreadViewBoxed{
		Messages: (func(x []MessageBoxed) []MessageBoxed {
			if x == nil {
				return nil
			}
			ret := make([]MessageBoxed, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Messages),
		Pagination: (func(x *Pagination) *Pagination {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Pagination),
	}
}

type GetInboxRemoteRes struct {
	Inbox     InboxView  `codec:"inbox" json:"inbox"`
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetInboxRemoteRes) DeepCopy() GetInboxRemoteRes {
	return GetInboxRemoteRes{
		Inbox: o.Inbox.DeepCopy(),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type GetInboxByTLFIDRemoteRes struct {
	Convs     []Conversation `codec:"convs" json:"convs"`
	RateLimit *RateLimit     `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetInboxByTLFIDRemoteRes) DeepCopy() GetInboxByTLFIDRemoteRes {
	return GetInboxByTLFIDRemoteRes{
		Convs: (func(x []Conversation) []Conversation {
			if x == nil {
				return nil
			}
			ret := make([]Conversation, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Convs),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type GetThreadRemoteRes struct {
	Thread      ThreadViewBoxed         `codec:"thread" json:"thread"`
	MembersType ConversationMembersType `codec:"membersType" json:"membersType"`
	Visibility  keybase1.TLFVisibility  `codec:"visibility" json:"visibility"`
	RateLimit   *RateLimit              `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetThreadRemoteRes) DeepCopy() GetThreadRemoteRes {
	return GetThreadRemoteRes{
		Thread:      o.Thread.DeepCopy(),
		MembersType: o.MembersType.DeepCopy(),
		Visibility:  o.Visibility.DeepCopy(),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type GetConversationMetadataRemoteRes struct {
	Conv      Conversation `codec:"conv" json:"conv"`
	RateLimit *RateLimit   `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetConversationMetadataRemoteRes) DeepCopy() GetConversationMetadataRemoteRes {
	return GetConversationMetadataRemoteRes{
		Conv: o.Conv.DeepCopy(),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type PostRemoteRes struct {
	MsgHeader MessageServerHeader `codec:"msgHeader" json:"msgHeader"`
	RateLimit *RateLimit          `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o PostRemoteRes) DeepCopy() PostRemoteRes {
	return PostRemoteRes{
		MsgHeader: o.MsgHeader.DeepCopy(),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type NewConversationRemoteRes struct {
	ConvID             ConversationID `codec:"convID" json:"convID"`
	CreatedComplexTeam bool           `codec:"createdComplexTeam" json:"createdComplexTeam"`
	RateLimit          *RateLimit     `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o NewConversationRemoteRes) DeepCopy() NewConversationRemoteRes {
	return NewConversationRemoteRes{
		ConvID:             o.ConvID.DeepCopy(),
		CreatedComplexTeam: o.CreatedComplexTeam,
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type GetMessagesRemoteRes struct {
	Msgs      []MessageBoxed `codec:"msgs" json:"msgs"`
	RateLimit *RateLimit     `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetMessagesRemoteRes) DeepCopy() GetMessagesRemoteRes {
	return GetMessagesRemoteRes{
		Msgs: (func(x []MessageBoxed) []MessageBoxed {
			if x == nil {
				return nil
			}
			ret := make([]MessageBoxed, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Msgs),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type MarkAsReadRes struct {
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o MarkAsReadRes) DeepCopy() MarkAsReadRes {
	return MarkAsReadRes{
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type SetConversationStatusRes struct {
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o SetConversationStatusRes) DeepCopy() SetConversationStatusRes {
	return SetConversationStatusRes{
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type GetPublicConversationsRes struct {
	Conversations []Conversation `codec:"conversations" json:"conversations"`
	RateLimit     *RateLimit     `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetPublicConversationsRes) DeepCopy() GetPublicConversationsRes {
	return GetPublicConversationsRes{
		Conversations: (func(x []Conversation) []Conversation {
			if x == nil {
				return nil
			}
			ret := make([]Conversation, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Conversations),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type ChannelMention int

const (
	ChannelMention_NONE ChannelMention = 0
	ChannelMention_ALL  ChannelMention = 1
	ChannelMention_HERE ChannelMention = 2
)

func (o ChannelMention) DeepCopy() ChannelMention { return o }

var ChannelMentionMap = map[string]ChannelMention{
	"NONE": 0,
	"ALL":  1,
	"HERE": 2,
}

var ChannelMentionRevMap = map[ChannelMention]string{
	0: "NONE",
	1: "ALL",
	2: "HERE",
}

func (e ChannelMention) String() string {
	if v, ok := ChannelMentionRevMap[e]; ok {
		return v
	}
	return ""
}

type UnreadUpdateFull struct {
	Ignore          bool             `codec:"ignore" json:"ignore"`
	InboxVers       InboxVers        `codec:"inboxVers" json:"inboxVers"`
	InboxSyncStatus SyncInboxResType `codec:"inboxSyncStatus" json:"inboxSyncStatus"`
	Updates         []UnreadUpdate   `codec:"updates" json:"updates"`
}

func (o UnreadUpdateFull) DeepCopy() UnreadUpdateFull {
	return UnreadUpdateFull{
		Ignore:          o.Ignore,
		InboxVers:       o.InboxVers.DeepCopy(),
		InboxSyncStatus: o.InboxSyncStatus.DeepCopy(),
		Updates: (func(x []UnreadUpdate) []UnreadUpdate {
			if x == nil {
				return nil
			}
			ret := make([]UnreadUpdate, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Updates),
	}
}

type S3Params struct {
	Bucket               string `codec:"bucket" json:"bucket"`
	ObjectKey            string `codec:"objectKey" json:"objectKey"`
	AccessKey            string `codec:"accessKey" json:"accessKey"`
	Acl                  string `codec:"acl" json:"acl"`
	RegionName           string `codec:"regionName" json:"regionName"`
	RegionEndpoint       string `codec:"regionEndpoint" json:"regionEndpoint"`
	RegionBucketEndpoint string `codec:"regionBucketEndpoint" json:"regionBucketEndpoint"`
}

func (o S3Params) DeepCopy() S3Params {
	return S3Params{
		Bucket:               o.Bucket,
		ObjectKey:            o.ObjectKey,
		AccessKey:            o.AccessKey,
		Acl:                  o.Acl,
		RegionName:           o.RegionName,
		RegionEndpoint:       o.RegionEndpoint,
		RegionBucketEndpoint: o.RegionBucketEndpoint,
	}
}

type SyncIncrementalRes struct {
	Vers  InboxVers      `codec:"vers" json:"vers"`
	Convs []Conversation `codec:"convs" json:"convs"`
}

func (o SyncIncrementalRes) DeepCopy() SyncIncrementalRes {
	return SyncIncrementalRes{
		Vers: o.Vers.DeepCopy(),
		Convs: (func(x []Conversation) []Conversation {
			if x == nil {
				return nil
			}
			ret := make([]Conversation, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Convs),
	}
}

type ServerCacheVers struct {
	InboxVers  int `codec:"inboxVers" json:"inboxVers"`
	BodiesVers int `codec:"bodiesVers" json:"bodiesVers"`
}

func (o ServerCacheVers) DeepCopy() ServerCacheVers {
	return ServerCacheVers{
		InboxVers:  o.InboxVers,
		BodiesVers: o.BodiesVers,
	}
}

type SyncInboxRes struct {
	Typ__         SyncInboxResType    `codec:"typ" json:"typ"`
	Incremental__ *SyncIncrementalRes `codec:"incremental,omitempty" json:"incremental,omitempty"`
}

func (o *SyncInboxRes) Typ() (ret SyncInboxResType, err error) {
	switch o.Typ__ {
	case SyncInboxResType_INCREMENTAL:
		if o.Incremental__ == nil {
			err = errors.New("unexpected nil value for Incremental__")
			return ret, err
		}
	}
	return o.Typ__, nil
}

func (o SyncInboxRes) Incremental() (res SyncIncrementalRes) {
	if o.Typ__ != SyncInboxResType_INCREMENTAL {
		panic("wrong case accessed")
	}
	if o.Incremental__ == nil {
		return
	}
	return *o.Incremental__
}

func NewSyncInboxResWithCurrent() SyncInboxRes {
	return SyncInboxRes{
		Typ__: SyncInboxResType_CURRENT,
	}
}

func NewSyncInboxResWithIncremental(v SyncIncrementalRes) SyncInboxRes {
	return SyncInboxRes{
		Typ__:         SyncInboxResType_INCREMENTAL,
		Incremental__: &v,
	}
}

func NewSyncInboxResWithClear() SyncInboxRes {
	return SyncInboxRes{
		Typ__: SyncInboxResType_CLEAR,
	}
}

func (o SyncInboxRes) DeepCopy() SyncInboxRes {
	return SyncInboxRes{
		Typ__: o.Typ__.DeepCopy(),
		Incremental__: (func(x *SyncIncrementalRes) *SyncIncrementalRes {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Incremental__),
	}
}

type SyncChatRes struct {
	CacheVers ServerCacheVers `codec:"cacheVers" json:"cacheVers"`
	InboxRes  SyncInboxRes    `codec:"inboxRes" json:"inboxRes"`
}

func (o SyncChatRes) DeepCopy() SyncChatRes {
	return SyncChatRes{
		CacheVers: o.CacheVers.DeepCopy(),
		InboxRes:  o.InboxRes.DeepCopy(),
	}
}

type SyncAllProtVers int

const (
	SyncAllProtVers_V0 SyncAllProtVers = 0
	SyncAllProtVers_V1 SyncAllProtVers = 1
)

func (o SyncAllProtVers) DeepCopy() SyncAllProtVers { return o }

var SyncAllProtVersMap = map[string]SyncAllProtVers{
	"V0": 0,
	"V1": 1,
}

var SyncAllProtVersRevMap = map[SyncAllProtVers]string{
	0: "V0",
	1: "V1",
}

func (e SyncAllProtVers) String() string {
	if v, ok := SyncAllProtVersRevMap[e]; ok {
		return v
	}
	return ""
}

type SyncAllNotificationType int

const (
	SyncAllNotificationType_STATE       SyncAllNotificationType = 0
	SyncAllNotificationType_INCREMENTAL SyncAllNotificationType = 1
)

func (o SyncAllNotificationType) DeepCopy() SyncAllNotificationType { return o }

var SyncAllNotificationTypeMap = map[string]SyncAllNotificationType{
	"STATE":       0,
	"INCREMENTAL": 1,
}

var SyncAllNotificationTypeRevMap = map[SyncAllNotificationType]string{
	0: "STATE",
	1: "INCREMENTAL",
}

func (e SyncAllNotificationType) String() string {
	if v, ok := SyncAllNotificationTypeRevMap[e]; ok {
		return v
	}
	return ""
}

type SyncAllNotificationRes struct {
	Typ__         SyncAllNotificationType `codec:"typ" json:"typ"`
	State__       *gregor1.State          `codec:"state,omitempty" json:"state,omitempty"`
	Incremental__ *gregor1.SyncResult     `codec:"incremental,omitempty" json:"incremental,omitempty"`
}

func (o *SyncAllNotificationRes) Typ() (ret SyncAllNotificationType, err error) {
	switch o.Typ__ {
	case SyncAllNotificationType_STATE:
		if o.State__ == nil {
			err = errors.New("unexpected nil value for State__")
			return ret, err
		}
	case SyncAllNotificationType_INCREMENTAL:
		if o.Incremental__ == nil {
			err = errors.New("unexpected nil value for Incremental__")
			return ret, err
		}
	}
	return o.Typ__, nil
}

func (o SyncAllNotificationRes) State() (res gregor1.State) {
	if o.Typ__ != SyncAllNotificationType_STATE {
		panic("wrong case accessed")
	}
	if o.State__ == nil {
		return
	}
	return *o.State__
}

func (o SyncAllNotificationRes) Incremental() (res gregor1.SyncResult) {
	if o.Typ__ != SyncAllNotificationType_INCREMENTAL {
		panic("wrong case accessed")
	}
	if o.Incremental__ == nil {
		return
	}
	return *o.Incremental__
}

func NewSyncAllNotificationResWithState(v gregor1.State) SyncAllNotificationRes {
	return SyncAllNotificationRes{
		Typ__:   SyncAllNotificationType_STATE,
		State__: &v,
	}
}

func NewSyncAllNotificationResWithIncremental(v gregor1.SyncResult) SyncAllNotificationRes {
	return SyncAllNotificationRes{
		Typ__:         SyncAllNotificationType_INCREMENTAL,
		Incremental__: &v,
	}
}

func (o SyncAllNotificationRes) DeepCopy() SyncAllNotificationRes {
	return SyncAllNotificationRes{
		Typ__: o.Typ__.DeepCopy(),
		State__: (func(x *gregor1.State) *gregor1.State {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.State__),
		Incremental__: (func(x *gregor1.SyncResult) *gregor1.SyncResult {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.Incremental__),
	}
}

type SyncAllResult struct {
	Auth         gregor1.AuthResult     `codec:"auth" json:"auth"`
	Chat         SyncChatRes            `codec:"chat" json:"chat"`
	Notification SyncAllNotificationRes `codec:"notification" json:"notification"`
	Badge        UnreadUpdateFull       `codec:"badge" json:"badge"`
}

func (o SyncAllResult) DeepCopy() SyncAllResult {
	return SyncAllResult{
		Auth:         o.Auth.DeepCopy(),
		Chat:         o.Chat.DeepCopy(),
		Notification: o.Notification.DeepCopy(),
		Badge:        o.Badge.DeepCopy(),
	}
}

type JoinLeaveConversationRemoteRes struct {
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o JoinLeaveConversationRemoteRes) DeepCopy() JoinLeaveConversationRemoteRes {
	return JoinLeaveConversationRemoteRes{
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type DeleteConversationRemoteRes struct {
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o DeleteConversationRemoteRes) DeepCopy() DeleteConversationRemoteRes {
	return DeleteConversationRemoteRes{
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type GetMessageBeforeRes struct {
	MsgID     MessageID  `codec:"msgID" json:"msgID"`
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetMessageBeforeRes) DeepCopy() GetMessageBeforeRes {
	return GetMessageBeforeRes{
		MsgID: o.MsgID.DeepCopy(),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type GetTLFConversationsRes struct {
	Conversations []Conversation `codec:"conversations" json:"conversations"`
	RateLimit     *RateLimit     `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o GetTLFConversationsRes) DeepCopy() GetTLFConversationsRes {
	return GetTLFConversationsRes{
		Conversations: (func(x []Conversation) []Conversation {
			if x == nil {
				return nil
			}
			ret := make([]Conversation, len(x))
			for i, v := range x {
				vCopy := v.DeepCopy()
				ret[i] = vCopy
			}
			return ret
		})(o.Conversations),
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type SetAppNotificationSettingsRes struct {
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o SetAppNotificationSettingsRes) DeepCopy() SetAppNotificationSettingsRes {
	return SetAppNotificationSettingsRes{
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type SetRetentionRes struct {
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o SetRetentionRes) DeepCopy() SetRetentionRes {
	return SetRetentionRes{
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type SetConvMinWriterRoleRes struct {
	RateLimit *RateLimit `codec:"rateLimit,omitempty" json:"rateLimit,omitempty"`
}

func (o SetConvMinWriterRoleRes) DeepCopy() SetConvMinWriterRoleRes {
	return SetConvMinWriterRoleRes{
		RateLimit: (func(x *RateLimit) *RateLimit {
			if x == nil {
				return nil
			}
			tmp := (*x).DeepCopy()
			return &tmp
		})(o.RateLimit),
	}
}

type SweepRes struct {
	FoundTask       bool    `codec:"foundTask" json:"foundTask"`
	DeletedMessages bool    `codec:"deletedMessages" json:"deletedMessages"`
	Expunge         Expunge `codec:"expunge" json:"expunge"`
}

func (o SweepRes) DeepCopy() SweepRes {
	return SweepRes{
		FoundTask:       o.FoundTask,
		DeletedMessages: o.DeletedMessages,
		Expunge:         o.Expunge.DeepCopy(),
	}
}

type GetInboxRemoteArg struct {
	Vers       InboxVers      `codec:"vers" json:"vers"`
	Query      *GetInboxQuery `codec:"query,omitempty" json:"query,omitempty"`
	Pagination *Pagination    `codec:"pagination,omitempty" json:"pagination,omitempty"`
}

type GetThreadRemoteArg struct {
	ConversationID ConversationID  `codec:"conversationID" json:"conversationID"`
	Reason         GetThreadReason `codec:"reason" json:"reason"`
	Query          *GetThreadQuery `codec:"query,omitempty" json:"query,omitempty"`
	Pagination     *Pagination     `codec:"pagination,omitempty" json:"pagination,omitempty"`
}

type GetPublicConversationsArg struct {
	TlfID            TLFID     `codec:"tlfID" json:"tlfID"`
	TopicType        TopicType `codec:"topicType" json:"topicType"`
	SummarizeMaxMsgs bool      `codec:"summarizeMaxMsgs" json:"summarizeMaxMsgs"`
}

type PostRemoteArg struct {
	ConversationID ConversationID  `codec:"conversationID" json:"conversationID"`
	MessageBoxed   MessageBoxed    `codec:"messageBoxed" json:"messageBoxed"`
	AtMentions     []gregor1.UID   `codec:"atMentions" json:"atMentions"`
	ChannelMention ChannelMention  `codec:"channelMention" json:"channelMention"`
	TopicNameState *TopicNameState `codec:"topicNameState,omitempty" json:"topicNameState,omitempty"`
}

type NewConversationRemoteArg struct {
	IdTriple ConversationIDTriple `codec:"idTriple" json:"idTriple"`
}

type NewConversationRemote2Arg struct {
	IdTriple       ConversationIDTriple    `codec:"idTriple" json:"idTriple"`
	TLFMessage     MessageBoxed            `codec:"TLFMessage" json:"TLFMessage"`
	MembersType    ConversationMembersType `codec:"membersType" json:"membersType"`
	TopicNameState *TopicNameState         `codec:"topicNameState,omitempty" json:"topicNameState,omitempty"`
}

type GetMessagesRemoteArg struct {
	ConversationID ConversationID   `codec:"conversationID" json:"conversationID"`
	ThreadReason   *GetThreadReason `codec:"threadReason,omitempty" json:"threadReason,omitempty"`
	MessageIDs     []MessageID      `codec:"messageIDs" json:"messageIDs"`
}

type MarkAsReadArg struct {
	ConversationID ConversationID `codec:"conversationID" json:"conversationID"`
	MsgID          MessageID      `codec:"msgID" json:"msgID"`
}

type SetConversationStatusArg struct {
	ConversationID ConversationID     `codec:"conversationID" json:"conversationID"`
	Status         ConversationStatus `codec:"status" json:"status"`
}

type GetUnreadUpdateFullArg struct {
	InboxVers InboxVers `codec:"inboxVers" json:"inboxVers"`
}

type GetS3ParamsArg struct {
	ConversationID ConversationID `codec:"conversationID" json:"conversationID"`
}

type S3SignArg struct {
	Version int    `codec:"version" json:"version"`
	Payload []byte `codec:"payload" json:"payload"`
}

type GetInboxVersionArg struct {
	Uid gregor1.UID `codec:"uid" json:"uid"`
}

type SyncInboxArg struct {
	Vers InboxVers `codec:"vers" json:"vers"`
}

type SyncChatArg struct {
	Vers InboxVers `codec:"vers" json:"vers"`
}

type SyncAllArg struct {
	Uid       gregor1.UID          `codec:"uid" json:"uid"`
	DeviceID  gregor1.DeviceID     `codec:"deviceID" json:"deviceID"`
	Session   gregor1.SessionToken `codec:"session" json:"session"`
	InboxVers InboxVers            `codec:"inboxVers" json:"inboxVers"`
	Ctime     gregor1.Time         `codec:"ctime" json:"ctime"`
	Fresh     bool                 `codec:"fresh" json:"fresh"`
	ProtVers  SyncAllProtVers      `codec:"protVers" json:"protVers"`
	HostName  string               `codec:"hostName" json:"hostName"`
}

type TlfFinalizeArg struct {
	TlfID          TLFID         `codec:"tlfID" json:"tlfID"`
	ResetUser      string        `codec:"resetUser" json:"resetUser"`
	ResetDate      string        `codec:"resetDate" json:"resetDate"`
	ResetTimestamp gregor1.Time  `codec:"resetTimestamp" json:"resetTimestamp"`
	ResetFull      string        `codec:"resetFull" json:"resetFull"`
	ResetUID       *keybase1.UID `codec:"resetUID,omitempty" json:"resetUID,omitempty"`
}

type TlfResolveArg struct {
	TlfID           TLFID         `codec:"tlfID" json:"tlfID"`
	ResolvedWriters []gregor1.UID `codec:"resolvedWriters" json:"resolvedWriters"`
	ResolvedReaders []gregor1.UID `codec:"resolvedReaders" json:"resolvedReaders"`
}

type UpdateTypingRemoteArg struct {
	Uid      gregor1.UID      `codec:"uid" json:"uid"`
	DeviceID gregor1.DeviceID `codec:"deviceID" json:"deviceID"`
	ConvID   ConversationID   `codec:"convID" json:"convID"`
	Typing   bool             `codec:"typing" json:"typing"`
}

type JoinConversationArg struct {
	ConvID ConversationID `codec:"convID" json:"convID"`
}

type LeaveConversationArg struct {
	ConvID ConversationID `codec:"convID" json:"convID"`
}

type PreviewConversationArg struct {
	ConvID ConversationID `codec:"convID" json:"convID"`
}

type DeleteConversationArg struct {
	ConvID ConversationID `codec:"convID" json:"convID"`
}

type GetMessageBeforeArg struct {
	ConvID ConversationID      `codec:"convID" json:"convID"`
	Age    gregor1.DurationSec `codec:"age" json:"age"`
}

type GetTLFConversationsArg struct {
	TlfID            TLFID     `codec:"tlfID" json:"tlfID"`
	TopicType        TopicType `codec:"topicType" json:"topicType"`
	SummarizeMaxMsgs bool      `codec:"summarizeMaxMsgs" json:"summarizeMaxMsgs"`
	UseCache         bool      `codec:"useCache" json:"useCache"`
}

type SetAppNotificationSettingsArg struct {
	ConvID   ConversationID               `codec:"convID" json:"convID"`
	Settings ConversationNotificationInfo `codec:"settings" json:"settings"`
}

type SetGlobalAppNotificationSettingsArg struct {
	Settings GlobalAppNotificationSettings `codec:"settings" json:"settings"`
}

type GetGlobalAppNotificationSettingsArg struct {
}

type RemoteNotificationSuccessfulArg struct {
	AuthToken        gregor1.SessionToken `codec:"authToken" json:"authToken"`
	CompanionPushIDs []string             `codec:"companionPushIDs" json:"companionPushIDs"`
}

type SetConvRetentionArg struct {
	ConvID       ConversationID  `codec:"convID" json:"convID"`
	Policy       RetentionPolicy `codec:"policy" json:"policy"`
	SweepChannel uint64          `codec:"sweepChannel" json:"sweepChannel"`
}

type SetTeamRetentionArg struct {
	TeamID       keybase1.TeamID `codec:"teamID" json:"teamID"`
	Policy       RetentionPolicy `codec:"policy" json:"policy"`
	SweepChannel uint64          `codec:"sweepChannel" json:"sweepChannel"`
}

type SetConvMinWriterRoleArg struct {
	ConvID ConversationID    `codec:"convID" json:"convID"`
	Role   keybase1.TeamRole `codec:"role" json:"role"`
}

type RetentionSweepConvArg struct {
	ConvID ConversationID `codec:"convID" json:"convID"`
}

type UpgradeKBFSToImpteamArg struct {
	TlfID TLFID `codec:"tlfID" json:"tlfID"`
}

type RegisterSharePostArg struct {
	ConvID   ConversationID   `codec:"convID" json:"convID"`
	DeviceID gregor1.DeviceID `codec:"deviceID" json:"deviceID"`
	OutboxID OutboxID         `codec:"outboxID" json:"outboxID"`
}

type FailSharePostArg struct {
	ConvID   ConversationID   `codec:"convID" json:"convID"`
	DeviceID gregor1.DeviceID `codec:"deviceID" json:"deviceID"`
	OutboxID OutboxID         `codec:"outboxID" json:"outboxID"`
}

type RemoteInterface interface {
	GetInboxRemote(context.Context, GetInboxRemoteArg) (GetInboxRemoteRes, error)
	GetThreadRemote(context.Context, GetThreadRemoteArg) (GetThreadRemoteRes, error)
	GetPublicConversations(context.Context, GetPublicConversationsArg) (GetPublicConversationsRes, error)
	PostRemote(context.Context, PostRemoteArg) (PostRemoteRes, error)
	NewConversationRemote(context.Context, ConversationIDTriple) (NewConversationRemoteRes, error)
	NewConversationRemote2(context.Context, NewConversationRemote2Arg) (NewConversationRemoteRes, error)
	GetMessagesRemote(context.Context, GetMessagesRemoteArg) (GetMessagesRemoteRes, error)
	MarkAsRead(context.Context, MarkAsReadArg) (MarkAsReadRes, error)
	SetConversationStatus(context.Context, SetConversationStatusArg) (SetConversationStatusRes, error)
	GetUnreadUpdateFull(context.Context, InboxVers) (UnreadUpdateFull, error)
	GetS3Params(context.Context, ConversationID) (S3Params, error)
	S3Sign(context.Context, S3SignArg) ([]byte, error)
	GetInboxVersion(context.Context, gregor1.UID) (InboxVers, error)
	SyncInbox(context.Context, InboxVers) (SyncInboxRes, error)
	SyncChat(context.Context, InboxVers) (SyncChatRes, error)
	SyncAll(context.Context, SyncAllArg) (SyncAllResult, error)
	TlfFinalize(context.Context, TlfFinalizeArg) error
	TlfResolve(context.Context, TlfResolveArg) error
	UpdateTypingRemote(context.Context, UpdateTypingRemoteArg) error
	JoinConversation(context.Context, ConversationID) (JoinLeaveConversationRemoteRes, error)
	LeaveConversation(context.Context, ConversationID) (JoinLeaveConversationRemoteRes, error)
	PreviewConversation(context.Context, ConversationID) (JoinLeaveConversationRemoteRes, error)
	DeleteConversation(context.Context, ConversationID) (DeleteConversationRemoteRes, error)
	GetMessageBefore(context.Context, GetMessageBeforeArg) (GetMessageBeforeRes, error)
	GetTLFConversations(context.Context, GetTLFConversationsArg) (GetTLFConversationsRes, error)
	SetAppNotificationSettings(context.Context, SetAppNotificationSettingsArg) (SetAppNotificationSettingsRes, error)
	SetGlobalAppNotificationSettings(context.Context, GlobalAppNotificationSettings) error
	GetGlobalAppNotificationSettings(context.Context) (GlobalAppNotificationSettings, error)
	RemoteNotificationSuccessful(context.Context, RemoteNotificationSuccessfulArg) error
	SetConvRetention(context.Context, SetConvRetentionArg) (SetRetentionRes, error)
	SetTeamRetention(context.Context, SetTeamRetentionArg) (SetRetentionRes, error)
	SetConvMinWriterRole(context.Context, SetConvMinWriterRoleArg) (SetConvMinWriterRoleRes, error)
	RetentionSweepConv(context.Context, ConversationID) (SweepRes, error)
	UpgradeKBFSToImpteam(context.Context, TLFID) error
	RegisterSharePost(context.Context, RegisterSharePostArg) error
	FailSharePost(context.Context, FailSharePostArg) error
}

func RemoteProtocol(i RemoteInterface) rpc.Protocol {
	return rpc.Protocol{
		Name: "chat.1.remote",
		Methods: map[string]rpc.ServeHandlerDescription{
			"getInboxRemote": {
				MakeArg: func() interface{} {
					var ret [1]GetInboxRemoteArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetInboxRemoteArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetInboxRemoteArg)(nil), args)
						return
					}
					ret, err = i.GetInboxRemote(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getThreadRemote": {
				MakeArg: func() interface{} {
					var ret [1]GetThreadRemoteArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetThreadRemoteArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetThreadRemoteArg)(nil), args)
						return
					}
					ret, err = i.GetThreadRemote(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getPublicConversations": {
				MakeArg: func() interface{} {
					var ret [1]GetPublicConversationsArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetPublicConversationsArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetPublicConversationsArg)(nil), args)
						return
					}
					ret, err = i.GetPublicConversations(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"postRemote": {
				MakeArg: func() interface{} {
					var ret [1]PostRemoteArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]PostRemoteArg)
					if !ok {
						err = rpc.NewTypeError((*[1]PostRemoteArg)(nil), args)
						return
					}
					ret, err = i.PostRemote(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"newConversationRemote": {
				MakeArg: func() interface{} {
					var ret [1]NewConversationRemoteArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]NewConversationRemoteArg)
					if !ok {
						err = rpc.NewTypeError((*[1]NewConversationRemoteArg)(nil), args)
						return
					}
					ret, err = i.NewConversationRemote(ctx, typedArgs[0].IdTriple)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"newConversationRemote2": {
				MakeArg: func() interface{} {
					var ret [1]NewConversationRemote2Arg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]NewConversationRemote2Arg)
					if !ok {
						err = rpc.NewTypeError((*[1]NewConversationRemote2Arg)(nil), args)
						return
					}
					ret, err = i.NewConversationRemote2(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getMessagesRemote": {
				MakeArg: func() interface{} {
					var ret [1]GetMessagesRemoteArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetMessagesRemoteArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetMessagesRemoteArg)(nil), args)
						return
					}
					ret, err = i.GetMessagesRemote(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"markAsRead": {
				MakeArg: func() interface{} {
					var ret [1]MarkAsReadArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]MarkAsReadArg)
					if !ok {
						err = rpc.NewTypeError((*[1]MarkAsReadArg)(nil), args)
						return
					}
					ret, err = i.MarkAsRead(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"SetConversationStatus": {
				MakeArg: func() interface{} {
					var ret [1]SetConversationStatusArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetConversationStatusArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetConversationStatusArg)(nil), args)
						return
					}
					ret, err = i.SetConversationStatus(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"GetUnreadUpdateFull": {
				MakeArg: func() interface{} {
					var ret [1]GetUnreadUpdateFullArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetUnreadUpdateFullArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetUnreadUpdateFullArg)(nil), args)
						return
					}
					ret, err = i.GetUnreadUpdateFull(ctx, typedArgs[0].InboxVers)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getS3Params": {
				MakeArg: func() interface{} {
					var ret [1]GetS3ParamsArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetS3ParamsArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetS3ParamsArg)(nil), args)
						return
					}
					ret, err = i.GetS3Params(ctx, typedArgs[0].ConversationID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"s3Sign": {
				MakeArg: func() interface{} {
					var ret [1]S3SignArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]S3SignArg)
					if !ok {
						err = rpc.NewTypeError((*[1]S3SignArg)(nil), args)
						return
					}
					ret, err = i.S3Sign(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getInboxVersion": {
				MakeArg: func() interface{} {
					var ret [1]GetInboxVersionArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetInboxVersionArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetInboxVersionArg)(nil), args)
						return
					}
					ret, err = i.GetInboxVersion(ctx, typedArgs[0].Uid)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"syncInbox": {
				MakeArg: func() interface{} {
					var ret [1]SyncInboxArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SyncInboxArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SyncInboxArg)(nil), args)
						return
					}
					ret, err = i.SyncInbox(ctx, typedArgs[0].Vers)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"syncChat": {
				MakeArg: func() interface{} {
					var ret [1]SyncChatArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SyncChatArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SyncChatArg)(nil), args)
						return
					}
					ret, err = i.SyncChat(ctx, typedArgs[0].Vers)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"syncAll": {
				MakeArg: func() interface{} {
					var ret [1]SyncAllArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SyncAllArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SyncAllArg)(nil), args)
						return
					}
					ret, err = i.SyncAll(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"tlfFinalize": {
				MakeArg: func() interface{} {
					var ret [1]TlfFinalizeArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]TlfFinalizeArg)
					if !ok {
						err = rpc.NewTypeError((*[1]TlfFinalizeArg)(nil), args)
						return
					}
					err = i.TlfFinalize(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"tlfResolve": {
				MakeArg: func() interface{} {
					var ret [1]TlfResolveArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]TlfResolveArg)
					if !ok {
						err = rpc.NewTypeError((*[1]TlfResolveArg)(nil), args)
						return
					}
					err = i.TlfResolve(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"updateTypingRemote": {
				MakeArg: func() interface{} {
					var ret [1]UpdateTypingRemoteArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]UpdateTypingRemoteArg)
					if !ok {
						err = rpc.NewTypeError((*[1]UpdateTypingRemoteArg)(nil), args)
						return
					}
					err = i.UpdateTypingRemote(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"joinConversation": {
				MakeArg: func() interface{} {
					var ret [1]JoinConversationArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]JoinConversationArg)
					if !ok {
						err = rpc.NewTypeError((*[1]JoinConversationArg)(nil), args)
						return
					}
					ret, err = i.JoinConversation(ctx, typedArgs[0].ConvID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"leaveConversation": {
				MakeArg: func() interface{} {
					var ret [1]LeaveConversationArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]LeaveConversationArg)
					if !ok {
						err = rpc.NewTypeError((*[1]LeaveConversationArg)(nil), args)
						return
					}
					ret, err = i.LeaveConversation(ctx, typedArgs[0].ConvID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"previewConversation": {
				MakeArg: func() interface{} {
					var ret [1]PreviewConversationArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]PreviewConversationArg)
					if !ok {
						err = rpc.NewTypeError((*[1]PreviewConversationArg)(nil), args)
						return
					}
					ret, err = i.PreviewConversation(ctx, typedArgs[0].ConvID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"deleteConversation": {
				MakeArg: func() interface{} {
					var ret [1]DeleteConversationArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]DeleteConversationArg)
					if !ok {
						err = rpc.NewTypeError((*[1]DeleteConversationArg)(nil), args)
						return
					}
					ret, err = i.DeleteConversation(ctx, typedArgs[0].ConvID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getMessageBefore": {
				MakeArg: func() interface{} {
					var ret [1]GetMessageBeforeArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetMessageBeforeArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetMessageBeforeArg)(nil), args)
						return
					}
					ret, err = i.GetMessageBefore(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getTLFConversations": {
				MakeArg: func() interface{} {
					var ret [1]GetTLFConversationsArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]GetTLFConversationsArg)
					if !ok {
						err = rpc.NewTypeError((*[1]GetTLFConversationsArg)(nil), args)
						return
					}
					ret, err = i.GetTLFConversations(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setAppNotificationSettings": {
				MakeArg: func() interface{} {
					var ret [1]SetAppNotificationSettingsArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetAppNotificationSettingsArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetAppNotificationSettingsArg)(nil), args)
						return
					}
					ret, err = i.SetAppNotificationSettings(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setGlobalAppNotificationSettings": {
				MakeArg: func() interface{} {
					var ret [1]SetGlobalAppNotificationSettingsArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetGlobalAppNotificationSettingsArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetGlobalAppNotificationSettingsArg)(nil), args)
						return
					}
					err = i.SetGlobalAppNotificationSettings(ctx, typedArgs[0].Settings)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"getGlobalAppNotificationSettings": {
				MakeArg: func() interface{} {
					var ret [1]GetGlobalAppNotificationSettingsArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					ret, err = i.GetGlobalAppNotificationSettings(ctx)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"remoteNotificationSuccessful": {
				MakeArg: func() interface{} {
					var ret [1]RemoteNotificationSuccessfulArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]RemoteNotificationSuccessfulArg)
					if !ok {
						err = rpc.NewTypeError((*[1]RemoteNotificationSuccessfulArg)(nil), args)
						return
					}
					err = i.RemoteNotificationSuccessful(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setConvRetention": {
				MakeArg: func() interface{} {
					var ret [1]SetConvRetentionArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetConvRetentionArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetConvRetentionArg)(nil), args)
						return
					}
					ret, err = i.SetConvRetention(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setTeamRetention": {
				MakeArg: func() interface{} {
					var ret [1]SetTeamRetentionArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetTeamRetentionArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetTeamRetentionArg)(nil), args)
						return
					}
					ret, err = i.SetTeamRetention(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"setConvMinWriterRole": {
				MakeArg: func() interface{} {
					var ret [1]SetConvMinWriterRoleArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]SetConvMinWriterRoleArg)
					if !ok {
						err = rpc.NewTypeError((*[1]SetConvMinWriterRoleArg)(nil), args)
						return
					}
					ret, err = i.SetConvMinWriterRole(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"retentionSweepConv": {
				MakeArg: func() interface{} {
					var ret [1]RetentionSweepConvArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]RetentionSweepConvArg)
					if !ok {
						err = rpc.NewTypeError((*[1]RetentionSweepConvArg)(nil), args)
						return
					}
					ret, err = i.RetentionSweepConv(ctx, typedArgs[0].ConvID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"upgradeKBFSToImpteam": {
				MakeArg: func() interface{} {
					var ret [1]UpgradeKBFSToImpteamArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]UpgradeKBFSToImpteamArg)
					if !ok {
						err = rpc.NewTypeError((*[1]UpgradeKBFSToImpteamArg)(nil), args)
						return
					}
					err = i.UpgradeKBFSToImpteam(ctx, typedArgs[0].TlfID)
					return
				},
				MethodType: rpc.MethodCall,
			},
			"registerSharePost": {
				MakeArg: func() interface{} {
					var ret [1]RegisterSharePostArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]RegisterSharePostArg)
					if !ok {
						err = rpc.NewTypeError((*[1]RegisterSharePostArg)(nil), args)
						return
					}
					err = i.RegisterSharePost(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
			"failSharePost": {
				MakeArg: func() interface{} {
					var ret [1]FailSharePostArg
					return &ret
				},
				Handler: func(ctx context.Context, args interface{}) (ret interface{}, err error) {
					typedArgs, ok := args.(*[1]FailSharePostArg)
					if !ok {
						err = rpc.NewTypeError((*[1]FailSharePostArg)(nil), args)
						return
					}
					err = i.FailSharePost(ctx, typedArgs[0])
					return
				},
				MethodType: rpc.MethodCall,
			},
		},
	}
}

type RemoteClient struct {
	Cli rpc.GenericClient
}

func (c RemoteClient) GetInboxRemote(ctx context.Context, __arg GetInboxRemoteArg) (res GetInboxRemoteRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.getInboxRemote", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetThreadRemote(ctx context.Context, __arg GetThreadRemoteArg) (res GetThreadRemoteRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.getThreadRemote", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetPublicConversations(ctx context.Context, __arg GetPublicConversationsArg) (res GetPublicConversationsRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.getPublicConversations", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) PostRemote(ctx context.Context, __arg PostRemoteArg) (res PostRemoteRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.postRemote", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) NewConversationRemote(ctx context.Context, idTriple ConversationIDTriple) (res NewConversationRemoteRes, err error) {
	__arg := NewConversationRemoteArg{IdTriple: idTriple}
	err = c.Cli.Call(ctx, "chat.1.remote.newConversationRemote", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) NewConversationRemote2(ctx context.Context, __arg NewConversationRemote2Arg) (res NewConversationRemoteRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.newConversationRemote2", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetMessagesRemote(ctx context.Context, __arg GetMessagesRemoteArg) (res GetMessagesRemoteRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.getMessagesRemote", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) MarkAsRead(ctx context.Context, __arg MarkAsReadArg) (res MarkAsReadRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.markAsRead", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SetConversationStatus(ctx context.Context, __arg SetConversationStatusArg) (res SetConversationStatusRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.SetConversationStatus", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetUnreadUpdateFull(ctx context.Context, inboxVers InboxVers) (res UnreadUpdateFull, err error) {
	__arg := GetUnreadUpdateFullArg{InboxVers: inboxVers}
	err = c.Cli.Call(ctx, "chat.1.remote.GetUnreadUpdateFull", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetS3Params(ctx context.Context, conversationID ConversationID) (res S3Params, err error) {
	__arg := GetS3ParamsArg{ConversationID: conversationID}
	err = c.Cli.Call(ctx, "chat.1.remote.getS3Params", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) S3Sign(ctx context.Context, __arg S3SignArg) (res []byte, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.s3Sign", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetInboxVersion(ctx context.Context, uid gregor1.UID) (res InboxVers, err error) {
	__arg := GetInboxVersionArg{Uid: uid}
	err = c.Cli.Call(ctx, "chat.1.remote.getInboxVersion", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SyncInbox(ctx context.Context, vers InboxVers) (res SyncInboxRes, err error) {
	__arg := SyncInboxArg{Vers: vers}
	err = c.Cli.Call(ctx, "chat.1.remote.syncInbox", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SyncChat(ctx context.Context, vers InboxVers) (res SyncChatRes, err error) {
	__arg := SyncChatArg{Vers: vers}
	err = c.Cli.Call(ctx, "chat.1.remote.syncChat", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SyncAll(ctx context.Context, __arg SyncAllArg) (res SyncAllResult, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.syncAll", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) TlfFinalize(ctx context.Context, __arg TlfFinalizeArg) (err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.tlfFinalize", []interface{}{__arg}, nil)
	return
}

func (c RemoteClient) TlfResolve(ctx context.Context, __arg TlfResolveArg) (err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.tlfResolve", []interface{}{__arg}, nil)
	return
}

func (c RemoteClient) UpdateTypingRemote(ctx context.Context, __arg UpdateTypingRemoteArg) (err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.updateTypingRemote", []interface{}{__arg}, nil)
	return
}

func (c RemoteClient) JoinConversation(ctx context.Context, convID ConversationID) (res JoinLeaveConversationRemoteRes, err error) {
	__arg := JoinConversationArg{ConvID: convID}
	err = c.Cli.Call(ctx, "chat.1.remote.joinConversation", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) LeaveConversation(ctx context.Context, convID ConversationID) (res JoinLeaveConversationRemoteRes, err error) {
	__arg := LeaveConversationArg{ConvID: convID}
	err = c.Cli.Call(ctx, "chat.1.remote.leaveConversation", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) PreviewConversation(ctx context.Context, convID ConversationID) (res JoinLeaveConversationRemoteRes, err error) {
	__arg := PreviewConversationArg{ConvID: convID}
	err = c.Cli.Call(ctx, "chat.1.remote.previewConversation", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) DeleteConversation(ctx context.Context, convID ConversationID) (res DeleteConversationRemoteRes, err error) {
	__arg := DeleteConversationArg{ConvID: convID}
	err = c.Cli.Call(ctx, "chat.1.remote.deleteConversation", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetMessageBefore(ctx context.Context, __arg GetMessageBeforeArg) (res GetMessageBeforeRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.getMessageBefore", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) GetTLFConversations(ctx context.Context, __arg GetTLFConversationsArg) (res GetTLFConversationsRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.getTLFConversations", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SetAppNotificationSettings(ctx context.Context, __arg SetAppNotificationSettingsArg) (res SetAppNotificationSettingsRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.setAppNotificationSettings", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SetGlobalAppNotificationSettings(ctx context.Context, settings GlobalAppNotificationSettings) (err error) {
	__arg := SetGlobalAppNotificationSettingsArg{Settings: settings}
	err = c.Cli.Call(ctx, "chat.1.remote.setGlobalAppNotificationSettings", []interface{}{__arg}, nil)
	return
}

func (c RemoteClient) GetGlobalAppNotificationSettings(ctx context.Context) (res GlobalAppNotificationSettings, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.getGlobalAppNotificationSettings", []interface{}{GetGlobalAppNotificationSettingsArg{}}, &res)
	return
}

func (c RemoteClient) RemoteNotificationSuccessful(ctx context.Context, __arg RemoteNotificationSuccessfulArg) (err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.remoteNotificationSuccessful", []interface{}{__arg}, nil)
	return
}

func (c RemoteClient) SetConvRetention(ctx context.Context, __arg SetConvRetentionArg) (res SetRetentionRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.setConvRetention", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SetTeamRetention(ctx context.Context, __arg SetTeamRetentionArg) (res SetRetentionRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.setTeamRetention", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) SetConvMinWriterRole(ctx context.Context, __arg SetConvMinWriterRoleArg) (res SetConvMinWriterRoleRes, err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.setConvMinWriterRole", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) RetentionSweepConv(ctx context.Context, convID ConversationID) (res SweepRes, err error) {
	__arg := RetentionSweepConvArg{ConvID: convID}
	err = c.Cli.Call(ctx, "chat.1.remote.retentionSweepConv", []interface{}{__arg}, &res)
	return
}

func (c RemoteClient) UpgradeKBFSToImpteam(ctx context.Context, tlfID TLFID) (err error) {
	__arg := UpgradeKBFSToImpteamArg{TlfID: tlfID}
	err = c.Cli.Call(ctx, "chat.1.remote.upgradeKBFSToImpteam", []interface{}{__arg}, nil)
	return
}

func (c RemoteClient) RegisterSharePost(ctx context.Context, __arg RegisterSharePostArg) (err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.registerSharePost", []interface{}{__arg}, nil)
	return
}

func (c RemoteClient) FailSharePost(ctx context.Context, __arg FailSharePostArg) (err error) {
	err = c.Cli.Call(ctx, "chat.1.remote.failSharePost", []interface{}{__arg}, nil)
	return
}
