// Code generated by mocker. DO NOT EDIT.
// github.com/travisjeffery/mocker
// Source: io.go

package mock

import (
	io "io"
	os "os"
	sync "sync"
	time "time"

	github_com_confluentinc_cli_internal_pkg_io "github.com/confluentinc/cli/v3/pkg/io"
)

// FileSystem is a mock of FileSystem interface
type FileSystem struct {
	lockOpen sync.Mutex
	OpenFunc func(name string) (github_com_confluentinc_cli_internal_pkg_io.File, error)

	lockStat sync.Mutex
	StatFunc func(name string) (os.FileInfo, error)

	lockCreate sync.Mutex
	CreateFunc func(name string) (github_com_confluentinc_cli_internal_pkg_io.File, error)

	lockChtimes sync.Mutex
	ChtimesFunc func(name string, atime, mtime time.Time) error

	lockChmod sync.Mutex
	ChmodFunc func(name string, mode os.FileMode) error

	lockRemove sync.Mutex
	RemoveFunc func(name string) error

	lockRemoveAll sync.Mutex
	RemoveAllFunc func(path string) error

	lockReadDir sync.Mutex
	ReadDirFunc func(dirname string) ([]os.DirEntry, error)

	lockMkdirTemp sync.Mutex
	MkdirTempFunc func(dir, prefix string) (string, error)

	lockCopy sync.Mutex
	CopyFunc func(dst io.Writer, src io.Reader) (int64, error)

	lockMove sync.Mutex
	MoveFunc func(src, dst string) error

	lockNewBufferedReader sync.Mutex
	NewBufferedReaderFunc func(rd io.Reader) github_com_confluentinc_cli_internal_pkg_io.Reader

	lockIsTerminal sync.Mutex
	IsTerminalFunc func(fd uintptr) bool

	lockGlob sync.Mutex
	GlobFunc func(pattern string) ([]string, error)

	calls struct {
		Open []struct {
			Name string
		}
		Stat []struct {
			Name string
		}
		Create []struct {
			Name string
		}
		Chtimes []struct {
			Name  string
			Atime time.Time
			Mtime time.Time
		}
		Chmod []struct {
			Name string
			Mode os.FileMode
		}
		Remove []struct {
			Name string
		}
		RemoveAll []struct {
			Path string
		}
		ReadDir []struct {
			Dirname string
		}
		MkdirTemp []struct {
			Dir    string
			Prefix string
		}
		Copy []struct {
			Dst io.Writer
			Src io.Reader
		}
		Move []struct {
			Src string
			Dst string
		}
		NewBufferedReader []struct {
			Rd io.Reader
		}
		IsTerminal []struct {
			Fd uintptr
		}
		Glob []struct {
			Pattern string
		}
	}
}

// Open mocks base method by wrapping the associated func.
func (m *FileSystem) Open(name string) (github_com_confluentinc_cli_internal_pkg_io.File, error) {
	m.lockOpen.Lock()
	defer m.lockOpen.Unlock()

	if m.OpenFunc == nil {
		panic("mocker: FileSystem.OpenFunc is nil but FileSystem.Open was called.")
	}

	call := struct {
		Name string
	}{
		Name: name,
	}

	m.calls.Open = append(m.calls.Open, call)

	return m.OpenFunc(name)
}

// OpenCalled returns true if Open was called at least once.
func (m *FileSystem) OpenCalled() bool {
	m.lockOpen.Lock()
	defer m.lockOpen.Unlock()

	return len(m.calls.Open) > 0
}

// OpenCalls returns the calls made to Open.
func (m *FileSystem) OpenCalls() []struct {
	Name string
} {
	m.lockOpen.Lock()
	defer m.lockOpen.Unlock()

	return m.calls.Open
}

// Stat mocks base method by wrapping the associated func.
func (m *FileSystem) Stat(name string) (os.FileInfo, error) {
	m.lockStat.Lock()
	defer m.lockStat.Unlock()

	if m.StatFunc == nil {
		panic("mocker: FileSystem.StatFunc is nil but FileSystem.Stat was called.")
	}

	call := struct {
		Name string
	}{
		Name: name,
	}

	m.calls.Stat = append(m.calls.Stat, call)

	return m.StatFunc(name)
}

// StatCalled returns true if Stat was called at least once.
func (m *FileSystem) StatCalled() bool {
	m.lockStat.Lock()
	defer m.lockStat.Unlock()

	return len(m.calls.Stat) > 0
}

// StatCalls returns the calls made to Stat.
func (m *FileSystem) StatCalls() []struct {
	Name string
} {
	m.lockStat.Lock()
	defer m.lockStat.Unlock()

	return m.calls.Stat
}

// Create mocks base method by wrapping the associated func.
func (m *FileSystem) Create(name string) (github_com_confluentinc_cli_internal_pkg_io.File, error) {
	m.lockCreate.Lock()
	defer m.lockCreate.Unlock()

	if m.CreateFunc == nil {
		panic("mocker: FileSystem.CreateFunc is nil but FileSystem.Create was called.")
	}

	call := struct {
		Name string
	}{
		Name: name,
	}

	m.calls.Create = append(m.calls.Create, call)

	return m.CreateFunc(name)
}

// CreateCalled returns true if Create was called at least once.
func (m *FileSystem) CreateCalled() bool {
	m.lockCreate.Lock()
	defer m.lockCreate.Unlock()

	return len(m.calls.Create) > 0
}

// CreateCalls returns the calls made to Create.
func (m *FileSystem) CreateCalls() []struct {
	Name string
} {
	m.lockCreate.Lock()
	defer m.lockCreate.Unlock()

	return m.calls.Create
}

// Chtimes mocks base method by wrapping the associated func.
func (m *FileSystem) Chtimes(name string, atime, mtime time.Time) error {
	m.lockChtimes.Lock()
	defer m.lockChtimes.Unlock()

	if m.ChtimesFunc == nil {
		panic("mocker: FileSystem.ChtimesFunc is nil but FileSystem.Chtimes was called.")
	}

	call := struct {
		Name  string
		Atime time.Time
		Mtime time.Time
	}{
		Name:  name,
		Atime: atime,
		Mtime: mtime,
	}

	m.calls.Chtimes = append(m.calls.Chtimes, call)

	return m.ChtimesFunc(name, atime, mtime)
}

// ChtimesCalled returns true if Chtimes was called at least once.
func (m *FileSystem) ChtimesCalled() bool {
	m.lockChtimes.Lock()
	defer m.lockChtimes.Unlock()

	return len(m.calls.Chtimes) > 0
}

// ChtimesCalls returns the calls made to Chtimes.
func (m *FileSystem) ChtimesCalls() []struct {
	Name  string
	Atime time.Time
	Mtime time.Time
} {
	m.lockChtimes.Lock()
	defer m.lockChtimes.Unlock()

	return m.calls.Chtimes
}

// Chmod mocks base method by wrapping the associated func.
func (m *FileSystem) Chmod(name string, mode os.FileMode) error {
	m.lockChmod.Lock()
	defer m.lockChmod.Unlock()

	if m.ChmodFunc == nil {
		panic("mocker: FileSystem.ChmodFunc is nil but FileSystem.Chmod was called.")
	}

	call := struct {
		Name string
		Mode os.FileMode
	}{
		Name: name,
		Mode: mode,
	}

	m.calls.Chmod = append(m.calls.Chmod, call)

	return m.ChmodFunc(name, mode)
}

// ChmodCalled returns true if Chmod was called at least once.
func (m *FileSystem) ChmodCalled() bool {
	m.lockChmod.Lock()
	defer m.lockChmod.Unlock()

	return len(m.calls.Chmod) > 0
}

// ChmodCalls returns the calls made to Chmod.
func (m *FileSystem) ChmodCalls() []struct {
	Name string
	Mode os.FileMode
} {
	m.lockChmod.Lock()
	defer m.lockChmod.Unlock()

	return m.calls.Chmod
}

// Remove mocks base method by wrapping the associated func.
func (m *FileSystem) Remove(name string) error {
	m.lockRemove.Lock()
	defer m.lockRemove.Unlock()

	if m.RemoveFunc == nil {
		panic("mocker: FileSystem.RemoveFunc is nil but FileSystem.Remove was called.")
	}

	call := struct {
		Name string
	}{
		Name: name,
	}

	m.calls.Remove = append(m.calls.Remove, call)

	return m.RemoveFunc(name)
}

// RemoveCalled returns true if Remove was called at least once.
func (m *FileSystem) RemoveCalled() bool {
	m.lockRemove.Lock()
	defer m.lockRemove.Unlock()

	return len(m.calls.Remove) > 0
}

// RemoveCalls returns the calls made to Remove.
func (m *FileSystem) RemoveCalls() []struct {
	Name string
} {
	m.lockRemove.Lock()
	defer m.lockRemove.Unlock()

	return m.calls.Remove
}

// RemoveAll mocks base method by wrapping the associated func.
func (m *FileSystem) RemoveAll(path string) error {
	m.lockRemoveAll.Lock()
	defer m.lockRemoveAll.Unlock()

	if m.RemoveAllFunc == nil {
		panic("mocker: FileSystem.RemoveAllFunc is nil but FileSystem.RemoveAll was called.")
	}

	call := struct {
		Path string
	}{
		Path: path,
	}

	m.calls.RemoveAll = append(m.calls.RemoveAll, call)

	return m.RemoveAllFunc(path)
}

// RemoveAllCalled returns true if RemoveAll was called at least once.
func (m *FileSystem) RemoveAllCalled() bool {
	m.lockRemoveAll.Lock()
	defer m.lockRemoveAll.Unlock()

	return len(m.calls.RemoveAll) > 0
}

// RemoveAllCalls returns the calls made to RemoveAll.
func (m *FileSystem) RemoveAllCalls() []struct {
	Path string
} {
	m.lockRemoveAll.Lock()
	defer m.lockRemoveAll.Unlock()

	return m.calls.RemoveAll
}

// ReadDir mocks base method by wrapping the associated func.
func (m *FileSystem) ReadDir(dirname string) ([]os.DirEntry, error) {
	m.lockReadDir.Lock()
	defer m.lockReadDir.Unlock()

	if m.ReadDirFunc == nil {
		panic("mocker: FileSystem.ReadDirFunc is nil but FileSystem.ReadDir was called.")
	}

	call := struct {
		Dirname string
	}{
		Dirname: dirname,
	}

	m.calls.ReadDir = append(m.calls.ReadDir, call)

	return m.ReadDirFunc(dirname)
}

// ReadDirCalled returns true if ReadDir was called at least once.
func (m *FileSystem) ReadDirCalled() bool {
	m.lockReadDir.Lock()
	defer m.lockReadDir.Unlock()

	return len(m.calls.ReadDir) > 0
}

// ReadDirCalls returns the calls made to ReadDir.
func (m *FileSystem) ReadDirCalls() []struct {
	Dirname string
} {
	m.lockReadDir.Lock()
	defer m.lockReadDir.Unlock()

	return m.calls.ReadDir
}

// MkdirTemp mocks base method by wrapping the associated func.
func (m *FileSystem) MkdirTemp(dir, prefix string) (string, error) {
	m.lockMkdirTemp.Lock()
	defer m.lockMkdirTemp.Unlock()

	if m.MkdirTempFunc == nil {
		panic("mocker: FileSystem.MkdirTempFunc is nil but FileSystem.MkdirTemp was called.")
	}

	call := struct {
		Dir    string
		Prefix string
	}{
		Dir:    dir,
		Prefix: prefix,
	}

	m.calls.MkdirTemp = append(m.calls.MkdirTemp, call)

	return m.MkdirTempFunc(dir, prefix)
}

// MkdirTempCalled returns true if MkdirTemp was called at least once.
func (m *FileSystem) MkdirTempCalled() bool {
	m.lockMkdirTemp.Lock()
	defer m.lockMkdirTemp.Unlock()

	return len(m.calls.MkdirTemp) > 0
}

// MkdirTempCalls returns the calls made to MkdirTemp.
func (m *FileSystem) MkdirTempCalls() []struct {
	Dir    string
	Prefix string
} {
	m.lockMkdirTemp.Lock()
	defer m.lockMkdirTemp.Unlock()

	return m.calls.MkdirTemp
}

// Copy mocks base method by wrapping the associated func.
func (m *FileSystem) Copy(dst io.Writer, src io.Reader) (int64, error) {
	m.lockCopy.Lock()
	defer m.lockCopy.Unlock()

	if m.CopyFunc == nil {
		panic("mocker: FileSystem.CopyFunc is nil but FileSystem.Copy was called.")
	}

	call := struct {
		Dst io.Writer
		Src io.Reader
	}{
		Dst: dst,
		Src: src,
	}

	m.calls.Copy = append(m.calls.Copy, call)

	return m.CopyFunc(dst, src)
}

// CopyCalled returns true if Copy was called at least once.
func (m *FileSystem) CopyCalled() bool {
	m.lockCopy.Lock()
	defer m.lockCopy.Unlock()

	return len(m.calls.Copy) > 0
}

// CopyCalls returns the calls made to Copy.
func (m *FileSystem) CopyCalls() []struct {
	Dst io.Writer
	Src io.Reader
} {
	m.lockCopy.Lock()
	defer m.lockCopy.Unlock()

	return m.calls.Copy
}

// Move mocks base method by wrapping the associated func.
func (m *FileSystem) Move(src, dst string) error {
	m.lockMove.Lock()
	defer m.lockMove.Unlock()

	if m.MoveFunc == nil {
		panic("mocker: FileSystem.MoveFunc is nil but FileSystem.Move was called.")
	}

	call := struct {
		Src string
		Dst string
	}{
		Src: src,
		Dst: dst,
	}

	m.calls.Move = append(m.calls.Move, call)

	return m.MoveFunc(src, dst)
}

// MoveCalled returns true if Move was called at least once.
func (m *FileSystem) MoveCalled() bool {
	m.lockMove.Lock()
	defer m.lockMove.Unlock()

	return len(m.calls.Move) > 0
}

// MoveCalls returns the calls made to Move.
func (m *FileSystem) MoveCalls() []struct {
	Src string
	Dst string
} {
	m.lockMove.Lock()
	defer m.lockMove.Unlock()

	return m.calls.Move
}

// NewBufferedReader mocks base method by wrapping the associated func.
func (m *FileSystem) NewBufferedReader(rd io.Reader) github_com_confluentinc_cli_internal_pkg_io.Reader {
	m.lockNewBufferedReader.Lock()
	defer m.lockNewBufferedReader.Unlock()

	if m.NewBufferedReaderFunc == nil {
		panic("mocker: FileSystem.NewBufferedReaderFunc is nil but FileSystem.NewBufferedReader was called.")
	}

	call := struct {
		Rd io.Reader
	}{
		Rd: rd,
	}

	m.calls.NewBufferedReader = append(m.calls.NewBufferedReader, call)

	return m.NewBufferedReaderFunc(rd)
}

// NewBufferedReaderCalled returns true if NewBufferedReader was called at least once.
func (m *FileSystem) NewBufferedReaderCalled() bool {
	m.lockNewBufferedReader.Lock()
	defer m.lockNewBufferedReader.Unlock()

	return len(m.calls.NewBufferedReader) > 0
}

// NewBufferedReaderCalls returns the calls made to NewBufferedReader.
func (m *FileSystem) NewBufferedReaderCalls() []struct {
	Rd io.Reader
} {
	m.lockNewBufferedReader.Lock()
	defer m.lockNewBufferedReader.Unlock()

	return m.calls.NewBufferedReader
}

// IsTerminal mocks base method by wrapping the associated func.
func (m *FileSystem) IsTerminal(fd uintptr) bool {
	m.lockIsTerminal.Lock()
	defer m.lockIsTerminal.Unlock()

	if m.IsTerminalFunc == nil {
		panic("mocker: FileSystem.IsTerminalFunc is nil but FileSystem.IsTerminal was called.")
	}

	call := struct {
		Fd uintptr
	}{
		Fd: fd,
	}

	m.calls.IsTerminal = append(m.calls.IsTerminal, call)

	return m.IsTerminalFunc(fd)
}

// IsTerminalCalled returns true if IsTerminal was called at least once.
func (m *FileSystem) IsTerminalCalled() bool {
	m.lockIsTerminal.Lock()
	defer m.lockIsTerminal.Unlock()

	return len(m.calls.IsTerminal) > 0
}

// IsTerminalCalls returns the calls made to IsTerminal.
func (m *FileSystem) IsTerminalCalls() []struct {
	Fd uintptr
} {
	m.lockIsTerminal.Lock()
	defer m.lockIsTerminal.Unlock()

	return m.calls.IsTerminal
}

// Glob mocks base method by wrapping the associated func.
func (m *FileSystem) Glob(pattern string) ([]string, error) {
	m.lockGlob.Lock()
	defer m.lockGlob.Unlock()

	if m.GlobFunc == nil {
		panic("mocker: FileSystem.GlobFunc is nil but FileSystem.Glob was called.")
	}

	call := struct {
		Pattern string
	}{
		Pattern: pattern,
	}

	m.calls.Glob = append(m.calls.Glob, call)

	return m.GlobFunc(pattern)
}

// GlobCalled returns true if Glob was called at least once.
func (m *FileSystem) GlobCalled() bool {
	m.lockGlob.Lock()
	defer m.lockGlob.Unlock()

	return len(m.calls.Glob) > 0
}

// GlobCalls returns the calls made to Glob.
func (m *FileSystem) GlobCalls() []struct {
	Pattern string
} {
	m.lockGlob.Lock()
	defer m.lockGlob.Unlock()

	return m.calls.Glob
}

// Reset resets the calls made to the mocked methods.
func (m *FileSystem) Reset() {
	m.lockOpen.Lock()
	m.calls.Open = nil
	m.lockOpen.Unlock()
	m.lockStat.Lock()
	m.calls.Stat = nil
	m.lockStat.Unlock()
	m.lockCreate.Lock()
	m.calls.Create = nil
	m.lockCreate.Unlock()
	m.lockChtimes.Lock()
	m.calls.Chtimes = nil
	m.lockChtimes.Unlock()
	m.lockChmod.Lock()
	m.calls.Chmod = nil
	m.lockChmod.Unlock()
	m.lockRemove.Lock()
	m.calls.Remove = nil
	m.lockRemove.Unlock()
	m.lockRemoveAll.Lock()
	m.calls.RemoveAll = nil
	m.lockRemoveAll.Unlock()
	m.lockReadDir.Lock()
	m.calls.ReadDir = nil
	m.lockReadDir.Unlock()
	m.lockMkdirTemp.Lock()
	m.calls.MkdirTemp = nil
	m.lockMkdirTemp.Unlock()
	m.lockCopy.Lock()
	m.calls.Copy = nil
	m.lockCopy.Unlock()
	m.lockMove.Lock()
	m.calls.Move = nil
	m.lockMove.Unlock()
	m.lockNewBufferedReader.Lock()
	m.calls.NewBufferedReader = nil
	m.lockNewBufferedReader.Unlock()
	m.lockIsTerminal.Lock()
	m.calls.IsTerminal = nil
	m.lockIsTerminal.Unlock()
	m.lockGlob.Lock()
	m.calls.Glob = nil
	m.lockGlob.Unlock()
}
