// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tlog

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// GetLogProofReader is a Reader for the GetLogProof structure.
type GetLogProofReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLogProofReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLogProofOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetLogProofBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewGetLogProofDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetLogProofOK creates a GetLogProofOK with default headers values
func NewGetLogProofOK() *GetLogProofOK {
	return &GetLogProofOK{}
}

/* GetLogProofOK describes a response with status code 200, with default header values.

All hashes required to compute the consistency proof
*/
type GetLogProofOK struct {
	Payload *models.ConsistencyProof
}

func (o *GetLogProofOK) Error() string {
	return fmt.Sprintf("[GET /api/v1/log/proof][%d] getLogProofOK  %+v", 200, o.Payload)
}
func (o *GetLogProofOK) GetPayload() *models.ConsistencyProof {
	return o.Payload
}

func (o *GetLogProofOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ConsistencyProof)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLogProofBadRequest creates a GetLogProofBadRequest with default headers values
func NewGetLogProofBadRequest() *GetLogProofBadRequest {
	return &GetLogProofBadRequest{}
}

/* GetLogProofBadRequest describes a response with status code 400, with default header values.

The content supplied to the server was invalid
*/
type GetLogProofBadRequest struct {
	Payload *models.Error
}

func (o *GetLogProofBadRequest) Error() string {
	return fmt.Sprintf("[GET /api/v1/log/proof][%d] getLogProofBadRequest  %+v", 400, o.Payload)
}
func (o *GetLogProofBadRequest) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetLogProofBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLogProofDefault creates a GetLogProofDefault with default headers values
func NewGetLogProofDefault(code int) *GetLogProofDefault {
	return &GetLogProofDefault{
		_statusCode: code,
	}
}

/* GetLogProofDefault describes a response with status code -1, with default header values.

There was an internal error in the server while processing the request
*/
type GetLogProofDefault struct {
	_statusCode int

	Payload *models.Error
}

// Code gets the status code for the get log proof default response
func (o *GetLogProofDefault) Code() int {
	return o._statusCode
}

func (o *GetLogProofDefault) Error() string {
	return fmt.Sprintf("[GET /api/v1/log/proof][%d] getLogProof default  %+v", o._statusCode, o.Payload)
}
func (o *GetLogProofDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetLogProofDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
