// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// GetRekorVersionReader is a Reader for the GetRekorVersion structure.
type GetRekorVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRekorVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRekorVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetRekorVersionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetRekorVersionOK creates a GetRekorVersionOK with default headers values
func NewGetRekorVersionOK() *GetRekorVersionOK {
	return &GetRekorVersionOK{}
}

/* GetRekorVersionOK describes a response with status code 200, with default header values.

A JSON object with the running rekor version
*/
type GetRekorVersionOK struct {
	Payload *models.RekorVersion
}

func (o *GetRekorVersionOK) Error() string {
	return fmt.Sprintf("[GET /api/v1/version][%d] getRekorVersionOK  %+v", 200, o.Payload)
}
func (o *GetRekorVersionOK) GetPayload() *models.RekorVersion {
	return o.Payload
}

func (o *GetRekorVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RekorVersion)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRekorVersionDefault creates a GetRekorVersionDefault with default headers values
func NewGetRekorVersionDefault(code int) *GetRekorVersionDefault {
	return &GetRekorVersionDefault{
		_statusCode: code,
	}
}

/* GetRekorVersionDefault describes a response with status code -1, with default header values.

There was an internal error in the server while processing the request
*/
type GetRekorVersionDefault struct {
	_statusCode int

	Payload *models.Error
}

// Code gets the status code for the get rekor version default response
func (o *GetRekorVersionDefault) Code() int {
	return o._statusCode
}

func (o *GetRekorVersionDefault) Error() string {
	return fmt.Sprintf("[GET /api/v1/version][%d] getRekorVersion default  %+v", o._statusCode, o.Payload)
}
func (o *GetRekorVersionDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetRekorVersionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
