/* gitg-dash-view.c generated by valac 0.32.1, the Vala compiler
 * generated from gitg-dash-view.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libgitg-ext/libgitg-ext.h"
#include <gio/gio.h>
#include "libgitg/libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <libgit2-glib/ggit.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define GITG_TYPE_RECURSIVE_SCANNER (gitg_recursive_scanner_get_type ())
#define GITG_RECURSIVE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_RECURSIVE_SCANNER, GitgRecursiveScanner))
#define GITG_IS_RECURSIVE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_RECURSIVE_SCANNER))
#define GITG_RECURSIVE_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_RECURSIVE_SCANNER, GitgRecursiveScannerIface))

typedef struct _GitgRecursiveScanner GitgRecursiveScanner;
typedef struct _GitgRecursiveScannerIface GitgRecursiveScannerIface;

#define GITG_TYPE_DASH_VIEW (gitg_dash_view_get_type ())
#define GITG_DASH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DASH_VIEW, GitgDashView))
#define GITG_DASH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DASH_VIEW, GitgDashViewClass))
#define GITG_IS_DASH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DASH_VIEW))
#define GITG_IS_DASH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DASH_VIEW))
#define GITG_DASH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DASH_VIEW, GitgDashViewClass))

typedef struct _GitgDashView GitgDashView;
typedef struct _GitgDashViewClass GitgDashViewClass;
typedef struct _GitgDashViewPrivate GitgDashViewPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;

#define GITG_TYPE_AUTHOR_DETAILS_DIALOG (gitg_author_details_dialog_get_type ())
#define GITG_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialog))
#define GITG_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))
#define GITG_IS_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_IS_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_AUTHOR_DETAILS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))

typedef struct _GitgAuthorDetailsDialog GitgAuthorDetailsDialog;
typedef struct _GitgAuthorDetailsDialogClass GitgAuthorDetailsDialogClass;
typedef struct _Block42Data Block42Data;
#define __vala_GgitFetchOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitFetchOptions_free (var), NULL)))

#define GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS (gitg_dash_view_clone_callbacks_get_type ())
#define GITG_DASH_VIEW_CLONE_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacks))
#define GITG_DASH_VIEW_CLONE_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacksClass))
#define GITG_DASH_VIEW_IS_CLONE_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS))
#define GITG_DASH_VIEW_IS_CLONE_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS))
#define GITG_DASH_VIEW_CLONE_CALLBACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacksClass))

typedef struct _GitgDashViewCloneCallbacks GitgDashViewCloneCallbacks;
typedef struct _GitgDashViewCloneCallbacksClass GitgDashViewCloneCallbacksClass;
typedef struct _GitgDashViewCloneData GitgDashViewCloneData;
typedef struct _Block43Data Block43Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block44Data Block44Data;
typedef struct _GitgDashViewFileExistsAsyncData GitgDashViewFileExistsAsyncData;
typedef struct _GitgDashViewScanVisitDirectoryData GitgDashViewScanVisitDirectoryData;
typedef struct _Block45Data Block45Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block46Data Block46Data;
#define _gitg_when_mapped_unref0(var) ((var == NULL) ? NULL : (var = (gitg_when_mapped_unref (var), NULL)))
typedef struct _GitgDashViewCloneCallbacksPrivate GitgDashViewCloneCallbacksPrivate;
#define _gitg_credentials_manager_unref0(var) ((var == NULL) ? NULL : (var = (gitg_credentials_manager_unref (var), NULL)))
typedef struct _Block47Data Block47Data;

struct _GitgRecursiveScannerIface {
	GTypeInterface parent_iface;
	void (*scan_visit_file) (GitgRecursiveScanner* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*scan_visit_file_finish) (GitgRecursiveScanner* self, GAsyncResult* _res_);
	void (*scan_visit_directory) (GitgRecursiveScanner* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*scan_visit_directory_finish) (GitgRecursiveScanner* self, GAsyncResult* _res_);
};

struct _GitgDashView {
	GtkGrid parent_instance;
	GitgDashViewPrivate * priv;
};

struct _GitgDashViewClass {
	GtkGridClass parent_class;
};

struct _GitgDashViewPrivate {
	GitgExtApplication* _application;
	gboolean d_setting_mode;
	GtkGrid* d_introduction;
	GtkLabel* d_label_scan;
	GtkLabel* d_label_profile;
	GtkScrolledWindow* d_scrolled_window;
	GitgRepositoryListBox* d_repository_list_box;
	gchar* d_search_text;
	gboolean _search_visible;
};

struct _Block42Data {
	int _ref_count_;
	GitgDashView* self;
	GitgRepository* repository;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	gpointer _async_data_;
};

struct _GitgDashViewCloneData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgDashView* self;
	GitgRepositoryListBoxRow* row;
	gchar* url;
	GFile* location;
	gboolean is_bare;
	GitgRepository* result;
	Block42Data* _data42_;
	GitgRepositoryListBoxRow* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	GitgRepository* _tmp4_;
	GError * _inner_error_;
};

struct _Block43Data {
	int _ref_count_;
	GitgDashView* self;
	GitgRepositoryListBoxRow* row;
};

struct _Block44Data {
	int _ref_count_;
	GitgDashView* self;
	GFile* location;
};

struct _GitgDashViewFileExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgDashView* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	GFileInfo* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_;
};

struct _GitgDashViewScanVisitDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgDashView* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GCancellable* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GFile* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GCancellable* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GCancellable* _tmp22_;
	gboolean _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GCancellable* _tmp27_;
	gboolean _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gboolean _tmp31_;
};

struct _Block45Data {
	int _ref_count_;
	GitgDashView* self;
	GtkMessageDialog* dlg;
	GCancellable* cancellable;
	guint timeout_id;
};

struct _Block46Data {
	int _ref_count_;
	GitgDashView* self;
	GitgWhenMapped* whenMapped;
};

struct _GitgDashViewCloneCallbacks {
	GgitRemoteCallbacks parent_instance;
	GitgDashViewCloneCallbacksPrivate * priv;
};

struct _GitgDashViewCloneCallbacksClass {
	GgitRemoteCallbacksClass parent_class;
};

struct _GitgDashViewCloneCallbacksPrivate {
	GitgRepositoryListBoxRow* d_row;
	GitgCredentialsManager* d_credentials;
};

struct _Block47Data {
	int _ref_count_;
	GitgDashViewCloneCallbacks* self;
	guint recvobj;
	guint indxobj;
	guint totaobj;
};


static gpointer gitg_dash_view_parent_class = NULL;
static gpointer gitg_dash_view_clone_callbacks_parent_class = NULL;
static GitgExtUIElementIface* gitg_dash_view_gitg_ext_ui_element_parent_iface = NULL;
static GitgExtActivityIface* gitg_dash_view_gitg_ext_activity_parent_iface = NULL;
static GitgExtSelectableIface* gitg_dash_view_gitg_ext_selectable_parent_iface = NULL;
static GitgExtSearchableIface* gitg_dash_view_gitg_ext_searchable_parent_iface = NULL;
static GitgRecursiveScannerIface* gitg_dash_view_gitg_recursive_scanner_parent_iface = NULL;

GType gitg_recursive_scanner_get_type (void) G_GNUC_CONST;
GType gitg_dash_view_get_type (void) G_GNUC_CONST;
#define GITG_DASH_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_DASH_VIEW, GitgDashViewPrivate))
enum  {
	GITG_DASH_VIEW_DUMMY_PROPERTY,
	GITG_DASH_VIEW_APPLICATION,
	GITG_DASH_VIEW_SELECTABLE_MODE,
	GITG_DASH_VIEW_HAS_REPOSITORIES,
	GITG_DASH_VIEW_SELECTABLE_AVAILABLE,
	GITG_DASH_VIEW_SEARCH_AVAILABLE,
	GITG_DASH_VIEW_DISPLAY_NAME,
	GITG_DASH_VIEW_DESCRIPTION,
	GITG_DASH_VIEW_ID,
	GITG_DASH_VIEW_WIDGET,
	GITG_DASH_VIEW_ICON,
	GITG_DASH_VIEW_SEARCH_TEXT,
	GITG_DASH_VIEW_SEARCH_ENTRY,
	GITG_DASH_VIEW_SEARCH_VISIBLE,
	GITG_DASH_VIEW_ACTION_WIDGET
};
#define GITG_DASH_VIEW_version VERSION
static void gitg_dash_view_update_search_text (GitgDashView* self);
static void gitg_dash_view_update_setup_profile_visibility (GitgDashView* self);
static gboolean gitg_dash_view_scan_home_activated (GitgDashView* self);
static void gitg_dash_view_add_repositories_scan (GitgDashView* self, GFile* location);
static gboolean _gitg_dash_view_scan_home_activated_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static gboolean gitg_dash_view_setup_profile_activated (GitgDashView* self);
GType gitg_window_get_type (void) G_GNUC_CONST;
GType gitg_author_details_dialog_get_type (void) G_GNUC_CONST;
GitgAuthorDetailsDialog* gitg_author_details_dialog_show_global (GitgWindow* window);
static gboolean _gitg_dash_view_setup_profile_activated_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void gitg_dash_view_update_availability (GitgDashView* self);
GitgRepositoryListBoxRow* gitg_dash_view_add_repository (GitgDashView* self, GitgRepository* repository);
static void gitg_dash_view_clone_data_free (gpointer _data);
static void gitg_dash_view_clone (GitgDashView* self, GitgRepositoryListBoxRow* row, const gchar* url, GFile* location, gboolean is_bare, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GitgRepository* gitg_dash_view_clone_finish (GitgDashView* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_dash_view_clone_co (GitgDashViewCloneData* _data_);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static void __lambda99_ (Block42Data* _data42_, GError** error);
static void _vala_GgitFetchOptions_free (GgitFetchOptions* self);
static GitgDashViewCloneCallbacks* gitg_dash_view_clone_callbacks_new (GitgExtApplication* application, GgitConfig* config, GitgRepositoryListBoxRow* row);
static GitgDashViewCloneCallbacks* gitg_dash_view_clone_callbacks_construct (GType object_type, GitgExtApplication* application, GgitConfig* config, GitgRepositoryListBoxRow* row);
static GType gitg_dash_view_clone_callbacks_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void ___lambda99__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_dash_view_clone_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void gitg_dash_view_clone_repository (GitgDashView* self, const gchar* url, GFile* location, gboolean is_bare);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static void __lambda101_ (Block43Data* _data43_, GObject* obj, GAsyncResult* res);
static void ___lambda101__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_dash_view_finish_add_repository (GitgDashView* self, GitgRepository* repo);
static void gitg_dash_view_do_add_repository (GitgDashView* self, GFile* location, gboolean report_errors);
static void gitg_dash_view_query_create_repository (GitgDashView* self, GFile* location);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static gboolean __lambda102_ (Block44Data* _data44_, GitgExtUserQuery* w, GtkResponseType r);
static gboolean ___lambda102__gitg_ext_user_query_response (GitgExtUserQuery* _sender, GtkResponseType response_type, gpointer self);
static gboolean gitg_dash_view_looks_like_git (GitgDashView* self, GFile* location);
static void gitg_dash_view_file_exists_async_data_free (gpointer _data);
static void gitg_dash_view_file_exists_async (GitgDashView* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean gitg_dash_view_file_exists_finish (GitgDashView* self, GAsyncResult* _res_);
static gboolean gitg_dash_view_file_exists_async_co (GitgDashViewFileExistsAsyncData* _data_);
static void gitg_dash_view_file_exists_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_dash_view_real_scan_visit_directory_data_free (gpointer _data);
static void gitg_dash_view_real_scan_visit_directory (GitgRecursiveScanner* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean gitg_dash_view_real_scan_visit_directory_co (GitgDashViewScanVisitDirectoryData* _data_);
static void gitg_dash_view_scan_visit_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean gitg_recursive_scanner_scan_visit_directory_default (GitgRecursiveScanner* self, GFile* file);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static void __lambda95_ (Block45Data* _data45_);
static void ___lambda95__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda96_ (Block45Data* _data45_);
static gboolean ___lambda96__gsource_func (gpointer self);
void gitg_recursive_scanner_scan (GitgRecursiveScanner* self, GFile* location, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_recursive_scanner_scan_finish (GitgRecursiveScanner* self, GAsyncResult* _res_);
static void __lambda97_ (Block45Data* _data45_);
static void ___lambda97__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void gitg_dash_view_add_repository_from_location (GitgDashView* self, GFile* location, gboolean scan_all);
GitgDashView* gitg_dash_view_new (void);
GitgDashView* gitg_dash_view_construct (GType object_type);
gboolean gitg_dash_view_get_has_repositories (GitgDashView* self);
static void _gitg_dash_view_action_widget___lambda103_ (GitgDashView* self);
static void __gitg_dash_view_action_widget___lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * gitg_dash_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static void _gitg_dash_view___lambda104_ (GitgDashView* self);
static void __gitg_dash_view___lambda104__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _gitg_dash_view___lambda105_ (GitgDashView* self, GitgRepository* repository);
static void __gitg_dash_view___lambda105__gitg_repository_list_box_repository_activated (GitgRepositoryListBox* _sender, GitgRepository* repository, gpointer self);
static void _gitg_dash_view___lambda106_ (GitgDashView* self, const gchar* primary_message, const gchar* secondary_message);
static void __gitg_dash_view___lambda106__gitg_repository_list_box_show_error (GitgRepositoryListBox* _sender, const gchar* primary_message, const gchar* secondary_message, gpointer self);
static void _gitg_dash_view_update_availability_gtk_container_add (GtkContainer* _sender, GtkWidget* widget, gpointer self);
static void _gitg_dash_view_update_availability_gtk_container_remove (GtkContainer* _sender, GtkWidget* widget, gpointer self);
static void _gitg_dash_view___lambda107_ (Block46Data* _data46_);
gchar* gitg_dirs_get_user_data_dir (void);
static void __gitg_dash_view___lambda107__gitg_when_mapped_on_mapped (gpointer self);
#define GITG_DASH_VIEW_CLONE_CALLBACKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacksPrivate))
enum  {
	GITG_DASH_VIEW_CLONE_CALLBACKS_DUMMY_PROPERTY
};
static void gitg_dash_view_clone_callbacks_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static gboolean __lambda100_ (Block47Data* _data47_);
static gboolean ___lambda100__gsource_func (gpointer self);
static GgitCred* gitg_dash_view_clone_callbacks_real_credentials (GgitRemoteCallbacks* base, const gchar* url, const gchar* username_from_url, GgitCredtype allowed_types, GError** error);
static void gitg_dash_view_clone_callbacks_finalize (GObject* obj);
static void gitg_dash_view_finalize (GObject* obj);
static void _vala_gitg_dash_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_dash_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void gitg_dash_view_update_search_text (GitgDashView* self) {
	GitgRepositoryListBox* _tmp0_ = NULL;
#line 150 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 152 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_repository_list_box;
#line 152 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp0_ != NULL) {
#line 410 "gitg-dash-view.c"
		const gchar* _tmp1_ = NULL;
#line 154 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp1_ = self->priv->d_search_text;
#line 154 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (g_strcmp0 (_tmp1_, "") != 0) {
#line 416 "gitg-dash-view.c"
			GitgRepositoryListBox* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
#line 156 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp2_ = self->priv->d_repository_list_box;
#line 156 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp3_ = self->priv->d_search_text;
#line 156 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_repository_list_box_filter_text (_tmp2_, _tmp3_);
#line 425 "gitg-dash-view.c"
		} else {
			GitgRepositoryListBox* _tmp4_ = NULL;
#line 160 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp4_ = self->priv->d_repository_list_box;
#line 160 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_repository_list_box_filter_text (_tmp4_, NULL);
#line 432 "gitg-dash-view.c"
		}
	}
}


static void gitg_dash_view_update_setup_profile_visibility (GitgDashView* self) {
	GtkLabel* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 243 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 443 "gitg-dash-view.c"
	{
		GgitConfig* _tmp0_ = NULL;
		GgitConfig* _tmp1_ = NULL;
		GgitConfig* config = NULL;
		GgitConfig* _tmp2_ = NULL;
		GgitConfig* _tmp3_ = NULL;
		GgitConfig* _tmp4_ = NULL;
		GgitConfig* _tmp5_ = NULL;
		gchar* author_name = NULL;
		GgitConfig* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* author_email = NULL;
		GgitConfig* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_ = NULL;
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp1_ = ggit_config_new_default (&_inner_error_);
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp0_ = _tmp1_;
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 468 "gitg-dash-view.c"
			goto __catch71_g_error;
		}
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp2_ = _tmp0_;
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp0_ = NULL;
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = _tmp2_;
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp4_ = ggit_config_snapshot (_tmp3_, &_inner_error_);
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp5_ = _tmp4_;
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp3_);
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		config = _tmp5_;
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (_tmp0_);
#line 489 "gitg-dash-view.c"
			goto __catch71_g_error;
		}
#line 248 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp6_ = config;
#line 248 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp7_ = ggit_config_get_string (_tmp6_, "user.name", &_inner_error_);
#line 248 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 248 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		author_name = _tmp8_;
#line 248 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 248 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (config);
#line 248 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (_tmp0_);
#line 506 "gitg-dash-view.c"
			goto __catch71_g_error;
		}
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp9_ = config;
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp10_ = ggit_config_get_string (_tmp9_, "user.email", &_inner_error_);
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		author_email = _tmp11_;
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_free0 (author_name);
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (config);
#line 249 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (_tmp0_);
#line 525 "gitg-dash-view.c"
			goto __catch71_g_error;
		}
#line 251 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp13_ = author_name;
#line 251 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (g_strcmp0 (_tmp13_, "") != 0) {
#line 532 "gitg-dash-view.c"
			const gchar* _tmp14_ = NULL;
#line 251 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp14_ = author_email;
#line 251 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
#line 538 "gitg-dash-view.c"
		} else {
#line 251 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp12_ = FALSE;
#line 542 "gitg-dash-view.c"
		}
#line 251 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_tmp12_) {
#line 546 "gitg-dash-view.c"
			GtkLabel* _tmp15_ = NULL;
#line 253 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp15_ = self->priv->d_label_profile;
#line 253 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gtk_widget_set_visible ((GtkWidget*) _tmp15_, FALSE);
#line 254 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_free0 (author_email);
#line 254 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_free0 (author_name);
#line 254 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (config);
#line 254 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (_tmp0_);
#line 254 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			return;
#line 562 "gitg-dash-view.c"
		}
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_free0 (author_email);
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_free0 (author_name);
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (config);
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp0_);
#line 572 "gitg-dash-view.c"
	}
	goto __finally71;
	__catch71_g_error:
	{
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_clear_error (&_inner_error_);
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_inner_error_ = NULL;
#line 581 "gitg-dash-view.c"
	}
	__finally71:
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_clear_error (&_inner_error_);
#line 245 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return;
#line 592 "gitg-dash-view.c"
	}
#line 258 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp16_ = self->priv->d_label_profile;
#line 258 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
#line 598 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_scan_home_activated (GitgDashView* self) {
	gboolean result = FALSE;
	gchar* homedir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 262 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 264 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = g_get_home_dir ();
#line 264 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 264 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	homedir = _tmp1_;
#line 266 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = homedir;
#line 266 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp2_ != NULL) {
#line 620 "gitg-dash-view.c"
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
#line 268 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = homedir;
#line 268 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp4_ = g_file_new_for_path (_tmp3_);
#line 268 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp5_ = _tmp4_;
#line 268 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_add_repositories_scan (self, _tmp5_);
#line 268 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp5_);
#line 634 "gitg-dash-view.c"
	}
#line 271 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = TRUE;
#line 271 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (homedir);
#line 271 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 642 "gitg-dash-view.c"
}


static gboolean _gitg_dash_view_scan_home_activated_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = gitg_dash_view_scan_home_activated ((GitgDashView*) self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 651 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_setup_profile_activated (GitgDashView* self) {
	gboolean result = FALSE;
	GitgExtApplication* _tmp0_ = NULL;
	GitgExtApplication* _tmp1_ = NULL;
	GitgWindow* _tmp2_ = NULL;
	GitgWindow* _tmp3_ = NULL;
	GitgAuthorDetailsDialog* _tmp4_ = NULL;
	GitgAuthorDetailsDialog* _tmp5_ = NULL;
#line 275 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _tmp0_;
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GITG_TYPE_WINDOW) ? ((GitgWindow*) _tmp1_) : NULL;
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp2_ == NULL) {
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp1_);
#line 675 "gitg-dash-view.c"
	}
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = _tmp2_;
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = gitg_author_details_dialog_show_global (_tmp3_);
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = _tmp4_;
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp5_);
#line 277 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp3_);
#line 278 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = TRUE;
#line 278 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 691 "gitg-dash-view.c"
}


static gboolean _gitg_dash_view_setup_profile_activated_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = gitg_dash_view_setup_profile_activated ((GitgDashView*) self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 700 "gitg-dash-view.c"
}


static void gitg_dash_view_update_availability (GitgDashView* self) {
#line 281 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject*) self, "has-repositories");
#line 284 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject*) self, "selectable-available");
#line 285 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject*) self, "search-available");
#line 713 "gitg-dash-view.c"
}


GitgRepositoryListBoxRow* gitg_dash_view_add_repository (GitgDashView* self, GitgRepository* repository) {
	GitgRepositoryListBoxRow* result = NULL;
	GitgRepositoryListBox* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
#line 288 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 288 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (repository != NULL, NULL);
#line 290 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_repository_list_box;
#line 290 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = repository;
#line 290 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = gitg_repository_list_box_add_repository (_tmp0_, _tmp1_, NULL);
#line 290 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp2_;
#line 290 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 736 "gitg-dash-view.c"
}


static void gitg_dash_view_clone_data_free (gpointer _data) {
	GitgDashViewCloneData* _data_;
	_data_ = _data;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->result);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_slice_free (GitgDashViewCloneData, _data_);
#line 749 "gitg-dash-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 756 "gitg-dash-view.c"
}


static void gitg_dash_view_clone (GitgDashView* self, GitgRepositoryListBoxRow* row, const gchar* url, GFile* location, gboolean is_bare, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgDashViewCloneData* _data_;
	GitgDashView* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = g_slice_new0 (GitgDashViewCloneData);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_dash_view_clone);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_dash_view_clone_data_free);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->self = _tmp0_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = row;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->row);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->row = _tmp2_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = url;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_data_->url);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->url = _tmp4_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = location;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->location);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->location = _tmp6_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = is_bare;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->is_bare = _tmp7_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_clone_co (_data_);
#line 810 "gitg-dash-view.c"
}


static GitgRepository* gitg_dash_view_clone_finish (GitgDashView* self, GAsyncResult* _res_, GError** error) {
	GitgRepository* result;
	GitgDashViewCloneData* _data_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return NULL;
#line 821 "gitg-dash-view.c"
	}
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _data_->result;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->result = NULL;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 831 "gitg-dash-view.c"
}


static Block42Data* block42_data_ref (Block42Data* _data42_) {
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_atomic_int_inc (&_data42_->_ref_count_);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return _data42_;
#line 840 "gitg-dash-view.c"
}


static void block42_data_unref (void * _userdata_) {
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
#line 849 "gitg-dash-view.c"
		GitgDashView* self;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		self = _data42_->self;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data42_->repository);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data42_->row);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_free0 (_data42_->url);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data42_->location);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (self);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_slice_free (Block42Data, _data42_);
#line 865 "gitg-dash-view.c"
	}
}


static void _vala_GgitFetchOptions_free (GgitFetchOptions* self) {
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_boxed_free (ggit_fetch_options_get_type (), self);
#line 873 "gitg-dash-view.c"
}


static void __lambda99_ (Block42Data* _data42_, GError** error) {
	GitgDashView* self;
	GgitCloneOptions* clone_options = NULL;
	GgitCloneOptions* _tmp0_ = NULL;
	GgitFetchOptions* fetch_options = NULL;
	GgitFetchOptions* _tmp1_ = NULL;
	GgitConfig* config = NULL;
	GitgExtApplication* _tmp5_ = NULL;
	GitgExtApplication* _tmp6_ = NULL;
	GitgExtApplication* _tmp7_ = NULL;
	GgitConfig* _tmp8_ = NULL;
	GitgRepositoryListBoxRow* _tmp9_ = NULL;
	GitgDashViewCloneCallbacks* _tmp10_ = NULL;
	GitgDashViewCloneCallbacks* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GgitRepository* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GgitRepository* _tmp16_ = NULL;
	GgitRepository* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data42_->self;
#line 327 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = ggit_clone_options_new ();
#line 327 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	clone_options = _tmp0_;
#line 328 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = ggit_fetch_options_new ();
#line 328 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	fetch_options = _tmp1_;
#line 329 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	config = NULL;
#line 910 "gitg-dash-view.c"
	{
		GgitConfig* _tmp2_ = NULL;
		GgitConfig* _tmp3_ = NULL;
		GgitConfig* _tmp4_ = NULL;
#line 333 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = ggit_config_new_default (&_inner_error_);
#line 333 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp2_ = _tmp3_;
#line 333 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 921 "gitg-dash-view.c"
			goto __catch72_g_error;
		}
#line 333 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp4_ = _tmp2_;
#line 333 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp2_ = NULL;
#line 333 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (config);
#line 333 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		config = _tmp4_;
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp2_);
#line 934 "gitg-dash-view.c"
	}
	goto __finally72;
	__catch72_g_error:
	{
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_clear_error (&_inner_error_);
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_inner_error_ = NULL;
#line 943 "gitg-dash-view.c"
	}
	__finally72:
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_propagate_error (error, _inner_error_);
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (config);
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		__vala_GgitFetchOptions_free0 (fetch_options);
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (clone_options);
#line 331 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return;
#line 958 "gitg-dash-view.c"
	}
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = _tmp5_;
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = _tmp6_;
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp8_ = config;
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp9_ = _data42_->row;
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp10_ = gitg_dash_view_clone_callbacks_new (_tmp7_, _tmp8_, _tmp9_);
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = _tmp10_;
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	ggit_fetch_options_set_remote_callbacks (fetch_options, (GgitRemoteCallbacks*) _tmp11_);
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp11_);
#line 336 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp7_);
#line 338 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp12_ = _data42_->is_bare;
#line 338 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	ggit_clone_options_set_is_bare (clone_options, _tmp12_);
#line 339 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	ggit_clone_options_set_fetch_options (clone_options, fetch_options);
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp14_ = _data42_->url;
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp15_ = _data42_->location;
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp16_ = ggit_repository_clone (_tmp14_, _tmp15_, clone_options, &_inner_error_);
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp13_ = _tmp16_;
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_propagate_error (error, _inner_error_);
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (config);
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		__vala_GgitFetchOptions_free0 (fetch_options);
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (clone_options);
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return;
#line 1006 "gitg-dash-view.c"
	}
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp17_ = _tmp13_;
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp13_ = NULL;
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data42_->repository);
#line 341 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data42_->repository = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GITG_TYPE_REPOSITORY, GitgRepository);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp13_);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (config);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	__vala_GgitFetchOptions_free0 (fetch_options);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (clone_options);
#line 1024 "gitg-dash-view.c"
}


static void ___lambda99__gitg_async_thread_func (gpointer self, GError** error) {
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	__lambda99_ (self, error);
#line 1031 "gitg-dash-view.c"
}


static void gitg_dash_view_clone_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgDashViewCloneData* _data_;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = _user_data_;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_source_object_ = source_object;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_res_ = _res_;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_clone_co (_data_);
#line 1045 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_clone_co (GitgDashViewCloneData* _data_) {
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	switch (_data_->_state_) {
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 0:
#line 1054 "gitg-dash-view.c"
		goto _state_0;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 1:
#line 1058 "gitg-dash-view.c"
		goto _state_1;
		default:
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_assert_not_reached ();
#line 1063 "gitg-dash-view.c"
	}
	_state_0:
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_ = g_slice_new0 (Block42Data);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->_ref_count_ = 1;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->self = g_object_ref (_data_->self);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp0_ = NULL;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp0_ = _data_->row;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->_data42_->row);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->row = _data_->_tmp0_;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp1_ = NULL;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp1_ = _data_->url;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_data_->_data42_->url);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->url = _data_->_tmp1_;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp2_ = NULL;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp2_ = _data_->location;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->_data42_->location);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->location = _data_->_tmp2_;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp3_ = FALSE;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp3_ = _data_->is_bare;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->is_bare = _data_->_tmp3_;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->_async_data_ = _data_;
#line 324 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_->repository = NULL;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_state_ = 1;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_async_thread (___lambda99__gitg_async_thread_func, _data_->_data42_, gitg_dash_view_clone_ready, _data_);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 1112 "gitg-dash-view.c"
	_state_1:
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_error_free (_data_->_inner_error_);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		block42_data_unref (_data_->_data42_);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_data42_ = NULL;
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_data_->_state_ == 0) {
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1130 "gitg-dash-view.c"
		} else {
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1134 "gitg-dash-view.c"
		}
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_object_unref (_data_->_async_result);
#line 326 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 1140 "gitg-dash-view.c"
	}
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp4_ = NULL;
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp4_ = _g_object_ref0 (_data_->_data42_->repository);
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->result = _data_->_tmp4_;
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block42_data_unref (_data_->_data42_);
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_ = NULL;
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_state_ == 0) {
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1156 "gitg-dash-view.c"
	} else {
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1160 "gitg-dash-view.c"
	}
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_unref (_data_->_async_result);
#line 344 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block42_data_unref (_data_->_data42_);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_data42_ = NULL;
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_state_ == 0) {
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1174 "gitg-dash-view.c"
	} else {
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1178 "gitg-dash-view.c"
	}
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_unref (_data_->_async_result);
#line 322 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 1184 "gitg-dash-view.c"
}


static Block43Data* block43_data_ref (Block43Data* _data43_) {
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_atomic_int_inc (&_data43_->_ref_count_);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return _data43_;
#line 1193 "gitg-dash-view.c"
}


static void block43_data_unref (void * _userdata_) {
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
#line 1202 "gitg-dash-view.c"
		GitgDashView* self;
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		self = _data43_->self;
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data43_->row);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (self);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_slice_free (Block43Data, _data43_);
#line 1212 "gitg-dash-view.c"
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1017 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1018 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1018 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1018 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1018 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1020 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1020 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1238 "gitg-dash-view.c"
		gchar* _tmp4_ = NULL;
#line 1021 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1021 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1021 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 1246 "gitg-dash-view.c"
	} else {
#line 1023 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		result = -1;
#line 1023 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 1252 "gitg-dash-view.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1295 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1296 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1296 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1276 "gitg-dash-view.c"
		glong _tmp4_ = 0L;
#line 1297 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1297 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1297 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 1284 "gitg-dash-view.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1299 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1299 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1299 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1299 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 1296 "gitg-dash-view.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1306 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1320 "gitg-dash-view.c"
		glong _tmp2_ = 0L;
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1326 "gitg-dash-view.c"
	} else {
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1330 "gitg-dash-view.c"
	}
#line 1308 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1334 "gitg-dash-view.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1310 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1310 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1310 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1310 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 1346 "gitg-dash-view.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1312 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1312 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1312 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 1356 "gitg-dash-view.c"
	}
#line 1315 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1315 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 1362 "gitg-dash-view.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1316 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1316 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1316 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1317 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1317 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 1376 "gitg-dash-view.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1319 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1319 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 1386 "gitg-dash-view.c"
	}
#line 1321 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1321 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 1392 "gitg-dash-view.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1322 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1322 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1322 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 1401 "gitg-dash-view.c"
	}
#line 1324 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1324 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1324 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1324 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1325 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1325 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1325 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1325 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1325 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 1421 "gitg-dash-view.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1454 "gitg-dash-view.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1463 "gitg-dash-view.c"
	}
#line 1333 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1469 "gitg-dash-view.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1478 "gitg-dash-view.c"
	}
#line 1336 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1484 "gitg-dash-view.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1493 "gitg-dash-view.c"
	} else {
#line 1336 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1497 "gitg-dash-view.c"
	}
#line 1336 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1505 "gitg-dash-view.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1514 "gitg-dash-view.c"
	} else {
#line 1337 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1518 "gitg-dash-view.c"
	}
#line 1337 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 1540 "gitg-dash-view.c"
}


static void __lambda101_ (Block43Data* _data43_, GObject* obj, GAsyncResult* res) {
	GitgDashView* self;
	GitgRepository* repository = NULL;
	GitgRepositoryListBox* _tmp10_ = NULL;
	GitgRepository* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data43_->self;
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (res != NULL);
#line 376 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	repository = NULL;
#line 1556 "gitg-dash-view.c"
	{
		GitgRepository* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GitgRepository* _tmp2_ = NULL;
		GitgRepository* _tmp3_ = NULL;
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp1_ = res;
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp2_ = gitg_dash_view_clone_finish (self, _tmp1_, &_inner_error_);
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp0_ = _tmp2_;
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1570 "gitg-dash-view.c"
			goto __catch73_g_error;
		}
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = _tmp0_;
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp0_ = NULL;
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (repository);
#line 380 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		repository = _tmp3_;
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp0_);
#line 1583 "gitg-dash-view.c"
	}
	goto __finally73;
	__catch73_g_error:
	{
		GError* e = NULL;
		GitgExtApplication* _tmp4_ = NULL;
		GitgExtApplication* _tmp5_ = NULL;
		GitgExtApplication* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		e = _inner_error_;
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_inner_error_ = NULL;
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp4_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp5_ = _tmp4_;
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp6_ = _tmp5_;
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp7_ = _ ("Failed to clone repository");
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp8_ = e;
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp9_ = _tmp8_->message;
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_ext_application_show_infobar (_tmp6_, _tmp7_, _tmp9_, GTK_MESSAGE_ERROR);
#line 384 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp6_);
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_error_free0 (e);
#line 1617 "gitg-dash-view.c"
	}
	__finally73:
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (repository);
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_clear_error (&_inner_error_);
#line 378 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return;
#line 1630 "gitg-dash-view.c"
	}
#line 387 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp10_ = self->priv->d_repository_list_box;
#line 387 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = repository;
#line 387 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_repository_list_box_end_cloning (_tmp10_, _data43_->row, _tmp11_);
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (repository);
#line 1640 "gitg-dash-view.c"
}


static void ___lambda101__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	__lambda101_ (self, source_object, res);
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block43_data_unref (self);
#line 1649 "gitg-dash-view.c"
}


void gitg_dash_view_clone_repository (GitgDashView* self, const gchar* url, GFile* location, gboolean is_bare) {
	Block43Data* _data43_;
	gint pos = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* dot_git_suffix = NULL;
	gchar* _tmp5_ = NULL;
	gchar* subfolder_name = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gboolean has_dot_git = FALSE;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GFile* subfolder = NULL;
	GFile* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	GitgRepositoryListBox* _tmp29_ = NULL;
	GitgRepositoryListBoxRow* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (url != NULL);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (location != NULL);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data43_ = g_slice_new0 (Block43Data);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data43_->_ref_count_ = 1;
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data43_->self = g_object_ref (self);
#line 350 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = url;
#line 350 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = string_last_index_of_char (_tmp0_, (gunichar) '/', 0);
#line 350 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	pos = _tmp1_;
#line 352 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = pos;
#line 352 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp2_ == -1) {
#line 1701 "gitg-dash-view.c"
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 354 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = url;
#line 354 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp4_ = string_last_index_of_char (_tmp3_, (gunichar) ':', 0);
#line 354 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		pos = _tmp4_;
#line 1710 "gitg-dash-view.c"
	}
#line 357 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = g_strdup (".git");
#line 357 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	dot_git_suffix = _tmp5_;
#line 358 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = url;
#line 358 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = pos;
#line 358 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp8_ = string_substring (_tmp6_, (glong) (_tmp7_ + 1), (glong) -1);
#line 358 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	subfolder_name = _tmp8_;
#line 359 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp9_ = subfolder_name;
#line 359 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp10_ = dot_git_suffix;
#line 359 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = g_str_has_suffix (_tmp9_, _tmp10_);
#line 359 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	has_dot_git = _tmp11_;
#line 361 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp13_ = has_dot_git;
#line 361 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp13_) {
#line 1736 "gitg-dash-view.c"
		gboolean _tmp14_ = FALSE;
#line 361 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp14_ = is_bare;
#line 361 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp12_ = !_tmp14_;
#line 1742 "gitg-dash-view.c"
	} else {
#line 361 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp12_ = FALSE;
#line 1746 "gitg-dash-view.c"
	}
#line 361 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp12_) {
#line 1750 "gitg-dash-view.c"
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
#line 363 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp15_ = subfolder_name;
#line 363 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp16_ = dot_git_suffix;
#line 363 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp17_ = strlen (_tmp16_);
#line 363 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp18_ = _tmp17_;
#line 363 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp19_ = string_slice (_tmp15_, (glong) 0, (glong) (-_tmp18_));
#line 363 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_free0 (subfolder_name);
#line 363 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		subfolder_name = _tmp19_;
#line 1770 "gitg-dash-view.c"
	} else {
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
#line 365 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp21_ = has_dot_git;
#line 365 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (!_tmp21_) {
#line 1778 "gitg-dash-view.c"
			gboolean _tmp22_ = FALSE;
#line 365 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp22_ = is_bare;
#line 365 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp20_ = _tmp22_;
#line 1784 "gitg-dash-view.c"
		} else {
#line 365 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp20_ = FALSE;
#line 1788 "gitg-dash-view.c"
		}
#line 365 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_tmp20_) {
#line 1792 "gitg-dash-view.c"
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 367 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp23_ = subfolder_name;
#line 367 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp24_ = dot_git_suffix;
#line 367 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
#line 367 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_free0 (subfolder_name);
#line 367 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			subfolder_name = _tmp25_;
#line 1806 "gitg-dash-view.c"
		}
	}
#line 370 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp26_ = location;
#line 370 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp27_ = subfolder_name;
#line 370 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp28_ = g_file_resolve_relative_path (_tmp26_, _tmp27_);
#line 370 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	subfolder = _tmp28_;
#line 373 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp29_ = self->priv->d_repository_list_box;
#line 373 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp30_ = gitg_repository_list_box_begin_cloning (_tmp29_, subfolder);
#line 373 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data43_->row = _tmp30_;
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp31_ = url;
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp32_ = is_bare;
#line 375 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_clone (self, _data43_->row, _tmp31_, subfolder, _tmp32_, ___lambda101__gasync_ready_callback, block43_data_ref (_data43_));
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (subfolder);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (subfolder_name);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (dot_git_suffix);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block43_data_unref (_data43_);
#line 347 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data43_ = NULL;
#line 1839 "gitg-dash-view.c"
}


static void gitg_dash_view_finish_add_repository (GitgDashView* self, GitgRepository* repo) {
	GitgRepositoryListBoxRow* row = NULL;
	GitgRepository* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GitgRepositoryListBoxRow* _tmp2_ = NULL;
#line 391 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 391 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (repo != NULL);
#line 393 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = repo;
#line 393 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = gitg_dash_view_add_repository (self, _tmp0_);
#line 393 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	row = _tmp1_;
#line 395 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = row;
#line 395 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp2_ != NULL) {
#line 1862 "gitg-dash-view.c"
		GitgRepositoryListBoxRow* _tmp3_ = NULL;
		GitgRepositoryListBox* _tmp4_ = NULL;
		GitgRepositoryListBoxRow* _tmp5_ = NULL;
#line 397 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = row;
#line 397 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
#line 398 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp4_ = self->priv->d_repository_list_box;
#line 398 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
#line 399 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp5_ = row;
#line 399 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
#line 1878 "gitg-dash-view.c"
	}
#line 391 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (row);
#line 1882 "gitg-dash-view.c"
}


static void gitg_dash_view_do_add_repository (GitgDashView* self, GFile* location, gboolean report_errors) {
	GitgRepository* repo = NULL;
	GitgRepository* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 403 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 403 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (location != NULL);
#line 1894 "gitg-dash-view.c"
	{
		GitgRepository* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GitgRepository* _tmp2_ = NULL;
		GitgRepository* _tmp3_ = NULL;
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp1_ = location;
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp2_ = gitg_repository_new (_tmp1_, NULL, &_inner_error_);
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp0_ = _tmp2_;
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1908 "gitg-dash-view.c"
			goto __catch74_g_error;
		}
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = _tmp0_;
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp0_ = NULL;
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (repo);
#line 409 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		repo = _tmp3_;
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp0_);
#line 1921 "gitg-dash-view.c"
	}
	goto __finally74;
	__catch74_g_error:
	{
		GError* err = NULL;
		gboolean _tmp4_ = FALSE;
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		err = _inner_error_;
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_inner_error_ = NULL;
#line 413 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp4_ = report_errors;
#line 413 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_tmp4_) {
#line 1936 "gitg-dash-view.c"
			GitgExtApplication* _tmp5_ = NULL;
			GitgExtApplication* _tmp6_ = NULL;
			GitgExtApplication* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp5_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp6_ = _tmp5_;
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp7_ = _tmp6_;
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp8_ = _ ("Failed to add repository");
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp9_ = err;
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp10_ = _tmp9_->message;
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_ext_application_show_infobar (_tmp7_, _tmp8_, _tmp10_, GTK_MESSAGE_ERROR);
#line 415 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (_tmp7_);
#line 1959 "gitg-dash-view.c"
		}
#line 418 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_error_free0 (err);
#line 418 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (repo);
#line 418 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return;
#line 1967 "gitg-dash-view.c"
	}
	__finally74:
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (repo);
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_clear_error (&_inner_error_);
#line 407 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return;
#line 1980 "gitg-dash-view.c"
	}
#line 421 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = repo;
#line 421 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_finish_add_repository (self, _tmp11_);
#line 403 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (repo);
#line 1988 "gitg-dash-view.c"
}


static Block44Data* block44_data_ref (Block44Data* _data44_) {
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_atomic_int_inc (&_data44_->_ref_count_);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return _data44_;
#line 1997 "gitg-dash-view.c"
}


static void block44_data_unref (void * _userdata_) {
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
#line 2006 "gitg-dash-view.c"
		GitgDashView* self;
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		self = _data44_->self;
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data44_->location);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (self);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_slice_free (Block44Data, _data44_);
#line 2016 "gitg-dash-view.c"
	}
}


static gboolean __lambda102_ (Block44Data* _data44_, GitgExtUserQuery* w, GtkResponseType r) {
	GitgDashView* self;
	gboolean result = FALSE;
	GtkResponseType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 445 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data44_->self;
#line 445 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (w != NULL, FALSE);
#line 446 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = r;
#line 446 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp0_ == GTK_RESPONSE_OK) {
#line 2034 "gitg-dash-view.c"
		GitgRepository* repo = NULL;
		GitgRepository* _tmp11_ = NULL;
		{
			GitgRepository* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			GitgRepository* _tmp3_ = NULL;
			GitgRepository* _tmp4_ = NULL;
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp2_ = _data44_->location;
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp3_ = gitg_repository_init_repository (_tmp2_, FALSE, &_inner_error_);
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp1_ = _tmp3_;
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2050 "gitg-dash-view.c"
				goto __catch75_g_error;
			}
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp4_ = _tmp1_;
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp1_ = NULL;
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (repo);
#line 452 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			repo = _tmp4_;
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (_tmp1_);
#line 2063 "gitg-dash-view.c"
		}
		goto __finally75;
		__catch75_g_error:
		{
			GError* err = NULL;
			GitgExtApplication* _tmp5_ = NULL;
			GitgExtApplication* _tmp6_ = NULL;
			GitgExtApplication* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			err = _inner_error_;
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_inner_error_ = NULL;
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp5_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp6_ = _tmp5_;
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp7_ = _tmp6_;
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp8_ = _ ("Failed to create repository");
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp9_ = err;
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp10_ = _tmp9_->message;
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_ext_application_show_infobar (_tmp7_, _tmp8_, _tmp10_, GTK_MESSAGE_ERROR);
#line 456 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (_tmp7_);
#line 457 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			result = TRUE;
#line 457 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_error_free0 (err);
#line 457 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (repo);
#line 457 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			return result;
#line 2103 "gitg-dash-view.c"
		}
		__finally75:
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_g_object_unref0 (repo);
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_clear_error (&_inner_error_);
#line 450 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			return FALSE;
#line 2116 "gitg-dash-view.c"
		}
#line 460 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp11_ = repo;
#line 460 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_finish_add_repository (self, _tmp11_);
#line 446 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (repo);
#line 2124 "gitg-dash-view.c"
	}
#line 463 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = TRUE;
#line 463 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 2130 "gitg-dash-view.c"
}


static gboolean ___lambda102__gitg_ext_user_query_response (GitgExtUserQuery* _sender, GtkResponseType response_type, gpointer self) {
	gboolean result;
	result = __lambda102_ (self, _sender, response_type);
#line 445 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 2139 "gitg-dash-view.c"
}


static void gitg_dash_view_query_create_repository (GitgDashView* self, GFile* location) {
	Block44Data* _data44_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GitgExtUserQuery* q = NULL;
	GitgExtUserQuery* _tmp2_ = NULL;
	gchar* name = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GitgExtUserQueryResponse* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GitgExtUserQueryResponse* _tmp15_ = NULL;
	GitgExtUserQueryResponse** _tmp16_ = NULL;
	GitgExtUserQueryResponse** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GitgExtApplication* _tmp18_ = NULL;
	GitgExtApplication* _tmp19_ = NULL;
	GitgExtApplication* _tmp20_ = NULL;
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (location != NULL);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data44_ = g_slice_new0 (Block44Data);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data44_->_ref_count_ = 1;
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data44_->self = g_object_ref (self);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = location;
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data44_->location);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data44_->location = _tmp1_;
#line 426 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = gitg_ext_user_query_new ();
#line 426 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	q = _tmp2_;
#line 427 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = _data44_->location;
#line 427 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = gitg_utils_replace_home_dir_with_tilde (_tmp3_);
#line 427 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	name = _tmp4_;
#line 429 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = name;
#line 429 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = g_markup_escape_text (_tmp5_, (gssize) -1);
#line 429 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (name);
#line 429 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	name = _tmp6_;
#line 431 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = _ ("Create new repository");
#line 431 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_user_query_set_title (q, _tmp7_);
#line 434 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp8_ = _ ("The location <i>%s</i> does not appear to be a valid git repository. W" \
"ould you like to initialize a new git repository at this location?");
#line 434 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp9_ = name;
#line 434 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_);
#line 434 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = _tmp10_;
#line 434 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_user_query_set_message (q, _tmp11_);
#line 434 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_tmp11_);
#line 435 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_user_query_set_message_type (q, GTK_MESSAGE_QUESTION);
#line 436 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_user_query_set_message_use_markup (q, TRUE);
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp12_ = _ ("_Cancel");
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp13_ = gitg_ext_user_query_response_new (_tmp12_, GTK_RESPONSE_CANCEL);
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp14_ = _ ("Create repository");
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp15_ = gitg_ext_user_query_response_new (_tmp14_, GTK_RESPONSE_OK);
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp16_ = g_new0 (GitgExtUserQueryResponse*, 2 + 1);
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp16_[0] = _tmp13_;
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp16_[1] = _tmp15_;
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp17_ = _tmp16_;
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp17__length1 = 2;
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_user_query_set_responses (q, _tmp17_, 2);
#line 438 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_object_unref), NULL);
#line 443 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_user_query_set_default_response (q, GTK_RESPONSE_OK);
#line 445 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_data (q, "response", (GCallback) ___lambda102__gitg_ext_user_query_response, block44_data_ref (_data44_), (GClosureNotify) block44_data_unref, 0);
#line 466 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp18_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 466 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp19_ = _tmp18_;
#line 466 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp20_ = _tmp19_;
#line 466 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_application_user_query (_tmp20_, q);
#line 466 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp20_);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (name);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (q);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block44_data_unref (_data44_);
#line 424 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data44_ = NULL;
#line 2269 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_looks_like_git (GitgDashView* self, GFile* location) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
#line 469 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 469 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (location != NULL, FALSE);
#line 471 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = location;
#line 471 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = g_file_get_child (_tmp0_, ".git");
#line 471 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _tmp1_;
#line 471 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 471 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = _tmp3_;
#line 471 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp2_);
#line 471 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp4_) {
#line 473 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		result = TRUE;
#line 473 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return result;
#line 2309 "gitg-dash-view.c"
	}
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = location;
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp8_ = g_file_get_child (_tmp7_, "objects");
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp9_ = _tmp8_;
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp10_ = g_file_query_exists (_tmp9_, NULL);
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = _tmp10_;
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp9_);
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp11_) {
#line 2325 "gitg-dash-view.c"
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 478 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp12_ = location;
#line 478 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp13_ = g_file_get_child (_tmp12_, "HEAD");
#line 478 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp14_ = _tmp13_;
#line 478 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp15_ = g_file_query_exists (_tmp14_, NULL);
#line 478 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp6_ = _tmp15_;
#line 478 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp14_);
#line 2342 "gitg-dash-view.c"
	} else {
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp6_ = FALSE;
#line 2346 "gitg-dash-view.c"
	}
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp6_) {
#line 2350 "gitg-dash-view.c"
		GFile* _tmp16_ = NULL;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 479 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp16_ = location;
#line 479 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp17_ = g_file_get_child (_tmp16_, "refs");
#line 479 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp18_ = _tmp17_;
#line 479 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp19_ = g_file_query_exists (_tmp18_, NULL);
#line 479 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp5_ = _tmp19_;
#line 479 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp18_);
#line 2367 "gitg-dash-view.c"
	} else {
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp5_ = FALSE;
#line 2371 "gitg-dash-view.c"
	}
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp5_;
#line 477 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 2377 "gitg-dash-view.c"
}


static void gitg_dash_view_file_exists_async_data_free (gpointer _data) {
	GitgDashViewFileExistsAsyncData* _data_;
	_data_ = _data;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->file);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_slice_free (GitgDashViewFileExistsAsyncData, _data_);
#line 2392 "gitg-dash-view.c"
}


static void gitg_dash_view_file_exists_async (GitgDashView* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgDashViewFileExistsAsyncData* _data_;
	GitgDashView* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = g_slice_new0 (GitgDashViewFileExistsAsyncData);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_dash_view_file_exists_async);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_dash_view_file_exists_async_data_free);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->self = _tmp0_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = file;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->file);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->file = _tmp2_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = cancellable;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->cancellable = _tmp4_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_file_exists_async_co (_data_);
#line 2431 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_file_exists_finish (GitgDashView* self, GAsyncResult* _res_) {
	gboolean result;
	GitgDashViewFileExistsAsyncData* _data_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _data_->result;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 2444 "gitg-dash-view.c"
}


static void gitg_dash_view_file_exists_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgDashViewFileExistsAsyncData* _data_;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = _user_data_;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_source_object_ = source_object;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_res_ = _res_;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_file_exists_async_co (_data_);
#line 2458 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_file_exists_async_co (GitgDashViewFileExistsAsyncData* _data_) {
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	switch (_data_->_state_) {
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 0:
#line 2467 "gitg-dash-view.c"
		goto _state_0;
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 1:
#line 2471 "gitg-dash-view.c"
		goto _state_1;
		default:
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_assert_not_reached ();
#line 2476 "gitg-dash-view.c"
	}
	_state_0:
	{
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp1_ = NULL;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp1_ = _data_->file;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp2_ = NULL;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp2_ = _data_->cancellable;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_state_ = 1;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_file_query_info_async (_data_->_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp2_, gitg_dash_view_file_exists_async_ready, _data_);
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2494 "gitg-dash-view.c"
		_state_1:
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp3_ = NULL;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp3_ = g_file_query_info_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp0_ = _data_->_tmp3_;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 2504 "gitg-dash-view.c"
			goto __catch76_g_error;
		}
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp4_ = NULL;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp4_ = _data_->_tmp0_;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp0_ = NULL;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp5_ = NULL;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp6_ = FALSE;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp6_ = _data_->_tmp5_ != NULL;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data_->_tmp5_);
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->result = _data_->_tmp6_;
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data_->_tmp0_);
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_data_->_state_ == 0) {
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2531 "gitg-dash-view.c"
		} else {
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2535 "gitg-dash-view.c"
		}
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_object_unref (_data_->_async_result);
#line 486 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2541 "gitg-dash-view.c"
	}
	goto __finally76;
	__catch76_g_error:
	{
#line 484 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_clear_error (&_data_->_inner_error_);
#line 484 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_inner_error_ = NULL;
#line 490 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->result = FALSE;
#line 490 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_data_->_state_ == 0) {
#line 490 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2556 "gitg-dash-view.c"
		} else {
#line 490 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2560 "gitg-dash-view.c"
		}
#line 490 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_object_unref (_data_->_async_result);
#line 490 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2566 "gitg-dash-view.c"
	}
	__finally76:
#line 484 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 484 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_clear_error (&_data_->_inner_error_);
#line 484 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_state_ == 0) {
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2579 "gitg-dash-view.c"
	} else {
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2583 "gitg-dash-view.c"
	}
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_unref (_data_->_async_result);
#line 482 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 2589 "gitg-dash-view.c"
}


static void gitg_dash_view_real_scan_visit_directory_data_free (gpointer _data) {
	GitgDashViewScanVisitDirectoryData* _data_;
	_data_ = _data;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->file);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_slice_free (GitgDashViewScanVisitDirectoryData, _data_);
#line 2604 "gitg-dash-view.c"
}


static void gitg_dash_view_real_scan_visit_directory (GitgRecursiveScanner* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgDashView * self;
	GitgDashViewScanVisitDirectoryData* _data_;
	GitgDashView* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = g_slice_new0 (GitgDashViewScanVisitDirectoryData);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_dash_view_real_scan_visit_directory);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_dash_view_real_scan_visit_directory_data_free);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->self = _tmp0_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = file;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->file);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->file = _tmp2_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = cancellable;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->cancellable);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->cancellable = _tmp4_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_real_scan_visit_directory_co (_data_);
#line 2646 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_real_scan_visit_directory_finish (GitgRecursiveScanner* base, GAsyncResult* _res_) {
	gboolean result;
	GitgDashViewScanVisitDirectoryData* _data_;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _data_->result;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 2659 "gitg-dash-view.c"
}


static void gitg_dash_view_scan_visit_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgDashViewScanVisitDirectoryData* _data_;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_ = _user_data_;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_source_object_ = source_object;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_res_ = _res_;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_real_scan_visit_directory_co (_data_);
#line 2673 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_real_scan_visit_directory_co (GitgDashViewScanVisitDirectoryData* _data_) {
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	switch (_data_->_state_) {
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 0:
#line 2682 "gitg-dash-view.c"
		goto _state_0;
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 1:
#line 2686 "gitg-dash-view.c"
		goto _state_1;
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 2:
#line 2690 "gitg-dash-view.c"
		goto _state_2;
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 3:
#line 2694 "gitg-dash-view.c"
		goto _state_3;
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case 4:
#line 2698 "gitg-dash-view.c"
		goto _state_4;
		default:
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_assert_not_reached ();
#line 2703 "gitg-dash-view.c"
	}
	_state_0:
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp1_ = NULL;
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_tmp1_ != NULL) {
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp2_ = NULL;
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp2_ = _data_->cancellable;
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp3_ = FALSE;
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp3_ = g_cancellable_is_cancelled (_data_->_tmp2_);
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp0_ = _data_->_tmp3_;
#line 2722 "gitg-dash-view.c"
	} else {
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp0_ = FALSE;
#line 2726 "gitg-dash-view.c"
	}
#line 496 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_tmp0_) {
#line 498 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->result = FALSE;
#line 498 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_data_->_state_ == 0) {
#line 498 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2736 "gitg-dash-view.c"
		} else {
#line 498 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2740 "gitg-dash-view.c"
		}
#line 498 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_object_unref (_data_->_async_result);
#line 498 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2746 "gitg-dash-view.c"
	}
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp4_ = NULL;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp4_ = _data_->file;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp5_ = NULL;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp5_ = g_file_get_child (_data_->_tmp4_, ".git");
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp6_ = NULL;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp7_ = NULL;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp7_ = _data_->cancellable;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_state_ = 1;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp6_, _data_->_tmp7_, gitg_dash_view_scan_visit_directory_ready, _data_);
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 2770 "gitg-dash-view.c"
	_state_1:
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp8_ = FALSE;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp8_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp9_ = FALSE;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 502 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_tmp9_) {
#line 504 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp10_ = NULL;
#line 504 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp10_ = _data_->file;
#line 504 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_do_add_repository (_data_->self, _data_->_tmp10_, FALSE);
#line 505 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->result = FALSE;
#line 505 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_data_->_state_ == 0) {
#line 505 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2796 "gitg-dash-view.c"
		} else {
#line 505 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2800 "gitg-dash-view.c"
		}
#line 505 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_object_unref (_data_->_async_result);
#line 505 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2806 "gitg-dash-view.c"
	}
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp13_ = NULL;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp13_ = _data_->file;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp14_ = NULL;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp14_ = g_file_get_child (_data_->_tmp13_, "objects");
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp15_ = NULL;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp16_ = NULL;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp16_ = _data_->cancellable;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_state_ = 2;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp15_, _data_->_tmp16_, gitg_dash_view_scan_visit_directory_ready, _data_);
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 2830 "gitg-dash-view.c"
	_state_2:
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp17_ = FALSE;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp17_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp18_ = FALSE;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp18_ = _data_->_tmp17_;
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_data_->_tmp15_);
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_tmp18_) {
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp19_ = NULL;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp19_ = _data_->file;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp20_ = NULL;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp20_ = g_file_get_child (_data_->_tmp19_, "HEAD");
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp21_ = NULL;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp21_ = _data_->_tmp20_;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp22_ = NULL;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp22_ = _data_->cancellable;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_state_ = 3;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp21_, _data_->_tmp22_, gitg_dash_view_scan_visit_directory_ready, _data_);
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2866 "gitg-dash-view.c"
		_state_3:
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp23_ = FALSE;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp23_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp12_ = _data_->_tmp23_;
#line 510 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data_->_tmp21_);
#line 2876 "gitg-dash-view.c"
	} else {
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp12_ = FALSE;
#line 2880 "gitg-dash-view.c"
	}
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_tmp12_) {
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp24_ = NULL;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp24_ = _data_->file;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp25_ = NULL;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp25_ = g_file_get_child (_data_->_tmp24_, "refs");
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp26_ = NULL;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp27_ = NULL;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp27_ = _data_->cancellable;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_state_ = 4;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_file_exists_async (_data_->self, _data_->_tmp26_, _data_->_tmp27_, gitg_dash_view_scan_visit_directory_ready, _data_);
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2906 "gitg-dash-view.c"
		_state_4:
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp28_ = FALSE;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp28_ = gitg_dash_view_file_exists_finish (_data_->self, _data_->_res_);
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp11_ = _data_->_tmp28_;
#line 511 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data_->_tmp26_);
#line 2916 "gitg-dash-view.c"
	} else {
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp11_ = FALSE;
#line 2920 "gitg-dash-view.c"
	}
#line 509 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_tmp11_) {
#line 513 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp29_ = NULL;
#line 513 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->_tmp29_ = _data_->file;
#line 513 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_do_add_repository (_data_->self, _data_->_tmp29_, FALSE);
#line 514 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data_->result = FALSE;
#line 514 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (_data_->_state_ == 0) {
#line 514 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2936 "gitg-dash-view.c"
		} else {
#line 514 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2940 "gitg-dash-view.c"
		}
#line 514 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_object_unref (_data_->_async_result);
#line 514 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return FALSE;
#line 2946 "gitg-dash-view.c"
	}
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp30_ = NULL;
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp30_ = _data_->file;
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp31_ = FALSE;
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->_tmp31_ = gitg_recursive_scanner_scan_visit_directory_default ((GitgRecursiveScanner*) _data_->self, _data_->_tmp30_);
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data_->result = _data_->_tmp31_;
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_state_ == 0) {
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2962 "gitg-dash-view.c"
	} else {
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2966 "gitg-dash-view.c"
	}
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_unref (_data_->_async_result);
#line 517 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_data_->_state_ == 0) {
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2976 "gitg-dash-view.c"
	} else {
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2980 "gitg-dash-view.c"
	}
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_unref (_data_->_async_result);
#line 494 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return FALSE;
#line 2986 "gitg-dash-view.c"
}


static Block45Data* block45_data_ref (Block45Data* _data45_) {
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_atomic_int_inc (&_data45_->_ref_count_);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return _data45_;
#line 2995 "gitg-dash-view.c"
}


static void block45_data_unref (void * _userdata_) {
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
#line 3004 "gitg-dash-view.c"
		GitgDashView* self;
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		self = _data45_->self;
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data45_->cancellable);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_data45_->dlg);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (self);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_slice_free (Block45Data, _data45_);
#line 3016 "gitg-dash-view.c"
	}
}


static void __lambda95_ (Block45Data* _data45_) {
	GitgDashView* self;
#line 533 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data45_->self;
#line 534 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_cancellable_cancel (_data45_->cancellable);
#line 3027 "gitg-dash-view.c"
}


static void ___lambda95__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 533 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	__lambda95_ (self);
#line 3034 "gitg-dash-view.c"
}


static gboolean __lambda96_ (Block45Data* _data45_) {
	GitgDashView* self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
#line 539 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data45_->self;
#line 540 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = _data45_->timeout_id;
#line 540 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 542 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gtk_widget_destroy ((GtkWidget*) _data45_->dlg);
#line 3050 "gitg-dash-view.c"
	}
#line 545 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_->timeout_id = (guint) 0;
#line 546 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = FALSE;
#line 546 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3058 "gitg-dash-view.c"
}


static gboolean ___lambda96__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda96_ (self);
#line 539 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3067 "gitg-dash-view.c"
}


static void __lambda97_ (Block45Data* _data45_) {
	GitgDashView* self;
	guint _tmp0_ = 0U;
#line 549 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data45_->self;
#line 550 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = _data45_->timeout_id;
#line 550 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 552 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_data45_->timeout_id = (guint) 0;
#line 3082 "gitg-dash-view.c"
	} else {
#line 556 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gtk_widget_destroy ((GtkWidget*) _data45_->dlg);
#line 3086 "gitg-dash-view.c"
	}
}


static void ___lambda97__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 549 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	__lambda97_ (self);
#line 549 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block45_data_unref (self);
#line 3096 "gitg-dash-view.c"
}


static void gitg_dash_view_add_repositories_scan (GitgDashView* self, GFile* location) {
	Block45Data* _data45_;
	GitgExtApplication* _tmp0_ = NULL;
	GitgExtApplication* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	GCancellable* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	GFile* _tmp12_ = NULL;
	GdkWindow* _tmp13_ = NULL;
	GdkDisplay* _tmp14_ = NULL;
	GdkCursor* _tmp15_ = NULL;
	GdkCursor* _tmp16_ = NULL;
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (location != NULL);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_ = g_slice_new0 (Block45Data);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_->_ref_count_ = 1;
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_->self = g_object_ref (self);
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _tmp0_;
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL;
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp2_ == NULL) {
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (_tmp1_);
#line 3139 "gitg-dash-view.c"
	}
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = _tmp2_;
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = _ ("Scanning for repositories in %s");
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = location;
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = gitg_utils_replace_home_dir_with_tilde (_tmp5_);
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = _tmp6_;
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CANCEL, _tmp4_, _tmp7_);
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_ref_sink (_tmp8_);
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp9_ = _tmp8_;
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_tmp7_);
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp3_);
#line 522 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_->dlg = _tmp9_;
#line 529 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_dialog_set_default_response ((GtkDialog*) _data45_->dlg, (gint) GTK_RESPONSE_CANCEL);
#line 531 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp10_ = g_cancellable_new ();
#line 531 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_->cancellable = _tmp10_;
#line 533 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_data ((GtkDialog*) _data45_->dlg, "response", (GCallback) ___lambda95__gtk_dialog_response, block45_data_ref (_data45_), (GClosureNotify) block45_data_unref, 0);
#line 537 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_->timeout_id = (guint) 0;
#line 539 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda96__gsource_func, block45_data_ref (_data45_), block45_data_unref);
#line 539 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_->timeout_id = _tmp11_;
#line 549 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp12_ = location;
#line 549 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_recursive_scanner_scan ((GitgRecursiveScanner*) self, _tmp12_, _data45_->cancellable, ___lambda97__gasync_ready_callback, block45_data_ref (_data45_));
#line 560 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_show ((GtkWidget*) _data45_->dlg);
#line 561 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp13_ = gtk_widget_get_window ((GtkWidget*) _data45_->dlg);
#line 561 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp14_ = gtk_widget_get_display ((GtkWidget*) self);
#line 561 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp15_ = gdk_cursor_new_for_display (_tmp14_, GDK_WATCH);
#line 561 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp16_ = _tmp15_;
#line 561 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gdk_window_set_cursor (_tmp13_, _tmp16_);
#line 561 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp16_);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block45_data_unref (_data45_);
#line 520 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data45_ = NULL;
#line 3199 "gitg-dash-view.c"
}


void gitg_dash_view_add_repository_from_location (GitgDashView* self, GFile* location, gboolean scan_all) {
	gboolean _tmp0_ = FALSE;
#line 564 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (self != NULL);
#line 564 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (location != NULL);
#line 566 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = scan_all;
#line 566 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp0_) {
#line 3213 "gitg-dash-view.c"
		GFile* _tmp1_ = NULL;
#line 568 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp1_ = location;
#line 568 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_add_repositories_scan (self, _tmp1_);
#line 3219 "gitg-dash-view.c"
	} else {
		GFile* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 570 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp2_ = location;
#line 570 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = gitg_dash_view_looks_like_git (self, _tmp2_);
#line 570 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		if (!_tmp3_) {
#line 3229 "gitg-dash-view.c"
			GFile* _tmp4_ = NULL;
#line 572 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp4_ = location;
#line 572 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_dash_view_query_create_repository (self, _tmp4_);
#line 3235 "gitg-dash-view.c"
		} else {
			GFile* _tmp5_ = NULL;
#line 576 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp5_ = location;
#line 576 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_dash_view_do_add_repository (self, _tmp5_, TRUE);
#line 3242 "gitg-dash-view.c"
		}
	}
}


GitgDashView* gitg_dash_view_construct (GType object_type) {
	GitgDashView * self = NULL;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) g_object_new (object_type, NULL);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return self;
#line 3254 "gitg-dash-view.c"
}


GitgDashView* gitg_dash_view_new (void) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return gitg_dash_view_construct (GITG_TYPE_DASH_VIEW);
#line 3261 "gitg-dash-view.c"
}


static GitgExtApplication* gitg_dash_view_real_get_application (GitgExtUIElement* base) {
	GitgExtApplication* result;
	GitgDashView* self;
	GitgExtApplication* _tmp0_ = NULL;
	GitgExtApplication* _tmp1_ = NULL;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->_application;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp1_;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3280 "gitg-dash-view.c"
}


static void gitg_dash_view_real_set_application (GitgExtUIElement* base, GitgExtApplication* value) {
	GitgDashView* self;
	GitgExtApplication* _tmp0_ = NULL;
	GitgExtApplication* _tmp1_ = NULL;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = value;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->_application);
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv->_application = _tmp1_;
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject *) self, "application");
#line 3300 "gitg-dash-view.c"
}


static GitgExtSelectionMode gitg_dash_view_real_get_selectable_mode (GitgExtSelectable* base) {
	GitgExtSelectionMode result;
	GitgDashView* self;
	GitgRepositoryListBox* _tmp0_ = NULL;
	GitgSelectionMode _tmp1_ = 0;
	GitgSelectionMode _tmp2_ = 0;
#line 49 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 51 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_repository_list_box;
#line 51 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = gitg_repository_list_box_get_mode (_tmp0_);
#line 51 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _tmp1_;
#line 51 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	switch (_tmp2_) {
#line 51 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_SELECTION_MODE_NORMAL:
#line 3322 "gitg-dash-view.c"
		{
#line 54 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			result = GITG_EXT_SELECTION_MODE_NORMAL;
#line 54 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			return result;
#line 3328 "gitg-dash-view.c"
		}
#line 51 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_SELECTION_MODE_SELECTION:
#line 3332 "gitg-dash-view.c"
		{
#line 56 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			result = GITG_EXT_SELECTION_MODE_SELECTION;
#line 56 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			return result;
#line 3338 "gitg-dash-view.c"
		}
		default:
#line 51 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 3343 "gitg-dash-view.c"
	}
#line 59 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = GITG_EXT_SELECTION_MODE_NORMAL;
#line 59 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3349 "gitg-dash-view.c"
}


static void gitg_dash_view_real_set_selectable_mode (GitgExtSelectable* base, GitgExtSelectionMode value) {
	GitgDashView* self;
	GitgExtSelectionMode _tmp0_ = 0;
	GitgExtSelectionMode _tmp1_ = 0;
	GitgExtSelectionMode _tmp2_ = 0;
	GitgExtSelectionMode _tmp3_ = 0;
#line 62 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 64 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = gitg_ext_selectable_get_selectable_mode ((GitgExtSelectable*) self);
#line 64 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _tmp0_;
#line 64 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = value;
#line 64 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (_tmp1_ == _tmp2_) {
#line 66 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return;
#line 3371 "gitg-dash-view.c"
	}
#line 69 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv->d_setting_mode = TRUE;
#line 71 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = value;
#line 71 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	switch (_tmp3_) {
#line 71 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_EXT_SELECTION_MODE_NORMAL:
#line 3381 "gitg-dash-view.c"
		{
			GitgRepositoryListBox* _tmp4_ = NULL;
#line 74 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp4_ = self->priv->d_repository_list_box;
#line 74 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_repository_list_box_set_mode (_tmp4_, GITG_SELECTION_MODE_NORMAL);
#line 75 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			break;
#line 3390 "gitg-dash-view.c"
		}
#line 71 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_EXT_SELECTION_MODE_SELECTION:
#line 3394 "gitg-dash-view.c"
		{
			GitgRepositoryListBox* _tmp5_ = NULL;
#line 77 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp5_ = self->priv->d_repository_list_box;
#line 77 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			gitg_repository_list_box_set_mode (_tmp5_, GITG_SELECTION_MODE_SELECTION);
#line 78 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			break;
#line 3403 "gitg-dash-view.c"
		}
		default:
#line 71 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 3408 "gitg-dash-view.c"
	}
#line 81 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv->d_setting_mode = FALSE;
#line 62 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject *) self, "selectable-mode");
#line 3414 "gitg-dash-view.c"
}


gboolean gitg_dash_view_get_has_repositories (GitgDashView* self) {
	gboolean result;
	GitgRepositoryListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_repository_list_box;
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _tmp1_;
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = g_list_length (_tmp2_);
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = _tmp3_ != ((guint) 0);
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_list_free0 (_tmp2_);
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp4_;
#line 87 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3443 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_real_get_selectable_available (GitgExtSelectable* base) {
	gboolean result;
	GitgDashView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 92 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 92 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = gitg_dash_view_get_has_repositories (self);
#line 92 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _tmp0_;
#line 92 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp1_;
#line 92 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3462 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_real_get_search_available (GitgExtSearchable* base) {
	gboolean result;
	GitgDashView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 97 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 97 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = gitg_dash_view_get_has_repositories (self);
#line 97 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _tmp0_;
#line 97 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp1_;
#line 97 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3481 "gitg-dash-view.c"
}


static gchar* gitg_dash_view_real_get_display_name (GitgExtUIElement* base) {
	gchar* result;
	GitgDashView* self;
	gchar* _tmp0_ = NULL;
#line 102 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 102 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = g_strdup ("Dash");
#line 102 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp0_;
#line 102 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3497 "gitg-dash-view.c"
}


static gchar* gitg_dash_view_real_get_description (GitgExtUIElement* base) {
	gchar* result;
	GitgDashView* self;
	gchar* _tmp0_ = NULL;
#line 107 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 107 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = g_strdup ("Dash view");
#line 107 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp0_;
#line 107 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3513 "gitg-dash-view.c"
}


static gchar* gitg_dash_view_real_get_id (GitgExtUIElement* base) {
	gchar* result;
	GitgDashView* self;
	gchar* _tmp0_ = NULL;
#line 112 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 112 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = g_strdup ("/org/gnome/gitg/dash");
#line 112 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp0_;
#line 112 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3529 "gitg-dash-view.c"
}


static GtkWidget* gitg_dash_view_real_get_widget (GitgExtUIElement* base) {
	GtkWidget* result;
	GitgDashView* self;
	GtkWidget* _tmp0_ = NULL;
#line 117 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 117 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = _g_object_ref0 ((GtkWidget*) self);
#line 117 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp0_;
#line 117 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3545 "gitg-dash-view.c"
}


static gchar* gitg_dash_view_real_get_icon (GitgExtUIElement* base) {
	gchar* result;
	GitgDashView* self;
#line 122 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 122 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = NULL;
#line 122 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3558 "gitg-dash-view.c"
}


static gchar* gitg_dash_view_real_get_search_text (GitgExtSearchable* base) {
	gchar* result;
	GitgDashView* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 129 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 129 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_search_text;
#line 129 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 129 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp1_;
#line 129 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3577 "gitg-dash-view.c"
}


static void gitg_dash_view_real_set_search_text (GitgExtSearchable* base, const gchar* value) {
	GitgDashView* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 131 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 133 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_search_text;
#line 133 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = value;
#line 133 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
#line 3593 "gitg-dash-view.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 135 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp2_ = value;
#line 135 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 135 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_free0 (self->priv->d_search_text);
#line 135 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		self->priv->d_search_text = _tmp3_;
#line 136 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_dash_view_update_search_text (self);
#line 3606 "gitg-dash-view.c"
	}
#line 131 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject *) self, "search-text");
#line 3610 "gitg-dash-view.c"
}


static void gitg_dash_view_real_set_search_entry (GitgExtSearchable* base, GtkEntry* value) {
	GitgDashView* self;
#line 145 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 145 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject *) self, "search-entry");
#line 3620 "gitg-dash-view.c"
}


static gboolean gitg_dash_view_real_get_search_visible (GitgExtSearchable* base) {
	gboolean result;
	GitgDashView* self;
	gboolean _tmp0_ = FALSE;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->_search_visible;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp0_;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3636 "gitg-dash-view.c"
}


static void gitg_dash_view_real_set_search_visible (GitgExtSearchable* base, gboolean value) {
	GitgDashView* self;
	gboolean _tmp0_ = FALSE;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = value;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv->_search_visible = _tmp0_;
#line 148 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_notify ((GObject *) self, "search-visible");
#line 3651 "gitg-dash-view.c"
}


static void _gitg_dash_view_action_widget___lambda103_ (GitgDashView* self) {
	GitgRepositoryListBox* _tmp0_ = NULL;
	GitgRepositoryListBoxRow** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GitgRepositoryListBoxRow** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_repository_list_box;
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = gitg_repository_list_box_get_selection (_tmp0_, &_tmp1__length1);
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _tmp1_;
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2__length1 = _tmp1__length1;
#line 3669 "gitg-dash-view.c"
	{
		GitgRepositoryListBoxRow** sel_collection = NULL;
		gint sel_collection_length1 = 0;
		gint _sel_collection_size_ = 0;
		gint sel_it = 0;
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		sel_collection = _tmp2_;
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		sel_collection_length1 = _tmp2__length1;
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		for (sel_it = 0; sel_it < _tmp2__length1; sel_it = sel_it + 1) {
#line 3681 "gitg-dash-view.c"
			GitgRepositoryListBoxRow* _tmp3_ = NULL;
			GitgRepositoryListBoxRow* sel = NULL;
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			_tmp3_ = _g_object_ref0 (sel_collection[sel_it]);
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
			sel = _tmp3_;
#line 3688 "gitg-dash-view.c"
			{
				GitgRepositoryListBoxRow* _tmp4_ = NULL;
#line 180 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
				_tmp4_ = sel;
#line 180 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
				g_signal_emit_by_name (_tmp4_, "request-remove");
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
				_g_object_unref0 (sel);
#line 3697 "gitg-dash-view.c"
			}
		}
#line 178 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		sel_collection = (_vala_array_free (sel_collection, sel_collection_length1, (GDestroyNotify) g_object_unref), NULL);
#line 3702 "gitg-dash-view.c"
	}
#line 183 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_selectable_set_selectable_mode ((GitgExtSelectable*) self, GITG_EXT_SELECTION_MODE_NORMAL);
#line 3706 "gitg-dash-view.c"
}


static void __gitg_dash_view_action_widget___lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 177 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_dash_view_action_widget___lambda103_ ((GitgDashView*) self);
#line 3713 "gitg-dash-view.c"
}


static GtkWidget* gitg_dash_view_real_get_action_widget (GitgExtSelectable* base) {
	GtkWidget* result;
	GitgDashView* self;
	GtkActionBar* ab = NULL;
	GtkActionBar* _tmp0_ = NULL;
	GtkButton* remove_button = NULL;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GitgRepositoryListBox* _tmp4_ = NULL;
#line 167 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashView*) base;
#line 169 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = (GtkActionBar*) gtk_action_bar_new ();
#line 169 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_ref_sink (_tmp0_);
#line 169 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	ab = _tmp0_;
#line 171 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _ ("_Remove");
#line 171 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp1_);
#line 171 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_ref_sink (_tmp2_);
#line 171 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	remove_button = _tmp2_;
#line 172 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) remove_button);
#line 172 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
#line 174 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) remove_button, FALSE);
#line 175 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_show ((GtkWidget*) remove_button);
#line 177 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_object (remove_button, "clicked", (GCallback) __gitg_dash_view_action_widget___lambda103__gtk_button_clicked, self, 0);
#line 186 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = self->priv->d_repository_list_box;
#line 186 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_bind_property_with_closures ((GObject*) _tmp4_, "has-selection", (GObject*) remove_button, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 188 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_action_bar_pack_end (ab, (GtkWidget*) remove_button);
#line 190 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = (GtkWidget*) ab;
#line 190 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (remove_button);
#line 190 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 3765 "gitg-dash-view.c"
}


static Block46Data* block46_data_ref (Block46Data* _data46_) {
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_atomic_int_inc (&_data46_->_ref_count_);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return _data46_;
#line 3774 "gitg-dash-view.c"
}


static void block46_data_unref (void * _userdata_) {
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
#line 3783 "gitg-dash-view.c"
		GitgDashView* self;
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		self = _data46_->self;
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_gitg_when_mapped_unref0 (_data46_->whenMapped);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (self);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_slice_free (Block46Data, _data46_);
#line 3793 "gitg-dash-view.c"
	}
}


static void _gitg_dash_view___lambda104_ (GitgDashView* self) {
	gboolean _tmp0_ = FALSE;
#line 198 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_setting_mode;
#line 198 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (!_tmp0_) {
#line 200 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_object_notify ((GObject*) self, "selectable-mode");
#line 3806 "gitg-dash-view.c"
	}
}


static void __gitg_dash_view___lambda104__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 197 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_dash_view___lambda104_ ((GitgDashView*) self);
#line 3814 "gitg-dash-view.c"
}


static void _gitg_dash_view___lambda105_ (GitgDashView* self, GitgRepository* repository) {
	GitgExtApplication* _tmp0_ = NULL;
	GitgExtApplication* _tmp1_ = NULL;
	GitgExtApplication* _tmp2_ = NULL;
	GitgRepository* _tmp3_ = NULL;
#line 204 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (repository != NULL);
#line 205 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 205 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _tmp0_;
#line 205 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _tmp1_;
#line 205 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = repository;
#line 205 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_application_set_repository (_tmp2_, _tmp3_);
#line 205 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp2_);
#line 3837 "gitg-dash-view.c"
}


static void __gitg_dash_view___lambda105__gitg_repository_list_box_repository_activated (GitgRepositoryListBox* _sender, GitgRepository* repository, gpointer self) {
#line 204 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_dash_view___lambda105_ ((GitgDashView*) self, repository);
#line 3844 "gitg-dash-view.c"
}


static void _gitg_dash_view___lambda106_ (GitgDashView* self, const gchar* primary_message, const gchar* secondary_message) {
	GitgExtApplication* _tmp0_ = NULL;
	GitgExtApplication* _tmp1_ = NULL;
	GitgExtApplication* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 208 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (primary_message != NULL);
#line 208 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (secondary_message != NULL);
#line 209 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = gitg_ext_ui_element_get_application ((GitgExtUIElement*) self);
#line 209 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _tmp0_;
#line 209 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _tmp1_;
#line 209 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = primary_message;
#line 209 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = secondary_message;
#line 209 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_application_show_infobar (_tmp2_, _tmp3_, _tmp4_, GTK_MESSAGE_ERROR);
#line 209 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp2_);
#line 3872 "gitg-dash-view.c"
}


static void __gitg_dash_view___lambda106__gitg_repository_list_box_show_error (GitgRepositoryListBox* _sender, const gchar* primary_message, const gchar* secondary_message, gpointer self) {
#line 208 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_dash_view___lambda106_ ((GitgDashView*) self, primary_message, secondary_message);
#line 3879 "gitg-dash-view.c"
}


static void _gitg_dash_view_update_availability_gtk_container_add (GtkContainer* _sender, GtkWidget* widget, gpointer self) {
#line 223 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_update_availability ((GitgDashView*) self);
#line 3886 "gitg-dash-view.c"
}


static void _gitg_dash_view_update_availability_gtk_container_remove (GtkContainer* _sender, GtkWidget* widget, gpointer self) {
#line 224 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_update_availability ((GitgDashView*) self);
#line 3893 "gitg-dash-view.c"
}


static void _gitg_dash_view___lambda107_ (Block46Data* _data46_) {
	GitgDashView* self;
	GitgRepositoryListBox* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GitgRepositoryListBox* _tmp8_ = NULL;
#line 235 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data46_->self;
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_repository_list_box;
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = gitg_dirs_get_user_data_dir ();
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = _tmp1_;
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = _tmp2_;
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = g_build_filename (_tmp3_, "repositories.gbookmarks", NULL);
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = _tmp4_;
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = g_file_new_for_path (_tmp5_);
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = _tmp6_;
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_repository_list_box_set_location (_tmp0_, _tmp7_);
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp7_);
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_tmp5_);
#line 236 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_tmp3_);
#line 237 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp8_ = self->priv->d_repository_list_box;
#line 237 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_repository_list_box_populate_bookmarks (_tmp8_);
#line 239 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_when_mapped_unref0 (_data46_->whenMapped);
#line 239 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data46_->whenMapped = NULL;
#line 3942 "gitg-dash-view.c"
}


static void __gitg_dash_view___lambda107__gitg_when_mapped_on_mapped (gpointer self) {
#line 235 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_dash_view___lambda107_ (self);
#line 3949 "gitg-dash-view.c"
}


static GObject * gitg_dash_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GitgDashView * self;
	Block46Data* _data46_;
	GitgRepositoryListBox* _tmp0_ = NULL;
	GitgRepositoryListBox* _tmp1_ = NULL;
	GitgRepositoryListBox* _tmp2_ = NULL;
	GtkScrolledWindow* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	GitgRepositoryListBox* _tmp5_ = NULL;
	GitgRepositoryListBox* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GitgWhenMapped* _tmp15_ = NULL;
	GitgWhenMapped* _tmp16_ = NULL;
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	parent_class = G_OBJECT_CLASS (gitg_dash_view_parent_class);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DASH_VIEW, GitgDashView);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data46_ = g_slice_new0 (Block46Data);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data46_->_ref_count_ = 1;
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data46_->self = g_object_ref (self);
#line 197 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_repository_list_box;
#line 197 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_object ((GObject*) _tmp0_, "notify::mode", (GCallback) __gitg_dash_view___lambda104__g_object_notify, self, 0);
#line 204 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = self->priv->d_repository_list_box;
#line 204 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_object (_tmp1_, "repository-activated", (GCallback) __gitg_dash_view___lambda105__gitg_repository_list_box_repository_activated, self, 0);
#line 208 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = self->priv->d_repository_list_box;
#line 208 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_object (_tmp2_, "show-error", (GCallback) __gitg_dash_view___lambda106__gitg_repository_list_box_show_error, self, 0);
#line 212 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = self->priv->d_scrolled_window;
#line 212 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "has-repositories", (GObject*) _tmp3_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 217 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = self->priv->d_introduction;
#line 217 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_bind_property_with_closures ((GObject*) self, "has-repositories", (GObject*) _tmp4_, "visible", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
#line 223 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = self->priv->d_repository_list_box;
#line 223 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_object ((GtkContainer*) _tmp5_, "add", (GCallback) _gitg_dash_view_update_availability_gtk_container_add, self, 0);
#line 224 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = self->priv->d_repository_list_box;
#line 224 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_signal_connect_object ((GtkContainer*) _tmp6_, "remove", (GCallback) _gitg_dash_view_update_availability_gtk_container_remove, self, 0);
#line 227 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp7_ = self->priv->d_label_scan;
#line 227 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp8_ = _ ("We can also %sscan your home directory%s for git repositories.");
#line 227 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp9_ = g_strdup_printf (_tmp8_, "<a href=\"scan-home\">", "</a>");
#line 227 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp10_ = _tmp9_;
#line 227 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_label_set_label (_tmp7_, _tmp10_);
#line 227 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_tmp10_);
#line 230 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp11_ = self->priv->d_label_profile;
#line 230 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp12_ = _ ("In the mean time, you may want to %sset up your git profile%s.");
#line 230 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp13_ = g_strdup_printf (_tmp12_, "<a href=\"setup-profile\">", "</a>");
#line 230 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp14_ = _tmp13_;
#line 230 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_label_set_label (_tmp11_, _tmp14_);
#line 230 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (_tmp14_);
#line 231 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_update_setup_profile_visibility (self);
#line 233 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp15_ = gitg_when_mapped_new ((GtkWidget*) self);
#line 233 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data46_->whenMapped = _tmp15_;
#line 235 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp16_ = _data46_->whenMapped;
#line 235 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_when_mapped_update (_tmp16_, __gitg_dash_view___lambda107__gitg_when_mapped_on_mapped, block46_data_ref (_data46_), block46_data_unref, NULL);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block46_data_unref (_data46_);
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data46_ = NULL;
#line 195 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return obj;
#line 4055 "gitg-dash-view.c"
}


static GitgDashViewCloneCallbacks* gitg_dash_view_clone_callbacks_construct (GType object_type, GitgExtApplication* application, GgitConfig* config, GitgRepositoryListBoxRow* row) {
	GitgDashViewCloneCallbacks * self = NULL;
	GitgRepositoryListBoxRow* _tmp0_ = NULL;
	GitgRepositoryListBoxRow* _tmp1_ = NULL;
	GgitConfig* _tmp2_ = NULL;
	GitgExtApplication* _tmp3_ = NULL;
	GitgCredentialsManager* _tmp4_ = NULL;
#line 298 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (application != NULL, NULL);
#line 298 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (row != NULL, NULL);
#line 298 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashViewCloneCallbacks*) g_object_new (object_type, NULL);
#line 300 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = row;
#line 300 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 300 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->d_row);
#line 300 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv->d_row = _tmp1_;
#line 301 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = config;
#line 301 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = application;
#line 301 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = gitg_credentials_manager_new (_tmp2_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL, FALSE);
#line 301 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_credentials_manager_unref0 (self->priv->d_credentials);
#line 301 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv->d_credentials = _tmp4_;
#line 298 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return self;
#line 4092 "gitg-dash-view.c"
}


static GitgDashViewCloneCallbacks* gitg_dash_view_clone_callbacks_new (GitgExtApplication* application, GgitConfig* config, GitgRepositoryListBoxRow* row) {
#line 298 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return gitg_dash_view_clone_callbacks_construct (GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, application, config, row);
#line 4099 "gitg-dash-view.c"
}


static Block47Data* block47_data_ref (Block47Data* _data47_) {
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_atomic_int_inc (&_data47_->_ref_count_);
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return _data47_;
#line 4108 "gitg-dash-view.c"
}


static void block47_data_unref (void * _userdata_) {
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
#line 4117 "gitg-dash-view.c"
		GitgDashViewCloneCallbacks* self;
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		self = _data47_->self;
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		_g_object_unref0 (self);
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_slice_free (Block47Data, _data47_);
#line 4125 "gitg-dash-view.c"
	}
}


static gboolean __lambda100_ (Block47Data* _data47_) {
	GitgDashViewCloneCallbacks* self;
	gboolean result = FALSE;
	GitgRepositoryListBoxRow* _tmp0_ = NULL;
#line 310 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = _data47_->self;
#line 311 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = self->priv->d_row;
#line 311 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_repository_list_box_row_set_fraction (_tmp0_, (_data47_->recvobj + _data47_->indxobj) / ((gdouble) (2 * _data47_->totaobj)));
#line 312 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = FALSE;
#line 312 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 4144 "gitg-dash-view.c"
}


static gboolean ___lambda100__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda100_ (self);
#line 310 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 4153 "gitg-dash-view.c"
}


static void gitg_dash_view_clone_callbacks_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats) {
	GitgDashViewCloneCallbacks * self;
	Block47Data* _data47_;
	GgitTransferProgress* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GgitTransferProgress* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GgitTransferProgress* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashViewCloneCallbacks*) base;
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_if_fail (stats != NULL);
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data47_ = g_slice_new0 (Block47Data);
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data47_->_ref_count_ = 1;
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data47_->self = g_object_ref (self);
#line 306 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = stats;
#line 306 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = ggit_transfer_progress_get_received_objects (_tmp0_);
#line 306 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data47_->recvobj = _tmp1_;
#line 307 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = stats;
#line 307 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = ggit_transfer_progress_get_indexed_objects (_tmp2_);
#line 307 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data47_->indxobj = _tmp3_;
#line 308 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = stats;
#line 308 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = ggit_transfer_progress_get_total_objects (_tmp4_);
#line 308 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data47_->totaobj = _tmp5_;
#line 310 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda100__gsource_func, block47_data_ref (_data47_), block47_data_unref);
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	block47_data_unref (_data47_);
#line 304 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_data47_ = NULL;
#line 4200 "gitg-dash-view.c"
}


static GgitCred* gitg_dash_view_clone_callbacks_real_credentials (GgitRemoteCallbacks* base, const gchar* url, const gchar* username_from_url, GgitCredtype allowed_types, GError** error) {
	GitgDashViewCloneCallbacks * self;
	GgitCred* result = NULL;
	GgitCred* _tmp0_ = NULL;
	GitgCredentialsManager* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GgitCredtype _tmp4_ = 0;
	GgitCred* _tmp5_ = NULL;
	GgitCred* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 316 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = (GitgDashViewCloneCallbacks*) base;
#line 316 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp1_ = self->priv->d_credentials;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp2_ = url;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp3_ = username_from_url;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp4_ = allowed_types;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp5_ = gitg_credentials_manager_credentials (_tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = _tmp5_;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_propagate_error (error, _inner_error_);
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		return NULL;
#line 4237 "gitg-dash-view.c"
	}
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp6_ = _tmp0_;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_tmp0_ = NULL;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	result = _tmp6_;
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (_tmp0_);
#line 318 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	return result;
#line 4249 "gitg-dash-view.c"
}


static void gitg_dash_view_clone_callbacks_class_init (GitgDashViewCloneCallbacksClass * klass) {
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_clone_callbacks_parent_class = g_type_class_peek_parent (klass);
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_type_class_add_private (klass, sizeof (GitgDashViewCloneCallbacksPrivate));
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	((GgitRemoteCallbacksClass *) klass)->transfer_progress = gitg_dash_view_clone_callbacks_real_transfer_progress;
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	((GgitRemoteCallbacksClass *) klass)->credentials = gitg_dash_view_clone_callbacks_real_credentials;
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_dash_view_clone_callbacks_finalize;
#line 4264 "gitg-dash-view.c"
}


static void gitg_dash_view_clone_callbacks_instance_init (GitgDashViewCloneCallbacks * self) {
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv = GITG_DASH_VIEW_CLONE_CALLBACKS_GET_PRIVATE (self);
#line 4271 "gitg-dash-view.c"
}


static void gitg_dash_view_clone_callbacks_finalize (GObject* obj) {
	GitgDashViewCloneCallbacks * self;
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_DASH_VIEW_TYPE_CLONE_CALLBACKS, GitgDashViewCloneCallbacks);
#line 295 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->d_row);
#line 296 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_gitg_credentials_manager_unref0 (self->priv->d_credentials);
#line 293 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	G_OBJECT_CLASS (gitg_dash_view_clone_callbacks_parent_class)->finalize (obj);
#line 4285 "gitg-dash-view.c"
}


static GType gitg_dash_view_clone_callbacks_get_type (void) {
	static volatile gsize gitg_dash_view_clone_callbacks_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_dash_view_clone_callbacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgDashViewCloneCallbacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_dash_view_clone_callbacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDashViewCloneCallbacks), 0, (GInstanceInitFunc) gitg_dash_view_clone_callbacks_instance_init, NULL };
		GType gitg_dash_view_clone_callbacks_type_id;
		gitg_dash_view_clone_callbacks_type_id = g_type_register_static (ggit_remote_callbacks_get_type (), "GitgDashViewCloneCallbacks", &g_define_type_info, 0);
		g_once_init_leave (&gitg_dash_view_clone_callbacks_type_id__volatile, gitg_dash_view_clone_callbacks_type_id);
	}
	return gitg_dash_view_clone_callbacks_type_id__volatile;
}


static void gitg_dash_view_class_init (GitgDashViewClass * klass) {
	gint GitgDashView_private_offset;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_type_class_add_private (klass, sizeof (GitgDashViewPrivate));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_dash_view_get_property;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_dash_view_set_property;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	G_OBJECT_CLASS (klass)->constructor = gitg_dash_view_constructor;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_dash_view_finalize;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_APPLICATION, g_param_spec_object ("application", "application", "application", GITG_EXT_TYPE_APPLICATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SELECTABLE_MODE, g_param_spec_enum ("selectable-mode", "selectable-mode", "selectable-mode", GITG_EXT_TYPE_SELECTION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_HAS_REPOSITORIES, g_param_spec_boolean ("has-repositories", "has-repositories", "has-repositories", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SELECTABLE_AVAILABLE, g_param_spec_boolean ("selectable-available", "selectable-available", "selectable-available", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_AVAILABLE, g_param_spec_boolean ("search-available", "search-available", "search-available", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_WIDGET, g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_ICON, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_TEXT, g_param_spec_string ("search-text", "search-text", "search-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_ENTRY, g_param_spec_object ("search-entry", "search-entry", "search-entry", gtk_entry_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_SEARCH_VISIBLE, g_param_spec_boolean ("search-visible", "search-visible", "search-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DASH_VIEW_ACTION_WIDGET, g_param_spec_object ("action-widget", "action-widget", "action-widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	GitgDashView_private_offset = g_type_class_get_instance_private_offset (klass);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-dash-view.ui");
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "introduction", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_introduction));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_scan", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_label_scan));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_profile", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_label_profile));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolled_window", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_scrolled_window));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "repository_list_box", FALSE, GitgDashView_private_offset + G_STRUCT_OFFSET (GitgDashViewPrivate, d_repository_list_box));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_home_activated", G_CALLBACK(_gitg_dash_view_scan_home_activated_gtk_label_activate_link));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "setup_profile_activated", G_CALLBACK(_gitg_dash_view_setup_profile_activated_gtk_label_activate_link));
#line 4361 "gitg-dash-view.c"
}


static void gitg_dash_view_gitg_ext_ui_element_interface_init (GitgExtUIElementIface * iface) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_gitg_ext_ui_element_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_application = gitg_dash_view_real_get_application;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->set_application = gitg_dash_view_real_set_application;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_display_name = gitg_dash_view_real_get_display_name;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_description = gitg_dash_view_real_get_description;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_id = gitg_dash_view_real_get_id;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_widget = gitg_dash_view_real_get_widget;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_icon = gitg_dash_view_real_get_icon;
#line 4382 "gitg-dash-view.c"
}


static void gitg_dash_view_gitg_ext_activity_interface_init (GitgExtActivityIface * iface) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_gitg_ext_activity_parent_iface = g_type_interface_peek_parent (iface);
#line 4389 "gitg-dash-view.c"
}


static void gitg_dash_view_gitg_ext_selectable_interface_init (GitgExtSelectableIface * iface) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_gitg_ext_selectable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_selectable_mode = gitg_dash_view_real_get_selectable_mode;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->set_selectable_mode = gitg_dash_view_real_set_selectable_mode;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_selectable_available = gitg_dash_view_real_get_selectable_available;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_action_widget = gitg_dash_view_real_get_action_widget;
#line 4404 "gitg-dash-view.c"
}


static void gitg_dash_view_gitg_ext_searchable_interface_init (GitgExtSearchableIface * iface) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_gitg_ext_searchable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_search_available = gitg_dash_view_real_get_search_available;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_search_text = gitg_dash_view_real_get_search_text;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->set_search_text = gitg_dash_view_real_set_search_text;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->set_search_entry = gitg_dash_view_real_set_search_entry;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->get_search_visible = gitg_dash_view_real_get_search_visible;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->set_search_visible = gitg_dash_view_real_set_search_visible;
#line 4423 "gitg-dash-view.c"
}


static void gitg_dash_view_gitg_recursive_scanner_interface_init (GitgRecursiveScannerIface * iface) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_dash_view_gitg_recursive_scanner_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->scan_visit_directory = (gboolean (*)(GitgRecursiveScanner*, GFile*, GCancellable*)) gitg_dash_view_real_scan_visit_directory;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	iface->scan_visit_directory_finish = gitg_dash_view_real_scan_visit_directory_finish;
#line 4434 "gitg-dash-view.c"
}


static void gitg_dash_view_instance_init (GitgDashView * self) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self->priv = GITG_DASH_VIEW_GET_PRIVATE (self);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gitg_ext_searchable_set_search_text (self, "");
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 4445 "gitg-dash-view.c"
}


static void gitg_dash_view_finalize (GObject* obj) {
	GitgDashView * self;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DASH_VIEW, GitgDashView);
#line 28 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->_application);
#line 33 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->d_introduction);
#line 36 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->d_label_scan);
#line 39 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->d_label_profile);
#line 42 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->d_scrolled_window);
#line 45 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_object_unref0 (self->priv->d_repository_list_box);
#line 125 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	_g_free0 (self->priv->d_search_text);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	G_OBJECT_CLASS (gitg_dash_view_parent_class)->finalize (obj);
#line 4469 "gitg-dash-view.c"
}


GType gitg_dash_view_get_type (void) {
	static volatile gsize gitg_dash_view_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_dash_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgDashViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_dash_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDashView), 0, (GInstanceInitFunc) gitg_dash_view_instance_init, NULL };
		static const GInterfaceInfo gitg_ext_ui_element_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_ui_element_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gitg_ext_activity_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_activity_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gitg_ext_selectable_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_selectable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gitg_ext_searchable_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_ext_searchable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gitg_recursive_scanner_info = { (GInterfaceInitFunc) gitg_dash_view_gitg_recursive_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gitg_dash_view_type_id;
		gitg_dash_view_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDashView", &g_define_type_info, 0);
		g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_UI_ELEMENT, &gitg_ext_ui_element_info);
		g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_ACTIVITY, &gitg_ext_activity_info);
		g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_SELECTABLE, &gitg_ext_selectable_info);
		g_type_add_interface_static (gitg_dash_view_type_id, GITG_EXT_TYPE_SEARCHABLE, &gitg_ext_searchable_info);
		g_type_add_interface_static (gitg_dash_view_type_id, GITG_TYPE_RECURSIVE_SCANNER, &gitg_recursive_scanner_info);
		g_once_init_leave (&gitg_dash_view_type_id__volatile, gitg_dash_view_type_id);
	}
	return gitg_dash_view_type_id__volatile;
}


static void _vala_gitg_dash_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgDashView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DASH_VIEW, GitgDashView);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	switch (property_id) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_APPLICATION:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_object (value, gitg_ext_ui_element_get_application ((GitgExtUIElement*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SELECTABLE_MODE:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_set_enum (value, gitg_ext_selectable_get_selectable_mode ((GitgExtSelectable*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_HAS_REPOSITORIES:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_set_boolean (value, gitg_dash_view_get_has_repositories (self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SELECTABLE_AVAILABLE:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_set_boolean (value, gitg_ext_selectable_get_selectable_available ((GitgExtSelectable*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SEARCH_AVAILABLE:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_set_boolean (value, gitg_ext_searchable_get_search_available ((GitgExtSearchable*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_DISPLAY_NAME:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_string (value, gitg_ext_ui_element_get_display_name ((GitgExtUIElement*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_DESCRIPTION:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_string (value, gitg_ext_ui_element_get_description ((GitgExtUIElement*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_ID:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_string (value, gitg_ext_ui_element_get_id ((GitgExtUIElement*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_WIDGET:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_object (value, gitg_ext_ui_element_get_widget ((GitgExtUIElement*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_ICON:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_string (value, gitg_ext_ui_element_get_icon ((GitgExtUIElement*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SEARCH_TEXT:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_string (value, gitg_ext_searchable_get_search_text ((GitgExtSearchable*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SEARCH_VISIBLE:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_set_boolean (value, gitg_ext_searchable_get_search_visible ((GitgExtSearchable*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_ACTION_WIDGET:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		g_value_take_object (value, gitg_ext_selectable_get_action_widget ((GitgExtSelectable*) self));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 4578 "gitg-dash-view.c"
		default:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 4584 "gitg-dash-view.c"
	}
}


static void _vala_gitg_dash_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgDashView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DASH_VIEW, GitgDashView);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
	switch (property_id) {
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_APPLICATION:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_ext_ui_element_set_application ((GitgExtUIElement*) self, g_value_get_object (value));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SELECTABLE_MODE:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_ext_selectable_set_selectable_mode ((GitgExtSelectable*) self, g_value_get_enum (value));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SEARCH_TEXT:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_ext_searchable_set_search_text ((GitgExtSearchable*) self, g_value_get_string (value));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SEARCH_ENTRY:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_ext_searchable_set_search_entry ((GitgExtSearchable*) self, g_value_get_object (value));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		case GITG_DASH_VIEW_SEARCH_VISIBLE:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		gitg_ext_searchable_set_search_visible ((GitgExtSearchable*) self, g_value_get_boolean (value));
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 4624 "gitg-dash-view.c"
		default:
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/jesse/dev/gitg/gitg/gitg-dash-view.vala"
		break;
#line 4630 "gitg-dash-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



