/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimptexttool_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimptexttool
 * @title: gimptexttool
 * @short_description: Functions for controlling the text tool.
 *
 * Functions for controlling the text tool.
 **/


/**
 * gimp_text_fontname:
 * @image_ID: The image.
 * @drawable_ID: The affected drawable: (-1 for a new text layer).
 * @x: The x coordinate for the left of the text bounding box.
 * @y: The y coordinate for the top of the text bounding box.
 * @text: The text to generate (in UTF-8 encoding).
 * @border: The size of the border.
 * @antialias: Antialiasing.
 * @size: The size of text in either pixels or points.
 * @size_type: The units of specified size.
 * @fontname: The name of the font.
 *
 * Add text at the specified location as a floating selection or a new
 * layer.
 *
 * This tool requires a fontname matching an installed PangoFT2 font.
 * You can specify the fontsize in units of pixels or points, and the
 * appropriate metric is specified using the size_type argument. The x
 * and y parameters together control the placement of the new text by
 * specifying the upper left corner of the text bounding box. If the
 * specified drawable parameter is valid, the text will be created as a
 * floating selection attached to the drawable. If the drawable
 * parameter is not valid (-1), the text will appear as a new layer.
 * Finally, a border can be specified around the final rendered text.
 * The border is measured in pixels. Parameter size-type is not used
 * and is currently ignored. If you need to display a font in points,
 * divide the size in points by 72.0 and multiply it by the image's
 * vertical resolution.
 *
 * Returns: The new text layer or -1 if no layer was created.
 **/
gint32
gimp_text_fontname (gint32        image_ID,
                    gint32        drawable_ID,
                    gdouble       x,
                    gdouble       y,
                    const gchar  *text,
                    gint          border,
                    gboolean      antialias,
                    gdouble       size,
                    GimpSizeType  size_type,
                    const gchar  *fontname)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint32 text_layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp-text-fontname",
                                    &nreturn_vals,
                                    GIMP_PDB_IMAGE, image_ID,
                                    GIMP_PDB_DRAWABLE, drawable_ID,
                                    GIMP_PDB_FLOAT, x,
                                    GIMP_PDB_FLOAT, y,
                                    GIMP_PDB_STRING, text,
                                    GIMP_PDB_INT32, border,
                                    GIMP_PDB_INT32, antialias,
                                    GIMP_PDB_FLOAT, size,
                                    GIMP_PDB_INT32, size_type,
                                    GIMP_PDB_STRING, fontname,
                                    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    text_layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return text_layer_ID;
}

/**
 * gimp_text_get_extents_fontname:
 * @text: The text to generate (in UTF-8 encoding).
 * @size: The size of text in either pixels or points.
 * @size_type: The units of specified size.
 * @fontname: The name of the font.
 * @width: The width of the specified font.
 * @height: The height of the specified font.
 * @ascent: The ascent of the specified font.
 * @descent: The descent of the specified font.
 *
 * Get extents of the bounding box for the specified text.
 *
 * This tool returns the width and height of a bounding box for the
 * specified text string with the specified font information. Ascent
 * and descent for the specified font are returned as well. Parameter
 * size-type is not used and is currently ignored. If you need to
 * display a font in points, divide the size in points by 72.0 and
 * multiply it by the vertical resolution of the image you are taking
 * into account.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_text_get_extents_fontname (const gchar  *text,
                                gdouble       size,
                                GimpSizeType  size_type,
                                const gchar  *fontname,
                                gint         *width,
                                gint         *height,
                                gint         *ascent,
                                gint         *descent)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-text-get-extents-fontname",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, text,
                                    GIMP_PDB_FLOAT, size,
                                    GIMP_PDB_INT32, size_type,
                                    GIMP_PDB_STRING, fontname,
                                    GIMP_PDB_END);

  *width = 0;
  *height = 0;
  *ascent = 0;
  *descent = 0;

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = return_vals[1].data.d_int32;
      *height = return_vals[2].data.d_int32;
      *ascent = return_vals[3].data.d_int32;
      *descent = return_vals[4].data.d_int32;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
