!     $Id: modulePakoTip.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!     Family:   OBSERVING MODES
!     Siblings: moduleTip.f90
!
!----------------------------------------------------------------------
!     PAKO module for TIP
!
Module modulePakoTip
  !
  Use modulePakoTypes
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoUtilities
  Use modulePakoPlots
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  Use modulePakoSubscanList
  Use modulePakoReceiver
  Use modulePakoBackend
  Use modulePakoSource
  Use modulePakoSwBeam
  Use modulePakoSwWobbler
  Use modulePakoSwTotalPower
  !
  Implicit None
  Save
  Private
  Public :: tip, saveTip, startTip
  !     
  ! *** Variables for tip ***
  Include 'inc/variables/variablesTip.inc'
!!!   
Contains
!!!
!!!
  Subroutine tip(programName,line,command,                    &
       &        error)
    !
    ! *** Arguments ***
    Include 'inc/variables/headerForCommandHandler2.inc'
    !
    ! *** standard working variables ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesTip.inc'
    !
    !D      Write (6,*) " module tip ---> SR: tip "
    !D      Write (6,*) "                          "
    !
    ! *** initialize ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/setDefaults.inc'
       isInitialized = .True.
    Endif
    !
    !D      Write (6,*) " after initialize "
    !D      Write (6,*) " vars(iValue)%doCurrentAzimuth: ", vars(iValue)%doCurrentAzimuth
    !D      Write (6,*) " vars(iTemp)%doCurrentAzimuth: ", vars(iTemp)%doCurrentAzimuth
    !D      Write (6,*) " vars(iIn)%doCurrentAzimuth: ", vars(iIn)%doCurrentAzimuth
    !D      Write (6,*) " vars(iDefault)%doCurrentAzimuth: ", vars(iDefault)%doCurrentAzimuth
    !
    ! *** set In-values = previous Values ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    !     read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    Call checkNofParameters(command,                                 &
         &     0, 1,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersAzimuth.inc'
       Include 'inc/options/readOptionsTip.inc'
    End If
    !
    ! *** set defaults ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/setDefaults.inc'
       Endif
    Endif
    !
    ! *** read Parameters, Options (again, after defaults!) ***
    !     and check for validity and ranges 
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersAzimuth.inc'
       Include 'inc/options/readOptionsTip.inc'
    End If
    !
    ! TBD make options /slew and /tSubscan alternatives!  
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.error) Then
       !
       errorInconsistent = .False.
       ! TBD    Include 'inc/parameters/checkConsistentTip.inc'
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from temporary into final variables ***
    If (.Not.ERROR) Then
       vars(iValue) = vars(iTemp)
    End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Include 'inc/display/commandDisplayTip.inc'
    !
    ! *** set "selected" observing mode & plot ***
    If (.Not.error) Then
       GV%observingMode = command
       Write (6,*) "        GV%observingMode ->", GV%observingMode(1:len_trim(GV%observingMode)), "<-"        
       tipCommand = line(1:lenc(line))
       Write (6,*) "        tipCommand ->", tipCommand(1:len_trim(tipCommand)), "<-"
       Call analyzeTip (errorA)
    End If
    !
    Return
  End Subroutine tip
!!!
!!!
  Subroutine analyzeTip (errorA)
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer              :: nScan 
    Character (len=12)   :: aUnit, sUnit
    Integer              :: iSS           = 0     ! counts subcans/segment
    Integer              :: nSS           = 1
    Real                 :: aa            = 1.0
    Real                 :: aFirst        = 1.0
    Real                 :: aLast         = 1.0
    Real                 :: aStep         = 1.0
    Real                 :: ee            = 10.0
    Real                 :: eTop          = 10.0
    Real                 :: eBot          = 10.0
    !
    errorA = .False.
    iSS    = 0
    nScan     = 1111
    aUnit     = au%degree                            ! TIP is in degree
    sUnit     = su%degree                            !     and   degree /second
    !
    ! TBD: tip for heterodyne receivers
    ! TBD: info messages about number of subscans and elevations!
    !
    aFirst = Min (vars(iValue)%airmass%from, vars(iValue)%airmass%to)
    aLast  = Max (vars(iValue)%airmass%from, vars(iValue)%airmass%to)
    aStep  = Abs (vars(iValue)%airmass%by)
    eTop   = Asin(1.0/aFirst)/deg
    eBot   = Asin(1.0/aLast)/deg
    nSS = Int(Abs(aLast-aFirst)/aStep)+1
    !
    vars(iValue)%elevation = eBot
    !
    Do ii = 1, nSS, 1
       !
       aa = aFirst + (ii-1)*aStep
       ee = Asin(1.0/aa)/deg
       !
       iSS = iSS+1
       segList(iSS)            =  segDefault
       segList(iSS)%newSubscan =  .True.
       segList(iSS)%scanNumber =  nScan
       segList(iSS)%ssNumber   =  iSS
       segList(iSS)%segNumber  =  1
       segList(iSS)%ssType     =  ss%am
       segList(iSS)%segType    =  seg%track
       segList(iSS)%angleUnit  =  aUnit
       segList(iSS)%speedUnit  =  sUnit
       segList(iSS)%flagOn     =  .False.
       segList(iSS)%flagRef    =  .False.
       segList(iSS)%pStart%x   =  0.0
       segList(iSS)%pStart%y   =  ee-eBot
       segList(iSS)%pEnd       =  segList(iSS)%pStart
       segList(iSS)%speedStart =  0.0
       segList(iSS)%speedEnd   =  0.0
       segList(iSS)%systemName =  'horizontal'
       segList(iSS)%altOption  =  'tSegment'
       segList(iSS)%tSegment   =  vars(iValue)%tSubscan
       segList(iSS)%tRecord    =  0.1
       Write (messageText,*)  "  subscan #:   ", iSS,        &
            &        segList(iSS)%ssType
       Call pakoMessage(priorityI,severityI,"TIP "//" Analyze",messageText)
       !
    End Do
    !                                                     
    iSS = iSS+1
    !
    segList(iSS)            =  segDefault                    ! PADDLE
    segList(iSS)%newSubscan =  .True.
    segList(iSS)%scanNumber =  nScan
    segList(iSS)%ssNumber   =  iSS
    segList(iSS)%segNumber  =  1
    segList(iSS)%ssType     =  ss%cp
    segList(iSS)%segType    =  seg%track
    segList(iSS)%angleUnit  =  aUnit
    segList(iSS)%speedUnit  =  sUnit
    segList(iSS)%flagOn     =  .False.
    segList(iSS)%flagRef    =  .False.
    segList(iSS)%pStart%x   =  0.0
    segList(iSS)%pStart%y   =  0.0
    segList(iSS)%pEnd       =  segList(iSS)%pStart
    segList(iSS)%speedStart =  0.0
    segList(iSS)%speedEnd   =  0.0
    segList(iSS)%systemName =  'horizontal'
    segList(iSS)%altOption  =  'tSegment'
    segList(iSS)%tSegment   =  vars(iValue)%tSubscan
    segList(iSS)%tRecord    =  0.1
    Write (messageText,*)  "  subscan #:   ", iSS,        &
         &        segList(iSS)%ssType
    Call pakoMessage(priorityI,severityI,"TIP "//" Analyze",messageText)
    !
    nSegments = iSS
    !
    Return 
    !
  End Subroutine analyzeTip
!!!
!!!
  Subroutine saveTip(programName,LINE,commandToSave,                 &
       &         iUnit, ERROR)
    !
    !**   Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !      
    contC = contNN
    Include 'inc/commands/saveCommand.inc'
    !
    !D      write (6,*) '      ---> SR: saveTip '
    !
    contC = contCC
    Include 'inc/options/saveAirmass.inc'
    !TBD:      Include 'inc/options/saveSlew.inc'
    contC = contCN
    Include 'inc/options/saveTsubscan.inc'
    !
    ! NB: parameter Azimuth gets saved last
    !     because TIP without argument has special meaning:
    !     "current azimuth"
    contC = contNN
    Include 'inc/parameters/saveAzimuth.inc'
    !
    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveTip
!!!
!!!
  Subroutine startTip(programName,LINE,commandToSave,                &
       &         iUnit, ERROR)
    !
    ! *** Variables ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Integer            :: ii
    Character (len=24) :: valueC
    Character (len=48) :: valueComment
    Logical            :: errorXML
    !
    ! TBD: tip for heterodyne receivers
    !
    !D      Write (6,*) "  --> module moduleTip: SR startTip "
    ! 
    Call pakoXMLsetOutputUnit(iunit=iunit)
    Call pakoXMLsetIndent(iIndent=2)
!!$   Call pakoXMLsetLevel(1)
    !
    Include 'inc/startXML/generalHead.inc'
    !
    Call writeXMLset(programName,LINE,commandToSave,                  &
         &         iUnit, ERROR)
    !
    Call pakoXMLwriteStartElement("RESOURCE","pakoScript",            &
         &                         comment="save from pako",                &
         &                         error=errorXML)
    Call pakoXMLwriteStartElement("DESCRIPTION",                      &
         &                         doCdata=.True.,                          &
         &                         error=errorXML)
    !
!!$    Call pakoSaveSet(programName,LINE,commandToSave,                  &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveReceiver(programName,LINE,commandToSave,                 &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveTip(programName,LINE,commandToSave,                      &
!!$         &         iUnit, ERROR)                                 
    !                                                                       
    Call pakoXMLwriteEndElement("DESCRIPTION",                        &
         &      error=errorXML)                                             
    Call pakoXMLwriteEndElement("RESOURCE", "pakoScript",             &
         &      error=errorXML)
    !
    Call writeXMLreceiver(programName,LINE,commandToSave,             &
         &         iUnit, ERROR)
    !
    Include 'inc/startXML/swTipXML.inc'
    !
    Include 'inc/startXML/sourceTip.inc'
    !
    Include 'inc/startXML/generalScanHead.inc'
    !
    Include 'inc/startXML/tipSubscansXML.inc'
    !   
    Include 'inc/startXML/generalTail.inc'
    !
    Return
  End Subroutine startTip
!!!
!!!
End Module modulePakoTip
