!     $Id: modulePakoSwWobbler.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!     Family:   SWITCH 
!     Siblings:        pakoSwBeam.f
!     Siblings:        pakoSwFrequency.f
!     Siblings:        pakoSwSpecial.f
!     Siblings:        pakoSwTotalPower.f
!     Siblings:        pakoSwWobbler.f 
!
!----------------------------------------------------------------------
!     PAKO module for  swWobbler
!
Module modulePakoSwWobbler
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  !
  Implicit None
  Save
  Private
  Public :: swWobbler
  Public :: saveSwWobbler, writeXMLswWobbler
  !     
  ! *** Variables for swWobbler ***
  Include 'inc/variables/variablesSwWobbler.inc'
  !     
!!!   
Contains
!!!
  Subroutine swWobbler(programName,line,command,                 &
       &        error)
    !
    ! *** Arguments: ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    ! TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesSwWobbler.inc'
    !
    !D    Write (6,*) " module swWobbler ---> SR: swWobbler "
    !D    Write (6,*) "                          "
    !D    Write (6,*) "        swModeSelected:   ", swModeSelected
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/swWobblerSetDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values   ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    ! *** read Parameters, Options (to detect errors)         ***
    ! *** and check for validity and ranges                   ***
    Call checkNofParameters(command,                                 &
         &     0, 2,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersWoffsets.inc'      
       Include 'inc/options/readOptionsSwWobbler.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/swWobblerSetDefaults.inc'
       Endif
    Endif
    !
    ! *** read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersWoffsets.inc'
       Include 'inc/options/readOptionsSwWobbler.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       !
       ! TBD:   INCLUDE 'inc/options/checkConsistentWoffsetsTphase.inc'
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from Temp into persistent variables   ***
    If (.Not.ERROR) Then
       vars(iValue) = vars(iTemp)
       GV%wOffset(1) = vars(iValue)%wOffset(1)
       GV%wOffset(2) = vars(iValue)%wOffset(2)
       Write (6,*) " GV%wOffset(1) ", GV%wOffset(1) 
       Write (6,*) " GV%wOffset(2) ", GV%wOffset(2) 
    End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Include 'inc/display/commandDisplaySwWobbler.inc'
    !
    ! *** set "selected" switching mode ***
    If (.Not.error) Then
       GV%switchingMode = command
       Write (6,*) " GV%switchingMode ", GV%switchingMode
       !D         Write (6,*) "        swModeSelected:   ", swModeSelected
       !D         Write (6,*) "        switchingMode:    ", switchingMode
       Write (messageText,*)                                         & 
            &         'Switching Mode selected: ',                            &
            &         GV%switchingMode,                                          &
            &         ' '
       Call pakoMessage(priorityI,severityI,command,messageText)
    End If
    !
    Return
  End Subroutine swWobbler
!!!
  Subroutine saveSwWobbler(programName,LINE,commandToSave,       &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    contC = contNN
    !
    B = '\'
    S = ' '
    CMD =  programName//B//"SWWOBBLER"
    lCMD = lenc(CMD)
    !
    ERROR = .false.
    !
    write (iUnit,*) "! "
    write (iUnit,*) "! ", CMD(1:lCMD)
    write (iUnit,*) CMD(1:lCMD), " -"
    !
    contC = contCC
    !
    Include 'inc/parameters/saveWoffsets.inc'
    !
    contC = contCN
    !
    Include 'inc/options/saveTphase.inc'
    !
    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveSwWobbler
!!!
  Subroutine writeXMLswWobbler(programName,LINE,commandToSave,      &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    character (len=24) :: valueC
    character (len=120) :: valueComment
    real               :: value
    logical :: errorXML
    !
    ERROR = .False.
    !
    !
    !D      write (6,*)  "      moduleSwWobbler --> SR: writeXMLWobbler "
    !
    include 'inc/startXML/swWobbler.inc'
    !
    Return
  End Subroutine writeXMLswWobbler
!!!
!!!
End Module modulePakoSwWobbler




