!
!     $Id: modulePakoSubscanList.f90,v 1.2 2005/06/22 14:46:29 ungerech Exp $
!     
!----------------------------------------------------------------------
!     PAKO 
!
! <DOCUMENTATION name="modulePakoSubscanList">
!
!  list of subscans and segments generated directly withuser commands
!  or by the "analyze" subroutines of the observing modes
!
! </DOCUMENTATION> <!-- name="modulePakoSubscanList" -->
!
Module modulePakoSubscanList
  !
  Use modulePakoMessages
  Use modulePakoXML
  Use modulePakoTypes
  Use modulePakoGlobalParameters
  Use modulePakoGlobalVariables
  !
  Implicit None
  Save
  Private
  !
  ! ***   data types and variables
  !
  Public  :: nSegments                 ! total number of segments -- DEPRECATED
  !
  ! *     points
  Public  :: pII
  !
  Public  :: dimensionList             ! dimension of segment list
  !
  ! *     subscans                     ! DEPRECATED
  Public  :: subscanType,     ssList,    ssDefault
  !
  ! *     segments
  Public  :: segmentType,     segList,   segDefault,  segOtfII
  ! *     choices for subscan and segment type
!!$  Public  :: ssChoicesType,   ss
!!$  Public  :: segChoicesType,  seg
  !
  ! ***   subroutines
!!$  Public  :: saveSubscanList            ! save into .pako script 
!!$  Public  :: startSubscanList           ! write complete XML for start of subscan list
  Public  :: writeXMLsubscanList        ! write XML only for subscan list
  Public  :: getNumberSegments          ! get     number of segments
  Public  :: getCountSubscans           ! get     subscan counter
  Public  :: getCountSegments           ! get     segment    "
  Public  :: countSubscans              ! control subscan counter
  Public  :: countSegments              !         segment    "
  Public  :: listSegmentList            ! list nicely list of segments
  Public  :: printSegmentList           ! print list of segments
  !
!!$  ! ***   type for xy offset points
!!$  Type    :: xyPointType
!!$     Real              :: x = 0.0
!!$     Real              :: y = 0.0
!!$  End Type xyPointType
  !
  ! ***   type for list of segments
  !       NB: segmentType should be used!
  !
  Type    :: segmentType
     Logical           :: newSubscan     = .False. ! flag for start of new subscan
     Integer           :: scanNumber     = 0       ! scan number (dummy)
     Integer           :: ssNumber       = 0       ! subscan number
     Integer           :: segNumber      = 0       ! segment number
     Character(len=24) :: ssType         = "none"  ! subscan type
     Character(len=24) :: segType        = "none"  ! segment type
     Character(len=24) :: angleUnit      = "none"  
     Character(len=24) :: speedUnit      = "none" 
     Logical           :: flagOn         = .False. ! flag as On-source
     Logical           :: flagRef        = .False. ! flag as off-source REF
     Type(xyPointType) :: pStart                   ! start
     Type(xyPointType) :: pEnd                     ! end
     Real              :: lengthOtf      = 0.0     ! linear length
     Real              :: turnAngle      = 0.0     ! turn angle for circle segment
     Type(xyPointType) :: CPstart                  ! start and
     Type(xyPointType) :: CPend                    ! end for curve segment
     Character(len=24) :: systemName     = "none"  ! system of mapping offsets
     Character(len=24) :: altOption      = "none"  ! alternative speed or tSegment 
     Real              :: speedStart     = 0.0     
     Real              :: speedEnd       = 0.0
     Real              :: tSegment       = 0.0     ! time per segment
     Real              :: tRecord        = 0.0     ! time per record
     Real              :: focusOffset    = 0.0     ! focus offset
     Character(len=24) :: directionFocus = "none"  ! focus direction
  End Type segmentType
  !
  !       NB: subscanType is deprecated
  Type    :: subscanType
     Integer           :: scanNumber  = 1       ! scan number
     Integer           :: ssNumber    = 1       ! subscan number
     Integer           :: segNumber   = 1       ! segment number
     Character(len=24) :: ssType      = "none"  ! subscan type
     Character(len=24) :: segType     = "none"  ! segment type
     Character(len=24) :: angleUnit   = "none"  
     Character(len=24) :: speedUnit   = "none"  
     Logical           :: flagOn      = .False. ! flag as On-source
     Logical           :: flagRef     = .False. ! flag as off-source REF
     Type(xyPointType) :: pStart 
     Type(xyPointType) :: pEnd
     ! TBD:     start & end are obsolete -- use pStart and pEnd !
     Type(xyPointType) :: start 
     Type(xyPointType) :: End
     Real              :: lengthOtf   = 0.0
     Real              :: turnAngle   = 0.0
     Type(xyPointType) :: CPstart 
     Type(xyPointType) :: CPend
     Character(len=24) :: altOption   = "none"  
     Real              :: speedStart  = 0.0
     Real              :: speedEnd    = 0.0
     Real              :: tSegment    = 0.0
     Real              :: tRecord     = 0.0
  End Type subscanType
  !
  Integer, Parameter   :: dimensionList = 999
  !
  Type (segmentType)                             :: segDefault
  Type (segmentType),  Dimension (dimensionList) :: segList
  !
  Type (segmentType)                             :: segOtfII
  !
  Type (xyPointType)                             :: pII
  !
  !       NB: subscanType is deprecated
  Type (subscanType)                             :: ssDefault
  Type (subscanType),  Dimension (dimensionList) :: ssList
  !
  Integer              :: iiSubscan   = 0       ! counter of subscans
  Integer              :: iiSegment   = 0       ! counter of segments
  Integer              :: nSegments   = 0       ! total number of segments
  !
!!$  Type :: ssChoicesType
!!$     Character(len=24) :: ca          = "calAmbient"
!!$     Character(len=24) :: cc          = "calCold"
!!$     Character(len=24) :: cs          = "calSky"
!!$     Character(len=24) :: cp          = "paddle"
!!$     Character(len=24) :: am          = "airmass"
!!$     Character(len=24) :: onFocus     = "onFocus"
!!$     Character(len=24) :: on          = "on"
!!$     Character(len=24) :: ref         = "reference"
!!$     Character(len=24) :: otf         = "onTheFly"      
!!$  End Type ssChoicesType
!!$  Type    (ssChoicesType) :: ss
!!$  !
!!$  Type :: segChoicesType
!!$     Character(len=24) :: track       = "track"
!!$     Character(len=24) :: linear      = "linear"
!!$     Character(len=24) :: circle      = "circle"
!!$     Character(len=24) :: curve       = "curve"
!!$  End Type segChoicesType
!!$  Type    (segChoicesType) :: seg
!!!
!!!
Contains
!!!
!!! TBD: imcomplete!
!!$  Subroutine saveSubscanList(programName,LINE,commandToSave,        &
!!$       &        OMselected, iUnit, ERROR)
!!$    !
!!$    ! *** Variables ***
!!$    Include 'inc/variables/headerForSaveMethods.inc'
!!$    !
!!$    Integer            :: ii
!!$    Character (len=24) :: valueC
!!$    Character (len=48) :: valueComment
!!$    !
!!$    Character(len=128) ::  messageText
!!$    ! 
!!$    !D      Write (6,*) '   --> moduleSubscanList: SR saveSubscanList '
!!$    !D      Write (6,*) '              iiSegment:   ', iiSegment
!!$    !
!!$    ERROR = .False.
!!$    !
!!$    If (iiSegment.Ge.1) Then
!!$       !
!!$       Do ii = 1, iiSegment, 1
!!$          !
!!$          !D            Write (6,*) ' Segment #:   ', ii
!!$          !D            Write (6,*) ' newsubscan:  ', segList(ii)%newSubscan
!!$          !D            Write (6,*) ' ssType:      ', segList(ii)%ssType
!!$          !
!!$          ! ***    start new subscan
!!$          If (segList(ii)%newSubscan) Then
!!$             !
!!$             CMD =  programName//B//'SUBSCAN'
!!$             lCMD = lenc(CMD)
!!$             !
!!$             Write (iUnit,*) "! ", CMD(1:lCMD)
!!$             Write (iUnit,*) CMD(1:lCMD), " /defaults"
!!$             !
!!$             If (ii .Eq. 1) Then
!!$                Write (iUnit,*) CMD(1:lCMD),                           &
!!$                     &                            " /initialize ", "yes"
!!$             Else
!!$                Write (iUnit,*) CMD(1:lCMD),                           &
!!$                     &                            " /initialize ", "no"
!!$             End If
!!$             !
!!$             l = lenc(segList(ii)%systemName)
!!$             Write (iUnit,*) CMD(1:lCMD),                              &
!!$                  &                 " /system "//Q//segList(ii)%systemName(1:l)//Q
!!$             !
!!$             Write (iUnit,*) CMD(1:lCMD),                              &
!!$                  &                 " /tRecord ", segList(ii)%tRecord
!!$             !
!!$             Write (iUnit,*) CMD(1:lCMD),                              &
!!$                  &                 " /writeToSub ", "yes"
!!$             !
!!$             Write (iUnit,*) "!"
!!$             !
!!$          End If
!!$          !
!!$          If (segList(ii)%ssType.Eq.ss%on .And.                        &
!!$               &          segList(ii)%segType.Eq.seg%track) Then
!!$             ! TBD
!!$          End If
!!$          !
!!$          ! ***    OTF segments
!!$          If (segList(ii)%ssType.Eq.ss%otf) Then
!!$             !
!!$             CMD =  programName//B//'SEGMENT'
!!$             lCMD = lenc(CMD)
!!$             !
!!$             Write (iUnit,*) "! ", CMD(1:lCMD)
!!$             !
!!$             l = lenc(segList(ii)%segType)
!!$             Write (iUnit,*) CMD(1:lCMD),                              &
!!$                  &               ' '//segList(ii)%segType(1:l)//'-'                  
!!$             !                                                                        
!!$             If (     segList(ii)%segType.Eq.seg%track  ) Then         
!!$                Write (iUnit,*)                                        &
!!$                     &              ' ',segList(ii)%Pstart                               
!!$             Else                                                      
!!$                Write (iUnit,*)                                        &
!!$                     &               ' ',segList(ii)%Pstart,'-'                          
!!$             End If
!!$             !                                                                        
!!$             If (     segList(ii)%segType.Eq.seg%linear ) Then         
!!$                Write (iUnit,*)                                        &
!!$                     &               ' ',segList(ii)%Pend                                
!!$             Else                                                      
!!$                Write (iUnit,*)                                        &
!!$                     &              ' ',segList(ii)%Pend,'-'                             
!!$             End If
!!$             !                                                                        
!!$             If (     segList(ii)%segType.Eq.seg%circle ) Then         
!!$                Write (iUnit,*)                                        &
!!$                     &              ' ',segList(ii)%turnAngle                            
!!$             End If
!!$             !                                                                        
!!$             If (     segList(ii)%segType.Eq.seg%curve  ) Then         
!!$                Write (iUnit,*)                                        &
!!$                     &              ' ',segList(ii)%CPStart,'-'                          
!!$                Write (iUnit,*)                                        &
!!$                     &              ' ',segList(ii)%CPEnd
!!$             End If
!!$             !
!!$             If (segList(ii)%flagRef) Then
!!$                Write (iUnit,*) CMD(1:lCMD),                           &
!!$                     &              ' /flagRef ', 'yes'
!!$             Else
!!$                Write (iUnit,*) CMD(1:lCMD),                           &
!!$                     &              ' /flagRef ', 'no'
!!$             End If
!!$             !
!!$             If (segList(ii)%altOption.Eq.'SPEED') Then
!!$                Write (iUnit,*) CMD(1:lCMD),                           &
!!$                     &              ' /speed ',                                          &
!!$                     &                segList(ii)%speedStart,                            &
!!$                     &                segList(ii)%speedEnd
!!$             Else 
!!$                Write (iUnit,*) CMD(1:lCMD),                           &
!!$                     &              ' /tSegment ', segList(ii)%tSegment
!!$             End If
!!$             !
!!$             Write (iUnit,*) CMD(1:lCMD),                              &
!!$                  &              ' /writeToSeg ', 'yes'
!!$             !
!!$             Write (iUnit,*) '!'
!!$             !
!!$          End If
!!$          !
!!$       End Do
!!$       !
!!$    Else
!!$       !
!!$       Write (messageText,*) '   list of subscans and segments is empty.'
!!$       Call PakoMessage(priorityW,severityW,'SAVE '//commandToSave,messageText)
!!$       Write (messageText,*) '      -- specify at least 1 subscan and 1 segment!'
!!$       Call PakoMessage(priorityW,severityW,'SAVE '//commandToSave,messageText)
!!$       !
!!$    End If
!!$    !
!!$    Return
!!$  End Subroutine SaveSubscanList
!!$!!!
!!$!!!   TBD: imcomplete!
!!$  Subroutine startSubscanList(programName,LINE,commandToSave,        &
!!$       &        OMselected, iUnit, ERROR)
!!$    !
!!$    ! *** Variables ***
!!$    Include 'inc/variables/headerForSaveMethods.inc'
!!$    !
!!$    Integer            :: ii
!!$    Character (len=24) :: valueC
!!$    Character (len=48) :: valueComment
!!$    Logical            :: errorXML
!!$    ! 
!!$    Logical            :: inOtfSubscan
!!$    !
!!$    Character(len=128) ::  messageText
!!$    !
!!$    !D       Write (6,*) '   --> moduleSubscanList: SR startSubscanList '
!!$    !
!!$    Call pakoXMLsetOutputUnit(iunit)
!!$    Call pakoXMLsetIndent(2)
!!$    !
!!$    If (iiSegment.Ge.1) Then
!!$       !
!!$       Include 'inc/startXML/subScanListSubscansXML.inc'
!!$       !   
!!$    Else
!!$       !
!!$       Write (messageText,*) '   list of subscans and segments is empty.'
!!$       Call PakoMessage(priorityW,severityW,'START '//commandToSave,messageText)
!!$       Write (messageText,*) '      -- specify at least 1 subscan and 1 segment!'
!!$       Call PakoMessage(priorityW,severityW,'START '//commandToSave,messageText)
!!$       !
!!$    End If
!!$    !
!!$    Return
!!$  End Subroutine startSubscanList
!!$!!!
!!!
  Subroutine writeXMLsubscanList(programName,LINE,commandToSave,        &
       &        iUnit, ERROR)
    !
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Integer            :: ii
    Character (len=24) :: valueC
    Character (len=48) :: valueComment
    Logical            :: errorXML
    ! 
    Character(len=128) :: messageText
    !
    Logical            :: inOtfSubscan
    !
    ERROR = .False.
    !
    !D            Write (6,*) '   --> moduleSubscanList: SR writeXMLsubscanList '
    !D            Write (6,*) '       iiSegment: ', iiSegment
    !
    If (iiSegment.Ge.1) Then
       !
!!$       Include 'inc/startXML/subScanListSubscansXML.inc'
       !
       !D       Write (6,*) "iiSegment:            ", iiSegment
       !D       Write (6,*) "number of segments:   ", nSegments
       !
       Call pakoXMLwriteStartElement("RESOURCE","subscans",                  &
            &                         comment="generated by paKo",           &
            &                         space ="before",                       &
            &                         error=errorXML)
       !
       inOtfSubscan = .False.
       !
       Do ii = 1,nSegments, 1
          !
          !D          Write (6,*) ' Segment #:   ', ii
          !D          Write (6,*) ' newsubscan:  ', segList(ii)%newSubscan
          !D          Write (6,*) segList(ii)%ssType
          !
          If      (segList(ii)%ssType .Eq. ss%cc) Then
             Include 'inc/startXML/segCalColdXML.inc'
             !
          Else If (segList(ii)%ssType .Eq. ss%ca) Then
             Include 'inc/startXML/segCalAmbientXML.inc'
             !
          Else If (segList(ii)%ssType .Eq. ss%cs) Then
             Include 'inc/startXML/segCalSkyXML.inc'
             !
          Else If (segList(ii)%ssType.Eq.ss%on .And.                          &
               &       segList(ii)%segType.Eq.seg%track) Then
             Include 'inc/startXML/trackXML.inc'
          Else If (segList(ii)%ssType.Eq.ss%ref .And.                          &
               &       segList(ii)%segType.Eq.seg%track) Then
             Include 'inc/startXML/trackXML.inc'
          Else If (segList(ii)%ssType.Eq.ss%track .And.                          &
               &       segList(ii)%segType.Eq.seg%track) Then
             Include 'inc/startXML/trackXML.inc'
          Else If (segList(ii)%ssType.Eq.ss%VLBI .And.                          &
               &       segList(ii)%segType.Eq.seg%track) Then
             Include 'inc/startXML/vlbiTrackXML.inc'
          End If
          !
          ! ***    OTF subscan
          If (segList(ii)%ssType.Eq.ss%otf) Then
             !
             ! ***       start of OTF subscan
             If (segList(ii)%newSubscan) Then
                inOtfSubscan = .True.
                Call pakoXMLwriteStartElement("RESOURCE","subscan",          &
                     &                         error=errorXML)
                valueC = segList(ii)%ssType
                Call pakoXMLcase(valueC,error=errorXML)
                If (valueC.Eq."OTF") valueC="onTheFly"
                Call pakoXMLwriteElement("PARAM","type",valueC,              &
                     &                         dataType="char",              &
                     &                         error=errorXML)
                valueC = segList(ii)%systemName
                Call pakoXMLcase(valueC,error=errorXML)
                If (valueC.Eq."horizontalT") valueC="horizontalTrue"
                Call pakoXMLwriteElement("PARAM","systemOffset",valueC,      &
                     &                         dataType="char",              &
                     &                         error=errorXML)
                ! TBD:     Write (valueC,*) segList(ii)%tRecord
                ! TBD:     Call pakoXMLwriteElement("PARAM","tRecord",valueC,&
                ! TBD:  &                  dataType="char",                  &
                ! TBD:  &                  error=errorXML)
                Call pakoXMLwriteStartElement("RESOURCE","segments",         &
                     &                         error=errorXML)
             End If
             !
             ! ***       OTF segments
             If (segList(ii)%ssType.Eq.ss%otf .And.                          &
                  &       segList(ii)%segType.Eq.seg%track) Then
                Include 'inc/startXML/segTrackXML.inc'
             End If
             !
             If (segList(ii)%ssType.Eq.ss%otf .And.                          &
                  &       segList(ii)%segType.Eq.seg%linear) Then
                Include 'inc/startXML/segLinearXML.inc'
             End If
             !
             If (segList(ii)%ssType.Eq.ss%otf .And.                          &
                  &       segList(ii)%segType.Eq.seg%circle) Then
                Include 'inc/startXML/segCircleXML.inc'
             End If
             !
             If (segList(ii)%ssType.Eq.ss%otf .And.                          &
                  &       segList(ii)%segType.Eq.seg%curve) Then
                Include 'inc/startXML/segCurveXML.inc'
             End If
             !
             ! ***       end of OTF subscan
             If (ii.Eq.iiSegment .Or.                                        &
                  &  ii.Lt.iiSegment .And. segList(ii+1)%newSubscan) Then
                Call pakoXMLwriteEndElement("RESOURCE","segments",           &
                     &                         error=errorXML)
                Call pakoXMLwriteEndElement("RESOURCE","subscan",            &
                     &                         error=errorXML)
                inOtfSubscan = .False.
             End If
             !
          End If
          !
       End Do
       !
       Call pakoXMLwriteEndElement("RESOURCE","subscans",                    &
            &                         error=errorXML)
       !
       !   
    Else
       !
       Write (messageText,*) '   list of subscans and segments is empty.'
       Call PakoMessage(priorityW,severityW,'START '//commandToSave,messageText)
       !
    End If
    !
    Return
  End Subroutine writeXMLsubscanList
!!!
!!!
  Subroutine printSegmentList  (error)
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
!!obsolete    Integer            :: ii
    Logical            :: error
    ! 
!!obsolete    Character(len=128) ::  messageText
    !
    Write (6,*) '   --> moduleSubscanList: SR printSegmentList '
    Write (6,*) '       iiSegment: ', iiSegment
    !
    If (iiSegment.Ge.1) Then
       !
       Do ii = 1, iiSegment, 1
          Write (6,*) '  ii                ', ii
          Write (6,*) '     newSubscan     ', segList(ii)%newSubscan  
          Write (6,*) '     scanNumber     ', segList(ii)%scanNumber  
          Write (6,*) '     ssNumber       ', segList(ii)%ssNumber    
          Write (6,*) '     segNumber      ', segList(ii)%segNumber   
          Write (6,*) '     ssType         ', segList(ii)%ssType      
          Write (6,*) '     segType        ', segList(ii)%segType     
          Write (6,*) '     angleUnit      ', segList(ii)%angleUnit   
          Write (6,*) '     speedUnit      ', segList(ii)%speedUnit   
          Write (6,*) '     flagOn         ', segList(ii)%flagOn      
          Write (6,*) '     flagRef        ', segList(ii)%flagRef     
          Write (6,*) '     pStart         ', segList(ii)%pStart      
          Write (6,*) '     pEnd           ', segList(ii)%pEnd        
          Write (6,*) '     lengthOtf      ', segList(ii)%lengthOtf   
          Write (6,*) '     turnAngle      ', segList(ii)%turnAngle   
          Write (6,*) '     CPstart        ', segList(ii)%CPstart     
          Write (6,*) '     CPend          ', segList(ii)%CPend       
          Write (6,*) '     systemName     ', segList(ii)%systemName  
          Write (6,*) '     altOption      ', segList(ii)%altOption   
          Write (6,*) '     speedStart     ', segList(ii)%speedStart  
          Write (6,*) '     speedEnd       ', segList(ii)%speedEnd    
          Write (6,*) '     tSegment       ', segList(ii)%tSegment    
          Write (6,*) '     tRecord        ', segList(ii)%tRecord     
          Write (6,*) '     focusOffset    ', segList(ii)%focusOffset
          Write (6,*) '     directionFocus ', segList(ii)%directionFocus
       End Do
       !   
    Else
       !
       Write (messageText,*) '   list of subscans and segments is empty.'
       Call PakoMessage(priorityW,severityW,'printSegmentList ',messageText)
       !
    End If
    !
    Return
  End Subroutine printSegmentList
!!!
!!!
  Subroutine listSegmentList  (error)
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    !!obsolete    Integer            :: ii
    Logical            :: error
    ! 
    !!obsolete    Character(len=128) ::  messageText
    !
    Write (6,*) '   --> moduleSubscanList: SR listSegmentList '
    Write (6,*) '        nSegments: ',  nSegments
    Write (6,*) '       iiSegment:  ', iiSegment
    !
    If (iiSegment.Ge.1) Then
       !
       Do ii = 1, iiSegment, 1
          !
          If (segList(ii)%ssType .Eq. ss%otf) Then
             Write (messageText,*)  "  subscan #:   ", ii," ",           &
                  &  segList(ii)%ssType,  " ",                           &
                  &  segList(ii)%segType, " ",                           &
                  &  "from ", segList(ii)%pStart%x/GV%angleFactorR," ",  &
                  &           segList(ii)%pStart%y/GV%angleFactorR," ",  &
                  &  "to ",   segList(ii)%pEnd%x/GV%angleFactorR,  " ",  &
                  &           segList(ii)%pEnd%y/GV%angleFactorR,  " ",  &
                  &  GV%angleUnitSetC
             !
          Else If (segList(ii)%ssType .Eq. ss%cs) Then
             Write (messageText,*)  "  subscan #:   ", ii," ",           &
                  &  segList(ii)%ssType," ",                             &
                  &  "at ",   segList(ii)%pStart%x/GV%angleFactorR," ",  &
                  &           segList(ii)%pStart%y/GV%angleFactorR," ",  &
                  &  GV%angleUnitSetC
             !
          Else If (segList(ii)%ssType .Eq. ss%track) Then
             If (segList(ii)%flagOn) Then
                Write (messageText,*)  "  subscan #:   ", ii," ",        &
                  &  segList(ii)%ssType," ",traceflag%on,                &
                  &  "at ",   segList(ii)%pStart%x/GV%angleFactorR," ",  &
                  &           segList(ii)%pStart%y/GV%angleFactorR," ",  &
                  &  GV%angleUnitSetC
             Else If (segList(ii)%flagRef) Then
                Write (messageText,*)  "  subscan #:   ", ii," ",        &
                  &  segList(ii)%ssType," ",traceflag%ref,               &
                  &  "at ",   segList(ii)%pStart%x/GV%angleFactorR," ",  &
                  &           segList(ii)%pStart%y/GV%angleFactorR," ",  &
                  &  GV%angleUnitSetC
             End If
             !
          Else
             Write (messageText,*)  "  subscan #:   ", ii," ",           &
                  &  segList(ii)%ssType
             !
          End If
          !
          l = Len_trim(GV%observingMode)
          Call pakoMESSAGE(priorityI,severityI,GV%observingMode(1:l),    &
               &           messageText)
       End Do
       !
    Else
       !
       Write (messageText,*) '   list of subscans and segments is empty.'
       Call PakoMessage(priorityW,severityW,'listSegmentList ',messageText)
       !
    End If
    !
    Return
  End Subroutine listSegmentList
!!!
!!!
  Subroutine getNumberSegments(ii)
    !
    Integer, Intent(out) :: ii
    !
    ii = iiSegment
    !
    Return
    !
  End Subroutine getNumberSegments
!!!
!!!
  Subroutine getCountSubscans(ii)
    !
    Integer, Intent(out) :: ii
    !
    ii = iiSubscan
    !
    Return
  End Subroutine getCountSubscans
!!!
!!!
  Subroutine getCountSegments(ii)
    !
    Integer, Intent(out) :: ii
    !
    ii = iiSegment
    !
    Return
  End Subroutine getCountSegments
!!!
!!!
  Subroutine countSubscans(ii,value)
    !
    Integer, Intent(in), Optional  :: value
    Integer, Intent(out), Optional :: ii
    !
    If (Present(value)) Then
       iiSubscan = value
    Else
       iiSubscan = iiSubscan+1
    End If
    !
    If (Present(ii)) Then
       ii = iiSubscan
    End If
    !
    Return
  End Subroutine countSubscans
!!!
!!!
  Subroutine countSegments(ii,value)
    !
    Integer, Intent(in), Optional  :: value
    Integer, Intent(out), Optional :: ii
    !
    If (Present(value)) Then
       iiSegment = value
    Else
       iiSegment = iiSegment+1
    End If
    !
    If (Present(ii)) Then
       ii = iiSegment
    End If
    !
    Return
  End Subroutine countSegments
!!!
!!!
End Module modulePakoSubscanList
!


