!
! $Id: modulePakoReceiver.f90,v 1.1 2005/03/23 14:26:00 pety Exp $
!     
! <DOCUMENTATION name="modulePakoReceiver">
!   <PROGRAM>
!                Pako
!   <\PROGRAM>
!   <FAMILY>
!                Receiver
!   </FAMILY>
!   <SIBLINGS>
!
!   </SIBLINGS>        
!
!   Pako module for command: Receiver
!
! </DOCUMENTATION> <!-- name="modulePakoReceiver" -->
!
Module modulePakoReceiver
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoDisplayText
  Use modulePakoUtilities
  Use modulePakoGlobalVariables
  !
  Implicit None
  Save
  Private
  Public :: listRX, varReceiver
  Public :: receiver, queryReceiver
  Public :: saveReceiver, writeXMLreceiver
  !     
  ! *** variables for command Receiver ***
  Include 'inc/variables/variablesReceiver.inc'
!!!   
!!!   
Contains
!!!   
!!!
  Subroutine receiver(programName,line,command,error)
    !
    ! *** arguments ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    ! *** ranges *** 
    ! TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesReceiver.inc'
    !
    Write (6,*) " module receiver ---> SR: receiver "
    Write (6,*) "                          "
    !
    ! *** initialize ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/receiverSetDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values   ***
    If (.Not.ERROR) Then
       vars(iIn,:) = vars(iValue,:)
    End If
    !
    ! *** check number of Parameters: 0, n --> at  most n allowed   ***
    ! *** read Parameters, Options (to detect errors)               ***
    ! *** and check for validity and ranges                         ***
    Call checkNofParameters(command,                                  &
         &     0, 4,                                                  &
         &     nArguments,                                            &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersReceiver.inc'      
       ! TBD: options /gainBolo(meter) /channel for bolometer
       Include 'inc/options/readOptionsReceiver.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                       &
            &        (command,option,commandFull,optionFull,          &
            &        commandIndex,optionIndex,iCommand,iOption,       &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/receiverSetDefaults.inc'
       Endif
    Endif
    !
    ! *** read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersReceiver.inc'
       ! TBD: options /gainBolo(meter) /channel for bolometer
       Include 'inc/options/readOptionsReceiver.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       errorInconsistent = .False.
       Include 'inc/parameters/checkConsistentReceiver.inc'
       If (.Not. errorInconsistent) Then
          vars(iTemp,:) = vars(iIn,:)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from Temp into persistent variables   ***
    !
    If (.Not.ERROR) Then
       vars(iValue,:) = vars(iTemp,:)
       listRX         = vars(iValue,:) 
    End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Call displayReceivers
    !
    ! *** list receivers in command line screen ***
    If (.Not.ERROR) Then
       !
       receiverCommand(iRec) = line(1:lenc(line))
       !
       Do ii = 1,nDimReceivers,1
          If (vars(iValue,ii)%isConnected) Then
             If (ii.Eq.iBolo) Then
                l = lenc(vars(iValue,ii)%bolometerName)
                Write (messageText,*)                                 & 
                     &         vars(iValue,ii)%name,                  &
                     &         ' ',                                   &
                     &         vars(iValue,ii)%bolometerName(1:l),    &
                     &         ' connected'
             Else
                l = lenc(vars(iValue,ii)%lineName)
                Write (messageText,*)                                 & 
                     &         vars(iValue,ii)%name,                  &
                     &         ' ',                                   &
                     &         vars(iValue,ii)%lineName(1:l),         &
                     &         ' connected'
             End If
             Call PakoMessage(priorityI,severityI,command,messageText)
          End If
       End Do
       !
    End If
    !
    Return
  End Subroutine receiver
!!!
!!!
  Subroutine displayReceivers
!
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Character(len=24)  :: command
    !
    Include 'inc/display/commandDisplayReceiver.inc'
!
  End Subroutine displayReceivers
!!!
!!!
  Subroutine queryReceiver(queryName, Result)
    !
    Character(len=*), Intent(IN)            ::  queryName
    Logical,          Intent(OUT)           ::  Result
    !
    Integer                                 ::  lenc
    Integer                                 ::  ii, l
    !
    Result = .False.
    !
    l = lenc(queryName)
    !
    !D        Write (6,*) '   --> queryReceiver '
    !D        Write (6,*)                                                      & 
    !D     &            ' Receiver: ',                                         &
    !D     &            queryName
    !
    Do ii = 1, nDimReceivers, 1
       !
       If (vars(iValue,ii)%isConnected) Then
          !D              write (6,*) '   ii, vars(iValue,ii)%name : ',              &
          !D     &                        ii, vars(iValue,ii)%name,                  &
          !D     &                            vars(iValue,ii)%isConnected
          If (vars(iValue,ii)%name(1:l) .Eq. queryName(1:l)) Then
             Result = .True.
          End If
       End If
       !
    End Do
    !
    Return
  End Subroutine queryReceiver
!!!
!!!
  Subroutine saveReceiver(programName,LINE,commandToSave,       &
       &        modeSelected, iUnit, ERROR)

    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods2.inc'
    !
    Integer            :: ii
    Character(len=512) :: messageText
    !
    B = "\"     ! "
    S = " "
    CMD =  programName//B//"RECEIVER"
    lCMD = lenc(CMD)
    !
    ERROR = .False.
    !
    contC = contNN
    !
    Write (iUnit,*) "! "
    Write (iUnit,*) "! ", CMD(1:lCMD)
    Write (iUnit,*) CMD(1:lCMD)," /connect no"
    !
    Do ii = 1,10,1
       If (vars(iValue,ii)%isConnected) Then
!!$               Write (messageText,*)                                   & 
!!$     &         " saving RX: ", vars(iValue,ii)%name
!!$               Call PakoMessage(priorityI,severityI,commandToSave,messageText)
!!$          contC = contNC
!!$          Include 'inc/parameters/saveReceiver.inc'
!!$          If (ii .Eq. iBolo) Then
!!$             contC = contCC
!!$             Include 'inc/parameters/saveNameBolometer.inc'
!!$             Include 'inc/parameters/saveGainBolometer.inc'
!!$             contC = contCN
!!$             Include 'inc/parameters/saveChannel.inc'
!!$          Else
!!$             contC = contCC
!!$             Include 'inc/parameters/saveLineName.inc'
!!$             Include 'inc/parameters/saveFrequency.inc'
!!$             Include 'inc/parameters/saveSideBand.inc'
!!$             rxName = vars(iValue,ii)%name
!!$             lName  = lenc(rxName)
!!$             Include 'inc/options/saveDoppler.inc'
!!$             Include 'inc/options/saveWidth.inc'
!!$             Include 'inc/options/saveGain.inc'
!!$             Include 'inc/options/saveTempLoad.inc'
!!$             Include 'inc/options/saveEfficiency.inc'
!!$             contC = contCN
!!$             Include 'inc/options/saveScale.inc'
!!$          End If
       Else
!!$               l = lenc(vars(iValue,ii)%name)
!!$               Write (iUnit,*) "!"
!!$               Write (iUnit,*) CMD(1:lCMD)," ",                        &
!!$     &         vars(iValue,ii)%name(1:l)," /connect ", "no"
       End If
    End Do
    !
    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveReceiver
!!!
!!!
  Subroutine writeXMLreceiver(programName,LINE,commandToSave,         &
       &        iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Logical :: errorXML
    Logical :: errorNotFound, errorNotUnique
    !
    Integer :: ii, jj
    Character (len=lenCh) :: valueC
    Character (len=lenLine) :: valueComment
    !
    ERROR = .False.
    !
!!$      write (6,*)  "      moduleReceiver --> SR: writeXMLreceiver "
    !
    Include 'inc/startXML/receiver.inc'
    !
    Return
  End Subroutine writeXMLreceiver
!!!
!!!
  Subroutine checkLine(NAME,LNAME,PAR,LPAR,FOUND)
    Character(len=*) NAME,PAR
    Integer LNAME,LPAR
    Logical FOUND
    !
    Integer J,K,J1,J2,NAME_OUT,JK
    Character(len=80) NOM
    Data NAME_OUT/0/
    !
    ! Syntax  is   NAME1[|NAME2[|NAME3]]
    !
!!$      Write (6,*) "   ---> SR: checkLine "
!!$      write (6,*) "        name   ->", name(1:lname)
!!$      Write (6,*) "        par    ->", par(1:lpar)
    !
    If (.Not.FOUND) Then
       JK = 1
       Do While (.Not.FOUND .And. JK.Lt.LPAR)
          J = Index(PAR(JK:LPAR),NAME(1:LNAME))
          FOUND = J.Ne.0
          If (.Not.FOUND) Return
          K = JK-1+J-1
          If (K.Gt.0 .And. PAR(K:K).Ne.'|') FOUND = .False.
          K = JK-1+J+LNAME
          If (K.Le.LPAR .And. PAR(K:K).Ne.'|') FOUND = .False.
          JK = K
       Enddo
       If (.Not.FOUND) Return
       ! Use only one name if NAME_OUT is set
       If (NAME_OUT.Eq.0) Then
          PAR = NAME(1:LNAME)
          LPAR = LNAME
          ! Use all names
       Elseif (NAME_OUT.Eq.-1) Then
          Return
       Endif
    Elseif (NAME_OUT.Eq.-1) Then
       Return
    Else
       ! Extract name of order NAME_OUT
       J = 0
       J1 = 1
       Do While (.True.)
          J2 = Index(PAR(J1:LPAR),'|')
          If (J2.Eq.0) Then
             NOM = PAR(J1:LPAR)
             LPAR = LPAR-J1+1
             PAR = NOM
             Return
          Endif
          J2 = J2+J1-2
          If (J.Eq.NAME_OUT) Then
             NOM = PAR(J1:J2)
             LPAR = J2-J1+1
             PAR = NOM
             Return
          Endif
          J1 = J2+2
          J = J+1
       Enddo
    Endif
  End Subroutine checkLine
!!!
!!!
End Module modulePakoReceiver











