!     $Id: modulePakoOtfMap.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!     Family:   OBSERVING MODES
!     Siblings: moduleOtfmap.f90
!
!----------------------------------------------------------------------
!     PAKO module for OTFMAP
!
Module modulePakoOtfmap
  !
  Use modulePakoTypes
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoUtilities
  Use modulePakoPlots
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  Use modulePakoSubscanList
  Use modulePakoReceiver
  Use modulePakoBackend
  Use modulePakoSource
  Use modulePakoSwBeam
  Use modulePakoSwWobbler
  Use modulePakoSwTotalPower
  !
  Implicit None
  Save
  Private
  Public :: otfMap, saveOtfMap, startOtfMap
  !     
  ! *** Variables for otfmap ***
  Include 'inc/variables/variablesOtfMap.inc'
!!!   
Contains
!!!
!!!
  Subroutine OTFMAP(programName,line,command,                    &
       &        error)
    !
    ! *** Arguments ***
    Include 'inc/variables/headerForCommandHandler.inc'
    !
    ! *** standard working variables ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
!!$      Integer              ::  iMatch = 0 , nMatch = 0
!!$      Character (len=128)  ::  errorCode = 'none'
!!$      Logical              ::  errorM = .False.
    !
    ! *** special working variables:   ***
    Logical               :: optionSpeedIsPresent, optionTotfIsPresent
    Logical, Dimension(3) :: alternative
    Real                  :: vIn, vStdMin, vStdMax, vLimitMin, vLimitMax
    !
    optionSpeedIsPresent = .False.
    optionTotfIsPresent  = .False.
    alternative          = .False.
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesOtfMap.inc'
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/setDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    Call checkNofParameters(command,                                 &
         &     0, 4,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    !
    ! *** check for alternative Options   ***
    If (.Not. ERROR) Then
       Include 'inc/options/alternativeSpeedTotf.inc'
    End If
    !
    ! *** read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersStartEnd.inc'
       Include 'inc/parameters/parametersLengthOtf.inc'
       Include 'inc/options/readOptionsOtfMap.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/setDefaults.inc'
       Endif
    Endif
    !
    ! *** Read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersStartEnd.inc'
       Include 'inc/parameters/parametersLengthOtf.inc'
       Include 'inc/options/readOptionsOtfMap.inc'
       Include 'inc/options/alternativeSpeedTotfSet.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       !
       errorInconsistent = .False.
       !
       Include 'inc/options/checkConsistentLengthOtfSpeedTotf.inc'
       !
       If (.Not. errorInconsistent) Then
          Include 'inc/options/checkConsistentNresumeNotf.inc'
       End If
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** conclude alternative options   ***
    If (.Not.error) Then
       Include 'inc/options/alternativeSpeedTotfEnd.inc'
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from temporary into final variables ***
    If (.Not.ERROR) Then
       vars(iValue)  = vars(iTemp)
       GV%tRecord    = vars(iValue)%tRecord 
    End If
    !
    ! *** display values ***
    !     (Note: this is done indepenently of the Error status)
    Include 'inc/display/commandDisplayOtfMap.inc'
    !
    ! *** set "selected" observing mode & plot ***
    If (.Not.error) Then
       GV%observingMode = command
       Write (6,*) "        GV%observingMode ->", GV%observingMode(1:len_trim(GV%observingMode)), "<-"        

       otfMapCommand = line(1:lenc(line))
       Write (6,*) "        otfMapCommand ->", otfMapCommand(1:len_trim(otfMapCommand)), "<-"

       Call analyzeOtfMap (errorA)
       !D         Call printSegmentList (command,errorA)
       Call plotOtfMap (errorP)
    End If
    !
    Return
  End Subroutine OTFMAP
!!!
!!!
  Subroutine analyzeOtfMap (errorA)
    !
    ! TBD:  support of several reference positions
    ! TBD:  support of /RESUME
    !
    ! <DOCUMENTATION name="analyzeOtfMap">
    !
    ! 
    ! The sequence of subscans is determined by 
    ! /croLoop /nOtf /reference /step /zigzag
    ! 
    ! /croLoop     sequence of 
    !              C Calibration
    !              R off-source Reference
    !              O on-source OTF
    ! /nOtf        number of OTF subscans
    ! /reference   off-source reference position
    ! /step        step in x and y between OTF subscans
    !              = translation of one OTF subscans to the next
    ! /zigzag      option to scan back-and-forth
    ! 
    ! The scan analysis loops through the letter codes in croLoop
    ! until nOtf OTF subscans have been generated, starting with 
    ! first letter in the croLoop.
    !    
    !    IF THE CROCODE LETTER IS "C":
    !    
    !    3 calibration subscans on cold load, ambient load, and sky
    !    are generated. The position of the (sky) calibration subscan is:
    !     - the (next) reference position if /reference is true, else:
    !       - if there is one calibration between 2 OTF subscans,
    !         the start position of the next OTF subscan
    !       - if there are two calibrations between 2 OTF subscans,
    !         the first (sky) calibration will be at the end 
    !         the end of the previous OTF subscan
    !    
    !    IF THE CROCODE LETTER IS "R" AND /REFERENCE IS TRUE:
    !    
    !    1 subscan tracking the fixed off-source reference position
    !    is generated
    !    
    !    IF THE CROCODE LETTER IS "O":
    !    
    !    1 linear OTF subscan is generated. 
    !    - The start and end positions of the first OTF subscan are:
    !      parameters xStart yStart xEnd yEnd of the OTFMAP command
    !    - For the second all following OTF subscans:
    !      xStart yStart xEnd yEnd of the previous OTF subscan are
    !      incremented by parameters dx and dy of option /step
    !      If /zigzag is true, xStart yStart and xEnd yEnd are
    !      interchanged
    !    
    ! Then the next letter code in the croLoop is considered
    ! in the same way.
    ! 
    ! If /reference is true,
    ! a croCode ending in "RC" or "R" will ensure that an off-source
    ! reference subscan follows the last OTF subscan.
    ! 
    ! A croCode ending in "C" will ensure that the subscan sequence
    ! ends with 3 calibration subscans on cold load, ambient load, and sky.
    ! - The position of the calibration sky subscan will be that of
    !   the last off-source reference position if /reference is true, else:
    ! - the end(!)  position of the last OTF subscan
    !
    ! </DOCUMENTATION> <!-- name="analyzeOtfMap" -->
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer              :: nScan 
    Character (len=12)   :: aUnit, sUnit
    Integer              :: iCRO          = 0     ! counts through CRO loop
    Integer              :: iCROnext      = 0     !        next iCRO
    Integer              :: iSS           = 0     ! counts subcans/segment
    Integer              :: iOTF          = 0     ! counts OTF subscans
    !
    Character (len=1)    :: cCroII        = ''    ! stores previous CRO code    
    !
    errorA = .False.
    !
    ! TBD:  proper scan numbers
    nScan     = 1111
    aUnit     = GV%angleUnitC
    sUnit     = GV%speedUnitC
    !
    iCRO = 0
    iSS  = 0
    iOTF = 0
    !
    cCroII = ''
    !
    Do While (iOTF .Lt. vars(iValue)%nOtf)
       !
       iCRO     = iCRO+1
       iCROnext = iCRO+1
       !
       !D           write (6,*) "   ++iCRO: ", iCRO
       !
       iCRO = Modulo(iCRO,vars(iValue)%croCodeCount)
       If (iCRO.Eq.0) iCRO = vars(iValue)%croCodeCount
       iCROnext = Modulo(iCROnext,vars(iValue)%croCodeCount)
       If (iCROnext.Eq.0) iCROnext = vars(iValue)%croCodeCount
       !
       !D           write (6,*) "     iCRO:     ", iCRO
       !D           write (6,*) "      CRO(",iCRO,"):   ->",                      &
       !D     &                 vars(iValue)%croCodeBites(iCRO:iCRO),"<-"
       !D           write (6,*) "     iCROnext: ", iCROnext
       !D           write (6,*) "      CRO(",iCROnext,"):   ->",                  &
       !D     &                 vars(iValue)%croCodeBites(iCROnext:iCROnext),"<-"
       !D
       !D           write (6,*) "     iSS:  ", iSS
       !D           write (6,*) "     iOTF: ", iOTF
       !D!
       !D           write (6,*) " is C? ", vars(iValue)%croCodeBites(iCRO:iCRO).eq."C"
       !D           write (6,*) " is c? ", vars(iValue)%croCodeBites(iCRO:iCRO).eq."c"
       !D           write (6,*) " is R? ", vars(iValue)%croCodeBites(iCRO:iCRO).eq."R"
       !D           write (6,*) " is r? ", vars(iValue)%croCodeBites(iCRO:iCRO).eq."r"
       !D           write (6,*) " is O? ", vars(iValue)%croCodeBites(iCRO:iCRO).eq."O"
       !D           write (6,*) " is o? ", vars(iValue)%croCodeBites(iCRO:iCRO).eq."o"
       !
       !D           write (6,*) '      cCroII: ', cCroII
       !
       If (vars(iValue)%croCodeBites(iCRO:iCRO).Eq."C") Then
          !
          iSS = iSS+1
          segList(iSS)            =  segDefault                    ! CAL COLD
          segList(iSS)%newSubscan =  .True.
          segList(iSS)%scanNumber =  nScan
          segList(iSS)%ssNumber   =  iSS
          segList(iSS)%segNumber  =  1
          segList(iSS)%ssType     =  ss%cc
          segList(iSS)%segType    =  seg%track
          segList(iSS)%angleUnit  =  aUnit
          segList(iSS)%speedUnit  =  sUnit
          segList(iSS)%flagOn     =  .False.
          segList(iSS)%flagRef    =  .False.
          If (vars(iValue)%doReference) Then
             segList(iSS)%pStart     =  vars(iValue)%offsetR
          Else If (iOTF.Eq.0) Then
             segList(iSS)%pStart     =  vars(iValue)%pStart
          Else If (vars(iValue)%croCodeBites(iCROnext:iCROnext).Eq."C") Then
             segList(iSS)%pStart%x   =  segOtfII%pEnd%x
             segList(iSS)%pStart%y   =  segOtfII%pEnd%y
          Else If (vars(iValue)%doZigzag) Then
             segList(iSS)%pStart%x   =  segOtfII%pEnd%x+vars(iValue)%delta%x
             segList(iSS)%pStart%y   =  segOtfII%pEnd%y+vars(iValue)%delta%y
          Else
             segList(iSS)%pStart%x   =  segOtfII%pStart%x+vars(iValue)%delta%x
             segList(iSS)%pStart%y   =  segOtfII%pStart%y+vars(iValue)%delta%y
          End If
          segList(iSS)%pEnd       =  segList(iSS)%pStart
          segList(iSS)%speedStart =  0.0
          segList(iSS)%speedEnd   =  0.0
          ! TBD: systemName in case of REF sysem .NE. OTF system
          segList(iSS)%systemName =  vars(iValue)%systemName
          segList(iSS)%altOption  =  'tSegment'
          ! TBD: time from CALIBRATE
          segList(iSS)%tSegment   =  5.0
          segList(iSS)%tRecord    =  vars(iValue)%tRecord
          Write (messageText,*)  "  subscan #:   ", iSS,        &
               &           segList(iSS)%ssType
          Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
          !
          iSS = iSS+1
          segList(iSS)            =  segList(iSS-1)                ! CAL AMBIENT
          segList(iSS)%ssNumber   =  iSS
          segList(iSS)%ssType     =  ss%ca
          Write (messageText,*)  "  subscan #:   ", iSS,        &
               &           segList(iSS)%ssType
          Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
          !
          iSS = iSS+1
          segList(iSS)            =  segList(iSS-1)                ! CAL SKY
          segList(iSS)%ssNumber   =  iSS
          segList(iSS)%ssType     =  ss%cs
          Write (messageText,*)  "  subscan #:   ", iSS,        &
               &           segList(iSS)%ssType, segList(iSS)%pStart
          Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
          !
          cCroII = vars(iValue)%croCodeBites(iCRO:iCRO)
          !
       End If
       !
       If (vars(iValue)%doReference .And.                            &
            &         vars(iValue)%croCodeBites(iCRO:iCRO).Eq."R") Then
          !
          iSS = iSS+1
          segList(iSS)            =  segDefault                    ! REFERENCE
          segList(iSS)%newSubscan =  .True.
          segList(iSS)%scanNumber =  nScan
          segList(iSS)%ssNumber   =  iSS
          segList(iSS)%segNumber  =  1
          segList(iSS)%ssType     =  ss%ref
          segList(iSS)%segType    =  seg%track
          segList(iSS)%angleUnit  =  aUnit
          segList(iSS)%speedUnit  =  sUnit
          segList(iSS)%flagOn     =  .False.
          segList(iSS)%flagRef    =  .True.
          segList(iSS)%pStart     =  vars(iValue)%offsetR
          segList(iSS)%pEnd       =  vars(iValue)%offsetR
          ! TBD: system name for REF
          segList(iSS)%systemName =  vars(iValue)%systemName
          segList(iSS)%altOption  =  'tSegment'
          segList(iSS)%speedStart =  0.0
          segList(iSS)%speedEnd   =  0.0
          segList(iSS)%tSegment   =  vars(iValue)%tReference
          segList(iSS)%tRecord    =  vars(iValue)%tRecord
          Write (messageText,*)  "  subscan #:   ", iSS,        &
               &           segList(iSS)%ssType, segList(iSS)%pStart
          Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
          !
          cCroII = vars(iValue)%croCodeBites(iCRO:iCRO)
          !
       End If
       !
       If (vars(iValue)%croCodeBites(iCRO:iCRO).Eq."O") Then
          !
          iSS  = iSS+1
          iOTF = iOTF+1
          If (iOTF.Eq.1) Then
             segOtfII            =  segDefault                    ! first OTF
             segList(iSS)%newSubscan =  .True.
             segOtfII%scanNumber =  nScan
             segOtfII%ssNumber   =  iSS
             segOtfII%segNumber  =  1
             segOtfII%ssType     =  ss%otf
             segOtfII%segType    =  seg%linear
             segOtfII%angleUnit  =  aUnit
             segOtfII%speedUnit  =  sUnit
             segOtfII%flagOn     =  .True.
             segOtfII%flagRef    =  .False.
             segOtfII%pStart     =  vars(iValue)%pStart  
             segOtfII%pEnd       =  vars(iValue)%pEnd  
             segOtfII%lengthOtf  =  vars(iValue)%lengthOtf
             segOtfII%systemName =  vars(iValue)%systemName
             segOtfII%altOption  =  vars(iValue)%altOption
             segOtfII%speedStart =  vars(iValue)%speedStart
             segOtfII%speedEnd   =  vars(iValue)%speedEnd
             segOtfII%tSegment   =  vars(iValue)%tOtf
             segOtfII%tRecord    =  vars(iValue)%tRecord
             segList(iSS)        =  segOtfII
          Else                                                 ! More OTF
             segOtfII%ssNumber   =  iSS
             If (vars(iValue)%doZigzag) Then
                pII              =  segOtfII%pStart
                segOtfII%pStart  =  segOtfII%pEnd
                segOtfII%pEnd    =  pII
             End If
             segOtfII%pStart%x   =  segOtfII%pStart%x+vars(iValue)%delta%x
             segOtfII%pStart%y   =  segOtfII%pStart%y+vars(iValue)%delta%y
             segOtfII%pEnd%x     =  segOtfII%pEnd%x  +vars(iValue)%delta%x
             segOtfII%pEnd%y     =  segOtfII%pEnd%y  +vars(iValue)%delta%y
             segList(iSS)        =  segOtfII
          End If
          !
          Write (messageText,*)  "  subscan #:   ", iSS,        &
               &           segList(iSS)%ssType, segList(iSS)%pStart, " to ",       &
               &           segList(iSS)%pEnd
          Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
          !
          cCroII = vars(iValue)%croCodeBites(iCRO:iCRO)
          !
       End If
       !
    End Do
    !
    nSegments = iSS
    !
    ii = vars(iValue)%croCodeCount
    If (vars(iValue)%doReference                                  &
         &         .And.((vars(iValue)%croCodeBites(ii:ii).Eq."R"            &      
         &                   .And. (segList(nSegments)%ssType.Eq.ss%otf))    &
         &               .Or.                                                &
         &               (vars(iValue)%croCodeBites(ii-1:ii).Eq."RC"         &      
         &                   .And. (segList(nSegments)%ssType.Eq.ss%otf))    &
         &              )                                                    &
         &        ) Then
       !
       iSS  = iSS+1
       segList(iSS)            =  segDefault                    ! add REFERENCE at end
       segList(iSS)%newSubscan =  .True.
       segList(iSS)%scanNumber =  nScan
       segList(iSS)%ssNumber   =  iSS
       segList(iSS)%segNumber  =  1
       segList(iSS)%ssType     =  ss%ref
       segList(iSS)%segType    =  seg%track
       segList(iSS)%angleUnit  =  aUnit
       segList(iSS)%speedUnit  =  sUnit
       segList(iSS)%flagOn     =  .False.
       segList(iSS)%flagRef    =  .True.
       segList(iSS)%pStart     =  vars(iValue)%offsetR  
       segList(iSS)%pEnd       =  vars(iValue)%offsetR  
       segList(iSS)%systemName =  vars(iValue)%systemName
       segList(iSS)%altOption  =  'tSegment'
       segList(iSS)%speedStart =  0.0
       segList(iSS)%speedEnd   =  0.0
       segList(iSS)%tSegment   =  vars(iValue)%tReference
       segList(iSS)%tRecord    =  vars(iValue)%tRecord
       Write (messageText,*)  "  subscan #:   ", iSS,        &
            &           segList(iSS)%ssType, segList(iSS)%pStart
       Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
       !
       cCroII = vars(iValue)%croCodeBites(iCRO:iCRO)
       !
    End If
    !
    nSegments = iSS
    !
    ii = vars(iValue)%croCodeCount
    If ( vars(iValue)%croCodeBites(ii:ii).Eq."C"                  &      
         &         .And. .Not. (segList(nSegments)%ssType.Eq.ss%cs)          &
         &        ) Then
       !                                                                      ! add CAL at end
       iSS  = iSS+1
       segList(iSS)            =  segDefault                    ! CAL COLD
       segList(iSS)%newSubscan =  .True.
       segList(iSS)%scanNumber =  nScan
       segList(iSS)%ssNumber   =  iSS
       segList(iSS)%segNumber  =  1
       segList(iSS)%ssType     =  ss%cc
       segList(iSS)%segType    =  seg%track
       segList(iSS)%angleUnit  =  aUnit
       segList(iSS)%speedUnit  =  sUnit
       segList(iSS)%flagOn     =  .False.
       segList(iSS)%flagRef    =  .False.
       If (vars(iValue)%doReference) Then
          segList(iSS)%pStart  =  vars(iValue)%offsetR  
       Else
          segList(iSS)%pStart  =  segOtfII%pEnd  
       End If
       segList(iSS)%pEnd       =  segList(iSS)%pStart  
       segList(iSS)%speedStart =  0.0
       segList(iSS)%speedEnd   =  0.0
       ! TBD: case ref system
       segList(iSS)%systemName =  vars(iValue)%systemName
       segList(iSS)%altOption  =  'tSegment'
       ! TBD: time from CALIBRATE
       segList(iSS)%tSegment   =  5.0
       segList(iSS)%tRecord    =  vars(iValue)%tRecord
       Write (messageText,*)  "  subscan #:   ", iSS,        &
            &           segList(iSS)%ssType
       Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
       !
       iSS = iSS+1
       segList(iSS)            =  segList(iSS-1)                ! CAL AMBIENT
       segList(iSS)%ssType     =  ss%ca
       Write (messageText,*)  "  subscan #:   ", iSS,        &
            &           segList(iSS)%ssType
       Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
       !
       iSS = iSS+1
       segList(iSS)            =  segList(iSS-1)                ! CAL SKY
       segList(iSS)%ssType     =  ss%cs
       Write (messageText,*)  "  subscan #:   ", iSS,        &
            &           segList(iSS)%ssType, segList(iSS)%pStart
       Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
       !
       cCroII = vars(iValue)%croCodeBites(iCRO:iCRO)
       !
    End If
    !
    nSegments = iSS
    !
    Write (messageText,*)  "   number of Subscans/Segments: ", nSegments
    Call pakoMessage(priorityI,severityI,"OTFMAP "//" Analyze",messageText)
    !
    Return 
    !
  End Subroutine analyzeOtfMap
!!!
!!!
  Subroutine plotOtfMap (errorP)
    !
    !**   Variables  for Plots   ***
    Include 'inc/variables/headerForPlotMethods.inc'
    !
    !**   standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    errorP = .False.
    !
    Call configurePlots
    !
!!$      Call plotOtfMapStart(errorP)
    !
    ! TBD: replace the following by general plot of segList
    !
    jj = 0                     ! jj counts OTF subscans / segments
    !
    Do ii = 1, nSegments, 1
       !
!!$         write (6,*) "segList(ii)%ssType: ", segList(ii)%ssType
!!$         write (6,*) "segList(ii)%segType: ", segList(ii)%segType
       !
       If (segList(ii)%ssType .Eq.ss%cs .And.                          &
            &       segList(ii)%segType.Eq.seg%track) Then
          Call plotCalSky(segList(ii)%pStart%x,segList(ii)%pStart%y,      &
               &                    errorP,                                       &
               &                    number=segList(ii)%ssNumber,                   &
               &                    Type=segList(ii)%ssType)
       End If
       !
       If (segList(ii)%ssType .Eq.ss%ref.And.                          &
            &       segList(ii)%segType.Eq.seg%track) Then
          Call plotTrack(segList(ii)%pStart%x,segList(ii)%pStart%y,     &
               &                    errorP,                                       &
               &                    number=segList(ii)%ssNumber,                   &
               &                    Type=segList(ii)%ssType)
       End If
       !
       If (segList(ii)%ssType .Eq.ss%otf .And.                          &
            segList(ii)%segType.Eq.seg%linear) Then
          jj = jj+1
          Call plotOtfLinear(segList(ii)%pStart%x,segList(ii)%pStart%y,  &
               &                         segList(ii)%pEnd%x,segList(ii)%pEnd%y,      &
               &                         errorP,                                   &
               &                         number=jj,                                &
               &                         Type='otfMap')
       End If
       !
    End Do
    !
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !
    errorP =  errorP .Or. GR_ERROR()
    !
    If (errorP)                                                    &
         &        Call pakoMessage(priorityE,severityE,                         &
         &        'OtfMap',' could not plot ')
    !
    Return
  End Subroutine plotOtfMap
!!!
!!!
  Subroutine saveOtfMap(programName,LINE,commandToSave,              &
       &        modeSelected, iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods2.inc'
    !
    contC = contNN
    !
    Include 'inc/commands/saveCommand.inc'
    !
    doContinue = .True.
    !
    contC = contCC
    !
    Include 'inc/parameters/saveStartEnd.inc'
    !
    !TBD:      Include 'inc/options/saveBalance.inc'
    Include 'inc/options/saveCroLoop.inc'
    Include 'inc/options/saveNotf.inc'
    Include 'inc/options/saveReference.inc'
    !TBD      Include 'inc/options/saveResume.inc'
    Include 'inc/options/saveStep.inc'
    Include 'inc/options/saveSystem.inc'
    Include 'inc/options/saveSpeedTotf.inc'
    ! TBD:      Include 'inc/options/saveTrecord.inc'
    Include 'inc/options/saveTreference.inc'
    !
    doContinue = .False.
    contC = contCN
    !
    Include 'inc/options/saveZigzag.inc'

    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveOtfMap
!!!
!!!
  Subroutine startOtfMap(programName,LINE,commandToSave,             &
       &         iUnit, ERROR)
    !
    ! *** Variables ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Integer            :: ii
    Character (len=24) :: valueC
    Character (len=48) :: valueComment
    Logical            :: errorXML
    ! 
    !D        Write (6,*) "   --> startOtfMap   "
    !
    Call pakoXMLsetOutputUnit(iunit=iunit)
    Call pakoXMLsetIndent(iIndent=2)
!!$   Call pakoXMLsetLevel(1)
    !
    Include 'inc/startXML/generalHead.inc'
    !
    Call writeXMLset(programName,LINE,commandToSave,                   &
         &         iUnit, ERROR)
    !
    Call pakoXMLwriteStartElement("RESOURCE","pakoScript",             &
         &                         comment="save from pako",                 &
         &                         error=errorXML)
    Call pakoXMLwriteStartElement("DESCRIPTION",                       &
         &                         doCdata=.True.,                           &
         &                         error=errorXML)
    !
!!$    Call pakoSaveSet(programName,LINE,commandToSave,                  &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveReceiver(programName,LINE,commandToSave,                 &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveBackend(programName,LINE,commandToSave,                  &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveSwitching(programName,LINE,commandToSave,                &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveSource(programName,LINE,commandToSave,                   &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveOtfMap(programName,LINE,commandToSave,                   &
!!$         &         iUnit, ERROR)                                 
    !                                                                       
    Call pakoXMLwriteEndElement("DESCRIPTION",                        &
         &      error=errorXML)                                             
    Call pakoXMLwriteEndElement("RESOURCE", "pakoScript",             &
         &      error=errorXML)
    !
    Call writeXMLreceiver(programName,LINE,commandToSave,             &
         &         iUnit, ERROR)
    !
    Call writeXMLbackend(programName,LINE,commandToSave,              &
         &         iUnit, ERROR)
    !
    Include 'inc/startXML/switchingMode.inc'
    !
    Call writeXMLsource(programName,LINE,commandToSave,              &
         &         iUnit, ERROR)
    !
    Include 'inc/startXML/generalScanHead.inc'
    !
    Include 'inc/startXML/otfMapSubscansXML.inc'
    !   
    Include 'inc/startXML/generalTail.inc'
    !
    Return
  End Subroutine startOtfMap
!!!
!!!
End Module modulePakoOtfmap





