!
!D      write (6,*)  "      source.f90 "
!
      Call pakoXMLwriteStartElement("RESOURCE","source",               &
     &                         comment="generated by paKo",            &
     &                         space ="before",                          &
     &                         error=errorXML)
!
! ** BODY
      If (vars(iValue)%isBody) Then
         !
         Write (valueC,*) "BODY ", vars(iValue)%sourceName
         Write (valueComment,*) "solar system body"
         Call pakoXMLwriteElement("PARAM","sourceName",valueC,                  &
              &                         dataType="char",                        &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(F20.6)') vars(iValue)%perihelionEpoch
         Write (valueComment,*) "JD"
         Call pakoXMLwriteElement("PARAM","perihelionEpoch",valueC,             &
              &                         unit="d",                               &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%ascendingNode*deg
         Write (valueComment,*) vars(iValue)%ascendingNode, au%degree
         Call pakoXMLwriteElement("PARAM","ascendingNode",valueC,               &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%argumentOfPerihelion*deg
         Write (valueComment,*) vars(iValue)%argumentOfPerihelion, au%degree
         Call pakoXMLwriteElement("PARAM","argumentOfPerihelion",valueC,        &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%inclination*deg
         Write (valueComment,*) vars(iValue)%inclination, au%degree
         Call pakoXMLwriteElement("PARAM","inclination",valueC,                 &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(F20.6)') vars(iValue)%perihelionDistance
         Call pakoXMLwriteElement("PARAM","perihelionDistance",valueC,         &
              &                         unit="AU",                              &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(F20.6)') vars(iValue)%eccentricity
         Call pakoXMLwriteElement("PARAM","eccentricity",valueC,                &
              &                         unit="--",                              &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
      End If
!
! **
      If (.Not. vars(iValue)%isBody) Then
         Write (valueC,*) vars(iValue)%sourceName
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","sourceName",valueC,            &
              &                         dataType="char",                        &
              &                         error=errorXML)
      End If
!
      If (.Not. (     vars(iValue)%isBody                               &
           &     .Or. vars(iValue)%isPlanet                             &
           &     .Or. vars(iValue)%isSatellite) ) Then
         !
         ! **  system name is looked up in available choices
         errorNotFound         = .False.
         errorNotUnique        = .False.
         choiceIndex = 0
         !
         Do ii = 1,6,1
            If (      systemNameChoices(ii)(1:2) .Eq.                  &
                 &               vars(iValue)%systemName(1:2) ) Then
               If (choiceIndex .Eq. 0) Then
                  choiceIndex = ii
               Else
                  errorNotUnique = .True.
               End If
            End If
         End Do
         errorNotFound =  choiceIndex .Eq. 0
         !
         If (.Not. errorNotFound) Then
            Write (valueC,*) systemNameChoices(choiceIndex)
         End If
         !
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","basisSystem",valueC,           &
              &                         dataType="char",                        &
              &                         error=errorXML)
         !
         ! TBD: equinoxSystem from SOURCE command
         !
         Write (valueC,*) "J"
         Call pakoXMLwriteElement("PARAM","equinoxSystem",valueC,         &
              &                         dataType="char",                        &
              &                         error=errorXML)
         !
         Write (valueC,*) vars(iValue)%epoch
         Call pakoXMLwriteElement("PARAM","equinoxYear",valueC,           &
              &                         unit="yr",                             &
              &                         dataType="double",                        &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%longitude%rad
         Call pakoXMLwriteElement("PARAM","lambda",valueC,                &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%latitude%rad
         Call pakoXMLwriteElement("PARAM","beta",valueC,                  &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,*) "NONE"
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","desriptiveSystem",valueC,      &
              &                         dataType="char",                        &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","alphaD",valueC,                &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","betaD",valueC,                 &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","gammaD",valueC,                &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,*) "RADIO"
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","projection",valueC,            &
              &                         dataType="char",                        &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","lambdaProjection",valueC,      &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","betaProjection",valueC,        &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","kappaProjection",valueC,       &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
      End If
! **
!
      Call writeXMLoffsets(programName,LINE,commandToSave,               &
     &        iUnit, ERROR)
!
      Call writeXMLtopology(programName,LINE,commandToSave,              &
     &        iUnit, ERROR)
!
      Call writeXMLpointingCorrections(programName,LINE,commandToSave,   &
     &        iUnit, ERROR)
!
      Call writeXMLfocusCorrections(programName,LINE,commandToSave,      &
     &        iUnit, ERROR)
!
      Call pakoXMLwriteEndElement  ("RESOURCE","source",                 &
     &                         space="after",                            &
     &                         error=errorXML)
!



