!
!     $Id: rangesSource.inc,v 1.1 2005/03/23 14:25:48 pety Exp $
!     Family:   
!
      vars(iDefault)%sourceName      = "Mars"
!                                    
!TBD: planetNameChoices(0)           = "Sun"
      planetNameChoices(1)           = "Mercury"
      planetNameChoices(2)           = "Venus"
      planetNameChoices(3)           = "Earth"
      planetNameChoices(4)           = "Mars"
      planetNameChoices(5)           = "Jupiter"
      planetNameChoices(6)           = "Saturn"
      planetNameChoices(7)           = "Uranus"
      planetNameChoices(8)           = "Neptune"
      planetNameChoices(9)           = "Pluto"
!                                    
      satelliteNameChoices(1)        = "Moon"
      satelliteNameChoices(2)        = "Io"
!TBD: other satellites
!
      vars(iDefault)%isBody          = .False.
      vars(iDefault)%isPlanet        = .True.
      vars(iDefault)%isSatellite     = .False.
!
      vars(iDefault)%systemName      = "PLANET"
!
!TBD: other systems
      systemNameChoices(2)           = "EQUATORIAL"
      systemNameChoices(3)           = "GALACTIC"
      systemNameChoices(4)           = "HORIZONTAL"
      systemNameChoices(5)           = "PLANET"
      systemNameChoices(6)           = "ECLIPTIC"
!
      vars(iDefault)%epoch           = 2000.0
      vars(iStd1)%epoch              = 1900.0
      vars(iStd2)%epoch              = 2100.0
      vars(iLimit1)%epoch            = 1800.0
      vars(iLimit2)%epoch            = 2200.0
!
      vars(iDefault)%longitude%rad   = 0.0
      vars(iStd1)%longitude%rad      = 0.0
      vars(iStd2)%longitude%rad      = 2.0d0*Pi
      vars(iLimit1)%longitude%rad    = 0.0
      vars(iLimit2)%longitude%rad    = 2.0d0*Pi
!
      vars(iDefault)%latitude%rad    = 0.0
      vars(iStd1)%latitude%rad       = -Pi/2.0d0
      vars(iStd2)%latitude%rad       =  Pi/2.0d0
      vars(iLimit1)%latitude%rad     = -Pi/2.0d0
      vars(iLimit2)%latitude%rad     =  Pi/2.0d0
!
      vars(iDefault)%velocity%value    = 0.0
      vars(iStd1)%velocity%value       =  -3000.0
      vars(iStd2)%velocity%value       =   3000.0
      vars(iLimit1)%velocity%value     = -10000.0
      vars(iLimit2)%velocity%value     =  10000.0
!
      velocityTypeChoices(1)           = "LSR"
      velocityTypeChoices(2)           = "HEL"
      velocityTypeChoices(3)           = "EARTH"
      velocityTypeChoices(4)           = "PLANET"
      velocityTypeChoices(5)           = "NUL"
      velocityTypeChoices(5)           = "NONE"
!
      vars(iDefault)%flux              =    0.0
      vars(iStd1)%flux                 =    0.0
      vars(iStd2)%flux                 =  100.0
      vars(iLimit1)%flux               =    0.0
      vars(iLimit2)%flux               = 1000.0
!
      vars(iDefault)%index                  =   0.0
         vars(iStd1)%index                  =  -3.0
         vars(iStd2)%index                  =   3.0
       vars(iLimit1)%index                  = -10.0
       vars(iLimit2)%index                  =  10.0
!
      vars(iDefault)%perihelionEpoch        =  2450000.0000D0
         vars(iStd1)%perihelionEpoch        =  2450000.0000D0
         vars(iStd2)%perihelionEpoch        =  2460000.0000D0
       vars(iLimit1)%perihelionEpoch        =  2400000.0000D0
       vars(iLimit2)%perihelionEpoch        =  2500000.0000D0
!
      vars(iDefault)%ascendingNode          =     0.0D0
         vars(iStd1)%ascendingNode          =  -360.0D0
         vars(iStd2)%ascendingNode          =   360.0D0
       vars(iLimit1)%ascendingNode          =  -360.0D0
       vars(iLimit2)%ascendingNode          =   360.0D0
!
      vars(iDefault)%argumentOfPerihelion   =     0.0D0
         vars(iStd1)%argumentOfPerihelion   =  -360.0D0
         vars(iStd2)%argumentOfPerihelion   =   360.0D0
       vars(iLimit1)%argumentOfPerihelion   =  -360.0D0
       vars(iLimit2)%argumentOfPerihelion   =   360.0D0
!
      vars(iDefault)%inclination            =     0.0D0
         vars(iStd1)%inclination            =  -360.0D0
         vars(iStd2)%inclination            =   360.0D0
       vars(iLimit1)%inclination            =  -360.0D0
       vars(iLimit2)%inclination            =   360.0D0
!
      vars(iDefault)%perihelionDistance     =    0.0D0
         vars(iStd1)%perihelionDistance     =    0.1D0
         vars(iStd2)%perihelionDistance     =   99.9D0
       vars(iLimit1)%perihelionDistance     =    0.001D0
       vars(iLimit2)%perihelionDistance     =  999.9D0
!
      vars(iDefault)%eccentricity           =    1.0D0
         vars(iStd1)%eccentricity           =    0.1D0
         vars(iStd2)%eccentricity           =    9.9D0
       vars(iLimit1)%eccentricity           =    0.001D0
       vars(iLimit2)%eccentricity           =  999.9D0
!
!TBD: defaults for names, types, units etc.
!
! *** Offsets:
!
      varsOffsets(iDefault,iPROJECTION)%systemName = offsetSystemChoices(iPROJECTION)
!
      varsOffsets(iDefault,iPROJECTION)%isSet      = .False.
!
      varsOffsets(iDefault,iPROJECTION)%point%x    =      0.0
      varsOffsets(iStd1,   iPROJECTION)%point%x    =  -3600.0
      varsOffsets(iStd2,   iPROJECTION)%point%x    =   3600.0
      varsOffsets(iLimit1, iPROJECTION)%point%x    = -36000.0
      varsOffsets(iLimit2, iPROJECTION)%point%x    =  36000.0
!
      varsOffsets(iDefault,iPROJECTION)%point%y    =      0.0
      varsOffsets(iStd1,   iPROJECTION)%point%y    =  -3600.0
      varsOffsets(iStd2,   iPROJECTION)%point%y    =   3600.0
      varsOffsets(iLimit1, iPROJECTION)%point%y    = -36000.0
      varsOffsets(iLimit2, iPROJECTION)%point%y    =  36000.0
!
      varsOffsets(iDefault,iPROJECTION)%channel    =      1
      varsOffsets(iStd1,   iPROJECTION)%channel    =      1  
      varsOffsets(iStd2,   iPROJECTION)%channel    =      1  
      varsOffsets(iLimit1, iPROJECTION)%channel    =      1  
      varsOffsets(iLimit2, iPROJECTION)%channel    =      1  
!
      varsOffsets(iDefault,iPROJECTION)%elevation  =      0.0  
      varsOffsets(iStd1,   iPROJECTION)%elevation  =      0.0 
      varsOffsets(iStd2,   iPROJECTION)%elevation  =      0.0
      varsOffsets(iLimit1, iPROJECTION)%elevation  =      0.0
      varsOffsets(iLimit2, iPROJECTION)%elevation  =      0.0
!
      do ii = 2, nDimOffsetChoices, 1
         varsOffsets(iDefault,ii) = varsOffsets(iDefault,iPROJECTION)
         varsOffsets(iStd1   ,ii) = varsOffsets(iStd1   ,iPROJECTION)
         varsOffsets(iStd2   ,ii) = varsOffsets(iStd2   ,iPROJECTION)
         varsOffsets(iLimit1 ,ii) = varsOffsets(iLimit1 ,iPROJECTION)
         varsOffsets(iLimit2 ,ii) = varsOffsets(iLimit2 ,iPROJECTION)
      end do
!
!D      Write (6,*) "   rangeSource.f90: offsetSystemChoices "
!D      do ii = 1, nDimOffsetChoices, 1
!D         Write (6,*) ii, offsetSystemChoices(ii)
!D      end do
!D      Write (6,*) iPROJECTION , offsetSystemChoices(iPROJECTION )
!D      Write (6,*) iDESCRIPTIVE, offsetSystemChoices(iDESCRIPTIVE)
!D      Write (6,*) iBASIS      , offsetSystemChoices(iBASIS      )
!D      Write (6,*) iEQUATORIAL , offsetSystemChoices(iEQUATORIAL )
!D      Write (6,*) iHADEC      , offsetSystemChoices(iHADEC      )
!D      Write (6,*) iHORIZONTRUE, offsetSystemChoices(iHORIZONTRUE)
!D      Write (6,*) iHORIZON    , offsetSystemChoices(iHORIZON    )
!D      Write (6,*) iNASMYTH    , offsetSystemChoices(iNASMYTH    )
!
      varsOffsets(iDefault,iDESCRIPTIVE)%systemName = offsetSystemChoices(iDESCRIPTIVE)
      varsOffsets(iDefault,iBASIS      )%systemName = offsetSystemChoices(iBASIS      )
      varsOffsets(iDefault,iEQUATORIAL )%systemName = offsetSystemChoices(iEQUATORIAL )
      varsOffsets(iDefault,iHADEC      )%systemName = offsetSystemChoices(iHADEC      )
      varsOffsets(iDefault,iHORIZONTRUE)%systemName = offsetSystemChoices(iHORIZONTRUE)
      varsOffsets(iDefault,iHORIZON    )%systemName = offsetSystemChoices(iHORIZON    )
!
      varsOffsets(iDefault,iNASMYTH    )%systemName = offsetSystemChoices(iNASMYTH    )
!
      varsOffsets(iDefault,iNASMYTH)%channel    =      1  
      varsOffsets(iStd1,   iNASMYTH)%channel    =      1  
      varsOffsets(iStd2,   iNASMYTH)%channel    =    117  
      varsOffsets(iLimit1, iNASMYTH)%channel    =      1  
      varsOffsets(iLimit2, iNASMYTH)%channel    =    117  
!
      varsOffsets(iDefault,iNASMYTH)%elevation  =     45.0  
      varsOffsets(iStd1,   iNASMYTH)%elevation  =     15.0
      varsOffsets(iStd2,   iNASMYTH)%elevation  =     85.0
      varsOffsets(iLimit1, iNASMYTH)%elevation  =      0.0
      varsOffsets(iLimit2, iNASMYTH)%elevation  =     90.0
!
!D      Write (6,*) "   rangeSource.f90: varsOffsets(iDefault,... " 
!D      do ii = 1, nDimOffsetChoices, 1
!D         write (6,*) ii, &
!D              & varsOffsets(iDefault,ii)%isSet,      &
!D              & varsOffsets(iDefault,ii)%systemName, &
!D              & varsOffsets(iDefault,ii)%point%x,    &
!D              & varsOffsets(iDefault,ii)%point%y,    &
!D              & varsOffsets(iDefault,ii)%channel,    &
!D              & varsOffsets(iDefault,ii)%elevation
!D      end do
