!
! $Id: parametersSetKeywordValue.inc,v 1.1 2005/03/23 14:25:51 pety Exp $
!
! TBD: SIC free LUN!
!
      error  = .False.
      errorL = .False.
      errorR = .False.
      errorC = .False.
!
! *** Keyword
      If (SIC_NARG(0).Ge.1.) Then
         iOption   = 0
         iArgument = 1
         Call SIC_CH(LINE,iOption,iArgument,                           &
     &        cInput,lengthInput,.True.,errorC)
         cInputUpper = cInput
         Call SIC_UPPER(cInputUpper)
         keyword =  cInputUpper(1:lengthInput)
      Else
         errorL = .True.
         messageText =                                                 &
     &        "no keyword specified"
         Call PakoMessage(priorityE,severityE,command,messageText)
      End If
!
      error = error .Or. errorC
!
! *** Value
      If (SIC_NARG(0).Ge.2.) Then
         iOption   = 0
         iArgument = 2
         Call SIC_CH(LINE,iOption,iArgument,                           &
     &        cInput256,lengthInput,.True.,errorC)
         valueC =  cInput256(1:lengthInput)
      Else
         errorL = .True.
         messageText =                                                 &
     &        "no value specified"
         Call PakoMessage(priorityE,severityE,command,messageText)
      End If
!
      error = error .Or. errorC
!
!D      Write (6,*) "   keyword:     ->",keyword(1:lenc(keyword)),'<-'
!D      Write (6,*) "   valueC:      ->", valueC(1:lenc(valueC)),'<-'
! 
      Call pakoUmatchKey (                                        &
           &              keys=setChoices,                        &
           &              key=keyword,                            &
           &              command='SET',                          &
           &              howto='Start Upper',                    &
           &              iMatch=iMatch,                          &
           &              nMatch=nMatch,                          &
           &              error=errorC,                           &
           &              errorCode=errorCode                     &
           &             )
!
!!$      Write (6,*) "   keyword:     ->", keyword(1:lenc(keyword)),'<-'
!!$      Write (6,*) "   iMatch:        ", iMatch
!!$      Write (6,*) "   nMatch:        ", nMatch
!!$      Write (6,*) "   errorC:        ", errorC
!!$      Write (6,*) "   errorCode:     ", errorCode
!
      If (.Not. errorC) Then
         Select Case (keyword)
!
         Case("FOCUS")
! TBD: handling of defaults, limits, etc.
            iOption   = 0
            iArgument = 2
            If (SIC_PRESENT(iOption,iArgument)) Then
               Call SIC_CH(LINE,iOption,iArgument,cInput,lengthInput,          &
      &              .False.,errorC)
               Call SIC_UPPER(cInput)
               logicalF1 = cInput(1:1) .Eq. 'F'
               If (logicalF1) Then
                  Continue
               Else If (cInput(1:1).Ne.'*') Then
                  Call SIC_R4(LINE,iOption,iArgument,rInput,.True.,errorR)
                  If (.Not. errorR) Then
                     GVfCorr%focusCorrection = rInput
                  End If
                  error = error .Or. errorR
               Else
                  rInput = GVfCorr%focusCorrection
               End If
            End If
!
            ier = sic_getlun(iunit)
! TBD: XML to nml translation
! TBD: check for presence of python utilities etc.
            If (logicalF1) Then
               Open (unit=iUnit, file='focus.nml',                       &
                    & delim='APOSTROPHE',  action='read', status='old',  &
                    & iostat=ier)
               If (ier .Eq. 0) Then 
                  fCorr = fCorrDefault
                  Read (unit=iunit, NML=fCorrNML, iostat=ier)
               End If
               If (ier .Ne. 0) Then
                  messageText =                                          &
                       &        "Could not read file: focus.nml"
                  Call PakoMessage(priorityE,severityE,command//' FOCUS',messageText)
                  error = .True.
               Else
                  GVfCorr = fCorr
                  If (.Not.logicalF1) GVfCorr%focusCorrection = rInput
               End If
               Close (unit=iunit)
            End If
            Write (messageText,*) 'Focus. focusCorrection:   ', GVfCorr%focusCorrection
            Call PakoMessage(priorityI,severityI,command,messageText)
!
         Case("LEVEL")
            iOption   = 0
            iArgument = 2
            If (SIC_PRESENT(iOption,iArgument)) Then
               Call SIC_I4(LINE,iOption,iArgument,iInput,.True.,errorI)
               If (.Not. errorI) Then
                  GV%iPstdio = Min(Max(0,iInput),9)
                  Call pakoMessage_level(GV%iPstdio)
               End If
            End If
            iArgument = 3
            If (SIC_PRESENT(iOption,iArgument)) Then              
               Call SIC_I4(LINE,iOption,iArgument,iInput,.True.,errorI)
               If (.Not. errorI) Then
                  GV%iPfile = Min(Max(0,iInput),9)
                  Call pakoMessage_level(GV%iPstdio,GV%iPfile)
               End If
            End If
!
         Case("PI")
            GV%PI = valueC
!
         Case("PROJECT")
            GV%project = valueC
!
         Case("OBSERVER")
            GV%observer = valueC
!
         Case("OPERATOR")
            GV%oper     = valueC
!
         Case("POINTING")
! TBD: handling of defaults, limits, etc.
            iOption   = 0
            iArgument = 2
            If (SIC_PRESENT(iOption,iArgument)) Then
               Call SIC_CH(LINE,iOption,iArgument,cInput,lengthInput,          &
      &              .False.,errorC)
               Call SIC_UPPER(cInput)
               logicalF1 = cInput(1:1) .Eq. 'F'
               If (logicalF1) Then
                  Continue
               Else If (cInput(1:1).Ne.'*') Then
                  Call SIC_R4(LINE,iOption,iArgument,rInput,.True.,errorR)
                  If (.Not. errorR) Then
                     GVpCorr%azimuthCorrection = rInput
                  End If
                  error = error .Or. errorR
               Else
                  rInput = GVpCorr%azimuthCorrection
               End If
            End If
            iArgument = 3
            If (SIC_PRESENT(iOption,iArgument)) Then              
               Call SIC_CH(LINE,iOption,iArgument,cInput,lengthInput,          &
      &              .False.,errorC)
               Call SIC_UPPER(cInput)
               logicalF2 = cInput(1:1) .Eq. 'F'
               If (logicalF2) Then
                  Continue
               Else If (cInput(1:1).Ne.'*') Then
                  Call SIC_R4(LINE,iOption,iArgument,rInput2,.True.,errorR)
                  If (.Not. errorR) Then
                     GVpCorr%elevationCorrection = rInput2
                  End If
                  error = error .Or. errorR
               Else
                  rInput2 = GVpCorr%elevationCorrection
               End If
            End If
            ier = sic_getlun(iunit)
! TBD: XML to nml translation
! TBD: check for presence of python utilities etc.
            If (logicalF1 .Or. logicalF2) Then
               Open (unit=iUnit, file='pointing.nml',                    &
                    & delim='APOSTROPHE',  action='read', status='old',  &
                    & iostat=ier)
               If (ier .Eq. 0) Then 
                  pCorr = pCorrDefault
                  Read (unit=iunit, NML=pCorrNML, iostat=ier)
               End If
               If (ier .Ne. 0) Then
                  messageText =                                          &
                       &        "Could not read file: pointing.nml"
                  Call PakoMessage(priorityE,severityE,command//' POINTING',messageText)
                  error = .True.
               Else
                  GVpCorr = pCorr
                  If (.Not.logicalF1) GVpCorr%azimuthCorrection = rInput
                  If (.Not.logicalF2) GVpCorr%elevationCorrection = rInput2
!!$                  Write (6,*) '      azimuth                 ', GVpCorr%azimuth           
!!$                  Write (6,*) '      elevation               ', GVpCorr%elevation         
!!$                  Write (6,*) '      pointingP1              ', GVpCorr%pointingP(1)
!!$                  Write (6,*) '      pointingP2              ', GVpCorr%pointingP(2)
!!$                  Write (6,*) '      pointingP7              ', GVpCorr%pointingP(7)
!!$                  Write (6,*) '      azimuthCorrection       ', GVpCorr%azimuthCorrection       
!!$                  Write (6,*) '      azimuthCorrectionError  ', GVpCorr%azimuthCorrectionError  
!!$                  Write (6,*) '      elevationCorrection     ', GVpCorr%elevationCorrection     
!!$                  Write (6,*) '      elevationCorrectionError', GVpCorr%elevationCorrectionError
               End If
               Close (unit=iunit)
            End If
            Write (messageText,*) 'Pointing. azimuthCorrection:   ', GVpCorr%azimuthCorrection
            Call PakoMessage(priorityI,severityI,command,messageText)
            Write (messageText,*) 'Pointing. elevationCorrection: ', GVpCorr%elevationCorrection
            Call PakoMessage(priorityI,severityI,command,messageText)
!
         Case("TOPOLOGY")
            errorTopology = .False.
            Call pakoUmatchKey (                                  &
           &              keys=topologyChoices,                   &
           &              key=valueC,                             &
           &              command='SET',                          &
           &              howto='Start Upper',                    &
           &              iMatch=iMatch,                          &
           &              nMatch=nMatch,                          &
           &              error=errorTopology,                           &
           &              errorCode=errorCode                     &
           &             )
!D            Write (6,*) "   valueC:      ->", valueC(1:lenc(valueC)),'<-'
!D            Write (6,*) "   iMatch:        ", iMatch
!D            Write (6,*) "   nMatch:        ", nMatch
!D            Write (6,*) "   errorC:        ", errorC
!D            Write (6,*) "   errorCode:     ", errorCode
            If  (iMatch.Lt.iLOW .Or. iMatch.Gt.iHIGH) Then
               errorTopology =  .True.
               Write (messageText,*) valueC(1:lenc(valueC)), " not yet supported"
               Call PakoMessage(priorityE,severityE,command//' TOPOLOGY',messageText)
            End If
            error = error .Or. errorTopology
            If (.Not. error) Then
               GV%topology = valueC
            End If
!
         Case("ANGLEUNIT")
            errorAngleUnit = .False.
            Call pakoUmatchKey (                                  &
           &              keys=angleChoices,                      &
           &              key=valueC,                             &
           &              command='SET',                          &
           &              howto='Start Upper',                    &
           &              iMatch=iMatch,                          &
           &              nMatch=nMatch,                          &
           &              error=errorAngleUnit,                   &
           &              errorCode=errorCode                     &
           &             )
!D            Write (6,*) "   valueC:      ->", valueC(1:lenc(valueC)),'<-'
!D            Write (6,*) "   iMatch:        ", iMatch
!D            Write (6,*) "   nMatch:        ", nMatch
!D            Write (6,*) "   errorC:        ", errorC
!D            Write (6,*) "   errorCode:     ", errorCode
            !
            If (.Not. errorAngleUnit) Then
               GV%iAU           = iMatch
               !
               GV%angleUnitSetC = angleChoices(iMatch)
               GV%angleUnitSet  = auConv(iMatch)
               GV%angleFactorD  = GV%angleUnitSet/GV%angleUnit
               GV%angleFactorR  = GV%angleUnitSet/GV%angleUnit
               !
               GV%speedUnitSetC = speedChoices(iMatch)
               GV%speedUnitSet  = auConv(iMatch)
               GV%speedFactorD  = GV%speedUnitSet/GV%speedUnit
               GV%speedFactorR  = GV%speedUnitSet/GV%speedUnit
               !
            End If

            error = error .Or. errorAngleUnit
!
         End Select
      End If
!
      error = error .Or. errorC
!
!D      Write (6,*) "      Project:    ", GV%project
!D      Write (6,*) "      PI:         ", GV%PI
!D      Write (6,*) "      Observer:   ", GV%observer
!D      Write (6,*) "      Operator:   ", GV%oper
!D      Write (6,*) "      GV%iPstdio:  ",  GV%iPstdio
!D      Write (6,*) "      GV%iPfile:   ",  GV%iPfile
!
!D      Write (6,*) "      GV%iAU =     ", GV%iAU
!D      Write (6,*) "      GV%angleUnitSetC:  ", GV%angleUnitSetC
!D      Write (6,*) "      GV%angleUnitSet=   ", GV%angleUnitSet
!D      Write (6,*) "      GV%speedUnitSetC:  ", GV%speedUnitSetC
!D      Write (6,*) "      GV%speedUnitSet=   ", GV%speedUnitSet
!
!D!
!D      Write (6,*) "   cInput256  ->",                                &
!D     &               cInput256(1:lenc(cInput256)),"<-"
!D      Write (6,*) "   errorC:      ->",errorC
!D      Write (6,*) "   errorL:      ->",errorL
!D!




