subroutine swaprt(rname,error,user_function)
  use gbl_message
  use classcore_dependencies_interfaces
  use classcore_interfaces, except_this=>swaprt
  use class_data
  !----------------------------------------------------------------------
  ! @ private
  !  Exchange R and T memories
  !----------------------------------------------------------------------
  character(len=*), intent(in)    :: rname
  logical,          intent(inout) :: error
  logical,          external      :: user_function
  ! Local
  type(observation), pointer :: tmp
  logical :: ll,myerror
  !
  ! Use a local 'myerror' because the subroutine can be called in error
  ! recovery mode.
  !
  if (t%head%xnum.eq.0) then
    if (rname.eq.'SWAP') then
      call class_message(seve%e,rname,'No spectrum in T buffer')
      error = .true.
    endif
    return  ! Nothing to swap...
  endif
  !
  tmp => r
  r => t
  t => tmp
  r%is_R = .true.
  t%is_R = .false.
  !
  ll = user_function('SWAP')
  !
  ! Need a complete redefinition of all Sic variables pointing to R
  myerror = .false.
  call sic_delvariable ('R',.false.,myerror)
  myerror = .false.  ! No error if not found
  call las_variables_r(error)
  if (myerror) then
    error = .true.
    return
  endif
  call las_setvar_R_aliases(error)
  if (myerror) then
    error = .true.
    return  ! Also redefine SET VARIABLE aliases
  endif
  !
  call newdat(r,myerror)
  call newdat_assoc(r,myerror)
  call newdat_user(r,myerror)
  if (myerror)  error = .true.
  !
end subroutine swaprt
!
subroutine copyrt(user_function,key)
  use gildas_def
  use class_data
  !----------------------------------------------------------------------
  ! @ private
  ! Copy R memory to T memory
  !----------------------------------------------------------------------
  logical,          external   :: user_function  !
  character(len=*), intent(in) :: key            !
  ! Local
  logical :: ll,error
  !
  if (r%head%xnum.eq.0)  return  ! Nothing to copy yet (copy_obs would raise an error)
  !
  call copy_obs(r,t,error)
  ll = user_function('COPY')
  !
end subroutine copyrt
!
subroutine copy2r(obs,error)
  use class_data
  !-------------------------------------------------------------------
  ! @ private
  ! Copy the observation into R memory
  !-------------------------------------------------------------------
  type(observation), intent(in)  :: obs    ! Current observation
  logical,           intent(out) :: error  ! Error flag
  !
  error = .false.
  call copy_obs(obs,r,error)
  if (error)  return
  !
  call newdat(r,error)
  call newdat_assoc(r,error)
  call newdat_user(r,error)
end subroutine copy2r
!
subroutine copy_obs(in,out,error)
  use gbl_message
  use classcore_interfaces, except_this=>copy_obs
  use class_types
  !-------------------------------------------------------------------
  ! @ private  (could be public?)
  ! Copy IN into OUT observation
  !-------------------------------------------------------------------
  type(observation), intent(in)    :: in     ! In  observation
  type(observation), intent(inout) :: out    ! Out observation
  logical,           intent(out)   :: error  ! Error flag
  ! Local
  character(len=*), parameter :: rname='COPY_OBS'
  integer(kind=4) :: ndata
  !
  ! Initialization
  error = .false.
  !
  ! Sanity check
  if (.not.associated(in%data1)) then
     call class_message(seve%e,rname,'Observation to be copied is empty')
     error = .true.
     return
  endif
  !
  ! Reallocate OUT buffer if needed
  ndata = obs_nchan(in%head)
  call reallocate_obs(out,ndata,error)
  if (error) return
  !
  ! Copy header
  out%head = in%head
  !
  ! Copy scalars
  out%cnchan = in%cnchan
  out%cbad   = in%cbad
  out%cimin  = in%cimin
  out%cimax  = in%cimax
  out%is_otf = in%is_otf
  ! out%is_R = DO NOT CHANGE!
  !
  ! Copy Arrays
  out%datax(1:ndata) = in%datax
  out%datas(1:ndata) = in%datas
  out%datai(1:ndata) = in%datai
  out%datav(1:ndata) = in%datav
  out%data1(1:ndata) = in%data1
  out%dataw(1:ndata) = in%dataw
  !
  ! User Section
  call copy_user(in%user,out%user,error)
  if (error)  return
  !
  ! Associated Arrays section
  call copy_assoc(in%assoc,out%assoc,error)
  if (error)  return
  !
  ! Set pointers
  out%spectre => out%data1
  !
end subroutine copy_obs
