module class_addons
  use gildas_def
  integer(kind=1), save :: mem_user(8)
  integer(kind=address_length), save :: addr_user
  integer(kind=address_length), save :: ip_user
end module class_addons
!
subroutine init_class(user_function)
  use gkernel_interfaces
  use classcore_interfaces, except_this=>init_class
  use class_addons
  !---------------------------------------------------------------------
  ! @ private
  ! LAS initialization routine
  ! SIC is loaded with LAS and ANALYSE languages, plot library is
  ! initialized, and SIC variables are defined.
  !---------------------------------------------------------------------
  external :: user_function         !
  ! Local
  integer, parameter :: mlas=112  ! LAS          language
  integer, parameter :: mana=61   ! ANALYSE      language
  integer, parameter :: mfit=17   ! FIT          language
  integer, parameter :: mdec=11   ! DECONV       language
  integer, parameter :: mexp=22   ! EXPERIMENTAL language
  character(len=12) :: vocab_las(mlas)
  character(len=12) :: vocab_ana(mana)
  character(len=12) :: vocab_fit(mfit)
  character(len=12) :: vocab_dec(mdec)
  character(len=12) :: vocab_exp(mexp)
  character(len=20) :: version
  external :: run_ana, run_sas, run_fit, run_dec, run_exp
  ! Data
  data vocab_las /  &
       ' ACCUMULATE', '/RESAMPLE','/NOCHECK','/WEIGHT',                      &
       ' ASSOCIATE', '/BAD','/UNIT','/DELETE',                               &
       ' AVERAGE', '/NOMATCH','/RESAMPLE','/NOCHECK','/WEIGHT',              &
       ' BASE', '/PLOT','/CONTINUUM','/INDEX','/OBS',                        &
       ' BOX', '/INDEX','/OBS','/UNIT',                                      &
       ' CATALOG', '/STATUS',                                                &
       ' CONSISTENCY', '/NOCHECK',                                           &
       ' COPY', '/SORTED',                                                   &
       ' DROP',                                                              &
       ' DUMP', '/SECTION',                                                  &
       ' EXTRACT', '/INDEX',                                                 &
       ' FILE', '/OVERWRITE',                                                &
       ' FIND', '/ALL','/LINE','/NUMBER','/SCAN','/OFFSET','/SOURCE',        &
                '/RANGE','/QUALITY','/TELESCOPE', '/SUBSCAN','/ENTRY',       &
                '/OBSERVED','/REDUCED','/FREQUENCY','/SECTION','/USER',      &
                '/MASK',                                                     &
       ' FITS', '/BITS','/STYLE','/XTENSION','/MODE','/CHECK',               &
       ' FOLD', '/BOUNDARIES',                                               &
       ' GET',                                                               &
       ' HEADER',                                                            &
       ' IGNORE', '/SCAN',                                                   &
       ' LIST', '/BRIEF','/LONG','/SCAN','/OUTPUT','/TOC','/VARIABLE',       &
       ' LOAD', '/NOCHECK',                                                  &
       ' MERGE',                                                             &
       ' MODIFY', '/RUZE',                                                   &
       ' MULTIPLY',                                                          &
       ' NEW_DATA',                                                          &
       ' PLOT', '/INDEX','/OBS',                                             &
       ' SAVE',                                                              &
       ' SET', '/NOCURSOR','/DEFAULT','/POLYGON','/VARIABLE','/ASSOCIATED',  &
       ' SHOW',                                                              &
       ' SPECTRUM', '/INDEX','/OBS','/PEN',                                  &
       ' STITCH', '/NOMATCH','/RESAMPLE','/IMAGE','/LINE','/TELESCOPE',      &
                  '/NOCHECK','/WEIGHT',                                      &
       ' SWAP',                                                              &
       ' TAG',                                                               &
       ' TITLE', '/INDEX','/OBS','/BRIEF','/LONG','/FULL',                   &
       ' UPDATE',                                                            &
       ' WRITE' /
  data vocab_ana /  &
       ' COMMENT',                                                           &
       ' DIVIDE',                                                            &
       ' DRAW', '/PEN',                                                      &
       ' FFT', '/REMOVE','/KILL','/INDEX','/OBS','/NOCURS','/CURS',          &
       ' FILL', '/INTER','/NOISE','/BLANK',                                  &
       ' GREG', '/FORMATTED','/READ',                                        &
       ' LMV', '/SCAN','/STEP','/LINE','/FORCE',                             &
       ' MAP', '/CELL','/GRID','/NOLABEL','/NUMBER','/BASE',                 &
       ' MEMORIZE', '/DELETE',                                               &
       ' MODEL', '/BLANK','/REGULAR','/FREQUENCY','/XAXIS',                  &
       ' NOISE',                                                             &
       ' POPUP',                                                             &
       ' PRINT', '/OUTPUT','/TABLE',                                         &
       ' REDUCE',                                                            &
       ' RESAMPLE', '/FFT','/NOFFT','/LIKE',                                 &
       ' RETRIEVE',                                                          &
       ' SMOOTH',                                                            &
       ' STAMP', '/LABEL',                                                   &
       ' STRIP',                                                             &
       ' TABLE', '/MATH','/RANGE','/RESAMPLE','/FFT','/FREQUENCY',           &
                 '/NOCHECK','/SIGMA','/WEIGHT','/LIKE' /
  data vocab_fit /  &
       ' DISPLAY', '/NOPLOT','/METHOD',                                      &
       ' ITERATE', '/NOCHECK',                                               &
       ' KEEP',                                                              &
       ' LINES', '/NOCURSOR','/INPUT','/SHOW',                               &
       ' METHOD',                                                            &
       ' MINIMIZE', '/NOCHECK',                                              &
       ' RESIDUAL',                                                          &
       ' RESULT',                                                            &
       ' VISUALIZE', '/PEN'/
  data vocab_dec /  &
       ' INITIALIZE', '/MODEL','/SIMULATE','/WEIGHT','/BMSW',                &
       ' DECONVOLVE', '/GAIN','/DERIV','/BMSW','/NOCHANNELS','/KEEP'/
  data vocab_exp /  &
       ' DIFF',                                                              &
       ' FILTER', '/STORE',                                                  &
       ' MEDIAN',                                                            &
       ' RMS', '/NOCHECK','/RESAMPLE','/WEIGHT',                             &
       ' SUBTRACT',                                                          &
       ' UNBLANK', '/MODE',                                                  &
       ' UV_ZERO', '/VERBOSE','/NEW','/NOCHECK','/LIKE',                     &
       ' VARIABLE', '/MODE','/INDEX',                                        &
       ' WAVELET', '/BASE','/PLOT'/
  !
  ! Code
  version = '6.0 15-JUN-2005'
  call sic_begin('LAS','GAG_HELP_LAS',mlas,vocab_las,   &
                 version//'  PHB - SG - JP - RL', run_sas, class_error)
  call sic_begin('ANALYSE','GAG_HELP_ANALYSE',mana,vocab_ana,   &
                 version//'  PHB - SG - JP - RL', run_ana, class_error)
  call sic_begin('FIT','GAG_HELP_FIT',mfit,vocab_fit,   &
                 version//'  PHB - SG - JP - RL', run_fit, class_error)
  call sic_begin('DSB2SSB','GAG_HELP_DSB2SSB',mdec,vocab_dec,   &
                 version//'  PHB - SG - JP - RL', run_dec, class_error)
  call sic_begin('EXPERIMENTAL','GAG_HELP_EXPERIMENTAL',mexp,vocab_exp,  &
                 version//'  JP - SB - PG', run_exp, class_error)
  call las_setup
  call las_variables
  !
  addr_user = locwrd(user_function)
  ip_user = bytpnt(addr_user,mem_user)
end subroutine init_class
!
subroutine exit_class
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  !
  !---------------------------------------------------------------------
  character(len=*), parameter :: rname='EXIT_CLASS'
  ! Local
  logical :: error
  !
  error = .false.
  !
  ! Class buffers
  call deallocate_class(error)
  !
  ! Free MEMORY buffers
  call memorize_free_all
  !
  call class_files_close(error)
  ! if (error)  continue
  call class_luns_free(error)
  ! if (error)  continue
  !
  call class_toc_clean(error)
  ! if (error)  continue
  !
end subroutine exit_class
