module classcore_interfaces_public
  interface
    subroutine abscissa_imaabs_left(head,imaabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      ! Compute the leftmost (channelwise) absolute image frequency of
      ! input spectrum
      !---------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(out) :: imaabs  !
    end subroutine abscissa_imaabs_left
  end interface
  !
  interface
    subroutine abscissa_imaabs_right(head,imaabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      ! Compute the rightmost (channelwise) absolute image frequency of
      ! input spectrum
      !---------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(out) :: imaabs  !
    end subroutine abscissa_imaabs_right
  end interface
  !
  interface abscissa_chan2imaabs
    subroutine abscissa_chan2imaabs_r4(head,chan,imaabs)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_chan2imaabs
      !--------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=4), intent(in)  :: chan    !
      real(kind=4), intent(out) :: imaabs  !
    end subroutine abscissa_chan2imaabs_r4
    subroutine abscissa_chan2imaabs_r8_head(head,chan,imaabs)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_chan2imaabs
      !  *** type(header) as argument ***
      !--------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(in)  :: chan    !
      real(kind=8), intent(out) :: imaabs  !
    end subroutine abscissa_chan2imaabs_r8_head
    subroutine abscissa_chan2imaabs_r8_spe(spe,chan,imaabs)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_chan2imaabs
      !  *** type(class_spectro_t) as argument ***
      !--------------------------------------------------------------------
      type(class_spectro_t), intent(in)  :: spe     !
      real(kind=8),          intent(in)  :: chan    !
      real(kind=8),          intent(out) :: imaabs  !
    end subroutine abscissa_chan2imaabs_r8_spe
  end interface abscissa_chan2imaabs
  !
  interface abscissa_chan2sigabs
    subroutine abscissa_chan2sigabs_r4(head,chan,sigabs)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_chan2sigabs
      !--------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=4), intent(in)  :: chan    !
      real(kind=4), intent(out) :: sigabs  !
    end subroutine abscissa_chan2sigabs_r4
    subroutine abscissa_chan2sigabs_r8_head(head,chan,sigabs)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_chan2sigabs
      !  *** type(header) as argument ***
      !--------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(in)  :: chan    !
      real(kind=8), intent(out) :: sigabs  !
    end subroutine abscissa_chan2sigabs_r8_head
    subroutine abscissa_chan2sigabs_r8_spe(spe,chan,sigabs)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_chan2sigabs
      !  *** type(class_spectro_t) as argument ***
      !--------------------------------------------------------------------
      type(class_spectro_t), intent(in)  :: spe     !
      real(kind=8),          intent(in)  :: chan    !
      real(kind=8),          intent(out) :: sigabs  !
    end subroutine abscissa_chan2sigabs_r8_spe
  end interface abscissa_chan2sigabs
  !
  interface abscissa_imaabs_middle
    subroutine abscissa_imaabs_middle_head(head,imaabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_imaabs_middle
      ! Compute the middle absolute image frequency of input spectrum
      !  *** type(header) as argument ***
      !---------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(out) :: imaabs  !
    end subroutine abscissa_imaabs_middle_head
    subroutine abscissa_imaabs_middle_spe(spe,imaabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_imaabs_middle
      ! Compute the middle absolute image frequency of input spectrum
      !  *** type(class_spectro_t) as argument ***
      !---------------------------------------------------------------------
      type(class_spectro_t), intent(in)  :: spe     !
      real(kind=8),          intent(out) :: imaabs  !
    end subroutine abscissa_imaabs_middle_spe
  end interface abscissa_imaabs_middle
  !
  interface abscissa_sigabs2chan
    subroutine abscissa_sigabs2chan_r4(head,sigabs,chan)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs2chan
      !--------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=4), intent(in)  :: sigabs  !
      real(kind=4), intent(out) :: chan    !
    end subroutine abscissa_sigabs2chan_r4
    subroutine abscissa_sigabs2chan_r8_head(head,sigabs,chan)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs2chan
      !  *** type(header) as argument ***
      !--------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(in)  :: sigabs  !
      real(kind=8), intent(out) :: chan    !
    end subroutine abscissa_sigabs2chan_r8_head
    subroutine abscissa_sigabs2chan_r8_spe(spe,sigabs,chan)
      use class_types
      !--------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs2chan
      !  *** type(class_spectro_t) as argument ***
      !--------------------------------------------------------------------
      type(class_spectro_t), intent(in)  :: spe     !
      real(kind=8),          intent(in)  :: sigabs  !
      real(kind=8),          intent(out) :: chan    !
    end subroutine abscissa_sigabs2chan_r8_spe
  end interface abscissa_sigabs2chan
  !
  interface abscissa_sigabs_left
    subroutine abscissa_sigabs_left_head(head,sigabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs_left
      ! Compute the leftmost (channelwise) absolute signal frequency of
      ! input spectrum
      !  *** type(header) as argument ***
      !---------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(out) :: sigabs  !
    end subroutine abscissa_sigabs_left_head
    subroutine abscissa_sigabs_left_spe(spe,sigabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs_left
      ! Compute the leftmost (channelwise) absolute signal frequency of
      ! input spectrum
      !  *** type(class_spectro_t) as argument ***
      !---------------------------------------------------------------------
      type(class_spectro_t), intent(in)  :: spe     !
      real(kind=8),          intent(out) :: sigabs  !
    end subroutine abscissa_sigabs_left_spe
  end interface abscissa_sigabs_left
  !
  interface abscissa_sigabs_middle
    subroutine abscissa_sigabs_middle_head(head,sigabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs_middle
      ! Compute the middle absolute signal frequency of input spectrum
      !  *** type(header) as argument ***
      !---------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(out) :: sigabs  !
    end subroutine abscissa_sigabs_middle_head
    subroutine abscissa_sigabs_middle_spe(spe,sigabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs_middle
      ! Compute the middle absolute signal frequency of input spectrum
      !  *** type(class_spectro_t) as argument ***
      !---------------------------------------------------------------------
      type(class_spectro_t), intent(in)  :: spe     !
      real(kind=8),          intent(out) :: sigabs  !
    end subroutine abscissa_sigabs_middle_spe
  end interface abscissa_sigabs_middle
  !
  interface abscissa_sigabs_right
    subroutine abscissa_sigabs_right_head(head,sigabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs_right
      ! Compute the rightmost (channelwise) absolute signal frequency of
      ! input spectrum
      !  *** type(header) as argument ***
      !---------------------------------------------------------------------
      type(header), intent(in)  :: head    !
      real(kind=8), intent(out) :: sigabs  !
    end subroutine abscissa_sigabs_right_head
    subroutine abscissa_sigabs_right_spe(spe,sigabs)
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic abscissa_sigabs_right
      ! Compute the rightmost (channelwise) absolute signal frequency of
      ! input spectrum
      !  *** type(class_spectro_t) as argument ***
      !---------------------------------------------------------------------
      type(class_spectro_t), intent(in)  :: spe     !
      real(kind=8),          intent(out) :: sigabs  !
    end subroutine abscissa_sigabs_right_spe
  end interface abscissa_sigabs_right
  !
  interface class_assoc_add
    subroutine class_assoc_add_reservedi41d(obs,name,ptr,error)
      use gbl_format
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic class_assoc_add
      !   Add a reserved Associated Array to the Associated Section of the
      ! input observation. For reserved Arrays, the unit, format, and 2nd
      ! dimension are implicit and can not be customized by the caller.
      ! ---
      !  This version for:
      !   - reserved keywords
      !   - associate 1D I*4 pointer to the array in return
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs     ! Observation
      character(len=*),  intent(in)    :: name    ! The array name
      integer(kind=4),   pointer       :: ptr(:)  ! Pointer on array
      logical,           intent(inout) :: error   ! Logical error flag
    end subroutine class_assoc_add_reservedi41d
    subroutine class_assoc_add_reservedr41d(obs,name,ptr,error)
      use gbl_format
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic class_assoc_add
      !   Add a reserved Associated Array to the Associated Section of the
      ! input observation. For reserved Arrays, the unit, format, and 2nd
      ! dimension are implicit and can not be customized by the caller.
      ! ---
      !  This version for:
      !   - reserved keywords
      !   - associate 1D R*4 pointer to the array in return
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs     ! Observation
      character(len=*),  intent(in)    :: name    ! The array name
      real(kind=4),      pointer       :: ptr(:)  ! Pointer on array
      logical,           intent(inout) :: error   ! Logical error flag
    end subroutine class_assoc_add_reservedr41d
    subroutine class_assoc_add_reservednum(obs,name,numarray,error)
      use gbl_format
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic class_assoc_add
      !   Add a reserved Associated Array to the Associated Section of the
      ! input observation. For reserved Arrays, the unit, format, and 2nd
      ! dimension are implicit and can not be customized by the caller.
      ! ---
      !  This version for:
      !   - reserved keywords
      !   - get the array identifier in return
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs       ! Observation
      character(len=*),  intent(in)    :: name      ! The array name
      integer(kind=4),   intent(out)   :: numarray  ! Array number
      logical,           intent(inout) :: error     ! Logical error flag
    end subroutine class_assoc_add_reservednum
    subroutine class_assoc_add_free_i41d(obs,name,unit,form,dim2,badi4,ptr,error)
      use gbl_format
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic class_assoc_add
      !   Add an array to the Associated Section of the input observation
      ! The array name must be a 'free' (non-reserved) Associated Array
      ! ---
      ! This version for:
      !  - non-reserved arrays
      !  - I*4 bad value
      !  - associate 1D I*4 pointer to the array in return
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs       ! Observation
      character(len=*),  intent(in)    :: name      ! The array name
      character(len=*),  intent(in)    :: unit      ! Unit for values
      integer(kind=4),   intent(in)    :: form      ! Format on disk
      integer(kind=4),   intent(in)    :: dim2      ! 2nd dimension, 0 for 1D array
      integer(kind=4),   intent(in)    :: badi4     ! Bad value
      integer(kind=4),   pointer       :: ptr(:)    ! Pointer on array
      logical,           intent(inout) :: error     ! Logical error flag
    end subroutine class_assoc_add_free_i41d
    subroutine class_assoc_add_free_i4num(obs,name,unit,form,dim2,badi4,numarray,error)
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic class_assoc_add
      !   Add an array to the Associated Section of the input observation
      ! The array name must be a 'free' (non-reserved) Associated Array
      ! ---
      ! This version for:
      !  - non-reserved arrays
      !  - I*4 bad value
      !  - get the array identifier in return
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs       ! Observation
      character(len=*),  intent(in)    :: name      ! The array name
      character(len=*),  intent(in)    :: unit      ! Unit for values
      integer(kind=4),   intent(in)    :: form      ! Format on disk
      integer(kind=4),   intent(in)    :: dim2      ! 2nd dimension, 0 for 1D array
      integer(kind=4),   intent(in)    :: badi4     ! Bad value
      integer(kind=4),   intent(out)   :: numarray  ! Array number
      logical,           intent(inout) :: error     ! Logical error flag
    end subroutine class_assoc_add_free_i4num
    subroutine class_assoc_add_free_r41d(obs,name,unit,form,dim2,badr4,ptr,error)
      use gbl_format
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic class_assoc_add
      !   Add an array to the Associated Section of the input observation
      ! The array name must be a 'free' (non-reserved) Associated Array
      ! ---
      ! This version for:
      !  - non-reserved arrays
      !  - R*4 bad value
      !  - associate 1D R*4 pointer to the array in return
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs       ! Observation
      character(len=*),  intent(in)    :: name      ! The array name
      character(len=*),  intent(in)    :: unit      ! Unit for values
      integer(kind=4),   intent(in)    :: form      ! Format on disk
      integer(kind=4),   intent(in)    :: dim2      ! 2nd dimension, 0 for 1D array
      real(kind=4),      intent(in)    :: badr4     ! Bad value
      real(kind=4),      pointer       :: ptr(:)    ! Pointer on array
      logical,           intent(inout) :: error     ! Logical error flag
    end subroutine class_assoc_add_free_r41d
    subroutine class_assoc_add_free_r4num(obs,name,unit,form,dim2,badr4,numarray,error)
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public-generic class_assoc_add
      !   Add an array to the Associated Section of the input observation
      ! The array name must be a 'free' (non-reserved) Associated Array
      ! ---
      ! This version for:
      !  - non-reserved arrays
      !  - R*4 bad value
      !  - get the array identifier in return
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs       ! Observation
      character(len=*),  intent(in)    :: name      ! The array name
      character(len=*),  intent(in)    :: unit      ! Unit for values
      integer(kind=4),   intent(in)    :: form      ! Format on disk
      integer(kind=4),   intent(in)    :: dim2      ! 2nd dimension, 0 for 1D array
      real(kind=4),      intent(in)    :: badr4     ! Bad value
      integer(kind=4),   intent(out)   :: numarray  ! Array number
      logical,           intent(inout) :: error     ! Logical error flag
    end subroutine class_assoc_add_free_r4num
  end interface class_assoc_add
  !
  interface
    subroutine simple_waverage(rdata1,rdataw,rbad,  &
                               sdata1,sdataw,sbad,  &
                               schanmin,schanmax,contaminate,wup)
      !---------------------------------------------------------------------
      ! @ public
      ! Simple summation in the case SET ALIGN is CHANNEL. For efficiency
      ! purpose, addition is performed only in a given range were we know
      ! the input data array contributes.
      ! Weighting :
      ! * All channels are assumed to be aligned
      ! * Input weights should have been computed according to SET WEIGHT.
      !   Output weights (possibly non-uniform) are computed with special
      !   care.
      ! * Blanked channels propagates or not in output sum according to
      !   input parameter 'contaminate'
      !---------------------------------------------------------------------
      real(kind=4),    intent(in)    :: rdata1(:)    ! Data to be added
      real(kind=4),    intent(in)    :: rdataw(:)    ! Weigth of data to be added
      real(kind=4),    intent(in)    :: rbad         ! Bad value for the data to be added
      real(kind=4),    intent(inout) :: sdata1(:)    ! Current sum
      real(kind=4),    intent(inout) :: sdataw(:)    ! Weight of current sum
      real(kind=4),    intent(in)    :: sbad         ! Bad value for the current sum
      integer(kind=4), intent(in)    :: schanmin     ! First channel
      integer(kind=4), intent(in)    :: schanmax     ! Last channel
      logical,         intent(in)    :: contaminate  ! Bad channels contaminate output or not?
      logical,         intent(in)    :: wup          ! Update weight in return?
    end subroutine simple_waverage
  end interface
  !
  interface
    subroutine class_fileout_open(spec,lnew,lover,lsize,lsingle,error)
      use classic_api
      !---------------------------------------------------------------------
      ! @ public
      !  Public entry point to open a new or reopen an old output file.
      !---------------------------------------------------------------------
      character(len=*),           intent(in)    :: spec     ! File name including extension
      logical,                    intent(in)    :: lnew     ! Should it be a new file or an old?
      logical,                    intent(in)    :: lover    ! If new, overwrite existing file or raise an error?
      integer(kind=entry_length), intent(in)    :: lsize    ! If new, maximum number of observations allowed
      logical,                    intent(in)    :: lsingle  ! If new, should spectra be unique?
      logical,                    intent(inout) :: error    ! Logical error flag
    end subroutine class_fileout_open
  end interface
  !
  interface
    subroutine class_fileout_close(error)
      use class_common
      !---------------------------------------------------------------------
      ! @ public (available to other programs)
      !  Close the output file without closing the input file if they are
      ! the same
      !---------------------------------------------------------------------
      logical, intent(inout) :: error  ! Error status
    end subroutine class_fileout_close
  end interface
  !
  interface
    subroutine modify_vdirection(head,error)
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      ! Support routine for command:
      !  MODIFY VDIRECTION
      !---------------------------------------------------------------------
      type(header), intent(inout) :: head   !
      logical,      intent(inout) :: error  !
    end subroutine modify_vdirection
  end interface
  !
  interface
    subroutine class_fold_obs(obs,keepblank,error)
      use gbl_constant
      use gbl_message
      use class_types
      !----------------------------------------------------------------------
      ! @ public
      !   Fold an unfolded frequency switched observation.
      !  Each phase is assumed to be given a weight and a frequency change.
      !  The frequency change need not be an integer number of channels.
      !  The number of phases is not limited.
      !-----------------------------------------------------------------------
      type(observation), intent(inout) :: obs
      logical,           intent(in)    :: keepblank  ! Keep blank channels at boundaries?
      logical,           intent(inout) :: error
    end subroutine class_fold_obs
  end interface
  !
  interface
    subroutine class_obs_init(obs,error)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      !  Initialize the input observation for later use
      !  See demo program classdemo-telwrite.f90
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs    !
      logical,           intent(inout) :: error  !
    end subroutine class_obs_init
  end interface
  !
  interface
    subroutine class_obs_reset(obs,ndata,error)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      !  Zero-ify and resize the input observation for later use
      !  See demo program classdemo-telwrite.f90
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs    !
      integer(kind=4),   intent(in)    :: ndata  ! Number of values the observation can accept in return
      logical,           intent(inout) :: error  ! Logical error flag
    end subroutine class_obs_reset
  end interface
  !
  interface
    subroutine class_obs_clean(obs,error)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      !  Clean/free the input observation before deleting it
      !  See demo program classdemo-telwrite.f90
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs    !
      logical,           intent(inout) :: error  !
    end subroutine class_obs_clean
  end interface
  !
  interface
    subroutine reallocate_obs(obs,new_ndata,error)
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      !   (Re)allocate obs. buffers
      !   Keep contents when enlarging the buffers
      !   The headers are not modified at all
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs        ! Current observation
      integer(kind=4),   intent(in)    :: new_ndata  ! Size of new obs arrays
      logical,           intent(out)   :: error      ! Error flag
    end subroutine reallocate_obs
  end interface
  !
  interface
    subroutine class_subtract(obs1,obs2,diff,error)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      ! Perform obs1-obs2 and return the result in the output observation
      !---------------------------------------------------------------------
      type(observation), intent(in)    :: obs1   !
      type(observation), intent(in)    :: obs2   !
      type(observation), intent(inout) :: diff   !
      logical,           intent(inout) :: error  !
    end subroutine class_subtract
  end interface
  !
  interface
    subroutine class_subtract_cons(h1,h2,error)
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      ! Check the consistency of the 2 input observations
      !---------------------------------------------------------------------
      type(header), intent(in)    :: h1     ! Header of 1st obs
      type(header), intent(in)    :: h2     ! Header of 2nd obs
      logical,      intent(inout) :: error  ! Logical error flag
    end subroutine class_subtract_cons
  end interface
  !
  interface
    subroutine class_subtract_data(obs1,obs2,diff,error)
      use gbl_constant
      use gbl_message
      use class_types
      !---------------------------------------------------------------------
      ! @ public (for mrtcal)
      ! Data difference. Only aligned spectra are implemented!
      !---------------------------------------------------------------------
      type(observation), intent(in)    :: obs1   !
      type(observation), intent(in)    :: obs2   !
      type(observation), intent(inout) :: diff   !
      logical,           intent(inout) :: error  ! Logical error flag
    end subroutine class_subtract_data
  end interface
  !
  interface
    subroutine my_get_beam(telescope,freq_mhz,found,beam_rad,error)
      use phys_const
      !---------------------------------------------------------------------
      ! @ public
      ! Compute the beam width for given telescope at given frequency
      ! The telescope name can be either:
      !  - a Class telescope name e.g. 30ME0HUI-V01,
      !  - a telescope name given by the user (e.g. through variable MAP%TELES)
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: telescope  ! [      ] Class telescope name
      real(kind=8),     intent(in)    :: freq_mhz   ! [MHz   ] Sky frequency
      logical,          intent(out)   :: found      ! [      ] Found the telescope beam?
      real(kind=4),     intent(out)   :: beam_rad   ! [radian] Beam size
      logical,          intent(inout) :: error      ! [      ] Return status
    end subroutine my_get_beam
  end interface
  !
  interface
    subroutine class_user_exists(obs,iuser)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      !  Search the User subsection matching the current hooks known by
      ! Class. Return index 0 if no such subsection exists.
      !---------------------------------------------------------------------
      type(observation), intent(in)  :: obs
      integer(kind=4),   intent(out) :: iuser
    end subroutine class_user_exists
  end interface
  !
  interface
    subroutine class_user_owner(sowner,stitle)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%owner character variable
      !---------------------------------------------------------------------
      character(len=*), intent(in) :: sowner  ! Section owner
      character(len=*), intent(in) :: stitle  ! Section title
    end subroutine class_user_owner
  end interface
  !
  interface
    subroutine class_user_toclass(usertoclass)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%toclass procedure to the input procedure
      !---------------------------------------------------------------------
      external usertoclass
    end subroutine class_user_toclass
  end interface
  !
  interface
    subroutine class_user_dump(userdump)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%dump procedure to the input procedure
      !---------------------------------------------------------------------
      external userdump
    end subroutine class_user_dump
  end interface
  !
  interface
    subroutine class_user_setvar(usersetvar)
      use class_setup
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%setvar procedure to the input procedure
      !---------------------------------------------------------------------
      external usersetvar
    end subroutine class_user_setvar
  end interface
  !
  interface
    subroutine class_user_fix(userfix)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%fix procedure to the input procedure
      !---------------------------------------------------------------------
      external userfix
    end subroutine class_user_fix
  end interface
  !
  interface
    subroutine class_user_find(userfind)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%find procedure to the input procedure
      !---------------------------------------------------------------------
      external userfind
    end subroutine class_user_find
  end interface
  !
  interface
    subroutine class_user_varidx_fill(uservaridx_fill)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%varidx_fill procedure to the input
      ! procedure
      !---------------------------------------------------------------------
      external uservaridx_fill
    end subroutine class_user_varidx_fill
  end interface
  !
  interface
    subroutine class_user_varidx_defvar(uservaridx_defvar)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%varidx_defvar procedure to the input
      ! procedure
      !---------------------------------------------------------------------
      external uservaridx_defvar
    end subroutine class_user_varidx_defvar
  end interface
  !
  interface
    subroutine class_user_varidx_realloc(uservaridx_realloc)
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Set the userhooks(cuserhooks)%varidx_realloc procedure to the input
      ! procedure
      !---------------------------------------------------------------------
      external uservaridx_realloc
    end subroutine class_user_varidx_realloc
  end interface
  !
  interface
    subroutine class_user_def_inte(suffix,ndim,dims,error)
      use gildas_def
      use class_buffer
      use class_data
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Define the Sic integer variable R%USER%OWNER%SUFFIX
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix   ! Component name
      integer(kind=4),  intent(in)    :: ndim     ! Number of dimensions (0=scalar)
      integer(kind=4),  intent(in)    :: dims(4)  ! Dimensions (if needed)
      logical,          intent(inout) :: error    ! Logical error flag
    end subroutine class_user_def_inte
  end interface
  !
  interface
    subroutine class_user_def_real(suffix,ndim,dims,error)
      use gildas_def
      use class_buffer
      use class_data
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Define the Sic real variable R%USER%OWNER%SUFFIX
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix   ! Component name
      integer(kind=4),  intent(in)    :: ndim     ! Number of dimensions (0=scalar)
      integer(kind=4),  intent(in)    :: dims(4)  ! Dimensions (if needed)
      logical,          intent(inout) :: error    ! Logical error flag
    end subroutine class_user_def_real
  end interface
  !
  interface
    subroutine class_user_def_dble(suffix,ndim,dims,error)
      use gildas_def
      use class_buffer
      use class_data
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Define the Sic double variable R%USER%OWNER%SUFFIX
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix   ! Component name
      integer(kind=4),  intent(in)    :: ndim     ! Number of dimensions (0=scalar)
      integer(kind=4),  intent(in)    :: dims(4)  ! Dimensions (if needed)
      logical,          intent(inout) :: error    ! Logical error flag
    end subroutine class_user_def_dble
  end interface
  !
  interface
    subroutine class_user_def_char(suffix,lchain,error)
      use class_buffer
      use class_data
      use class_user
      !---------------------------------------------------------------------
      ! @ public
      !  Define the Sic character variable R%USER%OWNER%SUFFIX
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix   ! Component name
      integer(kind=4),  intent(in)    :: lchain   ! String length in the 'data' buffer
      logical,          intent(inout) :: error    ! Logical error flag
    end subroutine class_user_def_char
  end interface
  !
  interface class_user_varidx_def_charn
    subroutine class_user_varidx_def_charn_1d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_charn
      !  Define the Sic character array IDX%USER%OWNER%TITLE%SUFFIX[:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix    ! Component name
      character(len=*), intent(in)    :: array(:)  ! Target 1D array
      logical,          intent(inout) :: error     ! Logical error flag
    end subroutine class_user_varidx_def_charn_1d
    subroutine class_user_varidx_def_charn_2d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_charn
      !  Define the Sic character array IDX%USER%OWNER%TITLE%SUFFIX[:,:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix      ! Component name
      character(len=*), intent(in)    :: array(:,:)  ! Target 2D array
      logical,          intent(inout) :: error       ! Logical error flag
    end subroutine class_user_varidx_def_charn_2d
  end interface class_user_varidx_def_charn
  !
  interface class_user_varidx_def_dble
    subroutine class_user_varidx_def_dble_1d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_dble
      !  Define the Sic double array IDX%USER%OWNER%TITLE%SUFFIX[:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix    ! Component name
      real(kind=8),     intent(in)    :: array(:)  ! Target 1D array
      logical,          intent(inout) :: error     ! Logical error flag
    end subroutine class_user_varidx_def_dble_1d
    subroutine class_user_varidx_def_dble_2d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_dble
      !  Define the Sic double array IDX%USER%OWNER%TITLE%SUFFIX[:,:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix      ! Component name
      real(kind=8),     intent(in)    :: array(:,:)  ! Target 2D array
      logical,          intent(inout) :: error       ! Logical error flag
    end subroutine class_user_varidx_def_dble_2d
  end interface class_user_varidx_def_dble
  !
  interface class_user_varidx_def_inte
    subroutine class_user_varidx_def_inte_1d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_inte
      !  Define the Sic integer array IDX%USER%OWNER%TITLE%SUFFIX[:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix    ! Component name
      integer(kind=4),  intent(in)    :: array(:)  ! Target 1D array
      logical,          intent(inout) :: error     ! Logical error flag
    end subroutine class_user_varidx_def_inte_1d
    subroutine class_user_varidx_def_inte_2d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_inte
      !  Define the Sic integer array IDX%USER%OWNER%TITLE%SUFFIX[:,:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix      ! Component name
      integer(kind=4),  intent(in)    :: array(:,:)  ! Target 2D array
      logical,          intent(inout) :: error       ! Logical error flag
    end subroutine class_user_varidx_def_inte_2d
  end interface class_user_varidx_def_inte
  !
  interface class_user_varidx_def_real
    subroutine class_user_varidx_def_real_1d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_real
      !  Define the Sic real array IDX%USER%OWNER%TITLE%SUFFIX[:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix    ! Component name
      real(kind=4),     intent(in)    :: array(:)  ! Target 1D array
      logical,          intent(inout) :: error     ! Logical error flag
    end subroutine class_user_varidx_def_real_1d
    subroutine class_user_varidx_def_real_2d(suffix,array,error)
      use gildas_def
      use class_index
      use class_user
      !---------------------------------------------------------------------
      ! @ public-generic class_user_varidx_def_real
      !  Define the Sic real array IDX%USER%OWNER%TITLE%SUFFIX[:,:]
      !---------------------------------------------------------------------
      character(len=*), intent(in)    :: suffix      ! Component name
      real(kind=4),     intent(in)    :: array(:,:)  ! Target 2D array
      logical,          intent(inout) :: error       ! Logical error flag
    end subroutine class_user_varidx_def_real_2d
  end interface class_user_varidx_def_real
  !
  interface
    subroutine class_obs_write(obs,error)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      !  Write the observation to the currently opened output file
      !  See demo program classdemo-telwrite.f90
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs    !
      logical,           intent(inout) :: error  ! Logical error flag
    end subroutine class_obs_write
  end interface
  !
  interface
    subroutine class_write(obs,error,user_function)
      use gbl_message
      use class_common
      use class_setup
      use class_types
      use plot_formula
      !---------------------------------------------------------------------
      ! @ public
      !  Writes the input observation onto the output file. "write" means:
      ! open the observation in the output file, transfer, close in the
      ! output file. Output file is not flushed, it is up to the calling
      ! routine to flush it or not for efficiency purpose.
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs            !
      logical,           intent(inout) :: error          ! Return error code
      logical,           external      :: user_function  ! Handling of user defined sections
    end subroutine class_write
  end interface
  !
  interface
    subroutine class_write_flush(obs,error)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      ! CLASS External routine (available to other programs)
      ! Close an observation and reopen the output file
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs    !
      logical,           intent(inout) :: error  ! Error status
    end subroutine class_write_flush
  end interface
  !
  interface
    subroutine class_write_close(obs,error)
      use class_types
      !---------------------------------------------------------------------
      ! @ public
      ! CLASS External routine (available to other programs)
      ! Close an observation, but not the file
      !---------------------------------------------------------------------
      type(observation), intent(inout) :: obs    !
      logical,           intent(inout) :: error  ! Error status
    end subroutine class_write_close
  end interface
  !
  interface
    subroutine class_write_init(error)
      use classic_api
      !---------------------------------------------------------------------
      ! @ public
      !   Public procedure suited for programs linked basically to the
      ! libclass, i.e. with no Gildas specific features like interpreter or
      ! initializations or so. See demo program classdemo-telwrite.f90
      !   Perform the basic initializations of the libclass needed for
      ! the writing process (e.g. stand-alone program at the telescope).
      !   Should be done once at program startup.
      !---------------------------------------------------------------------
      logical, intent(inout) :: error  ! Logical error flag
    end subroutine class_write_init
  end interface
  !
  interface
    subroutine class_write_clean(error)
      !---------------------------------------------------------------------
      ! @ public
      !   Public procedure suited for programs linked basically to the
      ! libclass, i.e. with no Gildas specific features like interpreter or
      ! initializations or so. See demo program classdemo-telwrite.f90
      !   Perform the basic cleaning of the libclass needed after the
      ! writing process (e.g. stand-alone program at the telescope).
      !  Should be done once before leaving the program
      !---------------------------------------------------------------------
      logical, intent(inout) :: error  ! Logical error flag
    end subroutine class_write_clean
  end interface
  !
end module classcore_interfaces_public
