!     
!     $Id: modulePakoPlots.f90,v 1.2 2005/06/22 14:46:29 ungerech Exp $
!     
Module modulePakoPlots
  !     
  Use modulePakoTypes
  Use modulePakoGlobalParameters
  use modulePakoMessages
  !
  Implicit None
  !
  Save
  Private
  Public :: configurePlots, plotOtfCircle, plotOtfLinear
  Public :: plotTrackP, plotOtfCurveP
  Public :: plotCalSky, plotPointingStart, plotTrack
  !     
  ! TBD: all SRs should have a version using Type xyPointType
  !      these versions are indicated by names ...P()
  !      e.g., plotOtfCurveP()
  !
  ! *** Variables  for Plots ***
  Include 'inc/variables/headerForPlotMethods.inc'
  !     
  ! *** working variables and constants ***
  !     standard constants
!!$      Real, Parameter  :: Pi=3.141592653589793
!!$      Real, Parameter  :: degs=Pi/180.0
  !     
Contains
  !     
  Subroutine configurePlots
    !     
!!$         Write (6,*) ' ---> SR configurePlots (in modulePlots)'
!!$         Write (6,*) "pPointChar ", pPointChar
    !     
    Include 'inc/variables/configurePlotMethods.inc'
    !     
  End Subroutine configurePlots
!!!
!!!
  Subroutine plotCalSky(    xStart, yStart,                         &
       &                          errorP,                                 &
       &                          number, name,   Type)
    !
    Real,             Intent(IN)           :: xStart, yStart
    Logical,          Intent(OUT)          :: errorP
    Integer,          Intent(IN), Optional :: number
    Character(len=*), Intent(IN), Optional :: name, Type
    !
    ! *** functions called: ***
    Logical       :: gr_error
    !
    errorP = .False.
    !     
    Write (pPandO,*)    pCalNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    !
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    !
    Write (pPandO,*)    0.5
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !
    Write (pPandO,*)    pCalMarker
    Call pakoGregExec( 'set marker'     , pPandO, errorP)
    !
    Write (pPandO,*)    xStart, yStart,                           &
         &                       ' ', pCalChar, ' 5 /user'
    Call pakoGregExec( 'draw text'      , pPandO, errorP)
    !
    Write (pPandO,*)    xStart, yStart, ' /user'
    Call pakoGregExec( 'draw marker'    , pPandO, errorP)
    !
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !
    errorP =  errorP .Or. GR_ERROR()
    !
    If (errorP)                                                   &
         &        Call PakoMessage(6,2,'Calibrate',' could not plot ')
    !
    Return
    !
  End Subroutine plotCalSky
!!!
!!!
  Subroutine plotTrack(    xStart, yStart,                          &
       &                          errorP,                                 &
       &                          number, name,   Type)
    !
    Real,             Intent(IN)           :: xStart, yStart
    Logical,          Intent(OUT)          :: errorP
    Integer,          Intent(IN), Optional :: number
    Character(len=*), Intent(IN), Optional :: name, Type
    !     
    ! *** functions called: ***
    Logical       :: gr_error
    !
    errorP = .False.
    !     
    Write (pPandO,*)    pRefNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    !
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    !
    Write (pPandO,*)    0.5
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !
    Write (pPandO,*)    pRefMarker
    Call pakoGregExec( 'set marker'     , pPandO, errorP)
    !
    Write (pPandO,*)    xStart, yStart,                           &
         &                       ' ', pRefChar, ' 5 /user'
    Call pakoGregExec( 'draw text'      , pPandO, errorP)
    !
    Write (pPandO,*)    xStart, yStart, ' /user'
    Call pakoGregExec( 'draw marker'    , pPandO, errorP)
    !
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !
    errorP =  errorP .Or. GR_ERROR()
    !
    If (errorP)                                                   &
         &        Call PakoMessage(6,2,'Track',' could not plot ')
    !
    Return
    !
  End Subroutine plotTrack
!!!
!!!
  Subroutine plotTrackP   (pStart,                                   &
       &                         errorP,                                   &
       &                         number, name,   Type)
    !     
    Type(xyPointType), Intent(IN)          :: pStart 
    !
    Logical,          Intent(OUT)          :: errorP
    Integer,          Intent(IN), Optional :: number
    Character(len=*), Intent(IN), Optional :: name, Type
    !     
    ! *** functions called: ***
    Logical       :: gr_error
    !
    integer :: lenc
    !
    errorP = .False.
    !     
    !D      WRITE (6,*) ' ---> SR plotTrackP (in modulePlots)'
    !
    errorP = .False.
    !
!!$    Call SIC_UPPER(Type)
    !
    If (Type.eq.ss%on) Then
       !     
       Write (pPandO,*)    pOnNpen
       Call pakoGregExec( 'pen'            , pPandO, errorP)
       !
       Write (pPandO,*)   'd'
       Call pakoGregExec( 'set font'       , pPandO, errorP)
       !
       Write (pPandO,*)    0.5
       Call pakoGregExec( 'set character'  , pPandO, errorP)
       !
       Write (pPandO,*)    pOnMarker
       Call pakoGregExec( 'set marker'     , pPandO, errorP)
       !
       Write (pPandO,*)    pStart%x, pStart%y,                         &
            &                       ' ', pOnChar, ' 5 /user'
       Call pakoGregExec( 'draw text'      , pPandO, errorP)
       !
       Write (pPandO,*)    pStart%x, pStart%y, ' /user'
       Call pakoGregExec( 'draw marker'    , pPandO, errorP)
       !
    End If
    !
    If (Type.eq.ss%ref) Then
       !     
       Write (pPandO,*)    pRefNpen
       Call pakoGregExec( 'pen'            , pPandO, errorP)
       !
       Write (pPandO,*)   'd'
       Call pakoGregExec( 'set font'       , pPandO, errorP)
       !
       Write (pPandO,*)    0.5
       Call pakoGregExec( 'set character'  , pPandO, errorP)
       !
       Write (pPandO,*)    pRefMarker
       Call pakoGregExec( 'set marker'     , pPandO, errorP)
       !
       Write (pPandO,*)    pStart%x, pStart%y,                         &
            &                       ' ', pRefChar, ' 5 /user'
       Call pakoGregExec( 'draw text'      , pPandO, errorP)
       !
       Write (pPandO,*)    pStart%x, pStart%y, ' /user'
       Call pakoGregExec( 'draw marker'    , pPandO, errorP)
       !
    End If
    !
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !
    errorP =  errorP .Or. GR_ERROR()
    !
    If (errorP)                                                     &
         &        Call PakoMessage(6,2,'Track',' could not plot ')
    !
    Return
    !
    Return
  End Subroutine plotTrackP
!!!
!!!
  Subroutine plotOtfCircle (xStart, yStart,                         &
       &                          xEnd,   yEnd,   turn, errorP,           &
       &                          number, name,   Type)
    !     
    Real,             Intent(IN)           :: xStart, yStart
    Real,             Intent(IN)           :: xEnd, yEnd
    Real,             Intent(IN)           :: turn
    Logical,          Intent(OUT)          :: errorP
    Integer,          Intent(IN), Optional :: number
    Character(len=*), Intent(IN), Optional :: name, Type
    !     
    Real :: xId, yId
    Real :: xDelta, yDelta 
    Real :: xDistance, xRadius
    Real :: alpha, lambda, aStart, aEnd, xcen, ycen 
    !     
    Real, Dimension(100) :: x, y
    !     
    !     loop variables:
    Integer :: ii=1
    !
    ! *** functions called: ***
    Logical       :: gr_error
    !
    Integer :: lenc
    !
    errorP = .False.
    !     
    !D    WRITE (6,*) ' ---> SR plotOtfCircle (in modulePlots)'
    !D    WRITE (6,*) 'xStart = ', xStart
    !D    WRITE (6,*) 'yStart = ', yStart
    !D    WRITE (6,*) 'xEnd   = ', xEnd
    !D    WRITE (6,*) 'yEnd   = ', yEnd
    !D    WRITE (6,*) 'turn   = ', turn
    !D    IF (Present(number)) WRITE (6,*) 'number = ', number
    !D    IF (Present(name))   WRITE (6,*) 'name   = ', name
    !D    IF (Present(type))   WRITE (6,*) 'type   = ', type
    !     
    !
    !     
    xDelta = xEnd-xStart
    yDelta = yEnd-yStart
    !     
    !D       WRITE (6,*) ' xEnd   = ', xEnd
    !D       WRITE (6,*) ' yEnd   = ', yEnd
    !D       WRITE (6,*) ' xDelta = ', xDelta
    !D       WRITE (6,*) ' yDelta = ', yDelta
    !     
    !!  we need lambda = the argument of (xEnd-xStart)+i*(yEnd-yStart)
    !!  in Mathematica this is ARcTan[xEnd-xStart,yEnd-yStart]
    !!  but with the simple-minded Atan(y/x) we have to be careful:
    !     
    If (xDelta.Gt.0.0.And.yDelta.Ge.0) Then
       lambda = Atan(yDelta/xDelta)
    End If
    !     
    If (xDelta.Gt.0.0.And.yDelta.Lt.0) Then
       lambda = 2*Pi+Atan(yDelta/xDelta)
    End If
    !     
    If (xDelta.Eq.0.0.And.yDelta.Gt.0) Then
       lambda = Pi/2
    End If
    !     
    If (xDelta.Eq.0.0.And.yDelta.Lt.0) Then
       lambda = 3*Pi/2
    End If
    !     
    If (xDelta.Lt.0.0) Then
       lambda = Pi+Atan(yDelta/xDelta)
    End If
    !     
    alpha     = turn*degs
    xDistance = Sqrt((xEnd-xStart)**2+(yEnd-yStart)**2)
    xRadius   = (xDistance/2.0)/Sin(turn/2.0*degs)
    aStart    = lambda-Pi/2.0-alpha/2.0
    aEnd      = lambda-Pi/2.0+alpha/2.0
    xcen      = xStart-xRadius*Cos(aStart)
    ycen      = yStart-xRadius*Sin(aStart)
    !     
    ! ***    Control Points: Center
    !
    Write (pPandO,*)    pCpNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    !     
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    !     
    Write (pPandO,*)    pCpCharSize
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !     
    Write (pPandO,*)    pCpMarker
    Call pakoGregExec( 'set marker'     , pPandO, errorP)
    !
    Write (pPandO,*)    xCen, yCen,                                 &
         &                       ' ', pCpChar(1:lenc(pCpChar))//'center',    &
         &                       ' 5 /user'
    Call pakoGregExec( 'draw text'      , pPandO, errorP)
    !
    Write (pPandO,*)    xCen, yCen, ' /user'
    Call pakoGregExec( 'draw marker'    , pPandO, errorP)
    !
    Write (pPandO,*)                                                &
         &        xStart ,                                                   &
         &        yStart ,                                                   &
         &        ' /user'
    Call pakoGregExec( 'draw relocate'  , pPandO, errorP)
    Write (pPandO,*)                                                &
         &        xCen,                                                      &
         &        yCen,                                                      &
         &        ' /user'
    Call pakoGregExec( 'draw line'  , pPandO, errorP)
    Write (pPandO,*)                                                &
         &        xEnd,                                                      &
         &        yEnd,                                                      &
         &        ' /user'
    Call pakoGregExec( 'draw line'  , pPandO, errorP)
    !
    !D       WRITE (6,*) ' lambda   = ', lambda
    !D       WRITE (6,*) ' turn     = ', turn
    !D       WRITE (6,*) ' degs     = ', degs
    !D       WRITE (6,*) ' turn     = ', turn
    !D       WRITE (6,*) ' alpha    = ', alpha
    !D       WRITE (6,*) ' xDistance   = ', xDistance
    !D       WRITE (6,*) ' xRadius     = ', xRadius  
    !D       WRITE (6,*) ' aStart      = ', aStart
    !D       WRITE (6,*) ' aEnd        = ', aEnd
    !D       WRITE (6,*) ' xcen         = ', xcen
    !D       WRITE (6,*) ' ycen         = ', ycen
    !     
    ! ***    OTF     
    !
    Do ii = 1,100,1
       x(ii) = xcen+xRadius*Cos(aStart+((ii-1.)/99.)*alpha)
       y(ii) = ycen+xRadius*Sin(aStart+((ii-1.)/99.)*alpha)
       !D          WRITE (6,*) ii, x(ii), y(ii)
    End Do
    !     
    Write (pPandO,*)    pOtfNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    !     
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    !     
    Write (pPandO,*)    pOtfCharSize
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !     
    Write (pPandO,*)    pOtfMarker
    Call pakoGregExec( 'set marker'     , pPandO, errorP)
    !
    If (Present(number)) Then
       xId    =  x(1)-5*(x(2)-x(1))
       yId    =  y(1)-5*(y(2)-y(1))
       !D       WRITE (6,*) ' xId         = ', xId
       !D       WRITE (6,*) ' yId         = ', yId
       Write (pPandO,*)                                               &
            &        xId,                                                      &
            &        yId,                                                      &
            &        number,                                                   &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    If (Present(Type)) Then
       xId    =  x(1)-10*(x(2)-x(1))
       yId    =  y(1)-10*(y(2)-y(1))
       Write (pPandO,*)                                               &
            &        xId,                                                      &
            &        yId,                                                      &
            &        Type,                                                     &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    If (Present(name)) Then
       xId    =  x(1)-15*(x(2)-x(1))
       yId    =  y(1)-15*(y(2)-y(1))
       Write (pPandO,*)                                               &
            &        xId,                                                      &
            &        yId,                                                      &
            &        name,                                                     &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    Call gr4_give('X',100,x)
    Call gr4_give('Y',100,y)
    Write (pPandO,*) ' '
    Call pakoGregExec( 'connect'  , pPandO, errorP)
    Write (pPandO,*)                                               &
         &        x(99),                                                    &
         &        y(99),                                                    &
         &        ' /user'
    Call pakoGregExec( 'draw relocate'  , pPandO, errorP)
    Write (pPandO,*)                                               &
         &        x(100),                                                   &
         &        y(100),                                                   &
         &        ' /user'
    Call pakoGregExec( 'draw arrow'  , pPandO, errorP)
    !     
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !     
    errorP =  errorP .Or. gr_error()
    !     
    If (errorP)                                                    &
         &        Call pakoMessage(6,2,'plotOtfCircle',' could not plot ')
    !     
    Return
  End Subroutine plotOtfCircle
!!!
!!!
  Subroutine plotOtfCurveP(pStart,                                   &
       &                         pEnd,                                     &
       &                         CPstart,                                  &
       &                         CPend,                                    &
       &                         errorP,                                   &
       &                         number, name,   Type)
    !     
    Type(xyPointType), Intent(IN)          :: pStart 
    Type(xyPointType), Intent(IN)          :: pEnd
    Type(xyPointType), Intent(IN)          :: CPstart 
    Type(xyPointType), Intent(IN)          :: CPend 
    !
    Logical,          Intent(OUT)          :: errorP
    Integer,          Intent(IN), Optional :: number
    Character(len=*), Intent(IN), Optional :: name, Type
    !     
    Real :: t
    Real :: xID, yID
    !     
    Real, Dimension(100) :: x, y
    !     
    ! *** functions called: ***
    Logical       :: gr_error
    !
    integer :: lenc
    !
    !     loop variables:
    Integer :: ii=1
    !
    errorP = .False.
    !     
    !D      WRITE (6,*) ' ---> SR plotOtfCurveP (in modulePlots)'
    !
    !D    WRITE (6,*) 'pStart%x = ', pStart%x
    !D    WRITE (6,*) 'pStart%y = ', pStart%y
    !D    WRITE (6,*) 'pEnd%x   = ', pEnd%x
    !D    WRITE (6,*) 'pEnd%y   = ', pEnd%y
    !D    IF (Present(number)) WRITE (6,*) 'number = ', number
    !D    IF (Present(name))   WRITE (6,*) 'name   = ', name
    !D    IF (Present(type))   WRITE (6,*) 'type   = ', type
    !     
    ! ***    Control Points
    !
    Write (pPandO,*)    pCpNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    !     
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    !     
    Write (pPandO,*)    pCpCharSize
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !     
    Write (pPandO,*)    pCpMarker
    Call pakoGregExec( 'set marker'     , pPandO, errorP)
    !
    Write (pPandO,*)                                                &
         &        pStart%x ,                                                 &
         &        pStart%y ,                                                 &
         &        ' /user'
    Call pakoGregExec( 'draw relocate'  , pPandO, errorP)
    Write (pPandO,*)                                                &
         &        CPstart%x,                                                 &
         &        CPStart%y,                                                 &
         &        ' /user'
    Call pakoGregExec( 'draw arrow'  , pPandO, errorP)
    !
    Write (pPandO,*)    CPstart%x, CPstart%y,                       &
         &                       ' ', pCpChar(1:lenc(pCpChar))//'start',     &
         &                       ' 5 /user'
    Call pakoGregExec( 'draw text'      , pPandO, errorP)
    !
    Write (pPandO,*)                                                &
         &        CPend%x,                                                   &
         &        CPEnd%y,                                                   &
         &        ' /user'
    Call pakoGregExec( 'draw relocate'  , pPandO, errorP)
    Write (pPandO,*)                                                &
         &        pEnd%x ,                                                   &
         &        pEnd%y ,                                                   &
         &        ' /user'
    Call pakoGregExec( 'draw arrow'  , pPandO, errorP)
    !
    Write (pPandO,*)    CPend%x, CPend%y,                           &
         &                       ' ', pCpChar(1:lenc(pCpChar))//'end',       &
         &                       ' 5 /user'
    Call pakoGregExec( 'draw text'      , pPandO, errorP)
    !
    ! ***    OTF     
    !
    Write (pPandO,*)    pOtfNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    !     
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    !     
    Write (pPandO,*)    pOtfCharSize
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !     
    Write (pPandO,*)    pOtfMarker
    Call pakoGregExec( 'set marker'     , pPandO, errorP)
    !     
    !     
    Do ii = 1,100,1
       t     = (real(ii)-1.0)/(100.0-1.0)
       ! TBD: check math
       x(ii) =       (1.0-t)**3.0       *pStart%x                   &
            &              + 3.0*(1.0-t)**2.0*t     *CPstart%x                  &
            &              + 3.0*(1.0-t)     *t**2.0*CPend%x                    &
            &              +                  t**3.0*pEnd%x                       
       y(ii) =       (1.0-t)**3.0       *pStart%y                   &
            &              + 3.0*(1.0-t)**2.0*t     *CPstart%y                  &
            &              + 3.0*(1.0-t)     *t**2.0*CPend%y                    &
            &              +                  t**3.0*pEnd%y                       
       !D          WRITE (6,*) ii, x(ii), y(ii)
    End Do
    !     
    If (Present(number)) Then
       xId    =  x(1)-5*(x(2)-x(1))
       yId    =  y(1)-5*(y(2)-y(1))
       !D       WRITE (6,*) ' xId         = ', xId
       !D       WRITE (6,*) ' yId         = ', yId
       Write (pPandO,*)                                               &
            &        xId,                                                      &
            &        yId,                                                      &
            &        number,                                                   &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    If (Present(Type)) Then
       xId    =  x(1)-10*(x(2)-x(1))
       yId    =  y(1)-10*(y(2)-y(1))
       Write (pPandO,*)                                               &
            &        xId,                                                      &
            &        yId,                                                      &
            &        Type,                                                     &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    If (Present(name)) Then
       xId    =  x(1)-15*(x(2)-x(1))
       yId    =  y(1)-15*(y(2)-y(1))
       Write (pPandO,*)                                               &
            &        xId,                                                      &
            &        yId,                                                      &
            &        name,                                                     &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    Call gr4_give('X',100,x)
    Call gr4_give('Y',100,y)
    Write (pPandO,*) ' '
    Call pakoGregExec( 'connect'  , pPandO, errorP)
    Write (pPandO,*)                                               &
         &        x(99),                                                    &
         &        y(99),                                                    &
         &        ' /user'
    Call pakoGregExec( 'draw relocate'  , pPandO, errorP)
    Write (pPandO,*)                                               &
         &        x(100),                                                   &
         &        y(100),                                                   &
         &        ' /user'
    Call pakoGregExec( 'draw arrow'  , pPandO, errorP)
    !     
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !     
    errorP =  errorP .Or. gr_error()
    !     
    If (errorP)                                                    &
         &        Call pakoMessage(6,2,'plotOtfCurve',' could not plot ')
    !     
    Return
  End Subroutine plotOtfCurveP
!!!
!!!
  Subroutine plotOtfLinear (xStart, yStart,                         &
       &                          xEnd,   yEnd,   errorP,                 &
       &                          number, name,   Type)
    !     
    Real,             Intent(IN)           :: xStart, yStart
    Real,             Intent(IN)           :: xEnd, yEnd
    Logical,          Intent(OUT)          :: errorP
    Integer,          Intent(IN), Optional :: number
    Character(len=*), Intent(IN), Optional :: name, Type
    !     
    ! *** functions called: ***
    Logical       :: gr_error
    !
    errorP = .False.
    !     
    !D    WRITE (6,*) ' ---> SR plotOtfLinear (in modulePlots)'
    !D    WRITE (6,*) 'xStart = ', xStart
    !D    WRITE (6,*) 'yStart = ', yStart
    !D    WRITE (6,*) 'xEnd   = ', xEnd
    !D    WRITE (6,*) 'yEnd   = ', yEnd
    !D    IF (Present(number)) WRITE (6,*) 'number = ', number
    !D    IF (Present(name))   WRITE (6,*) 'name   = ', name
    !D    IF (Present(type))   WRITE (6,*) 'type   = ', type
    !     
    Write (pPandO,*)    pOtfNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    Write (pPandO,*)    pOtfCharSize
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !     
    If (Present(Type) .And. Type.Eq.'pointing') Then
       Write (pPandO,*)    pPointNpen
       Call pakoGregExec( 'pen'            , pPandO, errorP)
       Write (pPandO,*)   's'
       Call pakoGregExec( 'set font'       , pPandO, errorP)
       Write (pPandO,*)    pPointCharSize
       Call pakoGregExec( 'set character'  , pPandO, errorP)
    End If
    !     
    If (Present(Type) .And. Type.Eq.'extra') Then
       Write (pPandO,*)    6
       Call pakoGregExec( 'pen'            , pPandO, errorP)
       Write (pPandO,*)   's'
       Call pakoGregExec( 'set font'       , pPandO, errorP)
    End If
    !     
!!$          WRITE (pPandO,*)    0.0, 0.0,
!!$      &                       ' ', pOtfChar, ' 5 /user'
!!$          CALL pakoGregExec( 'draw text'      , pPandO, errorP)
!!$          WRITE (pPandO,*)    pOtfMarker
!!$          CALL pakoGregExec( 'set marker'     , pPandO, errorP)
!!$!     
    If (Present(number)) Then
       Write (pPandO,*)                                               &
            &        xStart -0.1*(xEnd -xStart ),                              &
            &        yStart -0.1*(yEnd -yStart ),                              &
            &        number,                                                   &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    If (Present(Type).And.Type.Ne.'pointing'.And.Type.Ne.'extra') Then
       Write (pPandO,*)                                               &
            &        xStart -0.15*(xEnd -xStart ),                             &
            &        yStart -0.15*(yEnd -yStart ),                             &
            &        Type,                                                     &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    If (Present(name)) Then
       Write (pPandO,*)                                               &
            &        xStart -0.25*(xEnd -xStart ),                             &
            &        yStart -0.25*(yEnd -yStart ),                             &
            &        name,                                                     &
            &        ' /user'
       Call pakoGregExec( 'draw text'  , pPandO, errorP)
    End If
    !     
    Write (pPandO,*)                                               &
         &        xStart ,                                                  &
         &        yStart ,                                                  &
         &        ' /user'
    Call pakoGregExec( 'draw relocate'  , pPandO, errorP)
    Write (pPandO,*)                                               &
         &        xEnd ,                                                    &
         &        yEnd ,                                                    &
         &        ' /user'
    Call pakoGregExec( 'draw arrow'  , pPandO, errorP)
    !     
    Call gr_exec(      'set character 0.6' )
    Call gr_exec(      'pen 0'             )
    !     
    errorP =  errorP .Or. GR_ERROR()
    !     
    If (errorP)                                                    &
         &        Call pakoMessage(6,2,'plotOtfLinear',' could not plot ')
    !     
    Return
  End Subroutine plotOtfLinear
!!!
  Subroutine plotPointingStart(                                     &
       &                          errorP,                                 &
       &                          number, name,   Type)
    !
    Logical,          Intent(OUT)          :: errorP
    Integer,          Intent(IN), Optional :: number
    Character(len=*), Intent(IN), Optional :: name, Type
    !     
    errorP = .False.
    !     
    Write (pPandO,*)    pPointNpen
    Call pakoGregExec( 'pen'            , pPandO, errorP)
    !
    Write (pPandO,*)   'd'
    Call pakoGregExec( 'set font'       , pPandO, errorP)
    !
    Write (pPandO,*)    0.5
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !
!!$         write (6,*) "pPointChar ", pPointChar
    !
    Write (pPandO,*)    0.0, 0.0,                                 &
         &                       ' ', pPointChar, ' 5 /user'
    Call pakoGregExec( 'draw text'      , pPandO, errorP)
    !
    Write (pPandO,*)    pPointCharSize
    Call pakoGregExec( 'set character'  , pPandO, errorP)
    !
    Write (pPandO,*)    pPointMarker
    Call pakoGregExec( 'set marker'     , pPandO, errorP)
    !
    Return
    !
  End Subroutine plotPointingStart
!!!
  Subroutine pakoGregExec(plotCommand, plotPandO, errorPlot)
    !     
    Character(len=*),  Intent(IN)   :: plotCommand, plotPandO
    Logical,           Intent(OUT)  :: errorPlot
    !     
    ! *** functions called: ***
    Logical       :: gr_error
    Integer       :: lenc
    !     
    ! *** local variables: ***
    Integer       :: lc, lp, lcp
    Character(len=512) :: plotCPandO
    !     
    lc = lenc(plotCommand)
    lp = lenc(plotPandO)
    !     
    plotCPandO = plotCommand
    Write (plotCPandO(lc+2:),*) plotPandO(1:lp)
    lcp = lenc(plotCPandO)
    !     
    !D    write (6,*) " ---> SR pakoGregExec (in modulePlots): "
    !D    write (6,*) "   ->",plotCPandO(1:lcp),"<-  "
    !     
    Call gr_exec(plotCPandO(1:lcp))
    !     
    errorPlot =  errorPlot .Or. gr_error()
    !     
    Return
  End Subroutine pakoGregExec
  !     
End Module modulePakoPlots
