subroutine putios (name,ier)
  use gsys_interfaces, except_this=>putios
  !---------------------------------------------------------------------
  ! @ public
  ! Print system message corresponding to IO error code IER
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: name  ! Facility name
  integer(kind=4),  intent(in) :: ier   ! 32-bit system message code
  ! Local
  character(len=256) :: msg
  !
  call gag_iostat(msg,ier)
  write(6,'(A,A)') name,trim(msg)
end subroutine putios
!
subroutine putmsg (name,ier)
  !---------------------------------------------------------------------
  ! @ private
  ! UTIL  Internal routine
  !       Print system message corresponding to code IER on SYS$OUTPUT.
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: name  ! Facility name
  integer(kind=4),  intent(in) :: ier   ! 32-bit system message code
  !
  write(6,'(A,A,I6)') name,'System Error number ',ier
end subroutine putmsg
!
subroutine gag_iostat (msg,ier)
  use gsys_interfaces, except_this=>gag_iostat
  !---------------------------------------------------------------------
  ! @ public
  ! Return system message corresponding to IO error code IER
  !---------------------------------------------------------------------
  character(len=*), intent(out) :: msg  ! Returned message
  integer(kind=4),  intent(in)  :: ier  ! 32-bit system message code
  !
#if defined(GFORTRAN)
  call gfc_iostat(msg,ier)
#elif defined(WIN32)
  call win32_iostat(msg,ier)
#elif defined(IFORT)
  call ifort_iostat(msg,ier)
#else
  write(msg,'(A,I6)') 'I/O error number ',ier
#endif
end subroutine gag_iostat
!
subroutine win32_iostat (msg,ier)
  !---------------------------------------------------------------------
  ! @ private
  ! Get system message corresponding to IO error code IER
  !     Version for WIN32 Dec/Compaq compiler
  !---------------------------------------------------------------------
  character(len=*), intent(out) :: msg  ! Returned message
  integer(kind=4),  intent(in)  :: ier  ! 32-bit system message code
  ! Local
  character(len=48) :: io00(22:68)
  !
  data io00                                          &
    /'Input record too long '                        &  ! 22
    ,'Backspace error'                               &  ! 23
    ,'End-of-file during read'                       &  ! 24
    ,'Record number out of range '                   &  ! 25
    ,'OPEN required '                                &  ! 26
    ,'Too many record in I/O statement'              &  ! 27
    ,'CLOSE error'                                   &  ! 28
    ,'File not found'                                &  ! 29
    ,'Open failure'                                  &  ! 30
    ,'Mixed file access modes'                       &  ! 31
    ,'Invalid logical unit number'                   &  ! 32
    ,'ENDFILE error'                                 &  ! 33
    ,'Unit already opened'                           &  ! 34
    ,'Segmented record format error'                 &  ! 35
    ,'Attempt to access non-existent record'         &  ! 36
    ,'Inconsistent record length'                    &  ! 37
    ,'Error during write'                            &  ! 38
    ,'Error during read'                             &  ! 39
    ,'Recursive I/O operation'                       &  ! 40
    ,'Insufficient virtual memory'                   &  ! 41
    ,'No such device'                                &  ! 42
    ,'File name specification error'                 &  ! 43
    ,'Inconsistent record type'                      &  ! 44
    ,'Keyword value error in OPEN statement'         &  ! 45
    ,'Inconsistent OPEN/CLOSE parameters'            &  ! 46
    ,'Write to READONLY file'                        &  ! 47
    ,'Invalid argument to Fortran Run-Time Library'  &  ! 48
    ,' '                                             &
    ,' '                                             &
    ,'Inconsistent file organization',' '            &  ! 51
    ,'No current record',' '                         &  ! 53
    ,'DELETE error',' '                              &  ! 55
    ,'FIND error'                                    &  ! 57
    ,'Format syntax error at or near XX'             &  ! 58
    ,'List directed I/O syntax error'                &  ! 59
    ,'Infinite format loop'                          &  ! 60
    ,'Format/variable-type mismatch'                 &  ! 61
    ,'Syntax error in format'                        &  ! 62
    ,'Output conversion error'                       &  ! 63
    ,'Input conversion error'                        &  ! 64
    ,'Floating invalid'                              &  ! 65
    ,'Output statement overflows record'             &  ! 66
    ,'Input statement requires too much data'        &  ! 67
    ,'Variable format expression value error'/          ! 68
  ! ,' '
  ! ,'Integer overflow'                                 ! 70
  ! ,'Integer divide by zero'
  ! ,'
  !
  if (ier.lt.22 .or. ier.gt.68) then
    write(msg,'(A,I6)') 'I/O error number ',ier
  else
    msg = io00(ier)
  endif
  !
end subroutine win32_iostat
!
subroutine g95_iostat (msg,ier)
  !---------------------------------------------------------------------
  ! @ private
  ! Get system message corresponding to IO error code IER
  !     Version for G95 Gnu compiler.
  !---------------------------------------------------------------------
  character(len=*), intent(out) :: msg  ! Returned message
  integer(kind=4),  intent(in)  :: ier  ! 32-bit system message code
  ! Local
  character(len=40) :: errmsg
  character(len=40) :: io200(15)
  data io200/                               &
    'Conflicting statement options',        &
    'Bad statement option',                 &
    'Missing statement option',             &
    'File already opened in another unit',  &
    'Unattached unit',                      &
    'FORMAT error',                         &
    'Incorrect ACTION specified',           &
    'Read past ENDFILE record',             &
    'Corrupt unformatted sequential file',  &
    'Bad value during read',                &
    'Numeric overflow on read',             &
    'Out of memory',                        &
    'Array already allocated',              &
    'Deallocated a bad pointer',            &
    'Bad record read on input'/
  !
  if (ier.eq.-2) then
    msg = 'End of record'
  elseif  (ier.eq.-1) then
    msg = 'End of file'
  elseif  (ier.lt.200) then
    call gag_errno(ier,errmsg)
    write(msg,'(A,I4,A)')  trim(errmsg)//' (O/S errno # ',ier,')'
  elseif  (ier.le.214) then
    msg = io200(ier-200+1)
  else
    write(msg,'(A,I5)')  'Unknown error code ',ier
  endif
  !
end subroutine g95_iostat
!
subroutine gfc_iostat (msg,ier)
  !---------------------------------------------------------------------
  ! @ private
  ! Get system message corresponding to IO error code IER
  !     Version for GFortran Gnu compiler.
  !---------------------------------------------------------------------
  character(len=*), intent(out) :: msg  ! Returned message
  integer(kind=4),  intent(in)  :: ier  ! 32-bit system message code
  ! Local
  character(len=48) :: errmsg,io5000(17)
  data io5000/                                       &
    'Conflicting statement options',                 &  ! 5001
    'Bad statement option',                          &  ! 5002
    'Missing statement option',                      &  ! 5003
    'File already opened in another unit',           &  ! 5004
    'Unattached unit',                               &  ! 5005
    'FORMAT error',                                  &  ! 5006
    'Incorrect ACTION specified',                    &  ! 5007
    'Read past ENDFILE record',                      &  ! 5008
    'Corrupt unformatted sequential file',           &  ! 5009
    'Bad value during read',                         &  ! 5010
    'Numeric overflow on read',                      &  ! 5011
    'Internal error in run-time library',            &  ! 5012
    'Internal unit I/O error',                       &  ! 5013
    '? (LIBERROR_ALLOCATION)',                       &  ! 5014 ?
    'Write exceeds length of DIRECT access record',  &  ! 5015
    'I/O past end of record on unformatted file',    &  ! 5016
    'Unformatted file structure has been corrupted' /   ! 5017
  !
  select case (ier)
  case(-2)
    msg = 'End of record'
    !
  case(-1)
    msg = 'End of file'
    !
  case(5001:5017)
    msg = io5000(ier-5000)
    !
  case default
    call gag_errno(ier,errmsg)
    write(msg,'(A,I4,A)')  trim(errmsg)//' (O/S errno # ',ier,')'
    !
  end select
  !
end subroutine gfc_iostat
!
subroutine ifort_iostat(msg,ier)
  !---------------------------------------------------------------------
  ! @ private
  ! Get system message corresponding to IO error code IER
  !     Version for Intel Fortran compiler.
  !---------------------------------------------------------------------
  character(len=*), intent(out) :: msg  ! Returned message
  integer(kind=4),  intent(in)  :: ier  ! 32-bit system message code
  ! Local
  character(len=48) :: io08(8:79)
  data io08/                                             &
    'Internal consistency check failure',                &  !  8
    'Permission to access file denied',                  &  !  9
    'Cannot overwrite existing file',                    &  ! 10
    'Unit not connected',                                &  ! 11
    ' ',                                                 &  ! 12 (not used)
    ' ',                                                 &  ! 13 (not used)
    ' ',                                                 &  ! 14 (not used)
    ' ',                                                 &  ! 15 (not used)
    ' ',                                                 &  ! 16 (not used)
    'Syntax error in NAMELIST input',                    &  ! 17
    'Too many values for NAMELIST variable',             &  ! 18
    'Invalid reference to variable in NAMELIST input',   &  ! 19
    'REWIND error',                                      &  ! 20
    'Duplicate file specifications',                     &  ! 21
    'Input record too long',                             &  ! 22
    'BACKSPACE error',                                   &  ! 23
    'End-of-file during read',                           &  ! 24
    'Record number outside range',                       &  ! 25
    'OPEN or DEFINE FILE required',                      &  ! 26
    'Too many records in I/O statement',                 &  ! 27
    'CLOSE error',                                       &  ! 28
    'File not found',                                    &  ! 29
    'Open failure',                                      &  ! 30
    'Mixed file access modes',                           &  ! 31
    'Invalid logical unit number',                       &  ! 32
    'ENDFILE error',                                     &  ! 33
    'Unit already open',                                 &  ! 34
    'Segmented record format error',                     &  ! 35
    'Attempt to access non-existent record',             &  ! 36
    'Inconsistent record length',                        &  ! 37
    'Error during write',                                &  ! 38
    'Error during read',                                 &  ! 39
    'Recursive I/O operation',                           &  ! 40
    'Insufficient virtual memory',                       &  ! 41
    'No such device',                                    &  ! 42
    'File name specification error',                     &  ! 43
    'Inconsistent record type',                          &  ! 44
    'Keyword value error in OPEN statement',             &  ! 45
    'Inconsistent OPEN/CLOSE parameters',                &  ! 46
    'Write to READONLY file',                            &  ! 47
    'Invalid argument to Fortran Run-Time Library',      &  ! 48
    ' ',                                                 &  ! 49 (not used)
    ' ',                                                 &  ! 50 (not used)
    'Inconsistent file organization',                    &  ! 51
    ' ',                                                 &  ! 52 (not used)
    'No current record',                                 &  ! 53
    ' ',                                                 &  ! 54 (not used)
    'DELETE error',                                      &  ! 55
    ' ',                                                 &  ! 56 (not used)
    'FIND error',                                        &  ! 57
    'Format syntax error at or near xx',                 &  ! 58
    'List-directed I/O syntax error',                    &  ! 59
    'Infinite format loop',                              &  ! 60
    'Format/variable-type mismatch',                     &  ! 61
    'Syntax error in format',                            &  ! 62
    'Output conversion error',                           &  ! 63
    'Input conversion error',                            &  ! 64
    'Floating invalid',                                  &  ! 65
    'Output statement overflows record',                 &  ! 66
    'Input statement requires too much data',            &  ! 67
    'Variable format expression value error',            &  ! 68
    ' ',                                                 &  ! 69 (not used)
    'Integer overflow',                                  &  ! 70
    'Integer divide by zero',                            &  ! 71
    'Floating overflow',                                 &  ! 72
    'Floating divide by zero',                           &  ! 73
    'Floating underflow',                                &  ! 74
    'Floating point exception',                          &  ! 75
    ' ',                                                 &  ! 76 (not used)
    'Subscript out of range',                            &  ! 77
    'Process killed',                                    &  ! 78
    'Process quit' /                                        ! 79
  !
  select case (ier)
  case(-2)
    msg = 'End of record'
    !
  case(-1)
    msg = 'End of file'
    !
  case(1)
    msg = 'Not a Fortran-specific error'
    !
  case(8:79)
    msg = io08(ier)
    !
  case(95)
    msg = 'Floating-point conversion failed'
    !
  case(108)
    msg = 'Cannot stat file'
    !
  case default
    write(msg,'(A,I5)')  'Unknown error code ',ier
    !
  end select
  !
end subroutine ifort_iostat
!
function failed_allocate(rname,array,ier,error)
  use gbl_message
  use gsys_interfaces, except_this=>failed_allocate
  !-------------------------------------------------------------------
  ! @ public
  ! Check allocation status and display a message if error
  !-------------------------------------------------------------------
  logical :: failed_allocate  ! Function value on return
  character(len=*), intent(in)    :: rname  ! Calling routine name
  character(len=*), intent(in)    :: array  ! Name of allocated array
  integer(kind=4),  intent(in)    :: ier    ! Allocation status
  logical,          intent(inout) :: error  ! Logical error flag
  ! Local
  character(len=160) :: mess
  !
  if (ier.ne.0) then
    write(mess,'(a,i0,a)') 'Could not allocate memory for '//array//' (IER = ',ier,')'
    call gsys_message(seve%e,rname,mess)
    error = .true.
  endif
  failed_allocate = error
end function failed_allocate
