!     $Id: modulePakoFocus.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!     Family:   OBSERVING MODES
!     Siblings: moduleFocus.f90
!
!----------------------------------------------------------------------
!     PAKO module for FOCUS
!
Module modulePakoFocus
  !
  Use modulePakoTypes
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoUtilities
  Use modulePakoPlots
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  Use modulePakoSubscanList
  Use modulePakoReceiver
  Use modulePakoBackend
  Use modulePakoSource
  Use modulePakoSwBeam
  Use modulePakoSwWobbler
  Use modulePakoSwTotalPower
  !
  Implicit None
  Save
  Private
  Public :: Focus, saveFocus, startFocus
  !     
  ! *** Variables for Focus ***
  Include 'inc/variables/variablesFocus.inc'
!!!   
Contains
!!!
!!!
  Subroutine FOCUS(programName,line,command,                    &
       &         error)
    !
    ! *** Arguments ***
    Include 'inc/variables/headerForCommandHandler2.inc'
    !
    ! *** standard working variables ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    ! *** special working variables:   ***
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesFocus.inc'
    !
    !D      Write (6,*) " --> moduleFocus --> SR Focus "
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/setDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values ***
    If (.Not.ERROR) Then
       vars(iIn) = vars(iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    Call checkNofParameters(command,                                 &
         &     0, 1,                                                       &
         &     nArguments,                                                 &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    !
    ! *** read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersLengthFocus.inc'
       Include 'inc/options/readOptionsFocus.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/setDefaults.inc'
       Endif
    Endif
    !
    ! *** Read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/parameters/parametersLengthFocus.inc'
       Include 'inc/options/readOptionsFocus.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       !
       errorInconsistent = .False.
       !
       ! TBD:         Include 'inc/options/checkConsistentFocus.inc'
       !
       If (.Not. errorInconsistent) Then
          vars(iTemp) = vars(iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** store from temporary into final variables ***
    If (.Not.ERROR) Then
       vars(iValue)  = vars(iTemp)
    End If
    !
    ! *** display values ***
    !     (Note: this is done indepenently of the Error status)
    Include 'inc/display/commandDisplayFocus.inc'
    !
    ! *** set "selected" observing mode, anaylze  & plot ***
    If (.Not.error) Then
       GV%observingMode = command
       Write (6,*) "        GV%observingMode ->", GV%observingMode(1:len_trim(GV%observingMode)), "<-"        
       focusCommand = line(1:lenc(line))
       Write (6,*) "        focusCommand ->", focusCommand(1:len_trim(focusCommand)), "<-"
       Call analyzeFocus (errorA)
       !D       Call printSegmentList (command,errorA)
       !TBD: Call plotFocus (errorP)
    End If
    !
    Return
  End Subroutine FOCUS
!!!
!!!
  Subroutine analyzeFocus (errorA)
    !
    ! <DOCUMENTATION name="analyzeFocus">
    !
    ! The sequence of focus subscans is determined by 
    ! lengthFocus /nSubscans /otfFocus
    !
    !  lengthFocus     ! total length [mm] of the focus scan 
    !  /nSubscans      ! number of focus subscans
    !  /otfFocus       ! not yet implemented
    !
    !  focus subscan 1 is at offset  0.0
    !  focus subscan 2 is at offset  lengthFocus/2
    !  in case /nSubscans 3:
    !  focus subscan 3 is at offset -lengthFocus/2
    !  in case /nSubscans >3:
    !  focus subscan 3 is at offset  lengthFocus/2
    !  focus subscan 4 is at offset -lengthFocus/2
    !  focus subscan 5 is at offset -lengthFocus/2
    !  focus subscan 6 is at offset  0.0
    !  (etc.)
    !
    ! </DOCUMENTATION> <!-- name="analyzeFocus" -->
    !
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer              :: nScan 
    Character (len=12)   :: aUnit, sUnit
    Integer              :: iSS           = 0     ! counts subcans/segment
    !
    Real    :: swWobblerShift  = 0.0               !   Shift in Azimuth when Wobbler Switching
    !
    errorA = .False.
    !
    ! TBD:  proper scan numbers
    nScan     = 1111
    aUnit     = GV%angleUnitC
    sUnit     = GV%speedUnitC
    !
    swWobblerShift  = 0.0
    iSS  = 0
    !
    !D        Write (6,*) " --> moduleFocus --> SR analyzeFocus "        
    !D        Write (6,*) "          nSubscans:  ", vars(iValue)%nSubscans
    !
    If (GV%switchingMode .Eq. "SWWOBBLER") Then   
       swWobblerShift = -0.5*Abs(GV%wOffset(2)-GV%wOffset(1))  
       !D           Write (6,*) "      swWobblerShift = ", swWobblerShift
    End If
    !
    ! TBD: calibration subscans
    !
    ! ***
    If (vars(iValue)%nSubscans .Ge. 1) Then
       !
       iSS = iSS+1
       segList(iSS)            =  segDefault                    ! 
       segList(iSS)%newSubscan =  .True.
       segList(iSS)%scanNumber =  nScan
       segList(iSS)%ssNumber   =  iSS
       segList(iSS)%segNumber  =  1
       segList(iSS)%ssType     =  ss%onFocus
       segList(iSS)%segType    =  seg%track
       segList(iSS)%angleUnit  =  aUnit
       segList(iSS)%speedUnit  =  sUnit
       segList(iSS)%flagOn     =  .True.
       segList(iSS)%flagRef    =  .False.
       segList(iSS)%pStart     =  xyPointType(0.0,0.0)
       segList(iSS)%pEnd       =  segList(iSS)%pStart
       ! TBD: system from source command
       segList(iSS)%systemName =  offsetSystemChoices(iHORIZONTRUE)
       segList(iSS)%altOption  =  'tSegment'
       segList(iSS)%speedStart =  0.0
       segList(iSS)%speedEnd   =  0.0
       segList(iSS)%tSegment   =  vars(iValue)%tSubscan
       ! TBD:        segList(iSS)%tRecord    =  
       segList(iSS)%focusOffset = 0.0
       segList(iSS)%directionFocus = vars(iValue)%directionFocus
       !
       If (GV%switchingMode .Eq. "SWWOBBLER") Then   
          segList(iSS)%pStart%x  = segList(iSS)%pStart%x +swWobblerShift  
          segList(iSS)%pEnd%x    = segList(iSS)%pEnd%x   +swWobblerShift  
       End If
       !
       Write (messageText,*)  "  subscan #:   ", iSS, " ",             &
            &           segList(iSS)%ssType,                                    &
            &           segList(iSS)%directionFocus, segList(iSS)%focusOffset
       Call pakoMessage(priorityI,severityI,"Focus  Analyze",messageText)
       !
    End If
    !
    If (vars(iValue)%nSubscans .Ge. 2) Then
       !
       iSS = iSS+1
       segList(iSS)            =  segList(iSS-1)
       segList(iSS)%focusOffset = vars(iValue)%lengthFocus/2.0
       !
       Write (messageText,*)  "  subscan #:   ", iSS, " ",            &
            &           segList(iSS)%ssType,                                    &
            &           segList(iSS)%directionFocus, segList(iSS)%focusOffset
       Call pakoMessage(priorityI,severityI,"Focus  Analyze",messageText)
       !
    End If
    !
    If (vars(iValue)%nSubscans .Eq. 3) Then
       !
       iSS = iSS+1
       segList(iSS)            =  segList(iSS-1)
       segList(iSS)%focusOffset = -vars(iValue)%lengthFocus/2.0
       !
       Write (messageText,*)  "  subscan #:   ", iSS, " ",            &
            &           segList(iSS)%ssType,                                    &
            &           segList(iSS)%directionFocus, segList(iSS)%focusOffset
       Call pakoMessage(priorityI,severityI,"Focus  Analyze",messageText)
       !
    End If
    !
    If (vars(iValue)%nSubscans .Gt. 3) Then
       !
       Do ii = 3, vars(iValue)%nSubscans, 1
          !
          iSS = iSS+1
          segList(iSS)             =  segList(iSS-1)
          !
          Select Case (Mod(ii,6))
             !
          Case (0)
             segList(iSS)%focusOffset = 0.0
          Case (1)
             segList(iSS)%focusOffset = 0.0
          Case (2)
             segList(iSS)%focusOffset = vars(iValue)%lengthFocus/2.0
          Case (3)
             segList(iSS)%focusOffset = vars(iValue)%lengthFocus/2.0
          Case (4)
             segList(iSS)%focusOffset = -vars(iValue)%lengthFocus/2.0
          Case (5)
             segList(iSS)%focusOffset = -vars(iValue)%lengthFocus/2.0
          Case Default
             !
          End Select
          !
          Write (messageText,*)  "  subscan #:   ", iSS,  " ",           &
               &           segList(iSS)%ssType,                                    &
               &           segList(iSS)%directionFocus, segList(iSS)%focusOffset
          Call pakoMessage(priorityI,severityI,"Focus  Analyze",messageText)
          !
       End Do
       !
    End If
    !
    ! ***
    nSegments = iSS
    !
    Write (messageText,*)  "   number of Subscans/Segments: ", nSegments
    Call pakoMessage(priorityI,severityI,"Focus "//" Analyze",messageText)
    !
    Return 
    !
  End Subroutine analyzeFocus
!!!
!!!
  Subroutine plotFocus (errorP)
    !
    !**   Variables  for Plots   ***
    Include 'inc/variables/headerForPlotMethods.inc'
    !
    !**   standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    errorP = .False.
    !
    Call configurePlots
    !
    ! TBD: general plot of segList
    !
    Return
  End Subroutine plotFocus
!!!
!!!
  Subroutine saveFocus(programName,LINE,commandToSave,              &
       &         iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    contC = contNN
    !
    Include 'inc/commands/saveCommand.inc'
    !
!!$      doContinue = .True.
    !
    contC = contCC
    !
    Include 'inc/parameters/saveLengthFocus.inc'
    !
    !TBD:      Include 'inc/options/saveCalibrate.inc'
    Include 'inc/options/saveDirectionFocus.inc'
    Include 'inc/options/saveFeBe.inc'
    Include 'inc/options/saveNsubscans.inc'
    contC = contCN
    Include 'inc/options/saveTsubscan.inc'
    !TBD:      Include 'inc/options/saveOtfFocus.inc'
    !
    contC = contCN
    !
    !TBD:      Include 'inc/options/saveUpdate.inc'

    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveFocus
!!!
!!!
  Subroutine startFocus(programName,LINE,commandToSave,             &
       &         iUnit, ERROR)
    !
    ! *** Variables ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Integer            :: ii
    Character (len=24) :: valueC
    Character (len=48) :: valueComment
    Logical            :: errorXML
    ! 
    !D      Write (6,*) "   --> startFocus   "
    !
    Call pakoXMLsetOutputUnit(iunit=iunit)
    Call pakoXMLsetIndent(iIndent=2)
!!$   Call pakoXMLsetLevel(1)
    !
    Include 'inc/startXML/generalHead.inc'
    !
    Call writeXMLset(programName,LINE,commandToSave,                   &
         &         iUnit, ERROR)
    !
    Call pakoXMLwriteStartElement("RESOURCE","pakoScript",             &
         &                         comment="save from pako",                 &
         &                         error=errorXML)
    Call pakoXMLwriteStartElement("DESCRIPTION",                       &
         &                         doCdata=.True.,                           &
         &                         error=errorXML)
    !
!!$    Call pakoSaveSet(programName,LINE,commandToSave,                  &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveReceiver(programName,LINE,commandToSave,                 &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveBackend(programName,LINE,commandToSave,                  &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveSwitching(programName,LINE,commandToSave,                &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveSource(programName,LINE,commandToSave,                   &
!!$         &         iUnit, ERROR)                                 
!!$    Call saveFocus(programName,LINE,commandToSave,                   &
!!$         &         iUnit, ERROR)                                 
    !                                                                       
    Call pakoXMLwriteEndElement("DESCRIPTION",                        &
         &      error=errorXML)                                             
    Call pakoXMLwriteEndElement("RESOURCE", "pakoScript",             &
         &      error=errorXML)
    !
    Call writeXMLreceiver(programName,LINE,commandToSave,             &
         &         iUnit, ERROR)
    !
    Call writeXMLbackend(programName,LINE,commandToSave,              &
         &         iUnit, ERROR)
    !
    Include 'inc/startXML/switchingMode.inc'
    !
    Call writeXMLsource(programName,LINE,commandToSave,              &
         &         iUnit, ERROR)
    !
    Include 'inc/startXML/generalScanHead.inc'
    !
    Include 'inc/startXML/focusSubscansXML.inc'
    !   
    Include 'inc/startXML/generalTail.inc'
    !
    Return
  End Subroutine startFocus
!!!
!!!
End Module modulePakoFocus





