!
!     $Id: modulePakoCalibrate.f90,v 1.1 2005/06/22 14:46:29 ungerech Exp $
!     
!----------------------------------------------------------------------
!     PAKO module for CALIBRATE
!
Module modulePakoCalibrate
  !
  Use modulePakoMessages
  Use modulePakoGlobalParameters
  Use modulePakoLimits
  Use modulePakoXML
  Use modulePakoUtilities
  Use modulePakoPlots
  Use modulePakoDisplayText
  Use modulePakoGlobalVariables
  Use modulePakoSubscanList
  Use modulePakoReceiver
  Use modulePakoBackend
  Use modulePakoSource
  Use modulePakoSwBeam
  Use modulePakoSwWobbler
  Use modulePakoSwTotalPower

  !
  Implicit None
  Save
  Private
  Public :: calibrate, saveCalibrate, startCalibrate
  !     
  ! *** Variables for Calibrate ***
  Include 'inc/variables/variablesCalibrate.inc'
!!!   
Contains
!!!
!!!
  Subroutine CALIBRATE(programName,line,command,                    &
       &        error)
    !
    ! *** Arguments ***
    Include 'inc/variables/headerForCommandHandler2.inc'
    !
    ! *** standard working variables ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    ! *** special working variables:   ***
    Integer    ::   nSubscans
    !
    !     TBD: the following shall be replaced by a SR reading from XML:
    Include 'inc/ranges/rangesCalibrate.inc'
    !
    !D      write (6,*) '   --> moduleCalibrate: SR calibrate '
    !
    ! *** initialize:   ***
    If (.Not.isInitialized) Then
       Include 'inc/variables/setDefaults.inc'
       isInitialized = .True.
    Endif
    !
    ! *** set In-values = previous Values ***
    If (.Not.ERROR) Then
       vars   (iIn) = vars   (iValue)
    End If
    !
    ! *** check N of Parameters: 0, n --> at  most n allowed  ***
    Call checkNofParameters(command,                                   &
         &     0, 0,                                                         &
         &     nArguments,                                                   &
         &     errorNumber)
    ERROR = ERROR .Or. errorNumber
    !
    ! *** check for alternative Options   ***
!!$      If (.Not. ERROR) Then
!!$         Include 'inc/options/alternative.inc'
!!$      End If
    !
    ! *** read Parameters, Options (to detect errors)            
    !     and check for validity and ranges                      
    If (.Not. ERROR) Then
       Include 'inc/options/readOptionsCalibrate.inc'
    End If
    !
    ! *** set defaults   ***
    If (.Not. ERROR) Then
       option = 'DEFAULTS'
       Call indexCommmandOption                                      &
            &        (command,option,commandFull,optionFull,                  &
            &        commandIndex,optionIndex,iCommand,iOption,               &
            &        errorNotFound,errorNotUnique)
       setDefaults = SIC_PRESENT(iOption,0)
       If (setDefaults) Then
          Include 'inc/variables/setDefaults.inc'
       Endif
    Endif
    !
    ! *** Read Parameters, Options (again, after defaults!)   ***
    ! *** and check for validity and ranges                   ***
    If (.Not. ERROR) Then
       Include 'inc/options/readOptionsCalibrate.inc'
    End If
    !
    ! *** check consistency and                           ***
    ! *** store into temporary (intermediate) variables   ***
    If (.Not.ERROR) Then
       !
       errorInconsistent = .False.
       !
       Include 'inc/options/checkConsistentCalibrate.inc'
       !
       If (.Not. errorInconsistent) Then
          vars   (iTemp) = vars   (iIn)
       End If
       !
    End If
    !
    ERROR = ERROR .Or. errorInconsistent
    !
    ! *** conclude alternative options   ***
!!$      If (.Not.error) Then
!!$         Include 'inc/options/alternativeEnd.inc'
!!$      End If
    !
    ! *** store from temporary into final variables ***
    If (.Not.ERROR) Then
       vars   (iValue) = vars   (iTemp)
    End If
    !
    ! *** display values ***
    !     (Note: this is done independantly of the Error status)
    Include 'inc/display/commandDisplayCalibrate.inc'
    !
    ! *** set "selected" observing mode & plot ***
    If (.Not.error) Then
       GV%observingMode = command
       !D       Write (6,*) "        GV%observingMode ->", GV%observingMode(1:Len_trim(GV%observingMode)), "<-"        
       calibrateCommand = line(1:lenc(line))
       !D       Write (6,*) "        calibrateCommand ->", calibrateCommand(1:Len_trim(calibrateCommand)), "<-"
       Call analyzeCalibrate (errorA)
       Call listSegmentList (errorA)
       Call plotCalibrate (errorP)
    End If
    !
    Return
  End Subroutine CALIBRATE
!!!
!!!
  Subroutine analyzeCalibrate (errorA)

    Include 'inc/variables/standardWorkingVariables.inc'
    !
    Integer              :: nSubscans
    Character (len=12)   :: aUnit, sUnit
    !
    aUnit     = GV%angleUnitC
    sUnit     = GV%speedUnitC
    !
    errorA = .False.
    !
    !D        Write (6,*) "   --> analyzeCalibrate   "
    !
    segList(:) = segDefault
    !
    Call countSubscans(value=0)
    Call countSegments(value=0)
    !
    If (vars(iValue)%doSky) Then
       !
       Call countSubscans(ii)
       Call countSegments(jj)
       segList(ii)%newSubscan = .True.
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  jj
       segList(ii)%ssType     =  ss%cs
       segList(ii)%segType    =  seg%track
       segList(ii)%angleUnit  =  aUnit
       segList(ii)%speedUnit  =  sUnit
       segList(ii)%flagOn     =  .True.
       segList(ii)%flagRef    =  .False.
       segList(ii)%pStart%x   =  vars(iValue)%xOffsetRC
       segList(ii)%pStart%y   =  vars(iValue)%yOffsetRC
       segList(ii)%systemName =  vars(iValue)%systemName
       segList(ii)%tSegment   =  vars(iValue)%tCalibrate
       segList(ii)%tRecord    =  1.0
       !
    End If
    !
    If (vars(iValue)%doAmbient) Then
       !
       Call countSubscans(ii)
       Call countSegments(jj)
       segList(ii)%newSubscan = .True.
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  jj
       segList(ii)%ssType     =  ss%ca
       segList(ii)%segType    =  seg%track
       segList(ii)%angleUnit  =  aUnit
       segList(ii)%speedUnit  =  sUnit
       segList(ii)%flagOn     =  .True.
       segList(ii)%flagRef    =  .False.
       segList(ii)%pStart%x   =  vars(iValue)%xOffsetRC
       segList(ii)%pStart%y   =  vars(iValue)%yOffsetRC
       segList(ii)%systemName =  vars(iValue)%systemName
       segList(ii)%tSegment   =  vars(iValue)%tCalibrate
       segList(ii)%tRecord    =  1.0
       !
    End If
    !
    If (vars(iValue)%doCold) Then
       !
       Call countSubscans(ii)
       Call countSegments(jj)
       segList(ii)%newSubscan = .True.
       segList(ii)%ssNumber   =  ii
       segList(ii)%segNumber  =  jj
       segList(ii)%ssType     =  ss%cc
       segList(ii)%segType    =  seg%track
       segList(ii)%angleUnit  =  aUnit
       segList(ii)%speedUnit  =  sUnit
       segList(ii)%flagOn     =  .True.
       segList(ii)%flagRef    =  .False.
       segList(ii)%pStart%x   =  vars(iValue)%xOffsetRC
       segList(ii)%pStart%y   =  vars(iValue)%yOffsetRC
       segList(ii)%systemName =  vars(iValue)%systemName
       segList(ii)%tSegment   =  vars(iValue)%tCalibrate
       segList(ii)%tRecord    =  1.0
       !
    End If
    !
    Call getCountSegments(nSegments)
    !
    Return 
    !
  End Subroutine analyzeCalibrate
!!!
!!!
  Subroutine plotCalibrate (errorP)
    !
    !**   Variables  for Plots   ***
    Include 'inc/variables/headerForPlotMethods.inc'
    !
    !**   standard working variables   ***
    Include 'inc/variables/standardWorkingVariables.inc'
    !
    errorP = .False.
    !
    Call configurePlots
    !
    Call plotCalSky(vars(iValue)%xOffsetRC, vars(iValue)%yOffsetRC,  &
         &                  errorP)
    !
    Return
  End Subroutine plotCalibrate
!!!
!!!
  Subroutine saveCalibrate(programName,LINE,commandToSave,           &
       &         iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Integer   ::   length
    !
    contC = contNN
    !
    Include 'inc/commands/saveCommand.inc'
    !
    contC = contCC
    !
    Include 'inc/options/saveAmbient.inc'
    Include 'inc/options/saveCold.inc'
!!$        include 'inc/options/saveFast.inc'
!!$        include 'inc/options/saveNull.inc'
    Include 'inc/options/saveSky.inc'
    Include 'inc/options/saveSystem.inc'
    !
    contC = contCN
    !
    Include 'inc/options/saveTcalibrate.inc'
!!$        include 'inc/options/saveTest.inc'
!!$        include 'inc/options/saveVariable.inc'
    !
    Write (iUnit,*) "!"
    !
    Return
  End Subroutine saveCalibrate
!!!
!!!
  Subroutine startCalibrate(programName,LINE,commandToSave,           &
       &         iUnit, ERROR)
    !
    ! *** Variables   ***
    Include 'inc/variables/headerForSaveMethods.inc'
    !
    Integer            :: ii
    Character (len=24) :: valueC
    Logical            :: errorXML
    ! 
    Call pakoXMLsetOutputUnit(iunit=iunit)
    Call pakoXMLsetIndent(iIndent=2)
!!$   Call pakoXMLsetLevel(1)
    !
    Include 'inc/startXML/generalHead.inc'
    !
    Call pakoXMLwriteStartElement("RESOURCE","pakoScript",             &
         &                         comment="save from pako",                 &
         &                         error=errorXML)
    Call pakoXMLwriteStartElement("DESCRIPTION",                       &
         &                         doCdata=.True.,                           &
         &                         error=errorXML)
    !
!!$    Call saveReceiver(programName,LINE,commandToSave,                  &
!!$         &         iUnit, ERROR)
!!$    Call saveBackend(programName,LINE,commandToSave,                   &
!!$         &         iUnit, ERROR)
!!$    Call saveSwitching(programName,LINE,commandToSave,                 &
!!$         &         iUnit, ERROR)
!!$    Call saveSource(programName,LINE,commandToSave,                    &
!!$         &         iUnit, ERROR)
!!$    Call saveCalibrate(programName,LINE,commandToSave,                 &
!!$         &         iUnit, ERROR)
    !
    Call pakoXMLwriteEndElement("DESCRIPTION",                         &
         &                         doCdata=.True.,                           &
         &                         error=errorXML)
    Call pakoXMLwriteEndElement  ("RESOURCE","pakoScript",             &
         &                         space="after",                            &
         &                         error=errorXML)
    !
    Call writeXMLreceiver(programName,LINE,commandToSave,            &
         &         iUnit, ERROR)
    !
    Call writeXMLbackend(programName,LINE,commandToSave,             &
         &         iUnit, ERROR)
    !
    Include 'inc/startXML/switchingMode.inc'
    !
    Call writeXMLsource(programName,LINE,commandToSave,              &
         &         iUnit, ERROR)
    !
    Include 'inc/startXML/generalScanHead.inc'
    !
    Call writeXMLsubscanList(programName,LINE,commandToSave,         &
         &         iUnit, ERROR)
    !   
    Include 'inc/startXML/generalTail.inc'
    !
    Return
  End Subroutine startCalibrate
!!!
!!!
End Module modulePakoCalibrate





