!
! $Id: parametersBackend.inc,v 1.1 2005/03/23 14:25:51 pety Exp $
!
!D Write (6,*) "      --> parametersBackend.inc   "
!
ERROR     = .False.
errorL    = .False.
errorC    = .False.
errorR    = .False.
!
! *** check for option RECEIVER
!
OPTION = 'RECEIVER'
!
Call indexCommmandOption                                           &
     &     (command,option,commandFull,optionFull,                 &
     &      commandIndex,optionIndex,iCommand,iOption,             &
     &      errorNotFound,errorNotUnique)
!
doReceiver = SIC_PRESENT(iOption ,0) 
!
! *** check for options CLEAR, CONNECT, OR DISCONNECT
!
OPTION = 'CLEAR'
!
Call indexCommmandOption                                           &
     &     (command,option,commandFull,optionFull,                 &
     &      commandIndex,optionIndex,iCommand,iOption,             &
     &      errorNotFound,errorNotUnique)
!
OPTION = 'CONNECT'
!
Call indexCommmandOption                                           &
     &     (command,option,commandFull,optionFull,                 &
     &      commandIndex,optionIndex,iCommand,iOption2,            &
     &      errorNotFound,errorNotUnique)
!
OPTION = 'DISCONNECT'
!
Call indexCommmandOption                                           &
     &     (command,option,commandFull,optionFull,                 &
     &      commandIndex,optionIndex,iCommand,iOption3,            &
     &      errorNotFound,errorNotUnique)
!
doCCD =    SIC_PRESENT(iOption ,0)                                 &
     & .Or.SIC_PRESENT(iOption2,0)                                 &
     & .Or.SIC_PRESENT(iOption3,0)
!
!D Write (6,*) "      doReceiver: ", doReceiver
!D Write (6,*) "      doCCD:      ", doCCD
!
!!$disconnectAllBackends      =  .False.
!!$connectAllBackends         =  .False.
!!$disconnectAllParts         =  .False.
!!$connectAllParts            =  .False.
!!$!
!!$If (SIC_NARG(0).Eq.0 .And.                                            &
!!$     &   .Not. (SIC_PRESENT(1,0).Or.SIC_PRESENT(2,0).Or.              &
!!$     &          SIC_PRESENT(3,0).Or.SIC_PRESENT(4,0).Or.              &        
!!$     &          SIC_PRESENT(5,0)                                      &
!!$     &         ) ) Then
!!$   connectAllBackends         =  .True.
!!$End If
!
iBack           = GPnoneI
backendSelected = GPnone
iPart           = GPnoneI
!
! *** BACKEND NAME
!
iOption   = 0
iArgument = 1
!
If (SIC_PRESENT(iOption,iArgument)) Then
   Call SIC_CH(LINE,iOption,iArgument,                                &
        &        cInput,lengthInput,.True.,errorC)
Else
   errorL = .True.
   messageText =                                                      &
        &        "no backend name specified"
   Call pakoMessage(priorityW,severityW,command,messageText)
End If
!
If (errorC) Then
   messageText =                                                      &
        &     "backend name invalid"
   Call pakoMessage(priorityE,severityE,command,messageText)
End If
!
ERROR = ERROR .Or. errorC
!
! *** Check against valid backend names
!
If (.Not. ERROR) Then
   If (SIC_PRESENT(iOption,iArgument)) Then
      Call pakoUmatchKey (                                            &
           &              keys=backendChoices,                        &
           &              key=cInput,                                 &
           &              command='BACKEND',                          &
           &              howto='Start Upper',                        &
           &              iMatch=iMatch,                              &
           &              nMatch=nMatch,                              &
           &              error=errorC,                               &
           &              errorCode=errorCode                         &
           &             )
      !
      ERROR = ERROR .Or. errorC
      !
      If (.Not. ERROR) Then
         iBack                        = iMatch
         backendSelected              = backendChoices(iMatch)
         vars(iIn,iBack)%isConnected  = .True.
         vars(iIn,iBack)%wasConnected = .True.
         vars(iIn,iBack)%name         = backendChoices(iMatch)
         vars(iIn,iBack)%percentage   = vars(iDefault,iBack)%percentage
      End If
      !
   End If
End If
!
!D Write (6,*) "   --> parametersBackend: iBack : ", iBack
!
! *** PART NUMBER
!
If (.Not. ERROR) Then
   errorI    = .False.
   errorL    = .False.
   iOption   = 0
   iArgument = 2
   !
   iInput = GPnoneI
   !
   If (SIC_PRESENT(iOption,iArgument)) Then
      Call SIC_I4(LINE,iOption,iArgument,                             &
           &        iInput,lengthInput,.True.,errorI)
      If (.Not. errorI) Call checkI4(command,iInput,                  &
           &           vars(:,iBack)%nPart,                           &
           &           errorI)
   Else
      messageText =                                                   &
           &        "no backend part specified"
      Call pakoMessage(priorityW,severityW,command,messageText)
   End If
   !
   ERROR     = ERROR .Or. errorI
   !
   If (.Not.ERROR) Then
      iPart = iInput
   End If
   !
End If  !! .not.error
!
!D Write (6,*) "   --> parametersBackend: iPart : ", iPart
!
! *** re-connect without explicit option
!
If (.Not. doReceiver .And. SIC_NARG(0).Le.2 .And. iBack.Ge.1) Then
!
   doCCD = .True.
   Include 'inc/options/doConnectBE.inc'
!
End If
!
If (.Not.doCCD) Then
   !
   ! *** implied values
   !
   If (iBack .Eq. iContinuum .And. SIC_NARG(0) .Eq. 2) Then
      !
      shortsyntax = .True.
      !
      vars(iIn,iBack)%resolution  =  vars(iDefault,iBack)%resolution 
      vars(iIn,iBack)%bandWidth   =  vars(iDefault,iBack)%bandWidth 
      vars(iIn,iBack)%fShift      =  vars(iDefault,iBack)%fShift 
      messageText =                                                      &
           &  backendChoices(iContinuum)//                               &
           &  " implies resolution bandwidth fShift"
      Call pakoMessage(priorityI,severityI,command,messageText)
      !
   End If
   !
   If (iBack .Eq. iFB4MHz .And. SIC_NARG(0) .Eq. 2) Then
      !
      shortsyntax = .True.
      !
      vars(iIn,iBack)%resolution  =  vars(iDefault,iBack)%resolution 
      vars(iIn,iBack)%bandWidth   =  vars(iDefault,iBack)%bandWidth 
      messageText =                                                      &
           &  backendChoices(iFB4Mhz)//                                  &
           &  " implies resolution bandwidth "
      Call pakoMessage(priorityI,severityI,command,messageText)
      !
   End If
   !
   If (iBack .Eq. iFB1MHz .And. SIC_NARG(0) .Le. 3) Then
      !
      shortsyntax = .True.
      !
      vars(iIn,iBack)%resolution  =  vars(iDefault,iBack)%resolution 
      messageText =                                                      &
           &  backendChoices(iFB1Mhz)//                                  &
           &  " implies resolution "
      Call pakoMessage(priorityI,severityI,command,messageText)
      !
   End If
   !
   If (iBack .Eq. iFB100kHz .And. SIC_NARG(0) .Le. 3) Then
      !
      shortsyntax = .True.
      !
      vars(iIn,iBack)%resolution  =  vars(iDefault,iBack)%resolution 
      messageText =                                                      &
           &  backendChoices(iFB100kHz)//                                &
           &  " implies resolution "
      Call pakoMessage(priorityI,severityI,command,messageText)
      !
   End If
   !
   If (iBack .Eq. iWILMA .And. SIC_NARG(0) .Eq. 2) Then
      !
      shortsyntax = .True.
      !
      vars(iIn,iBack)%resolution  =  vars(iDefault,iBack)%resolution 
      vars(iIn,iBack)%bandWidth   =  vars(iDefault,iBack)%bandWidth 
      messageText =                                                      &
           &  backendChoices(iWILMA)//                                   &
           &  " implies resolution bandwidth "
      Call pakoMessage(priorityI,severityI,command,messageText)
      !
   End If
   !
   ! *** check minimum number of parameters for full syntax
   !
   If (.Not.doCCD .And. .Not.shortSyntax .And. SIC_NARG(0) .Lt. 4) Then
      !
      messageText =                                                      &
           &  " needs parameters: name nPart resol. bandw. [fShift] "
      Call pakoMessage(priorityE,severityE,command,messageText)   
      !
      ERROR = .True.
      !
   End If
   !
   ! *** RESOLUTION
   !
   If (.Not.ERROR .And. .Not.shortSyntax) Then
      !
      errorR    = .False.
      errorL    = .False.
      iOption   = 0
      iArgument = 3
      !
      If (SIC_PRESENT(iOption,iArgument)) Then
         Call SIC_R4(LINE,iOption,iArgument,                             &
              &        rInput,.True.,errorR)
         If (.Not. errorR) Call checkR4(command,rInput,                  &
              &           vars(:,iBack)%resolution,                      &
              &           errorR)
      Else
         errorL = .True.
         messageText =                                                   &
              &        "no resolution specified"
         Call pakoMessage(priorityW,severityW,command,messageText)
      End If
      !
      ERROR = ERROR .Or. errorR
      !
   End If  !! .not.error
   !
   ! *** BANDWIDTH
   !
   If (.Not.ERROR) Then
      !
      If (.Not.shortSyntax                                               &
           &  .Or. (iBack.Eq.iFB1MHz   .And. SIC_NARG(0).Eq.3)           &
           &  .Or. (iBack.Eq.iFB100kHz .And. SIC_NARG(0).Le.3) ) Then
         !
         errorR    = .False.
         errorL    = .False.
         iOption   = 0
         iArgument = 4
         !
         If (      (iBack.Eq.iFB1MHz   .And. SIC_NARG(0).Eq.3)           &
              &  .Or. (iBack.Eq.iFB100kHz .And. SIC_NARG(0).Le.3) ) Then
            iArgument = 3
         End If
         !
         If (SIC_PRESENT(iOption,iArgument)) Then
            Call SIC_R4(LINE,iOption,iArgument,                          &
                 &        rInput,.True.,errorR)
            If (.Not. errorR) Call checkR4(command,rInput,               &
                 &           vars(:,iBack)%bandwidth,                    &
                 &           errorR)
         Else
            errorL = .True.
            messageText =                                                &
                 &        "no bandwidth specified"
            Call pakoMessage(priorityW,severityW,command,messageText)
         End If
         !
         ERROR = ERROR .Or. errorR
         !
      End If   !!   .not.shortSyntax .Or.
      !
   End If  !! .not.error
   !
   ! *** FREQUENCY SHIFT
   !
   If (.Not.ERROR .And. .Not.shortSyntax) Then
      !
      errorR    = .False.
      errorL    = .False.
      iOption   = 0
      iArgument = 5
      !
      If (SIC_PRESENT(iOption,iArgument)) Then
         Call SIC_R4(LINE,iOption,iArgument,                             &
              &        rInput,.True.,errorR)
         If (.Not. errorR) Call checkR4(command,rInput,                  &
              &           vars(:,iBack)%fShift,                          &
              &           errorR)
      Else
         errorL = .True.
         messageText =                                                   &
              &        "no frequency shift specified"
         Call pakoMessage(priorityW,severityW,command,messageText)
      End If
      !
      ERROR = ERROR .Or. errorR
      !
   End If  !! .not.error
   !
   ! *** RECEIVER
   !
   If (.Not.ERROR .And. .Not.shortSyntax) Then
      !
      iOption   = 0
      iArgument = 6
      !
      If (SIC_PRESENT(iOption,iArgument)) Then
         Call SIC_CH(LINE,iOption,iArgument,                             &
              &        cInput,lengthInput,.True.,errorC)
      Else
         errorL = .True.
         messageText =                                                   &
              &        "no receiver name specified as parameter"
         Call pakoMessage(priorityI,severityI,command,messageText)
      End If
      !
!D       Write (6,*) "      cInput   ", cInput
      !
      ! *** Check against valid receiver names
      !
      If (SIC_PRESENT(iOption,iArgument) .And. .Not. ERROR) Then
         !
         Call pakoUmatchKey (                                            &
              &              keys=receiverChoices,                       &
              &              key=cInput,                                 &
              &              command='BACKEND',                          &
              &              howto='Start Upper',                        &
              &              iMatch=iMatch,                              &
              &              nMatch=nMatch,                              &
              &              error=errorC,                               &
              &              errorCode=errorCode                         &
              &             )
         !
         ERROR = ERROR .Or. errorC
         !
         If (.Not. ERROR) Then
            vars(iIn,iBack)%receiverName = receiverChoices(iMatch)
         End If
         !
      End If
      !
   End If  !! .not.error
   !
   ! *** RECEIVER 2
   !
   If (.Not.ERROR .And. .Not.shortSyntax) Then
      !
      iOption   = 0
      iArgument = 7
      !
      If (SIC_PRESENT(iOption,iArgument)) Then
         Call SIC_CH(LINE,iOption,iArgument,                             &
              &        cInput,lengthInput,.True.,errorC)
      Else
         vars(iIn,iBack)%receiverName2 = GPnone
         messageText =                                                   &
              &        "no 2nd receiver name specified as parameter"
         Call pakoMessage(priorityI,severityI,command,messageText)
      End If
      !
!D       Write (6,*) "      cInput   ", cInput
      !
      ! *** Check against valid receiver names
      !
      If (SIC_PRESENT(iOption,iArgument) .And. .Not. ERROR) Then
         !
         Call pakoUmatchKey (                                            &
              &              keys=receiverChoices,                       &
              &              key=cInput,                                 &
              &              command='BACKEND',                          &
              &              howto='Start Upper',                        &
              &              iMatch=iMatch,                              &
              &              nMatch=nMatch,                              &
              &              error=errorC,                               &
              &              errorCode=errorCode                         &
              &             )
         !
         ERROR = ERROR .Or. errorC
         !
         If (.Not. ERROR) Then
            vars(iIn,iBack)%receiverName2 = receiverChoices(iMatch)
         End If
         !
      End If
      !
   End If  !! .not.error
   !
End If  !! .not. doCCD
!
