*DECK D1MERG
      SUBROUTINE D1MERG (TCOS, I1, M1, I2, M2, I3)
C***BEGIN PROLOGUE  D1MERG
C***SUBSIDIARY
C***PURPOSE  Merge two strings of ascending double precision numbers.
C***LIBRARY   SLATEC
C***TYPE      DOUBLE PRECISION (S1MERG-S, D1MERG-D, CMERGE-C, I1MERG-I)
C***AUTHOR  Boland, W. Robert, (LANL)
C           Clemens, Reginald, (PLK)
C***DESCRIPTION
C
C   This subroutine merges two ascending strings of numbers in the
C   array TCOS.  The first string is of length M1 and starts at
C   TCOS(I1+1).  The second string is of length M2 and starts at
C   TCOS(I2+1).  The merged string goes into TCOS(I3+1).
C
C   This routine is currently unused, but was added to complete
C   the set of routines S1MERG and C1MERG (both of which are used).
C
C***ROUTINES CALLED  DCOPY
C***REVISION HISTORY  (YYMMDD)
C   910819  DATE WRITTEN
C***END PROLOGUE  D1MERG
      INTEGER I1, I2, I3, M1, M2
      DOUBLE PRECISION TCOS(*)
C
      INTEGER J1, J2, J3
C
C***FIRST EXECUTABLE STATEMENT  D1MERG
      IF (M1.EQ.0 .AND. M2.EQ.0) RETURN
C
      IF (M1.EQ.0 .AND. M2.NE.0) THEN
         CALL DCOPY (M2, TCOS(I2+1), 1, TCOS(I3+1), 1)
         RETURN
      ENDIF
C
      IF (M1.NE.0 .AND. M2.EQ.0) THEN
         CALL DCOPY (M1, TCOS(I1+1), 1, TCOS(I3+1), 1)
         RETURN
      ENDIF
C
      J1 = 1
      J2 = 1
      J3 = 1
C
   10 IF (TCOS(I1+J1) .LE. TCOS(I2+J2)) THEN
         TCOS(I3+J3) = TCOS(I1+J1)
         J1 = J1+1
         IF (J1 .GT. M1) THEN
            CALL DCOPY (M2-J2+1, TCOS(I2+J2), 1, TCOS(I3+J3+1), 1)
            RETURN
         ENDIF
      ELSE
         TCOS(I3+J3) = TCOS(I2+J2)
         J2 = J2+1
         IF (J2 .GT. M2) THEN
            CALL DCOPY (M1-J1+1, TCOS(I1+J1), 1, TCOS(I3+J3+1), 1)
            RETURN
         ENDIF
      ENDIF
      J3 = J3+1
      GO TO 10
      END
*DECK D1MPYQ
      SUBROUTINE D1MPYQ (M, N, A, LDA, V, W)
C***BEGIN PROLOGUE  D1MPYQ
C***SUBSIDIARY
C***PURPOSE  Subsidiary to DNSQ and DNSQE
C***LIBRARY   SLATEC
C***TYPE      DOUBLE PRECISION (R1MPYQ-S, D1MPYQ-D)
C***AUTHOR  (UNKNOWN)
C***DESCRIPTION
C
C     Given an M by N matrix A, this subroutine computes A*Q where
C     Q is the product of 2*(N - 1) transformations
C
C           GV(N-1)*...*GV(1)*GW(1)*...*GW(N-1)
C
C     and GV(I), GW(I) are Givens rotations in the (I,N) plane which
C     eliminate elements in the I-th and N-th planes, respectively.
C     Q itself is not given, rather the information to recover the
C     GV, GW rotations is supplied.
C
C     The SUBROUTINE statement is
C
C       SUBROUTINE D1MPYQ(M,N,A,LDA,V,W)
C
C     where
C
C       M is a positive integer input variable set to the number
C         of rows of A.
C
C       N IS a positive integer input variable set to the number
C         of columns of A.
C
C       A is an M by N array. On input A must contain the matrix
C         to be postmultiplied by the orthogonal matrix Q
C         described above. On output A*Q has replaced A.
C
C       LDA is a positive integer input variable not less than M
C         which specifies the leading dimension of the array A.
C
C       V is an input array of length N. V(I) must contain the
C         information necessary to recover the Givens rotation GV(I)
C         described above.
C
C       W is an input array of length N. W(I) must contain the
C         information necessary to recover the Givens rotation GW(I)
C         described above.
C
C***SEE ALSO  DNSQ, DNSQE
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   800301  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890831  Modified array declarations.  (WRB)
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900326  Removed duplicate information from DESCRIPTION section.
C           (WRB)
C   900328  Added TYPE section.  (WRB)
C***END PROLOGUE  D1MPYQ
      INTEGER I, J, LDA, M, N, NM1, NMJ
      DOUBLE PRECISION A(LDA,*), COS, ONE, SIN, TEMP, V(*), W(*)
      SAVE ONE
      DATA ONE /1.0D0/
C
C     APPLY THE FIRST SET OF GIVENS ROTATIONS TO A.
C
C***FIRST EXECUTABLE STATEMENT  D1MPYQ
      NM1 = N - 1
      IF (NM1 .LT. 1) GO TO 50
      DO 20 NMJ = 1, NM1
         J = N - NMJ
         IF (ABS(V(J)) .GT. ONE) COS = ONE/V(J)
         IF (ABS(V(J)) .GT. ONE) SIN = SQRT(ONE-COS**2)
         IF (ABS(V(J)) .LE. ONE) SIN = V(J)
         IF (ABS(V(J)) .LE. ONE) COS = SQRT(ONE-SIN**2)
         DO 10 I = 1, M
            TEMP = COS*A(I,J) - SIN*A(I,N)
            A(I,N) = SIN*A(I,J) + COS*A(I,N)
            A(I,J) = TEMP
   10       CONTINUE
   20    CONTINUE
C
C     APPLY THE SECOND SET OF GIVENS ROTATIONS TO A.
C
      DO 40 J = 1, NM1
         IF (ABS(W(J)) .GT. ONE) COS = ONE/W(J)
         IF (ABS(W(J)) .GT. ONE) SIN = SQRT(ONE-COS**2)
         IF (ABS(W(J)) .LE. ONE) SIN = W(J)
         IF (ABS(W(J)) .LE. ONE) COS = SQRT(ONE-SIN**2)
         DO 30 I = 1, M
            TEMP = COS*A(I,J) + SIN*A(I,N)
            A(I,N) = -SIN*A(I,J) + COS*A(I,N)
            A(I,J) = TEMP
   30       CONTINUE
   40    CONTINUE
   50 CONTINUE
      RETURN
C
C     LAST CARD OF SUBROUTINE D1MPYQ.
C
      END
*DECK D1UPDT
      SUBROUTINE D1UPDT (M, N, S, LS, U, V, W, SING)
C***BEGIN PROLOGUE  D1UPDT
C***SUBSIDIARY
C***PURPOSE  Subsidiary to DNSQ and DNSQE
C***LIBRARY   SLATEC
C***TYPE      DOUBLE PRECISION (R1UPDT-S, D1UPDT-D)
C***AUTHOR  (UNKNOWN)
C***DESCRIPTION
C
C     Given an M by N lower trapezoidal matrix S, an M-vector U,
C     and an N-vector V, the problem is to determine an
C     orthogonal matrix Q such that
C
C                   t
C           (S + U*V )*Q
C
C     is again lower trapezoidal.
C
C     This subroutine determines Q as the product of 2*(N - 1)
C     transformations
C
C           GV(N-1)*...*GV(1)*GW(1)*...*GW(N-1)
C
C     where GV(I), GW(I) are Givens rotations in the (I,N) plane
C     which eliminate elements in the I-th and N-th planes,
C     respectively. Q itself is not accumulated, rather the
C     information to recover the GV, GW rotations is returned.
C
C     The SUBROUTINE statement is
C
C       SUBROUTINE D1UPDT(M,N,S,LS,U,V,W,SING)
C
C     where
C
C       M is a positive integer input variable set to the number
C         of rows of S.
C
C       N is a positive integer input variable set to the number
C         of columns of S. N must not exceed M.
C
C       S is an array of length LS. On input S must contain the lower
C         trapezoidal matrix S stored by columns. On output S contains
C         the lower trapezoidal matrix produced as described above.
C
C       LS is a positive integer input variable not less than
C         (N*(2*M-N+1))/2.
C
C       U is an input array of length M which must contain the
C         vector U.
C
C       V is an array of length N. On input V must contain the vector
C         V. On output V(I) contains the information necessary to
C         recover the Givens rotation GV(I) described above.
C
C       W is an output array of length M. W(I) contains information
C         necessary to recover the Givens rotation GW(I) described
C         above.
C
C       SING is a LOGICAL output variable. SING is set TRUE if any
C         of the diagonal elements of the output S are zero. Otherwise
C         SING is set FALSE.
C
C***SEE ALSO  DNSQ, DNSQE
C***ROUTINES CALLED  D1MACH
C***REVISION HISTORY  (YYMMDD)
C   800301  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890831  Modified array declarations.  (WRB)
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900326  Removed duplicate information from DESCRIPTION section.
C           (WRB)
C   900328  Added TYPE section.  (WRB)
C***END PROLOGUE  D1UPDT
      DOUBLE PRECISION D1MACH
      INTEGER I, J, JJ, L, LS, M, N, NM1, NMJ
      DOUBLE PRECISION COS, COTAN, GIANT, ONE, P25, P5, S(*),
     1     SIN, TAN, TAU, TEMP, U(*), V(*), W(*), ZERO
      LOGICAL SING
      SAVE ONE, P5, P25, ZERO
      DATA ONE,P5,P25,ZERO /1.0D0,5.0D-1,2.5D-1,0.0D0/
C
C     GIANT IS THE LARGEST MAGNITUDE.
C
C***FIRST EXECUTABLE STATEMENT  D1UPDT
      GIANT = D1MACH(2)
C
C     INITIALIZE THE DIAGONAL ELEMENT POINTER.
C
      JJ = (N*(2*M - N + 1))/2 - (M - N)
C
C     MOVE THE NONTRIVIAL PART OF THE LAST COLUMN OF S INTO W.
C
      L = JJ
      DO 10 I = N, M
         W(I) = S(L)
         L = L + 1
   10    CONTINUE
C
C     ROTATE THE VECTOR V INTO A MULTIPLE OF THE N-TH UNIT VECTOR
C     IN SUCH A WAY THAT A SPIKE IS INTRODUCED INTO W.
C
      NM1 = N - 1
      IF (NM1 .LT. 1) GO TO 70
      DO 60 NMJ = 1, NM1
         J = N - NMJ
         JJ = JJ - (M - J + 1)
         W(J) = ZERO
         IF (V(J) .EQ. ZERO) GO TO 50
C
C        DETERMINE A GIVENS ROTATION WHICH ELIMINATES THE
C        J-TH ELEMENT OF V.
C
         IF (ABS(V(N)) .GE. ABS(V(J))) GO TO 20
            COTAN = V(N)/V(J)
            SIN = P5/SQRT(P25+P25*COTAN**2)
            COS = SIN*COTAN
            TAU = ONE
            IF (ABS(COS)*GIANT .GT. ONE) TAU = ONE/COS
            GO TO 30
   20    CONTINUE
            TAN = V(J)/V(N)
            COS = P5/SQRT(P25+P25*TAN**2)
            SIN = COS*TAN
            TAU = SIN
   30    CONTINUE
C
C        APPLY THE TRANSFORMATION TO V AND STORE THE INFORMATION
C        NECESSARY TO RECOVER THE GIVENS ROTATION.
C
         V(N) = SIN*V(J) + COS*V(N)
         V(J) = TAU
C
C        APPLY THE TRANSFORMATION TO S AND EXTEND THE SPIKE IN W.
C
         L = JJ
         DO 40 I = J, M
            TEMP = COS*S(L) - SIN*W(I)
            W(I) = SIN*S(L) + COS*W(I)
            S(L) = TEMP
            L = L + 1
   40       CONTINUE
   50    CONTINUE
   60    CONTINUE
   70 CONTINUE
C
C     ADD THE SPIKE FROM THE RANK 1 UPDATE TO W.
C
      DO 80 I = 1, M
         W(I) = W(I) + V(N)*U(I)
   80    CONTINUE
C
C     ELIMINATE THE SPIKE.
C
      SING = .FALSE.
      IF (NM1 .LT. 1) GO TO 140
      DO 130 J = 1, NM1
         IF (W(J) .EQ. ZERO) GO TO 120
C
C        DETERMINE A GIVENS ROTATION WHICH ELIMINATES THE
C        J-TH ELEMENT OF THE SPIKE.
C
         IF (ABS(S(JJ)) .GE. ABS(W(J))) GO TO 90
            COTAN = S(JJ)/W(J)
            SIN = P5/SQRT(P25+P25*COTAN**2)
            COS = SIN*COTAN
            TAU = ONE
            IF (ABS(COS)*GIANT .GT. ONE) TAU = ONE/COS
            GO TO 100
   90    CONTINUE
            TAN = W(J)/S(JJ)
            COS = P5/SQRT(P25+P25*TAN**2)
            SIN = COS*TAN
            TAU = SIN
  100    CONTINUE
C
C        APPLY THE TRANSFORMATION TO S AND REDUCE THE SPIKE IN W.
C
         L = JJ
         DO 110 I = J, M
            TEMP = COS*S(L) + SIN*W(I)
            W(I) = -SIN*S(L) + COS*W(I)
            S(L) = TEMP
            L = L + 1
  110       CONTINUE
C
C        STORE THE INFORMATION NECESSARY TO RECOVER THE
C        GIVENS ROTATION.
C
         W(J) = TAU
  120    CONTINUE
C
C        TEST FOR ZERO DIAGONAL ELEMENTS IN THE OUTPUT S.
C
         IF (S(JJ) .EQ. ZERO) SING = .TRUE.
         JJ = JJ + (M - J + 1)
  130    CONTINUE
  140 CONTINUE
C
C     MOVE W BACK INTO THE LAST COLUMN OF THE OUTPUT S.
C
      L = JJ
      DO 150 I = N, M
         S(L) = W(I)
         L = L + 1
  150    CONTINUE
      IF (S(JJ) .EQ. ZERO) SING = .TRUE.
      RETURN
C
C     LAST CARD OF SUBROUTINE D1UPDT.
C
      END
*DECK D9AIMP
      SUBROUTINE D9AIMP (X, AMPL, THETA)
C***BEGIN PROLOGUE  D9AIMP
C***SUBSIDIARY
C***PURPOSE  Evaluate the Airy modulus and phase.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C10D
C***TYPE      DOUBLE PRECISION (R9AIMP-S, D9AIMP-D)
C***KEYWORDS  AIRY FUNCTION, FNLIB, MODULUS, PHASE, SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Evaluate the Airy modulus and phase for X .LE. -1.0
C
C Series for AM20       on the interval -1.56250E-02 to  0.
C                                        with weighted error   3.12E-32
C                                         log weighted error  31.51
C                               significant figures required  29.24
C                                    decimal places required  32.38
C
C Series for ATH0       on the interval -1.56250E-02 to  0.
C                                        with weighted error   2.75E-32
C                                         log weighted error  31.56
C                               significant figures required  30.17
C                                    decimal places required  32.42
C
C Series for AM21       on the interval -1.25000E-01 to -1.56250E-02
C                                        with weighted error   3.40E-32
C                                         log weighted error  31.47
C                               significant figures required  29.02
C                                    decimal places required  32.36
C
C Series for ATH1       on the interval -1.25000E-01 to -1.56250E-02
C                                        with weighted error   2.94E-32
C                                         log weighted error  31.53
C                               significant figures required  30.08
C                                    decimal places required  32.41
C
C Series for AM22       on the interval -1.00000E+00 to -1.25000E-01
C                                        with weighted error   3.76E-32
C                                         log weighted error  31.42
C                               significant figures required  29.47
C                                    decimal places required  32.36
C
C Series for ATH2       on the interval -1.00000E+00 to -1.25000E-01
C                                        with weighted error   4.97E-32
C                                         log weighted error  31.30
C                               significant figures required  29.79
C                                    decimal places required  32.23
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9AIMP
      DOUBLE PRECISION X, AMPL, THETA, AM20CS(57), ATH0CS(53),
     1  AM21CS(60), ATH1CS(58), AM22CS(74), ATH2CS(72), PI4, SQRTX,
     2  XSML, Z,  D1MACH, DCSEVL
      LOGICAL FIRST
      SAVE AM20CS, ATH0CS, AM21CS, ATH1CS, AM22CS, ATH2CS,
     1 PI4, NAM20, NATH0, NAM21, NATH1, NAM22, NATH2, XSML, FIRST
      DATA AM20CS(  1) / +.1087167490 8656185661 5730588125 D-1        /
      DATA AM20CS(  2) / +.3694892289 8266355509 1728665146 D-3        /
      DATA AM20CS(  3) / +.4406801004 8468956366 7507001327 D-5        /
      DATA AM20CS(  4) / +.1436867623 6191115392 9183952833 D-6        /
      DATA AM20CS(  5) / +.8242755523 9007830867 0628855353 D-8        /
      DATA AM20CS(  6) / +.6844267588 9366160617 3927278180 D-9        /
      DATA AM20CS(  7) / +.7395666972 8273928773 1004740213 D-10       /
      DATA AM20CS(  8) / +.9745956336 9682501763 8702600847 D-11       /
      DATA AM20CS(  9) / +.1500768858 2940577565 0973119497 D-11       /
      DATA AM20CS( 10) / +.2621479102 2152763420 6252854802 D-12       /
      DATA AM20CS( 11) / +.5083541113 7648718035 7278966914 D-13       /
      DATA AM20CS( 12) / +.1076847533 5881144049 2985997070 D-13       /
      DATA AM20CS( 13) / +.2460912866 1843342933 5914062617 D-14       /
      DATA AM20CS( 14) / +.6007863803 5865641843 6110373550 D-15       /
      DATA AM20CS( 15) / +.1554491561 0238807115 0651388384 D-15       /
      DATA AM20CS( 16) / +.4235351250 3557660442 6382780182 D-16       /
      DATA AM20CS( 17) / +.1208621662 8929984015 4401109189 D-16       /
      DATA AM20CS( 18) / +.3596096512 1465824086 1499706423 D-17       /
      DATA AM20CS( 19) / +.1111342183 8639563826 1774604677 D-17       /
      DATA AM20CS( 20) / +.3555595324 3236660989 3680289225 D-18       /
      DATA AM20CS( 21) / +.1174330216 0013930999 8766947387 D-18       /
      DATA AM20CS( 22) / +.3993974546 6107756138 9162200966 D-19       /
      DATA AM20CS( 23) / +.1395766715 2891631042 5606325640 D-19       /
      DATA AM20CS( 24) / +.5002400553 0923604139 3459280716 D-20       /
      DATA AM20CS( 25) / +.1835527609 5813267918 4834866457 D-20       /
      DATA AM20CS( 26) / +.6884909981 7920274319 7790112404 D-21       /
      DATA AM20CS( 27) / +.2636310356 1141701235 9996885105 D-21       /
      DATA AM20CS( 28) / +.1029248902 3733836028 7153563785 D-21       /
      DATA AM20CS( 29) / +.4092469666 7159488548 9762960571 D-22       /
      DATA AM20CS( 30) / +.1655585734 0673465103 9727903828 D-22       /
      DATA AM20CS( 31) / +.6807974670 6303335611 6599685727 D-23       /
      DATA AM20CS( 32) / +.2843265599 3407983241 9751134476 D-23       /
      DATA AM20CS( 33) / +.1205073983 4896525509 7287818819 D-23       /
      DATA AM20CS( 34) / +.5179612432 8750521797 6613610424 D-24       /
      DATA AM20CS( 35) / +.2256226134 2756281630 3268640887 D-24       /
      DATA AM20CS( 36) / +.9954188011 4774516883 2117078246 D-25       /
      DATA AM20CS( 37) / +.4445516963 9734242430 8280582053 D-25       /
      DATA AM20CS( 38) / +.2008651954 6150110142 5916097338 D-25       /
      DATA AM20CS( 39) / +.9177863441 5177516597 3885645402 D-26       /
      DATA AM20CS( 40) / +.4238729581 0558924066 1672197948 D-26       /
      DATA AM20CS( 41) / +.1977892720 0784609237 0846251490 D-26       /
      DATA AM20CS( 42) / +.9321163512 8462066568 0435253373 D-27       /
      DATA AM20CS( 43) / +.4434821332 4991809995 5611379722 D-27       /
      DATA AM20CS( 44) / +.2129456723 6557389559 4589552837 D-27       /
      DATA AM20CS( 45) / +.1031585696 5107597755 2209344907 D-27       /
      DATA AM20CS( 46) / +.5040237730 2259119915 7904590029 D-28       /
      DATA AM20CS( 47) / +.2483013045 7015594530 4046541005 D-28       /
      DATA AM20CS( 48) / +.1233017831 2856219605 4198238560 D-28       /
      DATA AM20CS( 49) / +.6170334499 2052174612 1976730507 D-29       /
      DATA AM20CS( 50) / +.3110926174 1591889723 3869792213 D-29       /
      DATA AM20CS( 51) / +.1579830852 0170617301 5269071503 D-29       /
      DATA AM20CS( 52) / +.8079319875 3828360767 8121339092 D-30       /
      DATA AM20CS( 53) / +.4159973941 3866756272 2951360052 D-30       /
      DATA AM20CS( 54) / +.2156109340 9771690047 1935862504 D-30       /
      DATA AM20CS( 55) / +.1124688572 6586917829 6752823613 D-30       /
      DATA AM20CS( 56) / +.5903315606 3283809112 3040811797 D-31       /
      DATA AM20CS( 57) / +.3117356676 9292856204 6280505333 D-31       /
      DATA ATH0CS(  1) / -.8172601764 1616344998 4020870054 3 D-1      /
      DATA ATH0CS(  2) / -.8004012824 7882732875 9648111306 8 D-3      /
      DATA ATH0CS(  3) / -.3186525268 7821132037 9555362824 2 D-5      /
      DATA ATH0CS(  4) / -.6688388266 4775093307 4169886503 3 D-7      /
      DATA ATH0CS(  5) / -.2931759284 9945645165 0682246318 4 D-8      /
      DATA ATH0CS(  6) / -.2011263760 8836216690 4903030718 6 D-9      /
      DATA ATH0CS(  7) / -.1877522678 0559734260 7400816665 2 D-10     /
      DATA ATH0CS(  8) / -.2199637137 7046012518 9900219984 8 D-11     /
      DATA ATH0CS(  9) / -.3071616682 5922724490 2574660558 6 D-12     /
      DATA ATH0CS( 10) / -.4936140553 6734183610 2560098538 9 D-13     /
      DATA ATH0CS( 11) / -.8902833722 5836604169 3523696986 6 D-14     /
      DATA ATH0CS( 12) / -.1768987764 6152726136 5681419946 7 D-14     /
      DATA ATH0CS( 13) / -.3817868689 0322770146 7819960960 0 D-15     /
      DATA ATH0CS( 14) / -.8851159014 8199475941 5628650998 4 D-16     /
      DATA ATH0CS( 15) / -.2184818181 4143659531 4967767956 8 D-16     /
      DATA ATH0CS( 16) / -.5700849046 9864523805 9944229511 9 D-17     /
      DATA ATH0CS( 17) / -.1563121122 1778753925 1603179549 5 D-17     /
      DATA ATH0CS( 18) / -.4481437996 7689950679 0668877635 3 D-18     /
      DATA ATH0CS( 19) / -.1337794883 7361880220 4456604409 8 D-18     /
      DATA ATH0CS( 20) / -.4143340036 8741144537 7685244544 2 D-19     /
      DATA ATH0CS( 21) / -.1327263385 7188050250 8048116465 2 D-19     /
      DATA ATH0CS( 22) / -.4385728589 1284405222 1575683595 5 D-20     /
      DATA ATH0CS( 23) / -.1491360695 9528180676 8620174395 6 D-20     /
      DATA ATH0CS( 24) / -.5208104738 6307113771 5423818877 3 D-21     /
      DATA ATH0CS( 25) / -.1864382222 3904989238 7252660497 9 D-21     /
      DATA ATH0CS( 26) / -.6830263751 1679690129 7543538188 1 D-22     /
      DATA ATH0CS( 27) / -.2557117058 0293296292 9620759134 7 D-22     /
      DATA ATH0CS( 28) / -.9770158640 2543002182 4690725404 6 D-23     /
      DATA ATH0CS( 29) / -.3805161433 4166790840 6842825488 6 D-23     /
      DATA ATH0CS( 30) / -.1509022750 7370540634 9392648299 5 D-23     /
      DATA ATH0CS( 31) / -.6087551341 2424249290 0556801452 5 D-24     /
      DATA ATH0CS( 32) / -.2495879513 8097114954 2598212405 8 D-24     /
      DATA ATH0CS( 33) / -.1039157654 5819209489 0958808427 4 D-24     /
      DATA ATH0CS( 34) / -.4390235913 9768465369 7459496905 1 D-25     /
      DATA ATH0CS( 35) / -.1880790678 4479902116 7582682058 2 D-25     /
      DATA ATH0CS( 36) / -.8165070764 1994629488 6302220575 3 D-26     /
      DATA ATH0CS( 37) / -.3589944503 7497505142 6643558504 1 D-26     /
      DATA ATH0CS( 38) / -.1597658126 6321328729 8129160870 8 D-26     /
      DATA ATH0CS( 39) / -.7193250175 7038239691 1380283530 5 D-27     /
      DATA ATH0CS( 40) / -.3274943012 7278565062 0935113272 1 D-27     /
      DATA ATH0CS( 41) / -.1507042445 7836906658 1697504727 2 D-27     /
      DATA ATH0CS( 42) / -.7006624198 3199047178 4396794914 0 D-28     /
      DATA ATH0CS( 43) / -.3289907402 9837182265 2881567835 6 D-28     /
      DATA ATH0CS( 44) / -.1559518084 3651465264 4532271149 6 D-28     /
      DATA ATH0CS( 45) / -.7460690508 2082545828 3385111972 1 D-29     /
      DATA ATH0CS( 46) / -.3600877034 8246620205 6327724943 1 D-29     /
      DATA ATH0CS( 47) / -.1752851437 4737722573 5040221919 7 D-29     /
      DATA ATH0CS( 48) / -.8603275775 1885129096 2377862872 4 D-30     /
      DATA ATH0CS( 49) / -.4256432603 2269465346 6803948010 5 D-30     /
      DATA ATH0CS( 50) / -.2122161865 0442629277 2365069820 6 D-30     /
      DATA ATH0CS( 51) / -.1065996156 7048790524 7206079856 1 D-30     /
      DATA ATH0CS( 52) / -.5393568608 8169491164 1068808689 2 D-31     /
      DATA ATH0CS( 53) / -.2748174851 0439548222 7849651787 0 D-31     /
      DATA AM21CS(  1) / +.5927902667 2130958837 5717482814 D-2        /
      DATA AM21CS(  2) / +.2005694053 9316518642 8695217690 D-2        /
      DATA AM21CS(  3) / +.9110818502 6227589355 3072526291 D-4        /
      DATA AM21CS(  4) / +.8498943063 7204715563 3172107475 D-5        /
      DATA AM21CS(  5) / +.1132979089 7691307663 7929215494 D-5        /
      DATA AM21CS(  6) / +.1875179461 0066649618 0950627804 D-6        /
      DATA AM21CS(  7) / +.3593065190 1824583269 9035211192 D-7        /
      DATA AM21CS(  8) / +.7657577140 7168386403 9093517470 D-8        /
      DATA AM21CS(  9) / +.1769999671 6803917392 5953460744 D-8        /
      DATA AM21CS( 10) / +.4362595556 5459893272 0546585535 D-9        /
      DATA AM21CS( 11) / +.1132916413 3785323003 5520085219 D-9        /
      DATA AM21CS( 12) / +.3072576909 8241924413 7868398126 D-10       /
      DATA AM21CS( 13) / +.8644824164 8220107554 1200465766 D-11       /
      DATA AM21CS( 14) / +.2510152500 6092440211 5104562212 D-11       /
      DATA AM21CS( 15) / +.7491024967 6444037160 1802227751 D-12       /
      DATA AM21CS( 16) / +.2289969284 8799407308 9565214432 D-12       /
      DATA AM21CS( 17) / +.7151136589 2798769494 9327491175 D-13       /
      DATA AM21CS( 18) / +.2276079249 5956684194 6395165061 D-13       /
      DATA AM21CS( 19) / +.7369421427 6088651396 9953227782 D-14       /
      DATA AM21CS( 20) / +.2423286752 6782749046 3991742006 D-14       /
      DATA AM21CS( 21) / +.8081537745 4823986928 3406558403 D-15       /
      DATA AM21CS( 22) / +.2730080798 0435608665 9174563386 D-15       /
      DATA AM21CS( 23) / +.9332360708 9138531847 3519474326 D-16       /
      DATA AM21CS( 24) / +.3225080996 8108462221 3867546973 D-16       /
      DATA AM21CS( 25) / +.1125819323 4644454121 7757573416 D-16       /
      DATA AM21CS( 26) / +.3966994639 8693882166 0259459530 D-17       /
      DATA AM21CS( 27) / +.1410065679 4431950466 0865034527 D-17       /
      DATA AM21CS( 28) / +.5053020865 3785121337 5537393032 D-18       /
      DATA AM21CS( 29) / +.1824615232 1594514119 7999102789 D-18       /
      DATA AM21CS( 30) / +.6635845682 6213046692 8029121642 D-19       /
      DATA AM21CS( 31) / +.2429637316 3127617974 1747455826 D-19       /
      DATA AM21CS( 32) / +.8952389151 2368780201 3669922963 D-20       /
      DATA AM21CS( 33) / +.3318452893 5005079126 0229250755 D-20       /
      DATA AM21CS( 34) / +.1237061961 8865831538 4437905922 D-20       /
      DATA AM21CS( 35) / +.4636366770 1239084030 6767734243 D-21       /
      DATA AM21CS( 36) / +.1746531359 4776447546 9758765989 D-21       /
      DATA AM21CS( 37) / +.6611168102 3499117630 7910643111 D-22       /
      DATA AM21CS( 38) / +.2514099189 9407248617 6125666459 D-22       /
      DATA AM21CS( 39) / +.9602749955 7173256869 4034386998 D-23       /
      DATA AM21CS( 40) / +.3683249522 8929639568 6436898078 D-23       /
      DATA AM21CS( 41) / +.1418431382 6915913614 5535939553 D-23       /
      DATA AM21CS( 42) / +.5483426742 7693583010 6345800990 D-24       /
      DATA AM21CS( 43) / +.2127610546 2311880665 0372562616 D-24       /
      DATA AM21CS( 44) / +.8284437008 4941859148 7734760953 D-25       /
      DATA AM21CS( 45) / +.3236705639 2612700142 1028600927 D-25       /
      DATA AM21CS( 46) / +.1268688829 6328605735 5055062493 D-25       /
      DATA AM21CS( 47) / +.4988438189 9212162693 5068934362 D-26       /
      DATA AM21CS( 48) / +.1967345844 6764939096 7119381790 D-26       /
      DATA AM21CS( 49) / +.7781359710 2032695771 3212064836 D-27       /
      DATA AM21CS( 50) / +.3086339414 9891115291 9192968451 D-27       /
      DATA AM21CS( 51) / +.1227446470 4545311978 9338037234 D-27       /
      DATA AM21CS( 52) / +.4894312791 3429220588 5241216204 D-28       /
      DATA AM21CS( 53) / +.1956468798 0290982117 5925099724 D-28       /
      DATA AM21CS( 54) / +.7839889529 2242617116 6311492266 D-29       /
      DATA AM21CS( 55) / +.3148969140 0248422374 8298978099 D-29       /
      DATA AM21CS( 56) / +.1267697631 3725068130 7067842559 D-29       /
      DATA AM21CS( 57) / +.5114706919 0690014164 1632107724 D-30       /
      DATA AM21CS( 58) / +.2068017097 9553877025 0900316706 D-30       /
      DATA AM21CS( 59) / +.8378913447 6851900132 5996867583 D-31       /
      DATA AM21CS( 60) / +.3401689919 7148980205 2339079577 D-31       /
      DATA ATH1CS(  1) / -.6972849916 2088838458 8814841503 7 D-1      /
      DATA ATH1CS(  2) / -.5108722790 6500449870 7344807796 1 D-2      /
      DATA ATH1CS(  3) / -.8644335996 9897550945 2533474951 2 D-4      /
      DATA ATH1CS(  4) / -.5604720044 2352635421 8869891612 5 D-5      /
      DATA ATH1CS(  5) / -.6045735125 6238974091 5637664007 7 D-6      /
      DATA ATH1CS(  6) / -.8639802632 4883343932 1972113849 9 D-7      /
      DATA ATH1CS(  7) / -.1480809484 3099271571 4778248078 0 D-7      /
      DATA ATH1CS(  8) / -.2885809334 5772360399 9944990871 2 D-8      /
      DATA ATH1CS(  9) / -.6191631975 6656996093 0919123180 0 D-9      /
      DATA ATH1CS( 10) / -.1431992808 8609578309 3136525987 9 D-9      /
      DATA ATH1CS( 11) / -.3518141102 1372147215 0461687432 1 D-10     /
      DATA ATH1CS( 12) / -.9084761919 9550782900 7033980805 1 D-11     /
      DATA ATH1CS( 13) / -.2446171672 6885984493 4328366476 7 D-11     /
      DATA ATH1CS( 14) / -.6826083203 2134462408 2899671026 4 D-12     /
      DATA ATH1CS( 15) / -.1964579931 1949401712 7854625780 2 D-12     /
      DATA ATH1CS( 16) / -.5808933227 1396931640 0919126585 6 D-13     /
      DATA ATH1CS( 17) / -.1759042249 5274419927 9540095902 4 D-13     /
      DATA ATH1CS( 18) / -.5440902932 7148966136 3253894531 9 D-14     /
      DATA ATH1CS( 19) / -.1715247407 4868068026 2235851945 1 D-14     /
      DATA ATH1CS( 20) / -.5500929233 5769915468 7110184716 1 D-15     /
      DATA ATH1CS( 21) / -.1791878287 7393172594 9515263875 4 D-15     /
      DATA ATH1CS( 22) / -.5920372520 0866941977 7841106223 1 D-16     /
      DATA ATH1CS( 23) / -.1981713027 8764839624 7097220659 0 D-16     /
      DATA ATH1CS( 24) / -.6713232347 0163522620 4998434379 0 D-17     /
      DATA ATH1CS( 25) / -.2299450243 6582811161 2235861983 2 D-17     /
      DATA ATH1CS( 26) / -.7957300928 2363765953 0463714563 4 D-18     /
      DATA ATH1CS( 27) / -.2779994027 2917841571 7229023373 9 D-18     /
      DATA ATH1CS( 28) / -.9798924361 3269852244 0679548081 4 D-19     /
      DATA ATH1CS( 29) / -.3482717006 0615743867 0264556584 9 D-19     /
      DATA ATH1CS( 30) / -.1247489122 5585990571 7330005808 4 D-19     /
      DATA ATH1CS( 31) / -.4501210041 4782281134 8775182445 2 D-20     /
      DATA ATH1CS( 32) / -.1635346244 0133521355 9611416466 7 D-20     /
      DATA ATH1CS( 33) / -.5980102897 7803362680 9876226594 1 D-21     /
      DATA ATH1CS( 34) / -.2200246286 2861234540 2819629547 5 D-21     /
      DATA ATH1CS( 35) / -.8142463073 5150858974 0820529151 9 D-22     /
      DATA ATH1CS( 36) / -.3029924773 6600425374 3233070967 4 D-22     /
      DATA ATH1CS( 37) / -.1133390098 5746235377 2294396968 9 D-22     /
      DATA ATH1CS( 38) / -.4260766024 7492957192 8304988979 1 D-23     /
      DATA ATH1CS( 39) / -.1609363396 2781897187 9750063445 3 D-23     /
      DATA ATH1CS( 40) / -.6106377190 8250262930 4533044428 7 D-24     /
      DATA ATH1CS( 41) / -.2326954318 0216940618 3657788757 3 D-24     /
      DATA ATH1CS( 42) / -.8903987877 4722526044 7412955818 6 D-25     /
      DATA ATH1CS( 43) / -.3420558530 0056750241 1791475234 1 D-25     /
      DATA ATH1CS( 44) / -.1319026715 2572726590 1721210060 7 D-25     /
      DATA ATH1CS( 45) / -.5104899493 6120430913 1619117738 6 D-26     /
      DATA ATH1CS( 46) / -.1982599478 4745474512 4244466346 6 D-26     /
      DATA ATH1CS( 47) / -.7725702356 8808305356 3611185151 9 D-27     /
      DATA ATH1CS( 48) / -.3020234733 6646801008 1577686357 3 D-27     /
      DATA ATH1CS( 49) / -.1184379739 0741699937 1294638080 0 D-27     /
      DATA ATH1CS( 50) / -.4658430227 9223085205 7325284010 6 D-28     /
      DATA ATH1CS( 51) / -.1837554188 1003846471 5750200661 3 D-28     /
      DATA ATH1CS( 52) / -.7268566894 4279909533 2187668480 0 D-29     /
      DATA ATH1CS( 53) / -.2882863120 3914681355 2708987562 6 D-29     /
      DATA ATH1CS( 54) / -.1146374629 4599063504 1759166463 9 D-29     /
      DATA ATH1CS( 55) / -.4570031437 7485330581 7999168853 3 D-30     /
      DATA ATH1CS( 56) / -.1826276602 0453461048 0993402879 9 D-30     /
      DATA ATH1CS( 57) / -.7315349993 3852504691 1106635093 3 D-31     /
      DATA ATH1CS( 58) / -.2936925599 9714297816 3781577386 6 D-31     /
      DATA AM22CS(  1) / -.1562844480 6253411275 3545828583 D-1        /
      DATA AM22CS(  2) / +.7783364452 3968130701 8943100334 D-2        /
      DATA AM22CS(  3) / +.8670577704 7718952840 6072812110 D-3        /
      DATA AM22CS(  4) / +.1569662731 5611371946 9953482266 D-3        /
      DATA AM22CS(  5) / +.3563962571 4328651132 4100666302 D-4        /
      DATA AM22CS(  6) / +.9245983354 2504315449 5080090994 D-5        /
      DATA AM22CS(  7) / +.2621101618 5042238952 3194982066 D-5        /
      DATA AM22CS(  8) / +.7918822165 1601256148 9469982263 D-6        /
      DATA AM22CS(  9) / +.2510415279 2101184780 3162690862 D-6        /
      DATA AM22CS( 10) / +.8265223206 6540773447 2997712940 D-7        /
      DATA AM22CS( 11) / +.2805711662 8130526439 6384290014 D-7        /
      DATA AM22CS( 12) / +.9768210904 8468078667 4631273890 D-8        /
      DATA AM22CS( 13) / +.3474079232 2771034328 7279035573 D-8        /
      DATA AM22CS( 14) / +.1258281321 6983691421 9092738164 D-8        /
      DATA AM22CS( 15) / +.4629882606 4189526449 7330784625 D-9        /
      DATA AM22CS( 16) / +.1727282588 1360407246 8143128696 D-9        /
      DATA AM22CS( 17) / +.6523192001 3115413514 8574124970 D-10       /
      DATA AM22CS( 18) / +.2490471685 2098205601 9881087112 D-10       /
      DATA AM22CS( 19) / +.9601568205 5376594807 8189890126 D-11       /
      DATA AM22CS( 20) / +.3734480020 6772685697 4776596757 D-11       /
      DATA AM22CS( 21) / +.1464175650 3205339172 2216189678 D-11       /
      DATA AM22CS( 22) / +.5782654711 6851282547 5827881553 D-12       /
      DATA AM22CS( 23) / +.2299154072 4470611856 0254184494 D-12       /
      DATA AM22CS( 24) / +.9197807112 3199725715 0883662365 D-13       /
      DATA AM22CS( 25) / +.3700600688 1309006580 7504045556 D-13       /
      DATA AM22CS( 26) / +.1496757616 9867298782 3326345205 D-13       /
      DATA AM22CS( 27) / +.6083611949 3846114872 0451399443 D-14       /
      DATA AM22CS( 28) / +.2484040871 1512139763 5425326873 D-14       /
      DATA AM22CS( 29) / +.1018624765 2676908072 7914465339 D-14       /
      DATA AM22CS( 30) / +.4193838563 5275398942 9640310957 D-15       /
      DATA AM22CS( 31) / +.1733189017 6293075614 9702493501 D-15       /
      DATA AM22CS( 32) / +.7188219023 8850851782 0445406811 D-16       /
      DATA AM22CS( 33) / +.2991236335 9840360771 2470896113 D-16       /
      DATA AM22CS( 34) / +.1248689904 3323862785 5713110880 D-16       /
      DATA AM22CS( 35) / +.5228293446 0948366192 8651193632 D-17       /
      DATA AM22CS( 36) / +.2195329617 2471339659 5998454359 D-17       /
      DATA AM22CS( 37) / +.9242983252 2977728115 4410024332 D-18       /
      DATA AM22CS( 38) / +.3901577082 3609140782 5543197309 D-18       /
      DATA AM22CS( 39) / +.1650938926 9386370721 3759030367 D-18       /
      DATA AM22CS( 40) / +.7002218157 1599436756 5716554487 D-19       /
      DATA AM22CS( 41) / +.2976518336 1678691557 3214963506 D-19       /
      DATA AM22CS( 42) / +.1267965390 8690207257 1134261229 D-19       /
      DATA AM22CS( 43) / +.5412434006 9707762868 7581725061 D-20       /
      DATA AM22CS( 44) / +.2314873502 1815525229 6382133283 D-20       /
      DATA AM22CS( 45) / +.9919202883 8656656346 2623851167 D-21       /
      DATA AM22CS( 46) / +.4258030153 2373235715 8897608174 D-21       /
      DATA AM22CS( 47) / +.1831018429 7302450167 8402003088 D-21       /
      DATA AM22CS( 48) / +.7886787123 1107537556 4526811022 D-22       /
      DATA AM22CS( 49) / +.3402546073 8622987495 6582997235 D-22       /
      DATA AM22CS( 50) / +.1470208814 0571253079 1860892535 D-22       /
      DATA AM22CS( 51) / +.6362110183 2491695773 3348071767 D-23       /
      DATA AM22CS( 52) / +.2757070506 8098072191 9395987768 D-23       /
      DATA AM22CS( 53) / +.1196458580 9010407135 6261780457 D-23       /
      DATA AM22CS( 54) / +.5199125457 2924214798 1768210567 D-24       /
      DATA AM22CS( 55) / +.2262176748 4710447526 0575286850 D-24       /
      DATA AM22CS( 56) / +.9855261137 5443181944 8565068283 D-25       /
      DATA AM22CS( 57) / +.4298706303 3250871722 3681286187 D-25       /
      DATA AM22CS( 58) / +.1877236416 6158063982 9657670189 D-25       /
      DATA AM22CS( 59) / +.8207219417 7284213726 8801052115 D-26       /
      DATA AM22CS( 60) / +.3592146656 0461550781 2767944463 D-26       /
      DATA AM22CS( 61) / +.1573905946 1277331561 1458940587 D-26       /
      DATA AM22CS( 62) / +.6903297810 3933383496 5319153586 D-27       /
      DATA AM22CS( 63) / +.3030920790 7896853460 7859331415 D-27       /
      DATA AM22CS( 64) / +.1332049341 6048121918 5689121944 D-27       /
      DATA AM22CS( 65) / +.5859788368 5152349011 7937981442 D-28       /
      DATA AM22CS( 66) / +.2580168684 8948780633 8425080457 D-28       /
      DATA AM22CS( 67) / +.1137124336 3728366722 3632182863 D-28       /
      DATA AM22CS( 68) / +.5015925572 2606850923 6430548549 D-29       /
      DATA AM22CS( 69) / +.2214458293 9550937332 2569708484 D-29       /
      DATA AM22CS( 70) / +.9784702838 8650728998 4691416411 D-30       /
      DATA AM22CS( 71) / +.4326954149 3418017011 2000952983 D-30       /
      DATA AM22CS( 72) / +.1914972881 9399457061 2929860440 D-30       /
      DATA AM22CS( 73) / +.8481646224 0239235417 1298331562 D-31       /
      DATA AM22CS( 74) / +.3759470651 7395591994 7455052934 D-31       /
      DATA ATH2CS(  1) / +.4405273458 7187789970 6112705777 5 D-2      /
      DATA ATH2CS(  2) / -.3042919452 3184546084 8384423987 3 D-1      /
      DATA ATH2CS(  3) / -.1385653283 7717937916 0269284265 3 D-2      /
      DATA ATH2CS(  4) / -.1804443908 9549523026 7048691095 2 D-3      /
      DATA ATH2CS(  5) / -.3380847108 3273086710 5746532361 8 D-4      /
      DATA ATH2CS(  6) / -.7678183535 2290230552 5767681776 5 D-5      /
      DATA ATH2CS(  7) / -.1967839443 7160353246 9093541707 7 D-5      /
      DATA ATH2CS(  8) / -.5483727115 8777003615 8614365928 1 D-6      /
      DATA ATH2CS(  9) / -.1625461550 5326124527 1269621225 8 D-6      /
      DATA ATH2CS( 10) / -.5053049981 2688950152 7763784207 8 D-7      /
      DATA ATH2CS( 11) / -.1631580701 1240668811 8385171561 7 D-7      /
      DATA ATH2CS( 12) / -.5434204112 3485175079 6343669481 7 D-8      /
      DATA ATH2CS( 13) / -.1857398556 4099003257 6385010963 0 D-8      /
      DATA ATH2CS( 14) / -.6489512033 3261088162 1351364067 6 D-9      /
      DATA ATH2CS( 15) / -.2310594885 8009447204 8299598707 9 D-9      /
      DATA ATH2CS( 16) / -.8363282183 2044116828 1932954674 5 D-10     /
      DATA ATH2CS( 17) / -.3071196844 8901914626 6066130389 1 D-10     /
      DATA ATH2CS( 18) / -.1142367142 4327168194 0951457989 2 D-10     /
      DATA ATH2CS( 19) / -.4298116066 3458030658 2247010897 1 D-11     /
      DATA ATH2CS( 20) / -.1633898699 5967154406 0164608663 2 D-11     /
      DATA ATH2CS( 21) / -.6269328620 0166194321 2344375407 6 D-12     /
      DATA ATH2CS( 22) / -.2426052694 8162573573 5615920399 1 D-12     /
      DATA ATH2CS( 23) / -.9461198321 6240390907 4252776505 2 D-13     /
      DATA ATH2CS( 24) / -.3716060313 4115048068 4779828126 9 D-13     /
      DATA ATH2CS( 25) / -.1469155684 0975267631 7013881030 9 D-13     /
      DATA ATH2CS( 26) / -.5843694726 1409119445 5640136309 4 D-14     /
      DATA ATH2CS( 27) / -.2337502595 5919512988 3267503493 4 D-14     /
      DATA ATH2CS( 28) / -.9399231371 1714354011 6016735841 1 D-15     /
      DATA ATH2CS( 29) / -.3798014669 3728945000 7633526371 5 D-15     /
      DATA ATH2CS( 30) / -.1541731043 9849725248 8344368177 5 D-15     /
      DATA ATH2CS( 31) / -.6285287079 5353071629 2566236520 2 D-16     /
      DATA ATH2CS( 32) / -.2572731812 8114554247 5538399277 4 D-16     /
      DATA ATH2CS( 33) / -.1057098119 3540178093 4097486655 5 D-16     /
      DATA ATH2CS( 34) / -.4359080267 4026969666 9599269996 4 D-17     /
      DATA ATH2CS( 35) / -.1803634315 9599780139 5317694554 0 D-17     /
      DATA ATH2CS( 36) / -.7486838064 3805368217 1943167691 4 D-18     /
      DATA ATH2CS( 37) / -.3117261367 3476046567 9959720998 5 D-18     /
      DATA ATH2CS( 38) / -.1301687980 9277007347 9287162069 6 D-18     /
      DATA ATH2CS( 39) / -.5450527587 5195224689 7388390990 9 D-19     /
      DATA ATH2CS( 40) / -.2288293490 1142318722 6863593190 3 D-19     /
      DATA ATH2CS( 41) / -.9631059503 8295386556 5506044008 8 D-20     /
      DATA ATH2CS( 42) / -.4063281001 5246140890 9219541643 4 D-20     /
      DATA ATH2CS( 43) / -.1718203980 9080267639 0041385851 0 D-20     /
      DATA ATH2CS( 44) / -.7281574619 8925363674 1532247332 8 D-21     /
      DATA ATH2CS( 45) / -.3092352652 6806431279 6068034579 0 D-21     /
      DATA ATH2CS( 46) / -.1315917855 9654404903 8341702325 4 D-21     /
      DATA ATH2CS( 47) / -.5610606786 0870555126 6490741266 8 D-22     /
      DATA ATH2CS( 48) / -.2396621894 0863552060 2030433789 5 D-22     /
      DATA ATH2CS( 49) / -.1025574332 3905812008 3295442392 4 D-22     /
      DATA ATH2CS( 50) / -.4396264138 1436564764 0360732366 3 D-23     /
      DATA ATH2CS( 51) / -.1887652998 3725773733 4250871945 0 D-23     /
      DATA ATH2CS( 52) / -.8118140359 5768076035 7943323044 5 D-24     /
      DATA ATH2CS( 53) / -.3496734274 3662868563 7595208921 4 D-24     /
      DATA ATH2CS( 54) / -.1508402925 1568732151 7175147586 7 D-24     /
      DATA ATH2CS( 55) / -.6516268284 7786710597 8777383434 1 D-25     /
      DATA ATH2CS( 56) / -.2818945797 5292074245 0594211458 3 D-25     /
      DATA ATH2CS( 57) / -.1221127596 5122627445 9809446450 5 D-25     /
      DATA ATH2CS( 58) / -.5296674341 1698671686 2001170507 3 D-26     /
      DATA ATH2CS( 59) / -.2300359270 7736734313 5887097174 4 D-26     /
      DATA ATH2CS( 60) / -.1000279482 3553674947 8122034893 0 D-26     /
      DATA ATH2CS( 61) / -.4354760404 1808793948 0689316217 9 D-27     /
      DATA ATH2CS( 62) / -.1898056134 7414775225 1548282703 0 D-27     /
      DATA ATH2CS( 63) / -.8282111868 7129746975 5400930931 5 D-28     /
      DATA ATH2CS( 64) / -.3617815493 0665690065 8621348437 4 D-28     /
      DATA ATH2CS( 65) / -.1582018896 1780036548 5894184363 6 D-28     /
      DATA ATH2CS( 66) / -.6925068597 8022700117 7282038324 7 D-29     /
      DATA ATH2CS( 67) / -.3034390239 7786291289 0862972733 5 D-29     /
      DATA ATH2CS( 68) / -.1330889568 1667252247 6197744650 9 D-29     /
      DATA ATH2CS( 69) / -.5842848522 1730901204 8760697170 6 D-30     /
      DATA ATH2CS( 70) / -.2567488423 2383026311 2127435767 8 D-30     /
      DATA ATH2CS( 71) / -.1129232322 2688821857 9150581915 1 D-30     /
      DATA ATH2CS( 72) / -.4970947029 7533369165 5057010502 3 D-31     /
      DATA PI4 / 0.7853981633 9744830961 5660845819 88D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9AIMP
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NAM20 = INITDS (AM20CS, 57, ETA)
         NATH0 = INITDS (ATH0CS, 53, ETA)
         NAM21 = INITDS (AM21CS, 60, ETA)
         NATH1 = INITDS (ATH1CS, 58, ETA)
         NAM22 = INITDS (AM22CS, 74, ETA)
         NATH2 = INITDS (ATH2CS, 72, ETA)
C
         XSML = -1.0D0/D1MACH(3)**0.3333D0
      ENDIF
      FIRST = .FALSE.
C
      IF (X.GE.(-4.0D0)) GO TO 20
      Z = 1.0D0
      IF (X.GT.XSML) Z = 128.D0/X**3 + 1.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM20CS, NAM20)
      THETA = -0.625D0 + DCSEVL (Z, ATH0CS, NATH0)
      GO TO 40
C
 20   IF (X.GE.(-2.0D0)) GO TO 30
      Z = (128.D0/X**3 + 9.0D0)/7.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM21CS, NAM21)
      THETA = -0.625D0 + DCSEVL (Z, ATH1CS, NATH1)
      GO TO 40
C
 30   IF (X .GE. (-1.0D0)) CALL XERMSG ('SLATEC', 'D9AIMP',
     +   'X MUST BE LE -1.0', 1, 2)
C
      Z = (16.D0/X**3 + 9.0D0)/7.0D0
      AMPL = 0.3125D0 + DCSEVL (Z, AM22CS, NAM22)
      THETA = -0.625D0 + DCSEVL (Z, ATH2CS, NATH2)
C
 40   SQRTX = SQRT(-X)
      AMPL = SQRT(AMPL/SQRTX)
      THETA = PI4 - X*SQRTX*THETA
C
      RETURN
      END
*DECK D9ATN1
      DOUBLE PRECISION FUNCTION D9ATN1 (X)
C***BEGIN PROLOGUE  D9ATN1
C***SUBSIDIARY
C***PURPOSE  Evaluate DATAN(X) from first order relative accuracy so
C            that DATAN(X) = X + X**3*D9ATN1(X).
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C4A
C***TYPE      DOUBLE PRECISION (R9ATN1-S, D9ATN1-D)
C***KEYWORDS  ARC TANGENT, ELEMENTARY FUNCTIONS, FIRST ORDER, FNLIB,
C             TRIGONOMETRIC
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Evaluate  DATAN(X)  from first order, that is, evaluate
C (DATAN(X)-X)/X**3  with relative error accuracy so that
C        DATAN(X) = X + X**3*D9ATN1(X).
C
C Series for ATN1       on the interval  0.          to  1.00000E+00
C                                        with weighted error   3.39E-32
C                                         log weighted error  31.47
C                               significant figures required  30.26
C                                    decimal places required  32.27
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   780401  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   891115  Corrected third argument in reference to INITDS.  (WRB)
C   891115  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9ATN1
      DOUBLE PRECISION X, XBIG, XMAX, XSML, Y, ATN1CS(40), EPS,
     1  DCSEVL, D1MACH
      LOGICAL FIRST
      SAVE ATN1CS, NTATN1, XSML, XBIG, XMAX, FIRST
      DATA ATN1CS(  1) / -.3283997535 3552023569 0793992299 0 D-1      /
      DATA ATN1CS(  2) / +.5833432343 1724124499 5166991490 7 D-1      /
      DATA ATN1CS(  3) / -.7400369696 7196464638 0901155141 3 D-2      /
      DATA ATN1CS(  4) / +.1009784199 3372880835 9035751163 9 D-2      /
      DATA ATN1CS(  5) / -.1439787163 5652056214 7130369770 0 D-3      /
      DATA ATN1CS(  6) / +.2114512648 9921075720 7211224343 9 D-4      /
      DATA ATN1CS(  7) / -.3172321074 2546671674 0256499675 7 D-5      /
      DATA ATN1CS(  8) / +.4836620365 4607108253 7785938480 0 D-6      /
      DATA ATN1CS(  9) / -.7467746546 8141126704 3761432277 6 D-7      /
      DATA ATN1CS( 10) / +.1164800896 8244298306 2099864134 2 D-7      /
      DATA ATN1CS( 11) / -.1832088370 8472013926 9995624245 2 D-8      /
      DATA ATN1CS( 12) / +.2901908277 9660633131 7535123045 5 D-9      /
      DATA ATN1CS( 13) / -.4623885312 1063267383 5180572151 2 D-10     /
      DATA ATN1CS( 14) / +.7405528668 7757369179 9219704828 6 D-11     /
      DATA ATN1CS( 15) / -.1191354457 8451366823 7082037341 7 D-11     /
      DATA ATN1CS( 16) / +.1924090144 3917725998 6785569251 8 D-12     /
      DATA ATN1CS( 17) / -.3118271051 0761942722 5447615532 7 D-13     /
      DATA ATN1CS( 18) / +.5069240036 5677317896 9452059303 2 D-14     /
      DATA ATN1CS( 19) / -.8263694719 8028660538 1828440596 4 D-15     /
      DATA ATN1CS( 20) / +.1350486709 8170794205 2650612302 9 D-15     /
      DATA ATN1CS( 21) / -.2212023650 4817460458 4013782319 1 D-16     /
      DATA ATN1CS( 22) / +.3630654747 3813567838 2904764770 9 D-17     /
      DATA ATN1CS( 23) / -.5970345328 8471540524 5121585916 5 D-18     /
      DATA ATN1CS( 24) / +.9834816050 0771331194 4832900573 8 D-19     /
      DATA ATN1CS( 25) / -.1622655075 8550623361 4438760448 0 D-19     /
      DATA ATN1CS( 26) / +.2681186176 9454367963 0132030122 6 D-20     /
      DATA ATN1CS( 27) / -.4436309706 7852554796 3624368810 6 D-21     /
      DATA ATN1CS( 28) / +.7349691897 6524969450 7246551040 0 D-22     /
      DATA ATN1CS( 29) / -.1219077508 3500525882 8940137813 3 D-22     /
      DATA ATN1CS( 30) / +.2024298836 8052154031 8454087679 9 D-23     /
      DATA ATN1CS( 31) / -.3364871555 7973545799 2557636266 6 D-24     /
      DATA ATN1CS( 32) / +.5598673968 3469887494 9293397333 3 D-25     /
      DATA ATN1CS( 33) / -.9323939267 2723202296 2853205333 3 D-26     /
      DATA ATN1CS( 34) / +.1554133116 9959702229 3480789333 3 D-26     /
      DATA ATN1CS( 35) / -.2592569534 1797459227 5742719999 9 D-27     /
      DATA ATN1CS( 36) / +.4328193466 2457346850 3790933333 3 D-28     /
      DATA ATN1CS( 37) / -.7231013125 5954374711 9240533333 3 D-29     /
      DATA ATN1CS( 38) / +.1208902859 8304947729 4216533333 3 D-29     /
      DATA ATN1CS( 39) / -.2022404543 4498975793 1519999999 9 D-30     /
      DATA ATN1CS( 40) / +.3385428713 0464938430 7370666666 6 D-31     /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9ATN1
      IF (FIRST) THEN
         EPS = D1MACH(3)
         NTATN1 = INITDS (ATN1CS, 40, 0.1*REAL(EPS))
C
         XSML = SQRT (0.1D0*EPS)
         XBIG = 1.571D0/SQRT(EPS)
         XMAX = 1.571D0/EPS
      ENDIF
      FIRST = .FALSE.
C
      Y = ABS(X)
      IF (Y.GT.1.0D0) GO TO 20
C
      IF (Y.LE.XSML) D9ATN1 = -1.0D0/3.0D0
      IF (Y.LE.XSML) RETURN
C
      D9ATN1 = -0.25D0 + DCSEVL (2.D0*Y*Y-1.D0, ATN1CS, NTATN1)
      RETURN
C
 20   IF (Y .GT. XMAX) CALL XERMSG ('SLATEC', 'D9ATN1',
     +   'NO PRECISION IN ANSWER BECAUSE X IS TOO BIG', 2, 2)
      IF (Y .GT. XBIG) CALL XERMSG ('SLATEC', 'D9ATN1',
     +   'ANSWER LT HALF PRECISION BECAUSE X IS TOO BIG', 1, 1)
C
      D9ATN1 = (ATAN(X) - X) / X**3
      RETURN
C
      END
*DECK D9B0MP
      SUBROUTINE D9B0MP (X, AMPL, THETA)
C***BEGIN PROLOGUE  D9B0MP
C***SUBSIDIARY
C***PURPOSE  Evaluate the modulus and phase for the J0 and Y0 Bessel
C            functions.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C10A1
C***TYPE      DOUBLE PRECISION (D9B0MP-D)
C***KEYWORDS  BESSEL FUNCTION, FNLIB, MODULUS, PHASE, SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Evaluate the modulus and phase for the Bessel J0 and Y0 functions.
C
C Series for BM0        on the interval  1.56250E-02 to  6.25000E-02
C                                        with weighted error   4.40E-32
C                                         log weighted error  31.36
C                               significant figures required  30.02
C                                    decimal places required  32.14
C
C Series for BTH0       on the interval  0.          to  1.56250E-02
C                                        with weighted error   2.66E-32
C                                         log weighted error  31.57
C                               significant figures required  30.67
C                                    decimal places required  32.40
C
C Series for BM02       on the interval  0.          to  1.56250E-02
C                                        with weighted error   4.72E-32
C                                         log weighted error  31.33
C                               significant figures required  30.00
C                                    decimal places required  32.13
C
C Series for BT02       on the interval  1.56250E-02 to  6.25000E-02
C                                        with weighted error   2.99E-32
C                                         log weighted error  31.52
C                               significant figures required  30.61
C                                    decimal places required  32.32
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C   920618  Removed space from variable names.  (RWC, WRB)
C***END PROLOGUE  D9B0MP
      DOUBLE PRECISION X, AMPL, THETA, BM0CS(37), BT02CS(39),
     1  BM02CS(40), BTH0CS(44), XMAX, PI4, Z, D1MACH, DCSEVL
      LOGICAL FIRST
      SAVE BM0CS, BTH0CS, BM02CS, BT02CS, PI4, NBM0, NBT02,
     1 NBM02, NBTH0, XMAX, FIRST
      DATA BM0CS(  1) / +.9211656246 8277427125 7376773018 2 D-1      /
      DATA BM0CS(  2) / -.1050590997 2719051024 8071637175 5 D-2      /
      DATA BM0CS(  3) / +.1470159840 7687597540 5639285095 2 D-4      /
      DATA BM0CS(  4) / -.5058557606 0385542233 4792932770 2 D-6      /
      DATA BM0CS(  5) / +.2787254538 6324441766 3035613788 1 D-7      /
      DATA BM0CS(  6) / -.2062363611 7809148026 1884101897 3 D-8      /
      DATA BM0CS(  7) / +.1870214313 1388796751 3817259626 1 D-9      /
      DATA BM0CS(  8) / -.1969330971 1356362002 4173077782 5 D-10     /
      DATA BM0CS(  9) / +.2325973793 9992754440 1250881805 2 D-11     /
      DATA BM0CS( 10) / -.3009520344 9382502728 5122473448 2 D-12     /
      DATA BM0CS( 11) / +.4194521333 8506691814 7120676864 6 D-13     /
      DATA BM0CS( 12) / -.6219449312 1884458259 7326742956 4 D-14     /
      DATA BM0CS( 13) / +.9718260411 3360684696 0176588526 9 D-15     /
      DATA BM0CS( 14) / -.1588478585 7010752073 6663596693 7 D-15     /
      DATA BM0CS( 15) / +.2700072193 6713088900 8621732445 8 D-16     /
      DATA BM0CS( 16) / -.4750092365 2340089924 7750478677 3 D-17     /
      DATA BM0CS( 17) / +.8615128162 6043708731 9170374656 0 D-18     /
      DATA BM0CS( 18) / -.1605608686 9561448157 4560270335 9 D-18     /
      DATA BM0CS( 19) / +.3066513987 3144829751 8853980159 9 D-19     /
      DATA BM0CS( 20) / -.5987764223 1939564306 9650561706 6 D-20     /
      DATA BM0CS( 21) / +.1192971253 7482483064 8906984106 6 D-20     /
      DATA BM0CS( 22) / -.2420969142 0448054894 8468258133 3 D-21     /
      DATA BM0CS( 23) / +.4996751760 5106164533 7100287999 9 D-22     /
      DATA BM0CS( 24) / -.1047493639 3511585100 9504051199 9 D-22     /
      DATA BM0CS( 25) / +.2227786843 7974681010 4818346666 6 D-23     /
      DATA BM0CS( 26) / -.4801813239 3981628623 7054293333 3 D-24     /
      DATA BM0CS( 27) / +.1047962723 4709599564 7699626666 6 D-24     /
      DATA BM0CS( 28) / -.2313858165 6786153251 0126080000 0 D-25     /
      DATA BM0CS( 29) / +.5164823088 4626742116 3519999999 9 D-26     /
      DATA BM0CS( 30) / -.1164691191 8500653895 2540159999 9 D-26     /
      DATA BM0CS( 31) / +.2651788486 0433192829 5833600000 0 D-27     /
      DATA BM0CS( 32) / -.6092559503 8257284976 9130666666 6 D-28     /
      DATA BM0CS( 33) / +.1411804686 1442593080 3882666666 6 D-28     /
      DATA BM0CS( 34) / -.3298094961 2317372457 5061333333 3 D-29     /
      DATA BM0CS( 35) / +.7763931143 0740650317 1413333333 3 D-30     /
      DATA BM0CS( 36) / -.1841031343 6614584784 2133333333 3 D-30     /
      DATA BM0CS( 37) / +.4395880138 5943107371 0079999999 9 D-31     /
      DATA BTH0CS(  1) / -.2490178086 2128936717 7097937899 67 D+0     /
      DATA BTH0CS(  2) / +.4855029960 9623749241 0486155354 85 D-3     /
      DATA BTH0CS(  3) / -.5451183734 5017204950 6562735635 05 D-5     /
      DATA BTH0CS(  4) / +.1355867305 9405964054 3774459299 03 D-6     /
      DATA BTH0CS(  5) / -.5569139890 2227626227 5832184149 20 D-8     /
      DATA BTH0CS(  6) / +.3260903182 4994335304 0042057194 68 D-9     /
      DATA BTH0CS(  7) / -.2491880786 2461341125 2379038779 93 D-10    /
      DATA BTH0CS(  8) / +.2344937742 0882520554 3524135648 91 D-11    /
      DATA BTH0CS(  9) / -.2609653444 4310387762 1775747661 36 D-12    /
      DATA BTH0CS( 10) / +.3335314042 0097395105 8699550149 23 D-13    /
      DATA BTH0CS( 11) / -.4789000044 0572684646 7507705574 09 D-14    /
      DATA BTH0CS( 12) / +.7595617843 6192215972 6425685452 48 D-15    /
      DATA BTH0CS( 13) / -.1313155601 6891440382 7733974876 33 D-15    /
      DATA BTH0CS( 14) / +.2448361834 5240857495 4268207383 55 D-16    /
      DATA BTH0CS( 15) / -.4880572981 0618777683 2567619183 31 D-17    /
      DATA BTH0CS( 16) / +.1032728502 9786316149 2237563612 04 D-17    /
      DATA BTH0CS( 17) / -.2305763381 5057217157 0047445270 25 D-18    /
      DATA BTH0CS( 18) / +.5404444300 1892693993 0171084837 65 D-19    /
      DATA BTH0CS( 19) / -.1324069519 4366572724 1550328823 85 D-19    /
      DATA BTH0CS( 20) / +.3378079562 1371970203 4247921247 22 D-20    /
      DATA BTH0CS( 21) / -.8945762915 7111779003 0269262922 99 D-21    /
      DATA BTH0CS( 22) / +.2451990688 9219317090 8999086514 05 D-21    /
      DATA BTH0CS( 23) / -.6938842287 6866318680 1399331576 57 D-22    /
      DATA BTH0CS( 24) / +.2022827871 4890138392 9463033377 91 D-22    /
      DATA BTH0CS( 25) / -.6062850000 2335483105 7941953717 64 D-23    /
      DATA BTH0CS( 26) / +.1864974896 4037635381 8237883962 70 D-23    /
      DATA BTH0CS( 27) / -.5878373238 4849894560 2450365308 67 D-24    /
      DATA BTH0CS( 28) / +.1895859144 7999563485 5311795035 13 D-24    /
      DATA BTH0CS( 29) / -.6248197937 2258858959 2916207285 65 D-25    /
      DATA BTH0CS( 30) / +.2101790168 4551024686 6386335290 74 D-25    /
      DATA BTH0CS( 31) / -.7208430093 5209253690 8139339924 46 D-26    /
      DATA BTH0CS( 32) / +.2518136389 2474240867 1564059767 46 D-26    /
      DATA BTH0CS( 33) / -.8951804225 8785778806 1439459536 43 D-27    /
      DATA BTH0CS( 34) / +.3235723747 9762298533 2562358685 87 D-27    /
      DATA BTH0CS( 35) / -.1188301051 9855353657 0471441137 96 D-27    /
      DATA BTH0CS( 36) / +.4430628690 7358104820 5792319417 31 D-28    /
      DATA BTH0CS( 37) / -.1676100964 8834829495 7920101356 81 D-28    /
      DATA BTH0CS( 38) / +.6429294692 1207466972 5323939660 88 D-29    /
      DATA BTH0CS( 39) / -.2499226116 6978652421 2072136827 63 D-29    /
      DATA BTH0CS( 40) / +.9839979429 9521955672 8282603553 18 D-30    /
      DATA BTH0CS( 41) / -.3922037524 2408016397 9891316261 58 D-30    /
      DATA BTH0CS( 42) / +.1581810703 0056522138 5906188456 92 D-30    /
      DATA BTH0CS( 43) / -.6452550614 4890715944 3440983654 26 D-31    /
      DATA BTH0CS( 44) / +.2661111136 9199356137 1770183463 67 D-31    /
      DATA BM02CS(  1) / +.9500415145 2283813693 3086133556 0 D-1      /
      DATA BM02CS(  2) / -.3801864682 3656709917 4808156685 1 D-3      /
      DATA BM02CS(  3) / +.2258339301 0314811929 5182992722 4 D-5      /
      DATA BM02CS(  4) / -.3895725802 3722287647 3062141260 5 D-7      /
      DATA BM02CS(  5) / +.1246886416 5120816979 3099052972 5 D-8      /
      DATA BM02CS(  6) / -.6065949022 1025037798 0383505838 7 D-10     /
      DATA BM02CS(  7) / +.4008461651 4217469910 1527597104 5 D-11     /
      DATA BM02CS(  8) / -.3350998183 3980942184 6729879457 4 D-12     /
      DATA BM02CS(  9) / +.3377119716 5174173670 6326434199 6 D-13     /
      DATA BM02CS( 10) / -.3964585901 6350127005 6935629582 3 D-14     /
      DATA BM02CS( 11) / +.5286111503 8838572173 8793974473 5 D-15     /
      DATA BM02CS( 12) / -.7852519083 4508523136 5464024349 3 D-16     /
      DATA BM02CS( 13) / +.1280300573 3866822010 1163407344 9 D-16     /
      DATA BM02CS( 14) / -.2263996296 3914297762 8709924488 4 D-17     /
      DATA BM02CS( 15) / +.4300496929 6567903886 4641029047 7 D-18     /
      DATA BM02CS( 16) / -.8705749805 1325870797 4753545145 5 D-19     /
      DATA BM02CS( 17) / +.1865862713 9620951411 8144277205 0 D-19     /
      DATA BM02CS( 18) / -.4210482486 0930654573 4508697230 1 D-20     /
      DATA BM02CS( 19) / +.9956676964 2284009915 8162741784 2 D-21     /
      DATA BM02CS( 20) / -.2457357442 8053133596 0592147854 7 D-21     /
      DATA BM02CS( 21) / +.6307692160 7620315680 8735370705 9 D-22     /
      DATA BM02CS( 22) / -.1678773691 4407401426 9333117238 8 D-22     /
      DATA BM02CS( 23) / +.4620259064 6739044337 7087813608 7 D-23     /
      DATA BM02CS( 24) / -.1311782266 8603087322 3769340249 6 D-23     /
      DATA BM02CS( 25) / +.3834087564 1163028277 4792244027 6 D-24     /
      DATA BM02CS( 26) / -.1151459324 0777412710 7261329357 6 D-24     /
      DATA BM02CS( 27) / +.3547210007 5233385230 7697134521 3 D-25     /
      DATA BM02CS( 28) / -.1119218385 8150046462 6435594217 6 D-25     /
      DATA BM02CS( 29) / +.3611879427 6298378316 9840499425 7 D-26     /
      DATA BM02CS( 30) / -.1190687765 9133331500 9264176246 3 D-26     /
      DATA BM02CS( 31) / +.4005094059 4039681318 0247644953 6 D-27     /
      DATA BM02CS( 32) / -.1373169422 4522123905 9519391601 7 D-27     /
      DATA BM02CS( 33) / +.4794199088 7425315859 9649152643 7 D-28     /
      DATA BM02CS( 34) / -.1702965627 6241095840 0699447645 2 D-28     /
      DATA BM02CS( 35) / +.6149512428 9363300715 0357516132 4 D-29     /
      DATA BM02CS( 36) / -.2255766896 5818283499 4430023724 2 D-29     /
      DATA BM02CS( 37) / +.8399707509 2942994860 6165835320 0 D-30     /
      DATA BM02CS( 38) / -.3172997595 5626023555 6742393615 2 D-30     /
      DATA BM02CS( 39) / +.1215205298 8812985545 8333302651 4 D-30     /
      DATA BM02CS( 40) / -.4715852749 7544386930 1321056804 5 D-31     /
      DATA BT02CS(  1) / -.2454829521 3424597462 0504672493 24 D+0     /
      DATA BT02CS(  2) / +.1254412103 9084615780 7853317782 99 D-2     /
      DATA BT02CS(  3) / -.3125395041 4871522854 9734467095 71 D-4     /
      DATA BT02CS(  4) / +.1470977824 9940831164 4534269693 14 D-5     /
      DATA BT02CS(  5) / -.9954348893 7950033643 4688503511 58 D-7     /
      DATA BT02CS(  6) / +.8549316673 3203041247 5787113977 51 D-8     /
      DATA BT02CS(  7) / -.8698975952 6554334557 9855121791 92 D-9     /
      DATA BT02CS(  8) / +.1005209953 3559791084 5401010821 53 D-9     /
      DATA BT02CS(  9) / -.1282823060 1708892903 4836236855 44 D-10    /
      DATA BT02CS( 10) / +.1773170078 1805131705 6557504510 23 D-11    /
      DATA BT02CS( 11) / -.2617457456 9485577488 6362841809 25 D-12    /
      DATA BT02CS( 12) / +.4082835138 9972059621 9664812211 03 D-13    /
      DATA BT02CS( 13) / -.6675166823 9742720054 6067495542 61 D-14    /
      DATA BT02CS( 14) / +.1136576139 3071629448 3924695499 51 D-14    /
      DATA BT02CS( 15) / -.2005118962 0647160250 5592664121 17 D-15    /
      DATA BT02CS( 16) / +.3649797879 4766269635 7205914641 06 D-16    /
      DATA BT02CS( 17) / -.6830963756 4582303169 3558437888 00 D-17    /
      DATA BT02CS( 18) / +.1310758314 5670756620 0571042679 46 D-17    /
      DATA BT02CS( 19) / -.2572336310 1850607778 7571306495 99 D-18    /
      DATA BT02CS( 20) / +.5152165744 1863959925 2677809493 33 D-19    /
      DATA BT02CS( 21) / -.1051301756 3758802637 9407414613 33 D-19    /
      DATA BT02CS( 22) / +.2182038199 1194813847 3010845013 33 D-20    /
      DATA BT02CS( 23) / -.4600470121 0362160577 2259054933 33 D-21    /
      DATA BT02CS( 24) / +.9840700692 5466818520 9536511999 99 D-22    /
      DATA BT02CS( 25) / -.2133403803 5728375844 7359863466 66 D-22    /
      DATA BT02CS( 26) / +.4683103642 3973365296 0662869333 33 D-23    /
      DATA BT02CS( 27) / -.1040021369 1985747236 5133823999 99 D-23    /
      DATA BT02CS( 28) / +.2334910567 7301510051 7777408000 00 D-24    /
      DATA BT02CS( 29) / -.5295682532 3318615788 0497493333 33 D-25    /
      DATA BT02CS( 30) / +.1212634195 2959756829 1962879999 99 D-25    /
      DATA BT02CS( 31) / -.2801889708 2289428760 2756266666 66 D-26    /
      DATA BT02CS( 32) / +.6529267898 7012873342 5937066666 66 D-27    /
      DATA BT02CS( 33) / -.1533798006 1873346427 8357333333 33 D-27    /
      DATA BT02CS( 34) / +.3630588430 6364536682 3594666666 66 D-28    /
      DATA BT02CS( 35) / -.8656075571 3629122479 1722666666 66 D-29    /
      DATA BT02CS( 36) / +.2077990997 2536284571 2383999999 99 D-29    /
      DATA BT02CS( 37) / -.5021117022 1417221674 3253333333 33 D-30    /
      DATA BT02CS( 38) / +.1220836027 9441714184 1919999999 99 D-30    /
      DATA BT02CS( 39) / -.2986005626 7039913454 2506666666 66 D-31    /
      DATA PI4 / 0.7853981633 9744830961 5660845819 876 D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9B0MP
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NBM0 = INITDS (BM0CS, 37, ETA)
         NBT02 = INITDS (BT02CS, 39, ETA)
         NBM02 = INITDS (BM02CS, 40, ETA)
         NBTH0 = INITDS (BTH0CS, 44, ETA)
C
         XMAX = 1.0D0/D1MACH(4)
      ENDIF
      FIRST = .FALSE.
C
      IF (X .LT. 4.D0) CALL XERMSG ('SLATEC', 'D9B0MP',
     +   'X MUST BE GE 4', 1, 2)
C
      IF (X.GT.8.D0) GO TO 20
      Z = (128.D0/(X*X) - 5.D0)/3.D0
      AMPL = (.75D0 + DCSEVL (Z, BM0CS, NBM0))/SQRT(X)
      THETA = X - PI4 + DCSEVL (Z, BT02CS, NBT02)/X
      RETURN
C
 20   IF (X .GT. XMAX) CALL XERMSG ('SLATEC', 'D9B0MP',
     +   'NO PRECISION BECAUSE X IS BIG', 2, 2)
C
      Z = 128.D0/(X*X) - 1.D0
      AMPL = (.75D0 + DCSEVL (Z, BM02CS, NBM02))/SQRT(X)
      THETA = X - PI4 + DCSEVL (Z, BTH0CS, NBTH0)/X
      RETURN
C
      END
*DECK D9B1MP
      SUBROUTINE D9B1MP (X, AMPL, THETA)
C***BEGIN PROLOGUE  D9B1MP
C***SUBSIDIARY
C***PURPOSE  Evaluate the modulus and phase for the J1 and Y1 Bessel
C            functions.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C10A1
C***TYPE      DOUBLE PRECISION (D9B1MP-D)
C***KEYWORDS  BESSEL FUNCTION, FNLIB, MODULUS, PHASE, SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Evaluate the modulus and phase for the Bessel J1 and Y1 functions.
C
C Series for BM1        on the interval  1.56250E-02 to  6.25000E-02
C                                        with weighted error   4.91E-32
C                                         log weighted error  31.31
C                               significant figures required  30.04
C                                    decimal places required  32.09
C
C Series for BT12       on the interval  1.56250E-02 to  6.25000E-02
C                                        with weighted error   3.33E-32
C                                         log weighted error  31.48
C                               significant figures required  31.05
C                                    decimal places required  32.27
C
C Series for BM12       on the interval  0.          to  1.56250E-02
C                                        with weighted error   5.01E-32
C                                         log weighted error  31.30
C                               significant figures required  29.99
C                                    decimal places required  32.10
C
C Series for BTH1       on the interval  0.          to  1.56250E-02
C                                        with weighted error   2.82E-32
C                                         log weighted error  31.55
C                               significant figures required  31.12
C                                    decimal places required  32.37
C
C***SEE ALSO  DBESJ1, DBESY1
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C   920618  Removed space from variable name and code restructured to
C           use IF-THEN-ELSE.  (RWC, WRB)
C***END PROLOGUE  D9B1MP
      DOUBLE PRECISION X, AMPL, THETA, BM1CS(37), BT12CS(39),
     1  BM12CS(40), BTH1CS(44), XMAX, PI4, Z, D1MACH, DCSEVL
      LOGICAL FIRST
      SAVE BM1CS, BT12CS, BTH1CS, BM12CS, PI4, NBM1, NBT12,
     1 NBM12, NBTH1, XMAX, FIRST
      DATA BM1CS(  1) / +.1069845452 6180630149 6998530853 8 D+0      /
      DATA BM1CS(  2) / +.3274915039 7159649007 2905514344 5 D-2      /
      DATA BM1CS(  3) / -.2987783266 8316985920 3044577793 8 D-4      /
      DATA BM1CS(  4) / +.8331237177 9919745313 9322266902 3 D-6      /
      DATA BM1CS(  5) / -.4112665690 3020073048 9638172549 8 D-7      /
      DATA BM1CS(  6) / +.2855344228 7892152207 1975766316 1 D-8      /
      DATA BM1CS(  7) / -.2485408305 4156238780 6002659605 5 D-9      /
      DATA BM1CS(  8) / +.2543393338 0725824427 4248439717 4 D-10     /
      DATA BM1CS(  9) / -.2941045772 8229675234 8975082790 9 D-11     /
      DATA BM1CS( 10) / +.3743392025 4939033092 6505615362 6 D-12     /
      DATA BM1CS( 11) / -.5149118293 8211672187 2054824352 7 D-13     /
      DATA BM1CS( 12) / +.7552535949 8651439080 3404076419 9 D-14     /
      DATA BM1CS( 13) / -.1169409706 8288464441 6629062246 4 D-14     /
      DATA BM1CS( 14) / +.1896562449 4347915717 2182460506 0 D-15     /
      DATA BM1CS( 15) / -.3201955368 6932864206 6477531639 4 D-16     /
      DATA BM1CS( 16) / +.5599548399 3162041144 8416990549 3 D-17     /
      DATA BM1CS( 17) / -.1010215894 7304324431 1939044454 4 D-17     /
      DATA BM1CS( 18) / +.1873844985 7275629833 0204271957 3 D-18     /
      DATA BM1CS( 19) / -.3563537470 3285802192 7430143999 9 D-19     /
      DATA BM1CS( 20) / +.6931283819 9712383304 2276351999 9 D-20     /
      DATA BM1CS( 21) / -.1376059453 4065001522 5140893013 3 D-20     /
      DATA BM1CS( 22) / +.2783430784 1070802205 9977932799 9 D-21     /
      DATA BM1CS( 23) / -.5727595364 3205616893 4866943999 9 D-22     /
      DATA BM1CS( 24) / +.1197361445 9188926725 3575679999 9 D-22     /
      DATA BM1CS( 25) / -.2539928509 8918719766 4144042666 6 D-23     /
      DATA BM1CS( 26) / +.5461378289 6572959730 6961919999 9 D-24     /
      DATA BM1CS( 27) / -.1189211341 7733202889 8628949333 3 D-24     /
      DATA BM1CS( 28) / +.2620150977 3400815949 5782400000 0 D-25     /
      DATA BM1CS( 29) / -.5836810774 2556859019 2093866666 6 D-26     /
      DATA BM1CS( 30) / +.1313743500 0805957734 2361599999 9 D-26     /
      DATA BM1CS( 31) / -.2985814622 5103803553 3277866666 6 D-27     /
      DATA BM1CS( 32) / +.6848390471 3346049376 2559999999 9 D-28     /
      DATA BM1CS( 33) / -.1584401568 2224767211 9296000000 0 D-28     /
      DATA BM1CS( 34) / +.3695641006 5709380543 0101333333 3 D-29     /
      DATA BM1CS( 35) / -.8687115921 1446682430 1226666666 6 D-30     /
      DATA BM1CS( 36) / +.2057080846 1587634629 2906666666 6 D-30     /
      DATA BM1CS( 37) / -.4905225761 1162255185 2373333333 3 D-31     /
      DATA BT12CS(  1) / +.7382386012 8742974662 6208397927 64 D+0     /
      DATA BT12CS(  2) / -.3336111317 4483906384 4701476811 89 D-2     /
      DATA BT12CS(  3) / +.6146345488 8046964698 5148994201 86 D-4     /
      DATA BT12CS(  4) / -.2402458516 1602374264 9776354695 68 D-5     /
      DATA BT12CS(  5) / +.1466355557 7509746153 2105919972 04 D-6     /
      DATA BT12CS(  6) / -.1184191730 5589180567 0051475049 83 D-7     /
      DATA BT12CS(  7) / +.1157419896 3919197052 1254663030 55 D-8     /
      DATA BT12CS(  8) / -.1300116112 9439187449 3660077945 71 D-9     /
      DATA BT12CS(  9) / +.1624539114 1361731937 7421662736 67 D-10    /
      DATA BT12CS( 10) / -.2208963682 1403188752 1554417701 28 D-11    /
      DATA BT12CS( 11) / +.3218030425 8553177090 4743586537 78 D-12    /
      DATA BT12CS( 12) / -.4965314793 2768480785 5520211353 81 D-13    /
      DATA BT12CS( 13) / +.8043890043 2847825985 5588826393 17 D-14    /
      DATA BT12CS( 14) / -.1358912131 0161291384 6947126822 82 D-14    /
      DATA BT12CS( 15) / +.2381050439 7147214869 6765296059 73 D-15    /
      DATA BT12CS( 16) / -.4308146636 3849106724 4712414207 99 D-16    /
      DATA BT12CS( 17) / +.8020254403 2771002434 9935125504 00 D-17    /
      DATA BT12CS( 18) / -.1531631064 2462311864 2300274687 99 D-17    /
      DATA BT12CS( 19) / +.2992860635 2715568924 0730405546 66 D-18    /
      DATA BT12CS( 20) / -.5970996465 8085443393 8156366506 66 D-19    /
      DATA BT12CS( 21) / +.1214028966 9415185024 1608526506 66 D-19    /
      DATA BT12CS( 22) / -.2511511469 6612948901 0069777066 66 D-20    /
      DATA BT12CS( 23) / +.5279056717 0328744850 7383807999 99 D-21    /
      DATA BT12CS( 24) / -.1126050922 7550498324 3611613866 66 D-21    /
      DATA BT12CS( 25) / +.2434827735 9576326659 6634624000 00 D-22    /
      DATA BT12CS( 26) / -.5331726123 6931800130 0384426666 66 D-23    /
      DATA BT12CS( 27) / +.1181361505 9707121039 2059903999 99 D-23    /
      DATA BT12CS( 28) / -.2646536828 3353523514 8567893333 33 D-24    /
      DATA BT12CS( 29) / +.5990339404 1361503945 5778133333 33 D-25    /
      DATA BT12CS( 30) / -.1369085463 0829503109 1363839999 99 D-25    /
      DATA BT12CS( 31) / +.3157679015 4380228326 4136533333 33 D-26    /
      DATA BT12CS( 32) / -.7345791508 2084356491 4005333333 33 D-27    /
      DATA BT12CS( 33) / +.1722808148 0722747930 7059200000 00 D-27    /
      DATA BT12CS( 34) / -.4071690796 1286507941 0688000000 00 D-28    /
      DATA BT12CS( 35) / +.9693474513 6779622700 3733333333 33 D-29    /
      DATA BT12CS( 36) / -.2323763633 7765716765 3546666666 66 D-29    /
      DATA BT12CS( 37) / +.5607451067 3522029406 8906666666 66 D-30    /
      DATA BT12CS( 38) / -.1361646539 1539005860 5226666666 66 D-30    /
      DATA BT12CS( 39) / +.3326310923 3894654388 9066666666 66 D-31    /
      DATA BM12CS(  1) / +.9807979156 2330500272 7209354693 7 D-1      /
      DATA BM12CS(  2) / +.1150961189 5046853061 7548348460 2 D-2      /
      DATA BM12CS(  3) / -.4312482164 3382054098 8935809773 2 D-5      /
      DATA BM12CS(  4) / +.5951839610 0888163078 1302980183 2 D-7      /
      DATA BM12CS(  5) / -.1704844019 8269098574 0070158647 8 D-8      /
      DATA BM12CS(  6) / +.7798265413 6111095086 5817382740 1 D-10     /
      DATA BM12CS(  7) / -.4958986126 7664158094 9175495186 5 D-11     /
      DATA BM12CS(  8) / +.4038432416 4211415168 3820226514 4 D-12     /
      DATA BM12CS(  9) / -.3993046163 7251754457 6548384664 5 D-13     /
      DATA BM12CS( 10) / +.4619886183 1189664943 1334243277 5 D-14     /
      DATA BM12CS( 11) / -.6089208019 0953833013 4547261933 3 D-15     /
      DATA BM12CS( 12) / +.8960930916 4338764821 5704804124 9 D-16     /
      DATA BM12CS( 13) / -.1449629423 9420231229 1651891892 5 D-16     /
      DATA BM12CS( 14) / +.2546463158 5377760561 6514964806 8 D-17     /
      DATA BM12CS( 15) / -.4809472874 6478364442 5926371862 0 D-18     /
      DATA BM12CS( 16) / +.9687684668 2925990490 8727583912 4 D-19     /
      DATA BM12CS( 17) / -.2067213372 2779660232 4503811755 1 D-19     /
      DATA BM12CS( 18) / +.4646651559 1503847318 0276780959 0 D-20     /
      DATA BM12CS( 19) / -.1094966128 8483341382 4135132833 9 D-20     /
      DATA BM12CS( 20) / +.2693892797 2886828609 0570761278 5 D-21     /
      DATA BM12CS( 21) / -.6894992910 9303744778 1897002685 7 D-22     /
      DATA BM12CS( 22) / +.1830268262 7520629098 9066855474 0 D-22     /
      DATA BM12CS( 23) / -.5025064246 3519164281 5611355322 4 D-23     /
      DATA BM12CS( 24) / +.1423545194 4548060396 3169363419 4 D-23     /
      DATA BM12CS( 25) / -.4152191203 6164503880 6888676980 1 D-24     /
      DATA BM12CS( 26) / +.1244609201 5039793258 8233007654 7 D-24     /
      DATA BM12CS( 27) / -.3827336370 5693042994 3191866128 6 D-25     /
      DATA BM12CS( 28) / +.1205591357 8156175353 7472398183 5 D-25     /
      DATA BM12CS( 29) / -.3884536246 3764880764 3185936112 4 D-26     /
      DATA BM12CS( 30) / +.1278689528 7204097219 0489528346 1 D-26     /
      DATA BM12CS( 31) / -.4295146689 4479462720 6193691591 2 D-27     /
      DATA BM12CS( 32) / +.1470689117 8290708864 5680270798 3 D-27     /
      DATA BM12CS( 33) / -.5128315665 1060731281 8037401779 6 D-28     /
      DATA BM12CS( 34) / +.1819509585 4711693854 8143737328 6 D-28     /
      DATA BM12CS( 35) / -.6563031314 8419808676 1863505037 3 D-29     /
      DATA BM12CS( 36) / +.2404898976 9199606531 9891487583 4 D-29     /
      DATA BM12CS( 37) / -.8945966744 6906124732 3495824297 9 D-30     /
      DATA BM12CS( 38) / +.3376085160 6572310266 3714897824 0 D-30     /
      DATA BM12CS( 39) / -.1291791454 6206563609 1309991696 6 D-30     /
      DATA BM12CS( 40) / +.5008634462 9588105206 8495150125 4 D-31     /
      DATA BTH1CS(  1) / +.7474995720 3587276055 4434839696 95 D+0     /
      DATA BTH1CS(  2) / -.1240077714 4651711252 5457775413 84 D-2     /
      DATA BTH1CS(  3) / +.9925244240 4424527376 6414976895 92 D-5     /
      DATA BTH1CS(  4) / -.2030369073 7159711052 4193753756 08 D-6     /
      DATA BTH1CS(  5) / +.7535961770 5690885712 1840175836 29 D-8     /
      DATA BTH1CS(  6) / -.4166161271 5343550107 6300238562 28 D-9     /
      DATA BTH1CS(  7) / +.3070161807 0834890481 2451020912 16 D-10    /
      DATA BTH1CS(  8) / -.2817849963 7605213992 3240088839 24 D-11    /
      DATA BTH1CS(  9) / +.3079069673 9040295476 0281468216 47 D-12    /
      DATA BTH1CS( 10) / -.3880330026 2803434112 7873475547 81 D-13    /
      DATA BTH1CS( 11) / +.5509603960 8630904934 5617262085 62 D-14    /
      DATA BTH1CS( 12) / -.8659006076 8383779940 1033989539 94 D-15    /
      DATA BTH1CS( 13) / +.1485604914 1536749003 4236890606 83 D-15    /
      DATA BTH1CS( 14) / -.2751952981 5904085805 3712121250 09 D-16    /
      DATA BTH1CS( 15) / +.5455079609 0481089625 0362236409 23 D-17    /
      DATA BTH1CS( 16) / -.1148653450 1983642749 5436310271 77 D-17    /
      DATA BTH1CS( 17) / +.2553521337 7973900223 1990525335 22 D-18    /
      DATA BTH1CS( 18) / -.5962149019 7413450395 7682879078 49 D-19    /
      DATA BTH1CS( 19) / +.1455662290 2372718620 2883020058 33 D-19    /
      DATA BTH1CS( 20) / -.3702218542 2450538201 5797760195 93 D-20    /
      DATA BTH1CS( 21) / +.9776307412 5345357664 1684345179 24 D-21    /
      DATA BTH1CS( 22) / -.2672682163 9668488468 7237753930 52 D-21    /
      DATA BTH1CS( 23) / +.7545330038 4983271794 0381906557 64 D-22    /
      DATA BTH1CS( 24) / -.2194789991 9802744897 8923833716 47 D-22    /
      DATA BTH1CS( 25) / +.6564839462 3955262178 9069998174 93 D-23    /
      DATA BTH1CS( 26) / -.2015560429 8370207570 7840768695 19 D-23    /
      DATA BTH1CS( 27) / +.6341776855 6776143492 1446671856 70 D-24    /
      DATA BTH1CS( 28) / -.2041927788 5337895634 8137699555 91 D-24    /
      DATA BTH1CS( 29) / +.6719146422 0720567486 6589800185 51 D-25    /
      DATA BTH1CS( 30) / -.2256907911 0207573595 7090036873 36 D-25    /
      DATA BTH1CS( 31) / +.7729771989 2989706370 9269598719 29 D-26    /
      DATA BTH1CS( 32) / -.2696744451 2294640913 2114240809 20 D-26    /
      DATA BTH1CS( 33) / +.9574934451 8502698072 2955219336 27 D-27    /
      DATA BTH1CS( 34) / -.3456916844 8890113000 1756808276 27 D-27    /
      DATA BTH1CS( 35) / +.1268123481 7398436504 2119862383 74 D-27    /
      DATA BTH1CS( 36) / -.4723253663 0722639860 4649937134 45 D-28    /
      DATA BTH1CS( 37) / +.1785000847 8186376177 8586197964 17 D-28    /
      DATA BTH1CS( 38) / -.6840436100 4510395406 2152235667 46 D-29    /
      DATA BTH1CS( 39) / +.2656602867 1720419358 2934226722 12 D-29    /
      DATA BTH1CS( 40) / -.1045040252 7914452917 7141614846 70 D-29    /
      DATA BTH1CS( 41) / +.4161829082 5377144306 8619171970 64 D-30    /
      DATA BTH1CS( 42) / -.1677163920 3643714856 5013478828 87 D-30    /
      DATA BTH1CS( 43) / +.6836199777 6664389173 5359280285 28 D-31    /
      DATA BTH1CS( 44) / -.2817224786 1233641166 7395746228 10 D-31    /
      DATA PI4 / 0.7853981633 9744830961 5660845819 876 D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9B1MP
      IF (FIRST) THEN
         ETA = 0.1*REAL(D1MACH(3))
         NBM1 = INITDS (BM1CS, 37, ETA)
         NBT12 = INITDS (BT12CS, 39, ETA)
         NBM12 = INITDS (BM12CS, 40, ETA)
         NBTH1 = INITDS (BTH1CS, 44, ETA)
C
         XMAX = 1.0D0/D1MACH(4)
      ENDIF
      FIRST = .FALSE.
C
      IF (X .LT. 4.0D0) THEN
         CALL XERMSG ('SLATEC', 'D9B1MP', 'X must be .GE. 4', 1, 2)
         AMPL = 0.0D0
         THETA = 0.0D0
      ELSE IF (X .LE. 8.0D0) THEN
         Z = (128.0D0/(X*X) - 5.0D0)/3.0D0
         AMPL = (0.75D0 + DCSEVL (Z, BM1CS, NBM1))/SQRT(X)
         THETA = X - 3.0D0*PI4 + DCSEVL (Z, BT12CS, NBT12)/X
      ELSE
         IF (X .GT. XMAX) CALL XERMSG ('SLATEC', 'D9B1MP',
     +      'No precision because X is too big', 2, 2)
C
         Z = 128.0D0/(X*X) - 1.0D0
         AMPL = (0.75D0 + DCSEVL (Z, BM12CS, NBM12))/SQRT(X)
         THETA = X - 3.0D0*PI4 + DCSEVL (Z, BTH1CS, NBTH1)/X
      ENDIF
      RETURN
      END
*DECK D9CHU
      DOUBLE PRECISION FUNCTION D9CHU (A, B, Z)
C***BEGIN PROLOGUE  D9CHU
C***SUBSIDIARY
C***PURPOSE  Evaluate for large Z  Z**A * U(A,B,Z) where U is the
C            logarithmic confluent hypergeometric function.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C11
C***TYPE      DOUBLE PRECISION (R9CHU-S, D9CHU-D)
C***KEYWORDS  FNLIB, LOGARITHMIC CONFLUENT HYPERGEOMETRIC FUNCTION,
C             SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Evaluate for large Z  Z**A * U(A,B,Z)  where U is the logarithmic
C confluent hypergeometric function.  A rational approximation due to Y.
C L. Luke is used.  When U is not in the asymptotic region, i.e., when A
C or B is large compared with Z, considerable significance loss occurs.
C A warning is provided when the computed result is less than half
C precision.
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770801  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9CHU
      DOUBLE PRECISION A, B, Z, AA(4), BB(4), AB, ANBN, BP, CT1, CT2,
     1  CT3, C2, D1Z, EPS, G1, G2, G3, SAB, SQEPS, X2I1,  D1MACH
      LOGICAL FIRST
      SAVE EPS, SQEPS, FIRST
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9CHU
      IF (FIRST) THEN
         EPS = 4.0D0*D1MACH(4)
         SQEPS = SQRT(D1MACH(4))
      ENDIF
      FIRST = .FALSE.
C
      BP = 1.0D0 + A - B
      AB = A*BP
      CT2 = 2.0D0 * (Z - AB)
      SAB = A + BP
C
      BB(1) = 1.0D0
      AA(1) = 1.0D0
C
      CT3 = SAB + 1.0D0 + AB
      BB(2) = 1.0D0 + 2.0D0*Z/CT3
      AA(2) = 1.0D0 + CT2/CT3
C
      ANBN = CT3 + SAB + 3.0D0
      CT1 = 1.0D0 + 2.0D0*Z/ANBN
      BB(3) = 1.0D0 + 6.0D0*CT1*Z/CT3
      AA(3) = 1.0D0 + 6.0D0*AB/ANBN + 3.0D0*CT1*CT2/CT3
C
      DO 30 I=4,300
        X2I1 = 2*I - 3
        CT1 = X2I1/(X2I1-2.0D0)
        ANBN = ANBN + X2I1 + SAB
        CT2 = (X2I1 - 1.0D0)/ANBN
        C2 = X2I1*CT2 - 1.0D0
        D1Z = X2I1*2.0D0*Z/ANBN
C
        CT3 = SAB*CT2
        G1 = D1Z + CT1*(C2+CT3)
        G2 = D1Z - C2
        G3 = CT1*(1.0D0 - CT3 - 2.0D0*CT2)
C
        BB(4) = G1*BB(3) + G2*BB(2) + G3*BB(1)
        AA(4) = G1*AA(3) + G2*AA(2) + G3*AA(1)
        IF (ABS(AA(4)*BB(1)-AA(1)*BB(4)).LT.EPS*ABS(BB(4)*BB(1)))
     1    GO TO 40
C
C IF OVERFLOWS OR UNDERFLOWS PROVE TO BE A PROBLEM, THE STATEMENTS
C BELOW COULD BE ALTERED TO INCORPORATE A DYNAMICALLY ADJUSTED SCALE
C FACTOR.
C
        DO 20 J=1,3
          AA(J) = AA(J+1)
          BB(J) = BB(J+1)
 20     CONTINUE
 30   CONTINUE
      CALL XERMSG ('SLATEC', 'D9CHU', 'NO CONVERGENCE IN 300 TERMS', 2,
     +   2)
C
 40   D9CHU = AA(4)/BB(4)
C
      IF (D9CHU .LT. SQEPS .OR. D9CHU .GT. 1.0D0/SQEPS) CALL XERMSG
     +   ('SLATEC', 'D9CHU', 'ANSWER LT HALF PRECISION', 2, 1)
C
      RETURN
      END
*DECK D9GMIC
      DOUBLE PRECISION FUNCTION D9GMIC (A, X, ALX)
C***BEGIN PROLOGUE  D9GMIC
C***SUBSIDIARY
C***PURPOSE  Compute the complementary incomplete Gamma function for A
C            near a negative integer and X small.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C7E
C***TYPE      DOUBLE PRECISION (R9GMIC-S, D9GMIC-D)
C***KEYWORDS  COMPLEMENTARY INCOMPLETE GAMMA FUNCTION, FNLIB, SMALL X,
C             SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Compute the complementary incomplete gamma function for A near
C a negative integer and for small X.
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DLNGAM, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890911  Removed unnecessary intrinsics.  (WRB)
C   890911  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9GMIC
      DOUBLE PRECISION A, X, ALX, ALNG, BOT, EPS, EULER, FK, FKP1, FM,
     1  S, SGNG, T, TE, D1MACH, DLNGAM
      LOGICAL FIRST
      SAVE EULER, EPS, BOT, FIRST
      DATA EULER / 0.5772156649 0153286060 6512090082 40 D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9GMIC
      IF (FIRST) THEN
         EPS = 0.5D0*D1MACH(3)
         BOT = LOG (D1MACH(1))
      ENDIF
      FIRST = .FALSE.
C
      IF (A .GT. 0.D0) CALL XERMSG ('SLATEC', 'D9GMIC',
     +   'A MUST BE NEAR A NEGATIVE INTEGER', 2, 2)
      IF (X .LE. 0.D0) CALL XERMSG ('SLATEC', 'D9GMIC',
     +   'X MUST BE GT ZERO', 3, 2)
C
      M = -(A - 0.5D0)
      FM = M
C
      TE = 1.0D0
      T = 1.0D0
      S = T
      DO 20 K=1,200
        FKP1 = K + 1
        TE = -X*TE/(FM+FKP1)
        T = TE/FKP1
        S = S + T
        IF (ABS(T).LT.EPS*S) GO TO 30
 20   CONTINUE
      CALL XERMSG ('SLATEC', 'D9GMIC',
     +   'NO CONVERGENCE IN 200 TERMS OF CONTINUED FRACTION', 4, 2)
C
 30   D9GMIC = -ALX - EULER + X*S/(FM+1.0D0)
      IF (M.EQ.0) RETURN
C
      IF (M.EQ.1) D9GMIC = -D9GMIC - 1.D0 + 1.D0/X
      IF (M.EQ.1) RETURN
C
      TE = FM
      T = 1.D0
      S = T
      MM1 = M - 1
      DO 40 K=1,MM1
        FK = K
        TE = -X*TE/FK
        T = TE/(FM-FK)
        S = S + T
        IF (ABS(T).LT.EPS*ABS(S)) GO TO 50
 40   CONTINUE
C
 50   DO 60 K=1,M
        D9GMIC = D9GMIC + 1.0D0/K
 60   CONTINUE
C
      SGNG = 1.0D0
      IF (MOD(M,2).EQ.1) SGNG = -1.0D0
      ALNG = LOG(D9GMIC) - DLNGAM(FM+1.D0)
C
      D9GMIC = 0.D0
      IF (ALNG.GT.BOT) D9GMIC = SGNG * EXP(ALNG)
      IF (S.NE.0.D0) D9GMIC = D9GMIC +
     1  SIGN (EXP(-FM*ALX+LOG(ABS(S)/FM)), S)
C
      IF (D9GMIC .EQ. 0.D0 .AND. S .EQ. 0.D0) CALL XERMSG ('SLATEC',
     +   'D9GMIC', 'RESULT UNDERFLOWS', 1, 1)
      RETURN
C
      END
*DECK D9GMIT
      DOUBLE PRECISION FUNCTION D9GMIT (A, X, ALGAP1, SGNGAM, ALX)
C***BEGIN PROLOGUE  D9GMIT
C***SUBSIDIARY
C***PURPOSE  Compute Tricomi's incomplete Gamma function for small
C            arguments.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C7E
C***TYPE      DOUBLE PRECISION (R9GMIT-S, D9GMIT-D)
C***KEYWORDS  COMPLEMENTARY INCOMPLETE GAMMA FUNCTION, FNLIB, SMALL X,
C             SPECIAL FUNCTIONS, TRICOMI
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Compute Tricomi's incomplete gamma function for small X.
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DLNGAM, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890911  Removed unnecessary intrinsics.  (WRB)
C   890911  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9GMIT
      DOUBLE PRECISION A, X, ALGAP1, SGNGAM, ALX, AE, AEPS, ALGS, ALG2,
     1  BOT, EPS, FK, S, SGNG2, T, TE, D1MACH, DLNGAM
      LOGICAL FIRST
      SAVE EPS, BOT, FIRST
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9GMIT
      IF (FIRST) THEN
         EPS = 0.5D0*D1MACH(3)
         BOT = LOG (D1MACH(1))
      ENDIF
      FIRST = .FALSE.
C
      IF (X .LE. 0.D0) CALL XERMSG ('SLATEC', 'D9GMIT',
     +   'X SHOULD BE GT 0', 1, 2)
C
      MA = A + 0.5D0
      IF (A.LT.0.D0) MA = A - 0.5D0
      AEPS = A - MA
C
      AE = A
      IF (A.LT.(-0.5D0)) AE = AEPS
C
      T = 1.D0
      TE = AE
      S = T
      DO 20 K=1,200
        FK = K
        TE = -X*TE/FK
        T = TE/(AE+FK)
        S = S + T
        IF (ABS(T).LT.EPS*ABS(S)) GO TO 30
 20   CONTINUE
      CALL XERMSG ('SLATEC', 'D9GMIT',
     +   'NO CONVERGENCE IN 200 TERMS OF TAYLOR-S SERIES', 2, 2)
C
 30   IF (A.GE.(-0.5D0)) ALGS = -ALGAP1 + LOG(S)
      IF (A.GE.(-0.5D0)) GO TO 60
C
      ALGS = -DLNGAM(1.D0+AEPS) + LOG(S)
      S = 1.0D0
      M = -MA - 1
      IF (M.EQ.0) GO TO 50
      T = 1.0D0
      DO 40 K=1,M
        T = X*T/(AEPS-(M+1-K))
        S = S + T
        IF (ABS(T).LT.EPS*ABS(S)) GO TO 50
 40   CONTINUE
C
 50   D9GMIT = 0.0D0
      ALGS = -MA*LOG(X) + ALGS
      IF (S.EQ.0.D0 .OR. AEPS.EQ.0.D0) GO TO 60
C
      SGNG2 = SGNGAM * SIGN (1.0D0, S)
      ALG2 = -X - ALGAP1 + LOG(ABS(S))
C
      IF (ALG2.GT.BOT) D9GMIT = SGNG2 * EXP(ALG2)
      IF (ALGS.GT.BOT) D9GMIT = D9GMIT + EXP(ALGS)
      RETURN
C
 60   D9GMIT = EXP (ALGS)
      RETURN
C
      END
*DECK D9KNUS
      SUBROUTINE D9KNUS (XNU, X, BKNU, BKNU1, ISWTCH)
C***BEGIN PROLOGUE  D9KNUS
C***SUBSIDIARY
C***PURPOSE  Compute Bessel functions EXP(X)*K-SUB-XNU(X) and EXP(X)*
C            K-SUB-XNU+1(X) for 0.0 .LE. XNU .LT. 1.0.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C10B3
C***TYPE      DOUBLE PRECISION (R9KNUS-S, D9KNUS-D)
C***KEYWORDS  BESSEL FUNCTION, FNLIB, SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Compute Bessel functions EXP(X) * K-sub-XNU (X)  and
C EXP(X) * K-sub-XNU+1 (X) for 0.0 .LE. XNU .LT. 1.0 .
C
C Series for C0K        on the interval  0.          to  2.50000E-01
C                                        with weighted error   2.16E-32
C                                         log weighted error  31.67
C                               significant figures required  30.86
C                                    decimal places required  32.40
C
C Series for ZNU1       on the interval -7.00000E-01 to  0.
C                                        with weighted error   2.45E-33
C                                         log weighted error  32.61
C                               significant figures required  31.85
C                                    decimal places required  33.26
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, DGAMMA, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770601  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890911  Removed unnecessary intrinsics.  (WRB)
C   890911  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C   900727  Added EXTERNAL statement.  (WRB)
C   920618  Removed space from variable names.  (RWC, WRB)
C***END PROLOGUE  D9KNUS
      DOUBLE PRECISION XNU, X, BKNU, BKNU1, ALPHA(32), BETA(32), A(32),
     1  C0KCS(29), ZNU1CS(20), ALNZ, ALN2, A0, BKNUD, BKNU0,
     2  B0, C0, EULER, EXPX, P1, P2, P3, QQ, RESULT, SQPI2, SQRTX, V,
     3  VLNZ, XI, XMU, XNUSML, XSML, X2N, X2TOV, Z, ZTOV, ALNSML,
     4  ALNBIG
      REAL ALNEPS
      DOUBLE PRECISION D1MACH, DCSEVL, DGAMMA
      LOGICAL FIRST
      EXTERNAL DGAMMA
      SAVE C0KCS, ZNU1CS, EULER, SQPI2, ALN2, NTC0K,
     1 NTZNU1, XNUSML, XSML, ALNSML, ALNBIG, ALNEPS, FIRST
      DATA C0KCS(  1) / +.6018305724 2626108387 5774451803 29 D-1     /
      DATA C0KCS(  2) / -.1536487143 3017286092 9597559431 24 D+0     /
      DATA C0KCS(  3) / -.1175117600 8210492040 0682292262 13 D-1     /
      DATA C0KCS(  4) / -.8524878889 1979509827 0484015509 87 D-3     /
      DATA C0KCS(  5) / -.6132983876 7496791874 0981769221 11 D-4     /
      DATA C0KCS(  6) / -.4405228124 5510444562 6798895485 05 D-5     /
      DATA C0KCS(  7) / -.3163124672 8384488192 9154458921 99 D-6     /
      DATA C0KCS(  8) / -.2271071938 2899588330 6737717933 96 D-7     /
      DATA C0KCS(  9) / -.1630564460 8077609552 2746205153 60 D-8     /
      DATA C0KCS( 10) / -.1170693929 9414776568 7560440431 30 D-9     /
      DATA C0KCS( 11) / -.8405206378 6464437174 5465934137 92 D-11    /
      DATA C0KCS( 12) / -.6034667011 8979991487 0960507371 98 D-12    /
      DATA C0KCS( 13) / -.4332696033 5681371952 0459973669 03 D-13    /
      DATA C0KCS( 14) / -.3110735803 0203546214 6346977722 37 D-14    /
      DATA C0KCS( 15) / -.2233407822 6736982254 4861334098 40 D-15    /
      DATA C0KCS( 16) / -.1603514671 6864226300 6357915286 10 D-16    /
      DATA C0KCS( 17) / -.1151271736 3666556196 0356977053 05 D-17    /
      DATA C0KCS( 18) / -.8265759174 6836959105 1694790892 58 D-19    /
      DATA C0KCS( 19) / -.5934548080 6383948172 3334366959 84 D-20    /
      DATA C0KCS( 20) / -.4260813819 6467143926 4996130239 76 D-21    /
      DATA C0KCS( 21) / -.3059126686 4812876299 2636983705 42 D-22    /
      DATA C0KCS( 22) / -.2196354142 6734575224 9755018155 16 D-23    /
      DATA C0KCS( 23) / -.1576911326 1495836071 1057506847 60 D-24    /
      DATA C0KCS( 24) / -.1132171393 5950320948 7577310480 56 D-25    /
      DATA C0KCS( 25) / -.8128624883 4598404082 7923497144 33 D-27    /
      DATA C0KCS( 26) / -.5836090089 3453226552 8293493159 49 D-28    /
      DATA C0KCS( 27) / -.4190124162 3610922519 4523377809 05 D-29    /
      DATA C0KCS( 28) / -.3008373796 0206435069 5305042128 62 D-30    /
      DATA C0KCS( 29) / -.2159915206 7808647728 3421680898 32 D-31    /
      DATA ZNU1CS(  1) / +.2033067569 9419172967 4444001216 911 D+0    /
      DATA ZNU1CS(  2) / +.1400779334 1321977106 2943670790 563 D+0    /
      DATA ZNU1CS(  3) / +.7916796961 0016135284 0972241972 320 D-2    /
      DATA ZNU1CS(  4) / +.3398011825 3210404535 2930092205 750 D-3    /
      DATA ZNU1CS(  5) / +.1174197568 8989336666 4507228352 690 D-4    /
      DATA ZNU1CS(  6) / +.3393575706 1226168033 3825865475 121 D-6    /
      DATA ZNU1CS(  7) / +.8425941769 7621991019 4629891264 803 D-8    /
      DATA ZNU1CS(  8) / +.1833366770 2485008918 4748150900 090 D-9    /
      DATA ZNU1CS(  9) / +.3549698447 0441631086 3007064469 557 D-11   /
      DATA ZNU1CS( 10) / +.6190324964 6988733220 5244342078 407 D-13   /
      DATA ZNU1CS( 11) / +.9819645356 8043942496 0346115456 527 D-15   /
      DATA ZNU1CS( 12) / +.1428513143 9649047421 1473563005 985 D-16   /
      DATA ZNU1CS( 13) / +.1918949218 8782529896 6162467488 436 D-18   /
      DATA ZNU1CS( 14) / +.2394309797 3949891416 2313140597 128 D-20   /
      DATA ZNU1CS( 15) / +.2788902468 1534735483 5870465474 995 D-22   /
      DATA ZNU1CS( 16) / +.3046066506 3303344258 2845214092 865 D-24   /
      DATA ZNU1CS( 17) / +.3131732370 4219181577 1564260932 089 D-26   /
      DATA ZNU1CS( 18) / +.3041330989 8785495164 5174908005 034 D-28   /
      DATA ZNU1CS( 19) / +.2798403846 3683308434 3185097659 733 D-30   /
      DATA ZNU1CS( 20) / +.2446371862 7449759648 5238794922 666 D-32   /
      DATA EULER / 0.5772156649 0153286060 6512090082 40D0 /
      DATA SQPI2 / +1.253314137 3155002512 0788264240 55 D0      /
      DATA ALN2 / 0.6931471805 5994530941 7232121458 18D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9KNUS
      IF (FIRST) THEN
         ETA = 0.1D0*D1MACH(3)
         NTC0K = INITDS (C0KCS, 29, ETA)
         NTZNU1 = INITDS (ZNU1CS, 20, ETA)
C
         XNUSML = SQRT(D1MACH(3)/8.D0)
         XSML = 0.1D0*D1MACH(3)
         ALNSML = LOG (D1MACH(1))
         ALNBIG = LOG (D1MACH(2))
         ALNEPS = LOG (0.1D0*D1MACH(3))
      ENDIF
      FIRST = .FALSE.
C
      IF (XNU .LT. 0.D0 .OR. XNU .GE. 1.D0) CALL XERMSG ('SLATEC',
     +   'D9KNUS', 'XNU MUST BE GE 0 AND LT 1', 1, 2)
      IF (X .LE. 0.) CALL XERMSG ('SLATEC', 'D9KNUS', 'X MUST BE GT 0',
     +   2, 2)
C
      ISWTCH = 0
      IF (X.GT.2.0D0) GO TO 50
C
C X IS SMALL.  COMPUTE K-SUB-XNU (X) AND THE DERIVATIVE OF K-SUB-XNU (X)
C THEN FIND K-SUB-XNU+1 (X).  XNU IS REDUCED TO THE INTERVAL (-.5,+.5)
C THEN TO (0., .5), BECAUSE K OF NEGATIVE ORDER (-NU) = K OF POSITIVE
C ORDER (+NU).
C
      V = XNU
      IF (XNU.GT.0.5D0) V = 1.0D0 - XNU
C
C CAREFULLY FIND (X/2)**XNU AND Z**XNU WHERE Z = X*X/4.
      ALNZ = 2.D0 * (LOG(X) - ALN2)
C
      IF (X.GT.XNU) GO TO 20
      IF (-0.5D0*XNU*ALNZ-ALN2-LOG(XNU) .GT. ALNBIG) CALL XERMSG
     +   ('SLATEC', 'D9KNUS', 'X SO SMALL BESSEL K-SUB-XNU OVERFLOWS',
     +   3, 2)
C
 20   VLNZ = V*ALNZ
      X2TOV = EXP (0.5D0*VLNZ)
      ZTOV = 0.0D0
      IF (VLNZ.GT.ALNSML) ZTOV = X2TOV**2
C
      A0 = 0.5D0*DGAMMA(1.0D0+V)
      B0 = 0.5D0*DGAMMA(1.0D0-V)
      C0 = -EULER
      IF (ZTOV.GT.0.5D0 .AND. V.GT.XNUSML) C0 = -0.75D0 +
     1  DCSEVL ((8.0D0*V)*V-1.0D0, C0KCS, NTC0K)
C
      IF (ZTOV.LE.0.5D0) ALPHA(1) = (A0-ZTOV*B0)/V
      IF (ZTOV.GT.0.5D0) ALPHA(1) = C0 - ALNZ*(0.75D0 +
     1  DCSEVL (VLNZ/0.35D0+1.0D0, ZNU1CS, NTZNU1))*B0
      BETA(1) = -0.5D0*(A0+ZTOV*B0)
C
      Z = 0.0D0
      IF (X.GT.XSML) Z = 0.25D0*X*X
      NTERMS = MAX (2.0, 11.0+(8.*REAL(ALNZ)-25.19-ALNEPS)
     1  /(4.28-REAL(ALNZ)))
      DO 30 I=2,NTERMS
        XI = I - 1
        A0 = A0/(XI*(XI-V))
        B0 = B0/(XI*(XI+V))
        ALPHA(I) = (ALPHA(I-1)+2.0D0*XI*A0)/(XI*(XI+V))
        BETA(I) = (XI-0.5D0*V)*ALPHA(I) - ZTOV*B0
 30   CONTINUE
C
      BKNU = ALPHA(NTERMS)
      BKNUD = BETA(NTERMS)
      DO 40 II=2,NTERMS
        I = NTERMS + 1 - II
        BKNU = ALPHA(I) + BKNU*Z
        BKNUD = BETA(I) + BKNUD*Z
 40   CONTINUE
C
      EXPX = EXP(X)
      BKNU = EXPX*BKNU/X2TOV
C
      IF (-0.5D0*(XNU+1.D0)*ALNZ-2.0D0*ALN2.GT.ALNBIG) ISWTCH = 1
      IF (ISWTCH.EQ.1) RETURN
      BKNUD = EXPX*BKNUD*2.0D0/(X2TOV*X)
C
      IF (XNU.LE.0.5D0) BKNU1 = V*BKNU/X - BKNUD
      IF (XNU.LE.0.5D0) RETURN
C
      BKNU0 = BKNU
      BKNU = -V*BKNU/X - BKNUD
      BKNU1 = 2.0D0*XNU*BKNU/X + BKNU0
      RETURN
C
C X IS LARGE.  FIND K-SUB-XNU (X) AND K-SUB-XNU+1 (X) WITH Y. L. LUKE-S
C RATIONAL EXPANSION.
C
 50   SQRTX = SQRT(X)
      IF (X.GT.1.0D0/XSML) GO TO 90
      AN = -0.60 - 1.02/REAL(X)
      BN = -0.27 - 0.53/REAL(X)
      NTERMS = MIN (32, MAX1 (3.0, AN+BN*ALNEPS))
C
      DO 80 INU=1,2
        XMU = 0.D0
        IF (INU.EQ.1 .AND. XNU.GT.XNUSML) XMU = (4.0D0*XNU)*XNU
        IF (INU.EQ.2) XMU = 4.0D0*(ABS(XNU)+1.D0)**2
C
        A(1) = 1.0D0 - XMU
        A(2) = 9.0D0 - XMU
        A(3) = 25.0D0 - XMU
        IF (A(2).EQ.0.D0) RESULT = SQPI2*(16.D0*X+XMU+7.D0) /
     1    (16.D0*X*SQRTX)
        IF (A(2).EQ.0.D0) GO TO 70
C
        ALPHA(1) = 1.0D0
        ALPHA(2) = (16.D0*X+A(2))/A(2)
        ALPHA(3) = ((768.D0*X+48.D0*A(3))*X + A(2)*A(3))/(A(2)*A(3))
C
        BETA(1) = 1.0D0
        BETA(2) = (16.D0*X+(XMU+7.D0))/A(2)
        BETA(3) = ((768.D0*X+48.D0*(XMU+23.D0))*X +
     1    ((XMU+62.D0)*XMU+129.D0))/(A(2)*A(3))
C
        IF (NTERMS.LT.4) GO TO 65
        DO 60 I=4,NTERMS
          N = I - 1
          X2N = 2*N - 1
C
          A(I) = (X2N+2.D0)**2 - XMU
          QQ = 16.D0*X2N/A(I)
          P1 = -X2N*((12*N*N-20*N)-A(1))/((X2N-2.D0)*A(I))
     1      - QQ*X
          P2 = ((12*N*N-28*N+8)-A(1))/A(I) - QQ*X
          P3 = -X2N*A(I-3)/((X2N-2.D0)*A(I))
C
          ALPHA(I) = -P1*ALPHA(I-1) - P2*ALPHA(I-2) - P3*ALPHA(I-3)
          BETA(I) = -P1*BETA(I-1) - P2*BETA(I-2) - P3*BETA(I-3)
 60     CONTINUE
C
 65     RESULT = SQPI2*BETA(NTERMS)/(SQRTX*ALPHA(NTERMS))
C
 70     IF (INU.EQ.1) BKNU = RESULT
        IF (INU.EQ.2) BKNU1 = RESULT
 80   CONTINUE
      RETURN
C
 90   BKNU = SQPI2/SQRTX
      BKNU1 = BKNU
      RETURN
C
      END
*DECK D9LGIC
      DOUBLE PRECISION FUNCTION D9LGIC (A, X, ALX)
C***BEGIN PROLOGUE  D9LGIC
C***SUBSIDIARY
C***PURPOSE  Compute the log complementary incomplete Gamma function
C            for large X and for A .LE. X.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C7E
C***TYPE      DOUBLE PRECISION (R9LGIC-S, D9LGIC-D)
C***KEYWORDS  COMPLEMENTARY INCOMPLETE GAMMA FUNCTION, FNLIB, LARGE X,
C             LOGARITHM, SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Compute the log complementary incomplete gamma function for large X
C and for A .LE. X.
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9LGIC
      DOUBLE PRECISION A, X, ALX, EPS, FK, P, R, S, T, XMA, XPA, D1MACH
      SAVE EPS
      DATA EPS / 0.D0 /
C***FIRST EXECUTABLE STATEMENT  D9LGIC
      IF (EPS.EQ.0.D0) EPS = 0.5D0*D1MACH(3)
C
      XPA = X + 1.0D0 - A
      XMA = X - 1.D0 - A
C
      R = 0.D0
      P = 1.D0
      S = P
      DO 10 K=1,300
        FK = K
        T = FK*(A-FK)*(1.D0+R)
        R = -T/((XMA+2.D0*FK)*(XPA+2.D0*FK)+T)
        P = R*P
        S = S + P
        IF (ABS(P).LT.EPS*S) GO TO 20
 10   CONTINUE
      CALL XERMSG ('SLATEC', 'D9LGIC',
     +   'NO CONVERGENCE IN 300 TERMS OF CONTINUED FRACTION', 1, 2)
C
 20   D9LGIC = A*ALX - X + LOG(S/XPA)
C
      RETURN
      END
*DECK D9LGIT
      DOUBLE PRECISION FUNCTION D9LGIT (A, X, ALGAP1)
C***BEGIN PROLOGUE  D9LGIT
C***SUBSIDIARY
C***PURPOSE  Compute the logarithm of Tricomi's incomplete Gamma
C            function with Perron's continued fraction for large X and
C            A .GE. X.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C7E
C***TYPE      DOUBLE PRECISION (R9LGIT-S, D9LGIT-D)
C***KEYWORDS  FNLIB, INCOMPLETE GAMMA FUNCTION, LOGARITHM,
C             PERRON'S CONTINUED FRACTION, SPECIAL FUNCTIONS, TRICOMI
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Compute the log of Tricomi's incomplete gamma function with Perron's
C continued fraction for large X and for A .GE. X.
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9LGIT
      DOUBLE PRECISION A, X, ALGAP1, AX, A1X, EPS, FK, HSTAR, P, R, S,
     1  SQEPS, T, D1MACH
      LOGICAL FIRST
      SAVE EPS, SQEPS, FIRST
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9LGIT
      IF (FIRST) THEN
         EPS = 0.5D0*D1MACH(3)
         SQEPS = SQRT(D1MACH(4))
      ENDIF
      FIRST = .FALSE.
C
      IF (X .LE. 0.D0 .OR. A .LT. X) CALL XERMSG ('SLATEC', 'D9LGIT',
     +   'X SHOULD BE GT 0.0 AND LE A', 2, 2)
C
      AX = A + X
      A1X = AX + 1.0D0
      R = 0.D0
      P = 1.D0
      S = P
      DO 20 K=1,200
        FK = K
        T = (A+FK)*X*(1.D0+R)
        R = T/((AX+FK)*(A1X+FK)-T)
        P = R*P
        S = S + P
        IF (ABS(P).LT.EPS*S) GO TO 30
 20   CONTINUE
      CALL XERMSG ('SLATEC', 'D9LGIT',
     +   'NO CONVERGENCE IN 200 TERMS OF CONTINUED FRACTION', 3, 2)
C
 30   HSTAR = 1.0D0 - X*S/A1X
      IF (HSTAR .LT. SQEPS) CALL XERMSG ('SLATEC', 'D9LGIT',
     +   'RESULT LESS THAN HALF PRECISION', 1, 1)
C
      D9LGIT = -X - ALGAP1 - LOG(HSTAR)
      RETURN
C
      END
*DECK D9LGMC
      DOUBLE PRECISION FUNCTION D9LGMC (X)
C***BEGIN PROLOGUE  D9LGMC
C***SUBSIDIARY
C***PURPOSE  Compute the log Gamma correction factor so that
C            LOG(DGAMMA(X)) = LOG(SQRT(2*PI)) + (X-5.)*LOG(X) - X
C            + D9LGMC(X).
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C7E
C***TYPE      DOUBLE PRECISION (R9LGMC-S, D9LGMC-D, C9LGMC-C)
C***KEYWORDS  COMPLETE GAMMA FUNCTION, CORRECTION TERM, FNLIB,
C             LOG GAMMA, LOGARITHM, SPECIAL FUNCTIONS
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Compute the log gamma correction factor for X .GE. 10. so that
C LOG (DGAMMA(X)) = LOG(SQRT(2*PI)) + (X-.5)*LOG(X) - X + D9lGMC(X)
C
C Series for ALGM       on the interval  0.          to  1.00000E-02
C                                        with weighted error   1.28E-31
C                                         log weighted error  30.89
C                               significant figures required  29.81
C                                    decimal places required  31.48
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   770601  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9LGMC
      DOUBLE PRECISION X, ALGMCS(15), XBIG, XMAX, DCSEVL, D1MACH
      LOGICAL FIRST
      SAVE ALGMCS, NALGM, XBIG, XMAX, FIRST
      DATA ALGMCS(  1) / +.1666389480 4518632472 0572965082 2 D+0      /
      DATA ALGMCS(  2) / -.1384948176 0675638407 3298605913 5 D-4      /
      DATA ALGMCS(  3) / +.9810825646 9247294261 5717154748 7 D-8      /
      DATA ALGMCS(  4) / -.1809129475 5724941942 6330626671 9 D-10     /
      DATA ALGMCS(  5) / +.6221098041 8926052271 2601554341 6 D-13     /
      DATA ALGMCS(  6) / -.3399615005 4177219443 0333059966 6 D-15     /
      DATA ALGMCS(  7) / +.2683181998 4826987489 5753884666 6 D-17     /
      DATA ALGMCS(  8) / -.2868042435 3346432841 4462239999 9 D-19     /
      DATA ALGMCS(  9) / +.3962837061 0464348036 7930666666 6 D-21     /
      DATA ALGMCS( 10) / -.6831888753 9857668701 1199999999 9 D-23     /
      DATA ALGMCS( 11) / +.1429227355 9424981475 7333333333 3 D-24     /
      DATA ALGMCS( 12) / -.3547598158 1010705471 9999999999 9 D-26     /
      DATA ALGMCS( 13) / +.1025680058 0104709120 0000000000 0 D-27     /
      DATA ALGMCS( 14) / -.3401102254 3167487999 9999999999 9 D-29     /
      DATA ALGMCS( 15) / +.1276642195 6300629333 3333333333 3 D-30     /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9LGMC
      IF (FIRST) THEN
         NALGM = INITDS (ALGMCS, 15, REAL(D1MACH(3)) )
         XBIG = 1.0D0/SQRT(D1MACH(3))
         XMAX = EXP (MIN(LOG(D1MACH(2)/12.D0), -LOG(12.D0*D1MACH(1))))
      ENDIF
      FIRST = .FALSE.
C
      IF (X .LT. 10.D0) CALL XERMSG ('SLATEC', 'D9LGMC',
     +   'X MUST BE GE 10', 1, 2)
      IF (X.GE.XMAX) GO TO 20
C
      D9LGMC = 1.D0/(12.D0*X)
      IF (X.LT.XBIG) D9LGMC = DCSEVL (2.0D0*(10.D0/X)**2-1.D0, ALGMCS,
     1  NALGM) / X
      RETURN
C
 20   D9LGMC = 0.D0
      CALL XERMSG ('SLATEC', 'D9LGMC', 'X SO BIG D9LGMC UNDERFLOWS', 2,
     +   1)
      RETURN
C
      END
*DECK D9LN2R
      DOUBLE PRECISION FUNCTION D9LN2R (X)
C***BEGIN PROLOGUE  D9LN2R
C***SUBSIDIARY
C***PURPOSE  Evaluate LOG(1+X) from second order relative accuracy so
C            that LOG(1+X) = X - X**2/2 + X**3*D9LN2R(X)
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  C4B
C***TYPE      DOUBLE PRECISION (R9LN2R-S, D9LN2R-D, C9LN2R-C)
C***KEYWORDS  ELEMENTARY FUNCTIONS, FNLIB, LOGARITHM, SECOND ORDER
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Evaluate  LOG(1+X)  from 2-nd order with relative error accuracy so
C that    LOG(1+X) = X - X**2/2 + X**3*D9LN2R(X)
C
C Series for LN21       on the interval -6.25000E-01 to  0.
C                                        with weighted error   1.82E-32
C                                         log weighted error  31.74
C                               significant figures required  31.00
C                                    decimal places required  32.59
C
C Series for LN22       on the interval  0.          to  8.12500E-01
C                                        with weighted error   6.10E-32
C                                         log weighted error  31.21
C                               significant figures required  30.32
C                                    decimal places required  32.00
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, DCSEVL, INITDS, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   780401  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890911  Removed unnecessary intrinsics.  (WRB)
C   890911  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   900720  Routine changed from user-callable to subsidiary.  (WRB)
C***END PROLOGUE  D9LN2R
      DOUBLE PRECISION X, XBIG, TXBIG, XMAX, TXMAX, XMIN, LN21CS(50),
     *  LN22CS(37), DCSEVL, D1MACH
      LOGICAL FIRST
      SAVE LN21CS, LN22CS, NTLN21, NTLN22, XMIN, XBIG, XMAX, FIRST
      DATA LN21CS(  1) / +.1811196251 3478809875 8949530430 71 D+0     /
      DATA LN21CS(  2) / -.1562712319 2872462669 6251555410 78 D+0     /
      DATA LN21CS(  3) / +.2867630536 1557275209 5406271020 51 D-1     /
      DATA LN21CS(  4) / -.5558699655 9481398781 1577251267 81 D-2     /
      DATA LN21CS(  5) / +.1117897665 2299837657 3356662797 27 D-2     /
      DATA LN21CS(  6) / -.2308050898 2327947182 2992795857 05 D-3     /
      DATA LN21CS(  7) / +.4859885334 1100175874 6815580687 50 D-4     /
      DATA LN21CS(  8) / -.1039012738 8903210765 5142426333 38 D-4     /
      DATA LN21CS(  9) / +.2248456370 7390128494 6218049464 08 D-5     /
      DATA LN21CS( 10) / -.4914059273 9266484875 3278025970 91 D-6     /
      DATA LN21CS( 11) / +.1082825650 7077483336 6201529715 97 D-6     /
      DATA LN21CS( 12) / -.2402587276 3420701435 9766754167 19 D-7     /
      DATA LN21CS( 13) / +.5362460047 2708133762 9844432501 63 D-8     /
      DATA LN21CS( 14) / -.1202995136 2138772264 6716464243 77 D-8     /
      DATA LN21CS( 15) / +.2710788927 7591860785 6225516322 66 D-9     /
      DATA LN21CS( 16) / -.6132356261 8319010068 7967284306 90 D-10    /
      DATA LN21CS( 17) / +.1392085836 9159469857 4369085439 78 D-10    /
      DATA LN21CS( 18) / -.3169930033 0223494015 2830572608 83 D-11    /
      DATA LN21CS( 19) / +.7238375404 4307505335 2143261970 11 D-12    /
      DATA LN21CS( 20) / -.1657001718 4764411391 4988055062 68 D-12    /
      DATA LN21CS( 21) / +.3801842866 3117424257 3644226318 76 D-13    /
      DATA LN21CS( 22) / -.8741118929 6972700259 7244298991 37 D-14    /
      DATA LN21CS( 23) / +.2013561984 5055748302 1187510281 54 D-14    /
      DATA LN21CS( 24) / -.4646445640 9033907031 1020081544 77 D-15    /
      DATA LN21CS( 25) / +.1073928214 7018339453 4533385549 25 D-15    /
      DATA LN21CS( 26) / -.2485853461 9937794755 5340218339 60 D-16    /
      DATA LN21CS( 27) / +.5762019795 0800189813 8881426281 81 D-17    /
      DATA LN21CS( 28) / -.1337306376 9804394701 4021999580 50 D-17    /
      DATA LN21CS( 29) / +.3107465322 7331824966 5338071668 05 D-18    /
      DATA LN21CS( 30) / -.7228810408 3040539906 9019579176 27 D-19    /
      DATA LN21CS( 31) / +.1683378378 8037385103 3132581868 88 D-19    /
      DATA LN21CS( 32) / -.3923946331 2069958052 5193727399 25 D-20    /
      DATA LN21CS( 33) / +.9155146838 7536789746 3855286408 53 D-21    /
      DATA LN21CS( 34) / -.2137889532 1320159520 9820958010 02 D-21    /
      DATA LN21CS( 35) / +.4996450747 9047864699 8285645687 46 D-22    /
      DATA LN21CS( 36) / -.1168624063 6080170135 3608061474 13 D-22    /
      DATA LN21CS( 37) / +.2735312347 0391863775 6286867865 59 D-23    /
      DATA LN21CS( 38) / -.6406802508 4792111965 0503458815 99 D-24    /
      DATA LN21CS( 39) / +.1501629320 4334124162 9490719402 66 D-24    /
      DATA LN21CS( 40) / -.3521737241 0398479759 4971450026 66 D-25    /
      DATA LN21CS( 41) / +.8264390101 4814767012 4827333973 33 D-26    /
      DATA LN21CS( 42) / -.1940493027 5943401918 0366178986 66 D-26    /
      DATA LN21CS( 43) / +.4558788001 8841283562 4515884373 33 D-27    /
      DATA LN21CS( 44) / -.1071549208 7545202154 3786250239 99 D-27    /
      DATA LN21CS( 45) / +.2519940800 7927592978 0966741333 33 D-28    /
      DATA LN21CS( 46) / -.5928908840 0120969341 7504768000 00 D-29    /
      DATA LN21CS( 47) / +.1395586406 1057513058 2371532799 99 D-29    /
      DATA LN21CS( 48) / -.3286457881 3478583431 4366975999 99 D-30    /
      DATA LN21CS( 49) / +.7742496795 0478166247 2546986666 66 D-31    /
      DATA LN21CS( 50) / -.1824773566 7260887638 1252266666 66 D-31    /
      DATA LN22CS(  1) / -.2224253253 5020460829 8601522355 2 D+0      /
      DATA LN22CS(  2) / -.6104710010 8078623986 8010475576 4 D-1      /
      DATA LN22CS(  3) / +.7427235009 7503945905 1962975572 9 D-2      /
      DATA LN22CS(  4) / -.9335018261 6369705656 1277960639 7 D-3      /
      DATA LN22CS(  5) / +.1200499076 8726012833 5073128735 9 D-3      /
      DATA LN22CS(  6) / -.1570472295 2820041128 2335260824 3 D-4      /
      DATA LN22CS(  7) / +.2081874781 0512710960 5078359275 9 D-5      /
      DATA LN22CS(  8) / -.2789195577 6467136540 5721305137 5 D-6      /
      DATA LN22CS(  9) / +.3769355823 7601320584 2289513544 7 D-7      /
      DATA LN22CS( 10) / -.5130902896 5277112582 4058993800 3 D-8      /
      DATA LN22CS( 11) / +.7027141178 1506947382 0621821539 2 D-9      /
      DATA LN22CS( 12) / -.9674859550 1343423892 4397200513 7 D-10     /
      DATA LN22CS( 13) / +.1338104645 9248873065 8849644974 8 D-10     /
      DATA LN22CS( 14) / -.1858102603 5340639816 2845384659 1 D-11     /
      DATA LN22CS( 15) / +.2589294422 5279197493 0860012307 0 D-12     /
      DATA LN22CS( 16) / -.3619568316 1415886744 6602538217 2 D-13     /
      DATA LN22CS( 17) / +.5074037398 0166230880 0685891739 6 D-14     /
      DATA LN22CS( 18) / -.7131012977 0311273027 0093874892 7 D-15     /
      DATA LN22CS( 19) / +.1004490328 5545674818 5338678412 6 D-15     /
      DATA LN22CS( 20) / -.1417906532 1840257919 0440507528 5 D-16     /
      DATA LN22CS( 21) / +.2005297034 7433261178 9108639607 4 D-17     /
      DATA LN22CS( 22) / -.2840996662 3398033053 6539671756 7 D-18     /
      DATA LN22CS( 23) / +.4031469883 9690798995 9987866282 6 D-19     /
      DATA LN22CS( 24) / -.5729325241 8322073204 5549895679 9 D-20     /
      DATA LN22CS( 25) / +.8153488253 8900106758 4892873386 6 D-21     /
      DATA LN22CS( 26) / -.1161825588 5497217876 0602746879 9 D-21     /
      DATA LN22CS( 27) / +.1657516611 6625383436 5933977599 9 D-22     /
      DATA LN22CS( 28) / -.2367336704 7108051901 1401728000 0 D-23     /
      DATA LN22CS( 29) / +.3384670367 9755213860 7656959999 9 D-24     /
      DATA LN22CS( 30) / -.4843940829 2157182042 9639679999 9 D-25     /
      DATA LN22CS( 31) / +.6938759162 5142737186 7613866666 6 D-26     /
      DATA LN22CS( 32) / -.9948142607 0314365719 2379733333 3 D-27     /
      DATA LN22CS( 33) / +.1427440611 2116986106 3475200000 0 D-27     /
      DATA LN22CS( 34) / -.2049794721 8982349115 6650666666 6 D-28     /
      DATA LN22CS( 35) / +.2945648756 4013622228 8554666666 6 D-29     /
      DATA LN22CS( 36) / -.4235973185 1849570276 6933333333 3 D-30     /
      DATA LN22CS( 37) / +.6095532614 0038320401 0666666666 6 D-31     /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9LN2R
      IF (FIRST) THEN
         EPS = D1MACH(3)
         NTLN21 = INITDS (LN21CS, 50, 0.1*EPS)
         NTLN22 = INITDS (LN22CS, 37, 0.1*EPS)
C
         XMIN = -1.0D0 + SQRT(D1MACH(4))
         SQEPS = SQRT (EPS)
         TXMAX = 8.0/SQEPS
         XMAX = TXMAX - (EPS*TXMAX**2 - 2.D0*LOG(TXMAX))
     1     / (2.D0*EPS*TXMAX)
         TXBIG = 6.0/SQRT(SQEPS)
         XBIG = TXBIG - (SQEPS*TXBIG**2 - 2.D0*LOG(TXBIG))
     1     / (2.D0*SQEPS*TXBIG)
      ENDIF
      FIRST = .FALSE.
C
      IF (X.LT.(-.625D0) .OR. X.GT.0.8125D0) GO TO 20
C
      IF (X.LT.0.0D0) D9LN2R = 0.375D0 + DCSEVL (16.D0*X/5.D0+1.D0,
     1  LN21CS, NTLN21)
      IF (X.GE.0.0D0) D9LN2R = 0.375D0 + DCSEVL (32.D0*X/13.D0-1.D0,
     1  LN22CS, NTLN22)
      RETURN
C
 20   IF (X .LT. XMIN) CALL XERMSG ('SLATEC', 'D9LN2R',
     +   'ANSWER LT HALF PRECISION BECAUSE X IS TOO NEAR -1', 1, 1)
      IF (X .GT. XMAX) CALL XERMSG ('SLATEC', 'D9LN2R',
     +   'NO PRECISION IN ANSWER BECAUSE X IS TOO BIG', 3, 2)
      IF (X .GT. XBIG) CALL XERMSG ('SLATEC', 'D9LN2R',
     +   'ANSWER LT HALF PRECISION BECAUSE X IS TOO BIG', 2, 1)
C
      D9LN2R = (LOG(1.D0+X) - X*(1.D0 - 0.5D0*X)) / X**3
      RETURN
C
      END
*DECK D9PAK
      DOUBLE PRECISION FUNCTION D9PAK (Y, N)
C***BEGIN PROLOGUE  D9PAK
C***PURPOSE  Pack a base 2 exponent into a floating point number.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  A6B
C***TYPE      DOUBLE PRECISION (R9PAK-S, D9PAK-D)
C***KEYWORDS  FNLIB, PACK
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C Pack a base 2 exponent into floating point number X.  This routine is
C almost the inverse of D9UPAK.  It is not exactly the inverse, because
C ABS(X) need not be between 0.5 and 1.0.  If both D9PAK and 2.d0**N
C were known to be in range we could compute
C               D9PAK = X *2.0d0**N
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  D1MACH, D9UPAK, I1MACH, XERMSG
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890911  Removed unnecessary intrinsics.  (WRB)
C   891009  Corrected error when XERROR called.  (WRB)
C   891009  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900315  CALLs to XERROR changed to CALLs to XERMSG.  (THJ)
C   901009  Routine used I1MACH(7) where it should use I1MACH(10),
C           Corrected (RWC)
C***END PROLOGUE  D9PAK
      DOUBLE PRECISION Y, A1N2B,A1N210,D1MACH
      LOGICAL FIRST
      SAVE NMIN, NMAX, A1N210, FIRST
      DATA A1N210 / 3.321928094 8873623478 7031942948 9 D0 /
      DATA FIRST /.TRUE./
C***FIRST EXECUTABLE STATEMENT  D9PAK
      IF (FIRST) THEN
         A1N2B = 1.0D0
         IF(I1MACH(10).NE.2) A1N2B=D1MACH(5)*A1N210
         NMIN = A1N2B*I1MACH(15)
         NMAX = A1N2B*I1MACH(16)
      ENDIF
      FIRST = .FALSE.
C
      CALL D9UPAK(Y,D9PAK,NY)
C
      NSUM=N+NY
      IF(NSUM.LT.NMIN)GO TO 40
      IF (NSUM .GT. NMAX) CALL XERMSG ('SLATEC', 'D9PAK',
     +   'PACKED NUMBER OVERFLOWS', 1, 2)
C
      IF (NSUM.EQ.0) RETURN
      IF(NSUM.GT.0) GO TO 30
C
 20   D9PAK = 0.5D0*D9PAK
      NSUM=NSUM+1
      IF(NSUM.NE.0) GO TO 20
      RETURN
C
 30   D9PAK = 2.0D0*D9PAK
      NSUM=NSUM - 1
      IF (NSUM.NE.0) GO TO 30
      RETURN
C
 40   CALL XERMSG ('SLATEC', 'D9PAK', 'PACKED NUMBER UNDERFLOWS', 1, 1)
      D9PAK = 0.0D0
      RETURN
C
      END
*DECK D9UPAK
      SUBROUTINE D9UPAK (X, Y, N)
C***BEGIN PROLOGUE  D9UPAK
C***PURPOSE  Unpack a floating point number X so that X = Y*2**N.
C***LIBRARY   SLATEC (FNLIB)
C***CATEGORY  A6B
C***TYPE      DOUBLE PRECISION (R9UPAK-S, D9UPAK-D)
C***KEYWORDS  FNLIB, UNPACK
C***AUTHOR  Fullerton, W., (LANL)
C***DESCRIPTION
C
C   Unpack a floating point number X so that X = Y*2.0**N, where
C   0.5 .LE. ABS(Y) .LT. 1.0.
C
C***REFERENCES  (NONE)
C***ROUTINES CALLED  (NONE)
C***REVISION HISTORY  (YYMMDD)
C   780701  DATE WRITTEN
C   890531  Changed all specific intrinsics to generic.  (WRB)
C   890531  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   900820  Corrected code to find Y between 0.5 and 1.0 rather than
C           between 0.05 and 1.0.  (WRB)
C***END PROLOGUE  D9UPAK
      DOUBLE PRECISION X,Y,ABSX
C***FIRST EXECUTABLE STATEMENT  D9UPAK
      ABSX = ABS(X)
      N = 0
      IF (X.EQ.0.0D0) GO TO 30
C
   10 IF (ABSX.GE.0.5D0) GO TO 20
      N = N-1
      ABSX = ABSX*2.0D0
      GO TO 10
C
   20 IF (ABSX.LT.1.0D0) GO TO 30
      N = N+1
      ABSX = ABSX*0.5D0
      GO TO 20
C
   30 Y = SIGN(ABSX,X)
      RETURN
C
      END
