#!/usr/bin/env python

# DUPLICATE of "python-config --ldflags", fixed for the library location

# This utility is known to work with:
#  python2.6 (system install)   under SL6.4
#  python2.7 (custom install)   under SL6.4
#  python3.4 (custom install)   under SL6.4
#  python2.7 (system install)   under Fedora20
#  python2.7 (Apple install)    under MacOSX
#  python2.7 (MacPorts install) under MacOSX
#  python3.4 (MacPorts install) under MacOSX

import sys
import distutils.sysconfig

pyver = distutils.sysconfig.get_config_var('VERSION')
getvar = distutils.sysconfig.get_config_var

libs = getvar('LIBS').split() + getvar('SYSLIBS').split()
if (hasattr(sys,'abiflags')):
  libs.append('-lpython' + pyver + sys.abiflags)
else:
  libs.append('-lpython' + pyver)

# Add the library path
libs.insert(0, '-L' + getvar('LIBDIR'))

# Framework (specific for Mac)
if not getvar('PYTHONFRAMEWORK'):
    libs.extend(getvar('LINKFORSHARED').split())

print(' '.join(libs))
