!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine mrtcal_chunkset_check(set,error)
  use gbl_message
  use mrtcal_calib_types
  use mrtcal_interfaces, except_this=>mrtcal_chunkset_check
  !---------------------------------------------------------------------
  ! @ private
  ! Check the integrity of a set of chunks
  !---------------------------------------------------------------------
  type(chunkset_t), intent(in)    :: set
  logical,          intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='CHUNKSET>CHECK'
  integer(kind=4) :: ichunk,id
  character(len=12) :: line
  !
  call mrtcal_message(seve%t,rname,'Welcome')
  !
  id = set%chunks(1)%id
  line = set%chunks(1)%spe%line
  do ichunk=2,set%n
     if (set%chunks(ichunk)%id.ne.id) then
        call mrtcal_message(seve%e,rname,'Inconsistant identifiers in set of chunks')
        error = .true.
        return
     endif
     if (set%chunks(ichunk)%spe%line.ne.line) then
        call mrtcal_message(seve%e,rname,'Inconsistant line names in set of chunks')
        error = .true.
        return
     endif
  enddo
  !
end subroutine mrtcal_chunkset_check
!
subroutine mrtcal_chunkset_show(chunkset)
  use gbl_message
  use mrtcal_calib_types
  use mrtcal_interfaces, except_this=>mrtcal_chunkset_show
  !---------------------------------------------------------------------
  ! @ private
  ! Display a set of chunks. For debugging purpose.
  !---------------------------------------------------------------------
  type(chunkset_t), intent(in) :: chunkset
  ! Local
  integer(kind=4) :: ichunk
  character(len=*), parameter :: rname='CHUNKSET>SHOW'
  !
  call mrtcal_message(seve%t,rname,'Welcome')
  !
  do ichunk=1,chunkset%n
     write(*,'(A,I0)') 'Chunk #',ichunk
     call mrtcal_chunk_show(chunkset%chunks(ichunk))
  enddo
  !
end subroutine mrtcal_chunkset_show
!
subroutine chunkset_consistency(caller,c1,c2,error)
  use gbl_message
  use mrtcal_interfaces, except_this=>chunkset_consistency
  use mrtcal_calib_types
  !---------------------------------------------------------------------
  ! @ private
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: caller  ! Calling routine name
  type(chunkset_t), intent(in)    :: c1
  type(chunkset_t), intent(in)    :: c2
  logical,          intent(inout) :: error
  ! Local
  integer(kind=4) :: ichunk
  character(len=message_length) :: mess
  !
  if (c1%n.ne.c2%n) then
    write(mess,'(A,I0,1X,I0)')  &
      'Inconsistent number of chunks per set: ',c1%n,c2%n
    call mrtcal_message(seve%e,caller,mess)
    error = .true.
    return
  endif
  !
  do ichunk=1,c1%n
    if (c1%chunks(ichunk)%nchan.ne.c2%chunks(ichunk)%nchan) then
      write(mess,'(A,I0,1X,I0)')  'Inconsistent number of channels: ', &
        c1%chunks(ichunk)%nchan,c2%chunks(ichunk)%nchan
      call mrtcal_message(seve%e,caller,mess)
      error = .true.
      return
    endif
  enddo
  !
end subroutine chunkset_consistency
!
subroutine mrtcal_chunkset_accumulate_setweight(diff,tscale,dowei,error)
  use mrtcal_interfaces, except_this=>mrtcal_chunkset_accumulate_setweight
  use mrtcal_calib_types
  !---------------------------------------------------------------------
  ! @ private
  ! ZZZ
  ! Quick and dirty subroutine to enforce chunks dataw to something
  ! non-zero (needed by simple_waverage). Currently set to 1.0 i.e.
  ! equal weights. Should probably come early and cleverly e.g.
  ! weight equal, tsys, time, maybe in mrtcal_on_minus_off.
  !---------------------------------------------------------------------
  type(chunkset_t), intent(inout) :: diff
  type(chunkset_t), intent(in)    :: tscale
  logical,          intent(in)    :: dowei   ! Compute real weights or dummy?
  logical,          intent(inout) :: error
  ! Local
  integer(kind=size_length) :: ichunk,ichan
  real(kind=4) :: fact
  !
  if (dowei) then
    !
    do ichunk=1,diff%n
      fact = diff%chunks(ichunk)%gen%time * abs(diff%chunks(ichunk)%spe%fres)
      do ichan=1,diff%chunks(ichunk)%nchan
        diff%chunks(ichunk)%dataw(ichan) =  &
          fact / tscale%chunks(ichunk)%data1(ichan)**2
      enddo
    enddo ! ichunk
    !
  else
    !
    do ichunk=1,diff%n
      diff%chunks(ichunk)%dataw(:) = 1.0
    enddo ! ichunk
    !
  endif
  !
end subroutine mrtcal_chunkset_accumulate_setweight
!
subroutine mrtcal_chunkset_accumulate_do(inchunkset,ouchunkset,error)
  use mrtcal_dependencies_interfaces
  use mrtcal_interfaces, except_this=>mrtcal_chunkset_accumulate_do
  use mrtcal_calib_types
  !---------------------------------------------------------------------
  ! @ private-generic mrtcal_chunkset_accumulate_do
  ! Accumulate the input chunkset into the running output chunkset
  !---------------------------------------------------------------------
  type(chunkset_t), intent(in)    :: inchunkset
  type(chunkset_t), intent(inout) :: ouchunkset
  logical,          intent(inout) :: error
  ! Local
  integer(kind=size_length) :: ichunk
  logical, parameter :: contaminate=.true.  ! Input bad channels contaminate the output sum
  real(kind=8) :: iinteg,ointeg,sinteg
  !
  do ichunk=1,inchunkset%n
    call simple_waverage(                   &
      inchunkset%chunks(ichunk)%data1,      &
      inchunkset%chunks(ichunk)%dataw,bad,  &
      ouchunkset%chunks(ichunk)%data1,      &
      ouchunkset%chunks(ichunk)%dataw,bad,  &
      1,inchunkset%chunks(ichunk)%nchan,    &
      contaminate,.true.)
    ! The following lines assume that the whole spectrum is
    ! not bad
    iinteg = inchunkset%chunks(ichunk)%gen%time
    ointeg = ouchunkset%chunks(ichunk)%gen%time
    sinteg = iinteg+ointeg  ! Total integration time
    ouchunkset%chunks(ichunk)%mjd =  &
            (ouchunkset%chunks(ichunk)%mjd*ointeg +  &
            inchunkset%chunks(ichunk)%mjd*iinteg)/sinteg  ! Mean MJD
    call gag_mjd2gagut(ouchunkset%chunks(ichunk)%mjd,       &
                       ouchunkset%chunks(ichunk)%gen%dobs,  &
                       ouchunkset%chunks(ichunk)%gen%ut,    &
                       error)
    ouchunkset%chunks(ichunk)%gen%time = sinteg
    ! *** JP Normally OTF PSW never explore this subroutine.
    ! *** JP But if it would, the OFF time would be wrongly added...
    ouchunkset%chunks(ichunk)%swi%duree   =  &
      ouchunkset%chunks(ichunk)%swi%duree +  &
      inchunkset%chunks(ichunk)%swi%duree
  enddo ! ichunk
  !
end subroutine mrtcal_chunkset_accumulate_do
