program uv_resample
  !------------------------------------------------------------------------
  ! TASK  Resample in velocity an input UV Table
  !
  ! input :
  !	a uv table
  ! output :
  !	a uv table
  !------------------------------------------------------------------------
  use gbl_format
  use gkernel_interfaces
  !
  character(len=filename_length) :: input,output
  character(len=*), parameter :: rname = 'UV_RESAMPLE'
  real(8) :: convert(3)
  integer nc
  logical error
  !
  ! Input parameters
  call gildas_open
  call gildas_char('UV_INPUT$',input)
  call gildas_char('UV_OUTPUT$', output)
  call gildas_inte('NC$',nc,1)
  call gildas_dble('CONVERT$',convert,3)
  call gildas_close
  !
  call sub_uv_resample(input, output, nc, convert, error)
  if (error) call sysexi(fatale)
  call gagout('I-UV_RESAMPLE,  Successful completion')
  !
end program uv_resample  
!  
subroutine sub_uv_resample(input, output, nc, convert, error)
  !
  use image_def
  use gbl_format
  use gkernel_interfaces
  use mapping_interfaces
  use gbl_message
  !
  character(len=*), intent(in) :: input
  character(len=*), intent(in) :: output
  integer, intent(in) :: nc
  real(8), intent(inout) :: convert(3)
  logical, intent(out) :: error
  !
  type (gildas) :: uvint, uvout
  character(len=*), parameter :: rname = 'UV_RESAMPLE'
  integer :: i, n, ier
  integer :: iv, kv, nblock
  real(8) :: xref,xval,xinc,yref,yval,yinc
  character(len=80) :: mess
  !
  call map_message(seve%w,rname,'Task still experimental')
  call map_message(seve%w,rname,'Results NOT proven yet...')
  !
  error = .true.
  n = len_trim(input)
  if (n.le.0) then
    call map_message(seve%e,rname,'Input table name empty')
    return
  endif
  n = len_trim(output)
  if (n.le.0) then
    call map_message(seve%e,rname,'Output table name empty')
    return
  endif
  !
  ! Read input UV table
  call gildas_null(uvint, type = 'UVT')
  call gdf_read_gildas (uvint, input, '.uvt', error, data=.false.)
  if (gildas_error(uvint,rname,error)) then
    call map_message(seve%e,rname,'Cannot read Input UV table')
    return
  endif
  !
  ! Define output UV table
  call gildas_null(uvout, type = 'UVT')
  call gdf_copy_header(uvint,uvout,error)
  ! Compute the Frequency Conversion from the Velocity Conversion
  call getuv_conversion (uvout,nc,convert)
  call gdf_uv_shift_columns(uvint,uvout)
  call gdf_setuv(uvout,error)
  if (error) return
  !
  ! Define blocking factor
  call gdf_nitems('SPACE_GILDAS',nblock,uvint%gil%dim(1)) ! Visibilities at once
  nblock = min(nblock,uvint%gil%dim(2))
  allocate (uvint%r2d(uvint%gil%dim(1),nblock), uvout%r2d(uvout%gil%dim(1),nblock), stat=ier)
  if (ier.ne.0) then
    write(mess,*) 'Memory allocation error ',uvint%gil%dim(1), nblock
    call map_message(seve%e,rname,mess)
    error = .true.
    return
  endif
  !
  call sic_parse_file(output,' ','.uvt',uvout%file)
  call map_message(seve%i,rname,'Creating UV table '//trim(uvout%file))
  call gdf_create_image(uvout,error)
  !
  ! Loop over line table
  !
  uvint%blc = 0
  uvint%trc = 0
  uvout%blc = 0
  uvout%trc = 0
  !
  xref = uvout%gil%ref(1)
  yref = uvint%gil%ref(1)
  xval =   uvout%gil%voff
  xinc =   uvout%gil%vres 
  yval =   uvint%gil%voff
  yinc =   uvint%gil%vres 
  !
  do i=1,uvout%gil%dim(2),nblock
    write(mess,*) i,' / ',uvout%gil%dim(2),nblock
    call map_message(seve%i,rname,mess) 
    uvint%blc(2) = i
    uvint%trc(2) = min(uvint%gil%dim(2),i-1+nblock)
    uvout%blc(2) = i
    uvout%trc(2) = min(uvout%gil%dim(2),i-1+nblock) 
    call gdf_read_data(uvint,uvint%r2d,error)
    if (error) return
    !
    kv = uvint%trc(2)-uvint%blc(2)+1
    do iv=1,kv
      uvout%r2d(1:uvout%gil%nlead,iv) = uvint%r2d(1:uvint%gil%nlead,iv)
      call interpolate_uv (                                 & 
        &  uvout%r2d(uvout%gil%fcol:uvout%gil%lcol,iv),uvout%gil%nchan,&
        &   xinc,xref,xval,       &    
        &  uvint%r2d(uvint%gil%fcol:uvint%gil%lcol,iv),uvint%gil%nchan,& 
        &   yinc,yref,yval )
      if (uvout%gil%ntrail.gt.0) uvout%r2d(uvout%gil%lcol+1:uvout%gil%dim(1),iv) &
          = uvint%r2d(uvint%gil%lcol+1:uvint%gil%dim(1),iv)
    enddo
    call gdf_write_data (uvout,uvout%r2d,error)
    if (error) return
  enddo
  !
  ! Finalize UV data
  call gdf_close_image(uvint,error)
  call gdf_close_image(uvout,error)
  if (error) then
    call map_message(seve%e,rname,'Error writing UV table')
  endif
  !
end subroutine sub_uv_resample
