program field_find
  use gildas_def
  use image_def
  use gkernel_interfaces
  use gbl_format
  ! Local
  character(len=filename_length) :: namex,namey
  logical :: error
  integer :: n, nf, nfields, ier
  integer(4), allocatable :: ipi(:,:), ipf(:,:)
  real :: the
  type(gildas) :: x,y
  !
  call gildas_open
  call gildas_char('Y_NAME$',namey)
  call gildas_char('X_NAME$',namex)
  call gildas_real('THRESHOLD$',the,1)
  call gildas_close
  !
  n = len_trim(namey)
  call gildas_null(y)
  y%gil%ndim = 2
  call gdf_read_gildas(y,namey,'.gdf',error, rank=2)
  if (error) then
    call gagout('F-FIELD_FIND,  Cannot read input file')
    goto 100
  endif
  !
  ! Create output image
  call gildas_null(x)
  call gdf_copy_header(y,x,error)
  n = len_trim(namex)
  call sic_parsef(namex(1:n),x%file,' ','.gdf')
  call gdf_create_image(x,error)
  if (error) then
    call gagout('F-FIELD_FIND,  Cannot create output image')
    goto 100
  endif
  !
  nf = x%gil%dim(1) * x%gil%dim(2)
  allocate (x%r2d(x%gil%dim(1), x%gil%dim(2)),  &
  & ipi(x%gil%dim(1), x%gil%dim(2)),            &
  & ipf(x%gil%dim(1), x%gil%dim(2)),            &
  & stat =ier)
  if (ier.ne.0) goto 100
  !
  call label001 (y%r2d,   &  !Input image
     &    x%gil%dim(1),x%gil%dim(2),   &   !Size
     &    x%r2d,   &     !Output image
     &    nfields,   &         !
     &    ipi,   &     !
     &    ipf,   &     !
     &    nf,   &              !
     &    the,   &             ! Threshold
     &    y%gil%bval,y%gil%eval)       ! Blanking values
  !
  call gdf_write_data(x,x%r2d,error)
  if (nfields.eq.0) then
    call gagout('W-FIELD_FIND,  No field found')
  elseif (nfields.eq.1) then
    call gagout('I-FIELD_FIND,  Found 1 field in image')
  else
    write(namex,'(A,I12,A)') 'I-FIELD_FIND,  Found ',nfields,   &
     &      ' fields in image'
    call gagout(namex)
  endif
  call sysexi(1)
  !
100 call sysexi(fatale)
end program field_find
!
subroutine label001(imagein,ncolumns,nlines,labelout,nfields,   &
     &    labelint,labelfin,nfieldsint,threshold,blank,eblank)
  use gildas_def
  use gkernel_interfaces, only : gi4_trie
  !---------------------------------------------------------------------
  ! Modifie S.Guilloteau LAB 20 Janv 2013
  !    Order the field numbers by number of pixels
  ! Modifie S.Guilloteau
  ! Groupe d'Astrophysique de Grenoble 22 Octobre 1985
  ! Valeurs non definies et declaration LabelOut en reel
  !
  ! Origine : A.Bijaoui 25 octobre 1984 Observatoire de Nice
  ! Saidi1 Permet l'etiquettage des domaines a partir d'une
  ! segmentation avec seuil de flux
  !
  !---------------------------------------------------------------------
  integer(kind=index_length), intent(in) :: ncolumns                ! Number of "Columns"
  integer(kind=index_length), intent(in) :: nlines                  ! Number of "lines"
  real(4), intent(in) :: imagein(ncolumns,nlines)   ! Input image
  real(4), intent(out) :: labelout(ncolumns,nlines) ! Labels of fields
  integer, intent(out) :: nfields                   ! Number of fields
  integer, intent(in) :: nfieldsint                 ! Maximum number
  integer(4), intent(inout) :: labelint(nfieldsint) ! work area
  integer(4), intent(inout) :: labelfin(nfieldsint) ! Final labels
  real(4), intent(in) :: threshold                  ! Threshold
  real(4), intent(in) :: blank                      ! Blanking
  real(4), intent(in) :: eblank                     ! and tolerance
  ! Local
  integer :: nfieldsi,iline,icolumn,l1,l2,la1,la2,la,ifield
  integer :: jfield
  !
  integer :: labelpix(nfieldsint), iorder(nfieldsint)
  logical :: error
  !
  nfieldsi=0
  do iline=1,nlines
    do icolumn=1,ncolumns
      if (imagein(icolumn,iline).lt.threshold) then
        labelout(icolumn,iline)=0.0
      elseif (abs(imagein(icolumn,iline)-blank).le.eblank) then    !SG
        labelout(icolumn,iline)=0.0    !SG
      else
        labelout (icolumn,iline) = 0.0
        if (icolumn.ne.1) then
          l1=labelout(icolumn-1,iline)
          if (l1.ne.0) labelout(icolumn,iline)=l1
        endif
        if (iline.ne.1) then
          l2=labelout(icolumn,iline-1)
          if (l1.eq.0) then
            if (l2.eq.0) then
              nfieldsi=nfieldsi+1
              labelint(nfieldsi)=nfieldsi
              labelout(icolumn,iline)=nfieldsi
            else
              labelout(icolumn,iline)=l2
            endif
          else
            if (l2.ne.0) then
              if (l2.ne.l1) then
                call descen(labelint,l1,la1)
                call descen(labelint,l2,la2)
                la=min0(la1,la2)
                labelint(la1)=la
                labelint(la2)=la
                labelout(icolumn,iline)=la
              endif
            endif
          endif
        endif
      endif
    enddo
  enddo
  !
  nfields=0
  do ifield=1,nfieldsi
    call descen(labelint,ifield,jfield)
    if (ifield.eq.jfield) then
      nfields=nfields+1
      labelfin(ifield)=nfields
    endif
  enddo
  do iline=1,nlines
    do icolumn=1,ncolumns
      l1 = labelout(icolumn,iline)
      if (l1.ne.0) then
        call descen(labelint,l1,la1)
        labelout(icolumn,iline)=labelfin(la1)
      endif
    enddo
  enddo
  !
  ! Sort the final labels by ascending number of pixels...
  labelpix = 0
  do iline=1,nlines
    do icolumn=1,ncolumns
      if (labelout(icolumn,iline).ne.0) then
        ifield = labelout(icolumn,iline)
        labelpix(ifield) = labelpix(ifield)+1
      endif
    enddo
  enddo
  !
  labelint(1:nfields) = labelpix(1:nfields)
  do iline=1,nfieldsi
    iorder(iline) = iline
  enddo
  !
  call gi4_trie(labelpix, iorder, nfields, error)
  !
  do iline=1,nlines
    do icolumn=1,ncolumns
      if (labelout(icolumn,iline).ne.0) then
        do ifield=1,nfields
          if (iorder(ifield).eq.labelout(icolumn,iline)) then
            labelout(icolumn,iline) = ifield
          endif
        enddo
      endif
    enddo
  enddo
  !
end subroutine label001
!
subroutine descen(label,labin,labout)
  integer, intent(inout) :: label(*)   !
  integer, intent(in) :: labin         !
  integer, intent(out) :: labout       !
  ! Local
  integer :: lab
  !
  labout = labin
  do
    lab = label(labout)
    if (lab.eq.labout) return
    labout = lab
  enddo
end subroutine descen
