module imager_interfaces_none
  interface
    subroutine compact_data(error)
      use clean_def
      use clean_arrays
      use gbl_message
      logical error
    end subroutine compact_data
  end interface
  !
  interface
    subroutine clean_beam (line,error)
      use clean_def
      use clean_arrays
      use gbl_message
      !
      character(len=*), intent(in) :: line
      logical, intent(inout) :: error
    end subroutine clean_beam
  end interface
  !
  interface
    subroutine new_dirty_beam
      use clean_def
      use clean_arrays
      !
      ! needed when a new dirty map is computed by command uv_map:
    end subroutine new_dirty_beam
  end interface
  !
  interface
    subroutine save_result(error)
      use gildas_def
      use clean_types
      use gbl_message
      logical error
    end subroutine save_result
  end interface
  !
  interface
    subroutine define_var (error)
      use gildas_def
      use clean_def
      use clean_arrays
      use clean_types
      use clean_default
      use clean_support
      use code_names
      !
      logical :: error  ! Logical error flag
    end subroutine define_var
  end interface
  !
  interface
    subroutine message_attribute(cattr)
      use gbl_ansicodes
      !
      character(len=*), intent(in) :: cattr
    end subroutine message_attribute
  end interface
  !
  interface
    subroutine big_wait(n,b)
      real, intent(inout) :: b
      integer, intent(in) :: n
    end subroutine big_wait
  end interface
  !
  interface
    subroutine map_message_set_id(id)
      use gbl_message
      !---------------------------------------------------------------------
      ! Alter library id into input id. Should be called by the library
      ! which wants to share its id with the current one.
      !---------------------------------------------------------------------
      integer, intent(in) :: id
    end subroutine map_message_set_id
  end interface
  !
  interface
    subroutine imager_pack_set(pack)
      use gpack_def
      !
      type(gpack_info_t), intent(out) :: pack
    end subroutine imager_pack_set
  end interface
  !
  interface
    subroutine imager_pack_init(gpack_id,error)
      use sic_def
      !----------------------------------------------------------------------
      !
      !----------------------------------------------------------------------
      integer :: gpack_id
      logical :: error
    end subroutine imager_pack_init
  end interface
  !
  interface
    subroutine imager_pack_on_exit(error)
      !----------------------------------------------------------------------
      !
      !----------------------------------------------------------------------
      logical :: error
    end subroutine imager_pack_on_exit
  end interface
  !
  interface
    subroutine uvmap_headers(huv,nx,ny,nb,ns,map,mcol,hbeam,hdirty,error)
      use clean_def
      use image_def
      !---------------------------------------------------------------------
      ! IMAGER
      !
      !   Define the Beam and Dirty image headers 
      !---------------------------------------------------------------------
      integer, intent(in) :: nx,ny   ! Map size
      integer, intent(in) :: ns      ! Number of channels per single beam
      integer, intent(in) :: nb      ! Number of beams
      integer, intent(in) :: mcol(2) ! Channel range
      type (uvmap_par), intent(in) :: map    ! Mapping parameters
      type(gildas), intent(in) :: huv        ! UV headers
      type(gildas), intent(inout) :: hbeam   ! Beam headers
      type(gildas), intent(inout) :: hdirty  ! Dirty image header
      logical, intent(inout) :: error
    end subroutine uvmap_headers
  end interface
  !
  interface
    subroutine uvmap_cols(mcol,nc,fcol,lcol,wcol)
      !---------------------------------------------------------------------
      !
      ! IMAGER
      !   Define the Active columns (First, Last and Weight)
      !---------------------------------------------------------------------
      integer, intent(inout) :: mcol(2) ! Default channel range
      integer, intent(inout) :: nc      ! Resulting number of channels
      integer, intent(inout) :: wcol    ! Weight channel
      integer, intent(out) :: fcol,lcol ! First and last channel
    end subroutine uvmap_cols
  end interface
  !
  interface
    subroutine cossin(phase,rcos,rsin)
      !-------------------------------------------------------
      ! Semi-Fast,  Semi-accurate Sin/Cos pair computation
      ! using (not yet clever) interpolation from a precise
      ! loop-up table
      !
      ! A solution using Taylor expansion and symmetries
      ! would be faster and more accurate
      !-------------------------------------------------------
      real(8), intent(inout) :: phase
      real(8), intent(out) :: rcos
      real(8), intent(out) :: rsin
    end subroutine cossin
  end interface
  !
  interface
    subroutine get_stopping(miter,ares,iplane)
      use clean_arrays
      !
      integer, intent(inout) :: miter
      real, intent(inout) :: ares
      integer, intent(in) :: iplane
    end subroutine get_stopping
  end interface
  !
  interface
    subroutine maxcmp(nx,ny,wl,a)
      integer, intent(in) :: nx,ny
      real, intent(in) :: wl(2,nx,ny)
      real, intent(out) :: a
    end subroutine maxcmp
  end interface
  !
  interface
    subroutine map_minmax(hmap)
      use image_def
      !
      type(gildas), intent(inout) :: hmap
    end subroutine map_minmax
  end interface
  !
  interface
    subroutine userc (nv,coords,xref,xval,xinc,yref,yval,yinc)
      integer, intent(in) :: nv                     !
      real(4), intent(out) :: coords(2,nv)          !
      real(8), intent(in) :: xref                   !
      real(8), intent(in) :: xval                   !
      real(8), intent(in) :: xinc                   !
      real(8), intent(in) :: yref                   !
      real(8), intent(in) :: yval                   !
      real(8), intent(in) :: yinc                   !
    end subroutine userc
  end interface
  !
  interface
    subroutine mos_primary (prim,primary,bsize)
      !
      ! Mosaic and Primary beam support
      ! Compute a Gaussian primary beam
      !
      use image_def
      use gkernel_types
      type(gildas), intent(in) :: prim         ! Primary beam header
      real, intent(inout) :: primary(prim%gil%dim(1),prim%gil%dim(2)) ! Values
      real, intent(in) :: bsize                ! Primary beam size in radian
    end subroutine mos_primary
  end interface
  !
  interface
    subroutine mos_inverse (n,weight,thre)
      integer, intent(in) :: n
      real, intent(inout) :: weight(n)
      real, intent(in) :: thre
    end subroutine mos_inverse
  end interface
  !
  interface
    subroutine mos_addsq (n,nf,weight,lobe)
      integer, intent(in) :: n                      ! Size of arrays
      integer, intent(in) :: nf                     ! Number of fields
      real, intent(inout) :: weight(n)              ! Total weight
      real, intent(in) :: lobe(nf,n)                ! Primary beam array
    end subroutine mos_addsq
  end interface
  !
  interface
    subroutine connect_flux
      !
    end subroutine connect_flux
  end interface
  !
  interface
    subroutine mrc_clear
    end subroutine mrc_clear
  end interface
  !
  interface
    function minimum(n,a)
      integer n,i
      real a(*)
      real minimum
    end function minimum
  end interface
  !
  interface
    subroutine uv_free_buffers
      use clean_def
      use clean_arrays
      !---------------------------------------------------------------------
      ! MAPPING
      !   Deallocate all UV buffers.
      !---------------------------------------------------------------------
    end subroutine uv_free_buffers
  end interface
  !
  interface
    subroutine uv_buffer_finduv(code) 
      use clean_arrays
      character(len=1), intent(out) :: code
    end subroutine uv_buffer_finduv
  end interface
  !
  interface
    subroutine uv_buffer_resetuv(code) 
      use clean_arrays
      character(len=1), intent(in) :: code
    end subroutine uv_buffer_resetuv
  end interface
  !
  interface
    subroutine map_beams(task,map_beam,huv,nx,ny,nb,nc)
      use gbl_message
      use image_def
      !
      character(len=*), intent(in) :: task
      integer, intent(inout) :: map_beam
      type(gildas), intent(in) :: huv
      integer, intent(in) :: nx ! X size
      integer, intent(in) :: ny ! Y size
      integer, intent(in) :: nc ! Number of channels
      integer, intent(out) :: nb ! Number of beams
    end subroutine map_beams
  end interface
  !
  interface
    subroutine parabola(x,y,a,b,c) 
      !----------------------------------------------------------------------
      !	Solve for Y = a + b*x() + c*x()^2
      !----------------------------------------------------------------------
      real, intent(in) :: x(3)
      real, intent(in) :: y(3)
      real, intent(out) :: a,b,c
    end subroutine parabola
  end interface
  !
  interface
    function zant(i,r)
      !
      ! Return the apparent number of Antenna #i when reference
      ! antenna is #r. Since #r is not in the list of antennas for
      ! which a solution is to be searched, this number
      ! is #i for #i < #r, and #i-1 for #i > #r
      !
      integer :: zant                   ! intent(out)
      integer, intent(in) :: i          !
      integer, intent(in) :: r          !
    end function zant
  end interface
  !
  interface
    subroutine mth_dpotrf (name, uplo, n, a, lda, error)
      character(len=*) :: name           !
      character(len=*) :: uplo           !
      integer :: n                       !
      integer :: lda                     !
      real(8) :: a(lda,*)                 !
      logical :: error                   !
    end subroutine mth_dpotrf
  end interface
  !
  interface
    subroutine mth_dpotrs (name,   &
         &    uplo, n, nrhs, a, lda, b, ldb, info )
      character(len=*) :: name           !
      character(len=*) :: uplo           !
      integer :: n                       !
      integer :: nrhs                    !
      integer :: lda                     !
      real(8) :: a(lda,*)                 !
      integer :: ldb                     !
      real(8) :: b(ldb,*)                 !
      ! Local
      integer :: info
      logical :: error
      !
      !  Purpose
      !  =======
      !
      !  DPOTRS solves a system of linear equations A*X = B with a symmetric
      !  positive definite matrix A using the Cholesky factorization
      !  A = U**T*U or A = L*L**T computed by DPOTRF.
      !
      !  Arguments
      !  =========
      !
      !  UPLO    (input) CHARACTER*1
      !          = 'U':  Upper triangle of A is stored;
      !          = 'L':  Lower triangle of A is stored.
      !
      !  N       (input) INTEGER
      !          The order of the matrix A.  N >= 0.
      !
      !  NRHS    (input) INTEGER
      !          The number of right hand sides, i.e., the number of columns
      !          of the matrix B.  NRHS >= 0.
      !
      !  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
      !          The triangular factor U or L from the Cholesky factorization
      !          A = U**T*U or A = L*L**T, as computed by DPOTRF.
      !
      !  LDA     (input) INTEGER
      !          The leading dimension of the array A.  LDA >= max(1,N).
      !
      !  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
      !          On entry, the right hand side matrix B.
      !          On exit, the solution matrix X.
      !
      !  LDB     (input) INTEGER
      !          The leading dimension of the array B.  LDB >= max(1,N).
      !
      !  INFO    (output) INTEGER
      !          = 0:  successful exit
      !          < 0:  if INFO = -i, the i-th argument had an illegal value
      !
      ! Call LAPACK routine
    end subroutine mth_dpotrs
  end interface
  !
  interface
    subroutine mth_dpbtrf (name, uplo, n, kd, ab, ldab, error)
      character(len=*) :: name             !
      character(len=*) :: uplo             !
      integer :: n                         !
      integer :: kd                        !
      integer :: ldab                      !
      real(8) :: ab(ldab,*)                 !
      logical :: error                     !
    end subroutine mth_dpbtrf
  end interface
  !
  interface
    subroutine mth_dpbtrs (name,   &
         &    uplo, n, kd, nrhs, ab, ldab, b, ldb, error)
      character(len=*) :: name             !
      character(len=*) :: uplo             !
      integer :: n                         !
      integer :: kd                        !
      integer :: nrhs                      !
      integer :: ldab                      !
      real(8) :: ab(ldab,*)                 !
      integer :: ldb                       !
      real(8) :: b(ldb,*)                   !
      logical :: error                     !
    end subroutine mth_dpbtrs
  end interface
  !
  interface
    subroutine mth_fail (fac,prog,ifail,error)
      use gbl_message
      !---------------------------------------------------------------------
      ! Error handling routine
      !---------------------------------------------------------------------
      character(len=*) :: fac           !
      character(len=*) :: prog          !
      integer :: ifail                  !
      logical :: error                  !
    end subroutine mth_fail
  end interface
  !
  interface
    subroutine overlap(a,n,b,m,c,k)
      !
      ! Find the intersection of ensembles A and B
      !
      integer, intent(in) :: n
      integer, intent(in) :: a(n)
      integer, intent(in) :: m
      integer, intent(in) :: b(m)
      integer, intent(inout) :: k
      integer, intent(inout) ::c(*)
    end subroutine overlap
  end interface
  !
  interface
    subroutine union(a,n,b,m,c,k)
      !
      ! Find the Union of ensembles A and B
      !
      integer, intent(in) :: n
      integer, intent(in) :: a(n)
      integer, intent(in) :: m
      integer, intent(in) :: b(m)
      integer, intent(inout) :: k
      integer, intent(inout) ::c(*)
    end subroutine union
  end interface
  !
  interface
    subroutine do_fft (nx,ny,nf,fft,work)
      integer, intent(in)  :: nx                     !
      integer, intent(in)  :: ny                     !
      integer, intent(in)  :: nf                     !
      complex, intent(inout) :: fft(nx,ny,nf)
      real, intent(inout)  :: work(2*max(nx,ny))
    end subroutine do_fft
  end interface
  !
  interface
    subroutine do_uv_average(rname,hin,hou,numchan,nc,error)
      use gildas_def
      use image_def
      use gbl_format
      use gbl_message
      !---------------------------------------------------------------------
      ! GILDAS
      !	Compress an input UV table
      !---------------------------------------------------------------------
      character(len=*), intent(in) :: rname
      type(gildas), intent(in) :: hin
      type(gildas), intent(inout) :: hou
      integer, intent(in) :: numchan
      integer, intent(in) :: nc(numchan)
      logical, intent(out) :: error
    end subroutine do_uv_average
  end interface
  !
  interface
    subroutine uvshort_convol (du,dv,resu,conv)
      use clean_def
      !------------------------------------------------------------------------  
      !
      ! Compute convolving factor resu
      ! resu is the result of the multiplication of the convolution functions,
      ! for u and v axes, at point (du,dv)
      !
      ! Convolution function is defined in "conv"
      !------------------------------------------------------------------------  
      real, intent(out) :: resu
      real, intent(in) :: du,dv
      type(gridding), intent(in) :: conv
    end subroutine uvshort_convol
  end interface
  !
  interface
    subroutine uvshort_doconv (nd,np,visi,jx,jy,jo,we,gwe,&
      &   nc,nx,ny,map,mapx,mapy,sup,cell,maxw,conv)
      use clean_def
      !------------------------------------------------------------------------  
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Convolution of 'map' by function defined by "conv" 
      ! Used for gridding of Single Dish data.
      !------------------------------------------------------------------------  
      integer, intent(in) :: np              ! number of visibilities
      integer, intent(in) :: nd              ! visibility size
      integer, intent(in) :: nc              ! number of channels
      integer, intent(in) :: nx,ny           ! map size
      integer, intent(in) :: jx,jy           ! x coord, y coord location in visi
      real, intent(in) :: we(np)             ! weights
      integer, intent(in) :: jo              ! offset for data in visi
      real, intent(in) :: visi(nd,np)        ! values
      real, intent(out) :: gwe(nx,ny)        ! gridded weights
      real, intent(out) :: map(nc,nx,ny)     ! gridded values
      real, intent(in) :: mapx(nx),mapy(ny)  ! coordinates of grid
      real, intent(in) :: sup(2)             ! support of convolving function in user units
      real, intent(in) :: cell(2)            ! cell size in user units
      real, intent(out) :: maxw              ! maximum weight
      type(gridding), intent(in) :: conv
    end subroutine uvshort_doconv
  end interface
  !
  interface
    subroutine uvshort_dosmoo (raw,we,nc,nx,ny,map,mapx,mapy,sup,cell,conv)
      use clean_def
      !------------------------------------------------------------------------  
      ! Task UV_SHORT
      !   Internal routine
      !
      ! Smooth an input data cube raw in vlm along l and m by convolution
      ! by a gaussian function defined in "conv"
      !------------------------------------------------------------------------  
      integer, intent(in) :: nc,nx,ny          ! map size
      real, intent(in) :: we(nx,ny)            ! weights
      real, intent(in) :: raw(nc,nx,ny)        ! raw map
      real, intent(out) :: map(nc,nx,ny)       ! smoothed map
      real, intent(in) :: mapx(nx),mapy(ny)    ! coordinates of grid
      real, intent(in) :: sup(2)               ! support of convolving function in user units
      real, intent(in) :: cell(2)              ! cell size in user units
      type(gridding), intent(in) :: conv
    end subroutine uvshort_dosmoo
  end interface
  !
  interface
    subroutine uvshort_dowei (visi,nd,np,we,iw)
      !------------------------------------------------------------------------  
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Fill in weights array from the input table
      !------------------------------------------------------------------------  
      integer, intent(in) :: nd       ! Visibility size
      integer, intent(in) :: np       ! Number of visibilities
      integer, intent(in) :: iw       ! Weight column
      real, intent(in) :: visi(nd,np) ! Visibilities
      real, intent(out) :: we(np)     ! Weight values
    end subroutine uvshort_dowei
  end interface
  !
  interface
    subroutine uvshort_findr (nv,nc,ic,xx,xlim,nlim)
      !------------------------------------------------------------------------  
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Find nlim such as
      !   xx(ic,nlim-1) < xlim < xx(ic,nlim)
      ! for input data ordered, retrieved from memory
      ! assumes nlim already preset so that xx(ic,nlim-1) < xlim
      !
      !------------------------------------------------------------------------  
      integer, intent(in) :: nv       ! Number of visibilities
      integer, intent(in) :: nc       ! Size of a visibility
      integer, intent(in) :: ic       ! COlumn to be tested
      integer, intent(inout) :: nlim
      real, intent(in) ::  xx(nc,nv),xlim
    end subroutine uvshort_findr
  end interface
  !
  interface
    subroutine uvshort_finsiz (x,nd,np,ix,iy,we,xmin,xmax,ymin,ymax)
      !------------------------------------------------------------------------  
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Find extrema xmin, xmax in ix column values
      !          and ymin, ymax in iy column values,
      ! in table x(nd,np) for points where weight is not null
      ! taking in account that table x is ordered on iy column values.
      !
      !------------------------------------------------------------------------  
      integer, intent(in) :: nd,np    ! Table size
      integer, intent(in) :: ix,iy    ! X and Y column pointers
      real, intent(in) :: x(nd,np)    ! Table data
      real, intent(in) :: we(np)      ! Weights
      real, intent(out) :: xmin,xmax,ymin,ymax  ! Min-Max
    end subroutine uvshort_finsiz
  end interface
  !
  interface
    subroutine uvshort_dosor (rname,visi,nd,np,we,iy,error)
      use gildas_def
      use gbl_message
      !------------------------------------------------------------------------  
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Output Visi(nd,np) will contain Ycol column values in increasing order
      ! Uses procedure trione
      ! WE is used as work space only
      !------------------------------------------------------------------------  
      character(len=*), intent(in) :: rname
      integer, intent(in) :: nd,np,iy
      real, intent(inout) :: visi(nd,np)   ! Visibilities,we(nd)
      real, intent(inout) :: we(nd)        ! Work space for sorting
      logical, intent(out) :: error
    end subroutine uvshort_dosor
  end interface
  !
  interface
    subroutine uvshort_doapod (xmin,xmax,ymin,ymax,tole,beam,&
         nc,nx,ny,map,raw,mapx,mapy, weight,wmin)
      !---------------------------------------------------------------------
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Replace map edges and bad quality values of raw input data cube
      ! with smoothed values contains in mapx data cube.
      ! Map edges corresponding to the part of the map between
      ! max SD observations locations xmin,xmax,ymin,ymax, and map size nx,ny
      ! Bad quality values corresponding to weights < wmin
      !---------------------------------------------------------------------
      integer nc,nx,ny
      real mapx(nx),mapy(ny)
      real map(nc,nx,ny)
      real raw(nc,nx,ny)
      real beam,tole,xmin,xmax,ymin,ymax
      real weight(nx,ny),wmin
    end subroutine uvshort_doapod
  end interface
  !
  interface
    subroutine uvshort_dosdft(beam,diam,f,nx,ny,fact,lmv)
      use image_def
      !---------------------------------------------------------------------
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! computes inverse of ft of single-dish beam
      ! (uses a gaussian truncated at dish size)
      !---------------------------------------------------------------------
      type(gildas), intent(in) :: lmv     ! LMV header
      integer, intent(in) ::  nx, ny      ! Problem size
      real, intent(out) ::  f(nx,ny)      ! (real part of the) TF of beam
      real, intent(in) ::  beam           ! Beam size in radian
      real, intent(in) ::  diam           ! Antenna diameter in meter
      real, intent(in) ::  fact           ! Scale factor
    end subroutine uvshort_dosdft
  end interface
  !
  interface
    subroutine uvshort_dointft(beam,diam,f,nx,ny,fact,lmv)
      use image_def
      !---------------------------------------------------------------------
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! computes ft of single-dish beam
      ! (uses a gaussian truncated at dish size)
      !---------------------------------------------------------------------
      type(gildas), intent(in) :: lmv     ! LMV header
      integer, intent(in) ::  nx, ny      ! Problem size
      real, intent(out) ::  f(nx,ny)      ! (real part of the) TF of beam
      real, intent(in) ::  beam           ! Beam size in radian
      real, intent(in) ::  diam           ! Antenna diameter in meter
      real, intent(in) ::  fact           ! Scale factor
    end subroutine uvshort_dointft
  end interface
  !
  interface
    subroutine uvshort_shift(f,nx,ny,offra,offdec,lmv)
      use image_def
      !---------------------------------------------------------------------
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Centered interferometer beam f(nx,ny) of a mosaic field
      ! on is right position : offra and offdec shifted in uv plane
      !---------------------------------------------------------------------
      type(gildas), intent(in) :: lmv
      integer, intent(in) :: nx, ny
      complex, intent(inout) :: f(nx,ny)
      real, intent(in) :: offra, offdec
    end subroutine uvshort_shift
  end interface
  !
  interface
    subroutine uvshort_dotrans (a,b,n,m)
      !
      ! Output table "b" is table "a" transposed in line/column order
      !
      integer, intent(in) :: n,m
      real, intent(in) :: a(n,m)
      real, intent(out) ::  b(m,n)
    end subroutine uvshort_dotrans
  end interface
  !
  interface
    subroutine uvshort_prmult(z,f,nx,ny)
      !
      ! Update z(nx,ny) table with z*f, calculate in uv plane
      ! Used to multiply by interferometer primary beam
      !
      integer, intent(in) :: nx, ny         ! Problem size
      complex, intent(inout) :: z(nx, ny)   ! Complex values
      real, intent(in) :: f(nx,ny)          ! Multiplication function
    end subroutine uvshort_prmult
  end interface
  !
  interface
    subroutine uvshort_uvcount(nx,ny,nvis,diam,lmv)
      use image_def
      !---------------------------------------------------------------------
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Compute number of visibilities nvis sampled on
      ! a regular grid of steps dx,dy inside the dish defined by diam
      ! nx and ny needed because uvcount is working in Fourier plane
      !---------------------------------------------------------------------
      !
      type(gildas), intent(in) :: lmv   ! Input GILDAS image
      integer, intent(in) :: nx         ! X image size
      integer, intent(in) :: ny         ! Y image size
      integer, intent(out) :: nvis      ! Number of visibilities
      real, intent(in) :: diam          ! Telescope diameter
    end subroutine uvshort_uvcount
  end interface
  !
  interface
    subroutine uvshort_uvtable(nx,ny,nd,nc,v,w,ww,nvis,diam,wfactor,factor,lmv)
      use image_def
      !---------------------------------------------------------------------
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Tabulate the visibilities
      !---------------------------------------------------------------------
      !
      integer, intent(in) :: nx   ! X Image size
      integer, intent(in) :: ny   ! Y Image size
      integer, intent(in) :: nc   ! Number of channels
      integer, intent(in) :: nd   ! Visibility size
      integer, intent(in) :: nvis ! Number of visibilities
      complex, intent(in) :: v(nx,ny,nc)  ! Gridded visibilities
      complex, intent(in) :: ww(nx,ny)    ! Complex weights
      real, intent(out) :: w(nd,nvis)     ! Resulting visibilities
      real, intent(in) :: wfactor ! Weight factor
      real, intent(in) :: diam    ! Telescope diameter, factor
      real, intent(in) :: factor  ! Intensity factor
      type(gildas), intent(in) :: lmv     ! Input image
    end subroutine uvshort_uvtable
  end interface
  !
  interface
    subroutine uvshort_dopoint(data,nd,np,xcol,ycol,old,new)
      !---------------------------------------------------------------------
      ! IMAGER
      !   Support routine for command UV_SHORT
      !
      ! Recompute data(nd,np) xcol and ycol coordinates values
      ! in case of changing reference position a0 d0 from old to new
      !---------------------------------------------------------------------
      !
      integer, intent(in) :: nd         ! Size of a visibility
      integer, intent(in) :: np          ! Number of visibilities
      integer, intent(in) :: xcol        ! RA offset pointer
      integer, intent(in) :: ycol        ! Dec offset pointer
      real, intent(inout) :: data(nd,np) ! Visibilities
      real(8), intent(in) :: old(2)      ! Old RA and Dec center
      real(8), intent(in) :: new(2)      ! New Ra and Dec center
    end subroutine uvshort_dopoint
  end interface
  !
  interface
    subroutine do_sliceb(in, nx, ny, nc, x, y, out, np, blank, eblank)
      use gildas_def
      integer(kind=index_length), intent(in) :: nx  ! Number of X pixels
      integer(kind=index_length), intent(in) :: ny  ! Number of Y pixels
      integer(kind=index_length), intent(in) :: nc  ! Number of channels
      real, intent(in) :: in(nx,ny,nc)              ! Input cube
      integer :: np                                 ! Number of points
      real, intent(in) :: x(np)                     ! X coordinates
      real, intent(in) :: y(np)                     ! Y coordinates
      real, intent(out) :: out(np,nc)               ! Output slice
      real, intent(in) :: blank                     ! Blanking
      real, intent(in) :: eblank                    ! and tolerance
    end subroutine do_sliceb
  end interface
  !
  interface
    subroutine fill_gu(ipgu, ds, dt, np)
      integer, intent(in) :: np                      ! Number of points
      real, intent(out) :: ipgu(np)                  ! Output grid
      real(8), intent(in) :: ds                      ! Starting value
      real(8), intent(in) :: dt                      ! Step
    end subroutine fill_gu
  end interface
  !
  interface
    function pix_axis (head, user, iaxis)
      use image_def
      real(8), intent(in) :: user       ! User coordinates
      type(gildas), intent(in) :: head  ! Image header
      integer, intent(in) :: iaxis      ! Axis
      integer :: pix_axis ! intent(out) ! corresponding pixel 
    end function pix_axis
  end interface
  !
  interface
    subroutine sub_extract(a,na1,na2,na3,na4,   &
         &    b,nb1,nb2,nb3,nb4,ni,nu,np,blank)
      use gildas_def
      integer(kind=index_length) :: na1                    !
      integer(kind=index_length) :: na2                    !
      integer(kind=index_length) :: na3                    !
      integer(kind=index_length) :: na4                    !
      real, intent(in) :: a(na1,na2,na3,na4)               !
      integer(kind=index_length) :: nb1                    !
      integer(kind=index_length) :: nb2                    !
      integer(kind=index_length) :: nb3                    !
      integer(kind=index_length) :: nb4                    !
      real, intent(inout) :: b(nb1,nb2,nb3,nb4)            !
      integer(kind=index_length) :: ni(4)                  !
      integer(kind=index_length) :: nu(4)                  !
      integer(kind=index_length) :: np(4)                  !
      real, intent(in) :: blank                            !
    end subroutine sub_extract 
  end interface
  !
end module imager_interfaces_none
