#!/usr/bin/perl

use strict;
use Getopt::Std;
use Net::SMTP;

#
# Check options and arguments
#

my %opts;
if (!getopts('hs:', \%opts) || $opts{h} || @ARGV == 0) {
    die "Usage: $0 -s subject to-addr\n";
}

my @recipients = @ARGV;


#
# Send mail
#

sub send_mail {
    my $subject = shift;
    my $message = shift;
    my @recipients = @_;

    # Add @iram.fr if needed and remove duplicates
    @recipients = map { s/^([^\@]+)$/$1\@iram.fr/; $_ } @recipients;
    my %uniq = map { $_ => 1 } @recipients;
    @recipients = keys %uniq;

    my $smtp = Net::SMTP->new("smtp.iram.fr");
    # use getpwuid because getlogin() don't work inside newgrp call
    (my $user_name) = getpwuid( $<);
    $smtp->mail( $user_name.'@iram.fr');
    $smtp->to( @recipients);
    $smtp->data( );
    $smtp->datasend( "To: ".join( ", ", @recipients)."\n");
    $smtp->datasend( "Reply-To: noreply\n");
    $smtp->datasend( "Subject: $subject\n");
    $smtp->datasend( $message);
    $smtp->dataend( );
    $smtp->quit;
}

#
# read message from standard input
#

my $message;
while (<STDIN>) {
    $message .= $_;
}

#
# send mail
#

my $subject = $opts{s} ? $opts{s} : "no subject";
send_mail( $subject, $message, @recipients);

