--# -path=.:../prelude:../abstract:../common:../scandinavian

-- This dictionary is derived from SALDO, see:
--
--   Borin, Lars, Markus Forsberg and Lennart Lönngren 2008.
--   The hunting of the BLARK - SALDO, a freely available lexical database for 
--   Swedish language technology. Resourceful language technology.
--   Festschrift in honor of Anna Sågvall Hein, ed. by Joakim Nivre, 
--   Mats Dahllöf and Beáta Megyesi. 
--   Acta Universitatis Upsaliensis: Studia Linguistica Upsaliensia 7. 21-32.
--   <http://spraakbanken.gu.se/personal/lars/pblctns/ash-fs-080605.pdf>
--
-- Imported in GF by Krasimir Angelov
--
-- This resource is distributed under the free software license LGPL 3.0 or 
-- Creative Commons Attribution-Share Alike 2.5 Generic. 

concrete DictSwe of DictSweAbs = CatSwe ** open ParadigmsSwe in {

flags
  optimize=values ; coding=utf8 ;

lin
  A_vitamin_nn_1 = mkN "A-vitamin" "A-vitaminet" "A-vitaminer" "A-vitaminerna" ;
  A_vitaminbrist_nn_1 = mkN "A-vitaminbrist" "A-vitaminbrister" ;
  Antarktisfoerdrag_nn_1 = mkN "Antarktisfцrdrag" neutrum ;
  Antarktisprojekt_nn_1 = mkN "Antarktisprojekt" neutrum ;
  Arianeraket_nn_1 = mkN "Arianeraket" "Arianeraketer" ;
  B_vitamin_nn_1 = mkN "B-vitamin" "B-vitaminet" "B-vitaminer" "B-vitaminerna" ;
  B_vitaminbrist_nn_1 = mkN "B-vitaminbrist" "B-vitaminbrister" ;
  C_vitamin_nn_1 = mkN "C-vitamin" "C-vitaminet" "C-vitaminer" "C-vitaminerna" ;
  Celsius_ab_1 = mkAdv "Celsius" ;
  DNA_kedja_nn_1 = mkN "DNA-kedja" ;
  DNA_molekyl_nn_1 = mkN "DNA-molekyl" "DNA-molekyler" ;
  DNA_uppsaettning_nn_1 = mkN "DNA-uppsдttning" ;
  Efta_land_nn_1 = mkN "Efta-land" "Efta-landet" "Efta-lдnder" "Efta-lдnderna" ;
  Gudi_ab_1 = mkAdv "Gudi" ;
  Hiroshimabomb_nn_1 = mkN "Hiroshimabomb" "Hiroshimabomber" ;
  ID_kort_nn_1 = mkN "ID-kort" neutrum ;
  I_land_nn_1 = mkN "I-land" "I-landet" "I-lдnder" "I-lдnderna" ;
  Jantelag_nn_1 = mkN "Jantelag" ;
  Jupitermaane_nn_1 = mkN "Jupitermеne" utrum ;
  Koechelnummer_nn_1 = mkN "Kцchelnummer" neutrum ;
  Kubakris_nn_1 = mkN "Kubakris" "Kubakriser" ;
  LO_chef_nn_1 = mkN "LO-chef" "LO-chefer" ;
  LO_ordfoerande_nn_1 = mkN "LO-ordfцrande" "LO-ordfцranden" "LO-ordfцrande" "LO-ordfцrandena" ;
  Linkoepingsbo_nn_1 = mkN "Linkцpingsbo" "Linkцpingsbor" ;
  MAO_aktivitet_nn_1 = mkN "MAO-aktivitet" "MAO-aktiviteter" ;
  MAO_enzym_nn_1 = mkN "MAO-enzym" neutrum ;
  Medelhavsland_nn_1 = mkN "Medelhavsland" "Medelhavslandet" "Medelhavslдnder" "Medelhavslдnderna" ;
  Mosebok_nn_1 = mkN "Mosebok" "Mosebцcker" ;
  OECD_land_nn_1 = mkN "OECD-land" "OECD-landet" "OECD-lдnder" "OECD-lдnderna" ;
  PCB_foerbud_nn_1 = mkN "PCB-fцrbud" neutrum ;
  PCB_foerening_nn_1 = mkN "PCB-fцrening" ;
  PCB_foergiftning_nn_1 = mkN "PCB-fцrgiftning" ;
  PCB_halt_nn_1 = mkN "PCB-halt" "PCB-halter" ;
  PCB_olja_nn_1 = mkN "PCB-olja" ;
  PR_man_nn_1 = mkN "PR-man" "PR-mannen" "PR-mдn" "PR-mдnnen" ;
  Papyrusaktie_nn_1 = mkN "Papyrusaktie" "Papyrusaktier" ;
  SAP_program_nn_1 = mkN "SAP-program" "SAP-programmet" "SAP-program" "SAP-programmen" ;
  SAS_chef_nn_1 = mkN "SAS-chef" "SAS-chefer" ;
  SCOPE_rapport_nn_1 = mkN "SCOPE-rapport" "SCOPE-rapporter" ;
  Salazar_regim_nn_1 = mkN "Salazar-regim" "Salazar-regimer" ;
  TV_antenn_nn_1 = mkN "TV-antenn" "TV-antenner" ;
  TV_apparat_nn_1 = mkN "TV-apparat" "TV-apparater" ;
  TV_bild_nn_1 = mkN "TV-bild" "TV-bilder" ;
  TV_chef_nn_1 = mkN "TV-chef" "TV-chefer" ;
  TV_kamera_nn_1 = mkN "TV-kamera" ;
  TV_kanal_nn_1 = mkN "TV-kanal" "TV-kanaler" ;
  TV_konferens_nn_1 = mkN "TV-konferens" "TV-konferenser" ;
  TV_mottagare_nn_1 = mkN "TV-mottagare" "TV-mottagare" ;
  TV_producent_nn_1 = mkN "TV-producent" "TV-producenter" ;
  TV_program_nn_1 = mkN "TV-program" "TV-programmet" "TV-program" "TV-programmen" ;
  TV_reparatoer_nn_1 = mkN "TV-reparatцr" "TV-reparatцrer" ;
  TV_saendning_nn_1 = mkN "TV-sдndning" ;
  TV_serie_nn_1 = mkN "TV-serie" "TV-serier" ;
  TV_skaerm_nn_1 = mkN "TV-skдrm" ;
  TV_studio_nn_1 = mkN "TV-studio" "TV-studior" ;
  TV_tittare_nn_1 = mkN "TV-tittare" "TV-tittare" ;
  Tjernobylnedfall_nn_1 = mkN "Tjernobylnedfall" neutrum ;
  U_land_nn_1 = mkN "U-land" "U-landet" "U-lдnder" "U-lдnderna" ;
  Vietnamkrig_nn_1 = mkN "Vietnamkrig" neutrum ;
  Z_partikel_nn_1 = mkN "Z-partikel" ;
  aa_nn_2 = mkN "е" ;
  aabaekig_av_1 = mkA "еbдkig" ;
  aabo_nn_1 = mkN "еbo" "еbor" ;
  aadaga_ab_1 = mkAdv "еdaga" ;
  aader_nn_1 = mkN "еder" "еdern" "еdror" "еdrorna" ;
  aaderbraack_nn_1 = mkN "еderbrеck" neutrum ;
  aaderhinna_nn_1 = mkN "еderhinna" ;
  aaderlaata_vb_1 = mkV "еderlеta" "еderlдt" "еderlеtit" ;
  aadra_nn_1 = mkN "еdra" ;
  aadra_vb_1 = mkV "еdra" "еdrar" "еdra" "еdrog" "еdragit" "еdragen" ;
  aadrig_av_1 = mkA "еdrig" ;
  aadring_nn_1 = mkN "еdring" ;
  aahoerardag_nn_1 = mkN "еhцrardag" ;
  aahoerare_nn_1 = mkN "еhцrare" "еhцrare" ;
  aahoerarplats_nn_1 = mkN "еhцrarplats" "еhцrarplatser" ;
  aak_nn_1 = mkN "еk" neutrum ;
  aakare_nn_1 = mkN "еkare" "еkare" ;
  aakarkamp_nn_1 = mkN "еkarkamp" ;
  aakdon_nn_1 = mkN "еkdon" neutrum ;
  aaker_nn_1 = mkN "еker" ;
  aakeraert_nn_1 = mkN "еkerдrt" "еkerдrter" ;
  aakerbaer_nn_1 = mkN "еkerbдr" neutrum ;
  aakerbit_nn_1 = mkN "еkerbit" ;
  aakerbruk_nn_1 = mkN "еkerbruk" neutrum ;
  aakerbrukare_nn_1 = mkN "еkerbrukare" "еkerbrukare" ;
  aakerfaelt_nn_1 = mkN "еkerfдlt" neutrum ;
  aakerfraeken_nn_1 = mkN "еkerfrдken" "еkerfrдkenn" "еkerfrдknar" "еkerfrдknarna" ;
  aakergaerde_nn_1 = mkN "еkergдrde" ;
  aakeri_nn_1 = mkN "еkeri" "еkerit" "еkerier" "еkerierna" ;
  aakerjord_nn_1 = mkN "еkerjord" ;
  aakerlapp_nn_1 = mkN "еkerlapp" ;
  aakermark_nn_1 = mkN "еkermark" "еkermarker" ;
  aakerren_nn_1 = mkN "еkerren" "еkerrenen" "еkerrenar" "еkerrenarna" ;
  aakersork_nn_1 = mkN "еkersork" ;
  aakerspergel_nn_1 = mkN "еkerspergel" ;
  aakerteg_nn_1 = mkN "еkerteg" ;
  aakertistel_nn_1 = mkN "еkertistel" ;
  aakervaext_nn_1 = mkN "еkervдxt" "еkervдxter" ;
  aakervall_nn_1 = mkN "еkervall" ;
  aaklagare_nn_1 = mkN "еklagare" "еklagare" ;
  aaklagarmyndighet_nn_1 = mkN "еklagarmyndighet" "еklagarmyndigheter" ;
  aakning_nn_1 = mkN "еkning" ;
  aakpaase_nn_1 = mkN "еkpеse" utrum ;
  aakroek_nn_1 = mkN "еkrцk" ;
  aaksjuk_av_1 = mkA "еksjuk" ;
  aaktur_nn_1 = mkN "еktur" "еkturer" ;
  aal_nn_1 = mkN "еl" ;
  aalaendsk_av_1 = mkA "еlдndsk" ;
  aalaendska_nn_2 = mkN "еlдndska" ;
  aalaenning_nn_1 = mkN "еlдnning" ;
  aalandsrot_nn_1 = mkN "еlandsrot" "еlandsrцtter" ;
  aalder_nn_1 = mkN "еlder" ;
  aalderdom_nn_1 = mkN "еlderdom" ;
  aalderdomlig_av_1 = mkA "еlderdomlig" ;
  aalderdomsfoersaekring_nn_1 = mkN "еlderdomsfцrsдkring" ;
  aalderdomshem_nn_1 = mkN "еlderdomshem" "еlderdomshemmet" "еlderdomshem" "еlderdomshemmen" ;
  aalderdomspension_nn_1 = mkN "еlderdomspension" "еlderdomspensioner" ;
  aalderdomssvag_av_1 = mkA "еlderdomssvag" ;
  aalderman_nn_1 = mkN "еlderman" "еldermannen" "еldermдn" "еldermдnnen" ;
  aaldersbestaemning_nn_1 = mkN "еldersbestдmning" ;
  aaldersbetyg_nn_1 = mkN "еldersbetyg" neutrum ;
  aaldersfoeraendring_nn_1 = mkN "еldersfцrдndring" ;
  aaldersfoerdelning_nn_1 = mkN "еldersfцrdelning" ;
  aaldersgraens_nn_1 = mkN "еldersgrдns" "еldersgrдnser" ;
  aaldersgrupp_nn_1 = mkN "еldersgrupp" "еldersgrupper" ;
  aaldersklass_nn_1 = mkN "еldersklass" "еldersklasser" ;
  aalderslaangsynthet_nn_1 = mkN "еlderslеngsynthet" "еlderslеngsyntheter" ;
  aalderspension_nn_1 = mkN "еlderspension" "еlderspensioner" ;
  aalderspresident_nn_1 = mkN "еlderspresident" "еlderspresidenter" ;
  aaldersskael_nn_1 = mkN "еldersskдl" neutrum ;
  aaldersskillnad_nn_1 = mkN "еldersskillnad" "еldersskillnader" ;
  aaldersspaerr_nn_1 = mkN "еldersspдrr" ;
  aaldersstadium_nn_1 = mkN "еldersstadium" "еldersstadiet" "еldersstadier" "еldersstadierna" ;
  aaldersstruktur_nn_1 = mkN "еldersstruktur" "еldersstrukturer" ;
  aalderssvag_av_1 = mkA "еlderssvag" ;
  aalderstecken_nn_1 = mkN "еlderstecken" "еlderstecknet" "еlderstecken" "еlderstecknen" ;
  aalderstigen_av_1 = mkA "еlderstigen" "еlderstiget" ;
  aalderstillaegg_nn_1 = mkN "еlderstillдgg" neutrum ;
  aalderstyngd_av_1 = mkA "еlderstyngd" "еlderstyngt" ;
  aaldfru_nn_1 = mkN "еldfru" ;
  aaldrig_av_1 = mkA "еldrig" ;
  aaldring_nn_1 = mkN "еldring" ;
  aalfiskare_nn_1 = mkN "еlfiskare" "еlfiskare" ;
  aaliggande_nn_1 = mkN "еliggande" ;
  aalskinn_nn_1 = mkN "еlskinn" neutrum ;
  aam_nn_1 = mkN "еm" ;
  aamig_av_1 = mkA "еmig" ;
  aamning_nn_1 = mkN "еmning" ;
  aamynning_nn_1 = mkN "еmynning" ;
  aangackumulator_nn_1 = mkN "еngackumulator" "еngackumulatorer" ;
  aanganlaeggning_nn_1 = mkN "еnganlдggning" ;
  aangare_nn_1 = mkN "еngare" "еngare" ;
  aangbaat_nn_1 = mkN "еngbеt" ;
  aangbageri_nn_1 = mkN "еngbageri" "еngbagerit" "еngbagerier" "еngbagerierna" ;
  aangblaester_nn_1 = mkN "еngblдster" ;
  aangcentral_nn_1 = mkN "еngcentral" "еngcentraler" ;
  aangdriven_av_1 = mkA "еngdriven" "еngdrivet" ;
  aangerfull_av_1 = mkA "еngerfull" ;
  aangerkoept_av_1 = mkA "еngerkцpt" "еngerkцpt" ;
  aangermanlaendsk_av_1 = mkA "еngermanlдndsk" ;
  aangermanlaenning_nn_1 = mkN "еngermanlдnning" ;
  aangervecka_nn_1 = mkN "еngervecka" ;
  aangestfull_av_1 = mkA "еngestfull" ;
  aangestfylld_av_1 = mkA "еngestfylld" "еngestfyllt" ;
  aangestneuros_nn_1 = mkN "еngestneuros" "еngestneuroser" ;
  aangfartyg_nn_1 = mkN "еngfartyg" neutrum ;
  aanggenerator_nn_1 = mkN "еnggenerator" "еnggeneratorer" ;
  aangkoek_nn_1 = mkN "еngkцk" neutrum ;
  aangkokare_nn_1 = mkN "еngkokare" "еngkokare" ;
  aangkol_nn_1 = mkN "еngkol" neutrum ;
  aangkraftverk_nn_1 = mkN "еngkraftverk" neutrum ;
  aanglok_nn_1 = mkN "еnglok" neutrum ;
  aanglokomotiv_nn_1 = mkN "еnglokomotiv" neutrum ;
  aangmaskin_nn_1 = mkN "еngmaskin" "еngmaskiner" ;
  aangning_nn_1 = mkN "еngning" ;
  aangslup_nn_1 = mkN "еngslup" ;
  aangstroem_nn_1 = mkN "еngstrцm" "еngstrцmen" "еngstrцm" "еngstrцmen" ;
  aangstrykjaern_nn_1 = mkN "еngstrykjдrn" neutrum ;
  aangtryck_nn_1 = mkN "еngtryck" neutrum ;
  aangturbin_nn_1 = mkN "еngturbin" "еngturbiner" ;
  aangvaelt_nn_1 = mkN "еngvдlt" ;
  aangvinsch_nn_1 = mkN "еngvinsch" ;
  aangvissla_nn_1 = mkN "еngvissla" ;
  aanyo_ab_1 = mkAdv "еnyo" ;
  aapen_av_1 = mkA "еpen" "еpet" ;
  aar_nn_1 = mkN "еr" neutrum ;
  aarblad_nn_1 = mkN "еrblad" neutrum ;
  aarbraeckt_av_1 = mkA "еrbrдckt" "еrbrдckt" ;
  aarder_nn_1 = mkN "еrder" neutrum ;
  aaretruntbostad_nn_1 = mkN "еretruntbostad" "еretruntbostдder" ;
  aarfot_nn_1 = mkN "еrfot" "еrfцtter" ;
  aargaang_nn_1 = mkN "еrgеng" ;
  aargaangsvin_nn_1 = mkN "еrgеngsvin" "еrgеngsvinet" "еrgеngsviner" "еrgеngsvinerna" ;
  aaring_nn_1 = mkN "еring" ;
  aarlig_av_1 = mkA "еrlig" ;
  aarligen_ab_1 = mkAdv "еrligen" ;
  aarlom_nn_1 = mkN "еrlom" "еrlommen" "еrlommar" "еrlommarna" ;
  aarmiljon_nn_1 = mkN "еrmiljon" "еrmiljoner" ;
  aarpinne_nn_1 = mkN "еrpinne" utrum ;
  aarsavgift_nn_1 = mkN "еrsavgift" "еrsavgifter" ;
  aarsbaesta_av_1 = mkA "еrsbдsta" ;
  aarsbarn_nn_1 = mkN "еrsbarn" neutrum ;
  aarsberaettelse_nn_1 = mkN "еrsberдttelse" "еrsberдttelser" ;
  aarsbok_nn_1 = mkN "еrsbok" "еrsbцcker" ;
  aarsbokstav_nn_1 = mkN "еrsbokstav" "еrsbokstдver" ;
  aarscykel_nn_1 = mkN "еrscykel" ;
  aarsdag_nn_1 = mkN "еrsdag" ;
  aarsdos_nn_1 = mkN "еrsdos" "еrsdoser" ;
  aarsinkomst_nn_1 = mkN "еrsinkomst" "еrsinkomster" ;
  aarsklass_nn_1 = mkN "еrsklass" "еrsklasser" ;
  aarskull_nn_1 = mkN "еrskull" ;
  aarskurs_nn_1 = mkN "еrskurs" "еrskurser" ;
  aarsmedeltemperatur_nn_1 = mkN "еrsmedeltemperatur" "еrsmedeltemperaturer" ;
  aarsmodell_nn_1 = mkN "еrsmodell" "еrsmodeller" ;
  aarsmoete_nn_1 = mkN "еrsmцte" ;
  aarsredovisning_nn_1 = mkN "еrsredovisning" ;
  aarsring_nn_1 = mkN "еrsring" ;
  aarstid_nn_1 = mkN "еrstid" "еrstider" ;
  aarstidsvind_nn_1 = mkN "еrstidsvind" ;
  aarstryck_nn_1 = mkN "еrstryck" neutrum ;
  aartag_nn_1 = mkN "еrtag" neutrum ;
  aartal_nn_1 = mkN "еrtal" "еrtalet" "еrtalen" "еrtalena" ;
  aartionde_nn_1 = mkN "еrtionde" ;
  aartull_nn_1 = mkN "еrtull" ;
  aartusende_nn_1 = mkN "еrtusende" ;
  aas_nn_1 = mkN "еs" ;
  aasido_ab_1 = mkAdv "еsido" ;
  aasikt_nn_1 = mkN "еsikt" "еsikter" ;
  aasiktsfoerfoeljelse_nn_1 = mkN "еsiktsfцrfцljelse" "еsiktsfцrfцljelser" ;
  aasiktsfrihet_nn_1 = mkN "еsiktsfrihet" "еsiktsfriheter" ;
  aasiktsmaessig_av_1 = mkA "еsiktsmдssig" ;
  aasiktsriktning_nn_1 = mkN "еsiktsriktning" ;
  aasiktsutbyte_nn_1 = mkN "еsiktsutbyte" ;
  aaskaadare_nn_1 = mkN "еskеdare" "еskеdare" ;
  aaskaadarlaektare_nn_1 = mkN "еskеdarlдktare" "еskеdarlдktare" ;
  aaskaadlig_av_1 = mkA "еskеdlig" ;
  aaskaadning_nn_1 = mkN "еskеdning" ;
  aaskby_nn_1 = mkN "еskby" "еskbyn" "еskbyar" "еskbyarna" ;
  aaskdiger_av_1 = mkA "еskdiger" "еskdigert" "еskdigra" "еskdigra" "еskdigrare" "еskdigrast" "еskdigraste" ;
  aaskfront_nn_1 = mkN "еskfront" "еskfronter" ;
  aaskledare_nn_1 = mkN "еskledare" "еskledare" ;
  aaskmoln_nn_1 = mkN "еskmoln" neutrum ;
  aaskregn_nn_1 = mkN "еskregn" neutrum ;
  aaskvaeder_nn_1 = mkN "еskvдder" neutrum ;
  aasna_nn_1 = mkN "еsna" ;
  aasnedrivare_nn_1 = mkN "еsnedrivare" "еsnedrivare" ;
  aasneskri_nn_1 = mkN "еsneskri" "еsneskrit" "еsneskrin" "еsneskrien" ;
  aasnespark_nn_1 = mkN "еsnespark" ;
  aasstaang_nn_1 = mkN "еsstеng" "еsstдnger" ;
  aastad_ab_1 = mkAdv "еstad" ;
  aastadkomma_vb_1 = mkV "еstadkomma" "еstadkom" "еstadkommit" ;
  aat_ab_1 = mkAdv "еt" ;
  aata_vb_1 = mkV "еta" "еtar" "еta" "еtog" "еtagit" "еtagen" ;
  aatagande_nn_1 = mkN "еtagande" ;
  aatal_nn_1 = mkN "еtal" "еtalet" "еtalen" "еtalena" ;
  aatboerd_nn_1 = mkN "еtbцrd" "еtbцrder" ;
  aatel_nn_1 = mkN "еtel" ;
  aater_ab_1 = mkAdv "еter" ;
  aateranvaendning_nn_1 = mkN "еteranvдndning" ;
  aaterbaering_nn_1 = mkN "еterbдring" ;
  aaterbesoek_nn_1 = mkN "еterbesцk" neutrum ;
  aaterbetalning_nn_1 = mkN "еterbetalning" ;
  aaterblick_nn_1 = mkN "еterblick" ;
  aaterbud_nn_1 = mkN "еterbud" neutrum ;
  aaterfall_nn_1 = mkN "еterfall" neutrum ;
  aaterfalla_vb_1 = mkV "еterfalla" "еterfцll" "еterfallit" ;
  aaterfinna_vb_1 = mkV "еterfinna" "еterfann" "еterfunnit" ;
  aaterflyttning_nn_1 = mkN "еterflyttning" ;
  aaterfoederska_nn_1 = mkN "еterfцderska" ;
  aaterfoerening_nn_1 = mkN "еterfцrening" ;
  aaterfoersaekring_nn_1 = mkN "еterfцrsдkring" ;
  aaterfoersaeljare_nn_1 = mkN "еterfцrsдljare" "еterfцrsдljare" ;
  aatergaa_vb_1 = mkV "еtergе" "еtergеr" "еtergе" "еtergick" "еtergеtt" "еtergеngen" ;
  aaterge_vb_1 = mkV "еterge" "еterger" "еterge" "еtergav" "еtergett" "еtergiven" ;
  aatergivande_nn_1 = mkN "еtergivande" ;
  aatergivning_nn_1 = mkN "еtergivning" ;
  aaterhaalla_vb_1 = mkV "еterhеlla" "еterhцll" "еterhеllit" ;
  aaterhaallsam_av_1 = mkA "еterhеllsam" "еterhеllsamt" "еterhеllsamma" "еterhеllsamma" "еterhеllsammare" "еterhеllsammast" "еterhеllsammaste" ;
  aaterigen_ab_1 = mkAdv "еterigen" ;
  aaterkallelse_nn_1 = mkN "еterkallelse" "еterkallelser" ;
  aaterknyta_vb_1 = mkV "еterknyta" "еterknцt" "еterknutit" ;
  aaterkoep_nn_1 = mkN "еterkцp" neutrum ;
  aaterkomma_vb_1 = mkV "еterkomma" "еterkom" "еterkommit" ;
  aaterkoppling_nn_1 = mkN "еterkoppling" ;
  aaterrop_nn_1 = mkN "еterrop" neutrum ;
  aatersamling_nn_1 = mkN "еtersamling" ;
  aaterspegling_nn_1 = mkN "еterspegling" ;
  aaterstaellare_nn_1 = mkN "еterstдllare" "еterstдllare" ;
  aaterstaellningstecken_nn_1 = mkN "еterstдllningstecken" "еterstдllningstecknet" "еterstдllningstecken" "еterstдllningstecknen" ;
  aaterstod_nn_1 = mkN "еterstod" "еterstoder" ;
  aaterta_vb_1 = mkV "еterta" "еtertar" "еterta" "еtertog" "еtertagit" "еtertagen" ;
  aatertaag_nn_1 = mkN "еtertеg" neutrum ;
  aatertjaenst_nn_1 = mkN "еtertjдnst" "еtertjдnster" ;
  aateruppstaandelse_nn_1 = mkN "еteruppstеndelse" "еteruppstеndelser" ;
  aateruppta_vb_1 = mkV "еteruppta" "еterupptar" "еteruppta" "еterupptog" "еterupptagit" "еterupptagen" ;
  aatervaendsgraend_nn_1 = mkN "еtervдndsgrдnd" "еtervдndsgrдnder" ;
  aaterval_nn_1 = mkN "еterval" neutrum ;
  aaterverkning_nn_1 = mkN "еterverkning" ;
  aatervinna_vb_1 = mkV "еtervinna" "еtervann" "еtervunnit" ;
  aatgaa_vb_1 = mkV "еtgе" "еtgеr" "еtgе" "еtgick" "еtgеtt" "еtgеngen" ;
  aatgaangen_av_1 = mkA "еtgеngen" "еtgеnget" ;
  aatgaerd_nn_1 = mkN "еtgдrd" "еtgдrder" ;
  aathutning_nn_1 = mkN "еthutning" ;
  aatkomlig_av_1 = mkA "еtkomlig" ;
  aatlyda_vb_1 = mkV "еtlyda" "еtlydde" "еtlytt" ;
  aatlydnad_nn_1 = mkN "еtlydnad" "еtlydnader" ;
  aatminstone_ab_1 = mkAdv "еtminstone" ;
  aatnjuta_vb_1 = mkV "еtnjuta" "еtnjцt" "еtnjutit" ;
  aatraavaerd_av_1 = mkA "еtrеvдrd" "еtrеvдrt" ;
  aatsida_nn_1 = mkN "еtsida" ;
  aatsittande_av_1 = mkA "еtsittande" ;
  aatskillig_av_1 = mkA "еtskillig" ;
  aatskillnad_nn_1 = mkN "еtskillnad" "еtskillnader" ;
  aatskils_ab_1 = mkAdv "еtskils" ;
  aatsmitande_av_1 = mkA "еtsmitande" ;
  aatstramning_nn_1 = mkN "еtstramning" ;
  aattahoernig_av_1 = mkA "еttahцrnig" ;
  aattatimmarsdag_nn_1 = mkN "еttatimmarsdag" ;
  aattiondel_nn_1 = mkN "еttiondel" "еttiondelen" "еttiondelar" "еttiondelarna" ;
  aattiotalist_nn_1 = mkN "еttiotalist" "еttiotalister" ;
  aattitalism_nn_1 = mkN "еttitalism" "еttitalismer" ;
  aattitalist_nn_1 = mkN "еttitalist" "еttitalister" ;
  aattondel_nn_1 = mkN "еttondel" "еttondelen" "еttondelar" "еttondelarna" ;
  abakus_nn_1 = mkN "abakus" "abakuser" ;
  abbe_nn_1 = mkN "abbй" "abbйer" ;
  abborre_nn_1 = mkN "abborre" utrum ;
  abborrfisk_nn_1 = mkN "abborrfisk" ;
  abborrpinne_nn_1 = mkN "abborrpinne" utrum ;
  abbot_nn_1 = mkN "abbot" ;
  abbreviation_nn_1 = mkN "abbreviation" "abbreviationer" ;
  abbreviatur_nn_1 = mkN "abbreviatur" "abbreviaturer" ;
  abc_bok_nn_1 = mkN "abc-bok" "abc-bцcker" ;
  abderitisk_av_1 = mkA "abderitisk" ;
  abdikation_nn_1 = mkN "abdikation" "abdikationer" ;
  abdomen_nn_1 = mkN "abdomen" "abdomen" "abdomina" "abdomina" ;
  aber_nn_1 = mkN "aber" neutrum ;
  aberration_nn_1 = mkN "aberration" "aberrationer" ;
  abessinier_nn_1 = mkN "abessinier" "abessiniern" "abessinier" "abessinierna" ;
  abessinsk_av_1 = mkA "abessinsk" ;
  abilitet_nn_1 = mkN "abilitet" "abiliteter" ;
  abiturient_nn_1 = mkN "abiturient" "abiturienter" ;
  abiturientexamen_nn_1 = mkN "abiturientexamen" "abiturientexamen" "abiturientexamina" "abiturientexamina" ;
  ablation_nn_1 = mkN "ablation" "ablationer" ;
  ablativ_nn_1 = mkN "ablativ" "ablativer" ;
  abnorm_av_1 = mkA "abnorm" ;
  abnormitet_nn_1 = mkN "abnormitet" "abnormiteter" ;
  abolition_nn_1 = mkN "abolition" "abolitioner" ;
  abonnemang_nn_1 = mkN "abonnemang" neutrum ;
  abonnent_nn_1 = mkN "abonnent" "abonnenter" ;
  aboriginer_nn_1 = mkN "aboriginer" "aboriginern" "aboriginer" "aboriginerna" ;
  abort_nn_1 = mkN "abort" "aborter" ;
  abortiv_av_1 = mkA "abortiv" ;
  abortoer_nn_1 = mkN "abortцr" "abortцrer" ;
  abrupt_av_1 = mkA "abrupt" "abrupt" ;
  abscess_nn_1 = mkN "abscess" "abscesser" ;
  absens_nn_1 = mkN "absens" "absenser" ;
  absid_nn_1 = mkN "absid" "absider" ;
  absint_nn_1 = mkN "absint" "absinter" ;
  absolut_av_1 = mkA "absolut" "absolut" ;
  absolutbelopp_nn_1 = mkN "absolutbelopp" neutrum ;
  absolutist_nn_1 = mkN "absolutist" "absolutister" ;
  absolutistisk_av_1 = mkA "absolutistisk" ;
  absorptionslinje_nn_1 = mkN "absorptionslinje" "absorptionslinjer" ;
  abstrakt_av_1 = mkA "abstrakt" "abstrakt" ;
  abstrakt_nn_1 = mkN "abstrakt" "abstraktet" "abstrakter" "abstrakterna" ;
  abstraktion_nn_1 = mkN "abstraktion" "abstraktioner" ;
  abstrus_av_1 = mkA "abstrus" ;
  absurd_av_1 = mkA "absurd" "absurt" ;
  absurditet_nn_1 = mkN "absurditet" "absurditeter" ;
  abundant_av_1 = mkA "abundant" "abundant" ;
  abyssal_av_1 = mkA "abyssal" ;
  acceleration_nn_1 = mkN "acceleration" "accelerationer" ;
  accelerator_nn_1 = mkN "accelerator" "acceleratorer" ;
  acceleratormaskin_nn_1 = mkN "acceleratormaskin" "acceleratormaskiner" ;
  acceleratorsystem_nn_1 = mkN "acceleratorsystem" neutrum ;
  accent_nn_1 = mkN "accent" "accenter" ;
  accentfoerskjutning_nn_1 = mkN "accentfцrskjutning" ;
  accenttecken_nn_1 = mkN "accenttecken" "accenttecknet" "accenttecken" "accenttecknen" ;
  accept_nn_1 = mkN "accept" "accepter" ;
  acceptabel_av_1 = mkA "acceptabel" "acceptabelt" "acceptabla" "acceptabla" "acceptablare" "acceptablast" "acceptablaste" ;
  acceptant_nn_1 = mkN "acceptant" "acceptanter" ;
  accepterande_nn_1 = mkN "accepterande" ;
  acceptkredit_nn_1 = mkN "acceptkredit" "acceptkrediter" ;
  access_nn_1 = mkN "access" "accesser" ;
  accession_nn_1 = mkN "accession" "accessioner" ;
  accessionskatalog_nn_1 = mkN "accessionskatalog" "accessionskataloger" ;
  accessoar_nn_1 = mkN "accessoar" "accessoarer" ;
  accessorisk_av_1 = mkA "accessorisk" ;
  accesstid_nn_1 = mkN "accesstid" "accesstider" ;
  accidens_nn_1 = mkN "accidens" "accidenser" ;
  accidenstryck_nn_1 = mkN "accidenstryck" neutrum ;
  accidentell_av_1 = mkA "accidentell" ;
  accis_nn_1 = mkN "accis" "acciser" ;
  acetaldehyd_nn_1 = mkN "acetaldehyd" "acetaldehyder" ;
  acetat_nn_1 = mkN "acetat" neutrum ;
  aciditet_nn_1 = mkN "aciditet" "aciditeter" ;
  ackja_nn_1 = mkN "ackja" ;
  acklamation_nn_1 = mkN "acklamation" "acklamationer" ;
  ackommodation_nn_1 = mkN "ackommodation" "ackommodationer" ;
  ackommodationsvaexel_nn_1 = mkN "ackommodationsvдxel" ;
  ackompanjatoer_nn_1 = mkN "ackompanjatцr" "ackompanjatцrer" ;
  ackompanjemang_nn_1 = mkN "ackompanjemang" neutrum ;
  ackord_nn_1 = mkN "ackord" neutrum ;
  ackordion_nn_1 = mkN "ackordion" "ackordionet" "ackordion" "ackordierna" ;
  ackordsloen_nn_1 = mkN "ackordslцn" "ackordslцner" ;
  ackordssaettning_nn_1 = mkN "ackordssдttning" ;
  ackumulation_nn_1 = mkN "ackumulation" "ackumulationer" ;
  ackumulator_nn_1 = mkN "ackumulator" "ackumulatorer" ;
  ackurat_ab_1 = mkAdv "ackurat" ;
  ackurat_av_1 = mkA "ackurat" "ackurat" ;
  ackusativ_nn_1 = mkN "ackusativ" "ackusativer" ;
  ackusativobjekt_nn_1 = mkN "ackusativobjekt" neutrum ;
  ackusatorisk_av_1 = mkA "ackusatorisk" ;
  ackuschoer_nn_1 = mkN "ackuschцr" "ackuschцrer" ;
  ackuschoerska_nn_1 = mkN "ackuschцrska" ;
  ackvisition_nn_1 = mkN "ackvisition" "ackvisitioner" ;
  ackvisitoer_nn_1 = mkN "ackvisitцr" "ackvisitцrer" ;
  actionfilm_nn_1 = mkN "actionfilm" "actionfilmer" ;
  adagio_ab_1 = mkAdv "adagio" ;
  adagio_nn_1 = mkN "adagio" "adagiot" "adagion" "adagiona" ;
  adaptation_nn_1 = mkN "adaptation" "adaptationer" ;
  adapter_nn_1 = mkN "adapter" ;
  adaption_nn_1 = mkN "adaption" "adaptioner" ;
  adaptiv_av_1 = mkA "adaptiv" ;
  addend_nn_1 = mkN "addend" "addender" ;
  addenda_nn_1 = mkN "addenda" "addendan" "addenda" "addendana" ;
  addiktion_nn_1 = mkN "addiktion" "addiktioner" ;
  additament_nn_1 = mkN "additament" "additamentet" "additamenten" "additamentena" ;
  addition_nn_1 = mkN "addition" "additioner" ;
  additionstecken_nn_1 = mkN "additionstecken" "additionstecknet" "additionstecken" "additionstecknen" ;
  additiv_av_1 = mkA "additiv" ;
  additiv_nn_1 = mkN "additiv" neutrum ;
  adduktion_nn_1 = mkN "adduktion" "adduktioner" ;
  adekvat_av_1 = mkA "adekvat" "adekvat" ;
  adelsaett_nn_1 = mkN "adelsдtt" "adelsдtter" ;
  adelsbrev_nn_1 = mkN "adelsbrev" neutrum ;
  adelsgods_nn_1 = mkN "adelsgods" neutrum ;
  adelshem_nn_1 = mkN "adelshem" "adelshemmet" "adelshem" "adelshemmen" ;
  adelskalender_nn_1 = mkN "adelskalender" ;
  adelsmaerke_nn_1 = mkN "adelsmдrke" ;
  adelsman_nn_1 = mkN "adelsman" "adelsmannen" "adelsmдn" "adelsmдnnen" ;
  adelsprivilegium_nn_1 = mkN "adelsprivilegium" "adelsprivilegiet" "adelsprivilegier" "adelsprivilegierna" ;
  adenit_nn_1 = mkN "adenit" "adeniter" ;
  adept_nn_1 = mkN "adept" "adepter" ;
  adhesiv_av_1 = mkA "adhesiv" ;
  adiabatisk_av_1 = mkA "adiabatisk" ;
  adiafora_nn_1 = mkN "adiafora" "adiaforan" "adiafora" "adiaforana" ;
  adjektiv_nn_1 = mkN "adjektiv" neutrum ;
  adjektivattribut_nn_1 = mkN "adjektivattribut" neutrum ;
  adjektivisk_av_1 = mkA "adjektivisk" ;
  adjoe_nn_1 = mkN "adjц" "adjцt" "adjцn" "adjцna" ;
  adjunkt_nn_1 = mkN "adjunkt" "adjunkter" ;
  adjunktion_nn_1 = mkN "adjunktion" "adjunktioner" ;
  adjunktur_nn_1 = mkN "adjunktur" "adjunkturer" ;
  adjutant_nn_1 = mkN "adjutant" "adjutanter" ;
  adlig_av_1 = mkA "adlig" ;
  administration_nn_1 = mkN "administration" "administrationer" ;
  administrativ_av_1 = mkA "administrativ" ;
  administratoer_nn_1 = mkN "administratцr" "administratцrer" ;
  admonition_nn_1 = mkN "admonition" "admonitioner" ;
  adonis_nn_1 = mkN "adonis" ;
  adoptant_nn_1 = mkN "adoptant" "adoptanter" ;
  adoption_nn_1 = mkN "adoption" "adoptioner" ;
  adoptiv_av_1 = mkA "adoptiv" ;
  adoptivbarn_nn_1 = mkN "adoptivbarn" neutrum ;
  adoptivfoeraelder_nn_1 = mkN "adoptivfцrдlder" ;
  adoratoer_nn_1 = mkN "adoratцr" "adoratцrer" ;
  adrenalin_nn_1 = mkN "adrenalin" "adrenaliner" ;
  adress_nn_1 = mkN "adress" "adresser" ;
  adressat_nn_1 = mkN "adressat" "adressater" ;
  adresskort_nn_1 = mkN "adresskort" neutrum ;
  adresslapp_nn_1 = mkN "adresslapp" ;
  adstringerande_av_1 = mkA "adstringerande" ;
  adventist_nn_1 = mkN "adventist" "adventister" ;
  adventiv_av_1 = mkA "adventiv" ;
  adventsstake_nn_1 = mkN "adventsstake" utrum ;
  adverb_nn_1 = mkN "adverb" neutrum ;
  adverbial_nn_1 = mkN "adverbial" neutrum ;
  adverbiell_av_1 = mkA "adverbiell" ;
  advers_nn_1 = mkN "advers" "adverser" ;
  adversativ_av_1 = mkA "adversativ" ;
  advokat_nn_1 = mkN "advokat" "advokater" ;
  advokatfiskal_nn_1 = mkN "advokatfiskal" "advokatfiskaler" ;
  advokatorisk_av_1 = mkA "advokatorisk" ;
  advokatyr_nn_1 = mkN "advokatyr" "advokatyrer" ;
  aeckel_nn_1 = mkN "дckel" neutrum ;
  aecklig_av_1 = mkA "дcklig" ;
  aecklo_nn_1 = mkN "дcklo" "дcklot" "дcklon" "дcklona" ;
  aedel_av_1 = mkA "дdel" "дdelt" "дdla" "дdla" "дdlare" "дdlast" "дdlaste" ;
  aedelfasan_nn_1 = mkN "дdelfasan" "дdelfasaner" ;
  aedelgas_nn_1 = mkN "дdelgas" "дdelgaser" ;
  aedelgran_nn_1 = mkN "дdelgran" ;
  aedelloevtraed_nn_1 = mkN "дdellцvtrдd" neutrum ;
  aedelmetall_nn_1 = mkN "дdelmetall" "дdelmetaller" ;
  aedelmodig_av_1 = mkA "дdelmodig" ;
  aedelost_nn_1 = mkN "дdelost" ;
  aedelpekoral_nn_1 = mkN "дdelpekoral" neutrum ;
  aedelsmed_nn_1 = mkN "дdelsmed" "дdelsmeder" ;
  aedelsten_nn_1 = mkN "дdelsten" "дdelstenen" "дdelstenar" "дdelstenarna" ;
  aedling_nn_1 = mkN "дdling" ;
  aefsing_nn_1 = mkN "дfsing" ;
  aega_nn_1 = mkN "дga" ;
  aegande_nn_1 = mkN "дgande" ;
  aegare_nn_1 = mkN "дgare" "дgare" ;
  aegarform_nn_1 = mkN "дgarform" "дgarformer" ;
  aegg_nn_1 = mkN "дgg" neutrum ;
  aeggcell_nn_1 = mkN "дggcell" "дggceller" ;
  aegghinna_nn_1 = mkN "дgghinna" ;
  aeggklaeckningsmaskin_nn_1 = mkN "дggklдckningsmaskin" "дggklдckningsmaskiner" ;
  aeggkokare_nn_1 = mkN "дggkokare" "дggkokare" ;
  aeggkokning_nn_1 = mkN "дggkokning" ;
  aeggkopp_nn_1 = mkN "дggkopp" ;
  aegglaeggningsroer_nn_1 = mkN "дgglдggningsrцr" neutrum ;
  aeggledare_nn_1 = mkN "дggledare" "дggledare" ;
  aeggledartratt_nn_1 = mkN "дggledartratt" ;
  aeggliknande_av_1 = mkA "дggliknande" ;
  aegglossning_nn_1 = mkN "дgglossning" ;
  aeggost_nn_1 = mkN "дggost" ;
  aeggprickare_nn_1 = mkN "дggprickare" "дggprickare" ;
  aeggsaeck_nn_1 = mkN "дggsдck" ;
  aeggsjuk_av_1 = mkA "дggsjuk" ;
  aeggskal_nn_1 = mkN "дggskal" neutrum ;
  aeggsked_nn_1 = mkN "дggsked" ;
  aeggsnodd_nn_1 = mkN "дggsnodd" ;
  aeggstanning_nn_1 = mkN "дggstanning" ;
  aeggstav_nn_1 = mkN "дggstav" ;
  aeggstock_nn_1 = mkN "дggstock" ;
  aeggstocksinflammation_nn_1 = mkN "дggstocksinflammation" "дggstocksinflammationer" ;
  aeggsvamp_nn_1 = mkN "дggsvamp" ;
  aeggtoddy_nn_1 = mkN "дggtoddy" "дggtoddyn" "дggtoddyar" "дggtoddyarna" ;
  aeggvaermare_nn_1 = mkN "дggvдrmare" "дggvдrmare" ;
  aeggviteaemne_nn_1 = mkN "дggviteдmne" ;
  aeggviteprov_nn_1 = mkN "дggviteprov" neutrum ;
  aegiljett_nn_1 = mkN "дgiljett" "дgiljetter" ;
  aegodel_nn_1 = mkN "дgodel" "дgodelen" "дgodelar" "дgodelarna" ;
  aegodelning_nn_1 = mkN "дgodelning" ;
  aegotecken_nn_1 = mkN "дgotecken" "дgotecknet" "дgotecken" "дgotecknen" ;
  aegrett_nn_1 = mkN "дgrett" "дgretter" ;
  aegretthaeger_nn_1 = mkN "дgretthдger" ;
  aekta_av_1 = mkA "дkta" ;
  aektamakekuvert_nn_1 = mkN "дktamakekuvert" neutrum ;
  aektenskap_nn_1 = mkN "дktenskap" "дktenskapet" "дktenskapen" "дktenskapena" ;
  aektenskaplig_av_1 = mkA "дktenskaplig" ;
  aektenskapsbetyg_nn_1 = mkN "дktenskapsbetyg" neutrum ;
  aektenskapsbrott_nn_1 = mkN "дktenskapsbrott" neutrum ;
  aektenskapsbrytare_nn_1 = mkN "дktenskapsbrytare" "дktenskapsbrytare" ;
  aektenskapsbyraa_nn_1 = mkN "дktenskapsbyrе" "дktenskapsbyrеer" ;
  aektenskapscertifikat_nn_1 = mkN "дktenskapscertifikat" neutrum ;
  aektenskapsfoerord_nn_1 = mkN "дktenskapsfцrord" neutrum ;
  aektenskapshinder_nn_1 = mkN "дktenskapshinder" neutrum ;
  aektenskapsloefte_nn_1 = mkN "дktenskapslцfte" ;
  aektenskapsmaeklare_nn_1 = mkN "дktenskapsmдklare" "дktenskapsmдklare" ;
  aektenskapsskillnad_nn_1 = mkN "дktenskapsskillnad" "дktenskapsskillnader" ;
  aekthet_nn_1 = mkN "дkthet" "дktheter" ;
  aektsvensk_av_1 = mkA "дktsvensk" ;
  aelg_nn_1 = mkN "дlg" ;
  aelgjaegare_nn_1 = mkN "дlgjдgare" "дlgjдgare" ;
  aelgjakt_nn_1 = mkN "дlgjakt" "дlgjakter" ;
  aelgstudsare_nn_1 = mkN "дlgstudsare" "дlgstudsare" ;
  aelling_nn_1 = mkN "дlling" ;
  aelskare_nn_1 = mkN "дlskare" "дlskare" ;
  aelskarinna_nn_1 = mkN "дlskarinna" ;
  aelsklig_av_1 = mkA "дlsklig" ;
  aelskling_nn_1 = mkN "дlskling" ;
  aelsklingsraett_nn_1 = mkN "дlsklingsrдtt" "дlsklingsrдtter" ;
  aelskogskrank_av_1 = mkA "дlskogskrank" ;
  aelskvaerd_av_1 = mkA "дlskvдrd" "дlskvдrt" ;
  aelv_nn_1 = mkN "дlv" ;
  aelvbaedd_nn_1 = mkN "дlvbдdd" ;
  aelvbrink_nn_1 = mkN "дlvbrink" ;
  aelvdaling_nn_1 = mkN "дlvdaling" ;
  aelvkvarn_nn_1 = mkN "дlvkvarn" ;
  aelvstrand_nn_1 = mkN "дlvstrand" "дlvstrдnder" ;
  aemabel_av_1 = mkA "дmabel" "дmabelt" "дmabla" "дmabla" "дmablare" "дmablast" "дmablaste" ;
  aembar_nn_1 = mkN "дmbar" neutrum ;
  aembetsaaliggande_nn_1 = mkN "дmbetsеliggande" ;
  aembetsbrott_nn_1 = mkN "дmbetsbrott" neutrum ;
  aembetsexamen_nn_1 = mkN "дmbetsexamen" "дmbetsexamen" "дmbetsexamina" "дmbetsexamina" ;
  aembetsman_nn_1 = mkN "дmbetsman" "дmbetsmannen" "дmbetsmдn" "дmbetsmдnnen" ;
  aembetsmannaregering_nn_1 = mkN "дmbetsmannaregering" ;
  aembetsperiod_nn_1 = mkN "дmbetsperiod" "дmbetsperioder" ;
  aembetsskrud_nn_1 = mkN "дmbetsskrud" ;
  aembetstitel_nn_1 = mkN "дmbetstitel" ;
  aembetsverk_nn_1 = mkN "дmbetsverk" neutrum ;
  aemne_nn_1 = mkN "дmne" ;
  aemnesblock_nn_1 = mkN "дmnesblock" neutrum ;
  aemnesfoeretraedare_nn_1 = mkN "дmnesfцretrдdare" "дmnesfцretrдdare" ;
  aemnesgrupp_nn_1 = mkN "дmnesgrupp" "дmnesgrupper" ;
  aemnesjaern_nn_1 = mkN "дmnesjдrn" neutrum ;
  aemneskombination_nn_1 = mkN "дmneskombination" "дmneskombinationer" ;
  aemneskonferens_nn_1 = mkN "дmneskonferens" "дmneskonferenser" ;
  aemneslaerare_nn_1 = mkN "дmneslдrare" "дmneslдrare" ;
  aemnesnamn_nn_1 = mkN "дmnesnamn" neutrum ;
  aemnesomraade_nn_1 = mkN "дmnesomrеde" ;
  aen_ab_1 = mkAdv "дn" ;
  aenda_ab_1 = mkAdv "дnda" ;
  aenda_nn_1 = mkN "дnda" "дndan" "дndar" "дndarna" ;
  aendaa_ab_1 = mkAdv "дndе" ;
  aendamaal_nn_1 = mkN "дndamеl" neutrum ;
  aendamaalsenlig_av_1 = mkA "дndamеlsenlig" ;
  aendamaalsenlighet_nn_1 = mkN "дndamеlsenlighet" "дndamеlsenligheter" ;
  aendamaalsloes_av_1 = mkA "дndamеlslцs" ;
  aende_nn_1 = mkN "дnde" utrum ;
  aendelse_nn_1 = mkN "дndelse" "дndelser" ;
  aendlig_av_1 = mkA "дndlig" ;
  aendloes_av_1 = mkA "дndlцs" ;
  aendmoraen_nn_1 = mkN "дndmorдn" "дndmorдner" ;
  aendock_ab_1 = mkAdv "дndock" ;
  aendpunkt_nn_1 = mkN "дndpunkt" "дndpunkter" ;
  aendrim_nn_1 = mkN "дndrim" "дndrimmet" "дndrim" "дndrimmen" ;
  aendring_nn_1 = mkN "дndring" ;
  aendstation_nn_1 = mkN "дndstation" "дndstationer" ;
  aendtarm_nn_1 = mkN "дndtarm" ;
  aeng_ljud_nn_1 = mkN "дng-ljud" neutrum ;
  aeng_nn_1 = mkN "дng" ;
  aengd_nn_1 = mkN "дngd" "дngder" ;
  aengel_nn_1 = mkN "дngel" ;
  aenger_nn_1 = mkN "дnger" ;
  aenglakoer_nn_1 = mkN "дnglakцr" "дnglakцrer" ;
  aenglalik_av_1 = mkA "дnglalik" ;
  aenglamakerska_nn_1 = mkN "дnglamakerska" ;
  aengsknarr_nn_1 = mkN "дngsknarr" ;
  aengslig_av_1 = mkA "дngslig" ;
  aengsmark_nn_1 = mkN "дngsmark" "дngsmarker" ;
  aengsvial_nn_1 = mkN "дngsvial" "дngsvialer" ;
  aenkeaar_nn_1 = mkN "дnkeеr" neutrum ;
  aenkedok_nn_1 = mkN "дnkedok" neutrum ;
  aenkedrottning_nn_1 = mkN "дnkedrottning" ;
  aenkefru_nn_1 = mkN "дnkefru" ;
  aenkeman_nn_1 = mkN "дnkeman" "дnkemannen" "дnkemдn" "дnkemдnnen" ;
  aenkenaad_nn_1 = mkN "дnkenеd" "дnkenеder" ;
  aenkepension_nn_1 = mkN "дnkepension" "дnkepensioner" ;
  aenkestoet_nn_1 = mkN "дnkestцt" ;
  aenkling_nn_1 = mkN "дnkling" ;
  aennu_ab_1 = mkAdv "дnnu" ;
  aenterhake_nn_1 = mkN "дnterhake" utrum ;
  aenterpik_nn_1 = mkN "дnterpik" ;
  aentligen_ab_1 = mkAdv "дntligen" ;
  aentring_nn_1 = mkN "дntring" ;
  aentringsstrid_nn_1 = mkN "дntringsstrid" "дntringsstrider" ;
  aeppelkart_nn_1 = mkN "дppelkart" ;
  aeppelpraektig_av_1 = mkA "дppelprдktig" ;
  aeppelskrott_nn_1 = mkN "дppelskrott" ;
  aeppeltraed_nn_1 = mkN "дppeltrдd" neutrum ;
  aeppelvecklare_nn_1 = mkN "дppelvecklare" "дppelvecklare" ;
  aepplekart_nn_1 = mkN "дpplekart" ;
  aeppleliknande_av_1 = mkA "дppleliknande" ;
  aeppleskrott_nn_1 = mkN "дppleskrott" ;
  aeppletraed_nn_1 = mkN "дppletrдd" neutrum ;
  aerbar_av_1 = mkA "дrbar" ;
  aerebetygelse_nn_1 = mkN "дrebetygelse" "дrebetygelser" ;
  aerefoergaeten_av_1 = mkA "дrefцrgдten" "дrefцrgдtet" ;
  aeregirig_av_1 = mkA "дregirig" ;
  aereloes_av_1 = mkA "дrelцs" ;
  aerelysten_av_1 = mkA "дrelysten" "дrelystet" ;
  aerelystnad_nn_1 = mkN "дrelystnad" "дrelystnader" ;
  aereminne_nn_1 = mkN "дreminne" ;
  aerende_nn_1 = mkN "дrende" ;
  aereport_nn_1 = mkN "дreport" ;
  aereroerig_av_1 = mkA "дrerцrig" ;
  aeresak_nn_1 = mkN "дresak" "дresaker" ;
  aerevarv_nn_1 = mkN "дrevarv" neutrum ;
  aerevoerdig_av_1 = mkA "дrevцrdig" ;
  aerftlig_av_1 = mkA "дrftlig" ;
  aerftlighet_nn_1 = mkN "дrftlighet" "дrftligheter" ;
  aerftlighetsforskare_nn_1 = mkN "дrftlighetsforskare" "дrftlighetsforskare" ;
  aerftlighetslag_nn_1 = mkN "дrftlighetslag" ;
  aerggroen_av_1 = mkA "дrggrцn" ;
  aergig_av_1 = mkA "дrgig" ;
  aeril_nn_1 = mkN "дril" ;
  aerjkrok_nn_1 = mkN "дrjkrok" ;
  aerkeaengel_nn_1 = mkN "дrkeдngel" ;
  aerkebiskop_nn_1 = mkN "дrkebiskop" ;
  aerkefiende_nn_1 = mkN "дrkefiende" "дrkefiender" ;
  aerkehertig_nn_1 = mkN "дrkehertig" ;
  aerkenoet_nn_1 = mkN "дrkenцt" neutrum ;
  aerkestift_nn_1 = mkN "дrkestift" neutrum ;
  aerlig_av_1 = mkA "дrlig" ;
  aerligen_ab_1 = mkAdv "дrligen" ;
  aerlighet_nn_1 = mkN "дrlighet" "дrligheter" ;
  aerm_nn_1 = mkN "дrm" ;
  aermbraede_nn_1 = mkN "дrmbrдde" ;
  aermhaal_nn_1 = mkN "дrmhеl" neutrum ;
  aermhaallare_nn_1 = mkN "дrmhеllare" "дrmhеllare" ;
  aermlinning_nn_1 = mkN "дrmlinning" ;
  aermloes_av_1 = mkA "дrmlцs" ;
  aerob_av_1 = mkA "aerob" ;
  aerobisk_av_1 = mkA "aerobisk" ;
  aerodrom_nn_1 = mkN "aerodrom" "aerodromer" ;
  aerodynamisk_av_1 = mkA "aerodynamisk" ;
  aerofull_av_1 = mkA "дrofull" ;
  aerofylld_av_1 = mkA "дrofylld" "дrofyllt" ;
  aerogram_nn_1 = mkN "aerogram" "aerogrammet" "aerogram" "aerogrammen" ;
  aeronaut_nn_1 = mkN "aeronaut" "aeronauter" ;
  aeroplan_nn_1 = mkN "aeroplan" neutrum ;
  aerorik_av_1 = mkA "дrorik" ;
  aerosol_nn_1 = mkN "aerosol" "aerosoler" ;
  aerr_nn_1 = mkN "дrr" neutrum ;
  aerrbildning_nn_1 = mkN "дrrbildning" ;
  aerrig_av_1 = mkA "дrrig" ;
  aerrtatuering_nn_1 = mkN "дrrtatuering" ;
  aert_nn_1 = mkN "дrt" "дrter" ;
  aerta_nn_1 = mkN "дrta" ;
  aertig_av_1 = mkA "дrtig" ;
  aertvaext_nn_1 = mkN "дrtvдxt" "дrtvдxter" ;
  aertvecklare_nn_1 = mkN "дrtvecklare" "дrtvecklare" ;
  aeskande_nn_1 = mkN "дskande" ;
  aesping_nn_1 = mkN "дsping" ;
  aess_nn_1 = mkN "дss" neutrum ;
  aeta_vb_1 = mkV "дta" "еt" "дtit" ;
  aetbar_av_1 = mkA "дtbar" ;
  aetlig_av_1 = mkA "дtlig" ;
  aetpinne_nn_1 = mkN "дtpinne" utrum ;
  aett_nn_1 = mkN "дtt" "дtter" ;
  aettartavla_nn_1 = mkN "дttartavla" ;
  aettefader_nn_1 = mkN "дttefader" "дttefadern" "дttefдder" "дttefдderna" ;
  aettelaegg_nn_1 = mkN "дttelдgg" ;
  aetteled_nn_1 = mkN "дtteled" neutrum ;
  aettetal_nn_1 = mkN "дttetal" "дttetalet" "дttetalen" "дttetalena" ;
  aettetavla_nn_1 = mkN "дttetavla" ;
  aettiksinlaeggning_nn_1 = mkN "дttiksinlдggning" ;
  aettlaengd_nn_1 = mkN "дttlдngd" "дttlдngder" ;
  aettled_nn_1 = mkN "дttled" neutrum ;
  aettling_nn_1 = mkN "дttling" ;
  aettnummer_nn_1 = mkN "дttnummer" neutrum ;
  aeven_ab_1 = mkAdv "дven" ;
  aevenledes_ab_1 = mkAdv "дvenledes" ;
  aevensaa_ab_1 = mkAdv "дvensе" ;
  aeventyr_nn_1 = mkN "дventyr" neutrum ;
  aeventyrare_nn_1 = mkN "дventyrare" "дventyrare" ;
  aeventyrlig_av_1 = mkA "дventyrlig" ;
  aeventyrsbok_nn_1 = mkN "дventyrsbok" "дventyrsbцcker" ;
  aeventyrsfilm_nn_1 = mkN "дventyrsfilm" "дventyrsfilmer" ;
  aeventyrsroman_nn_1 = mkN "дventyrsroman" "дventyrsromaner" ;
  aexing_nn_1 = mkN "дxing" ;
  afasi_nn_1 = mkN "afasi" "afasier" ;
  afasisk_av_1 = mkA "afasisk" ;
  afatiker_nn_1 = mkN "afatiker" "afatikern" "afatiker" "afatikerna" ;
  afatisk_av_1 = mkA "afatisk" ;
  afelium_nn_1 = mkN "afelium" "afeliet" "afelier" "afelierna" ;
  affaer_nn_1 = mkN "affдr" "affдrer" ;
  affaersavtal_nn_1 = mkN "affдrsavtal" "affдrsavtalet" "affдrsavtalen" "affдrsavtalena" ;
  affaersbank_nn_1 = mkN "affдrsbank" "affдrsbanker" ;
  affaersbegaavning_nn_1 = mkN "affдrsbegеvning" ;
  affaersbitraede_nn_1 = mkN "affдrsbitrдde" ;
  affaersbrev_nn_1 = mkN "affдrsbrev" neutrum ;
  affaerscentrum_nn_1 = mkN "affдrscentrum" neutrum ;
  affaersdrivande_av_1 = mkA "affдrsdrivande" ;
  affaerskedja_nn_1 = mkN "affдrskedja" ;
  affaersliv_nn_1 = mkN "affдrsliv" neutrum ;
  affaersmaessig_av_1 = mkA "affдrsmдssig" ;
  affaersman_nn_1 = mkN "affдrsman" "affдrsmannen" "affдrsmдn" "affдrsmдnnen" ;
  affaerstid_nn_1 = mkN "affдrstid" "affдrstider" ;
  affaersverk_nn_1 = mkN "affдrsverk" neutrum ;
  affekt_nn_1 = mkN "affekt" "affekter" ;
  affektion_nn_1 = mkN "affektion" "affektioner" ;
  affektionsvaerde_nn_1 = mkN "affektionsvдrde" ;
  affektiv_av_1 = mkA "affektiv" ;
  affidavit_nn_1 = mkN "affidavit" neutrum ;
  affin_av_1 = mkA "affin" ;
  affinage_nn_1 = mkN "affinage" "affinaget" "affinage" "affinagen" ;
  affinitet_nn_1 = mkN "affinitet" "affiniteter" ;
  affirmativ_av_1 = mkA "affirmativ" ;
  affisch_nn_1 = mkN "affisch" "affischer" ;
  affischering_nn_1 = mkN "affischering" ;
  affischnamn_nn_1 = mkN "affischnamn" neutrum ;
  affischoer_nn_1 = mkN "affischцr" "affischцrer" ;
  affischpelare_nn_1 = mkN "affischpelare" "affischpelare" ;
  affix_nn_1 = mkN "affix" neutrum ;
  afghan_nn_1 = mkN "afghan" "afghaner" ;
  afghansk_av_1 = mkA "afghansk" ;
  aforism_nn_1 = mkN "aforism" "aforismer" ;
  aforistiker_nn_1 = mkN "aforistiker" "aforistikern" "aforistiker" "aforistikerna" ;
  aforistisk_av_1 = mkA "aforistisk" ;
  afrikan_nn_1 = mkN "afrikan" "afrikaner" ;
  afrikansk_av_1 = mkA "afrikansk" ;
  afro_asiatisk_av_1 = mkA "afro-asiatisk" ;
  afroamerikan_nn_1 = mkN "afroamerikan" "afroamerikaner" ;
  afroasiatisk_av_1 = mkA "afroasiatisk" ;
  afrodisiakum_nn_1 = mkN "afrodisiakum" "afrodisiakum" "afrodisiaka" "afrodisiakana" ;
  afrofrisyr_nn_1 = mkN "afrofrisyr" "afrofrisyrer" ;
  afse_nn_1 = mkN "afse" utrum ;
  afton_nn_1 = mkN "afton" "aftonen" "aftnar" "aftnarna" ;
  aftonboen_nn_1 = mkN "aftonbцn" "aftonbцner" ;
  aftondraekt_nn_1 = mkN "aftondrдkt" "aftondrдkter" ;
  aftongudstjaenst_nn_1 = mkN "aftongudstjдnst" "aftongudstjдnster" ;
  aftonklaenning_nn_1 = mkN "aftonklдnning" ;
  aftonrodnad_nn_1 = mkN "aftonrodnad" "aftonrodnader" ;
  aftonsaang_nn_1 = mkN "aftonsеng" "aftonsеnger" ;
  aftonvard_nn_1 = mkN "aftonvard" "aftonvarder" ;
  agat_nn_1 = mkN "agat" "agater" ;
  agave_nn_1 = mkN "agave" "agaver" ;
  agent_nn_1 = mkN "agent" "agenter" ;
  agentfilm_nn_1 = mkN "agentfilm" "agentfilmer" ;
  agentur_nn_1 = mkN "agentur" "agenturer" ;
  agerande_nn_1 = mkN "agerande" ;
  aggande_av_1 = mkA "aggande" ;
  agglomerat_nn_1 = mkN "agglomerat" neutrum ;
  agglomeration_nn_1 = mkN "agglomeration" "agglomerationer" ;
  agglutination_nn_1 = mkN "agglutination" "agglutinationer" ;
  aggregat_nn_1 = mkN "aggregat" neutrum ;
  aggregation_nn_1 = mkN "aggregation" "aggregationer" ;
  aggregationstillstaand_nn_1 = mkN "aggregationstillstеnd" neutrum ;
  aggression_nn_1 = mkN "aggression" "aggressioner" ;
  aggressionshaemning_nn_1 = mkN "aggressionshдmning" ;
  aggressiv_av_1 = mkA "aggressiv" ;
  aggressivitet_nn_1 = mkN "aggressivitet" "aggressiviteter" ;
  agitation_nn_1 = mkN "agitation" "agitationer" ;
  agitator_nn_1 = mkN "agitator" "agitatorer" ;
  agitatorisk_av_1 = mkA "agitatorisk" ;
  agn_nn_1 = mkN "agn" neutrum ;
  agnat_nn_1 = mkN "agnat" "agnater" ;
  agnatisk_av_1 = mkA "agnatisk" ;
  agnblommig_av_1 = mkA "agnblommig" ;
  agnborst_nn_1 = mkN "agnborst" neutrum ;
  agnosi_nn_1 = mkN "agnosi" "agnosier" ;
  agnostiker_nn_1 = mkN "agnostiker" "agnostikern" "agnostiker" "agnostikerna" ;
  agnostisk_av_1 = mkA "agnostisk" ;
  agoni_nn_1 = mkN "agoni" "agonier" ;
  agraff_nn_1 = mkN "agraff" "agraffer" ;
  agrar_av_1 = mkA "agrar" ;
  agrar_nn_1 = mkN "agrar" "agrarer" ;
  agreabel_av_1 = mkA "agreabel" "agreabelt" "agreabla" "agreabla" "agreablare" "agreablast" "agreablaste" ;
  agremang_nn_1 = mkN "agremang" neutrum ;
  agrikulturell_av_1 = mkA "agrikulturell" ;
  agronom_nn_1 = mkN "agronom" "agronomer" ;
  agronomisk_av_1 = mkA "agronomisk" ;
  aha_upplevelse_nn_1 = mkN "aha-upplevelse" "aha-upplevelser" ;
  air_nn_1 = mkN "air" "airer" ;
  airdaleterrier_nn_1 = mkN "airdaleterrier" "airdaleterriern" "airdaleterrier" "airdaleterrierna" ;
  akademi_nn_1 = mkN "akademi" "akademier" ;
  akademiker_nn_1 = mkN "akademiker" "akademikern" "akademiker" "akademikerna" ;
  akademisk_av_1 = mkA "akademisk" ;
  akademist_nn_1 = mkN "akademist" "akademister" ;
  akant_nn_1 = mkN "akant" "akanter" ;
  akantus_nn_1 = mkN "akantus" ;
  akatalektisk_av_1 = mkA "akatalektisk" ;
  akilleshael_nn_1 = mkN "akilleshдl" ;
  akrobat_nn_1 = mkN "akrobat" "akrobater" ;
  akrobatisk_av_1 = mkA "akrobatisk" ;
  akromatisk_av_1 = mkA "akromatisk" ;
  akromegali_nn_1 = mkN "akromegali" "akromegalier" ;
  akronym_nn_1 = mkN "akronym" "akronymer" ;
  akropol_nn_1 = mkN "akropol" "akropoler" ;
  akrostikon_nn_1 = mkN "akrostikon" neutrum ;
  akt_nn_1 = mkN "akt" "akter" ;
  akter_ab_1 = mkAdv "akter" ;
  akter_nn_1 = mkN "akter" ;
  akterdaeck_nn_1 = mkN "akterdдck" neutrum ;
  akterdel_nn_1 = mkN "akterdel" "akterdelen" "akterdelar" "akterdelarna" ;
  akterlig_av_1 = mkA "akterlig" ;
  akterskepp_nn_1 = mkN "akterskepp" neutrum ;
  akterspegel_nn_1 = mkN "akterspegel" ;
  aktie_nn_1 = mkN "aktie" "aktier" ;
  aktieaegande_nn_1 = mkN "aktieдgande" ;
  aktieaegare_nn_1 = mkN "aktieдgare" "aktieдgare" ;
  aktieboers_nn_1 = mkN "aktiebцrs" "aktiebцrser" ;
  aktiebolag_nn_1 = mkN "aktiebolag" neutrum ;
  aktiebrev_nn_1 = mkN "aktiebrev" neutrum ;
  aktieemission_nn_1 = mkN "aktieemission" "aktieemissioner" ;
  aktiekapital_nn_1 = mkN "aktiekapital" neutrum ;
  aktiekupong_nn_1 = mkN "aktiekupong" "aktiekuponger" ;
  aktiekurs_nn_1 = mkN "aktiekurs" "aktiekurser" ;
  aktiemajoritet_nn_1 = mkN "aktiemajoritet" "aktiemajoriteter" ;
  aktieportfoelj_nn_1 = mkN "aktieportfцlj" "aktieportfцljer" ;
  aktiepost_nn_1 = mkN "aktiepost" "aktieposter" ;
  aktiesparklubb_nn_1 = mkN "aktiesparklubb" ;
  aktiestock_nn_1 = mkN "aktiestock" ;
  aktieutdelning_nn_1 = mkN "aktieutdelning" ;
  aktievinst_nn_1 = mkN "aktievinst" "aktievinster" ;
  aktion_nn_1 = mkN "aktion" "aktioner" ;
  aktionsart_nn_1 = mkN "aktionsart" "aktionsarter" ;
  aktionsgrupp_nn_1 = mkN "aktionsgrupp" "aktionsgrupper" ;
  aktionsradie_nn_1 = mkN "aktionsradie" "aktionsradier" ;
  aktionssaett_nn_1 = mkN "aktionssдtt" neutrum ;
  aktionsstroem_nn_1 = mkN "aktionsstrцm" "aktionsstrцmmen" "aktionsstrцmmar" "aktionsstrцmmarna" ;
  aktionsturbin_nn_1 = mkN "aktionsturbin" "aktionsturbiner" ;
  aktiv_av_1 = mkA "aktiv" ;
  aktiva_nn_1 = mkN "aktiva" "aktivan" "aktiva" "aktivana" ;
  aktivist_nn_1 = mkN "aktivist" "aktivister" ;
  aktivitet_nn_1 = mkN "aktivitet" "aktiviteter" ;
  aktivum_nn_1 = mkN "aktivum" "aktivet" "aktiver" "aktiverna" ;
  aktningsfull_av_1 = mkA "aktningsfull" ;
  aktningsvaerd_av_1 = mkA "aktningsvдrd" "aktningsvдrt" ;
  aktoer_nn_1 = mkN "aktцr" "aktцrer" ;
  aktor_nn_1 = mkN "aktor" "aktorer" ;
  aktris_nn_1 = mkN "aktris" "aktriser" ;
  aktsam_av_1 = mkA "aktsam" "aktsamt" "aktsamma" "aktsamma" "aktsammare" "aktsammast" "aktsammaste" ;
  aktstycke_nn_1 = mkN "aktstycke" ;
  aktualitet_nn_1 = mkN "aktualitet" "aktualiteter" ;
  aktuarie_nn_1 = mkN "aktuarie" "aktuarier" ;
  aktuell_av_1 = mkA "aktuell" ;
  akustisk_av_1 = mkA "akustisk" ;
  akut_ab_1 = mkAdv "akut" ;
  akut_av_1 = mkA "akut" "akut" ;
  akut_nn_1 = mkN "akut" "akuter" ;
  akutavdelning_nn_1 = mkN "akutavdelning" ;
  akutfall_nn_1 = mkN "akutfall" neutrum ;
  akutmottagning_nn_1 = mkN "akutmottagning" ;
  akvakultur_nn_1 = mkN "akvakultur" "akvakulturer" ;
  akvamarin_nn_1 = mkN "akvamarin" "akvamariner" ;
  akvanaut_nn_1 = mkN "akvanaut" "akvanauter" ;
  akvaplaning_nn_1 = mkN "akvaplaning" ;
  akvarell_nn_1 = mkN "akvarell" "akvareller" ;
  akvarellfaerg_nn_1 = mkN "akvarellfдrg" "akvarellfдrger" ;
  akvarellist_nn_1 = mkN "akvarellist" "akvarellister" ;
  akvariefisk_nn_1 = mkN "akvariefisk" ;
  akvarium_nn_1 = mkN "akvarium" "akvariet" "akvarier" "akvarierna" ;
  akvatint_nn_1 = mkN "akvatint" "akvatinter" ;
  akvatisk_av_1 = mkA "akvatisk" ;
  akvavit_nn_1 = mkN "akvavit" "akvaviter" ;
  akvedukt_nn_1 = mkN "akvedukt" "akvedukter" ;
  al_nn_1 = mkN "al" ;
  aladaab_nn_1 = mkN "aladеb" "aladеber" ;
  alagreck_nn_1 = mkN "alagreck" "alagrecker" ;
  alan_nn_1 = mkN "alan" "alaner" ;
  alanin_nn_1 = mkN "alanin" neutrum ;
  alant_nn_1 = mkN "alant" "alanter" ;
  alarm_nn_1 = mkN "alarm" neutrum ;
  alarmerande_av_1 = mkA "alarmerande" ;
  alban_nn_1 = mkN "alban" "albaner" ;
  albansk_av_1 = mkA "albansk" ;
  albanska_nn_2 = mkN "albanska" ;
  albatross_nn_1 = mkN "albatross" "albatrosser" ;
  albigenser_nn_1 = mkN "albigenser" "albigensern" "albigenser" "albigenserna" ;
  albino_nn_1 = mkN "albino" "albinon" "albiner" "albinerna" ;
  album_nn_1 = mkN "album" neutrum ;
  albumin_nn_1 = mkN "albumin" "albuminer" ;
  albyl_nn_1 = mkN "albyl" "albylen" "albyl" "albylen" ;
  aldehyd_nn_1 = mkN "aldehyd" "aldehyder" ;
  aldrig_ab_1 = mkAdv "aldrig" ;
  alemann_nn_1 = mkN "alemann" "alemanner" ;
  alert_av_1 = mkA "alert" "alert" ;
  alexandrin_nn_1 = mkN "alexandrin" "alexandriner" ;
  alexandrinsk_av_1 = mkA "alexandrinsk" ;
  alexi_nn_1 = mkN "alexi" "alexier" ;
  alf_nn_1 = mkN "alf" "alfer" ;
  alfa_nn_1 = mkN "alfa" "alfat" "alfan" "alfana" ;
  alfaagel_nn_1 = mkN "alfеgel" ;
  alfabet_nn_1 = mkN "alfabet" neutrum ;
  alfabetisk_av_1 = mkA "alfabetisk" ;
  alfametyltyrosin_nn_1 = mkN "alfametyltyrosin" "alfametyltyrosiner" ;
  alfanumerisk_av_1 = mkA "alfanumerisk" ;
  alfapartikel_nn_1 = mkN "alfapartikel" ;
  alfastraalning_nn_1 = mkN "alfastrеlning" ;
  alfkors_nn_1 = mkN "alfkors" neutrum ;
  alfoerraedare_nn_1 = mkN "alfцrrдdare" "alfцrrдdare" ;
  alfons_nn_1 = mkN "alfons" "alfonser" ;
  alfresko_ab_1 = mkAdv "alfresko" ;
  alg_nn_1 = mkN "alg" "alger" ;
  algebraisk_av_1 = mkA "algebraisk" ;
  algerier_nn_1 = mkN "algerier" "algeriern" "algerier" "algerierna" ;
  algerisk_av_1 = mkA "algerisk" ;
  algolog_nn_1 = mkN "algolog" "algologer" ;
  algonk_nn_1 = mkN "algonk" "algonker" ;
  algoritm_nn_1 = mkN "algoritm" "algoritmer" ;
  alias_ab_1 = mkAdv "alias" ;
  alibi_nn_1 = mkN "alibi" "alibit" "alibin" "alibina" ;
  alienation_nn_1 = mkN "alienation" "alienationer" ;
  alifatisk_av_1 = mkA "alifatisk" ;
  alimentaer_av_1 = mkA "alimentдr" ;
  alkaisk_av_1 = mkA "alkaisk" ;
  alkali_nn_1 = mkN "alkali" "alkalit" "alkalier" "alkalierna" ;
  alkalimetall_nn_1 = mkN "alkalimetall" "alkalimetaller" ;
  alkalisk_av_1 = mkA "alkalisk" ;
  alkaloid_nn_1 = mkN "alkaloid" "alkaloider" ;
  alkan_nn_1 = mkN "alkan" "alkaner" ;
  alkanol_nn_1 = mkN "alkanol" "alkanoler" ;
  alkekung_nn_1 = mkN "alkekung" ;
  alkemist_nn_1 = mkN "alkemist" "alkemister" ;
  alkfaagel_nn_1 = mkN "alkfеgel" ;
  alkohol_nn_1 = mkN "alkohol" "alkoholer" ;
  alkoholhalt_nn_1 = mkN "alkoholhalt" "alkoholhalter" ;
  alkoholhaltig_av_1 = mkA "alkoholhaltig" ;
  alkoholisk_av_1 = mkA "alkoholisk" ;
  alkoholist_nn_1 = mkN "alkoholist" "alkoholister" ;
  alkoholistanstalt_nn_1 = mkN "alkoholistanstalt" "alkoholistanstalter" ;
  alkoholmissbrukare_nn_1 = mkN "alkoholmissbrukare" "alkoholmissbrukare" ;
  alkoholometer_nn_1 = mkN "alkoholometer" ;
  alkoholpsykos_nn_1 = mkN "alkoholpsykos" "alkoholpsykoser" ;
  alkoholsvag_av_1 = mkA "alkoholsvag" ;
  alkoholtest_nn_1 = mkN "alkoholtest" neutrum ;
  alkotest_nn_1 = mkN "alkotest" neutrum ;
  alkotte_nn_1 = mkN "alkotte" utrum ;
  alkov_nn_1 = mkN "alkov" "alkover" ;
  alkyd_nn_1 = mkN "alkyd" "alkyder" ;
  alkyl_nn_1 = mkN "alkyl" "alkyler" ;
  alkyn_nn_1 = mkN "alkyn" "alkyner" ;
  allaetare_nn_1 = mkN "allдtare" "allдtare" ;
  allan_ab_1 = mkAdv "allan" ;
  allaredan_ab_1 = mkAdv "allaredan" ;
  allbekant_av_1 = mkA "allbekant" "allbekant" ;
  alldaglig_av_1 = mkA "alldaglig" ;
  alldeles_ab_1 = mkAdv "alldeles" ;
  alle_nn_1 = mkN "allй" "allйer" ;
  allegat_nn_1 = mkN "allegat" neutrum ;
  allegori_nn_1 = mkN "allegori" "allegorier" ;
  allegorisk_av_1 = mkA "allegorisk" ;
  allegretto_ab_1 = mkAdv "allegretto" ;
  allegretto_nn_1 = mkN "allegretto" "allegrettot" "allegretton" "allegrettona" ;
  allegro_ab_1 = mkAdv "allegro" ;
  allegro_nn_1 = mkN "allegro" "allegrot" "allegron" "allegrona" ;
  allehanda_av_1 = mkA "allehanda" ;
  allemansfond_nn_1 = mkN "allemansfond" "allemansfonder" ;
  allena_av_1 = mkA "allena" ;
  allenaraadande_av_1 = mkA "allenarеdande" ;
  allenast_ab_1 = mkAdv "allenast" ;
  allergen_av_1 = mkA "allergen" ;
  allergen_nn_1 = mkN "allergen" neutrum ;
  allergi_nn_1 = mkN "allergi" "allergier" ;
  allergiker_nn_1 = mkN "allergiker" "allergikern" "allergiker" "allergikerna" ;
  allergisk_av_1 = mkA "allergisk" ;
  allergolog_nn_1 = mkN "allergolog" "allergologer" ;
  allestaedes_ab_1 = mkAdv "allestдdes" ;
  allfarvaeg_nn_1 = mkN "allfarvдg" ;
  allhelgonadag_nn_1 = mkN "allhelgonadag" ;
  allians_nn_1 = mkN "allians" "allianser" ;
  alliansfri_av_1 = mkA "alliansfri" "alliansfritt" ;
  alliansring_nn_1 = mkN "alliansring" ;
  alligator_nn_1 = mkN "alligator" "alligatorer" ;
  allitteration_nn_1 = mkN "allitteration" "allitterationer" ;
  allkonstverk_nn_1 = mkN "allkonstverk" neutrum ;
  allmaen_av_1 = mkA "allmдn" "allmдnt" "allmдnna" "allmдnna" "allmдnnare" "allmдnnast" "allmдnnaste" ;
  allmaenbegaavning_nn_1 = mkN "allmдnbegеvning" ;
  allmaenbegrepp_nn_1 = mkN "allmдnbegrepp" neutrum ;
  allmaenfarlig_av_1 = mkA "allmдnfarlig" ;
  allmaengiltig_av_1 = mkA "allmдngiltig" ;
  allmaengiltighet_nn_1 = mkN "allmдngiltighet" "allmдngiltigheter" ;
  allmaenhet_nn_1 = mkN "allmдnhet" "allmдnheter" ;
  allmaenmaensklig_av_1 = mkA "allmдnmдnsklig" ;
  allmaennelig_av_1 = mkA "allmдnnelig" ;
  allmaenning_nn_1 = mkN "allmдnning" ;
  allmaennyttig_av_1 = mkA "allmдnnyttig" ;
  allmaenpolitisk_av_1 = mkA "allmдnpolitisk" ;
  allmaenpraktiker_nn_1 = mkN "allmдnpraktiker" "allmдnpraktikern" "allmдnpraktiker" "allmдnpraktikerna" ;
  allmaenpraktiserande_av_1 = mkA "allmдnpraktiserande" ;
  allmaenpreventiv_av_1 = mkA "allmдnpreventiv" ;
  allmogeblaa_av_1 = mkA "allmogeblе" "allmogeblеtt" ;
  allmogedraekt_nn_1 = mkN "allmogedrдkt" "allmogedrдkter" ;
  allmogekultur_nn_1 = mkN "allmogekultur" "allmogekulturer" ;
  allmogevaevnad_nn_1 = mkN "allmogevдvnad" "allmogevдvnader" ;
  allod_nn_1 = mkN "allod" "allodet" "alloder" "alloderna" ;
  allodial_av_1 = mkA "allodial" ;
  allodium_nn_1 = mkN "allodium" "allodiet" "allodier" "allodierna" ;
  allofon_nn_1 = mkN "allofon" "allofoner" ;
  allograf_nn_1 = mkN "allograf" "allografer" ;
  allokton_av_1 = mkA "allokton" ;
  allokution_nn_1 = mkN "allokution" "allokutioner" ;
  allomfattande_av_1 = mkA "allomfattande" ;
  allomorf_av_1 = mkA "allomorf" ;
  allomorf_nn_1 = mkN "allomorf" "allomorfer" ;
  allongeperuk_nn_1 = mkN "allongeperuk" "allongeperuker" ;
  allra_ab_1 = mkAdv "allra" ;
  allraheligaste_av_1 = mkA "allraheligaste" ;
  allriskfoersaekring_nn_1 = mkN "allriskfцrsдkring" ;
  allround_av_1 = mkA "allround" ;
  allrum_nn_1 = mkN "allrum" "allrummet" "allrum" "allrummen" ;
  alls_ab_1 = mkAdv "alls" ;
  allsaang_nn_1 = mkN "allsеng" "allsеnger" ;
  allseende_av_1 = mkA "allseende" ;
  allshaerjarting_nn_1 = mkN "allshдrjarting" neutrum ;
  allsidig_av_1 = mkA "allsidig" ;
  allskoens_av_1 = mkA "allskцns" ;
  allsmaektig_av_1 = mkA "allsmдktig" ;
  allstroemsapparat_nn_1 = mkN "allstrцmsapparat" "allstrцmsapparater" ;
  allsvaaldig_av_1 = mkA "allsvеldig" ;
  allsvensk_av_1 = mkA "allsvensk" ;
  allt_ab_1 = mkAdv "allt" ;
  alltemellanaat_ab_1 = mkAdv "alltemellanеt" ;
  alltfoer_ab_1 = mkAdv "alltfцr" ;
  alltfort_ab_1 = mkAdv "alltfort" ;
  alltiallo_nn_1 = mkN "alltiallo" "alltiallor" ;
  alltid_ab_1 = mkAdv "alltid" ;
  alltigenom_ab_1 = mkAdv "alltigenom" ;
  allting_nn_1 = mkN "allting" neutrum ;
  alltjaemt_ab_1 = mkAdv "alltjдmt" ;
  alltmer_ab_1 = mkAdv "alltmer" ;
  alltmera_ab_1 = mkAdv "alltmera" ;
  alltnog_ab_1 = mkAdv "alltnog" ;
  alltomfattande_av_1 = mkA "alltomfattande" ;
  alltsaa_ab_1 = mkAdv "alltsе" ;
  alltsomoftast_ab_1 = mkAdv "alltsomoftast" ;
  allusion_nn_1 = mkN "allusion" "allusioner" ;
  alluvial_av_1 = mkA "alluvial" ;
  alluvium_nn_1 = mkN "alluvium" "alluviumet" "alluvier" "alluvierna" ;
  allvaedersstoevel_nn_1 = mkN "allvдdersstцvel" ;
  allvarlig_av_1 = mkA "allvarlig" ;
  allvarligen_ab_1 = mkAdv "allvarligen" ;
  allvarsam_av_1 = mkA "allvarsam" "allvarsamt" "allvarsamma" "allvarsamma" "allvarsammare" "allvarsammast" "allvarsammaste" ;
  allvarsord_nn_1 = mkN "allvarsord" neutrum ;
  allvarstyngd_av_1 = mkA "allvarstyngd" "allvarstyngt" ;
  allvetande_av_1 = mkA "allvetande" ;
  allvetare_nn_1 = mkN "allvetare" "allvetare" ;
  allvis_av_1 = mkA "allvis" ;
  alm_nn_1 = mkN "alm" ;
  almanacksblad_nn_1 = mkN "almanacksblad" neutrum ;
  aln_nn_1 = mkN "aln" ;
  aloe_nn_1 = mkN "aloe" "aloer" ;
  alp_nn_1 = mkN "alp" "alper" ;
  alpari_ab_1 = mkAdv "alpari" ;
  alpget_nn_1 = mkN "alpget" "alpgetter" ;
  alpin_av_1 = mkA "alpin" ;
  alpinist_nn_1 = mkN "alpinist" "alpinister" ;
  alpinsk_av_1 = mkA "alpinsk" ;
  alpjaegare_nn_1 = mkN "alpjдgare" "alpjдgare" ;
  alpviol_nn_1 = mkN "alpviol" "alpvioler" ;
  alster_nn_1 = mkN "alster" neutrum ;
  alstring_nn_1 = mkN "alstring" ;
  alt_nn_1 = mkN "alt" ;
  altan_nn_1 = mkN "altan" "altaner" ;
  altarbrun_nn_1 = mkN "altarbrun" neutrum ;
  altare_nn_1 = mkN "altare" "altaret" "altaren" "altarna" ;
  altargaang_nn_1 = mkN "altargеng" ;
  altarprydnad_nn_1 = mkN "altarprydnad" "altarprydnader" ;
  altarring_nn_1 = mkN "altarring" ;
  altarrund_nn_1 = mkN "altarrund" "altarrunder" ;
  altarskaap_nn_1 = mkN "altarskеp" neutrum ;
  altartavla_nn_1 = mkN "altartavla" ;
  altartjaenst_nn_1 = mkN "altartjдnst" "altartjдnster" ;
  alteration_nn_1 = mkN "alteration" "alterationer" ;
  alternativ_av_1 = mkA "alternativ" ;
  alternativ_nn_1 = mkN "alternativ" neutrum ;
  alternativfraaga_nn_1 = mkN "alternativfrеga" ;
  alternativkurs_nn_1 = mkN "alternativkurs" "alternativkurser" ;
  alternatvinkel_nn_1 = mkN "alternatvinkel" ;
  altfiol_nn_1 = mkN "altfiol" "altfioler" ;
  altitud_nn_1 = mkN "altitud" "altituder" ;
  altruist_nn_1 = mkN "altruist" "altruister" ;
  altruistisk_av_1 = mkA "altruistisk" ;
  altstaemma_nn_1 = mkN "altstдmma" ;
  altviolin_nn_1 = mkN "altviolin" "altvioliner" ;
  aluminiumjon_nn_1 = mkN "aluminiumjon" "aluminiumjoner" ;
  aluminiumpulver_nn_1 = mkN "aluminiumpulver" neutrum ;
  alumn_nn_1 = mkN "alumn" "alumner" ;
  alunskiffer_nn_1 = mkN "alunskiffer" ;
  alv_nn_2 = mkN "alv" "alver" ;
  alvarsmark_nn_1 = mkN "alvarsmark" "alvarsmarker" ;
  alveol_nn_1 = mkN "alveol" "alveoler" ;
  alveolar_av_1 = mkA "alveolar" ;
  alveolar_nn_1 = mkN "alveolar" "alveolarer" ;
  alvplog_nn_1 = mkN "alvplog" ;
  amalgam_nn_1 = mkN "amalgam" neutrum ;
  amanuens_nn_1 = mkN "amanuens" "amanuenser" ;
  amarant_nn_1 = mkN "amarant" "amaranter" ;
  amaryllis_nn_1 = mkN "amaryllis" ;
  amason_nn_1 = mkN "amason" "amasoner" ;
  amatoer_nn_1 = mkN "amatцr" "amatцrer" ;
  amatoerbestaemmelse_nn_1 = mkN "amatцrbestдmmelse" "amatцrbestдmmelser" ;
  amatoerforskare_nn_1 = mkN "amatцrforskare" "amatцrforskare" ;
  amatoeridrott_nn_1 = mkN "amatцridrott" "amatцridrotter" ;
  amatoermaessig_av_1 = mkA "amatцrmдssig" ;
  amatoerregel_nn_1 = mkN "amatцrregel" "amatцrregeln" "amatцrregler" "amatцrreglerna" ;
  amatoersaendare_nn_1 = mkN "amatцrsдndare" "amatцrsдndare" ;
  amatoerteleskop_nn_1 = mkN "amatцrteleskop" neutrum ;
  ambassad_nn_1 = mkN "ambassad" "ambassader" ;
  ambassadoer_nn_1 = mkN "ambassadцr" "ambassadцrer" ;
  ambassadraad_nn_1 = mkN "ambassadrеd" neutrum ;
  ambiguitet_nn_1 = mkN "ambiguitet" "ambiguiteter" ;
  ambitioes_av_1 = mkA "ambitiцs" ;
  ambition_nn_1 = mkN "ambition" "ambitioner" ;
  ambitionssak_nn_1 = mkN "ambitionssak" "ambitionssaker" ;
  ambivalent_av_1 = mkA "ambivalent" "ambivalent" ;
  ambrosisk_av_1 = mkA "ambrosisk" ;
  ambulans_nn_1 = mkN "ambulans" "ambulanser" ;
  ambulatorisk_av_1 = mkA "ambulatorisk" ;
  amendemang_nn_1 = mkN "amendemang" neutrum ;
  amerikan_nn_1 = mkN "amerikan" "amerikaner" ;
  amerikanare_nn_1 = mkN "amerikanare" "amerikanare" ;
  amerikanism_nn_1 = mkN "amerikanism" "amerikanismer" ;
  amerikansk_av_1 = mkA "amerikansk" ;
  amerikanska_nn_2 = mkN "amerikanska" ;
  ametist_nn_1 = mkN "ametist" "ametister" ;
  amfetamin_nn_1 = mkN "amfetamin" "amfetaminer" ;
  amfibie_nn_1 = mkN "amfibie" "amfibier" ;
  amfibisk_av_1 = mkA "amfibisk" ;
  amfibolit_nn_1 = mkN "amfibolit" "amfiboliter" ;
  amfiteater_nn_1 = mkN "amfiteater" ;
  amfiteatralisk_av_1 = mkA "amfiteatralisk" ;
  ami_nn_1 = mkN "ami" "amier" ;
  amid_nn_1 = mkN "amid" "amider" ;
  amin_nn_1 = mkN "amin" "aminer" ;
  amiral_nn_1 = mkN "amiral" "amiraler" ;
  amiralsperson_nn_1 = mkN "amiralsperson" "amiralspersoner" ;
  ammonit_nn_1 = mkN "ammonit" "ammoniter" ;
  ammoniumnitrat_nn_1 = mkN "ammoniumnitrat" "ammoniumnitrater" ;
  ammoniumnitratloesning_nn_1 = mkN "ammoniumnitratlцsning" ;
  amnesi_nn_1 = mkN "amnesi" "amnesier" ;
  amnesti_nn_1 = mkN "amnesti" "amnestier" ;
  amoralisk_av_1 = mkA "amoralisk" ;
  amoralitet_nn_1 = mkN "amoralitet" "amoraliteter" ;
  amorbaage_nn_1 = mkN "amorbеge" utrum ;
  amorf_av_1 = mkA "amorf" ;
  amorfism_nn_1 = mkN "amorfism" "amorfismer" ;
  amorin_nn_1 = mkN "amorin" "amoriner" ;
  amoroes_av_1 = mkA "amorцs" ;
  amortering_nn_1 = mkN "amortering" ;
  amorteringsfri_av_1 = mkA "amorteringsfri" "amorteringsfritt" ;
  amorteringsplan_nn_1 = mkN "amorteringsplan" "amorteringsplaner" ;
  ampel_av_1 = mkA "ampel" "ampelt" "ampla" "ampla" "amplare" "amplast" "amplaste" ;
  ampel_nn_1 = mkN "ampel" ;
  amper_av_1 = mkA "amper" "ampert" "ampra" "ampra" "amprare" "amprast" "ampraste" ;
  ampere_nn_1 = mkN "ampere" "amperen" "ampere" "amperena" ;
  amperemeter_nn_1 = mkN "amperemeter" ;
  amperesekund_nn_1 = mkN "amperesekund" "amperesekunder" ;
  amperevarv_nn_1 = mkN "amperevarv" neutrum ;
  amplitud_nn_1 = mkN "amplitud" "amplituder" ;
  amplitudmodulering_nn_1 = mkN "amplitudmodulering" ;
  ampull_nn_1 = mkN "ampull" "ampuller" ;
  amputation_nn_1 = mkN "amputation" "amputationer" ;
  amsaga_nn_1 = mkN "amsaga" ;
  amt_nn_1 = mkN "amt" neutrum ;
  amulett_nn_1 = mkN "amulett" "amuletter" ;
  amylas_nn_1 = mkN "amylas" "amylaser" ;
  amyotrofi_nn_1 = mkN "amyotrofi" "amyotrofier" ;
  an_ab_1 = mkAdv "an" ;
  anabaptist_nn_1 = mkN "anabaptist" "anabaptister" ;
  anabatisk_av_1 = mkA "anabatisk" ;
  anabol_nn_1 = mkN "anabol" "anaboler" ;
  anaerob_av_1 = mkA "anaerob" ;
  anafor_nn_1 = mkN "anafor" "anaforen" "anaforer" "anaforerna" ;
  anaforisk_av_1 = mkA "anaforisk" ;
  anagram_nn_1 = mkN "anagram" "anagrammet" "anagram" "anagrammen" ;
  anakolut_nn_1 = mkN "anakolut" "anakoluter" ;
  anakoret_nn_1 = mkN "anakoret" "anakoreter" ;
  anakreontisk_av_1 = mkA "anakreontisk" ;
  anakronism_nn_1 = mkN "anakronism" "anakronismer" ;
  anal_av_1 = mkA "anal" ;
  analfabet_nn_1 = mkN "analfabet" "analfabeter" ;
  analgetika_nn_1 = mkN "analgetika" "analgetikan" "analgetika" "analgetikana" ;
  analoeppning_nn_1 = mkN "analцppning" ;
  analog_av_1 = mkA "analog" ;
  analogi_nn_1 = mkN "analogi" "analogier" ;
  analogibevis_nn_1 = mkN "analogibevis" neutrum ;
  analogibildning_nn_1 = mkN "analogibildning" ;
  analogisk_av_1 = mkA "analogisk" ;
  analogislut_nn_1 = mkN "analogislut" neutrum ;
  analys_nn_1 = mkN "analys" "analyser" ;
  analytiker_nn_1 = mkN "analytiker" "analytikern" "analytiker" "analytikerna" ;
  analytisk_av_1 = mkA "analytisk" ;
  anamnes_nn_1 = mkN "anamnes" "anamneser" ;
  ananas_nn_1 = mkN "ananas" ;
  anapest_nn_1 = mkN "anapest" "anapester" ;
  anarkisk_av_1 = mkA "anarkisk" ;
  anarkist_nn_1 = mkN "anarkist" "anarkister" ;
  anarkistisk_av_1 = mkA "anarkistisk" ;
  anastas_nn_1 = mkN "anastas" "anastaser" ;
  anastatisk_av_1 = mkA "anastatisk" ;
  anastigmatisk_av_1 = mkA "anastigmatisk" ;
  anatema_nn_1 = mkN "anatema" "anatemat" "anateman" "anatemana" ;
  anatom_nn_1 = mkN "anatom" "anatomer" ;
  anatomisk_av_1 = mkA "anatomisk" ;
  anblick_nn_1 = mkN "anblick" ;
  anbrott_nn_1 = mkN "anbrott" neutrum ;
  anbud_nn_1 = mkN "anbud" neutrum ;
  anciennitet_nn_1 = mkN "anciennitet" "ancienniteter" ;
  and_nn_1 = mkN "and" "дnder" ;
  andaektig_av_1 = mkA "andдktig" ;
  andakt_nn_1 = mkN "andakt" "andakter" ;
  andaktsbok_nn_1 = mkN "andaktsbok" "andaktsbцcker" ;
  andaktsfull_av_1 = mkA "andaktsfull" ;
  andante_ab_1 = mkAdv "andante" ;
  andante_nn_1 = mkN "andante" ;
  ande_nn_1 = mkN "ande" utrum ;
  andebesvaerjare_nn_1 = mkN "andebesvдrjare" "andebesvдrjare" ;
  andebesvaerjelse_nn_1 = mkN "andebesvдrjelse" "andebesvдrjelser" ;
  andedrag_nn_1 = mkN "andedrag" neutrum ;
  andefattig_av_1 = mkA "andefattig" ;
  andefattigdom_nn_1 = mkN "andefattigdom" ;
  andel_nn_1 = mkN "andel" "andelen" "andelar" "andelarna" ;
  andelsfoerening_nn_1 = mkN "andelsfцrening" ;
  andemening_nn_1 = mkN "andemening" ;
  andeskaadare_nn_1 = mkN "andeskеdare" "andeskеdare" ;
  andetag_nn_1 = mkN "andetag" neutrum ;
  andevaesen_nn_1 = mkN "andevдsen" "andevдsendet" "andevдsen" "andevдsena" ;
  andfaadd_av_1 = mkA "andfеdd" ;
  andfaagel_nn_1 = mkN "andfеgel" ;
  andlig_av_1 = mkA "andlig" ;
  andligen_ab_1 = mkAdv "andligen" ;
  andloes_av_1 = mkA "andlцs" ;
  andning_nn_1 = mkN "andning" ;
  andningsapparat_nn_1 = mkN "andningsapparat" "andningsapparater" ;
  andningsenzym_nn_1 = mkN "andningsenzym" neutrum ;
  andningshaal_nn_1 = mkN "andningshеl" neutrum ;
  andningsorgan_nn_1 = mkN "andningsorgan" neutrum ;
  andningspaus_nn_1 = mkN "andningspaus" "andningspauser" ;
  andningsreaktion_nn_1 = mkN "andningsreaktion" "andningsreaktioner" ;
  andningsroer_nn_1 = mkN "andningsrцr" neutrum ;
  andorran_nn_1 = mkN "andorran" "andorraner" ;
  andorransk_av_1 = mkA "andorransk" ;
  andra_vb_1 = mkV "andra" "andrar" "andra" "androg" "andragit" "andragen" ;
  andrabas_nn_1 = mkN "andrabas" ;
  andrabil_nn_1 = mkN "andrabil" ;
  andrag_nn_1 = mkN "andrag" neutrum ;
  andragradsekvation_nn_1 = mkN "andragradsekvation" "andragradsekvationer" ;
  andrahandsbutik_nn_1 = mkN "andrahandsbutik" "andrahandsbutiker" ;
  andrahandsvaerde_nn_1 = mkN "andrahandsvдrde" ;
  andrake_nn_1 = mkN "andrake" utrum ;
  andraklassbiljett_nn_1 = mkN "andraklassbiljett" "andraklassbiljetter" ;
  andranamn_nn_1 = mkN "andranamn" neutrum ;
  andraplacering_nn_1 = mkN "andraplacering" ;
  andraplats_nn_1 = mkN "andraplats" "andraplatser" ;
  andratenor_nn_1 = mkN "andratenor" "andratenoren" "andratenorer" "andratenorerna" ;
  andratidning_nn_1 = mkN "andratidning" ;
  andreaskors_nn_1 = mkN "andreaskors" neutrum ;
  andrebas_nn_1 = mkN "andrebas" ;
  andretenor_nn_1 = mkN "andretenor" "andretenoren" "andretenorer" "andretenorerna" ;
  androgyn_av_1 = mkA "androgyn" ;
  androgyn_nn_1 = mkN "androgyn" "androgyner" ;
  andryg_av_1 = mkA "andryg" ;
  andstraeck_nn_1 = mkN "andstrдck" neutrum ;
  andtaeppt_av_1 = mkA "andtдppt" "andtдppt" ;
  andtruten_av_1 = mkA "andtruten" "andtrutet" ;
  andur_nn_1 = mkN "andur" "anduren" "andrar" "andrarna" ;
  anekdot_nn_1 = mkN "anekdot" "anekdoter" ;
  anekdotisk_av_1 = mkA "anekdotisk" ;
  anemi_nn_1 = mkN "anemi" "anemier" ;
  anemisk_av_1 = mkA "anemisk" ;
  anemometer_nn_1 = mkN "anemometer" ;
  anemon_nn_1 = mkN "anemon" "anemoner" ;
  aneroidbarometer_nn_1 = mkN "aneroidbarometer" ;
  anestesi_nn_1 = mkN "anestesi" "anestesier" ;
  anestesiolog_nn_1 = mkN "anestesiolog" "anestesiologer" ;
  anestetika_nn_1 = mkN "anestetika" "anestetikan" "anestetika" "anestetikana" ;
  anestetisk_av_1 = mkA "anestetisk" ;
  anfader_nn_1 = mkN "anfader" "anfadern" "anfдder" "anfдderna" ;
  anfaektelse_nn_1 = mkN "anfдktelse" "anfдktelser" ;
  anfall_nn_1 = mkN "anfall" neutrum ;
  anfalla_vb_1 = mkV "anfalla" "anfцll" "anfallit" ;
  anfallare_nn_1 = mkN "anfallare" "anfallare" ;
  anfallsbas_nn_1 = mkN "anfallsbas" "anfallsbaser" ;
  anfallsfront_nn_1 = mkN "anfallsfront" "anfallsfronter" ;
  anfallskrig_nn_1 = mkN "anfallskrig" neutrum ;
  anfallslinje_nn_1 = mkN "anfallslinje" "anfallslinjer" ;
  anfallsspel_nn_1 = mkN "anfallsspel" "anfallsspelet" "anfallsspel" "anfallsspelen" ;
  anfallsspelare_nn_1 = mkN "anfallsspelare" "anfallsspelare" ;
  anfallsvinkel_nn_1 = mkN "anfallsvinkel" ;
  anfang_nn_1 = mkN "anfang" "anfanger" ;
  anfart_nn_1 = mkN "anfart" "anfarter" ;
  anflog_nn_1 = mkN "anflog" neutrum ;
  anflygning_nn_1 = mkN "anflygning" ;
  anfoerande_nn_1 = mkN "anfцrande" ;
  anfoerare_nn_1 = mkN "anfцrare" "anfцrare" ;
  anfoering_nn_1 = mkN "anfцring" ;
  anfoeringstecken_nn_1 = mkN "anfцringstecken" "anfцringstecknet" "anfцringstecken" "anfцringstecknen" ;
  anfoeringsverb_nn_1 = mkN "anfцringsverb" neutrum ;
  anfoervant_nn_1 = mkN "anfцrvant" "anfцrvanter" ;
  ange_vb_1 = mkV "ange" "anger" "ange" "angav" "angett" "angiven" ;
  angel_nn_1 = mkN "angel" ;
  angelaegen_av_1 = mkA "angelдgen" "angelдget" ;
  angelaegenhet_nn_1 = mkN "angelдgenhet" "angelдgenheter" ;
  angelsachsare_nn_1 = mkN "angelsachsare" "angelsachsare" ;
  angelsaxare_nn_1 = mkN "angelsaxare" "angelsaxare" ;
  angenaem_av_1 = mkA "angenдm" ;
  angiosperm_nn_1 = mkN "angiosperm" "angiospermer" ;
  angivare_nn_1 = mkN "angivare" "angivare" ;
  angivelse_nn_1 = mkN "angivelse" "angivelser" ;
  angivelsebrott_nn_1 = mkN "angivelsebrott" neutrum ;
  angiveri_nn_1 = mkN "angiveri" "angiverit" "angiverier" "angiverierna" ;
  anglaes_nn_1 = mkN "anglдs" "anglдser" ;
  anglicism_nn_1 = mkN "anglicism" "anglicismer" ;
  anglikansk_av_1 = mkA "anglikansk" ;
  anglist_nn_1 = mkN "anglist" "anglister" ;
  anglosaxare_nn_1 = mkN "anglosaxare" "anglosaxare" ;
  anglosaxisk_av_1 = mkA "anglosaxisk" ;
  angolan_nn_1 = mkN "angolan" "angolaner" ;
  angolansk_av_1 = mkA "angolansk" ;
  angoraget_nn_1 = mkN "angoraget" "angoragetter" ;
  angorakatt_nn_1 = mkN "angorakatt" "angorakatter" ;
  angraensande_av_1 = mkA "angrдnsande" ;
  angrepp_nn_1 = mkN "angrepp" neutrum ;
  angreppspunkt_nn_1 = mkN "angreppspunkt" "angreppspunkter" ;
  angreppssaett_nn_1 = mkN "angreppssдtt" neutrum ;
  angripa_vb_1 = mkV "angripa" "angrep" "angripit" ;
  angripare_nn_1 = mkN "angripare" "angripare" ;
  anhaalla_vb_1 = mkV "anhеlla" "anhцll" "anhеllit" ;
  anhaallan_nn_1 = mkN "anhеllan" "anhеllan" "anhеllanden" "anhеllandena" ;
  anhaallande_nn_1 = mkN "anhеllande" ;
  anhaengare_nn_1 = mkN "anhдngare" "anhдngare" ;
  anhaengig_av_1 = mkA "anhдngig" ;
  anhalt_nn_1 = mkN "anhalt" "anhalter" ;
  anhang_nn_1 = mkN "anhang" neutrum ;
  anhoerig_av_1 = mkA "anhцrig" ;
  anhopning_nn_1 = mkN "anhopning" ;
  anilinfaerg_nn_1 = mkN "anilinfдrg" "anilinfдrger" ;
  animal_av_1 = mkA "animal" ;
  animalisk_av_1 = mkA "animalisk" ;
  animatoer_nn_1 = mkN "animatцr" "animatцrer" ;
  animistisk_av_1 = mkA "animistisk" ;
  animositet_nn_1 = mkN "animositet" "animositeter" ;
  aning_nn_1 = mkN "aning" ;
  aningsloes_av_1 = mkA "aningslцs" ;
  anisett_nn_1 = mkN "anisett" "anisetter" ;
  anjon_nn_1 = mkN "anjon" "anjoner" ;
  ankarboj_nn_1 = mkN "ankarboj" ;
  ankare_nn_1 = mkN "ankare" "ankaret" "ankare" "ankarna" ;
  ankarfly_nn_1 = mkN "ankarfly" "ankarflyt" "ankarflyn" "ankarflyen" ;
  ankargrund_nn_1 = mkN "ankargrund" "ankargrunder" ;
  ankarkabel_nn_1 = mkN "ankarkabel" ;
  ankarkaetting_nn_1 = mkN "ankarkдtting" ;
  ankarlindning_nn_1 = mkN "ankarlindning" ;
  ankarspel_nn_1 = mkN "ankarspel" "ankarspelet" "ankarspel" "ankarspelen" ;
  ankarstock_nn_1 = mkN "ankarstock" ;
  ankbonde_nn_1 = mkN "ankbonde" "ankbцnder" ;
  ankdamm_nn_1 = mkN "ankdamm" ;
  ankel_nn_1 = mkN "ankel" ;
  ankellaang_av_1 = mkA "ankellеng" ;
  anklagelse_nn_1 = mkN "anklagelse" "anklagelser" ;
  anklagelseakt_nn_1 = mkN "anklagelseakt" "anklagelseakter" ;
  anklagelsepunkt_nn_1 = mkN "anklagelsepunkt" "anklagelsepunkter" ;
  anklang_nn_1 = mkN "anklang" "anklanger" ;
  anknyta_vb_1 = mkV "anknyta" "anknцt" "anknutit" ;
  anknytning_nn_1 = mkN "anknytning" ;
  ankomma_vb_1 = mkV "ankomma" "ankom" "ankommit" ;
  ankommen_av_1 = mkA "ankommen" "ankommet" "ankomna" "ankomna" "ankomnare" "ankomnast" "ankomnaste" ;
  ankomst_nn_1 = mkN "ankomst" "ankomster" ;
  ankring_nn_1 = mkN "ankring" ;
  ankunge_nn_1 = mkN "ankunge" utrum ;
  anlaeggare_nn_1 = mkN "anlдggare" "anlдggare" ;
  anlaeggning_nn_1 = mkN "anlдggning" ;
  anlaeggningsarbetare_nn_1 = mkN "anlдggningsarbetare" "anlдggningsarbetare" ;
  anlaeggningskostnad_nn_1 = mkN "anlдggningskostnad" "anlдggningskostnader" ;
  anlaeggningsplats_nn_1 = mkN "anlдggningsplats" "anlдggningsplatser" ;
  anlaeggningstillgaang_nn_1 = mkN "anlдggningstillgеng" ;
  anlag_nn_1 = mkN "anlag" neutrum ;
  anlagsbaerare_nn_1 = mkN "anlagsbдrare" "anlagsbдrare" ;
  anlagstest_nn_1 = mkN "anlagstest" neutrum ;
  anledning_nn_1 = mkN "anledning" ;
  anletsdrag_nn_1 = mkN "anletsdrag" neutrum ;
  anlopp_nn_1 = mkN "anlopp" neutrum ;
  anloppshamn_nn_1 = mkN "anloppshamn" ;
  anlupen_av_1 = mkA "anlupen" "anlupet" ;
  anmaelan_nn_2 = mkN "anmдlan" "anmдlan" "anmдlningar" "anmдlningarna" ;
  anmaelare_nn_1 = mkN "anmдlare" "anmдlare" ;
  anmaelning_nn_1 = mkN "anmдlning" ;
  anmaelningstid_nn_1 = mkN "anmдlningstid" "anmдlningstider" ;
  anmaerkning_nn_1 = mkN "anmдrkning" ;
  anmaerkningsvaerd_av_1 = mkA "anmдrkningsvдrd" "anmдrkningsvдrt" ;
  anmodande_nn_1 = mkN "anmodande" ;
  anmoder_nn_1 = mkN "anmoder" "anmodern" "anmцdrar" "anmцdrarna" ;
  annalist_nn_1 = mkN "annalist" "annalister" ;
  annalkande_av_1 = mkA "annalkande" ;
  annandag_nn_1 = mkN "annandag" ;
  annanstans_ab_1 = mkAdv "annanstans" ;
  annars_ab_1 = mkAdv "annars" ;
  annektion_nn_1 = mkN "annektion" "annektioner" ;
  annex_nn_1 = mkN "annex" neutrum ;
  annexfoersamling_nn_1 = mkN "annexfцrsamling" ;
  annexion_nn_1 = mkN "annexion" "annexioner" ;
  annihilation_nn_1 = mkN "annihilation" "annihilationer" ;
  annons_nn_1 = mkN "annons" "annonser" ;
  annonsbyraa_nn_1 = mkN "annonsbyrе" "annonsbyrеer" ;
  annonskampanj_nn_1 = mkN "annonskampanj" "annonskampanjer" ;
  annonsoer_nn_1 = mkN "annonsцr" "annonsцrer" ;
  annonspelare_nn_1 = mkN "annonspelare" "annonspelare" ;
  annonsplats_nn_1 = mkN "annonsplats" "annonsplatser" ;
  annonssvar_nn_1 = mkN "annonssvar" neutrum ;
  annorlunda_ab_1 = mkAdv "annorlunda" ;
  annorlunda_av_1 = mkA "annorlunda" ;
  annorstaedes_ab_1 = mkAdv "annorstдdes" ;
  annotation_nn_1 = mkN "annotation" "annotationer" ;
  annuell_av_1 = mkA "annuell" ;
  annuitet_nn_1 = mkN "annuitet" "annuiteter" ;
  annuitetslaan_nn_1 = mkN "annuitetslеn" neutrum ;
  anod_nn_1 = mkN "anod" "anoder" ;
  anomali_nn_1 = mkN "anomali" "anomalier" ;
  anomi_nn_1 = mkN "anomi" "anomier" ;
  anonym_av_1 = mkA "anonym" ;
  anonymitet_nn_1 = mkN "anonymitet" "anonymiteter" ;
  anorak_nn_1 = mkN "anorak" "anoraker" ;
  anordning_nn_1 = mkN "anordning" ;
  anorexi_nn_1 = mkN "anorexi" "anorexier" ;
  anormal_av_1 = mkA "anormal" ;
  anpassbar_av_1 = mkA "anpassbar" ;
  anpasslig_av_1 = mkA "anpasslig" ;
  anpassling_nn_1 = mkN "anpassling" ;
  anpassning_nn_1 = mkN "anpassning" ;
  anpassningsgrupp_nn_1 = mkN "anpassningsgrupp" "anpassningsgrupper" ;
  anpassningsklinik_nn_1 = mkN "anpassningsklinik" "anpassningskliniker" ;
  anraettning_nn_1 = mkN "anrдttning" ;
  anrik_av_1 = mkA "anrik" ;
  anrikning_nn_1 = mkN "anrikning" ;
  anrop_nn_1 = mkN "anrop" neutrum ;
  ansaettningsskruv_nn_1 = mkN "ansдttningsskruv" ;
  ansamling_nn_1 = mkN "ansamling" ;
  ansats_nn_1 = mkN "ansats" "ansatser" ;
  ansedd_av_1 = mkA "ansedd" "ansedtt" ;
  ansenlig_av_1 = mkA "ansenlig" ;
  ansiktsbjudning_nn_1 = mkN "ansiktsbjudning" ;
  ansiktsdrag_nn_1 = mkN "ansiktsdrag" neutrum ;
  ansiktsfaerg_nn_1 = mkN "ansiktsfдrg" "ansiktsfдrger" ;
  ansiktskraem_nn_1 = mkN "ansiktskrдm" "ansiktskrдmer" ;
  ansiktslyftning_nn_1 = mkN "ansiktslyftning" ;
  ansiktsmask_nn_1 = mkN "ansiktsmask" "ansiktsmasker" ;
  ansiktsmuskel_nn_1 = mkN "ansiktsmuskel" "ansiktsmuskeln" "ansiktsmuskler" "ansiktsmusklerna" ;
  ansiktsnerv_nn_1 = mkN "ansiktsnerv" "ansiktsnerver" ;
  ansiktsskydd_nn_1 = mkN "ansiktsskydd" neutrum ;
  ansiktsuttryck_nn_1 = mkN "ansiktsuttryck" neutrum ;
  ansjovis_nn_1 = mkN "ansjovis" ;
  anskaffning_nn_1 = mkN "anskaffning" ;
  anskraemlig_av_1 = mkA "anskrдmlig" ;
  anskri_nn_1 = mkN "anskri" "anskrit" "anskrin" "anskrien" ;
  anskriven_av_1 = mkA "anskriven" "anskrivet" ;
  anslaaende_av_1 = mkA "anslеende" ;
  anslag_nn_1 = mkN "anslag" neutrum ;
  anslagsaeskande_nn_1 = mkN "anslagsдskande" ;
  anslagsbeviljande_av_1 = mkA "anslagsbeviljande" ;
  anslagsframstaellning_nn_1 = mkN "anslagsframstдllning" ;
  anslagstavla_nn_1 = mkN "anslagstavla" ;
  ansluta_vb_1 = mkV "ansluta" "anslцt" "anslutit" ;
  anslutning_nn_1 = mkN "anslutning" ;
  ansoekning_nn_1 = mkN "ansцkning" ;
  ansoekningshandling_nn_1 = mkN "ansцkningshandling" ;
  ansoekningstid_nn_1 = mkN "ansцkningstid" "ansцkningstider" ;
  anspaend_av_1 = mkA "anspдnd" ;
  anspann_nn_1 = mkN "anspann" neutrum ;
  anspelning_nn_1 = mkN "anspelning" ;
  anspraak_nn_1 = mkN "ansprеk" neutrum ;
  anspraaksfull_av_1 = mkA "ansprеksfull" ;
  anspraaksloes_av_1 = mkA "ansprеkslцs" ;
  anspraaksloeshet_nn_1 = mkN "ansprеkslцshet" "ansprеkslцsheter" ;
  anstaand_nn_1 = mkN "anstеnd" neutrum ;
  anstaellning_nn_1 = mkN "anstдllning" ;
  anstaellningsavtal_nn_1 = mkN "anstдllningsavtal" "anstдllningsavtalet" "anstдllningsavtalen" "anstдllningsavtalena" ;
  anstaellningsskydd_nn_1 = mkN "anstдllningsskydd" neutrum ;
  anstaendig_av_1 = mkA "anstдndig" ;
  anstaendighet_nn_1 = mkN "anstдndighet" "anstдndigheter" ;
  anstaendigtvis_ab_1 = mkAdv "anstдndigtvis" ;
  anstalt_nn_1 = mkN "anstalt" "anstalter" ;
  anstiftare_nn_1 = mkN "anstiftare" "anstiftare" ;
  anstoetlig_av_1 = mkA "anstцtlig" ;
  anstormning_nn_1 = mkN "anstormning" ;
  anstraengande_av_1 = mkA "anstrдngande" ;
  anstraengd_av_1 = mkA "anstrдngd" "anstrдngt" ;
  anstraengning_nn_1 = mkN "anstrдngning" ;
  anstruken_av_1 = mkA "anstruken" "anstruket" ;
  anstryka_vb_1 = mkV "anstryka" "anstrцk" "anstrukit" ;
  anstrykare_nn_1 = mkN "anstrykare" "anstrykare" ;
  anstrykning_nn_1 = mkN "anstrykning" ;
  anstucken_av_1 = mkA "anstucken" "anstucket" ;
  ansvaelld_av_1 = mkA "ansvдlld" "ansvдllt" ;
  ansvaellning_nn_1 = mkN "ansvдllning" ;
  ansvarig_av_1 = mkA "ansvarig" ;
  ansvarighetsfoersaekring_nn_1 = mkN "ansvarighetsfцrsдkring" ;
  ansvaring_nn_1 = mkN "ansvaring" ;
  ansvarsfoersaekring_nn_1 = mkN "ansvarsfцrsдkring" ;
  ansvarsfrihet_nn_1 = mkN "ansvarsfrihet" "ansvarsfriheter" ;
  ansvarsfull_av_1 = mkA "ansvarsfull" ;
  ansvarskaennande_av_1 = mkA "ansvarskдnnande" ;
  ansvarsloes_av_1 = mkA "ansvarslцs" ;
  ansvarsnaemnd_nn_1 = mkN "ansvarsnдmnd" "ansvarsnдmnder" ;
  anta_vb_1 = mkV "anta" "antar" "anta" "antog" "antagit" "antagen" ;
  antaag_nn_1 = mkN "antеg" neutrum ;
  antaendning_nn_1 = mkN "antдndning" ;
  antagande_nn_1 = mkN "antagande" ;
  antaglig_av_1 = mkA "antaglig" ;
  antagligen_ab_1 = mkAdv "antagligen" ;
  antagning_nn_1 = mkN "antagning" ;
  antagonist_nn_1 = mkN "antagonist" "antagonister" ;
  antagonistisk_av_1 = mkA "antagonistisk" ;
  antal_nn_1 = mkN "antal" "antalet" "antalen" "antalena" ;
  antarktisk_av_1 = mkA "antarktisk" ;
  antecedentia_nn_1 = mkN "antecedentia" "antecedentian" "antecedentia" "antecedentiana" ;
  antecipation_nn_1 = mkN "antecipation" "antecipationer" ;
  antecipativ_av_1 = mkA "antecipativ" ;
  anteckning_nn_1 = mkN "anteckning" ;
  anteckningsblock_nn_1 = mkN "anteckningsblock" neutrum ;
  anteckningsbok_nn_1 = mkN "anteckningsbok" "anteckningsbцcker" ;
  antediluviansk_av_1 = mkA "antediluviansk" ;
  antenn_nn_1 = mkN "antenn" "antenner" ;
  antependium_nn_1 = mkN "antependium" "antependiet" "antependier" "antependierna" ;
  antepenultima_nn_1 = mkN "antepenultima" ;
  antibarbarus_nn_1 = mkN "antibarbarus" ;
  antibiotika_nn_1 = mkN "antibiotika" ;
  antibiotikum_nn_1 = mkN "antibiotikum" "antibiotikum" "antibiotika" "antibiotikana" ;
  antibiotisk_av_1 = mkA "antibiotisk" ;
  anticyklon_nn_1 = mkN "anticyklon" "anticykloner" ;
  antidepressiv_av_1 = mkA "antidepressiv" ;
  antidot_nn_1 = mkN "antidot" "antidotet" "antidoter" "antidoterna" ;
  antifoni_nn_1 = mkN "antifoni" "antifonier" ;
  antigen_nn_1 = mkN "antigen" "antigener" ;
  antihistamin_nn_1 = mkN "antihistamin" "antihistaminet" "antihistaminer" "antihistaminerna" ;
  antihjaelte_nn_1 = mkN "antihjдlte" utrum ;
  antiintellektuell_av_1 = mkA "antiintellektuell" ;
  antik_av_1 = mkA "antik" ;
  antiklerikal_av_1 = mkA "antiklerikal" ;
  antiklimax_nn_1 = mkN "antiklimax" ;
  antiklinal_nn_1 = mkN "antiklinal" "antiklinaler" ;
  antikljus_nn_1 = mkN "antikljus" neutrum ;
  antikonceptionell_av_1 = mkA "antikonceptionell" ;
  antikropp_nn_1 = mkN "antikropp" ;
  antikvariat_nn_1 = mkN "antikvariat" neutrum ;
  antikvarie_nn_1 = mkN "antikvarie" "antikvarier" ;
  antikvarisk_av_1 = mkA "antikvarisk" ;
  antikvitet_nn_1 = mkN "antikvitet" "antikviteter" ;
  antilop_nn_1 = mkN "antilop" "antiloper" ;
  antimakass_nn_1 = mkN "antimakass" "antimakasser" ;
  antimilitarist_nn_1 = mkN "antimilitarist" "antimilitarister" ;
  antimilitaristisk_av_1 = mkA "antimilitaristisk" ;
  antingen_ab_1 = mkAdv "antingen" ;
  antinomi_nn_1 = mkN "antinomi" "antinomier" ;
  antipartikel_nn_1 = mkN "antipartikel" ;
  antipassad_nn_1 = mkN "antipassad" "antipassader" ;
  antipati_nn_1 = mkN "antipati" "antipatier" ;
  antipod_nn_1 = mkN "antipod" "antipoder" ;
  antisemit_nn_1 = mkN "antisemit" "antisemiter" ;
  antisemitisk_av_1 = mkA "antisemitisk" ;
  antiseptika_nn_1 = mkN "antiseptika" "antiseptikan" "antiseptika" "antiseptikana" ;
  antiseptisk_av_1 = mkA "antiseptisk" ;
  antisionistisk_av_1 = mkA "antisionistisk" ;
  antistatisk_av_1 = mkA "antistatisk" ;
  antistatmedel_nn_1 = mkN "antistatmedel" neutrum ;
  antites_nn_1 = mkN "antites" "antiteser" ;
  antitetisk_av_1 = mkA "antitetisk" ;
  antitoxin_nn_1 = mkN "antitoxin" "antitoxiner" ;
  antologi_nn_1 = mkN "antologi" "antologier" ;
  antonym_nn_1 = mkN "antonym" "antonymer" ;
  antraeffbar_av_1 = mkA "antrдffbar" ;
  antropisk_av_1 = mkA "antropisk" ;
  antropocentrisk_av_1 = mkA "antropocentrisk" ;
  antropofag_nn_1 = mkN "antropofag" "antropofager" ;
  antropoid_nn_1 = mkN "antropoid" "antropoider" ;
  antropolog_nn_1 = mkN "antropolog" "antropologer" ;
  antropomorf_av_1 = mkA "antropomorf" ;
  antroposof_nn_1 = mkN "antroposof" "antroposofer" ;
  antroposofisk_av_1 = mkA "antroposofisk" ;
  antydning_nn_1 = mkN "antydning" ;
  antydningsvis_ab_1 = mkAdv "antydningsvis" ;
  anvaendande_nn_1 = mkN "anvдndande" ;
  anvaendare_nn_1 = mkN "anvдndare" "anvдndare" ;
  anvaendbar_av_1 = mkA "anvдndbar" ;
  anvaendbarhet_nn_1 = mkN "anvдndbarhet" "anvдndbarheter" ;
  anvaendning_nn_1 = mkN "anvдndning" ;
  anvaendningsomraade_nn_1 = mkN "anvдndningsomrеde" ;
  anvisning_nn_1 = mkN "anvisning" ;
  anvisningslaekare_nn_1 = mkN "anvisningslдkare" "anvisningslдkare" ;
  aorist_nn_1 = mkN "aorist" "aorister" ;
  apache_nn_1 = mkN "apache" "apacher" ;
  apanage_nn_1 = mkN "apanage" "apanaget" "apanage" "apanagen" ;
  apart_av_1 = mkA "apart" "apart" ;
  apart_nn_1 = mkN "apart" "aparter" ;
  apati_nn_1 = mkN "apati" "apatier" ;
  apatisk_av_1 = mkA "apatisk" ;
  apbroedstraed_nn_1 = mkN "apbrцdstrдd" neutrum ;
  apekatt_nn_1 = mkN "apekatt" "apekatter" ;
  apel_nn_1 = mkN "apel" ;
  apelgraa_av_1 = mkA "apelgrе" "apelgrеtt" ;
  apelsin_nn_1 = mkN "apelsin" "apelsiner" ;
  aperitif_nn_1 = mkN "aperitif" "aperitifer" ;
  apertur_nn_1 = mkN "apertur" "aperturer" ;
  apetidin_nn_1 = mkN "apetidin" "apetidiner" ;
  aphelium_nn_1 = mkN "aphelium" "apheliet" "aphelier" "aphelierna" ;
  apmaenniska_nn_1 = mkN "apmдnniska" ;
  apodiktisk_av_1 = mkA "apodiktisk" ;
  apokalyps_nn_1 = mkN "apokalyps" "apokalypser" ;
  apokalyptisk_av_1 = mkA "apokalyptisk" ;
  apokryfisk_av_1 = mkA "apokryfisk" ;
  apollinisk_av_1 = mkA "apollinisk" ;
  apollofjaeril_nn_1 = mkN "apollofjдril" ;
  apologet_nn_1 = mkN "apologet" "apologeter" ;
  apologetisk_av_1 = mkA "apologetisk" ;
  apologi_nn_1 = mkN "apologi" "apologier" ;
  apoplektisk_av_1 = mkA "apoplektisk" ;
  apoplexi_nn_1 = mkN "apoplexi" "apoplexier" ;
  apostel_nn_1 = mkN "apostel" ;
  aposteriorisk_av_1 = mkA "aposteriorisk" ;
  apostolisk_av_1 = mkA "apostolisk" ;
  apostrof_nn_1 = mkN "apostrof" "apostrofer" ;
  apotek_nn_1 = mkN "apotek" neutrum ;
  apotekare_nn_1 = mkN "apotekare" "apotekare" ;
  apoteksvaext_nn_1 = mkN "apoteksvдxt" "apoteksvдxter" ;
  apoteos_nn_1 = mkN "apoteos" "apoteoser" ;
  apparans_nn_1 = mkN "apparans" "apparanser" ;
  apparat_nn_1 = mkN "apparat" "apparater" ;
  apparatur_nn_1 = mkN "apparatur" "apparaturer" ;
  apparition_nn_1 = mkN "apparition" "apparitioner" ;
  appell_nn_1 = mkN "appell" "appeller" ;
  appellant_nn_1 = mkN "appellant" "appellanter" ;
  appellationsdomstol_nn_1 = mkN "appellationsdomstol" ;
  appellativ_nn_1 = mkN "appellativ" neutrum ;
  appendicit_nn_1 = mkN "appendicit" "appendiciter" ;
  appendix_nn_1 = mkN "appendix" neutrum ;
  apperception_nn_1 = mkN "apperception" "apperceptioner" ;
  applaad_nn_1 = mkN "applеd" "applеder" ;
  applikation_nn_1 = mkN "applikation" "applikationer" ;
  applikatorisk_av_1 = mkA "applikatorisk" ;
  applikatur_nn_1 = mkN "applikatur" "applikaturer" ;
  apposition_nn_1 = mkN "apposition" "appositioner" ;
  appreciering_nn_1 = mkN "appreciering" ;
  appretyr_nn_1 = mkN "appretyr" "appretyrer" ;
  approach_nn_1 = mkN "approach" "approacher" ;
  approbabel_av_1 = mkA "approbabel" "approbabelt" "approbabla" "approbabla" "approbablare" "approbablast" "approbablaste" ;
  approbatur_nn_1 = mkN "approbatur" neutrum ;
  approximation_nn_1 = mkN "approximation" "approximationer" ;
  approximationsteori_nn_1 = mkN "approximationsteori" "approximationsteorier" ;
  approximativ_av_1 = mkA "approximativ" ;
  aprikos_nn_1 = mkN "aprikos" "aprikoser" ;
  aprildag_nn_1 = mkN "aprildag" ;
  aprilskaemt_nn_1 = mkN "aprilskдmt" neutrum ;
  apriorisk_av_1 = mkA "apriorisk" ;
  apropaa_ab_1 = mkAdv "apropе" ;
  apropaa_nn_1 = mkN "apropе" "apropеt" "apropеn" "apropеna" ;
  apsort_nn_1 = mkN "apsort" "apsorter" ;
  apspel_nn_1 = mkN "apspel" "apspelet" "apspel" "apspelen" ;
  aptitlig_av_1 = mkA "aptitlig" ;
  aptitloeshet_nn_1 = mkN "aptitlцshet" "aptitlцsheter" ;
  aptitretande_av_1 = mkA "aptitretande" ;
  aptitretare_nn_1 = mkN "aptitretare" "aptitretare" ;
  ar_nn_1 = mkN "ar" neutrum ;
  arab_nn_1 = mkN "arab" "araber" ;
  arabesk_nn_1 = mkN "arabesk" "arabesker" ;
  arabisk_av_1 = mkA "arabisk" ;
  arabiska_nn_2 = mkN "arabiska" ;
  arabist_nn_1 = mkN "arabist" "arabister" ;
  arbetare_nn_1 = mkN "arbetare" "arbetare" ;
  arbetarfoerening_nn_1 = mkN "arbetarfцrening" ;
  arbetargrupp_nn_1 = mkN "arbetargrupp" "arbetargrupper" ;
  arbetarklass_nn_1 = mkN "arbetarklass" "arbetarklasser" ;
  arbetarkommun_nn_1 = mkN "arbetarkommun" "arbetarkommuner" ;
  arbetarparti_nn_1 = mkN "arbetarparti" "arbetarpartit" "arbetarpartier" "arbetarpartierna" ;
  arbetarraad_nn_1 = mkN "arbetarrеd" neutrum ;
  arbetarregering_nn_1 = mkN "arbetarregering" ;
  arbetarroerelse_nn_1 = mkN "arbetarrцrelse" "arbetarrцrelser" ;
  arbetarsaang_nn_1 = mkN "arbetarsеng" "arbetarsеnger" ;
  arbetsaar_nn_1 = mkN "arbetsеr" neutrum ;
  arbetsam_av_1 = mkA "arbetsam" "arbetsamt" "arbetsamma" "arbetsamma" "arbetsammare" "arbetsammast" "arbetsammaste" ;
  arbetsanstalt_nn_1 = mkN "arbetsanstalt" "arbetsanstalter" ;
  arbetsavtal_nn_1 = mkN "arbetsavtal" "arbetsavtalet" "arbetsavtalen" "arbetsavtalena" ;
  arbetsbeskrivning_nn_1 = mkN "arbetsbeskrivning" ;
  arbetsbesparande_av_1 = mkA "arbetsbesparande" ;
  arbetsbi_nn_1 = mkN "arbetsbi" "arbetsbit" "arbetsbin" "arbetsbien" ;
  arbetsboerda_nn_1 = mkN "arbetsbцrda" ;
  arbetsbok_nn_1 = mkN "arbetsbok" "arbetsbцcker" ;
  arbetsbord_nn_1 = mkN "arbetsbord" neutrum ;
  arbetsbyte_nn_1 = mkN "arbetsbyte" ;
  arbetsdag_nn_1 = mkN "arbetsdag" ;
  arbetsdelning_nn_1 = mkN "arbetsdelning" ;
  arbetsdomstol_nn_1 = mkN "arbetsdomstol" ;
  arbetsduglig_av_1 = mkA "arbetsduglig" ;
  arbetsfaelt_nn_1 = mkN "arbetsfдlt" neutrum ;
  arbetsfoer_av_1 = mkA "arbetsfцr" ;
  arbetsfoermedling_nn_1 = mkN "arbetsfцrmedling" ;
  arbetsfoertjaenst_nn_1 = mkN "arbetsfцrtjдnst" "arbetsfцrtjдnster" ;
  arbetsform_nn_1 = mkN "arbetsform" "arbetsformer" ;
  arbetsfri_av_1 = mkA "arbetsfri" "arbetsfritt" ;
  arbetsgivaravgift_nn_1 = mkN "arbetsgivaravgift" "arbetsgivaravgifter" ;
  arbetsgivare_nn_1 = mkN "arbetsgivare" "arbetsgivare" ;
  arbetsgivarfoerening_nn_1 = mkN "arbetsgivarfцrening" ;
  arbetsgivarintraede_nn_1 = mkN "arbetsgivarintrдde" ;
  arbetsgrupp_nn_1 = mkN "arbetsgrupp" "arbetsgrupper" ;
  arbetshypotes_nn_1 = mkN "arbetshypotes" "arbetshypoteser" ;
  arbetsinkomst_nn_1 = mkN "arbetsinkomst" "arbetsinkomster" ;
  arbetsinsats_nn_1 = mkN "arbetsinsats" "arbetsinsatser" ;
  arbetsinstaellelse_nn_1 = mkN "arbetsinstдllelse" "arbetsinstдllelser" ;
  arbetsintensiv_av_1 = mkA "arbetsintensiv" ;
  arbetskamrat_nn_1 = mkN "arbetskamrat" "arbetskamrater" ;
  arbetskoepare_nn_1 = mkN "arbetskцpare" "arbetskцpare" ;
  arbetskonflikt_nn_1 = mkN "arbetskonflikt" "arbetskonflikter" ;
  arbetslaeger_nn_1 = mkN "arbetslдger" neutrum ;
  arbetsledare_nn_1 = mkN "arbetsledare" "arbetsledare" ;
  arbetslivserfarenhet_nn_1 = mkN "arbetslivserfarenhet" "arbetslivserfarenheter" ;
  arbetsloes_av_1 = mkA "arbetslцs" ;
  arbetsloeshet_nn_1 = mkN "arbetslцshet" "arbetslцsheter" ;
  arbetsmaengd_nn_1 = mkN "arbetsmдngd" "arbetsmдngder" ;
  arbetsmaetning_nn_1 = mkN "arbetsmдtning" ;
  arbetsmarknad_nn_1 = mkN "arbetsmarknad" "arbetsmarknader" ;
  arbetsmarknadspolitik_nn_1 = mkN "arbetsmarknadspolitik" "arbetsmarknadspolitiker" ;
  arbetsmarknadspolitisk_av_1 = mkA "arbetsmarknadspolitisk" ;
  arbetsmarknadsutbildning_nn_1 = mkN "arbetsmarknadsutbildning" ;
  arbetsmaskin_nn_1 = mkN "arbetsmaskin" "arbetsmaskiner" ;
  arbetsmaterial_nn_1 = mkN "arbetsmaterial" neutrum ;
  arbetsmiljoe_nn_1 = mkN "arbetsmiljц" "arbetsmiljцn" "arbetsmiljцer" "arbetsmiljцerna" ;
  arbetsmoment_nn_1 = mkN "arbetsmoment" "arbetsmomentet" "arbetsmomenten" "arbetsmomentena" ;
  arbetsmoral_nn_1 = mkN "arbetsmoral" "arbetsmoraler" ;
  arbetsnaemnd_nn_1 = mkN "arbetsnдmnd" "arbetsnдmnder" ;
  arbetsnamn_nn_1 = mkN "arbetsnamn" neutrum ;
  arbetsnarkoman_nn_1 = mkN "arbetsnarkoman" "arbetsnarkomaner" ;
  arbetsnedlaeggelse_nn_1 = mkN "arbetsnedlдggelse" "arbetsnedlдggelser" ;
  arbetsomraade_nn_1 = mkN "arbetsomrеde" ;
  arbetsordning_nn_1 = mkN "arbetsordning" ;
  arbetspass_nn_1 = mkN "arbetspass" neutrum ;
  arbetsplats_nn_1 = mkN "arbetsplats" "arbetsplatser" ;
  arbetsplenum_nn_1 = mkN "arbetsplenum" neutrum ;
  arbetsprov_nn_1 = mkN "arbetsprov" neutrum ;
  arbetsredskap_nn_1 = mkN "arbetsredskap" "arbetsredskapet" "arbetsredskapen" "arbetsredskapena" ;
  arbetsrum_nn_1 = mkN "arbetsrum" "arbetsrummet" "arbetsrum" "arbetsrummen" ;
  arbetssaang_nn_1 = mkN "arbetssеng" "arbetssеnger" ;
  arbetssaett_nn_1 = mkN "arbetssдtt" neutrum ;
  arbetsseger_nn_1 = mkN "arbetsseger" ;
  arbetsskygg_av_1 = mkA "arbetsskygg" ;
  arbetssoekande_nn_1 = mkN "arbetssцkande" "arbetssцkanden" "arbetssцkande" "arbetssцkandena" ;
  arbetsstudieman_nn_1 = mkN "arbetsstudieman" "arbetsstudiemannen" "arbetsstudiemдn" "arbetsstudiemдnnen" ;
  arbetstagare_nn_1 = mkN "arbetstagare" "arbetstagare" ;
  arbetstemperatur_nn_1 = mkN "arbetstemperatur" "arbetstemperaturer" ;
  arbetsterapeut_nn_1 = mkN "arbetsterapeut" "arbetsterapeuter" ;
  arbetstid_nn_1 = mkN "arbetstid" "arbetstider" ;
  arbetstillfaelle_nn_1 = mkN "arbetstillfдlle" ;
  arbetstillstaand_nn_1 = mkN "arbetstillstеnd" neutrum ;
  arbetstvist_nn_1 = mkN "arbetstvist" "arbetstvister" ;
  arbetsuppgift_nn_1 = mkN "arbetsuppgift" "arbetsuppgifter" ;
  arbetsutskott_nn_1 = mkN "arbetsutskott" neutrum ;
  arbetsvaerdering_nn_1 = mkN "arbetsvдrdering" ;
  arbetsvecka_nn_1 = mkN "arbetsvecka" ;
  arbetsvilja_nn_1 = mkN "arbetsvilja" ;
  arbetsvillig_av_1 = mkA "arbetsvillig" ;
  arbitraer_av_1 = mkA "arbitrдr" ;
  arboretum_nn_1 = mkN "arboretum" neutrum ;
  arborr_nn_1 = mkN "arborr" ;
  ardenner_nn_1 = mkN "ardenner" "ardennern" "ardenner" "ardennerna" ;
  areal_nn_1 = mkN "areal" "arealer" ;
  arena_nn_1 = mkN "arena" ;
  arenateater_nn_1 = mkN "arenateater" ;
  areometer_nn_1 = mkN "areometer" ;
  areopag_nn_1 = mkN "areopag" "areopager" ;
  arg_av_1 = mkA "arg" ;
  argentinare_nn_1 = mkN "argentinare" "argentinare" ;
  argentinsk_av_1 = mkA "argentinsk" ;
  argentinska_nn_1 = mkN "argentinska" ;
  argsint_av_1 = mkA "argsint" "argsint" ;
  argument_nn_1 = mkN "argument" neutrum ;
  argumentation_nn_1 = mkN "argumentation" "argumentationer" ;
  argumentering_nn_1 = mkN "argumentering" ;
  argusoega_nn_1 = mkN "argusцga" "argusцgat" "argusцgon" "argusцgonen" ;
  ariadnetraad_nn_1 = mkN "ariadnetrеd" ;
  arian_nn_1 = mkN "arian" "arianer" ;
  ariansk_av_1 = mkA "ariansk" ;
  arier_nn_1 = mkN "arier" "ariern" "arier" "arierna" ;
  arioso_nn_1 = mkN "arioso" "ariosot" "arioson" "ariosona" ;
  arisk_av_1 = mkA "arisk" ;
  aristokrat_nn_1 = mkN "aristokrat" "aristokrater" ;
  aristokrati_nn_1 = mkN "aristokrati" "aristokratier" ;
  aristokratisk_av_1 = mkA "aristokratisk" ;
  aritmetisk_av_1 = mkA "aritmetisk" ;
  ark_nn_1 = mkN "ark" neutrum ;
  arkad_nn_1 = mkN "arkad" "arkader" ;
  arkadisk_av_1 = mkA "arkadisk" ;
  arkadspel_nn_1 = mkN "arkadspel" "arkadspelet" "arkadspel" "arkadspelen" ;
  arkaisk_av_1 = mkA "arkaisk" ;
  arkaism_nn_1 = mkN "arkaism" "arkaismer" ;
  arkaistisk_av_1 = mkA "arkaistisk" ;
  arkebusering_nn_1 = mkN "arkebusering" ;
  arkeolog_nn_1 = mkN "arkeolog" "arkeologer" ;
  arkeologisk_av_1 = mkA "arkeologisk" ;
  arketyp_nn_1 = mkN "arketyp" "arketyper" ;
  arketypisk_av_1 = mkA "arketypisk" ;
  arkiater_nn_1 = mkN "arkiater" "arkiatern" "arkiatrer" "arkiatrerna" ;
  arkipelag_nn_1 = mkN "arkipelag" "arkipelager" ;
  arkitekt_nn_1 = mkN "arkitekt" "arkitekter" ;
  arkitektonisk_av_1 = mkA "arkitektonisk" ;
  arkitektur_nn_1 = mkN "arkitektur" "arkitekturer" ;
  arkitrav_nn_1 = mkN "arkitrav" "arkitraver" ;
  arkiv_nn_1 = mkN "arkiv" neutrum ;
  arkivalisk_av_1 = mkA "arkivalisk" ;
  arkivarbetare_nn_1 = mkN "arkivarbetare" "arkivarbetare" ;
  arkivarie_nn_1 = mkN "arkivarie" "arkivarier" ;
  arkivexemplar_nn_1 = mkN "arkivexemplar" neutrum ;
  arksignatur_nn_1 = mkN "arksignatur" "arksignaturer" ;
  arktisk_av_1 = mkA "arktisk" ;
  arla_ab_1 = mkAdv "arla" ;
  arm_av_1 = mkA "arm" ;
  arm_nn_1 = mkN "arm" ;
  armatur_nn_1 = mkN "armatur" "armaturer" ;
  armbaage_nn_1 = mkN "armbеge" utrum ;
  armbaagsben_nn_1 = mkN "armbеgsben" neutrum ;
  armbaagsled_nn_1 = mkN "armbеgsled" "armbеgsleder" ;
  armband_nn_1 = mkN "armband" neutrum ;
  armbandsur_nn_1 = mkN "armbandsur" neutrum ;
  armbindel_nn_1 = mkN "armbindel" ;
  armboejning_nn_1 = mkN "armbцjning" ;
  armborst_nn_1 = mkN "armborst" neutrum ;
  armborstpil_nn_1 = mkN "armborstpil" ;
  armbrott_nn_1 = mkN "armbrott" neutrum ;
  armbrytning_nn_1 = mkN "armbrytning" ;
  arme_nn_1 = mkN "armй" "armйer" ;
  armechef_nn_1 = mkN "armйchef" "armйchefer" ;
  armefoerband_nn_1 = mkN "armйfцrband" neutrum ;
  armegevaer_nn_1 = mkN "armйgevдr" neutrum ;
  armehaest_nn_1 = mkN "armйhдst" ;
  armekaar_nn_1 = mkN "armйkеr" "armйkеrer" ;
  armenier_nn_1 = mkN "armenier" "armeniern" "armenier" "armenierna" ;
  armenisk_av_1 = mkA "armenisk" ;
  armeniska_nn_2 = mkN "armeniska" ;
  armering_nn_1 = mkN "armering" ;
  armeringsjaern_nn_1 = mkN "armeringsjдrn" neutrum ;
  armfoering_nn_1 = mkN "armfцring" ;
  armfoting_nn_1 = mkN "armfoting" ;
  armhaevning_nn_1 = mkN "armhдvning" ;
  armkrok_nn_1 = mkN "armkrok" ;
  armlaengd_nn_1 = mkN "armlдngd" "armlдngder" ;
  armled_nn_1 = mkN "armled" "armleder" ;
  armmuskel_nn_1 = mkN "armmuskel" "armmuskeln" "armmuskler" "armmusklerna" ;
  armpolyp_nn_1 = mkN "armpolyp" "armpolyper" ;
  armstoed_nn_1 = mkN "armstцd" neutrum ;
  armstyrka_nn_1 = mkN "armstyrka" ;
  armveck_nn_1 = mkN "armveck" neutrum ;
  arom_nn_1 = mkN "arom" "aromer" ;
  aromatisk_av_1 = mkA "aromatisk" ;
  aromglas_nn_1 = mkN "aromglas" neutrum ;
  arpeggio_nn_1 = mkN "arpeggio" "arpeggiot" "arpeggion" "arpeggiona" ;
  arr_nn_1 = mkN "arr" neutrum ;
  arrangemang_nn_1 = mkN "arrangemang" neutrum ;
  arrangoer_nn_1 = mkN "arrangцr" "arrangцrer" ;
  arrendator_nn_1 = mkN "arrendator" "arrendatorer" ;
  arrende_nn_1 = mkN "arrende" ;
  arrest_nn_1 = mkN "arrest" "arrester" ;
  arrestant_nn_1 = mkN "arrestant" "arrestanter" ;
  arrestering_nn_1 = mkN "arrestering" ;
  arriaergarde_nn_1 = mkN "arriдrgarde" ;
  arrivist_nn_1 = mkN "arrivist" "arrivister" ;
  arrogant_av_1 = mkA "arrogant" "arrogant" ;
  arrowrot_nn_1 = mkN "arrowrot" "arrowrцtter" ;
  arsel_nn_1 = mkN "arsel" neutrum ;
  arsenal_nn_1 = mkN "arsenal" "arsenaler" ;
  arsenikhalt_nn_1 = mkN "arsenikhalt" "arsenikhalter" ;
  arsenikhaltig_av_1 = mkA "arsenikhaltig" ;
  arsenikkis_nn_1 = mkN "arsenikkis" "arsenikkiser" ;
  art_nn_1 = mkN "art" "arter" ;
  artaer_nn_1 = mkN "artдr" "artдrer" ;
  artbildning_nn_1 = mkN "artbildning" ;
  artbildningsteori_nn_1 = mkN "artbildningsteori" "artbildningsteorier" ;
  artefakt_nn_1 = mkN "artefakt" "artefakter" ;
  artegen_av_1 = mkA "artegen" "arteget" ;
  arteriell_av_1 = mkA "arteriell" ;
  artesisk_av_1 = mkA "artesisk" ;
  artfraemmande_av_1 = mkA "artfrдmmande" ;
  artificiell_av_1 = mkA "artificiell" ;
  artig_av_1 = mkA "artig" ;
  artighet_nn_1 = mkN "artighet" "artigheter" ;
  artighetsbetygelse_nn_1 = mkN "artighetsbetygelse" "artighetsbetygelser" ;
  artighetsfras_nn_1 = mkN "artighetsfras" "artighetsfraser" ;
  artighetsvisit_nn_1 = mkN "artighetsvisit" "artighetsvisiter" ;
  artikel_nn_1 = mkN "artikel" ;
  artikelfoerfattare_nn_1 = mkN "artikelfцrfattare" "artikelfцrfattare" ;
  artikelserie_nn_1 = mkN "artikelserie" "artikelserier" ;
  artikulation_nn_1 = mkN "artikulation" "artikulationer" ;
  artikulationsbas_nn_1 = mkN "artikulationsbas" "artikulationsbaser" ;
  artikulationsstaelle_nn_1 = mkN "artikulationsstдlle" ;
  artilleribeskjutning_nn_1 = mkN "artilleribeskjutning" ;
  artillerield_nn_1 = mkN "artillerield" ;
  artillerigranat_nn_1 = mkN "artillerigranat" "artillerigranater" ;
  artilleripjaes_nn_1 = mkN "artilleripjдs" "artilleripjдser" ;
  artillerist_nn_1 = mkN "artillerist" "artillerister" ;
  artillerivapen_nn_1 = mkN "artillerivapen" "artillerivapnet" "artillerivapen" "artillerivapnen" ;
  artist_nn_1 = mkN "artist" "artister" ;
  artistframtraedande_nn_1 = mkN "artistframtrдdande" ;
  artistisk_av_1 = mkA "artistisk" ;
  artistnamn_nn_1 = mkN "artistnamn" neutrum ;
  artnamn_nn_1 = mkN "artnamn" neutrum ;
  artotek_nn_1 = mkN "artotek" neutrum ;
  artrik_av_1 = mkA "artrik" ;
  artrit_nn_1 = mkN "artrit" "artriter" ;
  artros_nn_1 = mkN "artros" "artroser" ;
  artskild_av_1 = mkA "artskild" "artskilt" ;
  artskillnad_nn_1 = mkN "artskillnad" "artskillnader" ;
  arv_nn_1 = mkN "arv" neutrum ;
  arvedel_nn_1 = mkN "arvedel" "arvedelen" "arvedelar" "arvedelarna" ;
  arvfiende_nn_1 = mkN "arvfiende" "arvfiender" ;
  arvfoeljd_nn_1 = mkN "arvfцljd" "arvfцljder" ;
  arvfurste_nn_1 = mkN "arvfurste" utrum ;
  arvinge_nn_1 = mkN "arvinge" utrum ;
  arvlaatare_nn_1 = mkN "arvlеtare" "arvlеtare" ;
  arvloes_av_1 = mkA "arvlцs" ;
  arvode_nn_1 = mkN "arvode" ;
  arvord_nn_1 = mkN "arvord" neutrum ;
  arvsanlag_nn_1 = mkN "arvsanlag" neutrum ;
  arvsfaktor_nn_1 = mkN "arvsfaktor" "arvsfaktorer" ;
  arvsfoeljd_nn_1 = mkN "arvsfцljd" "arvsfцljder" ;
  arvsfond_nn_1 = mkN "arvsfond" "arvsfonder" ;
  arvskatt_nn_1 = mkN "arvskatt" "arvskatter" ;
  arvskifte_nn_1 = mkN "arvskifte" ;
  arvslott_nn_1 = mkN "arvslott" "arvslotter" ;
  arvsmolekyl_nn_1 = mkN "arvsmolekyl" "arvsmolekyler" ;
  arvsraett_nn_1 = mkN "arvsrдtt" "arvsrдtter" ;
  arvsskatt_nn_1 = mkN "arvsskatt" "arvsskatter" ;
  arvsynd_nn_1 = mkN "arvsynd" "arvsynder" ;
  arvtagare_nn_1 = mkN "arvtagare" "arvtagare" ;
  arvtant_nn_1 = mkN "arvtant" "arvtanter" ;
  arytmi_nn_1 = mkN "arytmi" "arytmier" ;
  as_nn_1 = mkN "as" neutrum ;
  as_nn_2 = mkN "as" ;
  asaetare_nn_1 = mkN "asдtare" "asдtare" ;
  asbagge_nn_1 = mkN "asbagge" utrum ;
  aseptisk_av_1 = mkA "aseptisk" ;
  asexuell_av_1 = mkA "asexuell" ;
  asfalt_nn_1 = mkN "asfalt" "asfalter" ;
  asfaltemulsion_nn_1 = mkN "asfaltemulsion" "asfaltemulsioner" ;
  asfaltlack_nn_1 = mkN "asfaltlack" "asfaltlacker" ;
  asfaltmoped_nn_1 = mkN "asfaltmoped" "asfaltmopeder" ;
  asgam_nn_1 = mkN "asgam" ;
  asiat_nn_1 = mkN "asiat" "asiater" ;
  asiatisk_av_1 = mkA "asiatisk" ;
  asimut_nn_1 = mkN "asimut" "asimuter" ;
  ask_nn_1 = mkN "ask" ;
  askblond_av_1 = mkA "askblond" ;
  askenas_nn_1 = mkN "askenas" "askenaser" ;
  asket_nn_1 = mkN "asket" "asketer" ;
  asketisk_av_1 = mkA "asketisk" ;
  askfat_nn_1 = mkN "askfat" neutrum ;
  askgraa_av_1 = mkA "askgrе" "askgrеtt" ;
  askkopp_nn_1 = mkN "askkopp" ;
  askonsdag_nn_1 = mkN "askonsdag" ;
  askunge_nn_1 = mkN "askunge" utrum ;
  asocial_av_1 = mkA "asocial" ;
  asocialitet_nn_1 = mkN "asocialitet" "asocialiteter" ;
  asp_nn_1 = mkN "asp" ;
  aspdunge_nn_1 = mkN "aspdunge" utrum ;
  aspekt_nn_1 = mkN "aspekt" "aspekter" ;
  aspirant_nn_1 = mkN "aspirant" "aspiranter" ;
  aspiration_nn_1 = mkN "aspiration" "aspirationer" ;
  aspirin_nn_1 = mkN "aspirin" "aspiriner" ;
  asploev_nn_1 = mkN "asplцv" neutrum ;
  ass_nn_1 = mkN "ass" neutrum ;
  assegaj_nn_1 = mkN "assegaj" "assegajer" ;
  assessor_nn_1 = mkN "assessor" "assessorer" ;
  assiett_nn_1 = mkN "assiett" "assietter" ;
  assignant_nn_1 = mkN "assignant" "assignanter" ;
  assignation_nn_1 = mkN "assignation" "assignationer" ;
  assimilation_nn_1 = mkN "assimilation" "assimilationer" ;
  assist_nn_1 = mkN "assist" "assister" ;
  assistans_nn_1 = mkN "assistans" "assistanser" ;
  assistent_nn_1 = mkN "assistent" "assistenter" ;
  association_nn_1 = mkN "association" "associationer" ;
  associationskedja_nn_1 = mkN "associationskedja" ;
  associationslexikon_nn_1 = mkN "associationslexikon" neutrum ;
  associativ_av_1 = mkA "associativ" ;
  assonans_nn_1 = mkN "assonans" "assonanser" ;
  assuradoer_nn_1 = mkN "assuradцr" "assuradцrer" ;
  assurans_nn_1 = mkN "assurans" "assuranser" ;
  assyrier_nn_1 = mkN "assyrier" "assyriern" "assyrier" "assyrierna" ;
  assyrisk_av_1 = mkA "assyrisk" ;
  asteni_nn_1 = mkN "asteni" "astenier" ;
  asteniker_nn_1 = mkN "asteniker" "astenikern" "asteniker" "astenikerna" ;
  astenisk_av_1 = mkA "astenisk" ;
  aster_nn_1 = mkN "aster" ;
  asterisk_nn_1 = mkN "asterisk" "asterisker" ;
  asteroid_nn_1 = mkN "asteroid" "asteroider" ;
  astigmatiker_nn_1 = mkN "astigmatiker" "astigmatikern" "astigmatiker" "astigmatikerna" ;
  astigmatisk_av_1 = mkA "astigmatisk" ;
  astmatiker_nn_1 = mkN "astmatiker" "astmatikern" "astmatiker" "astmatikerna" ;
  astmatisk_av_1 = mkA "astmatisk" ;
  astrakan_nn_1 = mkN "astrakan" "astrakaner" ;
  astrakan_nn_2 = mkN "astrakan" "astrakaner" ;
  astral_av_1 = mkA "astral" ;
  astralkropp_nn_1 = mkN "astralkropp" ;
  astrofysiker_nn_1 = mkN "astrofysiker" "astrofysikern" "astrofysiker" "astrofysikerna" ;
  astrolog_nn_1 = mkN "astrolog" "astrologer" ;
  astronaut_nn_1 = mkN "astronaut" "astronauter" ;
  astronautik_nn_1 = mkN "astronautik" "astronautiker" ;
  astronom_nn_1 = mkN "astronom" "astronomer" ;
  astronomisk_av_1 = mkA "astronomisk" ;
  asyl_nn_1 = mkN "asyl" "asyler" ;
  asymmetri_nn_1 = mkN "asymmetri" "asymmetrier" ;
  asymmetrisk_av_1 = mkA "asymmetrisk" ;
  asymptot_nn_1 = mkN "asymptot" "asymptoter" ;
  asyndes_nn_1 = mkN "asyndes" "asyndeser" ;
  asyndetisk_av_1 = mkA "asyndetisk" ;
  asyndeton_nn_1 = mkN "asyndeton" "asyndeton" "asyndeton" "asyndetonen" ;
  asynja_nn_1 = mkN "asynja" ;
  asynkron_av_1 = mkA "asynkron" ;
  ataktisk_av_1 = mkA "ataktisk" ;
  ataraktika_nn_1 = mkN "ataraktika" "ataraktikan" "ataraktika" "ataraktikana" ;
  atavism_nn_1 = mkN "atavism" "atavismer" ;
  atavistisk_av_1 = mkA "atavistisk" ;
  ataxi_nn_1 = mkN "ataxi" "ataxier" ;
  ateist_nn_1 = mkN "ateist" "ateister" ;
  ateistisk_av_1 = mkA "ateistisk" ;
  atelje_nn_1 = mkN "ateljй" "ateljйer" ;
  ateljefoenster_nn_1 = mkN "ateljйfцnster" neutrum ;
  atenienn_nn_1 = mkN "atenienn" "atenienner" ;
  atlantisk_av_1 = mkA "atlantisk" ;
  atlas_nn_1 = mkN "atlas" "atlaser" ;
  atlasbindning_nn_1 = mkN "atlasbindning" ;
  atlasspinnare_nn_1 = mkN "atlasspinnare" "atlasspinnare" ;
  atlet_nn_1 = mkN "atlet" "atleter" ;
  atletisk_av_1 = mkA "atletisk" ;
  atmosfaer_nn_1 = mkN "atmosfдr" "atmosfдrer" ;
  atmosfaerforskare_nn_1 = mkN "atmosfдrforskare" "atmosfдrforskare" ;
  atmosfaerisk_av_1 = mkA "atmosfдrisk" ;
  atmosfaerkemist_nn_1 = mkN "atmosfдrkemist" "atmosfдrkemister" ;
  atmosfaerstryck_nn_1 = mkN "atmosfдrstryck" neutrum ;
  atoll_nn_1 = mkN "atoll" "atoller" ;
  atom_nn_1 = mkN "atom" "atomer" ;
  atomaer_av_1 = mkA "atomдr" ;
  atombomb_nn_1 = mkN "atombomb" "atombomber" ;
  atomdriven_av_1 = mkA "atomdriven" "atomdrivet" ;
  atomenergiorganisation_nn_1 = mkN "atomenergiorganisation" "atomenergiorganisationer" ;
  atomgrupp_nn_1 = mkN "atomgrupp" "atomgrupper" ;
  atomistisk_av_1 = mkA "atomistisk" ;
  atomjon_nn_1 = mkN "atomjon" "atomjoner" ;
  atommodell_nn_1 = mkN "atommodell" "atommodeller" ;
  atomnummer_nn_1 = mkN "atomnummer" neutrum ;
  atomreaktor_nn_1 = mkN "atomreaktor" "atomreaktorer" ;
  atomspektrum_nn_1 = mkN "atomspektrum" neutrum ;
  atomubaat_nn_1 = mkN "atomubеt" ;
  atomur_nn_1 = mkN "atomur" neutrum ;
  atomvapen_nn_1 = mkN "atomvapen" "atomvapnet" "atomvapen" "atomvapnen" ;
  atomvikt_nn_1 = mkN "atomvikt" "atomvikter" ;
  atomvinter_nn_1 = mkN "atomvinter" ;
  atonal_av_1 = mkA "atonal" ;
  atoni_nn_1 = mkN "atoni" "atonier" ;
  atrium_nn_1 = mkN "atrium" "atriet" "atrier" "atrierna" ;
  atrofi_nn_1 = mkN "atrofi" "atrofier" ;
  atrofisk_av_1 = mkA "atrofisk" ;
  att_sats_nn_1 = mkN "att-sats" "att-satser" ;
  attache_nn_1 = mkN "attachй" "attachйer" ;
  attack_nn_1 = mkN "attack" "attacker" ;
  attackdykare_nn_1 = mkN "attackdykare" "attackdykare" ;
  attackplan_nn_1 = mkN "attackplan" neutrum ;
  attentat_nn_1 = mkN "attentat" neutrum ;
  attentator_nn_1 = mkN "attentator" "attentatorer" ;
  attentatsman_nn_1 = mkN "attentatsman" "attentatsmannen" "attentatsmдn" "attentatsmдnnen" ;
  attest_nn_1 = mkN "attest" "attester" ;
  attiralj_nn_1 = mkN "attiralj" "attiraljer" ;
  attisk_av_1 = mkA "attisk" ;
  attityd_nn_1 = mkN "attityd" "attityder" ;
  attitydundersoekning_nn_1 = mkN "attitydundersцkning" ;
  attraktion_nn_1 = mkN "attraktion" "attraktioner" ;
  attraktiv_av_1 = mkA "attraktiv" ;
  attrapp_nn_1 = mkN "attrapp" "attrapper" ;
  attribut_nn_1 = mkN "attribut" neutrum ;
  attribution_nn_1 = mkN "attribution" "attributioner" ;
  attributiv_av_1 = mkA "attributiv" ;
  atypi_nn_1 = mkN "atypi" "atypier" ;
  atypisk_av_1 = mkA "atypisk" ;
  aubergine_nn_1 = mkN "aubergine" "auberginer" ;
  audiens_nn_1 = mkN "audiens" "audienser" ;
  audiogram_nn_1 = mkN "audiogram" "audiogrammet" "audiogram" "audiogrammen" ;
  audiometer_nn_1 = mkN "audiometer" ;
  audiovisuell_av_1 = mkA "audiovisuell" ;
  auditiv_av_1 = mkA "auditiv" ;
  auditoer_nn_1 = mkN "auditцr" "auditцrer" ;
  auditorium_nn_1 = mkN "auditorium" "auditoriet" "auditorier" "auditorierna" ;
  audivisuell_av_1 = mkA "audivisuell" ;
  augiasstall_nn_1 = mkN "augiasstall" neutrum ;
  augment_nn_1 = mkN "augment" neutrum ;
  augur_nn_1 = mkN "augur" "augurer" ;
  augustipaeron_nn_1 = mkN "augustipдron" neutrum ;
  auktion_nn_1 = mkN "auktion" "auktioner" ;
  auktionist_nn_1 = mkN "auktionist" "auktionister" ;
  auktionsfoerraettare_nn_1 = mkN "auktionsfцrrдttare" "auktionsfцrrдttare" ;
  auktionskammare_nn_1 = mkN "auktionskammare" "auktionskammaren" "auktionskamrar" "auktionskamrarna" ;
  auktionsutropare_nn_1 = mkN "auktionsutropare" "auktionsutropare" ;
  auktionsverk_nn_1 = mkN "auktionsverk" neutrum ;
  auktor_nn_1 = mkN "auktor" "auktorer" ;
  auktorisation_nn_1 = mkN "auktorisation" "auktorisationer" ;
  auktoritaer_av_1 = mkA "auktoritдr" ;
  auktoritativ_av_1 = mkA "auktoritativ" ;
  auktoritet_nn_1 = mkN "auktoritet" "auktoriteter" ;
  auktoritetsbunden_av_1 = mkA "auktoritetsbunden" "auktoritetsbundet" ;
  auskultant_nn_1 = mkN "auskultant" "auskultanter" ;
  auskultation_nn_1 = mkN "auskultation" "auskultationer" ;
  australiensare_nn_1 = mkN "australiensare" "australiensare" ;
  australier_nn_1 = mkN "australier" "australiern" "australier" "australierna" ;
  australisk_av_1 = mkA "australisk" ;
  autarki_nn_1 = mkN "autarki" "autarkier" ;
  autencitet_nn_1 = mkN "autencitet" "autenciteter" ;
  autenticitet_nn_1 = mkN "autenticitet" "autenticiteter" ;
  autentisk_av_1 = mkA "autentisk" ;
  auteur_nn_1 = mkN "auteur" "auteurer" ;
  autistisk_av_1 = mkA "autistisk" ;
  autodafe_nn_1 = mkN "autodafй" "autodafйer" ;
  autodidakt_nn_1 = mkN "autodidakt" "autodidakter" ;
  autodrom_nn_1 = mkN "autodrom" "autodromer" ;
  autograf_nn_1 = mkN "autograf" "autografer" ;
  autoklav_nn_1 = mkN "autoklav" "autoklaver" ;
  autokrat_nn_1 = mkN "autokrat" "autokrater" ;
  autokton_av_1 = mkA "autokton" ;
  automat_nn_1 = mkN "automat" "automater" ;
  automatgevaer_nn_1 = mkN "automatgevдr" neutrum ;
  automatisk_av_1 = mkA "automatisk" ;
  automatkarbin_nn_1 = mkN "automatkarbin" "automatkarbiner" ;
  automatvapen_nn_1 = mkN "automatvapen" "automatvapnet" "automatvapen" "automatvapnen" ;
  automobil_nn_1 = mkN "automobil" "automobiler" ;
  autonom_av_1 = mkA "autonom" ;
  autopilot_nn_1 = mkN "autopilot" "autopiloter" ;
  autopsi_nn_1 = mkN "autopsi" "autopsier" ;
  autotypi_nn_1 = mkN "autotypi" "autotypier" ;
  av_ab_1 = mkAdv "av" ;
  avaeta_vb_1 = mkV "avдta" "avеt" "avдtit" ;
  avancemang_nn_1 = mkN "avancemang" neutrum ;
  avannons_nn_1 = mkN "avannons" "avannonser" ;
  avans_nn_1 = mkN "avans" "avanser" ;
  avantgardist_nn_1 = mkN "avantgardist" "avantgardister" ;
  avantgardistisk_av_1 = mkA "avantgardistisk" ;
  avantloge_nn_1 = mkN "avantloge" "avantloger" ;
  avantscen_nn_1 = mkN "avantscen" "avantscener" ;
  avart_nn_1 = mkN "avart" "avarter" ;
  avbaerning_nn_1 = mkN "avbдrning" ;
  avbalkning_nn_1 = mkN "avbalkning" ;
  avbasning_nn_1 = mkN "avbasning" ;
  avbetalning_nn_1 = mkN "avbetalning" ;
  avbetingning_nn_1 = mkN "avbetingning" ;
  avbild_nn_1 = mkN "avbild" "avbilder" ;
  avbildning_nn_1 = mkN "avbildning" ;
  avbildningsfel_nn_1 = mkN "avbildningsfel" "avbildningsfelet" "avbildningsfel" "avbildningsfelen" ;
  avbitare_nn_1 = mkN "avbitare" "avbitare" ;
  avbitartaang_nn_1 = mkN "avbitartеng" "avbitartдnger" ;
  avblaasning_nn_1 = mkN "avblеsning" ;
  avboejning_nn_1 = mkN "avbцjning" ;
  avboen_nn_1 = mkN "avbцn" "avbцner" ;
  avbraeck_nn_1 = mkN "avbrдck" neutrum ;
  avbraenning_nn_1 = mkN "avbrдnning" ;
  avbroestning_nn_1 = mkN "avbrцstning" ;
  avbrott_nn_1 = mkN "avbrott" neutrum ;
  avbryta_vb_1 = mkV "avbryta" "avbrцt" "avbrutit" ;
  avbrytare_nn_1 = mkN "avbrytare" "avbrytare" ;
  avbytare_nn_1 = mkN "avbytare" "avbytare" ;
  avdagata_vb_1 = mkV "avdagata" "avdagatar" "avdagata" "avdagatog" "avdagatagit" "avdagatagen" ;
  avdelning_nn_1 = mkN "avdelning" ;
  avdelningschef_nn_1 = mkN "avdelningschef" "avdelningschefer" ;
  avdelningsdirektoer_nn_1 = mkN "avdelningsdirektцr" "avdelningsdirektцrer" ;
  avdelningsskoeterska_nn_1 = mkN "avdelningsskцterska" ;
  avdoed_av_1 = mkA "avdцd" ;
  avdrag_nn_1 = mkN "avdrag" neutrum ;
  avdragsgill_av_1 = mkA "avdragsgill" ;
  avdragsmoejlighet_nn_1 = mkN "avdragsmцjlighet" "avdragsmцjligheter" ;
  avdriva_vb_1 = mkV "avdriva" "avdrev" "avdrivit" ;
  avdunstning_nn_1 = mkN "avdunstning" ;
  ave_nn_1 = mkN "ave" ;
  avec_nn_1 = mkN "avec" "avecer" ;
  avelsdjur_nn_1 = mkN "avelsdjur" neutrum ;
  avelshingst_nn_1 = mkN "avelshingst" ;
  avenbok_nn_1 = mkN "avenbok" ;
  aveny_nn_1 = mkN "aveny" "avenyer" ;
  avers_nn_1 = mkN "avers" "averser" ;
  aversion_nn_1 = mkN "aversion" "aversioner" ;
  avfaellig_av_1 = mkA "avfдllig" ;
  avfaelling_nn_1 = mkN "avfдlling" ;
  avfaerd_nn_1 = mkN "avfдrd" "avfдrder" ;
  avfall_nn_1 = mkN "avfall" "avfallet" "avfallen" "avfallena" ;
  avfalla_vb_1 = mkV "avfalla" "avfцll" "avfallit" ;
  avfallen_av_1 = mkA "avfallen" "avfallet" ;
  avfallskvarn_nn_1 = mkN "avfallskvarn" ;
  avfallsupplag_nn_1 = mkN "avfallsupplag" neutrum ;
  avfart_nn_1 = mkN "avfart" "avfarter" ;
  avfattning_nn_1 = mkN "avfattning" ;
  avfloede_nn_1 = mkN "avflцde" ;
  avflyttningsfoerbud_nn_1 = mkN "avflyttningsfцrbud" neutrum ;
  avfoering_nn_1 = mkN "avfцring" ;
  avfoeringsmedel_nn_1 = mkN "avfцringsmedel" neutrum ;
  avfrostning_nn_1 = mkN "avfrostning" ;
  avgaa_vb_1 = mkV "avgе" "avgеr" "avgе" "avgick" "avgеtt" "avgеngen" ;
  avgaang_nn_1 = mkN "avgеng" ;
  avgaangsbetyg_nn_1 = mkN "avgеngsbetyg" neutrum ;
  avgaangsbidrag_nn_1 = mkN "avgеngsbidrag" neutrum ;
  avgaangsklass_nn_1 = mkN "avgеngsklass" "avgеngsklasser" ;
  avgaeld_nn_1 = mkN "avgдld" "avgдlder" ;
  avgasroer_nn_1 = mkN "avgasrцr" neutrum ;
  avge_vb_1 = mkV "avge" "avger" "avge" "avgav" "avgett" "avgiven" ;
  avgift_nn_1 = mkN "avgift" "avgifter" ;
  avgjord_av_1 = mkA "avgjord" "avgjort" ;
  avgjutning_nn_1 = mkN "avgjutning" ;
  avgoerande_av_1 = mkA "avgцrande" ;
  avgoerande_nn_1 = mkN "avgцrande" ;
  avgrund_nn_1 = mkN "avgrund" "avgrunder" ;
  avgrundsande_nn_1 = mkN "avgrundsande" utrum ;
  avgrundsdjup_av_1 = mkA "avgrundsdjup" ;
  avgud_nn_1 = mkN "avgud" ;
  avgudabild_nn_1 = mkN "avgudabild" "avgudabilder" ;
  avhaall_nn_1 = mkN "avhеll" neutrum ;
  avhaalla_vb_1 = mkV "avhеlla" "avhцll" "avhеllit" ;
  avhaallen_av_1 = mkA "avhеllen" "avhеllet" ;
  avhaallsam_av_1 = mkA "avhеllsam" "avhеllsamt" "avhеllsamma" "avhеllsamma" "avhеllsammare" "avhеllsammast" "avhеllsammaste" ;
  avhaengd_av_1 = mkA "avhдngd" "avhдngt" ;
  avhaengig_av_1 = mkA "avhдngig" ;
  avhandling_nn_1 = mkN "avhandling" ;
  avhopp_nn_1 = mkN "avhopp" neutrum ;
  avhoppare_nn_1 = mkN "avhoppare" "avhoppare" ;
  avhyvling_nn_1 = mkN "avhyvling" ;
  avi_nn_1 = mkN "avi" "avier" ;
  aviarium_nn_1 = mkN "aviarium" "aviariet" "aviarier" "aviarierna" ;
  aviatisk_av_1 = mkA "aviatisk" ;
  aviatoer_nn_1 = mkN "aviatцr" "aviatцrer" ;
  avig_av_1 = mkA "avig" ;
  avigsida_nn_1 = mkN "avigsida" ;
  avisering_nn_1 = mkN "avisering" ;
  aviseringsperiod_nn_1 = mkN "aviseringsperiod" "aviseringsperioder" ;
  avisofartyg_nn_1 = mkN "avisofartyg" neutrum ;
  avista_ab_1 = mkAdv "avista" ;
  avitaminos_nn_1 = mkN "avitaminos" "avitaminoser" ;
  avkaennare_nn_1 = mkN "avkдnnare" "avkдnnare" ;
  avklaedning_nn_1 = mkN "avklдdning" ;
  avklappning_nn_1 = mkN "avklappning" ;
  avkoerningsramp_nn_1 = mkN "avkцrningsramp" "avkцrningsramper" ;
  avkok_nn_1 = mkN "avkok" neutrum ;
  avkomling_nn_1 = mkN "avkomling" ;
  avkoppling_nn_1 = mkN "avkoppling" ;
  avkortning_nn_1 = mkN "avkortning" ;
  avkrok_nn_1 = mkN "avkrok" ;
  avkylning_nn_1 = mkN "avkylning" ;
  avlaang_av_1 = mkA "avlеng" ;
  avlaata_vb_1 = mkV "avlеta" "avlдt" "avlеtit" ;
  avlaeggare_nn_1 = mkN "avlдggare" "avlдggare" ;
  avlaegsen_av_1 = mkA "avlдgsen" "avlдgset" ;
  avlaemning_nn_1 = mkN "avlдmning" ;
  avlaesare_nn_1 = mkN "avlдsare" "avlдsare" ;
  avlaesbar_av_1 = mkA "avlдsbar" ;
  avlaesning_nn_1 = mkN "avlдsning" ;
  avlagd_av_1 = mkA "avlagd" "avlagt" ;
  avlagring_nn_1 = mkN "avlagring" ;
  avlastare_nn_1 = mkN "avlastare" "avlastare" ;
  avlastning_nn_1 = mkN "avlastning" ;
  avlastningsplats_nn_1 = mkN "avlastningsplats" "avlastningsplatser" ;
  avlatsbrev_nn_1 = mkN "avlatsbrev" neutrum ;
  avledning_nn_1 = mkN "avledning" ;
  avledningsaendelse_nn_1 = mkN "avledningsдndelse" "avledningsдndelser" ;
  avlida_vb_1 = mkV "avlida" "avled" "avlidit" ;
  avliden_av_1 = mkA "avliden" "avlidet" ;
  avlinge_nn_1 = mkN "avlinge" ;
  avljud_nn_1 = mkN "avljud" neutrum ;
  avloening_nn_1 = mkN "avlцning" ;
  avloepning_nn_1 = mkN "avlцpning" ;
  avloesning_nn_1 = mkN "avlцsning" ;
  avlopp_nn_1 = mkN "avlopp" neutrum ;
  avloppsdike_nn_1 = mkN "avloppsdike" ;
  avloppsledning_nn_1 = mkN "avloppsledning" ;
  avloppsvatten_nn_1 = mkN "avloppsvatten" "avloppsvattnet" "avloppsvatten" "avloppsvattnen" ;
  avlyssning_nn_1 = mkN "avlyssning" ;
  avlyssningsapparatur_nn_1 = mkN "avlyssningsapparatur" "avlyssningsapparaturer" ;
  avmaetning_nn_1 = mkN "avmдtning" ;
  avmaett_av_1 = mkA "avmдtt" ;
  avmagring_nn_1 = mkN "avmagring" ;
  avmarsch_nn_1 = mkN "avmarsch" "avmarscher" ;
  avmattning_nn_1 = mkN "avmattning" ;
  avnaemare_nn_1 = mkN "avnдmare" "avnдmare" ;
  avnjuta_vb_1 = mkV "avnjuta" "avnjцt" "avnjutit" ;
  avog_av_1 = mkA "avog" ;
  avokado_nn_1 = mkN "avokado" "avokador" ;
  avraadande_nn_1 = mkN "avrеdande" ;
  avraekning_nn_1 = mkN "avrдkning" ;
  avraettning_nn_1 = mkN "avrдttning" ;
  avredning_nn_1 = mkN "avredning" ;
  avringning_nn_1 = mkN "avringning" ;
  avrinna_vb_1 = mkV "avrinna" "avrann" "avrunnit" ;
  avrinning_nn_1 = mkN "avrinning" ;
  avrivning_nn_1 = mkN "avrivning" ;
  avrop_nn_1 = mkN "avrop" neutrum ;
  avsaegelse_nn_1 = mkN "avsдgelse" "avsдgelser" ;
  avsaendare_nn_1 = mkN "avsдndare" "avsдndare" ;
  avsaettlig_av_1 = mkA "avsдttlig" ;
  avsaettning_nn_1 = mkN "avsдttning" ;
  avsaettningsbassaeng_nn_1 = mkN "avsдttningsbassдng" "avsдttningsbassдnger" ;
  avsaknad_nn_1 = mkN "avsaknad" "avsaknader" ;
  avsats_nn_1 = mkN "avsats" "avsatser" ;
  avseende_nn_1 = mkN "avseende" ;
  avsegling_nn_1 = mkN "avsegling" ;
  avsevaerd_av_1 = mkA "avsevдrd" "avsevдrt" ;
  avsides_ab_1 = mkAdv "avsides" ;
  avsides_av_1 = mkA "avsides" ;
  avsigkommen_av_1 = mkA "avsigkommen" "avsigkommet" "avsigkomna" "avsigkomna" "avsigkomnare" "avsigkomnast" "avsigkomnaste" ;
  avsikt_nn_1 = mkN "avsikt" "avsikter" ;
  avsiktlig_av_1 = mkA "avsiktlig" ;
  avsittning_nn_1 = mkN "avsittning" ;
  avsjunga_vb_1 = mkV "avsjunga" "avsjцng" "avsjungit" ;
  avskaera_vb_1 = mkV "avskдra" "avskar" "avskurit" ;
  avskaerning_nn_1 = mkN "avskдrning" ;
  avskaffande_nn_1 = mkN "avskaffande" ;
  avsked_nn_1 = mkN "avsked" neutrum ;
  avskedsdikt_nn_1 = mkN "avskedsdikt" "avskedsdikter" ;
  avskild_av_1 = mkA "avskild" "avskilt" ;
  avskildhet_nn_1 = mkN "avskildhet" "avskildheter" ;
  avskjuta_vb_1 = mkV "avskjuta" "avskцt" "avskjutit" ;
  avskjutning_nn_1 = mkN "avskjutning" ;
  avskraeckning_nn_1 = mkN "avskrдckning" ;
  avskraede_nn_1 = mkN "avskrдde" ;
  avskraedeshoeg_nn_1 = mkN "avskrдdeshцg" ;
  avskrift_nn_1 = mkN "avskrift" "avskrifter" ;
  avskriva_vb_1 = mkV "avskriva" "avskrev" "avskrivit" ;
  avskrivning_nn_1 = mkN "avskrivning" ;
  avskrot_nn_1 = mkN "avskrot" ;
  avskyvaerd_av_1 = mkA "avskyvдrd" "avskyvдrt" ;
  avslag_nn_1 = mkN "avslag" neutrum ;
  avslagen_av_1 = mkA "avslagen" "avslaget" ;
  avslappning_nn_1 = mkN "avslappning" ;
  avslappningsoevning_nn_1 = mkN "avslappningsцvning" ;
  avslita_vb_1 = mkV "avslita" "avslet" "avslitit" ;
  avsloejande_nn_1 = mkN "avslцjande" ;
  avslut_nn_1 = mkN "avslut" neutrum ;
  avslutning_nn_1 = mkN "avslutning" ;
  avslutningsfest_nn_1 = mkN "avslutningsfest" "avslutningsfester" ;
  avslutningsvis_ab_1 = mkAdv "avslutningsvis" ;
  avsmaeltning_nn_1 = mkN "avsmдltning" ;
  avsnitt_nn_1 = mkN "avsnitt" neutrum ;
  avsnoerning_nn_1 = mkN "avsnцrning" ;
  avsnoerningsteori_nn_1 = mkN "avsnцrningsteori" "avsnцrningsteorier" ;
  avsoekare_nn_1 = mkN "avsцkare" "avsцkare" ;
  avsoendring_nn_1 = mkN "avsцndring" ;
  avspaend_av_1 = mkA "avspдnd" ;
  avspaenning_nn_1 = mkN "avspдnning" ;
  avspaerrning_nn_1 = mkN "avspдrrning" ;
  avspark_nn_1 = mkN "avspark" ;
  avspegling_nn_1 = mkN "avspegling" ;
  avspelning_nn_1 = mkN "avspelning" ;
  avspraang_nn_1 = mkN "avsprеng" neutrum ;
  avstaand_nn_1 = mkN "avstеnd" neutrum ;
  avstaandsinformation_nn_1 = mkN "avstеndsinformation" "avstеndsinformationer" ;
  avstaandskraft_nn_1 = mkN "avstеndskraft" "avstеndskrafter" ;
  avstaandsmaetning_nn_1 = mkN "avstеndsmдtning" ;
  avstaandstagande_nn_1 = mkN "avstеndstagande" ;
  avstaellning_nn_1 = mkN "avstдllning" ;
  avstaempling_nn_1 = mkN "avstдmpling" ;
  avstaengning_nn_1 = mkN "avstдngning" ;
  avstamp_nn_1 = mkN "avstamp" neutrum ;
  avstavning_nn_1 = mkN "avstavning" ;
  avsteg_nn_1 = mkN "avsteg" neutrum ;
  avstickare_nn_1 = mkN "avstickare" "avstickare" ;
  avstickning_nn_1 = mkN "avstickning" ;
  avstigning_nn_1 = mkN "avstigning" ;
  avstjaelpningsplats_nn_1 = mkN "avstjдlpningsplats" "avstjдlpningsplatser" ;
  avsutten_av_1 = mkA "avsutten" "avsuttet" ;
  avsvaerja_vb_1 = mkV "avsvдrja" "avsvдrj" "avsvдrj" "avsvorj" "avsvurjit" "avsvurjen" ;
  avsvalkning_nn_1 = mkN "avsvalkning" ;
  avsynare_nn_1 = mkN "avsynare" "avsynare" ;
  avta_vb_1 = mkV "avta" "avtar" "avta" "avtog" "avtagit" "avtagen" ;
  avtaag_nn_1 = mkN "avtеg" neutrum ;
  avtaerd_av_1 = mkA "avtдrd" "avtдrt" ;
  avtagande_av_1 = mkA "avtagande" ;
  avtagbar_av_1 = mkA "avtagbar" ;
  avtagsvaeg_nn_1 = mkN "avtagsvдg" ;
  avtal_nn_1 = mkN "avtal" "avtalet" "avtalen" "avtalena" ;
  avtalsenlig_av_1 = mkA "avtalsenlig" ;
  avtalsfrihet_nn_1 = mkN "avtalsfrihet" "avtalsfriheter" ;
  avtalsperiod_nn_1 = mkN "avtalsperiod" "avtalsperioder" ;
  avtalsroerelse_nn_1 = mkN "avtalsrцrelse" "avtalsrцrelser" ;
  avtalsstridig_av_1 = mkA "avtalsstridig" ;
  avtappning_nn_1 = mkN "avtappning" ;
  avtoning_nn_1 = mkN "avtoning" ;
  avtraede_nn_1 = mkN "avtrдde" ;
  avtraedelse_nn_1 = mkN "avtrдdelse" "avtrдdelser" ;
  avtryck_nn_1 = mkN "avtryck" neutrum ;
  avtryckare_nn_1 = mkN "avtryckare" "avtryckare" ;
  avtvagning_nn_1 = mkN "avtvagning" ;
  avtvinga_vb_1 = mkV "avtvinga" ;
  avundsam_av_1 = mkA "avundsam" "avundsamt" "avundsamma" "avundsamma" "avundsammare" "avundsammast" "avundsammaste" ;
  avundsjuk_av_1 = mkA "avundsjuk" ;
  avundsman_nn_1 = mkN "avundsman" "avundsmannen" "avundsmдn" "avundsmдnnen" ;
  avundsvaerd_av_1 = mkA "avundsvдrd" "avundsvдrt" ;
  avvaeg_nn_1 = mkN "avvдg" ;
  avvaegning_nn_1 = mkN "avvдgning" ;
  avvaegningsinstrument_nn_1 = mkN "avvдgningsinstrument" neutrum ;
  avvaenjning_nn_1 = mkN "avvдnjning" ;
  avvaenjningstid_nn_1 = mkN "avvдnjningstid" "avvдnjningstider" ;
  avvaepnande_av_1 = mkA "avvдpnande" ;
  avveckling_nn_1 = mkN "avveckling" ;
  avverkning_nn_1 = mkN "avverkning" ;
  avvika_vb_1 = mkV "avvika" "avvek" "avvikit" ;
  avvikande_av_1 = mkA "avvikande" ;
  avvikare_nn_1 = mkN "avvikare" "avvikare" ;
  avvikelse_nn_1 = mkN "avvikelse" "avvikelser" ;
  avvinna_vb_1 = mkV "avvinna" "avvann" "avvunnit" ;
  avvisare_nn_1 = mkN "avvisare" "avvisare" ;
  avvisning_nn_1 = mkN "avvisning" ;
  avytterlig_av_1 = mkA "avytterlig" ;
  ax_nn_1 = mkN "ax" neutrum ;
  axblommig_av_1 = mkA "axblommig" ;
  axel_nn_1 = mkN "axel" ;
  axelband_nn_1 = mkN "axelband" neutrum ;
  axelbred_av_1 = mkA "axelbred" ;
  axelgehaeng_nn_1 = mkN "axelgehдng" neutrum ;
  axelhoelster_nn_1 = mkN "axelhцlster" neutrum ;
  axelklaff_nn_1 = mkN "axelklaff" ;
  axelkoppling_nn_1 = mkN "axelkoppling" ;
  axellager_nn_1 = mkN "axellager" neutrum ;
  axelmuff_nn_1 = mkN "axelmuff" ;
  axelrem_nn_1 = mkN "axelrem" "axelremmen" "axelremmar" "axelremmarna" ;
  axelriktning_nn_1 = mkN "axelriktning" ;
  axelryckning_nn_1 = mkN "axelryckning" ;
  axial_av_1 = mkA "axial" ;
  axiom_nn_1 = mkN "axiom" neutrum ;
  axiomatisk_av_1 = mkA "axiomatisk" ;
  axion_nn_1 = mkN "axion" "axioner" ;
  axionfoertaetning_nn_1 = mkN "axionfцrtдtning" ;
  axplock_nn_1 = mkN "axplock" neutrum ;
  aztek_nn_1 = mkN "aztek" "azteker" ;
  aztekisk_av_1 = mkA "aztekisk" ;
  azurblaa_av_1 = mkA "azurblе" "azurblеtt" ;
  baade_ab_1 = mkAdv "bеde" ;
  baade_nn_1 = mkN "bеde" utrum ;
  baagbro_nn_1 = mkN "bеgbro" ;
  baage_nn_1 = mkN "bеge" utrum ;
  baagfaelt_nn_1 = mkN "bеgfдlt" neutrum ;
  baagfil_nn_1 = mkN "bеgfil" ;
  baagfoenster_nn_1 = mkN "bеgfцnster" neutrum ;
  baagformig_av_1 = mkA "bеgformig" ;
  baagfris_nn_1 = mkN "bеgfris" "bеgfriser" ;
  baaggaang_nn_1 = mkN "bеggеng" ;
  baagig_av_1 = mkA "bеgig" ;
  baagminut_nn_1 = mkN "bеgminut" "bеgminuter" ;
  baagsaag_nn_1 = mkN "bеgsеg" ;
  baagsekund_nn_1 = mkN "bеgsekund" "bеgsekunder" ;
  baagskytt_nn_1 = mkN "bеgskytt" ;
  baak_nn_1 = mkN "bеk" ;
  baal_nn_1 = mkN "bеl" ;
  baal_nn_2 = mkN "bеl" neutrum ;
  baald_av_1 = mkA "bеld" "bеlt" ;
  baalgeting_nn_1 = mkN "bеlgeting" ;
  baalrullning_nn_1 = mkN "bеlrullning" ;
  baalvaext_nn_1 = mkN "bеlvдxt" "bеlvдxter" ;
  baalverk_nn_1 = mkN "bеlverk" neutrum ;
  baangstyrig_av_1 = mkA "bеngstyrig" ;
  baar_nn_1 = mkN "bеr" ;
  baarbaerare_nn_1 = mkN "bеrbдrare" "bеrbдrare" ;
  baard_nn_1 = mkN "bеrd" "bеrder" ;
  baarhus_nn_1 = mkN "bеrhus" neutrum ;
  baas_nn_1 = mkN "bеs" neutrum ;
  baat_nn_1 = mkN "bеt" ;
  baatben_nn_1 = mkN "bеtben" neutrum ;
  baatbyggare_nn_1 = mkN "bеtbyggare" "bеtbyggare" ;
  baatbyggeri_nn_1 = mkN "bеtbyggeri" "bеtbyggerit" "bеtbyggerier" "bеtbyggerierna" ;
  baatformig_av_1 = mkA "bеtformig" ;
  baatgrav_nn_1 = mkN "bеtgrav" ;
  baathus_nn_1 = mkN "bеthus" neutrum ;
  baatliknande_av_1 = mkA "bеtliknande" ;
  baatmotor_nn_1 = mkN "bеtmotor" "bеtmotorer" ;
  baatnad_nn_1 = mkN "bеtnad" "bеtnader" ;
  baatplats_nn_1 = mkN "bеtplats" "bеtplatser" ;
  baatshake_nn_1 = mkN "bеtshake" utrum ;
  baatskjul_nn_1 = mkN "bеtskjul" neutrum ;
  baatskraa_nn_1 = mkN "bеtskrе" "bеtskrеt" "bеtskrеn" "bеtskrеen" ;
  baatsman_nn_1 = mkN "bеtsman" "bеtsmannen" "bеtsmдn" "bеtsmдnnen" ;
  baatsmansstol_nn_1 = mkN "bеtsmansstol" ;
  baattaevling_nn_1 = mkN "bеttдvling" ;
  babblan_ab_1 = mkAdv "babblan" ;
  babian_nn_1 = mkN "babian" "babianer" ;
  babordsvakt_nn_1 = mkN "babordsvakt" "babordsvakter" ;
  baby_nn_1 = mkN "baby" "babyn" "babyar" "babyarna" ;
  babydraekt_nn_1 = mkN "babydrдkt" "babydrдkter" ;
  babylonier_nn_1 = mkN "babylonier" "babyloniern" "babylonier" "babylonierna" ;
  babylonisk_av_1 = mkA "babylonisk" ;
  babysitter_nn_1 = mkN "babysitter" ;
  bacill_nn_1 = mkN "bacill" "baciller" ;
  bacillbaerare_nn_1 = mkN "bacillbдrare" "bacillbдrare" ;
  back_nn_1 = mkN "back" ;
  backanal_nn_1 = mkN "backanal" "backanaler" ;
  backant_nn_1 = mkN "backant" "backanter" ;
  backe_nn_1 = mkN "backe" utrum ;
  backfisch_nn_1 = mkN "backfisch" ;
  backhammer_nn_1 = mkN "backhammer" "backhammern" "backhammrar" "backhammrarna" ;
  backhoppare_nn_1 = mkN "backhoppare" "backhoppare" ;
  backhoppning_nn_1 = mkN "backhoppning" ;
  backig_av_1 = mkA "backig" ;
  backkroen_nn_1 = mkN "backkrцn" neutrum ;
  backlandskap_nn_1 = mkN "backlandskap" "backlandskapet" "backlandskapen" "backlandskapena" ;
  backslag_nn_1 = mkN "backslag" neutrum ;
  backspegel_nn_1 = mkN "backspegel" ;
  backstag_nn_1 = mkN "backstag" neutrum ;
  backstroem_nn_1 = mkN "backstrцm" "backstrцmmen" "backstrцmmar" "backstrцmmarna" ;
  backstuga_nn_1 = mkN "backstuga" ;
  backstugusittare_nn_1 = mkN "backstugusittare" "backstugusittare" ;
  backvial_nn_1 = mkN "backvial" "backvialer" ;
  bad_nn_1 = mkN "bad" neutrum ;
  badanlaeggning_nn_1 = mkN "badanlдggning" ;
  badbassaeng_nn_1 = mkN "badbassдng" "badbassдnger" ;
  badborste_nn_1 = mkN "badborste" utrum ;
  baddare_nn_1 = mkN "baddare" "baddare" ;
  baddjaevel_nn_1 = mkN "baddjдvel" ;
  baddraekt_nn_1 = mkN "baddrдkt" "baddrдkter" ;
  badensare_nn_1 = mkN "badensare" "badensare" ;
  badensisk_av_1 = mkA "badensisk" ;
  badgaest_nn_1 = mkN "badgдst" "badgдster" ;
  badhandduk_nn_1 = mkN "badhandduk" ;
  badhus_nn_1 = mkN "badhus" neutrum ;
  badhytt_nn_1 = mkN "badhytt" "badhytter" ;
  badkar_nn_1 = mkN "badkar" neutrum ;
  badkarseffekt_nn_1 = mkN "badkarseffekt" "badkarseffekter" ;
  badkarskant_nn_1 = mkN "badkarskant" "badkarskanter" ;
  badlakan_nn_1 = mkN "badlakan" neutrum ;
  badmintonboll_nn_1 = mkN "badmintonboll" ;
  badort_nn_1 = mkN "badort" "badorter" ;
  badrum_nn_1 = mkN "badrum" "badrummet" "badrum" "badrummen" ;
  badsalt_nn_1 = mkN "badsalt" "badsaltet" "badsalter" "badsalterna" ;
  badstaelle_nn_1 = mkN "badstдlle" ;
  badstrand_nn_1 = mkN "badstrand" "badstrдnder" ;
  badturist_nn_1 = mkN "badturist" "badturister" ;
  badvatten_nn_1 = mkN "badvatten" "badvattnet" "badvatten" "badvattnen" ;
  baebis_nn_1 = mkN "bдbis" ;
  baeck_nn_1 = mkN "bдck" ;
  baeckahaest_nn_1 = mkN "bдckahдst" ;
  baecken_nn_1 = mkN "bдcken" neutrum ;
  baeckenben_nn_1 = mkN "bдckenben" neutrum ;
  baeckenfoertraengning_nn_1 = mkN "bдckenfцrtrдngning" ;
  baeckforell_nn_1 = mkN "bдckforell" "bдckforeller" ;
  baeckoering_nn_1 = mkN "bдckцring" ;
  baeckravin_nn_1 = mkN "bдckravin" "bдckraviner" ;
  baeckroeding_nn_1 = mkN "bдckrцding" ;
  baedd_nn_1 = mkN "bдdd" ;
  baeddutrustning_nn_1 = mkN "bдddutrustning" ;
  baegare_nn_1 = mkN "bдgare" "bдgare" ;
  baegarkorall_nn_1 = mkN "bдgarkorall" "bдgarkoraller" ;
  baegarmanet_nn_1 = mkN "bдgarmanet" "bдgarmaneter" ;
  baegarsvamp_nn_1 = mkN "bдgarsvamp" ;
  baelg_nn_1 = mkN "bдlg" ;
  baelgkamera_nn_1 = mkN "bдlgkamera" ;
  baelgliknande_av_1 = mkA "bдlgliknande" ;
  baelgvante_nn_1 = mkN "bдlgvante" utrum ;
  baeltdjur_nn_1 = mkN "bдltdjur" neutrum ;
  baeltespaennare_nn_1 = mkN "bдltespдnnare" "bдltespдnnare" ;
  baendelband_nn_1 = mkN "bдndelband" neutrum ;
  baendjaern_nn_1 = mkN "bдndjдrn" neutrum ;
  baendsel_nn_1 = mkN "bдndsel" ;
  baengel_nn_1 = mkN "bдngel" ;
  baenk_nn_1 = mkN "bдnk" ;
  baenkgranne_nn_1 = mkN "bдnkgranne" utrum ;
  baenkkamrat_nn_1 = mkN "bдnkkamrat" "bдnkkamrater" ;
  baenknummer_nn_1 = mkN "bдnknummer" neutrum ;
  baenkrad_nn_1 = mkN "bдnkrad" "bдnkrader" ;
  baenkspis_nn_1 = mkN "bдnkspis" ;
  baensel_nn_1 = mkN "bдnsel" ;
  baer_nn_1 = mkN "bдr" neutrum ;
  baera_vb_1 = mkV "bдra" "bar" "burit" ;
  baerande_av_1 = mkA "bдrande" ;
  baerare_nn_1 = mkN "bдrare" "bдrare" ;
  baerbar_av_1 = mkA "bдrbar" ;
  baerbjaelke_nn_1 = mkN "bдrbjдlke" utrum ;
  baerbuske_nn_1 = mkN "bдrbuske" utrum ;
  baerfis_nn_1 = mkN "bдrfis" ;
  baerfrekvens_nn_1 = mkN "bдrfrekvens" "bдrfrekvenser" ;
  baergning_nn_1 = mkN "bдrgning" ;
  baergningsbil_nn_1 = mkN "bдrgningsbil" ;
  baerig_av_1 = mkA "bдrig" ;
  baering_nn_1 = mkN "bдring" ;
  baerkasse_nn_1 = mkN "bдrkasse" utrum ;
  baerkotte_nn_1 = mkN "bдrkotte" utrum ;
  baerkraftig_av_1 = mkA "bдrkraftig" ;
  baerlager_nn_1 = mkN "bдrlager" neutrum ;
  baerm_nn_1 = mkN "bдrm" "bдrmer" ;
  baermark_nn_1 = mkN "bдrmark" "bдrmarker" ;
  baerpaase_nn_1 = mkN "bдrpеse" utrum ;
  baerplan_nn_1 = mkN "bдrplan" neutrum ;
  baerplansbaat_nn_1 = mkN "bдrplansbеt" ;
  baerplockare_nn_1 = mkN "bдrplockare" "bдrplockare" ;
  baers_nn_1 = mkN "bдrs" "bдrsen" "bдrs" "bдrsen" ;
  baersaerk_nn_1 = mkN "bдrsдrk" ;
  baerstol_nn_1 = mkN "bдrstol" ;
  baervidd_nn_1 = mkN "bдrvidd" "bдrvidder" ;
  baesteman_nn_1 = mkN "bдsteman" "bдstemannen" "bдstemдn" "bдstemдnnen" ;
  baestis_nn_1 = mkN "bдstis" ;
  baestsaeljare_nn_1 = mkN "bдstsдljare" "bдstsдljare" ;
  baettring_nn_1 = mkN "bдttring" ;
  baever_nn_1 = mkN "bдver" ;
  baevning_nn_1 = mkN "bдvning" ;
  bag_nn_1 = mkN "bag" ;
  bagageinlaemning_nn_1 = mkN "bagageinlдmning" ;
  bagageutrymme_nn_1 = mkN "bagageutrymme" ;
  bagarbarn_nn_1 = mkN "bagarbarn" neutrum ;
  bagarbod_nn_1 = mkN "bagarbod" ;
  bagare_nn_1 = mkN "bagare" "bagare" ;
  bagatell_nn_1 = mkN "bagatell" "bagateller" ;
  bagatellmaal_nn_1 = mkN "bagatellmеl" neutrum ;
  bagel_nn_1 = mkN "bagel" "bageln" "bagels" "bagelsen" ;
  bageri_nn_1 = mkN "bageri" "bagerit" "bagerier" "bagerierna" ;
  bagerimargarin_nn_1 = mkN "bagerimargarin" "bagerimargarinet" "bagerimargariner" "bagerimargarinerna" ;
  bagg_nn_1 = mkN "bagg" ;
  bagge_nn_1 = mkN "bagge" utrum ;
  bagis_nn_1 = mkN "bagis" ;
  baguette_nn_1 = mkN "baguette" "baguetter" ;
  bahaman_nn_1 = mkN "bahaman" "bahamaner" ;
  bahamansk_av_1 = mkA "bahamansk" ;
  bahrainare_nn_1 = mkN "bahrainare" "bahrainare" ;
  bahrainsk_av_1 = mkA "bahrainsk" ;
  bahytt_nn_1 = mkN "bahytt" "bahytter" ;
  baisse_nn_1 = mkN "baisse" "baisser" ;
  bajadaer_nn_1 = mkN "bajadдr" "bajadдrer" ;
  bajersk_av_1 = mkA "bajersk" ;
  bajonett_nn_1 = mkN "bajonett" "bajonetter" ;
  bajonettbalja_nn_1 = mkN "bajonettbalja" ;
  bajonettfattning_nn_1 = mkN "bajonettfattning" ;
  bajrare_nn_1 = mkN "bajrare" "bajrare" ;
  bajsnoedig_av_1 = mkA "bajsnцdig" ;
  bak_ab_1 = mkAdv "bak" ;
  bak_nn_1 = mkN "bak" ;
  bak_nn_2 = mkN "bak" neutrum ;
  bakaat_ab_1 = mkAdv "bakеt" ;
  bakaatraeknande_av_1 = mkA "bakеtrдknande" ;
  bakaatstraevande_av_1 = mkA "bakеtstrдvande" ;
  bakaatstraevare_nn_1 = mkN "bakеtstrдvare" "bakеtstrдvare" ;
  bakarv_nn_1 = mkN "bakarv" neutrum ;
  bakarvinge_nn_1 = mkN "bakarvinge" utrum ;
  bakaxel_nn_1 = mkN "bakaxel" ;
  bakaxelvaexel_nn_1 = mkN "bakaxelvдxel" ;
  bakben_nn_1 = mkN "bakben" neutrum ;
  bakbinda_vb_1 = mkV "bakbinda" "bakband" "bakbundit" ;
  bakblaasare_nn_1 = mkN "bakblеsare" "bakblеsare" ;
  bakdaeck_nn_1 = mkN "bakdдck" neutrum ;
  bakdel_nn_1 = mkN "bakdel" "bakdelen" "bakdelar" "bakdelarna" ;
  bakdoerr_nn_1 = mkN "bakdцrr" ;
  bakefter_ab_1 = mkAdv "bakefter" ;
  bakelse_nn_1 = mkN "bakelse" "bakelser" ;
  bakfot_nn_1 = mkN "bakfot" "bakfцtter" ;
  bakfram_ab_1 = mkAdv "bakfram" ;
  bakfull_av_1 = mkA "bakfull" ;
  bakgaard_nn_1 = mkN "bakgеrd" ;
  bakgrund_nn_1 = mkN "bakgrund" "bakgrunder" ;
  bakgrundsfigur_nn_1 = mkN "bakgrundsfigur" "bakgrundsfigurer" ;
  bakgrundsstraalning_nn_1 = mkN "bakgrundsstrеlning" ;
  bakgrundsvariabel_nn_1 = mkN "bakgrundsvariabel" "bakgrundsvariabeln" "bakgrundsvariabler" "bakgrundsvariablerna" ;
  bakhaall_nn_1 = mkN "bakhеll" neutrum ;
  bakhal_av_1 = mkA "bakhal" ;
  bakhas_nn_1 = mkN "bakhas" ;
  bakhjul_nn_1 = mkN "bakhjul" neutrum ;
  bakhuvud_nn_1 = mkN "bakhuvud" "bakhuvudet" "bakhuvuden" "bakhuvudena" ;
  baki_ab_1 = mkAdv "baki" ;
  bakifraan_ab_1 = mkAdv "bakifrеn" ;
  bakjour_nn_1 = mkN "bakjour" "bakjourer" ;
  bakkropp_nn_1 = mkN "bakkropp" ;
  bakladdare_nn_1 = mkN "bakladdare" "bakladdare" ;
  bakladdning_nn_1 = mkN "bakladdning" ;
  baklaenges_ab_1 = mkAdv "baklдnges" ;
  baklaengesordbok_nn_1 = mkN "baklдngesordbok" "baklдngesordbцcker" ;
  bakoever_ab_1 = mkAdv "bakцver" ;
  bakom_ab_1 = mkAdv "bakom" ;
  bakpaa_ab_1 = mkAdv "bakpе" ;
  bakplaat_nn_1 = mkN "bakplеt" ;
  bakplaatspapper_nn_1 = mkN "bakplеtspapper" neutrum ;
  bakprojektion_nn_1 = mkN "bakprojektion" "bakprojektioner" ;
  bakpulver_nn_1 = mkN "bakpulver" neutrum ;
  bakrus_nn_1 = mkN "bakrus" neutrum ;
  baksaete_nn_1 = mkN "baksдte" ;
  baksida_nn_1 = mkN "baksida" ;
  bakslag_nn_1 = mkN "bakslag" neutrum ;
  bakslagsventil_nn_1 = mkN "bakslagsventil" "bakslagsventiler" ;
  bakslug_av_1 = mkA "bakslug" ;
  bakspaar_nn_1 = mkN "bakspеr" neutrum ;
  bakstraevare_nn_1 = mkN "bakstrдvare" "bakstrдvare" ;
  bakstroem_nn_1 = mkN "bakstrцm" "bakstrцmmen" "bakstrцmmar" "bakstrцmmarna" ;
  baktanke_nn_1 = mkN "baktanke" utrum ;
  baktericid_nn_1 = mkN "baktericid" "baktericider" ;
  bakterie_nn_1 = mkN "bakterie" "bakterier" ;
  bakterieart_nn_1 = mkN "bakterieart" "bakteriearter" ;
  bakteriedoedande_av_1 = mkA "bakteriedцdande" ;
  bakteriehaerd_nn_1 = mkN "bakteriehдrd" ;
  bakteriekultur_nn_1 = mkN "bakteriekultur" "bakteriekulturer" ;
  bakteriofag_nn_1 = mkN "bakteriofag" "bakteriofager" ;
  bakteriolog_nn_1 = mkN "bakteriolog" "bakteriologer" ;
  bakteriologisk_av_1 = mkA "bakteriologisk" ;
  baktill_ab_1 = mkAdv "baktill" ;
  baktung_av_1 = mkA "baktung" ;
  bakugn_nn_1 = mkN "bakugn" ;
  bakut_ab_1 = mkAdv "bakut" ;
  bakvaeg_nn_1 = mkN "bakvдg" ;
  bakvaend_av_1 = mkA "bakvдnd" ;
  bakvatten_nn_1 = mkN "bakvatten" "bakvattnet" "bakvatten" "bakvattnen" ;
  bakverk_nn_1 = mkN "bakverk" neutrum ;
  bakvid_ab_1 = mkAdv "bakvid" ;
  bakvikt_nn_1 = mkN "bakvikt" "bakvikter" ;
  bal_nn_1 = mkN "bal" ;
  bal_nn_2 = mkN "bal" "baler" ;
  balans_nn_1 = mkN "balans" "balanser" ;
  balansakt_nn_1 = mkN "balansakt" "balansakter" ;
  balansering_nn_1 = mkN "balansering" ;
  balanserstaang_nn_1 = mkN "balanserstеng" "balanserstдnger" ;
  balanshjul_nn_1 = mkN "balanshjul" neutrum ;
  balanskonstnaer_nn_1 = mkN "balanskonstnдr" "balanskonstnдrer" ;
  balanskonto_nn_1 = mkN "balanskonto" "balanskontot" "balanskonton" "balanskontona" ;
  balansplog_nn_1 = mkN "balansplog" ;
  balansraekning_nn_1 = mkN "balansrдkning" ;
  balansroder_nn_1 = mkN "balansroder" neutrum ;
  balansrubbning_nn_1 = mkN "balansrubbning" ;
  balansvaag_nn_1 = mkN "balansvеg" ;
  baldakin_nn_1 = mkN "baldakin" "baldakiner" ;
  baldersbraa_nn_1 = mkN "baldersbrе" "baldersbrеn" "baldersbrеr" "baldersbrеrna" ;
  bale_nn_1 = mkN "bale" utrum ;
  balett_nn_1 = mkN "balett" "baletter" ;
  balettdans_nn_1 = mkN "balettdans" "balettdanser" ;
  balettdansoes_nn_1 = mkN "balettdansцs" "balettdansцser" ;
  balettmaestare_nn_1 = mkN "balettmдstare" "balettmдstare" ;
  baljvaext_nn_1 = mkN "baljvдxt" "baljvдxter" ;
  balk_nn_1 = mkN "balk" ;
  balkanfolk_nn_1 = mkN "balkanfolk" neutrum ;
  balkanisering_nn_1 = mkN "balkanisering" ;
  balkknae_nn_1 = mkN "balkknд" "balkknдet" "balkknдn" "balkknдna" ;
  balkong_nn_1 = mkN "balkong" "balkonger" ;
  balkvaegare_nn_1 = mkN "balkvдgare" "balkvдgare" ;
  balkverk_nn_1 = mkN "balkverk" neutrum ;
  ball_av_1 = mkA "ball" ;
  ballad_nn_1 = mkN "ballad" "ballader" ;
  ballast_nn_1 = mkN "ballast" "ballaster" ;
  ballong_nn_1 = mkN "ballong" "ballonger" ;
  ballongboll_nn_1 = mkN "ballongboll" ;
  ballongdaeck_nn_1 = mkN "ballongdдck" neutrum ;
  ballonggas_nn_1 = mkN "ballonggas" "ballonggaser" ;
  ballongprick_nn_1 = mkN "ballongprick" ;
  ballongsegel_nn_1 = mkN "ballongsegel" neutrum ;
  balloptikon_nn_1 = mkN "balloptikon" neutrum ;
  balneolog_nn_1 = mkN "balneolog" "balneologer" ;
  balsam_nn_1 = mkN "balsam" "balsamer" ;
  balsamdoftande_av_1 = mkA "balsamdoftande" ;
  balsamin_nn_1 = mkN "balsamin" "balsaminer" ;
  balsamisk_av_1 = mkA "balsamisk" ;
  balt_nn_1 = mkN "balt" "balter" ;
  baltisk_av_1 = mkA "baltisk" ;
  baluns_nn_1 = mkN "baluns" "balunser" ;
  baluster_nn_1 = mkN "baluster" ;
  balustrad_nn_1 = mkN "balustrad" "balustrader" ;
  bamburoer_nn_1 = mkN "bamburцr" neutrum ;
  ban_nn_1 = mkN "ban" ;
  banal_av_1 = mkA "banal" ;
  banalitet_nn_1 = mkN "banalitet" "banaliteter" ;
  banan_nn_1 = mkN "banan" "bananer" ;
  banankontakt_nn_1 = mkN "banankontakt" "banankontakter" ;
  bananrepublik_nn_1 = mkN "bananrepublik" "bananrepubliker" ;
  bananstock_nn_1 = mkN "bananstock" ;
  banbrytande_av_1 = mkA "banbrytande" ;
  banbrytare_nn_1 = mkN "banbrytare" "banbrytare" ;
  band_nn_1 = mkN "band" neutrum ;
  bandage_nn_1 = mkN "bandage" "bandaget" "bandage" "bandagen" ;
  banderoll_nn_1 = mkN "banderoll" "banderoller" ;
  bandfordon_nn_1 = mkN "bandfordon" neutrum ;
  bandgenerator_nn_1 = mkN "bandgenerator" "bandgeneratorer" ;
  bandhund_nn_1 = mkN "bandhund" ;
  bandit_nn_1 = mkN "bandit" "banditer" ;
  bandolaer_nn_1 = mkN "bandolдr" neutrum ;
  bandotek_nn_1 = mkN "bandotek" neutrum ;
  bandspektrum_nn_1 = mkN "bandspektrum" neutrum ;
  bandspelare_nn_1 = mkN "bandspelare" "bandspelare" ;
  bandstation_nn_1 = mkN "bandstation" "bandstationer" ;
  bandtraktor_nn_1 = mkN "bandtraktor" "bandtraktorer" ;
  bandyroer_nn_1 = mkN "bandyrцr" neutrum ;
  bandyslag_nn_1 = mkN "bandyslag" neutrum ;
  baneman_nn_1 = mkN "baneman" "banemannen" "banemдn" "banemдnnen" ;
  baner_nn_1 = mkN "baner" "baneret" "baner" "baneren" ;
  banerfoerare_nn_1 = mkN "banerfцrare" "banerfцrare" ;
  banesaar_nn_1 = mkN "banesеr" neutrum ;
  bang_av_1 = mkA "bang" ;
  bang_nn_1 = mkN "bang" ;
  bangaard_nn_1 = mkN "bangеrd" ;
  bangladeshare_nn_1 = mkN "bangladeshare" "bangladeshare" ;
  bangladeshisk_av_1 = mkA "bangladeshisk" ;
  banhall_nn_1 = mkN "banhall" ;
  baning_nn_1 = mkN "baning" ;
  banjo_nn_1 = mkN "banjo" "banjor" ;
  bank_nn_1 = mkN "bank" ;
  bank_nn_2 = mkN "bank" "banker" ;
  bankbok_nn_1 = mkN "bankbok" "bankbцcker" ;
  bankett_nn_1 = mkN "bankett" "banketter" ;
  bankfack_nn_1 = mkN "bankfack" neutrum ;
  bankgiro_nn_1 = mkN "bankgiro" "bankgirot" "bankgiron" "bankgirona" ;
  bankinspektion_nn_1 = mkN "bankinspektion" "bankinspektioner" ;
  bankir_nn_1 = mkN "bankir" "bankirer" ;
  bankkamrer_nn_1 = mkN "bankkamrer" "bankkamrerer" ;
  bankkonto_nn_1 = mkN "bankkonto" "bankkontot" "bankkonton" "bankkontona" ;
  banklaan_nn_1 = mkN "banklеn" neutrum ;
  bankofullmaektig_nn_1 = mkN "bankofullmдktig" "bankofullmдktigen" "bankofullmдktige" "bankofullmдktigena" ;
  bankomat_nn_1 = mkN "bankomat" "bankomater" ;
  bankroerelse_nn_1 = mkN "bankrцrelse" "bankrцrelser" ;
  bankrutt_av_1 = mkA "bankrutt" ;
  bankrutt_nn_1 = mkN "bankrutt" "bankrutter" ;
  bankruttoer_nn_1 = mkN "bankruttцr" "bankruttцrer" ;
  banksparande_nn_1 = mkN "banksparande" ;
  bankvaexel_nn_1 = mkN "bankvдxel" ;
  banloepning_nn_1 = mkN "banlцpning" ;
  bann_nn_1 = mkN "bann" neutrum ;
  bannstraale_nn_1 = mkN "bannstrеle" utrum ;
  banrekord_nn_1 = mkN "banrekord" neutrum ;
  banroerelse_nn_1 = mkN "banrцrelse" "banrцrelser" ;
  bantlaer_nn_1 = mkN "bantlдr" neutrum ;
  bantufolk_nn_1 = mkN "bantufolk" neutrum ;
  bantuspraak_nn_1 = mkN "bantusprеk" neutrum ;
  banvagn_nn_1 = mkN "banvagn" ;
  banvall_nn_1 = mkN "banvall" ;
  baptist_nn_1 = mkN "baptist" "baptister" ;
  baptisterium_nn_1 = mkN "baptisterium" "baptisteriet" "baptisterier" "baptisterierna" ;
  bar_av_1 = mkA "bar" ;
  bar_nn_1 = mkN "bar" "barer" ;
  bar_nn_2 = mkN "bar" "baren" "bar" "baren" ;
  bara_ab_1 = mkAdv "bara" ;
  barack_nn_1 = mkN "barack" "baracker" ;
  barbacka_ab_1 = mkAdv "barbacka" ;
  barbadier_nn_1 = mkN "barbadier" "barbadiern" "barbadier" "barbadierna" ;
  barbadisk_av_1 = mkA "barbadisk" ;
  barbar_nn_1 = mkN "barbar" "barbarer" ;
  barbarisk_av_1 = mkA "barbarisk" ;
  barbarism_nn_1 = mkN "barbarism" "barbarismer" ;
  barbent_av_1 = mkA "barbent" "barbent" ;
  barberare_nn_1 = mkN "barberare" "barberare" ;
  barbiturat_nn_1 = mkN "barbiturat" neutrum ;
  bard_nn_1 = mkN "bard" "barder" ;
  bardisan_nn_1 = mkN "bardisan" "bardisaner" ;
  bardisk_nn_1 = mkN "bardisk" ;
  bardun_nn_1 = mkN "bardun" "barduner" ;
  bardval_nn_1 = mkN "bardval" ;
  barett_nn_1 = mkN "barett" "baretter" ;
  barfota_av_1 = mkA "barfota" ;
  barfotalaekare_nn_1 = mkN "barfotalдkare" "barfotalдkare" ;
  barfotalasse_nn_1 = mkN "barfotalasse" utrum ;
  barfotamunk_nn_1 = mkN "barfotamunk" ;
  bariton_nn_1 = mkN "bariton" "baritoner" ;
  bariumfoerening_nn_1 = mkN "bariumfцrening" ;
  bariumsalt_nn_1 = mkN "bariumsalt" "bariumsaltet" "bariumsalter" "bariumsalterna" ;
  bariumsulfat_nn_1 = mkN "bariumsulfat" neutrum ;
  bark_nn_2 = mkN "bark" ;
  barkaroll_nn_1 = mkN "barkaroll" "barkaroller" ;
  barkass_nn_1 = mkN "barkass" "barkasser" ;
  barkbaat_nn_1 = mkN "barkbеt" ;
  barkborre_nn_1 = mkN "barkborre" utrum ;
  barkbroed_nn_1 = mkN "barkbrцd" neutrum ;
  barkis_nn_1 = mkN "barkis" ;
  barkspade_nn_1 = mkN "barkspade" utrum ;
  barktaekt_nn_1 = mkN "barktдkt" "barktдkter" ;
  barlast_nn_1 = mkN "barlast" "barlaster" ;
  barlastkoel_nn_1 = mkN "barlastkцl" ;
  barm_nn_1 = mkN "barm" ;
  barmark_nn_1 = mkN "barmark" "barmarker" ;
  barmhaertig_av_1 = mkA "barmhдrtig" ;
  barmhaertighet_nn_1 = mkN "barmhдrtighet" "barmhдrtigheter" ;
  barmhaertighetsmord_nn_1 = mkN "barmhдrtighetsmord" neutrum ;
  barn_nn_1 = mkN "barn" neutrum ;
  barnadoedlighet_nn_1 = mkN "barnadцdlighet" "barnadцdligheter" ;
  barnafader_nn_1 = mkN "barnafader" "barnafadern" "barnafдder" "barnafдderna" ;
  barnafoederska_nn_1 = mkN "barnafцderska" ;
  barnarov_nn_1 = mkN "barnarov" neutrum ;
  barnasinne_nn_1 = mkN "barnasinne" ;
  barnavaard_nn_1 = mkN "barnavеrd" ;
  barnavaardscentral_nn_1 = mkN "barnavеrdscentral" "barnavеrdscentraler" ;
  barnavaardsman_nn_1 = mkN "barnavеrdsman" "barnavеrdsmannen" "barnavеrdsmдn" "barnavеrdsmдnnen" ;
  barnavaardsnaemnd_nn_1 = mkN "barnavеrdsnдmnd" "barnavеrdsnдmnder" ;
  barnbarn_nn_1 = mkN "barnbarn" neutrum ;
  barnbarnsbarn_nn_1 = mkN "barnbarnsbarn" neutrum ;
  barnbegraensning_nn_1 = mkN "barnbegrдnsning" ;
  barnbespisning_nn_1 = mkN "barnbespisning" ;
  barnbidrag_nn_1 = mkN "barnbidrag" neutrum ;
  barnboerdshus_nn_1 = mkN "barnbцrdshus" neutrum ;
  barnbok_nn_1 = mkN "barnbok" "barnbцcker" ;
  barncykel_nn_1 = mkN "barncykel" ;
  barndaghem_nn_1 = mkN "barndaghem" "barndaghemmet" "barndaghem" "barndaghemmen" ;
  barndom_nn_1 = mkN "barndom" ;
  barndop_nn_1 = mkN "barndop" neutrum ;
  barnfamilj_nn_1 = mkN "barnfamilj" "barnfamiljer" ;
  barnfoedd_av_1 = mkA "barnfцdd" ;
  barnfoerbjuden_av_1 = mkA "barnfцrbjuden" "barnfцrbjudet" ;
  barngrupp_nn_1 = mkN "barngrupp" "barngrupper" ;
  barnhem_nn_1 = mkN "barnhem" "barnhemmet" "barnhem" "barnhemmen" ;
  barnhuvud_nn_1 = mkN "barnhuvud" "barnhuvudet" "barnhuvuden" "barnhuvudena" ;
  barnkaer_av_1 = mkA "barnkдr" ;
  barnkalas_nn_1 = mkN "barnkalas" neutrum ;
  barnkoloni_nn_1 = mkN "barnkoloni" "barnkolonier" ;
  barnledig_av_1 = mkA "barnledig" ;
  barnlek_nn_1 = mkN "barnlek" ;
  barnloes_av_1 = mkA "barnlцs" ;
  barnmorska_nn_1 = mkN "barnmorska" ;
  barnomsorgskostnad_nn_1 = mkN "barnomsorgskostnad" "barnomsorgskostnader" ;
  barnparkering_nn_1 = mkN "barnparkering" ;
  barnpassning_nn_1 = mkN "barnpassning" ;
  barnsaeker_av_1 = mkA "barnsдker" "barnsдkert" "barnsдkra" "barnsдkra" "barnsдkrare" "barnsдkrast" "barnsдkraste" ;
  barnsaeng_nn_1 = mkN "barnsдng" ;
  barnsak_nn_1 = mkN "barnsak" "barnsaker" ;
  barnsboerd_nn_1 = mkN "barnsbцrd" "barnsbцrder" ;
  barnsjukdom_nn_1 = mkN "barnsjukdom" ;
  barnsko_nn_1 = mkN "barnsko" "barnskor" ;
  barnskoeterska_nn_1 = mkN "barnskцterska" ;
  barnslig_av_1 = mkA "barnslig" ;
  barnslighet_nn_1 = mkN "barnslighet" "barnsligheter" ;
  barnstuga_nn_1 = mkN "barnstuga" ;
  barntillaaten_av_1 = mkA "barntillеten" "barntillеtet" ;
  barnunge_nn_1 = mkN "barnunge" utrum ;
  barnvagn_nn_1 = mkN "barnvagn" ;
  barnvakt_nn_1 = mkN "barnvakt" "barnvakter" ;
  barock_av_1 = mkA "barock" ;
  barockstil_nn_1 = mkN "barockstil" ;
  barograf_nn_1 = mkN "barograf" "barografer" ;
  barogram_nn_1 = mkN "barogram" "barogrammet" "barogram" "barogrammen" ;
  barometer_nn_1 = mkN "barometer" ;
  barometerfall_nn_1 = mkN "barometerfall" neutrum ;
  barometerstaand_nn_1 = mkN "barometerstеnd" neutrum ;
  barometrisk_av_1 = mkA "barometrisk" ;
  baron_nn_1 = mkN "baron" "baroner" ;
  barospirator_nn_1 = mkN "barospirator" "barospiratorer" ;
  barr_nn_1 = mkN "barr" neutrum ;
  barr_nn_2 = mkN "barr" "barrer" ;
  barriaer_nn_1 = mkN "barriдr" "barriдrer" ;
  barrikad_nn_1 = mkN "barrikad" "barrikader" ;
  barrikadkaempe_nn_1 = mkN "barrikadkдmpe" utrum ;
  barrikadstrid_nn_1 = mkN "barrikadstrid" "barrikadstrider" ;
  barrskog_nn_1 = mkN "barrskog" ;
  barrskogsgraens_nn_1 = mkN "barrskogsgrдns" "barrskogsgrдnser" ;
  barrskogsregion_nn_1 = mkN "barrskogsregion" "barrskogsregioner" ;
  barrtraed_nn_1 = mkN "barrtrдd" neutrum ;
  barrtraedskotte_nn_1 = mkN "barrtrдdskotte" utrum ;
  barrtraedssort_nn_1 = mkN "barrtrдdssort" "barrtrдdssorter" ;
  barservering_nn_1 = mkN "barservering" ;
  barsk_av_1 = mkA "barsk" ;
  barskaap_nn_1 = mkN "barskеp" neutrum ;
  barstol_nn_1 = mkN "barstol" ;
  bartender_nn_1 = mkN "bartender" ;
  barvinter_nn_1 = mkN "barvinter" ;
  barysfaer_nn_1 = mkN "barysfдr" "barysfдrer" ;
  baryton_nn_1 = mkN "baryton" "barytoner" ;
  bas_nn_1 = mkN "bas" ;
  bas_nn_2 = mkN "bas" "baser" ;
  basaar_nn_1 = mkN "basеr" neutrum ;
  basal_av_1 = mkA "basal" ;
  basar_nn_1 = mkN "basar" "basarer" ;
  basbelopp_nn_1 = mkN "basbelopp" neutrum ;
  basenhet_nn_1 = mkN "basenhet" "basenheter" ;
  basfaerdighet_nn_1 = mkN "basfдrdighet" "basfдrdigheter" ;
  basfiol_nn_1 = mkN "basfiol" "basfioler" ;
  basilisk_nn_1 = mkN "basilisk" "basilisker" ;
  basisk_av_1 = mkA "basisk" ;
  basist_nn_1 = mkN "basist" "basister" ;
  bask_nn_1 = mkN "bask" "basker" ;
  basker_nn_1 = mkN "basker" ;
  basketboll_nn_1 = mkN "basketboll" ;
  baskisk_av_1 = mkA "baskisk" ;
  baskiska_nn_2 = mkN "baskiska" ;
  baslinje_nn_1 = mkN "baslinje" "baslinjer" ;
  basning_nn_1 = mkN "basning" ;
  basorganisation_nn_1 = mkN "basorganisation" "basorganisationer" ;
  basrelief_nn_1 = mkN "basrelief" "basreliefer" ;
  bassaeng_nn_1 = mkN "bassдng" "bassдnger" ;
  basse_nn_1 = mkN "basse" utrum ;
  basset_nn_1 = mkN "basset" ;
  bast_nn_2 = mkN "bast" neutrum ;
  bastant_av_1 = mkA "bastant" "bastant" ;
  bastard_nn_1 = mkN "bastard" "bastarder" ;
  bastardform_nn_1 = mkN "bastardform" "bastardformer" ;
  bastardnaektergal_nn_1 = mkN "bastardnдktergal" ;
  bastcell_nn_1 = mkN "bastcell" "bastceller" ;
  bastfiber_nn_1 = mkN "bastfiber" "bastfibern" "bastfibrer" "bastfibrerna" ;
  bastingering_nn_1 = mkN "bastingering" ;
  bastion_nn_1 = mkN "bastion" "bastioner" ;
  bastonad_nn_1 = mkN "bastonad" "bastonader" ;
  bastu_nn_1 = mkN "bastu" "bastun" "bastur" "basturna" ;
  bastubad_nn_1 = mkN "bastubad" neutrum ;
  basun_nn_1 = mkN "basun" "basuner" ;
  basunstoet_nn_1 = mkN "basunstцt" ;
  basvaeg_nn_1 = mkN "basvдg" ;
  basvinkel_nn_1 = mkN "basvinkel" ;
  batalj_nn_1 = mkN "batalj" "bataljer" ;
  bataljmaalare_nn_1 = mkN "bataljmеlare" "bataljmеlare" ;
  bataljmaalning_nn_1 = mkN "bataljmеlning" ;
  bataljon_nn_1 = mkN "bataljon" "bataljoner" ;
  bataljonschef_nn_1 = mkN "bataljonschef" "bataljonschefer" ;
  batat_nn_1 = mkN "batat" "batater" ;
  batist_nn_1 = mkN "batist" "batister" ;
  batong_nn_1 = mkN "batong" "batonger" ;
  batteri_nn_1 = mkN "batteri" "batterit" "batterier" "batterierna" ;
  batteridriven_av_1 = mkA "batteridriven" "batteridrivet" ;
  batteriprovare_nn_1 = mkN "batteriprovare" "batteriprovare" ;
  batterist_nn_1 = mkN "batterist" "batterister" ;
  batteritaendning_nn_1 = mkN "batteritдndning" ;
  batting_nn_1 = mkN "batting" ;
  batysfaer_nn_1 = mkN "batysfдr" "batysfдrer" ;
  baud_nn_1 = mkN "baud" "bauden" "baud" "bauden" ;
  bautasten_nn_1 = mkN "bautasten" "bautastenen" "bautastenar" "bautastenarna" ;
  be_vb_1 = mkV "be" "bad" "bett" ;
  beagle_nn_1 = mkN "beagle" utrum ;
  beaktansvaerd_av_1 = mkA "beaktansvдrd" "beaktansvдrt" ;
  bearbetning_nn_1 = mkN "bearbetning" ;
  bearnaisesaas_nn_1 = mkN "bearnaisesеs" "bearnaisesеser" ;
  beatnik_nn_1 = mkN "beatnik" ;
  bebaadelse_nn_1 = mkN "bebеdelse" "bebеdelser" ;
  bebis_nn_1 = mkN "bebis" ;
  bebodd_av_1 = mkA "bebodd" "bebodtt" ;
  beboelig_av_1 = mkA "beboelig" ;
  bebyggelse_nn_1 = mkN "bebyggelse" "bebyggelser" ;
  bebyggelsenamn_nn_1 = mkN "bebyggelsenamn" neutrum ;
  beckasin_nn_1 = mkN "beckasin" "beckasiner" ;
  beckig_av_1 = mkA "beckig" ;
  beckmoerk_av_1 = mkA "beckmцrk" ;
  becquerel_nn_1 = mkN "becquerel" "becquerelen" "becquerel" "becquerelen" ;
  bedaarande_av_1 = mkA "bedеrande" ;
  bedja_vb_1 = mkV "bedja" "bedjar" "bedja" "bedjad" "bedjatt" "bedjadd" ;
  bedjande_av_1 = mkA "bedjande" ;
  bedoemande_nn_1 = mkN "bedцmande" ;
  bedoemare_nn_1 = mkN "bedцmare" "bedцmare" ;
  bedoemning_nn_1 = mkN "bedцmning" ;
  bedoevning_nn_1 = mkN "bedцvning" ;
  bedoevningsmedel_nn_1 = mkN "bedцvningsmedel" neutrum ;
  bedra_vb_1 = mkV "bedra" "bedrar" "bedra" "bedrog" "bedragit" "bedragen" ;
  bedraegeri_nn_1 = mkN "bedrдgeri" "bedrдgerit" "bedrдgerier" "bedrдgerierna" ;
  bedraeglig_av_1 = mkA "bedrдglig" ;
  bedragare_nn_1 = mkN "bedragare" "bedragare" ;
  bedrift_nn_1 = mkN "bedrift" "bedrifter" ;
  bedriva_vb_1 = mkV "bedriva" "bedrev" "bedrivit" ;
  bedroevelse_nn_1 = mkN "bedrцvelse" "bedrцvelser" ;
  bedroevlig_av_1 = mkA "bedrцvlig" ;
  beduin_nn_1 = mkN "beduin" "beduiner" ;
  befael_nn_1 = mkN "befдl" neutrum ;
  befaelhavande_av_1 = mkA "befдlhavande" ;
  befaelhavare_nn_1 = mkN "befдlhavare" "befдlhavare" ;
  befaelselev_nn_1 = mkN "befдlselev" "befдlselever" ;
  befaelsfoering_nn_1 = mkN "befдlsfцring" ;
  befaelsgrad_nn_1 = mkN "befдlsgrad" "befдlsgrader" ;
  befaelsstaellning_nn_1 = mkN "befдlsstдllning" ;
  befaelstecken_nn_1 = mkN "befдlstecken" "befдlstecknet" "befдlstecken" "befдlstecknen" ;
  befaengd_av_1 = mkA "befдngd" "befдngt" ;
  befaestning_nn_1 = mkN "befдstning" ;
  befaestningsgrav_nn_1 = mkN "befдstningsgrav" ;
  befaestningslinje_nn_1 = mkN "befдstningslinje" "befдstningslinjer" ;
  befaestningsskydd_nn_1 = mkN "befдstningsskydd" neutrum ;
  befaestningsverk_nn_1 = mkN "befдstningsverk" neutrum ;
  befallande_av_1 = mkA "befallande" ;
  befallning_nn_1 = mkN "befallning" ;
  befallningshavande_nn_1 = mkN "befallningshavande" "befallningshavanden" "befallningshavande" "befallningshavandena" ;
  befallningsman_nn_1 = mkN "befallningsman" "befallningsmannen" "befallningsmдn" "befallningsmдnnen" ;
  befara_vb_2 = mkV "befara" "befor" "befarit" ;
  befaren_av_1 = mkA "befaren" "befaret" ;
  befattning_nn_1 = mkN "befattning" ;
  befattningshavare_nn_1 = mkN "befattningshavare" "befattningshavare" ;
  befinna_vb_1 = mkV "befinna" "befann" "befunnit" ;
  befintlig_av_1 = mkA "befintlig" ;
  befintlighet_nn_1 = mkN "befintlighet" "befintligheter" ;
  befjaedring_nn_1 = mkN "befjдdring" ;
  befogenhet_nn_1 = mkN "befogenhet" "befogenheter" ;
  befolkning_nn_1 = mkN "befolkning" ;
  befolkningsexplosion_nn_1 = mkN "befolkningsexplosion" "befolkningsexplosioner" ;
  befolkningsgrupp_nn_1 = mkN "befolkningsgrupp" "befolkningsgrupper" ;
  befolkningsoekning_nn_1 = mkN "befolkningsцkning" ;
  befolkningspyramid_nn_1 = mkN "befolkningspyramid" "befolkningspyramider" ;
  befolkningsstatistik_nn_1 = mkN "befolkningsstatistik" "befolkningsstatistiker" ;
  befordran_nn_1 = mkN "befordran" "befordran" "befordringar" "befordringarna" ;
  befordring_nn_1 = mkN "befordring" ;
  befordringsgaang_nn_1 = mkN "befordringsgеng" ;
  befordringsgrund_nn_1 = mkN "befordringsgrund" "befordringsgrunder" ;
  befraemjare_nn_1 = mkN "befrдmjare" "befrдmjare" ;
  befraktare_nn_1 = mkN "befraktare" "befraktare" ;
  befraktning_nn_1 = mkN "befraktning" ;
  befriande_av_1 = mkA "befriande" ;
  befrielse_nn_1 = mkN "befrielse" "befrielser" ;
  befrielsefront_nn_1 = mkN "befrielsefront" "befrielsefronter" ;
  befrielsekamp_nn_1 = mkN "befrielsekamp" "befrielsekamper" ;
  befrielsekrig_nn_1 = mkN "befrielsekrig" neutrum ;
  befrielseroerelse_nn_1 = mkN "befrielserцrelse" "befrielserцrelser" ;
  befruktning_nn_1 = mkN "befruktning" ;
  begaa_vb_1 = mkV "begе" "begеr" "begе" "begick" "begеtt" "begеngen" ;
  begaavning_nn_1 = mkN "begеvning" ;
  begaavningsreserv_nn_1 = mkN "begеvningsreserv" "begеvningsreserver" ;
  begaer_nn_1 = mkN "begдr" neutrum ;
  begaerelse_nn_1 = mkN "begдrelse" "begдrelser" ;
  begaerlig_av_1 = mkA "begдrlig" ;
  bege_vb_1 = mkV "bege" "beger" "bege" "begav" "begett" "begiven" ;
  begeistring_nn_1 = mkN "begeistring" ;
  begineraa_nn_1 = mkN "beginerе" "beginerеn" "beginerеr" "beginerеrna" ;
  begivande_nn_1 = mkN "begivande" ;
  begiven_av_1 = mkA "begiven" "begivet" ;
  begivenhet_nn_1 = mkN "begivenhet" "begivenheter" ;
  begjuta_vb_1 = mkV "begjuta" "begцt" "begjutit" ;
  begraata_vb_1 = mkV "begrеta" "begrдt" "begrеtit" ;
  begraensning_nn_1 = mkN "begrдnsning" ;
  begraensningslinje_nn_1 = mkN "begrдnsningslinje" "begrдnsningslinjer" ;
  begrava_vb_1 = mkV "begraver" ;
  begravning_nn_1 = mkN "begravning" ;
  begravningsakt_nn_1 = mkN "begravningsakt" "begravningsakter" ;
  begravningsbok_nn_1 = mkN "begravningsbok" "begravningsbцcker" ;
  begravningsbyraa_nn_1 = mkN "begravningsbyrе" "begravningsbyrеer" ;
  begravningsentreprenoer_nn_1 = mkN "begravningsentreprenцr" "begravningsentreprenцrer" ;
  begravningsgaest_nn_1 = mkN "begravningsgдst" "begravningsgдster" ;
  begravningskassa_nn_1 = mkN "begravningskassa" ;
  begravningskrans_nn_1 = mkN "begravningskrans" ;
  begravningsmarsch_nn_1 = mkN "begravningsmarsch" "begravningsmarscher" ;
  begravningsmin_nn_1 = mkN "begravningsmin" "begravningsminer" ;
  begravningsplats_nn_1 = mkN "begravningsplats" "begravningsplatser" ;
  begravningsprocession_nn_1 = mkN "begravningsprocession" "begravningsprocessioner" ;
  begravningstaag_nn_1 = mkN "begravningstеg" neutrum ;
  begrepp_nn_1 = mkN "begrepp" neutrum ;
  begreppsanalys_nn_1 = mkN "begreppsanalys" "begreppsanalyser" ;
  begreppsanalytisk_av_1 = mkA "begreppsanalytisk" ;
  begreppsbestaemning_nn_1 = mkN "begreppsbestдmning" ;
  begreppsfoervirring_nn_1 = mkN "begreppsfцrvirring" ;
  begreppslig_av_1 = mkA "begreppslig" ;
  begripa_vb_1 = mkV "begripa" "begrep" "begripit" ;
  begriplig_av_1 = mkA "begriplig" ;
  begriplighet_nn_1 = mkN "begriplighet" "begripligheter" ;
  begynnelse_nn_1 = mkN "begynnelse" "begynnelser" ;
  begynnelsebokstav_nn_1 = mkN "begynnelsebokstav" "begynnelsebokstдver" ;
  begynnelsehastighet_nn_1 = mkN "begynnelsehastighet" "begynnelsehastigheter" ;
  begynnelseloen_nn_1 = mkN "begynnelselцn" "begynnelselцner" ;
  begynnelserim_nn_1 = mkN "begynnelserim" "begynnelserimmet" "begynnelserim" "begynnelserimmen" ;
  begynnelseskede_nn_1 = mkN "begynnelseskede" ;
  begynnelsespraak_nn_1 = mkN "begynnelsesprеk" neutrum ;
  begynnelsestadium_nn_1 = mkN "begynnelsestadium" "begynnelsestadiet" "begynnelsestadier" "begynnelsestadierna" ;
  behaa_nn_1 = mkN "behе" ;
  behaalla_vb_1 = mkV "behеlla" "behцll" "behеllit" ;
  behaallare_nn_1 = mkN "behеllare" "behеllare" ;
  behaallning_nn_1 = mkN "behеllning" ;
  behaaring_nn_1 = mkN "behеring" ;
  behaendig_av_1 = mkA "behдndig" ;
  behag_nn_1 = mkN "behag" neutrum ;
  behagfull_av_1 = mkA "behagfull" ;
  behaglig_av_1 = mkA "behaglig" ;
  behagsjuk_av_1 = mkA "behagsjuk" ;
  behandling_nn_1 = mkN "behandling" ;
  behandlingsbar_av_1 = mkA "behandlingsbar" ;
  behandlingsenhet_nn_1 = mkN "behandlingsenhet" "behandlingsenheter" ;
  behandlingsrum_nn_1 = mkN "behandlingsrum" "behandlingsrummet" "behandlingsrum" "behandlingsrummen" ;
  behaviorist_nn_1 = mkN "behaviorist" "behaviorister" ;
  behjaelplig_av_1 = mkA "behjдlplig" ;
  behjaertansvaerd_av_1 = mkA "behjдrtansvдrd" "behjдrtansvдrt" ;
  behjaertenhet_nn_1 = mkN "behjдrtenhet" "behjдrtenheter" ;
  behoerig_av_1 = mkA "behцrig" ;
  behoerigen_ab_1 = mkAdv "behцrigen" ;
  behoerighet_nn_1 = mkN "behцrighet" "behцrigheter" ;
  behoerighetsbevis_nn_1 = mkN "behцrighetsbevis" neutrum ;
  behoevande_av_1 = mkA "behцvande" ;
  behoevlig_av_1 = mkA "behцvlig" ;
  behov_nn_1 = mkN "behov" neutrum ;
  behovloes_av_1 = mkA "behovlцs" ;
  behovloeshet_nn_1 = mkN "behovlцshet" "behovlцsheter" ;
  behovsprincip_nn_1 = mkN "behovsprincip" "behovsprinciper" ;
  behovsproevning_nn_1 = mkN "behovsprцvning" ;
  beige_av_1 = mkA "beige" ;
  beivrande_nn_1 = mkN "beivrande" ;
  bej_nn_1 = mkN "bej" "bejer" ;
  bekaempning_nn_1 = mkN "bekдmpning" ;
  bekaempningsmedel_nn_1 = mkN "bekдmpningsmedel" neutrum ;
  bekaennare_nn_1 = mkN "bekдnnare" "bekдnnare" ;
  bekaennelse_nn_1 = mkN "bekдnnelse" "bekдnnelser" ;
  bekaennelsefrihet_nn_1 = mkN "bekдnnelsefrihet" "bekдnnelsefriheter" ;
  bekaennelseroman_nn_1 = mkN "bekдnnelseroman" "bekдnnelseromaner" ;
  bekaennelseskrift_nn_1 = mkN "bekдnnelseskrift" "bekдnnelseskrifter" ;
  bekant_av_1 = mkA "bekant" "bekant" ;
  bekant_nn_1 = mkN "bekant" "bekanter" ;
  bekanting_nn_1 = mkN "bekanting" ;
  bekantskap_nn_1 = mkN "bekantskap" "bekantskaper" ;
  bekantskapskrets_nn_1 = mkN "bekantskapskrets" ;
  beklaednad_nn_1 = mkN "beklдdnad" "beklдdnader" ;
  beklaemd_av_1 = mkA "beklдmd" "beklдmt" ;
  beklaemmande_av_1 = mkA "beklдmmande" ;
  beklagande_nn_1 = mkN "beklagande" ;
  beklagansvaerd_av_1 = mkA "beklagansvдrd" "beklagansvдrt" ;
  beklaglig_av_1 = mkA "beklaglig" ;
  beklagligen_ab_1 = mkAdv "beklagligen" ;
  beklagligtvis_ab_1 = mkAdv "beklagligtvis" ;
  beknipa_vb_1 = mkV "beknipa" "beknep" "beknipit" ;
  bekostnad_nn_1 = mkN "bekostnad" "bekostnader" ;
  bekraeftelse_nn_1 = mkN "bekrдftelse" "bekrдftelser" ;
  bekroening_nn_1 = mkN "bekrцning" ;
  bekvaem_av_1 = mkA "bekvдm" ;
  bekvaemlighet_nn_1 = mkN "bekvдmlighet" "bekvдmligheter" ;
  bekvaemlighetsinraettning_nn_1 = mkN "bekvдmlighetsinrдttning" ;
  bekymmer_nn_1 = mkN "bekymmer" neutrum ;
  bekymmerfri_av_1 = mkA "bekymmerfri" "bekymmerfritt" ;
  bekymmersam_av_1 = mkA "bekymmersam" "bekymmersamt" "bekymmersamma" "bekymmersamma" "bekymmersammare" "bekymmersammast" "bekymmersammaste" ;
  bekymmersfri_av_1 = mkA "bekymmersfri" "bekymmersfritt" ;
  bekymmersloes_av_1 = mkA "bekymmerslцs" ;
  belaaning_nn_1 = mkN "belеning" ;
  belaaten_av_1 = mkA "belеten" "belеtet" ;
  belaatenhet_nn_1 = mkN "belеtenhet" "belеtenheter" ;
  belackare_nn_1 = mkN "belackare" "belackare" ;
  belaegen_av_1 = mkA "belдgen" "belдget" ;
  belaegenhet_nn_1 = mkN "belдgenhet" "belдgenheter" ;
  belaegg_nn_1 = mkN "belдgg" neutrum ;
  belaeggning_nn_1 = mkN "belдggning" ;
  belaeggningsring_nn_1 = mkN "belдggningsring" ;
  belaeggningssnoere_nn_1 = mkN "belдggningssnцre" ;
  belaeggningsstaempel_nn_1 = mkN "belдggningsstдmpel" ;
  belaegring_nn_1 = mkN "belдgring" ;
  belaegringstillstaand_nn_1 = mkN "belдgringstillstеnd" neutrum ;
  belaesenhet_nn_1 = mkN "belдsenhet" "belдsenheter" ;
  belaest_av_1 = mkA "belдst" "belдst" ;
  belaesthet_nn_1 = mkN "belдsthet" "belдstheter" ;
  belag_nn_1 = mkN "belag" neutrum ;
  belastning_nn_1 = mkN "belastning" ;
  belemnit_nn_1 = mkN "belemnit" "belemniter" ;
  belevenhet_nn_1 = mkN "belevenhet" "belevenheter" ;
  belgare_nn_1 = mkN "belgare" "belgare" ;
  belgier_nn_1 = mkN "belgier" "belgiern" "belgier" "belgierna" ;
  belgisk_av_1 = mkA "belgisk" ;
  belgiska_nn_1 = mkN "belgiska" ;
  belizier_nn_1 = mkN "belizier" "beliziern" "belizier" "belizierna" ;
  belizisk_av_1 = mkA "belizisk" ;
  beljuga_vb_1 = mkV "beljuga" "beljцg" "beljugit" ;
  belletrist_nn_1 = mkN "belletrist" "belletrister" ;
  belletristisk_av_1 = mkA "belletristisk" ;
  bellis_nn_1 = mkN "bellis" ;
  beloening_nn_1 = mkN "belцning" ;
  beloeningssystem_nn_1 = mkN "belцningssystem" neutrum ;
  belopp_nn_1 = mkN "belopp" neutrum ;
  belysande_av_1 = mkA "belysande" ;
  belysning_nn_1 = mkN "belysning" ;
  belysningsarmatur_nn_1 = mkN "belysningsarmatur" "belysningsarmaturer" ;
  belysningsstroem_nn_1 = mkN "belysningsstrцm" "belysningsstrцmmen" "belysningsstrцmmar" "belysningsstrцmmarna" ;
  belysningsstyrka_nn_1 = mkN "belysningsstyrka" ;
  bemaelde_av_1 = mkA "bemдlde" ;
  bemaerkelse_nn_1 = mkN "bemдrkelse" "bemдrkelser" ;
  bemaerkelsedag_nn_1 = mkN "bemдrkelsedag" ;
  bemaerkt_av_1 = mkA "bemдrkt" "bemдrkt" ;
  bemanning_nn_1 = mkN "bemanning" ;
  bemoedande_nn_1 = mkN "bemцdande" ;
  bemyndigande_nn_1 = mkN "bemyndigande" ;
  ben_nn_1 = mkN "ben" neutrum ;
  benaadning_nn_1 = mkN "benеdning" ;
  benaegen_av_1 = mkA "benдgen" "benдget" ;
  benaegenhet_nn_1 = mkN "benдgenhet" "benдgenheter" ;
  benaemning_nn_1 = mkN "benдmning" ;
  benbildning_nn_1 = mkN "benbildning" ;
  benbrosk_nn_1 = mkN "benbrosk" neutrum ;
  benbrott_nn_1 = mkN "benbrott" neutrum ;
  benediktin_nn_1 = mkN "benediktin" "benediktiner" ;
  benediktinerkloster_nn_1 = mkN "benediktinerkloster" neutrum ;
  benediktinermunk_nn_1 = mkN "benediktinermunk" ;
  benediktinerorden_nn_1 = mkN "benediktinerorden" ;
  beneficium_nn_1 = mkN "beneficium" "beneficiet" "beneficier" "beneficierna" ;
  benefik_av_1 = mkA "benefik" ;
  benfisk_nn_1 = mkN "benfisk" ;
  benfri_av_1 = mkA "benfri" "benfritt" ;
  bengalisk_av_1 = mkA "bengalisk" ;
  benget_nn_1 = mkN "benget" "bengetter" ;
  benhaard_av_1 = mkA "benhеrd" "benhеrt" ;
  benhinna_nn_1 = mkN "benhinna" ;
  benhinneinflammation_nn_1 = mkN "benhinneinflammation" "benhinneinflammationer" ;
  benig_av_1 = mkA "benig" ;
  benign_av_1 = mkA "benign" ;
  beninier_nn_1 = mkN "beninier" "beniniern" "beninier" "beninierna" ;
  beninsk_av_1 = mkA "beninsk" ;
  benling_nn_1 = mkN "benling" ;
  benmuskel_nn_1 = mkN "benmuskel" "benmuskeln" "benmuskler" "benmusklerna" ;
  benporslin_nn_1 = mkN "benporslin" "benporslinet" "benporsliner" "benporslinerna" ;
  benprotes_nn_1 = mkN "benprotes" "benproteser" ;
  benrangel_nn_1 = mkN "benrangel" neutrum ;
  benrest_nn_1 = mkN "benrest" "benrester" ;
  bensaar_nn_1 = mkN "bensеr" neutrum ;
  bensinautomat_nn_1 = mkN "bensinautomat" "bensinautomater" ;
  bensinbolag_nn_1 = mkN "bensinbolag" neutrum ;
  bensindriven_av_1 = mkA "bensindriven" "bensindrivet" ;
  bensindunk_nn_1 = mkN "bensindunk" ;
  bensinfoerbrukning_nn_1 = mkN "bensinfцrbrukning" ;
  bensinmack_nn_1 = mkN "bensinmack" ;
  bensinmotor_nn_1 = mkN "bensinmotor" "bensinmotorer" ;
  bensinpump_nn_1 = mkN "bensinpump" ;
  bensinskatt_nn_1 = mkN "bensinskatt" "bensinskatter" ;
  bensinsnaal_av_1 = mkA "bensinsnеl" ;
  bensinstation_nn_1 = mkN "bensinstation" "bensinstationer" ;
  bensintank_nn_1 = mkN "bensintank" ;
  bensintillsats_nn_1 = mkN "bensintillsats" "bensintillsatser" ;
  benskoer_av_1 = mkA "benskцr" ;
  benskoerhet_nn_1 = mkN "benskцrhet" "benskцrheter" ;
  benskydd_nn_1 = mkN "benskydd" neutrum ;
  benspets_nn_1 = mkN "benspets" ;
  benstamp_nn_1 = mkN "benstamp" ;
  benstomme_nn_1 = mkN "benstomme" utrum ;
  benstraale_nn_1 = mkN "benstrеle" utrum ;
  bensubstans_nn_1 = mkN "bensubstans" "bensubstanser" ;
  bensvulst_nn_1 = mkN "bensvulst" "bensvulster" ;
  bentonit_nn_1 = mkN "bentonit" "bentoniter" ;
  benutskott_nn_1 = mkN "benutskott" neutrum ;
  benvaevnad_nn_1 = mkN "benvдvnad" "benvдvnader" ;
  benvit_av_1 = mkA "benvit" ;
  bepansring_nn_1 = mkN "bepansring" ;
  beraeknande_av_1 = mkA "berдknande" ;
  beraeknelig_av_1 = mkA "berдknelig" ;
  beraekning_nn_1 = mkN "berдkning" ;
  beraekningsgrund_nn_1 = mkN "berдkningsgrund" "berдkningsgrunder" ;
  beraekningsmetod_nn_1 = mkN "berдkningsmetod" "berдkningsmetoder" ;
  beraekningssaett_nn_1 = mkN "berдkningssдtt" neutrum ;
  beraettande_av_1 = mkA "berдttande" ;
  beraettare_nn_1 = mkN "berдttare" "berдttare" ;
  beraettarjag_nn_1 = mkN "berдttarjag" neutrum ;
  beraettarkonst_nn_1 = mkN "berдttarkonst" "berдttarkonster" ;
  beraettartalang_nn_1 = mkN "berдttartalang" "berдttartalanger" ;
  beraettarteknik_nn_1 = mkN "berдttarteknik" "berдttartekniker" ;
  beraettelse_nn_1 = mkN "berдttelse" "berдttelser" ;
  berber_nn_1 = mkN "berber" "berbern" "berber" "berberna" ;
  berceuse_nn_1 = mkN "berceuse" "berceuser" ;
  beredare_nn_1 = mkN "beredare" "beredare" ;
  beredd_av_1 = mkA "beredd" ;
  beredelse_nn_1 = mkN "beredelse" "beredelser" ;
  beredning_nn_1 = mkN "beredning" ;
  beredningsnaemnd_nn_1 = mkN "beredningsnдmnd" "beredningsnдmnder" ;
  beredskap_nn_1 = mkN "beredskap" "beredskaper" ;
  beredskapslager_nn_1 = mkN "beredskapslager" neutrum ;
  beredskapslagring_nn_1 = mkN "beredskapslagring" ;
  beredskapsplan_nn_1 = mkN "beredskapsplan" neutrum ;
  beredskapsstat_nn_1 = mkN "beredskapsstat" "beredskapsstater" ;
  beredskapstjaenst_nn_1 = mkN "beredskapstjдnst" "beredskapstjдnster" ;
  beredvillig_av_1 = mkA "beredvillig" ;
  beredvillighet_nn_1 = mkN "beredvillighet" "beredvilligheter" ;
  berest_av_1 = mkA "berest" "berest" ;
  berg_nn_1 = mkN "berg" neutrum ;
  bergakung_nn_1 = mkN "bergakung" ;
  bergamott_nn_1 = mkN "bergamott" "bergamotter" ;
  bergart_nn_1 = mkN "bergart" "bergarter" ;
  bergartslager_nn_1 = mkN "bergartslager" neutrum ;
  bergbestigare_nn_1 = mkN "bergbestigare" "bergbestigare" ;
  bergbestigning_nn_1 = mkN "bergbestigning" ;
  bergborr_nn_1 = mkN "bergborr" ;
  bergborrning_nn_1 = mkN "bergborrning" ;
  bergfast_av_1 = mkA "bergfast" "bergfast" ;
  bergfin_av_1 = mkA "bergfin" ;
  bergfink_nn_1 = mkN "bergfink" ;
  berggrund_nn_1 = mkN "berggrund" "berggrunder" ;
  berghaell_nn_1 = mkN "berghдll" ;
  bergig_av_1 = mkA "bergig" ;
  bergis_av_1 = mkA "bergis" ;
  bergis_nn_1 = mkN "bergis" ;
  bergkam_nn_1 = mkN "bergkam" "bergkammen" "bergkammar" "bergkammarna" ;
  bergklack_nn_1 = mkN "bergklack" ;
  bergknalle_nn_1 = mkN "bergknalle" utrum ;
  bergkristall_nn_1 = mkN "bergkristall" "bergkristaller" ;
  bergkulle_nn_1 = mkN "bergkulle" utrum ;
  bergnymf_nn_1 = mkN "bergnymf" "bergnymfer" ;
  bergolja_nn_1 = mkN "bergolja" ;
  bergrum_nn_1 = mkN "bergrum" "bergrummet" "bergrum" "bergrummen" ;
  bergrygg_nn_1 = mkN "bergrygg" ;
  bergsaeker_av_1 = mkA "bergsдker" "bergsдkert" "bergsдkra" "bergsдkra" "bergsдkrare" "bergsдkrast" "bergsдkraste" ;
  bergsbestigare_nn_1 = mkN "bergsbestigare" "bergsbestigare" ;
  bergsbestigning_nn_1 = mkN "bergsbestigning" ;
  bergsformation_nn_1 = mkN "bergsformation" "bergsformationer" ;
  bergskedja_nn_1 = mkN "bergskedja" ;
  bergskedjebildning_nn_1 = mkN "bergskedjebildning" ;
  bergsklaettrare_nn_1 = mkN "bergsklдttrare" "bergsklдttrare" ;
  bergsklaettring_nn_1 = mkN "bergsklдttring" ;
  bergskred_nn_1 = mkN "bergskred" neutrum ;
  bergslag_nn_1 = mkN "bergslag" "bergslager" ;
  bergslager_nn_1 = mkN "bergslager" neutrum ;
  bergsman_nn_1 = mkN "bergsman" "bergsmannen" "bergsmдn" "bergsmдnnen" ;
  bergsmassiv_nn_1 = mkN "bergsmassiv" neutrum ;
  bergsomraade_nn_1 = mkN "bergsomrеde" ;
  bergsrygg_nn_1 = mkN "bergsrygg" ;
  bergssida_nn_1 = mkN "bergssida" ;
  bergstopp_nn_1 = mkN "bergstopp" ;
  bergstrakt_nn_1 = mkN "bergstrakt" "bergstrakter" ;
  bergstup_nn_1 = mkN "bergstup" neutrum ;
  bergtagen_av_1 = mkA "bergtagen" "bergtaget" ;
  bergtall_nn_1 = mkN "bergtall" ;
  bergtopp_nn_1 = mkN "bergtopp" ;
  bergtroll_nn_1 = mkN "bergtroll" neutrum ;
  berguv_nn_1 = mkN "berguv" ;
  bergvaegg_nn_1 = mkN "bergvдgg" ;
  bergvind_nn_1 = mkN "bergvind" ;
  beridare_nn_1 = mkN "beridare" "beridare" ;
  beriden_av_1 = mkA "beriden" "beridet" ;
  beriktigande_nn_1 = mkN "beriktigande" ;
  berkis_nn_1 = mkN "berkis" ;
  berlock_nn_1 = mkN "berlock" "berlocker" ;
  bermudarigg_nn_1 = mkN "bermudarigg" ;
  beroemd_av_1 = mkA "berцmd" "berцmt" ;
  beroemdhet_nn_1 = mkN "berцmdhet" "berцmdheter" ;
  beroemlig_av_1 = mkA "berцmlig" ;
  beroemvaerd_av_1 = mkA "berцmvдrd" "berцmvдrt" ;
  beroende_av_1 = mkA "beroende" ;
  beroendeframkallande_av_1 = mkA "beroendeframkallande" ;
  beroerd_av_1 = mkA "berцrd" "berцrt" ;
  beroering_nn_1 = mkN "berцring" ;
  beroeringsassociation_nn_1 = mkN "berцringsassociation" "berцringsassociationer" ;
  beroeringselektricitet_nn_1 = mkN "berцringselektricitet" "berцringselektriciteter" ;
  beroeringspunkt_nn_1 = mkN "berцringspunkt" "berцringspunkter" ;
  bersaa_nn_1 = mkN "bersе" "bersеer" ;
  bertel_nn_1 = mkN "bertel" ;
  berusande_av_1 = mkA "berusande" ;
  berusning_nn_1 = mkN "berusning" ;
  beryll_nn_1 = mkN "beryll" "beryller" ;
  besaettning_nn_1 = mkN "besдttning" ;
  besaettningsband_nn_1 = mkN "besдttningsband" neutrum ;
  besaettningsman_nn_1 = mkN "besдttningsman" "besдttningsmannen" "besдttningsmдn" "besдttningsmдnnen" ;
  besatt_av_1 = mkA "besatt" ;
  besegrare_nn_1 = mkN "besegrare" "besegrare" ;
  besiffring_nn_1 = mkN "besiffring" ;
  besiktning_nn_1 = mkN "besiktning" ;
  besiktningsinstrument_nn_1 = mkN "besiktningsinstrument" neutrum ;
  besiktningsman_nn_1 = mkN "besiktningsman" "besiktningsmannen" "besiktningsmдn" "besiktningsmдnnen" ;
  besinningsfull_av_1 = mkA "besinningsfull" ;
  besinningsloes_av_1 = mkA "besinningslцs" ;
  besitta_vb_1 = mkV "besitta" "besatt" "besuttit" ;
  besittning_nn_1 = mkN "besittning" ;
  besittningshavare_nn_1 = mkN "besittningshavare" "besittningshavare" ;
  besittningsraett_nn_1 = mkN "besittningsrдtt" "besittningsrдtter" ;
  besittningsskydd_nn_1 = mkN "besittningsskydd" neutrum ;
  besjunga_vb_1 = mkV "besjunga" "besjцng" "besjungit" ;
  besk_av_1 = mkA "besk" ;
  besk_nn_1 = mkN "besk" ;
  beskaeftig_av_1 = mkA "beskдftig" ;
  beskaellare_nn_1 = mkN "beskдllare" "beskдllare" ;
  beskaenkt_av_1 = mkA "beskдnkt" "beskдnkt" ;
  beskaera_vb_2 = mkV "beskдra" "beskar" "beskurit" ;
  beskaerd_av_1 = mkA "beskдrd" "beskдrt" ;
  beskaermelse_nn_1 = mkN "beskдrmelse" "beskдrmelser" ;
  beskaerning_nn_1 = mkN "beskдrning" ;
  beskaffenhet_nn_1 = mkN "beskaffenhet" "beskaffenheter" ;
  beskattning_nn_1 = mkN "beskattning" ;
  beskattningsaar_nn_1 = mkN "beskattningsеr" neutrum ;
  beskattningsbar_av_1 = mkA "beskattningsbar" ;
  beskattningsgrund_nn_1 = mkN "beskattningsgrund" "beskattningsgrunder" ;
  beskattningsnaemnd_nn_1 = mkN "beskattningsnдmnd" "beskattningsnдmnder" ;
  beskattningsprincip_nn_1 = mkN "beskattningsprincip" "beskattningsprinciper" ;
  besked_nn_1 = mkN "besked" neutrum ;
  beskedlig_av_1 = mkA "beskedlig" ;
  beskhet_nn_1 = mkN "beskhet" "beskheter" ;
  beskickning_nn_1 = mkN "beskickning" ;
  beskickningschef_nn_1 = mkN "beskickningschef" "beskickningschefer" ;
  beskjuta_vb_1 = mkV "beskjuta" "beskцt" "beskjutit" ;
  beskjutning_nn_1 = mkN "beskjutning" ;
  beskriva_vb_1 = mkV "beskriva" "beskrev" "beskrivit" ;
  beskrivande_av_1 = mkA "beskrivande" ;
  beskrivbar_av_1 = mkA "beskrivbar" ;
  beskrivning_nn_1 = mkN "beskrivning" ;
  beskyddare_nn_1 = mkN "beskyddare" "beskyddare" ;
  beskyllning_nn_1 = mkN "beskyllning" ;
  beslag_nn_1 = mkN "beslag" neutrum ;
  beslagare_nn_1 = mkN "beslagare" "beslagare" ;
  beslagsband_nn_1 = mkN "beslagsband" neutrum ;
  beslagssmed_nn_1 = mkN "beslagssmed" "beslagssmeder" ;
  beslagssmide_nn_1 = mkN "beslagssmide" ;
  beslagta_vb_1 = mkV "beslagta" "beslagtar" "beslagta" "beslagtog" "beslagtagit" "beslagtagen" ;
  beslut_nn_1 = mkN "beslut" neutrum ;
  besluta_vb_1 = mkV "besluta" ;
  besluten_av_1 = mkA "besluten" "beslutet" ;
  beslutenlig_av_1 = mkA "beslutenlig" ;
  beslutfattare_nn_1 = mkN "beslutfattare" "beslutfattare" ;
  beslutfoer_av_1 = mkA "beslutfцr" ;
  beslutmaessig_av_1 = mkA "beslutmдssig" ;
  beslutnivaa_nn_1 = mkN "beslutnivе" "beslutnivеer" ;
  beslutsam_av_1 = mkA "beslutsam" "beslutsamt" "beslutsamma" "beslutsamma" "beslutsammare" "beslutsammast" "beslutsammaste" ;
  beslutsamhet_nn_1 = mkN "beslutsamhet" "beslutsamheter" ;
  beslutsfattande_av_1 = mkA "beslutsfattande" ;
  beslutsfattare_nn_1 = mkN "beslutsfattare" "beslutsfattare" ;
  beslutsfoer_av_1 = mkA "beslutsfцr" ;
  beslutshierarki_nn_1 = mkN "beslutshierarki" "beslutshierarkier" ;
  beslutsmaessig_av_1 = mkA "beslutsmдssig" ;
  beslutsnivaa_nn_1 = mkN "beslutsnivе" "beslutsnivеer" ;
  besman_nn_1 = mkN "besman" neutrum ;
  besmanskrok_nn_1 = mkN "besmanskrok" ;
  besmittelse_nn_1 = mkN "besmittelse" "besmittelser" ;
  besoek_nn_1 = mkN "besцk" neutrum ;
  besoekande_nn_1 = mkN "besцkande" "besцkanden" "besцkande" "besцkandena" ;
  besoekare_nn_1 = mkN "besцkare" "besцkare" ;
  besoeksadress_nn_1 = mkN "besцksadress" "besцksadresser" ;
  besoeksbok_nn_1 = mkN "besцksbok" "besцksbцcker" ;
  besoeksdag_nn_1 = mkN "besцksdag" ;
  besoekstid_nn_1 = mkN "besцkstid" "besцkstider" ;
  besparing_nn_1 = mkN "besparing" ;
  besparingsskog_nn_1 = mkN "besparingsskog" ;
  bespisning_nn_1 = mkN "bespisning" ;
  bespottelse_nn_1 = mkN "bespottelse" "bespottelser" ;
  besprutning_nn_1 = mkN "besprutning" ;
  besprutningsmedel_nn_1 = mkN "besprutningsmedel" neutrum ;
  besprutningsvaetska_nn_1 = mkN "besprutningsvдtska" ;
  bessemerblaasning_nn_1 = mkN "bessemerblеsning" ;
  bessemerstaal_nn_1 = mkN "bessemerstеl" neutrum ;
  bessemerugn_nn_1 = mkN "bessemerugn" ;
  besserwisser_nn_1 = mkN "besserwisser" ;
  best_nn_1 = mkN "best" ;
  bestaaende_av_1 = mkA "bestеende" ;
  bestaand_nn_1 = mkN "bestеnd" neutrum ;
  bestaandande_av_1 = mkA "bestеndande" ;
  bestaandsbildande_av_1 = mkA "bestеndsbildande" ;
  bestaandsdel_nn_1 = mkN "bestеndsdel" "bestеndsdelen" "bestеndsdelar" "bestеndsdelarna" ;
  bestaellare_nn_1 = mkN "bestдllare" "bestдllare" ;
  bestaellning_nn_1 = mkN "bestдllning" ;
  bestaellningsavgift_nn_1 = mkN "bestдllningsavgift" "bestдllningsavgifter" ;
  bestaellningsverk_nn_1 = mkN "bestдllningsverk" neutrum ;
  bestaellsam_av_1 = mkA "bestдllsam" "bestдllsamt" "bestдllsamma" "bestдllsamma" "bestдllsammare" "bestдllsammast" "bestдllsammaste" ;
  bestaellt_av_1 = mkA "bestдllt" ;
  bestaembar_av_1 = mkA "bestдmbar" ;
  bestaemd_av_1 = mkA "bestдmd" "bestдmt" ;
  bestaemmelse_nn_1 = mkN "bestдmmelse" "bestдmmelser" ;
  bestaemmelseort_nn_1 = mkN "bestдmmelseort" "bestдmmelseorter" ;
  bestaemning_nn_1 = mkN "bestдmning" ;
  bestaemningsord_nn_1 = mkN "bestдmningsord" neutrum ;
  bestaendig_av_1 = mkA "bestдndig" ;
  bestaendighet_nn_1 = mkN "bestдndighet" "bestдndigheter" ;
  bestialisk_av_1 = mkA "bestialisk" ;
  bestick_nn_1 = mkN "bestick" neutrum ;
  besticka_vb_1 = mkV "besticka" "bestack" "bestuckit" ;
  bestickande_av_1 = mkA "bestickande" ;
  bestickfoering_nn_1 = mkN "bestickfцring" ;
  besticklig_av_1 = mkA "besticklig" ;
  bestickning_nn_1 = mkN "bestickning" ;
  bestiga_vb_1 = mkV "bestiga" "besteg" "bestigit" ;
  bestigning_nn_1 = mkN "bestigning" ;
  bestjaela_vb_1 = mkV "bestjдla" "bestjдl" "bestjдl" "bestal" "bestulit" "bestulen" ;
  bestoert_av_1 = mkA "bestцrt" "bestцrt" ;
  bestraalning_nn_1 = mkN "bestrеlning" ;
  bestraffning_nn_1 = mkN "bestraffning" ;
  bestrida_vb_1 = mkV "bestrida" "bestred" "bestritt" ;
  bestryka_vb_1 = mkV "bestryka" "bestrцk" "bestrukit" ;
  bestrykning_nn_1 = mkN "bestrykning" ;
  bestseller_nn_1 = mkN "bestseller" ;
  bestsellerfoerfattare_nn_1 = mkN "bestsellerfцrfattare" "bestsellerfцrfattare" ;
  bestyckning_nn_1 = mkN "bestyckning" ;
  bestyr_nn_1 = mkN "bestyr" neutrum ;
  besutten_av_1 = mkA "besutten" "besuttet" ;
  besvaer_nn_1 = mkN "besvдr" neutrum ;
  besvaerja_vb_1 = mkV "besvдrja" "besvдrjer" "besvдrj" "besvor" "besvurit" "besvдrjd" ;
  besvaerjelse_nn_1 = mkN "besvдrjelse" "besvдrjelser" ;
  besvaerjelseformel_nn_1 = mkN "besvдrjelseformel" "besvдrjelseformeln" "besvдrjelseformler" "besvдrjelseformlerna" ;
  besvaerlig_av_1 = mkA "besvдrlig" ;
  besvaerlighet_nn_1 = mkN "besvдrlighet" "besvдrligheter" ;
  besvaersgrund_nn_1 = mkN "besvдrsgrund" "besvдrsgrunder" ;
  besvaershaenvisning_nn_1 = mkN "besvдrshдnvisning" ;
  besvaershandling_nn_1 = mkN "besvдrshandling" ;
  besvaersinstans_nn_1 = mkN "besvдrsinstans" "besvдrsinstanser" ;
  besvaersmaal_nn_1 = mkN "besvдrsmеl" neutrum ;
  besvaersmyndighet_nn_1 = mkN "besvдrsmyndighet" "besvдrsmyndigheter" ;
  besvaersskrift_nn_1 = mkN "besvдrsskrift" "besvдrsskrifter" ;
  besvaerssubjekt_nn_1 = mkN "besvдrssubjekt" neutrum ;
  besvaerstid_nn_1 = mkN "besvдrstid" "besvдrstider" ;
  besvikelse_nn_1 = mkN "besvikelse" "besvikelser" ;
  besviken_av_1 = mkA "besviken" "besviket" ;
  besynnerlig_av_1 = mkA "besynnerlig" ;
  besynnerlighet_nn_1 = mkN "besynnerlighet" "besynnerligheter" ;
  bet_ab_1 = mkAdv "bet" ;
  bet_nn_1 = mkN "bet" ;
  beta_nn_2 = mkN "beta" "betat" "betan" "betana" ;
  beta_vb_2 = mkV "beta" "betar" "beta" "betog" "betagit" "betagen" ;
  betablockerare_nn_1 = mkN "betablockerare" "betablockerare" ;
  betaeckning_ab_1 = mkAdv "betдckning" ;
  betaeckning_nn_1 = mkN "betдckning" ;
  betaenkande_nn_1 = mkN "betдnkande" ;
  betaenketid_nn_1 = mkN "betдnketid" "betдnketider" ;
  betaenklig_av_1 = mkA "betдnklig" ;
  betaenklighet_nn_1 = mkN "betдnklighet" "betдnkligheter" ;
  betaenksam_av_1 = mkA "betдnksam" "betдnksamt" "betдnksamma" "betдnksamma" "betдnksammare" "betдnksammast" "betдnksammaste" ;
  betaenkt_av_1 = mkA "betдnkt" "betдnkt" ;
  betagande_av_1 = mkA "betagande" ;
  betagen_av_1 = mkA "betagen" "betaget" ;
  betalbar_av_1 = mkA "betalbar" ;
  betalkurs_nn_1 = mkN "betalkurs" "betalkurser" ;
  betalning_nn_1 = mkN "betalning" ;
  betalningsanstaand_nn_1 = mkN "betalningsanstеnd" neutrum ;
  betalningsavtal_nn_1 = mkN "betalningsavtal" "betalningsavtalet" "betalningsavtalen" "betalningsavtalena" ;
  betalningsbalans_nn_1 = mkN "betalningsbalans" "betalningsbalanser" ;
  betalningsbevis_nn_1 = mkN "betalningsbevis" neutrum ;
  betalningsfoerelaeggande_nn_1 = mkN "betalningsfцrelдggande" ;
  betalningsfri_av_1 = mkA "betalningsfri" "betalningsfritt" ;
  betalningsfrist_nn_1 = mkN "betalningsfrist" "betalningsfrister" ;
  betalningsgill_av_1 = mkA "betalningsgill" ;
  betalningsinstaellelse_nn_1 = mkN "betalningsinstдllelse" "betalningsinstдllelser" ;
  betalningsmedel_nn_1 = mkN "betalningsmedel" neutrum ;
  betalningsskyldig_av_1 = mkA "betalningsskyldig" ;
  betalningstermin_nn_1 = mkN "betalningstermin" "betalningsterminer" ;
  betalningstid_nn_1 = mkN "betalningstid" "betalningstider" ;
  betalningsvillkor_nn_1 = mkN "betalningsvillkor" neutrum ;
  betapartikel_nn_1 = mkN "betapartikel" ;
  betastraalande_av_1 = mkA "betastrеlande" ;
  betastraalning_nn_1 = mkN "betastrеlning" ;
  betatron_nn_1 = mkN "betatron" "betatroner" ;
  bete_nn_1 = mkN "bete" ;
  bete_nn_2 = mkN "bete" utrum ;
  betecknande_av_1 = mkA "betecknande" ;
  beteckning_nn_1 = mkN "beteckning" ;
  beteende_nn_1 = mkN "beteende" ;
  beteendeforskning_nn_1 = mkN "beteendeforskning" ;
  beteendemoenster_nn_1 = mkN "beteendemцnster" neutrum ;
  beteenderubbning_nn_1 = mkN "beteenderubbning" ;
  beteendevetare_nn_1 = mkN "beteendevetare" "beteendevetare" ;
  beteendevetenskap_nn_1 = mkN "beteendevetenskap" "beteendevetenskaper" ;
  betelblad_nn_1 = mkN "betelblad" neutrum ;
  betelnoet_nn_1 = mkN "betelnцt" "betelnцtter" ;
  betelpalm_nn_1 = mkN "betelpalm" "betelpalmer" ;
  beteltuggare_nn_1 = mkN "beteltuggare" "beteltuggare" ;
  betesgaang_nn_1 = mkN "betesgеng" ;
  betesland_nn_1 = mkN "betesland" neutrum ;
  betesmark_nn_1 = mkN "betesmark" "betesmarker" ;
  betesomraade_nn_1 = mkN "betesomrеde" ;
  betesplats_nn_1 = mkN "betesplats" "betesplatser" ;
  beting_nn_1 = mkN "beting" neutrum ;
  beting_nn_2 = mkN "beting" ;
  betingelse_nn_1 = mkN "betingelse" "betingelser" ;
  betingning_nn_1 = mkN "betingning" ;
  betingslaesning_nn_1 = mkN "betingslдsning" ;
  betjaening_nn_1 = mkN "betjдning" ;
  betjaeningsavgift_nn_1 = mkN "betjдningsavgift" "betjдningsavgifter" ;
  betjaent_av_1 = mkA "betjдnt" "betjдnt" ;
  betjaent_nn_1 = mkN "betjдnt" "betjдnter" ;
  betkampanj_nn_1 = mkN "betkampanj" "betkampanjer" ;
  betmedel_nn_1 = mkN "betmedel" neutrum ;
  betning_nn_1 = mkN "betning" ;
  betongbaedd_nn_1 = mkN "betongbдdd" ;
  betongblandare_nn_1 = mkN "betongblandare" "betongblandare" ;
  betongpaale_nn_1 = mkN "betongpеle" utrum ;
  betoning_nn_1 = mkN "betoning" ;
  betraengd_av_1 = mkA "betrдngd" "betrдngt" ;
  betraktare_nn_1 = mkN "betraktare" "betraktare" ;
  betraktelse_nn_1 = mkN "betraktelse" "betraktelser" ;
  betraktelsesaett_nn_1 = mkN "betraktelsesдtt" neutrum ;
  betrodd_av_1 = mkA "betrodd" "betrodtt" ;
  betryckt_av_1 = mkA "betryckt" "betryckt" ;
  betryggande_av_1 = mkA "betryggande" ;
  bets_nn_1 = mkN "bets" "betser" ;
  betsel_nn_1 = mkN "betsel" neutrum ;
  betsmedel_nn_1 = mkN "betsmedel" neutrum ;
  betsning_nn_1 = mkN "betsning" ;
  bett_nn_1 = mkN "bett" neutrum ;
  bettel_nn_1 = mkN "bettel" ;
  bettlare_nn_1 = mkN "bettlare" "bettlare" ;
  betungande_av_1 = mkA "betungande" ;
  betvinga_vb_1 = mkV "betvinga" ;
  betvingande_av_1 = mkA "betvingande" ;
  betydande_av_1 = mkA "betydande" ;
  betydelse_nn_1 = mkN "betydelse" "betydelser" ;
  betydelsebaerande_av_1 = mkA "betydelsebдrande" ;
  betydelsefattig_av_1 = mkA "betydelsefattig" ;
  betydelsefoeraendring_nn_1 = mkN "betydelsefцrдndring" ;
  betydelsefoerskjutning_nn_1 = mkN "betydelsefцrskjutning" ;
  betydelsefull_av_1 = mkA "betydelsefull" ;
  betydelselaera_nn_1 = mkN "betydelselдra" ;
  betydelseloes_av_1 = mkA "betydelselцs" ;
  betydelsenyans_nn_1 = mkN "betydelsenyans" "betydelsenyanser" ;
  betydelseutveckling_nn_1 = mkN "betydelseutveckling" ;
  betydenhet_nn_1 = mkN "betydenhet" "betydenheter" ;
  betydlig_av_1 = mkA "betydlig" ;
  betyg_nn_1 = mkN "betyg" neutrum ;
  betygelse_nn_1 = mkN "betygelse" "betygelser" ;
  betygsaettning_nn_1 = mkN "betygsдttning" ;
  betygsavskrift_nn_1 = mkN "betygsavskrift" "betygsavskrifter" ;
  betygsfri_av_1 = mkA "betygsfri" "betygsfritt" ;
  betygsgrad_nn_1 = mkN "betygsgrad" "betygsgrader" ;
  betygskatalog_nn_1 = mkN "betygskatalog" "betygskataloger" ;
  betygsnaemnd_nn_1 = mkN "betygsnдmnd" "betygsnдmnder" ;
  beundransvaerd_av_1 = mkA "beundransvдrd" "beundransvдrt" ;
  beundrare_nn_1 = mkN "beundrare" "beundrare" ;
  beundrarinna_nn_1 = mkN "beundrarinna" ;
  bevaagen_av_1 = mkA "bevеgen" "bevеget" ;
  bevaagenhet_nn_1 = mkN "bevеgenhet" "bevеgenheter" ;
  bevaepning_nn_1 = mkN "bevдpning" ;
  bevaering_nn_1 = mkN "bevдring" ;
  bevaext_av_1 = mkA "bevдxt" "bevдxt" ;
  bevakning_nn_1 = mkN "bevakning" ;
  bevakningskedja_nn_1 = mkN "bevakningskedja" ;
  bevakningsomraade_nn_1 = mkN "bevakningsomrеde" ;
  bevattning_nn_1 = mkN "bevattning" ;
  bevekande_av_1 = mkA "bevekande" ;
  bevekelse_nn_1 = mkN "bevekelse" "bevekelser" ;
  bevekelsegrund_nn_1 = mkN "bevekelsegrund" "bevekelsegrunder" ;
  bevillning_nn_1 = mkN "bevillning" ;
  bevillningsavgift_nn_1 = mkN "bevillningsavgift" "bevillningsavgifter" ;
  bevillningsutskott_nn_1 = mkN "bevillningsutskott" neutrum ;
  bevis_nn_1 = mkN "bevis" neutrum ;
  bevisbar_av_1 = mkA "bevisbar" ;
  bevisboerda_nn_1 = mkN "bevisbцrda" ;
  bevisfoering_nn_1 = mkN "bevisfцring" ;
  bevisfoervanskning_nn_1 = mkN "bevisfцrvanskning" ;
  beviskedja_nn_1 = mkN "beviskedja" ;
  beviskraft_nn_1 = mkN "beviskraft" "beviskrafter" ;
  beviskraftig_av_1 = mkA "beviskraftig" ;
  beviskrav_nn_1 = mkN "beviskrav" neutrum ;
  bevislig_av_1 = mkA "bevislig" ;
  bevisligen_ab_1 = mkAdv "bevisligen" ;
  bevismaterial_nn_1 = mkN "bevismaterial" neutrum ;
  bevismedel_nn_1 = mkN "bevismedel" neutrum ;
  bevisning_nn_1 = mkN "bevisning" ;
  bevisproevning_nn_1 = mkN "bevisprцvning" ;
  bevissaekring_nn_1 = mkN "bevissдkring" ;
  bevisskyldig_av_1 = mkA "bevisskyldig" ;
  bevisvaerde_nn_1 = mkN "bevisvдrde" ;
  bevisvaerdering_nn_1 = mkN "bevisvдrdering" ;
  bevuxen_av_1 = mkA "bevuxen" "bevuxet" ;
  bhutanes_nn_1 = mkN "bhutanes" "bhutaneser" ;
  bhutanesisk_av_1 = mkA "bhutanesisk" ;
  bi_ab_1 = mkAdv "bi" ;
  bi_nn_1 = mkN "bi" "bit" "bin" "bien" ;
  biaccent_nn_1 = mkN "biaccent" "biaccenter" ;
  biaemne_nn_1 = mkN "biдmne" ;
  biaetare_nn_1 = mkN "biдtare" "biдtare" ;
  bias_nn_1 = mkN "bias" "biaser" ;
  biavsikt_nn_1 = mkN "biavsikt" "biavsikter" ;
  bibehaalla_vb_1 = mkV "bibehеlla" "bibehцll" "bibehеllit" ;
  bibehaallen_av_1 = mkA "bibehеllen" "bibehеllet" ;
  bibel_nn_1 = mkN "bibel" ;
  bibelcitat_nn_1 = mkN "bibelcitat" neutrum ;
  bibelfoerklaring_nn_1 = mkN "bibelfцrklaring" ;
  bibelhandskrift_nn_1 = mkN "bibelhandskrift" "bibelhandskrifter" ;
  bibelkanon_nn_1 = mkN "bibelkanon" "bibelkanon" "bibelkanoner" "bibelkanonerna" ;
  bibelkommission_nn_1 = mkN "bibelkommission" "bibelkommissioner" ;
  bibelkonkordans_nn_1 = mkN "bibelkonkordans" "bibelkonkordanser" ;
  bibelkristen_av_1 = mkA "bibelkristen" "bibelkristet" ;
  bibeloeversaettning_nn_1 = mkN "bibelцversдttning" ;
  bibelord_nn_1 = mkN "bibelord" neutrum ;
  bibelsaellskap_nn_1 = mkN "bibelsдllskap" "bibelsдllskapet" "bibelsдllskapen" "bibelsдllskapena" ;
  bibelsamtal_nn_1 = mkN "bibelsamtal" "bibelsamtalet" "bibelsamtalen" "bibelsamtalena" ;
  bibelspraak_nn_1 = mkN "bibelsprеk" neutrum ;
  bibelspraengd_av_1 = mkA "bibelsprдngd" "bibelsprдngt" ;
  bibeltext_nn_1 = mkN "bibeltext" "bibeltexter" ;
  bibeltrogen_av_1 = mkA "bibeltrogen" "bibeltroget" ;
  bibelvers_nn_1 = mkN "bibelvers" ;
  bibetydelse_nn_1 = mkN "bibetydelse" "bibetydelser" ;
  biblicism_nn_1 = mkN "biblicism" "biblicismer" ;
  bibliofil_nn_1 = mkN "bibliofil" "bibliofiler" ;
  bibliofilupplaga_nn_1 = mkN "bibliofilupplaga" ;
  bibliograf_nn_1 = mkN "bibliograf" "bibliografer" ;
  bibliografi_nn_1 = mkN "bibliografi" "bibliografier" ;
  bibliografisk_av_1 = mkA "bibliografisk" ;
  biblioman_nn_1 = mkN "biblioman" "bibliomaner" ;
  bibliotek_nn_1 = mkN "bibliotek" neutrum ;
  bibliotekarie_nn_1 = mkN "bibliotekarie" "bibliotekarier" ;
  biblioteksavgift_nn_1 = mkN "biblioteksavgift" "biblioteksavgifter" ;
  biblioteksband_nn_1 = mkN "biblioteksband" neutrum ;
  biblioteksbord_nn_1 = mkN "biblioteksbord" neutrum ;
  bibliotekskatalog_nn_1 = mkN "bibliotekskatalog" "bibliotekskataloger" ;
  bibliotekslaan_nn_1 = mkN "bibliotekslеn" neutrum ;
  biblisk_av_1 = mkA "biblisk" ;
  bibroed_nn_1 = mkN "bibrцd" neutrum ;
  biceps_nn_1 = mkN "biceps" ;
  bicepsmuskel_nn_1 = mkN "bicepsmuskel" "bicepsmuskeln" "bicepsmuskler" "bicepsmusklerna" ;
  bide_nn_1 = mkN "bidй" "bidйer" ;
  bidevind_ab_1 = mkAdv "bidevind" ;
  bidevindare_nn_1 = mkN "bidevindare" "bidevindare" ;
  bidevindsegel_nn_1 = mkN "bidevindsegel" neutrum ;
  bidevindseglare_nn_1 = mkN "bidevindseglare" "bidevindseglare" ;
  bidra_vb_1 = mkV "bidra" "bidrar" "bidra" "bidrog" "bidragit" "bidragen" ;
  bidrag_nn_1 = mkN "bidrag" neutrum ;
  bidragande_av_1 = mkA "bidragande" ;
  bidragsdel_nn_1 = mkN "bidragsdel" "bidragsdelen" "bidragsdelar" "bidragsdelarna" ;
  bidragsfoerskott_nn_1 = mkN "bidragsfцrskott" neutrum ;
  bidragsgivare_nn_1 = mkN "bidragsgivare" "bidragsgivare" ;
  bidragsskyldighet_nn_1 = mkN "bidragsskyldighet" "bidragsskyldigheter" ;
  bidrottning_nn_1 = mkN "bidrottning" ;
  biedermeierstil_nn_1 = mkN "biedermeierstil" ;
  bieffekt_nn_1 = mkN "bieffekt" "bieffekter" ;
  bienn_av_1 = mkA "bienn" "bient" ;
  biennal_nn_1 = mkN "biennal" "biennaler" ;
  bifall_nn_1 = mkN "bifall" neutrum ;
  bifalla_vb_1 = mkV "bifalla" "bifцll" "bifallit" ;
  bifallsrop_nn_1 = mkN "bifallsrop" neutrum ;
  bifallsstorm_nn_1 = mkN "bifallsstorm" ;
  bifenyl_nn_1 = mkN "bifenyl" "bifenyler" ;
  biff_nn_1 = mkN "biff" ;
  biffdjur_nn_1 = mkN "biffdjur" neutrum ;
  biffen_ab_1 = mkAdv "biffen" ;
  biffko_nn_1 = mkN "biffko" "biffkor" ;
  biffrad_nn_1 = mkN "biffrad" "biffrader" ;
  biffstek_nn_1 = mkN "biffstek" ;
  bifigur_nn_1 = mkN "bifigur" "bifigurer" ;
  bifilaer_av_1 = mkA "bifilдr" ;
  biflod_nn_1 = mkN "biflod" "bifloder" ;
  bifloede_nn_1 = mkN "biflцde" ;
  bifokalglas_nn_1 = mkN "bifokalglas" neutrum ;
  bifurkation_nn_1 = mkN "bifurkation" "bifurkationer" ;
  bigaard_nn_1 = mkN "bigеrd" ;
  bigamist_nn_1 = mkN "bigamist" "bigamister" ;
  bigarraa_nn_1 = mkN "bigarrе" "bigarrеer" ;
  bigift_nn_1 = mkN "bigift" "bigiftet" "bigifter" "bigifterna" ;
  bigott_av_1 = mkA "bigott" ;
  bigotteri_nn_1 = mkN "bigotteri" "bigotterit" "bigotterier" "bigotterierna" ;
  bihaaleinflammation_nn_1 = mkN "bihеleinflammation" "bihеleinflammationer" ;
  bihandling_nn_1 = mkN "bihandling" ;
  bihang_nn_1 = mkN "bihang" neutrum ;
  bihus_nn_1 = mkN "bihus" neutrum ;
  bihustru_nn_1 = mkN "bihustru" "bihustrun" "bihustrur" "bihustrurna" ;
  biinkomst_nn_1 = mkN "biinkomst" "biinkomster" ;
  bikini_nn_1 = mkN "bikini" "bikinin" "bikini" "bikinina" ;
  bikloev_nn_1 = mkN "biklцv" ;
  bikonkav_av_1 = mkA "bikonkav" ;
  bikonvex_av_1 = mkA "bikonvex" ;
  bikt_nn_1 = mkN "bikt" "bikter" ;
  biktbarn_nn_1 = mkN "biktbarn" neutrum ;
  biktfader_nn_1 = mkN "biktfader" "biktfadern" "biktfдder" "biktfдderna" ;
  biktstol_nn_1 = mkN "biktstol" ;
  bikvadrat_nn_1 = mkN "bikvadrat" "bikvadrater" ;
  bil_nn_1 = mkN "bil" ;
  bilaakning_nn_1 = mkN "bilеkning" ;
  bilabial_av_1 = mkA "bilabial" ;
  bilaccis_nn_1 = mkN "bilaccis" "bilacciser" ;
  bilaegare_nn_1 = mkN "bilдgare" "bilдgare" ;
  bilaeger_nn_1 = mkN "bilдger" neutrum ;
  bilateral_av_1 = mkA "bilateral" ;
  bilbaelte_nn_1 = mkN "bilbдlte" ;
  bilbatteri_nn_1 = mkN "bilbatteri" "bilbatterit" "bilbatterier" "bilbatterierna" ;
  bilbesiktning_nn_1 = mkN "bilbesiktning" ;
  bilboke_nn_1 = mkN "bilbokй" "bilbokйer" ;
  bilburen_av_1 = mkA "bilburen" "bilburet" ;
  bild_nn_1 = mkN "bild" "bilder" ;
  bildaeck_nn_1 = mkN "bildдck" neutrum ;
  bildande_av_1 = mkA "bildande" ;
  bildband_nn_1 = mkN "bildband" neutrum ;
  bildbar_av_1 = mkA "bildbar" ;
  bilderbok_nn_1 = mkN "bilderbok" "bilderbцcker" ;
  bildhaallning_nn_1 = mkN "bildhеllning" ;
  bildhuggare_nn_1 = mkN "bildhuggare" "bildhuggare" ;
  bildhuggeri_nn_1 = mkN "bildhuggeri" "bildhuggerit" "bildhuggerier" "bildhuggerierna" ;
  bildkonst_nn_1 = mkN "bildkonst" "bildkonster" ;
  bildkryss_nn_1 = mkN "bildkryss" neutrum ;
  bildlig_av_1 = mkA "bildlig" ;
  bildmaessig_av_1 = mkA "bildmдssig" ;
  bildmaterial_nn_1 = mkN "bildmaterial" neutrum ;
  bildmonitor_nn_1 = mkN "bildmonitor" "bildmonitorer" ;
  bildning_nn_1 = mkN "bildning" ;
  bildningsaristokrat_nn_1 = mkN "bildningsaristokrat" "bildningsaristokrater" ;
  bildningsfel_nn_1 = mkN "bildningsfel" "bildningsfelet" "bildningsfel" "bildningsfelen" ;
  bildningsfoerbund_nn_1 = mkN "bildningsfцrbund" neutrum ;
  bildningsnivaa_nn_1 = mkN "bildningsnivе" "bildningsnivеer" ;
  bildningsorganisation_nn_1 = mkN "bildningsorganisation" "bildningsorganisationer" ;
  bildningsroman_nn_1 = mkN "bildningsroman" "bildningsromaner" ;
  bildningsverksamhet_nn_1 = mkN "bildningsverksamhet" "bildningsverksamheter" ;
  bildoeverfoering_nn_1 = mkN "bildцverfцring" ;
  bildredaktoer_nn_1 = mkN "bildredaktцr" "bildredaktцrer" ;
  bildreportage_nn_1 = mkN "bildreportage" "bildreportaget" "bildreportage" "bildreportagen" ;
  bildroer_nn_1 = mkN "bildrцr" neutrum ;
  bildrulle_1_nn_1 = mkN "bildrulle" utrum ;
  bildrulle_2_nn_1 = mkN "bildrulle" utrum ;
  bildsignal_nn_1 = mkN "bildsignal" "bildsignaler" ;
  bildskaerm_nn_1 = mkN "bildskдrm" ;
  bildskoen_av_1 = mkA "bildskцn" ;
  bildskrift_nn_1 = mkN "bildskrift" "bildskrifter" ;
  bildsnidare_nn_1 = mkN "bildsnidare" "bildsnidare" ;
  bildsnideri_nn_1 = mkN "bildsnideri" "bildsniderit" "bildsniderier" "bildsniderierna" ;
  bildspraak_nn_1 = mkN "bildsprеk" neutrum ;
  bildsten_nn_1 = mkN "bildsten" "bildstenen" "bildstenar" "bildstenarna" ;
  bildstod_nn_1 = mkN "bildstod" "bildstoder" ;
  bildstormare_nn_1 = mkN "bildstormare" "bildstormare" ;
  bildstrid_nn_1 = mkN "bildstrid" "bildstrider" ;
  bildsvit_nn_1 = mkN "bildsvit" "bildsviter" ;
  bildtelefon_nn_1 = mkN "bildtelefon" "bildtelefoner" ;
  bildtext_nn_1 = mkN "bildtext" "bildtexter" ;
  bildtolkning_nn_1 = mkN "bildtolkning" ;
  bildvaevnad_nn_1 = mkN "bildvдvnad" "bildvдvnader" ;
  bilfaerja_nn_1 = mkN "bilfдrja" ;
  bilfoerare_nn_1 = mkN "bilfцrare" "bilfцrare" ;
  bilfoersaekring_nn_1 = mkN "bilfцrsдkring" ;
  bilfri_av_1 = mkA "bilfri" "bilfritt" ;
  bilgolv_nn_1 = mkN "bilgolv" neutrum ;
  bilindustri_nn_1 = mkN "bilindustri" "bilindustrier" ;
  bilingual_av_1 = mkA "bilingual" ;
  bilist_nn_1 = mkN "bilist" "bilister" ;
  biljard_nn_1 = mkN "biljard" "biljarder" ;
  biljardboll_nn_1 = mkN "biljardboll" ;
  biljardbord_nn_1 = mkN "biljardbord" neutrum ;
  biljardkaepp_nn_1 = mkN "biljardkдpp" ;
  biljardkoe_nn_1 = mkN "biljardkц" "biljardkцn" "biljardkцer" "biljardkцerna" ;
  biljardsalong_nn_1 = mkN "biljardsalong" "biljardsalonger" ;
  biljardspel_nn_1 = mkN "biljardspel" "biljardspelet" "biljardspel" "biljardspelen" ;
  biljett_nn_1 = mkN "biljett" "biljetter" ;
  biljettaang_nn_1 = mkN "biljettеng" "biljettдnger" ;
  biljettautomat_nn_1 = mkN "biljettautomat" "biljettautomater" ;
  biljettbok_nn_1 = mkN "biljettbok" "biljettbцcker" ;
  biljettexpedition_nn_1 = mkN "biljettexpedition" "biljettexpeditioner" ;
  biljettfoersaeljare_nn_1 = mkN "biljettfцrsдljare" "biljettfцrsдljare" ;
  biljettfoersaeljning_nn_1 = mkN "biljettfцrsдljning" ;
  biljetthaefte_nn_1 = mkN "biljetthдfte" ;
  biljettinkomst_nn_1 = mkN "biljettinkomst" "biljettinkomster" ;
  biljettkontor_nn_1 = mkN "biljettkontor" neutrum ;
  biljettkontroll_nn_1 = mkN "biljettkontroll" "biljettkontroller" ;
  biljettmaskin_nn_1 = mkN "biljettmaskin" "biljettmaskiner" ;
  biljon_nn_1 = mkN "biljon" "biljoner" ;
  biljud_nn_1 = mkN "biljud" neutrum ;
  bilkaar_nn_1 = mkN "bilkеr" "bilkеrer" ;
  bilkaarist_nn_1 = mkN "bilkеrist" "bilkеrister" ;
  bilkoe_nn_1 = mkN "bilkц" "bilkцn" "bilkцer" "bilkцerna" ;
  bilkoep_nn_1 = mkN "bilkцp" neutrum ;
  bilkoerning_nn_1 = mkN "bilkцrning" ;
  bilkrock_nn_1 = mkN "bilkrock" ;
  bilkupe_nn_1 = mkN "bilkupй" "bilkupйer" ;
  bill_nn_1 = mkN "bill" ;
  bill_nn_2 = mkN "bill" ;
  billaan_nn_1 = mkN "billеn" neutrum ;
  billast_nn_1 = mkN "billast" "billaster" ;
  billig_av_1 = mkA "billig" ;
  billighet_nn_1 = mkN "billighet" "billigheter" ;
  billighetsupplaga_nn_1 = mkN "billighetsupplaga" ;
  billjus_nn_1 = mkN "billjus" neutrum ;
  billots_nn_1 = mkN "billots" ;
  bilmaerke_nn_1 = mkN "bilmдrke" ;
  bilmekaniker_nn_1 = mkN "bilmekaniker" "bilmekanikern" "bilmekaniker" "bilmekanikerna" ;
  bilmotor_nn_1 = mkN "bilmotor" "bilmotorer" ;
  bilnummer_nn_1 = mkN "bilnummer" neutrum ;
  bilnyckel_nn_1 = mkN "bilnyckel" ;
  bilpark_nn_1 = mkN "bilpark" "bilparker" ;
  bilparkering_nn_1 = mkN "bilparkering" ;
  bilplaat_nn_1 = mkN "bilplеt" ;
  bilprovning_nn_1 = mkN "bilprovning" ;
  bilrally_nn_1 = mkN "bilrally" "bilrallyt" "bilrallyn" "bilrallyna" ;
  bilratt_nn_1 = mkN "bilratt" ;
  bilregister_nn_1 = mkN "bilregister" neutrum ;
  bilring_nn_1 = mkN "bilring" ;
  bilsaete_nn_1 = mkN "bilsдte" ;
  bilsjuk_av_1 = mkA "bilsjuk" ;
  bilskatt_nn_1 = mkN "bilskatt" "bilskatter" ;
  bilstoeld_nn_1 = mkN "bilstцld" "bilstцlder" ;
  biltaevling_nn_1 = mkN "biltдvling" ;
  biltak_nn_1 = mkN "biltak" neutrum ;
  biltelefon_nn_1 = mkN "biltelefon" "biltelefoner" ;
  biltog_av_1 = mkA "biltog" ;
  biltunnel_nn_1 = mkN "biltunnel" ;
  bilvaeg_nn_1 = mkN "bilvдg" ;
  bilverkstad_nn_1 = mkN "bilverkstad" "bilverkstдder" ;
  bimaane_nn_1 = mkN "bimеne" utrum ;
  bimetall_nn_1 = mkN "bimetall" "bimetaller" ;
  binaer_av_1 = mkA "binдr" ;
  binaering_nn_1 = mkN "binдring" ;
  binamn_nn_1 = mkN "binamn" neutrum ;
  bind_nn_1 = mkN "bind" neutrum ;
  binda_vb_1 = mkV "binda" "band" "bundit" ;
  bindaemne_nn_1 = mkN "bindдmne" ;
  bindande_av_1 = mkA "bindande" ;
  bindare_nn_1 = mkN "bindare" "bindare" ;
  bindbjaelke_nn_1 = mkN "bindbjдlke" utrum ;
  bindehinna_nn_1 = mkN "bindehinna" ;
  bindehinneinflammation_nn_1 = mkN "bindehinneinflammation" "bindehinneinflammationer" ;
  bindel_nn_1 = mkN "bindel" ;
  bindemedel_nn_1 = mkN "bindemedel" neutrum ;
  bindenyckel_nn_1 = mkN "bindenyckel" ;
  bindeord_nn_1 = mkN "bindeord" neutrum ;
  binderi_nn_1 = mkN "binderi" "binderit" "binderier" "binderierna" ;
  bindesaeck_nn_1 = mkN "bindesдck" ;
  bindestreck_nn_1 = mkN "bindestreck" neutrum ;
  bindesubstans_nn_1 = mkN "bindesubstans" "bindesubstanser" ;
  bindevokal_nn_1 = mkN "bindevokal" "bindevokaler" ;
  bindgalen_av_1 = mkA "bindgalen" "bindgalet" ;
  bindgarn_nn_1 = mkN "bindgarn" neutrum ;
  bindnaal_nn_1 = mkN "bindnеl" ;
  bindning_nn_1 = mkN "bindning" ;
  bindsten_nn_1 = mkN "bindsten" "bindstenen" "bindstenar" "bindstenarna" ;
  bindvaev_nn_1 = mkN "bindvдv" ;
  bindvaevshinna_nn_1 = mkN "bindvдvshinna" ;
  bindvaevskapsel_nn_1 = mkN "bindvдvskapsel" ;
  bindvaevssaeck_nn_1 = mkN "bindvдvssдck" ;
  bindvaevstraad_nn_1 = mkN "bindvдvstrеd" ;
  binge_nn_1 = mkN "binge" utrum ;
  bingel_nn_1 = mkN "bingel" ;
  binjure_nn_1 = mkN "binjure" utrum ;
  binnikemask_nn_1 = mkN "binnikemask" ;
  binokel_nn_1 = mkN "binokel" ;
  binokulaer_av_1 = mkA "binokulдr" ;
  binom_nn_1 = mkN "binom" neutrum ;
  biobesoek_nn_1 = mkN "biobesцk" neutrum ;
  biobiljett_nn_1 = mkN "biobiljett" "biobiljetter" ;
  biobraensle_nn_1 = mkN "biobrдnsle" ;
  biocid_nn_1 = mkN "biocid" "biocider" ;
  biodlare_nn_1 = mkN "biodlare" "biodlare" ;
  biodling_nn_1 = mkN "biodling" ;
  bioduk_nn_1 = mkN "bioduk" ;
  biodynamisk_av_1 = mkA "biodynamisk" ;
  biofoerestaellning_nn_1 = mkN "biofцrestдllning" ;
  biofysisk_av_1 = mkA "biofysisk" ;
  biogen_av_1 = mkA "biogen" ;
  biogenetisk_av_1 = mkA "biogenetisk" ;
  biograf_nn_1 = mkN "biograf" "biografer" ;
  biografbyraa_nn_1 = mkN "biografbyrе" "biografbyrеer" ;
  biografi_nn_1 = mkN "biografi" "biografier" ;
  biografisk_av_1 = mkA "biografisk" ;
  biograforgel_nn_1 = mkN "biograforgel" ;
  biografteater_nn_1 = mkN "biografteater" ;
  biokemisk_av_1 = mkA "biokemisk" ;
  biokemist_nn_1 = mkN "biokemist" "biokemister" ;
  biolog_nn_1 = mkN "biolog" "biologer" ;
  biologisk_av_1 = mkA "biologisk" ;
  biomstaendighet_nn_1 = mkN "biomstдndighet" "biomstдndigheter" ;
  biosfaer_nn_1 = mkN "biosfдr" "biosfдrer" ;
  bioteknik_nn_1 = mkN "bioteknik" "biotekniker" ;
  bioteknisk_av_1 = mkA "bioteknisk" ;
  biotisk_av_1 = mkA "biotisk" ;
  biotop_nn_1 = mkN "biotop" "biotoper" ;
  biotyp_nn_1 = mkN "biotyp" "biotyper" ;
  biperson_nn_1 = mkN "biperson" "bipersoner" ;
  biplan_nn_1 = mkN "biplan" neutrum ;
  biplanet_nn_1 = mkN "biplanet" "biplaneter" ;
  bipolaer_av_1 = mkA "bipolдr" ;
  bipolaritet_nn_1 = mkN "bipolaritet" "bipolariteter" ;
  biprodukt_nn_1 = mkN "biprodukt" "biprodukter" ;
  birem_nn_1 = mkN "birem" "biremer" ;
  birfilare_nn_1 = mkN "birfilare" "birfilare" ;
  biroll_nn_1 = mkN "biroll" "biroller" ;
  birot_nn_1 = mkN "birot" "birцtter" ;
  bisaettning_nn_1 = mkN "bisдttning" ;
  bisak_nn_1 = mkN "bisak" "bisaker" ;
  bisamhaelle_nn_1 = mkN "bisamhдlle" ;
  bisamoxe_nn_1 = mkN "bisamoxe" utrum ;
  bisamsvin_nn_1 = mkN "bisamsvin" neutrum ;
  bisarr_av_1 = mkA "bisarr" ;
  bisarreri_nn_1 = mkN "bisarreri" "bisarrerit" "bisarrerier" "bisarrerierna" ;
  bisats_nn_1 = mkN "bisats" "bisatser" ;
  bisatsordfoeljd_nn_1 = mkN "bisatsordfцljd" "bisatsordfцljder" ;
  bisektris_nn_1 = mkN "bisektris" "bisektriser" ;
  bisexualitet_nn_1 = mkN "bisexualitet" "bisexualiteter" ;
  bisexuell_av_1 = mkA "bisexuell" ;
  bisittare_nn_1 = mkN "bisittare" "bisittare" ;
  biskoeldkoertel_nn_1 = mkN "biskцldkцrtel" ;
  biskop_nn_1 = mkN "biskop" ;
  biskoplig_av_1 = mkA "biskoplig" ;
  biskopsdoeme_nn_1 = mkN "biskopsdцme" ;
  biskopskors_nn_1 = mkN "biskopskors" neutrum ;
  biskopsmoete_nn_1 = mkN "biskopsmцte" ;
  biskopsskrud_nn_1 = mkN "biskopsskrud" ;
  biskopsstav_nn_1 = mkN "biskopsstav" ;
  biskopsvisitation_nn_1 = mkN "biskopsvisitation" "biskopsvisitationer" ;
  biskvi_nn_1 = mkN "biskvi" "biskvier" ;
  bismak_nn_1 = mkN "bismak" "bismaker" ;
  bisol_nn_1 = mkN "bisol" ;
  bisonoxe_nn_1 = mkN "bisonoxe" utrum ;
  bisp_nn_1 = mkN "bisp" ;
  bispringa_vb_1 = mkV "bispringa" "bisprang" "bisprungit" ;
  bistaandsland_nn_1 = mkN "bistеndsland" "bistеndslandet" "bistеndslдnder" "bistеndslдnderna" ;
  bistaandsorgan_nn_1 = mkN "bistеndsorgan" neutrum ;
  bistaandsprogram_nn_1 = mkN "bistеndsprogram" "bistеndsprogrammet" "bistеndsprogram" "bistеndsprogrammen" ;
  bister_av_1 = mkA "bister" "bistert" "bistra" "bistra" "bistrare" "bistrast" "bistraste" ;
  bistick_nn_1 = mkN "bistick" neutrum ;
  bisting_nn_1 = mkN "bisting" neutrum ;
  bistock_nn_1 = mkN "bistock" ;
  bistro_nn_1 = mkN "bistro" "bistron" "bistroer" "bistroerna" ;
  bisturi_nn_1 = mkN "bisturi" "bisturier" ;
  bistyng_nn_1 = mkN "bistyng" neutrum ;
  bisvaerm_nn_1 = mkN "bisvдrm" ;
  bisyssla_nn_1 = mkN "bisyssla" ;
  bit_nn_1 = mkN "bit" ;
  bit_nn_2 = mkN "bit" ;
  bita_vb_1 = mkV "bita" "bet" "bitit" ;
  bitande_av_1 = mkA "bitande" ;
  bitanke_nn_1 = mkN "bitanke" utrum ;
  bitecken_nn_1 = mkN "bitecken" "bitecknet" "bitecken" "bitecknen" ;
  biten_av_1 = mkA "biten" "bitet" ;
  bitestikel_nn_1 = mkN "bitestikel" ;
  biton_nn_1 = mkN "biton" "bitoner" ;
  bitraedande_av_1 = mkA "bitrдdande" ;
  bitraede_nn_1 = mkN "bitrдde" ;
  bitsk_av_1 = mkA "bitsk" ;
  bitter_av_1 = mkA "bitter" "bittert" "bittra" "bittra" "bittrare" "bittrast" "bittraste" ;
  bitterhet_nn_1 = mkN "bitterhet" "bitterheter" ;
  bitterkall_av_1 = mkA "bitterkall" ;
  bitterligen_ab_1 = mkAdv "bitterligen" ;
  bitterljuv_av_1 = mkA "bitterljuv" ;
  bittermandel_nn_1 = mkN "bittermandel" ;
  bittersalt_av_1 = mkA "bittersalt" "bittersalt" ;
  bittersoet_av_1 = mkA "bittersцt" ;
  bittersta_av_1 = mkA "bittersta" ;
  bittida_ab_1 = mkAdv "bittida" ;
  bituminoes_av_1 = mkA "bituminцs" ;
  bitvarg_nn_1 = mkN "bitvarg" ;
  bitvis_ab_1 = mkAdv "bitvis" ;
  bivack_nn_1 = mkN "bivack" "bivacker" ;
  bivaeg_nn_1 = mkN "bivдg" ;
  bivax_nn_1 = mkN "bivax" "bivaxet" "bivaxer" "bivaxerna" ;
  biverkning_nn_1 = mkN "biverkning" ;
  bivraak_nn_1 = mkN "bivrеk" ;
  biyngel_nn_1 = mkN "biyngel" neutrum ;
  bjaebbig_av_1 = mkA "bjдbbig" ;
  bjaebbighet_nn_1 = mkN "bjдbbighet" "bjдbbigheter" ;
  bjaelke_nn_1 = mkN "bjдlke" utrum ;
  bjaelkhuvud_nn_1 = mkN "bjдlkhuvud" "bjдlkhuvudet" "bjдlkhuvuden" "bjдlkhuvudena" ;
  bjaelklag_nn_1 = mkN "bjдlklag" neutrum ;
  bjaelkverk_nn_1 = mkN "bjдlkverk" neutrum ;
  bjaellko_nn_1 = mkN "bjдllko" "bjдllkor" ;
  bjaert_av_1 = mkA "bjдrt" "bjдrt" ;
  bjaesse_nn_1 = mkN "bjдsse" utrum ;
  bjoerk_nn_1 = mkN "bjцrk" ;
  bjoerkblad_nn_1 = mkN "bjцrkblad" neutrum ;
  bjoerkloev_nn_1 = mkN "bjцrklцv" neutrum ;
  bjoerknaever_nn_1 = mkN "bjцrknдver" ;
  bjoerkregion_nn_1 = mkN "bjцrkregion" "bjцrkregioner" ;
  bjoerkris_nn_1 = mkN "bjцrkris" neutrum ;
  bjoerksopp_nn_1 = mkN "bjцrksopp" ;
  bjoerktrast_nn_1 = mkN "bjцrktrast" ;
  bjoern_nn_1 = mkN "bjцrn" ;
  bjoernbaer_nn_1 = mkN "bjцrnbдr" neutrum ;
  bjoernbaersbuske_nn_1 = mkN "bjцrnbдrsbuske" utrum ;
  bjoernbindsle_nn_1 = mkN "bjцrnbindsle" ;
  bjoernhallon_nn_1 = mkN "bjцrnhallon" neutrum ;
  bjoernhund_nn_1 = mkN "bjцrnhund" ;
  bjoerninna_nn_1 = mkN "bjцrninna" ;
  bjoernjakt_nn_1 = mkN "bjцrnjakt" "bjцrnjakter" ;
  bjoernliknande_av_1 = mkA "bjцrnliknande" ;
  bjoernram_nn_1 = mkN "bjцrnram" ;
  bjoernskall_nn_1 = mkN "bjцrnskall" neutrum ;
  bjoernskinn_nn_1 = mkN "bjцrnskinn" neutrum ;
  bjoerntjaenst_nn_1 = mkN "bjцrntjдnst" "bjцrntjдnster" ;
  bjuda_vb_1 = mkV "bjuda" "bjцd" "bjudit" ;
  bjudcigarr_nn_1 = mkN "bjudcigarr" "bjudcigarrer" ;
  bjudning_nn_1 = mkN "bjudning" ;
  blaa_av_1 = mkA "blе" "blеtt" ;
  blaaaktig_av_1 = mkA "blеaktig" ;
  blaaanlupen_av_1 = mkA "blеanlupen" "blеanlupet" ;
  blaabaer_nn_1 = mkN "blеbдr" neutrum ;
  blaabaersris_nn_1 = mkN "blеbдrsris" neutrum ;
  blaablodig_av_1 = mkA "blеblodig" ;
  blaadaare_nn_1 = mkN "blеdеre" utrum ;
  blaafoerskjutning_nn_1 = mkN "blеfцrskjutning" ;
  blaafrusen_av_1 = mkA "blеfrusen" "blеfruset" ;
  blaagroen_av_1 = mkA "blеgrцn" ;
  blaagroenalg_nn_1 = mkN "blеgrцnalg" "blеgrцnalger" ;
  blaagul_av_1 = mkA "blеgul" ;
  blaahaj_nn_1 = mkN "blеhaj" ;
  blaahake_nn_1 = mkN "blеhake" utrum ;
  blaahallon_nn_1 = mkN "blеhallon" neutrum ;
  blaahjon_nn_1 = mkN "blеhjon" neutrum ;
  blaaklint_nn_1 = mkN "blеklint" ;
  blaakopia_nn_1 = mkN "blеkopia" ;
  blaalusern_nn_1 = mkN "blеlusern" "blеluserner" ;
  blaamaerke_nn_1 = mkN "blеmдrke" ;
  blaames_nn_1 = mkN "blеmes" ;
  blaamusseron_nn_1 = mkN "blеmusseron" "blеmusseroner" ;
  blaamussla_nn_1 = mkN "blеmussla" ;
  blaanad_nn_1 = mkN "blеnad" "blеnader" ;
  blaaoegd_av_1 = mkA "blецgd" "blецgt" ;
  blaaraev_nn_1 = mkN "blеrдv" ;
  blaaroed_av_1 = mkA "blеrцd" ;
  blaasare_nn_1 = mkN "blеsare" "blеsare" ;
  blaasbaelg_nn_1 = mkN "blеsbдlg" ;
  blaasfoting_nn_1 = mkN "blеsfoting" ;
  blaashaal_nn_1 = mkN "blеshеl" neutrum ;
  blaashals_nn_1 = mkN "blеshals" ;
  blaasig_av_1 = mkA "blеsig" ;
  blaasinstrument_nn_1 = mkN "blеsinstrument" neutrum ;
  blaaskatarr_nn_1 = mkN "blеskatarr" "blеskatarrer" ;
  blaasljud_nn_1 = mkN "blеsljud" neutrum ;
  blaasmask_nn_1 = mkN "blеsmask" ;
  blaasning_nn_1 = mkN "blеsning" ;
  blaasorkester_nn_1 = mkN "blеsorkester" ;
  blaasroer_nn_1 = mkN "blеsrцr" neutrum ;
  blaassten_nn_1 = mkN "blеssten" "blеsstenen" "blеsstenar" "blеsstenarna" ;
  blaastaell_nn_1 = mkN "blеstдll" neutrum ;
  blaasur_av_1 = mkA "blеsur" ;
  blaaval_nn_1 = mkN "blеval" ;
  blaavinge_nn_1 = mkN "blеvinge" utrum ;
  blaaviolett_av_1 = mkA "blеviolett" ;
  blaavit_av_1 = mkA "blеvit" ;
  blaavitling_nn_1 = mkN "blеvitling" ;
  black_av_1 = mkA "black" ;
  black_nn_1 = mkN "black" ;
  blackig_av_1 = mkA "blackig" ;
  blackout_nn_1 = mkN "blackout" "blackouter" ;
  blad_nn_1 = mkN "blad" neutrum ;
  bladbagge_nn_1 = mkN "bladbagge" utrum ;
  bladfot_nn_1 = mkN "bladfot" "bladfцtter" ;
  bladfoting_nn_1 = mkN "bladfoting" ;
  bladkrans_nn_1 = mkN "bladkrans" ;
  bladlus_nn_1 = mkN "bladlus" "bladlusen" "bladlцss" "bladlцssen" ;
  bladmage_nn_1 = mkN "bladmage" utrum ;
  bladminerare_nn_1 = mkN "bladminerare" "bladminerare" ;
  bladstaellning_nn_1 = mkN "bladstдllning" ;
  bladstekel_nn_1 = mkN "bladstekel" ;
  blaeckfisk_nn_1 = mkN "blдckfisk" ;
  blaeckhorn_nn_1 = mkN "blдckhorn" neutrum ;
  blaeckkoertel_nn_1 = mkN "blдckkцrtel" ;
  blaeckplump_nn_1 = mkN "blдckplump" ;
  blaecksaeck_nn_1 = mkN "blдcksдck" ;
  blaecksuddare_nn_1 = mkN "blдcksuddare" "blдcksuddare" ;
  blaecksvamp_nn_1 = mkN "blдcksvamp" ;
  blaedderblock_nn_1 = mkN "blдdderblock" neutrum ;
  blaedderbok_nn_1 = mkN "blдdderbok" "blдdderbцcker" ;
  blaendare_nn_1 = mkN "blдndare" "blдndare" ;
  blaende_nn_1 = mkN "blдnde" ;
  blaendfri_av_1 = mkA "blдndfri" "blдndfritt" ;
  blaendning_nn_1 = mkN "blдndning" ;
  blaendskydd_nn_1 = mkN "blдndskydd" neutrum ;
  blaendverk_nn_1 = mkN "blдndverk" neutrum ;
  blaendvit_av_1 = mkA "blдndvit" ;
  blaeng_nn_1 = mkN "blдng" ;
  blaenk_nn_1 = mkN "blдnk" ;
  blaenkare_nn_1 = mkN "blдnkare" "blдnkare" ;
  blaenkfyr_nn_1 = mkN "blдnkfyr" ;
  blaes_nn_1 = mkN "blдs" ;
  blaesand_nn_1 = mkN "blдsand" "blдsдnder" ;
  blaesbock_nn_1 = mkN "blдsbock" ;
  blaesgaas_nn_1 = mkN "blдsgеs" "blдsgеsen" "blдsgдss" "blдsgдssen" ;
  blaester_nn_1 = mkN "blдster" ;
  blaesterroer_nn_1 = mkN "blдsterrцr" neutrum ;
  blaesterugn_nn_1 = mkN "blдsterugn" ;
  blam_nn_1 = mkN "blam" "blamer" ;
  blamage_nn_1 = mkN "blamage" "blamager" ;
  blamant_av_1 = mkA "blamant" "blamant" ;
  blancmange_nn_1 = mkN "blancmangй" "blancmangйer" ;
  blandaektenskap_nn_1 = mkN "blandдktenskap" "blandдktenskapet" "blandдktenskapen" "blandдktenskapena" ;
  blandare_nn_1 = mkN "blandare" "blandare" ;
  blandekonomi_nn_1 = mkN "blandekonomi" "blandekonomier" ;
  blandfaerg_nn_1 = mkN "blandfдrg" "blandfдrger" ;
  blandform_nn_1 = mkN "blandform" "blandformer" ;
  blandning_nn_1 = mkN "blandning" ;
  blandningsfoerhaallande_nn_1 = mkN "blandningsfцrhеllande" ;
  blandningskran_nn_1 = mkN "blandningskran" ;
  blandras_nn_1 = mkN "blandras" "blandraser" ;
  blandskog_nn_1 = mkN "blandskog" ;
  blandspraak_nn_1 = mkN "blandsprеk" neutrum ;
  blandtyp_nn_1 = mkN "blandtyp" "blandtyper" ;
  blank_av_1 = mkA "blank" ;
  blankaal_nn_1 = mkN "blankеl" ;
  blankborste_nn_1 = mkN "blankborste" utrum ;
  blankett_nn_1 = mkN "blankett" "blanketter" ;
  blankettskaap_nn_1 = mkN "blankettskеp" neutrum ;
  blanklax_nn_1 = mkN "blanklax" ;
  blankoaccept_nn_1 = mkN "blankoaccept" "blankoaccepter" ;
  blankocheck_nn_1 = mkN "blankocheck" ;
  blankofoersaeljning_nn_1 = mkN "blankofцrsдljning" ;
  blankofullmakt_nn_1 = mkN "blankofullmakt" "blankofullmakter" ;
  blankokredit_nn_1 = mkN "blankokredit" "blankokrediter" ;
  blankotransport_nn_1 = mkN "blankotransport" "blankotransporter" ;
  blankovaexel_nn_1 = mkN "blankovдxel" ;
  blanksej_nn_1 = mkN "blanksej" ;
  blanksliten_av_1 = mkA "blanksliten" "blankslitet" ;
  blanksmoerja_nn_1 = mkN "blanksmцrja" ;
  blankvatten_nn_1 = mkN "blankvatten" "blankvattnet" "blankvatten" "blankvattnen" ;
  blase_av_1 = mkA "blasй" ;
  blasfemi_nn_1 = mkN "blasfemi" "blasfemier" ;
  blasfemisk_av_1 = mkA "blasfemisk" ;
  blaskig_av_1 = mkA "blaskig" ;
  blasonering_nn_1 = mkN "blasonering" ;
  blatte_nn_1 = mkN "blatte" utrum ;
  blazer_nn_1 = mkN "blazer" ;
  bleck_nn_1 = mkN "bleck" neutrum ;
  bleckblaasinstrument_nn_1 = mkN "bleckblеsinstrument" neutrum ;
  bleckburk_nn_1 = mkN "bleckburk" ;
  bleckplaat_nn_1 = mkN "bleckplеt" ;
  bleckslagare_nn_1 = mkN "bleckslagare" "bleckslagare" ;
  bleckslageri_nn_1 = mkN "bleckslageri" "bleckslagerit" "bleckslagerier" "bleckslagerierna" ;
  blek_av_1 = mkA "blek" ;
  blekeri_nn_1 = mkN "blekeri" "blekerit" "blekerier" "blekerierna" ;
  blekfet_av_1 = mkA "blekfet" ;
  blekhet_nn_1 = mkN "blekhet" "blekheter" ;
  bleking_nn_1 = mkN "bleking" ;
  blekingsk_av_1 = mkA "blekingsk" ;
  bleklagd_av_1 = mkA "bleklagd" "bleklagt" ;
  blekmedel_nn_1 = mkN "blekmedel" neutrum ;
  bleknos_nn_1 = mkN "bleknos" ;
  bleksiktig_av_1 = mkA "bleksiktig" ;
  blekvaetska_nn_1 = mkN "blekvдtska" ;
  blessyr_nn_1 = mkN "blessyr" "blessyrer" ;
  blick_nn_1 = mkN "blick" ;
  blickfaang_nn_1 = mkN "blickfеng" neutrum ;
  blickfaelt_nn_1 = mkN "blickfдlt" neutrum ;
  blickstilla_av_1 = mkA "blickstilla" ;
  blid_av_1 = mkA "blid" ;
  blidgrad_nn_1 = mkN "blidgrad" "blidgrader" ;
  blidvinter_nn_1 = mkN "blidvinter" ;
  blind_av_1 = mkA "blind" ;
  blindalfabet_nn_1 = mkN "blindalfabet" neutrum ;
  blindbock_nn_1 = mkN "blindbock" ;
  blindbotten_nn_1 = mkN "blindbotten" ;
  blindbroms_nn_1 = mkN "blindbroms" ;
  blinddoerr_nn_1 = mkN "blinddцrr" ;
  blindering_nn_1 = mkN "blindering" ;
  blindfoenster_nn_1 = mkN "blindfцnster" neutrum ;
  blindgaangare_nn_1 = mkN "blindgеngare" "blindgеngare" ;
  blindhund_nn_1 = mkN "blindhund" ;
  blindlandning_nn_1 = mkN "blindlandning" ;
  blindnaessla_nn_1 = mkN "blindnдssla" ;
  blindparti_nn_1 = mkN "blindparti" "blindpartit" "blindpartier" "blindpartierna" ;
  blindpassagerare_nn_1 = mkN "blindpassagerare" "blindpassagerare" ;
  blindpatron_nn_1 = mkN "blindpatron" "blindpatroner" ;
  blindpressning_nn_1 = mkN "blindpressning" ;
  blindraa_nn_1 = mkN "blindrе" "blindrеn" "blindrеr" "blindrеrna" ;
  blindrote_nn_1 = mkN "blindrote" utrum ;
  blindskaer_nn_1 = mkN "blindskдr" neutrum ;
  blindspaar_nn_1 = mkN "blindspеr" neutrum ;
  blindstyre_nn_1 = mkN "blindstyre" ;
  blindtarm_nn_1 = mkN "blindtarm" ;
  blindtarmsinflammation_nn_1 = mkN "blindtarmsinflammation" "blindtarmsinflammationer" ;
  blindtryck_nn_1 = mkN "blindtryck" neutrum ;
  blini_nn_1 = mkN "blini" "blinier" ;
  blink_nn_1 = mkN "blink" ;
  blinker_nn_1 = mkN "blinker" ;
  blinkfyr_nn_1 = mkN "blinkfyr" ;
  blinkhinna_nn_1 = mkN "blinkhinna" ;
  blinkljus_nn_1 = mkN "blinkljus" neutrum ;
  blinning_nn_1 = mkN "blinning" ;
  blip_nn_1 = mkN "blip" ;
  blivande_av_1 = mkA "blivande" ;
  blixt_nn_1 = mkN "blixt" ;
  blixtanfall_nn_1 = mkN "blixtanfall" neutrum ;
  blixtbesoek_nn_1 = mkN "blixtbesцk" neutrum ;
  blixtfoto_nn_1 = mkN "blixtfoto" "blixtfotot" "blixtfoton" "blixtfotona" ;
  blixtfyr_nn_1 = mkN "blixtfyr" ;
  blixtkrig_nn_1 = mkN "blixtkrig" neutrum ;
  blixtlaas_nn_1 = mkN "blixtlеs" neutrum ;
  blixtnedslag_nn_1 = mkN "blixtnedslag" neutrum ;
  blixtpatron_nn_1 = mkN "blixtpatron" "blixtpatroner" ;
  blixtrande_av_1 = mkA "blixtrande" ;
  blixtsamtal_nn_1 = mkN "blixtsamtal" "blixtsamtalet" "blixtsamtalen" "blixtsamtalena" ;
  blixtsnabb_av_1 = mkA "blixtsnabb" ;
  blixtvisit_nn_1 = mkN "blixtvisit" "blixtvisiter" ;
  block_nn_1 = mkN "block" neutrum ;
  blockad_nn_1 = mkN "blockad" "blockader" ;
  blockadbrott_nn_1 = mkN "blockadbrott" neutrum ;
  blockadbrytare_nn_1 = mkN "blockadbrytare" "blockadbrytare" ;
  blockaemne_nn_1 = mkN "blockдmne" ;
  blockbildning_nn_1 = mkN "blockbildning" ;
  blockdiagram_nn_1 = mkN "blockdiagram" "blockdiagrammet" "blockdiagram" "blockdiagrammen" ;
  blockering_nn_1 = mkN "blockering" ;
  blockfloejt_nn_1 = mkN "blockflцjt" "blockflцjter" ;
  blockgraens_nn_1 = mkN "blockgrдns" "blockgrдnser" ;
  blockhus_nn_1 = mkN "blockhus" neutrum ;
  blockig_av_1 = mkA "blockig" ;
  blocksignal_nn_1 = mkN "blocksignal" "blocksignaler" ;
  blocksystem_nn_1 = mkN "blocksystem" neutrum ;
  blocktalja_nn_1 = mkN "blocktalja" ;
  blocktyg_nn_1 = mkN "blocktyg" neutrum ;
  blockvagn_nn_1 = mkN "blockvagn" ;
  blodaader_nn_1 = mkN "blodеder" "blodеdern" "blodеdror" "blodеdrorna" ;
  blodapelsin_nn_1 = mkN "blodapelsin" "blodapelsiner" ;
  blodbad_nn_1 = mkN "blodbad" neutrum ;
  blodbank_nn_1 = mkN "blodbank" "blodbanker" ;
  blodbok_nn_1 = mkN "blodbok" ;
  blodcell_nn_1 = mkN "blodcell" "blodceller" ;
  bloddrypande_av_1 = mkA "bloddrypande" ;
  blodfaergaemne_nn_1 = mkN "blodfдrgдmne" ;
  blodfattig_av_1 = mkA "blodfattig" ;
  blodflaeck_nn_1 = mkN "blodflдck" ;
  blodfloede_nn_1 = mkN "blodflцde" ;
  blodfoergiftning_nn_1 = mkN "blodfцrgiftning" ;
  blodfull_av_1 = mkA "blodfull" ;
  blodgivare_nn_1 = mkN "blodgivare" "blodgivare" ;
  blodgrupp_nn_1 = mkN "blodgrupp" "blodgrupper" ;
  blodhund_nn_1 = mkN "blodhund" ;
  blodig_av_1 = mkA "blodig" ;
  blodigel_nn_1 = mkN "blodigel" ;
  blodkaerl_nn_1 = mkN "blodkдrl" neutrum ;
  blodkorv_nn_1 = mkN "blodkorv" ;
  blodkraekning_nn_1 = mkN "blodkrдkning" ;
  blodkropp_nn_1 = mkN "blodkropp" ;
  blodledare_nn_1 = mkN "blodledare" "blodledare" ;
  blodloes_av_1 = mkA "blodlцs" ;
  blodoern_ab_1 = mkAdv "blodцrn" ;
  blodoeverfoering_nn_1 = mkN "blodцverfцring" ;
  blodoeverfyllnad_nn_1 = mkN "blodцverfyllnad" "blodцverfyllnader" ;
  blodpalt_nn_1 = mkN "blodpalt" ;
  blodplaett_nn_1 = mkN "blodplдtt" ;
  blodpropp_nn_1 = mkN "blodpropp" ;
  blodprotein_nn_1 = mkN "blodprotein" "blodproteinet" "blodproteiner" "blodproteinerna" ;
  blodprov_nn_1 = mkN "blodprov" neutrum ;
  blodpudding_nn_1 = mkN "blodpudding" ;
  blodrand_nn_1 = mkN "blodrand" "blodrдnder" ;
  blodroed_av_1 = mkA "blodrцd" ;
  blodsband_nn_1 = mkN "blodsband" neutrum ;
  blodsdaad_nn_1 = mkN "blodsdеd" neutrum ;
  blodsdroppe_nn_1 = mkN "blodsdroppe" utrum ;
  blodsjukdom_nn_1 = mkN "blodsjukdom" ;
  blodspenning_nn_1 = mkN "blodspenning" ;
  blodspottning_nn_1 = mkN "blodspottning" ;
  blodspraengd_av_1 = mkA "blodsprдngd" "blodsprдngt" ;
  blodstaenkt_av_1 = mkA "blodstдnkt" "blodstдnkt" ;
  blodstillande_av_1 = mkA "blodstillande" ;
  blodstinn_av_1 = mkA "blodstinn" "blodstint" ;
  blodstoertning_nn_1 = mkN "blodstцrtning" ;
  blodsugande_av_1 = mkA "blodsugande" ;
  blodsugare_nn_1 = mkN "blodsugare" "blodsugare" ;
  blodsutgjutelse_nn_1 = mkN "blodsutgjutelse" "blodsutgjutelser" ;
  blodsvulst_nn_1 = mkN "blodsvulst" "blodsvulster" ;
  blodsystem_nn_1 = mkN "blodsystem" neutrum ;
  blodtappning_nn_1 = mkN "blodtappning" ;
  blodtoerstig_av_1 = mkA "blodtцrstig" ;
  blodtransfusion_nn_1 = mkN "blodtransfusion" "blodtransfusioner" ;
  blodtryck_nn_1 = mkN "blodtryck" neutrum ;
  blodtyp_nn_1 = mkN "blodtyp" "blodtyper" ;
  blodvaerde_nn_1 = mkN "blodvдrde" ;
  blodvallning_nn_1 = mkN "blodvallning" ;
  blodvite_nn_1 = mkN "blodvite" ;
  bloedare_nn_1 = mkN "blцdare" "blцdare" ;
  bloedig_av_1 = mkA "blцdig" ;
  bloedighet_nn_1 = mkN "blцdighet" "blцdigheter" ;
  bloedning_nn_1 = mkN "blцdning" ;
  bloejbyte_nn_1 = mkN "blцjbyte" ;
  bloet_av_1 = mkA "blцt" ;
  bloetdjur_nn_1 = mkN "blцtdjur" neutrum ;
  bloetlaeggningsmedel_nn_1 = mkN "blцtlдggningsmedel" neutrum ;
  blogg_nn_1 = mkN "blogg" ;
  bloggare_nn_1 = mkN "bloggare" "bloggare" ;
  blomaxel_nn_1 = mkN "blomaxel" ;
  blombefruktning_nn_1 = mkN "blombefruktning" ;
  blomblad_nn_1 = mkN "blomblad" neutrum ;
  blombord_nn_1 = mkN "blombord" neutrum ;
  blombotten_nn_1 = mkN "blombotten" ;
  blombukett_nn_1 = mkN "blombukett" "blombuketter" ;
  blomdoft_nn_1 = mkN "blomdoft" "blomdofter" ;
  blomfat_nn_1 = mkN "blomfat" neutrum ;
  blomfjaell_nn_1 = mkN "blomfjдll" neutrum ;
  blomflock_nn_1 = mkN "blomflock" ;
  blomfoder_nn_1 = mkN "blomfoder" neutrum ;
  blomhoelster_nn_1 = mkN "blomhцlster" neutrum ;
  blomholk_nn_1 = mkN "blomholk" ;
  blomhuvud_nn_1 = mkN "blomhuvud" "blomhuvudet" "blomhuvuden" "blomhuvudena" ;
  blomkaalshuvud_nn_1 = mkN "blomkеlshuvud" "blomkеlshuvudet" "blomkеlshuvuden" "blomkеlshuvudena" ;
  blomkaalsoera_nn_1 = mkN "blomkеlsцra" "blomkеlsцrat" "blomkеlsцron" "blomkеlsцronen" ;
  blomkaalssvamp_nn_1 = mkN "blomkеlssvamp" ;
  blomkaepp_nn_1 = mkN "blomkдpp" ;
  blomkalk_nn_1 = mkN "blomkalk" ;
  blomklaedd_av_1 = mkA "blomklдdd" ;
  blomklase_nn_1 = mkN "blomklase" utrum ;
  blomknopp_nn_1 = mkN "blomknopp" ;
  blomkolv_nn_1 = mkN "blomkolv" ;
  blomkorg_nn_1 = mkN "blomkorg" ;
  blomkrans_nn_1 = mkN "blomkrans" ;
  blomkvast_nn_1 = mkN "blomkvast" ;
  blommig_av_1 = mkA "blommig" ;
  blommogram_nn_1 = mkN "blommogram" "blommogrammet" "blommogram" "blommogrammen" ;
  blomning_nn_1 = mkN "blomning" ;
  blomningstid_nn_1 = mkN "blomningstid" "blomningstider" ;
  blomskaft_nn_1 = mkN "blomskaft" neutrum ;
  blomstaellning_nn_1 = mkN "blomstдllning" ;
  blomster_nn_1 = mkN "blomster" neutrum ;
  blomsteraeng_nn_1 = mkN "blomsterдng" ;
  blomsteraffaer_nn_1 = mkN "blomsteraffдr" "blomsteraffдrer" ;
  blomsterbord_nn_1 = mkN "blomsterbord" neutrum ;
  blomsterfoermedling_nn_1 = mkN "blomsterfцrmedling" ;
  blomsterhandel_nn_1 = mkN "blomsterhandel" ;
  blomsterhandlare_nn_1 = mkN "blomsterhandlare" "blomsterhandlare" ;
  blomsterklaedd_av_1 = mkA "blomsterklдdd" ;
  blomsterkvast_nn_1 = mkN "blomsterkvast" ;
  blomsterloek_nn_1 = mkN "blomsterlцk" ;
  blomstermaanad_nn_1 = mkN "blomstermеnad" "blomstermеnader" ;
  blomstertraedgaard_nn_1 = mkN "blomstertrдdgеrd" ;
  blomsteruppsats_nn_1 = mkN "blomsteruppsats" "blomsteruppsatser" ;
  blomstervas_nn_1 = mkN "blomstervas" "blomstervaser" ;
  blomstjaelk_nn_1 = mkN "blomstjдlk" ;
  blomstringstid_nn_1 = mkN "blomstringstid" "blomstringstider" ;
  blomvaext_nn_1 = mkN "blomvдxt" "blomvдxter" ;
  blomvas_nn_1 = mkN "blomvas" "blomvaser" ;
  blond_av_1 = mkA "blond" ;
  blond_nn_1 = mkN "blond" "blonder" ;
  blondin_nn_1 = mkN "blondin" "blondiner" ;
  bloss_nn_1 = mkN "bloss" neutrum ;
  blot_nn_1 = mkN "blot" neutrum ;
  blott_ab_1 = mkAdv "blott" ;
  blottare_nn_1 = mkN "blottare" "blottare" ;
  blottstaelld_av_1 = mkA "blottstдlld" "blottstдllt" ;
  bluff_nn_1 = mkN "bluff" ;
  bluffmakare_nn_1 = mkN "bluffmakare" "bluffmakare" ;
  blunder_nn_1 = mkN "blunder" ;
  blus_nn_1 = mkN "blus" ;
  blyacetat_nn_1 = mkN "blyacetat" neutrum ;
  blyackumulator_nn_1 = mkN "blyackumulator" "blyackumulatorer" ;
  blyazid_nn_1 = mkN "blyazid" "blyazider" ;
  blybatteri_nn_1 = mkN "blybatteri" "blybatterit" "blybatterier" "blybatterierna" ;
  blydagg_nn_1 = mkN "blydagg" ;
  blyerts_nn_1 = mkN "blyerts" ;
  blyfaerg_nn_1 = mkN "blyfдrg" "blyfдrger" ;
  blyfoerening_nn_1 = mkN "blyfцrening" ;
  blyfoergiftning_nn_1 = mkN "blyfцrgiftning" ;
  blyfolie_nn_1 = mkN "blyfolie" "blyfolier" ;
  blyg_av_1 = mkA "blyg" ;
  blygdben_nn_1 = mkN "blygdben" neutrum ;
  blygdlaepp_nn_1 = mkN "blygdlдpp" ;
  blyghet_nn_1 = mkN "blyghet" "blygheter" ;
  blygraa_av_1 = mkA "blygrе" "blygrеtt" ;
  blygsam_av_1 = mkA "blygsam" "blygsamt" "blygsamma" "blygsamma" "blygsammare" "blygsammast" "blygsammaste" ;
  blygsamhet_nn_1 = mkN "blygsamhet" "blygsamheter" ;
  blyhalt_nn_1 = mkN "blyhalt" "blyhalter" ;
  blyhaltig_av_1 = mkA "blyhaltig" ;
  blykoel_nn_1 = mkN "blykцl" ;
  blymantel_nn_1 = mkN "blymantel" ;
  blyoxid_nn_1 = mkN "blyoxid" "blyoxider" ;
  blytung_av_1 = mkA "blytung" ;
  bo_nn_1 = mkN "bo" "bot" "bon" "boen" ;
  boaegg_nn_1 = mkN "boдgg" neutrum ;
  boaorm_nn_1 = mkN "boaorm" ;
  boardingcard_nn_1 = mkN "boardingcard" neutrum ;
  bob_nn_1 = mkN "bob" "bobben" "bobbar" "bobbarna" ;
  bobin_nn_1 = mkN "bobin" "bobiner" ;
  bobsleigh_nn_1 = mkN "bobsleigh" ;
  bock_nn_1 = mkN "bock" ;
  bockbent_av_1 = mkA "bockbent" "bockbent" ;
  bockblad_nn_1 = mkN "bockblad" neutrum ;
  bockbro_nn_1 = mkN "bockbro" ;
  bockfot_nn_1 = mkN "bockfot" "bockfцtter" ;
  bockhorn_nn_1 = mkN "bockhorn" neutrum ;
  bockning_nn_1 = mkN "bockning" ;
  bockprov_nn_1 = mkN "bockprov" neutrum ;
  bockskaegg_nn_1 = mkN "bockskдgg" neutrum ;
  bod_nn_1 = mkN "bod" ;
  bodbetjaent_nn_1 = mkN "bodbetjдnt" "bodbetjдnter" ;
  bodelning_nn_1 = mkN "bodelning" ;
  bodknodd_nn_1 = mkN "bodknodd" ;
  bodmeri_nn_1 = mkN "bodmeri" "bodmerit" "bodmerier" "bodmerierna" ;
  boeckling_nn_1 = mkN "bцckling" ;
  boedel_nn_1 = mkN "bцdel" ;
  boedelsdraeng_nn_1 = mkN "bцdelsdrдng" ;
  boeg_nn_1 = mkN "bцg" ;
  boehmare_nn_1 = mkN "bцhmare" "bцhmare" ;
  boehmisk_av_1 = mkA "bцhmisk" ;
  boej_nn_1 = mkN "bцj" ;
  boejare_nn_1 = mkN "bцjare" "bцjare" ;
  boejarmuskel_nn_1 = mkN "bцjarmuskel" "bцjarmuskeln" "bцjarmuskler" "bцjarmusklerna" ;
  boejbar_av_1 = mkA "bцjbar" ;
  boejd_av_1 = mkA "bцjd" "bцjt" ;
  boejelse_nn_1 = mkN "bцjelse" "bцjelser" ;
  boejhaallfasthet_nn_1 = mkN "bцjhеllfasthet" "bцjhеllfastheter" ;
  boejlig_av_1 = mkA "bцjlig" ;
  boejmuskel_nn_1 = mkN "bцjmuskel" "bцjmuskeln" "bцjmuskler" "bцjmusklerna" ;
  boejning_nn_1 = mkN "bцjning" ;
  boejningsaendelse_nn_1 = mkN "bцjningsдndelse" "bцjningsдndelser" ;
  boejningsform_nn_1 = mkN "bцjningsform" "bцjningsformer" ;
  boejningsmoenster_nn_1 = mkN "bцjningsmцnster" neutrum ;
  boejprov_nn_1 = mkN "bцjprov" neutrum ;
  boekig_av_1 = mkA "bцkig" ;
  boeld_nn_1 = mkN "bцld" "bцlder" ;
  boelja_nn_1 = mkN "bцlja" ;
  boeljegaang_nn_1 = mkN "bцljegеng" ;
  boeljeslag_nn_1 = mkN "bцljeslag" neutrum ;
  boeljeslagsmaerke_nn_1 = mkN "bцljeslagsmдrke" ;
  boen_nn_1 = mkN "bцn" "bцner" ;
  boenbok_nn_1 = mkN "bцnbok" "bцnbцcker" ;
  boendag_nn_1 = mkN "bцndag" ;
  boende_nn_1 = mkN "boende" ;
  boende_nn_2 = mkN "boende" "boenden" "boende" "boendena" ;
  boendeform_nn_1 = mkN "boendeform" "boendeformer" ;
  boendekostnad_nn_1 = mkN "boendekostnad" "boendekostnader" ;
  boenegudstjaenst_nn_1 = mkN "bцnegudstjдnst" "bцnegudstjдnster" ;
  boenehus_nn_1 = mkN "bцnehus" neutrum ;
  boeneman_nn_1 = mkN "bцneman" "bцnemannen" "bцnemдn" "bцnemдnnen" ;
  boenemoete_nn_1 = mkN "bцnemцte" ;
  boeneskrift_nn_1 = mkN "bцneskrift" "bцneskrifter" ;
  boenfalla_vb_1 = mkV "bцnfalla" "bцnfцll" "bцnfallit" ;
  boenformig_av_1 = mkA "bцnformig" ;
  boenhas_nn_1 = mkN "bцnhas" ;
  boenhoerelse_nn_1 = mkN "bцnhцrelse" "bцnhцrelser" ;
  boenpall_nn_1 = mkN "bцnpall" ;
  boenvaext_nn_1 = mkN "bцnvдxt" "bцnvдxter" ;
  boer_nn_1 = mkN "boer" "boern" "boer" "boerna" ;
  boerda_nn_1 = mkN "bцrda" ;
  boerdig_av_1 = mkA "bцrdig" ;
  boerdsstolt_av_1 = mkA "bцrdsstolt" "bцrdsstolt" ;
  boers_nn_1 = mkN "bцrs" ;
  boers_nn_2 = mkN "bцrs" "bцrser" ;
  boersjobbare_nn_1 = mkN "bцrsjobbare" "bцrsjobbare" ;
  boerskurs_nn_1 = mkN "bцrskurs" "bцrskurser" ;
  boersmaeklare_nn_1 = mkN "bцrsmдklare" "bцrsmдklare" ;
  boersnotering_nn_1 = mkN "bцrsnotering" ;
  boersspekulant_nn_1 = mkN "bцrsspekulant" "bцrsspekulanter" ;
  boersspekulation_nn_1 = mkN "bцrsspekulation" "bцrsspekulationer" ;
  boerting_nn_1 = mkN "bцrting" ;
  boesshaall_nn_1 = mkN "bцsshеll" neutrum ;
  boessinsamling_nn_1 = mkN "bцssinsamling" ;
  boett_nn_1 = mkN "boett" "boetter" ;
  boevel_nn_1 = mkN "bцvel" ;
  bofaellig_av_1 = mkA "bofдllig" ;
  bofast_av_1 = mkA "bofast" "bofast" ;
  bofink_nn_1 = mkN "bofink" ;
  bog_nn_1 = mkN "bog" ;
  bogankare_nn_1 = mkN "bogankare" "bogankaret" "bogankare" "bogankarna" ;
  bogblad_nn_1 = mkN "bogblad" neutrum ;
  bogbruten_av_1 = mkA "bogbruten" "bogbrutet" ;
  boggi_nn_1 = mkN "boggi" "boggin" "boggier" "boggierna" ;
  boghalt_av_1 = mkA "boghalt" "boghalt" ;
  boghoejd_nn_1 = mkN "boghцjd" "boghцjder" ;
  bogserare_nn_1 = mkN "bogserare" "bogserare" ;
  bogserbaat_nn_1 = mkN "bogserbеt" ;
  bogsergalge_nn_1 = mkN "bogsergalge" utrum ;
  bogsering_nn_1 = mkN "bogsering" ;
  bogserslaep_nn_1 = mkN "bogserslдp" neutrum ;
  bogsertross_nn_1 = mkN "bogsertross" ;
  bogsproet_nn_1 = mkN "bogsprцt" neutrum ;
  bohag_nn_1 = mkN "bohag" neutrum ;
  bohem_nn_1 = mkN "bohem" "bohemer" ;
  bohemisk_av_1 = mkA "bohemisk" ;
  bohuslaenning_nn_1 = mkN "bohuslдnning" ;
  bohuslaensk_av_1 = mkA "bohuslдnsk" ;
  boj_nn_1 = mkN "boj" ;
  boj_nn_2 = mkN "boj" "bojer" ;
  bojar_nn_1 = mkN "bojar" "bojarer" ;
  bojkott_nn_1 = mkN "bojkott" "bojkotter" ;
  bok_nn_1 = mkN "bok" "bцcker" ;
  bok_nn_2 = mkN "bok" ;
  bokanmaelan_nn_1 = mkN "bokanmдlan" "bokanmдlan" "bokanmдlningar" "bokanmдlningarna" ;
  bokauktion_nn_1 = mkN "bokauktion" "bokauktioner" ;
  bokband_nn_1 = mkN "bokband" neutrum ;
  bokbindare_nn_1 = mkN "bokbindare" "bokbindare" ;
  bokbinderi_nn_1 = mkN "bokbinderi" "bokbinderit" "bokbinderier" "bokbinderierna" ;
  bokbindning_nn_1 = mkN "bokbindning" ;
  bokbuss_nn_1 = mkN "bokbuss" ;
  boken_av_1 = mkA "boken" "boket" ;
  bokfilm_nn_1 = mkN "bokfilm" "bokfilmer" ;
  bokflod_nn_1 = mkN "bokflod" "bokfloder" ;
  bokfoering_nn_1 = mkN "bokfцring" ;
  bokfoeringsaar_nn_1 = mkN "bokfцringsеr" neutrum ;
  bokfoeringsmaessig_av_1 = mkA "bokfцringsmдssig" ;
  bokfoeringsskyldig_av_1 = mkA "bokfцringsskyldig" ;
  bokfoeringsskyldighet_nn_1 = mkN "bokfцringsskyldighet" "bokfцringsskyldigheter" ;
  bokfoerlaeggare_nn_1 = mkN "bokfцrlдggare" "bokfцrlдggare" ;
  bokfoerlag_nn_1 = mkN "bokfцrlag" neutrum ;
  bokformat_nn_1 = mkN "bokformat" neutrum ;
  bokhaallare_nn_1 = mkN "bokhеllare" "bokhеllare" ;
  bokhandel_nn_1 = mkN "bokhandel" ;
  bokhandlare_nn_1 = mkN "bokhandlare" "bokhandlare" ;
  bokklubb_nn_1 = mkN "bokklubb" ;
  boklaan_nn_1 = mkN "boklеn" neutrum ;
  boklaerd_av_1 = mkA "boklдrd" "boklдrt" ;
  boklig_av_1 = mkA "boklig" ;
  bokmaerke_nn_1 = mkN "bokmдrke" ;
  bokmagasin_nn_1 = mkN "bokmagasin" neutrum ;
  bokmal_nn_1 = mkN "bokmal" ;
  bokmarknad_nn_1 = mkN "bokmarknad" "bokmarknader" ;
  bokollon_nn_1 = mkN "bokollon" neutrum ;
  bokomslag_nn_1 = mkN "bokomslag" neutrum ;
  bokrulle_nn_1 = mkN "bokrulle" utrum ;
  bokrygg_nn_1 = mkN "bokrygg" ;
  boksamlare_nn_1 = mkN "boksamlare" "boksamlare" ;
  boksamling_nn_1 = mkN "boksamling" ;
  boksida_nn_1 = mkN "boksida" ;
  bokskog_nn_1 = mkN "bokskog" ;
  bokslut_nn_1 = mkN "bokslut" neutrum ;
  bokstav_nn_1 = mkN "bokstav" "bokstдver" ;
  bokstavlig_av_1 = mkA "bokstavlig" ;
  bokstavligen_ab_1 = mkAdv "bokstavligen" ;
  bokstavsbeteckning_nn_1 = mkN "bokstavsbeteckning" ;
  bokstavsfoeljd_nn_1 = mkN "bokstavsfцljd" "bokstavsfцljder" ;
  bokstavsordning_nn_1 = mkN "bokstavsordning" ;
  bokstavsrim_nn_1 = mkN "bokstavsrim" "bokstavsrimmet" "bokstavsrim" "bokstavsrimmen" ;
  bokstavstecken_nn_1 = mkN "bokstavstecken" "bokstavstecknet" "bokstavstecken" "bokstavstecknen" ;
  bokstavstrael_nn_1 = mkN "bokstavstrдl" ;
  bokstavstrogen_av_1 = mkA "bokstavstrogen" "bokstavstroget" ;
  bokstipendium_nn_1 = mkN "bokstipendium" "bokstipendiet" "bokstipendier" "bokstipendierna" ;
  bokstoed_nn_1 = mkN "bokstцd" neutrum ;
  boksynt_av_1 = mkA "boksynt" "boksynt" ;
  boktitel_nn_1 = mkN "boktitel" ;
  boktorn_nn_1 = mkN "boktorn" neutrum ;
  boktryckare_nn_1 = mkN "boktryckare" "boktryckare" ;
  boktryckeri_nn_1 = mkN "boktryckeri" "boktryckerit" "boktryckerier" "boktryckerierna" ;
  boktrycksstil_nn_1 = mkN "boktrycksstil" ;
  bokverk_nn_1 = mkN "bokverk" neutrum ;
  bol_nn_1 = mkN "bol" neutrum ;
  bolag_nn_1 = mkN "bolag" neutrum ;
  bolagsman_nn_1 = mkN "bolagsman" "bolagsmannen" "bolagsmдn" "bolagsmдnnen" ;
  bolagsordning_nn_1 = mkN "bolagsordning" ;
  bolagsskog_nn_1 = mkN "bolagsskog" ;
  bolagsstaemma_nn_1 = mkN "bolagsstдmma" ;
  bolagsstyrelse_nn_1 = mkN "bolagsstyrelse" "bolagsstyrelser" ;
  bolare_nn_1 = mkN "bolare" "bolare" ;
  bolero_nn_1 = mkN "bolero" "boleror" ;
  bolin_nn_1 = mkN "bolin" "boliner" ;
  bolivian_nn_1 = mkN "bolivian" "bolivianer" ;
  boliviansk_av_1 = mkA "boliviansk" ;
  boll_nn_1 = mkN "boll" ;
  bollkalle_nn_1 = mkN "bollkalle" utrum ;
  bollning_nn_1 = mkN "bollning" ;
  bollplan_nn_1 = mkN "bollplan" "bollplaner" ;
  bollpojke_nn_1 = mkN "bollpojke" utrum ;
  bollspel_nn_1 = mkN "bollspel" "bollspelet" "bollspel" "bollspelen" ;
  bollspelare_nn_1 = mkN "bollspelare" "bollspelare" ;
  bolltrae_nn_1 = mkN "bolltrд" "bolltrдet" "bolltrдn" "bolltrдna" ;
  bolmoertsskivling_nn_1 = mkN "bolmцrtsskivling" ;
  bolsjevik_nn_1 = mkN "bolsjevik" "bolsjeviker" ;
  bolsjevistisk_av_1 = mkA "bolsjevistisk" ;
  bolster_nn_1 = mkN "bolster" ;
  bolsterstock_nn_1 = mkN "bolsterstock" ;
  bolstervagn_nn_1 = mkN "bolstervagn" ;
  bolstervar_nn_1 = mkN "bolstervar" neutrum ;
  bom_nn_1 = mkN "bom" "bommen" "bommar" "bommarna" ;
  bomaerke_nn_1 = mkN "bomдrke" ;
  bomaterial_nn_1 = mkN "bomaterial" neutrum ;
  bomb_nn_1 = mkN "bomb" "bomber" ;
  bombanfall_nn_1 = mkN "bombanfall" neutrum ;
  bombardemang_nn_1 = mkN "bombardemang" neutrum ;
  bombare_nn_1 = mkN "bombare" "bombare" ;
  bombasm_nn_1 = mkN "bombasm" "bombasmer" ;
  bombastisk_av_1 = mkA "bombastisk" ;
  bombattentat_nn_1 = mkN "bombattentat" neutrum ;
  bombering_nn_1 = mkN "bombering" ;
  bombfast_av_1 = mkA "bombfast" "bombfast" ;
  bombkrater_nn_1 = mkN "bombkrater" ;
  bombnedslag_nn_1 = mkN "bombnedslag" neutrum ;
  bombning_nn_1 = mkN "bombning" ;
  bomboffer_nn_1 = mkN "bomboffer" neutrum ;
  bombplan_nn_1 = mkN "bombplan" neutrum ;
  bombraed_nn_1 = mkN "bombrдd" "bombrдder" ;
  bombsaeker_av_1 = mkA "bombsдker" "bombsдkert" "bombsдkra" "bombsдkra" "bombsдkrare" "bombsдkrast" "bombsдkraste" ;
  bomsadel_nn_1 = mkN "bomsadel" ;
  bomsegel_nn_1 = mkN "bomsegel" neutrum ;
  bomullsbal_nn_1 = mkN "bomullsbal" ;
  bomullsband_nn_1 = mkN "bomullsband" neutrum ;
  bomullsbuske_nn_1 = mkN "bomullsbuske" utrum ;
  bomullsflanell_nn_1 = mkN "bomullsflanell" "bomullsflaneller" ;
  bomullsfroe_nn_1 = mkN "bomullsfrц" "bomullsfrцt" "bomullsfrцn" "bomullsfrцen" ;
  bomullsplantage_nn_1 = mkN "bomullsplantage" "bomullsplantager" ;
  bomullstyg_nn_1 = mkN "bomullstyg" neutrum ;
  bomullsvaevnad_nn_1 = mkN "bomullsvдvnad" "bomullsvдvnader" ;
  bomullsvaext_nn_1 = mkN "bomullsvдxt" "bomullsvдxter" ;
  bonad_nn_1 = mkN "bonad" "bonader" ;
  bonbonjaer_nn_1 = mkN "bonbonjдr" "bonbonjдrer" ;
  bonddraeng_nn_1 = mkN "bonddrдng" ;
  bonddryg_av_1 = mkA "bonddryg" ;
  bonde_nn_1 = mkN "bonde" "bцnder" ;
  bondearme_nn_1 = mkN "bondearmй" "bondearmйer" ;
  bondebefolkning_nn_1 = mkN "bondebefolkning" ;
  bondefred_nn_1 = mkN "bondefred" "bondefreder" ;
  bondehaer_nn_1 = mkN "bondehдr" ;
  bondehemman_nn_1 = mkN "bondehemman" neutrum ;
  bondekultur_nn_1 = mkN "bondekultur" "bondekulturer" ;
  bondeskog_nn_1 = mkN "bondeskog" ;
  bondetaag_nn_1 = mkN "bondetеg" neutrum ;
  bondfaangare_nn_1 = mkN "bondfеngare" "bondfеngare" ;
  bondfamilj_nn_1 = mkN "bondfamilj" "bondfamiljer" ;
  bondfoersoek_nn_1 = mkN "bondfцrsцk" neutrum ;
  bondgaard_nn_1 = mkN "bondgеrd" ;
  bondhustru_nn_1 = mkN "bondhustru" "bondhustrun" "bondhustrur" "bondhustrurna" ;
  bondkomiker_nn_1 = mkN "bondkomiker" "bondkomikern" "bondkomiker" "bondkomikerna" ;
  bondpermission_nn_1 = mkN "bondpermission" "bondpermissioner" ;
  bondsk_av_1 = mkA "bondsk" ;
  bondslug_av_1 = mkA "bondslug" ;
  bong_nn_1 = mkN "bong" ;
  boning_nn_1 = mkN "boning" ;
  boningshus_nn_1 = mkN "boningshus" neutrum ;
  bonitering_nn_1 = mkN "bonitering" ;
  bonitet_nn_1 = mkN "bonitet" "boniteter" ;
  bonjour_nn_1 = mkN "bonjour" "bonjourer" ;
  bonmot_nn_1 = mkN "bonmot" neutrum ;
  bonnett_nn_1 = mkN "bonnett" "bonnetter" ;
  bonus_nn_1 = mkN "bonus" ;
  bonusklass_nn_1 = mkN "bonusklass" "bonusklasser" ;
  bookmaker_nn_1 = mkN "bookmaker" "bookmakern" "bookmaker" "bookmakerna" ;
  boom_nn_1 = mkN "boom" "boomer" ;
  boplats_nn_1 = mkN "boplats" "boplatser" ;
  boplatsgraevning_nn_1 = mkN "boplatsgrдvning" ;
  bord_nn_1 = mkN "bord" neutrum ;
  borddans_nn_1 = mkN "borddans" "borddanser" ;
  bordduk_nn_1 = mkN "bordduk" ;
  bordeaux_nn_1 = mkN "bordeaux" "bordeauxer" ;
  bordell_nn_1 = mkN "bordell" "bordeller" ;
  bordhyvel_nn_1 = mkN "bordhyvel" ;
  bordlaeggning_nn_1 = mkN "bordlдggning" ;
  bordlaeggningsplenum_nn_1 = mkN "bordlдggningsplenum" neutrum ;
  bordloepare_nn_1 = mkN "bordlцpare" "bordlцpare" ;
  bordsamtal_nn_1 = mkN "bordsamtal" "bordsamtalet" "bordsamtalen" "bordsamtalena" ;
  bordsben_nn_1 = mkN "bordsben" neutrum ;
  bordsbestaellning_nn_1 = mkN "bordsbestдllning" ;
  bordsboen_nn_1 = mkN "bordsbцn" "bordsbцner" ;
  bordsdam_nn_1 = mkN "bordsdam" "bordsdamer" ;
  bordsdryck_nn_1 = mkN "bordsdryck" "bordsdrycker" ;
  bordservis_nn_1 = mkN "bordservis" "bordserviser" ;
  bordsfilt_nn_1 = mkN "bordsfilt" ;
  bordskant_nn_1 = mkN "bordskant" "bordskanter" ;
  bordskavaljer_nn_1 = mkN "bordskavaljer" "bordskavaljerer" ;
  bordskick_nn_1 = mkN "bordskick" neutrum ;
  bordskniv_nn_1 = mkN "bordskniv" ;
  bordsmargarin_nn_1 = mkN "bordsmargarin" "bordsmargarinet" "bordsmargariner" "bordsmargarinerna" ;
  bordssamtal_nn_1 = mkN "bordssamtal" "bordssamtalet" "bordssamtalen" "bordssamtalena" ;
  bordsservis_nn_1 = mkN "bordsservis" "bordsserviser" ;
  bordsskick_nn_1 = mkN "bordsskick" neutrum ;
  bordsstaell_nn_1 = mkN "bordsstдll" neutrum ;
  bordsstudsare_nn_1 = mkN "bordsstudsare" "bordsstudsare" ;
  bordstudsare_nn_1 = mkN "bordstudsare" "bordstudsare" ;
  bordsuppsats_nn_1 = mkN "bordsuppsats" "bordsuppsatser" ;
  bordsvatten_nn_1 = mkN "bordsvatten" "bordsvattnet" "bordsvatten" "bordsvattnen" ;
  bordtennisracket_nn_1 = mkN "bordtennisracket" ;
  bordvarts_ab_1 = mkAdv "bordvarts" ;
  boreal_av_1 = mkA "boreal" ;
  boren_av_1 = mkA "boren" "boret" ;
  borg_nn_1 = mkN "borg" ;
  borgarbevaepning_nn_1 = mkN "borgarbevдpning" ;
  borgarbrev_nn_1 = mkN "borgarbrev" neutrum ;
  borgardoeme_nn_1 = mkN "borgardцme" ;
  borgare_nn_1 = mkN "borgare" "borgare" ;
  borgargarde_nn_1 = mkN "borgargarde" ;
  borgarklass_nn_1 = mkN "borgarklass" "borgarklasser" ;
  borgarraad_nn_1 = mkN "borgarrеd" neutrum ;
  borgenaer_nn_1 = mkN "borgenдr" "borgenдrer" ;
  borgenaersed_nn_1 = mkN "borgenдrsed" "borgenдrseder" ;
  borgensaatagande_nn_1 = mkN "borgensеtagande" ;
  borgensfoerbindelse_nn_1 = mkN "borgensfцrbindelse" "borgensfцrbindelser" ;
  borgenslaan_nn_1 = mkN "borgenslеn" neutrum ;
  borgensman_nn_1 = mkN "borgensman" "borgensmannen" "borgensmдn" "borgensmдnnen" ;
  borgenssumma_nn_1 = mkN "borgenssumma" ;
  borgerlig_av_1 = mkA "borgerlig" ;
  borgerlighet_nn_1 = mkN "borgerlighet" "borgerligheter" ;
  borgerskap_nn_1 = mkN "borgerskap" "borgerskapet" "borgerskapen" "borgerskapena" ;
  borgfred_nn_1 = mkN "borgfred" "borgfreder" ;
  borggaard_nn_1 = mkN "borggеrd" ;
  borgmaestare_nn_1 = mkN "borgmдstare" "borgmдstare" ;
  borkarbid_nn_1 = mkN "borkarbid" "borkarbider" ;
  borr_nn_1 = mkN "borr" ;
  borrchuck_nn_1 = mkN "borrchuck" ;
  borrhaal_nn_1 = mkN "borrhеl" neutrum ;
  borrhaalsvaegg_nn_1 = mkN "borrhеlsvдgg" ;
  borrjigg_nn_1 = mkN "borrjigg" ;
  borrmaskin_nn_1 = mkN "borrmaskin" "borrmaskiner" ;
  borrmussla_nn_1 = mkN "borrmussla" ;
  borrning_nn_1 = mkN "borrning" ;
  borrplattform_nn_1 = mkN "borrplattform" ;
  borrspaan_nn_1 = mkN "borrspеn" neutrum ;
  borrspindel_nn_1 = mkN "borrspindel" ;
  borrstaal_nn_1 = mkN "borrstеl" neutrum ;
  borrsvaeng_nn_1 = mkN "borrsvдng" ;
  borrtorn_nn_1 = mkN "borrtorn" neutrum ;
  borst_nn_1 = mkN "borst" neutrum ;
  borstbindare_nn_1 = mkN "borstbindare" "borstbindare" ;
  borstbinderi_nn_1 = mkN "borstbinderi" "borstbinderit" "borstbinderier" "borstbinderierna" ;
  borste_nn_1 = mkN "borste" utrum ;
  borstgarnityr_nn_1 = mkN "borstgarnityr" neutrum ;
  borstgraes_nn_1 = mkN "borstgrдs" neutrum ;
  borstig_av_1 = mkA "borstig" ;
  borstmask_nn_1 = mkN "borstmask" ;
  borstsvans_nn_1 = mkN "borstsvans" ;
  borstviskare_nn_1 = mkN "borstviskare" "borstviskare" ;
  bort_ab_1 = mkAdv "bort" ;
  borta_ab_1 = mkAdv "borta" ;
  bortaat_ab_1 = mkAdv "bortеt" ;
  bortafoersaekring_nn_1 = mkN "bortafцrsдkring" ;
  bortalag_nn_1 = mkN "bortalag" neutrum ;
  bortamatch_nn_1 = mkN "bortamatch" "bortamatcher" ;
  bortanfoer_ab_1 = mkAdv "bortanfцr" ;
  bortaplan_nn_1 = mkN "bortaplan" "bortaplaner" ;
  bortaseger_nn_1 = mkN "bortaseger" ;
  bortbjuden_av_1 = mkA "bortbjuden" "bortbjudet" ;
  bortblaast_av_1 = mkA "bortblеst" "bortblеst" ;
  bortbyting_nn_1 = mkN "bortbyting" ;
  bortdoeende_av_1 = mkA "bortdцende" ;
  bortdoemning_nn_1 = mkN "bortdцmning" ;
  bortdriva_vb_1 = mkV "bortdriva" "bortdrev" "bortdrivit" ;
  bortemot_ab_1 = mkAdv "bortemot" ;
  bortfall_nn_1 = mkN "bortfall" neutrum ;
  bortfalla_vb_1 = mkV "bortfalla" "bortfцll" "bortfallit" ;
  bortfoerklaring_nn_1 = mkN "bortfцrklaring" ;
  bortgaa_vb_1 = mkV "bortgе" "bortgеr" "bortgе" "bortgick" "bortgеtt" "bortgеngen" ;
  bortgloemd_av_1 = mkA "bortglцmd" "bortglцmt" ;
  bortifraan_ab_1 = mkAdv "bortifrеn" ;
  bortigenom_ab_1 = mkAdv "bortigenom" ;
  bortkommen_av_1 = mkA "bortkommen" "bortkommet" "bortkomna" "bortkomna" "bortkomnare" "bortkomnast" "bortkomnaste" ;
  bortoever_ab_1 = mkAdv "bortцver" ;
  bortom_ab_1 = mkAdv "bortom" ;
  bortrationalisering_nn_1 = mkN "bortrationalisering" ;
  bortrest_av_1 = mkA "bortrest" "bortrest" ;
  bortrinna_vb_1 = mkV "bortrinna" "bortrann" "bortrunnit" ;
  bortsaettning_nn_1 = mkN "bortsдttning" ;
  bortskaemd_av_1 = mkA "bortskдmd" "bortskдmt" ;
  bortskrivning_nn_1 = mkN "bortskrivning" ;
  bortsluta_vb_1 = mkV "bortsluta" "bortslцt" "bortslutit" ;
  bortsprungen_av_1 = mkA "bortsprungen" "bortsprunget" ;
  bortstoetning_nn_1 = mkN "bortstцtning" ;
  bortta_vb_1 = mkV "bortta" "borttar" "bortta" "borttog" "borttagit" "borttagen" ;
  borttraengning_nn_1 = mkN "borttrдngning" ;
  bosaettning_nn_1 = mkN "bosдttning" ;
  bosaettningsaffaer_nn_1 = mkN "bosдttningsaffдr" "bosдttningsaffдrer" ;
  bosaettningslaan_nn_1 = mkN "bosдttningslеn" neutrum ;
  bosaettningsort_nn_1 = mkN "bosдttningsort" "bosдttningsorter" ;
  bosatt_av_1 = mkA "bosatt" ;
  boskapshjord_nn_1 = mkN "boskapshjord" ;
  boskapsskoetande_av_1 = mkA "boskapsskцtande" ;
  boskapsskoetare_nn_1 = mkN "boskapsskцtare" "boskapsskцtare" ;
  boskapsstaengsel_nn_1 = mkN "boskapsstдngsel" neutrum ;
  boskapsstock_nn_1 = mkN "boskapsstock" ;
  boskifte_nn_1 = mkN "boskifte" ;
  boskillnad_nn_1 = mkN "boskillnad" "boskillnader" ;
  bosnier_nn_1 = mkN "bosnier" "bosniern" "bosnier" "bosnierna" ;
  bosnisk_av_1 = mkA "bosnisk" ;
  boss_nn_1 = mkN "boss" ;
  bossig_av_1 = mkA "bossig" ;
  bostad_nn_1 = mkN "bostad" "bostдder" ;
  bostadsadress_nn_1 = mkN "bostadsadress" "bostadsadresser" ;
  bostadsband_nn_1 = mkN "bostadsband" neutrum ;
  bostadsbidrag_nn_1 = mkN "bostadsbidrag" neutrum ;
  bostadsbyggande_nn_1 = mkN "bostadsbyggande" ;
  bostadsfoerbaettringslaan_nn_1 = mkN "bostadsfцrbдttringslеn" neutrum ;
  bostadsfoeretag_nn_1 = mkN "bostadsfцretag" neutrum ;
  bostadsfoermedling_nn_1 = mkN "bostadsfцrmedling" ;
  bostadshus_nn_1 = mkN "bostadshus" neutrum ;
  bostadskoe_nn_1 = mkN "bostadskц" "bostadskцn" "bostadskцer" "bostadskцerna" ;
  bostadskooperation_nn_1 = mkN "bostadskooperation" "bostadskooperationer" ;
  bostadskredit_nn_1 = mkN "bostadskredit" "bostadskrediter" ;
  bostadslaan_nn_1 = mkN "bostadslеn" neutrum ;
  bostadslaegenhet_nn_1 = mkN "bostadslдgenhet" "bostadslдgenheter" ;
  bostadsloes_av_1 = mkA "bostadslцs" ;
  bostadsmarknad_nn_1 = mkN "bostadsmarknad" "bostadsmarknader" ;
  bostadsmiljoe_nn_1 = mkN "bostadsmiljц" "bostadsmiljцn" "bostadsmiljцer" "bostadsmiljцerna" ;
  bostadsnaemnd_nn_1 = mkN "bostadsnдmnd" "bostadsnдmnder" ;
  bostadsomraade_nn_1 = mkN "bostadsomrеde" ;
  bostadspolitisk_av_1 = mkA "bostadspolitisk" ;
  bostadsraett_nn_1 = mkN "bostadsrдtt" "bostadsrдtter" ;
  bostadsraettsfoerening_nn_1 = mkN "bostadsrдttsfцrening" ;
  bostadssoekande_nn_1 = mkN "bostadssцkande" "bostadssцkanden" "bostadssцkande" "bostadssцkandena" ;
  bostadsstyrelse_nn_1 = mkN "bostadsstyrelse" "bostadsstyrelser" ;
  bostadstillaegg_nn_1 = mkN "bostadstillдgg" neutrum ;
  bostonvals_nn_1 = mkN "bostonvals" "bostonvalser" ;
  bot_nn_2 = mkN "bot" "bцter" ;
  botaniker_nn_1 = mkN "botaniker" "botanikern" "botaniker" "botanikerna" ;
  botanikspade_nn_1 = mkN "botanikspade" utrum ;
  botanisk_av_1 = mkA "botanisk" ;
  botanist_nn_1 = mkN "botanist" "botanister" ;
  botanistspade_nn_1 = mkN "botanistspade" utrum ;
  botdag_nn_1 = mkN "botdag" ;
  botemedel_nn_1 = mkN "botemedel" neutrum ;
  botfaerdig_av_1 = mkA "botfдrdig" ;
  botgoerare_nn_1 = mkN "botgцrare" "botgцrare" ;
  botgoerelse_nn_1 = mkN "botgцrelse" "botgцrelser" ;
  botgoering_nn_1 = mkN "botgцring" ;
  botlig_av_1 = mkA "botlig" ;
  botswanier_nn_1 = mkN "botswanier" "botswaniern" "botswanier" "botswanierna" ;
  botswansk_av_1 = mkA "botswansk" ;
  botten_nn_1 = mkN "botten" ;
  bottenavlagring_nn_1 = mkN "bottenavlagring" ;
  bottenbjaelke_nn_1 = mkN "bottenbjдlke" utrum ;
  bottendaalig_av_1 = mkA "bottendеlig" ;
  bottendjur_nn_1 = mkN "bottendjur" neutrum ;
  bottenfaellning_nn_1 = mkN "bottenfдllning" ;
  bottenfaerg_nn_1 = mkN "bottenfдrg" "bottenfдrger" ;
  bottenfast_av_1 = mkA "bottenfast" "bottenfast" ;
  bottenfock_nn_1 = mkN "bottenfock" ;
  bottengarn_nn_1 = mkN "bottengarn" neutrum ;
  bottenhederlig_av_1 = mkA "bottenhederlig" ;
  bottenkaenning_nn_1 = mkN "bottenkдnning" ;
  bottenkran_nn_1 = mkN "bottenkran" ;
  bottenkurs_nn_1 = mkN "bottenkurs" "bottenkurser" ;
  bottenlaan_nn_1 = mkN "bottenlеn" neutrum ;
  bottenlaege_nn_1 = mkN "bottenlдge" ;
  bottenlag_nn_1 = mkN "bottenlag" neutrum ;
  bottenlevande_av_1 = mkA "bottenlevande" ;
  bottenloes_av_1 = mkA "bottenlцs" ;
  bottennapp_nn_1 = mkN "bottennapp" neutrum ;
  bottenplan_nn_1 = mkN "bottenplan" neutrum ;
  bottenrekord_nn_1 = mkN "bottenrekord" neutrum ;
  bottenrev_nn_1 = mkN "bottenrev" neutrum ;
  bottensats_nn_1 = mkN "bottensats" "bottensatser" ;
  bottensediment_nn_1 = mkN "bottensediment" neutrum ;
  bottenskikt_nn_1 = mkN "bottenskikt" neutrum ;
  bottenskvaett_nn_1 = mkN "bottenskvдtt" ;
  bottenstock_nn_1 = mkN "bottenstock" ;
  bottenvaaning_nn_1 = mkN "bottenvеning" ;
  bottenvatten_nn_1 = mkN "bottenvatten" "bottenvattnet" "bottenvatten" "bottenvattnen" ;
  bottenventil_nn_1 = mkN "bottenventil" "bottenventiler" ;
  bottin_nn_1 = mkN "bottin" "bottiner" ;
  bottnisk_av_1 = mkA "bottnisk" ;
  boudoir_nn_1 = mkN "boudoir" "boudoirer" ;
  boulevard_nn_1 = mkN "boulevard" "boulevarder" ;
  bouppteckning_nn_1 = mkN "bouppteckning" ;
  bouquet_nn_1 = mkN "bouquet" "bouqueter" ;
  bourgogne_nn_1 = mkN "bourgogne" "bourgogner" ;
  boutique_nn_1 = mkN "boutique" "boutiquer" ;
  boutredning_nn_1 = mkN "boutredning" ;
  bouzouki_nn_1 = mkN "bouzouki" "bouzoukin" "bouzouki" "bouzoukina" ;
  bov_nn_1 = mkN "bov" ;
  bovaktig_av_1 = mkA "bovaktig" ;
  boveteplaett_nn_1 = mkN "boveteplдtt" ;
  bovfysionomi_nn_1 = mkN "bovfysionomi" "bovfysionomier" ;
  bovstreck_nn_1 = mkN "bovstreck" neutrum ;
  bowlare_nn_1 = mkN "bowlare" "bowlare" ;
  bowlinghall_nn_1 = mkN "bowlinghall" ;
  bowlingklot_nn_1 = mkN "bowlingklot" neutrum ;
  box_nn_1 = mkN "box" ;
  boxare_nn_1 = mkN "boxare" "boxare" ;
  boxboll_nn_1 = mkN "boxboll" ;
  boxer_nn_1 = mkN "boxer" ;
  boxhandske_nn_1 = mkN "boxhandske" utrum ;
  boxning_nn_1 = mkN "boxning" ;
  boxningsmatch_nn_1 = mkN "boxningsmatch" "boxningsmatcher" ;
  boxningsring_nn_1 = mkN "boxningsring" ;
  boxningstraening_nn_1 = mkN "boxningstrдning" ;
  boyscout_nn_1 = mkN "boyscout" "boyscouter" ;
  bra_ab_1 = mkAdv "bra" ;
  bra_av_1 = mkA "bra" "bra" "bra" "bдttre" "bдst" ;
  braack_nn_1 = mkN "brеck" neutrum ;
  braackband_nn_1 = mkN "brеckband" neutrum ;
  braad_av_1 = mkA "brеd" ;
  braaddjup_av_1 = mkA "brеddjup" ;
  braadis_ab_1 = mkAdv "brеdis" ;
  braadmogen_av_1 = mkA "brеdmogen" "brеdmoget" ;
  braadskande_av_1 = mkA "brеdskande" ;
  braak_nn_1 = mkN "brеk" neutrum ;
  braakdel_nn_1 = mkN "brеkdel" "brеkdelen" "brеkdelar" "brеkdelarna" ;
  braakig_av_1 = mkA "brеkig" ;
  braakmakare_nn_1 = mkN "brеkmakare" "brеkmakare" ;
  braakstake_nn_1 = mkN "brеkstake" utrum ;
  braakstreck_nn_1 = mkN "brеkstreck" neutrum ;
  braaktal_nn_1 = mkN "brеktal" "brеktalet" "brеktalen" "brеktalena" ;
  braanad_nn_1 = mkN "brеnad" "brеnader" ;
  braattom_ab_1 = mkAdv "brеttom" ;
  brackig_av_1 = mkA "brackig" ;
  braeckhammare_nn_1 = mkN "brдckhammare" "brдckhammaren" "brдckhamrar" "brдckhamrarna" ;
  braeckjaern_nn_1 = mkN "brдckjдrn" neutrum ;
  braeckkorv_nn_1 = mkN "brдckkorv" ;
  braecklig_av_1 = mkA "brдcklig" ;
  braeckt_av_1 = mkA "brдckt" "brдckt" ;
  braeckvatten_nn_1 = mkN "brдckvatten" "brдckvattnet" "brдckvatten" "brдckvattnen" ;
  braeda_nn_1 = mkN "brдda" ;
  braedd_nn_1 = mkN "brдdd" ;
  braeddavlopp_nn_1 = mkN "brдddavlopp" neutrum ;
  braeddfull_av_1 = mkA "brдddfull" ;
  braeddfylld_av_1 = mkA "brдddfylld" "brдddfyllt" ;
  braedgaang_nn_1 = mkN "brдdgеng" ;
  braedgaard_nn_1 = mkN "brдdgеrd" ;
  braedspel_nn_1 = mkN "brдdspel" "brдdspelet" "brдdspel" "brдdspelen" ;
  braekande_nn_1 = mkN "brдkande" ;
  braeken_nn_1 = mkN "brдken" ;
  braem_nn_1 = mkN "brдm" neutrum ;
  braennaessla_nn_1 = mkN "brдnnдssla" ;
  braennande_av_1 = mkA "brдnnande" ;
  braennare_nn_1 = mkN "brдnnare" "brдnnare" ;
  braennbar_av_1 = mkA "brдnnbar" ;
  braenneri_nn_1 = mkN "brдnneri" "brдnnerit" "brдnnerier" "brдnnerierna" ;
  braennglas_nn_1 = mkN "brдnnglas" neutrum ;
  braennhaar_nn_1 = mkN "brдnnhеr" neutrum ;
  braennhet_av_1 = mkA "brдnnhet" ;
  braenning_nn_1 = mkN "brдnning" ;
  braennjaern_nn_1 = mkN "brдnnjдrn" neutrum ;
  braennkammare_nn_1 = mkN "brдnnkammare" "brдnnkammare" ;
  braennmaerke_nn_1 = mkN "brдnnmдrke" ;
  braennmanet_nn_1 = mkN "brдnnmanet" "brдnnmaneter" ;
  braennoffer_nn_1 = mkN "brдnnoffer" neutrum ;
  braennpunkt_nn_1 = mkN "brдnnpunkt" "brдnnpunkter" ;
  braennsaar_nn_1 = mkN "brдnnsеr" neutrum ;
  braennvidd_nn_1 = mkN "brдnnvidd" "brдnnvidder" ;
  braennvin_nn_1 = mkN "brдnnvin" "brдnnvinet" "brдnnviner" "brдnnvinerna" ;
  braennvinsadvokat_nn_1 = mkN "brдnnvinsadvokat" "brдnnvinsadvokater" ;
  braennvinsbas_nn_1 = mkN "brдnnvinsbas" ;
  braennvinsbraenneri_nn_1 = mkN "brдnnvinsbrдnneri" "brдnnvinsbrдnnerit" "brдnnvinsbrдnnerier" "brдnnvinsbrдnnerierna" ;
  braennvinsglas_nn_1 = mkN "brдnnvinsglas" neutrum ;
  braennvinsprovare_nn_1 = mkN "brдnnvinsprovare" "brдnnvinsprovare" ;
  braenslecell_nn_1 = mkN "brдnslecell" "brдnsleceller" ;
  braenslecellsdriven_av_1 = mkA "brдnslecellsdriven" "brдnslecellsdrivet" ;
  braenslecellskonstruktion_nn_1 = mkN "brдnslecellskonstruktion" "brдnslecellskonstruktioner" ;
  braenslecellskraftverk_nn_1 = mkN "brдnslecellskraftverk" neutrum ;
  braenslecellstyp_nn_1 = mkN "brдnslecellstyp" "brдnslecellstyper" ;
  braensleelement_nn_1 = mkN "brдnsleelement" neutrum ;
  braenslefaelt_nn_1 = mkN "brдnslefдlt" neutrum ;
  braenslefoerraad_nn_1 = mkN "brдnslefцrrеd" neutrum ;
  braenslegas_nn_1 = mkN "brдnslegas" "brдnslegaser" ;
  braenslekanal_nn_1 = mkN "brдnslekanal" "brдnslekanaler" ;
  braenslemaetare_nn_1 = mkN "brдnslemдtare" "brдnslemдtare" ;
  braensleomvandlare_nn_1 = mkN "brдnsleomvandlare" "brдnsleomvandlaren" "brдnsleomvandrar" "brдnsleomvandrarna" ;
  braenslesnaal_av_1 = mkA "brдnslesnеl" ;
  braenslestav_nn_1 = mkN "brдnslestav" ;
  braensletank_nn_1 = mkN "brдnsletank" ;
  braensletillaegg_nn_1 = mkN "brдnsletillдgg" neutrum ;
  braesch_nn_1 = mkN "brдsch" "brдscher" ;
  bragd_nn_1 = mkN "bragd" "bragder" ;
  brageloefte_nn_1 = mkN "bragelцfte" ;
  brakfest_nn_1 = mkN "brakfest" "brakfester" ;
  brakmiddag_nn_1 = mkN "brakmiddag" ;
  brakskit_nn_1 = mkN "brakskit" ;
  braksucce_nn_1 = mkN "braksuccй" "braksuccйer" ;
  brakteat_nn_1 = mkN "brakteat" "brakteater" ;
  brakycefal_av_1 = mkA "brakycefal" ;
  brallis_nn_1 = mkN "brallis" ;
  braman_nn_1 = mkN "braman" "bramaner" ;
  bramansk_av_1 = mkA "bramansk" ;
  bramin_nn_1 = mkN "bramin" "braminer" ;
  bramsegel_nn_1 = mkN "bramsegel" neutrum ;
  bramstaang_nn_1 = mkN "bramstеng" "bramstдnger" ;
  brand_nn_1 = mkN "brand" "brдnder" ;
  brandalarm_nn_1 = mkN "brandalarm" neutrum ;
  brandartikel_nn_1 = mkN "brandartikel" ;
  brandbefael_nn_1 = mkN "brandbefдl" neutrum ;
  brandbil_nn_1 = mkN "brandbil" ;
  brandbomb_nn_1 = mkN "brandbomb" "brandbomber" ;
  brandbotten_nn_1 = mkN "brandbotten" ;
  brandchef_nn_1 = mkN "brandchef" "brandchefer" ;
  branddike_nn_1 = mkN "branddike" ;
  branddoerr_nn_1 = mkN "branddцrr" ;
  brandfackla_nn_1 = mkN "brandfackla" ;
  brandfarlig_av_1 = mkA "brandfarlig" ;
  brandfoersaekringsbolag_nn_1 = mkN "brandfцrsдkringsbolag" neutrum ;
  brandgavel_nn_1 = mkN "brandgavel" ;
  brandgrav_nn_1 = mkN "brandgrav" ;
  brandgul_av_1 = mkA "brandgul" ;
  brandhaerd_nn_1 = mkN "brandhдrd" ;
  brandhaerdig_av_1 = mkA "brandhдrdig" ;
  brandingenjoer_nn_1 = mkN "brandingenjцr" "brandingenjцrer" ;
  brandinspektion_nn_1 = mkN "brandinspektion" "brandinspektioner" ;
  brandinspektoer_nn_1 = mkN "brandinspektцr" "brandinspektцrer" ;
  brandkaar_nn_1 = mkN "brandkеr" "brandkеrer" ;
  brandkaarsutryckning_nn_1 = mkN "brandkеrsutryckning" ;
  brandkapten_nn_1 = mkN "brandkapten" "brandkaptener" ;
  brandlager_nn_1 = mkN "brandlager" neutrum ;
  brandlarm_nn_1 = mkN "brandlarm" neutrum ;
  brandman_nn_1 = mkN "brandman" "brandmannen" "brandmдn" "brandmдnnen" ;
  brandmur_nn_1 = mkN "brandmur" ;
  brandorsak_nn_1 = mkN "brandorsak" "brandorsaker" ;
  brandpost_nn_1 = mkN "brandpost" "brandposter" ;
  brandredskap_nn_1 = mkN "brandredskap" "brandredskapet" "brandredskapen" "brandredskapena" ;
  brandrest_nn_1 = mkN "brandrest" "brandrester" ;
  brandroer_nn_1 = mkN "brandrцr" neutrum ;
  brandsaeker_av_1 = mkA "brandsдker" "brandsдkert" "brandsдkra" "brandsдkra" "brandsдkrare" "brandsдkrast" "brandsдkraste" ;
  brandsegel_nn_1 = mkN "brandsegel" neutrum ;
  brandskaap_nn_1 = mkN "brandskеp" neutrum ;
  brandslaeckare_nn_1 = mkN "brandslдckare" "brandslдckare" ;
  brandslang_nn_1 = mkN "brandslang" ;
  brandsoldat_nn_1 = mkN "brandsoldat" "brandsoldater" ;
  brandstation_nn_1 = mkN "brandstation" "brandstationer" ;
  brandstege_nn_1 = mkN "brandstege" utrum ;
  brandstodsbolag_nn_1 = mkN "brandstodsbolag" neutrum ;
  brandstyrka_nn_1 = mkN "brandstyrka" ;
  brandsvamp_nn_1 = mkN "brandsvamp" ;
  brandsyn_nn_1 = mkN "brandsyn" "brandsyner" ;
  brandtal_nn_1 = mkN "brandtal" "brandtalet" "brandtalen" "brandtalena" ;
  brandtorn_nn_1 = mkN "brandtorn" neutrum ;
  brandvakt_ab_1 = mkAdv "brandvakt" ;
  brandvakt_nn_1 = mkN "brandvakt" "brandvakter" ;
  brandvarnare_nn_1 = mkN "brandvarnare" "brandvarnare" ;
  bransch_nn_1 = mkN "bransch" "branscher" ;
  branschfoerening_nn_1 = mkN "branschfцrening" ;
  branschraad_nn_1 = mkN "branschrеd" neutrum ;
  brant_av_1 = mkA "brant" "brant" ;
  brant_nn_1 = mkN "brant" "branter" ;
  brasilian_nn_1 = mkN "brasilian" "brasilianer" ;
  brasilianare_nn_1 = mkN "brasilianare" "brasilianare" ;
  brasiliansk_av_1 = mkA "brasiliansk" ;
  braskande_av_1 = mkA "braskande" ;
  brasklapp_nn_1 = mkN "brasklapp" ;
  brastaendare_nn_1 = mkN "brastдndare" "brastдndare" ;
  bravad_nn_1 = mkN "bravad" "bravader" ;
  bravurnummer_nn_1 = mkN "bravurnummer" neutrum ;
  bravurroll_nn_1 = mkN "bravurroll" "bravurroller" ;
  braxen_nn_1 = mkN "braxen" ;
  break_nn_1 = mkN "break" neutrum ;
  bred_av_1 = mkA "bred" ;
  bredbar_av_1 = mkA "bredbar" ;
  bredbent_av_1 = mkA "bredbent" "bredbent" ;
  bredbladig_av_1 = mkA "bredbladig" ;
  bredbraettig_av_1 = mkA "bredbrдttig" ;
  bredd_nn_1 = mkN "bredd" "bredder" ;
  breddgrad_nn_1 = mkN "breddgrad" "breddgrader" ;
  breddidrott_nn_1 = mkN "breddidrott" "breddidrotter" ;
  breddning_nn_1 = mkN "breddning" ;
  bredmun_nn_1 = mkN "bredmun" "bredmunnen" "bredmunnar" "bredmunnarna" ;
  bredmynt_av_1 = mkA "bredmynt" "bredmynt" ;
  bredrandig_av_1 = mkA "bredrandig" ;
  bredsida_nn_1 = mkN "bredsida" ;
  bredskyggig_av_1 = mkA "bredskyggig" ;
  bredspaarig_av_1 = mkA "bredspеrig" ;
  bredvid_ab_1 = mkAdv "bredvid" ;
  bretagnare_nn_1 = mkN "bretagnare" "bretagnare" ;
  bretagnisk_av_1 = mkA "bretagnisk" ;
  bretagniska_nn_2 = mkN "bretagniska" ;
  breton_nn_1 = mkN "breton" "bretoner" ;
  bretonsk_av_1 = mkA "bretonsk" ;
  bretonska_nn_2 = mkN "bretonska" ;
  brev_nn_1 = mkN "brev" neutrum ;
  brevbaerare_nn_1 = mkN "brevbдrare" "brevbдrare" ;
  brevbomb_nn_1 = mkN "brevbomb" "brevbomber" ;
  brevfack_nn_1 = mkN "brevfack" neutrum ;
  brevfoersaendelse_nn_1 = mkN "brevfцrsдndelse" "brevfцrsдndelser" ;
  brevfraaga_nn_1 = mkN "brevfrеga" ;
  brevhemlighet_nn_1 = mkN "brevhemlighet" "brevhemligheter" ;
  brevhuvud_nn_1 = mkN "brevhuvud" "brevhuvudet" "brevhuvuden" "brevhuvudena" ;
  breviarium_nn_1 = mkN "breviarium" "breviariet" "breviarier" "breviarierna" ;
  brevinkast_nn_1 = mkN "brevinkast" neutrum ;
  brevkort_nn_1 = mkN "brevkort" neutrum ;
  brevlaadefoeretag_nn_1 = mkN "brevlеdefцretag" neutrum ;
  brevledes_ab_1 = mkAdv "brevledes" ;
  brevoeppnare_nn_1 = mkN "brevцppnare" "brevцppnare" ;
  brevpapper_nn_1 = mkN "brevpapper" neutrum ;
  brevporto_nn_1 = mkN "brevporto" "brevportot" "brevporton" "brevportona" ;
  brevpress_nn_1 = mkN "brevpress" ;
  brevroman_nn_1 = mkN "brevroman" "brevromaner" ;
  brevskoerd_nn_1 = mkN "brevskцrd" ;
  brevskrivare_nn_1 = mkN "brevskrivare" "brevskrivare" ;
  brevstaell_nn_1 = mkN "brevstдll" neutrum ;
  brevstaellare_nn_1 = mkN "brevstдllare" "brevstдllare" ;
  brevsvar_nn_1 = mkN "brevsvar" neutrum ;
  brevtelegram_nn_1 = mkN "brevtelegram" "brevtelegrammet" "brevtelegram" "brevtelegrammen" ;
  brevvaag_nn_1 = mkN "brevvеg" ;
  brevvaen_nn_1 = mkN "brevvдn" "brevvдnnen" "brevvдnner" "brevvдnnerna" ;
  brevvaexling_nn_1 = mkN "brevvдxling" ;
  brickband_nn_1 = mkN "brickband" neutrum ;
  brickbord_nn_1 = mkN "brickbord" neutrum ;
  brickduk_nn_1 = mkN "brickduk" ;
  bricklunch_nn_1 = mkN "bricklunch" "brickluncher" ;
  brickplockare_nn_1 = mkN "brickplockare" "brickplockare" ;
  brickvaevd_av_1 = mkA "brickvдvd" "brickvдvt" ;
  bridgebord_nn_1 = mkN "bridgebord" neutrum ;
  bridong_nn_1 = mkN "bridong" "bridonger" ;
  bridreaktor_nn_1 = mkN "bridreaktor" "bridreaktorer" ;
  brigad_nn_1 = mkN "brigad" "brigader" ;
  brigadgeneral_nn_1 = mkN "brigadgeneral" "brigadgeneraler" ;
  brigadoer_nn_1 = mkN "brigadцr" "brigadцrer" ;
  brigantin_nn_1 = mkN "brigantin" "brigantiner" ;
  brigg_nn_1 = mkN "brigg" ;
  briggsegel_nn_1 = mkN "briggsegel" neutrum ;
  brikett_nn_1 = mkN "brikett" "briketter" ;
  brikettpress_nn_1 = mkN "brikettpress" ;
  brikollstoet_nn_1 = mkN "brikollstцt" ;
  briljant_av_1 = mkA "briljant" "briljant" ;
  briljant_nn_1 = mkN "briljant" "briljanter" ;
  brink_nn_1 = mkN "brink" ;
  brinna_vb_1 = mkV "brinna" "brann" "brunnit" ;
  brinnande_av_1 = mkA "brinnande" ;
  bris_nn_1 = mkN "bris" ;
  brisad_nn_1 = mkN "brisad" "brisader" ;
  brisans_nn_1 = mkN "brisans" "brisanser" ;
  brisansgranat_nn_1 = mkN "brisansgranat" "brisansgranater" ;
  brisant_av_1 = mkA "brisant" "brisant" ;
  brisant_nn_1 = mkN "brisant" "brisanter" ;
  brisken_av_1 = mkA "brisken" "brisket" ;
  brissling_nn_1 = mkN "brissling" ;
  brist_nn_1 = mkN "brist" "brister" ;
  brista_vb_1 = mkV "brista" "brast" "brustit" ;
  bristande_av_1 = mkA "bristande" ;
  bristfaellig_av_1 = mkA "bristfдllig" ;
  bristlaege_nn_1 = mkN "bristlдge" ;
  bristning_nn_1 = mkN "bristning" ;
  bristsituation_nn_1 = mkN "bristsituation" "bristsituationer" ;
  bristsjukdom_nn_1 = mkN "bristsjukdom" ;
  bristyrke_nn_1 = mkN "bristyrke" ;
  britannisk_av_1 = mkA "britannisk" ;
  brits_nn_1 = mkN "brits" ;
  britt_nn_1 = mkN "britt" "britter" ;
  brittisk_av_1 = mkA "brittisk" ;
  brittsommar_nn_1 = mkN "brittsommar" "brittsommarn" "brittsommrar" "brittsommrarna" ;
  bro_nn_1 = mkN "bro" ;
  broavgift_nn_1 = mkN "broavgift" "broavgifter" ;
  brobaenk_nn_1 = mkN "brobдnk" ;
  brobelastning_nn_1 = mkN "brobelastning" ;
  brock_nn_1 = mkN "brock" ;
  brock_nn_2 = mkN "brock" neutrum ;
  brockband_nn_1 = mkN "brockband" neutrum ;
  brockfaagel_nn_1 = mkN "brockfеgel" ;
  brodd_nn_1 = mkN "brodd" ;
  broder_nn_1 = mkN "broder" "brodern" "brцder" "brцderna" ;
  broderbaage_nn_1 = mkN "broderbеge" utrum ;
  broderbok_nn_1 = mkN "broderbok" "broderbцcker" ;
  broderfolk_nn_1 = mkN "broderfolk" neutrum ;
  broderi_nn_1 = mkN "broderi" "broderit" "broderier" "broderierna" ;
  brodering_nn_1 = mkN "brodering" ;
  broderlig_av_1 = mkA "broderlig" ;
  brodernaal_nn_1 = mkN "brodernеl" ;
  brodersax_nn_1 = mkN "brodersax" ;
  broderskaerlek_nn_1 = mkN "broderskдrlek" ;
  broderskap_nn_1 = mkN "broderskap" "broderskapet" "broderskapen" "broderskapena" ;
  brodersoem_nn_1 = mkN "brodersцm" "brodersцmmen" "brodersцmmar" "brodersцmmarna" ;
  brodyr_nn_1 = mkN "brodyr" "brodyrer" ;
  broed_nn_1 = mkN "brцd" neutrum ;
  broedbagge_nn_1 = mkN "brцdbagge" utrum ;
  broedbak_nn_1 = mkN "brцdbak" neutrum ;
  broedbit_nn_1 = mkN "brцdbit" ;
  broedburk_nn_1 = mkN "brцdburk" ;
  broedfat_nn_1 = mkN "brцdfat" neutrum ;
  broedfrukt_nn_1 = mkN "brцdfrukt" "brцdfrukter" ;
  broeding_nn_1 = mkN "brцding" ;
  broedkant_nn_1 = mkN "brцdkant" "brцdkanter" ;
  broedkavel_nn_1 = mkN "brцdkavel" ;
  broedkniv_nn_1 = mkN "brцdkniv" ;
  broedkorg_nn_1 = mkN "brцdkorg" ;
  broedloes_av_1 = mkA "brцdlцs" ;
  broednagg_nn_1 = mkN "brцdnagg" ;
  broedpudding_nn_1 = mkN "brцdpudding" ;
  broedrafolk_nn_1 = mkN "brцdrafolk" neutrum ;
  broedrapar_nn_1 = mkN "brцdrapar" neutrum ;
  broedraskap_nn_1 = mkN "brцdraskap" "brцdraskapet" "brцdraskapen" "brцdraskapena" ;
  broedrost_nn_1 = mkN "brцdrost" ;
  broedsbrytelse_nn_1 = mkN "brцdsbrytelse" "brцdsbrytelser" ;
  broedskriveri_nn_1 = mkN "brцdskriveri" "brцdskriverit" "brцdskriverier" "brцdskriverierna" ;
  broedspade_nn_1 = mkN "brцdspade" utrum ;
  broel_nn_1 = mkN "brцl" neutrum ;
  broellop_nn_1 = mkN "brцllop" neutrum ;
  broellopsdag_nn_1 = mkN "brцllopsdag" ;
  broellopsfoto_nn_1 = mkN "brцllopsfoto" "brцllopsfotot" "brцllopsfoton" "brцllopsfotona" ;
  broellopsgaest_nn_1 = mkN "brцllopsgдst" "brцllopsgдster" ;
  broellopsmarsch_nn_1 = mkN "brцllopsmarsch" "brцllopsmarscher" ;
  broellopsnatt_nn_1 = mkN "brцllopsnatt" "brцllopsnдtter" ;
  broellopspar_nn_1 = mkN "brцllopspar" neutrum ;
  broellopsvittne_nn_1 = mkN "brцllopsvittne" ;
  broest_nn_1 = mkN "brцst" neutrum ;
  broestarv_nn_1 = mkN "brцstarv" neutrum ;
  broestarvinge_nn_1 = mkN "brцstarvinge" utrum ;
  broestbarn_nn_1 = mkN "brцstbarn" neutrum ;
  broestben_nn_1 = mkN "brцstben" neutrum ;
  broestbild_nn_1 = mkN "brцstbild" "brцstbilder" ;
  broestboeld_nn_1 = mkN "brцstbцld" "brцstbцlder" ;
  broestcancer_nn_1 = mkN "brцstcancer" ;
  broestgaang_nn_1 = mkN "brцstgеng" ;
  broestgaenges_ab_1 = mkAdv "brцstgдnges" ;
  broestkaramell_nn_1 = mkN "brцstkaramell" "brцstkarameller" ;
  broestkatarr_nn_1 = mkN "brцstkatarr" "brцstkatarrer" ;
  broestkoertel_nn_1 = mkN "brцstkцrtel" ;
  broestkorg_nn_1 = mkN "brцstkorg" ;
  broestlapp_nn_1 = mkN "brцstlapp" ;
  broestmaatt_nn_1 = mkN "brцstmеtt" neutrum ;
  broestmur_nn_1 = mkN "brцstmur" ;
  broestmuskel_nn_1 = mkN "brцstmuskel" "brцstmuskeln" "brцstmuskler" "brцstmusklerna" ;
  broestning_nn_1 = mkN "brцstning" ;
  broestparti_nn_1 = mkN "brцstparti" "brцstpartit" "brцstpartier" "brцstpartierna" ;
  broestpump_nn_1 = mkN "brцstpump" ;
  broestregister_nn_1 = mkN "brцstregister" neutrum ;
  broestsimmare_nn_1 = mkN "brцstsimmare" "brцstsimmare" ;
  broestskydd_nn_1 = mkN "brцstskydd" neutrum ;
  broestton_nn_1 = mkN "brцstton" "brцsttoner" ;
  broestvaern_nn_1 = mkN "brцstvдrn" neutrum ;
  broestvidd_nn_1 = mkN "brцstvidd" "brцstvidder" ;
  broet_nn_1 = mkN "brцt" ;
  broethake_nn_1 = mkN "brцthake" utrum ;
  broetling_nn_1 = mkN "brцtling" ;
  brohuvud_nn_1 = mkN "brohuvud" "brohuvudet" "brohuvuden" "brohuvudena" ;
  broiler_nn_1 = mkN "broiler" ;
  brok_nn_1 = mkN "brok" ;
  brokad_nn_1 = mkN "brokad" "brokader" ;
  brokanal_nn_1 = mkN "brokanal" "brokanaler" ;
  brokar_nn_1 = mkN "brokar" neutrum ;
  brokbladig_av_1 = mkA "brokbladig" ;
  brokblommig_av_1 = mkA "brokblommig" ;
  brokig_av_1 = mkA "brokig" ;
  brokspett_nn_1 = mkN "brokspett" ;
  bromfoergiftning_nn_1 = mkN "bromfцrgiftning" ;
  bromid_nn_1 = mkN "bromid" "bromider" ;
  broms_nn_1 = mkN "broms" ;
  bromsare_nn_1 = mkN "bromsare" "bromsare" ;
  bromsback_nn_1 = mkN "bromsback" ;
  bromsband_nn_1 = mkN "bromsband" neutrum ;
  bromsbelaegg_nn_1 = mkN "bromsbelдgg" neutrum ;
  bromsblock_nn_1 = mkN "bromsblock" neutrum ;
  bromscylinder_nn_1 = mkN "bromscylinder" ;
  bromsgaller_nn_1 = mkN "bromsgaller" neutrum ;
  bromsilverpapper_nn_1 = mkN "bromsilverpapper" neutrum ;
  bromsklaff_nn_1 = mkN "bromsklaff" ;
  bromskloss_nn_1 = mkN "bromskloss" ;
  bromsljus_nn_1 = mkN "bromsljus" neutrum ;
  bromsning_nn_1 = mkN "bromsning" ;
  bromsolja_nn_1 = mkN "bromsolja" ;
  bromspedal_nn_1 = mkN "bromspedal" "bromspedaler" ;
  bromsraket_nn_1 = mkN "bromsraket" "bromsraketer" ;
  bromsskaerm_nn_1 = mkN "bromsskдrm" ;
  bromssko_nn_1 = mkN "bromssko" "bromsskor" ;
  bromsspaar_nn_1 = mkN "bromsspеr" neutrum ;
  bromssystem_nn_1 = mkN "bromssystem" neutrum ;
  bromsvaetska_nn_1 = mkN "bromsvдtska" ;
  bromsvagn_nn_1 = mkN "bromsvagn" ;
  bronkit_nn_1 = mkN "bronkit" "bronkiter" ;
  bronkografi_nn_1 = mkN "bronkografi" "bronkografier" ;
  bronkoskop_nn_1 = mkN "bronkoskop" neutrum ;
  bronkoskopi_nn_1 = mkN "bronkoskopi" "bronkoskopier" ;
  brons_nn_1 = mkN "brons" "bronser" ;
  brons_nn_2 = mkN "brons" neutrum ;
  bronsaaldersfynd_nn_1 = mkN "bronsеldersfynd" neutrum ;
  bronsmaerke_nn_1 = mkN "bronsmдrke" ;
  bronsmedalj_nn_1 = mkN "bronsmedalj" "bronsmedaljer" ;
  bropelare_nn_1 = mkN "bropelare" "bropelare" ;
  bropeng_nn_1 = mkN "bropeng" ;
  bropenning_nn_1 = mkN "bropenning" ;
  brorsarv_nn_1 = mkN "brorsarv" neutrum ;
  brorsbarn_nn_1 = mkN "brorsbarn" neutrum ;
  brorsdotter_nn_1 = mkN "brorsdotter" "brorsdottern" "brorsdцttrar" "brorsdцttrarna" ;
  brorskaal_nn_1 = mkN "brorskеl" ;
  brorslott_nn_1 = mkN "brorslott" "brorslotter" ;
  brorson_nn_1 = mkN "brorson" "brorsцner" ;
  brorsskaal_nn_1 = mkN "brorsskеl" ;
  brosch_nn_1 = mkN "brosch" "broscher" ;
  broschyr_nn_1 = mkN "broschyr" "broschyrer" ;
  brosk_nn_1 = mkN "brosk" neutrum ;
  broskfisk_nn_1 = mkN "broskfisk" ;
  broskhinna_nn_1 = mkN "broskhinna" ;
  broskskivling_nn_1 = mkN "broskskivling" ;
  brosksvamp_nn_1 = mkN "brosksvamp" ;
  broskvaevnad_nn_1 = mkN "broskvдvnad" "broskvдvnader" ;
  broskverk_nn_1 = mkN "broskverk" neutrum ;
  broslagning_nn_1 = mkN "broslagning" ;
  brosme_nn_1 = mkN "brosme" utrum ;
  brospann_nn_1 = mkN "brospann" neutrum ;
  brotsch_nn_1 = mkN "brotsch" ;
  brott_nn_1 = mkN "brott" neutrum ;
  brottare_nn_1 = mkN "brottare" "brottare" ;
  brottmaal_nn_1 = mkN "brottmеl" neutrum ;
  brottning_nn_1 = mkN "brottning" ;
  brottningsgrepp_nn_1 = mkN "brottningsgrepp" neutrum ;
  brottningsmatch_nn_1 = mkN "brottningsmatch" "brottningsmatcher" ;
  brottsfoerebyggande_av_1 = mkA "brottsfцrebyggande" ;
  brottsjoe_nn_1 = mkN "brottsjц" ;
  brottslig_av_1 = mkA "brottslig" ;
  brottslighet_nn_1 = mkN "brottslighet" "brottsligheter" ;
  brottsling_nn_1 = mkN "brottsling" ;
  brottsplats_nn_1 = mkN "brottsplats" "brottsplatser" ;
  brottsrekvisit_nn_1 = mkN "brottsrekvisit" neutrum ;
  brottsrubricering_nn_1 = mkN "brottsrubricering" ;
  brottstillfaelle_nn_1 = mkN "brottstillfдlle" ;
  brottsutredning_nn_1 = mkN "brottsutredning" ;
  brovalv_nn_1 = mkN "brovalv" neutrum ;
  browning_nn_1 = mkN "browning" ;
  bruckel_nn_1 = mkN "bruckel" neutrum ;
  brud_nn_1 = mkN "brud" ;
  brudand_nn_1 = mkN "brudand" "brudдnder" ;
  brudbukett_nn_1 = mkN "brudbukett" "brudbuketter" ;
  brudfoto_nn_1 = mkN "brudfoto" "brudfotot" "brudfoton" "brudfotona" ;
  brudgum_nn_1 = mkN "brudgum" "brudgummen" "brudgummar" "brudgummarna" ;
  brudklaenning_nn_1 = mkN "brudklдnning" ;
  brudkoep_nn_1 = mkN "brudkцp" neutrum ;
  brudnaebb_nn_1 = mkN "brudnдbb" ;
  brudpaell_nn_1 = mkN "brudpдll" ;
  brudpall_nn_1 = mkN "brudpall" ;
  brudpar_nn_1 = mkN "brudpar" neutrum ;
  brudrov_nn_1 = mkN "brudrov" neutrum ;
  brudsaeng_nn_1 = mkN "brudsдng" ;
  brudsloeja_nn_1 = mkN "brudslцja" ;
  brudsporre_nn_1 = mkN "brudsporre" utrum ;
  brudstol_nn_1 = mkN "brudstol" ;
  brugd_nn_1 = mkN "brugd" "brugder" ;
  bruk_nn_1 = mkN "bruk" neutrum ;
  brukare_nn_1 = mkN "brukare" "brukare" ;
  brukbar_av_1 = mkA "brukbar" ;
  bruklig_av_1 = mkA "bruklig" ;
  bruklighet_nn_1 = mkN "bruklighet" "brukligheter" ;
  brukningsenhet_nn_1 = mkN "brukningsenhet" "brukningsenheter" ;
  bruksanvisning_nn_1 = mkN "bruksanvisning" ;
  bruksartikel_nn_1 = mkN "bruksartikel" ;
  bruksdisponent_nn_1 = mkN "bruksdisponent" "bruksdisponenter" ;
  bruksdjur_nn_1 = mkN "bruksdjur" neutrum ;
  bruksfoeremaal_nn_1 = mkN "bruksfцremеl" neutrum ;
  brukshund_nn_1 = mkN "brukshund" ;
  brukslagare_nn_1 = mkN "brukslagare" "brukslagare" ;
  brukspatron_nn_1 = mkN "brukspatron" "brukspatroner" ;
  bruksvaerde_nn_1 = mkN "bruksvдrde" ;
  brulepudding_nn_1 = mkN "brulйpudding" ;
  brumbas_nn_1 = mkN "brumbas" ;
  brumbjoern_nn_1 = mkN "brumbjцrn" ;
  brumkoer_nn_1 = mkN "brumkцr" "brumkцrer" ;
  brummare_nn_1 = mkN "brummare" "brummare" ;
  brun_av_1 = mkA "brun" ;
  brunaktig_av_1 = mkA "brunaktig" ;
  brunalg_nn_1 = mkN "brunalg" "brunalger" ;
  brunbaer_nn_1 = mkN "brunbдr" neutrum ;
  brunbraend_av_1 = mkA "brunbrдnd" ;
  brunch_nn_1 = mkN "brunch" "bruncher" ;
  brunett_av_1 = mkA "brunett" ;
  brunhaarig_av_1 = mkA "brunhеrig" ;
  brunkol_nn_1 = mkN "brunkol" neutrum ;
  brunn_nn_1 = mkN "brunn" ;
  brunnshus_nn_1 = mkN "brunnshus" neutrum ;
  brunnskar_nn_1 = mkN "brunnskar" neutrum ;
  brunnskur_nn_1 = mkN "brunnskur" "brunnskurer" ;
  brunnsort_nn_1 = mkN "brunnsort" "brunnsorter" ;
  brunnssvaengel_nn_1 = mkN "brunnssvдngel" ;
  brunnsvatten_nn_1 = mkN "brunnsvatten" "brunnsvattnet" "brunnsvatten" "brunnsvattnen" ;
  brunoegd_av_1 = mkA "brunцgd" "brunцgt" ;
  brunoert_nn_1 = mkN "brunцrt" "brunцrter" ;
  brunroed_av_1 = mkA "brunrцd" ;
  brunstig_av_1 = mkA "brunstig" ;
  brunsvart_av_1 = mkA "brunsvart" "brunsvart" ;
  brunte_nn_1 = mkN "brunte" utrum ;
  brushane_nn_1 = mkN "brushane" utrum ;
  brushuvud_nn_1 = mkN "brushuvud" "brushuvudet" "brushuvuden" "brushuvudena" ;
  brustablett_nn_1 = mkN "brustablett" "brustabletter" ;
  brusten_av_1 = mkA "brusten" "brustet" ;
  brutal_av_1 = mkA "brutal" ;
  brutalitet_nn_1 = mkN "brutalitet" "brutaliteter" ;
  brutto_ab_1 = mkAdv "brutto" ;
  brutto_nn_1 = mkN "brutto" "bruttot" "brutton" "bruttona" ;
  bruttobehaallning_nn_1 = mkN "bruttobehеllning" ;
  bruttodraektighet_nn_1 = mkN "bruttodrдktighet" "bruttodrдktigheter" ;
  bruttoformel_nn_1 = mkN "bruttoformel" "bruttoformeln" "bruttoformler" "bruttoformlerna" ;
  bruttoinkomst_nn_1 = mkN "bruttoinkomst" "bruttoinkomster" ;
  bruttoloen_nn_1 = mkN "bruttolцn" "bruttolцner" ;
  bruttonationalprodukt_nn_1 = mkN "bruttonationalprodukt" "bruttonationalprodukter" ;
  bruttopris_nn_1 = mkN "bruttopris" neutrum ;
  bruttoregisterton_nn_1 = mkN "bruttoregisterton" "bruttoregistertonnet" "bruttoregisterton" "bruttoregistertonnen" ;
  brydd_av_1 = mkA "brydd" ;
  bryderi_nn_1 = mkN "bryderi" "bryderit" "bryderier" "bryderierna" ;
  brydsam_av_1 = mkA "brydsam" "brydsamt" "brydsamma" "brydsamma" "brydsammare" "brydsammast" "brydsammaste" ;
  brygd_nn_1 = mkN "brygd" "brygder" ;
  bryggare_nn_1 = mkN "bryggare" "bryggare" ;
  bryggeri_nn_1 = mkN "bryggeri" "bryggerit" "bryggerier" "bryggerierna" ;
  brygghus_nn_1 = mkN "brygghus" neutrum ;
  bryggmald_av_1 = mkA "bryggmald" "bryggmalt" ;
  bryggmalen_av_1 = mkA "bryggmalen" "bryggmalet" ;
  bryggvaag_nn_1 = mkN "bryggvеg" ;
  brylaa_nn_1 = mkN "brylе" "brylеer" ;
  brylepudding_nn_1 = mkN "brylйpudding" ;
  brylling_nn_1 = mkN "brylling" ;
  bryn_nn_1 = mkN "bryn" neutrum ;
  brynja_nn_1 = mkN "brynja" ;
  brynstaal_nn_1 = mkN "brynstеl" neutrum ;
  brynsten_nn_1 = mkN "brynsten" "brynstenen" "brynstenar" "brynstenarna" ;
  bryolog_nn_1 = mkN "bryolog" "bryologer" ;
  brysk_av_1 = mkA "brysk" ;
  brysselspets_nn_1 = mkN "brysselspets" ;
  bryta_vb_1 = mkV "bryta" "brцt" "brutit" ;
  bryte_nn_1 = mkN "bryte" utrum ;
  brytning_nn_1 = mkN "brytning" ;
  brytningsaar_nn_1 = mkN "brytningsеr" neutrum ;
  brytningsexponent_nn_1 = mkN "brytningsexponent" "brytningsexponenter" ;
  brytningsfel_nn_1 = mkN "brytningsfel" "brytningsfelet" "brytningsfel" "brytningsfelen" ;
  brytningsindex_nn_1 = mkN "brytningsindex" neutrum ;
  brytningspunkt_nn_1 = mkN "brytningspunkt" "brytningspunkter" ;
  brytningstid_nn_1 = mkN "brytningstid" "brytningstider" ;
  brytningsvinkel_nn_1 = mkN "brytningsvinkel" ;
  brytpunkt_nn_1 = mkN "brytpunkt" "brytpunkter" ;
  brytvapen_nn_1 = mkN "brytvapen" "brytvapnet" "brytvapen" "brytvapnen" ;
  bubbelgum_nn_1 = mkN "bubbelgum" "bubbelgummet" "bubbelgum" "bubbelgummen" ;
  bubbelkammare_nn_1 = mkN "bubbelkammare" "bubbelkammaren" "bubbelkamrar" "bubbelkamrarna" ;
  bubbelpool_nn_1 = mkN "bubbelpool" "bubbelpooler" ;
  bubbla_nn_1 = mkN "bubbla" ;
  bubblig_av_1 = mkA "bubblig" ;
  bubon_nn_1 = mkN "bubon" "buboner" ;
  buckla_nn_1 = mkN "buckla" ;
  bucklig_av_1 = mkA "bucklig" ;
  bud_nn_1 = mkN "bud" neutrum ;
  budbaerare_nn_1 = mkN "budbдrare" "budbдrare" ;
  budbyraa_nn_1 = mkN "budbyrе" "budbyrеer" ;
  buddist_nn_1 = mkN "buddist" "buddister" ;
  buddistisk_av_1 = mkA "buddistisk" ;
  budget_nn_1 = mkN "budget" ;
  budgetaar_nn_1 = mkN "budgetеr" neutrum ;
  budgetaer_av_1 = mkA "budgetдr" ;
  budgetoeverskott_nn_1 = mkN "budgetцverskott" neutrum ;
  budgetproposition_nn_1 = mkN "budgetproposition" "budgetpropositioner" ;
  budgetunderskott_nn_1 = mkN "budgetunderskott" neutrum ;
  budgivning_nn_1 = mkN "budgivning" ;
  budkavel_nn_1 = mkN "budkavel" ;
  budkavle_nn_1 = mkN "budkavle" utrum ;
  budoar_nn_1 = mkN "budoar" "budoarer" ;
  budord_nn_1 = mkN "budord" neutrum ;
  budskap_nn_1 = mkN "budskap" "budskapet" "budskapen" "budskapena" ;
  buff_nn_1 = mkN "buff" ;
  buffaopera_nn_1 = mkN "buffaopera" ;
  buffe_nn_1 = mkN "buffй" "buffйer" ;
  buffel_nn_1 = mkN "buffel" ;
  buffelaktig_av_1 = mkA "buffelaktig" ;
  buffelhjord_nn_1 = mkN "buffelhjord" ;
  buffert_nn_1 = mkN "buffert" ;
  buffertkapacitet_nn_1 = mkN "buffertkapacitet" "buffertkapaciteter" ;
  buffertlager_nn_1 = mkN "buffertlager" neutrum ;
  buffertloesning_nn_1 = mkN "buffertlцsning" ;
  buffertstat_nn_1 = mkN "buffertstat" "buffertstater" ;
  bufflig_av_1 = mkA "bufflig" ;
  bugning_nn_1 = mkN "bugning" ;
  buk_nn_1 = mkN "buk" ;
  bukett_nn_1 = mkN "bukett" "buketter" ;
  bukformig_av_1 = mkA "bukformig" ;
  bukgjord_nn_1 = mkN "bukgjord" ;
  bukhinna_nn_1 = mkN "bukhinna" ;
  bukhinneinflammation_nn_1 = mkN "bukhinneinflammation" "bukhinneinflammationer" ;
  bukig_av_1 = mkA "bukig" ;
  bukmuskel_nn_1 = mkN "bukmuskel" "bukmuskeln" "bukmuskler" "bukmusklerna" ;
  bukolisk_av_1 = mkA "bukolisk" ;
  bukspottkoertel_nn_1 = mkN "bukspottkцrtel" ;
  bukstinn_av_1 = mkA "bukstinn" "bukstint" ;
  buksvaager_nn_1 = mkN "buksvеger" ;
  bukt_ab_1 = mkAdv "bukt" ;
  bukt_nn_1 = mkN "bukt" "bukter" ;
  buktalare_nn_1 = mkN "buktalare" "buktalare" ;
  buktig_av_1 = mkA "buktig" ;
  bukvaegg_nn_1 = mkN "bukvдgg" ;
  bulb_nn_1 = mkN "bulb" "bulber" ;
  bulbjaern_nn_1 = mkN "bulbjдrn" neutrum ;
  bulevard_nn_1 = mkN "bulevard" "bulevarder" ;
  bulgar_nn_1 = mkN "bulgar" "bulgarer" ;
  bulgarisk_av_1 = mkA "bulgarisk" ;
  bulgariska_nn_2 = mkN "bulgariska" ;
  buljong_nn_1 = mkN "buljong" "buljonger" ;
  buljongben_nn_1 = mkN "buljongben" neutrum ;
  buljongtaerning_nn_1 = mkN "buljongtдrning" ;
  bulkfartyg_nn_1 = mkN "bulkfartyg" neutrum ;
  bulklast_nn_1 = mkN "bulklast" "bulklaster" ;
  bulklastare_nn_1 = mkN "bulklastare" "bulklastare" ;
  bulkmedel_nn_1 = mkN "bulkmedel" neutrum ;
  bulldogg_nn_1 = mkN "bulldogg" ;
  bulldozer_nn_1 = mkN "bulldozer" ;
  bulle_nn_1 = mkN "bulle" utrum ;
  buller_nn_1 = mkN "buller" neutrum ;
  bullerbas_nn_1 = mkN "bullerbas" ;
  bullerblomster_nn_1 = mkN "bullerblomster" neutrum ;
  bullersam_av_1 = mkA "bullersam" "bullersamt" "bullersamma" "bullersamma" "bullersammare" "bullersammast" "bullersammaste" ;
  bullersten_nn_1 = mkN "bullersten" "bullerstenen" "bullerstenar" "bullerstenarna" ;
  bulletin_nn_1 = mkN "bulletin" "bulletiner" ;
  bullig_av_1 = mkA "bullig" ;
  bullrig_av_1 = mkA "bullrig" ;
  bulnad_nn_1 = mkN "bulnad" "bulnader" ;
  bulsig_av_1 = mkA "bulsig" ;
  bult_nn_1 = mkN "bult" ;
  bultpistol_nn_1 = mkN "bultpistol" "bultpistoler" ;
  bultsax_nn_1 = mkN "bultsax" ;
  bulvan_nn_1 = mkN "bulvan" "bulvaner" ;
  bumerang_nn_1 = mkN "bumerang" "bumeranger" ;
  bumling_nn_1 = mkN "bumling" ;
  bums_ab_1 = mkAdv "bums" ;
  bunden_av_1 = mkA "bunden" "bundet" ;
  bundsfoervant_nn_1 = mkN "bundsfцrvant" "bundsfцrvanter" ;
  bungalow_nn_1 = mkN "bungalow" "bungalower" ;
  bunke_nn_1 = mkN "bunke" utrum ;
  bunker_nn_1 = mkN "bunker" ;
  bunsenbraennare_nn_1 = mkN "bunsenbrдnnare" "bunsenbrдnnare" ;
  bunt_nn_1 = mkN "bunt" ;
  buntmakare_nn_1 = mkN "buntmakare" "buntmakare" ;
  bur_nn_1 = mkN "bur" ;
  burbrev_nn_1 = mkN "burbrev" neutrum ;
  burdus_av_1 = mkA "burdus" ;
  burfaagel_nn_1 = mkN "burfеgel" ;
  burgare_nn_1 = mkN "burgare" "burgare" ;
  burgen_av_1 = mkA "burgen" "burget" ;
  burgunder_nn_1 = mkN "burgunder" "burgundern" "burgunder" "burgunderna" ;
  burk_nn_1 = mkN "burk" ;
  burkoel_nn_1 = mkN "burkцl" neutrum ;
  burkoeppnare_nn_1 = mkN "burkцppnare" "burkцppnare" ;
  burlesk_av_1 = mkA "burlesk" ;
  burlesk_nn_1 = mkN "burlesk" "burlesker" ;
  burleskeri_nn_1 = mkN "burleskeri" "burleskerit" "burleskerier" "burleskerierna" ;
  burman_nn_1 = mkN "burman" "burmaner" ;
  burmanska_nn_2 = mkN "burmanska" ;
  burmes_nn_1 = mkN "burmes" "burmeser" ;
  burnus_nn_1 = mkN "burnus" ;
  burr_nn_1 = mkN "burr" neutrum ;
  burrig_av_1 = mkA "burrig" ;
  burschikos_av_1 = mkA "burschikos" ;
  burspraak_nn_1 = mkN "bursprеk" neutrum ;
  burundier_nn_1 = mkN "burundier" "burundiern" "burundier" "burundierna" ;
  burundisk_av_1 = mkA "burundisk" ;
  buse_nn_1 = mkN "buse" utrum ;
  busfason_nn_1 = mkN "busfason" "busfasoner" ;
  busfroe_nn_1 = mkN "busfrц" "busfrцt" "busfrцn" "busfrцen" ;
  bushman_nn_1 = mkN "bushman" "bushmannen" "bushmдn" "bushmдnnen" ;
  busig_av_1 = mkA "busig" ;
  business_nn_1 = mkN "business" ;
  buskablyg_av_1 = mkA "buskablyg" ;
  buskage_nn_1 = mkN "buskage" "buskaget" "buskage" "buskagen" ;
  buske_nn_1 = mkN "buske" utrum ;
  buskig_av_1 = mkA "buskig" ;
  buskliknande_av_1 = mkA "buskliknande" ;
  buskoerning_nn_1 = mkN "buskцrning" ;
  busksly_nn_1 = mkN "busksly" "buskslyet" "buskslyn" "buskslyna" ;
  buss_nn_1 = mkN "buss" ;
  bussarong_nn_1 = mkN "bussarong" "bussaronger" ;
  busschauffoer_nn_1 = mkN "busschauffцr" "busschauffцrer" ;
  bussfoerbindelse_nn_1 = mkN "bussfцrbindelse" "bussfцrbindelser" ;
  busshaallplats_nn_1 = mkN "busshеllplats" "busshеllplatser" ;
  bussig_av_1 = mkA "bussig" ;
  busskort_nn_1 = mkN "busskort" neutrum ;
  busslast_nn_1 = mkN "busslast" "busslaster" ;
  busslinje_nn_1 = mkN "busslinje" "busslinjer" ;
  bussning_nn_1 = mkN "bussning" ;
  busunge_nn_1 = mkN "busunge" utrum ;
  busvissling_nn_1 = mkN "busvissling" ;
  butan_nn_1 = mkN "butan" "butaner" ;
  butelj_nn_1 = mkN "butelj" "buteljer" ;
  buteljborste_nn_1 = mkN "buteljborste" utrum ;
  buteljbotten_nn_1 = mkN "buteljbotten" ;
  buteljering_nn_1 = mkN "buteljering" ;
  buteljgroen_av_1 = mkA "buteljgrцn" ;
  butik_nn_1 = mkN "butik" "butiker" ;
  butiksbitraede_nn_1 = mkN "butiksbitrдde" ;
  butikskedja_nn_1 = mkN "butikskedja" ;
  butiksstaengningslag_nn_1 = mkN "butiksstдngningslag" ;
  butler_nn_1 = mkN "butler" "butlern" "butlers" "butlersen" ;
  butter_av_1 = mkA "butter" "buttert" "buttra" "buttra" "buttrare" "buttrast" "buttraste" ;
  butyl_nn_1 = mkN "butyl" "butyler" ;
  buxbom_nn_1 = mkN "buxbom" ;
  by_nn_1 = mkN "by" "byn" "byar" "byarna" ;
  byaeldste_nn_1 = mkN "byдldste" utrum ;
  byalag_nn_1 = mkN "byalag" neutrum ;
  byamaal_nn_1 = mkN "byamеl" neutrum ;
  byfaane_nn_1 = mkN "byfеne" utrum ;
  byffe_nn_1 = mkN "byffй" "byffйer" ;
  byfogde_nn_1 = mkN "byfogde" utrum ;
  bygd_nn_1 = mkN "bygd" "bygder" ;
  bygdeborg_nn_1 = mkN "bygdeborg" ;
  bygdegaard_nn_1 = mkN "bygdegеrd" ;
  bygdemaal_nn_1 = mkN "bygdemеl" neutrum ;
  bygel_nn_1 = mkN "bygel" ;
  bygelhaest_nn_1 = mkN "bygelhдst" ;
  bygelhorn_nn_1 = mkN "bygelhorn" neutrum ;
  bygellaas_nn_1 = mkN "bygellеs" neutrum ;
  byggarbetare_nn_1 = mkN "byggarbetare" "byggarbetare" ;
  byggare_nn_1 = mkN "byggare" "byggare" ;
  byggelement_nn_1 = mkN "byggelement" neutrum ;
  byggherre_nn_1 = mkN "byggherre" utrum ;
  byggkloss_nn_1 = mkN "byggkloss" ;
  bygglag_nn_1 = mkN "bygglag" ;
  bygglekplats_nn_1 = mkN "bygglekplats" "bygglekplatser" ;
  bygglov_nn_1 = mkN "bygglov" neutrum ;
  byggmaestare_nn_1 = mkN "byggmдstare" "byggmдstare" ;
  byggmaterial_nn_1 = mkN "byggmaterial" neutrum ;
  byggnad_nn_1 = mkN "byggnad" "byggnader" ;
  byggnadsarbetare_nn_1 = mkN "byggnadsarbetare" "byggnadsarbetare" ;
  byggnadsindustri_nn_1 = mkN "byggnadsindustri" "byggnadsindustrier" ;
  byggnadskonstruktion_nn_1 = mkN "byggnadskonstruktion" "byggnadskonstruktioner" ;
  byggnadskontor_nn_1 = mkN "byggnadskontor" neutrum ;
  byggnadskredit_nn_1 = mkN "byggnadskredit" "byggnadskrediter" ;
  byggnadskreditiv_nn_1 = mkN "byggnadskreditiv" neutrum ;
  byggnadslaan_nn_1 = mkN "byggnadslеn" neutrum ;
  byggnadslov_nn_1 = mkN "byggnadslov" neutrum ;
  byggnadsmaterial_nn_1 = mkN "byggnadsmaterial" neutrum ;
  byggnadsminne_nn_1 = mkN "byggnadsminne" ;
  byggnadsnaemnd_nn_1 = mkN "byggnadsnдmnd" "byggnadsnдmnder" ;
  byggnadsplan_nn_1 = mkN "byggnadsplan" "byggnadsplaner" ;
  byggnadssnickare_nn_1 = mkN "byggnadssnickare" "byggnadssnickare" ;
  byggnadsstaellning_nn_1 = mkN "byggnadsstдllning" ;
  byggnadssten_nn_1 = mkN "byggnadssten" "byggnadsstenen" "byggnadsstenar" "byggnadsstenarna" ;
  byggnadsstil_nn_1 = mkN "byggnadsstil" ;
  byggnadsstyrelse_nn_1 = mkN "byggnadsstyrelse" "byggnadsstyrelser" ;
  byggnadstillstaand_nn_1 = mkN "byggnadstillstеnd" neutrum ;
  byggnadsverk_nn_1 = mkN "byggnadsverk" neutrum ;
  byggning_nn_1 = mkN "byggning" ;
  byggsats_nn_1 = mkN "byggsats" "byggsatser" ;
  byggstart_nn_1 = mkN "byggstart" "byggstarter" ;
  byggsten_nn_1 = mkN "byggsten" "byggstenen" "byggstenar" "byggstenarna" ;
  byggstopp_nn_1 = mkN "byggstopp" neutrum ;
  byggtork_nn_1 = mkN "byggtork" ;
  byhus_nn_1 = mkN "byhus" neutrum ;
  byig_av_1 = mkA "byig" ;
  byk_nn_1 = mkN "byk" ;
  byling_nn_1 = mkN "byling" ;
  bylsig_av_1 = mkA "bylsig" ;
  bymoln_nn_1 = mkN "bymoln" neutrum ;
  byomraade_nn_1 = mkN "byomrеde" ;
  byordning_nn_1 = mkN "byordning" ;
  byraa_nn_1 = mkN "byrе" ;
  byraa_nn_2 = mkN "byrе" "byrеer" ;
  byraaassistent_nn_1 = mkN "byrеassistent" "byrеassistenter" ;
  byraachef_nn_1 = mkN "byrеchef" "byrеchefer" ;
  byraadirektoer_nn_1 = mkN "byrеdirektцr" "byrеdirektцrer" ;
  byraakrat_nn_1 = mkN "byrеkrat" "byrеkrater" ;
  byraakrati_nn_1 = mkN "byrеkrati" "byrеkratier" ;
  byraakratisk_av_1 = mkA "byrеkratisk" ;
  byraasekreterare_nn_1 = mkN "byrеsekreterare" "byrеsekreterare" ;
  byrett_nn_1 = mkN "byrett" "byretter" ;
  bysamfaellighet_nn_1 = mkN "bysamfдllighet" "bysamfдlligheter" ;
  bysantin_nn_1 = mkN "bysantin" "bysantiner" ;
  bysantinsk_av_1 = mkA "bysantinsk" ;
  byssja_nn_1 = mkN "byssja" ;
  byst_nn_1 = mkN "byst" "byster" ;
  bystaemma_nn_1 = mkN "bystдmma" ;
  bystdrottning_nn_1 = mkN "bystdrottning" ;
  bysthaallare_nn_1 = mkN "bysthеllare" "bysthеllare" ;
  bystmaatt_nn_1 = mkN "bystmеtt" neutrum ;
  byte_nn_1 = mkN "byte" ;
  byte_nn_2 = mkN "byte" "byten" "byte" "bytena" ;
  bytesaffaer_nn_1 = mkN "bytesaffдr" "bytesaffдrer" ;
  bytesdjur_nn_1 = mkN "bytesdjur" neutrum ;
  byteslaegenhet_nn_1 = mkN "byteslдgenhet" "byteslдgenheter" ;
  bytesmedel_nn_1 = mkN "bytesmedel" neutrum ;
  bytesobjekt_nn_1 = mkN "bytesobjekt" neutrum ;
  bytesvaerde_nn_1 = mkN "bytesvдrde" ;
  byting_nn_1 = mkN "byting" ;
  byx_nn_1 = mkN "byx" ;
  byxbak_nn_1 = mkN "byxbak" ;
  byxben_nn_1 = mkN "byxben" neutrum ;
  byxdraekt_nn_1 = mkN "byxdrдkt" "byxdrдkter" ;
  byxdress_nn_1 = mkN "byxdress" ;
  byxholk_nn_1 = mkN "byxholk" ;
  byxis_av_1 = mkA "byxis" ;
  byxkjol_nn_1 = mkN "byxkjol" ;
  cab_nn_1 = mkN "cab" ;
  cabb_nn_1 = mkN "cabb" ;
  cabriolet_nn_1 = mkN "cabriolet" "cabrioleter" ;
  caddie_nn_1 = mkN "caddie" "caddien" "caddies" "caddiesen" ;
  cafe_nn_1 = mkN "cafй" "cafйt" "cafйer" "cafйerna" ;
  callgirl_nn_1 = mkN "callgirl" "callgirlen" "callgirls" "callgirlsen" ;
  calmettevaccinering_nn_1 = mkN "calmettevaccinering" ;
  camouflage_nn_1 = mkN "camouflage" "camouflaget" "camouflage" "camouflagen" ;
  camp_av_1 = mkA "camp" "camp" ;
  campare_nn_1 = mkN "campare" "campare" ;
  camping_nn_1 = mkN "camping" ;
  campingplats_nn_1 = mkN "campingplats" "campingplatser" ;
  campus_nn_1 = mkN "campus" neutrum ;
  cancer_nn_1 = mkN "cancer" ;
  cancerfall_nn_1 = mkN "cancerfall" neutrum ;
  cancerfara_nn_1 = mkN "cancerfara" ;
  cancerform_nn_1 = mkN "cancerform" "cancerformer" ;
  cancerforskare_nn_1 = mkN "cancerforskare" "cancerforskare" ;
  cancerforskning_nn_1 = mkN "cancerforskning" ;
  cancerframkallande_av_1 = mkA "cancerframkallande" ;
  cancerogen_av_1 = mkA "cancerogen" ;
  cancerrisk_nn_1 = mkN "cancerrisk" "cancerrisker" ;
  cancersvulst_nn_1 = mkN "cancersvulst" "cancersvulster" ;
  candela_nn_1 = mkN "candela" "candelan" "candela" "candelana" ;
  cape_nn_1 = mkN "cape" "caper" ;
  cappuccino_nn_1 = mkN "cappuccino" "cappuccinon" "cappuccino" "cappuccinona" ;
  carcinogen_nn_1 = mkN "carcinogen" "carcinogener" ;
  cardigan_nn_1 = mkN "cardigan" "cardiganen" "cardigans" "cardigansen" ;
  cash_ab_1 = mkAdv "cash" ;
  cash_nn_1 = mkN "cash" neutrum ;
  caterpillar_nn_1 = mkN "caterpillar" "caterpillarn" "caterpillars" "caterpillarsen" ;
  ceder_nn_1 = mkN "ceder" ;
  cedilj_nn_1 = mkN "cedilj" "cediljer" ;
  celeber_av_1 = mkA "celeber" "celebert" "celebra" "celebra" "celebrare" "celebrast" "celebraste" ;
  celebritet_nn_1 = mkN "celebritet" "celebriteter" ;
  celest_av_1 = mkA "celest" "celest" ;
  celibat_nn_1 = mkN "celibat" neutrum ;
  cell_nn_1 = mkN "cell" "celler" ;
  celldelning_nn_1 = mkN "celldelning" ;
  cellfaengelse_nn_1 = mkN "cellfдngelse" "cellfдngelset" "cellfдngelser" "cellfдngelserna" ;
  cellgift_nn_1 = mkN "cellgift" "cellgiftet" "cellgifter" "cellgifterna" ;
  cellgranne_nn_1 = mkN "cellgranne" utrum ;
  cellist_nn_1 = mkN "cellist" "cellister" ;
  cellkamrat_nn_1 = mkN "cellkamrat" "cellkamrater" ;
  cellmembran_nn_1 = mkN "cellmembran" neutrum ;
  cello_nn_1 = mkN "cello" "cellor" ;
  cellplasma_nn_1 = mkN "cellplasma" "cellplasmat" "cellplasmer" "cellplasmerna" ;
  cellsjok_nn_1 = mkN "cellsjok" neutrum ;
  cellskikt_nn_1 = mkN "cellskikt" neutrum ;
  cellspaenning_nn_1 = mkN "cellspдnning" ;
  cellstraff_nn_1 = mkN "cellstraff" neutrum ;
  cellstruktur_nn_1 = mkN "cellstruktur" "cellstrukturer" ;
  celltraad_nn_1 = mkN "celltrеd" ;
  celltyp_nn_1 = mkN "celltyp" "celltyper" ;
  cellulaer_av_1 = mkA "cellulдr" ;
  cellulosaindustri_nn_1 = mkN "cellulosaindustri" "cellulosaindustrier" ;
  cellulosalack_nn_1 = mkN "cellulosalack" neutrum ;
  cellulosamolekyl_nn_1 = mkN "cellulosamolekyl" "cellulosamolekyler" ;
  cellulosanitrat_nn_1 = mkN "cellulosanitrat" neutrum ;
  cellulosaplast_nn_1 = mkN "cellulosaplast" "cellulosaplaster" ;
  cellvaegg_nn_1 = mkN "cellvдgg" ;
  celsiusgrad_nn_1 = mkN "celsiusgrad" "celsiusgrader" ;
  celsiustermometer_nn_1 = mkN "celsiustermometer" ;
  celt_nn_1 = mkN "celt" "celter" ;
  cembalist_nn_1 = mkN "cembalist" "cembalister" ;
  cembalo_nn_1 = mkN "cembalo" "cembalor" ;
  cementblandare_nn_1 = mkN "cementblandare" "cementblandare" ;
  cementering_nn_1 = mkN "cementering" ;
  cenakel_nn_1 = mkN "cenakel" neutrum ;
  cendre_av_1 = mkA "cendrй" ;
  censor_nn_1 = mkN "censor" "censorer" ;
  census_nn_1 = mkN "census" ;
  cent_nn_1 = mkN "cent" "centen" "cent" "centen" ;
  centaur_nn_1 = mkN "centaur" "centaurer" ;
  center_nn_1 = mkN "center" ;
  center_nn_2 = mkN "center" "centret" "centrer" "centrerna" ;
  centerback_nn_1 = mkN "centerback" ;
  centerbord_nn_1 = mkN "centerbord" neutrum ;
  centerforward_nn_1 = mkN "centerforward" ;
  centerhalv_nn_1 = mkN "centerhalv" ;
  centerparti_nn_1 = mkN "centerparti" "centerpartit" "centerpartier" "centerpartierna" ;
  centerpartist_nn_1 = mkN "centerpartist" "centerpartister" ;
  centiliter_nn_1 = mkN "centiliter" "centilitern" "centiliter" "centiliterna" ;
  centilong_nn_1 = mkN "centilong" "centilongen" "centilong" "centilongen" ;
  centimeter_nn_1 = mkN "centimeter" ;
  centner_nn_1 = mkN "centner" "centnern" "centner" "centnerna" ;
  central_av_1 = mkA "central" ;
  centralafrikan_nn_1 = mkN "centralafrikan" "centralafrikaner" ;
  centralafrikansk_av_1 = mkA "centralafrikansk" ;
  centralamerikansk_av_1 = mkA "centralamerikansk" ;
  centralanstalt_nn_1 = mkN "centralanstalt" "centralanstalter" ;
  centralantenn_nn_1 = mkN "centralantenn" "centralantenner" ;
  centralbank_nn_1 = mkN "centralbank" "centralbanker" ;
  centralbyggnad_nn_1 = mkN "centralbyggnad" "centralbyggnader" ;
  centralbyraa_nn_1 = mkN "centralbyrе" "centralbyrеer" ;
  centralenhet_nn_1 = mkN "centralenhet" "centralenheter" ;
  centraleuropeisk_av_1 = mkA "centraleuropeisk" ;
  centralfoerbund_nn_1 = mkN "centralfцrbund" neutrum ;
  centralfoervaltning_nn_1 = mkN "centralfцrvaltning" ;
  centralgestalt_nn_1 = mkN "centralgestalt" "centralgestalter" ;
  centralisering_nn_1 = mkN "centralisering" ;
  centralistisk_av_1 = mkA "centralistisk" ;
  centralkommitte_nn_1 = mkN "centralkommittй" "centralkommittйer" ;
  centralkontor_nn_1 = mkN "centralkontor" neutrum ;
  centralkyrka_nn_1 = mkN "centralkyrka" ;
  centrallasarett_nn_1 = mkN "centrallasarett" neutrum ;
  centrallyrisk_av_1 = mkA "centrallyrisk" ;
  centralmakt_nn_1 = mkN "centralmakt" "centralmakter" ;
  centralnaemnd_nn_1 = mkN "centralnдmnd" "centralnдmnder" ;
  centralorganisation_nn_1 = mkN "centralorganisation" "centralorganisationer" ;
  centralort_nn_1 = mkN "centralort" "centralorter" ;
  centralregering_nn_1 = mkN "centralregering" ;
  centralroerelse_nn_1 = mkN "centralrцrelse" "centralrцrelser" ;
  centralstation_nn_1 = mkN "centralstation" "centralstationer" ;
  centralstimulantia_nn_1 = mkN "centralstimulantia" "centralstimulantian" "centralstimulantia" "centralstimulantiana" ;
  centralstimulerande_av_1 = mkA "centralstimulerande" ;
  centralstyrd_av_1 = mkA "centralstyrd" "centralstyrt" ;
  centralstyrelse_nn_1 = mkN "centralstyrelse" "centralstyrelser" ;
  centrifug_nn_1 = mkN "centrifug" "centrifuger" ;
  centrifugal_av_1 = mkA "centrifugal" ;
  centrifugalpump_nn_1 = mkN "centrifugalpump" ;
  centripetal_av_1 = mkA "centripetal" ;
  centrisk_av_1 = mkA "centrisk" ;
  centrum_nn_1 = mkN "centrum" neutrum ;
  centumspraak_nn_1 = mkN "centumsprеk" neutrum ;
  cerat_nn_1 = mkN "cerat" neutrum ;
  cerebral_av_1 = mkA "cerebral" ;
  cerebrospinal_av_1 = mkA "cerebrospinal" ;
  ceremoni_nn_1 = mkN "ceremoni" "ceremonier" ;
  ceremoniel_nn_1 = mkN "ceremoniel" "ceremonielet" "ceremoniel" "ceremonielen" ;
  ceremoniell_av_1 = mkA "ceremoniell" ;
  ceremonimaestare_nn_1 = mkN "ceremonimдstare" "ceremonimдstare" ;
  ceremonioes_av_1 = mkA "ceremoniцs" ;
  cerise_av_1 = mkA "cerise" ;
  cerise_nn_1 = mkN "cerise" "ceriser" ;
  cernering_nn_1 = mkN "cernering" ;
  cert_nn_1 = mkN "cert" "certer" ;
  certeparti_nn_1 = mkN "certeparti" "certepartit" "certepartier" "certepartierna" ;
  certifikat_nn_1 = mkN "certifikat" neutrum ;
  cesarisk_av_1 = mkA "cesarisk" ;
  cession_nn_1 = mkN "cession" "cessioner" ;
  cesur_nn_1 = mkN "cesur" "cesurer" ;
  champagneglas_nn_1 = mkN "champagneglas" neutrum ;
  champagnekork_nn_1 = mkN "champagnekork" ;
  champinjon_nn_1 = mkN "champinjon" "champinjoner" ;
  champinjonbaedd_nn_1 = mkN "champinjonbдdd" ;
  champion_nn_1 = mkN "champion" "championen" "champions" "championsen" ;
  championat_nn_1 = mkN "championat" neutrum ;
  changemang_nn_1 = mkN "changemang" neutrum ;
  chans_nn_1 = mkN "chans" "chanser" ;
  chansloes_av_1 = mkA "chanslцs" ;
  chansning_nn_1 = mkN "chansning" ;
  chanson_nn_1 = mkN "chanson" "chansoner" ;
  chansonett_nn_1 = mkN "chansonett" "chansonetter" ;
  chanstagare_nn_1 = mkN "chanstagare" "chanstagare" ;
  chanstagning_nn_1 = mkN "chanstagning" ;
  chapeau_claque_nn_1 = mkN "chapeau-claque" "chapeau-claquer" ;
  char_nn_1 = mkN "char" "charer" ;
  charabang_nn_1 = mkN "charabang" "charabanger" ;
  charad_nn_1 = mkN "charad" "charader" ;
  charge_d'27affaires_nn_1 = mkN "chargй-d'affaires" "chargй-d'affaireser" ;
  charge_nn_1 = mkN "charge" "charger" ;
  charkuteri_nn_1 = mkN "charkuteri" "charkuterit" "charkuterier" "charkuterierna" ;
  charkuterist_nn_1 = mkN "charkuterist" "charkuterister" ;
  charlatan_nn_1 = mkN "charlatan" "charlataner" ;
  charmant_av_1 = mkA "charmant" "charmant" ;
  charmfull_av_1 = mkA "charmfull" ;
  charmig_av_1 = mkA "charmig" ;
  charmkurs_nn_1 = mkN "charmkurs" "charmkurser" ;
  charmloes_av_1 = mkA "charmlцs" ;
  charmoer_nn_1 = mkN "charmцr" "charmцrer" ;
  charmoffensiv_nn_1 = mkN "charmoffensiv" "charmoffensiver" ;
  charmtroll_nn_1 = mkN "charmtroll" neutrum ;
  charner_nn_1 = mkN "charner" "charneret" "charner" "charneren" ;
  chartreuse_nn_1 = mkN "chartreuse" "chartreuser" ;
  chassi_nn_1 = mkN "chassi" "chassit" "chassier" "chassierna" ;
  chateaubriand_nn_1 = mkN "chateaubriand" "chateaubriander" ;
  chauffoer_nn_1 = mkN "chauffцr" "chauffцrer" ;
  chausse_nn_1 = mkN "chaussй" "chaussйer" ;
  chauvinist_nn_1 = mkN "chauvinist" "chauvinister" ;
  chauvinistisk_av_1 = mkA "chauvinistisk" ;
  check_nn_1 = mkN "check" ;
  checkhaefte_nn_1 = mkN "checkhдfte" ;
  checkkonto_nn_1 = mkN "checkkonto" "checkkontot" "checkkonton" "checkkontona" ;
  checkkredit_nn_1 = mkN "checkkredit" "checkkrediter" ;
  checkraekning_nn_1 = mkN "checkrдkning" ;
  cheddarost_nn_1 = mkN "cheddarost" ;
  chef_nn_1 = mkN "chef" "chefer" ;
  chefredaktoer_nn_1 = mkN "chefredaktцr" "chefredaktцrer" ;
  chefsideolog_nn_1 = mkN "chefsideolog" "chefsideologer" ;
  chefstjaensteman_nn_1 = mkN "chefstjдnsteman" "chefstjдnstemannen" "chefstjдnstemдn" "chefstjдnstemдnnen" ;
  chemis_nn_1 = mkN "chemis" "chemiser" ;
  chemisett_nn_1 = mkN "chemisett" "chemisetter" ;
  chevaleresk_av_1 = mkA "chevaleresk" ;
  chevelyr_nn_1 = mkN "chevelyr" "chevelyrer" ;
  cheviot_nn_1 = mkN "cheviot" "chevioter" ;
  chic_av_1 = mkA "chic" ;
  chiffer_nn_1 = mkN "chiffer" neutrum ;
  chiffernyckel_nn_1 = mkN "chiffernyckel" ;
  chiffong_nn_1 = mkN "chiffong" "chiffonger" ;
  chiffonje_nn_1 = mkN "chiffonjй" "chiffonjйer" ;
  chikan_nn_1 = mkN "chikan" "chikaner" ;
  chilen_nn_1 = mkN "chilen" "chilener" ;
  chilenare_nn_1 = mkN "chilenare" "chilenare" ;
  chilensk_av_1 = mkA "chilensk" ;
  chimaer_nn_1 = mkN "chimдr" "chimдrer" ;
  chinjong_nn_1 = mkN "chinjong" "chinjonger" ;
  chips_nn_1 = mkN "chips" neutrum ;
  chock_nn_1 = mkN "chock" "chocker" ;
  chockbehandling_nn_1 = mkN "chockbehandling" ;
  chockrosa_av_1 = mkA "chockrosa" ;
  choke_nn_1 = mkN "choke" utrum ;
  choklad_nn_1 = mkN "choklad" "choklader" ;
  chokladbit_nn_1 = mkN "chokladbit" ;
  chokladpudding_nn_1 = mkN "chokladpudding" ;
  chosefri_av_1 = mkA "chosefri" "chosefritt" ;
  chosig_av_1 = mkA "chosig" ;
  chuck_nn_1 = mkN "chuck" ;
  ciceron_nn_1 = mkN "ciceron" "ciceroner" ;
  cif_ab_1 = mkAdv "cif" ;
  cigarett_nn_1 = mkN "cigarett" "cigaretter" ;
  cigarettaendare_nn_1 = mkN "cigarettдndare" "cigarettдndare" ;
  cigarettfimp_nn_1 = mkN "cigarettfimp" ;
  cigarettpaket_nn_1 = mkN "cigarettpaket" neutrum ;
  cigarettroek_nn_1 = mkN "cigarettrцk" ;
  cigarill_nn_1 = mkN "cigarill" "cigariller" ;
  cigarr_nn_1 = mkN "cigarr" "cigarrer" ;
  cigarrcigarett_nn_1 = mkN "cigarrcigarett" "cigarrcigaretter" ;
  cigarrett_nn_1 = mkN "cigarrett" "cigarretter" ;
  cigarrettaendare_nn_1 = mkN "cigarrettдndare" "cigarrettдndare" ;
  cigarrettfimp_nn_1 = mkN "cigarrettfimp" ;
  cigarrettpaket_nn_1 = mkN "cigarrettpaket" neutrum ;
  ciklidfisk_nn_1 = mkN "ciklidfisk" ;
  ciliarkropp_nn_1 = mkN "ciliarkropp" ;
  ciliarmuskel_nn_1 = mkN "ciliarmuskel" "ciliarmuskeln" "ciliarmuskler" "ciliarmusklerna" ;
  cilie_nn_1 = mkN "cilie" "cilier" ;
  cineast_nn_1 = mkN "cineast" "cineaster" ;
  cinematek_nn_1 = mkN "cinematek" neutrum ;
  cirka_ab_1 = mkAdv "cirka" ;
  cirkapris_nn_1 = mkN "cirkapris" neutrum ;
  cirkel_nn_1 = mkN "cirkel" ;
  cirkelbaage_nn_1 = mkN "cirkelbеge" utrum ;
  cirkelben_nn_1 = mkN "cirkelben" neutrum ;
  cirkelbevis_nn_1 = mkN "cirkelbevis" neutrum ;
  cirkeldefinition_nn_1 = mkN "cirkeldefinition" "cirkeldefinitioner" ;
  cirkelledare_nn_1 = mkN "cirkelledare" "cirkelledare" ;
  cirkelperiferi_nn_1 = mkN "cirkelperiferi" "cirkelperiferier" ;
  cirkelprocess_nn_1 = mkN "cirkelprocess" "cirkelprocesser" ;
  cirkelroerelse_nn_1 = mkN "cirkelrцrelse" "cirkelrцrelser" ;
  cirkelrund_av_1 = mkA "cirkelrund" ;
  cirkelsaag_nn_1 = mkN "cirkelsеg" ;
  cirkelsegment_nn_1 = mkN "cirkelsegment" neutrum ;
  cirkelsektor_nn_1 = mkN "cirkelsektor" "cirkelsektorer" ;
  cirkelslut_nn_1 = mkN "cirkelslut" neutrum ;
  cirkulaer_av_1 = mkA "cirkulдr" ;
  cirkulaer_nn_1 = mkN "cirkulдr" neutrum ;
  cirkulaerledare_nn_1 = mkN "cirkulдrledare" "cirkulдrledare" ;
  cirkulationsplats_nn_1 = mkN "cirkulationsplats" "cirkulationsplatser" ;
  cirkulationspump_nn_1 = mkN "cirkulationspump" ;
  cirkulationsrubbning_nn_1 = mkN "cirkulationsrubbning" ;
  cirkumflex_nn_1 = mkN "cirkumflex" "cirkumflexer" ;
  cirkumpolaer_av_1 = mkA "cirkumpolдr" ;
  cirkumpolar_av_1 = mkA "cirkumpolar" ;
  cirkus_nn_1 = mkN "cirkus" ;
  cirkusarena_nn_1 = mkN "cirkusarena" ;
  cirkusartist_nn_1 = mkN "cirkusartist" "cirkusartister" ;
  cirkusdjur_nn_1 = mkN "cirkusdjur" neutrum ;
  cirkusmanege_nn_1 = mkN "cirkusmanege" "cirkusmaneger" ;
  cirkusnummer_nn_1 = mkN "cirkusnummer" neutrum ;
  cirrusmoln_nn_1 = mkN "cirrusmoln" neutrum ;
  cisalpinsk_av_1 = mkA "cisalpinsk" ;
  ciseloer_nn_1 = mkN "ciselцr" "ciselцrer" ;
  ciss_nn_1 = mkN "ciss" neutrum ;
  cissus_nn_1 = mkN "cissus" ;
  cisterciens_nn_1 = mkN "cisterciens" "cistercienser" ;
  cisterciensorden_nn_1 = mkN "cisterciensorden" ;
  cistern_nn_1 = mkN "cistern" "cisterner" ;
  citadell_nn_1 = mkN "citadell" neutrum ;
  citat_nn_1 = mkN "citat" neutrum ;
  citation_nn_1 = mkN "citation" "citationer" ;
  citationstecken_nn_1 = mkN "citationstecken" "citationstecknet" "citationstecken" "citationstecknen" ;
  citatord_nn_1 = mkN "citatord" neutrum ;
  citrin_nn_1 = mkN "citrin" "citriner" ;
  citron_nn_1 = mkN "citron" "citroner" ;
  citronfjaeril_nn_1 = mkN "citronfjдril" ;
  citrongul_av_1 = mkA "citrongul" ;
  citronlaesk_nn_1 = mkN "citronlдsk" "citronlдsken" "citronlдsk" "citronlдsken" ;
  citronskal_nn_1 = mkN "citronskal" neutrum ;
  citrus_nn_1 = mkN "citrus" ;
  citrusfrukt_nn_1 = mkN "citrusfrukt" "citrusfrukter" ;
  cittra_nn_1 = mkN "cittra" ;
  city_nn_1 = mkN "city" "cityt" "cityn" "cityna" ;
  citydress_nn_1 = mkN "citydress" ;
  civil_av_1 = mkA "civil" ;
  civilaektenskap_nn_1 = mkN "civilдktenskap" "civilдktenskapet" "civilдktenskapen" "civilдktenskapena" ;
  civilbegravning_nn_1 = mkN "civilbegravning" ;
  civilekonom_nn_1 = mkN "civilekonom" "civilekonomer" ;
  civilingenjoer_nn_1 = mkN "civilingenjцr" "civilingenjцrer" ;
  civilisation_nn_1 = mkN "civilisation" "civilisationer" ;
  civilisatorisk_av_1 = mkA "civilisatorisk" ;
  civilist_nn_1 = mkN "civilist" "civilister" ;
  civilklaedd_av_1 = mkA "civilklдdd" "civilklдdtt" ;
  civillag_nn_1 = mkN "civillag" ;
  civilmaal_nn_1 = mkN "civilmеl" neutrum ;
  civilmilitaer_av_1 = mkA "civilmilitдr" ;
  civilmilitaer_nn_1 = mkN "civilmilitдr" "civilmilitдrer" ;
  civilprocess_nn_1 = mkN "civilprocess" "civilprocesser" ;
  civilstaand_nn_1 = mkN "civilstеnd" neutrum ;
  civilstat_nn_1 = mkN "civilstat" "civilstater" ;
  clairobscur_nn_1 = mkN "clairobscur" "clairobscurer" ;
  clairvoyance_nn_1 = mkN "clairvoyance" "clairvoyancer" ;
  clairvoyant_av_1 = mkA "clairvoyant" "clairvoyant" ;
  clematis_nn_1 = mkN "clematis" ;
  clementin_nn_1 = mkN "clementin" "clementiner" ;
  clips_nn_1 = mkN "clips" neutrum ;
  clitoris_nn_1 = mkN "clitoris" ;
  cloisonvaegg_nn_1 = mkN "cloisonvдgg" ;
  cloque_nn_1 = mkN "cloquй" "cloquйer" ;
  clown_nn_1 = mkN "clown" "clowner" ;
  clowneri_nn_1 = mkN "clowneri" "clownerit" "clownerier" "clownerierna" ;
  club_blazer_nn_1 = mkN "club-blazer" ;
  clubstek_nn_1 = mkN "clubstek" ;
  coach_nn_1 = mkN "coach" "coacher" ;
  cockerspaniel_nn_1 = mkN "cockerspaniel" "cockerspanieln" "cockerspanielar" "cockerspanielarna" ;
  cockpit_nn_1 = mkN "cockpit" ;
  cocktail_nn_1 = mkN "cocktail" ;
  cocktailbaer_nn_1 = mkN "cocktailbдr" neutrum ;
  cocktailparty_nn_1 = mkN "cocktailparty" "cocktailpartyt" "cocktailpartyn" "cocktailpartyna" ;
  codex_nn_1 = mkN "codex" ;
  collage_nn_1 = mkN "collage" "collaget" "collage" "collagen" ;
  college_nn_1 = mkN "college" "colleget" "college" "collegen" ;
  collie_nn_1 = mkN "collie" "collien" "collies" "colliesen" ;
  collier_nn_1 = mkN "collier" "collierer" ;
  colombian_nn_1 = mkN "colombian" "colombianer" ;
  colombiansk_av_1 = mkA "colombiansk" ;
  colombianska_nn_1 = mkN "colombianska" ;
  come_back_nn_1 = mkN "come-back" "come-backer" ;
  comeback_nn_1 = mkN "comeback" "comebacker" ;
  commando_nn_1 = mkN "commando" "commandon" "commandos" "commandosen" ;
  commandotrupp_nn_1 = mkN "commandotrupp" "commandotrupper" ;
  comme_il_faut_ab_1 = mkAdv "comme-il-faut" ;
  comorier_nn_1 = mkN "comorier" "comoriern" "comorier" "comorierna" ;
  comorisk_av_1 = mkA "comorisk" ;
  conferencier_nn_1 = mkN "confйrencier" "confйrencierer" ;
  consomme_nn_1 = mkN "consommй" "consommйer" ;
  container_nn_1 = mkN "container" ;
  contortatall_nn_1 = mkN "contortatall" ;
  cool_av_1 = mkA "cool" ;
  copywriter_nn_1 = mkN "copywriter" "copywritern" "copywriters" "copywritersen" ;
  cornichon_nn_1 = mkN "cornichon" "cornichoner" ;
  coronacell_nn_1 = mkN "coronacell" "coronaceller" ;
  corps_de_logi_nn_1 = mkN "corps-de-logi" "corps-de-logit" "corps-de-logier" "corps-de-logierna" ;
  corpus_nn_1 = mkN "corpus" ;
  cortege_nn_1 = mkN "cortиge" "cortиger" ;
  cortical_av_1 = mkA "cortical" ;
  cortison_nn_1 = mkN "cortison" "cortisoner" ;
  cosinus_nn_1 = mkN "cosinus" ;
  costarican_nn_1 = mkN "costarican" "costaricaner" ;
  costaricansk_av_1 = mkA "costaricansk" ;
  cotangent_nn_1 = mkN "cotangent" "cotangenter" ;
  coulomb_nn_1 = mkN "coulomb" "coulomben" "coulomb" "coulomben" ;
  coupe_nn_1 = mkN "coupe" "couper" ;
  cowboy_nn_1 = mkN "cowboy" "cowboyen" "cowboyer" "cowboyerna" ;
  crazy_av_1 = mkA "crazy" ;
  credo_nn_1 = mkN "credo" "credot" "credon" "credona" ;
  creme_nn_1 = mkN "crиme" "crиmer" ;
  crepe_nn_1 = mkN "crepe" "crepen" "crepes" "crepesen" ;
  crescendo_ab_1 = mkAdv "crescendo" ;
  crescendo_nn_1 = mkN "crescendo" "crescendot" "crescendon" "crescendona" ;
  croissant_nn_1 = mkN "croissant" "croissanter" ;
  croquis_nn_1 = mkN "croquis" "croquiser" ;
  crosschecking_nn_1 = mkN "crosschecking" ;
  croupier_nn_1 = mkN "croupier" "croupierer" ;
  cuban_nn_1 = mkN "cuban" "cubaner" ;
  cubansk_av_1 = mkA "cubansk" ;
  cumulus_nn_1 = mkN "cumulus" ;
  cumuluscell_nn_1 = mkN "cumuluscell" "cumulusceller" ;
  cumulusmoln_nn_1 = mkN "cumulusmoln" neutrum ;
  cup_nn_1 = mkN "cup" "cuper" ;
  curie_nn_1 = mkN "curie" "curien" "curie" "curiena" ;
  cyanblaa_av_1 = mkA "cyanblе" "cyanblеtt" ;
  cyanid_nn_1 = mkN "cyanid" "cyanider" ;
  cyanobakterie_nn_1 = mkN "cyanobakterie" "cyanobakterier" ;
  cybernetisk_av_1 = mkA "cybernetisk" ;
  cykel_nn_1 = mkN "cykel" ;
  cykel_nn_2 = mkN "cykel" ;
  cykeldaeck_nn_1 = mkN "cykeldдck" neutrum ;
  cykelergometer_nn_1 = mkN "cykelergometer" ;
  cykelkedja_nn_1 = mkN "cykelkedja" ;
  cykelpump_nn_1 = mkN "cykelpump" ;
  cykelsadel_nn_1 = mkN "cykelsadel" ;
  cykelslang_nn_1 = mkN "cykelslang" ;
  cykelstaell_nn_1 = mkN "cykelstдll" neutrum ;
  cykelstyre_nn_1 = mkN "cykelstyre" ;
  cykeltaevling_nn_1 = mkN "cykeltдvling" ;
  cykeltrupp_nn_1 = mkN "cykeltrupp" "cykeltrupper" ;
  cykelventil_nn_1 = mkN "cykelventil" "cykelventiler" ;
  cyklamen_nn_1 = mkN "cyklamen" "cyklamen" "cyklamen" "cyklamena" ;
  cyklisk_av_1 = mkA "cyklisk" ;
  cyklist_nn_1 = mkN "cyklist" "cyklister" ;
  cykloid_nn_1 = mkN "cykloid" "cykloider" ;
  cyklometer_nn_1 = mkN "cyklometer" ;
  cyklon_nn_1 = mkN "cyklon" "cykloner" ;
  cyklonfamilj_nn_1 = mkN "cyklonfamilj" "cyklonfamiljer" ;
  cyklop_nn_1 = mkN "cyklop" "cykloper" ;
  cyklop_nn_2 = mkN "cyklop" neutrum ;
  cyklopoega_nn_1 = mkN "cyklopцga" "cyklopцgat" "cyklopцgon" "cyklopцgonen" ;
  cyklotron_nn_1 = mkN "cyklotron" "cyklotroner" ;
  cyklotym_av_1 = mkA "cyklotym" ;
  cylinder_nn_1 = mkN "cylinder" ;
  cylinderblock_nn_1 = mkN "cylinderblock" neutrum ;
  cylinderhatt_nn_1 = mkN "cylinderhatt" ;
  cylinderlaas_nn_1 = mkN "cylinderlеs" neutrum ;
  cylinderpress_nn_1 = mkN "cylinderpress" ;
  cylindrisk_av_1 = mkA "cylindrisk" ;
  cymbal_nn_1 = mkN "cymbal" "cymbaler" ;
  cyniker_nn_1 = mkN "cyniker" "cynikern" "cyniker" "cynikerna" ;
  cynisk_av_1 = mkA "cynisk" ;
  cynism_nn_1 = mkN "cynism" "cynismer" ;
  cypress_nn_1 = mkN "cypress" "cypresser" ;
  cypriot_nn_1 = mkN "cypriot" "cyprioter" ;
  cypriotisk_av_1 = mkA "cypriotisk" ;
  cystoskop_nn_1 = mkN "cystoskop" neutrum ;
  cystoskopi_nn_1 = mkN "cystoskopi" "cystoskopier" ;
  cytologisk_av_1 = mkA "cytologisk" ;
  daa_ab_1 = mkAdv "dе" ;
  daad_nn_1 = mkN "dеd" neutrum ;
  daadrafroe_nn_1 = mkN "dеdrafrц" "dеdrafrцet" "dеdrafrцer" "dеdrafrцerna" ;
  daafoertiden_ab_1 = mkAdv "dеfцrtiden" ;
  daalig_av_1 = mkA "dеlig" ;
  daalighet_nn_1 = mkN "dеlighet" "dеligheter" ;
  daamera_ab_1 = mkAdv "dеmera" ;
  daan_nn_1 = mkN "dеn" neutrum ;
  daandimpen_ab_1 = mkAdv "dеndimpen" ;
  daaraktig_av_1 = mkA "dеraktig" ;
  daare_nn_1 = mkN "dеre" utrum ;
  daarfink_nn_1 = mkN "dеrfink" ;
  daarhus_nn_1 = mkN "dеrhus" neutrum ;
  daarskap_nn_1 = mkN "dеrskap" "dеrskaper" ;
  daasig_av_1 = mkA "dеsig" ;
  daasighet_nn_1 = mkN "dеsighet" "dеsigheter" ;
  daatida_av_1 = mkA "dеtida" ;
  daavarande_av_1 = mkA "dеvarande" ;
  dadaist_nn_1 = mkN "dadaist" "dadaister" ;
  dadaistisk_av_1 = mkA "dadaistisk" ;
  dadel_nn_1 = mkN "dadel" ;
  dadelpalm_nn_1 = mkN "dadelpalm" "dadelpalmer" ;
  daeck_nn_1 = mkN "dдck" neutrum ;
  daeckel_nn_1 = mkN "dдckel" ;
  daecker_nn_1 = mkN "dдcker" neutrum ;
  daeckslast_nn_1 = mkN "dдckslast" "dдckslaster" ;
  daecksmanskap_nn_1 = mkN "dдcksmanskap" "dдcksmanskapet" "dдcksmanskapen" "dдcksmanskapena" ;
  daedan_ab_1 = mkAdv "dдdan" ;
  daeggdjur_nn_1 = mkN "dдggdjur" neutrum ;
  daeggdjursgrupp_nn_1 = mkN "dдggdjursgrupp" "dдggdjursgrupper" ;
  daeggdjurstand_nn_1 = mkN "dдggdjurstand" "dдggdjurstдnder" ;
  daeggdjurstyp_nn_1 = mkN "dдggdjurstyp" "dдggdjurstyper" ;
  daeggdjursunge_nn_1 = mkN "dдggdjursunge" utrum ;
  daeld_nn_1 = mkN "dдld" "dдlder" ;
  daemmare_nn_1 = mkN "dдmmare" "dдmmare" ;
  daemme_nn_1 = mkN "dдmme" ;
  daemning_nn_1 = mkN "dдmning" ;
  daempare_nn_1 = mkN "dдmpare" "dдmpare" ;
  daempbox_nn_1 = mkN "dдmpbox" ;
  daempning_nn_1 = mkN "dдmpning" ;
  daen_ab_1 = mkAdv "dдn" ;
  daer_ab_1 = mkAdv "dдr" ;
  daeraat_ab_1 = mkAdv "dдrеt" ;
  daerav_ab_1 = mkAdv "dдrav" ;
  daerborta_ab_1 = mkAdv "dдrborta" ;
  daerefter_ab_1 = mkAdv "dдrefter" ;
  daeremellan_ab_1 = mkAdv "dдremellan" ;
  daeremot_ab_1 = mkAdv "dдremot" ;
  daerfoer_ab_1 = mkAdv "dдrfцr" ;
  daerfoere_ab_1 = mkAdv "dдrfцre" ;
  daerfoerinnan_ab_1 = mkAdv "dдrfцrinnan" ;
  daerfoerutan_ab_1 = mkAdv "dдrfцrutan" ;
  daerhaen_ab_1 = mkAdv "dдrhдn" ;
  daerhemma_ab_1 = mkAdv "dдrhemma" ;
  daeri_ab_1 = mkAdv "dдri" ;
  daeribland_ab_1 = mkAdv "dдribland" ;
  daerifraan_ab_1 = mkAdv "dдrifrеn" ;
  daerigenom_ab_1 = mkAdv "dдrigenom" ;
  daerinne_ab_1 = mkAdv "dдrinne" ;
  daerjaemte_ab_1 = mkAdv "dдrjдmte" ;
  daermed_ab_1 = mkAdv "dдrmed" ;
  daernaest_ab_1 = mkAdv "dдrnдst" ;
  daernedanfoer_ab_1 = mkAdv "dдrnedanfцr" ;
  daernere_ab_1 = mkAdv "dдrnere" ;
  daeroever_ab_1 = mkAdv "dдrцver" ;
  daerom_ab_1 = mkAdv "dдrom" ;
  daerpaa_ab_1 = mkAdv "dдrpе" ;
  daerstaedes_ab_1 = mkAdv "dдrstдdes" ;
  daertill_ab_1 = mkAdv "dдrtill" ;
  daerunder_ab_1 = mkAdv "dдrunder" ;
  daeruppe_ab_1 = mkAdv "dдruppe" ;
  daerutav_ab_1 = mkAdv "dдrutav" ;
  daerute_ab_1 = mkAdv "dдrute" ;
  daerutinnan_ab_1 = mkAdv "dдrutinnan" ;
  daerutoever_ab_1 = mkAdv "dдrutцver" ;
  daervid_ab_1 = mkAdv "dдrvid" ;
  daervidlag_ab_1 = mkAdv "dдrvidlag" ;
  daest_av_1 = mkA "dдst" "dдst" ;
  daeven_av_1 = mkA "dдven" "dдvet" ;
  daevert_nn_1 = mkN "dдvert" ;
  daexel_nn_1 = mkN "dдxel" ;
  dag_nn_1 = mkN "dag" ;
  dagakarl_nn_1 = mkN "dagakarl" ;
  dagaktiv_av_1 = mkA "dagaktiv" ;
  dagavdelning_nn_1 = mkN "dagavdelning" ;
  dagbarn_nn_1 = mkN "dagbarn" neutrum ;
  dagbarnvaardare_nn_1 = mkN "dagbarnvеrdare" "dagbarnvеrdare" ;
  dagbefael_nn_1 = mkN "dagbefдl" neutrum ;
  dagblad_nn_1 = mkN "dagblad" neutrum ;
  dagblind_av_1 = mkA "dagblind" ;
  dagbok_nn_1 = mkN "dagbok" "dagbцcker" ;
  dagbraeckning_nn_1 = mkN "dagbrдckning" ;
  dagbrott_nn_1 = mkN "dagbrott" neutrum ;
  dagbrytning_nn_1 = mkN "dagbrytning" ;
  dagcentral_nn_1 = mkN "dagcentral" "dagcentraler" ;
  dagcentrum_nn_1 = mkN "dagcentrum" neutrum ;
  dagdjur_nn_1 = mkN "dagdjur" neutrum ;
  dagdrivare_nn_1 = mkN "dagdrivare" "dagdrivare" ;
  dagdroem_nn_1 = mkN "dagdrцm" "dagdrцmmen" "dagdrцmmar" "dagdrцmmarna" ;
  dagdroemmare_nn_1 = mkN "dagdrцmmare" "dagdrцmmare" ;
  dagdroemmeri_nn_1 = mkN "dagdrцmmeri" "dagdrцmmerit" "dagdrцmmerier" "dagdrцmmerierna" ;
  dagenefterstaemning_nn_1 = mkN "dagenefterstдmning" ;
  dager_nn_1 = mkN "dager" ;
  dagerrotyp_nn_1 = mkN "dagerrotyp" "dagerrotyper" ;
  dagerrotypi_nn_1 = mkN "dagerrotypi" "dagerrotypier" ;
  dagfjaeril_nn_1 = mkN "dagfjдril" ;
  dagg_nn_2 = mkN "dagg" ;
  daggdroppe_nn_1 = mkN "daggdroppe" utrum ;
  daggert_nn_1 = mkN "daggert" ;
  daggfrisk_av_1 = mkA "daggfrisk" ;
  daggig_av_1 = mkA "daggig" ;
  daggmask_nn_1 = mkN "daggmask" ;
  daggpunkt_nn_1 = mkN "daggpunkt" "daggpunkter" ;
  daghavande_av_1 = mkA "daghavande" ;
  daghavande_nn_1 = mkN "daghavande" "daghavanden" "daghavande" "daghavandena" ;
  daghem_nn_1 = mkN "daghem" "daghemmet" "daghem" "daghemmen" ;
  dagis_nn_1 = mkN "dagis" neutrum ;
  dagkarl_nn_1 = mkN "dagkarl" ;
  daglig_av_1 = mkA "daglig" ;
  dagligdags_ab_1 = mkAdv "dagligdags" ;
  dagligen_ab_1 = mkAdv "dagligen" ;
  dagligstuga_nn_1 = mkN "dagligstuga" ;
  dagloen_nn_1 = mkN "daglцn" "daglцner" ;
  dagloenare_nn_1 = mkN "daglцnare" "daglцnare" ;
  dagmamma_nn_1 = mkN "dagmamma" ;
  dago_nn_1 = mkN "dago" "dagon" "dagos" "dagosen" ;
  dagoeppning_nn_1 = mkN "dagцppning" ;
  dagofficer_nn_1 = mkN "dagofficer" "dagofficern" "dagofficerare" "dagofficerarna" ;
  dagorder_nn_1 = mkN "dagorder" ;
  dagordning_nn_1 = mkN "dagordning" ;
  dagort_nn_1 = mkN "dagort" "dagorter" ;
  dagpenning_nn_1 = mkN "dagpenning" ;
  dagrum_nn_1 = mkN "dagrum" "dagrummet" "dagrum" "dagrummen" ;
  dags_ab_1 = mkAdv "dags" ;
  dagsaktuell_av_1 = mkA "dagsaktuell" ;
  dagsbehov_nn_1 = mkN "dagsbehov" neutrum ;
  dagsbot_nn_1 = mkN "dagsbot" "dagsbцter" ;
  dagsedel_nn_1 = mkN "dagsedel" ;
  dagsens_av_1 = mkA "dagsens" ;
  dagskassa_nn_1 = mkN "dagskassa" ;
  dagsled_nn_1 = mkN "dagsled" "dagsleder" ;
  dagsmarsch_nn_1 = mkN "dagsmarsch" "dagsmarscher" ;
  dagsranson_nn_1 = mkN "dagsranson" "dagsransoner" ;
  dagstemperatur_nn_1 = mkN "dagstemperatur" "dagstemperaturer" ;
  dagstidning_nn_1 = mkN "dagstidning" ;
  dagsverkare_nn_1 = mkN "dagsverkare" "dagsverkare" ;
  dagtid_nn_1 = mkN "dagtid" "dagtider" ;
  dagtraktamente_nn_1 = mkN "dagtraktamente" ;
  dagvatten_nn_1 = mkN "dagvatten" "dagvattnet" "dagvatten" "dagvattnen" ;
  dakapo_ab_1 = mkAdv "dakapo" ;
  dakapo_nn_1 = mkN "dakapo" "dakapot" "dakapon" "dakapona" ;
  daktyl_nn_1 = mkN "daktyl" "daktyler" ;
  daktylisk_av_1 = mkA "daktylisk" ;
  dal_nn_1 = mkN "dal" ;
  dalahaest_nn_1 = mkN "dalahдst" ;
  dalbo_nn_1 = mkN "dalbo" "dalbor" ;
  dalbotten_nn_1 = mkN "dalbotten" ;
  daldans_nn_1 = mkN "daldans" "daldanser" ;
  daler_nn_1 = mkN "daler" "dalern" "daler" "dalerna" ;
  dalgaang_nn_1 = mkN "dalgеng" ;
  dalkarl_nn_1 = mkN "dalkarl" ;
  dallring_nn_1 = mkN "dallring" ;
  dalmaal_nn_1 = mkN "dalmеl" neutrum ;
  dalmaalning_nn_1 = mkN "dalmеlning" ;
  dalmas_nn_1 = mkN "dalmas" ;
  dalmatiner_nn_1 = mkN "dalmatiner" "dalmatinern" "dalmatiner" "dalmatinerna" ;
  dalprofil_nn_1 = mkN "dalprofil" "dalprofiler" ;
  dalsk_av_1 = mkA "dalsk" ;
  dalslaendsk_av_1 = mkA "dalslдndsk" ;
  dalslaenning_nn_1 = mkN "dalslдnning" ;
  dalsluttning_nn_1 = mkN "dalsluttning" ;
  dalvind_nn_1 = mkN "dalvind" ;
  dam_nn_1 = mkN "dam" "damer" ;
  damask_nn_1 = mkN "damask" "damasker" ;
  damast_nn_1 = mkN "damast" "damaster" ;
  dambesoek_nn_1 = mkN "dambesцk" neutrum ;
  dambjudning_nn_1 = mkN "dambjudning" ;
  damcykel_nn_1 = mkN "damcykel" ;
  damejeanne_nn_1 = mkN "damejeanne" "damejeanner" ;
  damfrisering_nn_1 = mkN "damfrisering" ;
  damfrisoer_nn_1 = mkN "damfrisцr" "damfrisцrer" ;
  damfrisoerska_nn_1 = mkN "damfrisцrska" ;
  damgambit_nn_1 = mkN "damgambit" ;
  damhatt_nn_1 = mkN "damhatt" ;
  damig_av_1 = mkA "damig" ;
  damkoer_nn_1 = mkN "damkцr" "damkцrer" ;
  damm_nn_1 = mkN "damm" ;
  dammanlaeggning_nn_1 = mkN "dammanlдggning" ;
  dammbindningsmedel_nn_1 = mkN "dammbindningsmedel" neutrum ;
  dammfoersoek_nn_1 = mkN "dammfцrsцk" neutrum ;
  dammig_av_1 = mkA "dammig" ;
  dammkorn_nn_1 = mkN "dammkorn" neutrum ;
  dammoln_nn_1 = mkN "dammoln" neutrum ;
  dammport_nn_1 = mkN "dammport" ;
  dammsuga_vb_1 = mkV "dammsuga" "dammsцg" "dammsugit" ;
  dammsugare_nn_1 = mkN "dammsugare" "dammsugare" ;
  dammussla_nn_1 = mkN "dammussla" ;
  damoklessvaerd_nn_1 = mkN "damoklessvдrd" neutrum ;
  damrum_nn_1 = mkN "damrum" "damrummet" "damrum" "damrummen" ;
  damsida_nn_1 = mkN "damsida" ;
  damspel_nn_1 = mkN "damspel" "damspelet" "damspel" "damspelen" ;
  damtidning_nn_1 = mkN "damtidning" ;
  dan_av_1 = mkA "dan" ;
  danaarv_nn_1 = mkN "danaarv" neutrum ;
  dandy_nn_1 = mkN "dandy" "dandyn" "dandies" "dandyerna" ;
  daning_nn_1 = mkN "daning" ;
  danism_nn_1 = mkN "danism" "danismer" ;
  dank_ab_1 = mkAdv "dank" ;
  dank_nn_1 = mkN "dank" ;
  danneman_nn_1 = mkN "danneman" "dannemannen" "dannemдn" "dannemдnnen" ;
  dans_nn_1 = mkN "dans" "danser" ;
  dansant_av_1 = mkA "dansant" "dansant" ;
  dansare_nn_1 = mkN "dansare" "dansare" ;
  dansgolv_nn_1 = mkN "dansgolv" neutrum ;
  danshak_nn_1 = mkN "danshak" neutrum ;
  dansk_av_1 = mkA "dansk" ;
  dansk_nn_1 = mkN "dansk" ;
  danska_nn_2 = mkN "danska" ;
  danskonst_nn_1 = mkN "danskonst" "danskonster" ;
  danslek_nn_1 = mkN "danslek" ;
  dansoer_nn_1 = mkN "dansцr" "dansцrer" ;
  dansoes_nn_1 = mkN "dansцs" "dansцser" ;
  dansrestaurang_nn_1 = mkN "dansrestaurang" "dansrestauranger" ;
  dansstaelle_nn_1 = mkN "dansstдlle" ;
  danssteg_nn_1 = mkN "danssteg" neutrum ;
  danstillstaellning_nn_1 = mkN "danstillstдllning" ;
  darraal_nn_1 = mkN "darrеl" ;
  darrhaent_av_1 = mkA "darrhдnt" "darrhдnt" ;
  darrig_av_1 = mkA "darrig" ;
  darrning_nn_1 = mkN "darrning" ;
  darwinfink_nn_1 = mkN "darwinfink" ;
  darwinist_nn_1 = mkN "darwinist" "darwinister" ;
  darwinistisk_av_1 = mkA "darwinistisk" ;
  daskig_av_1 = mkA "daskig" ;
  dass_nn_1 = mkN "dass" neutrum ;
  dassig_av_1 = mkA "dassig" ;
  dat_nn_1 = mkN "dat" "dater" ;
  data_nn_1 = mkN "data" "datan" "data" "datana" ;
  dataanlaeggning_nn_1 = mkN "dataanlдggning" ;
  databank_nn_1 = mkN "databank" "databanker" ;
  databas_nn_1 = mkN "databas" "databaser" ;
  databehandling_nn_1 = mkN "databehandling" ;
  datacentral_nn_1 = mkN "datacentral" "datacentraler" ;
  datafil_nn_1 = mkN "datafil" "datafiler" ;
  datakoerning_nn_1 = mkN "datakцrning" ;
  datakommunikation_nn_1 = mkN "datakommunikation" "datakommunikationer" ;
  datamaengd_nn_1 = mkN "datamдngd" "datamдngder" ;
  datamaskin_nn_1 = mkN "datamaskin" "datamaskiner" ;
  datamaskinell_av_1 = mkA "datamaskinell" ;
  dataminne_nn_1 = mkN "dataminne" ;
  dataprogram_nn_1 = mkN "dataprogram" "dataprogrammet" "dataprogram" "dataprogrammen" ;
  dataregister_nn_1 = mkN "dataregister" neutrum ;
  dataskaerm_nn_1 = mkN "dataskдrm" ;
  dataspel_nn_1 = mkN "dataspel" "dataspelet" "dataspel" "dataspelen" ;
  datering_nn_1 = mkN "datering" ;
  dativ_nn_1 = mkN "dativ" "dativer" ;
  dativobjekt_nn_1 = mkN "dativobjekt" neutrum ;
  dator_nn_1 = mkN "dator" "datorer" ;
  datoranlaeggning_nn_1 = mkN "datoranlдggning" ;
  datorbehandling_nn_1 = mkN "datorbehandling" ;
  datorberaekning_nn_1 = mkN "datorberдkning" ;
  datorminne_nn_1 = mkN "datorminne" ;
  datormodell_nn_1 = mkN "datormodell" "datormodeller" ;
  datorprogrammerare_nn_1 = mkN "datorprogrammerare" "datorprogrammerare" ;
  datovaexel_nn_1 = mkN "datovдxel" ;
  datum_nn_1 = mkN "datum" ;
  datumgraens_nn_1 = mkN "datumgrдns" "datumgrдnser" ;
  datumparkering_nn_1 = mkN "datumparkering" ;
  debacle_nn_1 = mkN "debacle" "debaclet" "debacle" "debaclen" ;
  debatt_nn_1 = mkN "debatt" "debatter" ;
  debattinlaegg_nn_1 = mkN "debattinlдgg" neutrum ;
  debattoer_nn_1 = mkN "debattцr" "debattцrer" ;
  debetsedel_nn_1 = mkN "debetsedel" ;
  debetsida_nn_1 = mkN "debetsida" ;
  debil_av_1 = mkA "debil" ;
  debilitet_nn_1 = mkN "debilitet" "debiliteter" ;
  debit_nn_1 = mkN "debit" "debiter" ;
  debitering_nn_1 = mkN "debitering" ;
  debut_nn_1 = mkN "debut" "debuter" ;
  debutant_nn_1 = mkN "debutant" "debutanter" ;
  debutbok_nn_1 = mkN "debutbok" "debutbцcker" ;
  debutroman_nn_1 = mkN "debutroman" "debutromaner" ;
  decennium_nn_1 = mkN "decennium" "decenniet" "decennier" "decennierna" ;
  decentralisation_nn_1 = mkN "decentralisation" "decentralisationer" ;
  decentralisering_nn_1 = mkN "decentralisering" ;
  decharge_nn_1 = mkN "decharge" "decharger" ;
  dechargedebatt_nn_1 = mkN "dechargedebatt" "dechargedebatter" ;
  decibel_nn_1 = mkN "decibel" "decibelen" "decibel" "decibelen" ;
  deciliter_nn_1 = mkN "deciliter" "decilitern" "deciliter" "deciliterna" ;
  decilitermaatt_nn_1 = mkN "decilitermеtt" neutrum ;
  decimal_nn_1 = mkN "decimal" "decimaler" ;
  decimalbraak_nn_1 = mkN "decimalbrеk" neutrum ;
  decimalkomma_nn_1 = mkN "decimalkomma" "decimalkommat" "decimalkomman" "decimalkommana" ;
  decimalsystem_nn_1 = mkN "decimalsystem" neutrum ;
  decimaltal_nn_1 = mkN "decimaltal" "decimaltalet" "decimaltalen" "decimaltalena" ;
  decimeter_nn_1 = mkN "decimeter" ;
  deckare_nn_1 = mkN "deckare" "deckare" ;
  dedikation_nn_1 = mkN "dedikation" "dedikationer" ;
  dedikationsexemplar_nn_1 = mkN "dedikationsexemplar" neutrum ;
  deduktion_nn_1 = mkN "deduktion" "deduktioner" ;
  deduktiv_av_1 = mkA "deduktiv" ;
  defaitist_nn_1 = mkN "defaitist" "defaitister" ;
  defaitistisk_av_1 = mkA "defaitistisk" ;
  defekt_av_1 = mkA "defekt" "defekt" ;
  defekt_nn_1 = mkN "defekt" "defekter" ;
  defensiv_av_1 = mkA "defensiv" ;
  deficit_nn_1 = mkN "deficit" neutrum ;
  defile_nn_1 = mkN "defilй" "defilйer" ;
  defilering_nn_1 = mkN "defilering" ;
  definierbar_av_1 = mkA "definierbar" ;
  definit_av_1 = mkA "definit" "definit" ;
  definition_nn_1 = mkN "definition" "definitioner" ;
  definitionsmaengd_nn_1 = mkN "definitionsmдngd" "definitionsmдngder" ;
  definitionsmaessig_av_1 = mkA "definitionsmдssig" ;
  definitiv_av_1 = mkA "definitiv" ;
  deflagration_nn_1 = mkN "deflagration" "deflagrationer" ;
  defloration_nn_1 = mkN "defloration" "deflorationer" ;
  deformation_nn_1 = mkN "deformation" "deformationer" ;
  deformering_nn_1 = mkN "deformering" ;
  deformitet_nn_1 = mkN "deformitet" "deformiteter" ;
  defroster_nn_1 = mkN "defroster" ;
  deg_nn_1 = mkN "deg" ;
  degel_nn_1 = mkN "degel" ;
  degenerativ_av_1 = mkA "degenerativ" ;
  degig_av_1 = mkA "degig" ;
  dego_nn_1 = mkN "dego" "degon" "degos" "degosen" ;
  degradation_nn_1 = mkN "degradation" "degradationer" ;
  degrand_nn_1 = mkN "degrand" "degrдnder" ;
  degression_nn_1 = mkN "degression" "degressioner" ;
  deiktisk_av_1 = mkA "deiktisk" ;
  deist_nn_1 = mkN "deist" "deister" ;
  deistisk_av_1 = mkA "deistisk" ;
  dejlig_av_1 = mkA "dejlig" ;
  dekad_nn_1 = mkN "dekad" "dekader" ;
  dekadent_av_1 = mkA "dekadent" "dekadent" ;
  dekadisk_av_1 = mkA "dekadisk" ;
  dekal_nn_1 = mkN "dekal" "dekaler" ;
  dekan_nn_1 = mkN "dekan" "dekaner" ;
  deklamation_nn_1 = mkN "deklamation" "deklamationer" ;
  deklamatoer_nn_1 = mkN "deklamatцr" "deklamatцrer" ;
  deklamatorisk_av_1 = mkA "deklamatorisk" ;
  deklarant_nn_1 = mkN "deklarant" "deklaranter" ;
  deklaration_nn_1 = mkN "deklaration" "deklarationer" ;
  deklarationsblankett_nn_1 = mkN "deklarationsblankett" "deklarationsblanketter" ;
  deklination_nn_1 = mkN "deklination" "deklinationer" ;
  deklinationsnaal_nn_1 = mkN "deklinationsnеl" ;
  dekokt_nn_1 = mkN "dekokt" "dekokter" ;
  dekolletage_nn_1 = mkN "dekolletage" "dekolletaget" "dekolletage" "dekolletagen" ;
  dekolletering_nn_1 = mkN "dekolletering" ;
  dekor_nn_1 = mkN "dekor" "dekoren" "dekorer" "dekorerna" ;
  dekoration_nn_1 = mkN "dekoration" "dekorationer" ;
  dekorationslist_nn_1 = mkN "dekorationslist" "dekorationslister" ;
  dekorativ_av_1 = mkA "dekorativ" ;
  dekoratoer_nn_1 = mkN "dekoratцr" "dekoratцrer" ;
  dekret_nn_1 = mkN "dekret" neutrum ;
  del_nn_1 = mkN "del" "delen" "delar" "delarna" ;
  delaegare_nn_1 = mkN "delдgare" "delдgare" ;
  delaktig_av_1 = mkA "delaktig" ;
  delaktighet_nn_1 = mkN "delaktighet" "delaktigheter" ;
  delbar_av_1 = mkA "delbar" ;
  delbetalning_nn_1 = mkN "delbetalning" ;
  delegat_nn_1 = mkN "delegat" "delegater" ;
  delegation_nn_1 = mkN "delegation" "delegationer" ;
  delegering_nn_1 = mkN "delegering" ;
  delfin_nn_1 = mkN "delfin" "delfiner" ;
  delge_vb_1 = mkV "delge" "delger" "delge" "delgav" "delgett" "delgiven" ;
  delgivning_nn_1 = mkN "delgivning" ;
  delicioes_av_1 = mkA "deliciцs" ;
  delikat_av_1 = mkA "delikat" "delikat" ;
  delikatess_nn_1 = mkN "delikatess" "delikatesser" ;
  delikt_nn_1 = mkN "delikt" neutrum ;
  delinkvent_nn_1 = mkN "delinkvent" "delinkventer" ;
  delirant_nn_1 = mkN "delirant" "deliranter" ;
  dellikvid_nn_1 = mkN "dellikvid" "dellikvider" ;
  delmaengd_nn_1 = mkN "delmдngd" "delmдngder" ;
  delning_nn_1 = mkN "delning" ;
  delperiod_nn_1 = mkN "delperiod" "delperioder" ;
  delprojekt_nn_1 = mkN "delprojekt" neutrum ;
  delrepublik_nn_1 = mkN "delrepublik" "delrepubliker" ;
  dels_ab_1 = mkAdv "dels" ;
  delstat_nn_1 = mkN "delstat" "delstater" ;
  delstreck_nn_1 = mkN "delstreck" neutrum ;
  delta_nn_1 = mkN "delta" "deltat" "deltan" "deltana" ;
  delta_vb_1 = mkV "delta" "deltar" "delta" "deltog" "deltagit" "deltagen" ;
  deltagande_av_1 = mkA "deltagande" ;
  deltagare_nn_1 = mkN "deltagare" "deltagare" ;
  deltamuskel_nn_1 = mkN "deltamuskel" "deltamuskeln" "deltamuskler" "deltamusklerna" ;
  deltavinge_nn_1 = mkN "deltavinge" utrum ;
  deltid_nn_1 = mkN "deltid" "deltider" ;
  deltidare_nn_1 = mkN "deltidare" "deltidare" ;
  deltidsanstaelld_av_1 = mkA "deltidsanstдlld" "deltidsanstдllt" ;
  delvis_ab_1 = mkAdv "delvis" ;
  delvis_av_1 = mkA "delvis" ;
  demagog_nn_1 = mkN "demagog" "demagoger" ;
  demagogisk_av_1 = mkA "demagogisk" ;
  demarkationslinje_nn_1 = mkN "demarkationslinje" "demarkationslinjer" ;
  demarsch_nn_1 = mkN "demarsch" "demarscher" ;
  dementi_nn_1 = mkN "dementi" "dementier" ;
  demeriterande_av_1 = mkA "demeriterande" ;
  demimond_nn_1 = mkN "demimond" "demimonder" ;
  demission_nn_1 = mkN "demission" "demissioner" ;
  demiurg_nn_1 = mkN "demiurg" "demiurger" ;
  demografisk_av_1 = mkA "demografisk" ;
  demoinspelning_nn_1 = mkN "demoinspelning" ;
  demokrat_nn_1 = mkN "demokrat" "demokrater" ;
  demokrati_nn_1 = mkN "demokrati" "demokratier" ;
  demokratisk_av_1 = mkA "demokratisk" ;
  demon_nn_1 = mkN "demon" "demoner" ;
  demonisk_av_1 = mkA "demonisk" ;
  demonregissoer_nn_1 = mkN "demonregissцr" "demonregissцrer" ;
  demonstrant_nn_1 = mkN "demonstrant" "demonstranter" ;
  demonstration_nn_1 = mkN "demonstration" "demonstrationer" ;
  demonstrationsfrihet_nn_1 = mkN "demonstrationsfrihet" "demonstrationsfriheter" ;
  demonstrationstaag_nn_1 = mkN "demonstrationstеg" neutrum ;
  demonstrativ_av_1 = mkA "demonstrativ" ;
  demonstratoer_nn_1 = mkN "demonstratцr" "demonstratцrer" ;
  demonstratris_nn_1 = mkN "demonstratris" "demonstratriser" ;
  demontering_nn_1 = mkN "demontering" ;
  demotape_nn_1 = mkN "demotape" "demotaper" ;
  denar_nn_1 = mkN "denar" "denarer" ;
  dendrit_nn_1 = mkN "dendrit" "dendriter" ;
  dendrolog_nn_1 = mkN "dendrolog" "dendrologer" ;
  denier_nn_1 = mkN "denier" "denieren" "denier" "denieren" ;
  dennes_ab_1 = mkAdv "dennes" ;
  denotation_nn_1 = mkN "denotation" "denotationer" ;
  denotativ_av_1 = mkA "denotativ" ;
  densitet_nn_1 = mkN "densitet" "densiteter" ;
  densitometer_nn_1 = mkN "densitometer" ;
  densometer_nn_1 = mkN "densometer" ;
  dental_av_1 = mkA "dental" ;
  dental_nn_1 = mkN "dental" "dentaler" ;
  dentist_nn_1 = mkN "dentist" "dentister" ;
  denudation_nn_1 = mkN "denudation" "denudationer" ;
  denuklearisering_nn_1 = mkN "denuklearisering" ;
  deodorant_nn_1 = mkN "deodorant" "deodoranter" ;
  depaa_nn_1 = mkN "depе" "depеer" ;
  depaafynd_nn_1 = mkN "depеfynd" neutrum ;
  departement_nn_1 = mkN "departement" "departementet" "departementen" "departementena" ;
  departemental_av_1 = mkA "departemental" ;
  departementsaerende_nn_1 = mkN "departementsдrende" ;
  departementschef_nn_1 = mkN "departementschef" "departementschefer" ;
  depens_nn_1 = mkN "depens" "depenser" ;
  depesch_nn_1 = mkN "depesch" "depescher" ;
  depeschbyraa_nn_1 = mkN "depeschbyrе" "depeschbyrеer" ;
  depolarisator_nn_1 = mkN "depolarisator" "depolarisatorer" ;
  deponens_nn_1 = mkN "deponens" "deponens" "deponens" "deponensen" ;
  deponent_nn_1 = mkN "deponent" "deponenter" ;
  deponentiell_av_1 = mkA "deponentiell" ;
  deportation_nn_1 = mkN "deportation" "deportationer" ;
  deportationsort_nn_1 = mkN "deportationsort" "deportationsorter" ;
  deposition_nn_1 = mkN "deposition" "depositioner" ;
  depositionsbevis_nn_1 = mkN "depositionsbevis" neutrum ;
  depositum_nn_1 = mkN "depositum" "depositum" "deposita" "depositana" ;
  deppig_av_1 = mkA "deppig" ;
  depression_nn_1 = mkN "depression" "depressioner" ;
  depressiv_av_1 = mkA "depressiv" ;
  deprimerande_av_1 = mkA "deprimerande" ;
  deprivation_nn_1 = mkN "deprivation" "deprivationer" ;
  deputation_nn_1 = mkN "deputation" "deputationer" ;
  deputerad_nn_1 = mkN "deputerad" "deputeraden" "deputerade" "deputeradena" ;
  derby_nn_1 = mkN "derby" "derbyt" "derbyn" "derbyna" ;
  derivat_nn_1 = mkN "derivat" neutrum ;
  derivation_nn_1 = mkN "derivation" "derivationer" ;
  dermatit_nn_1 = mkN "dermatit" "dermatiter" ;
  dermatolog_nn_1 = mkN "dermatolog" "dermatologer" ;
  dermatologisk_av_1 = mkA "dermatologisk" ;
  dervisch_nn_1 = mkN "dervisch" "dervischer" ;
  descendent_nn_1 = mkN "descendent" "descendenter" ;
  desegregation_nn_1 = mkN "desegregation" "desegregationer" ;
  desertoer_nn_1 = mkN "desertцr" "desertцrer" ;
  deshabille_nn_1 = mkN "deshabillй" "deshabillйer" ;
  designer_nn_1 = mkN "designer" "designern" "designer" "designerna" ;
  desillusion_nn_1 = mkN "desillusion" "desillusioner" ;
  desinfektion_nn_1 = mkN "desinfektion" "desinfektioner" ;
  desinfektoer_nn_1 = mkN "desinfektцr" "desinfektцrer" ;
  desinformation_nn_1 = mkN "desinformation" "desinformationer" ;
  desintegration_nn_1 = mkN "desintegration" "desintegrationer" ;
  deskription_nn_1 = mkN "deskription" "deskriptioner" ;
  deskriptiv_av_1 = mkA "deskriptiv" ;
  desperado_nn_1 = mkN "desperado" "desperadon" "desperados" "desperadosen" ;
  desperat_av_1 = mkA "desperat" "desperat" ;
  despot_nn_1 = mkN "despot" "despoter" ;
  despoti_nn_1 = mkN "despoti" "despotier" ;
  despotisk_av_1 = mkA "despotisk" ;
  dess_ab_1 = mkAdv "dess" ;
  dessaeng_nn_1 = mkN "dessдng" "dessдnger" ;
  dessbaettre_ab_1 = mkAdv "dessbдttre" ;
  dessemellan_ab_1 = mkAdv "dessemellan" ;
  dessert_nn_1 = mkN "dessert" "desserter" ;
  dessertgaffel_nn_1 = mkN "dessertgaffel" ;
  dessertkniv_nn_1 = mkN "dessertkniv" ;
  dessertost_nn_1 = mkN "dessertost" ;
  dessertsaas_nn_1 = mkN "dessertsеs" "dessertsеser" ;
  dessertsked_nn_1 = mkN "dessertsked" ;
  desserttallrik_nn_1 = mkN "desserttallrik" ;
  dessertvin_nn_1 = mkN "dessertvin" "dessertvinet" "dessertviner" "dessertvinerna" ;
  dessfoerinnan_ab_1 = mkAdv "dessfцrinnan" ;
  dessfoerutan_ab_1 = mkAdv "dessfцrutan" ;
  dessinatoer_nn_1 = mkN "dessinatцr" "dessinatцrer" ;
  desslikes_ab_1 = mkAdv "desslikes" ;
  dessutom_ab_1 = mkAdv "dessutom" ;
  dessvaerre_ab_1 = mkAdv "dessvдrre" ;
  destabiliserande_av_1 = mkA "destabiliserande" ;
  destillat_nn_1 = mkN "destillat" neutrum ;
  destillation_nn_1 = mkN "destillation" "destillationer" ;
  destillationsapparat_nn_1 = mkN "destillationsapparat" "destillationsapparater" ;
  destillering_nn_1 = mkN "destillering" ;
  destinataer_nn_1 = mkN "destinatдr" "destinatдrer" ;
  destination_nn_1 = mkN "destination" "destinationer" ;
  destinationsort_nn_1 = mkN "destinationsort" "destinationsorter" ;
  destinatoer_nn_1 = mkN "destinatцr" "destinatцrer" ;
  desto_ab_1 = mkAdv "desto" ;
  destruent_nn_1 = mkN "destruent" "destruenter" ;
  destruktionsanlaeggning_nn_1 = mkN "destruktionsanlдggning" ;
  destruktiv_av_1 = mkA "destruktiv" ;
  detachement_nn_1 = mkN "detachement" "detachementet" "detachementen" "detachementena" ;
  detachoer_nn_1 = mkN "detachцr" "detachцrer" ;
  detalj_nn_1 = mkN "detalj" "detaljer" ;
  detaljanmaerkning_nn_1 = mkN "detaljanmдrkning" ;
  detaljfraaga_nn_1 = mkN "detaljfrеga" ;
  detaljhandlare_nn_1 = mkN "detaljhandlare" "detaljhandlare" ;
  detaljist_nn_1 = mkN "detaljist" "detaljister" ;
  detaljkaennedom_nn_1 = mkN "detaljkдnnedom" ;
  detaljpris_nn_1 = mkN "detaljpris" neutrum ;
  detaljrik_av_1 = mkA "detaljrik" ;
  detaljstudium_nn_1 = mkN "detaljstudium" "detaljstudiet" "detaljstudier" "detaljstudierna" ;
  detaljutfoerande_nn_1 = mkN "detaljutfцrande" ;
  detektiv_av_1 = mkA "detektiv" ;
  detektiv_nn_1 = mkN "detektiv" "detektiver" ;
  detektivroman_nn_1 = mkN "detektivroman" "detektivromaner" ;
  detektor_nn_1 = mkN "detektor" "detektorer" ;
  detergent_nn_1 = mkN "detergent" "detergenter" ;
  determination_nn_1 = mkN "determination" "determinationer" ;
  determinativ_av_1 = mkA "determinativ" ;
  determinist_nn_1 = mkN "determinist" "determinister" ;
  deterministisk_av_1 = mkA "deterministisk" ;
  detonation_nn_1 = mkN "detonation" "detonationer" ;
  detonationshastighet_nn_1 = mkN "detonationshastighet" "detonationshastigheter" ;
  detonationstryck_nn_1 = mkN "detonationstryck" neutrum ;
  detonationszon_nn_1 = mkN "detonationszon" "detonationszoner" ;
  detonator_nn_1 = mkN "detonator" "detonatorer" ;
  deuce_ab_1 = mkAdv "deuce" ;
  deuteron_nn_1 = mkN "deuteron" "deuteroner" ;
  deutron_nn_1 = mkN "deutron" "deutroner" ;
  deviation_nn_1 = mkN "deviation" "deviationer" ;
  devis_nn_1 = mkN "devis" "deviser" ;
  devot_av_1 = mkA "devot" "devot" ;
  dextran_nn_1 = mkN "dextran" "dextraner" ;
  dextrin_nn_1 = mkN "dextrin" "dextriner" ;
  diabas_nn_1 = mkN "diabas" "diabaser" ;
  diabetiker_nn_1 = mkN "diabetiker" "diabetikern" "diabetiker" "diabetikerna" ;
  diabild_nn_1 = mkN "diabild" "diabilder" ;
  diabolisk_av_1 = mkA "diabolisk" ;
  diadem_nn_1 = mkN "diadem" neutrum ;
  diafilm_nn_1 = mkN "diafilm" "diafilmer" ;
  diafragma_nn_1 = mkN "diafragma" ;
  diagnos_nn_1 = mkN "diagnos" "diagnoser" ;
  diagnostiker_nn_1 = mkN "diagnostiker" "diagnostikern" "diagnostiker" "diagnostikerna" ;
  diagnostisk_av_1 = mkA "diagnostisk" ;
  diagonal_av_1 = mkA "diagonal" ;
  diagonal_nn_1 = mkN "diagonal" "diagonaler" ;
  diagram_nn_1 = mkN "diagram" "diagrammet" "diagram" "diagrammen" ;
  diakon_nn_1 = mkN "diakon" "diakoner" ;
  diakonistyrelse_nn_1 = mkN "diakonistyrelse" "diakonistyrelser" ;
  diakritisk_av_1 = mkA "diakritisk" ;
  diakron_av_1 = mkA "diakron" ;
  diakronisk_av_1 = mkA "diakronisk" ;
  dialekt_nn_1 = mkN "dialekt" "dialekter" ;
  dialektal_av_1 = mkA "dialektal" ;
  dialektgeografisk_av_1 = mkA "dialektgeografisk" ;
  dialektiker_nn_1 = mkN "dialektiker" "dialektikern" "dialektiker" "dialektikerna" ;
  dialektisk_av_1 = mkA "dialektisk" ;
  dialektolog_nn_1 = mkN "dialektolog" "dialektologer" ;
  dialektologisk_av_1 = mkA "dialektologisk" ;
  dialog_nn_1 = mkN "dialog" "dialoger" ;
  dialys_nn_1 = mkN "dialys" "dialyser" ;
  dialytisk_av_1 = mkA "dialytisk" ;
  diamant_nn_1 = mkN "diamant" "diamanter" ;
  diamantborr_nn_1 = mkN "diamantborr" ;
  diamantbroellop_nn_1 = mkN "diamantbrцllop" neutrum ;
  diameter_nn_1 = mkN "diameter" ;
  diametral_av_1 = mkA "diametral" ;
  diapositiv_nn_1 = mkN "diapositiv" neutrum ;
  diarienummer_nn_1 = mkN "diarienummer" neutrum ;
  diarium_nn_1 = mkN "diarium" "diariet" "diarier" "diarierna" ;
  diarre_nn_1 = mkN "diarrй" "diarrйer" ;
  diastas_nn_1 = mkN "diastas" "diastaser" ;
  diastolisk_av_1 = mkA "diastolisk" ;
  diatonisk_av_1 = mkA "diatonisk" ;
  diatrib_nn_1 = mkN "diatrib" "diatriber" ;
  dibarn_nn_1 = mkN "dibarn" neutrum ;
  didaktiker_nn_1 = mkN "didaktiker" "didaktikern" "didaktiker" "didaktikerna" ;
  didaktisk_av_1 = mkA "didaktisk" ;
  diesel_nn_1 = mkN "diesel" ;
  dieselmotor_nn_1 = mkN "dieselmotor" "dieselmotorer" ;
  dieselolja_nn_1 = mkN "dieselolja" ;
  diet_nn_1 = mkN "diet" "dieter" ;
  dietetisk_av_1 = mkA "dietetisk" ;
  dietisk_av_1 = mkA "dietisk" ;
  dietist_nn_1 = mkN "dietist" "dietister" ;
  differens_nn_1 = mkN "differens" "differenser" ;
  different_av_1 = mkA "different" "different" ;
  differential_nn_1 = mkN "differential" "differentialer" ;
  differentialekvation_nn_1 = mkN "differentialekvation" "differentialekvationer" ;
  differentialkalkyl_nn_1 = mkN "differentialkalkyl" "differentialkalkyler" ;
  differentialspaerr_nn_1 = mkN "differentialspдrr" ;
  differentialvaexel_nn_1 = mkN "differentialvдxel" ;
  differentiell_av_1 = mkA "differentiell" ;
  differentiering_nn_1 = mkN "differentiering" ;
  diffraktion_nn_1 = mkN "diffraktion" "diffraktioner" ;
  diffraktionsspektrum_nn_1 = mkN "diffraktionsspektrum" neutrum ;
  diffus_av_1 = mkA "diffus" ;
  diftong_nn_1 = mkN "diftong" "diftonger" ;
  digel_nn_1 = mkN "digel" ;
  digelpress_nn_1 = mkN "digelpress" ;
  diger_av_1 = mkA "diger" "digert" "digra" "digra" "digrare" "digrast" "digraste" ;
  digital_av_1 = mkA "digital" ;
  digivning_nn_1 = mkN "digivning" ;
  dignitaer_nn_1 = mkN "dignitдr" "dignitдrer" ;
  dignitet_nn_1 = mkN "dignitet" "digniteter" ;
  digression_nn_1 = mkN "digression" "digressioner" ;
  dike_nn_1 = mkN "dike" ;
  dikeskoerning_nn_1 = mkN "dikeskцrning" ;
  dikesren_nn_1 = mkN "dikesren" "dikesrenen" "dikesrenar" "dikesrenarna" ;
  diklin_av_1 = mkA "diklin" ;
  diklin_nn_1 = mkN "diklin" "dikliner" ;
  dikotomi_nn_1 = mkN "dikotomi" "dikotomier" ;
  dikotyledon_av_1 = mkA "dikotyledon" ;
  dikotyledon_nn_1 = mkN "dikotyledon" "dikotyledoner" ;
  dikt_ab_1 = mkAdv "dikt" ;
  dikt_nn_1 = mkN "dikt" "dikter" ;
  diktafon_nn_1 = mkN "diktafon" "diktafoner" ;
  diktamen_nn_1 = mkN "diktamen" "diktamen" "diktamina" "diktamina" ;
  diktarbegaavning_nn_1 = mkN "diktarbegеvning" ;
  diktare_nn_1 = mkN "diktare" "diktare" ;
  diktargrupp_nn_1 = mkN "diktargrupp" "diktargrupper" ;
  diktat_nn_1 = mkN "diktat" neutrum ;
  diktator_nn_1 = mkN "diktator" "diktatorer" ;
  diktatorisk_av_1 = mkA "diktatorisk" ;
  diktatur_nn_1 = mkN "diktatur" "diktaturer" ;
  diktcykel_nn_1 = mkN "diktcykel" ;
  dikteringsmaskin_nn_1 = mkN "dikteringsmaskin" "dikteringsmaskiner" ;
  diktning_nn_1 = mkN "diktning" ;
  diktsamling_nn_1 = mkN "diktsamling" ;
  diktverk_nn_1 = mkN "diktverk" neutrum ;
  dilatation_nn_1 = mkN "dilatation" "dilatationer" ;
  dilatationsfog_nn_1 = mkN "dilatationsfog" ;
  dildo_nn_1 = mkN "dildo" ;
  dilemma_nn_1 = mkN "dilemma" "dilemmat" "dilemman" "dilemmana" ;
  dilettant_nn_1 = mkN "dilettant" "dilettanter" ;
  dilettantisk_av_1 = mkA "dilettantisk" ;
  dilettantmaessig_av_1 = mkA "dilettantmдssig" ;
  diligens_nn_1 = mkN "diligens" "diligenser" ;
  dilleri_nn_1 = mkN "dilleri" "dillerit" "dillerier" "dillerierna" ;
  dillsaas_nn_1 = mkN "dillsеs" "dillsеser" ;
  dimbaage_nn_1 = mkN "dimbеge" utrum ;
  dimbank_nn_1 = mkN "dimbank" ;
  dimbildning_nn_1 = mkN "dimbildning" ;
  dimblaa_av_1 = mkA "dimblе" "dimblеtt" ;
  dimension_nn_1 = mkN "dimension" "dimensioner" ;
  dimensionering_nn_1 = mkN "dimensionering" ;
  dimensionsavverkning_nn_1 = mkN "dimensionsavverkning" ;
  dimhoeljd_av_1 = mkA "dimhцljd" "dimhцljt" ;
  diminuendo_ab_1 = mkAdv "diminuendo" ;
  diminuendo_nn_1 = mkN "diminuendo" "diminuendot" "diminuendon" "diminuendona" ;
  diminutiv_av_1 = mkA "diminutiv" ;
  diminutiv_nn_1 = mkN "diminutiv" "diminutiver" ;
  dimkammare_nn_1 = mkN "dimkammare" "dimkammaren" "dimkamrar" "dimkamrarna" ;
  dimljus_nn_1 = mkN "dimljus" neutrum ;
  dimmig_av_1 = mkA "dimmig" ;
  dimmoln_nn_1 = mkN "dimmoln" neutrum ;
  dimorf_av_1 = mkA "dimorf" ;
  dimorfi_nn_1 = mkN "dimorfi" "dimorfier" ;
  dimridaa_nn_1 = mkN "dimridе" "dimridеer" ;
  dinar_nn_1 = mkN "dinar" "dinarer" ;
  dinatriumvaetefosfat_nn_1 = mkN "dinatriumvдtefosfat" neutrum ;
  dine_nn_1 = mkN "dinй" "dinйer" ;
  dinge_nn_1 = mkN "dinge" utrum ;
  dingo_nn_1 = mkN "dingo" "dingor" ;
  dinosaur_nn_1 = mkN "dinosaur" "dinosaurer" ;
  dinosaurie_nn_1 = mkN "dinosaurie" "dinosaurier" ;
  dinosaurieart_nn_1 = mkN "dinosaurieart" "dinosauriearter" ;
  diod_nn_1 = mkN "diod" "dioder" ;
  dionysisk_av_1 = mkA "dionysisk" ;
  diopter_nn_1 = mkN "diopter" ;
  dioptri_nn_1 = mkN "dioptri" "dioptrier" ;
  dioptrisk_av_1 = mkA "dioptrisk" ;
  diorama_nn_1 = mkN "diorama" "dioramat" "dioraman" "dioramana" ;
  diorit_nn_1 = mkN "diorit" "dioriter" ;
  dioskur_nn_1 = mkN "dioskur" "dioskurer" ;
  dioxin_nn_1 = mkN "dioxin" "dioxinet" "dioxiner" "dioxinerna" ;
  diperiod_nn_1 = mkN "diperiod" "diperioder" ;
  diplom_nn_1 = mkN "diplom" neutrum ;
  diplomat_nn_1 = mkN "diplomat" "diplomater" ;
  diplomatarisk_av_1 = mkA "diplomatarisk" ;
  diplomatarium_nn_1 = mkN "diplomatarium" "diplomatariet" "diplomatarier" "diplomatarierna" ;
  diplomatisk_av_1 = mkA "diplomatisk" ;
  diplomingenjoer_nn_1 = mkN "diplomingenjцr" "diplomingenjцrer" ;
  dipol_nn_1 = mkN "dipol" "dipoler" ;
  dipsoman_nn_1 = mkN "dipsoman" "dipsomaner" ;
  diptyk_nn_1 = mkN "diptyk" "diptyker" ;
  direkt_av_1 = mkA "direkt" "direkt" ;
  direkthet_nn_1 = mkN "direkthet" "direktheter" ;
  direktinflytande_nn_1 = mkN "direktinflytande" ;
  direktinsprutning_nn_1 = mkN "direktinsprutning" ;
  direktion_nn_1 = mkN "direktion" "direktioner" ;
  direktiv_nn_1 = mkN "direktiv" neutrum ;
  direktkontakt_nn_1 = mkN "direktkontakt" "direktkontakter" ;
  direktlinje_nn_1 = mkN "direktlinje" "direktlinjer" ;
  direktmetod_nn_1 = mkN "direktmetod" "direktmetoder" ;
  direktoer_nn_1 = mkN "direktцr" "direktцrer" ;
  direktor_nn_1 = mkN "direktor" "direktorer" ;
  direktreferat_nn_1 = mkN "direktreferat" neutrum ;
  direktris_nn_1 = mkN "direktris" "direktriser" ;
  direktsaendning_nn_1 = mkN "direktsдndning" ;
  direktskott_nn_1 = mkN "direktskott" neutrum ;
  direktvaexel_nn_1 = mkN "direktvдxel" ;
  dirigent_nn_1 = mkN "dirigent" "dirigenter" ;
  dirk_nn_1 = mkN "dirk" ;
  dis_nn_2 = mkN "dis" "diser" ;
  disackarid_nn_1 = mkN "disackarid" "disackarider" ;
  discipel_nn_1 = mkN "discipel" ;
  disciplin_nn_1 = mkN "disciplin" "discipliner" ;
  disciplinaer_av_1 = mkA "disciplinдr" ;
  disciplinbot_nn_1 = mkN "disciplinbot" "disciplinbцter" ;
  disciplinmaal_nn_1 = mkN "disciplinmеl" neutrum ;
  disciplinstraff_nn_1 = mkN "disciplinstraff" neutrum ;
  discjockey_nn_1 = mkN "discjockey" "discjockeyer" ;
  disco_nn_1 = mkN "disco" "discot" "discon" "discona" ;
  disharmoni_nn_1 = mkN "disharmoni" "disharmonier" ;
  disharmonisk_av_1 = mkA "disharmonisk" ;
  disig_av_1 = mkA "disig" ;
  disjunkt_av_1 = mkA "disjunkt" "disjunkt" ;
  disjunktion_nn_1 = mkN "disjunktion" "disjunktioner" ;
  disjunktiv_av_1 = mkA "disjunktiv" ;
  disk_nn_1 = mkN "disk" ;
  diskant_nn_1 = mkN "diskant" "diskanter" ;
  diskantklav_nn_1 = mkN "diskantklav" "diskantklaver" ;
  diskare_nn_1 = mkN "diskare" "diskare" ;
  diskbaenk_nn_1 = mkN "diskbдnk" ;
  diskbraack_nn_1 = mkN "diskbrеck" neutrum ;
  diskett_nn_1 = mkN "diskett" "disketter" ;
  diskho_nn_1 = mkN "diskho" ;
  diskjockey_nn_1 = mkN "diskjockey" ;
  diskmaskin_nn_1 = mkN "diskmaskin" "diskmaskiner" ;
  diskmedel_nn_1 = mkN "diskmedel" neutrum ;
  disko_nn_1 = mkN "disko" "diskot" "diskon" "diskona" ;
  diskofil_nn_1 = mkN "diskofil" "diskofiler" ;
  diskontinuerlig_av_1 = mkA "diskontinuerlig" ;
  diskontinuitet_nn_1 = mkN "diskontinuitet" "diskontinuiteter" ;
  diskonto_nn_1 = mkN "diskonto" "diskontot" "diskonton" "diskontona" ;
  diskontoer_nn_1 = mkN "diskontцr" "diskontцrer" ;
  diskordans_nn_1 = mkN "diskordans" "diskordanser" ;
  diskordant_av_1 = mkA "diskordant" "diskordant" ;
  diskotek_nn_1 = mkN "diskotek" neutrum ;
  diskplockare_nn_1 = mkN "diskplockare" "diskplockare" ;
  diskrepans_nn_1 = mkN "diskrepans" "diskrepanser" ;
  diskret_av_1 = mkA "diskret" "diskret" ;
  diskriminering_nn_1 = mkN "diskriminering" ;
  diskstaell_nn_1 = mkN "diskstдll" neutrum ;
  disktorkning_nn_1 = mkN "disktorkning" ;
  diskurs_nn_1 = mkN "diskurs" "diskurser" ;
  diskursiv_av_1 = mkA "diskursiv" ;
  diskus_nn_1 = mkN "diskus" ;
  diskuskastning_nn_1 = mkN "diskuskastning" ;
  diskussion_nn_1 = mkN "diskussion" "diskussioner" ;
  diskussionsprotokoll_nn_1 = mkN "diskussionsprotokoll" neutrum ;
  diskutabel_av_1 = mkA "diskutabel" "diskutabelt" "diskutabla" "diskutabla" "diskutablare" "diskutablast" "diskutablaste" ;
  diskvalificering_nn_1 = mkN "diskvalificering" ;
  diskvalifikation_nn_1 = mkN "diskvalifikation" "diskvalifikationer" ;
  dislokation_nn_1 = mkN "dislokation" "dislokationer" ;
  disoes_nn_1 = mkN "disцs" "disцser" ;
  disparat_av_1 = mkA "disparat" "disparat" ;
  dispasch_nn_1 = mkN "dispasch" "dispascher" ;
  dispaschoer_nn_1 = mkN "dispaschцr" "dispaschцrer" ;
  dispens_nn_1 = mkN "dispens" "dispenser" ;
  dispensaer_nn_1 = mkN "dispensдr" "dispensдrer" ;
  dispers_av_1 = mkA "dispers" ;
  display_nn_1 = mkN "display" "displayen" "displayer" "displayerna" ;
  disponent_nn_1 = mkN "disponent" "disponenter" ;
  disponibel_av_1 = mkA "disponibel" "disponibelt" "disponibla" "disponibla" "disponiblare" "disponiblast" "disponiblaste" ;
  disponibilitet_nn_1 = mkN "disponibilitet" "disponibiliteter" ;
  disposition_nn_1 = mkN "disposition" "dispositioner" ;
  dispositionsfond_nn_1 = mkN "dispositionsfond" "dispositionsfonder" ;
  dispositiv_av_1 = mkA "dispositiv" ;
  disproportion_nn_1 = mkN "disproportion" "disproportioner" ;
  disproportionerlig_av_1 = mkA "disproportionerlig" ;
  disputation_nn_1 = mkN "disputation" "disputationer" ;
  dispyt_nn_1 = mkN "dispyt" "dispyter" ;
  dissektion_nn_1 = mkN "dissektion" "dissektioner" ;
  dissenter_nn_1 = mkN "dissenter" "dissentern" "dissenter" "dissenterna" ;
  dissertation_nn_1 = mkN "dissertation" "dissertationer" ;
  dissident_nn_1 = mkN "dissident" "dissidenter" ;
  dissimilation_nn_1 = mkN "dissimilation" "dissimilationer" ;
  dissociation_nn_1 = mkN "dissociation" "dissociationer" ;
  dissonans_nn_1 = mkN "dissonans" "dissonanser" ;
  dissonant_av_1 = mkA "dissonant" "dissonant" ;
  dissonant_nn_1 = mkN "dissonant" "dissonanter" ;
  distans_nn_1 = mkN "distans" "distanser" ;
  distansflygning_nn_1 = mkN "distansflygning" ;
  distansminut_nn_1 = mkN "distansminut" "distansminuter" ;
  distikon_nn_1 = mkN "distikon" neutrum ;
  distinkt_av_1 = mkA "distinkt" "distinkt" ;
  distinktion_nn_1 = mkN "distinktion" "distinktioner" ;
  distorsion_nn_1 = mkN "distorsion" "distorsioner" ;
  distraktion_nn_1 = mkN "distraktion" "distraktioner" ;
  distraktor_nn_1 = mkN "distraktor" "distraktorer" ;
  distribuent_nn_1 = mkN "distribuent" "distribuenter" ;
  distribunal_nn_1 = mkN "distribunal" "distribunaler" ;
  distribution_nn_1 = mkN "distribution" "distributioner" ;
  distributionscentral_nn_1 = mkN "distributionscentral" "distributionscentraler" ;
  distributiv_av_1 = mkA "distributiv" ;
  distributoer_nn_1 = mkN "distributцr" "distributцrer" ;
  distrikt_nn_1 = mkN "distrikt" neutrum ;
  distriktslaekare_nn_1 = mkN "distriktslдkare" "distriktslдkare" ;
  distriktsmaestare_nn_1 = mkN "distriktsmдstare" "distriktsmдstare" ;
  distriktsmaesterskap_nn_1 = mkN "distriktsmдsterskap" "distriktsmдsterskapet" "distriktsmдsterskapen" "distriktsmдsterskapena" ;
  dit_ab_1 = mkAdv "dit" ;
  ditaat_ab_1 = mkAdv "ditеt" ;
  dithaen_ab_1 = mkAdv "dithдn" ;
  dithoerande_av_1 = mkA "dithцrande" ;
  ditintills_ab_1 = mkAdv "ditintills" ;
  dito_av_1 = mkA "dito" ;
  dittills_ab_1 = mkAdv "dittills" ;
  dittillsvarande_av_1 = mkA "dittillsvarande" ;
  dityramb_nn_1 = mkN "dityramb" "dityramber" ;
  dityrambisk_av_1 = mkA "dityrambisk" ;
  divan_nn_1 = mkN "divan" "divaner" ;
  divergens_nn_1 = mkN "divergens" "divergenser" ;
  divergent_av_1 = mkA "divergent" "divergent" ;
  diverse_av_1 = mkA "diverse" ;
  diversearbetare_nn_1 = mkN "diversearbetare" "diversearbetare" ;
  diversehandel_nn_1 = mkN "diversehandel" ;
  diversion_nn_1 = mkN "diversion" "diversioner" ;
  divertissemang_nn_1 = mkN "divertissemang" neutrum ;
  dividend_nn_1 = mkN "dividend" "dividender" ;
  divig_av_1 = mkA "divig" ;
  divinatorisk_av_1 = mkA "divinatorisk" ;
  divis_nn_1 = mkN "divis" "diviser" ;
  division_nn_1 = mkN "division" "divisioner" ;
  divisor_nn_1 = mkN "divisor" "divisorer" ;
  djaekne_nn_1 = mkN "djдkne" utrum ;
  djaerv_av_1 = mkA "djдrv" ;
  djaervhet_nn_1 = mkN "djдrvhet" "djдrvheter" ;
  djaevel_nn_1 = mkN "djдvel" ;
  djaevla_av_1 = mkA "djдvla" ;
  djaevlig_av_1 = mkA "djдvlig" ;
  djaevul_nn_1 = mkN "djдvul" "djдvulen" "djдvlar" "djдvlarna" ;
  djaevulsk_av_1 = mkA "djдvulsk" ;
  djaevulskap_nn_1 = mkN "djдvulskap" "djдvulskaper" ;
  djaevulstyg_nn_1 = mkN "djдvulstyg" neutrum ;
  djiboutier_nn_1 = mkN "djiboutier" "djiboutiern" "djiboutier" "djiboutierna" ;
  djiboutisk_av_1 = mkA "djiboutisk" ;
  djonk_nn_1 = mkN "djonk" "djonker" ;
  djungel_nn_1 = mkN "djungel" "djungeln" "djungler" "djunglerna" ;
  djup_av_1 = mkA "djup" ;
  djup_nn_1 = mkN "djup" neutrum ;
  djupbergart_nn_1 = mkN "djupbergart" "djupbergarter" ;
  djupbild_nn_1 = mkN "djupbild" "djupbilder" ;
  djupblaa_av_1 = mkA "djupblе" "djupblеtt" ;
  djupborrande_av_1 = mkA "djupborrande" ;
  djupborrning_nn_1 = mkN "djupborrning" ;
  djupbrytning_nn_1 = mkN "djupbrytning" ;
  djupdimension_nn_1 = mkN "djupdimension" "djupdimensioner" ;
  djupdykning_nn_1 = mkN "djupdykning" ;
  djupgaaende_av_1 = mkA "djupgеende" ;
  djuphavsbotten_nn_1 = mkN "djuphavsbotten" ;
  djuphavsfisk_nn_1 = mkN "djuphavsfisk" ;
  djuphavsvatten_nn_1 = mkN "djuphavsvatten" "djuphavsvattnet" "djuphavsvatten" "djuphavsvattnen" ;
  djuping_nn_1 = mkN "djuping" ;
  djupintervju_nn_1 = mkN "djupintervju" "djupintervjun" "djupintervjuer" "djupintervjuerna" ;
  djuplek_nn_1 = mkN "djuplek" ;
  djuplod_nn_1 = mkN "djuplod" neutrum ;
  djuplodande_av_1 = mkA "djuplodande" ;
  djupmask_nn_1 = mkN "djupmask" ;
  djuproed_av_1 = mkA "djuprцd" ;
  djupsinnig_av_1 = mkA "djupsinnig" ;
  djupsinnighet_nn_1 = mkN "djupsinnighet" "djupsinnigheter" ;
  djupstruktur_nn_1 = mkN "djupstruktur" "djupstrukturer" ;
  djuptaenkt_av_1 = mkA "djuptдnkt" "djuptдnkt" ;
  djuptryck_nn_1 = mkN "djuptryck" neutrum ;
  djupvatten_nn_1 = mkN "djupvatten" "djupvattnet" "djupvatten" "djupvattnen" ;
  djur_nn_1 = mkN "djur" neutrum ;
  djurangrepp_nn_1 = mkN "djurangrepp" neutrum ;
  djurart_nn_1 = mkN "djurart" "djurarter" ;
  djurben_nn_1 = mkN "djurben" neutrum ;
  djurdel_nn_1 = mkN "djurdel" "djurdelen" "djurdelar" "djurdelarna" ;
  djurfabel_nn_1 = mkN "djurfabel" "djurfabeln" "djurfabler" "djurfablerna" ;
  djurfoder_nn_1 = mkN "djurfoder" neutrum ;
  djurfoersoek_nn_1 = mkN "djurfцrsцk" neutrum ;
  djurgaard_nn_1 = mkN "djurgеrd" ;
  djurgrupp_nn_1 = mkN "djurgrupp" "djurgrupper" ;
  djurhud_nn_1 = mkN "djurhud" ;
  djurisk_av_1 = mkA "djurisk" ;
  djurkropp_nn_1 = mkN "djurkropp" ;
  djurlaekare_nn_1 = mkN "djurlдkare" "djurlдkare" ;
  djurpark_nn_1 = mkN "djurpark" "djurparker" ;
  djurplaagare_nn_1 = mkN "djurplеgare" "djurplеgare" ;
  djurplankton_nn_1 = mkN "djurplankton" neutrum ;
  djursjukhus_nn_1 = mkN "djursjukhus" neutrum ;
  djurskinn_nn_1 = mkN "djurskinn" neutrum ;
  djurskoetare_nn_1 = mkN "djurskцtare" "djurskцtare" ;
  djurslag_nn_1 = mkN "djurslag" neutrum ;
  djurtarm_nn_1 = mkN "djurtarm" ;
  djurutstaellning_nn_1 = mkN "djurutstдllning" ;
  djurvaen_nn_1 = mkN "djurvдn" "djurvдnnen" "djurvдnner" "djurvдnnerna" ;
  djurvaenlig_av_1 = mkA "djurvдnlig" ;
  doakoer_nn_1 = mkN "doakцr" "doakцrer" ;
  docent_nn_1 = mkN "docent" "docenter" ;
  docentur_nn_1 = mkN "docentur" "docenturer" ;
  dock_ab_1 = mkAdv "dock" ;
  dockskaap_nn_1 = mkN "dockskеp" neutrum ;
  docksoet_av_1 = mkA "docksцt" ;
  dockteater_nn_1 = mkN "dockteater" ;
  dodekaeder_nn_1 = mkN "dodekaeder" ;
  doebattang_nn_1 = mkN "dцbattang" "dцbattanger" ;
  doed_av_1 = mkA "dцd" ;
  doed_nn_1 = mkN "dцd" ;
  doedande_av_1 = mkA "dцdande" ;
  doedbraend_av_1 = mkA "dцdbrдnd" ;
  doeddansare_nn_1 = mkN "dцddansare" "dцddansare" ;
  doedfoedd_av_1 = mkA "dцdfцdd" ;
  doedfull_av_1 = mkA "dцdfull" ;
  doedgraevare_nn_1 = mkN "dцdgrдvare" "dцdgrдvare" ;
  doeding_nn_1 = mkN "dцding" ;
  doedlaege_nn_1 = mkN "dцdlдge" ;
  doedlig_av_1 = mkA "dцdlig" ;
  doedlighet_nn_1 = mkN "dцdlighet" "dцdligheter" ;
  doedperiod_nn_1 = mkN "dцdperiod" "dцdperioder" ;
  doedsannons_nn_1 = mkN "dцdsannons" "dцdsannonser" ;
  doedsattest_nn_1 = mkN "dцdsattest" "dцdsattester" ;
  doedsbaedd_nn_1 = mkN "dцdsbдdd" ;
  doedsbevis_nn_1 = mkN "dцdsbevis" neutrum ;
  doedsblek_av_1 = mkA "dцdsblek" ;
  doedsbo_nn_1 = mkN "dцdsbo" "dцdsbot" "dцdsbon" "dцdsboen" ;
  doedsdans_nn_1 = mkN "dцdsdans" "dцdsdanser" ;
  doedsdoemd_av_1 = mkA "dцdsdцmd" "dцdsdцmt" ;
  doedsdom_nn_1 = mkN "dцdsdom" ;
  doedsfall_nn_1 = mkN "dцdsfall" neutrum ;
  doedsfara_nn_1 = mkN "dцdsfara" ;
  doedsfas_nn_1 = mkN "dцdsfas" "dцdsfaser" ;
  doedsfiende_nn_1 = mkN "dцdsfiende" "dцdsfiender" ;
  doedsfoeraktande_av_1 = mkA "dцdsfцraktande" ;
  doedsfoerskraeckt_av_1 = mkA "dцdsfцrskrдckt" "dцdsfцrskrдckt" ;
  doedskalle_nn_1 = mkN "dцdskalle" utrum ;
  doedskallefjaeril_nn_1 = mkN "dцdskallefjдril" ;
  doedskamp_nn_1 = mkN "dцdskamp" "dцdskamper" ;
  doedsmaerkt_av_1 = mkA "dцdsmдrkt" "dцdsmдrkt" ;
  doedsmask_nn_1 = mkN "dцdsmask" "dцdsmasker" ;
  doedsoffer_nn_1 = mkN "dцdsoffer" neutrum ;
  doedsorsak_nn_1 = mkN "dцdsorsak" "dцdsorsaker" ;
  doedspatrull_nn_1 = mkN "dцdspatrull" "dцdspatruller" ;
  doedsrike_nn_1 = mkN "dцdsrike" ;
  doedssjuk_av_1 = mkA "dцdssjuk" ;
  doedsstelhet_nn_1 = mkN "dцdsstelhet" "dцdsstelheter" ;
  doedsstoet_nn_1 = mkN "dцdsstцt" ;
  doedsstraff_nn_1 = mkN "dцdsstraff" neutrum ;
  doedssynd_nn_1 = mkN "dцdssynd" "dцdssynder" ;
  doedstroett_av_1 = mkA "dцdstrцtt" ;
  doedstyst_av_1 = mkA "dцdstyst" "dцdstyst" ;
  doedsur_nn_1 = mkN "dцdsur" neutrum ;
  doegling_nn_1 = mkN "dцgling" ;
  doeing_nn_1 = mkN "dцing" ;
  doerj_nn_1 = mkN "dцrj" ;
  doerr_nn_1 = mkN "dцrr" ;
  doerrfoerhaenge_nn_1 = mkN "dцrrfцrhдnge" ;
  doerrfoersaeljare_nn_1 = mkN "dцrrfцrsдljare" "dцrrfцrsдljare" ;
  doerrhandtag_nn_1 = mkN "dцrrhandtag" neutrum ;
  doerrkarm_nn_1 = mkN "dцrrkarm" ;
  doerrkedja_nn_1 = mkN "dцrrkedja" ;
  doerrknackare_nn_1 = mkN "dцrrknackare" "dцrrknackare" ;
  doerroeppning_nn_1 = mkN "dцrrцppning" ;
  doerrpost_nn_1 = mkN "dцrrpost" "dцrrposter" ;
  doerrspegel_nn_1 = mkN "dцrrspegel" ;
  doerrstaengare_nn_1 = mkN "dцrrstдngare" "dцrrstдngare" ;
  does_nn_1 = mkN "dцs" ;
  doeskraj_av_1 = mkA "dцskraj" ;
  doev_av_1 = mkA "dцv" ;
  doevhet_nn_1 = mkN "dцvhet" "dцvheter" ;
  doevstum_av_1 = mkA "dцvstum" "dцvstumt" "dцvstumma" "dцvstumma" "dцvstummare" "dцvstummast" "dцvstummaste" ;
  doft_nn_1 = mkN "doft" "dofter" ;
  doftaemne_nn_1 = mkN "doftдmne" ;
  doftloes_av_1 = mkA "doftlцs" ;
  doftmarkering_nn_1 = mkN "doftmarkering" ;
  dogcart_nn_1 = mkN "dogcart" "dogcarter" ;
  doge_nn_1 = mkN "doge" "doger" ;
  dogg_nn_1 = mkN "dogg" ;
  dogm_nn_1 = mkN "dogm" "dogmer" ;
  dogmatiker_nn_1 = mkN "dogmatiker" "dogmatikern" "dogmatiker" "dogmatikerna" ;
  dogmatisk_av_1 = mkA "dogmatisk" ;
  dok_nn_1 = mkN "dok" neutrum ;
  doktor_nn_1 = mkN "doktor" "doktorer" ;
  doktorand_nn_1 = mkN "doktorand" "doktorander" ;
  doktorsavhandling_nn_1 = mkN "doktorsavhandling" ;
  doktorsdisputation_nn_1 = mkN "doktorsdisputation" "doktorsdisputationer" ;
  doktorsexamen_nn_1 = mkN "doktorsexamen" "doktorsexamen" "doktorsexamina" "doktorsexamina" ;
  doktorsgrad_nn_1 = mkN "doktorsgrad" "doktorsgrader" ;
  doktorshatt_nn_1 = mkN "doktorshatt" ;
  doktorspromotion_nn_1 = mkN "doktorspromotion" "doktorspromotioner" ;
  doktrin_nn_1 = mkN "doktrin" "doktriner" ;
  doktrinaer_av_1 = mkA "doktrinдr" ;
  dokument_nn_1 = mkN "dokument" neutrum ;
  dokumentaer_av_1 = mkA "dokumentдr" ;
  dokumentaer_nn_1 = mkN "dokumentдr" "dokumentдrer" ;
  dokumentaerfilm_nn_1 = mkN "dokumentдrfilm" "dokumentдrfilmer" ;
  dokumentaerprogram_nn_1 = mkN "dokumentдrprogram" "dokumentдrprogrammet" "dokumentдrprogram" "dokumentдrprogrammen" ;
  dokumentaerroman_nn_1 = mkN "dokumentдrroman" "dokumentдrromaner" ;
  dokumentalist_nn_1 = mkN "dokumentalist" "dokumentalister" ;
  dokumentarisk_av_1 = mkA "dokumentarisk" ;
  dokumentation_nn_1 = mkN "dokumentation" "dokumentationer" ;
  dokumentkreditiv_nn_1 = mkN "dokumentkreditiv" neutrum ;
  dokumentportfoelj_nn_1 = mkN "dokumentportfцlj" "dokumentportfцljer" ;
  dokumentsamling_nn_1 = mkN "dokumentsamling" ;
  dold_av_1 = mkA "dold" "dolt" ;
  doldis_nn_1 = mkN "doldis" ;
  dolikocefal_av_1 = mkA "dolikocefal" ;
  dolikocefal_nn_1 = mkN "dolikocefal" "dolikocefaler" ;
  dolikocefali_nn_1 = mkN "dolikocefali" "dolikocefalier" ;
  dolk_nn_1 = mkN "dolk" ;
  dolkstoet_nn_1 = mkN "dolkstцt" ;
  dollar_nn_1 = mkN "dollar" "dollarn" "dollar" "dollarna" ;
  dollargrin_nn_1 = mkN "dollargrin" neutrum ;
  dollarturist_nn_1 = mkN "dollarturist" "dollarturister" ;
  dolma_nn_1 = mkN "dolma" "dolman" "dolmar" "dolmarna" ;
  dolomit_nn_1 = mkN "dolomit" "dolomiter" ;
  dolsk_av_1 = mkA "dolsk" ;
  dom_nn_1 = mkN "dom" ;
  dom_nn_2 = mkN "dom" "domer" ;
  domaen_nn_1 = mkN "domдn" "domдner" ;
  domaenverk_nn_1 = mkN "domдnverk" neutrum ;
  domare_nn_1 = mkN "domare" "domare" ;
  domared_nn_1 = mkN "domared" "domareder" ;
  domaredans_nn_1 = mkN "domaredans" "domaredanser" ;
  domarring_nn_1 = mkN "domarring" ;
  dombok_nn_1 = mkN "dombok" "dombцcker" ;
  domedagspredikning_nn_1 = mkN "domedagspredikning" ;
  domedagsprofet_nn_1 = mkN "domedagsprofet" "domedagsprofeter" ;
  domestik_nn_1 = mkN "domestik" "domestiker" ;
  domfoer_av_1 = mkA "domfцr" ;
  domhavande_av_1 = mkA "domhavande" ;
  domherre_nn_1 = mkN "domherre" utrum ;
  domicil_nn_1 = mkN "domicil" neutrum ;
  dominant_av_1 = mkA "dominant" "dominant" ;
  dominant_nn_1 = mkN "dominant" "dominanter" ;
  dominerande_av_1 = mkA "dominerande" ;
  dominikan_nn_1 = mkN "dominikan" "dominikaner" ;
  dominikanerorden_nn_1 = mkN "dominikanerorden" ;
  dominikanmunk_nn_1 = mkN "dominikanmunk" ;
  dominikansk_av_1 = mkA "dominikansk" ;
  dominiker_nn_1 = mkN "dominiker" "dominikern" "dominiker" "dominikerna" ;
  dominikisk_av_1 = mkA "dominikisk" ;
  dominion_nn_1 = mkN "dominion" "dominion" "dominier" "dominierna" ;
  domino_nn_1 = mkN "domino" "dominor" ;
  dominoteori_nn_1 = mkN "dominoteori" "dominoteorier" ;
  domkapitel_nn_1 = mkN "domkapitel" neutrum ;
  domkraft_nn_1 = mkN "domkraft" "domkrafter" ;
  domkval_nn_1 = mkN "domkval" neutrum ;
  domkyrka_nn_1 = mkN "domkyrka" ;
  domprost_nn_1 = mkN "domprost" ;
  domptoer_nn_1 = mkN "domptцr" "domptцrer" ;
  domsaga_nn_1 = mkN "domsaga" ;
  domskael_nn_1 = mkN "domskдl" neutrum ;
  domslut_nn_1 = mkN "domslut" neutrum ;
  domsoendag_nn_1 = mkN "domsцndag" ;
  domssoendag_nn_1 = mkN "domssцndag" ;
  domstol_nn_1 = mkN "domstol" ;
  domstolsmaal_nn_1 = mkN "domstolsmеl" neutrum ;
  domstolsprotokoll_nn_1 = mkN "domstolsprotokoll" neutrum ;
  domstolsverk_nn_1 = mkN "domstolsverk" neutrum ;
  don_nn_1 = mkN "don" neutrum ;
  donation_nn_1 = mkN "donation" "donationer" ;
  donationsbrev_nn_1 = mkN "donationsbrev" neutrum ;
  donator_nn_1 = mkN "donator" "donatorer" ;
  doning_nn_1 = mkN "doning" ;
  donjuan_nn_1 = mkN "donjuan" "donjuan" "donjuaner" "donjuanerna" ;
  donlaege_nn_1 = mkN "donlдge" ;
  dop_nn_1 = mkN "dop" neutrum ;
  dopamin_nn_1 = mkN "dopamin" "dopaminer" ;
  dopaminkaenslig_av_1 = mkA "dopaminkдnslig" ;
  dopattest_nn_1 = mkN "dopattest" "dopattester" ;
  dopbassaeng_nn_1 = mkN "dopbassдng" "dopbassдnger" ;
  dopfunt_nn_1 = mkN "dopfunt" ;
  dopnamn_nn_1 = mkN "dopnamn" neutrum ;
  dopp_nn_1 = mkN "dopp" neutrum ;
  dopping_nn_1 = mkN "dopping" ;
  doppsko_nn_1 = mkN "doppsko" "doppskor" ;
  doppvaermare_nn_1 = mkN "doppvдrmare" "doppvдrmare" ;
  dopvittne_nn_1 = mkN "dopvittne" ;
  dorer_nn_1 = mkN "dorer" "dorern" "dorer" "dorerna" ;
  dorisk_av_1 = mkA "dorisk" ;
  dormitorium_nn_1 = mkN "dormitorium" "dormitoriet" "dormitorier" "dormitorierna" ;
  dorn_nn_1 = mkN "dorn" ;
  dorsal_av_1 = mkA "dorsal" ;
  dorsal_nn_1 = mkN "dorsal" "dorsaler" ;
  dorsk_av_1 = mkA "dorsk" ;
  dos_nn_1 = mkN "dos" "doser" ;
  dosbarometer_nn_1 = mkN "dosbarometer" ;
  dosekvivalent_nn_1 = mkN "dosekvivalent" "dosekvivalenter" ;
  dosering_nn_1 = mkN "dosering" ;
  dosimeter_nn_1 = mkN "dosimeter" ;
  doslibell_nn_1 = mkN "doslibell" "doslibeller" ;
  dosmaetare_nn_1 = mkN "dosmдtare" "dosmдtare" ;
  dossering_nn_1 = mkN "dossering" ;
  dossier_nn_1 = mkN "dossier" "dossiern" "dossierer" "dossiererna" ;
  dotation_nn_1 = mkN "dotation" "dotationer" ;
  dotter_nn_1 = mkN "dotter" "dottern" "dцttrar" "dцttrarna" ;
  dotterbolag_nn_1 = mkN "dotterbolag" neutrum ;
  dottercell_nn_1 = mkN "dottercell" "dotterceller" ;
  dotterdotter_nn_1 = mkN "dotterdotter" "dotterdottern" "dotterdцttrar" "dotterdцttrarna" ;
  dotterfoeretag_nn_1 = mkN "dotterfцretag" neutrum ;
  dotterfoersamling_nn_1 = mkN "dotterfцrsamling" ;
  dotterlig_av_1 = mkA "dotterlig" ;
  dotterson_nn_1 = mkN "dotterson" "dottersцner" ;
  dotterspraak_nn_1 = mkN "dottersprеk" neutrum ;
  dottersvulst_nn_1 = mkN "dottersvulst" "dottersvulster" ;
  dottertumoer_nn_1 = mkN "dottertumцr" "dottertumцrer" ;
  double_nn_2 = mkN "doublй" "doublйer" ;
  dov_av_1 = mkA "dov" ;
  dovhjort_nn_1 = mkN "dovhjort" ;
  downperiod_nn_1 = mkN "downperiod" "downperioder" ;
  doyen_nn_1 = mkN "doyen" "doyener" ;
  dra_vb_1 = mkV "dra" "drar" "dra" "drog" "dragit" "dragen" ;
  draap_nn_1 = mkN "drеp" neutrum ;
  draapare_nn_1 = mkN "drеpare" "drеpare" ;
  draaplig_av_1 = mkA "drеplig" ;
  draapslag_nn_1 = mkN "drеpslag" neutrum ;
  draase_nn_1 = mkN "drеse" utrum ;
  drabant_nn_1 = mkN "drabant" "drabanter" ;
  drabantstat_nn_1 = mkN "drabantstat" "drabantstater" ;
  drabbning_nn_1 = mkN "drabbning" ;
  draeglig_av_1 = mkA "drдglig" ;
  draekt_nn_1 = mkN "drдkt" "drдkter" ;
  draektig_av_1 = mkA "drдktig" ;
  draektighet_nn_1 = mkN "drдktighet" "drдktigheter" ;
  draen_nn_1 = mkN "drдn" "drдner" ;
  draenering_nn_1 = mkN "drдnering" ;
  draeneringsdike_nn_1 = mkN "drдneringsdike" ;
  draeneringsomraade_nn_1 = mkN "drдneringsomrеde" ;
  draeng_nn_1 = mkN "drдng" ;
  draengtjaenst_nn_1 = mkN "drдngtjдnst" "drдngtjдnster" ;
  draepande_av_1 = mkA "drдpande" ;
  draetselkammare_nn_1 = mkN "drдtselkammare" "drдtselkammaren" "drдtselkamrar" "drдtselkamrarna" ;
  draett_nn_1 = mkN "drдtt" ;
  drag_nn_1 = mkN "drag" neutrum ;
  dragare_nn_1 = mkN "dragare" "dragare" ;
  dragbaenk_nn_1 = mkN "dragbдnk" ;
  dragband_nn_1 = mkN "dragband" neutrum ;
  dragbasun_nn_1 = mkN "dragbasun" "dragbasuner" ;
  dragbil_nn_1 = mkN "dragbil" ;
  dragdjur_nn_1 = mkN "dragdjur" neutrum ;
  drage_nn_1 = mkN "dragй" "dragйer" ;
  dragen_av_1 = mkA "dragen" "draget" ;
  dragg_nn_1 = mkN "dragg" ;
  draghaallfasthet_nn_1 = mkN "draghеllfasthet" "draghеllfastheter" ;
  dragig_av_1 = mkA "dragig" ;
  dragkamp_nn_1 = mkN "dragkamp" "dragkamper" ;
  dragkedja_nn_1 = mkN "dragkedja" ;
  dragkrok_nn_1 = mkN "dragkrok" ;
  dragnagel_nn_1 = mkN "dragnagel" ;
  dragning_nn_1 = mkN "dragning" ;
  dragoman_nn_1 = mkN "dragoman" "dragomaner" ;
  dragon_nn_1 = mkN "dragon" "dragoner" ;
  dragplaaster_nn_1 = mkN "dragplеster" neutrum ;
  dragpress_nn_1 = mkN "dragpress" ;
  dragprov_nn_1 = mkN "dragprov" neutrum ;
  dragshow_nn_1 = mkN "dragshow" "dragshower" ;
  dragskaap_nn_1 = mkN "dragskеp" neutrum ;
  dragsko_nn_1 = mkN "dragsko" "dragskor" ;
  dragspel_nn_1 = mkN "dragspel" "dragspelet" "dragspel" "dragspelen" ;
  dragstift_nn_1 = mkN "dragstift" neutrum ;
  drakblodstraed_nn_1 = mkN "drakblodstrдd" neutrum ;
  drake_nn_1 = mkN "drake" utrum ;
  drakflygare_nn_1 = mkN "drakflygare" "drakflygare" ;
  drakhuvudfisk_nn_1 = mkN "drakhuvudfisk" ;
  drakma_nn_1 = mkN "drakma" "drakman" "drakmer" "drakmerna" ;
  drakonisk_av_1 = mkA "drakonisk" ;
  draksaadd_nn_1 = mkN "draksеdd" "draksеdder" ;
  drakskepp_nn_1 = mkN "drakskepp" neutrum ;
  dram_nn_1 = mkN "dram" "dramer" ;
  drama_nn_1 = mkN "drama" "dramat" "draman" "dramana" ;
  dramatiker_nn_1 = mkN "dramatiker" "dramatikern" "dramatiker" "dramatikerna" ;
  dramatisering_nn_1 = mkN "dramatisering" ;
  dramatisk_av_1 = mkA "dramatisk" ;
  dramaturg_nn_1 = mkN "dramaturg" "dramaturger" ;
  draperi_nn_1 = mkN "draperi" "draperit" "draperier" "draperierna" ;
  drapering_nn_1 = mkN "drapering" ;
  drastisk_av_1 = mkA "drastisk" ;
  drasut_nn_1 = mkN "drasut" "drasuter" ;
  dress_nn_1 = mkN "dress" ;
  dressin_nn_1 = mkN "dressin" "dressiner" ;
  dressing_nn_1 = mkN "dressing" ;
  dressoer_nn_1 = mkN "dressцr" "dressцrer" ;
  dressyr_nn_1 = mkN "dressyr" "dressyrer" ;
  dressyrridning_nn_1 = mkN "dressyrridning" ;
  drev_nn_1 = mkN "drev" neutrum ;
  drever_nn_1 = mkN "drever" ;
  drevhund_nn_1 = mkN "drevhund" ;
  drevjakt_nn_1 = mkN "drevjakt" "drevjakter" ;
  drevkarl_nn_1 = mkN "drevkarl" ;
  dribbler_nn_1 = mkN "dribbler" "dribblern" "dribbler" "dribblerna" ;
  dribbling_nn_1 = mkN "dribbling" ;
  dricka_vb_1 = mkV "dricka" "drack" "druckit" ;
  drickankare_nn_1 = mkN "drickankare" "drickankaret" "drickankare" "drickankarna" ;
  drickbar_av_1 = mkA "drickbar" ;
  dricksglas_nn_1 = mkN "dricksglas" neutrum ;
  drickspeng_nn_1 = mkN "drickspeng" ;
  dricksvatten_nn_1 = mkN "dricksvatten" "dricksvattnet" "dricksvatten" "dricksvattnen" ;
  drift_nn_2 = mkN "drift" "drifter" ;
  driftbudget_nn_1 = mkN "driftbudget" ;
  driftig_av_1 = mkA "driftig" ;
  driftkostnad_nn_1 = mkN "driftkostnad" "driftkostnader" ;
  driftkucku_nn_1 = mkN "driftkucku" ;
  driftsaeker_av_1 = mkA "driftsдker" "driftsдkert" "driftsдkra" "driftsдkra" "driftsдkrare" "driftsдkrast" "driftsдkraste" ;
  driftskostnad_nn_1 = mkN "driftskostnad" "driftskostnader" ;
  driftstopp_nn_1 = mkN "driftstopp" neutrum ;
  drill_nn_1 = mkN "drill" ;
  drillborr_nn_1 = mkN "drillborr" ;
  drilling_nn_1 = mkN "drilling" ;
  drink_nn_1 = mkN "drink" ;
  drinkare_nn_1 = mkN "drinkare" "drinkare" ;
  dristig_av_1 = mkA "dristig" ;
  drittel_nn_1 = mkN "drittel" ;
  driv_nn_1 = mkN "driv" ;
  driva_vb_1 = mkV "driva" "drev" "drivit" ;
  drivande_av_1 = mkA "drivande" ;
  drivankare_nn_1 = mkN "drivankare" "drivankaret" "drivankare" "drivankarna" ;
  drivaxel_nn_1 = mkN "drivaxel" ;
  drivbaenk_nn_1 = mkN "drivbдnk" ;
  drivband_nn_1 = mkN "drivband" neutrum ;
  drive_nn_1 = mkN "drive" utrum ;
  driven_av_1 = mkA "driven" "drivet" ;
  drivfjaeder_nn_1 = mkN "drivfjдder" ;
  drivgarn_nn_1 = mkN "drivgarn" neutrum ;
  drivhjul_nn_1 = mkN "drivhjul" neutrum ;
  drivhus_nn_1 = mkN "drivhus" neutrum ;
  drivkedja_nn_1 = mkN "drivkedja" ;
  drivkraft_nn_1 = mkN "drivkraft" "drivkrafter" ;
  drivmedel_nn_1 = mkN "drivmedel" neutrum ;
  droeg_nn_1 = mkN "drцg" ;
  droeglapp_nn_1 = mkN "drцglapp" ;
  droejsmaal_nn_1 = mkN "drцjsmеl" neutrum ;
  droem_nn_1 = mkN "drцm" "drцmmen" "drцmmar" "drцmmarna" ;
  droembok_nn_1 = mkN "drцmbok" "drцmbцcker" ;
  droemmare_nn_1 = mkN "drцmmare" "drцmmare" ;
  droemmeri_nn_1 = mkN "drцmmeri" "drцmmerit" "drцmmerier" "drцmmerierna" ;
  droemsk_av_1 = mkA "drцmsk" ;
  droemslott_nn_1 = mkN "drцmslott" neutrum ;
  droemtydning_nn_1 = mkN "drцmtydning" ;
  droemvaerld_nn_1 = mkN "drцmvдrld" ;
  droenare_nn_1 = mkN "drцnare" "drцnare" ;
  droes_nn_1 = mkN "drцs" ;
  droese_nn_1 = mkN "drцse" utrum ;
  drog_nn_1 = mkN "drog" "droger" ;
  drogeri_nn_1 = mkN "drogeri" "drogerit" "drogerier" "drogerierna" ;
  droghandel_nn_1 = mkN "droghandel" ;
  drogmissbruk_nn_1 = mkN "drogmissbruk" neutrum ;
  drogmissbrukare_nn_1 = mkN "drogmissbrukare" "drogmissbrukare" ;
  dromedar_nn_1 = mkN "dromedar" "dromedarer" ;
  dront_nn_1 = mkN "dront" "dronter" ;
  droppe_nn_1 = mkN "droppe" utrum ;
  droppglas_nn_1 = mkN "droppglas" neutrum ;
  droppinfektion_nn_1 = mkN "droppinfektion" "droppinfektioner" ;
  droppkork_nn_1 = mkN "droppkork" ;
  droppspets_nn_1 = mkN "droppspets" ;
  droppsten_nn_1 = mkN "droppsten" "droppstenen" "droppstenar" "droppstenarna" ;
  droppvis_ab_1 = mkAdv "droppvis" ;
  droskfoerare_nn_1 = mkN "droskfцrare" "droskfцrare" ;
  drossel_nn_1 = mkN "drossel" ;
  drots_nn_1 = mkN "drots" ;
  drott_nn_1 = mkN "drott" ;
  drottning_nn_1 = mkN "drottning" ;
  drucken_av_1 = mkA "drucken" "drucket" ;
  drufs_nn_1 = mkN "drufs" ;
  druid_nn_1 = mkN "druid" "druider" ;
  drul_nn_1 = mkN "drul" ;
  drulle_nn_1 = mkN "drulle" utrum ;
  drullefoersaekring_nn_1 = mkN "drullefцrsдkring" ;
  drullig_av_1 = mkA "drullig" ;
  drullputt_nn_1 = mkN "drullputt" ;
  drumlig_av_1 = mkA "drumlig" ;
  drummel_nn_1 = mkN "drummel" "drummeln" "drummlar" "drummlarna" ;
  drummelaktig_av_1 = mkA "drummelaktig" ;
  drunkning_nn_1 = mkN "drunkning" ;
  drus_nn_1 = mkN "drus" "druser" ;
  druvblaa_av_1 = mkA "druvblе" "druvblеtt" ;
  druvboerd_nn_1 = mkN "druvbцrd" "druvbцrder" ;
  druvflaeder_nn_1 = mkN "druvflдder" ;
  druvhagel_nn_1 = mkN "druvhagel" neutrum ;
  druvklase_nn_1 = mkN "druvklase" utrum ;
  druvrussin_nn_1 = mkN "druvrussin" neutrum ;
  dryad_nn_1 = mkN "dryad" "dryader" ;
  dryck_nn_1 = mkN "dryck" "drycker" ;
  dryckesbroder_nn_1 = mkN "dryckesbroder" "dryckesbrodern" "dryckesbrцder" "dryckesbrцderna" ;
  dryckeshorn_nn_1 = mkN "dryckeshorn" neutrum ;
  dryckeskaerl_nn_1 = mkN "dryckeskдrl" neutrum ;
  dryckeslag_nn_1 = mkN "dryckeslag" neutrum ;
  dryckesoffer_nn_1 = mkN "dryckesoffer" neutrum ;
  dryckesservis_nn_1 = mkN "dryckesservis" "dryckesserviser" ;
  dryg_av_1 = mkA "dryg" ;
  dryghet_nn_1 = mkN "dryghet" "drygheter" ;
  dualist_nn_1 = mkN "dualist" "dualister" ;
  dualistisk_av_1 = mkA "dualistisk" ;
  dubb_nn_1 = mkN "dubb" ;
  dubbdaeck_nn_1 = mkN "dubbdдck" neutrum ;
  dubbel_av_1 = mkA "dubbel" "dubbelt" "dubbla" "dubbla" "dubblare" "dubblast" "dubblaste" ;
  dubbelagent_nn_1 = mkN "dubbelagent" "dubbelagenter" ;
  dubbelarbetande_av_1 = mkA "dubbelarbetande" ;
  dubbelbeckasin_nn_1 = mkN "dubbelbeckasin" "dubbelbeckasiner" ;
  dubbelbiff_nn_1 = mkN "dubbelbiff" ;
  dubbelbindning_nn_1 = mkN "dubbelbindning" ;
  dubbelbluff_nn_1 = mkN "dubbelbluff" ;
  dubbelbotten_nn_1 = mkN "dubbelbotten" ;
  dubbelbredd_nn_1 = mkN "dubbelbredd" "dubbelbredder" ;
  dubbelbroellop_nn_1 = mkN "dubbelbrцllop" neutrum ;
  dubbelbrytning_nn_1 = mkN "dubbelbrytning" ;
  dubbeldaeckare_nn_1 = mkN "dubbeldдckare" "dubbeldдckare" ;
  dubbeldoerr_nn_1 = mkN "dubbeldцrr" ;
  dubbelfel_nn_1 = mkN "dubbelfel" "dubbelfelet" "dubbelfel" "dubbelfelen" ;
  dubbelfoenster_nn_1 = mkN "dubbelfцnster" neutrum ;
  dubbelgaangare_nn_1 = mkN "dubbelgеngare" "dubbelgеngare" ;
  dubbelgrepp_nn_1 = mkN "dubbelgrepp" neutrum ;
  dubbelhet_nn_1 = mkN "dubbelhet" "dubbelheter" ;
  dubbelhytt_nn_1 = mkN "dubbelhytt" "dubbelhytter" ;
  dubbelkommando_nn_1 = mkN "dubbelkommando" "dubbelkommandot" "dubbelkommandon" "dubbelkommandona" ;
  dubbelkontakt_nn_1 = mkN "dubbelkontakt" "dubbelkontakter" ;
  dubbelmening_nn_1 = mkN "dubbelmening" ;
  dubbelmord_nn_1 = mkN "dubbelmord" neutrum ;
  dubbelnamn_nn_1 = mkN "dubbelnamn" neutrum ;
  dubbelnatur_nn_1 = mkN "dubbelnatur" "dubbelnaturer" ;
  dubbelnoet_nn_1 = mkN "dubbelnцt" "dubbelnцtter" ;
  dubbelpipig_av_1 = mkA "dubbelpipig" ;
  dubbelrevolution_nn_1 = mkN "dubbelrevolution" "dubbelrevolutioner" ;
  dubbelroer_nn_1 = mkN "dubbelrцr" neutrum ;
  dubbelroll_nn_1 = mkN "dubbelroll" "dubbelroller" ;
  dubbelrum_nn_1 = mkN "dubbelrum" "dubbelrummet" "dubbelrum" "dubbelrummen" ;
  dubbelsaeng_nn_1 = mkN "dubbelsдng" ;
  dubbelsalt_nn_1 = mkN "dubbelsalt" "dubbelsaltet" "dubbelsalter" "dubbelsalterna" ;
  dubbelsidig_av_1 = mkA "dubbelsidig" ;
  dubbelspel_nn_1 = mkN "dubbelspel" "dubbelspelet" "dubbelspel" "dubbelspelen" ;
  dubbelstjaernsystem_nn_1 = mkN "dubbelstjдrnsystem" neutrum ;
  dubbeltimme_nn_1 = mkN "dubbeltimme" utrum ;
  dubbeltraadig_av_1 = mkA "dubbeltrеdig" ;
  dubbeltraeff_nn_1 = mkN "dubbeltrдff" ;
  dubbeltydig_av_1 = mkA "dubbeltydig" ;
  dubble_nn_2 = mkN "dubblй" "dubblйer" ;
  dubblett_nn_1 = mkN "dubblett" "dubbletter" ;
  dubioes_av_1 = mkA "dubiцs" ;
  dublett_nn_1 = mkN "dublett" "dubletter" ;
  duchatel_nn_1 = mkN "duchatel" "duchateler" ;
  duell_nn_1 = mkN "duell" "dueller" ;
  duellant_nn_1 = mkN "duellant" "duellanter" ;
  duett_nn_1 = mkN "duett" "duetter" ;
  duffel_nn_1 = mkN "duffel" ;
  dugande_av_1 = mkA "dugande" ;
  duggregn_nn_1 = mkN "duggregn" neutrum ;
  duglig_av_1 = mkA "duglig" ;
  duglighet_nn_1 = mkN "duglighet" "dugligheter" ;
  duk_nn_1 = mkN "duk" ;
  dukagaang_nn_1 = mkN "dukagеng" ;
  dukat_nn_1 = mkN "dukat" "dukater" ;
  dukning_nn_1 = mkN "dukning" ;
  dukt_nn_1 = mkN "dukt" "dukter" ;
  duktig_av_1 = mkA "duktig" ;
  dulcian_nn_1 = mkN "dulcian" "dulcianer" ;
  dum_av_1 = mkA "dum" "dumt" "dumma" "dumma" "dummare" "dummast" "dummaste" ;
  dumbom_nn_1 = mkN "dumbom" "dumbommen" "dumbommar" "dumbommarna" ;
  dumdristig_av_1 = mkA "dumdristig" ;
  dumdryg_av_1 = mkA "dumdryg" ;
  dumhet_nn_1 = mkN "dumhet" "dumheter" ;
  dumhuvud_nn_1 = mkN "dumhuvud" "dumhuvudet" "dumhuvuden" "dumhuvudena" ;
  dummerjoens_nn_1 = mkN "dummerjцns" ;
  dumming_nn_1 = mkN "dumming" ;
  dummy_nn_1 = mkN "dummy" "dummyn" "dummies" "dummyerna" ;
  dumper_nn_1 = mkN "dumper" ;
  dumskalle_nn_1 = mkN "dumskalle" utrum ;
  dumsnut_nn_1 = mkN "dumsnut" ;
  dun_nn_1 = mkN "dun" neutrum ;
  dunboll_nn_1 = mkN "dunboll" ;
  dunder_nn_1 = mkN "dunder" neutrum ;
  dunge_nn_1 = mkN "dunge" utrum ;
  dunig_av_1 = mkA "dunig" ;
  dunk_nn_1 = mkN "dunk" ;
  dunkel_av_1 = mkA "dunkel" "dunkelt" "dunkla" "dunkla" "dunklare" "dunklast" "dunklaste" ;
  dunkelblaa_av_1 = mkA "dunkelblе" "dunkelblеtt" ;
  dunlaett_av_1 = mkA "dunlдtt" ;
  duns_nn_1 = mkN "duns" ;
  dunst_nn_1 = mkN "dunst" "dunster" ;
  dunstig_av_1 = mkA "dunstig" ;
  dununge_nn_1 = mkN "dununge" utrum ;
  duo_nn_1 = mkN "duo" "duon" "duos" "duosen" ;
  duodecimalsystem_nn_1 = mkN "duodecimalsystem" neutrum ;
  duodes_nn_1 = mkN "duodes" "duodeser" ;
  duplett_nn_1 = mkN "duplett" "dupletter" ;
  duplexfaerg_nn_1 = mkN "duplexfдrg" "duplexfдrger" ;
  duplicering_nn_1 = mkN "duplicering" ;
  duplik_nn_1 = mkN "duplik" "dupliker" ;
  duplikat_nn_1 = mkN "duplikat" neutrum ;
  duplikator_nn_1 = mkN "duplikator" "duplikatorer" ;
  durabel_av_1 = mkA "durabel" ;
  duralexglas_nn_1 = mkN "duralexglas" neutrum ;
  durativ_av_1 = mkA "durativ" ;
  dureform_nn_1 = mkN "dureform" "dureformer" ;
  durk_nn_1 = mkN "durk" ;
  durkdriven_av_1 = mkA "durkdriven" "durkdrivet" ;
  durkslag_nn_1 = mkN "durkslag" neutrum ;
  duroplast_nn_1 = mkN "duroplast" "duroplaster" ;
  dus_nn_1 = mkN "dus" "duser" ;
  dusch_nn_1 = mkN "dusch" ;
  duskaal_nn_1 = mkN "duskеl" ;
  dusoer_nn_1 = mkN "dusцr" "dusцrer" ;
  dussin_nn_1 = mkN "dussin" neutrum ;
  dussinmaenniska_nn_1 = mkN "dussinmдnniska" ;
  dussinroman_nn_1 = mkN "dussinroman" "dussinromaner" ;
  dussintal_nn_1 = mkN "dussintal" "dussintalet" "dussintalen" "dussintalena" ;
  dussintals_ab_1 = mkAdv "dussintals" ;
  dussinvis_ab_1 = mkAdv "dussinvis" ;
  dust_nn_1 = mkN "dust" "duster" ;
  duvblaa_av_1 = mkA "duvblе" "duvblеtt" ;
  duven_av_1 = mkA "duven" "duvet" ;
  duvfaagel_nn_1 = mkN "duvfеgel" ;
  duvhoek_nn_1 = mkN "duvhцk" ;
  duvning_nn_1 = mkN "duvning" ;
  duvslag_nn_1 = mkN "duvslag" neutrum ;
  duvunge_nn_1 = mkN "duvunge" utrum ;
  dvaerg_nn_1 = mkN "dvдrg" ;
  dvaergbjoerk_nn_1 = mkN "dvдrgbjцrk" ;
  dvaergbrytare_nn_1 = mkN "dvдrgbrytare" "dvдrgbrytare" ;
  dvaergbuske_nn_1 = mkN "dvдrgbuske" utrum ;
  dvaerggalax_nn_1 = mkN "dvдrggalax" "dvдrggalaxer" ;
  dvaerghamster_nn_1 = mkN "dvдrghamster" ;
  dvaerghund_nn_1 = mkN "dvдrghund" ;
  dyblad_nn_1 = mkN "dyblad" neutrum ;
  dybloet_av_1 = mkA "dyblцt" ;
  dyborre_nn_1 = mkN "dyborre" utrum ;
  dyckert_nn_1 = mkN "dyckert" ;
  dygd_nn_1 = mkN "dygd" "dygder" ;
  dygdemoenster_nn_1 = mkN "dygdemцnster" neutrum ;
  dygdig_av_1 = mkA "dygdig" ;
  dygn_nn_1 = mkN "dygn" neutrum ;
  dygnsring_nn_1 = mkN "dygnsring" ;
  dygnsrytm_nn_1 = mkN "dygnsrytm" "dygnsrytmer" ;
  dyig_av_1 = mkA "dyig" ;
  dykand_nn_1 = mkN "dykand" "dykдnder" ;
  dykarbagge_nn_1 = mkN "dykarbagge" utrum ;
  dykardraekt_nn_1 = mkN "dykardrдkt" "dykardrдkter" ;
  dykare_nn_1 = mkN "dykare" "dykare" ;
  dykarutrustning_nn_1 = mkN "dykarutrustning" ;
  dykdalb_nn_1 = mkN "dykdalb" "dykdalber" ;
  dykning_nn_1 = mkN "dykning" ;
  dymedelst_ab_1 = mkAdv "dymedelst" ;
  dymling_nn_1 = mkN "dymling" ;
  dymmelonsdag_nn_1 = mkN "dymmelonsdag" ;
  dymmelvecka_nn_1 = mkN "dymmelvecka" ;
  dyn_nn_1 = mkN "dyn" "dyner" ;
  dyn_nn_2 = mkN "dyn" neutrum ;
  dynamisk_av_1 = mkA "dynamisk" ;
  dynamitard_nn_1 = mkN "dynamitard" "dynamitarder" ;
  dynamitgubbe_nn_1 = mkN "dynamitgubbe" utrum ;
  dynamo_nn_1 = mkN "dynamo" "dynamor" ;
  dynamometer_nn_1 = mkN "dynamometer" ;
  dynasti_nn_1 = mkN "dynasti" "dynastier" ;
  dynastisk_av_1 = mkA "dynastisk" ;
  dyngbagge_nn_1 = mkN "dyngbagge" utrum ;
  dyning_nn_1 = mkN "dyning" ;
  dyr_av_1 = mkA "dyr" ;
  dyrbar_av_1 = mkA "dyrbar" ;
  dyrbarhet_nn_1 = mkN "dyrbarhet" "dyrbarheter" ;
  dyrgrip_nn_1 = mkN "dyrgrip" ;
  dyrk_nn_1 = mkN "dyrk" ;
  dyrkansvaerd_av_1 = mkA "dyrkansvдrd" "dyrkansvдrt" ;
  dyrkare_nn_1 = mkN "dyrkare" "dyrkare" ;
  dyrkfri_av_1 = mkA "dyrkfri" "dyrkfritt" ;
  dyrkoept_av_1 = mkA "dyrkцpt" "dyrkцpt" ;
  dyrort_nn_1 = mkN "dyrort" "dyrorter" ;
  dyrortsgrupp_nn_1 = mkN "dyrortsgrupp" "dyrortsgrupper" ;
  dyrortsgruppering_nn_1 = mkN "dyrortsgruppering" ;
  dyrtid_nn_1 = mkN "dyrtid" "dyrtider" ;
  dys_nn_1 = mkN "dys" "dyser" ;
  dyschatell_nn_1 = mkN "dyschatell" "dyschateller" ;
  dysenteri_nn_1 = mkN "dysenteri" "dysenterier" ;
  dysfori_nn_1 = mkN "dysfori" "dysforier" ;
  dyslexi_nn_1 = mkN "dyslexi" "dyslexier" ;
  dyspepsi_nn_1 = mkN "dyspepsi" "dyspepsier" ;
  dyster_av_1 = mkA "dyster" "dystert" "dystra" "dystra" "dystrare" "dystrast" "dystraste" ;
  dystopi_nn_1 = mkN "dystopi" "dystopier" ;
  dystrof_av_1 = mkA "dystrof" ;
  dystrofi_nn_1 = mkN "dystrofi" "dystrofier" ;
  dyvaat_av_1 = mkA "dyvеt" ;
  e_brev_nn_1 = mkN "e-brev" neutrum ;
  e_mail_nn_2 = mkN "e-mail" neutrum ;
  ebenist_nn_1 = mkN "ebenist" "ebenister" ;
  ebonitstav_nn_1 = mkN "ebonitstav" ;
  echelong_nn_1 = mkN "echelong" "echelonger" ;
  ecklesiastik_av_1 = mkA "ecklesiastik" ;
  ecklesiastikdepartement_nn_1 = mkN "ecklesiastikdepartement" "ecklesiastikdepartementet" "ecklesiastikdepartementen" "ecklesiastikdepartementena" ;
  ecklesiastikminister_nn_1 = mkN "ecklesiastikminister" ;
  ecklesiastisk_av_1 = mkA "ecklesiastisk" ;
  ecuadorian_nn_1 = mkN "ecuadorian" "ecuadorianer" ;
  ecuadoriansk_av_1 = mkA "ecuadoriansk" ;
  ecuadorianska_nn_1 = mkN "ecuadorianska" ;
  ed_ab_1 = mkAdv "ed" ;
  ed_nn_1 = mkN "ed" "eder" ;
  ed_nn_2 = mkN "ed" neutrum ;
  edamerost_nn_1 = mkN "edamerost" ;
  edgaang_nn_1 = mkN "edgеng" ;
  edikt_nn_1 = mkN "edikt" neutrum ;
  edil_nn_1 = mkN "edil" "ediler" ;
  edition_nn_1 = mkN "edition" "editioner" ;
  edlig_av_1 = mkA "edlig" ;
  edligen_ab_1 = mkAdv "edligen" ;
  edsbrott_nn_1 = mkN "edsbrott" neutrum ;
  edsvuren_av_1 = mkA "edsvuren" "edsvuret" ;
  efedrin_nn_1 = mkN "efedrin" "efedriner" ;
  efemaer_av_1 = mkA "efemдr" ;
  efemerid_nn_1 = mkN "efemerid" "efemerider" ;
  effekt_nn_1 = mkN "effekt" "effekter" ;
  effektfaktor_nn_1 = mkN "effektfaktor" "effektfaktorer" ;
  effektfoerstaerkare_nn_1 = mkN "effektfцrstдrkare" "effektfцrstдrkare" ;
  effektfraanskiljare_nn_1 = mkN "effektfrеnskiljare" "effektfrеnskiljare" ;
  effektfull_av_1 = mkA "effektfull" ;
  effektiv_av_1 = mkA "effektiv" ;
  effektivitet_nn_1 = mkN "effektivitet" "effektiviteter" ;
  effektoekning_nn_1 = mkN "effektцkning" ;
  effektsoekeri_nn_1 = mkN "effektsцkeri" "effektsцkerit" "effektsцkerier" "effektsцkerierna" ;
  efor_nn_1 = mkN "efor" "eforen" "eforer" "eforerna" ;
  eforus_nn_1 = mkN "eforus" "eforus" "eforer" "eforerna" ;
  efter_ab_1 = mkAdv "efter" ;
  efter_av_1 = mkA "efter" ;
  efteraat_ab_1 = mkAdv "efterеt" ;
  efteraccept_nn_1 = mkN "efteraccept" neutrum ;
  efterbesiktning_nn_1 = mkN "efterbesiktning" ;
  efterbeskattning_nn_1 = mkN "efterbeskattning" ;
  efterbestaellning_nn_1 = mkN "efterbestдllning" ;
  efterbild_nn_1 = mkN "efterbild" "efterbilder" ;
  efterbildning_nn_1 = mkN "efterbildning" ;
  efterbliven_av_1 = mkA "efterbliven" "efterblivet" ;
  efterbloedning_nn_1 = mkN "efterblцdning" ;
  efterboerd_nn_1 = mkN "efterbцrd" "efterbцrder" ;
  efterboers_nn_1 = mkN "efterbцrs" "efterbцrser" ;
  efterbraennare_nn_1 = mkN "efterbrдnnare" "efterbrдnnare" ;
  efterbraennkammare_nn_1 = mkN "efterbrдnnkammare" "efterbrдnnkammaren" "efterbrдnnkamrar" "efterbrдnnkamrarna" ;
  efterdoeme_nn_1 = mkN "efterdцme" ;
  efterdoemlig_av_1 = mkA "efterdцmlig" ;
  efterdyning_nn_1 = mkN "efterdyning" ;
  efterfoeljansvaerd_av_1 = mkA "efterfцljansvдrd" "efterfцljansvдrt" ;
  efterfoeljare_nn_1 = mkN "efterfцljare" "efterfцljare" ;
  efterfoeljelse_nn_1 = mkN "efterfцljelse" "efterfцljelser" ;
  efterforskning_nn_1 = mkN "efterforskning" ;
  efterfraagning_nn_1 = mkN "efterfrеgning" ;
  efterge_vb_1 = mkV "efterge" "efterger" "efterge" "eftergav" "eftergett" "eftergiven" ;
  eftergift_nn_1 = mkN "eftergift" "eftergifter" ;
  eftergiven_av_1 = mkA "eftergiven" "eftergivet" ;
  eftergivenhet_nn_1 = mkN "eftergivenhet" "eftergivenheter" ;
  eftergivlig_av_1 = mkA "eftergivlig" ;
  eftergjord_av_1 = mkA "eftergjord" "eftergjort" ;
  eftergranskning_nn_1 = mkN "eftergranskning" ;
  eftergymnasial_av_1 = mkA "eftergymnasial" ;
  efterhaalla_vb_1 = mkV "efterhеlla" "efterhцll" "efterhеllit" ;
  efterhaengsen_av_1 = mkA "efterhдngsen" "efterhдngset" ;
  efterhaermning_nn_1 = mkN "efterhдrmning" ;
  efterhand_ab_1 = mkAdv "efterhand" ;
  efterhandskonstruktion_nn_1 = mkN "efterhandskonstruktion" "efterhandskonstruktioner" ;
  efterhoest_nn_1 = mkN "efterhцst" ;
  efterkaenning_nn_1 = mkN "efterkдnning" ;
  efterklang_nn_1 = mkN "efterklang" "efterklanger" ;
  efterklok_av_1 = mkA "efterklok" ;
  efterkokning_nn_1 = mkN "efterkokning" ;
  efterkomma_vb_1 = mkV "efterkomma" "efterkom" "efterkommit" ;
  efterkommande_nn_1 = mkN "efterkommande" "efterkommanden" "efterkommande" "efterkommandena" ;
  efterkonstruktion_nn_1 = mkN "efterkonstruktion" "efterkonstruktioner" ;
  efterkontroll_nn_1 = mkN "efterkontroll" "efterkontroller" ;
  efterkrav_nn_1 = mkN "efterkrav" neutrum ;
  efterkrigstid_nn_1 = mkN "efterkrigstid" "efterkrigstider" ;
  efterlaata_vb_1 = mkV "efterlеta" "efterlдt" "efterlеtit" ;
  efterlaaten_av_1 = mkA "efterlеten" "efterlеtet" ;
  efterled_nn_1 = mkN "efterled" neutrum ;
  efterlevande_av_1 = mkA "efterlevande" ;
  efterleverska_nn_1 = mkN "efterleverska" ;
  efterlevnad_nn_1 = mkN "efterlevnad" "efterlevnader" ;
  efterliggande_av_1 = mkA "efterliggande" ;
  efterlysning_nn_1 = mkN "efterlysning" ;
  eftermaele_nn_1 = mkN "eftermдle" ;
  eftermiddag_nn_1 = mkN "eftermiddag" ;
  efternamn_nn_1 = mkN "efternamn" neutrum ;
  efterproevning_nn_1 = mkN "efterprцvning" ;
  efterraekning_nn_1 = mkN "efterrдkning" ;
  efterraett_nn_1 = mkN "efterrдtt" "efterrдtter" ;
  efterrationalisering_nn_1 = mkN "efterrationalisering" ;
  eftersaegare_nn_1 = mkN "eftersдgare" "eftersдgare" ;
  eftersaettsblad_nn_1 = mkN "eftersдttsblad" neutrum ;
  eftersats_nn_1 = mkN "eftersats" "eftersatser" ;
  eftersinnande_av_1 = mkA "eftersinnande" ;
  eftersits_nn_1 = mkN "eftersits" ;
  efterskott_nn_1 = mkN "efterskott" neutrum ;
  efterskrift_nn_1 = mkN "efterskrift" "efterskrifter" ;
  efterslaeng_nn_1 = mkN "efterslдng" ;
  efterslaentrare_nn_1 = mkN "efterslдntrare" "efterslдntrare" ;
  efterslag_nn_1 = mkN "efterslag" neutrum ;
  eftersoekt_av_1 = mkA "eftersцkt" "eftersцkt" ;
  eftersommar_nn_1 = mkN "eftersommar" "eftersommarn" "eftersommrar" "eftersommrarna" ;
  efterspaning_nn_1 = mkN "efterspaning" ;
  efterspel_nn_1 = mkN "efterspel" "efterspelet" "efterspel" "efterspelen" ;
  efterst_ab_1 = mkAdv "efterst" ;
  efterstaelld_av_1 = mkA "efterstдlld" "efterstдllt" ;
  efterstraevansvaerd_av_1 = mkA "efterstrдvansvдrd" "efterstrдvansvдrt" ;
  efterstygn_nn_1 = mkN "efterstygn" neutrum ;
  eftertaenksam_av_1 = mkA "eftertдnksam" "eftertдnksamt" "eftertдnksamma" "eftertдnksamma" "eftertдnksammare" "eftertдnksammast" "eftertдnksammaste" ;
  eftertaxering_nn_1 = mkN "eftertaxering" ;
  eftertextnot_nn_1 = mkN "eftertextnot" "eftertextnoter" ;
  eftertraedare_nn_1 = mkN "eftertrдdare" "eftertrдdare" ;
  eftertraktansvaerd_av_1 = mkA "eftertraktansvдrd" "eftertraktansvдrt" ;
  eftertrupp_nn_1 = mkN "eftertrupp" "eftertrupper" ;
  eftertryck_nn_1 = mkN "eftertryck" neutrum ;
  eftertrycklig_av_1 = mkA "eftertrycklig" ;
  eftertryckligen_ab_1 = mkAdv "eftertryckligen" ;
  efterundersoekning_nn_1 = mkN "efterundersцkning" ;
  efterutbildning_nn_1 = mkN "efterutbildning" ;
  efterverkning_nn_1 = mkN "efterverkning" ;
  eftervinter_nn_1 = mkN "eftervinter" ;
  eftervis_av_1 = mkA "eftervis" ;
  egal_av_1 = mkA "egal" ;
  egalitaer_av_1 = mkA "egalitдr" ;
  egalitet_nn_1 = mkN "egalitet" "egaliteter" ;
  egeisk_av_1 = mkA "egeisk" ;
  egen_av_1 = mkA "egen" "eget" ;
  egendom_nn_1 = mkN "egendom" ;
  egendomlig_av_1 = mkA "egendomlig" ;
  egendomlighet_nn_1 = mkN "egendomlighet" "egendomligheter" ;
  egendomsaffaer_nn_1 = mkN "egendomsaffдr" "egendomsaffдrer" ;
  egendomsbrott_nn_1 = mkN "egendomsbrott" neutrum ;
  egendomsfoersaeljning_nn_1 = mkN "egendomsfцrsдljning" ;
  egendomsloes_av_1 = mkA "egendomslцs" ;
  egenfrekvens_nn_1 = mkN "egenfrekvens" "egenfrekvenser" ;
  egenhaendig_av_1 = mkA "egenhдndig" ;
  egenhet_nn_1 = mkN "egenhet" "egenheter" ;
  egenkaer_av_1 = mkA "egenkдr" ;
  egenkaerlek_nn_1 = mkN "egenkдrlek" ;
  egenmaektig_av_1 = mkA "egenmдktig" ;
  egennamn_nn_1 = mkN "egennamn" neutrum ;
  egennytta_nn_1 = mkN "egennytta" ;
  egennyttig_av_1 = mkA "egennyttig" ;
  egenraadig_av_1 = mkA "egenrеdig" ;
  egenraettfaerdig_av_1 = mkA "egenrдttfдrdig" ;
  egensinnig_av_1 = mkA "egensinnig" ;
  egenskap_nn_1 = mkN "egenskap" "egenskaper" ;
  egenskapsgenitiv_nn_1 = mkN "egenskapsgenitiv" "egenskapsgenitiver" ;
  egenskapsord_nn_1 = mkN "egenskapsord" neutrum ;
  egentlig_av_1 = mkA "egentlig" ;
  egentligen_ab_1 = mkAdv "egentligen" ;
  egenvarm_av_1 = mkA "egenvarm" ;
  egg_nn_1 = mkN "egg" ;
  eggelse_nn_1 = mkN "eggelse" "eggelser" ;
  eggjaern_nn_1 = mkN "eggjдrn" neutrum ;
  eggvass_av_1 = mkA "eggvass" ;
  eggverktyg_nn_1 = mkN "eggverktyg" neutrum ;
  egnahem_nn_1 = mkN "egnahem" "egnahemmet" "egnahem" "egnahemmen" ;
  egocentricitet_nn_1 = mkN "egocentricitet" "egocentriciteter" ;
  egocentriker_nn_1 = mkN "egocentriker" "egocentrikern" "egocentriker" "egocentrikerna" ;
  egocentrisk_av_1 = mkA "egocentrisk" ;
  egoist_nn_1 = mkN "egoist" "egoister" ;
  egoistisk_av_1 = mkA "egoistisk" ;
  egotripp_nn_1 = mkN "egotripp" ;
  egypter_nn_1 = mkN "egypter" "egyptern" "egypter" "egypterna" ;
  egyptier_nn_1 = mkN "egyptier" "egyptiern" "egyptier" "egyptierna" ;
  egyptisk_av_1 = mkA "egyptisk" ;
  egyptiska_nn_2 = mkN "egyptiska" ;
  egyptolog_nn_1 = mkN "egyptolog" "egyptologer" ;
  eidetisk_av_1 = mkA "eidetisk" ;
  einsteinsk_av_1 = mkA "einsteinsk" ;
  ej_ab_1 = mkAdv "ej" ;
  ejakulat_nn_1 = mkN "ejakulat" neutrum ;
  ejakulation_nn_1 = mkN "ejakulation" "ejakulationer" ;
  ejder_nn_1 = mkN "ejder" ;
  ejderunge_nn_1 = mkN "ejderunge" utrum ;
  ejektor_nn_1 = mkN "ejektor" "ejektorer" ;
  ek_nn_1 = mkN "ek" ;
  ekbock_nn_1 = mkN "ekbock" ;
  eker_nn_1 = mkN "eker" ;
  ekipage_nn_1 = mkN "ekipage" "ekipaget" "ekipage" "ekipagen" ;
  ekipering_nn_1 = mkN "ekipering" ;
  ekiperingsaffaer_nn_1 = mkN "ekiperingsaffдr" "ekiperingsaffдrer" ;
  ekivok_av_1 = mkA "ekivok" ;
  eklaerering_nn_1 = mkN "eklдrering" ;
  eklampsi_nn_1 = mkN "eklampsi" "eklampsier" ;
  eklatant_av_1 = mkA "eklatant" "eklatant" ;
  eklatt_av_1 = mkA "eklatt" ;
  eklektiker_nn_1 = mkN "eklektiker" "eklektikern" "eklektiker" "eklektikerna" ;
  eklektisk_av_1 = mkA "eklektisk" ;
  eklips_nn_1 = mkN "eklips" "eklipser" ;
  eklog_nn_1 = mkN "eklog" "ekloger" ;
  eko_nn_1 = mkN "eko" "ekot" "ekon" "ekona" ;
  ekollon_nn_1 = mkN "ekollon" neutrum ;
  ekolod_nn_1 = mkN "ekolod" neutrum ;
  ekolog_nn_1 = mkN "ekolog" "ekologer" ;
  ekologisk_av_1 = mkA "ekologisk" ;
  ekonom_nn_1 = mkN "ekonom" "ekonomer" ;
  ekonomexamen_nn_1 = mkN "ekonomexamen" "ekonomexamen" "ekonomexamina" "ekonomexamina" ;
  ekonomi_nn_1 = mkN "ekonomi" "ekonomier" ;
  ekonomibitraede_nn_1 = mkN "ekonomibitrдde" ;
  ekonomibrev_nn_1 = mkN "ekonomibrev" neutrum ;
  ekonomibyggnad_nn_1 = mkN "ekonomibyggnad" "ekonomibyggnader" ;
  ekonomie_av_1 = mkA "ekonomie" ;
  ekonomifoerestaandare_nn_1 = mkN "ekonomifцrestеndare" "ekonomifцrestеndare" ;
  ekonomifoerpackning_nn_1 = mkN "ekonomifцrpackning" ;
  ekonomilaera_nn_1 = mkN "ekonomilдra" ;
  ekonomipaket_nn_1 = mkN "ekonomipaket" neutrum ;
  ekonomisk_av_1 = mkA "ekonomisk" ;
  ekoradio_nn_1 = mkN "ekoradio" "ekoradior" ;
  ekorrbaer_nn_1 = mkN "ekorrbдr" neutrum ;
  ekorrdjur_nn_1 = mkN "ekorrdjur" neutrum ;
  ekorre_nn_1 = mkN "ekorre" utrum ;
  ekorrliknande_av_1 = mkA "ekorrliknande" ;
  ekosystem_nn_1 = mkN "ekosystem" neutrum ;
  ekotyp_nn_1 = mkN "ekotyp" "ekotyper" ;
  ekoxe_nn_1 = mkN "ekoxe" utrum ;
  eksem_nn_1 = mkN "eksem" neutrum ;
  ekskog_nn_1 = mkN "ekskog" ;
  ekspinnare_nn_1 = mkN "ekspinnare" "ekspinnare" ;
  ekstock_nn_1 = mkN "ekstock" ;
  ektomi_nn_1 = mkN "ektomi" "ektomier" ;
  ekumenisk_av_1 = mkA "ekumenisk" ;
  ekvation_nn_1 = mkN "ekvation" "ekvationer" ;
  ekvatorial_av_1 = mkA "ekvatorial" ;
  ekvatorialbaelte_nn_1 = mkN "ekvatorialbдlte" ;
  ekvatorialguinean_nn_1 = mkN "ekvatorialguinean" "ekvatorialguineaner" ;
  ekvatorialguineansk_av_1 = mkA "ekvatorialguineansk" ;
  ekvatorialstroem_nn_1 = mkN "ekvatorialstrцm" "ekvatorialstrцmmen" "ekvatorialstrцmmar" "ekvatorialstrцmmarna" ;
  ekvatorialzon_nn_1 = mkN "ekvatorialzon" "ekvatorialzoner" ;
  ekvatoriell_av_1 = mkA "ekvatoriell" ;
  ekvatorsplan_nn_1 = mkN "ekvatorsplan" neutrum ;
  ekvecklare_nn_1 = mkN "ekvecklare" "ekvecklare" ;
  ekvidistant_av_1 = mkA "ekvidistant" "ekvidistant" ;
  ekvilibrist_nn_1 = mkN "ekvilibrist" "ekvilibrister" ;
  ekvilibristisk_av_1 = mkA "ekvilibristisk" ;
  ekvipotentiallinje_nn_1 = mkN "ekvipotentiallinje" "ekvipotentiallinjer" ;
  ekvivalent_av_1 = mkA "ekvivalent" "ekvivalent" ;
  ekvivalentvikt_nn_1 = mkN "ekvivalentvikt" "ekvivalentvikter" ;
  elaenda_av_1 = mkA "elдnda" ;
  elaende_nn_1 = mkN "elдnde" ;
  elaendig_av_1 = mkA "elдndig" ;
  elak_av_1 = mkA "elak" ;
  elakhet_nn_1 = mkN "elakhet" "elakheter" ;
  elaking_nn_1 = mkN "elaking" ;
  eland_nn_1 = mkN "eland" "elander" ;
  elasticitet_nn_1 = mkN "elasticitet" "elasticiteter" ;
  elasticitetsgraens_nn_1 = mkN "elasticitetsgrдns" "elasticitetsgrдnser" ;
  elastisk_av_1 = mkA "elastisk" ;
  elbil_nn_1 = mkN "elbil" ;
  elborste_nn_1 = mkN "elborste" utrum ;
  elchock_nn_1 = mkN "elchock" "elchocker" ;
  eld_nn_1 = mkN "eld" ;
  eldare_nn_1 = mkN "eldare" "eldare" ;
  eldavstaand_nn_1 = mkN "eldavstеnd" neutrum ;
  eldbegaengelse_nn_1 = mkN "eldbegдngelse" "eldbegдngelser" ;
  eldbrand_nn_1 = mkN "eldbrand" "eldbrдnder" ;
  elddon_nn_1 = mkN "elddon" neutrum ;
  elddop_nn_1 = mkN "elddop" neutrum ;
  eldfaengd_av_1 = mkA "eldfдngd" "eldfдngt" ;
  eldfarlig_av_1 = mkA "eldfarlig" ;
  eldfast_av_1 = mkA "eldfast" "eldfast" ;
  eldgaffel_nn_1 = mkN "eldgaffel" ;
  eldhaerd_nn_1 = mkN "eldhдrd" ;
  eldhaerdig_av_1 = mkA "eldhдrdig" ;
  eldhandvapen_nn_1 = mkN "eldhandvapen" "eldhandvapnet" "eldhandvapen" "eldhandvapnen" ;
  eldhastighet_nn_1 = mkN "eldhastighet" "eldhastigheter" ;
  eldhund_nn_1 = mkN "eldhund" ;
  eldhus_nn_1 = mkN "eldhus" neutrum ;
  eldig_av_1 = mkA "eldig" ;
  eldkanal_nn_1 = mkN "eldkanal" "eldkanaler" ;
  eldkastare_nn_1 = mkN "eldkastare" "eldkastare" ;
  eldkommando_nn_1 = mkN "eldkommando" "eldkommandot" "eldkommandon" "eldkommandona" ;
  eldledare_nn_1 = mkN "eldledare" "eldledare" ;
  eldlinje_nn_1 = mkN "eldlinje" "eldlinjer" ;
  eldningsolja_nn_1 = mkN "eldningsolja" ;
  eldoeverfall_nn_1 = mkN "eldцverfall" neutrum ;
  eldorado_nn_1 = mkN "eldorado" "eldoradot" "eldoradon" "eldoradona" ;
  eldprov_nn_1 = mkN "eldprov" neutrum ;
  eldriven_av_1 = mkA "eldriven" "eldrivet" ;
  eldroed_av_1 = mkA "eldrцd" ;
  eldroer_nn_1 = mkN "eldrцr" neutrum ;
  eldsaeker_av_1 = mkA "eldsдker" "eldsдkert" "eldsдkra" "eldsдkra" "eldsдkrare" "eldsдkrast" "eldsдkraste" ;
  eldsalamander_nn_1 = mkN "eldsalamander" ;
  eldsats_nn_1 = mkN "eldsats" "eldsatser" ;
  eldsignal_nn_1 = mkN "eldsignal" "eldsignaler" ;
  eldsignalering_nn_1 = mkN "eldsignalering" ;
  eldsjael_nn_1 = mkN "eldsjдl" ;
  eldsken_nn_1 = mkN "eldsken" neutrum ;
  eldskur_nn_1 = mkN "eldskur" ;
  eldslaeckare_nn_1 = mkN "eldslдckare" "eldslдckare" ;
  eldslaeckning_nn_1 = mkN "eldslдckning" ;
  eldslaendare_nn_1 = mkN "eldslдndare" "eldslдndare" ;
  eldsljus_nn_1 = mkN "eldsljus" neutrum ;
  eldslukare_nn_1 = mkN "eldslukare" "eldslukare" ;
  eldsmaerke_nn_1 = mkN "eldsmдrke" ;
  eldstaal_nn_1 = mkN "eldstеl" neutrum ;
  eldstad_nn_1 = mkN "eldstad" "eldstдder" ;
  eldstaellning_nn_1 = mkN "eldstдllning" ;
  eldstod_nn_1 = mkN "eldstod" "eldstoder" ;
  eldstorm_nn_1 = mkN "eldstorm" ;
  eldstrid_nn_1 = mkN "eldstrid" "eldstrider" ;
  eldsvaada_nn_1 = mkN "eldsvеda" ;
  eldsvaadeunge_nn_1 = mkN "eldsvеdeunge" utrum ;
  eldupphoer_nn_1 = mkN "eldupphцr" neutrum ;
  eldupphoerorder_nn_1 = mkN "eldupphцrorder" ;
  eldvapen_nn_1 = mkN "eldvapen" "eldvapnet" "eldvapen" "eldvapnen" ;
  elefant_nn_1 = mkN "elefant" "elefanter" ;
  elefantbete_nn_1 = mkN "elefantbete" utrum ;
  elefantinhopp_nn_1 = mkN "elefantinhopp" neutrum ;
  elefantnaebbmus_nn_1 = mkN "elefantnдbbmus" "elefantnдbbmusen" "elefantnдbbmцss" "elefantnдbbmцssen" ;
  elegant_av_1 = mkA "elegant" "elegant" ;
  elegi_nn_1 = mkN "elegi" "elegier" ;
  elegisk_av_1 = mkA "elegisk" ;
  elektor_nn_1 = mkN "elektor" "elektorer" ;
  elektricitet_nn_1 = mkN "elektricitet" "elektriciteter" ;
  elektricitetsmaengd_nn_1 = mkN "elektricitetsmдngd" "elektricitetsmдngder" ;
  elektricitetsverk_nn_1 = mkN "elektricitetsverk" neutrum ;
  elektriker_nn_1 = mkN "elektriker" "elektrikern" "elektriker" "elektrikerna" ;
  elektrisk_av_1 = mkA "elektrisk" ;
  elektrochock_nn_1 = mkN "elektrochock" "elektrochocker" ;
  elektrod_nn_1 = mkN "elektrod" "elektroder" ;
  elektroencefalografi_nn_1 = mkN "elektroencefalografi" "elektroencefalografier" ;
  elektroencefalogram_nn_1 = mkN "elektroencefalogram" "elektroencefalogrammet" "elektroencefalogram" "elektroencefalogrammen" ;
  elektrofilter_nn_1 = mkN "elektrofilter" neutrum ;
  elektrofor_nn_1 = mkN "elektrofor" "elektroforen" "elektroforer" "elektroforerna" ;
  elektroingenjoer_nn_1 = mkN "elektroingenjцr" "elektroingenjцrer" ;
  elektrokardiografi_nn_1 = mkN "elektrokardiografi" "elektrokardiografier" ;
  elektrokardiogram_nn_1 = mkN "elektrokardiogram" "elektrokardiogrammet" "elektrokardiogram" "elektrokardiogrammen" ;
  elektrolys_nn_1 = mkN "elektrolys" "elektrolyser" ;
  elektrolyt_nn_1 = mkN "elektrolyt" "elektrolyter" ;
  elektrolytisk_av_1 = mkA "elektrolytisk" ;
  elektromagnet_nn_1 = mkN "elektromagnet" "elektromagneter" ;
  elektromagnetisk_av_1 = mkA "elektromagnetisk" ;
  elektromekanisk_av_1 = mkA "elektromekanisk" ;
  elektrometer_nn_1 = mkN "elektrometer" ;
  elektromotor_nn_1 = mkN "elektromotor" "elektromotorer" ;
  elektromotorisk_av_1 = mkA "elektromotorisk" ;
  elektron_nn_1 = mkN "elektron" "elektroner" ;
  elektronblixt_nn_1 = mkN "elektronblixt" ;
  elektronegativitet_nn_1 = mkN "elektronegativitet" "elektronegativiteter" ;
  elektronisk_av_1 = mkA "elektronisk" ;
  elektronkamera_nn_1 = mkN "elektronkamera" ;
  elektronmikroskop_nn_1 = mkN "elektronmikroskop" neutrum ;
  elektronmikroskopbild_nn_1 = mkN "elektronmikroskopbild" "elektronmikroskopbilder" ;
  elektronmikroskopi_nn_1 = mkN "elektronmikroskopi" "elektronmikroskopier" ;
  elektronmoln_nn_1 = mkN "elektronmoln" neutrum ;
  elektronpar_nn_1 = mkN "elektronpar" neutrum ;
  elektronparbindning_nn_1 = mkN "elektronparbindning" ;
  elektronroer_nn_1 = mkN "elektronrцr" neutrum ;
  elektronroersdiod_nn_1 = mkN "elektronrцrsdiod" "elektronrцrsdioder" ;
  elektronskal_nn_1 = mkN "elektronskal" neutrum ;
  elektronstraale_nn_1 = mkN "elektronstrеle" utrum ;
  elektronugn_nn_1 = mkN "elektronugn" ;
  elektronvolt_nn_1 = mkN "elektronvolt" "elektronvolten" "elektronvolt" "elektronvolten" ;
  elektroskop_nn_1 = mkN "elektroskop" neutrum ;
  elektrostatisk_av_1 = mkA "elektrostatisk" ;
  elektrosvag_av_1 = mkA "elektrosvag" ;
  elektrotekniker_nn_1 = mkN "elektrotekniker" "elektroteknikern" "elektrotekniker" "elektroteknikerna" ;
  elektroteknisk_av_1 = mkA "elektroteknisk" ;
  elektrotyp_nn_1 = mkN "elektrotyp" "elektrotyper" ;
  element_nn_1 = mkN "element" neutrum ;
  elementa_nn_1 = mkN "elementa" "elementan" "elementa" "elementana" ;
  elementaer_av_1 = mkA "elementдr" ;
  elementarande_nn_1 = mkN "elementarande" utrum ;
  elementarbok_nn_1 = mkN "elementarbok" "elementarbцcker" ;
  elementarpartikel_nn_1 = mkN "elementarpartikel" ;
  elev_nn_1 = mkN "elev" "elever" ;
  elevation_nn_1 = mkN "elevation" "elevationer" ;
  elevator_nn_1 = mkN "elevator" "elevatorer" ;
  elevfartyg_nn_1 = mkN "elevfartyg" neutrum ;
  elevhem_nn_1 = mkN "elevhem" "elevhemmet" "elevhem" "elevhemmen" ;
  elevraad_nn_1 = mkN "elevrеd" neutrum ;
  elevunderlag_nn_1 = mkN "elevunderlag" neutrum ;
  elfenbenspalm_nn_1 = mkN "elfenbenspalm" "elfenbenspalmer" ;
  elfenbenstorn_nn_1 = mkN "elfenbenstorn" "elfenbenstornet" "elfenbenstornen" "elfenbenstornena" ;
  elgenerator_nn_1 = mkN "elgenerator" "elgeneratorer" ;
  elgitarr_nn_1 = mkN "elgitarr" "elgitarrer" ;
  elimination_nn_1 = mkN "elimination" "eliminationer" ;
  elision_nn_1 = mkN "elision" "elisioner" ;
  elit_nn_1 = mkN "elit" "eliter" ;
  elitfoerband_nn_1 = mkN "elitfцrband" neutrum ;
  elitidrott_nn_1 = mkN "elitidrott" "elitidrotter" ;
  elitidrottsman_nn_1 = mkN "elitidrottsman" "elitidrottsmannen" "elitidrottsmдn" "elitidrottsmдnnen" ;
  elitisk_av_1 = mkA "elitisk" ;
  elitistisk_av_1 = mkA "elitistisk" ;
  elitsoldat_nn_1 = mkN "elitsoldat" "elitsoldater" ;
  elitteori_nn_1 = mkN "elitteori" "elitteorier" ;
  elixir_nn_1 = mkN "elixir" neutrum ;
  eljest_ab_1 = mkAdv "eljest" ;
  elkoppling_nn_1 = mkN "elkoppling" ;
  elkraftsaggregat_nn_1 = mkN "elkraftsaggregat" neutrum ;
  ellande_ab_1 = mkAdv "ellande" ;
  elledning_nn_1 = mkN "elledning" ;
  ellips_nn_1 = mkN "ellips" "ellipser" ;
  ellipsoid_nn_1 = mkN "ellipsoid" "ellipsoider" ;
  elliptisk_av_1 = mkA "elliptisk" ;
  elljusspaar_nn_1 = mkN "elljusspеr" neutrum ;
  ellok_nn_1 = mkN "ellok" neutrum ;
  elmaetare_nn_1 = mkN "elmдtare" "elmдtare" ;
  elmotor_nn_1 = mkN "elmotor" "elmotorer" ;
  elmseld_nn_1 = mkN "elmseld" ;
  elnaet_nn_1 = mkN "elnдt" neutrum ;
  eloge_nn_1 = mkN "eloge" "eloger" ;
  elokvent_av_1 = mkA "elokvent" "elokvent" ;
  elongation_nn_1 = mkN "elongation" "elongationer" ;
  elorgel_nn_1 = mkN "elorgel" ;
  elsevir_nn_1 = mkN "elsevir" "elsevirer" ;
  elspis_nn_1 = mkN "elspis" ;
  elstroem_nn_1 = mkN "elstrцm" "elstrцmmen" "elstrцmmar" "elstrцmmarna" ;
  eluttag_nn_1 = mkN "eluttag" neutrum ;
  eluvial_av_1 = mkA "eluvial" ;
  elvadimensionell_av_1 = mkA "elvadimensionell" ;
  elvamannalag_nn_1 = mkN "elvamannalag" neutrum ;
  elverk_nn_1 = mkN "elverk" neutrum ;
  elyseisk_av_1 = mkA "elyseisk" ;
  elzevier_nn_1 = mkN "elzevier" "elzevierer" ;
  emalj_nn_1 = mkN "emalj" "emaljer" ;
  emaljfaerg_nn_1 = mkN "emaljfдrg" "emaljfдrger" ;
  emaljfyllning_nn_1 = mkN "emaljfyllning" ;
  emaljinlaeggning_nn_1 = mkN "emaljinlдggning" ;
  emaljoega_nn_1 = mkN "emaljцga" "emaljцgat" "emaljцgon" "emaljцgonen" ;
  emaljoer_nn_1 = mkN "emaljцr" "emaljцrer" ;
  emaljplomb_nn_1 = mkN "emaljplomb" "emaljplomber" ;
  emanation_nn_1 = mkN "emanation" "emanationer" ;
  emballage_nn_1 = mkN "emballage" "emballaget" "emballage" "emballagen" ;
  emblem_nn_1 = mkN "emblem" neutrum ;
  emboli_nn_1 = mkN "emboli" "embolier" ;
  embryo_nn_1 = mkN "embryo" "embryot" "embryon" "embryona" ;
  embryolog_nn_1 = mkN "embryolog" "embryologer" ;
  embryonal_av_1 = mkA "embryonal" ;
  embryonisk_av_1 = mkA "embryonisk" ;
  embryosaeck_nn_1 = mkN "embryosдck" ;
  emellan_ab_1 = mkAdv "emellan" ;
  emellanaat_ab_1 = mkAdv "emellanеt" ;
  emellertid_ab_1 = mkAdv "emellertid" ;
  emendation_nn_1 = mkN "emendation" "emendationer" ;
  emeritus_nn_1 = mkN "emeritus" "emeritus" "emeriti" "emeritina" ;
  emfatisk_av_1 = mkA "emfatisk" ;
  emfysem_nn_1 = mkN "emfysem" neutrum ;
  emigrant_nn_1 = mkN "emigrant" "emigranter" ;
  eminens_nn_1 = mkN "eminens" "eminenser" ;
  eminent_av_1 = mkA "eminent" "eminent" ;
  emir_nn_1 = mkN "emir" "emirer" ;
  emissarie_nn_1 = mkN "emissarie" "emissarier" ;
  emission_nn_1 = mkN "emission" "emissioner" ;
  emitter_nn_1 = mkN "emitter" ;
  emot_ab_1 = mkAdv "emot" ;
  emotion_nn_1 = mkN "emotion" "emotioner" ;
  emotionell_av_1 = mkA "emotionell" ;
  emotiv_av_1 = mkA "emotiv" ;
  emotta_vb_1 = mkV "emotta" "emottar" "emotta" "emottog" "emottagit" "emottagen" ;
  empirestil_nn_1 = mkN "empirestil" ;
  empiriker_nn_1 = mkN "empiriker" "empirikern" "empiriker" "empirikerna" ;
  empirisk_av_1 = mkA "empirisk" ;
  empirist_nn_1 = mkN "empirist" "empirister" ;
  empyem_nn_1 = mkN "empyem" neutrum ;
  emu_nn_1 = mkN "emu" "emun" "emuer" "emuerna" ;
  emulsion_nn_1 = mkN "emulsion" "emulsioner" ;
  emulsionsfaerg_nn_1 = mkN "emulsionsfдrg" "emulsionsfдrger" ;
  emulsionsspraengaemne_nn_1 = mkN "emulsionssprдngдmne" ;
  en_ab_1 = mkAdv "en" ;
  en_nn_1 = mkN "en" "enen" "enar" "enarna" ;
  enaeggstvilling_nn_1 = mkN "enдggstvilling" ;
  enahanda_av_1 = mkA "enahanda" ;
  enaktare_nn_1 = mkN "enaktare" "enaktare" ;
  enaraadande_av_1 = mkA "enarеdande" ;
  enarmig_av_1 = mkA "enarmig" ;
  enastaaende_av_1 = mkA "enastеende" ;
  enaxlig_av_1 = mkA "enaxlig" ;
  enbaeddsrum_nn_1 = mkN "enbдddsrum" "enbдddsrummet" "enbдddsrum" "enbдddsrummen" ;
  enbaer_nn_1 = mkN "enbдr" neutrum ;
  enbart_ab_1 = mkAdv "enbart" ;
  enbasisk_av_1 = mkA "enbasisk" ;
  enbent_av_1 = mkA "enbent" "enbent" ;
  enbet_nn_1 = mkN "enbet" neutrum ;
  enbuske_nn_1 = mkN "enbuske" utrum ;
  enbyggare_nn_1 = mkN "enbyggare" "enbyggare" ;
  encefalit_nn_1 = mkN "encefalit" "encefaliter" ;
  encefalografi_nn_1 = mkN "encefalografi" "encefalografier" ;
  encellig_av_1 = mkA "encellig" ;
  encyklopedi_nn_1 = mkN "encyklopedi" "encyklopedier" ;
  encyklopedisk_av_1 = mkA "encyklopedisk" ;
  endast_ab_1 = mkAdv "endast" ;
  endels_ab_1 = mkAdv "endels" ;
  endemi_nn_1 = mkN "endemi" "endemier" ;
  endemisk_av_1 = mkA "endemisk" ;
  endimensionell_av_1 = mkA "endimensionell" ;
  endiv_nn_1 = mkN "endiv" "endiver" ;
  endogen_av_1 = mkA "endogen" ;
  endokrin_av_1 = mkA "endokrin" ;
  endokrinolog_nn_1 = mkN "endokrinolog" "endokrinologer" ;
  endorfin_nn_1 = mkN "endorfin" "endorfinet" "endorfiner" "endorfinerna" ;
  endossat_nn_1 = mkN "endossat" "endossater" ;
  endossement_nn_1 = mkN "endossement" "endossementet" "endossementen" "endossementena" ;
  endossent_nn_1 = mkN "endossent" "endossenter" ;
  endotermisk_av_1 = mkA "endotermisk" ;
  energi_nn_1 = mkN "energi" "energier" ;
  energialternativ_nn_1 = mkN "energialternativ" neutrum ;
  energibehov_nn_1 = mkN "energibehov" neutrum ;
  energifoerlust_nn_1 = mkN "energifцrlust" "energifцrluster" ;
  energiform_nn_1 = mkN "energiform" "energiformer" ;
  energiinnehaall_nn_1 = mkN "energiinnehеll" neutrum ;
  energikoncentration_nn_1 = mkN "energikoncentration" "energikoncentrationer" ;
  energimaengd_nn_1 = mkN "energimдngd" "energimдngder" ;
  energimarknad_nn_1 = mkN "energimarknad" "energimarknader" ;
  energiomsaettning_nn_1 = mkN "energiomsдttning" ;
  energiomvandling_nn_1 = mkN "energiomvandling" ;
  energiomvandlingscentrum_nn_1 = mkN "energiomvandlingscentrum" neutrum ;
  energirik_av_1 = mkA "energirik" ;
  energisk_av_1 = mkA "energisk" ;
  energiskatt_nn_1 = mkN "energiskatt" "energiskatter" ;
  energiskog_nn_1 = mkN "energiskog" ;
  energiteori_nn_1 = mkN "energiteori" "energiteorier" ;
  energitillstaand_nn_1 = mkN "energitillstеnd" neutrum ;
  energiupptagande_av_1 = mkA "energiupptagande" ;
  energiutstraalning_nn_1 = mkN "energiutstrеlning" ;
  energiverk_nn_1 = mkN "energiverk" neutrum ;
  energivinst_nn_1 = mkN "energivinst" "energivinster" ;
  enfaldeligen_ab_1 = mkAdv "enfaldeligen" ;
  enfaldig_av_1 = mkA "enfaldig" ;
  enfamiljshus_nn_1 = mkN "enfamiljshus" neutrum ;
  enfas_av_1 = mkA "enfas" ;
  enfasig_av_1 = mkA "enfasig" ;
  enfoedd_av_1 = mkA "enfцdd" ;
  enfoeraeldersfamilj_nn_1 = mkN "enfцrдldersfamilj" "enfцrдldersfamiljer" ;
  enformig_av_1 = mkA "enformig" ;
  engaang_ab_1 = mkAdv "engеng" ;
  engaangsdos_nn_1 = mkN "engеngsdos" "engеngsdoser" ;
  engaangshandduk_nn_1 = mkN "engеngshandduk" ;
  engaangsnaesduk_nn_1 = mkN "engеngsnдsduk" ;
  engaangsservett_nn_1 = mkN "engеngsservett" "engеngsservetter" ;
  engaangsskatt_nn_1 = mkN "engеngsskatt" "engеngsskatter" ;
  engaangstallrik_nn_1 = mkN "engеngstallrik" ;
  engaangsvaerde_nn_1 = mkN "engеngsvдrde" ;
  engagemang_nn_1 = mkN "engagemang" neutrum ;
  engelsk_av_1 = mkA "engelsk" ;
  engelska_nn_2 = mkN "engelska" ;
  engelsman_nn_1 = mkN "engelsman" "engelsmannen" "engelsmдn" "engelsmдnnen" ;
  englergrad_nn_1 = mkN "englergrad" "englergrader" ;
  engram_nn_1 = mkN "engram" "engrammet" "engram" "engrammen" ;
  engrossist_nn_1 = mkN "engrossist" "engrossister" ;
  enhaellig_av_1 = mkA "enhдllig" ;
  enharmonisk_av_1 = mkA "enharmonisk" ;
  enhet_nn_1 = mkN "enhet" "enheter" ;
  enhetlig_av_1 = mkA "enhetlig" ;
  enhetscirkel_nn_1 = mkN "enhetscirkel" ;
  enhetsflygplan_nn_1 = mkN "enhetsflygplan" neutrum ;
  enhetsfront_nn_1 = mkN "enhetsfront" "enhetsfronter" ;
  enhetsladdning_nn_1 = mkN "enhetsladdning" ;
  enhetslast_nn_1 = mkN "enhetslast" "enhetslaster" ;
  enhetsmaatt_nn_1 = mkN "enhetsmеtt" neutrum ;
  enhetsparti_nn_1 = mkN "enhetsparti" "enhetspartit" "enhetspartier" "enhetspartierna" ;
  enhetspatron_nn_1 = mkN "enhetspatron" "enhetspatroner" ;
  enhetsporto_nn_1 = mkN "enhetsporto" "enhetsportot" "enhetsporton" "enhetsportona" ;
  enhetspris_nn_1 = mkN "enhetspris" neutrum ;
  enhetsvektor_nn_1 = mkN "enhetsvektor" "enhetsvektorer" ;
  enhjaertbladig_av_1 = mkA "enhjдrtbladig" ;
  enhoerning_nn_1 = mkN "enhцrning" ;
  enig_av_1 = mkA "enig" ;
  enighet_nn_1 = mkN "enighet" "enigheter" ;
  enigmatisk_av_1 = mkA "enigmatisk" ;
  enjambemang_nn_1 = mkN "enjambemang" neutrum ;
  enkaet_nn_1 = mkN "enkдt" "enkдter" ;
  enkammarsystem_nn_1 = mkN "enkammarsystem" neutrum ;
  enkannerligen_ab_1 = mkAdv "enkannerligen" ;
  enkel_av_1 = mkA "enkel" "enkelt" "enkla" "enkla" "enklare" "enklast" "enklaste" ;
  enkelbeckasin_nn_1 = mkN "enkelbeckasin" "enkelbeckasiner" ;
  enkelbiff_nn_1 = mkN "enkelbiff" ;
  enkelbiljett_nn_1 = mkN "enkelbiljett" "enkelbiljetter" ;
  enkelbredd_nn_1 = mkN "enkelbredd" "enkelbredder" ;
  enkelhet_nn_1 = mkN "enkelhet" "enkelheter" ;
  enkelkikare_nn_1 = mkN "enkelkikare" "enkelkikare" ;
  enkelknaeppt_av_1 = mkA "enkelknдppt" "enkelknдppt" ;
  enkelkvartett_nn_1 = mkN "enkelkvartett" "enkelkvartetter" ;
  enkelladdare_nn_1 = mkN "enkelladdare" "enkelladdare" ;
  enkelnervig_av_1 = mkA "enkelnervig" ;
  enkelpipig_av_1 = mkA "enkelpipig" ;
  enkelrad_nn_1 = mkN "enkelrad" "enkelrader" ;
  enkelrum_nn_1 = mkN "enkelrum" "enkelrummet" "enkelrum" "enkelrummen" ;
  enkelsaeng_nn_1 = mkN "enkelsдng" ;
  enkelskriva_vb_1 = mkV "enkelskriva" "enkelskrev" "enkelskrivit" ;
  enkelspaarig_av_1 = mkA "enkelspеrig" ;
  enkelspel_nn_1 = mkN "enkelspel" "enkelspelet" "enkelspel" "enkelspelen" ;
  enkeltimme_nn_1 = mkN "enkeltimme" utrum ;
  enklav_nn_1 = mkN "enklav" "enklaver" ;
  enklitisk_av_1 = mkA "enklitisk" ;
  enkom_ab_1 = mkAdv "enkom" ;
  enmanslivbaat_nn_1 = mkN "enmanslivbеt" ;
  enmansshow_nn_1 = mkN "enmansshow" "enmansshower" ;
  enmansvalkrets_nn_1 = mkN "enmansvalkrets" ;
  enoegd_av_1 = mkA "enцgd" "enцgt" ;
  enorm_av_1 = mkA "enorm" ;
  enpartistat_nn_1 = mkN "enpartistat" "enpartistater" ;
  enplanshus_nn_1 = mkN "enplanshus" neutrum ;
  enpolig_av_1 = mkA "enpolig" ;
  enpucklig_av_1 = mkA "enpucklig" ;
  enraadig_av_1 = mkA "enrеdig" ;
  enris_nn_1 = mkN "enris" neutrum ;
  enrisroekt_av_1 = mkA "enrisrцkt" "enrisrцkt" ;
  ens_ab_1 = mkAdv "ens" ;
  ens_av_1 = mkA "ens" ;
  ensak_nn_1 = mkN "ensak" "ensaker" ;
  ensam_av_1 = mkA "ensam" "ensamt" "ensamma" "ensamma" "ensammare" "ensammast" "ensammaste" ;
  ensamfoeraelder_nn_1 = mkN "ensamfцrдlder" ;
  ensamgaard_nn_1 = mkN "ensamgеrd" ;
  ensamhet_nn_1 = mkN "ensamhet" "ensamheter" ;
  ensamraett_nn_1 = mkN "ensamrдtt" "ensamrдtter" ;
  ensamseglare_nn_1 = mkN "ensamseglare" "ensamseglare" ;
  ensamstaaende_av_1 = mkA "ensamstеende" ;
  ense_av_1 = mkA "ense" ;
  ensemble_nn_1 = mkN "ensemble" "ensembler" ;
  ensfyr_nn_1 = mkN "ensfyr" ;
  ensidig_av_1 = mkA "ensidig" ;
  ensittare_nn_1 = mkN "ensittare" "ensittare" ;
  enskild_av_1 = mkA "enskild" "enskilt" ;
  enskildhet_nn_1 = mkN "enskildhet" "enskildheter" ;
  enslig_av_1 = mkA "enslig" ;
  ensling_nn_1 = mkN "ensling" ;
  enslinje_nn_1 = mkN "enslinje" "enslinjer" ;
  enspraakig_av_1 = mkA "ensprеkig" ;
  enstaemmig_av_1 = mkA "enstдmmig" ;
  enstaendig_av_1 = mkA "enstдndig" ;
  enstaka_av_1 = mkA "enstaka" ;
  enstavig_av_1 = mkA "enstavig" ;
  enstensmur_nn_1 = mkN "enstensmur" ;
  enstjaernig_av_1 = mkA "enstjдrnig" ;
  enstoerig_av_1 = mkA "enstцrig" ;
  enstoering_nn_1 = mkN "enstцring" ;
  ental_nn_1 = mkN "ental" "entalet" "entalen" "entalena" ;
  entente_nn_1 = mkN "entente" "ententer" ;
  entertainer_nn_1 = mkN "entertainer" "entertainern" "entertainer" "entertainerna" ;
  entitet_nn_1 = mkN "entitet" "entiteter" ;
  entomolog_nn_1 = mkN "entomolog" "entomologer" ;
  entomologisk_av_1 = mkA "entomologisk" ;
  entonig_av_1 = mkA "entonig" ;
  entraegen_av_1 = mkA "entrдgen" "entrдget" ;
  entre_nn_1 = mkN "entrй" "entrйer" ;
  entrecote_nn_1 = mkN "entrecote" "entrecoter" ;
  entredoerr_nn_1 = mkN "entrйdцrr" ;
  entreprenad_nn_1 = mkN "entreprenad" "entreprenader" ;
  entreprenoer_nn_1 = mkN "entreprenцr" "entreprenцrer" ;
  entresol_nn_1 = mkN "entresol" "entresoler" ;
  entusiast_nn_1 = mkN "entusiast" "entusiaster" ;
  entusiastisk_av_1 = mkA "entusiastisk" ;
  entydig_av_1 = mkA "entydig" ;
  entydighet_nn_1 = mkN "entydighet" "entydigheter" ;
  entypsbaat_nn_1 = mkN "entypsbеt" ;
  enumeration_nn_1 = mkN "enumeration" "enumerationer" ;
  envaaldshaerskare_nn_1 = mkN "envеldshдrskare" "envеldshдrskare" ;
  envaaningshus_nn_1 = mkN "envеningshus" neutrum ;
  envaegskommunikation_nn_1 = mkN "envдgskommunikation" "envдgskommunikationer" ;
  envaeldig_av_1 = mkA "envдldig" ;
  envaerd_av_1 = mkA "envдrd" "envдrt" ;
  enveten_av_1 = mkA "enveten" "envetet" ;
  envig_nn_1 = mkN "envig" ;
  environg_nn_1 = mkN "environg" "environger" ;
  envis_av_1 = mkA "envis" ;
  envoye_nn_1 = mkN "envoyй" "envoyйer" ;
  enzym_nn_1 = mkN "enzym" neutrum ;
  enzymsystem_nn_1 = mkN "enzymsystem" neutrum ;
  enzymtvaettmedel_nn_1 = mkN "enzymtvдttmedel" neutrum ;
  eoler_nn_1 = mkN "eoler" "eolern" "eoler" "eolerna" ;
  eolisk_av_1 = mkA "eolisk" ;
  eon_nn_1 = mkN "eon" "eoner" ;
  eosin_nn_1 = mkN "eosin" "eosiner" ;
  epaalett_nn_1 = mkN "epеlett" "epеletter" ;
  epatraktor_nn_1 = mkN "epatraktor" "epatraktorer" ;
  epicentrum_nn_1 = mkN "epicentrum" neutrum ;
  epidemi_nn_1 = mkN "epidemi" "epidemier" ;
  epidemisk_av_1 = mkA "epidemisk" ;
  epiduralblockad_nn_1 = mkN "epiduralblockad" "epiduralblockader" ;
  epifys_nn_1 = mkN "epifys" "epifyser" ;
  epifyt_nn_1 = mkN "epifyt" "epifyter" ;
  epigon_nn_1 = mkN "epigon" "epigoner" ;
  epigram_nn_1 = mkN "epigram" "epigrammet" "epigram" "epigrammen" ;
  epigrammatisk_av_1 = mkA "epigrammatisk" ;
  epiker_nn_1 = mkN "epiker" "epikern" "epiker" "epikerna" ;
  epikure_nn_1 = mkN "epikurй" "epikurйer" ;
  epikureisk_av_1 = mkA "epikureisk" ;
  epilepsi_nn_1 = mkN "epilepsi" "epilepsier" ;
  epileptiker_nn_1 = mkN "epileptiker" "epileptikern" "epileptiker" "epileptikerna" ;
  epilog_nn_1 = mkN "epilog" "epiloger" ;
  episk_av_1 = mkA "episk" ;
  episkop_nn_1 = mkN "episkop" neutrum ;
  episkopal_av_1 = mkA "episkopal" ;
  episkopat_nn_1 = mkN "episkopat" neutrum ;
  episod_nn_1 = mkN "episod" "episoder" ;
  episodisk_av_1 = mkA "episodisk" ;
  epistel_nn_1 = mkN "epistel" ;
  epistolaer_av_1 = mkA "epistolдr" ;
  epistyl_nn_1 = mkN "epistyl" "epistyler" ;
  epitaf_nn_1 = mkN "epitaf" "epitafet" "epitafer" "epitaferna" ;
  epitafium_nn_1 = mkN "epitafium" "epitafiet" "epitafier" "epitafierna" ;
  epitel_nn_1 = mkN "epitel" "epitelet" "epitel" "epitelen" ;
  epitelcell_nn_1 = mkN "epitelcell" "epitelceller" ;
  epitet_nn_1 = mkN "epitet" neutrum ;
  epizoisk_av_1 = mkA "epizoisk" ;
  epizooti_nn_1 = mkN "epizooti" "epizootier" ;
  epok_nn_1 = mkN "epok" "epoker" ;
  epokgoerande_av_1 = mkA "epokgцrande" ;
  epos_nn_1 = mkN "epos" neutrum ;
  erbarmlig_av_1 = mkA "erbarmlig" ;
  erbjuda_vb_1 = mkV "erbjuda" "erbjцd" "erbjudit" ;
  erbjudande_nn_1 = mkN "erbjudande" ;
  erektion_nn_1 = mkN "erektion" "erektioner" ;
  eremit_nn_1 = mkN "eremit" "eremiter" ;
  eremitage_nn_1 = mkN "eremitage" "eremitaget" "eremitage" "eremitagen" ;
  eremitisk_av_1 = mkA "eremitisk" ;
  erfaren_av_1 = mkA "erfaren" "erfaret" ;
  erfarenhet_nn_1 = mkN "erfarenhet" "erfarenheter" ;
  erfarenhetsmaessig_av_1 = mkA "erfarenhetsmдssig" ;
  erforderlig_av_1 = mkA "erforderlig" ;
  ergo_ab_1 = mkAdv "ergo" ;
  ergometer_nn_1 = mkN "ergometer" ;
  ergonom_nn_1 = mkN "ergonom" "ergonomer" ;
  ergonometrisk_av_1 = mkA "ergonometrisk" ;
  ergonomisk_av_1 = mkA "ergonomisk" ;
  erhaalla_vb_1 = mkV "erhеlla" "erhцll" "erhеllit" ;
  erinnye_nn_1 = mkN "erinnye" "erinnyer" ;
  erinran_nn_1 = mkN "erinran" "erinran" "erinringar" "erinringarna" ;
  erinring_nn_1 = mkN "erinring" ;
  erkaend_av_1 = mkA "erkдnd" ;
  erkaennande_nn_1 = mkN "erkдnnande" ;
  erkaennsam_av_1 = mkA "erkдnnsam" "erkдnnsamt" "erkдnnsamma" "erkдnnsamma" "erkдnnsammare" "erkдnnsammast" "erkдnnsammaste" ;
  eroevrare_nn_1 = mkN "erцvrare" "erцvrare" ;
  eroevring_nn_1 = mkN "erцvring" ;
  erogen_av_1 = mkA "erogen" ;
  erosion_nn_1 = mkN "erosion" "erosioner" ;
  erotiker_nn_1 = mkN "erotiker" "erotikern" "erotiker" "erotikerna" ;
  erotisk_av_1 = mkA "erotisk" ;
  erotogen_av_1 = mkA "erotogen" ;
  erotoman_av_1 = mkA "erotoman" ;
  erotoman_nn_1 = mkN "erotoman" "erotomaner" ;
  errata_nn_1 = mkN "errata" "erratan" "errata" "erratana" ;
  erratisk_av_1 = mkA "erratisk" ;
  ersaettare_nn_1 = mkN "ersдttare" "ersдttare" ;
  ersaettlig_av_1 = mkA "ersдttlig" ;
  ersaettning_nn_1 = mkN "ersдttning" ;
  eruption_nn_1 = mkN "eruption" "eruptioner" ;
  eruptiv_av_1 = mkA "eruptiv" ;
  eruptivbergart_nn_1 = mkN "eruptivbergart" "eruptivbergarter" ;
  escudo_nn_1 = mkN "escudo" "escudon" "escudos" "escudosen" ;
  eselhuvud_nn_1 = mkN "eselhuvud" "eselhuvudet" "eselhuvuden" "eselhuvudena" ;
  eskader_nn_1 = mkN "eskader" ;
  eskapad_nn_1 = mkN "eskapad" "eskapader" ;
  eskarp_nn_1 = mkN "eskarp" "eskarper" ;
  eskatologisk_av_1 = mkA "eskatologisk" ;
  eskimaa_nn_1 = mkN "eskimе" "eskimеer" ;
  eskimaahund_nn_1 = mkN "eskimеhund" ;
  eskort_nn_1 = mkN "eskort" "eskorter" ;
  eskulap_nn_1 = mkN "eskulap" "eskulaper" ;
  esomoftast_ab_1 = mkAdv "esomoftast" ;
  esoterisk_av_1 = mkA "esoterisk" ;
  espadrill_nn_1 = mkN "espadrill" "espadriller" ;
  espagnolett_nn_1 = mkN "espagnolett" "espagnoletter" ;
  esperantist_nn_1 = mkN "esperantist" "esperantister" ;
  esplanad_nn_1 = mkN "esplanad" "esplanader" ;
  espri_nn_2 = mkN "espri" "esprier" ;
  ess_nn_1 = mkN "ess" neutrum ;
  essae_nn_1 = mkN "essд" "essдn" "essдer" "essдerna" ;
  essaefraaga_nn_1 = mkN "essдfrеga" ;
  essaeist_nn_1 = mkN "essдist" "essдister" ;
  essaeistisk_av_1 = mkA "essдistisk" ;
  essaesamling_nn_1 = mkN "essдsamling" ;
  essaeuppgift_nn_1 = mkN "essдuppgift" "essдuppgifter" ;
  essay_nn_1 = mkN "essay" "essayer" ;
  essayist_nn_1 = mkN "essayist" "essayister" ;
  essayistik_nn_1 = mkN "essayistik" "essayistiker" ;
  essayistisk_av_1 = mkA "essayistisk" ;
  essaysamling_nn_1 = mkN "essaysamling" ;
  essens_nn_1 = mkN "essens" "essenser" ;
  essentiell_av_1 = mkA "essentiell" ;
  est_nn_1 = mkN "est" "ester" ;
  ester_nn_1 = mkN "ester" ;
  esterplast_nn_1 = mkN "esterplast" "esterplaster" ;
  estet_nn_1 = mkN "estet" "esteter" ;
  estetiker_nn_1 = mkN "estetiker" "estetikern" "estetiker" "estetikerna" ;
  estetisk_av_1 = mkA "estetisk" ;
  estlaendare_nn_1 = mkN "estlдndare" "estlдndare" ;
  estlaendsk_av_1 = mkA "estlдndsk" ;
  estlaendska_nn_1 = mkN "estlдndska" ;
  estnisk_av_1 = mkA "estnisk" ;
  estniska_nn_2 = mkN "estniska" ;
  estrad_nn_1 = mkN "estrad" "estrader" ;
  estradartist_nn_1 = mkN "estradartist" "estradartister" ;
  estraddebatt_nn_1 = mkN "estraddebatt" "estraddebatter" ;
  estradoer_nn_1 = mkN "estradцr" "estradцrer" ;
  estradsamtal_nn_1 = mkN "estradsamtal" "estradsamtalet" "estradsamtalen" "estradsamtalena" ;
  etablissemang_nn_1 = mkN "etablissemang" neutrum ;
  etagaer_nn_1 = mkN "etagдr" "etagдrer" ;
  etage_nn_1 = mkN "etage" "etager" ;
  etagevaaning_nn_1 = mkN "etagevеning" ;
  etalong_nn_1 = mkN "etalong" "etalonger" ;
  etan_nn_1 = mkN "etan" "etaner" ;
  etapp_nn_1 = mkN "etapp" "etapper" ;
  etapplinje_nn_1 = mkN "etapplinje" "etapplinjer" ;
  etappvis_ab_1 = mkAdv "etappvis" ;
  etcetera_ab_1 = mkAdv "etcetera" ;
  eter_nn_1 = mkN "eter" ;
  eterisering_nn_1 = mkN "eterisering" ;
  eterisk_av_1 = mkA "eterisk" ;
  etermedium_nn_1 = mkN "etermedium" "etermediet" "etermedier" "etermedierna" ;
  eternell_nn_1 = mkN "eternell" "eterneller" ;
  etiker_nn_1 = mkN "etiker" "etikern" "etiker" "etikerna" ;
  etikett_nn_1 = mkN "etikett" "etiketter" ;
  etiologisk_av_1 = mkA "etiologisk" ;
  etiop_nn_1 = mkN "etiop" "etioper" ;
  etiopier_nn_1 = mkN "etiopier" "etiopiern" "etiopier" "etiopierna" ;
  etiopisk_av_1 = mkA "etiopisk" ;
  etiopiska_nn_2 = mkN "etiopiska" ;
  etisk_av_1 = mkA "etisk" ;
  etnisk_av_1 = mkA "etnisk" ;
  etnocentrisk_av_1 = mkA "etnocentrisk" ;
  etnograf_nn_1 = mkN "etnograf" "etnografer" ;
  etnografisk_av_1 = mkA "etnografisk" ;
  etnolog_nn_1 = mkN "etnolog" "etnologer" ;
  etnologisk_av_1 = mkA "etnologisk" ;
  etolog_nn_1 = mkN "etolog" "etologer" ;
  etologisk_av_1 = mkA "etologisk" ;
  etrusk_nn_1 = mkN "etrusk" "etrusker" ;
  etrusker_nn_1 = mkN "etrusker" "etruskern" "etrusker" "etruskerna" ;
  etruskisk_av_1 = mkA "etruskisk" ;
  etruskiska_nn_2 = mkN "etruskiska" ;
  etsmedel_nn_1 = mkN "etsmedel" neutrum ;
  etsning_nn_1 = mkN "etsning" ;
  ettaarig_av_1 = mkA "ettеrig" ;
  ettaaring_nn_1 = mkN "ettеring" ;
  ettoering_nn_1 = mkN "ettцring" ;
  ettrig_av_1 = mkA "ettrig" ;
  ettstruken_av_1 = mkA "ettstruken" "ettstruket" ;
  etui_nn_1 = mkN "etui" "etuiet" "etuier" "etuierna" ;
  etyd_nn_1 = mkN "etyd" "etyder" ;
  etymolog_nn_1 = mkN "etymolog" "etymologer" ;
  etymologi_nn_1 = mkN "etymologi" "etymologier" ;
  etymologisk_av_1 = mkA "etymologisk" ;
  eufemism_nn_1 = mkN "eufemism" "eufemismer" ;
  eufoni_nn_1 = mkN "eufoni" "eufonier" ;
  eufori_nn_1 = mkN "eufori" "euforier" ;
  euforisk_av_1 = mkA "euforisk" ;
  euklidisk_av_1 = mkA "euklidisk" ;
  eumenid_nn_1 = mkN "eumenid" "eumenider" ;
  eunuck_nn_1 = mkN "eunuck" "eunucker" ;
  eurasier_nn_1 = mkN "eurasier" "eurasiern" "eurasier" "eurasierna" ;
  eurasisk_av_1 = mkA "eurasisk" ;
  euro_nn_1 = mkN "euro" "euron" "euro" "eurona" ;
  eurodollar_nn_1 = mkN "eurodollar" "eurodollarn" "eurodollar" "eurodollarna" ;
  europamaestare_nn_1 = mkN "europamдstare" "europamдstare" ;
  europamaesterskap_nn_1 = mkN "europamдsterskap" "europamдsterskapet" "europamдsterskapen" "europamдsterskapena" ;
  europavaeg_nn_1 = mkN "europavдg" ;
  europe_nn_1 = mkN "europй" "europйer" ;
  europeisk_av_1 = mkA "europeisk" ;
  europeiska_nn_1 = mkN "europeiska" ;
  europid_nn_1 = mkN "europid" "europider" ;
  eurytmi_nn_1 = mkN "eurytmi" "eurytmier" ;
  eutrof_av_1 = mkA "eutrof" ;
  evaerdlig_av_1 = mkA "evдrdlig" ;
  evakostym_nn_1 = mkN "evakostym" "evakostymer" ;
  evakuering_nn_1 = mkN "evakuering" ;
  evangeliebok_nn_1 = mkN "evangeliebok" "evangeliebцcker" ;
  evangelisk_av_1 = mkA "evangelisk" ;
  evangelist_nn_1 = mkN "evangelist" "evangelister" ;
  evangelium_nn_1 = mkN "evangelium" "evangeliet" "evangelier" "evangelierna" ;
  evar_ab_1 = mkAdv "evar" ;
  evart_ab_1 = mkAdv "evart" ;
  evenemang_nn_1 = mkN "evenemang" neutrum ;
  eventualitet_nn_1 = mkN "eventualitet" "eventualiteter" ;
  eventuell_av_1 = mkA "eventuell" ;
  evergreen_nn_1 = mkN "evergreen" "evergreenen" "evergreens" "evergreensen" ;
  evertebrat_nn_1 = mkN "evertebrat" "evertebrater" ;
  evident_av_1 = mkA "evident" "evident" ;
  evig_av_1 = mkA "evig" ;
  evighet_nn_1 = mkN "evighet" "evigheter" ;
  evighetskalender_nn_1 = mkN "evighetskalender" ;
  evighetsmaskin_nn_1 = mkN "evighetsmaskin" "evighetsmaskiner" ;
  evinnerlig_av_1 = mkA "evinnerlig" ;
  evinnerligen_ab_1 = mkAdv "evinnerligen" ;
  evolution_nn_1 = mkN "evolution" "evolutioner" ;
  evolutionaer_av_1 = mkA "evolutionдr" ;
  evolutionist_nn_1 = mkN "evolutionist" "evolutionister" ;
  evolutionsbiolog_nn_1 = mkN "evolutionsbiolog" "evolutionsbiologer" ;
  evolutionsforskning_nn_1 = mkN "evolutionsforskning" ;
  evolutionsmekanism_nn_1 = mkN "evolutionsmekanism" "evolutionsmekanismer" ;
  evolutionsteori_nn_1 = mkN "evolutionsteori" "evolutionsteorier" ;
  exakt_av_1 = mkA "exakt" "exakt" ;
  exakthet_nn_1 = mkN "exakthet" "exaktheter" ;
  examen_nn_1 = mkN "examen" "examen" "examina" "examina" ;
  examinand_nn_1 = mkN "examinand" "examinander" ;
  examination_nn_1 = mkN "examination" "examinationer" ;
  examinator_nn_1 = mkN "examinator" "examinatorer" ;
  examinatorium_nn_1 = mkN "examinatorium" "examinatoriumet" "examinatorier" "examinatorierna" ;
  exantem_nn_1 = mkN "exantem" neutrum ;
  excellens_nn_1 = mkN "excellens" "excellenser" ;
  excellent_av_1 = mkA "excellent" "excellent" ;
  excenter_nn_1 = mkN "excenter" ;
  excentricitet_nn_1 = mkN "excentricitet" "excentriciteter" ;
  excentriker_nn_1 = mkN "excentriker" "excentrikern" "excentriker" "excentrikerna" ;
  excentrisk_av_1 = mkA "excentrisk" ;
  exceptionell_av_1 = mkA "exceptionell" ;
  excerpist_nn_1 = mkN "excerpist" "excerpister" ;
  excerpt_nn_1 = mkN "excerpt" "excerpter" ;
  excess_nn_1 = mkN "excess" "excesser" ;
  excision_nn_1 = mkN "excision" "excisioner" ;
  excitation_nn_1 = mkN "excitation" "excitationer" ;
  exeget_nn_1 = mkN "exeget" "exegeter" ;
  exekution_nn_1 = mkN "exekution" "exekutioner" ;
  exekutiv_av_1 = mkA "exekutiv" ;
  exekutiv_nn_1 = mkN "exekutiv" "exekutiver" ;
  exekutoer_nn_1 = mkN "exekutцr" "exekutцrer" ;
  exekutor_nn_1 = mkN "exekutor" "exekutorer" ;
  exekutorisk_av_1 = mkA "exekutorisk" ;
  exempel_nn_1 = mkN "exempel" neutrum ;
  exempelloes_av_1 = mkA "exempellцs" ;
  exempelvis_ab_1 = mkAdv "exempelvis" ;
  exemplar_nn_1 = mkN "exemplar" neutrum ;
  exemplarisk_av_1 = mkA "exemplarisk" ;
  exemplifiering_nn_1 = mkN "exemplifiering" ;
  exemplifikation_nn_1 = mkN "exemplifikation" "exemplifikationer" ;
  exercis_nn_1 = mkN "exercis" "exerciser" ;
  exhibitionist_nn_1 = mkN "exhibitionist" "exhibitionister" ;
  exhustru_nn_1 = mkN "exhustru" "exhustrun" "exhustrur" "exhustrurna" ;
  exigibel_av_1 = mkA "exigibel" "exigibelt" "exigibla" "exigibla" "exigiblare" "exigiblast" "exigiblaste" ;
  existens_nn_1 = mkN "existens" "existenser" ;
  existensminimum_nn_1 = mkN "existensminimum" neutrum ;
  existentiell_av_1 = mkA "existentiell" ;
  exklamation_nn_1 = mkN "exklamation" "exklamationer" ;
  exklamatorisk_av_1 = mkA "exklamatorisk" ;
  exklusiv_av_1 = mkA "exklusiv" ;
  exklusivitet_nn_1 = mkN "exklusivitet" "exklusiviteter" ;
  exkrement_nn_1 = mkN "exkrement" "exkrementet" "exkrementer" "exkrementerna" ;
  exkremental_av_1 = mkA "exkremental" ;
  exkret_nn_1 = mkN "exkret" neutrum ;
  exkretion_nn_1 = mkN "exkretion" "exkretioner" ;
  exkung_nn_1 = mkN "exkung" ;
  exkurs_nn_1 = mkN "exkurs" "exkurser" ;
  exkursion_nn_1 = mkN "exkursion" "exkursioner" ;
  exlibris_nn_1 = mkN "exlibris" neutrum ;
  exogen_av_1 = mkA "exogen" ;
  exorcist_nn_1 = mkN "exorcist" "exorcister" ;
  exoterisk_av_1 = mkA "exoterisk" ;
  exotermisk_av_1 = mkA "exotermisk" ;
  exotisk_av_1 = mkA "exotisk" ;
  expansibel_av_1 = mkA "expansibel" "expansibelt" "expansibla" "expansibla" "expansiblare" "expansiblast" "expansiblaste" ;
  expansionskaerl_nn_1 = mkN "expansionskдrl" neutrum ;
  expansiv_av_1 = mkA "expansiv" ;
  expedit_av_1 = mkA "expedit" "expedit" ;
  expedit_nn_1 = mkN "expedit" "expediter" ;
  expedition_nn_1 = mkN "expedition" "expeditioner" ;
  expeditionskaar_nn_1 = mkN "expeditionskеr" "expeditionskеrer" ;
  expeditionsministaer_nn_1 = mkN "expeditionsministдr" "expeditionsministдrer" ;
  expeditionsregering_nn_1 = mkN "expeditionsregering" ;
  expeditionsvakt_nn_1 = mkN "expeditionsvakt" "expeditionsvakter" ;
  expeditoer_nn_1 = mkN "expeditцr" "expeditцrer" ;
  expektoration_nn_1 = mkN "expektoration" "expektorationer" ;
  experiment_nn_1 = mkN "experiment" neutrum ;
  experimentalfysiker_nn_1 = mkN "experimentalfysiker" "experimentalfysikern" "experimentalfysiker" "experimentalfysikerna" ;
  experimentator_nn_1 = mkN "experimentator" "experimentatorer" ;
  experimentell_av_1 = mkA "experimentell" ;
  experimentgymnasium_nn_1 = mkN "experimentgymnasium" "experimentgymnasiet" "experimentgymnasier" "experimentgymnasierna" ;
  expert_nn_1 = mkN "expert" "experter" ;
  expertgrupp_nn_1 = mkN "expertgrupp" "expertgrupper" ;
  expertkrets_nn_1 = mkN "expertkrets" ;
  expertspraak_nn_1 = mkN "expertsprеk" neutrum ;
  explanativ_av_1 = mkA "explanativ" ;
  explicit_av_1 = mkA "explicit" "explicit" ;
  explikation_nn_1 = mkN "explikation" "explikationer" ;
  exploatering_nn_1 = mkN "exploatering" ;
  exploatoer_nn_1 = mkN "exploatцr" "exploatцrer" ;
  explosion_nn_1 = mkN "explosion" "explosioner" ;
  explosionsfoerlopp_nn_1 = mkN "explosionsfцrlopp" neutrum ;
  explosionshaerd_nn_1 = mkN "explosionshдrd" ;
  explosionsmotor_nn_1 = mkN "explosionsmotor" "explosionsmotorer" ;
  explosionsoegonblick_nn_1 = mkN "explosionsцgonblick" neutrum ;
  explosionssaett_nn_1 = mkN "explosionssдtt" neutrum ;
  explosiv_av_1 = mkA "explosiv" ;
  expo_nn_1 = mkN "expo" "expor" ;
  exponent_nn_1 = mkN "exponent" "exponenter" ;
  exponentiell_av_1 = mkA "exponentiell" ;
  exponering_nn_1 = mkN "exponering" ;
  exponeringsmaetare_nn_1 = mkN "exponeringsmдtare" "exponeringsmдtare" ;
  export_nn_1 = mkN "export" "exporter" ;
  exportinkomst_nn_1 = mkN "exportinkomst" "exportinkomster" ;
  exportmarknad_nn_1 = mkN "exportmarknad" "exportmarknader" ;
  exportoer_nn_1 = mkN "exportцr" "exportцrer" ;
  expose_nn_1 = mkN "exposй" "exposйer" ;
  exposition_nn_1 = mkN "exposition" "expositioner" ;
  express_ab_1 = mkAdv "express" ;
  express_nn_1 = mkN "express" "expresser" ;
  expressbrev_nn_1 = mkN "expressbrev" neutrum ;
  expressbyraa_nn_1 = mkN "expressbyrе" "expressbyrеer" ;
  expressfoersaendelse_nn_1 = mkN "expressfцrsдndelse" "expressfцrsдndelser" ;
  expressionist_nn_1 = mkN "expressionist" "expressionister" ;
  expressiv_av_1 = mkA "expressiv" ;
  expressivitet_nn_1 = mkN "expressivitet" "expressiviteter" ;
  expropriation_nn_1 = mkN "expropriation" "expropriationer" ;
  exsickat_nn_1 = mkN "exsickat" neutrum ;
  exsickator_nn_1 = mkN "exsickator" "exsickatorer" ;
  exsudat_nn_1 = mkN "exsudat" neutrum ;
  extatisk_av_1 = mkA "extatisk" ;
  extempore_ab_1 = mkAdv "extempore" ;
  extension_nn_1 = mkN "extension" "extensioner" ;
  extensiv_av_1 = mkA "extensiv" ;
  exterioer_nn_1 = mkN "exteriцr" "exteriцrer" ;
  extern_av_1 = mkA "extern" ;
  extern_nn_1 = mkN "extern" "externer" ;
  externat_nn_1 = mkN "externat" neutrum ;
  exterritoriell_av_1 = mkA "exterritoriell" ;
  extra_ab_1 = mkAdv "extra" ;
  extra_av_1 = mkA "extra" ;
  extrainkomst_nn_1 = mkN "extrainkomst" "extrainkomster" ;
  extrajudiciell_av_1 = mkA "extrajudiciell" ;
  extraknaeck_nn_1 = mkN "extraknдck" neutrum ;
  extrakontant_av_1 = mkA "extrakontant" "extrakontant" ;
  extrakt_nn_1 = mkN "extrakt" neutrum ;
  extraktion_nn_1 = mkN "extraktion" "extraktioner" ;
  extraktivaemne_nn_1 = mkN "extraktivдmne" ;
  extraktor_nn_1 = mkN "extraktor" "extraktorer" ;
  extramural_av_1 = mkA "extramural" ;
  extraordinaer_av_1 = mkA "extraordinдr" ;
  extraordinarie_av_1 = mkA "extraordinarie" ;
  extraordinarie_nn_1 = mkN "extraordinarie" "extraordinarier" ;
  extrapolation_nn_1 = mkN "extrapolation" "extrapolationer" ;
  extrapris_nn_1 = mkN "extrapris" neutrum ;
  extrasol_nn_1 = mkN "extrasol" ;
  extrauterin_av_1 = mkA "extrauterin" ;
  extravagans_nn_1 = mkN "extravagans" "extravaganser" ;
  extravagant_av_1 = mkA "extravagant" "extravagant" ;
  extrem_av_1 = mkA "extrem" ;
  extrem_nn_1 = mkN "extrem" "extremer" ;
  extremist_nn_1 = mkN "extremist" "extremister" ;
  extremitet_nn_1 = mkN "extremitet" "extremiteter" ;
  extrovert_av_1 = mkA "extrovert" "extrovert" ;
  eye_liner_nn_1 = mkN "eye-liner" "eye-linern" "eye-liners" "eye-linersen" ;
  faa_av_1 = mkA "fе" "fе" "fе" "fдrre" "fдrst" ;
  faafaeng_av_1 = mkA "fеfдng" ;
  faafaenglig_av_1 = mkA "fеfдnglig" ;
  faafaenglighet_nn_1 = mkN "fеfдnglighet" "fеfдngligheter" ;
  faagel_nn_1 = mkN "fеgel" ;
  faagelaegg_nn_1 = mkN "fеgelдgg" neutrum ;
  faagelbad_nn_1 = mkN "fеgelbad" neutrum ;
  faagelbaer_nn_1 = mkN "fеgelbдr" neutrum ;
  faagelbo_nn_1 = mkN "fеgelbo" "fеgelbot" "fеgelbon" "fеgelboen" ;
  faagelbur_nn_1 = mkN "fеgelbur" ;
  faagelfjaeder_nn_1 = mkN "fеgelfjдder" ;
  faagelfot_nn_1 = mkN "fеgelfot" "fеgelfцtter" ;
  faagelfri_av_1 = mkA "fеgelfri" "fеgelfritt" ;
  faagelholk_nn_1 = mkN "fеgelholk" ;
  faagelhund_nn_1 = mkN "fеgelhund" ;
  faageljakt_nn_1 = mkN "fеgeljakt" "fеgeljakter" ;
  faagelperspektiv_nn_1 = mkN "fеgelperspektiv" neutrum ;
  faagelskaadare_nn_1 = mkN "fеgelskеdare" "fеgelskеdare" ;
  faagelskaadning_nn_1 = mkN "fеgelskеdning" ;
  faagelstraeck_nn_1 = mkN "fеgelstrдck" neutrum ;
  faagelunge_nn_1 = mkN "fеgelunge" utrum ;
  faagelvinge_nn_1 = mkN "fеgelvinge" utrum ;
  faakunnig_av_1 = mkA "fеkunnig" ;
  faale_nn_1 = mkN "fеle" utrum ;
  faall_nn_1 = mkN "fеll" ;
  faallbaenk_nn_1 = mkN "fеllbдnk" ;
  faamaeld_av_1 = mkA "fеmдld" "fеmдlt" ;
  faamansfoeretag_nn_1 = mkN "fеmansfцretag" neutrum ;
  faan_nn_1 = mkN "fеn" neutrum ;
  faane_nn_1 = mkN "fеne" utrum ;
  faaneri_nn_1 = mkN "fеneri" "fеnerit" "fеnerier" "fеnerierna" ;
  faang_nn_1 = mkN "fеng" neutrum ;
  faange_nn_1 = mkN "fеnge" utrum ;
  faangen_av_1 = mkA "fеngen" "fеnget" ;
  faangeshandling_nn_1 = mkN "fеngeshandling" ;
  faangesman_nn_1 = mkN "fеngesman" "fеngesmannen" "fеngesmдn" "fеngesmдnnen" ;
  faanglaeger_nn_1 = mkN "fеnglдger" neutrum ;
  faangst_nn_1 = mkN "fеngst" "fеngster" ;
  faangstanordning_nn_1 = mkN "fеngstanordning" ;
  faangstfolk_nn_1 = mkN "fеngstfolk" neutrum ;
  faangstgrop_nn_1 = mkN "fеngstgrop" ;
  faangstkrok_nn_1 = mkN "fеngstkrok" ;
  faangstkultur_nn_1 = mkN "fеngstkultur" "fеngstkulturer" ;
  faangstplats_nn_1 = mkN "fеngstplats" "fеngstplatser" ;
  faangstredskap_nn_1 = mkN "fеngstredskap" "fеngstredskapet" "fеngstredskapen" "fеngstredskapena" ;
  faangvaktare_nn_1 = mkN "fеngvaktare" "fеngvaktare" ;
  faanig_av_1 = mkA "fеnig" ;
  faanskratt_nn_1 = mkN "fеnskratt" neutrum ;
  faantratt_nn_1 = mkN "fеntratt" ;
  faaordig_av_1 = mkA "fеordig" ;
  faar_nn_1 = mkN "fеr" neutrum ;
  faaraktig_av_1 = mkA "fеraktig" ;
  faarbogsaerm_nn_1 = mkN "fеrbogsдrm" ;
  faarfiol_nn_1 = mkN "fеrfiol" "fеrfioler" ;
  faarhund_nn_1 = mkN "fеrhund" ;
  faarost_nn_1 = mkN "fеrost" ;
  faarskalle_nn_1 = mkN "fеrskalle" utrum ;
  faarskinn_nn_1 = mkN "fеrskinn" neutrum ;
  faat_nn_1 = mkN "fеt" "fеter" ;
  faatal_nn_1 = mkN "fеtal" "fеtalet" "fеtalen" "fеtalena" ;
  faatalig_av_1 = mkA "fеtalig" ;
  faatoelj_nn_1 = mkN "fеtцlj" "fеtцljer" ;
  faavitsk_av_1 = mkA "fеvitsk" ;
  fabel_nn_1 = mkN "fabel" "fabeln" "fabler" "fablerna" ;
  fabelaktig_av_1 = mkA "fabelaktig" ;
  fabeldjur_nn_1 = mkN "fabeldjur" neutrum ;
  fabrik_nn_1 = mkN "fabrik" "fabriker" ;
  fabrikant_nn_1 = mkN "fabrikant" "fabrikanter" ;
  fabrikat_nn_1 = mkN "fabrikat" neutrum ;
  fabrikation_nn_1 = mkN "fabrikation" "fabrikationer" ;
  fabrikoer_nn_1 = mkN "fabrikцr" "fabrikцrer" ;
  fabriksmaessig_av_1 = mkA "fabriksmдssig" ;
  fabriksny_av_1 = mkA "fabriksny" "fabriksnytt" ;
  fabrikspris_nn_1 = mkN "fabrikspris" neutrum ;
  fabriksskorsten_nn_1 = mkN "fabriksskorsten" "fabriksskorstenen" "fabriksskorstenar" "fabriksskorstenarna" ;
  fabulering_nn_1 = mkN "fabulering" ;
  fabuloes_av_1 = mkA "fabulцs" ;
  facil_av_1 = mkA "facil" ;
  facilitet_nn_1 = mkN "facilitet" "faciliteter" ;
  fack_nn_1 = mkN "fack" neutrum ;
  fackelblomster_nn_1 = mkN "fackelblomster" neutrum ;
  fackeltaag_nn_1 = mkN "fackeltеg" neutrum ;
  fackfoerbund_nn_1 = mkN "fackfцrbund" neutrum ;
  fackfoerening_nn_1 = mkN "fackfцrening" ;
  fackfoereningsroerelse_nn_1 = mkN "fackfцreningsrцrelse" "fackfцreningsrцrelser" ;
  fackidiot_nn_1 = mkN "fackidiot" "fackidioter" ;
  fackkunnig_av_1 = mkA "fackkunnig" ;
  fackkunskap_nn_1 = mkN "fackkunskap" "fackkunskaper" ;
  fackla_nn_1 = mkN "fackla" ;
  facklig_av_1 = mkA "facklig" ;
  fackmaessig_av_1 = mkA "fackmдssig" ;
  fackman_nn_1 = mkN "fackman" "fackmannen" "fackmдn" "fackmдnnen" ;
  fackminister_nn_1 = mkN "fackminister" ;
  fackordbok_nn_1 = mkN "fackordbok" "fackordbцcker" ;
  fackorgan_nn_1 = mkN "fackorgan" neutrum ;
  fackspraak_nn_1 = mkN "facksprеk" neutrum ;
  fackterm_nn_1 = mkN "fackterm" "facktermer" ;
  facktidskrift_nn_1 = mkN "facktidskrift" "facktidskrifter" ;
  fackutskottsprincip_nn_1 = mkN "fackutskottsprincip" "fackutskottsprinciper" ;
  fackverk_nn_1 = mkN "fackverk" neutrum ;
  fadaes_nn_1 = mkN "fadдs" "fadдser" ;
  fadder_nn_1 = mkN "fadder" ;
  fadderbarn_nn_1 = mkN "fadderbarn" neutrum ;
  fader_nn_1 = mkN "fader" "fadern" "fдder" "fдderna" ;
  faderlig_av_1 = mkA "faderlig" ;
  fadermoerdare_nn_1 = mkN "fadermцrdare" "fadermцrdare" ;
  fadersarv_nn_1 = mkN "fadersarv" neutrum ;
  fadersfigur_nn_1 = mkN "fadersfigur" "fadersfigurer" ;
  fadersgestalt_nn_1 = mkN "fadersgestalt" "fadersgestalter" ;
  fadershus_nn_1 = mkN "fadershus" neutrum ;
  faderskomplex_nn_1 = mkN "faderskomplex" neutrum ;
  fadersnamn_nn_1 = mkN "fadersnamn" neutrum ;
  fadersvaelde_nn_1 = mkN "fadersvдlde" ;
  fadervaar_nn_1 = mkN "fadervеr" neutrum ;
  fae_nn_1 = mkN "fд" "fдet" "fдn" "fдna" ;
  faeaktig_av_1 = mkA "fдaktig" ;
  faebless_nn_1 = mkN "fдbless" "fдblesser" ;
  faebod_nn_1 = mkN "fдbod" ;
  faebodvall_nn_1 = mkN "fдbodvall" ;
  faedernesland_nn_1 = mkN "fдdernesland" neutrum ;
  faegnad_nn_1 = mkN "fдgnad" "fдgnader" ;
  faegnesam_av_1 = mkA "fдgnesam" "fдgnesamt" "fдgnesamma" "fдgnesamma" "fдgnesammare" "fдgnesammast" "fдgnesammaste" ;
  faehund_nn_1 = mkN "fдhund" ;
  faehus_nn_1 = mkN "fдhus" neutrum ;
  faektare_nn_1 = mkN "fдktare" "fдktare" ;
  faektning_nn_1 = mkN "fдktning" ;
  faelg_nn_1 = mkN "fдlg" ;
  faelgkors_nn_1 = mkN "fдlgkors" neutrum ;
  faell_nn_1 = mkN "fдll" ;
  faellbar_av_1 = mkA "fдllbar" ;
  faellkniv_nn_1 = mkN "fдllkniv" ;
  faellkoel_nn_1 = mkN "fдllkцl" ;
  faellning_nn_1 = mkN "fдllning" ;
  faellstol_nn_1 = mkN "fдllstol" ;
  faelt_nn_1 = mkN "fдlt" neutrum ;
  faeltarme_nn_1 = mkN "fдltarmй" "fдltarmйer" ;
  faeltassistent_nn_1 = mkN "fдltassistent" "fдltassistenter" ;
  faeltbiolog_nn_1 = mkN "fдltbiolog" "fдltbiologer" ;
  faeltflygare_nn_1 = mkN "fдltflygare" "fдltflygare" ;
  faeltfoersoek_nn_1 = mkN "fдltfцrsцk" neutrum ;
  faeltgraa_av_1 = mkA "fдltgrе" "fдltgrеtt" ;
  faelthare_nn_1 = mkN "fдlthare" utrum ;
  faeltherre_nn_1 = mkN "fдltherre" utrum ;
  faelthoens_nn_1 = mkN "fдlthцns" neutrum ;
  faeltkikare_nn_1 = mkN "fдltkikare" "fдltkikare" ;
  faeltmaessig_av_1 = mkA "fдltmдssig" ;
  faeltmaetning_nn_1 = mkN "fдltmдtning" ;
  faeltmarskalk_nn_1 = mkN "fдltmarskalk" ;
  faeltpraest_nn_1 = mkN "fдltprдst" "fдltprдster" ;
  faeltrop_nn_1 = mkN "fдltrop" neutrum ;
  faeltskaer_nn_1 = mkN "fдltskдr" "fдltskдrer" ;
  faeltslag_nn_1 = mkN "fдltslag" neutrum ;
  faeltspat_nn_1 = mkN "fдltspat" "fдltspater" ;
  faeltstudium_nn_1 = mkN "fдltstudium" "fдltstudiet" "fдltstudier" "fдltstudierna" ;
  faeltstyrka_nn_1 = mkN "fдltstyrka" ;
  faelttaag_nn_1 = mkN "fдlttеg" neutrum ;
  faelttaagsplan_nn_1 = mkN "fдlttеgsplan" "fдlttеgsplaner" ;
  faelttaevlan_nn_1 = mkN "fдlttдvlan" "fдlttдvlan" "fдlttдvlningar" "fдlttдvlningarna" ;
  faelttecken_nn_1 = mkN "fдlttecken" "fдlttecknet" "fдlttecken" "fдlttecknen" ;
  faelttjaenstgoering_nn_1 = mkN "fдlttjдnstgцring" ;
  faelttjaenstoevning_nn_1 = mkN "fдlttjдnstцvning" ;
  faeltuniform_nn_1 = mkN "fдltuniform" "fдltuniformer" ;
  faenad_nn_1 = mkN "fдnad" "fдnader" ;
  faengelse_nn_1 = mkN "fдngelse" "fдngelset" "fдngelser" "fдngelserna" ;
  faengelsecell_nn_1 = mkN "fдngelsecell" "fдngelseceller" ;
  faengelsefoerhaallande_nn_1 = mkN "fдngelsefцrhеllande" ;
  faengelsekund_nn_1 = mkN "fдngelsekund" "fдngelsekunder" ;
  faengelsestraff_nn_1 = mkN "fдngelsestraff" neutrum ;
  faenghaal_nn_1 = mkN "fдnghеl" neutrum ;
  faengsel_nn_1 = mkN "fдngsel" neutrum ;
  faengslande_av_1 = mkA "fдngslande" ;
  faengslig_av_1 = mkA "fдngslig" ;
  faenrik_nn_1 = mkN "fдnrik" ;
  faerd_nn_1 = mkN "fдrd" "fдrder" ;
  faerdbevis_nn_1 = mkN "fдrdbevis" neutrum ;
  faerdbiljett_nn_1 = mkN "fдrdbiljett" "fдrdbiljetter" ;
  faerdig_av_1 = mkA "fдrdig" ;
  faerdighet_nn_1 = mkN "fдrdighet" "fдrdigheter" ;
  faerdighetsaemne_nn_1 = mkN "fдrdighetsдmne" ;
  faerdighetstraening_nn_1 = mkN "fдrdighetstrдning" ;
  faerdknaepp_nn_1 = mkN "fдrdknдpp" ;
  faerdled_nn_1 = mkN "fдrdled" "fдrdleder" ;
  faerdledare_nn_1 = mkN "fдrdledare" "fдrdledare" ;
  faerdmedel_nn_1 = mkN "fдrdmedel" neutrum ;
  faerdriktning_nn_1 = mkN "fдrdriktning" ;
  faerdskrivare_nn_1 = mkN "fдrdskrivare" "fдrdskrivare" ;
  faerdvaeg_nn_1 = mkN "fдrdvдg" ;
  faerg_nn_1 = mkN "fдrg" "fдrger" ;
  faergaekta_av_1 = mkA "fдrgдkta" ;
  faergaemne_nn_1 = mkN "fдrgдmne" ;
  faergbad_nn_1 = mkN "fдrgbad" neutrum ;
  faergband_nn_1 = mkN "fдrgband" neutrum ;
  faergbestaendig_av_1 = mkA "fдrgbestдndig" ;
  faergbild_nn_1 = mkN "fдrgbild" "fдrgbilder" ;
  faergblandning_nn_1 = mkN "fдrgblandning" ;
  faergblind_av_1 = mkA "fдrgblind" ;
  faergeri_nn_1 = mkN "fдrgeri" "fдrgerit" "fдrgerier" "fдrgerierna" ;
  faergfilter_nn_1 = mkN "fдrgfilter" neutrum ;
  faergfoeraendring_nn_1 = mkN "fдrgfцrдndring" ;
  faergglad_av_1 = mkA "fдrgglad" ;
  faerggrann_av_1 = mkA "fдrggrann" "fдrggrant" ;
  faerghandel_nn_1 = mkN "fдrghandel" ;
  faergkaenslig_av_1 = mkA "fдrgkдnslig" ;
  faergkaenslighet_nn_1 = mkN "fдrgkдnslighet" "fдrgkдnsligheter" ;
  faergklick_nn_1 = mkN "fдrgklick" ;
  faergkontrast_nn_1 = mkN "fдrgkontrast" "fдrgkontraster" ;
  faerglitografi_nn_1 = mkN "fдrglitografi" "fдrglitografier" ;
  faergloes_av_1 = mkA "fдrglцs" ;
  faergmoenster_nn_1 = mkN "fдrgmцnster" neutrum ;
  faergning_nn_1 = mkN "fдrgning" ;
  faergpigment_nn_1 = mkN "fдrgpigment" neutrum ;
  faergreproduktion_nn_1 = mkN "fдrgreproduktion" "fдrgreproduktioner" ;
  faergrik_av_1 = mkA "fдrgrik" ;
  faergrivning_nn_1 = mkN "fдrgrivning" ;
  faergsaettning_nn_1 = mkN "fдrgsдttning" ;
  faergspektrum_nn_1 = mkN "fдrgspektrum" neutrum ;
  faergspel_nn_1 = mkN "fдrgspel" "fдrgspelet" "fдrgspel" "fдrgspelen" ;
  faergsprakande_av_1 = mkA "fдrgsprakande" ;
  faergspridning_nn_1 = mkN "fдrgspridning" ;
  faergstark_av_1 = mkA "fдrgstark" ;
  faergstoff_nn_1 = mkN "fдrgstoff" "fдrgstoffer" ;
  faergtemperatur_nn_1 = mkN "fдrgtemperatur" "fдrgtemperaturer" ;
  faergteve_nn_1 = mkN "fдrgteve" "fдrgteven" "fдrgteve" "fдrgtevena" ;
  faergton_nn_1 = mkN "fдrgton" "fдrgtoner" ;
  faergtryck_nn_1 = mkN "fдrgtryck" neutrum ;
  faering_nn_1 = mkN "fдring" ;
  faerjelaege_nn_1 = mkN "fдrjelдge" ;
  faerm_av_1 = mkA "fдrm" ;
  faermitet_nn_1 = mkN "fдrmitet" "fдrmiteter" ;
  faeroeing_nn_1 = mkN "fдrцing" ;
  faeroeisk_av_1 = mkA "fдrцisk" ;
  faeroeiska_nn_2 = mkN "fдrцiska" ;
  faers_nn_1 = mkN "fдrs" "fдrser" ;
  faersk_av_1 = mkA "fдrsk" ;
  faerskmalm_nn_1 = mkN "fдrskmalm" "fдrskmalmer" ;
  faerskning_nn_1 = mkN "fдrskning" ;
  faerskvatten_nn_1 = mkN "fдrskvatten" "fдrskvattnet" "fдrskvatten" "fдrskvattnen" ;
  faesoer_nn_1 = mkN "fдsцr" "fдsцrer" ;
  faesting_nn_1 = mkN "fдsting" ;
  faestman_nn_1 = mkN "fдstman" "fдstmannen" "fдstmдn" "fдstmдnnen" ;
  faestmoe_nn_1 = mkN "fдstmц" "fдstmцn" "fдstmцr" "fдstmцrna" ;
  faestning_nn_1 = mkN "fдstning" ;
  faestpunkt_nn_1 = mkN "fдstpunkt" "fдstpunkter" ;
  fager_av_1 = mkA "fager" "fagert" "fagra" "fagra" "fagrare" "fagrast" "fagraste" ;
  fagott_nn_1 = mkN "fagott" "fagotter" ;
  faiblesse_nn_1 = mkN "faiblesse" "faiblesser" ;
  fajans_nn_1 = mkN "fajans" "fajanser" ;
  fajt_nn_1 = mkN "fajt" "fajter" ;
  fakir_nn_1 = mkN "fakir" "fakirer" ;
  faksimil_nn_1 = mkN "faksimil" neutrum ;
  faksimile_nn_1 = mkN "faksimile" "faksimiler" ;
  faktafolder_nn_1 = mkN "faktafolder" ;
  fakticitet_nn_1 = mkN "fakticitet" "fakticiteter" ;
  faktisk_av_1 = mkA "faktisk" ;
  faktor_nn_1 = mkN "faktor" "faktorer" ;
  faktoranalys_nn_1 = mkN "faktoranalys" "faktoranalyser" ;
  faktori_nn_1 = mkN "faktori" "faktorit" "faktorier" "faktorierna" ;
  faktotum_nn_1 = mkN "faktotum" neutrum ;
  faktum_nn_1 = mkN "faktum" neutrum ;
  fakultativ_av_1 = mkA "fakultativ" ;
  fakultet_nn_1 = mkN "fakultet" "fakulteter" ;
  fakultetsopponent_nn_1 = mkN "fakultetsopponent" "fakultetsopponenter" ;
  fal_av_1 = mkA "fal" ;
  falang_nn_1 = mkN "falang" "falanger" ;
  falangist_nn_1 = mkN "falangist" "falangister" ;
  falk_nn_1 = mkN "falk" ;
  falkenerare_nn_1 = mkN "falkenerare" "falkenerare" ;
  falkjakt_nn_1 = mkN "falkjakt" "falkjakter" ;
  falkonett_nn_1 = mkN "falkonett" "falkonetter" ;
  fall_nn_1 = mkN "fall" neutrum ;
  falla_vb_1 = mkV "falla" "fцll" "fallit" ;
  fallen_av_1 = mkA "fallen" "fallet" ;
  fallenhet_nn_1 = mkN "fallenhet" "fallenheter" ;
  fallfaerdig_av_1 = mkA "fallfдrdig" ;
  fallfrukt_nn_1 = mkN "fallfrukt" "fallfrukter" ;
  fallgrop_nn_1 = mkN "fallgrop" ;
  fallhammare_nn_1 = mkN "fallhammare" "fallhammaren" "fallhamrar" "fallhamrarna" ;
  fallhoejd_nn_1 = mkN "fallhцjd" "fallhцjder" ;
  fallissemang_nn_1 = mkN "fallissemang" neutrum ;
  fallos_nn_1 = mkN "fallos" ;
  fallrep_nn_1 = mkN "fallrep" neutrum ;
  fallseger_nn_1 = mkN "fallseger" ;
  fallskaerm_nn_1 = mkN "fallskдrm" ;
  fallskaermshoppare_nn_1 = mkN "fallskдrmshoppare" "fallskдrmshoppare" ;
  fallskaermsjaegare_nn_1 = mkN "fallskдrmsjдgare" "fallskдrmsjдgare" ;
  fallskaermstrupp_nn_1 = mkN "fallskдrmstrupp" "fallskдrmstrupper" ;
  fallstudie_nn_1 = mkN "fallstudie" "fallstudier" ;
  fallverk_nn_1 = mkN "fallverk" neutrum ;
  fallvind_nn_1 = mkN "fallvind" ;
  fals_nn_1 = mkN "fals" ;
  falsarium_nn_1 = mkN "falsarium" "falsariet" "falsarier" "falsarierna" ;
  falsifikat_nn_1 = mkN "falsifikat" neutrum ;
  falsk_av_1 = mkA "falsk" ;
  falskeligen_ab_1 = mkAdv "falskeligen" ;
  falskmyntare_nn_1 = mkN "falskmyntare" "falskmyntare" ;
  falskspel_nn_1 = mkN "falskspel" "falskspelet" "falskspel" "falskspelen" ;
  falukorv_nn_1 = mkN "falukorv" ;
  faluroed_av_1 = mkA "falurцd" ;
  familj_nn_1 = mkN "familj" "familjer" ;
  familjaer_av_1 = mkA "familjдr" ;
  familjaritet_nn_1 = mkN "familjaritet" "familjariteter" ;
  familjebidrag_nn_1 = mkN "familjebidrag" neutrum ;
  familjebiljett_nn_1 = mkN "familjebiljett" "familjebiljetter" ;
  familjebolag_nn_1 = mkN "familjebolag" neutrum ;
  familjedaghem_nn_1 = mkN "familjedaghem" "familjedaghemmet" "familjedaghem" "familjedaghemmen" ;
  familjefoeretag_nn_1 = mkN "familjefцretag" neutrum ;
  familjefoersoerjare_nn_1 = mkN "familjefцrsцrjare" "familjefцrsцrjare" ;
  familjehem_nn_1 = mkN "familjehem" "familjehemmet" "familjehem" "familjehemmen" ;
  familjehotell_nn_1 = mkN "familjehotell" neutrum ;
  familjejordbruk_nn_1 = mkN "familjejordbruk" neutrum ;
  familjekrets_nn_1 = mkN "familjekrets" ;
  familjemedlem_nn_1 = mkN "familjemedlem" "familjemedlemmen" "familjemedlemmar" "familjemedlemmarna" ;
  familjenamn_nn_1 = mkN "familjenamn" neutrum ;
  familjepension_nn_1 = mkN "familjepension" "familjepensioner" ;
  familjeplanering_nn_1 = mkN "familjeplanering" ;
  familjeraadgivning_nn_1 = mkN "familjerеdgivning" ;
  familjerabatt_nn_1 = mkN "familjerabatt" "familjerabatter" ;
  famlande_av_1 = mkA "famlande" ;
  famn_nn_1 = mkN "famn" ;
  famntag_nn_1 = mkN "famntag" neutrum ;
  famoes_av_1 = mkA "famцs" ;
  fan_nn_2 = mkN "fan" "fanen" "fans" "fansen" ;
  fan_nn_3 = mkN "fan" neutrum ;
  fanatiker_nn_1 = mkN "fanatiker" "fanatikern" "fanatiker" "fanatikerna" ;
  fanatisk_av_1 = mkA "fanatisk" ;
  fanborg_nn_1 = mkN "fanborg" ;
  fandango_nn_1 = mkN "fandango" "fandangor" ;
  faner_nn_1 = mkN "faner" "faneret" "faner" "faneren" ;
  fanerogam_av_1 = mkA "fanerogam" ;
  fanerogam_nn_1 = mkN "fanerogam" "fanerogamer" ;
  fanfar_nn_1 = mkN "fanfar" "fanfarer" ;
  fanjunkare_nn_1 = mkN "fanjunkare" "fanjunkare" ;
  fanskap_nn_1 = mkN "fanskap" "fanskapet" "fanskapen" "fanskapena" ;
  fanstyg_nn_1 = mkN "fanstyg" neutrum ;
  fantasi_nn_1 = mkN "fantasi" "fantasier" ;
  fantasidjur_nn_1 = mkN "fantasidjur" neutrum ;
  fantasifull_av_1 = mkA "fantasifull" ;
  fantasiloes_av_1 = mkA "fantasilцs" ;
  fantasiprodukt_nn_1 = mkN "fantasiprodukt" "fantasiprodukter" ;
  fantasispel_nn_1 = mkN "fantasispel" "fantasispelet" "fantasispel" "fantasispelen" ;
  fantasivaerld_nn_1 = mkN "fantasivдrld" ;
  fantast_nn_1 = mkN "fantast" "fantaster" ;
  fantasteri_nn_1 = mkN "fantasteri" "fantasterit" "fantasterier" "fantasterierna" ;
  fantastisk_av_1 = mkA "fantastisk" ;
  fantom_nn_1 = mkN "fantom" neutrum ;
  fantom_nn_2 = mkN "fantom" "fantomer" ;
  fantomsnygg_av_1 = mkA "fantomsnygg" ;
  fara_nn_1 = mkN "fara" ;
  fara_vb_1 = mkV "fara" "for" "farit" ;
  farad_nn_1 = mkN "farad" "faraden" "farad" "faraden" ;
  farao_nn_1 = mkN "farao" "farao" "faraoner" "faraonerna" ;
  farbar_av_1 = mkA "farbar" ;
  farbroder_nn_1 = mkN "farbroder" "farbrodern" "farbrцder" "farbrцderna" ;
  farbroderlig_av_1 = mkA "farbroderlig" ;
  farbror_nn_1 = mkN "farbror" "farbrцder" ;
  fardag_nn_1 = mkN "fardag" ;
  farfoeraelder_nn_1 = mkN "farfцrдlder" ;
  fargalt_nn_1 = mkN "fargalt" ;
  farise_nn_1 = mkN "farisй" "farisйer" ;
  fariseisk_av_1 = mkA "fariseisk" ;
  farkost_nn_1 = mkN "farkost" "farkoster" ;
  farled_nn_1 = mkN "farled" "farleder" ;
  farlig_av_1 = mkA "farlig" ;
  farlighet_nn_1 = mkN "farlighet" "farligheter" ;
  farm_nn_1 = mkN "farm" ;
  farmaceut_nn_1 = mkN "farmaceut" "farmaceuter" ;
  farmaceutisk_av_1 = mkA "farmaceutisk" ;
  farmacevt_nn_1 = mkN "farmacevt" "farmacevter" ;
  farmacevtisk_av_1 = mkA "farmacevtisk" ;
  farmacie_av_1 = mkA "farmacie" ;
  farmaka_nn_1 = mkN "farmaka" "farmakan" "farmaka" "farmakana" ;
  farmakolog_nn_1 = mkN "farmakolog" "farmakologer" ;
  farmakologisk_av_1 = mkA "farmakologisk" ;
  farmakope_nn_1 = mkN "farmakopй" "farmakopйer" ;
  farmare_nn_1 = mkN "farmare" "farmare" ;
  farmor_nn_1 = mkN "farmoder" "farmodern" "farmцdrar" "farmцdrarna" ;
  farofylld_av_1 = mkA "farofylld" "farofyllt" ;
  farozon_nn_1 = mkN "farozon" "farozoner" ;
  fars_nn_1 = mkN "fars" "farser" ;
  farsarv_nn_1 = mkN "farsarv" neutrum ;
  farsgubbe_nn_1 = mkN "farsgubbe" utrum ;
  farsot_nn_1 = mkN "farsot" "farsoter" ;
  farstu_nn_1 = mkN "farstu" "farstun" "farstur" "farsturna" ;
  fart_nn_1 = mkN "fart" "farter" ;
  fartblind_av_1 = mkA "fartblind" ;
  fartdaare_nn_1 = mkN "fartdеre" utrum ;
  farthaallare_nn_1 = mkN "farthеllare" "farthеllare" ;
  farthinder_nn_1 = mkN "farthinder" neutrum ;
  fartkamera_nn_1 = mkN "fartkamera" ;
  fartrand_nn_1 = mkN "fartrand" "fartrдnder" ;
  fartyg_nn_1 = mkN "fartyg" neutrum ;
  fartygsbesaettning_nn_1 = mkN "fartygsbesдttning" ;
  fartygsbotten_nn_1 = mkN "fartygsbotten" ;
  fartygsdaeck_nn_1 = mkN "fartygsdдck" neutrum ;
  fartygskurs_nn_1 = mkN "fartygskurs" "fartygskurser" ;
  fartygslast_nn_1 = mkN "fartygslast" "fartygslaster" ;
  fartygssida_nn_1 = mkN "fartygssida" ;
  fartygsskrov_nn_1 = mkN "fartygsskrov" neutrum ;
  fartygstyp_nn_1 = mkN "fartygstyp" "fartygstyper" ;
  farvael_nn_1 = mkN "farvдl" neutrum ;
  farvatten_nn_1 = mkN "farvatten" "farvattnet" "farvatten" "farvattnen" ;
  faryngal_av_1 = mkA "faryngal" ;
  fas_nn_1 = mkN "fas" "faser" ;
  fasa_nn_1 = mkN "fasa" ;
  fasad_nn_1 = mkN "fasad" "fasader" ;
  fasan_nn_1 = mkN "fasan" "fasaner" ;
  fasansfull_av_1 = mkA "fasansfull" ;
  fasavaeckande_av_1 = mkA "fasavдckande" ;
  fascist_nn_1 = mkN "fascist" "fascister" ;
  fascistisk_av_1 = mkA "fascistisk" ;
  fasett_nn_1 = mkN "fasett" "fasetter" ;
  fasettoega_nn_1 = mkN "fasettцga" "fasettцgat" "fasettцgon" "fasettцgonen" ;
  fasfoerskjutning_nn_1 = mkN "fasfцrskjutning" ;
  fashionabel_av_1 = mkA "fashionabel" "fashionabelt" "fashionabla" "fashionabla" "fashionablare" "fashionablast" "fashionablaste" ;
  faskikel_nn_1 = mkN "faskikel" ;
  faskin_nn_1 = mkN "faskin" "faskiner" ;
  faskinkniv_nn_1 = mkN "faskinkniv" ;
  faslig_av_1 = mkA "faslig" ;
  fason_nn_1 = mkN "fason" "fasoner" ;
  fasspaenning_nn_1 = mkN "fasspдnning" ;
  fast_ab_1 = mkAdv "fast" ;
  fast_av_1 = mkA "fast" "fast" ;
  fasta_nn_1 = mkN "fasta" ;
  fastage_nn_1 = mkN "fastage" "fastaget" "fastage" "fastagen" ;
  fastemaanad_nn_1 = mkN "fastemеnad" "fastemеnader" ;
  faster_nn_1 = mkN "faster" ;
  fastfrusen_av_1 = mkA "fastfrusen" "fastfruset" ;
  fasthaalla_vb_1 = mkV "fasthеlla" "fasthцll" "fasthеllit" ;
  fasthaallning_nn_1 = mkN "fasthеllning" ;
  fasthet_nn_1 = mkN "fasthet" "fastheter" ;
  fastighet_nn_1 = mkN "fastighet" "fastigheter" ;
  fastighetsbyraa_nn_1 = mkN "fastighetsbyrе" "fastighetsbyrеer" ;
  fastighetskoep_nn_1 = mkN "fastighetskцp" neutrum ;
  fastighetsmaeklare_nn_1 = mkN "fastighetsmдklare" "fastighetsmдklare" ;
  fastighetsskatt_nn_1 = mkN "fastighetsskatt" "fastighetsskatter" ;
  fastighetsskoetare_nn_1 = mkN "fastighetsskцtare" "fastighetsskцtare" ;
  fastighetstaxering_nn_1 = mkN "fastighetstaxering" ;
  fastlaast_av_1 = mkA "fastlеst" "fastlеst" ;
  fastlaenning_nn_1 = mkN "fastlдnning" ;
  fastlagsbulle_nn_1 = mkN "fastlagsbulle" utrum ;
  fastlagsris_nn_1 = mkN "fastlagsris" neutrum ;
  fastlagssoendag_nn_1 = mkN "fastlagssцndag" ;
  fastmer_ab_1 = mkAdv "fastmer" ;
  fastsaettning_nn_1 = mkN "fastsдttning" ;
  fastta_vb_1 = mkV "fastta" "fasttar" "fastta" "fasttog" "fasttagit" "fasttagen" ;
  fat_nn_1 = mkN "fat" neutrum ;
  fatabur_nn_1 = mkN "fatabur" "fataburer" ;
  fatal_av_1 = mkA "fatal" ;
  fataliedag_nn_1 = mkN "fataliedag" ;
  fatalietid_nn_1 = mkN "fatalietid" "fatalietider" ;
  fatalist_nn_1 = mkN "fatalist" "fatalister" ;
  fatalistisk_av_1 = mkA "fatalistisk" ;
  fatalitet_nn_1 = mkN "fatalitet" "fataliteter" ;
  fatbur_nn_1 = mkN "fatbur" "fatburer" ;
  fatt_ab_1 = mkAdv "fatt" ;
  fatt_av_1 = mkA "fatt" ;
  fattbar_av_1 = mkA "fattbar" ;
  fattbarhet_nn_1 = mkN "fattbarhet" "fattbarheter" ;
  fattig_av_1 = mkA "fattig" ;
  fattigdom_nn_1 = mkN "fattigdom" ;
  fattigdomsbevis_nn_1 = mkN "fattigdomsbevis" neutrum ;
  fattighjon_nn_1 = mkN "fattighjon" neutrum ;
  fattiglapp_nn_1 = mkN "fattiglapp" ;
  fattlig_av_1 = mkA "fattlig" ;
  fattning_nn_1 = mkN "fattning" ;
  faun_nn_1 = mkN "faun" "fauner" ;
  faunist_nn_1 = mkN "faunist" "faunister" ;
  faunistisk_av_1 = mkA "faunistisk" ;
  faute_nn_1 = mkN "faute" "fauter" ;
  favoer_nn_1 = mkN "favцr" "favцrer" ;
  favorit_nn_1 = mkN "favorit" "favoriter" ;
  favoritfoerfattare_nn_1 = mkN "favoritfцrfattare" "favoritfцrfattare" ;
  favoritraett_nn_1 = mkN "favoritrдtt" "favoritrдtter" ;
  favoritrestaurang_nn_1 = mkN "favoritrestaurang" "favoritrestauranger" ;
  fax_nn_1 = mkN "fax" ;
  fax_nn_2 = mkN "fax" neutrum ;
  fe_nn_1 = mkN "fe" "feer" ;
  featureprogram_nn_1 = mkN "featureprogram" "featureprogrammet" "featureprogram" "featureprogrammen" ;
  feber_nn_1 = mkN "feber" ;
  feberanfall_nn_1 = mkN "feberanfall" neutrum ;
  feberfri_av_1 = mkA "feberfri" "feberfritt" ;
  febersjukdom_nn_1 = mkN "febersjukdom" ;
  febertermometer_nn_1 = mkN "febertermometer" ;
  febrig_av_1 = mkA "febrig" ;
  febril_av_1 = mkA "febril" ;
  federal_av_1 = mkA "federal" ;
  federalist_nn_1 = mkN "federalist" "federalister" ;
  federalistisk_av_1 = mkA "federalistisk" ;
  federation_nn_1 = mkN "federation" "federationer" ;
  federativ_av_1 = mkA "federativ" ;
  feeri_nn_1 = mkN "feeri" "feerit" "feerier" "feerierna" ;
  feg_av_1 = mkA "feg" ;
  feghet_nn_1 = mkN "feghet" "fegheter" ;
  fegis_nn_1 = mkN "fegis" ;
  fejd_nn_1 = mkN "fejd" "fejder" ;
  fekal_av_1 = mkA "fekal" ;
  fel_av_1 = mkA "fel" ;
  fel_nn_1 = mkN "fel" neutrum ;
  felaktig_av_1 = mkA "felaktig" ;
  felaktighet_nn_1 = mkN "felaktighet" "felaktigheter" ;
  felbedoemning_nn_1 = mkN "felbedцmning" ;
  felberaekning_nn_1 = mkN "felberдkning" ;
  feldrag_nn_1 = mkN "feldrag" neutrum ;
  felfinnare_nn_1 = mkN "felfinnare" "felfinnare" ;
  felfri_av_1 = mkA "felfri" "felfritt" ;
  felgrepp_nn_1 = mkN "felgrepp" neutrum ;
  felhandling_nn_1 = mkN "felhandling" ;
  felmarginal_nn_1 = mkN "felmarginal" "felmarginaler" ;
  felparkering_nn_1 = mkN "felparkering" ;
  felprocent_nn_1 = mkN "felprocent" "felprocenten" "felprocent" "felprocenten" ;
  felraekningspeng_nn_1 = mkN "felrдkningspeng" ;
  felsaegning_nn_1 = mkN "felsдgning" ;
  felslagen_av_1 = mkA "felslagen" "felslaget" ;
  felslut_nn_1 = mkN "felslut" neutrum ;
  felsteg_nn_1 = mkN "felsteg" neutrum ;
  femaarig_av_1 = mkA "femеrig" ;
  femaarsplan_nn_1 = mkN "femеrsplan" "femеrsplaner" ;
  femaktare_nn_1 = mkN "femaktare" "femaktare" ;
  femdagarsvecka_nn_1 = mkN "femdagarsvecka" ;
  femdygnsprognos_nn_1 = mkN "femdygnsprognos" "femdygnsprognoser" ;
  feminin_av_1 = mkA "feminin" ;
  femininum_nn_1 = mkN "femininum" "femininet" "femininer" "femininerna" ;
  feminist_nn_1 = mkN "feminist" "feminister" ;
  feministisk_av_1 = mkA "feministisk" ;
  femkamp_nn_1 = mkN "femkamp" "femkamper" ;
  femling_nn_1 = mkN "femling" ;
  femoering_nn_1 = mkN "femцring" ;
  femstaemmig_av_1 = mkA "femstдmmig" ;
  femtedel_nn_1 = mkN "femtedel" "femtedelen" "femtedelar" "femtedelarna" ;
  femtekolonn_nn_1 = mkN "femtekolonn" "femtekolonner" ;
  femtekolonnare_nn_1 = mkN "femtekolonnare" "femtekolonnare" ;
  femtiaarsdag_nn_1 = mkN "femtiеrsdag" ;
  femtikronorssedel_nn_1 = mkN "femtikronorssedel" ;
  femtilapp_nn_1 = mkN "femtilapp" ;
  femtioaarsdag_nn_1 = mkN "femtioеrsdag" ;
  femtioering_nn_1 = mkN "femtiцring" ;
  femtiokronorssedel_nn_1 = mkN "femtiokronorssedel" ;
  femtiooering_nn_1 = mkN "femtioцring" ;
  femtiotal_nn_1 = mkN "femtiotal" "femtiotalet" "femtiotalen" "femtiotalena" ;
  femtiotalist_nn_1 = mkN "femtiotalist" "femtiotalister" ;
  femtital_nn_1 = mkN "femtital" "femtitalet" "femtitalen" "femtitalena" ;
  femtitalist_nn_1 = mkN "femtitalist" "femtitalister" ;
  femtonhundrameterslopp_nn_1 = mkN "femtonhundrameterslopp" neutrum ;
  femuddig_av_1 = mkA "femuddig" ;
  fena_av_1 = mkA "fena" ;
  fender_nn_1 = mkN "fender" ;
  fendert_nn_1 = mkN "fendert" ;
  fenedrin_nn_1 = mkN "fenedrin" "fenedriner" ;
  fenicier_nn_1 = mkN "fenicier" "feniciern" "fenicier" "fenicierna" ;
  fenicisk_av_1 = mkA "fenicisk" ;
  fenkoel_nn_1 = mkN "fenkцl" ;
  fenmetralin_nn_1 = mkN "fenmetralin" "fenmetraliner" ;
  fennicism_nn_1 = mkN "fennicism" "fennicismer" ;
  fennoman_nn_1 = mkN "fennoman" "fennomaner" ;
  fenol_nn_1 = mkN "fenol" "fenoler" ;
  fenolftalein_nn_1 = mkN "fenolftalein" "fenolftaleiner" ;
  fenolisk_av_1 = mkA "fenolisk" ;
  fenomen_nn_1 = mkN "fenomen" neutrum ;
  fenomenal_av_1 = mkA "fenomenal" ;
  fenomenologisk_av_1 = mkA "fenomenologisk" ;
  fenoplast_nn_1 = mkN "fenoplast" "fenoplaster" ;
  fenotyp_nn_1 = mkN "fenotyp" "fenotyper" ;
  fenval_nn_1 = mkN "fenval" ;
  feodal_av_1 = mkA "feodal" ;
  ferie_nn_1 = mkN "ferie" "ferier" ;
  ferm_av_1 = mkA "ferm" ;
  fermat_nn_1 = mkN "fermat" neutrum ;
  ferment_nn_1 = mkN "ferment" neutrum ;
  fermitet_nn_1 = mkN "fermitet" "fermiteter" ;
  ferrit_nn_1 = mkN "ferrit" "ferriter" ;
  ferrolegering_nn_1 = mkN "ferrolegering" ;
  fertil_av_1 = mkA "fertil" ;
  fertilitet_nn_1 = mkN "fertilitet" "fertiliteter" ;
  fest_nn_1 = mkN "fest" "fester" ;
  festande_nn_1 = mkN "festande" ;
  festarrangoer_nn_1 = mkN "festarrangцr" "festarrangцrer" ;
  festbord_nn_1 = mkN "festbord" neutrum ;
  festival_nn_1 = mkN "festival" "festivaler" ;
  festivitet_nn_1 = mkN "festivitet" "festiviteter" ;
  festklaenning_nn_1 = mkN "festklдnning" ;
  festkvaell_nn_1 = mkN "festkvдll" ;
  festlig_av_1 = mkA "festlig" ;
  festlighet_nn_1 = mkN "festlighet" "festligheter" ;
  festmaaltid_nn_1 = mkN "festmеltid" "festmеltider" ;
  festmiddag_nn_1 = mkN "festmiddag" ;
  feston_nn_1 = mkN "feston" "festoner" ;
  festong_nn_1 = mkN "festong" "festonger" ;
  festprisse_nn_1 = mkN "festprisse" utrum ;
  festskrift_nn_1 = mkN "festskrift" "festskrifter" ;
  festspel_nn_1 = mkN "festspel" "festspelet" "festspel" "festspelen" ;
  feststaemning_nn_1 = mkN "feststдmning" ;
  festtaag_nn_1 = mkN "festtеg" neutrum ;
  festvaaning_nn_1 = mkN "festvеning" ;
  fet_av_1 = mkA "fet" ;
  fetblad_nn_1 = mkN "fetblad" neutrum ;
  fetisch_nn_1 = mkN "fetisch" "fetischer" ;
  fetischist_nn_1 = mkN "fetischist" "fetischister" ;
  fetknopp_nn_1 = mkN "fetknopp" ;
  fetlagd_av_1 = mkA "fetlagd" "fetlagt" ;
  fets_nn_1 = mkN "fets" "fetser" ;
  fetsill_nn_1 = mkN "fetsill" ;
  fetstil_nn_1 = mkN "fetstil" ;
  fett_nn_1 = mkN "fett" "fettet" "fetter" "fetterna" ;
  fettaemne_nn_1 = mkN "fettдmne" ;
  fetthaerdning_nn_1 = mkN "fetthдrdning" ;
  fetthalt_nn_1 = mkN "fetthalt" "fetthalter" ;
  fetthaltig_av_1 = mkA "fetthaltig" ;
  fettisdag_nn_1 = mkN "fettisdag" ;
  fettisdagsbulle_nn_1 = mkN "fettisdagsbulle" utrum ;
  fettkoertel_nn_1 = mkN "fettkцrtel" ;
  fettlever_nn_1 = mkN "fettlever" ;
  fettloesande_av_1 = mkA "fettlцsande" ;
  fettloeslig_av_1 = mkA "fettlцslig" ;
  fettloeslighet_nn_1 = mkN "fettlцslighet" "fettlцsligheter" ;
  fetto_nn_1 = mkN "fetto" "fettot" "fetton" "fettona" ;
  fettreserv_nn_1 = mkN "fettreserv" "fettreserver" ;
  fettrik_av_1 = mkA "fettrik" ;
  fettsvansfaar_nn_1 = mkN "fettsvansfеr" neutrum ;
  fettvaevnad_nn_1 = mkN "fettvдvnad" "fettvдvnader" ;
  fettvalk_nn_1 = mkN "fettvalk" ;
  fez_nn_1 = mkN "fez" "fezer" ;
  fial_nn_1 = mkN "fial" "fialer" ;
  fiasko_nn_1 = mkN "fiasko" "fiaskot" "fiaskon" "fiaskona" ;
  fibbla_nn_1 = mkN "fibbla" ;
  fiber_nn_1 = mkN "fiber" "fibern" "fibrer" "fibrerna" ;
  fiberrik_av_1 = mkA "fiberrik" ;
  fiberspik_nn_1 = mkN "fiberspik" ;
  fibervaext_nn_1 = mkN "fibervдxt" "fibervдxter" ;
  fibrig_av_1 = mkA "fibrig" ;
  fibrill_nn_1 = mkN "fibrill" "fibriller" ;
  fibrin_nn_1 = mkN "fibrin" neutrum ;
  fickformat_nn_1 = mkN "fickformat" neutrum ;
  fickhandbok_nn_1 = mkN "fickhandbok" "fickhandbцcker" ;
  fickkalkylator_nn_1 = mkN "fickkalkylator" "fickkalkylatorer" ;
  fickkniv_nn_1 = mkN "fickkniv" ;
  fickpeng_nn_1 = mkN "fickpeng" ;
  fickspegel_nn_1 = mkN "fickspegel" ;
  ficktjuv_nn_1 = mkN "ficktjuv" ;
  fickur_nn_1 = mkN "fickur" neutrum ;
  fiction_novell_nn_1 = mkN "fiction-novell" "fiction-noveller" ;
  fideikommiss_nn_1 = mkN "fideikommiss" neutrum ;
  fidjian_nn_1 = mkN "fidjian" "fidjianer" ;
  fidus_nn_1 = mkN "fidus" ;
  fiende_nn_1 = mkN "fiende" "fiender" ;
  fiendskap_nn_1 = mkN "fiendskap" "fiendskaper" ;
  fientlig_av_1 = mkA "fientlig" ;
  fientlighet_nn_1 = mkN "fientlighet" "fientligheter" ;
  fiffig_av_1 = mkA "fiffig" ;
  fifflare_nn_1 = mkN "fifflare" "fifflare" ;
  fight_nn_1 = mkN "fight" "fighter" ;
  fighter_nn_1 = mkN "fighter" "fightern" "fighter" "fighterna" ;
  figur_nn_1 = mkN "figur" "figurer" ;
  figuraakning_nn_1 = mkN "figurеkning" ;
  figurant_nn_1 = mkN "figurant" "figuranter" ;
  figuration_nn_1 = mkN "figuration" "figurationer" ;
  figurativ_av_1 = mkA "figurativ" ;
  figurlig_av_1 = mkA "figurlig" ;
  figursydd_av_1 = mkA "figursydd" "figursydtt" ;
  fijian_nn_1 = mkN "fijian" "fijianer" ;
  fik_nn_1 = mkN "fik" neutrum ;
  fiken_av_1 = mkA "fiken" "fiket" ;
  fikon_nn_1 = mkN "fikon" neutrum ;
  fikonloev_nn_1 = mkN "fikonlцv" neutrum ;
  fikonspraak_nn_1 = mkN "fikonsprеk" neutrum ;
  fikontraed_nn_1 = mkN "fikontrдd" neutrum ;
  fiktion_nn_1 = mkN "fiktion" "fiktioner" ;
  fiktiv_av_1 = mkA "fiktiv" ;
  fikus_nn_1 = mkN "fikus" ;
  fil_nn_1 = mkN "fil" "filer" ;
  fil_nn_2 = mkN "fil" ;
  filantrop_nn_1 = mkN "filantrop" "filantroper" ;
  filantropisk_av_1 = mkA "filantropisk" ;
  filatelist_nn_1 = mkN "filatelist" "filatelister" ;
  filbunke_nn_1 = mkN "filbunke" utrum ;
  file_nn_1 = mkN "filй" "filйer" ;
  filharmoniker_nn_1 = mkN "filharmoniker" "filharmonikern" "filharmoniker" "filharmonikerna" ;
  filharmonisk_av_1 = mkA "filharmonisk" ;
  filial_nn_1 = mkN "filial" "filialer" ;
  filibuster_nn_1 = mkN "filibuster" ;
  filibustring_nn_1 = mkN "filibustring" ;
  filigran_nn_1 = mkN "filigran" neutrum ;
  filipin_nn_1 = mkN "filipin" "filipiner" ;
  filippik_nn_1 = mkN "filippik" "filippiker" ;
  filippinare_nn_1 = mkN "filippinare" "filippinare" ;
  filippinsk_av_1 = mkA "filippinsk" ;
  filiste_nn_1 = mkN "filistй" "filistйer" ;
  filister_nn_1 = mkN "filister" ;
  filistroes_av_1 = mkA "filistrцs" ;
  filklove_nn_1 = mkN "filklove" utrum ;
  filkoerning_nn_1 = mkN "filkцrning" ;
  film_nn_1 = mkN "film" "filmer" ;
  filmare_nn_1 = mkN "filmare" "filmare" ;
  filmatelje_nn_1 = mkN "filmateljй" "filmateljйer" ;
  filmatisk_av_1 = mkA "filmatisk" ;
  filmbild_nn_1 = mkN "filmbild" "filmbilder" ;
  filmexpert_nn_1 = mkN "filmexpert" "filmexperter" ;
  filmfars_nn_1 = mkN "filmfars" "filmfarser" ;
  filmfotograf_nn_1 = mkN "filmfotograf" "filmfotografer" ;
  filmframkallning_nn_1 = mkN "filmframkallning" ;
  filmgranskning_nn_1 = mkN "filmgranskning" ;
  filmhistoria_nn_1 = mkN "filmhistoria" "filmhistorien" "filmhistorier" "filmhistorierna" ;
  filminspelning_nn_1 = mkN "filminspelning" ;
  filmisk_av_1 = mkA "filmisk" ;
  filmkamera_nn_1 = mkN "filmkamera" ;
  filmkomedi_nn_1 = mkN "filmkomedi" "filmkomedier" ;
  filmmanuskript_nn_1 = mkN "filmmanuskript" neutrum ;
  filmning_nn_1 = mkN "filmning" ;
  filmotek_nn_1 = mkN "filmotek" neutrum ;
  filmpremiaer_nn_1 = mkN "filmpremiдr" "filmpremiдrer" ;
  filmregissoer_nn_1 = mkN "filmregissцr" "filmregissцrer" ;
  filmrulle_nn_1 = mkN "filmrulle" utrum ;
  filmscen_nn_1 = mkN "filmscen" "filmscener" ;
  filmskaadespelare_nn_1 = mkN "filmskеdespelare" "filmskеdespelare" ;
  filmskapare_nn_1 = mkN "filmskapare" "filmskapare" ;
  filmstudio_nn_1 = mkN "filmstudio" "filmstudior" ;
  filmtecknare_nn_1 = mkN "filmtecknare" "filmtecknare" ;
  filolog_nn_1 = mkN "filolog" "filologer" ;
  filologi_nn_1 = mkN "filologi" "filologier" ;
  filologisk_av_1 = mkA "filologisk" ;
  filosof_nn_1 = mkN "filosof" "filosofer" ;
  filosofem_nn_1 = mkN "filosofem" neutrum ;
  filosofi_nn_1 = mkN "filosofi" "filosofier" ;
  filosofie_av_1 = mkA "filosofie" ;
  filosofisk_av_1 = mkA "filosofisk" ;
  filspaan_nn_1 = mkN "filspеn" neutrum ;
  filt_nn_1 = mkN "filt" ;
  filter_nn_1 = mkN "filter" neutrum ;
  filtercigarett_nn_1 = mkN "filtercigarett" "filtercigaretter" ;
  filterpaase_nn_1 = mkN "filterpеse" utrum ;
  filtrat_nn_1 = mkN "filtrat" neutrum ;
  filtrerpapper_nn_1 = mkN "filtrerpapper" neutrum ;
  filtspets_nn_1 = mkN "filtspets" ;
  filttoffel_nn_1 = mkN "filttoffel" "filttoffeln" "filttofflor" "filttofflorna" ;
  filur_nn_1 = mkN "filur" "filurer" ;
  fimbulvinter_nn_1 = mkN "fimbulvinter" ;
  fimmelstaang_nn_1 = mkN "fimmelstеng" "fimmelstдnger" ;
  fimp_nn_1 = mkN "fimp" ;
  fin_av_1 = mkA "fin" ;
  final_av_1 = mkA "final" ;
  final_nn_1 = mkN "final" "finaler" ;
  finalist_nn_1 = mkN "finalist" "finalister" ;
  finansdebatt_nn_1 = mkN "finansdebatt" "finansdebatter" ;
  finansdepartement_nn_1 = mkN "finansdepartement" "finansdepartementet" "finansdepartementen" "finansdepartementena" ;
  finansiaer_nn_1 = mkN "finansiдr" "finansiдrer" ;
  finansiell_av_1 = mkA "finansiell" ;
  finansiering_nn_1 = mkN "finansiering" ;
  finansman_nn_1 = mkN "finansman" "finansmannen" "finansmдn" "finansmдnnen" ;
  finansminister_nn_1 = mkN "finansminister" ;
  finansplan_nn_1 = mkN "finansplan" "finansplaner" ;
  finansvalp_nn_1 = mkN "finansvalp" ;
  finemang_ab_1 = mkAdv "finemang" ;
  finess_nn_1 = mkN "finess" "finesser" ;
  finfin_av_1 = mkA "finfin" ;
  finger_nn_1 = mkN "finger" ;
  fingeravtryck_nn_1 = mkN "fingeravtryck" neutrum ;
  fingerboejarmuskel_nn_1 = mkN "fingerbцjarmuskel" "fingerbцjarmuskeln" "fingerbцjarmuskler" "fingerbцjarmusklerna" ;
  fingerborg_nn_1 = mkN "fingerborg" ;
  fingerfaerdig_av_1 = mkA "fingerfдrdig" ;
  fingerfaerg_nn_1 = mkN "fingerfдrg" "fingerfдrger" ;
  fingerhud_nn_1 = mkN "fingerhud" ;
  fingerled_nn_1 = mkN "fingerled" "fingerleder" ;
  fingernerv_nn_1 = mkN "fingernerv" "fingernerver" ;
  fingeroert_nn_1 = mkN "fingerцrt" "fingerцrter" ;
  fingerprov_nn_1 = mkN "fingerprov" neutrum ;
  fingerring_nn_1 = mkN "fingerring" ;
  fingersaettning_nn_1 = mkN "fingersдttning" ;
  fingerstraeckarmuskel_nn_1 = mkN "fingerstrдckarmuskel" "fingerstrдckarmuskeln" "fingerstrдckarmuskler" "fingerstrдckarmusklerna" ;
  fingersvamp_nn_1 = mkN "fingersvamp" ;
  fingertopp_nn_1 = mkN "fingertopp" ;
  fingervante_nn_1 = mkN "fingervante" utrum ;
  fingervisning_nn_1 = mkN "fingervisning" ;
  finhyllt_av_1 = mkA "finhyllt" "finhyllt" ;
  finish_nn_1 = mkN "finish" ;
  finit_av_1 = mkA "finit" "finit" ;
  fink_nn_1 = mkN "fink" ;
  finkaensla_nn_1 = mkN "finkдnsla" ;
  finkaenslig_av_1 = mkA "finkдnslig" ;
  finkaenslighet_nn_1 = mkN "finkдnslighet" "finkдnsligheter" ;
  finkalibrig_av_1 = mkA "finkalibrig" ;
  finkart_nn_1 = mkN "finkart" "finkarter" ;
  finkelolja_nn_1 = mkN "finkelolja" ;
  finkfaagel_nn_1 = mkN "finkfеgel" ;
  finklaedd_av_1 = mkA "finklдdd" "finklдdtt" ;
  finkornig_av_1 = mkA "finkornig" ;
  finkunge_nn_1 = mkN "finkunge" utrum ;
  finlaendare_nn_1 = mkN "finlдndare" "finlдndare" ;
  finlaendsk_av_1 = mkA "finlдndsk" ;
  finlaendska_nn_1 = mkN "finlдndska" ;
  finlandism_nn_1 = mkN "finlandism" "finlandismer" ;
  finlandssvensk_av_1 = mkA "finlandssvensk" ;
  finlandssvensk_nn_1 = mkN "finlandssvensk" ;
  finlandssvenska_nn_2 = mkN "finlandssvenska" ;
  finlek_nn_1 = mkN "finlek" ;
  finmaskig_av_1 = mkA "finmaskig" ;
  finmekaniker_nn_1 = mkN "finmekaniker" "finmekanikern" "finmekaniker" "finmekanikerna" ;
  finmekanisk_av_1 = mkA "finmekanisk" ;
  finna_vb_1 = mkV "finna" "fann" "funnit" ;
  finne_nn_1 = mkN "finne" utrum ;
  finnig_av_1 = mkA "finnig" ;
  finnjolle_nn_1 = mkN "finnjolle" utrum ;
  finnmark_nn_1 = mkN "finnmark" "finnmarker" ;
  finrum_nn_1 = mkN "finrum" "finrummet" "finrum" "finrummen" ;
  finsk_av_1 = mkA "finsk" ;
  finsk_ugrisk_av_1 = mkA "finsk-ugrisk" ;
  finska_nn_2 = mkN "finska" ;
  finskhet_nn_1 = mkN "finskhet" "finskheter" ;
  finsko_nn_1 = mkN "finsko" "finskor" ;
  finsmakare_nn_1 = mkN "finsmakare" "finsmakare" ;
  finsmide_nn_1 = mkN "finsmide" ;
  finsnickare_nn_1 = mkN "finsnickare" "finsnickare" ;
  finsnickeri_nn_1 = mkN "finsnickeri" "finsnickerit" "finsnickerier" "finsnickerierna" ;
  finspunnen_av_1 = mkA "finspunnen" "finspunnet" "finspunna" "finspunna" "finspunnare" "finspunnast" "finspunnaste" ;
  finstaemd_av_1 = mkA "finstдmd" "finstдmt" ;
  finstilt_av_1 = mkA "finstilt" "finstilt" ;
  finstruktur_nn_1 = mkN "finstruktur" "finstrukturer" ;
  fint_nn_1 = mkN "fint" "finter" ;
  fintlig_av_1 = mkA "fintlig" ;
  fintvaett_nn_1 = mkN "fintvдtt" ;
  finurlig_av_1 = mkA "finurlig" ;
  fiol_nn_1 = mkN "fiol" "fioler" ;
  fiolblock_nn_1 = mkN "fiolblock" neutrum ;
  fiolspelare_nn_1 = mkN "fiolspelare" "fiolspelare" ;
  fiolstraeng_nn_1 = mkN "fiolstrдng" ;
  fioritur_nn_1 = mkN "fioritur" "fioriturer" ;
  fipplig_av_1 = mkA "fipplig" ;
  firma_nn_1 = mkN "firma" ;
  firmafest_nn_1 = mkN "firmafest" "firmafester" ;
  firmamaerke_nn_1 = mkN "firmamдrke" ;
  firmanamn_nn_1 = mkN "firmanamn" neutrum ;
  firmatecknare_nn_1 = mkN "firmatecknare" "firmatecknare" ;
  firmateckning_nn_1 = mkN "firmateckning" ;
  firngraens_nn_1 = mkN "firngrдns" "firngrдnser" ;
  firre_nn_1 = mkN "firre" utrum ;
  fis_nn_1 = mkN "fis" ;
  fischy_nn_1 = mkN "fischy" "fischyer" ;
  fisfoernaem_av_1 = mkA "fisfцrnдm" ;
  fisig_av_1 = mkA "fisig" ;
  fisk_nn_1 = mkN "fisk" ;
  fiskaadra_nn_1 = mkN "fiskеdra" ;
  fiskal_av_1 = mkA "fiskal" ;
  fiskalisk_av_1 = mkA "fiskalisk" ;
  fiskare_nn_1 = mkN "fiskare" "fiskare" ;
  fiskart_nn_1 = mkN "fiskart" "fiskarter" ;
  fiskben_nn_1 = mkN "fiskben" neutrum ;
  fiskbensmoenster_nn_1 = mkN "fiskbensmцnster" neutrum ;
  fiskbulle_nn_1 = mkN "fiskbulle" utrum ;
  fiskdamm_nn_1 = mkN "fiskdamm" ;
  fiske_nn_1 = mkN "fiske" ;
  fiskebaat_nn_1 = mkN "fiskebеt" ;
  fiskebank_nn_1 = mkN "fiskebank" ;
  fiskedrag_nn_1 = mkN "fiskedrag" neutrum ;
  fiskefartyg_nn_1 = mkN "fiskefartyg" neutrum ;
  fiskegraens_nn_1 = mkN "fiskegrдns" "fiskegrдnser" ;
  fiskekort_nn_1 = mkN "fiskekort" neutrum ;
  fiskekrok_nn_1 = mkN "fiskekrok" ;
  fiskelaege_nn_1 = mkN "fiskelдge" ;
  fiskelag_nn_1 = mkN "fiskelag" ;
  fiskenaet_nn_1 = mkN "fiskenдt" neutrum ;
  fiskenation_nn_1 = mkN "fiskenation" "fiskenationer" ;
  fiskeredskap_nn_1 = mkN "fiskeredskap" "fiskeredskapet" "fiskeredskapen" "fiskeredskapena" ;
  fiskeri_nn_1 = mkN "fiskeri" "fiskerit" "fiskerier" "fiskerierna" ;
  fiskeristyrelse_nn_1 = mkN "fiskeristyrelse" "fiskeristyrelser" ;
  fiskevatten_nn_1 = mkN "fiskevatten" "fiskevattnet" "fiskevatten" "fiskevattnen" ;
  fiskezon_nn_1 = mkN "fiskezon" "fiskezoner" ;
  fiskfile_nn_1 = mkN "fiskfilй" "fiskfilйer" ;
  fiskgjuse_nn_1 = mkN "fiskgjuse" utrum ;
  fiskhamn_nn_1 = mkN "fiskhamn" ;
  fiskkrok_nn_1 = mkN "fiskkrok" ;
  fiskmaas_nn_1 = mkN "fiskmеs" ;
  fiskmun_nn_1 = mkN "fiskmun" "fiskmunnen" "fiskmunnar" "fiskmunnarna" ;
  fisknaet_nn_1 = mkN "fisknдt" neutrum ;
  fisknot_nn_1 = mkN "fisknot" ;
  fiskodling_nn_1 = mkN "fiskodling" ;
  fiskoega_nn_1 = mkN "fiskцga" "fiskцgat" "fiskцgon" "fiskцgonen" ;
  fiskpinne_nn_1 = mkN "fiskpinne" utrum ;
  fiskpudding_nn_1 = mkN "fiskpudding" ;
  fiskredskap_nn_1 = mkN "fiskredskap" "fiskredskapet" "fiskredskapen" "fiskredskapena" ;
  fiskstim_nn_1 = mkN "fiskstim" "fiskstimmet" "fiskstim" "fiskstimmen" ;
  fisksump_nn_1 = mkN "fisksump" ;
  fisktom_av_1 = mkA "fisktom" "fisktomt" "fisktomma" "fisktomma" "fisktommare" "fisktommast" "fisktommaste" ;
  fiskvandring_nn_1 = mkN "fiskvandring" ;
  fiskyngel_nn_1 = mkN "fiskyngel" neutrum ;
  fissil_av_1 = mkA "fissil" ;
  fission_nn_1 = mkN "fission" "fissioner" ;
  fissur_nn_1 = mkN "fissur" "fissurer" ;
  fistel_nn_1 = mkN "fistel" ;
  fistuloes_av_1 = mkA "fistulцs" ;
  fix_av_1 = mkA "fix" ;
  fixare_nn_1 = mkN "fixare" "fixare" ;
  fixativ_nn_1 = mkN "fixativ" neutrum ;
  fixerbad_nn_1 = mkN "fixerbad" neutrum ;
  fixering_nn_1 = mkN "fixering" ;
  fixeringsbild_nn_1 = mkN "fixeringsbild" "fixeringsbilder" ;
  fixpunkt_nn_1 = mkN "fixpunkt" "fixpunkter" ;
  fixtur_nn_1 = mkN "fixtur" "fixturer" ;
  fjaeder_nn_1 = mkN "fjдder" ;
  fjaederboll_nn_1 = mkN "fjдderboll" ;
  fjaederbuske_nn_1 = mkN "fjдderbuske" utrum ;
  fjaederdraekt_nn_1 = mkN "fjдderdrдkt" "fjдderdrдkter" ;
  fjaederfae_nn_1 = mkN "fjдderfд" "fjдderfдet" "fjдderfдn" "fjдderfдna" ;
  fjaederklaedd_av_1 = mkA "fjдderklдdd" ;
  fjaederlaett_av_1 = mkA "fjдderlдtt" ;
  fjaedermoln_nn_1 = mkN "fjдdermoln" neutrum ;
  fjaederpensel_nn_1 = mkN "fjдderpensel" ;
  fjaederskrud_nn_1 = mkN "fjдderskrud" ;
  fjaedertyp_nn_1 = mkN "fjдdertyp" "fjдdertyper" ;
  fjaedervaag_nn_1 = mkN "fjдdervеg" ;
  fjaedervinge_nn_1 = mkN "fjдdervinge" utrum ;
  fjaedring_nn_1 = mkN "fjдdring" ;
  fjaell_nn_1 = mkN "fjдll" neutrum ;
  fjaellaemmel_nn_1 = mkN "fjдllдmmel" "fjдllдmmeln" "fjдllдmmlar" "fjдllдmmlarna" ;
  fjaellbaeck_nn_1 = mkN "fjдllbдck" ;
  fjaellbjoerk_nn_1 = mkN "fjдllbjцrk" ;
  fjaellbrud_nn_1 = mkN "fjдllbrud" ;
  fjaellig_av_1 = mkA "fjдllig" ;
  fjaellik_av_1 = mkA "fjдllik" ;
  fjaellkedja_nn_1 = mkN "fjдllkedja" ;
  fjaellnaera_av_1 = mkA "fjдllnдra" ;
  fjaellpansar_nn_1 = mkN "fjдllpansar" neutrum ;
  fjaellpipare_nn_1 = mkN "fjдllpipare" "fjдllpipare" ;
  fjaellplataa_nn_1 = mkN "fjдllplatе" "fjдllplatеer" ;
  fjaellraev_nn_1 = mkN "fjдllrдv" ;
  fjaellskivling_nn_1 = mkN "fjдllskivling" ;
  fjaelltrakt_nn_1 = mkN "fjдlltrakt" "fjдlltrakter" ;
  fjaellturist_nn_1 = mkN "fjдllturist" "fjдllturister" ;
  fjaellvaerld_nn_1 = mkN "fjдllvдrld" ;
  fjaellvandrare_nn_1 = mkN "fjдllvandrare" "fjдllvandrare" ;
  fjaellvandring_nn_1 = mkN "fjдllvandring" ;
  fjaellvraak_nn_1 = mkN "fjдllvrеk" ;
  fjaelster_nn_1 = mkN "fjдlster" neutrum ;
  fjaer_av_1 = mkA "fjдr" ;
  fjaerd_nn_1 = mkN "fjдrd" ;
  fjaerdedel_nn_1 = mkN "fjдrdedel" "fjдrdedelen" "fjдrdedelar" "fjдrdedelarna" ;
  fjaerding_nn_1 = mkN "fjдrding" ;
  fjaerdingsman_nn_1 = mkN "fjдrdingsman" "fjдrdingsmannen" "fjдrdingsmдn" "fjдrdingsmдnnen" ;
  fjaerdingsvaeg_nn_1 = mkN "fjдrdingsvдg" "fjдrdingsvдgen" "fjдrdingsvдg" "fjдrdingsvдgen" ;
  fjaeril_nn_1 = mkN "fjдril" ;
  fjaerilsart_nn_1 = mkN "fjдrilsart" "fjдrilsarter" ;
  fjaerran_ab_1 = mkAdv "fjдrran" ;
  fjaerran_av_1 = mkA "fjдrran" ;
  fjaerrblockering_nn_1 = mkN "fjдrrblockering" ;
  fjaerrkontroll_nn_1 = mkN "fjдrrkontroll" "fjдrrkontroller" ;
  fjaerrpunkt_nn_1 = mkN "fjдrrpunkt" "fjдrrpunkter" ;
  fjaerrseende_av_1 = mkA "fjдrrseende" ;
  fjaerrskaadande_av_1 = mkA "fjдrrskеdande" ;
  fjaerrskaadare_nn_1 = mkN "fjдrrskеdare" "fjдrrskеdare" ;
  fjaerrskrivare_nn_1 = mkN "fjдrrskrivare" "fjдrrskrivare" ;
  fjaerrskrivmaskin_nn_1 = mkN "fjдrrskrivmaskin" "fjдrrskrivmaskiner" ;
  fjaerrstyrd_av_1 = mkA "fjдrrstyrd" "fjдrrstyrt" ;
  fjaerrtaag_nn_1 = mkN "fjдrrtеg" neutrum ;
  fjaert_nn_1 = mkN "fjдrt" ;
  fjaesker_nn_1 = mkN "fjдsker" ;
  fjaeskig_av_1 = mkA "fjдskig" ;
  fjaet_nn_1 = mkN "fjдt" neutrum ;
  fjant_nn_1 = mkN "fjant" ;
  fjanteri_nn_1 = mkN "fjanteri" "fjanterit" "fjanterier" "fjanterierna" ;
  fjantig_av_1 = mkA "fjantig" ;
  fjoel_nn_1 = mkN "fjцl" ;
  fjolaar_nn_1 = mkN "fjolеr" neutrum ;
  fjolaarsgraes_nn_1 = mkN "fjolеrsgrдs" neutrum ;
  fjolleri_nn_1 = mkN "fjolleri" "fjollerit" "fjollerier" "fjollerierna" ;
  fjollig_av_1 = mkA "fjollig" ;
  fjomperi_nn_1 = mkN "fjomperi" "fjomperit" "fjomperier" "fjomperierna" ;
  fjompig_av_1 = mkA "fjompig" ;
  fjord_nn_1 = mkN "fjord" ;
  fjordhaest_nn_1 = mkN "fjordhдst" ;
  fjording_nn_1 = mkN "fjording" ;
  fjun_nn_1 = mkN "fjun" neutrum ;
  fjunig_av_1 = mkA "fjunig" ;
  fjuttig_av_1 = mkA "fjuttig" ;
  flaabuse_nn_1 = mkN "flеbuse" utrum ;
  flaasig_av_1 = mkA "flеsig" ;
  flabb_nn_1 = mkN "flabb" ;
  flabb_nn_2 = mkN "flabb" neutrum ;
  flabbig_av_1 = mkA "flabbig" ;
  flack_av_1 = mkA "flack" ;
  flackbanepjaes_nn_1 = mkN "flackbanepjдs" "flackbanepjдser" ;
  fladdermus_nn_1 = mkN "fladdermus" "fladdermusen" "fladdermцss" "fladdermцssen" ;
  fladdrig_av_1 = mkA "fladdrig" ;
  flaeck_nn_1 = mkN "flдck" ;
  flaeckborttagning_nn_1 = mkN "flдckborttagning" ;
  flaeckborttagningsmedel_nn_1 = mkN "flдckborttagningsmedel" neutrum ;
  flaeckfri_av_1 = mkA "flдckfri" "flдckfritt" ;
  flaeckig_av_1 = mkA "flдckig" ;
  flaeckvis_ab_1 = mkAdv "flдckvis" ;
  flaeder_nn_1 = mkN "flдder" ;
  flaederbaer_nn_1 = mkN "flдderbдr" neutrum ;
  flaedermus_nn_1 = mkN "flдdermus" "flдdermusen" "flдdermцss" "flдdermцssen" ;
  flaekt_nn_1 = mkN "flдkt" ;
  flaengig_av_1 = mkA "flдngig" ;
  flaens_nn_1 = mkN "flдns" ;
  flaerdfri_av_1 = mkA "flдrdfri" "flдrdfritt" ;
  flaerdfull_av_1 = mkA "flдrdfull" ;
  flaeskaenger_nn_1 = mkN "flдskдnger" ;
  flaeskfile_nn_1 = mkN "flдskfilй" "flдskfilйer" ;
  flaeskhare_nn_1 = mkN "flдskhare" utrum ;
  flaeskig_av_1 = mkA "flдskig" ;
  flaeskkarre_nn_1 = mkN "flдskkarrй" "flдskkarrйer" ;
  flaeskkorv_nn_1 = mkN "flдskkorv" ;
  flaeskkotlett_nn_1 = mkN "flдskkotlett" "flдskkotletter" ;
  flaesklaegg_nn_1 = mkN "flдsklдgg" ;
  flaesklaepp_nn_1 = mkN "flдsklдpp" ;
  flaesktaerning_nn_1 = mkN "flдsktдrning" ;
  flaetverk_nn_1 = mkN "flдtverk" neutrum ;
  flagell_nn_1 = mkN "flagell" "flageller" ;
  flagellant_nn_1 = mkN "flagellant" "flagellanter" ;
  flagellat_nn_1 = mkN "flagellat" "flagellater" ;
  flageolett_nn_1 = mkN "flageolett" "flageoletter" ;
  flaggdag_nn_1 = mkN "flaggdag" ;
  flaggkapten_nn_1 = mkN "flaggkapten" "flaggkaptener" ;
  flaggman_nn_1 = mkN "flaggman" "flaggmannen" "flaggmдn" "flaggmдnnen" ;
  flaggning_nn_1 = mkN "flaggning" ;
  flaggskepp_nn_1 = mkN "flaggskepp" neutrum ;
  flaggspel_nn_1 = mkN "flaggspel" "flaggspelet" "flaggspel" "flaggspelen" ;
  flaggstaang_nn_1 = mkN "flaggstеng" "flaggstдnger" ;
  flagig_av_1 = mkA "flagig" ;
  flagrant_av_1 = mkA "flagrant" "flagrant" ;
  flak_nn_1 = mkN "flak" neutrum ;
  flakong_nn_1 = mkN "flakong" "flakonger" ;
  flamenco_nn_1 = mkN "flamenco" "flamencor" ;
  flamingo_nn_1 = mkN "flamingo" "flamingor" ;
  flamlaendare_nn_1 = mkN "flamlдndare" "flamlдndare" ;
  flamlaendsk_av_1 = mkA "flamlдndsk" ;
  flamlaendska_nn_2 = mkN "flamlдndska" ;
  flammig_av_1 = mkA "flammig" ;
  flampunkt_nn_1 = mkN "flampunkt" "flampunkter" ;
  flamsig_av_1 = mkA "flamsig" ;
  flamsk_av_1 = mkA "flamsk" ;
  flamskvaevnad_nn_1 = mkN "flamskvдvnad" "flamskvдvnader" ;
  flamskyddsmedel_nn_1 = mkN "flamskyddsmedel" neutrum ;
  flamugn_nn_1 = mkN "flamugn" ;
  flandrisk_av_1 = mkA "flandrisk" ;
  flanell_nn_1 = mkN "flanell" "flaneller" ;
  flanellograf_nn_1 = mkN "flanellograf" "flanellografer" ;
  flank_nn_1 = mkN "flank" "flanker" ;
  flanoer_nn_1 = mkN "flanцr" "flanцrer" ;
  flark_nn_1 = mkN "flark" ;
  flarn_nn_1 = mkN "flarn" neutrum ;
  flaskbarn_nn_1 = mkN "flaskbarn" neutrum ;
  flaskborste_nn_1 = mkN "flaskborste" utrum ;
  flaskhaal_nn_1 = mkN "flaskhеl" neutrum ;
  flaskhals_nn_1 = mkN "flaskhals" ;
  flaskoeppning_nn_1 = mkN "flaskцppning" ;
  flatbroed_nn_1 = mkN "flatbrцd" neutrum ;
  flatfisk_nn_1 = mkN "flatfisk" ;
  flatlus_nn_1 = mkN "flatlus" "flatlusen" "flatlцss" "flatlцssen" ;
  flatskratt_nn_1 = mkN "flatskratt" neutrum ;
  flau_av_1 = mkA "flau" ;
  flaxig_av_1 = mkA "flaxig" ;
  flegmatiker_nn_1 = mkN "flegmatiker" "flegmatikern" "flegmatiker" "flegmatikerna" ;
  flegmatisk_av_1 = mkA "flegmatisk" ;
  flektion_nn_1 = mkN "flektion" "flektioner" ;
  fleraarig_av_1 = mkA "flerеrig" ;
  flerbarnsfamilj_nn_1 = mkN "flerbarnsfamilj" "flerbarnsfamiljer" ;
  flercellig_av_1 = mkA "flercellig" ;
  flerdubbel_av_1 = mkA "flerdubbel" "flerdubbelt" "flerdubbla" "flerdubbla" "flerdubblare" "flerdubblast" "flerdubblaste" ;
  flerfaergstryck_nn_1 = mkN "flerfдrgstryck" neutrum ;
  flerfaldig_av_1 = mkA "flerfaldig" ;
  flerfamiljshus_nn_1 = mkN "flerfamiljshus" neutrum ;
  flermansvalkrets_nn_1 = mkN "flermansvalkrets" ;
  flerpartisystem_nn_1 = mkN "flerpartisystem" neutrum ;
  flerspraakig_av_1 = mkA "flersprеkig" ;
  flerstaedes_ab_1 = mkAdv "flerstдdes" ;
  flerstaemmig_av_1 = mkA "flerstдmmig" ;
  flerstammig_av_1 = mkA "flerstammig" ;
  flertydig_av_1 = mkA "flertydig" ;
  flervaaningshus_nn_1 = mkN "flervеningshus" neutrum ;
  flervalstest_nn_1 = mkN "flervalstest" neutrum ;
  flervalsuppgift_nn_1 = mkN "flervalsuppgift" "flervalsuppgifter" ;
  fles_nn_1 = mkN "fles" ;
  flexibel_av_1 = mkA "flexibel" "flexibelt" "flexibla" "flexibla" "flexiblare" "flexiblast" "flexiblaste" ;
  flexibilitet_nn_1 = mkN "flexibilitet" "flexibiliteter" ;
  flexion_nn_1 = mkN "flexion" "flexioner" ;
  flextid_nn_1 = mkN "flextid" "flextider" ;
  flexur_nn_1 = mkN "flexur" "flexurer" ;
  flickjaegare_nn_1 = mkN "flickjдgare" "flickjдgare" ;
  flicknamn_nn_1 = mkN "flicknamn" neutrum ;
  flickpension_nn_1 = mkN "flickpension" "flickpensioner" ;
  flickvaen_nn_1 = mkN "flickvдn" "flickvдnnen" "flickvдnner" "flickvдnnerna" ;
  flik_nn_1 = mkN "flik" ;
  flikig_av_1 = mkA "flikig" ;
  flimmercell_nn_1 = mkN "flimmercell" "flimmerceller" ;
  flimmerhaar_nn_1 = mkN "flimmerhеr" neutrum ;
  flimrig_av_1 = mkA "flimrig" ;
  flin_nn_1 = mkN "flin" neutrum ;
  flink_av_1 = mkA "flink" ;
  flintlaas_nn_1 = mkN "flintlеs" neutrum ;
  flintlaasgevaer_nn_1 = mkN "flintlеsgevдr" neutrum ;
  flintskalle_nn_1 = mkN "flintskalle" utrum ;
  flintskallig_av_1 = mkA "flintskallig" ;
  flipperspel_nn_1 = mkN "flipperspel" "flipperspelet" "flipperspel" "flipperspelen" ;
  flisig_av_1 = mkA "flisig" ;
  flitig_av_1 = mkA "flitig" ;
  flo_nn_1 = mkN "flo" ;
  flock_nn_1 = mkN "flock" ;
  flockblommig_av_1 = mkA "flockblommig" ;
  flockig_av_1 = mkA "flockig" ;
  flockinstinkt_nn_1 = mkN "flockinstinkt" "flockinstinkter" ;
  flockkamrat_nn_1 = mkN "flockkamrat" "flockkamrater" ;
  flod_nn_1 = mkN "flod" "floder" ;
  flodarm_nn_1 = mkN "flodarm" ;
  flodbaedd_nn_1 = mkN "flodbдdd" ;
  flodbraedd_nn_1 = mkN "flodbrдdd" ;
  floddal_nn_1 = mkN "floddal" ;
  flodhaest_nn_1 = mkN "flodhдst" ;
  flodiller_nn_1 = mkN "flodiller" ;
  flodomraade_nn_1 = mkN "flodomrеde" ;
  flodprofil_nn_1 = mkN "flodprofil" "flodprofiler" ;
  flodslaett_nn_1 = mkN "flodslдtt" "flodslдtter" ;
  flodstrand_nn_1 = mkN "flodstrand" "flodstrдnder" ;
  flodsystem_nn_1 = mkN "flodsystem" neutrum ;
  flodterrass_nn_1 = mkN "flodterrass" "flodterrasser" ;
  floede_nn_1 = mkN "flцde" ;
  floedesdiagram_nn_1 = mkN "flцdesdiagram" "flцdesdiagrammet" "flцdesdiagram" "flцdesdiagrammen" ;
  floedesschema_nn_1 = mkN "flцdesschema" "flцdesschemat" "flцdesscheman" "flцdesschemana" ;
  floej_nn_1 = mkN "flцj" ;
  floejel_nn_1 = mkN "flцjel" ;
  floejt_nn_1 = mkN "flцjt" "flцjter" ;
  floejtist_nn_1 = mkN "flцjtist" "flцjtister" ;
  floejttravaer_nn_1 = mkN "flцjttravдr" "flцjttravдrer" ;
  floert_nn_1 = mkN "flцrt" "flцrter" ;
  floertig_av_1 = mkA "flцrtig" ;
  floets_nn_1 = mkN "flцts" "flцtser" ;
  flogroenn_nn_1 = mkN "flogrцnn" ;
  flop_nn_1 = mkN "flop" "floppen" "floppar" "flopparna" ;
  flor_nn_1 = mkN "flor" neutrum ;
  florentinsk_av_1 = mkA "florentinsk" ;
  florett_nn_1 = mkN "florett" "floretter" ;
  florilegium_nn_1 = mkN "florilegium" "florilegiet" "florilegier" "florilegierna" ;
  florin_nn_1 = mkN "florin" "floriner" ;
  florist_nn_1 = mkN "florist" "florister" ;
  floristisk_av_1 = mkA "floristisk" ;
  floskel_nn_1 = mkN "floskel" "floskeln" "floskler" "flosklerna" ;
  floskuloes_av_1 = mkA "floskulцs" ;
  flott_av_1 = mkA "flott" ;
  flottare_nn_1 = mkN "flottare" "flottare" ;
  flottbas_nn_1 = mkN "flottbas" "flottbaser" ;
  flottbesoek_nn_1 = mkN "flottbesцk" neutrum ;
  flottbro_nn_1 = mkN "flottbro" ;
  flotte_nn_1 = mkN "flotte" utrum ;
  flottflaeck_nn_1 = mkN "flottflдck" ;
  flottig_av_1 = mkA "flottig" ;
  flottilj_nn_1 = mkN "flottilj" "flottiljer" ;
  flottist_nn_1 = mkN "flottist" "flottister" ;
  flottled_nn_1 = mkN "flottled" "flottleder" ;
  flottning_nn_1 = mkN "flottning" ;
  flottningstimmer_nn_1 = mkN "flottningstimmer" neutrum ;
  flottoer_nn_1 = mkN "flottцr" "flottцrer" ;
  flottyr_nn_1 = mkN "flottyr" "flottyrer" ;
  flox_nn_1 = mkN "flox" ;
  fluffig_av_1 = mkA "fluffig" ;
  flugblomster_nn_1 = mkN "flugblomster" neutrum ;
  flugsnappare_nn_1 = mkN "flugsnappare" "flugsnappare" ;
  flugsvamp_nn_1 = mkN "flugsvamp" ;
  fluidum_nn_1 = mkN "fluidum" "fluidet" "fluider" "fluiderna" ;
  flukt_nn_1 = mkN "flukt" ;
  fluktuation_nn_1 = mkN "fluktuation" "fluktuationer" ;
  flummig_av_1 = mkA "flummig" ;
  fluorbehandling_nn_1 = mkN "fluorbehandling" ;
  fluorhalt_nn_1 = mkN "fluorhalt" "fluorhalter" ;
  fluorhaltig_av_1 = mkA "fluorhaltig" ;
  fluorid_nn_1 = mkN "fluorid" "fluorider" ;
  fluss_nn_1 = mkN "fluss" "flusser" ;
  flussmedel_nn_1 = mkN "flussmedel" neutrum ;
  fluster_nn_1 = mkN "fluster" neutrum ;
  fluvial_av_1 = mkA "fluvial" ;
  fly_nn_1 = mkN "fly" "flyt" "flyn" "flyen" ;
  flyg_nn_1 = mkN "flyg" neutrum ;
  flyga_vb_1 = mkV "flyga" "flцg" "flugit" ;
  flyganfall_nn_1 = mkN "flyganfall" neutrum ;
  flygare_nn_1 = mkN "flygare" "flygare" ;
  flygattack_nn_1 = mkN "flygattack" "flygattacker" ;
  flygbaat_nn_1 = mkN "flygbеt" ;
  flygbas_nn_1 = mkN "flygbas" "flygbaser" ;
  flygbild_nn_1 = mkN "flygbild" "flygbilder" ;
  flygbiljett_nn_1 = mkN "flygbiljett" "flygbiljetter" ;
  flygblad_nn_1 = mkN "flygblad" neutrum ;
  flygbolag_nn_1 = mkN "flygbolag" neutrum ;
  flygbomb_nn_1 = mkN "flygbomb" "flygbomber" ;
  flygcertifikat_nn_1 = mkN "flygcertifikat" neutrum ;
  flygekorre_nn_1 = mkN "flygekorre" utrum ;
  flygel_nn_1 = mkN "flygel" ;
  flygfae_nn_1 = mkN "flygfд" "flygfдet" "flygfдn" "flygfдna" ;
  flygfaelt_nn_1 = mkN "flygfдlt" neutrum ;
  flygfaerdig_av_1 = mkA "flygfдrdig" ;
  flygfisk_nn_1 = mkN "flygfisk" ;
  flygfoerband_nn_1 = mkN "flygfцrband" neutrum ;
  flygfoto_nn_1 = mkN "flygfoto" "flygfotot" "flygfoton" "flygfotona" ;
  flygfotografi_nn_1 = mkN "flygfotografi" "flygfotografit" "flygfotografier" "flygfotografierna" ;
  flygg_av_1 = mkA "flygg" ;
  flyghastighet_nn_1 = mkN "flyghastighet" "flyghastigheter" ;
  flyghund_nn_1 = mkN "flyghund" ;
  flygindustri_nn_1 = mkN "flygindustri" "flygindustrier" ;
  flygkaar_nn_1 = mkN "flygkеr" "flygkеrer" ;
  flygkapning_nn_1 = mkN "flygkapning" ;
  flygkapten_nn_1 = mkN "flygkapten" "flygkaptener" ;
  flygkonst_nn_1 = mkN "flygkonst" "flygkonster" ;
  flygkropp_nn_1 = mkN "flygkropp" ;
  flyglarm_nn_1 = mkN "flyglarm" neutrum ;
  flygledare_nn_1 = mkN "flygledare" "flygledare" ;
  flygledes_ab_1 = mkAdv "flygledes" ;
  flygledning_nn_1 = mkN "flygledning" ;
  flyglinje_nn_1 = mkN "flyglinje" "flyglinjer" ;
  flygmaskin_nn_1 = mkN "flygmaskin" "flygmaskiner" ;
  flygning_nn_1 = mkN "flygning" ;
  flygplan_nn_1 = mkN "flygplan" neutrum ;
  flygplanskabin_nn_1 = mkN "flygplanskabin" "flygplanskabiner" ;
  flygplansroder_nn_1 = mkN "flygplansroder" neutrum ;
  flygplansvinge_nn_1 = mkN "flygplansvinge" utrum ;
  flygplats_nn_1 = mkN "flygplats" "flygplatser" ;
  flygroenn_nn_1 = mkN "flygrцnn" ;
  flygtransport_nn_1 = mkN "flygtransport" "flygtransporter" ;
  flygtur_nn_1 = mkN "flygtur" "flygturer" ;
  flygutbildning_nn_1 = mkN "flygutbildning" ;
  flygvaerdinna_nn_1 = mkN "flygvдrdinna" ;
  flygvapen_nn_1 = mkN "flygvapen" "flygvapnet" "flygvapen" "flygvapnen" ;
  flyhaent_av_1 = mkA "flyhдnt" "flyhдnt" ;
  flykt_nn_1 = mkN "flykt" "flykter" ;
  flyktfoersoek_nn_1 = mkN "flyktfцrsцk" neutrum ;
  flyktig_av_1 = mkA "flyktig" ;
  flykting_nn_1 = mkN "flykting" ;
  flyta_vb_1 = mkV "flyta" "flцt" "flutit" ;
  flythjaelp_nn_1 = mkN "flythjдlp" ;
  flytning_nn_1 = mkN "flytning" ;
  flyttbar_av_1 = mkA "flyttbar" ;
  flyttblock_nn_1 = mkN "flyttblock" neutrum ;
  flyttfaagel_nn_1 = mkN "flyttfеgel" ;
  flyttgroet_nn_1 = mkN "flyttgrцt" ;
  flyttkarl_nn_1 = mkN "flyttkarl" ;
  flyttlass_nn_1 = mkN "flyttlass" neutrum ;
  flyttning_nn_1 = mkN "flyttning" ;
  flytvaest_nn_1 = mkN "flytvдst" ;
  fnasig_av_1 = mkA "fnasig" ;
  fnask_nn_1 = mkN "fnask" neutrum ;
  fnasker_nn_1 = mkN "fnasker" ;
  fniss_nn_1 = mkN "fniss" neutrum ;
  fnissig_av_1 = mkA "fnissig" ;
  fnissning_nn_1 = mkN "fnissning" ;
  fnittrig_av_1 = mkA "fnittrig" ;
  fnoesksvamp_nn_1 = mkN "fnцsksvamp" ;
  fnoskig_av_1 = mkA "fnoskig" ;
  foaje_nn_1 = mkN "foajй" "foajйer" ;
  fob_ab_1 = mkAdv "fob" ;
  fobi_nn_1 = mkN "fobi" "fobier" ;
  fobitraening_nn_1 = mkN "fobitrдning" ;
  fock_nn_1 = mkN "fock" ;
  fockmast_nn_1 = mkN "fockmast" "fockmaster" ;
  focus_nn_1 = mkN "focus" ;
  foder_nn_1 = mkN "foder" neutrum ;
  foderblad_nn_1 = mkN "foderblad" neutrum ;
  fodermaengd_nn_1 = mkN "fodermдngd" "fodermдngder" ;
  fodermark_nn_1 = mkN "fodermark" "fodermarker" ;
  foderpaase_nn_1 = mkN "foderpеse" utrum ;
  fodervaerde_nn_1 = mkN "fodervдrde" ;
  fodervaext_nn_1 = mkN "fodervдxt" "fodervдxter" ;
  fodral_nn_1 = mkN "fodral" neutrum ;
  foedd_av_1 = mkA "fцdd" ;
  foedelse_nn_1 = mkN "fцdelse" "fцdelser" ;
  foedelsedag_nn_1 = mkN "fцdelsedag" ;
  foedelsedagsbarn_nn_1 = mkN "fцdelsedagsbarn" neutrum ;
  foedelsehem_nn_1 = mkN "fцdelsehem" "fцdelsehemmet" "fцdelsehem" "fцdelsehemmen" ;
  foedelsekontroll_nn_1 = mkN "fцdelsekontroll" "fцdelsekontroller" ;
  foedelsemaerke_nn_1 = mkN "fцdelsemдrke" ;
  foedelsenummer_nn_1 = mkN "fцdelsenummer" neutrum ;
  foedelsestad_nn_1 = mkN "fцdelsestad" "fцdelsestдder" ;
  foedelsetal_nn_1 = mkN "fцdelsetal" "fцdelsetalet" "fцdelsetalen" "fцdelsetalena" ;
  foedgeni_nn_1 = mkN "fцdgeni" "fцdgeniet" "fцdgenier" "fцdgenierna" ;
  foedkrok_nn_1 = mkN "fцdkrok" ;
  foedoaemne_nn_1 = mkN "fцdoдmne" ;
  foedoorganism_nn_1 = mkN "fцdoorganism" "fцdoorganismer" ;
  foedopartikel_nn_1 = mkN "fцdopartikel" ;
  foedoraad_nn_1 = mkN "fцdorеd" neutrum ;
  foedsel_nn_1 = mkN "fцdsel" ;
  foedsloraett_nn_1 = mkN "fцdslorдtt" "fцdslorдtter" ;
  foega_ab_1 = mkAdv "fцga" ;
  foegderi_nn_1 = mkN "fцgderi" "fцgderit" "fцgderier" "fцgderierna" ;
  foegderifoervaltning_nn_1 = mkN "fцgderifцrvaltning" ;
  foel_nn_1 = mkN "fцl" neutrum ;
  foeljaktligen_ab_1 = mkAdv "fцljaktligen" ;
  foeljande_av_1 = mkA "fцljande" ;
  foeljd_nn_1 = mkN "fцljd" "fцljder" ;
  foeljdenlig_av_1 = mkA "fцljdenlig" ;
  foeljdriktig_av_1 = mkA "fцljdriktig" ;
  foeljdsats_nn_1 = mkN "fцljdsats" "fцljdsatser" ;
  foeljdverkning_nn_1 = mkN "fцljdverkning" ;
  foeljebil_nn_1 = mkN "fцljebil" ;
  foeljebrev_nn_1 = mkN "fцljebrev" neutrum ;
  foeljesedel_nn_1 = mkN "fцljesedel" ;
  foeljeslagare_nn_1 = mkN "fцljeslagare" "fцljeslagare" ;
  foeljeslagarinna_nn_1 = mkN "fцljeslagarinna" ;
  foeljetong_nn_1 = mkN "fцljetong" "fцljetonger" ;
  foeljsam_av_1 = mkA "fцljsam" "fцljsamt" "fцljsamma" "fцljsamma" "fцljsammare" "fцljsammast" "fцljsammaste" ;
  foelsto_nn_1 = mkN "fцlsto" "fцlstoet" "fцlston" "fцlstona" ;
  foen_nn_2 = mkN "fцn" ;
  foenster_nn_1 = mkN "fцnster" neutrum ;
  foensterbaage_nn_1 = mkN "fцnsterbеge" utrum ;
  foensterbaenk_nn_1 = mkN "fцnsterbдnk" ;
  foensterbleck_nn_1 = mkN "fцnsterbleck" neutrum ;
  foensterbord_nn_1 = mkN "fцnsterbord" neutrum ;
  foensterbraede_nn_1 = mkN "fцnsterbrдde" ;
  foensterglas_nn_1 = mkN "fцnsterglas" neutrum ;
  foensterkarm_nn_1 = mkN "fцnsterkarm" ;
  foensterkuvert_nn_1 = mkN "fцnsterkuvert" neutrum ;
  foensterluft_nn_1 = mkN "fцnsterluft" "fцnsterlufter" ;
  foensternisch_nn_1 = mkN "fцnsternisch" "fцnsternischer" ;
  foensterplats_nn_1 = mkN "fцnsterplats" "fцnsterplatser" ;
  foensterputsare_nn_1 = mkN "fцnsterputsare" "fцnsterputsare" ;
  foenstersmyg_nn_1 = mkN "fцnstersmyg" ;
  foenstertittare_nn_1 = mkN "fцnstertittare" "fцnstertittare" ;
  foer_ab_1 = mkAdv "fцr" ;
  foer_nn_1 = mkN "fцr" ;
  foeraedling_nn_1 = mkN "fцrдdling" ;
  foeraektenskaplig_av_1 = mkA "fцrдktenskaplig" ;
  foeraelder_nn_1 = mkN "fцrдlder" ;
  foeraeldrabalk_nn_1 = mkN "fцrдldrabalk" ;
  foeraeldrabesoek_nn_1 = mkN "fцrдldrabesцk" neutrum ;
  foeraeldradag_nn_1 = mkN "fцrдldradag" ;
  foeraeldrafoermaan_nn_1 = mkN "fцrдldrafцrmеn" "fцrдldrafцrmеner" ;
  foeraeldrafoersaekring_nn_1 = mkN "fцrдldrafцrsдkring" ;
  foeraeldrafri_av_1 = mkA "fцrдldrafri" "fцrдldrafritt" ;
  foeraeldrahem_nn_1 = mkN "fцrдldrahem" "fцrдldrahemmet" "fцrдldrahem" "fцrдldrahemmen" ;
  foeraeldraledig_av_1 = mkA "fцrдldraledig" ;
  foeraeldraledighet_nn_1 = mkN "fцrдldraledighet" "fцrдldraledigheter" ;
  foeraeldraloes_av_1 = mkA "fцrдldralцs" ;
  foeraeldratraed_nn_1 = mkN "fцrдldratrдd" neutrum ;
  foeraelskelse_nn_1 = mkN "fцrдlskelse" "fцrдlskelser" ;
  foeraenderlig_av_1 = mkA "fцrдnderlig" ;
  foeraendring_nn_1 = mkN "fцrдndring" ;
  foeraendringstakt_nn_1 = mkN "fцrдndringstakt" "fцrдndringstakter" ;
  foeraeta_vb_1 = mkV "fцrдta" "fцrеt" "fцrдtit" ;
  foeraktfull_av_1 = mkA "fцraktfull" ;
  foeraktlig_av_1 = mkA "fцraktlig" ;
  foeraning_nn_1 = mkN "fцraning" ;
  foerankring_nn_1 = mkN "fцrankring" ;
  foeranmaelning_nn_1 = mkN "fцranmдlning" ;
  foeranstaltning_nn_1 = mkN "fцranstaltning" ;
  foerare_nn_1 = mkN "fцrare" "fцrare" ;
  foerargelsevaeckande_av_1 = mkA "fцrargelsevдckande" ;
  foerarglig_av_1 = mkA "fцrarglig" ;
  foerarhytt_nn_1 = mkN "fцrarhytt" "fцrarhytter" ;
  foerarkabin_nn_1 = mkN "fцrarkabin" "fцrarkabiner" ;
  foerbaalt_ab_1 = mkAdv "fцrbеlt" ;
  foerbaetterlig_av_1 = mkA "fцrbдtterlig" ;
  foerbaettring_nn_1 = mkN "fцrbдttring" ;
  foerbaettringslaan_nn_1 = mkN "fцrbдttringslеn" neutrum ;
  foerband_nn_1 = mkN "fцrband" neutrum ;
  foerbandsplats_nn_1 = mkN "fцrbandsplats" "fцrbandsplatser" ;
  foerbannelse_nn_1 = mkN "fцrbannelse" "fцrbannelser" ;
  foerbehaall_nn_1 = mkN "fцrbehеll" neutrum ;
  foerbehaalla_vb_1 = mkV "fцrbehеlla" "fцrbehцll" "fцrbehеllit" ;
  foerbehaallsam_av_1 = mkA "fцrbehеllsam" "fцrbehеllsamt" "fцrbehеllsamma" "fцrbehеllsamma" "fцrbehеllsammare" "fцrbehеllsammast" "fцrbehеllsammaste" ;
  foerbehaallsamhet_nn_1 = mkN "fцrbehеllsamhet" "fцrbehеllsamheter" ;
  foerbehaallsloes_av_1 = mkA "fцrbehеllslцs" ;
  foerbemaelde_av_1 = mkA "fцrbemдlde" ;
  foerberedande_av_1 = mkA "fцrberedande" ;
  foerberedd_av_1 = mkA "fцrberedd" ;
  foerberedelse_nn_1 = mkN "fцrberedelse" "fцrberedelser" ;
  foerberg_nn_1 = mkN "fцrberg" neutrum ;
  foerbi_ab_1 = mkAdv "fцrbi" ;
  foerbi_av_1 = mkA "fцrbi" ;
  foerbifartsled_nn_1 = mkN "fцrbifartsled" "fцrbifartsleder" ;
  foerbigaa_vb_1 = mkV "fцrbigе" "fцrbigеr" "fцrbigе" "fцrbigick" "fцrbigеtt" "fцrbigеngen" ;
  foerbigaangen_av_1 = mkA "fцrbigеngen" "fцrbigеnget" ;
  foerbinda_vb_1 = mkV "fцrbinda" "fцrband" "fцrbundit" ;
  foerbindelse_nn_1 = mkN "fцrbindelse" "fцrbindelser" ;
  foerbindelsegaang_nn_1 = mkN "fцrbindelsegеng" ;
  foerbindelseled_nn_1 = mkN "fцrbindelseled" "fцrbindelseleder" ;
  foerbindlig_av_1 = mkA "fцrbindlig" ;
  foerbindning_nn_1 = mkN "fцrbindning" ;
  foerbiseende_nn_1 = mkN "fцrbiseende" ;
  foerbjuda_vb_1 = mkV "fцrbjuda" "fцrbjцd" "fцrbjudit" ;
  foerbjuden_av_1 = mkA "fцrbjuden" "fцrbjudet" ;
  foerblivande_av_1 = mkA "fцrblivande" ;
  foerbluffande_av_1 = mkA "fцrbluffande" ;
  foerboen_nn_1 = mkN "fцrbцn" "fцrbцner" ;
  foerbraenningsmotor_nn_1 = mkN "fцrbrдnningsmotor" "fцrbrдnningsmotorer" ;
  foerbraenningsprodukt_nn_1 = mkN "fцrbrдnningsprodukt" "fцrbrдnningsprodukter" ;
  foerbrinna_vb_1 = mkV "fцrbrinna" "fцrbrann" "fцrbrunnit" ;
  foerbroedring_nn_1 = mkN "fцrbrцdring" ;
  foerbrukare_nn_1 = mkN "fцrbrukare" "fцrbrukare" ;
  foerbrukningsartikel_nn_1 = mkN "fцrbrukningsartikel" ;
  foerbrukningsmaterial_nn_1 = mkN "fцrbrukningsmaterial" neutrum ;
  foerbryta_vb_1 = mkV "fцrbryta" "fцrbryter" "fцrbryt" "fцrbrцt" "fцrbrutit" "fцrbrytt" ;
  foerbrytare_nn_1 = mkN "fцrbrytare" "fцrbrytare" ;
  foerbrytelse_nn_1 = mkN "fцrbrytelse" "fцrbrytelser" ;
  foerbud_nn_1 = mkN "fцrbud" neutrum ;
  foerbund_nn_1 = mkN "fцrbund" neutrum ;
  foerbunden_av_1 = mkA "fцrbunden" "fцrbundet" ;
  foerbundsbrev_nn_1 = mkN "fцrbundsbrev" neutrum ;
  foerbundsdag_nn_1 = mkN "fцrbundsdag" ;
  foerbundskansler_nn_1 = mkN "fцrbundskansler" "fцrbundskanslern" "fцrbundskanslerer" "fцrbundskanslererna" ;
  foerbundskapten_nn_1 = mkN "fцrbundskapten" "fцrbundskaptener" ;
  foerbundspresident_nn_1 = mkN "fцrbundspresident" "fцrbundspresidenter" ;
  foerbundsregering_nn_1 = mkN "fцrbundsregering" ;
  foerbundsrepublik_nn_1 = mkN "fцrbundsrepublik" "fцrbundsrepubliker" ;
  foerbundsstat_nn_1 = mkN "fцrbundsstat" "fцrbundsstater" ;
  foerbyggnad_nn_1 = mkN "fцrbyggnad" "fцrbyggnader" ;
  foerdaeck_nn_1 = mkN "fцrdдck" neutrum ;
  foerdaemning_nn_1 = mkN "fцrdдmning" ;
  foerdaervlig_av_1 = mkA "fцrdдrvlig" ;
  foerdel_nn_1 = mkN "fцrdel" "fцrdelen" "fцrdelar" "fцrdelarna" ;
  foerdelaktig_av_1 = mkA "fцrdelaktig" ;
  foerdelare_nn_1 = mkN "fцrdelare" "fцrdelare" ;
  foerdelning_nn_1 = mkN "fцrdelning" ;
  foerdelningspolitisk_av_1 = mkA "fцrdelningspolitisk" ;
  foerdenskull_ab_1 = mkAdv "fцrdenskull" ;
  foerdetta_av_1 = mkA "fцrdetta" ;
  foerdetting_nn_1 = mkN "fцrdetting" ;
  foerdevind_ab_1 = mkAdv "fцrdevind" ;
  foerdjupning_nn_1 = mkN "fцrdjupning" ;
  foerdjupningskurs_nn_1 = mkN "fцrdjupningskurs" "fцrdjupningskurser" ;
  foerdoemd_av_1 = mkA "fцrdцmd" "fцrdцmt" ;
  foerdoemlig_av_1 = mkA "fцrdцmlig" ;
  foerdold_av_1 = mkA "fцrdold" "fцrdolt" ;
  foerdom_nn_1 = mkN "fцrdom" ;
  foerdomsalstrande_av_1 = mkA "fцrdomsalstrande" ;
  foerdomsfri_av_1 = mkA "fцrdomsfri" "fцrdomsfritt" ;
  foerdomsfull_av_1 = mkA "fцrdomsfull" ;
  foerdra_vb_1 = mkV "fцrdra" "fцrdrar" "fцrdra" "fцrdrog" "fцrdragit" "fцrdragen" ;
  foerdrag_nn_1 = mkN "fцrdrag" neutrum ;
  foerdragen_av_1 = mkA "fцrdragen" "fцrdraget" ;
  foerdragsam_av_1 = mkA "fцrdragsam" "fцrdragsamt" "fцrdragsamma" "fцrdragsamma" "fцrdragsammare" "fцrdragsammast" "fцrdragsammaste" ;
  foerdragsamhet_nn_1 = mkN "fцrdragsamhet" "fцrdragsamheter" ;
  foerdriva_vb_1 = mkV "fцrdriva" "fцrdrev" "fцrdrivit" ;
  foerdrivande_nn_1 = mkN "fцrdrivande" ;
  foerdrivning_nn_1 = mkN "fцrdrivning" ;
  foerdroejning_nn_1 = mkN "fцrdrцjning" ;
  foerdroemd_av_1 = mkA "fцrdrцmd" "fцrdrцmt" ;
  foerdubbling_nn_1 = mkN "fцrdubbling" ;
  foere_ab_1 = mkAdv "fцre" ;
  foerebaera_vb_1 = mkV "fцrebдra" "fцrebar" "fцreburit" ;
  foerebaerande_nn_1 = mkN "fцrebдrande" ;
  foerebild_nn_1 = mkN "fцrebild" "fцrebilder" ;
  foerebildlig_av_1 = mkA "fцrebildlig" ;
  foerebraaelse_nn_1 = mkN "fцrebrеelse" "fцrebrеelser" ;
  foerebud_nn_1 = mkN "fцrebud" neutrum ;
  foeredoemlig_av_1 = mkA "fцredцmlig" ;
  foeredra_vb_1 = mkV "fцredra" "fцredrar" "fцredra" "fцredrog" "fцredragit" "fцredragen" ;
  foeredrag_nn_1 = mkN "fцredrag" neutrum ;
  foeredragande_nn_1 = mkN "fцredragande" "fцredraganden" "fцredragande" "fцredragandena" ;
  foeredragning_nn_1 = mkN "fцredragning" ;
  foerefintlig_av_1 = mkA "fцrefintlig" ;
  foeregaa_vb_1 = mkV "fцregе" "fцregеr" "fцregе" "fцregick" "fцregеtt" "fцregеngen" ;
  foeregaaende_av_1 = mkA "fцregеende" ;
  foeregaangare_nn_1 = mkN "fцregеngare" "fцregеngare" ;
  foeregaangsman_nn_1 = mkN "fцregеngsman" "fцregеngsmannen" "fцregеngsmдn" "fцregеngsmдnnen" ;
  foerege_vb_1 = mkV "fцrege" "fцreger" "fцrege" "fцregav" "fцregett" "fцregiven" ;
  foeregivande_nn_1 = mkN "fцregivande" ;
  foeregripa_vb_1 = mkV "fцregripa" "fцregrep" "fцregripit" ;
  foerehaalla_vb_1 = mkV "fцrehеlla" "fцrehцll" "fцrehеllit" ;
  foerehavande_nn_1 = mkN "fцrehavande" ;
  foerekomma_vb_1 = mkV "fцrekomma" "fцrekom" "fцrekommit" ;
  foerekommande_av_1 = mkA "fцrekommande" ;
  foerekomst_nn_1 = mkN "fцrekomst" "fцrekomster" ;
  foerelaeggande_nn_1 = mkN "fцrelдggande" ;
  foerelaesare_nn_1 = mkN "fцrelдsare" "fцrelдsare" ;
  foerelaesning_nn_1 = mkN "fцrelдsning" ;
  foerelaesningssal_nn_1 = mkN "fцrelдsningssal" ;
  foereloepare_nn_1 = mkN "fцrelцpare" "fцrelцpare" ;
  foeremaal_nn_1 = mkN "fцremеl" neutrum ;
  foerening_nn_1 = mkN "fцrening" ;
  foereningsbank_nn_1 = mkN "fцreningsbank" "fцreningsbanker" ;
  foereningsfrihet_nn_1 = mkN "fцreningsfrihet" "fцreningsfriheter" ;
  foereningsmaengd_nn_1 = mkN "fцreningsmдngd" "fцreningsmдngder" ;
  foereningsroerelse_nn_1 = mkN "fцreningsrцrelse" "fцreningsrцrelser" ;
  foerenkling_nn_1 = mkN "fцrenkling" ;
  foerenlig_av_1 = mkA "fцrenlig" ;
  foerenlighet_nn_1 = mkN "fцrenlighet" "fцrenligheter" ;
  foeresats_nn_1 = mkN "fцresats" "fцresatser" ;
  foereskrift_nn_1 = mkN "fцreskrift" "fцreskrifter" ;
  foereskriva_vb_1 = mkV "fцreskriva" "fцreskrev" "fцreskrivit" ;
  foerespegling_nn_1 = mkN "fцrespegling" ;
  foerespraakare_nn_1 = mkN "fцresprеkare" "fцresprеkare" ;
  foerestaaende_av_1 = mkA "fцrestеende" ;
  foerestaandare_nn_1 = mkN "fцrestеndare" "fцrestеndare" ;
  foerestaandarinna_nn_1 = mkN "fцrestеndarinna" ;
  foerestaellande_av_1 = mkA "fцrestдllande" ;
  foerestaellare_nn_1 = mkN "fцrestдllare" "fцrestдllare" ;
  foerestaellning_nn_1 = mkN "fцrestдllning" ;
  foerestaellningsvaerld_nn_1 = mkN "fцrestдllningsvдrld" ;
  foereta_vb_1 = mkV "fцreta" "fцretar" "fцreta" "fцretog" "fцretagit" "fцretagen" ;
  foeretag_nn_1 = mkN "fцretag" neutrum ;
  foeretagare_nn_1 = mkN "fцretagare" "fцretagare" ;
  foeretagsam_av_1 = mkA "fцretagsam" "fцretagsamt" "fцretagsamma" "fцretagsamma" "fцretagsammare" "fцretagsammast" "fцretagsammaste" ;
  foeretagsamhet_nn_1 = mkN "fцretagsamhet" "fцretagsamheter" ;
  foeretagsekonom_nn_1 = mkN "fцretagsekonom" "fцretagsekonomer" ;
  foeretagsekonomisk_av_1 = mkA "fцretagsekonomisk" ;
  foeretagsfilial_nn_1 = mkN "fцretagsfilial" "fцretagsfilialer" ;
  foeretagsledning_nn_1 = mkN "fцretagsledning" ;
  foeretagsnaemnd_nn_1 = mkN "fцretagsnдmnd" "fцretagsnдmnder" ;
  foeretagsvinst_nn_1 = mkN "fцretagsvinst" "fцretagsvinster" ;
  foeretal_nn_1 = mkN "fцretal" "fцretalet" "fцretalen" "fцretalena" ;
  foereteelse_nn_1 = mkN "fцreteelse" "fцreteelser" ;
  foeretraedare_nn_1 = mkN "fцretrдdare" "fцretrдdare" ;
  foeretraede_nn_1 = mkN "fцretrдde" ;
  foeretraedesvis_ab_1 = mkAdv "fцretrдdesvis" ;
  foerevaendning_nn_1 = mkN "fцrevдndning" ;
  foerevarande_av_1 = mkA "fцrevarande" ;
  foerfader_nn_1 = mkN "fцrfader" "fцrfadern" "fцrfдder" "fцrfдderna" ;
  foerfaerlig_av_1 = mkA "fцrfдrlig" ;
  foerfalla_vb_1 = mkV "fцrfalla" "fцrfцll" "fцrfallit" ;
  foerfallen_av_1 = mkA "fцrfallen" "fцrfallet" ;
  foerfallodag_nn_1 = mkN "fцrfallodag" ;
  foerfalskare_nn_1 = mkN "fцrfalskare" "fцrfalskare" ;
  foerfalskning_nn_1 = mkN "fцrfalskning" ;
  foerfarande_nn_1 = mkN "fцrfarande" ;
  foerfaren_av_1 = mkA "fцrfaren" "fцrfaret" ;
  foerfaringssaett_nn_1 = mkN "fцrfaringssдtt" neutrum ;
  foerfattare_nn_1 = mkN "fцrfattare" "fцrfattare" ;
  foerfattarinna_nn_1 = mkN "fцrfattarinna" ;
  foerfattarjag_nn_1 = mkN "fцrfattarjag" neutrum ;
  foerfattning_nn_1 = mkN "fцrfattning" ;
  foerfining_nn_1 = mkN "fцrfining" ;
  foerflugen_av_1 = mkA "fцrflugen" "fцrfluget" ;
  foerfluten_av_1 = mkA "fцrfluten" "fцrflutet" ;
  foerflyta_vb_1 = mkV "fцrflyta" "fцrflцt" "fцrflutit" ;
  foerflyttning_nn_1 = mkN "fцrflyttning" ;
  foerfoeljelse_nn_1 = mkN "fцrfцljelse" "fцrfцljelser" ;
  foerfoeljelsemani_nn_1 = mkN "fцrfцljelsemani" "fцrfцljelsemanier" ;
  foerfoerare_nn_1 = mkN "fцrfцrare" "fцrfцrare" ;
  foerfoerelse_nn_1 = mkN "fцrfцrelse" "fцrfцrelser" ;
  foerfoerisk_av_1 = mkA "fцrfцrisk" ;
  foerfogande_nn_1 = mkN "fцrfogande" ;
  foerfogandelag_nn_1 = mkN "fцrfogandelag" ;
  foerfraagning_nn_1 = mkN "fцrfrеgning" ;
  foerfriskning_nn_1 = mkN "fцrfriskning" ;
  foerfrusen_av_1 = mkA "fцrfrusen" "fцrfruset" ;
  foergaa_vb_1 = mkV "fцrgе" "fцrgеr" "fцrgе" "fцrgick" "fцrgеtt" "fцrgеngen" ;
  foergaard_nn_1 = mkN "fцrgеrd" ;
  foergaenglig_av_1 = mkA "fцrgдnglig" ;
  foergaeta_vb_1 = mkV "fцrgдta" "fцrgat" "fцrgдtit" ;
  foergaetmigej_nn_1 = mkN "fцrgдtmigej" "fцrgдtmigejer" ;
  foergaeves_ab_1 = mkAdv "fцrgдves" ;
  foergasare_nn_1 = mkN "fцrgasare" "fцrgasare" ;
  foergiftning_nn_1 = mkN "fцrgiftning" ;
  foergjord_av_1 = mkA "fцrgjord" "fцrgjort" ;
  foergraaten_av_1 = mkA "fцrgrеten" "fцrgrеtet" ;
  foergraemd_av_1 = mkA "fцrgrдmd" "fцrgrдmt" ;
  foergrening_nn_1 = mkN "fцrgrening" ;
  foergripelse_nn_1 = mkN "fцrgripelse" "fцrgripelser" ;
  foergriplig_av_1 = mkA "fцrgriplig" ;
  foergrund_nn_1 = mkN "fцrgrund" "fцrgrunder" ;
  foergrundsfigur_nn_1 = mkN "fцrgrundsfigur" "fцrgrundsfigurer" ;
  foergrundsgestalt_nn_1 = mkN "fцrgrundsgestalt" "fцrgrundsgestalter" ;
  foergudning_nn_1 = mkN "fцrgudning" ;
  foerhaall_nn_1 = mkN "fцrhеll" neutrum ;
  foerhaallande_nn_1 = mkN "fцrhеllande" ;
  foerhaallandevis_ab_1 = mkAdv "fцrhеllandevis" ;
  foerhaallning_nn_1 = mkN "fцrhеllning" ;
  foerhaallningsorder_nn_1 = mkN "fцrhеllningsorder" ;
  foerhaallningssaett_nn_1 = mkN "fцrhеllningssдtt" neutrum ;
  foerhaardnad_nn_1 = mkN "fцrhеrdnad" "fцrhеrdnader" ;
  foerhaerligande_nn_1 = mkN "fцrhдrligande" ;
  foerhaerskande_av_1 = mkA "fцrhдrskande" ;
  foerhall_nn_1 = mkN "fцrhall" ;
  foerhanden_ab_1 = mkAdv "fцrhanden" ;
  foerhandenvarande_av_1 = mkA "fцrhandenvarande" ;
  foerhandlare_nn_1 = mkN "fцrhandlare" "fцrhandlare" ;
  foerhandling_nn_1 = mkN "fцrhandling" ;
  foerhandlingsbar_av_1 = mkA "fцrhandlingsbar" ;
  foerhandlingsbord_nn_1 = mkN "fцrhandlingsbord" neutrum ;
  foerhandsbukt_nn_1 = mkN "fцrhandsbukt" "fцrhandsbukter" ;
  foerhatlig_av_1 = mkA "fцrhatlig" ;
  foerhinder_nn_1 = mkN "fцrhinder" neutrum ;
  foerhistorisk_av_1 = mkA "fцrhistorisk" ;
  foerhoejning_nn_1 = mkN "fцrhцjning" ;
  foerhoer_nn_1 = mkN "fцrhцr" neutrum ;
  foerhoersledare_nn_1 = mkN "fцrhцrsledare" "fцrhцrsledare" ;
  foerhoersvittne_nn_1 = mkN "fцrhцrsvittne" ;
  foerhoppning_nn_1 = mkN "fцrhoppning" ;
  foerhoppningsfull_av_1 = mkA "fцrhoppningsfull" ;
  foerhoppningsvis_ab_1 = mkAdv "fцrhoppningsvis" ;
  foerhuggning_nn_1 = mkN "fцrhuggning" ;
  foerintande_av_1 = mkA "fцrintande" ;
  foerkaempe_nn_1 = mkN "fцrkдmpe" utrum ;
  foerkaenning_nn_1 = mkN "fцrkдnning" ;
  foerkaensla_nn_1 = mkN "fцrkдnsla" ;
  foerkaerlek_nn_1 = mkN "fцrkдrlek" ;
  foerkalkning_nn_1 = mkN "fцrkalkning" ;
  foerkastelsedom_nn_1 = mkN "fцrkastelsedom" ;
  foerkastlig_av_1 = mkA "fцrkastlig" ;
  foerkastning_nn_1 = mkN "fцrkastning" ;
  foerklae_nn_1 = mkN "fцrklд" "fцrklдt" "fцrklдn" "fцrklдna" ;
  foerklaede_nn_1 = mkN "fцrklдde" ;
  foerklaedeskjol_nn_1 = mkN "fцrklдdeskjol" ;
  foerklaednad_nn_1 = mkN "fцrklдdnad" "fцrklдdnader" ;
  foerklaring_nn_1 = mkN "fцrklaring" ;
  foerklarlig_av_1 = mkA "fцrklarlig" ;
  foerklenande_av_1 = mkA "fцrklenande" ;
  foerklistring_nn_1 = mkN "fцrklistring" ;
  foerklyftning_nn_1 = mkN "fцrklyftning" ;
  foerknippning_nn_1 = mkN "fцrknippning" ;
  foerkoep_nn_1 = mkN "fцrkцp" neutrum ;
  foerkomma_vb_1 = mkV "fцrkomma" "fцrkom" "fцrkommit" ;
  foerkommen_av_1 = mkA "fцrkommen" "fцrkommet" "fцrkomna" "fцrkomna" "fцrkomnare" "fцrkomnast" "fцrkomnaste" ;
  foerkortning_nn_1 = mkN "fцrkortning" ;
  foerkrigstid_nn_1 = mkN "fцrkrigstid" "fцrkrigstider" ;
  foerkristen_av_1 = mkA "fцrkristen" "fцrkristet" ;
  foerkroppning_nn_1 = mkN "fцrkroppning" ;
  foerkrossande_av_1 = mkA "fцrkrossande" ;
  foerkrympt_av_1 = mkA "fцrkrympt" "fцrkrympt" ;
  foerkunnare_nn_1 = mkN "fцrkunnare" "fцrkunnare" ;
  foerkunnelse_nn_1 = mkN "fцrkunnelse" "fцrkunnelser" ;
  foerkyld_av_1 = mkA "fцrkyld" "fцrkylt" ;
  foerkylning_nn_1 = mkN "fцrkylning" ;
  foerlaat_nn_1 = mkN "fцrlеt" "fцrlеter" ;
  foerlaata_vb_1 = mkV "fцrlеta" "fцrlдt" "fцrlеtit" ;
  foerlaatlig_av_1 = mkA "fцrlеtlig" ;
  foerladdning_nn_1 = mkN "fцrladdning" ;
  foerlaegen_av_1 = mkA "fцrlдgen" "fцrlдget" ;
  foerlaegenhet_nn_1 = mkN "fцrlдgenhet" "fцrlдgenheter" ;
  foerlaeggare_nn_1 = mkN "fцrlдggare" "fцrlдggare" ;
  foerlaeggning_nn_1 = mkN "fцrlдggning" ;
  foerlaengning_nn_1 = mkN "fцrlдngning" ;
  foerlaengningssladd_nn_1 = mkN "fцrlдngningssladd" ;
  foerlaening_nn_1 = mkN "fцrlдning" ;
  foerlaest_av_1 = mkA "fцrlдst" "fцrlдst" ;
  foerlag_1_nn_1 = mkN "fцrlag" neutrum ;
  foerlag_2_nn_1 = mkN "fцrlag" neutrum ;
  foerlagsbevis_nn_1 = mkN "fцrlagsbevis" neutrum ;
  foerlagslaan_nn_1 = mkN "fцrlagslеn" neutrum ;
  foerlamning_nn_1 = mkN "fцrlamning" ;
  foerled_nn_1 = mkN "fцrled" neutrum ;
  foerlida_vb_1 = mkV "fцrlida" "fцrled" "fцrlidit" ;
  foerliden_av_1 = mkA "fцrliden" "fцrlidet" ;
  foerlig_av_1 = mkA "fцrlig" ;
  foerlikning_nn_1 = mkN "fцrlikning" ;
  foerlikningskommission_nn_1 = mkN "fцrlikningskommission" "fцrlikningskommissioner" ;
  foerlikningsman_nn_1 = mkN "fцrlikningsman" "fцrlikningsmannen" "fцrlikningsmдn" "fцrlikningsmдnnen" ;
  foerlisning_nn_1 = mkN "fцrlisning" ;
  foerljudande_nn_1 = mkN "fцrljudande" ;
  foerljugen_av_1 = mkA "fцrljugen" "fцrljuget" ;
  foerloepare_nn_1 = mkN "fцrlцpare" "fцrlцpare" ;
  foerloepning_nn_1 = mkN "fцrlцpning" ;
  foerlopp_nn_1 = mkN "fцrlopp" neutrum ;
  foerlorare_nn_1 = mkN "fцrlorare" "fцrlorare" ;
  foerlossning_nn_1 = mkN "fцrlossning" ;
  foerlossningsanstalt_nn_1 = mkN "fцrlossningsanstalt" "fцrlossningsanstalter" ;
  foerlovning_nn_1 = mkN "fцrlovning" ;
  foerlovningsring_nn_1 = mkN "fцrlovningsring" ;
  foerlupen_av_1 = mkA "fцrlupen" "fцrlupet" ;
  foerlust_nn_1 = mkN "fцrlust" "fцrluster" ;
  foerlustbringande_av_1 = mkA "fцrlustbringande" ;
  foerlustelse_nn_1 = mkN "fцrlustelse" "fцrlustelser" ;
  foerlustig_av_1 = mkA "fцrlustig" ;
  foermaan_nn_1 = mkN "fцrmеn" "fцrmеner" ;
  foermaanlig_av_1 = mkA "fцrmеnlig" ;
  foermaanserbjudande_nn_1 = mkN "fцrmеnserbjudande" ;
  foermaanstagare_nn_1 = mkN "fцrmеnstagare" "fцrmеnstagare" ;
  foermaeld_av_1 = mkA "fцrmдld" "fцrmдlt" ;
  foermaeten_av_1 = mkA "fцrmдten" "fцrmдtet" ;
  foermak_nn_1 = mkN "fцrmak" neutrum ;
  foerman_nn_1 = mkN "fцrman" "fцrmannen" "fцrmдn" "fцrmдnnen" ;
  foermaning_nn_1 = mkN "fцrmaning" ;
  foermatch_nn_1 = mkN "fцrmatch" "fцrmatcher" ;
  foermedlande_av_1 = mkA "fцrmedlande" ;
  foermedlare_nn_1 = mkN "fцrmedlare" "fцrmedlare" ;
  foermedling_nn_1 = mkN "fцrmedling" ;
  foermedveten_av_1 = mkA "fцrmedveten" "fцrmedvetet" ;
  foerment_av_1 = mkA "fцrment" "fцrment" ;
  foermer_av_1 = mkA "fцrmer" ;
  foermiddag_nn_1 = mkN "fцrmiddag" ;
  foermildrande_av_1 = mkA "fцrmildrande" ;
  foerminskning_nn_1 = mkN "fцrminskning" ;
  foermodande_nn_1 = mkN "fцrmodande" ;
  foermodligen_ab_1 = mkAdv "fцrmodligen" ;
  foermoegen_av_1 = mkA "fцrmцgen" "fцrmцget" ;
  foermoegenhet_nn_1 = mkN "fцrmцgenhet" "fцrmцgenheter" ;
  foermoegenhetsbrott_nn_1 = mkN "fцrmцgenhetsbrott" neutrum ;
  foermoegenhetsraett_nn_1 = mkN "fцrmцgenhetsrдtt" "fцrmцgenhetsrдtter" ;
  foermoegenhetsskatt_nn_1 = mkN "fцrmцgenhetsskatt" "fцrmцgenhetsskatter" ;
  foermoerkelse_nn_1 = mkN "fцrmцrkelse" "fцrmцrkelser" ;
  foermoerkelsevariabel_nn_1 = mkN "fцrmцrkelsevariabel" "fцrmцrkelsevariabeln" "fцrmцrkelsevariabler" "fцrmцrkelsevariablerna" ;
  foermoerkning_nn_1 = mkN "fцrmцrkning" ;
  foermultning_nn_1 = mkN "fцrmultning" ;
  foermyndaraktig_av_1 = mkA "fцrmyndaraktig" ;
  foermyndare_nn_1 = mkN "fцrmyndare" "fцrmyndare" ;
  foermyndarskap_nn_1 = mkN "fцrmyndarskap" "fцrmyndarskapet" "fцrmyndarskapen" "fцrmyndarskapena" ;
  foernaem_av_1 = mkA "fцrnдm" "fцrnдmare" "fцrnдmst" ;
  foernaemitet_nn_1 = mkN "fцrnдmitet" "fцrnдmiteter" ;
  foernaemlig_av_1 = mkA "fцrnдmlig" ;
  foernaemligen_ab_1 = mkAdv "fцrnдmligen" ;
  foernaer_ab_1 = mkAdv "fцrnдr" ;
  foernaermelse_nn_1 = mkN "fцrnдrmelse" "fцrnдrmelser" ;
  foernamn_nn_1 = mkN "fцrnamn" neutrum ;
  foernekare_nn_1 = mkN "fцrnekare" "fцrnekare" ;
  foernekelse_nn_1 = mkN "fцrnekelse" "fцrnekelser" ;
  foernimbar_av_1 = mkA "fцrnimbar" ;
  foernimma_vb_1 = mkV "fцrnimma" "fцrnam" "fцrnummit" ;
  foernimmelse_nn_1 = mkN "fцrnimmelse" "fцrnimmelser" ;
  foerning_nn_1 = mkN "fцrning" ;
  foernoedenhet_nn_1 = mkN "fцrnцdenhet" "fцrnцdenheter" ;
  foernoejd_av_1 = mkA "fцrnцjd" "fцrnцjt" ;
  foernoejelse_nn_1 = mkN "fцrnцjelse" "fцrnцjelser" ;
  foernoejsam_av_1 = mkA "fцrnцjsam" "fцrnцjsamt" "fцrnцjsamma" "fцrnцjsamma" "fцrnцjsammare" "fцrnцjsammast" "fцrnцjsammaste" ;
  foernuftig_av_1 = mkA "fцrnuftig" ;
  foernuftsskael_nn_1 = mkN "fцrnuftsskдl" neutrum ;
  foernuftsstridig_av_1 = mkA "fцrnuftsstridig" ;
  foernuftsvidrig_av_1 = mkA "fцrnuftsvidrig" ;
  foernumstig_av_1 = mkA "fцrnumstig" ;
  foernumstighet_nn_1 = mkN "fцrnumstighet" "fцrnumstigheter" ;
  foernyare_nn_1 = mkN "fцrnyare" "fцrnyare" ;
  foernybar_av_1 = mkA "fцrnybar" ;
  foernyelse_nn_1 = mkN "fцrnyelse" "fцrnyelser" ;
  foeroedande_av_1 = mkA "fцrцdande" ;
  foeroedelse_nn_1 = mkN "fцrцdelse" "fцrцdelser" ;
  foeroedmjukelse_nn_1 = mkN "fцrцdmjukelse" "fцrцdmjukelser" ;
  foeroekning_nn_1 = mkN "fцrцkning" ;
  foeroevare_nn_1 = mkN "fцrцvare" "fцrцvare" ;
  foeroever_ab_1 = mkAdv "fцrцver" ;
  foeroevning_nn_1 = mkN "fцrцvning" ;
  foeroevrigt_ab_1 = mkAdv "fцrцvrigt" ;
  foerolaempning_nn_1 = mkN "fцrolдmpning" ;
  foerord_nn_1 = mkN "fцrord" neutrum ;
  foerordnande_nn_1 = mkN "fцrordnande" ;
  foerordning_nn_1 = mkN "fцrordning" ;
  foerorening_nn_1 = mkN "fцrorening" ;
  foeroreningsgrad_nn_1 = mkN "fцroreningsgrad" "fцroreningsgrader" ;
  foerort_nn_1 = mkN "fцrort" "fцrorter" ;
  foerpackning_nn_1 = mkN "fцrpackning" ;
  foerpaktare_nn_1 = mkN "fцrpaktare" "fцrpaktare" ;
  foerpassning_nn_1 = mkN "fцrpassning" ;
  foerpatrull_nn_1 = mkN "fцrpatrull" "fцrpatruller" ;
  foerpik_nn_1 = mkN "fцrpik" ;
  foerplaegnad_nn_1 = mkN "fцrplдgnad" "fцrplдgnader" ;
  foerpliktande_av_1 = mkA "fцrpliktande" ;
  foerpliktelse_nn_1 = mkN "fцrpliktelse" "fцrpliktelser" ;
  foerpost_nn_1 = mkN "fцrpost" "fцrposter" ;
  foerpostfaektning_nn_1 = mkN "fцrpostfдktning" ;
  foerpubertet_nn_1 = mkN "fцrpubertet" "fцrpuberteter" ;
  foerpuppning_nn_1 = mkN "fцrpuppning" ;
  foerr_ab_1 = mkAdv "fцrr" ;
  foerraad_nn_1 = mkN "fцrrеd" neutrum ;
  foerraadshus_nn_1 = mkN "fцrrеdshus" neutrum ;
  foerraedare_nn_1 = mkN "fцrrдdare" "fцrrдdare" ;
  foerraederi_nn_1 = mkN "fцrrдderi" "fцrrдderit" "fцrrдderier" "fцrrдderierna" ;
  foerraedisk_av_1 = mkA "fцrrдdisk" ;
  foerraett_nn_1 = mkN "fцrrдtt" "fцrrдtter" ;
  foerraettare_nn_1 = mkN "fцrrдttare" "fцrrдttare" ;
  foerraettning_nn_1 = mkN "fцrrдttning" ;
  foerregling_nn_1 = mkN "fцrregling" ;
  foerresten_ab_1 = mkAdv "fцrresten" ;
  foerrfoerra_av_1 = mkA "fцrrfцrra" ;
  foerrinna_vb_1 = mkV "fцrrinna" "fцrrann" "fцrrunnit" ;
  foerromantisk_av_1 = mkA "fцrromantisk" ;
  foerromersk_av_1 = mkA "fцrromersk" ;
  foerrum_nn_1 = mkN "fцrrum" "fцrrummet" "fцrrum" "fцrrummen" ;
  foerruttnelsegas_nn_1 = mkN "fцrruttnelsegas" "fцrruttnelsegaser" ;
  foerryckt_av_1 = mkA "fцrryckt" "fцrryckt" ;
  foerrymd_av_1 = mkA "fцrrymd" "fцrrymt" ;
  foersaapning_nn_1 = mkN "fцrsеpning" ;
  foersaat_nn_1 = mkN "fцrsеt" neutrum ;
  foersaatlig_av_1 = mkA "fцrsеtlig" ;
  foersaegning_nn_1 = mkN "fцrsдgning" ;
  foersaekran_nn_1 = mkN "fцrsдkran" "fцrsдkran" "fцrsдkringar" "fцrsдkringarna" ;
  foersaekring_nn_1 = mkN "fцrsдkring" ;
  foersaekringsbedraegeri_nn_1 = mkN "fцrsдkringsbedrдgeri" "fцrsдkringsbedrдgerit" "fцrsдkringsbedrдgerier" "fцrsдkringsbedrдgerierna" ;
  foersaekringsbesked_nn_1 = mkN "fцrsдkringsbesked" neutrum ;
  foersaekringsbolag_nn_1 = mkN "fцrsдkringsbolag" neutrum ;
  foersaekringsbrev_nn_1 = mkN "fцrsдkringsbrev" neutrum ;
  foersaekringsgivare_nn_1 = mkN "fцrsдkringsgivare" "fцrsдkringsgivare" ;
  foersaekringsinslag_nn_1 = mkN "fцrsдkringsinslag" neutrum ;
  foersaekringskassa_nn_1 = mkN "fцrsдkringskassa" ;
  foersaekringsmarknad_nn_1 = mkN "fцrsдkringsmarknad" "fцrsдkringsmarknader" ;
  foersaekringspeng_nn_1 = mkN "fцrsдkringspeng" ;
  foersaekringspolis_nn_1 = mkN "fцrsдkringspolis" "fцrsдkringspoliser" ;
  foersaekringspremie_nn_1 = mkN "fцrsдkringspremie" "fцrsдkringspremier" ;
  foersaekringsskydd_nn_1 = mkN "fцrsдkringsskydd" neutrum ;
  foersaekringssystem_nn_1 = mkN "fцrsдkringssystem" neutrum ;
  foersaekringsvillkor_nn_1 = mkN "fцrsдkringsvillkor" neutrum ;
  foersaeljare_nn_1 = mkN "fцrsдljare" "fцrsдljare" ;
  foersaeljning_nn_1 = mkN "fцrsдljning" ;
  foersaeljningsbransch_nn_1 = mkN "fцrsдljningsbransch" "fцrsдljningsbranscher" ;
  foersaeljningschef_nn_1 = mkN "fцrsдljningschef" "fцrsдljningschefer" ;
  foersaeljningsdisk_nn_1 = mkN "fцrsдljningsdisk" ;
  foersaeljningsled_nn_1 = mkN "fцrsдljningsled" neutrum ;
  foersaeljningsort_nn_1 = mkN "fцrsдljningsort" "fцrsдljningsorter" ;
  foersaeljningspris_nn_1 = mkN "fцrsдljningspris" neutrum ;
  foersaeljningsstaand_nn_1 = mkN "fцrsдljningsstеnd" neutrum ;
  foersaeljningsstopp_nn_1 = mkN "fцrsдljningsstopp" neutrum ;
  foersaeljningsvana_nn_1 = mkN "fцrsдljningsvana" ;
  foersaeljningsvinst_nn_1 = mkN "fцrsдljningsvinst" "fцrsдljningsvinster" ;
  foersaemring_nn_1 = mkN "fцrsдmring" ;
  foersaendelse_nn_1 = mkN "fцrsдndelse" "fцrsдndelser" ;
  foersaenkare_nn_1 = mkN "fцrsдnkare" "fцrsдnkare" ;
  foersaenkning_nn_1 = mkN "fцrsдnkning" ;
  foersaettsblad_nn_1 = mkN "fцrsдttsblad" neutrum ;
  foersaettslins_nn_1 = mkN "fцrsдttslins" "fцrsдttslinser" ;
  foersagd_av_1 = mkA "fцrsagd" "fцrsagt" ;
  foersakelse_nn_1 = mkN "fцrsakelse" "fцrsakelser" ;
  foersamling_nn_1 = mkN "fцrsamling" ;
  foersamlingsassistent_nn_1 = mkN "fцrsamlingsassistent" "fцrsamlingsassistenter" ;
  foersamlingsbok_nn_1 = mkN "fцrsamlingsbok" "fцrsamlingsbцcker" ;
  foersamlingsfrihet_nn_1 = mkN "fцrsamlingsfrihet" "fцrsamlingsfriheter" ;
  foersamlingshem_nn_1 = mkN "fцrsamlingshem" "fцrsamlingshemmet" "fцrsamlingshem" "fцrsamlingshemmen" ;
  foersamlingsmedlem_nn_1 = mkN "fцrsamlingsmedlem" "fцrsamlingsmedlemmen" "fцrsamlingsmedlemmar" "fцrsamlingsmedlemmarna" ;
  foersats_nn_1 = mkN "fцrsats" "fцrsatser" ;
  foerseelse_nn_1 = mkN "fцrseelse" "fцrseelser" ;
  foersegel_nn_1 = mkN "fцrsegel" neutrum ;
  foersening_nn_1 = mkN "fцrsening" ;
  foersiggaa_vb_1 = mkV "fцrsiggе" "fцrsiggеr" "fцrsiggе" "fцrsiggick" "fцrsiggеtt" "fцrsiggеngen" ;
  foersigkommen_av_1 = mkA "fцrsigkommen" "fцrsigkommet" "fцrsigkomna" "fцrsigkomna" "fцrsigkomnare" "fцrsigkomnast" "fцrsigkomnaste" ;
  foersiktig_av_1 = mkA "fцrsiktig" ;
  foersiktighet_nn_1 = mkN "fцrsiktighet" "fцrsiktigheter" ;
  foersiktighetsaatgaerd_nn_1 = mkN "fцrsiktighetsеtgдrd" "fцrsiktighetsеtgдrder" ;
  foersiktighetsmaatt_nn_1 = mkN "fцrsiktighetsmеtt" neutrum ;
  foersiktigtvis_ab_1 = mkAdv "fцrsiktigtvis" ;
  foersitta_vb_1 = mkV "fцrsitta" "fцrsatt" "fцrsuttit" ;
  foersjunka_vb_1 = mkV "fцrsjunka" "fцrsjцnk" "fцrsjunkit" ;
  foersjunken_av_1 = mkA "fцrsjunken" "fцrsjunket" ;
  foerskaemd_av_1 = mkA "fцrskдmd" "fцrskдmt" ;
  foerskaemning_nn_1 = mkN "fцrskдmning" ;
  foerskaera_vb_1 = mkV "fцrskдra" "fцrskar" "fцrskurit" ;
  foerskaerare_nn_1 = mkN "fцrskдrare" "fцrskдrare" ;
  foerskaerargaffel_nn_1 = mkN "fцrskдrargaffel" ;
  foerskaerarkniv_nn_1 = mkN "fцrskдrarkniv" ;
  foerskansning_nn_1 = mkN "fцrskansning" ;
  foerskepp_nn_1 = mkN "fцrskepp" neutrum ;
  foerskiffring_nn_1 = mkN "fцrskiffring" ;
  foerskingrare_nn_1 = mkN "fцrskingrare" "fцrskingrare" ;
  foerskingring_nn_1 = mkN "fцrskingring" ;
  foerskinn_nn_1 = mkN "fцrskinn" neutrum ;
  foerskjuta_vb_1 = mkV "fцrskjuta" "fцrskцt" "fцrskjutit" ;
  foerskjutning_nn_1 = mkN "fцrskjutning" ;
  foerskoleaalder_nn_1 = mkN "fцrskoleеlder" ;
  foerskollaerare_nn_1 = mkN "fцrskollдrare" "fцrskollдrare" ;
  foerskott_nn_1 = mkN "fцrskott" neutrum ;
  foerskraeckelse_nn_1 = mkN "fцrskrдckelse" "fцrskrдckelser" ;
  foerskraecklig_av_1 = mkA "fцrskrдcklig" ;
  foerskraeckt_av_1 = mkA "fцrskrдckt" "fцrskrдckt" ;
  foerskraemd_av_1 = mkA "fцrskrдmd" "fцrskrдmt" ;
  foerskriva_vb_1 = mkV "fцrskriva" "fцrskrev" "fцrskrivit" ;
  foerskrivning_nn_1 = mkN "fцrskrivning" ;
  foerslag_1_nn_1 = mkN "fцrslag" neutrum ;
  foerslag_2_nn_1 = mkN "fцrslag" neutrum ;
  foerslagen_av_1 = mkA "fцrslagen" "fцrslaget" ;
  foerslagsrum_nn_1 = mkN "fцrslagsrum" "fцrslagsrummet" "fцrslagsrum" "fцrslagsrummen" ;
  foerslagsvis_ab_1 = mkAdv "fцrslagsvis" ;
  foerslappning_nn_1 = mkN "fцrslappning" ;
  foerslita_vb_1 = mkV "fцrslita" "fцrslet" "fцrslitit" ;
  foerslitning_nn_1 = mkN "fцrslitning" ;
  foersluta_vb_1 = mkV "fцrsluta" "fцrslцt" "fцrslutit" ;
  foerslutning_nn_1 = mkN "fцrslutning" ;
  foersmaedlig_av_1 = mkA "fцrsmдdlig" ;
  foersoek_nn_1 = mkN "fцrsцk" neutrum ;
  foersoeksballong_nn_1 = mkN "fцrsцksballong" "fцrsцksballonger" ;
  foersoeksdamm_nn_1 = mkN "fцrsцksdamm" ;
  foersoeksdjur_nn_1 = mkN "fцrsцksdjur" neutrum ;
  foersoeksgymnasium_nn_1 = mkN "fцrsцksgymnasium" "fцrsцksgymnasiet" "fцrsцksgymnasier" "fцrsцksgymnasierna" ;
  foersoeksheat_nn_1 = mkN "fцrsцksheat" neutrum ;
  foersoekskanin_nn_1 = mkN "fцrsцkskanin" "fцrsцkskaniner" ;
  foersoeksledare_nn_1 = mkN "fцrsцksledare" "fцrsцksledare" ;
  foersoeksobjekt_nn_1 = mkN "fцrsцksobjekt" neutrum ;
  foersoeksperson_nn_1 = mkN "fцrsцksperson" "fцrsцkspersoner" ;
  foersoeksverksamhet_nn_1 = mkN "fцrsцksverksamhet" "fцrsцksverksamheter" ;
  foersoeksvis_ab_1 = mkAdv "fцrsцksvis" ;
  foersoerjare_nn_1 = mkN "fцrsцrjare" "fцrsцrjare" ;
  foersoerjningsboerda_nn_1 = mkN "fцrsцrjningsbцrda" ;
  foersommar_nn_1 = mkN "fцrsommar" "fцrsommarn" "fцrsommrar" "fцrsommrarna" ;
  foersonande_av_1 = mkA "fцrsonande" ;
  foersoning_nn_1 = mkN "fцrsoning" ;
  foersonlig_av_1 = mkA "fцrsonlig" ;
  foersova_vb_1 = mkV "fцrsova" "fцrsov" "fцrsovit" ;
  foerspaend_av_1 = mkA "fцrspдnd" ;
  foerspaenning_nn_1 = mkN "fцrspдnning" ;
  foerspel_nn_1 = mkN "fцrspel" "fцrspelet" "fцrspel" "fцrspelen" ;
  foerst_ab_1 = mkAdv "fцrst" ;
  foerstaaelig_av_1 = mkA "fцrstеelig" ;
  foerstaaende_av_1 = mkA "fцrstеende" ;
  foerstaandig_av_1 = mkA "fцrstеndig" ;
  foerstaandshandikapp_nn_1 = mkN "fцrstеndshandikapp" neutrum ;
  foerstaang_nn_1 = mkN "fцrstеng" "fцrstдnger" ;
  foerstaas_ab_1 = mkAdv "fцrstеs" ;
  foerstaasigpaaare_nn_1 = mkN "fцrstеsigpеare" "fцrstеsigpеare" ;
  foerstad_nn_1 = mkN "fцrstad" "fцrstдder" ;
  foerstadagsbrev_nn_1 = mkN "fцrstadagsbrev" neutrum ;
  foerstadium_nn_1 = mkN "fцrstadium" "fцrstadiet" "fцrstadier" "fцrstadierna" ;
  foerstaemd_av_1 = mkA "fцrstдmd" "fцrstдmt" ;
  foerstaendigande_nn_1 = mkN "fцrstдndigande" ;
  foerstaerkare_nn_1 = mkN "fцrstдrkare" "fцrstдrkare" ;
  foerstaerkning_nn_1 = mkN "fцrstдrkning" ;
  foerstaerkningsord_nn_1 = mkN "fцrstдrkningsord" neutrum ;
  foerstaev_nn_1 = mkN "fцrstдv" ;
  foerstag_nn_1 = mkN "fцrstag" neutrum ;
  foerstagaangsvaeljare_nn_1 = mkN "fцrstagеngsvдljare" "fцrstagеngsvдljare" ;
  foerstagradsekvation_nn_1 = mkN "fцrstagradsekvation" "fцrstagradsekvationer" ;
  foerstahandsuppgift_nn_1 = mkN "fцrstahandsuppgift" "fцrstahandsuppgifter" ;
  foerstaklasshotell_nn_1 = mkN "fцrstaklasshotell" neutrum ;
  foerstamajtaag_nn_1 = mkN "fцrstamajtеg" neutrum ;
  foerstasida_nn_1 = mkN "fцrstasida" ;
  foerstaupplaga_nn_1 = mkN "fцrstaupplaga" ;
  foerstavelse_nn_1 = mkN "fцrstavelse" "fцrstavelser" ;
  foerstbemaelde_av_1 = mkA "fцrstbemдlde" ;
  foersteg_nn_1 = mkN "fцrsteg" neutrum ;
  foerstfoedd_av_1 = mkA "fцrstfцdd" ;
  foerstfoederska_nn_1 = mkN "fцrstfцderska" ;
  foerstklassig_av_1 = mkA "fцrstklassig" ;
  foerstling_nn_1 = mkN "fцrstling" ;
  foerstnaemnd_av_1 = mkA "fцrstnдmnd" ;
  foerstnaemnde_av_1 = mkA "fцrstnдmnde" ;
  foerstoerelse_nn_1 = mkN "fцrstцrelse" "fцrstцrelser" ;
  foerstoppning_nn_1 = mkN "fцrstoppning" ;
  foerstoring_nn_1 = mkN "fцrstoring" ;
  foerstoringsapparat_nn_1 = mkN "fцrstoringsapparat" "fцrstoringsapparater" ;
  foerstoringsglas_nn_1 = mkN "fцrstoringsglas" neutrum ;
  foerstraeckning_nn_1 = mkN "fцrstrдckning" ;
  foerstroedd_av_1 = mkA "fцrstrцdd" "fцrstrцdtt" ;
  foerstroeelse_nn_1 = mkN "fцrstrцelse" "fцrstrцelser" ;
  foerstubro_nn_1 = mkN "fцrstubro" ;
  foerstucken_av_1 = mkA "fцrstucken" "fцrstucket" ;
  foerstudie_nn_1 = mkN "fцrstudie" "fцrstudier" ;
  foerstuga_nn_1 = mkN "fцrstuga" ;
  foerstugubro_nn_1 = mkN "fцrstugubro" ;
  foerstukvist_nn_1 = mkN "fцrstukvist" ;
  foerstulen_av_1 = mkA "fцrstulen" "fцrstulet" ;
  foersumbar_av_1 = mkA "fцrsumbar" ;
  foersumlig_av_1 = mkA "fцrsumlig" ;
  foersumlighet_nn_1 = mkN "fцrsumlighet" "fцrsumligheter" ;
  foersummelse_nn_1 = mkN "fцrsummelse" "fцrsummelser" ;
  foersupen_av_1 = mkA "fцrsupen" "fцrsupet" ;
  foersvaarande_av_1 = mkA "fцrsvеrande" ;
  foersvaerja_vb_1 = mkV "fцrsvдrja" "fцrsvдrj" "fцrsvдrj" "fцrsvorj" "fцrsvurjit" "fцrsvurjen" ;
  foersvarare_nn_1 = mkN "fцrsvarare" "fцrsvarare" ;
  foersvarbar_av_1 = mkA "fцrsvarbar" ;
  foersvarlig_av_1 = mkA "fцrsvarlig" ;
  foersvarsadvokat_nn_1 = mkN "fцrsvarsadvokat" "fцrsvarsadvokater" ;
  foersvarsanlaeggning_nn_1 = mkN "fцrsvarsanlдggning" ;
  foersvarsattache_nn_1 = mkN "fцrsvarsattachй" "fцrsvarsattachйer" ;
  foersvarsgren_nn_1 = mkN "fцrsvarsgren" "fцrsvarsgrenen" "fцrsvarsgrenar" "fцrsvarsgrenarna" ;
  foersvarshemlighet_nn_1 = mkN "fцrsvarshemlighet" "fцrsvarshemligheter" ;
  foersvarskostnad_nn_1 = mkN "fцrsvarskostnad" "fцrsvarskostnader" ;
  foersvarskraft_nn_1 = mkN "fцrsvarskraft" "fцrsvarskrafter" ;
  foersvarslinje_nn_1 = mkN "fцrsvarslinje" "fцrsvarslinjer" ;
  foersvarsloes_av_1 = mkA "fцrsvarslцs" ;
  foersvarsminister_nn_1 = mkN "fцrsvarsminister" ;
  foersvarsomraade_nn_1 = mkN "fцrsvarsomrеde" ;
  foersvarsskrift_nn_1 = mkN "fцrsvarsskrift" "fцrsvarsskrifter" ;
  foersvarsspel_nn_1 = mkN "fцrsvarsspel" "fцrsvarsspelet" "fцrsvarsspel" "fцrsvarsspelen" ;
  foersvarsspelare_nn_1 = mkN "fцrsvarsspelare" "fцrsvarsspelare" ;
  foersvarsstab_nn_1 = mkN "fцrsvarsstab" "fцrsvarsstaber" ;
  foersvarsstaellning_nn_1 = mkN "fцrsvarsstдllning" ;
  foersvarstal_nn_1 = mkN "fцrsvarstal" "fцrsvarstalet" "fцrsvarstalen" "fцrsvarstalena" ;
  foersvarsverk_nn_1 = mkN "fцrsvarsverk" neutrum ;
  foersvinna_vb_1 = mkV "fцrsvinna" "fцrsvann" "fцrsvunnit" ;
  foersvinnande_nn_1 = mkN "fцrsvinnande" ;
  foersynt_av_1 = mkA "fцrsynt" "fцrsynt" ;
  foerta_vb_1 = mkV "fцrta" "fцrtar" "fцrta" "fцrtog" "fцrtagit" "fцrtagen" ;
  foertaeckt_av_1 = mkA "fцrtдckt" "fцrtдckt" ;
  foertaendning_nn_1 = mkN "fцrtдndning" ;
  foertaenksam_av_1 = mkA "fцrtдnksam" "fцrtдnksamt" "fцrtдnksamma" "fцrtдnksamma" "fцrtдnksammare" "fцrtдnksammast" "fцrtдnksammaste" ;
  foertaetning_nn_1 = mkN "fцrtдtning" ;
  foertalskampanj_nn_1 = mkN "fцrtalskampanj" "fцrtalskampanjer" ;
  foertecken_nn_1 = mkN "fцrtecken" "fцrtecknet" "fцrtecken" "fцrtecknen" ;
  foerteckning_nn_1 = mkN "fцrteckning" ;
  foertegen_av_1 = mkA "fцrtegen" "fцrteget" ;
  foertida_av_1 = mkA "fцrtida" ;
  foertidsboerd_nn_1 = mkN "fцrtidsbцrd" "fцrtidsbцrder" ;
  foertidspension_nn_1 = mkN "fцrtidspension" "fцrtidspensioner" ;
  foertimring_nn_1 = mkN "fцrtimring" ;
  foertjaenst_ab_1 = mkAdv "fцrtjдnst" ;
  foertjaenst_nn_1 = mkN "fцrtjдnst" "fцrtjдnster" ;
  foertjaenstfull_av_1 = mkA "fцrtjдnstfull" ;
  foertjaensttecken_nn_1 = mkN "fцrtjдnsttecken" "fцrtjдnsttecknet" "fцrtjдnsttecken" "fцrtjдnsttecknen" ;
  foertjaent_av_1 = mkA "fцrtjдnt" "fцrtjдnt" ;
  foertjusande_av_1 = mkA "fцrtjusande" ;
  foertjust_av_1 = mkA "fцrtjust" "fцrtjust" ;
  foertoejning_nn_1 = mkN "fцrtцjning" ;
  foertoejningsring_nn_1 = mkN "fцrtцjningsring" ;
  foertoning_nn_1 = mkN "fцrtoning" ;
  foertraefflig_av_1 = mkA "fцrtrдfflig" ;
  foertraengning_nn_1 = mkN "fцrtrдngning" ;
  foertretlig_av_1 = mkA "fцrtretlig" ;
  foertretlighet_nn_1 = mkN "fцrtretlighet" "fцrtretligheter" ;
  foertroende_nn_1 = mkN "fцrtroende" ;
  foertroendefraaga_nn_1 = mkN "fцrtroendefrеga" ;
  foertroendefull_av_1 = mkA "fцrtroendefull" ;
  foertroendeingivande_av_1 = mkA "fцrtroendeingivande" ;
  foertroendeman_nn_1 = mkN "fцrtroendeman" "fцrtroendemannen" "fцrtroendemдn" "fцrtroendemдnnen" ;
  foertroenderaad_nn_1 = mkN "fцrtroenderеd" neutrum ;
  foertroendeuppdrag_nn_1 = mkN "fцrtroendeuppdrag" neutrum ;
  foertroendevald_av_1 = mkA "fцrtroendevald" "fцrtroendevalt" ;
  foertroendevotum_nn_1 = mkN "fцrtroendevotum" neutrum ;
  foertrogen_av_1 = mkA "fцrtrogen" "fцrtroget" ;
  foertrogenhet_nn_1 = mkN "fцrtrogenhet" "fцrtrogenheter" ;
  foertrolig_av_1 = mkA "fцrtrolig" ;
  foertrolighet_nn_1 = mkN "fцrtrolighet" "fцrtroligheter" ;
  foertrollande_av_1 = mkA "fцrtrollande" ;
  foertrupp_nn_1 = mkN "fцrtrupp" "fцrtrupper" ;
  foertryckare_nn_1 = mkN "fцrtryckare" "fцrtryckare" ;
  foertrytsam_av_1 = mkA "fцrtrytsam" "fцrtrytsamt" "fцrtrytsamma" "fцrtrytsamma" "fцrtrytsammare" "fцrtrytsammast" "fцrtrytsammaste" ;
  foertunning_nn_1 = mkN "fцrtunning" ;
  foertvaalning_nn_1 = mkN "fцrtvеlning" ;
  foertvaett_nn_1 = mkN "fцrtvдtt" ;
  foerty_ab_1 = mkAdv "fцrty" ;
  foertydligande_nn_1 = mkN "fцrtydligande" ;
  foerunderlig_av_1 = mkA "fцrunderlig" ;
  foerundersoekning_nn_1 = mkN "fцrundersцkning" ;
  foerundransvaerd_av_1 = mkA "fцrundransvдrd" "fцrundransvдrt" ;
  foerut_1_ab_1 = mkAdv "fцrut" ;
  foerut_2_ab_1 = mkAdv "fцrut" ;
  foerutbestaemd_av_1 = mkA "fцrutbestдmd" "fцrutbestдmt" ;
  foerutsaegbar_av_1 = mkA "fцrutsдgbar" ;
  foerutsaegelse_nn_1 = mkN "fцrutsдgelse" "fцrutsдgelser" ;
  foerutsaettning_nn_1 = mkN "fцrutsдttning" ;
  foerutsaettningsloes_av_1 = mkA "fцrutsдttningslцs" ;
  foerutseende_av_1 = mkA "fцrutseende" ;
  foerutvarande_av_1 = mkA "fцrutvarande" ;
  foervaanansvaerd_av_1 = mkA "fцrvеnansvдrd" "fцrvеnansvдrt" ;
  foervaegen_av_1 = mkA "fцrvдgen" "fцrvдget" ;
  foervaeljare_nn_1 = mkN "fцrvдljare" "fцrvдljare" ;
  foervaend_av_1 = mkA "fцrvдnd" ;
  foervaentansfull_av_1 = mkA "fцrvдntansfull" ;
  foervaentning_nn_1 = mkN "fцrvдntning" ;
  foervaermare_nn_1 = mkN "fцrvдrmare" "fцrvдrmare" ;
  foervaerv_nn_1 = mkN "fцrvдrv" neutrum ;
  foervaervsavdrag_nn_1 = mkN "fцrvдrvsavdrag" neutrum ;
  foervaervsverksamhet_nn_1 = mkN "fцrvдrvsverksamhet" "fцrvдrvsverksamheter" ;
  foervaexling_nn_1 = mkN "fцrvдxling" ;
  foervaext_av_1 = mkA "fцrvдxt" "fцrvдxt" ;
  foervaltare_nn_1 = mkN "fцrvaltare" "fцrvaltare" ;
  foervaltarskapsomraade_nn_1 = mkN "fцrvaltarskapsomrеde" ;
  foervaltning_nn_1 = mkN "fцrvaltning" ;
  foervaltningsberaettelse_nn_1 = mkN "fцrvaltningsberдttelse" "fцrvaltningsberдttelser" ;
  foervaltningsbolag_nn_1 = mkN "fцrvaltningsbolag" neutrum ;
  foervaltningsutskott_nn_1 = mkN "fцrvaltningsutskott" neutrum ;
  foervandling_nn_1 = mkN "fцrvandling" ;
  foervandlingskonstnaer_nn_1 = mkN "fцrvandlingskonstnдr" "fцrvandlingskonstnдrer" ;
  foervandlingsnummer_nn_1 = mkN "fцrvandlingsnummer" neutrum ;
  foervandlingsstraff_nn_1 = mkN "fцrvandlingsstraff" neutrum ;
  foervanskning_nn_1 = mkN "fцrvanskning" ;
  foervaring_nn_1 = mkN "fцrvaring" ;
  foervaringshall_nn_1 = mkN "fцrvaringshall" ;
  foervaringsutrymme_nn_1 = mkN "fцrvaringsutrymme" ;
  foervarning_nn_1 = mkN "fцrvarning" ;
  foerveckling_nn_1 = mkN "fцrveckling" ;
  foervedning_nn_1 = mkN "fцrvedning" ;
  foerverkande_nn_1 = mkN "fцrverkande" ;
  foerverkligande_nn_1 = mkN "fцrverkligande" ;
  foerveten_av_1 = mkA "fцrveten" "fцrvetet" ;
  foervillelse_nn_1 = mkN "fцrvillelse" "fцrvillelser" ;
  foervisning_nn_1 = mkN "fцrvisning" ;
  foervisso_ab_1 = mkAdv "fцrvisso" ;
  foervittring_nn_1 = mkN "fцrvittring" ;
  foervraengning_nn_1 = mkN "fцrvrдngning" ;
  foervrida_vb_1 = mkV "fцrvrida" "fцrvred" "fцrvridit" ;
  foervunnen_av_1 = mkA "fцrvunnen" "fцrvunnet" "fцrvunna" "fцrvunna" "fцrvunnare" "fцrvunnast" "fцrvunnaste" ;
  foervuxen_av_1 = mkA "fцrvuxen" "fцrvuxet" ;
  fog_nn_1 = mkN "fog" ;
  fogde_nn_1 = mkN "fogde" utrum ;
  fogeord_nn_1 = mkN "fogeord" neutrum ;
  foglig_av_1 = mkA "foglig" ;
  fogstryka_vb_1 = mkV "fogstryka" "fogstrцk" "fogstrukit" ;
  fogsvans_nn_1 = mkN "fogsvans" ;
  fokal_av_1 = mkA "fokal" ;
  fokaldistans_nn_1 = mkN "fokaldistans" "fokaldistanser" ;
  fokalplan_nn_1 = mkN "fokalplan" neutrum ;
  fokus_nn_1 = mkN "fokus" ;
  folder_nn_1 = mkN "folder" ;
  foliant_nn_1 = mkN "foliant" "folianter" ;
  folie_nn_1 = mkN "folie" "folier" ;
  folioformat_nn_1 = mkN "folioformat" neutrum ;
  folk_nn_1 = mkN "folk" neutrum ;
  folkarme_nn_1 = mkN "folkarmй" "folkarmйer" ;
  folkbaat_nn_1 = mkN "folkbеt" ;
  folkbibliotek_nn_1 = mkN "folkbibliotek" neutrum ;
  folkbokfoering_nn_1 = mkN "folkbokfцring" ;
  folkdans_nn_1 = mkN "folkdans" "folkdanser" ;
  folkdemokrati_nn_1 = mkN "folkdemokrati" "folkdemokratier" ;
  folkdemokratisk_av_1 = mkA "folkdemokratisk" ;
  folkdikt_nn_1 = mkN "folkdikt" "folkdikter" ;
  folkdiktning_nn_1 = mkN "folkdiktning" ;
  folkdjup_nn_1 = mkN "folkdjup" neutrum ;
  folkdomstol_nn_1 = mkN "folkdomstol" ;
  folkdraekt_nn_1 = mkN "folkdrдkt" "folkdrдkter" ;
  folketymologi_nn_1 = mkN "folketymologi" "folketymologier" ;
  folketymologisk_av_1 = mkA "folketymologisk" ;
  folkfest_nn_1 = mkN "folkfest" "folkfester" ;
  folkfoersamling_nn_1 = mkN "folkfцrsamling" ;
  folkfront_nn_1 = mkN "folkfront" "folkfronter" ;
  folkgrupp_nn_1 = mkN "folkgrupp" "folkgrupper" ;
  folkhem_nn_1 = mkN "folkhem" "folkhemmet" "folkhem" "folkhemmen" ;
  folkhemsk_av_1 = mkA "folkhemsk" ;
  folkhjaelte_nn_1 = mkN "folkhjдlte" utrum ;
  folkhop_nn_1 = mkN "folkhop" ;
  folkilsken_av_1 = mkA "folkilsken" "folkilsket" ;
  folkkaer_av_1 = mkA "folkkдr" ;
  folkkommissarie_nn_1 = mkN "folkkommissarie" "folkkommissarier" ;
  folkkommun_nn_1 = mkN "folkkommun" "folkkommuner" ;
  folkkongress_nn_1 = mkN "folkkongress" "folkkongresser" ;
  folklager_nn_1 = mkN "folklager" neutrum ;
  folkledare_nn_1 = mkN "folkledare" "folkledare" ;
  folklek_nn_1 = mkN "folklek" ;
  folklig_av_1 = mkA "folklig" ;
  folklighet_nn_1 = mkN "folklighet" "folkligheter" ;
  folklivsforskare_nn_1 = mkN "folklivsforskare" "folklivsforskare" ;
  folklivsskildring_nn_1 = mkN "folklivsskildring" ;
  folklorist_nn_1 = mkN "folklorist" "folklorister" ;
  folkloristisk_av_1 = mkA "folkloristisk" ;
  folklustspel_nn_1 = mkN "folklustspel" "folklustspelet" "folklustspel" "folklustspelen" ;
  folkmaal_nn_1 = mkN "folkmеl" neutrum ;
  folkmaengd_nn_1 = mkN "folkmдngd" "folkmдngder" ;
  folkmelodi_nn_1 = mkN "folkmelodi" "folkmelodier" ;
  folkminne_nn_1 = mkN "folkminne" ;
  folkmord_nn_1 = mkN "folkmord" neutrum ;
  folknoeje_nn_1 = mkN "folknцje" ;
  folkoel_nn_1 = mkN "folkцl" neutrum ;
  folkomroestning_nn_1 = mkN "folkomrцstning" ;
  folkpark_nn_1 = mkN "folkpark" "folkparker" ;
  folkpartist_nn_1 = mkN "folkpartist" "folkpartister" ;
  folkpension_nn_1 = mkN "folkpension" "folkpensioner" ;
  folkpensionaer_nn_1 = mkN "folkpensionдr" "folkpensionдrer" ;
  folkraekning_nn_1 = mkN "folkrдkning" ;
  folkraettslig_av_1 = mkA "folkrдttslig" ;
  folkrepresentation_nn_1 = mkN "folkrepresentation" "folkrepresentationer" ;
  folkrepublik_nn_1 = mkN "folkrepublik" "folkrepubliker" ;
  folkresning_nn_1 = mkN "folkresning" ;
  folkrik_av_1 = mkA "folkrik" ;
  folkroerelse_nn_1 = mkN "folkrцrelse" "folkrцrelser" ;
  folksaang_nn_1 = mkN "folksеng" "folksеnger" ;
  folksaegen_nn_1 = mkN "folksдgen" "folksдgenn" "folksдgner" "folksдgnerna" ;
  folksaga_nn_1 = mkN "folksaga" ;
  folksamling_nn_1 = mkN "folksamling" ;
  folkskollaerare_nn_1 = mkN "folkskollдrare" "folkskollдrare" ;
  folkskygg_av_1 = mkA "folkskygg" ;
  folkslag_nn_1 = mkN "folkslag" neutrum ;
  folkstam_nn_1 = mkN "folkstam" "folkstammen" "folkstammar" "folkstammarna" ;
  folkstorm_nn_1 = mkN "folkstorm" ;
  folkstyre_nn_1 = mkN "folkstyre" ;
  folktaet_av_1 = mkA "folktдt" ;
  folktaethet_nn_1 = mkN "folktдthet" "folktдtheter" ;
  folkting_nn_1 = mkN "folkting" neutrum ;
  folktom_av_1 = mkA "folktom" "folktomt" "folktomma" "folktomma" "folktommare" "folktommast" "folktommaste" ;
  folktribun_nn_1 = mkN "folktribun" "folktribuner" ;
  folkuniversitet_nn_1 = mkN "folkuniversitet" neutrum ;
  folkvald_av_1 = mkA "folkvald" "folkvalt" ;
  folkvandring_nn_1 = mkN "folkvandring" ;
  folkvilja_nn_1 = mkN "folkvilja" ;
  follikel_nn_1 = mkN "follikel" ;
  follikelstimulerande_av_1 = mkA "follikelstimulerande" ;
  fon_nn_1 = mkN "fon" "foner" ;
  fond_nn_1 = mkN "fond" "fonder" ;
  fondaktie_nn_1 = mkN "fondaktie" "fondaktier" ;
  fondboers_nn_1 = mkN "fondbцrs" "fondbцrser" ;
  fondemission_nn_1 = mkN "fondemission" "fondemissioner" ;
  fondkommissionaer_nn_1 = mkN "fondkommissionдr" "fondkommissionдrer" ;
  fondpapper_nn_1 = mkN "fondpapper" neutrum ;
  fondstaempel_nn_1 = mkN "fondstдmpel" ;
  fondue_nn_1 = mkN "fondue" "fonduer" ;
  fonem_nn_1 = mkN "fonem" neutrum ;
  fonematisk_av_1 = mkA "fonematisk" ;
  fonetiker_nn_1 = mkN "fonetiker" "fonetikern" "fonetiker" "fonetikerna" ;
  fonetisk_av_1 = mkA "fonetisk" ;
  foniater_nn_1 = mkN "foniater" "foniatern" "foniatrer" "foniatrerna" ;
  foniatriker_nn_1 = mkN "foniatriker" "foniatrikern" "foniatriker" "foniatrikerna" ;
  foniatrisk_av_1 = mkA "foniatrisk" ;
  fonograf_nn_1 = mkN "fonograf" "fonografer" ;
  fonogram_nn_1 = mkN "fonogram" "fonogrammet" "fonogram" "fonogrammen" ;
  fonologisk_av_1 = mkA "fonologisk" ;
  fonotek_nn_1 = mkN "fonotek" neutrum ;
  fontaen_nn_1 = mkN "fontдn" "fontдner" ;
  fontanell_nn_1 = mkN "fontanell" "fontaneller" ;
  forcerbar_av_1 = mkA "forcerbar" ;
  forcering_nn_1 = mkN "forcering" ;
  fordom_ab_1 = mkAdv "fordom" ;
  fordon_nn_1 = mkN "fordon" neutrum ;
  fordonsuppstaellning_nn_1 = mkN "fordonsuppstдllning" ;
  fordonsvikt_nn_1 = mkN "fordonsvikt" "fordonsvikter" ;
  fordran_nn_1 = mkN "fordran" "fordran" "fordringar" "fordringarna" ;
  fordrande_av_1 = mkA "fordrande" ;
  fordring_nn_1 = mkN "fordring" ;
  fordringsaegare_nn_1 = mkN "fordringsдgare" "fordringsдgare" ;
  fordringsfull_av_1 = mkA "fordringsfull" ;
  forell_nn_1 = mkN "forell" "foreller" ;
  form_nn_1 = mkN "form" ;
  form_nn_2 = mkN "form" "former" ;
  formaldehyd_nn_1 = mkN "formaldehyd" "formaldehyder" ;
  formalist_nn_1 = mkN "formalist" "formalister" ;
  formaliter_ab_1 = mkAdv "formaliter" ;
  formalitet_nn_1 = mkN "formalitet" "formaliteter" ;
  formant_nn_1 = mkN "formant" "formanter" ;
  format_nn_1 = mkN "format" neutrum ;
  formation_nn_1 = mkN "formation" "formationer" ;
  formbakelse_nn_1 = mkN "formbakelse" "formbakelser" ;
  formbar_av_1 = mkA "formbar" ;
  formbildning_nn_1 = mkN "formbildning" ;
  formbildningsproblem_nn_1 = mkN "formbildningsproblem" neutrum ;
  formbroed_nn_1 = mkN "formbrцd" neutrum ;
  formbunden_av_1 = mkA "formbunden" "formbundet" ;
  formel_nn_1 = mkN "formel" "formeln" "formler" "formlerna" ;
  formelenhet_nn_1 = mkN "formelenhet" "formelenheter" ;
  formell_av_1 = mkA "formell" ;
  formering_nn_1 = mkN "formering" ;
  formfraaga_nn_1 = mkN "formfrеga" ;
  formfranska_nn_1 = mkN "formfranska" ;
  formge_vb_1 = mkV "formge" "formger" "formge" "formgav" "formgett" "formgiven" ;
  formgivare_nn_1 = mkN "formgivare" "formgivare" ;
  formgivning_nn_1 = mkN "formgivning" ;
  formidabel_av_1 = mkA "formidabel" "formidabelt" "formidabla" "formidabla" "formidablare" "formidablast" "formidablaste" ;
  formlaera_nn_1 = mkN "formlдra" ;
  formlig_av_1 = mkA "formlig" ;
  formligen_ab_1 = mkAdv "formligen" ;
  formloes_av_1 = mkA "formlцs" ;
  formord_nn_1 = mkN "formord" neutrum ;
  formpressning_nn_1 = mkN "formpressning" ;
  formrik_av_1 = mkA "formrik" ;
  formrikedom_nn_1 = mkN "formrikedom" ;
  formsak_nn_1 = mkN "formsak" "formsaker" ;
  formspel_nn_1 = mkN "formspel" "formspelet" "formspel" "formspelen" ;
  formspraak_nn_1 = mkN "formsprеk" neutrum ;
  formulaer_nn_1 = mkN "formulдr" neutrum ;
  formulering_nn_1 = mkN "formulering" ;
  forn_av_1 = mkA "forn" ;
  fornborg_nn_1 = mkN "fornborg" ;
  fornegyptisk_av_1 = mkA "fornegyptisk" ;
  fornfolk_nn_1 = mkN "fornfolk" neutrum ;
  fornfynd_nn_1 = mkN "fornfynd" neutrum ;
  forngrekisk_av_1 = mkA "forngrekisk" ;
  fornislaendsk_av_1 = mkA "fornislдndsk" ;
  fornitaliensk_av_1 = mkA "fornitaliensk" ;
  fornkeltisk_av_1 = mkA "fornkeltisk" ;
  fornlaemning_nn_1 = mkN "fornlдmning" ;
  fornminne_nn_1 = mkN "fornminne" ;
  fornnordisk_av_1 = mkA "fornnordisk" ;
  fornromersk_av_1 = mkA "fornromersk" ;
  fornsvensk_av_1 = mkA "fornsvensk" ;
  forntid_nn_1 = mkN "forntid" "forntider" ;
  forntida_av_1 = mkA "forntida" ;
  fors_nn_1 = mkN "fors" ;
  forshuvud_nn_1 = mkN "forshuvud" "forshuvudet" "forshuvuden" "forshuvudena" ;
  forskarassistent_nn_1 = mkN "forskarassistent" "forskarassistenter" ;
  forskare_nn_1 = mkN "forskare" "forskare" ;
  forskargrupp_nn_1 = mkN "forskargrupp" "forskargrupper" ;
  forskarkonspiration_nn_1 = mkN "forskarkonspiration" "forskarkonspirationer" ;
  forskarlag_nn_1 = mkN "forskarlag" neutrum ;
  forskarledighet_nn_1 = mkN "forskarledighet" "forskarledigheter" ;
  forskning_nn_1 = mkN "forskning" ;
  forskningsfaelt_nn_1 = mkN "forskningsfдlt" neutrum ;
  forskningsfartyg_nn_1 = mkN "forskningsfartyg" neutrum ;
  forskningsinstitut_nn_1 = mkN "forskningsinstitut" neutrum ;
  forskningskompetens_nn_1 = mkN "forskningskompetens" "forskningskompetenser" ;
  forskningslaboratorium_nn_1 = mkN "forskningslaboratorium" "forskningslaboratoriet" "forskningslaboratorier" "forskningslaboratorierna" ;
  forskningsomraade_nn_1 = mkN "forskningsomrеde" ;
  forskningsorganisation_nn_1 = mkN "forskningsorganisation" "forskningsorganisationer" ;
  forskningsprojekt_nn_1 = mkN "forskningsprojekt" neutrum ;
  forskningsraad_nn_1 = mkN "forskningsrеd" neutrum ;
  forskningsresande_nn_1 = mkN "forskningsresande" "forskningsresanden" "forskningsresande" "forskningsresandena" ;
  forskningsresultat_nn_1 = mkN "forskningsresultat" neutrum ;
  forskningsroen_nn_1 = mkN "forskningsrцn" neutrum ;
  forskningsstation_nn_1 = mkN "forskningsstation" "forskningsstationer" ;
  forsraenning_nn_1 = mkN "forsrдnning" ;
  fort_ab_1 = mkAdv "fort" ;
  fort_nn_1 = mkN "fort" neutrum ;
  fortbildning_nn_1 = mkN "fortbildning" ;
  forte_ab_1 = mkAdv "forte" ;
  forte_nn_1 = mkN "forte" ;
  fortel_nn_1 = mkN "fortel" ;
  fortepiano_nn_1 = mkN "fortepiano" "fortepianot" "fortepianon" "fortepianona" ;
  fortfaerdig_av_1 = mkA "fortfдrdig" ;
  fortfarande_ab_1 = mkAdv "fortfarande" ;
  fortgaaende_av_1 = mkA "fortgеende" ;
  fortifikation_nn_1 = mkN "fortifikation" "fortifikationer" ;
  fortifikationsfoervaltning_nn_1 = mkN "fortifikationsfцrvaltning" ;
  fortifikationskaar_nn_1 = mkN "fortifikationskеr" "fortifikationskеrer" ;
  fortis_av_1 = mkA "fortis" ;
  fortissimo_ab_1 = mkAdv "fortissimo" ;
  fortissimo_nn_1 = mkN "fortissimo" "fortissimot" "fortissimon" "fortissimona" ;
  fortkoerning_nn_1 = mkN "fortkцrning" ;
  fortkomst_nn_1 = mkN "fortkomst" "fortkomster" ;
  fortloepande_av_1 = mkA "fortlцpande" ;
  fortplantning_nn_1 = mkN "fortplantning" ;
  fortplantningsdrift_nn_1 = mkN "fortplantningsdrift" "fortplantningsdrifter" ;
  fortplantningsorgan_nn_1 = mkN "fortplantningsorgan" neutrum ;
  fortsaettning_nn_1 = mkN "fortsдttning" ;
  fortsaettningsvis_ab_1 = mkAdv "fortsдttningsvis" ;
  fortskaffningsmedel_nn_1 = mkN "fortskaffningsmedel" neutrum ;
  fortskrida_vb_1 = mkV "fortskrida" "fortskred" "fortskridit" ;
  fortskridande_nn_1 = mkN "fortskridande" ;
  forum_nn_1 = mkN "forum" neutrum ;
  forumtidning_nn_1 = mkN "forumtidning" ;
  forward_nn_1 = mkN "forward" ;
  fosfat_nn_1 = mkN "fosfat" neutrum ;
  fosforescent_av_1 = mkA "fosforescent" "fosforescent" ;
  fosforit_nn_1 = mkN "fosforit" "fosforiter" ;
  fosforsyracell_nn_1 = mkN "fosforsyracell" "fosforsyraceller" ;
  fossil_av_1 = mkA "fossil" ;
  fossil_nn_1 = mkN "fossil" neutrum ;
  fossilfri_av_1 = mkA "fossilfri" "fossilfritt" ;
  fossilfynd_nn_1 = mkN "fossilfynd" neutrum ;
  fossilletare_nn_1 = mkN "fossilletare" "fossilletare" ;
  fossilminskning_nn_1 = mkN "fossilminskning" ;
  fossing_nn_1 = mkN "fossing" ;
  fostbroedralag_nn_1 = mkN "fostbrцdralag" neutrum ;
  foster_nn_1 = mkN "foster" neutrum ;
  fosterbarn_nn_1 = mkN "fosterbarn" neutrum ;
  fosterfoeraelder_nn_1 = mkN "fosterfцrдlder" ;
  fosterfoerdrivning_nn_1 = mkN "fosterfцrdrivning" ;
  fosterhem_nn_1 = mkN "fosterhem" "fosterhemmet" "fosterhem" "fosterhemmen" ;
  fosterhinna_nn_1 = mkN "fosterhinna" ;
  fosterlaege_nn_1 = mkN "fosterlдge" ;
  fosterlaendsk_av_1 = mkA "fosterlдndsk" ;
  fosterland_nn_1 = mkN "fosterland" neutrum ;
  fosterljud_nn_1 = mkN "fosterljud" neutrum ;
  fosterutveckling_nn_1 = mkN "fosterutveckling" ;
  fostervatten_nn_1 = mkN "fostervatten" "fostervattnet" "fostervatten" "fostervattnen" ;
  fostrare_nn_1 = mkN "fostrare" "fostrare" ;
  fot_nn_1 = mkN "fot" "fцtter" ;
  fot_nn_2 = mkN "fot" "foten" "fot" "foten" ;
  fotaenda_nn_1 = mkN "fotдnda" "fotдndan" "fotдndar" "fotдndarna" ;
  fotbad_nn_1 = mkN "fotbad" neutrum ;
  fotbjudning_nn_1 = mkN "fotbjudning" ;
  fotblad_nn_1 = mkN "fotblad" neutrum ;
  fotboll_nn_1 = mkN "fotboll" ;
  fotbollsfoerbund_nn_1 = mkN "fotbollsfцrbund" neutrum ;
  fotbollskedja_nn_1 = mkN "fotbollskedja" ;
  fotbollslag_nn_1 = mkN "fotbollslag" neutrum ;
  fotbollsmaal_nn_1 = mkN "fotbollsmеl" neutrum ;
  fotbollsmatch_nn_1 = mkN "fotbollsmatch" "fotbollsmatcher" ;
  fotbollsplan_nn_1 = mkN "fotbollsplan" "fotbollsplaner" ;
  fotbollsspelare_nn_1 = mkN "fotbollsspelare" "fotbollsspelare" ;
  fotbollstips_nn_1 = mkN "fotbollstips" neutrum ;
  fotbroms_nn_1 = mkN "fotbroms" ;
  fotfel_nn_1 = mkN "fotfel" "fotfelet" "fotfel" "fotfelen" ;
  fotgaengare_nn_1 = mkN "fotgдngare" "fotgдngare" ;
  fotino_nn_1 = mkN "fotino" "fotinon" "fotinos" "fotinosen" ;
  fotknoel_nn_1 = mkN "fotknцl" ;
  fotled_nn_1 = mkN "fotled" "fotleder" ;
  fotnot_nn_1 = mkN "fotnot" "fotnoter" ;
  foto_nn_1 = mkN "foto" "fotot" "foton" "fotona" ;
  fotoautomat_nn_1 = mkN "fotoautomat" "fotoautomater" ;
  fotoblixt_nn_1 = mkN "fotoblixt" ;
  fotocell_nn_1 = mkN "fotocell" "fotoceller" ;
  fotoelektricitet_nn_1 = mkN "fotoelektricitet" "fotoelektriciteter" ;
  fotoelektrisk_av_1 = mkA "fotoelektrisk" ;
  fotogenique_av_1 = mkA "fotogenique" ;
  fotogenisk_av_1 = mkA "fotogenisk" ;
  fotogenkoek_nn_1 = mkN "fotogenkцk" neutrum ;
  fotograf_nn_1 = mkN "fotograf" "fotografer" ;
  fotografering_nn_1 = mkN "fotografering" ;
  fotografi_nn_1 = mkN "fotografi" "fotografit" "fotografier" "fotografierna" ;
  fotografiplaat_nn_1 = mkN "fotografiplеt" ;
  fotografisk_av_1 = mkA "fotografisk" ;
  fotogram_nn_1 = mkN "fotogram" "fotogrammet" "fotogram" "fotogrammen" ;
  fotogrammetrisk_av_1 = mkA "fotogrammetrisk" ;
  fotogravyr_nn_1 = mkN "fotogravyr" "fotogravyrer" ;
  fotokemisk_av_1 = mkA "fotokemisk" ;
  fotokopia_nn_1 = mkN "fotokopia" ;
  fotokopiering_nn_1 = mkN "fotokopiering" ;
  fotometer_nn_1 = mkN "fotometer" ;
  fotomodell_nn_1 = mkN "fotomodell" "fotomodeller" ;
  fotomontage_nn_1 = mkN "fotomontage" "fotomontaget" "fotomontage" "fotomontagen" ;
  foton_nn_1 = mkN "foton" "fotoner" ;
  fotoresistor_nn_1 = mkN "fotoresistor" "fotoresistorer" ;
  fotosaettning_nn_1 = mkN "fotosдttning" ;
  fotostatkopia_nn_1 = mkN "fotostatkopia" ;
  fotostatkopiering_nn_1 = mkN "fotostatkopiering" ;
  fotosyntes_nn_1 = mkN "fotosyntes" "fotosynteser" ;
  fotriktig_av_1 = mkA "fotriktig" ;
  fotsack_nn_1 = mkN "fotsack" ;
  fotsid_av_1 = mkA "fotsid" ;
  fotspaar_nn_1 = mkN "fotspеr" neutrum ;
  fotsteg_nn_1 = mkN "fotsteg" neutrum ;
  fotstoed_nn_1 = mkN "fotstцd" neutrum ;
  fotvaenlig_av_1 = mkA "fotvдnlig" ;
  fotvalv_nn_1 = mkN "fotvalv" neutrum ;
  fotvandring_nn_1 = mkN "fotvandring" ;
  foul_nn_1 = mkN "foul" "fouler" ;
  foxterrier_nn_1 = mkN "foxterrier" "foxterriern" "foxterrier" "foxterrierna" ;
  foxtrot_nn_1 = mkN "foxtrot" "foxtroter" ;
  foyer_nn_1 = mkN "foyer" "foyern" "foyerer" "foyererna" ;
  fraaga_nn_1 = mkN "frеga" ;
  fraageform_nn_1 = mkN "frеgeform" "frеgeformer" ;
  fraageformulaer_nn_1 = mkN "frеgeformulдr" neutrum ;
  fraageord_nn_1 = mkN "frеgeord" neutrum ;
  fraagesats_nn_1 = mkN "frеgesats" "frеgesatser" ;
  fraagespalt_nn_1 = mkN "frеgespalt" "frеgespalter" ;
  fraagesport_nn_1 = mkN "frеgesport" "frеgesporter" ;
  fraagestaellare_nn_1 = mkN "frеgestдllare" "frеgestдllare" ;
  fraagestaellning_nn_1 = mkN "frеgestдllning" ;
  fraagestund_nn_1 = mkN "frеgestund" "frеgestunder" ;
  fraagetaevling_nn_1 = mkN "frеgetдvling" ;
  fraagetecken_nn_1 = mkN "frеgetecken" "frеgetecknet" "frеgetecken" "frеgetecknen" ;
  fraagvis_av_1 = mkA "frеgvis" ;
  fraanlandsvind_nn_1 = mkN "frеnlandsvind" ;
  fraansida_nn_1 = mkN "frеnsida" ;
  fraanskild_av_1 = mkA "frеnskild" "frеnskilt" ;
  fraanskiljare_nn_1 = mkN "frеnskiljare" "frеnskiljare" ;
  fraanstoetande_av_1 = mkA "frеnstцtande" ;
  fraanta_vb_1 = mkV "frеnta" "frеntar" "frеnta" "frеntog" "frеntagit" "frеntagen" ;
  fraanvarande_av_1 = mkA "frеnvarande" ;
  frack_nn_1 = mkN "frack" ;
  fradgig_av_1 = mkA "fradgig" ;
  fraeck_av_1 = mkA "frдck" ;
  fraeckhet_nn_1 = mkN "frдckhet" "frдckheter" ;
  fraeckis_nn_1 = mkN "frдckis" ;
  fraeken_nn_1 = mkN "frдken" "frдkenn" "frдknar" "frдknarna" ;
  fraekne_nn_1 = mkN "frдkne" utrum ;
  fraeknig_av_1 = mkA "frдknig" ;
  fraelsare_nn_1 = mkN "frдlsare" "frдlsare" ;
  fraelsarkrans_nn_1 = mkN "frдlsarkrans" ;
  fraelse_av_1 = mkA "frдlse" ;
  fraelsebonde_nn_1 = mkN "frдlsebonde" "frдlsebцnder" ;
  fraelsejord_nn_1 = mkN "frдlsejord" ;
  fraelsningsmoete_nn_1 = mkN "frдlsningsmцte" ;
  fraelsningssoldat_nn_1 = mkN "frдlsningssoldat" "frдlsningssoldater" ;
  fraelst_av_1 = mkA "frдlst" "frдlst" ;
  fraemling_nn_1 = mkN "frдmling" ;
  fraemlingslegion_nn_1 = mkN "frдmlingslegion" "frдmlingslegioner" ;
  fraemlingslegionaer_nn_1 = mkN "frдmlingslegionдr" "frдmlingslegionдrer" ;
  fraemlingspass_nn_1 = mkN "frдmlingspass" neutrum ;
  fraemmande_av_1 = mkA "frдmmande" ;
  fraemmande_nn_1 = mkN "frдmmande" ;
  fraemmat_av_1 = mkA "frдmmat" ;
  fraemre_av_1 = mkA "frдmre" ;
  fraen_av_1 = mkA "frдn" ;
  fraende_nn_1 = mkN "frдnde" "frдnder" ;
  fraendskap_nn_1 = mkN "frдndskap" "frдndskaper" ;
  fraes_nn_1 = mkN "frдs" ;
  fraesch_av_1 = mkA "frдsch" ;
  fraesig_av_1 = mkA "frдsig" ;
  fraesmaskin_nn_1 = mkN "frдsmaskin" "frдsmaskiner" ;
  fragil_av_1 = mkA "fragil" ;
  fragment_nn_1 = mkN "fragment" neutrum ;
  fragmentarisk_av_1 = mkA "fragmentarisk" ;
  frakt_nn_1 = mkN "frakt" "frakter" ;
  fraktal_av_1 = mkA "fraktal" ;
  fraktavtal_nn_1 = mkN "fraktavtal" "fraktavtalet" "fraktavtalen" "fraktavtalena" ;
  fraktion_nn_1 = mkN "fraktion" "fraktioner" ;
  fraktsats_nn_1 = mkN "fraktsats" "fraktsatser" ;
  fraktsedel_nn_1 = mkN "fraktsedel" ;
  fraktur_nn_2 = mkN "fraktur" "frakturer" ;
  fram_ab_1 = mkAdv "fram" ;
  framaat_ab_1 = mkAdv "framеt" ;
  framaenda_nn_1 = mkN "framдnda" "framдndan" "framдndar" "framдndarna" ;
  framaxel_nn_1 = mkN "framaxel" ;
  frambaera_vb_1 = mkV "frambдra" "frambar" "framburit" ;
  framben_nn_1 = mkN "framben" neutrum ;
  frambesvaerja_vb_1 = mkV "frambesvдrja" "frambesvдrjer" "frambesvдrj" "frambesvor" "frambesvurit" "frambesvдrjd" ;
  frambryta_vb_1 = mkV "frambryta" "frambrцt" "frambrutit" ;
  framdel_nn_1 = mkN "framdel" "framdelen" "framdelar" "framdelarna" ;
  framdeles_ab_1 = mkAdv "framdeles" ;
  framdriva_vb_1 = mkV "framdriva" "framdrev" "framdrivit" ;
  framfaerd_nn_1 = mkN "framfдrd" "framfдrder" ;
  framfall_nn_1 = mkN "framfall" neutrum ;
  framfara_vb_1 = mkV "framfara" "framfor" "framfarit" ;
  framfoer_ab_1 = mkAdv "framfцr" ;
  framfoerallt_ab_1 = mkAdv "framfцrallt" ;
  framfoerande_nn_1 = mkN "framfцrande" ;
  framfoerhaallning_nn_1 = mkN "framfцrhеllning" ;
  framfoervarande_av_1 = mkA "framfцrvarande" ;
  framfot_nn_1 = mkN "framfot" "framfцtter" ;
  framfusig_av_1 = mkA "framfusig" ;
  framgaa_vb_1 = mkV "framgе" "framgеr" "framgе" "framgick" "framgеtt" "framgеngen" ;
  framgaang_nn_1 = mkN "framgеng" ;
  framgaangsrik_av_1 = mkA "framgеngsrik" ;
  framgaffel_nn_1 = mkN "framgaffel" ;
  framgent_ab_1 = mkAdv "framgent" ;
  framhaalla_vb_1 = mkV "framhеlla" "framhцll" "framhеllit" ;
  framhjul_nn_1 = mkN "framhjul" neutrum ;
  framhjulsdriven_av_1 = mkA "framhjulsdriven" "framhjulsdrivet" ;
  framifraan_ab_1 = mkAdv "framifrеn" ;
  framkallare_nn_1 = mkN "framkallare" "framkallare" ;
  framkallning_nn_1 = mkN "framkallning" ;
  framkant_nn_1 = mkN "framkant" "framkanter" ;
  framkoerning_nn_1 = mkN "framkцrning" ;
  framkomlig_av_1 = mkA "framkomlig" ;
  framkomlighet_nn_1 = mkN "framkomlighet" "framkomligheter" ;
  framkomma_vb_1 = mkV "framkomma" "framkom" "framkommit" ;
  framladdare_nn_1 = mkN "framladdare" "framladdare" ;
  framladdning_nn_1 = mkN "framladdning" ;
  framlaenges_ab_1 = mkAdv "framlдnges" ;
  framlida_vb_1 = mkV "framlida" "framled" "framlidit" ;
  framliden_av_1 = mkA "framliden" "framlidet" ;
  framlob_nn_1 = mkN "framlob" "framlober" ;
  frammarsch_nn_1 = mkN "frammarsch" "frammarscher" ;
  framme_ab_1 = mkAdv "framme" ;
  framoever_ab_1 = mkAdv "framцver" ;
  frampaa_ab_1 = mkAdv "frampе" ;
  framryckning_nn_1 = mkN "framryckning" ;
  framsaete_nn_1 = mkN "framsдte" ;
  framsida_nn_1 = mkN "framsida" ;
  framskjuta_vb_1 = mkV "framskjuta" "framskцt" "framskjutit" ;
  framskjutande_av_1 = mkA "framskjutande" ;
  framskjuten_av_1 = mkA "framskjuten" "framskjutet" ;
  framskrida_vb_1 = mkV "framskrida" "framskred" "framskridit" ;
  framskriden_av_1 = mkA "framskriden" "framskridet" ;
  framspelare_nn_1 = mkN "framspelare" "framspelare" ;
  framspelning_nn_1 = mkN "framspelning" ;
  framstaaende_av_1 = mkA "framstеende" ;
  framstaellan_nn_1 = mkN "framstдllan" "framstдllan" "framstдllningar" "framstдllningarna" ;
  framstaellning_nn_1 = mkN "framstдllning" ;
  framstam_nn_1 = mkN "framstam" "framstammen" "framstammar" "framstammarna" ;
  framsteg_nn_1 = mkN "framsteg" neutrum ;
  framstegsparti_nn_1 = mkN "framstegsparti" "framstegspartit" "framstegspartier" "framstegspartierna" ;
  framstegsvaenlig_av_1 = mkA "framstegsvдnlig" ;
  framstoet_nn_1 = mkN "framstцt" ;
  framstupa_ab_1 = mkAdv "framstupa" ;
  framsynt_av_1 = mkA "framsynt" "framsynt" ;
  framtand_nn_1 = mkN "framtand" "framtдnder" ;
  framtid_nn_1 = mkN "framtid" "framtider" ;
  framtida_av_1 = mkA "framtida" ;
  framtidsforskning_nn_1 = mkN "framtidsforskning" ;
  framtidsloefte_nn_1 = mkN "framtidslцfte" ;
  framtidsman_nn_1 = mkN "framtidsman" "framtidsmannen" "framtidsmдn" "framtidsmдnnen" ;
  framtidsversion_nn_1 = mkN "framtidsversion" "framtidsversioner" ;
  framtidsvision_nn_1 = mkN "framtidsvision" "framtidsvisioner" ;
  framtidsvy_nn_1 = mkN "framtidsvy" "framtidsvyer" ;
  framtill_ab_1 = mkAdv "framtill" ;
  framtoning_nn_1 = mkN "framtoning" ;
  framtraedande_av_1 = mkA "framtrдdande" ;
  framtraedande_nn_1 = mkN "framtrдdande" ;
  framtraengande_av_1 = mkA "framtrдngande" ;
  framtung_av_1 = mkA "framtung" ;
  framtvinga_vb_1 = mkV "framtvinga" ;
  framvagn_nn_1 = mkN "framvagn" ;
  franc_nn_1 = mkN "franc" "francen" "franc" "francen" ;
  franciskan_nn_1 = mkN "franciskan" "franciskaner" ;
  franciskanerkloster_nn_1 = mkN "franciskanerkloster" neutrum ;
  franciskanermunk_nn_1 = mkN "franciskanermunk" ;
  franciskanerorden_nn_1 = mkN "franciskanerorden" ;
  frank_av_1 = mkA "frank" ;
  frank_nn_1 = mkN "frank" "franker" ;
  franko_ab_1 = mkAdv "franko" ;
  frankostaempel_nn_1 = mkN "frankostдmpel" ;
  frankotecken_nn_1 = mkN "frankotecken" "frankotecknet" "frankotecken" "frankotecknen" ;
  frans_nn_1 = mkN "frans" ;
  fransaes_nn_1 = mkN "fransдs" "fransдser" ;
  fransig_av_1 = mkA "fransig" ;
  fransk_av_1 = mkA "fransk" ;
  franska_nn_2 = mkN "franska" ;
  franskbroed_nn_1 = mkN "franskbrцd" neutrum ;
  franskklassisk_av_1 = mkA "franskklassisk" ;
  fransman_nn_1 = mkN "fransman" "fransmannen" "fransmдn" "fransmдnnen" ;
  fransos_nn_1 = mkN "fransos" "fransoser" ;
  fransyska_nn_1 = mkN "fransyska" ;
  frappant_av_1 = mkA "frappant" "frappant" ;
  frapperande_av_1 = mkA "frapperande" ;
  fras_nn_1 = mkN "fras" "fraser" ;
  fraseologisk_av_1 = mkA "fraseologisk" ;
  frasering_nn_1 = mkN "frasering" ;
  frasig_av_1 = mkA "frasig" ;
  frasliberal_av_1 = mkA "frasliberal" ;
  frasliberal_nn_1 = mkN "frasliberal" "frasliberaler" ;
  frasmakare_nn_1 = mkN "frasmakare" "frasmakare" ;
  frasradikal_av_1 = mkA "frasradikal" ;
  frasradikal_nn_1 = mkN "frasradikal" "frasradikaler" ;
  frasvaaffla_nn_1 = mkN "frasvеffla" ;
  freak_nn_1 = mkN "freak" ;
  fred_nn_1 = mkN "fred" "freder" ;
  fredag_nn_1 = mkN "fredag" ;
  fredagsboers_nn_1 = mkN "fredagsbцrs" "fredagsbцrser" ;
  fredagskvaell_nn_1 = mkN "fredagskvдll" ;
  fredagsmorgon_nn_1 = mkN "fredagsmorgon" "fredagsmorgonen" "fredagsmorgnar" "fredagsmorgnarna" ;
  fredlig_av_1 = mkA "fredlig" ;
  fredloes_av_1 = mkA "fredlцs" ;
  fredsbevarande_av_1 = mkA "fredsbevarande" ;
  fredsdomare_nn_1 = mkN "fredsdomare" "fredsdomare" ;
  fredsdomstol_nn_1 = mkN "fredsdomstol" ;
  fredsfoerdrag_nn_1 = mkN "fredsfцrdrag" neutrum ;
  fredsfoerhandling_nn_1 = mkN "fredsfцrhandling" ;
  fredsforskning_nn_1 = mkN "fredsforskning" ;
  fredskaar_nn_1 = mkN "fredskеr" "fredskеrer" ;
  fredskonferens_nn_1 = mkN "fredskonferens" "fredskonferenser" ;
  fredsmaeklare_nn_1 = mkN "fredsmдklare" "fredsmдklare" ;
  fredspris_nn_1 = mkN "fredspris" neutrum ;
  fredsroerelse_nn_1 = mkN "fredsrцrelse" "fredsrцrelser" ;
  fredsslut_nn_1 = mkN "fredsslut" neutrum ;
  fredsstraevande_nn_1 = mkN "fredsstrдvande" ;
  fredstid_nn_1 = mkN "fredstid" "fredstider" ;
  fredstida_av_1 = mkA "fredstida" ;
  free_style_nn_1 = mkN "free-style" "free-stylen" "free-styles" "free-stylesen" ;
  fregatt_nn_1 = mkN "fregatt" "fregatter" ;
  fregattfaagel_nn_1 = mkN "fregattfеgel" ;
  frejdig_av_1 = mkA "frejdig" ;
  frekvens_nn_1 = mkN "frekvens" "frekvenser" ;
  frekvensband_nn_1 = mkN "frekvensband" neutrum ;
  frekvensmodulering_nn_1 = mkN "frekvensmodulering" ;
  frekvensomraade_nn_1 = mkN "frekvensomrеde" ;
  frekvent_av_1 = mkA "frekvent" "frekvent" ;
  frenetisk_av_1 = mkA "frenetisk" ;
  frenologisk_av_1 = mkA "frenologisk" ;
  freon_nn_1 = mkN "freon" "freoner" ;
  fresk_nn_1 = mkN "fresk" "fresker" ;
  freskomaalning_nn_1 = mkN "freskomеlning" ;
  frestande_av_1 = mkA "frestande" ;
  frestare_nn_1 = mkN "frestare" "frestare" ;
  frestelse_nn_1 = mkN "frestelse" "frestelser" ;
  fri_av_1 = mkA "fri" "fritt" ;
  friaakning_nn_1 = mkN "friеkning" ;
  friare_nn_1 = mkN "friare" "friare" ;
  fribaerande_av_1 = mkA "fribдrande" ;
  fribiljett_nn_1 = mkN "fribiljett" "fribiljetter" ;
  fribladig_av_1 = mkA "fribladig" ;
  fribonde_nn_1 = mkN "fribonde" "fribцnder" ;
  fribord_nn_1 = mkN "fribord" neutrum ;
  friboren_av_1 = mkA "friboren" "friboret" ;
  fribrev_nn_1 = mkN "fribrev" neutrum ;
  fribrottare_nn_1 = mkN "fribrottare" "fribrottare" ;
  fribytare_nn_1 = mkN "fribytare" "fribytare" ;
  fribyteri_nn_1 = mkN "fribyteri" "fribyterit" "fribyterier" "fribyterierna" ;
  fridag_nn_1 = mkN "fridag" ;
  fridfull_av_1 = mkA "fridfull" ;
  fridlysning_nn_1 = mkN "fridlysning" ;
  fridsam_av_1 = mkA "fridsam" "fridsamt" "fridsamma" "fridsamma" "fridsammare" "fridsammast" "fridsammaste" ;
  frieri_nn_1 = mkN "frieri" "frierit" "frierier" "frierierna" ;
  frifraesare_nn_1 = mkN "frifrдsare" "frifrдsare" ;
  frifraesig_av_1 = mkA "frifrдsig" ;
  frigaaende_av_1 = mkA "frigеende" ;
  frige_vb_1 = mkV "frige" "friger" "frige" "frigav" "frigett" "frigiven" ;
  friggebod_nn_1 = mkN "friggebod" ;
  frigiditet_nn_1 = mkN "frigiditet" "frigiditeter" ;
  frigivning_nn_1 = mkN "frigivning" ;
  frigjord_av_1 = mkA "frigjord" "frigjort" ;
  frigjordhet_nn_1 = mkN "frigjordhet" "frigjordheter" ;
  frihamn_nn_1 = mkN "frihamn" ;
  frihandelsomraade_nn_1 = mkN "frihandelsomrеde" ;
  frihandsteckning_nn_1 = mkN "frihandsteckning" ;
  friherre_nn_1 = mkN "friherre" utrum ;
  frihet_nn_1 = mkN "frihet" "friheter" ;
  frihetlig_av_1 = mkA "frihetlig" ;
  frihetsberoevande_nn_1 = mkN "frihetsberцvande" ;
  frihetsgrad_nn_1 = mkN "frihetsgrad" "frihetsgrader" ;
  frihetshjaelte_nn_1 = mkN "frihetshjдlte" utrum ;
  frihetskamp_nn_1 = mkN "frihetskamp" "frihetskamper" ;
  frihetskrig_nn_1 = mkN "frihetskrig" neutrum ;
  frihetsstraff_nn_1 = mkN "frihetsstraff" neutrum ;
  frihjul_nn_1 = mkN "frihjul" neutrum ;
  friholt_nn_1 = mkN "friholt" ;
  friidrott_nn_1 = mkN "friidrott" "friidrotter" ;
  frikaar_nn_1 = mkN "frikеr" "frikеrer" ;
  frikadell_nn_1 = mkN "frikadell" "frikadeller" ;
  frikaennande_nn_1 = mkN "frikдnnande" ;
  frikasse_nn_1 = mkN "frikassй" "frikassйer" ;
  frikast_nn_1 = mkN "frikast" neutrum ;
  frikativ_av_1 = mkA "frikativ" ;
  frikoep_nn_1 = mkN "frikцp" neutrum ;
  frikoppling_nn_1 = mkN "frikoppling" ;
  frikort_nn_1 = mkN "frikort" neutrum ;
  frikostig_av_1 = mkA "frikostig" ;
  frikrets_nn_1 = mkN "frikrets" ;
  friktion_nn_1 = mkN "friktion" "friktioner" ;
  friktionsfri_av_1 = mkA "friktionsfri" "friktionsfritt" ;
  friktionskoefficient_nn_1 = mkN "friktionskoefficient" "friktionskoefficienter" ;
  friktionstal_nn_1 = mkN "friktionstal" "friktionstalet" "friktionstalen" "friktionstalena" ;
  frikyrka_nn_1 = mkN "frikyrka" ;
  frikyrklig_av_1 = mkA "frikyrklig" ;
  frikyrklighet_nn_1 = mkN "frikyrklighet" "frikyrkligheter" ;
  friland_nn_1 = mkN "friland" neutrum ;
  frilans_nn_1 = mkN "frilans" ;
  frilansare_nn_1 = mkN "frilansare" "frilansare" ;
  frilevande_av_1 = mkA "frilevande" ;
  friluftsaendamaal_nn_1 = mkN "friluftsдndamеl" neutrum ;
  friluftsbad_nn_1 = mkN "friluftsbad" neutrum ;
  friluftsdag_nn_1 = mkN "friluftsdag" ;
  friluftsmiljoe_nn_1 = mkN "friluftsmiljц" "friluftsmiljцn" "friluftsmiljцer" "friluftsmiljцerna" ;
  friluftsmuseum_nn_1 = mkN "friluftsmuseum" "friluftsmuseet" "friluftsmuseer" "friluftsmuseerna" ;
  friluftsomraade_nn_1 = mkN "friluftsomrеde" ;
  friluftsskog_nn_1 = mkN "friluftsskog" ;
  friluftsvana_nn_1 = mkN "friluftsvana" ;
  frimaerkssamling_nn_1 = mkN "frimдrkssamling" ;
  frimickel_nn_1 = mkN "frimickel" ;
  frimodig_av_1 = mkA "frimodig" ;
  frimurare_nn_1 = mkN "frimurare" "frimurare" ;
  frimurarloge_nn_1 = mkN "frimurarloge" "frimurarloger" ;
  frimurarorden_nn_1 = mkN "frimurarorden" ;
  fripassagerare_nn_1 = mkN "fripassagerare" "fripassagerare" ;
  friplaat_nn_1 = mkN "friplеt" ;
  frireligioes_av_1 = mkA "frireligiцs" ;
  fris_1_nn_1 = mkN "fris" "friser" ;
  fris_2_nn_1 = mkN "fris" "friser" ;
  frisbee_nn_1 = mkN "frisbee" "frisbeen" "frisbeear" "frisbeearna" ;
  frisedel_nn_1 = mkN "frisedel" ;
  frisersalong_nn_1 = mkN "frisersalong" "frisersalonger" ;
  frisisk_av_1 = mkA "frisisk" ;
  frisiska_nn_2 = mkN "frisiska" ;
  frisk_av_1 = mkA "frisk" ;
  friskhet_nn_1 = mkN "friskhet" "friskheter" ;
  friskintyg_nn_1 = mkN "friskintyg" neutrum ;
  friskluftsintag_nn_1 = mkN "friskluftsintag" neutrum ;
  friskriven_av_1 = mkA "friskriven" "friskrivet" ;
  friskrivning_nn_1 = mkN "friskrivning" ;
  friskskriva_vb_1 = mkV "friskskriva" "friskskrev" "friskskrivit" ;
  friskus_nn_1 = mkN "friskus" ;
  frislag_nn_1 = mkN "frislag" neutrum ;
  frisoer_nn_1 = mkN "frisцr" "frisцrer" ;
  frisoerska_nn_1 = mkN "frisцrska" ;
  frispark_nn_1 = mkN "frispark" ;
  frispraakig_av_1 = mkA "frisprеkig" ;
  frist_nn_1 = mkN "frist" "frister" ;
  fristaaende_av_1 = mkA "fristеende" ;
  fristad_nn_1 = mkN "fristad" "fristдder" ;
  fristat_nn_1 = mkN "fristat" "fristater" ;
  frisyr_nn_1 = mkN "frisyr" "frisyrer" ;
  frisyrgele_nn_1 = mkN "frisyrgelй" "frisyrgelйer" ;
  frita_vb_1 = mkV "frita" "fritar" "frita" "fritog" "fritagit" "fritagen" ;
  fritaenkare_nn_1 = mkN "fritдnkare" "fritдnkare" ;
  fritagning_nn_1 = mkN "fritagning" ;
  fritidsaktivitet_nn_1 = mkN "fritidsaktivitet" "fritidsaktiviteter" ;
  fritidsbaat_nn_1 = mkN "fritidsbеt" ;
  fritidsbebyggelse_nn_1 = mkN "fritidsbebyggelse" "fritidsbebyggelser" ;
  fritidsby_nn_1 = mkN "fritidsby" "fritidsbyn" "fritidsbyar" "fritidsbyarna" ;
  fritidsfoervaltning_nn_1 = mkN "fritidsfцrvaltning" ;
  fritidsgaard_nn_1 = mkN "fritidsgеrd" ;
  fritidshem_nn_1 = mkN "fritidshem" "fritidshemmet" "fritidshem" "fritidshemmen" ;
  fritidshus_nn_1 = mkN "fritidshus" neutrum ;
  fritidsledare_nn_1 = mkN "fritidsledare" "fritidsledare" ;
  fritidslokal_nn_1 = mkN "fritidslokal" "fritidslokaler" ;
  fritidsnaemnd_nn_1 = mkN "fritidsnдmnd" "fritidsnдmnder" ;
  fritidsomraade_nn_1 = mkN "fritidsomrеde" ;
  fritidspedagog_nn_1 = mkN "fritidspedagog" "fritidspedagoger" ;
  fritidsproblem_nn_1 = mkN "fritidsproblem" neutrum ;
  fritidsstuga_nn_1 = mkN "fritidsstuga" ;
  fritidssysselsaettning_nn_1 = mkN "fritidssysselsдttning" ;
  fritis_nn_1 = mkN "fritis" neutrum ;
  frityr_nn_1 = mkN "frityr" "frityrer" ;
  frivakt_nn_1 = mkN "frivakt" "frivakter" ;
  frivillig_av_1 = mkA "frivillig" ;
  frivillighet_nn_1 = mkN "frivillighet" "frivilligheter" ;
  frivol_av_1 = mkA "frivol" ;
  frivolitet_nn_1 = mkN "frivolitet" "frivoliteter" ;
  frivolt_nn_1 = mkN "frivolt" "frivolter" ;
  frodig_av_1 = mkA "frodig" ;
  froe_nn_1 = mkN "frц" "frцet" "frцer" "frцerna" ;
  froeaemne_nn_1 = mkN "frцдmne" ;
  froehus_nn_1 = mkN "frцhus" neutrum ;
  froejd_nn_1 = mkN "frцjd" "frцjder" ;
  froejdefull_av_1 = mkA "frцjdefull" ;
  froeken_nn_1 = mkN "frцken" ;
  froeodling_nn_1 = mkN "frцodling" ;
  froeplantage_nn_1 = mkN "frцplantage" "frцplantager" ;
  froeskal_nn_1 = mkN "frцskal" neutrum ;
  froetraed_nn_1 = mkN "frцtrдd" neutrum ;
  froevaext_nn_1 = mkN "frцvдxt" "frцvдxter" ;
  from_av_1 = mkA "from" "fromt" "fromma" "fromma" "frommare" "frommast" "frommaste" ;
  fromage_nn_1 = mkN "fromage" "fromager" ;
  fromhet_nn_1 = mkN "fromhet" "fromheter" ;
  fromsint_av_1 = mkA "fromsint" "fromsint" ;
  frondoer_nn_1 = mkN "frondцr" "frondцrer" ;
  front_nn_1 = mkN "front" "fronter" ;
  frontal_av_1 = mkA "frontal" ;
  frontalangrepp_nn_1 = mkN "frontalangrepp" neutrum ;
  frontalkrock_nn_1 = mkN "frontalkrock" ;
  frontallob_nn_1 = mkN "frontallob" "frontallober" ;
  frontavsnitt_nn_1 = mkN "frontavsnitt" neutrum ;
  frontbildning_nn_1 = mkN "frontbildning" ;
  frontespis_nn_1 = mkN "frontespis" "frontespiser" ;
  frontfoerbindelse_nn_1 = mkN "frontfцrbindelse" "frontfцrbindelser" ;
  frontlinje_nn_1 = mkN "frontlinje" "frontlinjer" ;
  fronton_nn_1 = mkN "fronton" "frontoner" ;
  frontsoldat_nn_1 = mkN "frontsoldat" "frontsoldater" ;
  frontzon_nn_1 = mkN "frontzon" "frontzoner" ;
  frosch_nn_1 = mkN "frosch" "froscher" ;
  frossare_nn_1 = mkN "frossare" "frossare" ;
  frossbrytning_nn_1 = mkN "frossbrytning" ;
  frostbiten_av_1 = mkA "frostbiten" "frostbitet" ;
  frostfjaeril_nn_1 = mkN "frostfjдril" ;
  frostfri_av_1 = mkA "frostfri" "frostfritt" ;
  frosthaerdig_av_1 = mkA "frosthдrdig" ;
  frosthaerdighet_nn_1 = mkN "frosthдrdighet" "frosthдrdigheter" ;
  frostig_av_1 = mkA "frostig" ;
  frostkaenslig_av_1 = mkA "frostkдnslig" ;
  frostkaenslighet_nn_1 = mkN "frostkдnslighet" "frostkдnsligheter" ;
  frostnatt_nn_1 = mkN "frostnatt" "frostnдtter" ;
  frostskyddsvaetska_nn_1 = mkN "frostskyddsvдtska" ;
  frostspraengning_nn_1 = mkN "frostsprдngning" ;
  frosttaalig_av_1 = mkA "frosttеlig" ;
  frotte_nn_1 = mkN "frottй" "frottйer" ;
  fru_nn_1 = mkN "fru" ;
  frugal_av_1 = mkA "frugal" ;
  frukost_nn_1 = mkN "frukost" ;
  frukostmiddag_nn_1 = mkN "frukostmiddag" ;
  frukostrast_nn_1 = mkN "frukostrast" "frukostraster" ;
  frukt_nn_1 = mkN "frukt" "frukter" ;
  fruktaemne_nn_1 = mkN "fruktдmne" ;
  fruktaffaer_nn_1 = mkN "fruktaffдr" "fruktaffдrer" ;
  fruktansvaerd_av_1 = mkA "fruktansvдrd" "fruktansvдrt" ;
  fruktbaerande_av_1 = mkA "fruktbдrande" ;
  fruktbar_av_1 = mkA "fruktbar" ;
  fruktbarhet_nn_1 = mkN "fruktbarhet" "fruktbarheter" ;
  fruktbarhetsgud_nn_1 = mkN "fruktbarhetsgud" ;
  fruktbringande_av_1 = mkA "fruktbringande" ;
  fruktig_av_1 = mkA "fruktig" ;
  fruktkniv_nn_1 = mkN "fruktkniv" ;
  fruktkompott_nn_1 = mkN "fruktkompott" "fruktkompotter" ;
  fruktliknande_av_1 = mkA "fruktliknande" ;
  fruktloes_av_1 = mkA "fruktlцs" ;
  fruktodlare_nn_1 = mkN "fruktodlare" "fruktodlare" ;
  fruktodling_nn_1 = mkN "fruktodling" ;
  fruktsallad_nn_1 = mkN "fruktsallad" "fruktsallader" ;
  fruktsam_av_1 = mkA "fruktsam" "fruktsamt" "fruktsamma" "fruktsamma" "fruktsammare" "fruktsammast" "fruktsammaste" ;
  fruktsporre_nn_1 = mkN "fruktsporre" utrum ;
  frukttraed_nn_1 = mkN "frukttrдd" neutrum ;
  frukttraedgaard_nn_1 = mkN "frukttrдdgеrd" ;
  fruktvaegg_nn_1 = mkN "fruktvдgg" ;
  fruntimmer_nn_1 = mkN "fruntimmer" neutrum ;
  fruntimmerskarl_nn_1 = mkN "fruntimmerskarl" ;
  frusen_av_1 = mkA "frusen" "fruset" ;
  frustration_nn_1 = mkN "frustration" "frustrationer" ;
  fryntlig_av_1 = mkA "fryntlig" ;
  frys_nn_1 = mkN "frys" ;
  frysbox_nn_1 = mkN "frysbox" ;
  frysdisk_nn_1 = mkN "frysdisk" ;
  fryseri_nn_1 = mkN "fryseri" "fryserit" "fryserier" "fryserierna" ;
  frysfack_nn_1 = mkN "frysfack" neutrum ;
  frysfoersoek_nn_1 = mkN "frysfцrsцk" neutrum ;
  fryspunkt_nn_1 = mkN "fryspunkt" "fryspunkter" ;
  fryst_av_1 = mkA "fryst" "fryst" ;
  frystaalig_av_1 = mkA "frystеlig" ;
  frystest_nn_1 = mkN "frystest" neutrum ;
  fuffens_nn_1 = mkN "fuffens" neutrum ;
  fuktig_av_1 = mkA "fuktig" ;
  fuktighet_nn_1 = mkN "fuktighet" "fuktigheter" ;
  ful_av_1 = mkA "ful" ;
  fuling_nn_1 = mkN "fuling" ;
  full_av_1 = mkA "full" ;
  fullblod_nn_1 = mkN "fullblod" neutrum ;
  fullgaangen_av_1 = mkA "fullgеngen" "fullgеnget" ;
  fullgod_av_1 = mkA "fullgod" ;
  fullkomlig_av_1 = mkA "fullkomlig" ;
  fullkornsbroed_nn_1 = mkN "fullkornsbrцd" neutrum ;
  fullmaane_nn_1 = mkN "fullmеne" utrum ;
  fullmaektig_nn_1 = mkN "fullmдktig" "fullmдktigen" "fullmдktige" "fullmдktigena" ;
  fullmakt_nn_1 = mkN "fullmakt" "fullmakter" ;
  fullmaktslag_nn_1 = mkN "fullmaktslag" ;
  fullmogen_av_1 = mkA "fullmogen" "fullmoget" ;
  fulloedig_av_1 = mkA "fullцdig" ;
  fullriggare_nn_1 = mkN "fullriggare" "fullriggare" ;
  fullsatt_av_1 = mkA "fullsatt" ;
  fullstaemmig_av_1 = mkA "fullstдmmig" ;
  fullstaendig_av_1 = mkA "fullstдndig" ;
  fullstaendighet_nn_1 = mkN "fullstдndighet" "fullstдndigheter" ;
  fulltalig_av_1 = mkA "fulltalig" ;
  fulltonig_av_1 = mkA "fulltonig" ;
  fulltraeff_nn_1 = mkN "fulltrдff" ;
  fullvaerdesfoersaekring_nn_1 = mkN "fullvдrdesfцrsдkring" ;
  fullvaerdig_av_1 = mkA "fullvдrdig" ;
  fullvuxen_av_1 = mkA "fullvuxen" "fullvuxet" ;
  fulsnygg_av_1 = mkA "fulsnygg" ;
  fumlig_av_1 = mkA "fumlig" ;
  fundament_nn_1 = mkN "fundament" neutrum ;
  fundamental_av_1 = mkA "fundamental" ;
  fundamentalist_nn_1 = mkN "fundamentalist" "fundamentalister" ;
  funderare_nn_1 = mkN "funderare" "funderare" ;
  fundering_nn_1 = mkN "fundering" ;
  fundersam_av_1 = mkA "fundersam" "fundersamt" "fundersamma" "fundersamma" "fundersammare" "fundersammast" "fundersammaste" ;
  funktion_nn_1 = mkN "funktion" "funktioner" ;
  funktionaer_nn_1 = mkN "funktionдr" "funktionдrer" ;
  funktionalist_nn_1 = mkN "funktionalist" "funktionalister" ;
  funktionalistisk_av_1 = mkA "funktionalistisk" ;
  funktionell_av_1 = mkA "funktionell" ;
  funktionsduglig_av_1 = mkA "funktionsduglig" ;
  funktionsvaerde_nn_1 = mkN "funktionsvдrde" ;
  furie_nn_1 = mkN "furie" "furier" ;
  furioso_ab_1 = mkAdv "furioso" ;
  furioso_nn_1 = mkN "furioso" "furiosot" "furioson" "furiosona" ;
  furir_nn_1 = mkN "furir" "furirer" ;
  furnissoer_nn_1 = mkN "furnissцr" "furnissцrer" ;
  furstbiskop_nn_1 = mkN "furstbiskop" ;
  furste_nn_1 = mkN "furste" utrum ;
  fursteaett_nn_1 = mkN "fursteдtt" "fursteдtter" ;
  furstlig_av_1 = mkA "furstlig" ;
  furunkel_nn_1 = mkN "furunkel" ;
  fusion_nn_1 = mkN "fusion" "fusioner" ;
  fusklapp_nn_1 = mkN "fusklapp" ;
  fuskverk_nn_1 = mkN "fuskverk" neutrum ;
  futhark_nn_1 = mkN "futhark" "futharker" ;
  futil_av_1 = mkA "futil" ;
  futilitet_nn_1 = mkN "futilitet" "futiliteter" ;
  futt_nn_1 = mkN "futt" ;
  futtig_av_1 = mkA "futtig" ;
  futural_av_1 = mkA "futural" ;
  futurist_nn_1 = mkN "futurist" "futurister" ;
  futuristisk_av_1 = mkA "futuristisk" ;
  futurolog_nn_1 = mkN "futurolog" "futurologer" ;
  futurologisk_av_1 = mkA "futurologisk" ;
  futurum_nn_1 = mkN "futurum" "futurum" "futurer" "futurerna" ;
  fux_nn_1 = mkN "fux" ;
  fylking_nn_1 = mkN "fylking" ;
  fyllbult_nn_1 = mkN "fyllbult" ;
  fylld_av_1 = mkA "fylld" "fyllt" ;
  fyllerist_nn_1 = mkN "fyllerist" "fyllerister" ;
  fyllig_av_1 = mkA "fyllig" ;
  fyllnad_nn_1 = mkN "fyllnad" "fyllnader" ;
  fyllnadstjaenstgoering_nn_1 = mkN "fyllnadstjдnstgцring" ;
  fyllnadsval_nn_1 = mkN "fyllnadsval" neutrum ;
  fyllning_nn_1 = mkN "fyllning" ;
  fyllo_nn_1 = mkN "fyllo" "fyllot" "fyllon" "fyllona" ;
  fylogenetisk_av_1 = mkA "fylogenetisk" ;
  fynd_nn_1 = mkN "fynd" neutrum ;
  fyndig_av_1 = mkA "fyndig" ;
  fyndighet_nn_1 = mkN "fyndighet" "fyndigheter" ;
  fyndort_nn_1 = mkN "fyndort" "fyndorter" ;
  fyndplats_nn_1 = mkN "fyndplats" "fyndplatser" ;
  fyndpris_nn_1 = mkN "fyndpris" neutrum ;
  fyr_nn_1 = mkN "fyr" ;
  fyraaarig_av_1 = mkA "fyraеrig" ;
  fyrbaak_nn_1 = mkN "fyrbеk" ;
  fyrbackslinje_nn_1 = mkN "fyrbackslinje" "fyrbackslinjer" ;
  fyrbent_av_1 = mkA "fyrbent" "fyrbent" ;
  fyrcylindrig_av_1 = mkA "fyrcylindrig" ;
  fyrdubbel_av_1 = mkA "fyrdubbel" "fyrdubbelt" "fyrdubbla" "fyrdubbla" "fyrdubblare" "fyrdubblast" "fyrdubblaste" ;
  fyrfaergstryck_nn_1 = mkN "fyrfдrgstryck" neutrum ;
  fyrfaldig_av_1 = mkA "fyrfaldig" ;
  fyrfalt_ab_1 = mkAdv "fyrfalt" ;
  fyrfota_av_1 = mkA "fyrfota" ;
  fyrfotadjur_nn_1 = mkN "fyrfotadjur" neutrum ;
  fyrfoting_nn_1 = mkN "fyrfoting" ;
  fyrhaendig_av_1 = mkA "fyrhдndig" ;
  fyrhandssaettning_nn_1 = mkN "fyrhandssдttning" ;
  fyrhoerning_nn_1 = mkN "fyrhцrning" ;
  fyrk_nn_1 = mkN "fyrk" ;
  fyrkant_nn_1 = mkN "fyrkant" "fyrkanter" ;
  fyrkantig_av_1 = mkA "fyrkantig" ;
  fyrkaraktaer_nn_1 = mkN "fyrkaraktдr" "fyrkaraktдrer" ;
  fyrling_nn_1 = mkN "fyrling" ;
  fyrljus_nn_1 = mkN "fyrljus" neutrum ;
  fyrmaenning_nn_1 = mkN "fyrmдnning" ;
  fyrmotorig_av_1 = mkA "fyrmotorig" ;
  fyrop_nn_1 = mkN "fyrop" neutrum ;
  fyrsiding_nn_1 = mkN "fyrsiding" ;
  fyrsiffrig_av_1 = mkA "fyrsiffrig" ;
  fyrsitsig_av_1 = mkA "fyrsitsig" ;
  fyrskepp_nn_1 = mkN "fyrskepp" neutrum ;
  fyrspann_nn_1 = mkN "fyrspann" neutrum ;
  fyrtaktare_nn_1 = mkN "fyrtaktare" "fyrtaktare" ;
  fyrtaktsmotor_nn_1 = mkN "fyrtaktsmotor" "fyrtaktsmotorer" ;
  fyrtal_nn_1 = mkN "fyrtal" "fyrtalet" "fyrtalen" "fyrtalena" ;
  fyrtiotalist_nn_1 = mkN "fyrtiotalist" "fyrtiotalister" ;
  fyrtiotimmarsvecka_nn_1 = mkN "fyrtiotimmarsvecka" ;
  fyrtitalism_nn_1 = mkN "fyrtitalism" "fyrtitalismer" ;
  fyrtitalist_nn_1 = mkN "fyrtitalist" "fyrtitalister" ;
  fyrtorn_nn_1 = mkN "fyrtorn" neutrum ;
  fyrvaeldig_av_1 = mkA "fyrvдldig" ;
  fyrvaeppling_nn_1 = mkN "fyrvдppling" ;
  fyrvaktare_nn_1 = mkN "fyrvaktare" "fyrvaktare" ;
  fyrverkare_nn_1 = mkN "fyrverkare" "fyrverkare" ;
  fyrverkeri_nn_1 = mkN "fyrverkeri" "fyrverkerit" "fyrverkerier" "fyrverkerierna" ;
  fyrverkeripjaes_nn_1 = mkN "fyrverkeripjдs" "fyrverkeripjдser" ;
  fysikalisk_av_1 = mkA "fysikalisk" ;
  fysiker_nn_1 = mkN "fysiker" "fysikern" "fysiker" "fysikerna" ;
  fysikforskare_nn_1 = mkN "fysikforskare" "fysikforskare" ;
  fysikforskning_nn_1 = mkN "fysikforskning" ;
  fysikvetenskap_nn_1 = mkN "fysikvetenskap" "fysikvetenskaper" ;
  fysiokrat_nn_1 = mkN "fysiokrat" "fysiokrater" ;
  fysiokratisk_av_1 = mkA "fysiokratisk" ;
  fysiolog_nn_1 = mkN "fysiolog" "fysiologer" ;
  fysiologisk_av_1 = mkA "fysiologisk" ;
  fysionomi_nn_1 = mkN "fysionomi" "fysionomier" ;
  fysisk_av_1 = mkA "fysisk" ;
  fytotron_nn_1 = mkN "fytotron" "fytotroner" ;
  g_draekt_nn_1 = mkN "g-drдkt" "g-drдkter" ;
  g_klav_nn_1 = mkN "g-klav" "g-klaver" ;
  gaa_vb_1 = mkV "gе" "gеr" "gе" "gick" "gеtt" "gеngen" ;
  gaabock_nn_1 = mkN "gеbock" ;
  gaagosse_nn_1 = mkN "gеgosse" utrum ;
  gaang_nn_1 = mkN "gеng" ;
  gaang_nn_2 = mkN "gеng" "gеnger" ;
  gaangare_nn_1 = mkN "gеngare" "gеngare" ;
  gaangart_nn_1 = mkN "gеngart" "gеngarter" ;
  gaangavstaand_nn_1 = mkN "gеngavstеnd" neutrum ;
  gaangbar_av_1 = mkA "gеngbar" ;
  gaangbergart_nn_1 = mkN "gеngbergart" "gеngbergarter" ;
  gaangbord_nn_1 = mkN "gеngbord" neutrum ;
  gaangbro_nn_1 = mkN "gеngbro" ;
  gaangfot_nn_1 = mkN "gеngfot" "gеngfцtter" ;
  gaanggrift_nn_1 = mkN "gеnggrift" "gеnggrifter" ;
  gaangjaern_nn_1 = mkN "gеngjдrn" neutrum ;
  gaanglaat_nn_1 = mkN "gеnglеt" ;
  gaangled_nn_1 = mkN "gеngled" "gеngleder" ;
  gaangspel_nn_1 = mkN "gеngspel" "gеngspelet" "gеngspel" "gеngspelen" ;
  gaangstol_nn_1 = mkN "gеngstol" ;
  gaangvaeg_nn_1 = mkN "gеngvдg" ;
  gaapaaare_nn_1 = mkN "gеpеare" "gеpеare" ;
  gaapaaig_av_1 = mkA "gеpеig" ;
  gaard_nn_1 = mkN "gеrd" ;
  gaardag_nn_1 = mkN "gеrdag" ;
  gaardfarihandlande_nn_1 = mkN "gеrdfarihandlande" "gеrdfarihandlanden" "gеrdfarihandlande" "gеrdfarihandlandena" ;
  gaardfarihandlare_nn_1 = mkN "gеrdfarihandlare" "gеrdfarihandlare" ;
  gaarding_nn_1 = mkN "gеrding" ;
  gaardshus_nn_1 = mkN "gеrdshus" neutrum ;
  gaardskarl_nn_1 = mkN "gеrdskarl" ;
  gaardskulle_nn_1 = mkN "gеrdskulle" utrum ;
  gaardsmusikant_nn_1 = mkN "gеrdsmusikant" "gеrdsmusikanter" ;
  gaardsomraade_nn_1 = mkN "gеrdsomrеde" ;
  gaardsplan_nn_1 = mkN "gеrdsplan" "gеrdsplaner" ;
  gaardsplats_nn_1 = mkN "gеrdsplats" "gеrdsplatser" ;
  gaardsrum_nn_1 = mkN "gеrdsrum" "gеrdsrummet" "gеrdsrum" "gеrdsrummen" ;
  gaardvar_nn_1 = mkN "gеrdvar" ;
  gaas_nn_1 = mkN "gеs" "gеsen" "gдss" "gдssen" ;
  gaasbroest_nn_1 = mkN "gеsbrцst" neutrum ;
  gaase_nn_1 = mkN "gеse" utrum ;
  gaasfjaeder_nn_1 = mkN "gеsfjдder" ;
  gaasfot_nn_1 = mkN "gеsfot" "gеsfцtter" ;
  gaaskarl_nn_1 = mkN "gеskarl" ;
  gaastol_nn_1 = mkN "gеstol" ;
  gaasunge_nn_1 = mkN "gеsunge" utrum ;
  gaat_nn_1 = mkN "gеt" ;
  gaatfull_av_1 = mkA "gеtfull" ;
  gaava_nn_1 = mkN "gеva" ;
  gaavoavtal_nn_1 = mkN "gеvoavtal" "gеvoavtalet" "gеvoavtalen" "gеvoavtalena" ;
  gaavobrev_nn_1 = mkN "gеvobrev" neutrum ;
  gaavohandling_nn_1 = mkN "gеvohandling" ;
  gabon_nn_2 = mkN "gabon" "gaboner" ;
  gabondoerr_nn_1 = mkN "gabondцrr" ;
  gabones_nn_1 = mkN "gabones" "gaboneser" ;
  gabonhuggorm_nn_1 = mkN "gabonhuggorm" ;
  gadd_nn_1 = mkN "gadd" ;
  gaddloes_av_1 = mkA "gaddlцs" ;
  gaddstekel_nn_1 = mkN "gaddstekel" ;
  gaeck_ab_1 = mkAdv "gдck" ;
  gaeckeri_nn_1 = mkN "gдckeri" "gдckerit" "gдckerier" "gдckerierna" ;
  gaeckmast_nn_1 = mkN "gдckmast" "gдckmaster" ;
  gaecksam_av_1 = mkA "gдcksam" "gдcksamt" "gдcksamma" "gдcksamma" "gдcksammare" "gдcksammast" "gдcksammaste" ;
  gaeddsax_nn_1 = mkN "gдddsax" ;
  gael_nn_1 = mkN "gдl" ;
  gael_nn_2 = mkN "gдl" "gдler" ;
  gaelbaage_nn_1 = mkN "gдlbеge" utrum ;
  gaelbgjutare_nn_1 = mkN "gдlbgjutare" "gдlbgjutare" ;
  gaelbgjuteri_nn_1 = mkN "gдlbgjuteri" "gдlbgjuterit" "gдlbgjuterier" "gдlbgjuterierna" ;
  gaelblad_nn_1 = mkN "gдlblad" neutrum ;
  gaelda_vb_1 = mkV "gдlda" ;
  gaeldbunden_av_1 = mkA "gдldbunden" "gдldbundet" ;
  gaeldenaer_nn_1 = mkN "gдldenдr" "gдldenдrer" ;
  gaeldstuga_nn_1 = mkN "gдldstuga" ;
  gaelisk_av_1 = mkA "gaelisk" ;
  gaeliska_nn_2 = mkN "gaeliska" ;
  gaell_av_1 = mkA "gдll" ;
  gaellen_av_1 = mkA "gдllen" "gдllet" ;
  gaems_nn_1 = mkN "gдms" "gдmser" ;
  gaeng_nn_1 = mkN "gдng" neutrum ;
  gaengback_nn_1 = mkN "gдngback" ;
  gaenglig_av_1 = mkA "gдnglig" ;
  gaengning_nn_1 = mkN "gдngning" ;
  gaengse_av_1 = mkA "gдngse" ;
  gaengstaal_nn_1 = mkN "gдngstеl" neutrum ;
  gaengtapp_nn_1 = mkN "gдngtapp" ;
  gaengtolk_nn_1 = mkN "gдngtolk" ;
  gaerd_nn_1 = mkN "gдrd" "gдrder" ;
  gaerde_nn_1 = mkN "gдrde" ;
  gaerdesgaard_nn_1 = mkN "gдrdesgеrd" ;
  gaerdning_nn_1 = mkN "gдrdning" ;
  gaerdsel_nn_1 = mkN "gдrdsel" neutrum ;
  gaerdsgaard_nn_1 = mkN "gдrdsgеrd" ;
  gaerdsgaardsstoer_nn_1 = mkN "gдrdsgеrdsstцr" ;
  gaerdsmyg_nn_1 = mkN "gдrdsmyg" ;
  gaerna_ab_1 = mkAdv "gдrna" ;
  gaerning_nn_1 = mkN "gдrning" ;
  gaerningsman_nn_1 = mkN "gдrningsman" "gдrningsmannen" "gдrningsmдn" "gдrningsmдnnen" ;
  gaerningsort_nn_1 = mkN "gдrningsort" "gдrningsorter" ;
  gaers_nn_1 = mkN "gдrs" ;
  gaesp_nn_1 = mkN "gдsp" neutrum ;
  gaespig_av_1 = mkA "gдspig" ;
  gaespning_nn_1 = mkN "gдspning" ;
  gaessling_nn_1 = mkN "gдssling" ;
  gaest_nn_1 = mkN "gдst" "gдster" ;
  gaestabud_nn_1 = mkN "gдstabud" neutrum ;
  gaestarbetare_nn_1 = mkN "gдstarbetare" "gдstarbetare" ;
  gaestbok_nn_1 = mkN "gдstbok" "gдstbцcker" ;
  gaestfri_av_1 = mkA "gдstfri" "gдstfritt" ;
  gaestgivare_nn_1 = mkN "gдstgivare" "gдstgivare" ;
  gaestgivargaard_nn_1 = mkN "gдstgivargеrd" ;
  gaestgiveri_nn_1 = mkN "gдstgiveri" "gдstgiverit" "gдstgiverier" "gдstgiverierna" ;
  gaesthandduk_nn_1 = mkN "gдsthandduk" ;
  gaestnatt_nn_1 = mkN "gдstnatt" "gдstnдtter" ;
  gaestning_nn_1 = mkN "gдstning" ;
  gaestrike_nn_1 = mkN "gдstrike" utrum ;
  gaestriking_nn_1 = mkN "gдstriking" ;
  gaestriklaendska_nn_1 = mkN "gдstriklдndska" ;
  gaestriklaenning_nn_1 = mkN "gдstriklдnning" ;
  gaestring_nn_1 = mkN "gдstring" ;
  gaestrisk_av_1 = mkA "gдstrisk" ;
  gaestrum_nn_1 = mkN "gдstrum" "gдstrummet" "gдstrum" "gдstrummen" ;
  gaestspel_nn_1 = mkN "gдstspel" "gдstspelet" "gдstspel" "gдstspelen" ;
  gaestvaenlig_av_1 = mkA "gдstvдnlig" ;
  gaff_nn_1 = mkN "gaff" ;
  gaffel_nn_1 = mkN "gaffel" ;
  gaffelantilop_nn_1 = mkN "gaffelantilop" "gaffelantiloper" ;
  gaffelbit_nn_1 = mkN "gaffelbit" ;
  gaffelbock_nn_1 = mkN "gaffelbock" ;
  gaffelhjort_nn_1 = mkN "gaffelhjort" ;
  gaffelklo_nn_1 = mkN "gaffelklo" "gaffelklor" ;
  gaffelrigg_nn_1 = mkN "gaffelrigg" ;
  gaffelsegel_nn_1 = mkN "gaffelsegel" neutrum ;
  gaffeltruck_nn_1 = mkN "gaffeltruck" ;
  gafflan_ab_1 = mkAdv "gafflan" ;
  gag_nn_1 = mkN "gag" neutrum ;
  gagat_nn_1 = mkN "gagat" "gagater" ;
  gagatsvart_av_1 = mkA "gagatsvart" "gagatsvart" ;
  gage_nn_1 = mkN "gage" "gaget" "gage" "gagen" ;
  gaggig_av_1 = mkA "gaggig" ;
  gagnelig_av_1 = mkA "gagnelig" ;
  gagnerik_av_1 = mkA "gagnerik" ;
  gagnloes_av_1 = mkA "gagnlцs" ;
  gagnrik_av_1 = mkA "gagnrik" ;
  gagnvaext_nn_1 = mkN "gagnvдxt" "gagnvдxter" ;
  gaillarde_nn_1 = mkN "gaillarde" "gaillarder" ;
  gaj_nn_1 = mkN "gaj" ;
  galaer_nn_1 = mkN "galдr" "galдrer" ;
  galaerslav_nn_1 = mkN "galдrslav" ;
  galaktisk_av_1 = mkA "galaktisk" ;
  galant_ab_1 = mkAdv "galant" ;
  galant_av_1 = mkA "galant" "galant" ;
  galanteri_nn_1 = mkN "galanteri" "galanterit" "galanterier" "galanterierna" ;
  galat_nn_1 = mkN "galat" "galater" ;
  galavagn_nn_1 = mkN "galavagn" ;
  galax_nn_1 = mkN "galax" "galaxer" ;
  galaxbildning_nn_1 = mkN "galaxbildning" ;
  galaxcentrum_nn_1 = mkN "galaxcentrum" neutrum ;
  galaxhop_nn_1 = mkN "galaxhop" ;
  galaxspektrum_nn_1 = mkN "galaxspektrum" neutrum ;
  galaxvaerld_nn_1 = mkN "galaxvдrld" ;
  galder_nn_1 = mkN "galder" ;
  galeas_nn_1 = mkN "galeas" "galeaser" ;
  galen_av_1 = mkA "galen" "galet" ;
  galenskap_nn_1 = mkN "galenskap" "galenskaper" ;
  galgbacke_nn_1 = mkN "galgbacke" utrum ;
  galge_nn_1 = mkN "galge" utrum ;
  galgfaagel_nn_1 = mkN "galgfеgel" ;
  galicisk_av_1 = mkA "galicisk" ;
  galile_nn_1 = mkN "galilй" "galilйer" ;
  galjon_nn_1 = mkN "galjon" "galjoner" ;
  galjonsbild_nn_1 = mkN "galjonsbild" "galjonsbilder" ;
  galjonsfigur_nn_1 = mkN "galjonsfigur" "galjonsfigurer" ;
  gall_av_1 = mkA "gall" ;
  gall_nn_1 = mkN "gall" "galler" ;
  gallbildning_nn_1 = mkN "gallbildning" ;
  galldrivande_av_1 = mkA "galldrivande" ;
  galler_nn_1 = mkN "galler" neutrum ;
  galler_nn_2 = mkN "galler" "gallern" "galler" "gallerna" ;
  galleri_nn_1 = mkN "galleri" "gallerit" "gallerier" "gallerierna" ;
  galleriskog_nn_1 = mkN "galleriskog" ;
  gallerist_nn_1 = mkN "gallerist" "gallerister" ;
  gallerverk_nn_1 = mkN "gallerverk" neutrum ;
  gallgaang_nn_1 = mkN "gallgеng" ;
  gallicism_nn_1 = mkN "gallicism" "gallicismer" ;
  gallier_nn_1 = mkN "gallier" "galliern" "gallier" "gallierna" ;
  gallion_nn_1 = mkN "gallion" "gallioner" ;
  gallisk_av_1 = mkA "gallisk" ;
  gallko_nn_1 = mkN "gallko" "gallkor" ;
  gallkvalster_nn_1 = mkN "gallkvalster" neutrum ;
  gallon_nn_1 = mkN "gallon" "gallonen" "gallon" "gallonen" ;
  gallring_nn_1 = mkN "gallring" ;
  gallsjuk_av_1 = mkA "gallsjuk" ;
  gallskrik_nn_1 = mkN "gallskrik" neutrum ;
  gallspraengd_av_1 = mkA "gallsprдngd" "gallsprдngt" ;
  gallstekel_nn_1 = mkN "gallstekel" ;
  gallsten_nn_1 = mkN "gallsten" "gallstenen" "gallstenar" "gallstenarna" ;
  galltjut_nn_1 = mkN "galltjut" neutrum ;
  gallup_nn_1 = mkN "gallup" ;
  galning_nn_1 = mkN "galning" ;
  galon_nn_2 = mkN "galon" "galoner" ;
  galopp_nn_1 = mkN "galopp" "galopper" ;
  galoppad_nn_1 = mkN "galoppad" "galoppader" ;
  galopptaevling_nn_1 = mkN "galopptдvling" ;
  galosch_nn_1 = mkN "galosch" "galoscher" ;
  galt_nn_1 = mkN "galt" ;
  galvanisk_av_1 = mkA "galvanisk" ;
  galvanometer_nn_1 = mkN "galvanometer" ;
  galvanoskop_nn_1 = mkN "galvanoskop" neutrum ;
  galvanotyp_nn_1 = mkN "galvanotyp" "galvanotyper" ;
  gam_nn_1 = mkN "gam" ;
  gamaeng_nn_1 = mkN "gamдng" "gamдnger" ;
  gamasch_nn_1 = mkN "gamasch" "gamascher" ;
  gambier_nn_1 = mkN "gambier" "gambiern" "gambier" "gambierna" ;
  gambisk_av_1 = mkA "gambisk" ;
  gambit_nn_1 = mkN "gambit" ;
  game_nn_1 = mkN "game" "gamet" "game" "gamen" ;
  gamet_nn_1 = mkN "gamet" "gameter" ;
  gamling_nn_1 = mkN "gamling" ;
  gamma_nn_1 = mkN "gamma" "gammat" "gamman" "gammana" ;
  gammafly_nn_1 = mkN "gammafly" "gammaflyt" "gammaflyn" "gammaflyen" ;
  gammaglobulin_nn_1 = mkN "gammaglobulin" "gammaglobuliner" ;
  gammakamera_nn_1 = mkN "gammakamera" ;
  gammal_av_1 = mkA "gammal" "gammalt" "gamla" "дldre" "дldst" ;
  gammaldags_av_1 = mkA "gammaldags" ;
  gammaldans_nn_1 = mkN "gammaldans" "gammaldanser" ;
  gammalkommunist_nn_1 = mkN "gammalkommunist" "gammalkommunister" ;
  gammalkristen_av_1 = mkA "gammalkristen" "gammalkristet" ;
  gammalkyrklig_av_1 = mkA "gammalkyrklig" ;
  gammalmodig_av_1 = mkA "gammalmodig" ;
  gammalrosa_av_1 = mkA "gammalrosa" ;
  gammaltestamentlig_av_1 = mkA "gammaltestamentlig" ;
  gammalvals_nn_1 = mkN "gammalvals" "gammalvalser" ;
  gammastraale_nn_1 = mkN "gammastrеle" utrum ;
  gammeldans_nn_1 = mkN "gammeldans" "gammeldanser" ;
  gan_nn_1 = mkN "gan" ;
  ganasch_nn_1 = mkN "ganasch" "ganascher" ;
  ganglie_nn_1 = mkN "ganglie" "ganglier" ;
  gangrenoes_av_1 = mkA "gangrenцs" ;
  gangster_nn_1 = mkN "gangster" ;
  gans_nn_1 = mkN "gans" "ganser" ;
  ganska_ab_1 = mkAdv "ganska" ;
  ganymed_nn_1 = mkN "ganymed" "ganymeder" ;
  gap_nn_1 = mkN "gap" neutrum ;
  gaphals_nn_1 = mkN "gaphals" ;
  gapig_av_1 = mkA "gapig" ;
  gapsax_nn_1 = mkN "gapsax" ;
  gapskratt_nn_1 = mkN "gapskratt" neutrum ;
  gapstock_nn_1 = mkN "gapstock" ;
  garage_nn_1 = mkN "garage" "garaget" "garage" "garagen" ;
  garant_nn_1 = mkN "garant" "garanter" ;
  garanti_nn_1 = mkN "garanti" "garantier" ;
  garantifoerdrag_nn_1 = mkN "garantifцrdrag" neutrum ;
  garantifoersaekring_nn_1 = mkN "garantifцrsдkring" ;
  garantifond_nn_1 = mkN "garantifond" "garantifonder" ;
  garantilaan_nn_1 = mkN "garantilеn" neutrum ;
  gard_nn_1 = mkN "gard" "garder" ;
  garde_nn_1 = mkN "garde" ;
  gardering_nn_1 = mkN "gardering" ;
  garderob_nn_1 = mkN "garderob" "garderober" ;
  garderobiaer_nn_1 = mkN "garderobiдr" "garderobiдrer" ;
  garderobie_nn_1 = mkN "garderobiй" "garderobiйer" ;
  gardian_nn_1 = mkN "gardian" "gardianer" ;
  gardin_nn_1 = mkN "gardin" "gardiner" ;
  gardinband_nn_1 = mkN "gardinband" neutrum ;
  gardinluft_nn_1 = mkN "gardinluft" "gardinlufter" ;
  gardinring_nn_1 = mkN "gardinring" ;
  gardinstaang_nn_1 = mkN "gardinstеng" "gardinstдnger" ;
  gardist_nn_1 = mkN "gardist" "gardister" ;
  gardjaern_nn_1 = mkN "gardjдrn" neutrum ;
  garfaagel_nn_1 = mkN "garfеgel" ;
  garn_nn_1 = mkN "garn" neutrum ;
  garnbom_nn_1 = mkN "garnbom" "garnbommen" "garnbommar" "garnbommarna" ;
  garnering_nn_1 = mkN "garnering" ;
  garnhank_nn_1 = mkN "garnhank" ;
  garnison_nn_1 = mkN "garnison" "garnisoner" ;
  garnityr_nn_1 = mkN "garnityr" neutrum ;
  garnspole_nn_1 = mkN "garnspole" utrum ;
  garson_nn_1 = mkN "garзon" "garзoner" ;
  garsong_nn_1 = mkN "garsong" "garsonger" ;
  gartner_nn_1 = mkN "gartner" "gartnern" "gartner" "gartnerna" ;
  garv_nn_1 = mkN "garv" neutrum ;
  garvaemne_nn_1 = mkN "garvдmne" ;
  garvare_nn_1 = mkN "garvare" "garvare" ;
  garveri_nn_1 = mkN "garveri" "garverit" "garverier" "garverierna" ;
  garvmedel_nn_1 = mkN "garvmedel" neutrum ;
  garvning_nn_1 = mkN "garvning" ;
  gas_nn_1 = mkN "gas" "gaser" ;
  gas_nn_2 = mkN "gas" "gaser" ;
  gasackumulator_nn_1 = mkN "gasackumulator" "gasackumulatorer" ;
  gasblandning_nn_1 = mkN "gasblandning" ;
  gasbraennare_nn_1 = mkN "gasbrдnnare" "gasbrдnnare" ;
  gasbubbla_nn_1 = mkN "gasbubbla" ;
  gascognare_nn_1 = mkN "gascognare" "gascognare" ;
  gasell_nn_1 = mkN "gasell" "gaseller" ;
  gaseruption_nn_1 = mkN "gaseruption" "gaseruptioner" ;
  gasett_nn_1 = mkN "gasett" "gasetter" ;
  gasformig_av_1 = mkA "gasformig" ;
  gasgenerator_nn_1 = mkN "gasgenerator" "gasgeneratorer" ;
  gask_nn_1 = mkN "gask" ;
  gaskammare_nn_1 = mkN "gaskammare" "gaskammaren" "gaskamrar" "gaskamrarna" ;
  gasklot_nn_1 = mkN "gasklot" neutrum ;
  gaskromatograf_nn_1 = mkN "gaskromatograf" "gaskromatografer" ;
  gaskropp_nn_1 = mkN "gaskropp" ;
  gaslaeckage_nn_1 = mkN "gaslдckage" "gaslдckaget" "gaslдckage" "gaslдckagen" ;
  gaslaera_nn_1 = mkN "gaslдra" ;
  gasmask_nn_1 = mkN "gasmask" "gasmasker" ;
  gasmoln_nn_1 = mkN "gasmoln" neutrum ;
  gasolkoek_nn_1 = mkN "gasolkцk" neutrum ;
  gasoltub_nn_1 = mkN "gasoltub" "gasoltuber" ;
  gasometer_nn_1 = mkN "gasometer" ;
  gaspedal_nn_1 = mkN "gaspedal" "gaspedaler" ;
  gassig_av_1 = mkA "gassig" ;
  gasskydd_nn_1 = mkN "gasskydd" neutrum ;
  gasspis_nn_1 = mkN "gasspis" ;
  gasstroem_nn_1 = mkN "gasstrцm" "gasstrцmmen" "gasstrцmmar" "gasstrцmmarna" ;
  gast_nn_1 = mkN "gast" ;
  gastrisk_av_1 = mkA "gastrisk" ;
  gastrit_nn_1 = mkN "gastrit" "gastriter" ;
  gastronom_nn_1 = mkN "gastronom" "gastronomer" ;
  gastronomisk_av_1 = mkA "gastronomisk" ;
  gastroskop_nn_1 = mkN "gastroskop" neutrum ;
  gastroskopi_nn_1 = mkN "gastroskopi" "gastroskopier" ;
  gastryck_nn_1 = mkN "gastryck" neutrum ;
  gasturbin_nn_1 = mkN "gasturbin" "gasturbiner" ;
  gasurladdning_nn_1 = mkN "gasurladdning" ;
  gasventil_nn_1 = mkN "gasventil" "gasventiler" ;
  gasverk_nn_1 = mkN "gasverk" neutrum ;
  gata_nn_1 = mkN "gata" ;
  gathoern_nn_1 = mkN "gathцrn" neutrum ;
  gathus_nn_1 = mkN "gathus" neutrum ;
  gatlaeggning_nn_1 = mkN "gatlдggning" ;
  gatlopp_nn_1 = mkN "gatlopp" neutrum ;
  gatpojke_nn_1 = mkN "gatpojke" utrum ;
  gatsopare_nn_1 = mkN "gatsopare" "gatsopare" ;
  gatsten_nn_1 = mkN "gatsten" "gatstenen" "gatstenar" "gatstenarna" ;
  gatt_nn_1 = mkN "gatt" neutrum ;
  gatubelaeggning_nn_1 = mkN "gatubelдggning" ;
  gatubelysning_nn_1 = mkN "gatubelysning" ;
  gatufoersaeljare_nn_1 = mkN "gatufцrsдljare" "gatufцrsдljare" ;
  gatukoek_nn_1 = mkN "gatukцk" neutrum ;
  gatukors_nn_1 = mkN "gatukors" neutrum ;
  gatukorsning_nn_1 = mkN "gatukorsning" ;
  gatuliv_nn_1 = mkN "gatuliv" neutrum ;
  gatunamn_nn_1 = mkN "gatunamn" neutrum ;
  gatunge_nn_1 = mkN "gatunge" utrum ;
  gatuplan_nn_1 = mkN "gatuplan" neutrum ;
  gaucho_nn_1 = mkN "gaucho" "gauchon" "gauchos" "gauchosen" ;
  gauge_nn_1 = mkN "gauge" "gaugen" "gauge" "gaugena" ;
  gaullist_nn_1 = mkN "gaullist" "gaullister" ;
  gaullistisk_av_1 = mkA "gaullistisk" ;
  gaur_nn_1 = mkN "gaur" "gaurer" ;
  gauss_nn_1 = mkN "gauss" "gaussen" "gauss" "gaussen" ;
  gavel_nn_1 = mkN "gavel" ;
  gavelfaelt_nn_1 = mkN "gavelfдlt" neutrum ;
  gavelhus_nn_1 = mkN "gavelhus" neutrum ;
  gavelroeste_nn_1 = mkN "gavelrцste" ;
  gavial_nn_1 = mkN "gavial" "gavialer" ;
  gavott_nn_1 = mkN "gavott" "gavotter" ;
  gay_av_1 = mkA "gay" ;
  gayal_nn_1 = mkN "gayal" "gayaler" ;
  ge_vb_1 = mkV "ge" "ger" "ge" "gav" "gett" "given" ;
  gebit_nn_1 = mkN "gebit" neutrum ;
  gecko_nn_1 = mkN "gecko" "geckor" ;
  gedigen_av_1 = mkA "gedigen" "gediget" ;
  geg_nn_1 = mkN "geg" "geger" ;
  geggig_av_1 = mkA "geggig" ;
  gehaeng_nn_1 = mkN "gehдng" neutrum ;
  geheimeraad_nn_1 = mkN "geheimerеd" neutrum ;
  geiger_mullerroer_nn_1 = mkN "geiger-mьllerrцr" neutrum ;
  geigermaetare_nn_1 = mkN "geigermдtare" "geigermдtare" ;
  gejd_nn_1 = mkN "gejd" "gejder" ;
  gejser_nn_1 = mkN "gejser" ;
  gel_nn_1 = mkN "gel" "gelet" "geler" "gelerna" ;
  gelaenk_nn_1 = mkN "gelдnk" neutrum ;
  gelatinkapsel_nn_1 = mkN "gelatinkapsel" ;
  gelatinoes_av_1 = mkA "gelatinцs" ;
  gelbgjutare_nn_1 = mkN "gelbgjutare" "gelbgjutare" ;
  gelbgjuteri_nn_1 = mkN "gelbgjuteri" "gelbgjuterit" "gelbgjuterier" "gelbgjuterierna" ;
  gele_nn_1 = mkN "gelй" "gelйer" ;
  gelehallon_nn_1 = mkN "gelйhallon" neutrum ;
  geleig_av_1 = mkA "geleig" ;
  geleklump_nn_1 = mkN "gelйklump" ;
  gelesvamp_nn_1 = mkN "gelйsvamp" ;
  gelike_nn_1 = mkN "gelike" utrum ;
  gem_nn_1 = mkN "gem" "gemmen" "gemmer" "gemmerna" ;
  gem_nn_2 = mkN "gem" neutrum ;
  gemaal_nn_1 = mkN "gemеl" "gemеler" ;
  gemak_nn_1 = mkN "gemak" neutrum ;
  gemen_av_1 = mkA "gemen" ;
  gemenhet_nn_1 = mkN "gemenhet" "gemenheter" ;
  gemenligen_ab_1 = mkAdv "gemenligen" ;
  gemensam_av_1 = mkA "gemensam" "gemensamt" "gemensamma" "gemensamma" "gemensammare" "gemensammast" "gemensammaste" ;
  gemensamhet_nn_1 = mkN "gemensamhet" "gemensamheter" ;
  gemensamhetsgrav_nn_1 = mkN "gemensamhetsgrav" ;
  gemination_nn_1 = mkN "gemination" "geminationer" ;
  geminering_nn_1 = mkN "geminering" ;
  gems_nn_1 = mkN "gems" "gemser" ;
  gemyt_nn_1 = mkN "gemyt" neutrum ;
  gemytlig_av_1 = mkA "gemytlig" ;
  gen_av_1 = mkA "gen" ;
  gen_nn_1 = mkN "gen" "gener" ;
  genant_av_1 = mkA "genant" "genant" ;
  genast_ab_1 = mkAdv "genast" ;
  gendarm_nn_1 = mkN "gendarm" "gendarmer" ;
  gendriva_vb_1 = mkV "gendriva" "gendrev" "gendrivit" ;
  genealog_nn_1 = mkN "genealog" "genealoger" ;
  genealogi_nn_1 = mkN "genealogi" "genealogier" ;
  general_nn_1 = mkN "general" "generaler" ;
  generalagent_nn_1 = mkN "generalagent" "generalagenter" ;
  generaldirektoer_nn_1 = mkN "generaldirektцr" "generaldirektцrer" ;
  generalfoersamling_nn_1 = mkN "generalfцrsamling" ;
  generalguvernoer_nn_1 = mkN "generalguvernцr" "generalguvernцrer" ;
  generalisation_nn_1 = mkN "generalisation" "generalisationer" ;
  generalisering_nn_1 = mkN "generalisering" ;
  generalist_nn_1 = mkN "generalist" "generalister" ;
  generalitet_nn_2 = mkN "generalitet" "generaliteter" ;
  generalkonsul_nn_1 = mkN "generalkonsul" "generalkonsuln" "generalkonsuler" "generalkonsulerna" ;
  generalkonsulat_nn_1 = mkN "generalkonsulat" neutrum ;
  generalloejtnant_nn_1 = mkN "generallцjtnant" "generallцjtnanter" ;
  generalmajor_nn_1 = mkN "generalmajor" "generalmajorer" ;
  generaloeverste_nn_1 = mkN "generalцverste" utrum ;
  generalpaus_nn_1 = mkN "generalpaus" "generalpauser" ;
  generalplan_nn_1 = mkN "generalplan" "generalplaner" ;
  generalrep_nn_1 = mkN "generalrep" neutrum ;
  generalrepetition_nn_1 = mkN "generalrepetition" "generalrepetitioner" ;
  generalsekreterare_nn_1 = mkN "generalsekreterare" "generalsekreterare" ;
  generalsperson_nn_1 = mkN "generalsperson" "generalspersoner" ;
  generalstab_nn_1 = mkN "generalstab" "generalstaber" ;
  generalstrejk_nn_1 = mkN "generalstrejk" "generalstrejker" ;
  generande_av_1 = mkA "generande" ;
  generation_nn_1 = mkN "generation" "generationer" ;
  generationstid_nn_1 = mkN "generationstid" "generationstider" ;
  generationsvaexling_nn_1 = mkN "generationsvдxling" ;
  generativ_av_1 = mkA "generativ" ;
  generator_nn_1 = mkN "generator" "generatorer" ;
  generatris_nn_1 = mkN "generatris" "generatriser" ;
  generell_av_1 = mkA "generell" ;
  generisk_av_1 = mkA "generisk" ;
  generoes_av_1 = mkA "generцs" ;
  generositet_nn_1 = mkN "generositet" "generositeter" ;
  genetiker_nn_1 = mkN "genetiker" "genetikern" "genetiker" "genetikerna" ;
  genetisk_av_1 = mkA "genetisk" ;
  genett_nn_1 = mkN "genett" "genetter" ;
  genfordran_nn_1 = mkN "genfordran" "genfordran" "genfordringar" "genfordringarna" ;
  genfordring_nn_1 = mkN "genfordring" ;
  gengaangare_nn_1 = mkN "gengеngare" "gengеngare" ;
  geni_nn_1 = mkN "geni" "genit" "genier" "genierna" ;
  genial_av_1 = mkA "genial" ;
  genialisk_av_1 = mkA "genialisk" ;
  genialitet_nn_1 = mkN "genialitet" "genialiteter" ;
  genie_nn_1 = mkN "genie" "genier" ;
  genitiv_nn_1 = mkN "genitiv" "genitiver" ;
  genitivattribut_nn_1 = mkN "genitivattribut" neutrum ;
  genkaerande_nn_1 = mkN "genkдrande" "genkдranden" "genkдrande" "genkдrandena" ;
  genmaele_nn_1 = mkN "genmдle" ;
  genmanipulation_nn_1 = mkN "genmanipulation" "genmanipulationer" ;
  genom_ab_1 = mkAdv "genom" ;
  genom_nn_1 = mkN "genom" neutrum ;
  genombloedning_nn_1 = mkN "genomblцdning" ;
  genombloet_av_1 = mkA "genomblцt" ;
  genombrott_nn_1 = mkN "genombrott" neutrum ;
  genombruten_av_1 = mkA "genombruten" "genombrutet" ;
  genombryta_vb_1 = mkV "genombryta" "genombrцt" "genombrutit" ;
  genomdriva_vb_1 = mkV "genomdriva" "genomdrev" "genomdrivit" ;
  genomfara_vb_1 = mkV "genomfara" "genomfor" "genomfarit" ;
  genomfart_nn_1 = mkN "genomfart" "genomfarter" ;
  genomfartsled_nn_1 = mkN "genomfartsled" "genomfartsleder" ;
  genomfoerande_nn_1 = mkN "genomfцrande" ;
  genomfoerbar_av_1 = mkA "genomfцrbar" ;
  genomfoering_nn_1 = mkN "genomfцring" ;
  genomfoerkyld_av_1 = mkA "genomfцrkyld" "genomfцrkylt" ;
  genomgaa_vb_1 = mkV "genomgе" "genomgеr" "genomgе" "genomgick" "genomgеtt" "genomgеngen" ;
  genomgaaende_ab_1 = mkAdv "genomgеende" ;
  genomgaaende_av_1 = mkA "genomgеende" ;
  genomgaang_nn_1 = mkN "genomgеng" ;
  genomgripande_av_1 = mkA "genomgripande" ;
  genomklappning_nn_1 = mkN "genomklappning" ;
  genomkoerare_nn_1 = mkN "genomkцrare" "genomkцrare" ;
  genomlida_vb_1 = mkV "genomlida" "genomled" "genomlidit" ;
  genomlysande_av_1 = mkA "genomlysande" ;
  genomlysning_nn_1 = mkN "genomlysning" ;
  genommoenstring_nn_1 = mkN "genommцnstring" ;
  genomsippring_nn_1 = mkN "genomsippring" ;
  genomskinlig_av_1 = mkA "genomskinlig" ;
  genomslaepplig_av_1 = mkA "genomslдpplig" ;
  genomslaepplighet_nn_1 = mkN "genomslдpplighet" "genomslдppligheter" ;
  genomslag_nn_1 = mkN "genomslag" neutrum ;
  genomslagskopia_nn_1 = mkN "genomslagskopia" ;
  genomslagspapper_nn_1 = mkN "genomslagspapper" neutrum ;
  genomsnitt_nn_1 = mkN "genomsnitt" neutrum ;
  genomsnittlig_av_1 = mkA "genomsnittlig" ;
  genomsnittsinkomst_nn_1 = mkN "genomsnittsinkomst" "genomsnittsinkomster" ;
  genomsnittsskatt_nn_1 = mkN "genomsnittsskatt" "genomsnittsskatter" ;
  genomsnittsvaerde_nn_1 = mkN "genomsnittsvдrde" ;
  genomtaenkt_av_1 = mkA "genomtдnkt" "genomtдnkt" ;
  genomtraengande_av_1 = mkA "genomtrдngande" ;
  genomtraenglig_av_1 = mkA "genomtrдnglig" ;
  genomtraengning_nn_1 = mkN "genomtrдngning" ;
  genomtryckt_av_1 = mkA "genomtryckt" "genomtryckt" ;
  genomvaat_av_1 = mkA "genomvеt" ;
  genomvaevd_av_1 = mkA "genomvдvd" "genomvдvt" ;
  genotyp_nn_1 = mkN "genotyp" "genotyper" ;
  genre_nn_1 = mkN "genre" "genrer" ;
  genrep_nn_1 = mkN "genrep" neutrum ;
  gensaegelse_nn_1 = mkN "gensдgelse" "gensдgelser" ;
  gensaga_nn_1 = mkN "gensaga" ;
  gensare_nn_1 = mkN "gensare" "gensare" ;
  genskjuta_vb_1 = mkV "genskjuta" "genskцt" "genskjutit" ;
  genstaemning_nn_1 = mkN "genstдmning" ;
  genstoertig_av_1 = mkA "genstцrtig" ;
  genstraevig_av_1 = mkA "genstrдvig" ;
  genstridig_av_1 = mkA "genstridig" ;
  genta_vb_1 = mkV "genta" "gentar" "genta" "gentog" "gentagit" "gentagen" ;
  gentil_av_1 = mkA "gentil" ;
  gentjaenst_nn_1 = mkN "gentjдnst" "gentjдnster" ;
  gentleman_nn_1 = mkN "gentleman" "gentlemannen" "gentlemдn" "gentlemдnnen" ;
  genuafock_nn_1 = mkN "genuafock" ;
  genuin_av_1 = mkA "genuin" ;
  genus_nn_1 = mkN "genus" neutrum ;
  genvaeg_nn_1 = mkN "genvдg" ;
  geocentrisk_av_1 = mkA "geocentrisk" ;
  geodet_nn_1 = mkN "geodet" "geodeter" ;
  geodetisk_av_1 = mkA "geodetisk" ;
  geodimeter_nn_1 = mkN "geodimeter" ;
  geograf_nn_1 = mkN "geograf" "geografer" ;
  geografisk_av_1 = mkA "geografisk" ;
  geokemisk_av_1 = mkA "geokemisk" ;
  geokronologisk_av_1 = mkA "geokronologisk" ;
  geolog_nn_1 = mkN "geolog" "geologer" ;
  geologisk_av_1 = mkA "geologisk" ;
  geometri_nn_1 = mkN "geometri" "geometrier" ;
  geometriker_nn_1 = mkN "geometriker" "geometrikern" "geometriker" "geometrikerna" ;
  geometrisk_av_1 = mkA "geometrisk" ;
  geomorfologisk_av_1 = mkA "geomorfologisk" ;
  georgier_nn_1 = mkN "georgier" "georgiern" "georgier" "georgierna" ;
  georgisk_av_1 = mkA "georgisk" ;
  georgiska_nn_2 = mkN "georgiska" ;
  georgskors_nn_1 = mkN "georgskors" neutrum ;
  geostationaer_av_1 = mkA "geostationдr" ;
  geosynklinal_nn_1 = mkN "geosynklinal" "geosynklinaler" ;
  geotermisk_av_1 = mkA "geotermisk" ;
  geovetare_nn_1 = mkN "geovetare" "geovetare" ;
  geovetenskap_nn_1 = mkN "geovetenskap" "geovetenskaper" ;
  geovetenskaplig_av_1 = mkA "geovetenskaplig" ;
  gepard_nn_1 = mkN "gepard" "geparder" ;
  geranium_nn_1 = mkN "geranium" "geranien" "geranier" "geranierna" ;
  geriatrisk_av_1 = mkA "geriatrisk" ;
  geridon_nn_1 = mkN "geridon" "geridoner" ;
  geridong_nn_1 = mkN "geridong" "geridonger" ;
  gerilla_nn_1 = mkN "gerilla" ;
  gerillaledare_nn_1 = mkN "gerillaledare" "gerillaledare" ;
  gering_nn_1 = mkN "gering" ;
  german_nn_1 = mkN "german" "germaner" ;
  germanfolk_nn_1 = mkN "germanfolk" neutrum ;
  germanism_nn_1 = mkN "germanism" "germanismer" ;
  germanist_nn_1 = mkN "germanist" "germanister" ;
  germanistisk_av_1 = mkA "germanistisk" ;
  germankrigare_nn_1 = mkN "germankrigare" "germankrigare" ;
  germansk_av_1 = mkA "germansk" ;
  germanstam_nn_1 = mkN "germanstam" "germanstammen" "germanstammar" "germanstammarna" ;
  gerontologisk_av_1 = mkA "gerontologisk" ;
  gers_nn_1 = mkN "gers" ;
  gerundium_nn_1 = mkN "gerundium" "gerundium" "gerundier" "gerundierna" ;
  gerundivum_nn_1 = mkN "gerundivum" "gerundivum" "gerundiver" "gerundiverna" ;
  gesaell_nn_1 = mkN "gesдll" "gesдller" ;
  gesaellbrev_nn_1 = mkN "gesдllbrev" neutrum ;
  gesaellprov_nn_1 = mkN "gesдllprov" neutrum ;
  gesaellvandring_nn_1 = mkN "gesдllvandring" ;
  gesant_nn_1 = mkN "gesant" "gesanter" ;
  geschaeft_nn_1 = mkN "geschдft" neutrum ;
  geschwint_ab_1 = mkAdv "geschwint" ;
  gesims_nn_1 = mkN "gesims" "gesimser" ;
  gesimsbaage_nn_1 = mkN "gesimsbеge" utrum ;
  gesimslist_nn_1 = mkN "gesimslist" "gesimslister" ;
  gest_nn_1 = mkN "gest" "gester" ;
  gestalt_nn_1 = mkN "gestalt" "gestalter" ;
  gestaltning_nn_1 = mkN "gestaltning" ;
  gestikulation_nn_1 = mkN "gestikulation" "gestikulationer" ;
  get_nn_1 = mkN "get" "getter" ;
  getabock_nn_1 = mkN "getabock" ;
  getapel_nn_1 = mkN "getapel" ;
  getfot_nn_1 = mkN "getfot" ;
  geting_nn_1 = mkN "geting" ;
  getingbo_nn_1 = mkN "getingbo" "getingbot" "getingbon" "getingboen" ;
  getingmidja_nn_1 = mkN "getingmidja" ;
  getingstick_nn_1 = mkN "getingstick" neutrum ;
  getmjoelksost_nn_1 = mkN "getmjцlksost" ;
  getoega_nn_1 = mkN "getцga" "getцgat" "getцgon" "getцgonen" ;
  getost_nn_1 = mkN "getost" ;
  getskaegg_nn_1 = mkN "getskдgg" neutrum ;
  getskinn_nn_1 = mkN "getskinn" neutrum ;
  getto_nn_1 = mkN "getto" "gettot" "getton" "gettona" ;
  getvaeppling_nn_1 = mkN "getvдppling" ;
  gevaer_nn_1 = mkN "gevдr" neutrum ;
  gevaersfaktori_nn_1 = mkN "gevдrsfaktori" "gevдrsfaktorit" "gevдrsfaktorier" "gevдrsfaktorierna" ;
  gevaersgranat_nn_1 = mkN "gevдrsgranat" "gevдrsgranater" ;
  gevaerskolv_nn_1 = mkN "gevдrskolv" ;
  gevaerskompani_nn_1 = mkN "gevдrskompani" "gevдrskompanit" "gevдrskompanier" "gevдrskompanierna" ;
  gevaerspatron_nn_1 = mkN "gevдrspatron" "gevдrspatroner" ;
  gevaerspost_nn_1 = mkN "gevдrspost" "gevдrsposter" ;
  gevaerssmed_nn_1 = mkN "gevдrssmed" "gevдrssmeder" ;
  gevaerssmide_nn_1 = mkN "gevдrssmide" ;
  gevaersstock_nn_1 = mkN "gevдrsstock" ;
  gevaldiger_nn_1 = mkN "gevaldiger" "gevaldigern" "gevaldiger" "gevaldigerna" ;
  ghanan_nn_1 = mkN "ghanan" "ghananer" ;
  ghanansk_av_1 = mkA "ghanansk" ;
  ghanes_nn_1 = mkN "ghanes" "ghaneser" ;
  ghanesisk_av_1 = mkA "ghanesisk" ;
  ghasel_nn_1 = mkN "ghasel" "ghaseler" ;
  ghetto_nn_1 = mkN "ghetto" "ghettot" "ghetton" "ghettona" ;
  ghost_writer_nn_1 = mkN "ghost-writer" "ghost-writern" "ghost-writers" "ghost-writersen" ;
  gibbon_nn_1 = mkN "gibbon" "gibboner" ;
  giffel_nn_1 = mkN "giffel" ;
  gift_av_1 = mkA "gift" "gift" ;
  gift_nn_1 = mkN "gift" "giftet" "gifter" "gifterna" ;
  giftapparat_nn_1 = mkN "giftapparat" "giftapparater" ;
  giftasvuxen_av_1 = mkA "giftasvuxen" "giftasvuxet" ;
  giftavdunstning_nn_1 = mkN "giftavdunstning" ;
  giftbaegare_nn_1 = mkN "giftbдgare" "giftbдgare" ;
  giftblandare_nn_1 = mkN "giftblandare" "giftblandare" ;
  giftbok_nn_1 = mkN "giftbok" "giftbцcker" ;
  giftermaal_nn_1 = mkN "giftermеl" neutrum ;
  giftermaalsbalk_nn_1 = mkN "giftermеlsbalk" ;
  giftfri_av_1 = mkA "giftfri" "giftfritt" ;
  giftgas_nn_1 = mkN "giftgas" "giftgaser" ;
  giftgroen_av_1 = mkA "giftgrцn" ;
  gifthalt_nn_1 = mkN "gifthalt" "gifthalter" ;
  giftig_av_1 = mkA "giftig" ;
  giftighet_nn_1 = mkN "giftighet" "giftigheter" ;
  giftkoertel_nn_1 = mkN "giftkцrtel" ;
  giftmaengd_nn_1 = mkN "giftmдngd" "giftmдngder" ;
  giftmoln_nn_1 = mkN "giftmoln" neutrum ;
  giftmord_nn_1 = mkN "giftmord" neutrum ;
  giftoman_nn_1 = mkN "giftoman" "giftomannen" "giftomдn" "giftomдnnen" ;
  giftorm_nn_1 = mkN "giftorm" ;
  giftstadga_nn_1 = mkN "giftstadga" ;
  gifttagg_nn_1 = mkN "gifttagg" ;
  gifttand_nn_1 = mkN "gifttand" "gifttдnder" ;
  gifttransport_nn_1 = mkN "gifttransport" "gifttransporter" ;
  giftverkan_nn_1 = mkN "giftverkan" "giftverkan" "giftverkningar" "giftverkningarna" ;
  gig_nn_1 = mkN "gig" neutrum ;
  gigant_nn_1 = mkN "gigant" "giganter" ;
  gigantisk_av_1 = mkA "gigantisk" ;
  gigaton_nn_1 = mkN "gigaton" "gigatonnet" "gigaton" "gigatonnen" ;
  gigawatt_nn_1 = mkN "gigawatt" "gigawatten" "gigawatt" "gigawatten" ;
  gigg_nn_1 = mkN "gigg" ;
  gigolo_nn_1 = mkN "gigolo" "gigolon" "gigolos" "gigolosen" ;
  gigue_nn_1 = mkN "gigue" "giguer" ;
  giktbruten_av_1 = mkA "giktbruten" "giktbrutet" ;
  giktring_nn_1 = mkN "giktring" ;
  giljare_nn_1 = mkN "giljare" "giljare" ;
  giljarfaerd_nn_1 = mkN "giljarfдrd" "giljarfдrder" ;
  giljotin_nn_1 = mkN "giljotin" "giljotiner" ;
  gill_av_1 = mkA "gill" ;
  gillande_nn_1 = mkN "gillande" ;
  giller_nn_1 = mkN "giller" neutrum ;
  gillesbroder_nn_1 = mkN "gillesbroder" "gillesbrodern" "gillesbrцder" "gillesbrцderna" ;
  gillessocialism_nn_1 = mkN "gillessocialism" "gillessocialismer" ;
  gillestuga_nn_1 = mkN "gillestuga" ;
  giltig_av_1 = mkA "giltig" ;
  giltighet_nn_1 = mkN "giltighet" "giltigheter" ;
  gimmick_nn_1 = mkN "gimmick" ;
  gin_av_1 = mkA "gin" ;
  ginbalk_nn_1 = mkN "ginbalk" ;
  ginnungagap_nn_1 = mkN "ginnungagap" neutrum ;
  ginst_nn_1 = mkN "ginst" "ginster" ;
  ginstkatt_nn_1 = mkN "ginstkatt" "ginstkatter" ;
  ginvaeg_nn_1 = mkN "ginvдg" ;
  gip_nn_1 = mkN "gip" ;
  gipp_nn_1 = mkN "gipp" ;
  gips_nn_1 = mkN "gips" "gipser" ;
  gipsavgjutning_nn_1 = mkN "gipsavgjutning" ;
  gipsfoerband_nn_1 = mkN "gipsfцrband" neutrum ;
  gipsform_nn_1 = mkN "gipsform" ;
  gipyr_nn_1 = mkN "gipyr" "gipyrer" ;
  gir_nn_1 = mkN "gir" ;
  giraff_nn_1 = mkN "giraff" "giraffer" ;
  giraffliknande_av_1 = mkA "giraffliknande" ;
  girandole_nn_1 = mkN "girandole" "girandoler" ;
  girering_nn_1 = mkN "girering" ;
  girig_av_1 = mkA "girig" ;
  girigbuk_nn_1 = mkN "girigbuk" ;
  girland_nn_1 = mkN "girland" "girlander" ;
  giro_nn_1 = mkN "giro" "girot" "giron" "girona" ;
  girobesked_nn_1 = mkN "girobesked" neutrum ;
  girvaext_av_1 = mkA "girvдxt" "girvдxt" ;
  girvuxen_av_1 = mkA "girvuxen" "girvuxet" ;
  gissel_nn_1 = mkN "gissel" neutrum ;
  gisseldjur_nn_1 = mkN "gisseldjur" neutrum ;
  gisslare_nn_1 = mkN "gisslare" "gisslare" ;
  gissning_nn_1 = mkN "gissning" ;
  gissningsvis_ab_1 = mkAdv "gissningsvis" ;
  gisten_av_1 = mkA "gisten" "gistet" ;
  gistgaard_nn_1 = mkN "gistgеrd" ;
  gitarr_nn_1 = mkN "gitarr" "gitarrer" ;
  gitarrist_nn_1 = mkN "gitarrist" "gitarrister" ;
  gitter_nn_1 = mkN "gitter" neutrum ;
  giv_nn_1 = mkN "giv" ;
  givakt_nn_1 = mkN "givakt" "givakter" ;
  givande_av_1 = mkA "givande" ;
  givare_nn_1 = mkN "givare" "givare" ;
  given_av_1 = mkA "given" "givet" ;
  givetvis_ab_1 = mkAdv "givetvis" ;
  givkort_nn_1 = mkN "givkort" neutrum ;
  givmild_av_1 = mkA "givmild" "givmilt" ;
  givmildhet_nn_1 = mkN "givmildhet" "givmildheter" ;
  givning_nn_1 = mkN "givning" ;
  gjord_nn_1 = mkN "gjord" ;
  gjuse_nn_1 = mkN "gjuse" utrum ;
  gjuta_vb_1 = mkV "gjuta" "gцt" "gjutit" ;
  gjutare_nn_1 = mkN "gjutare" "gjutare" ;
  gjutbar_av_1 = mkA "gjutbar" ;
  gjuteri_nn_1 = mkN "gjuteri" "gjuterit" "gjuterier" "gjuterierna" ;
  gjutform_nn_1 = mkN "gjutform" ;
  gjutmodell_nn_1 = mkN "gjutmodell" "gjutmodeller" ;
  gjutning_nn_1 = mkN "gjutning" ;
  gjutrand_nn_1 = mkN "gjutrand" "gjutrдnder" ;
  glaamig_av_1 = mkA "glеmig" ;
  glaapord_nn_1 = mkN "glеpord" neutrum ;
  glacehandske_nn_1 = mkN "glacйhandske" utrum ;
  glaci_nn_1 = mkN "glaci" "glacier" ;
  glaciaer_nn_1 = mkN "glaciдr" "glaciдrer" ;
  glaciaeraelv_nn_1 = mkN "glaciдrдlv" ;
  glaciaerbrunn_nn_1 = mkN "glaciдrbrunn" ;
  glaciaeris_nn_1 = mkN "glaciдris" ;
  glaciaernisch_nn_1 = mkN "glaciдrnisch" "glaciдrnischer" ;
  glaciaerport_nn_1 = mkN "glaciдrport" ;
  glaciaerraeffla_nn_1 = mkN "glaciдrrдffla" ;
  glacial_av_1 = mkA "glacial" ;
  glacialperiod_nn_1 = mkN "glacialperiod" "glacialperioder" ;
  glacialraeffla_nn_1 = mkN "glacialrдffla" ;
  glacifluvial_av_1 = mkA "glacifluvial" ;
  glaciolog_nn_1 = mkN "glaciolog" "glaciologer" ;
  glaciologisk_av_1 = mkA "glaciologisk" ;
  glad_av_1 = mkA "glad" ;
  glad_nn_1 = mkN "glad" neutrum ;
  gladelig_av_1 = mkA "gladelig" ;
  gladeligen_ab_1 = mkAdv "gladeligen" ;
  gladeligt_ab_1 = mkAdv "gladeligt" ;
  gladiator_nn_1 = mkN "gladiator" "gladiatorer" ;
  gladiatorspel_nn_1 = mkN "gladiatorspel" "gladiatorspelet" "gladiatorspel" "gladiatorspelen" ;
  gladiolus_nn_1 = mkN "gladiolus" ;
  gladlig_av_1 = mkA "gladlig" ;
  gladligen_ab_1 = mkAdv "gladligen" ;
  gladlynt_av_1 = mkA "gladlynt" "gladlynt" ;
  glaedjande_av_1 = mkA "glдdjande" ;
  glaedjeaemne_nn_1 = mkN "glдdjeдmne" ;
  glaedjebetygelse_nn_1 = mkN "glдdjebetygelse" "glдdjebetygelser" ;
  glaedjedoedare_nn_1 = mkN "glдdjedцdare" "glдdjedцdare" ;
  glaedjefylld_av_1 = mkA "glдdjefylld" "glдdjefyllt" ;
  glaedjehus_nn_1 = mkN "glдdjehus" neutrum ;
  glaedjekalkyl_nn_1 = mkN "glдdjekalkyl" "glдdjekalkyler" ;
  glaedjekvarter_nn_1 = mkN "glдdjekvarter" "glдdjekvarteret" "glдdjekvarter" "glдdjekvarteren" ;
  glaedjerus_nn_1 = mkN "glдdjerus" neutrum ;
  glaedjestraalande_av_1 = mkA "glдdjestrеlande" ;
  glaensande_av_1 = mkA "glдnsande" ;
  glaettig_av_1 = mkA "glдttig" ;
  glaettighet_nn_1 = mkN "glдttighet" "glдttigheter" ;
  glaettning_nn_1 = mkN "glдttning" ;
  glaettsten_nn_1 = mkN "glдttsten" "glдttstenen" "glдttstenar" "glдttstenarna" ;
  glagolitisk_av_1 = mkA "glagolitisk" ;
  glamoroes_av_1 = mkA "glamorцs" ;
  glamouroes_av_1 = mkA "glamourцs" ;
  glandel_nn_1 = mkN "glandel" "glandeln" "glandler" "glandlerna" ;
  glanduloes_av_1 = mkA "glandulцs" ;
  glansbagge_nn_1 = mkN "glansbagge" utrum ;
  glansfull_av_1 = mkA "glansfull" ;
  glansig_av_1 = mkA "glansig" ;
  glansk_av_1 = mkA "glansk" ;
  glansloes_av_1 = mkA "glanslцs" ;
  glansnummer_nn_1 = mkN "glansnummer" neutrum ;
  glanspapper_nn_1 = mkN "glanspapper" neutrum ;
  glansperiod_nn_1 = mkN "glansperiod" "glansperioder" ;
  glansroll_nn_1 = mkN "glansroll" "glansroller" ;
  glanstid_nn_1 = mkN "glanstid" "glanstider" ;
  glapp_av_1 = mkA "glapp" ;
  glapp_nn_1 = mkN "glapp" neutrum ;
  glapprum_nn_1 = mkN "glapprum" "glapprummet" "glapprum" "glapprummen" ;
  glas_nn_1 = mkN "glas" neutrum ;
  glasaal_nn_1 = mkN "glasеl" ;
  glasbjoerk_nn_1 = mkN "glasbjцrk" ;
  glasblaasare_nn_1 = mkN "glasblеsare" "glasblеsare" ;
  glasblaaseri_nn_1 = mkN "glasblеseri" "glasblеserit" "glasblеserier" "glasblеserierna" ;
  glasbruk_nn_1 = mkN "glasbruk" neutrum ;
  glasbult_nn_1 = mkN "glasbult" ;
  glasering_nn_1 = mkN "glasering" ;
  glasfiber_nn_1 = mkN "glasfiber" "glasfibern" "glasfibrer" "glasfibrerna" ;
  glasfoeremaal_nn_1 = mkN "glasfцremеl" neutrum ;
  glasframstaellning_nn_1 = mkN "glasframstдllning" ;
  glashal_av_1 = mkA "glashal" ;
  glashandduk_nn_1 = mkN "glashandduk" ;
  glashus_nn_1 = mkN "glashus" neutrum ;
  glashuv_nn_1 = mkN "glashuv" ;
  glasig_av_1 = mkA "glasig" ;
  glasighet_nn_1 = mkN "glasighet" "glasigheter" ;
  glasiglo_nn_1 = mkN "glasiglo" "glasiglor" ;
  glasiologisk_av_1 = mkA "glasiologisk" ;
  glasklar_av_1 = mkA "glasklar" ;
  glaskolv_nn_1 = mkN "glaskolv" ;
  glaskropp_nn_1 = mkN "glaskropp" ;
  glasmaalning_nn_1 = mkN "glasmеlning" ;
  glasmaestardiamant_nn_1 = mkN "glasmдstardiamant" "glasmдstardiamanter" ;
  glasmaestare_nn_1 = mkN "glasmдstare" "glasmдstare" ;
  glasmaesteri_nn_1 = mkN "glasmдsteri" "glasmдsterit" "glasmдsterier" "glasmдsterierna" ;
  glasoega_nn_1 = mkN "glasцga" "glasцgat" "glasцgon" "glasцgonen" ;
  glasoegonbaage_nn_1 = mkN "glasцgonbеge" utrum ;
  glasoegonbjoern_nn_1 = mkN "glasцgonbjцrn" ;
  glasoegonorm_nn_1 = mkN "glasцgonorm" ;
  glasprisma_nn_1 = mkN "glasprisma" ;
  glasroer_nn_1 = mkN "glasrцr" neutrum ;
  glass_nn_1 = mkN "glass" ;
  glassbaegare_nn_1 = mkN "glassbдgare" "glassbдgare" ;
  glassbomb_nn_1 = mkN "glassbomb" "glassbomber" ;
  glassdessert_nn_1 = mkN "glassdessert" "glassdesserter" ;
  glassig_av_1 = mkA "glassig" ;
  glasskaerardiamant_nn_1 = mkN "glasskдrardiamant" "glasskдrardiamanter" ;
  glasskaerare_nn_1 = mkN "glasskдrare" "glasskдrare" ;
  glasslipare_nn_1 = mkN "glasslipare" "glasslipare" ;
  glassmaskin_nn_1 = mkN "glassmaskin" "glassmaskiner" ;
  glasspinne_nn_1 = mkN "glasspinne" utrum ;
  glasstrut_nn_1 = mkN "glasstrut" ;
  glasvakt_nn_1 = mkN "glasvakt" "glasvakter" ;
  glasvar_nn_1 = mkN "glasvar" ;
  glasvingefjaeril_nn_1 = mkN "glasvingefjдril" ;
  glasyr_nn_1 = mkN "glasyr" "glasyrer" ;
  glatt_av_1 = mkA "glatt" ;
  glattmask_nn_1 = mkN "glattmask" ;
  glav_nn_1 = mkN "glav" ;
  gles_av_1 = mkA "gles" ;
  glesbygd_nn_1 = mkN "glesbygd" "glesbygder" ;
  gletscher_nn_1 = mkN "gletscher" ;
  gli_nn_1 = mkN "gli" "glit" "glin" "glien" ;
  glid_nn_1 = mkN "glid" neutrum ;
  glida_vb_1 = mkV "glida" "gled" "glidit" ;
  glidkontakt_nn_1 = mkN "glidkontakt" "glidkontakter" ;
  glidkraem_nn_1 = mkN "glidkrдm" "glidkrдmer" ;
  glidlager_nn_1 = mkN "glidlager" neutrum ;
  glidljud_nn_1 = mkN "glidljud" neutrum ;
  glidmedel_nn_1 = mkN "glidmedel" neutrum ;
  glidning_nn_1 = mkN "glidning" ;
  glidtackling_nn_1 = mkN "glidtackling" ;
  glim_nn_1 = mkN "glim" "glimmen" "glim" "glimmen" ;
  glimt_nn_1 = mkN "glimt" ;
  glimtaendare_nn_1 = mkN "glimtдndare" "glimtдndare" ;
  glimtvis_ab_1 = mkAdv "glimtvis" ;
  glinder_nn_1 = mkN "glinder" neutrum ;
  gliom_nn_1 = mkN "gliom" neutrum ;
  gliring_nn_1 = mkN "gliring" ;
  glis_nn_2 = mkN "glis" ;
  glisoert_nn_1 = mkN "glisцrt" "glisцrter" ;
  glissando_nn_1 = mkN "glissando" "glissandot" "glissandon" "glissandona" ;
  glitterglad_av_1 = mkA "glitterglad" ;
  glittrig_av_1 = mkA "glittrig" ;
  glob_nn_1 = mkN "glob" "glober" ;
  global_av_1 = mkA "global" ;
  globetrotter_nn_1 = mkN "globetrotter" ;
  globulin_nn_1 = mkN "globulin" "globuliner" ;
  gloed_nn_1 = mkN "glцd" "glцder" ;
  gloedbaedd_nn_1 = mkN "glцdbдdd" ;
  gloedhet_av_1 = mkA "glцdhet" ;
  gloedhoeg_nn_1 = mkN "glцdhцg" ;
  gloedkatod_nn_1 = mkN "glцdkatod" "glцdkatoder" ;
  gloedkropp_nn_1 = mkN "glцdkropp" ;
  gloedmjuk_av_1 = mkA "glцdmjuk" ;
  gloedning_nn_1 = mkN "glцdning" ;
  gloedstroem_nn_1 = mkN "glцdstrцm" "glцdstrцmmen" "glцdstrцmmar" "glцdstrцmmarna" ;
  gloedtraad_nn_1 = mkN "glцdtrеd" ;
  gloedvarm_av_1 = mkA "glцdvarm" ;
  gloegg_nn_1 = mkN "glцgg" ;
  gloemsk_av_1 = mkA "glцmsk" ;
  glop_nn_1 = mkN "glop" ;
  glorioes_av_1 = mkA "gloriцs" ;
  glosig_av_1 = mkA "glosig" ;
  glosoegd_av_1 = mkA "glosцgd" "glosцgt" ;
  glossar_nn_1 = mkN "glossar" neutrum ;
  glossarium_nn_1 = mkN "glossarium" "glossariet" "glossarier" "glossarierna" ;
  glossematik_nn_1 = mkN "glossematik" "glossematiker" ;
  glossolali_nn_1 = mkN "glossolali" "glossolalier" ;
  glottisstoet_nn_1 = mkN "glottisstцt" ;
  glugg_nn_1 = mkN "glugg" ;
  glunt_nn_1 = mkN "glunt" ;
  glupande_av_1 = mkA "glupande" ;
  glupsk_av_1 = mkA "glupsk" ;
  glutamat_nn_1 = mkN "glutamat" neutrum ;
  glutenfri_av_1 = mkA "glutenfri" "glutenfritt" ;
  glutinoes_av_1 = mkA "glutinцs" ;
  glycerid_nn_1 = mkN "glycerid" "glycerider" ;
  glycin_nn_1 = mkN "glycin" "glyciner" ;
  glykol_nn_1 = mkN "glykol" "glykoler" ;
  glykopeptid_nn_1 = mkN "glykopeptid" "glykopeptider" ;
  glykos_nn_1 = mkN "glykos" "glykoser" ;
  glyptotek_nn_1 = mkN "glyptotek" neutrum ;
  glytt_nn_1 = mkN "glytt" ;
  glyttig_av_1 = mkA "glyttig" ;
  gnabb_nn_1 = mkN "gnabb" neutrum ;
  gnaellig_av_1 = mkA "gnдllig" ;
  gnaellmaans_nn_1 = mkN "gnдllmеns" ;
  gnaellspik_nn_1 = mkN "gnдllspik" ;
  gnagare_nn_1 = mkN "gnagare" "gnagare" ;
  gnagtand_nn_1 = mkN "gnagtand" "gnagtдnder" ;
  gnatig_av_1 = mkA "gnatig" ;
  gnejs_nn_1 = mkN "gnejs" "gnejser" ;
  gnet_nn_1 = mkN "gnet" "gnetter" ;
  gnet_nn_2 = mkN "gnet" ;
  gnetig_av_1 = mkA "gnetig" ;
  gnida_vb_1 = mkV "gnida" "gned" "gnidit" ;
  gnidare_nn_1 = mkN "gnidare" "gnidare" ;
  gniden_av_1 = mkA "gniden" "gnidet" ;
  gnidig_av_1 = mkA "gnidig" ;
  gnidningselektricitet_nn_1 = mkN "gnidningselektricitet" "gnidningselektriciteter" ;
  gnistfaangare_nn_1 = mkN "gnistfеngare" "gnistfеngare" ;
  gnistgaller_nn_1 = mkN "gnistgaller" neutrum ;
  gnistgap_nn_1 = mkN "gnistgap" neutrum ;
  gnistinduktor_nn_1 = mkN "gnistinduktor" "gnistinduktorer" ;
  gnistkammare_nn_1 = mkN "gnistkammare" "gnistkammaren" "gnistkamrar" "gnistkamrarna" ;
  gnistrig_av_1 = mkA "gnistrig" ;
  gnistsaendare_nn_1 = mkN "gnistsдndare" "gnistsдndare" ;
  gnistskydd_nn_1 = mkN "gnistskydd" neutrum ;
  gniststation_nn_1 = mkN "gniststation" "gniststationer" ;
  gnisttaendning_nn_1 = mkN "gnisttдndning" ;
  gnoding_nn_1 = mkN "gnoding" ;
  gnom_nn_1 = mkN "gnom" "gnomer" ;
  gnomiker_nn_1 = mkN "gnomiker" "gnomikern" "gnomiker" "gnomikerna" ;
  gnostiker_nn_1 = mkN "gnostiker" "gnostikern" "gnostiker" "gnostikerna" ;
  gnu_nn_1 = mkN "gnu" "gnun" "gnuer" "gnuerna" ;
  gnuggbild_nn_1 = mkN "gnuggbild" "gnuggbilder" ;
  go_cart_nn_1 = mkN "go-cart" "go-carten" "go-carts" "go-cartsen" ;
  gobelaeng_nn_1 = mkN "gobelдng" "gobelдnger" ;
  gobelaengbroderi_nn_1 = mkN "gobelдngbroderi" "gobelдngbroderit" "gobelдngbroderier" "gobelдngbroderierna" ;
  god_av_1 = mkA "god" ;
  godbit_nn_1 = mkN "godbit" ;
  goddagspilt_nn_1 = mkN "goddagspilt" ;
  gode_nn_1 = mkN "gode" utrum ;
  godhaellig_av_1 = mkA "godhдllig" ;
  godhet_nn_1 = mkN "godhet" "godheter" ;
  godhetsfull_av_1 = mkA "godhetsfull" ;
  godhjaertenhet_nn_1 = mkN "godhjдrtenhet" "godhjдrtenheter" ;
  goding_nn_1 = mkN "goding" ;
  godis_nn_2 = mkN "godis" ;
  godkaend_av_1 = mkA "godkдnd" ;
  godkaennande_nn_1 = mkN "godkдnnande" ;
  godlynt_av_1 = mkA "godlynt" "godlynt" ;
  godmanskap_nn_1 = mkN "godmanskap" "godmanskapet" "godmanskapen" "godmanskapena" ;
  godmodig_av_1 = mkA "godmodig" ;
  gods_nn_1 = mkN "gods" neutrum ;
  godsaegare_nn_1 = mkN "godsдgare" "godsдgare" ;
  godsak_nn_1 = mkN "godsak" "godsaker" ;
  godsexpedition_nn_1 = mkN "godsexpedition" "godsexpeditioner" ;
  godsherre_nn_1 = mkN "godsherre" utrum ;
  godsint_av_1 = mkA "godsint" "godsint" ;
  godsmottagning_nn_1 = mkN "godsmottagning" ;
  godstaag_nn_1 = mkN "godstеg" neutrum ;
  godsvagn_nn_1 = mkN "godsvagn" ;
  godta_vb_1 = mkV "godta" "godtar" "godta" "godtog" "godtagit" "godtagen" ;
  godtagbar_av_1 = mkA "godtagbar" ;
  godtemplare_nn_1 = mkN "godtemplare" "godtemplare" ;
  godtemplarorden_nn_1 = mkN "godtemplarorden" ;
  godtrogen_av_1 = mkA "godtrogen" "godtroget" ;
  godtrosfoervaerv_nn_1 = mkN "godtrosfцrvдrv" neutrum ;
  godtycklig_av_1 = mkA "godtycklig" ;
  godvikt_nn_1 = mkN "godvikt" "godvikter" ;
  godvillig_av_1 = mkA "godvillig" ;
  goeddjur_nn_1 = mkN "gцddjur" neutrum ;
  goedkyckling_nn_1 = mkN "gцdkyckling" ;
  goedning_nn_1 = mkN "gцdning" ;
  goedningsmedel_nn_1 = mkN "gцdningsmedel" neutrum ;
  goedselmedel_nn_1 = mkN "gцdselmedel" neutrum ;
  goedselspridare_nn_1 = mkN "gцdselspridare" "gцdselspridare" ;
  goedselstack_nn_1 = mkN "gцdselstack" ;
  goedselstad_nn_1 = mkN "gцdselstad" "gцdselstдder" ;
  goedsling_nn_1 = mkN "gцdsling" ;
  goejemaanad_nn_1 = mkN "gцjemеnad" "gцjemеnader" ;
  goek_nn_1 = mkN "gцk" ;
  goekblomster_nn_1 = mkN "gцkblomster" neutrum ;
  goekunge_nn_1 = mkN "gцkunge" utrum ;
  goekur_nn_1 = mkN "gцkur" neutrum ;
  goel_nn_1 = mkN "gцl" ;
  goeling_nn_1 = mkN "gцling" ;
  goemfroeig_av_1 = mkA "gцmfrцig" ;
  goemstaelle_nn_1 = mkN "gцmstдlle" ;
  goepen_nn_1 = mkN "gцpen" "gцpenn" "gцpnar" "gцpnarna" ;
  goerare_nn_1 = mkN "gцrare" "gцrare" ;
  goerdel_nn_1 = mkN "gцrdel" ;
  goerdelbaage_nn_1 = mkN "gцrdelbеge" utrum ;
  goerdeldaeck_nn_1 = mkN "gцrdeldдck" neutrum ;
  goerdelfaestning_nn_1 = mkN "gцrdelfдstning" ;
  goerdelmakare_nn_1 = mkN "gцrdelmakare" "gцrdelmakare" ;
  goerlig_av_1 = mkA "gцrlig" ;
  goeromaal_nn_1 = mkN "gцromеl" neutrum ;
  goes_nn_1 = mkN "gцs" ;
  goesstake_nn_1 = mkN "gцsstake" utrum ;
  goet_nn_1 = mkN "gцt" ;
  goet_nn_2 = mkN "gцt" neutrum ;
  goetamaal_nn_1 = mkN "gцtamеl" neutrum ;
  goete_nn_1 = mkN "gцte" utrum ;
  goeteborgare_nn_1 = mkN "gцteborgare" "gцteborgare" ;
  goeteborgsk_av_1 = mkA "gцteborgsk" ;
  goeteborgska_nn_2 = mkN "gцteborgska" ;
  goeteborgsvits_nn_1 = mkN "gцteborgsvits" ;
  goeticistisk_av_1 = mkA "gцticistisk" ;
  goetisk_av_1 = mkA "gцtisk" ;
  goetvalsverk_nn_1 = mkN "gцtvalsverk" neutrum ;
  gold_digger_nn_1 = mkN "gold-digger" "gold-diggern" "gold-diggers" "gold-diggersen" ;
  golf_nn_2 = mkN "golf" "golfer" ;
  golfare_nn_1 = mkN "golfare" "golfare" ;
  golfspel_nn_1 = mkN "golfspel" "golfspelet" "golfspel" "golfspelen" ;
  golgiapparat_nn_1 = mkN "golgiapparat" "golgiapparater" ;
  golv_nn_1 = mkN "golv" neutrum ;
  golvbelaeggning_nn_1 = mkN "golvbelдggning" ;
  golvbjaelke_nn_1 = mkN "golvbjдlke" utrum ;
  golvbraeda_nn_1 = mkN "golvbrдda" ;
  golvbrunn_nn_1 = mkN "golvbrunn" ;
  golvfast_av_1 = mkA "golvfast" "golvfast" ;
  golvkall_av_1 = mkA "golvkall" ;
  golvlaeggare_nn_1 = mkN "golvlдggare" "golvlдggare" ;
  golvramp_nn_1 = mkN "golvramp" "golvramper" ;
  golvur_nn_1 = mkN "golvur" neutrum ;
  golvvaexel_nn_1 = mkN "golvvдxel" ;
  golvvax_nn_1 = mkN "golvvax" "golvvaxet" "golvvaxer" "golvvaxerna" ;
  gom_nn_1 = mkN "gom" "gommen" "gommar" "gommarna" ;
  gombaage_nn_1 = mkN "gombеge" utrum ;
  gomben_nn_1 = mkN "gomben" neutrum ;
  gomljud_nn_1 = mkN "gomljud" neutrum ;
  gomsegel_nn_1 = mkN "gomsegel" neutrum ;
  gomspene_nn_1 = mkN "gomspene" utrum ;
  gon_nn_1 = mkN "gon" "goner" ;
  gonad_nn_1 = mkN "gonad" "gonader" ;
  gondol_nn_1 = mkN "gondol" "gondoler" ;
  gondoljaer_nn_1 = mkN "gondoljдr" "gondoljдrer" ;
  gonfaloniaer_nn_1 = mkN "gonfaloniдr" "gonfaloniдrer" ;
  gonggong_nn_1 = mkN "gonggong" ;
  gonokock_nn_1 = mkN "gonokock" "gonokocker" ;
  gonorre_nn_1 = mkN "gonorrй" "gonorrйer" ;
  goraa_nn_1 = mkN "gorе" "gorеt" "gorеn" "gorеna" ;
  gordonsetter_nn_1 = mkN "gordonsetter" ;
  gorgon_nn_1 = mkN "gorgon" "gorgoner" ;
  gosig_av_1 = mkA "gosig" ;
  gospel_nn_1 = mkN "gospel" "gospeln" "gospel" "gospelna" ;
  gosse_nn_1 = mkN "gosse" utrum ;
  got_nn_1 = mkN "got" "goter" ;
  goticerande_av_1 = mkA "goticerande" ;
  gotiserande_av_1 = mkA "gotiserande" ;
  gotisk_av_1 = mkA "gotisk" ;
  gotlaendsk_av_1 = mkA "gotlдndsk" ;
  gotlaendska_nn_2 = mkN "gotlдndska" ;
  gotlaenning_nn_1 = mkN "gotlдnning" ;
  gotlandsruss_nn_1 = mkN "gotlandsruss" neutrum ;
  gotsk_av_1 = mkA "gotsk" ;
  gottgoerelse_nn_1 = mkN "gottgцrelse" "gottgцrelser" ;
  gottskriva_vb_1 = mkV "gottskriva" "gottskrev" "gottskrivit" ;
  gouache_nn_1 = mkN "gouache" "gouacher" ;
  gourmand_nn_1 = mkN "gourmand" "gourmander" ;
  gourme_nn_1 = mkN "gourmй" "gourmйer" ;
  gourmet_nn_1 = mkN "gourmet" "gourmeter" ;
  graa_av_1 = mkA "grе" "grеtt" ;
  graaaktig_av_1 = mkA "grеaktig" ;
  graaal_nn_1 = mkN "grеal" ;
  graablaa_av_1 = mkA "grеblе" "grеblеtt" ;
  graablek_av_1 = mkA "grеblek" ;
  graabo_nn_1 = mkN "grеbo" "grеbor" ;
  graabroder_nn_1 = mkN "grеbroder" "grеbrodern" "grеbrцder" "grеbrцderna" ;
  graadaskig_av_1 = mkA "grеdaskig" ;
  graaflaeckig_av_1 = mkA "grеflдckig" ;
  graagaas_nn_1 = mkN "grеgеs" "grеgеsen" "grеgдss" "grеgдssen" ;
  graagosse_nn_1 = mkN "grеgosse" utrum ;
  graagroen_av_1 = mkA "grеgrцn" ;
  graagyllen_nn_1 = mkN "grеgyllen" "grеgyllen" "grеgyllen" "grеgyllena" ;
  graahaarig_av_1 = mkA "grеhеrig" ;
  graahaeger_nn_1 = mkN "grеhдger" ;
  graahund_nn_1 = mkN "grеhund" ;
  graakall_av_1 = mkA "grеkall" ;
  graalax_nn_1 = mkN "grеlax" ;
  graalle_nn_1 = mkN "grеlle" utrum ;
  graames_nn_1 = mkN "grеmes" ;
  graamunk_nn_1 = mkN "grеmunk" ;
  graapaeron_nn_1 = mkN "grеpдron" neutrum ;
  graasael_nn_1 = mkN "grеsдl" ;
  graasej_nn_1 = mkN "grеsej" ;
  graasiska_nn_1 = mkN "grеsiska" ;
  graaskaeckig_av_1 = mkA "grеskдckig" ;
  graaskaegg_nn_1 = mkN "grеskдgg" neutrum ;
  graaskimlig_av_1 = mkA "grеskimlig" ;
  graaskimmel_nn_1 = mkN "grеskimmel" "grеskimmeln" "grеskimmlar" "grеskimmlarna" ;
  graasosse_nn_1 = mkN "grеsosse" utrum ;
  graasparv_nn_1 = mkN "grеsparv" ;
  graaspett_nn_1 = mkN "grеspett" ;
  graaspraengd_av_1 = mkA "grеsprдngd" "grеsprдngt" ;
  graasten_nn_1 = mkN "grеsten" "grеstenen" "grеstenar" "grеstenarna" ;
  graasvart_av_1 = mkA "grеsvart" "grеsvart" ;
  graaterska_nn_1 = mkN "grеterska" ;
  graatfaerdig_av_1 = mkA "grеtfдrdig" ;
  graatmild_av_1 = mkA "grеtmild" "grеtmilt" ;
  graaton_nn_1 = mkN "grеton" "grеtoner" ;
  graatrut_nn_1 = mkN "grеtrut" ;
  grabb_nn_1 = mkN "grabb" ;
  grabbatag_nn_1 = mkN "grabbatag" neutrum ;
  grabbnaeve_nn_1 = mkN "grabbnдve" utrum ;
  grace_nn_1 = mkN "grace" "gracer" ;
  gracil_av_1 = mkA "gracil" ;
  gracioes_av_1 = mkA "graciцs" ;
  grad_nn_1 = mkN "grad" "grader" ;
  gradaeng_nn_1 = mkN "gradдng" "gradдnger" ;
  gradation_nn_1 = mkN "gradation" "gradationer" ;
  gradbeteckning_nn_1 = mkN "gradbeteckning" ;
  gradboejning_nn_1 = mkN "gradbцjning" ;
  graderverk_nn_1 = mkN "graderverk" neutrum ;
  gradient_nn_1 = mkN "gradient" "gradienter" ;
  gradlist_nn_1 = mkN "gradlist" "gradlister" ;
  gradmaetare_nn_1 = mkN "gradmдtare" "gradmдtare" ;
  gradmaetning_nn_1 = mkN "gradmдtning" ;
  gradmejsel_nn_1 = mkN "gradmejsel" ;
  gradnaet_nn_1 = mkN "gradnдt" neutrum ;
  gradsaag_nn_1 = mkN "gradsеg" ;
  gradskillnad_nn_1 = mkN "gradskillnad" "gradskillnader" ;
  gradstreck_nn_1 = mkN "gradstreck" neutrum ;
  gradtal_nn_1 = mkN "gradtal" "gradtalet" "gradtalen" "gradtalena" ;
  gradtapp_nn_1 = mkN "gradtapp" ;
  gradtecken_nn_1 = mkN "gradtecken" "gradtecknet" "gradtecken" "gradtecknen" ;
  gradualavhandling_nn_1 = mkN "gradualavhandling" ;
  gradualpsalm_nn_1 = mkN "gradualpsalm" "gradualpsalmer" ;
  graduell_av_1 = mkA "graduell" ;
  gradvis_ab_1 = mkAdv "gradvis" ;
  gradvis_av_1 = mkA "gradvis" ;
  graeddbakelse_nn_1 = mkN "grдddbakelse" "grдddbakelser" ;
  graeddhalt_nn_1 = mkN "grдddhalt" "grдddhalter" ;
  graeddig_av_1 = mkA "grдddig" ;
  graeddmaetare_nn_1 = mkN "grдddmдtare" "grдddmдtare" ;
  graeddvisp_nn_1 = mkN "grдddvisp" ;
  grael_nn_1 = mkN "grдl" neutrum ;
  graelaktig_av_1 = mkA "grдlaktig" ;
  graelig_av_1 = mkA "grдlig" ;
  graell_av_1 = mkA "grдll" ;
  graelmaans_nn_1 = mkN "grдlmеns" ;
  graelmakare_nn_1 = mkN "grдlmakare" "grдlmakare" ;
  graelsjuk_av_1 = mkA "grдlsjuk" ;
  graemelse_nn_1 = mkN "grдmelse" "grдmelser" ;
  graen_nn_1 = mkN "grдn" neutrum ;
  graend_nn_1 = mkN "grдnd" "grдnder" ;
  graeng_nn_1 = mkN "grдng" "grдnger" ;
  graens_nn_1 = mkN "grдns" "grдnser" ;
  graensbevakning_nn_1 = mkN "grдnsbevakning" ;
  graensbo_nn_1 = mkN "grдnsbo" "grдnsbor" ;
  graensfall_nn_1 = mkN "grдnsfall" neutrum ;
  graensintaekt_nn_1 = mkN "grдnsintдkt" "grдnsintдkter" ;
  graensjaegare_nn_1 = mkN "grдnsjдgare" "grдnsjдgare" ;
  graenskontroll_nn_1 = mkN "grдnskontroll" "grдnskontroller" ;
  graenskostnad_nn_1 = mkN "grдnskostnad" "grдnskostnader" ;
  graensle_ab_1 = mkAdv "grдnsle" ;
  graenslinje_nn_1 = mkN "grдnslinje" "grдnslinjer" ;
  graensloes_av_1 = mkA "grдnslцs" ;
  graensnytta_nn_1 = mkN "grдnsnytta" ;
  graensoeverskridande_av_1 = mkA "grдnsцverskridande" ;
  graensoeverskridande_nn_1 = mkN "grдnsцverskridande" ;
  graensomraade_nn_1 = mkN "grдnsomrеde" ;
  graenspaale_nn_1 = mkN "grдnspеle" utrum ;
  graenspolis_nn_1 = mkN "grдnspolis" "grдnspoliser" ;
  graensskikt_nn_1 = mkN "grдnsskikt" neutrum ;
  graenstrakt_nn_1 = mkN "grдnstrakt" "grдnstrakter" ;
  graensvaerde_nn_1 = mkN "grдnsvдrde" ;
  graes_nn_1 = mkN "grдs" neutrum ;
  graesaenkling_nn_1 = mkN "grдsдnkling" ;
  graesaetare_nn_1 = mkN "grдsдtare" "grдsдtare" ;
  graesand_nn_1 = mkN "grдsand" "grдsдnder" ;
  graesfjaeril_nn_1 = mkN "grдsfjдril" ;
  graesfly_nn_1 = mkN "grдsfly" "grдsflyt" "grдsflyn" "grдsflyen" ;
  graesklippare_nn_1 = mkN "grдsklippare" "grдsklippare" ;
  graeslig_av_1 = mkA "grдslig" ;
  graeslighet_nn_1 = mkN "grдslighet" "grдsligheter" ;
  graesliknande_av_1 = mkA "grдsliknande" ;
  graesmaanad_nn_1 = mkN "grдsmеnad" "grдsmеnader" ;
  graesmask_nn_1 = mkN "grдsmask" ;
  graesplan_nn_1 = mkN "grдsplan" "grдsplaner" ;
  graesrot_nn_1 = mkN "grдsrot" "grдsrцtter" ;
  graesvall_nn_1 = mkN "grдsvall" ;
  graetten_av_1 = mkA "grдtten" "grдttet" ;
  graevling_nn_1 = mkN "grдvling" ;
  graevlingsgryt_nn_1 = mkN "grдvlingsgryt" neutrum ;
  graevlingshund_nn_1 = mkN "grдvlingshund" ;
  graevmaskin_nn_1 = mkN "grдvmaskin" "grдvmaskiner" ;
  graevning_nn_1 = mkN "grдvning" ;
  graevsvin_nn_1 = mkN "grдvsvin" neutrum ;
  graf_nn_1 = mkN "graf" "grafer" ;
  grafem_nn_1 = mkN "grafem" neutrum ;
  grafematisk_av_1 = mkA "grafematisk" ;
  grafiker_nn_1 = mkN "grafiker" "grafikern" "grafiker" "grafikerna" ;
  grafisk_av_1 = mkA "grafisk" ;
  grafit_nn_1 = mkN "grafit" "grafiter" ;
  grafitdegel_nn_1 = mkN "grafitdegel" ;
  grafitgraa_av_1 = mkA "grafitgrе" "grafitgrеtt" ;
  grafolog_nn_1 = mkN "grafolog" "grafologer" ;
  grafonomisk_av_1 = mkA "grafonomisk" ;
  grafteori_nn_1 = mkN "grafteori" "grafteorier" ;
  gram_nn_1 = mkN "gram" "grammet" "gram" "grammen" ;
  gramkalori_nn_1 = mkN "gramkalori" "gramkalorier" ;
  grammatik_nn_1 = mkN "grammatik" "grammatiker" ;
  grammatikalisk_av_1 = mkA "grammatikalisk" ;
  grammatikbok_nn_1 = mkN "grammatikbok" "grammatikbцcker" ;
  grammatiker_nn_1 = mkN "grammatiker" "grammatikern" "grammatiker" "grammatikerna" ;
  grammatikregel_nn_1 = mkN "grammatikregel" "grammatikregeln" "grammatikregler" "grammatikreglerna" ;
  grammatisk_av_1 = mkA "grammatisk" ;
  grammofon_nn_1 = mkN "grammofon" "grammofoner" ;
  grammofonarkiv_nn_1 = mkN "grammofonarkiv" neutrum ;
  grammofonstift_nn_1 = mkN "grammofonstift" neutrum ;
  grammolekyl_nn_1 = mkN "grammolekyl" "grammolekyler" ;
  gramse_av_1 = mkA "gramse" ;
  gran_nn_1 = mkN "gran" ;
  gran_nn_2 = mkN "gran" neutrum ;
  granat_nn_1 = mkN "granat" "granater" ;
  granatgevaer_nn_1 = mkN "granatgevдr" neutrum ;
  granatkartesch_nn_1 = mkN "granatkartesch" "granatkartescher" ;
  granbarrlus_nn_1 = mkN "granbarrlus" "granbarrlusen" "granbarrlцss" "granbarrlцssen" ;
  grand_nn_2 = mkN "grand" "grander" ;
  grandios_av_1 = mkA "grandios" ;
  grandseigneur_nn_1 = mkN "grandseigneur" "grandseigneurer" ;
  granit_nn_1 = mkN "granit" "graniter" ;
  grann_av_1 = mkA "grann" "grant" ;
  granne_nn_1 = mkN "granne" utrum ;
  granneligen_ab_1 = mkAdv "granneligen" ;
  grannlaat_nn_1 = mkN "grannlеt" "grannlеter" ;
  grannlaga_av_1 = mkA "grannlaga" ;
  grannland_nn_1 = mkN "grannland" "grannlandet" "grannlдnder" "grannlдnderna" ;
  grannskap_nn_1 = mkN "grannskap" "grannskapet" "grannskapen" "grannskapena" ;
  grannstat_nn_1 = mkN "grannstat" "grannstater" ;
  grannsynt_av_1 = mkA "grannsynt" "grannsynt" ;
  granntyckt_av_1 = mkA "granntyckt" "granntyckt" ;
  gransaangare_nn_1 = mkN "gransеngare" "gransеngare" ;
  granskare_nn_1 = mkN "granskare" "granskare" ;
  granskning_nn_1 = mkN "granskning" ;
  granskningsexemplar_nn_1 = mkN "granskningsexemplar" neutrum ;
  granskningsman_nn_1 = mkN "granskningsman" "granskningsmannen" "granskningsmдn" "granskningsmдnnen" ;
  granskog_nn_1 = mkN "granskog" ;
  gransort_nn_1 = mkN "gransort" "gransorter" ;
  granulat_nn_1 = mkN "granulat" neutrum ;
  granulation_nn_1 = mkN "granulation" "granulationer" ;
  granulationsvaevnad_nn_1 = mkN "granulationsvдvnad" "granulationsvдvnader" ;
  granulering_nn_1 = mkN "granulering" ;
  granulum_nn_1 = mkN "granulum" "granulum" "granula" "granulana" ;
  grapefrukt_nn_1 = mkN "grapefrukt" "grapefrukter" ;
  grataeng_nn_1 = mkN "gratдng" "gratдnger" ;
  gratial_nn_1 = mkN "gratial" "gratialer" ;
  gratialist_nn_1 = mkN "gratialist" "gratialister" ;
  gratie_nn_1 = mkN "gratie" "gratier" ;
  gratifikation_nn_1 = mkN "gratifikation" "gratifikationer" ;
  gratin_nn_1 = mkN "gratin" "gratiner" ;
  gratis_ab_1 = mkAdv "gratis" ;
  gratis_av_1 = mkA "gratis" ;
  gratisaktie_nn_1 = mkN "gratisaktie" "gratisaktier" ;
  gratispassagerare_nn_1 = mkN "gratispassagerare" "gratispassagerare" ;
  gratulant_nn_1 = mkN "gratulant" "gratulanter" ;
  gratulation_nn_1 = mkN "gratulation" "gratulationer" ;
  grav_av_1 = mkA "grav" ;
  grav_nn_1 = mkN "grav" ;
  gravallvarlig_av_1 = mkA "gravallvarlig" ;
  gravand_nn_1 = mkN "gravand" "gravдnder" ;
  gravation_nn_1 = mkN "gravation" "gravationer" ;
  gravbrev_nn_1 = mkN "gravbrev" neutrum ;
  gravbyggnad_nn_1 = mkN "gravbyggnad" "gravbyggnader" ;
  grave_ab_1 = mkAdv "grave" ;
  gravenstein_nn_1 = mkN "gravenstein" "gravensteiner" ;
  graverande_av_1 = mkA "graverande" ;
  gravering_nn_1 = mkN "gravering" ;
  gravfaelt_nn_1 = mkN "gravfдlt" neutrum ;
  gravfynd_nn_1 = mkN "gravfynd" neutrum ;
  gravgaas_nn_1 = mkN "gravgеs" "gravgеsen" "gravgдss" "gravgдssen" ;
  gravhoeg_nn_1 = mkN "gravhцg" ;
  graviditet_nn_1 = mkN "graviditet" "graviditeter" ;
  graviditetstest_nn_1 = mkN "graviditetstest" neutrum ;
  graviditetsvecka_nn_1 = mkN "graviditetsvecka" ;
  gravimeter_nn_1 = mkN "gravimeter" ;
  gravitationskonstant_nn_1 = mkN "gravitationskonstant" "gravitationskonstanter" ;
  gravitationskraft_nn_1 = mkN "gravitationskraft" "gravitationskrafter" ;
  gravitationslag_nn_1 = mkN "gravitationslag" ;
  gravitationsstraalning_nn_1 = mkN "gravitationsstrеlning" ;
  gravitet_nn_1 = mkN "gravitet" "graviteter" ;
  gravitetisk_av_1 = mkA "gravitetisk" ;
  graviton_nn_1 = mkN "graviton" "gravitoner" ;
  gravkapell_nn_1 = mkN "gravkapell" neutrum ;
  gravkor_nn_1 = mkN "gravkor" neutrum ;
  gravkummel_nn_1 = mkN "gravkummel" "gravkummlet" "gravkummel" "gravkummlen" ;
  gravkyrka_nn_1 = mkN "gravkyrka" ;
  gravlax_nn_1 = mkN "gravlax" ;
  gravlik_av_1 = mkA "gravlik" ;
  gravmaterial_nn_1 = mkN "gravmaterial" neutrum ;
  gravoel_nn_1 = mkN "gravцl" neutrum ;
  gravoeppning_nn_1 = mkN "gravцppning" ;
  gravoer_nn_1 = mkN "gravцr" "gravцrer" ;
  gravplats_nn_1 = mkN "gravplats" "gravplatser" ;
  gravsaettning_nn_1 = mkN "gravsдttning" ;
  gravsed_nn_1 = mkN "gravsed" "gravseder" ;
  gravskaendning_nn_1 = mkN "gravskдndning" ;
  gravskick_nn_1 = mkN "gravskick" neutrum ;
  gravsten_nn_1 = mkN "gravsten" "gravstenen" "gravstenar" "gravstenarna" ;
  gravstickel_nn_1 = mkN "gravstickel" ;
  gravsvepning_nn_1 = mkN "gravsvepning" ;
  gravvaard_nn_1 = mkN "gravvеrd" ;
  gravvalv_nn_1 = mkN "gravvalv" neutrum ;
  gravyr_nn_1 = mkN "gravyr" "gravyrer" ;
  gray_nn_1 = mkN "gray" "grayen" "gray" "grayen" ;
  grecism_nn_1 = mkN "grecism" "grecismer" ;
  gredelin_av_1 = mkA "gredelin" ;
  green_nn_1 = mkN "green" "greener" ;
  gregoriansk_av_1 = mkA "gregoriansk" ;
  grej_nn_1 = mkN "grej" "grejer" ;
  grek_nn_1 = mkN "grek" "greker" ;
  grekcypriot_nn_1 = mkN "grekcypriot" "grekcyprioter" ;
  grekinna_nn_1 = mkN "grekinna" ;
  grekisk_av_1 = mkA "grekisk" ;
  grekisk_katolsk_av_1 = mkA "grekisk-katolsk" ;
  grekisk_ortodox_av_1 = mkA "grekisk-ortodox" ;
  grekisk_romersk_av_1 = mkA "grekisk-romersk" ;
  grekiska_nn_2 = mkN "grekiska" ;
  gren_nn_1 = mkN "gren" "grenen" "grenar" "grenarna" ;
  grenadier_nn_1 = mkN "grenadier" "grenadiern" "grenadier" "grenadierna" ;
  grenadin_nn_1 = mkN "grenadin" "grenadiner" ;
  grenadisk_av_1 = mkA "grenadisk" ;
  grenadjaer_nn_1 = mkN "grenadjдr" "grenadjдrer" ;
  grenhopp_nn_1 = mkN "grenhopp" neutrum ;
  grenig_av_1 = mkA "grenig" ;
  grenledning_nn_1 = mkN "grenledning" ;
  grenljus_nn_1 = mkN "grenljus" neutrum ;
  grensle_ab_1 = mkAdv "grensle" ;
  grenstaaende_av_1 = mkA "grenstеende" ;
  grenuttag_nn_1 = mkN "grenuttag" neutrum ;
  grenveck_nn_1 = mkN "grenveck" neutrum ;
  grenvinkel_nn_1 = mkN "grenvinkel" ;
  grep_nn_1 = mkN "grep" "greper" ;
  grepe_nn_1 = mkN "grepe" utrum ;
  grepp_nn_1 = mkN "grepp" neutrum ;
  greppbraede_nn_1 = mkN "greppbrдde" ;
  greppriktig_av_1 = mkA "greppriktig" ;
  greve_nn_1 = mkN "greve" utrum ;
  grevinna_nn_1 = mkN "grevinna" ;
  grevlig_av_1 = mkA "grevlig" ;
  grevskap_nn_1 = mkN "grevskap" "grevskapet" "grevskapen" "grevskapena" ;
  greyhound_nn_1 = mkN "greyhound" "greyhounden" "greyhounds" "greyhoundsen" ;
  griffel_nn_1 = mkN "griffel" ;
  griffeltavla_nn_1 = mkN "griffeltavla" ;
  grift_nn_1 = mkN "grift" "grifter" ;
  griftetal_nn_1 = mkN "griftetal" "griftetalet" "griftetalen" "griftetalena" ;
  grill_nn_1 = mkN "grill" ;
  grillbar_nn_1 = mkN "grillbar" "grillbarer" ;
  grillfaengeri_nn_1 = mkN "grillfдngeri" "grillfдngerit" "grillfдngerier" "grillfдngerierna" ;
  grilljanne_nn_1 = mkN "grilljanne" utrum ;
  grillspett_nn_1 = mkN "grillspett" neutrum ;
  grimas_nn_1 = mkN "grimas" "grimaser" ;
  grimskaft_nn_1 = mkN "grimskaft" neutrum ;
  grin_nn_1 = mkN "grin" neutrum ;
  grind_nn_1 = mkN "grind" ;
  grindoeppning_nn_1 = mkN "grindцppning" ;
  grindslant_nn_1 = mkN "grindslant" ;
  grindstuga_nn_1 = mkN "grindstuga" ;
  grindval_nn_1 = mkN "grindval" ;
  gringo_nn_1 = mkN "gringo" "gringon" "gringos" "gringosen" ;
  grinig_av_1 = mkA "grinig" ;
  grinolle_nn_1 = mkN "grinolle" utrum ;
  grip_nn_1 = mkN "grip" ;
  gripa_vb_1 = mkV "gripa" "grep" "gripit" ;
  gripande_av_1 = mkA "gripande" ;
  gripbar_av_1 = mkA "gripbar" ;
  gripen_av_1 = mkA "gripen" "gripet" ;
  gripfot_nn_1 = mkN "gripfot" "gripfцtter" ;
  gris_nn_1 = mkN "gris" ;
  grisaille_nn_1 = mkN "grisaille" "grisailler" ;
  griseri_nn_1 = mkN "griseri" "griserit" "griserier" "griserierna" ;
  grisett_nn_1 = mkN "grisett" "grisetter" ;
  grisig_av_1 = mkA "grisig" ;
  grisinsulin_nn_1 = mkN "grisinsulin" "grisinsuliner" ;
  griskulting_nn_1 = mkN "griskulting" ;
  grisning_nn_1 = mkN "grisning" ;
  grisningsbo_nn_1 = mkN "grisningsbo" "grisningsbot" "grisningsbon" "grisningsboen" ;
  grisoega_nn_1 = mkN "grisцga" "grisцgat" "grisцgon" "grisцgonen" ;
  grissel_nn_1 = mkN "grissel" ;
  grissvans_nn_1 = mkN "grissvans" ;
  grisunge_nn_1 = mkN "grisunge" utrum ;
  grizzlybjoern_nn_1 = mkN "grizzlybjцrn" ;
  grobarhet_nn_1 = mkN "grobarhet" "grobarheter" ;
  grobian_nn_1 = mkN "grobian" "grobianer" ;
  groblad_nn_1 = mkN "groblad" neutrum ;
  grodd_nn_1 = mkN "grodd" ;
  groddblad_nn_1 = mkN "groddblad" neutrum ;
  groddjur_nn_1 = mkN "groddjur" neutrum ;
  groddknopp_nn_1 = mkN "groddknopp" ;
  grodfisk_nn_1 = mkN "grodfisk" ;
  grodlaar_nn_1 = mkN "grodlеr" neutrum ;
  grodman_nn_1 = mkN "grodman" "grodmannen" "grodmдn" "grodmдnnen" ;
  groen_av_1 = mkA "grцn" ;
  groenalg_nn_1 = mkN "grцnalg" "grцnalger" ;
  groenblek_av_1 = mkA "grцnblek" ;
  groenblind_av_1 = mkA "grцnblind" ;
  groenfink_nn_1 = mkN "grцnfink" ;
  groengoeling_nn_1 = mkN "grцngцling" ;
  groengul_av_1 = mkA "grцngul" ;
  groening_nn_1 = mkN "grцning" ;
  groenkoepingsmaessig_av_1 = mkA "grцnkцpingsmдssig" ;
  groenlaendare_nn_1 = mkN "grцnlдndare" "grцnlдndare" ;
  groenlaendsk_av_1 = mkA "grцnlдndsk" ;
  groenlaendska_nn_2 = mkN "grцnlдndska" ;
  groenlandsval_nn_1 = mkN "grцnlandsval" ;
  groenling_nn_1 = mkN "grцnling" ;
  groenmoegelost_nn_1 = mkN "grцnmцgelost" ;
  groenmoerk_av_1 = mkA "grцnmцrk" ;
  groenmogen_av_1 = mkA "grцnmogen" "grцnmoget" ;
  groenmognad_nn_1 = mkN "grцnmognad" "grцnmognader" ;
  groenomraade_nn_1 = mkN "grцnomrеde" ;
  groenraett_nn_1 = mkN "grцnrдtt" "grцnrдtter" ;
  groensak_nn_1 = mkN "grцnsak" "grцnsaker" ;
  groensaksblandning_nn_1 = mkN "grцnsaksblandning" ;
  groensakstallrik_nn_1 = mkN "grцnsakstallrik" ;
  groensallad_nn_1 = mkN "grцnsallad" "grцnsallader" ;
  groensiska_nn_1 = mkN "grцnsiska" ;
  groenspett_nn_1 = mkN "grцnspett" ;
  groepning_nn_1 = mkN "grцpning" ;
  groet_nn_1 = mkN "grцt" ;
  groetfrukost_nn_1 = mkN "grцtfrukost" ;
  groetig_av_1 = mkA "grцtig" ;
  groetmyndig_av_1 = mkA "grцtmyndig" ;
  groetomslag_nn_1 = mkN "grцtomslag" neutrum ;
  groetrim_nn_1 = mkN "grцtrim" "grцtrimmet" "grцtrim" "grцtrimmen" ;
  groetrock_nn_1 = mkN "grцtrock" ;
  grogg_nn_1 = mkN "grogg" ;
  groggy_av_1 = mkA "groggy" ;
  grogrund_nn_1 = mkN "grogrund" "grogrunder" ;
  grop_nn_1 = mkN "grop" ;
  gropig_av_1 = mkA "gropig" ;
  groschen_nn_1 = mkN "groschen" "groschenen" "groschen" "groschenen" ;
  gross_nn_1 = mkN "gross" neutrum ;
  grossess_nn_1 = mkN "grossess" "grossesser" ;
  grosshandlare_nn_1 = mkN "grosshandlare" "grosshandlare" ;
  grossist_nn_1 = mkN "grossist" "grossister" ;
  grossistpris_nn_1 = mkN "grossistpris" neutrum ;
  grossoer_nn_1 = mkN "grossцr" "grossцrer" ;
  grotesk_av_1 = mkA "grotesk" ;
  grotesk_nn_1 = mkN "grotesk" "grotesker" ;
  groteskeri_nn_1 = mkN "groteskeri" "groteskerit" "groteskerier" "groteskerierna" ;
  grottbjoern_nn_1 = mkN "grottbjцrn" ;
  grottforskare_nn_1 = mkN "grottforskare" "grottforskare" ;
  grottgaang_nn_1 = mkN "grottgеng" ;
  grottingaang_nn_1 = mkN "grottingеng" ;
  grottinvaanare_nn_1 = mkN "grottinvеnare" "grottinvеnare" ;
  grottmaalning_nn_1 = mkN "grottmеlning" ;
  grottmaenniska_nn_1 = mkN "grottmдnniska" ;
  groupie_nn_1 = mkN "groupie" "groupien" "groupies" "groupiesen" ;
  grov_av_1 = mkA "grov" "grцvre" "grцvst" ;
  grovarbetare_nn_1 = mkN "grovarbetare" "grovarbetare" ;
  grovhet_nn_1 = mkN "grovhet" "grovheter" ;
  grovhuggen_av_1 = mkA "grovhuggen" "grovhugget" ;
  grovkoek_nn_1 = mkN "grovkцk" neutrum ;
  grovkornig_av_1 = mkA "grovkornig" ;
  grovlek_nn_1 = mkN "grovlek" ;
  grovsyssla_nn_1 = mkN "grovsyssla" ;
  grovtarm_nn_1 = mkN "grovtarm" ;
  grubblare_nn_1 = mkN "grubblare" "grubblare" ;
  grubbleri_nn_1 = mkN "grubbleri" "grubblerit" "grubblerier" "grubblerierna" ;
  gruff_nn_1 = mkN "gruff" neutrum ;
  grumlig_av_1 = mkA "grumlig" ;
  grumling_nn_1 = mkN "grumling" ;
  grumsig_av_1 = mkA "grumsig" ;
  grund_av_1 = mkA "grund" ;
  grund_nn_1 = mkN "grund" "grunder" ;
  grund_nn_2 = mkN "grund" neutrum ;
  grundackord_nn_1 = mkN "grundackord" neutrum ;
  grundaemne_nn_1 = mkN "grundдmne" ;
  grundare_nn_1 = mkN "grundare" "grundare" ;
  grundavdrag_nn_1 = mkN "grundavdrag" neutrum ;
  grundavgift_nn_1 = mkN "grundavgift" "grundavgifter" ;
  grundbelopp_nn_1 = mkN "grundbelopp" neutrum ;
  grundbetydelse_nn_1 = mkN "grundbetydelse" "grundbetydelser" ;
  grundbok_nn_1 = mkN "grundbok" "grundbцcker" ;
  grundbrott_nn_1 = mkN "grundbrott" neutrum ;
  grundbult_nn_1 = mkN "grundbult" ;
  grunddrag_nn_1 = mkN "grunddrag" neutrum ;
  grundenhet_nn_1 = mkN "grundenhet" "grundenheter" ;
  grundfaerg_nn_1 = mkN "grundfдrg" "grundfдrger" ;
  grundfalsk_av_1 = mkA "grundfalsk" ;
  grundfoerbaettring_nn_1 = mkN "grundfцrbдttring" ;
  grundform_nn_1 = mkN "grundform" "grundformer" ;
  grundhav_nn_1 = mkN "grundhav" neutrum ;
  grundkaenning_nn_1 = mkN "grundkдnning" ;
  grundkraft_nn_1 = mkN "grundkraft" "grundkrafter" ;
  grundkurs_nn_1 = mkN "grundkurs" "grundkurser" ;
  grundlaeggande_av_1 = mkA "grundlдggande" ;
  grundlaeggare_nn_1 = mkN "grundlдggare" "grundlдggare" ;
  grundlaeggning_nn_1 = mkN "grundlдggning" ;
  grundlag_nn_1 = mkN "grundlag" ;
  grundlag_nn_2 = mkN "grundlag" neutrum ;
  grundlig_av_1 = mkA "grundlig" ;
  grundligen_ab_1 = mkAdv "grundligen" ;
  grundlighet_nn_1 = mkN "grundlighet" "grundligheter" ;
  grundlinje_nn_1 = mkN "grundlinje" "grundlinjer" ;
  grundloen_nn_1 = mkN "grundlцn" "grundlцner" ;
  grundloes_av_1 = mkA "grundlцs" ;
  grundmaatt_nn_1 = mkN "grundmеtt" neutrum ;
  grundning_nn_1 = mkN "grundning" ;
  grundord_nn_1 = mkN "grundord" neutrum ;
  grundorsak_nn_1 = mkN "grundorsak" "grundorsaker" ;
  grundpelare_nn_1 = mkN "grundpelare" "grundpelare" ;
  grundperiod_nn_1 = mkN "grundperiod" "grundperioder" ;
  grundplaat_nn_1 = mkN "grundplеt" ;
  grundsats_nn_1 = mkN "grundsats" "grundsatser" ;
  grundskolelaerare_nn_1 = mkN "grundskolelдrare" "grundskolelдrare" ;
  grundskott_nn_1 = mkN "grundskott" neutrum ;
  grundspraak_nn_1 = mkN "grundsprеk" neutrum ;
  grundstam_nn_1 = mkN "grundstam" "grundstammen" "grundstammar" "grundstammarna" ;
  grundsten_nn_1 = mkN "grundsten" "grundstenen" "grundstenar" "grundstenarna" ;
  grundstoetning_nn_1 = mkN "grundstцtning" ;
  grundtal_nn_1 = mkN "grundtal" "grundtalet" "grundtalen" "grundtalena" ;
  grundtanke_nn_1 = mkN "grundtanke" utrum ;
  grundteori_nn_1 = mkN "grundteori" "grundteorier" ;
  grundton_nn_1 = mkN "grundton" "grundtoner" ;
  grundutbildning_nn_1 = mkN "grundutbildning" ;
  grundval_nn_1 = mkN "grundval" ;
  grundvatten_nn_1 = mkN "grundvatten" "grundvattnet" "grundvatten" "grundvattnen" ;
  grupp_nn_1 = mkN "grupp" "grupper" ;
  gruppbild_nn_1 = mkN "gruppbild" "gruppbilder" ;
  gruppchef_nn_1 = mkN "gruppchef" "gruppchefer" ;
  gruppdynamisk_av_1 = mkA "gruppdynamisk" ;
  gruppering_nn_1 = mkN "gruppering" ;
  gruppfoersaekring_nn_1 = mkN "gruppfцrsдkring" ;
  gruppgenitiv_nn_1 = mkN "gruppgenitiv" "gruppgenitiver" ;
  grupphus_nn_1 = mkN "grupphus" neutrum ;
  gruppkorsband_nn_1 = mkN "gruppkorsband" neutrum ;
  gruppsamtal_nn_1 = mkN "gruppsamtal" "gruppsamtalet" "gruppsamtalen" "gruppsamtalena" ;
  gruppterapi_nn_1 = mkN "gruppterapi" "gruppterapier" ;
  grupptest_nn_1 = mkN "grupptest" neutrum ;
  grusgaang_nn_1 = mkN "grusgеng" ;
  grusgrop_nn_1 = mkN "grusgrop" ;
  grusig_av_1 = mkA "grusig" ;
  grusplan_nn_1 = mkN "grusplan" "grusplaner" ;
  grustaekt_nn_1 = mkN "grustдkt" "grustдkter" ;
  grustag_nn_1 = mkN "grustag" neutrum ;
  grusvaeg_nn_1 = mkN "grusvдg" ;
  gruvbrytning_nn_1 = mkN "gruvbrytning" ;
  gruvdrift_nn_1 = mkN "gruvdrift" "gruvdrifter" ;
  gruvfaelt_nn_1 = mkN "gruvfдlt" neutrum ;
  gruvfogde_nn_1 = mkN "gruvfogde" utrum ;
  gruvgaang_nn_1 = mkN "gruvgеng" ;
  gruvhund_nn_1 = mkN "gruvhund" ;
  gruvkompass_nn_1 = mkN "gruvkompass" "gruvkompasser" ;
  gruvlave_nn_1 = mkN "gruvlave" utrum ;
  gruvlig_av_1 = mkA "gruvlig" ;
  gruvoeppning_nn_1 = mkN "gruvцppning" ;
  gruvsam_av_1 = mkA "gruvsam" "gruvsamt" "gruvsamma" "gruvsamma" "gruvsammare" "gruvsammast" "gruvsammaste" ;
  gruvschakt_nn_1 = mkN "gruvschakt" neutrum ;
  gruvstigare_nn_1 = mkN "gruvstigare" "gruvstigare" ;
  grym_av_1 = mkA "grym" "grymt" "grymma" "grymma" "grymmare" "grymmast" "grymmaste" ;
  grymhet_nn_1 = mkN "grymhet" "grymheter" ;
  grymthastighet_nn_1 = mkN "grymthastighet" "grymthastigheter" ;
  grymtning_nn_1 = mkN "grymtning" ;
  grymtoxe_nn_1 = mkN "grymtoxe" utrum ;
  gryn_nn_1 = mkN "gryn" neutrum ;
  grynig_av_1 = mkA "grynig" ;
  gryning_nn_1 = mkN "gryning" ;
  grynkorv_nn_1 = mkN "grynkorv" ;
  grynpipig_av_1 = mkA "grynpipig" ;
  gryt_nn_1 = mkN "gryt" neutrum ;
  grythund_nn_1 = mkN "grythund" ;
  grytlapp_nn_1 = mkN "grytlapp" ;
  grytskaap_nn_1 = mkN "grytskеp" neutrum ;
  grytstek_nn_1 = mkN "grytstek" ;
  grytvante_nn_1 = mkN "grytvante" utrum ;
  guanin_nn_1 = mkN "guanin" "guaninet" "guaniner" "guaninerna" ;
  guatemalan_nn_1 = mkN "guatemalan" "guatemalaner" ;
  guatemalansk_av_1 = mkA "guatemalansk" ;
  guatemaltek_nn_1 = mkN "guatemaltek" "guatemalteker" ;
  guatemaltekisk_av_1 = mkA "guatemaltekisk" ;
  guayanan_nn_1 = mkN "guayanan" "guayananer" ;
  guayansk_av_1 = mkA "guayansk" ;
  gubbe_nn_1 = mkN "gubbe" utrum ;
  gubbig_av_1 = mkA "gubbig" ;
  gubbsjuk_av_1 = mkA "gubbsjuk" ;
  gubbstrutt_nn_1 = mkN "gubbstrutt" ;
  guckusko_nn_1 = mkN "guckusko" "guckuskor" ;
  gud_nn_1 = mkN "gud" ;
  gudaktig_av_1 = mkA "gudaktig" ;
  gudalaera_nn_1 = mkN "gudalдra" ;
  gudasaend_av_1 = mkA "gudasдnd" ;
  gudasaga_nn_1 = mkN "gudasaga" ;
  gudbarn_nn_1 = mkN "gudbarn" neutrum ;
  guddotter_nn_1 = mkN "guddotter" "guddottern" "guddцttrar" "guddцttrarna" ;
  gudelig_av_1 = mkA "gudelig" ;
  gudfader_nn_1 = mkN "gudfader" "gudfadern" "gudfдder" "gudfдderna" ;
  gudfruktig_av_1 = mkA "gudfruktig" ;
  gudi_ab_1 = mkAdv "gudi" ;
  gudilov_ab_1 = mkAdv "gudilov" ;
  guding_nn_1 = mkN "guding" ;
  gudinna_nn_1 = mkN "gudinna" ;
  gudinog_ab_1 = mkAdv "gudinog" ;
  gudlig_av_1 = mkA "gudlig" ;
  gudloes_av_1 = mkA "gudlцs" ;
  gudmoder_nn_1 = mkN "gudmoder" "gudmodern" "gudmцdrar" "gudmцdrarna" ;
  gudom_nn_1 = mkN "gudom" ;
  gudomlig_av_1 = mkA "gudomlig" ;
  gudsbevis_nn_1 = mkN "gudsbevis" neutrum ;
  gudsdom_nn_1 = mkN "gudsdom" ;
  gudsfoergaeten_av_1 = mkA "gudsfцrgдten" "gudsfцrgдtet" ;
  gudsfoernekare_nn_1 = mkN "gudsfцrnekare" "gudsfцrnekare" ;
  gudsfoernekelse_nn_1 = mkN "gudsfцrnekelse" "gudsfцrnekelser" ;
  gudskelov_ab_1 = mkAdv "gudskelov" ;
  gudslaan_nn_1 = mkN "gudslеn" neutrum ;
  gudsman_nn_1 = mkN "gudsman" "gudsmannen" "gudsmдn" "gudsmдnnen" ;
  gudsnaadelig_av_1 = mkA "gudsnеdelig" ;
  gudson_nn_1 = mkN "gudson" "gudsцner" ;
  gudsord_nn_1 = mkN "gudsord" neutrum ;
  gudstjaenst_nn_1 = mkN "gudstjдnst" "gudstjдnster" ;
  gudstjaenstdag_nn_1 = mkN "gudstjдnstdag" ;
  gudstjaenstritual_nn_1 = mkN "gudstjдnstritual" neutrum ;
  gudunge_nn_1 = mkN "gudunge" utrum ;
  guide_nn_1 = mkN "guide" "guider" ;
  guinea_nn_1 = mkN "guinea" "guinean" "guineas" "guineasen" ;
  guinean_nn_1 = mkN "guinean" "guineaner" ;
  guineansk_av_1 = mkA "guineansk" ;
  gul_av_1 = mkA "gul" ;
  gulasch_nn_2 = mkN "gulasch" "gulascher" ;
  gulaschbaron_nn_1 = mkN "gulaschbaron" "gulaschbaroner" ;
  gulblek_av_1 = mkA "gulblek" ;
  gulblommig_av_1 = mkA "gulblommig" ;
  gulbrun_av_1 = mkA "gulbrun" ;
  guld_nn_1 = mkN "guld" neutrum ;
  guldaalder_nn_1 = mkN "guldеlder" ;
  guldbagge_nn_1 = mkN "guldbagge" utrum ;
  guldbarr_nn_1 = mkN "guldbarr" "guldbarrer" ;
  guldberlock_nn_1 = mkN "guldberlock" "guldberlocker" ;
  guldbroellop_nn_1 = mkN "guldbrцllop" neutrum ;
  gulddrageri_nn_1 = mkN "gulddrageri" "gulddragerit" "gulddragerier" "gulddragerierna" ;
  gulden_nn_1 = mkN "gulden" "guldenen" "gulden" "guldenen" ;
  guldfasan_nn_1 = mkN "guldfasan" "guldfasaner" ;
  guldfisk_nn_1 = mkN "guldfisk" ;
  guldfoeremaal_nn_1 = mkN "guldfцremеl" neutrum ;
  guldfux_nn_1 = mkN "guldfux" ;
  guldfynd_nn_1 = mkN "guldfynd" neutrum ;
  guldgraevare_nn_1 = mkN "guldgrдvare" "guldgrдvare" ;
  guldhalt_nn_1 = mkN "guldhalt" "guldhalter" ;
  guldkalv_nn_1 = mkN "guldkalv" ;
  guldkant_nn_1 = mkN "guldkant" "guldkanter" ;
  guldklimp_nn_1 = mkN "guldklimp" ;
  guldkorn_nn_1 = mkN "guldkorn" neutrum ;
  guldkrog_nn_1 = mkN "guldkrog" ;
  guldlegering_nn_1 = mkN "guldlegering" ;
  guldliknande_av_1 = mkA "guldliknande" ;
  guldmakare_nn_1 = mkN "guldmakare" "guldmakare" ;
  guldmakeri_nn_1 = mkN "guldmakeri" "guldmakerit" "guldmakerier" "guldmakerierna" ;
  guldmakrill_nn_1 = mkN "guldmakrill" ;
  guldmedalj_nn_1 = mkN "guldmedalj" "guldmedaljer" ;
  guldmedaljoer_nn_1 = mkN "guldmedaljцr" "guldmedaljцrer" ;
  guldmynt_nn_1 = mkN "guldmynt" neutrum ;
  guldplants_nn_1 = mkN "guldplants" ;
  guldpressning_nn_1 = mkN "guldpressning" ;
  guldprov_nn_1 = mkN "guldprov" neutrum ;
  guldreserv_nn_1 = mkN "guldreserv" "guldreserver" ;
  guldrush_nn_1 = mkN "guldrush" "guldrusher" ;
  guldslagare_nn_1 = mkN "guldslagare" "guldslagare" ;
  guldslageri_nn_1 = mkN "guldslageri" "guldslagerit" "guldslagerier" "guldslagerierna" ;
  guldsmed_nn_1 = mkN "guldsmed" "guldsmeder" ;
  guldsmidd_av_1 = mkA "guldsmidd" ;
  guldsmide_nn_1 = mkN "guldsmide" ;
  guldsnitt_nn_1 = mkN "guldsnitt" neutrum ;
  guldstaempel_nn_1 = mkN "guldstдmpel" ;
  guldstekel_nn_1 = mkN "guldstekel" ;
  guldtand_nn_1 = mkN "guldtand" "guldtдnder" ;
  guldtraad_nn_1 = mkN "guldtrеd" ;
  guldvaag_nn_1 = mkN "guldvеg" ;
  guldvaskning_nn_1 = mkN "guldvaskning" ;
  gulesaeck_nn_1 = mkN "gulesдck" ;
  gulfaergning_nn_1 = mkN "gulfдrgning" ;
  gulfilter_nn_1 = mkN "gulfilter" neutrum ;
  gulgraa_av_1 = mkA "gulgrе" "gulgrеtt" ;
  guling_nn_1 = mkN "guling" ;
  gulkropp_nn_1 = mkN "gulkropp" ;
  gull_nn_1 = mkN "gull" neutrum ;
  gullegris_nn_1 = mkN "gullegris" ;
  gullgosse_nn_1 = mkN "gullgosse" utrum ;
  gullgris_nn_1 = mkN "gullgris" ;
  gullig_av_1 = mkA "gullig" ;
  gullstol_nn_1 = mkN "gullstol" ;
  gulning_nn_1 = mkN "gulning" ;
  gulroed_av_1 = mkA "gulrцd" ;
  gulsaeck_nn_1 = mkN "gulsдck" ;
  gulsiktig_av_1 = mkA "gulsiktig" ;
  gulsparv_nn_1 = mkN "gulsparv" ;
  gulsporre_nn_1 = mkN "gulsporre" utrum ;
  gulvit_av_1 = mkA "gulvit" ;
  gummering_nn_1 = mkN "gummering" ;
  gummi_nn_1 = mkN "gummi" "gummit" "gummin" "gummina" ;
  gummibaat_nn_1 = mkN "gummibеt" ;
  gummiband_nn_1 = mkN "gummiband" neutrum ;
  gummidaeck_nn_1 = mkN "gummidдck" neutrum ;
  gummiharts_nn_1 = mkN "gummiharts" "gummihartset" "gummihartser" "gummihartserna" ;
  gummimaterial_nn_1 = mkN "gummimaterial" neutrum ;
  gummiparagraf_nn_1 = mkN "gummiparagraf" "gummiparagrafer" ;
  gummisnodd_nn_1 = mkN "gummisnodd" ;
  gummistoevel_nn_1 = mkN "gummistцvel" ;
  gummitraed_nn_1 = mkN "gummitrдd" neutrum ;
  gummoes_av_1 = mkA "gummцs" ;
  gump_nn_1 = mkN "gump" ;
  gumpkoertel_nn_1 = mkN "gumpkцrtel" ;
  gumse_nn_1 = mkN "gumse" utrum ;
  gungbraede_nn_1 = mkN "gungbrдde" ;
  gungfly_nn_1 = mkN "gungfly" "gungflyt" "gungflyn" "gungflyen" ;
  gunghaest_nn_1 = mkN "gunghдst" ;
  gungig_av_1 = mkA "gungig" ;
  gungning_nn_1 = mkN "gungning" ;
  gungstol_nn_1 = mkN "gungstol" ;
  gunrum_nn_1 = mkN "gunrum" "gunrummet" "gunrum" "gunrummen" ;
  gunst_nn_1 = mkN "gunst" "gunster" ;
  gunstbenaegen_av_1 = mkA "gunstbenдgen" "gunstbenдget" ;
  gunstig_av_1 = mkA "gunstig" ;
  gunstling_nn_1 = mkN "gunstling" ;
  gupp_nn_1 = mkN "gupp" neutrum ;
  guppig_av_1 = mkA "guppig" ;
  guppy_nn_1 = mkN "guppy" "guppyn" "guppies" "guppyerna" ;
  gurami_nn_1 = mkN "gurami" "guramin" "guramier" "guramierna" ;
  gurgel_nn_1 = mkN "gurgel" neutrum ;
  gurkha_nn_1 = mkN "gurkha" ;
  gurklist_nn_1 = mkN "gurklist" "gurklister" ;
  gurkvaext_nn_1 = mkN "gurkvдxt" "gurkvдxter" ;
  guru_nn_1 = mkN "guru" "gurun" "guruer" "guruerna" ;
  gustavian_nn_1 = mkN "gustavian" "gustavianer" ;
  gustaviansk_av_1 = mkA "gustaviansk" ;
  gute_nn_1 = mkN "gute" utrum ;
  gutnisk_av_1 = mkA "gutnisk" ;
  guttural_av_1 = mkA "guttural" ;
  guvernant_nn_1 = mkN "guvernant" "guvernanter" ;
  guvernement_nn_1 = mkN "guvernement" "guvernementet" "guvernementen" "guvernementena" ;
  guvernoer_nn_1 = mkN "guvernцr" "guvernцrer" ;
  gyckelbild_nn_1 = mkN "gyckelbild" "gyckelbilder" ;
  gyckelspel_nn_1 = mkN "gyckelspel" "gyckelspelet" "gyckelspel" "gyckelspelen" ;
  gycklare_nn_1 = mkN "gycklare" "gycklare" ;
  gyckleri_nn_1 = mkN "gyckleri" "gycklerit" "gycklerier" "gycklerierna" ;
  gydja_nn_1 = mkN "gydja" ;
  gylf_nn_1 = mkN "gylf" ;
  gyllen_nn_1 = mkN "gyllen" neutrum ;
  gyllen_nn_2 = mkN "gyllen" "gyllenen" "gyllen" "gyllenen" ;
  gyllen_nn_3 = mkN "gyllen" "gyllen" "gyllen" "gyllena" ;
  gyllene_av_1 = mkA "gyllene" ;
  gyllental_nn_1 = mkN "gyllental" neutrum ;
  gylling_nn_1 = mkN "gylling" ;
  gym_nn_1 = mkN "gym" "gymmet" "gym" "gymmen" ;
  gymnasial_av_1 = mkA "gymnasial" ;
  gymnasieekonom_nn_1 = mkN "gymnasieekonom" "gymnasieekonomer" ;
  gymnasieingenjoer_nn_1 = mkN "gymnasieingenjцr" "gymnasieingenjцrer" ;
  gymnasieinspektoer_nn_1 = mkN "gymnasieinspektцr" "gymnasieinspektцrer" ;
  gymnasielinje_nn_1 = mkN "gymnasielinje" "gymnasielinjer" ;
  gymnasist_nn_1 = mkN "gymnasist" "gymnasister" ;
  gymnasium_nn_1 = mkN "gymnasium" "gymnasiet" "gymnasier" "gymnasierna" ;
  gymnast_nn_1 = mkN "gymnast" "gymnaster" ;
  gymnastikdirektoer_nn_1 = mkN "gymnastikdirektцr" "gymnastikdirektцrer" ;
  gymnastikdraekt_nn_1 = mkN "gymnastikdrдkt" "gymnastikdrдkter" ;
  gymnastikhopp_nn_1 = mkN "gymnastikhopp" neutrum ;
  gymnastikredskap_nn_1 = mkN "gymnastikredskap" "gymnastikredskapet" "gymnastikredskapen" "gymnastikredskapena" ;
  gymnastiksko_nn_1 = mkN "gymnastiksko" "gymnastikskor" ;
  gymnastisk_av_1 = mkA "gymnastisk" ;
  gymnisk_av_1 = mkA "gymnisk" ;
  gymnosperm_nn_1 = mkN "gymnosperm" "gymnospermer" ;
  gynekolog_nn_1 = mkN "gynekolog" "gynekologer" ;
  gynekologisk_av_1 = mkA "gynekologisk" ;
  gynnare_nn_1 = mkN "gynnare" "gynnare" ;
  gynnsam_av_1 = mkA "gynnsam" "gynnsamt" "gynnsamma" "gynnsamma" "gynnsammare" "gynnsammast" "gynnsammaste" ;
  gyro_nn_1 = mkN "gyro" "gyrot" "gyron" "gyrona" ;
  gyrohorisont_nn_1 = mkN "gyrohorisont" "gyrohorisonter" ;
  gyrokompass_nn_1 = mkN "gyrokompass" "gyrokompasser" ;
  gyroskop_nn_1 = mkN "gyroskop" neutrum ;
  gyroskopkompass_nn_1 = mkN "gyroskopkompass" "gyroskopkompasser" ;
  gyrostabilisator_nn_1 = mkN "gyrostabilisator" "gyrostabilisatorer" ;
  gyttjebad_nn_1 = mkN "gyttjebad" neutrum ;
  gyttjig_av_1 = mkA "gyttjig" ;
  gyttrig_av_1 = mkA "gyttrig" ;
  gyttring_nn_1 = mkN "gyttring" ;
  haabrand_nn_1 = mkN "hеbrand" ;
  haagkomst_nn_1 = mkN "hеgkomst" "hеgkomster" ;
  haagloes_av_1 = mkA "hеglцs" ;
  haakaering_nn_1 = mkN "hеkдring" ;
  haal_nn_1 = mkN "hеl" neutrum ;
  haalfot_nn_1 = mkN "hеlfot" "hеlfцtter" ;
  haalfotsinlaegg_nn_1 = mkN "hеlfotsinlдgg" neutrum ;
  haalig_av_1 = mkA "hеlig" ;
  haalighet_nn_1 = mkN "hеlighet" "hеligheter" ;
  haalkael_nn_1 = mkN "hеlkдl" ;
  haalkort_nn_1 = mkN "hеlkort" neutrum ;
  haall_nn_1 = mkN "hеll" neutrum ;
  haalla_vb_1 = mkV "hеlla" "hцll" "hеllit" ;
  haallare_nn_1 = mkN "hеllare" "hеllare" ;
  haallbar_av_1 = mkA "hеllbar" ;
  haallbarhet_nn_1 = mkN "hеllbarhet" "hеllbarheter" ;
  haallbarhetsdag_nn_1 = mkN "hеllbarhetsdag" ;
  haalldam_nn_1 = mkN "hеlldam" "hеlldamer" ;
  haallen_av_1 = mkA "hеllen" "hеllet" ;
  haallfast_av_1 = mkA "hеllfast" "hеllfast" ;
  haallfasthet_nn_1 = mkN "hеllfasthet" "hеllfastheter" ;
  haallfasthetsberaekning_nn_1 = mkN "hеllfasthetsberдkning" ;
  haallfasthetslaera_nn_1 = mkN "hеllfasthetslдra" ;
  haallhake_nn_1 = mkN "hеllhake" utrum ;
  haalligaang_nn_1 = mkN "hеlligеng" neutrum ;
  haallning_nn_1 = mkN "hеllning" ;
  haallningsloes_av_1 = mkA "hеllningslцs" ;
  haallplats_nn_1 = mkN "hеllplats" "hеllplatser" ;
  haallpunkt_nn_1 = mkN "hеllpunkt" "hеllpunkter" ;
  haalmoenster_nn_1 = mkN "hеlmцnster" neutrum ;
  haaloegd_av_1 = mkA "hеlцgd" "hеlцgt" ;
  haalrum_nn_1 = mkN "hеlrum" "hеlrummet" "hеlrum" "hеlrummen" ;
  haalslag_nn_1 = mkN "hеlslag" neutrum ;
  haalslagning_nn_1 = mkN "hеlslagning" ;
  haalslev_nn_1 = mkN "hеlslev" ;
  haaltimme_nn_1 = mkN "hеltimme" utrum ;
  haalvaeg_nn_1 = mkN "hеlvдg" ;
  haalven_nn_1 = mkN "hеlven" "hеlvener" ;
  haanfull_av_1 = mkA "hеnfull" ;
  haanskratt_nn_1 = mkN "hеnskratt" neutrum ;
  haar_nn_1 = mkN "hеr" neutrum ;
  haarband_nn_1 = mkN "hеrband" neutrum ;
  haarbeklaednad_nn_1 = mkN "hеrbeklдdnad" "hеrbeklдdnader" ;
  haarbevuxen_av_1 = mkA "hеrbevuxen" "hеrbevuxet" ;
  haarborste_nn_1 = mkN "hеrborste" utrum ;
  haarbotten_nn_1 = mkN "hеrbotten" ;
  haard_av_1 = mkA "hеrd" "hеrt" ;
  haarddata_nn_1 = mkN "hеrddata" "hеrddatan" "hеrddata" "hеrddatana" ;
  haardfoer_av_1 = mkA "hеrdfцr" ;
  haardfrusen_av_1 = mkA "hеrdfrusen" "hеrdfruset" ;
  haardhaent_av_1 = mkA "hеrdhдnt" "hеrdhдnt" ;
  haardhet_nn_1 = mkN "hеrdhet" "hеrdheter" ;
  haarding_nn_1 = mkN "hеrding" ;
  haardkokt_av_1 = mkA "hеrdkokt" "hеrdkokt" ;
  haardmetall_nn_1 = mkN "hеrdmetall" "hеrdmetaller" ;
  haardra_vb_1 = mkV "hеrdra" "hеrdrar" "hеrdra" "hеrdrog" "hеrdragit" "hеrdragen" ;
  haardsmaelt_av_1 = mkA "hеrdsmдlt" "hеrdsmдlt" ;
  haardvaluta_nn_1 = mkN "hеrdvaluta" ;
  haarfaellning_nn_1 = mkN "hеrfдllning" ;
  haarfaerg_nn_1 = mkN "hеrfдrg" "hеrfдrger" ;
  haarfin_av_1 = mkA "hеrfin" ;
  haarfrisoer_nn_1 = mkN "hеrfrisцr" "hеrfrisцrer" ;
  haarfrisoerska_nn_1 = mkN "hеrfrisцrska" ;
  haarig_av_1 = mkA "hеrig" ;
  haarklyveri_nn_1 = mkN "hеrklyveri" "hеrklyverit" "hеrklyverier" "hеrklyverierna" ;
  haarknut_nn_1 = mkN "hеrknut" ;
  haarkors_nn_1 = mkN "hеrkors" neutrum ;
  haarlaeggning_nn_1 = mkN "hеrlдggning" ;
  haarlag_nn_1 = mkN "hеrlag" neutrum ;
  haarliknande_av_1 = mkA "hеrliknande" ;
  haarlock_nn_1 = mkN "hеrlock" ;
  haarloes_av_1 = mkA "hеrlцs" ;
  haarnaal_nn_1 = mkN "hеrnеl" ;
  haarolja_nn_1 = mkN "hеrolja" ;
  haarpensel_nn_1 = mkN "hеrpensel" ;
  haarrem_nn_1 = mkN "hеrrem" "hеrremmen" "hеrremmar" "hеrremmarna" ;
  haarresande_av_1 = mkA "hеrresande" ;
  haarroer_nn_1 = mkN "hеrrцr" neutrum ;
  haarroerskaerl_nn_1 = mkN "hеrrцrskдrl" neutrum ;
  haarrulle_nn_1 = mkN "hеrrulle" utrum ;
  haarsaeck_nn_1 = mkN "hеrsдck" ;
  haarsida_nn_1 = mkN "hеrsida" ;
  haarspaenne_nn_1 = mkN "hеrspдnne" ;
  haarstraa_nn_1 = mkN "hеrstrе" "hеrstrеet" "hеrstrеn" "hеrstrеna" ;
  haarsvall_nn_1 = mkN "hеrsvall" neutrum ;
  haartest_nn_1 = mkN "hеrtest" ;
  haartofs_nn_1 = mkN "hеrtofs" ;
  haartork_nn_1 = mkN "hеrtork" ;
  haartuss_nn_1 = mkN "hеrtuss" ;
  haartvaett_nn_1 = mkN "hеrtvдtt" ;
  haaruppsaettning_nn_1 = mkN "hеruppsдttning" ;
  haarvatten_nn_1 = mkN "hеrvatten" "hеrvattnet" "hеrvatten" "hеrvattnen" ;
  haav_nn_1 = mkN "hеv" ;
  habil_av_1 = mkA "habil" ;
  habilitet_nn_1 = mkN "habilitet" "habiliteter" ;
  habit_nn_1 = mkN "habit" "habiter" ;
  habitue_nn_1 = mkN "habituй" "habituйer" ;
  habituell_av_1 = mkA "habituell" ;
  habitus_nn_1 = mkN "habitus" ;
  habsburgsk_av_1 = mkA "habsburgsk" ;
  hack_nn_1 = mkN "hack" neutrum ;
  hackbraede_nn_1 = mkN "hackbrдde" ;
  hacker_nn_1 = mkN "hacker" ;
  hackig_av_1 = mkA "hackig" ;
  hackkyckling_nn_1 = mkN "hackkyckling" ;
  hackspett_nn_1 = mkN "hackspett" ;
  haeck_nn_1 = mkN "hдck" ;
  haeckfaagel_nn_1 = mkN "hдckfеgel" ;
  haecklare_nn_1 = mkN "hдcklare" "hдcklare" ;
  haeckloepning_nn_1 = mkN "hдcklцpning" ;
  haecklopp_nn_1 = mkN "hдcklopp" neutrum ;
  haeckning_nn_1 = mkN "hдckning" ;
  haedan_ab_1 = mkAdv "hдdan" ;
  haedanefter_ab_1 = mkAdv "hдdanefter" ;
  haedanfaerd_nn_1 = mkN "hдdanfдrd" "hдdanfдrder" ;
  haedangaangen_av_1 = mkA "hдdangеngen" "hдdangеnget" ;
  haedelse_nn_1 = mkN "hдdelse" "hдdelser" ;
  haedisk_av_1 = mkA "hдdisk" ;
  haeftapparat_nn_1 = mkN "hдftapparat" "hдftapparater" ;
  haefte_nn_1 = mkN "hдfte" ;
  haeftig_av_1 = mkA "hдftig" ;
  haeftklammer_nn_1 = mkN "hдftklammer" "hдftklammern" "hдftklammer" "hдftklammerna" ;
  haeftplaaster_nn_1 = mkN "hдftplеster" neutrum ;
  haeftstift_nn_1 = mkN "hдftstift" neutrum ;
  haeger_nn_1 = mkN "hдger" ;
  haegg_nn_1 = mkN "hдgg" ;
  haegnad_nn_1 = mkN "hдgnad" "hдgnader" ;
  haegring_nn_1 = mkN "hдgring" ;
  haekte_nn_1 = mkN "hдkte" ;
  haektning_nn_1 = mkN "hдktning" ;
  hael_nn_1 = mkN "hдl" ;
  haelare_nn_1 = mkN "hдlare" "hдlare" ;
  haelben_nn_1 = mkN "hдlben" neutrum ;
  haeleri_nn_1 = mkN "hдleri" "hдlerit" "hдlerier" "hдlerierna" ;
  haelft_nn_1 = mkN "hдlft" "hдlfter" ;
  haelftenbruk_nn_1 = mkN "hдlftenbruk" neutrum ;
  haelgaangare_nn_1 = mkN "hдlgеngare" "hдlgеngare" ;
  haell_nn_1 = mkN "hдll" ;
  haellmark_nn_1 = mkN "hдllmark" "hдllmarker" ;
  haellregn_nn_1 = mkN "hдllregn" neutrum ;
  haellristning_nn_1 = mkN "hдllristning" ;
  haelsing_nn_1 = mkN "hдlsing" ;
  haelsning_nn_1 = mkN "hдlsning" ;
  haelsningsanfoerande_nn_1 = mkN "hдlsningsanfцrande" ;
  haelsobringande_av_1 = mkA "hдlsobringande" ;
  haelsobrunn_nn_1 = mkN "hдlsobrunn" ;
  haelsocenter_nn_1 = mkN "hдlsocenter" "hдlsocentret" "hдlsocentrer" "hдlsocentrerna" ;
  haelsoeffekt_nn_1 = mkN "hдlsoeffekt" "hдlsoeffekter" ;
  haelsofarlig_av_1 = mkA "hдlsofarlig" ;
  haelsokontroll_nn_1 = mkN "hдlsokontroll" "hдlsokontroller" ;
  haelsokort_nn_1 = mkN "hдlsokort" neutrum ;
  haelsosam_av_1 = mkA "hдlsosam" "hдlsosamt" "hдlsosamma" "hдlsosamma" "hдlsosammare" "hдlsosammast" "hдlsosammaste" ;
  haelsotecken_nn_1 = mkN "hдlsotecken" "hдlsotecknet" "hдlsotecken" "hдlsotecknen" ;
  haelsotek_nn_1 = mkN "hдlsotek" neutrum ;
  haelsovaadlig_av_1 = mkA "hдlsovеdlig" ;
  haelsovaardsnaemnd_nn_1 = mkN "hдlsovеrdsnдmnd" "hдlsovеrdsnдmnder" ;
  haemnare_nn_1 = mkN "hдmnare" "hдmnare" ;
  haemndaktion_nn_1 = mkN "hдmndaktion" "hдmndaktioner" ;
  haemndeande_nn_1 = mkN "hдmndeande" utrum ;
  haemndgirig_av_1 = mkA "hдmndgirig" ;
  haemndgudinna_nn_1 = mkN "hдmndgudinna" ;
  haemndlysten_av_1 = mkA "hдmndlysten" "hдmndlystet" ;
  haemndlystnad_nn_1 = mkN "hдmndlystnad" "hдmndlystnader" ;
  haemning_nn_1 = mkN "hдmning" ;
  haemningsloes_av_1 = mkA "hдmningslцs" ;
  haempling_nn_1 = mkN "hдmpling" ;
  haemsko_nn_1 = mkN "hдmsko" "hдmskor" ;
  haemtning_nn_1 = mkN "hдmtning" ;
  haemtpris_nn_1 = mkN "hдmtpris" neutrum ;
  haen_ab_1 = mkAdv "hдn" ;
  haendelse_nn_1 = mkN "hдndelse" "hдndelser" ;
  haendelsefattig_av_1 = mkA "hдndelsefattig" ;
  haendelsefoerlopp_nn_1 = mkN "hдndelsefцrlopp" neutrum ;
  haendelseloes_av_1 = mkA "hдndelselцs" ;
  haendelserik_av_1 = mkA "hдndelserik" ;
  haendelsevis_ab_1 = mkAdv "hдndelsevis" ;
  haendig_av_1 = mkA "hдndig" ;
  haenfoerande_av_1 = mkA "hдnfцrande" ;
  haenfoerd_av_1 = mkA "hдnfцrd" "hдnfцrt" ;
  haengande_nn_1 = mkN "hдngande" ;
  haengare_nn_1 = mkN "hдngare" "hдngare" ;
  haengavtal_nn_1 = mkN "hдngavtal" "hдngavtalet" "hдngavtalen" "hдngavtalena" ;
  haengbjoerk_nn_1 = mkN "hдngbjцrk" ;
  haengbro_nn_1 = mkN "hдngbro" ;
  haengbroest_nn_1 = mkN "hдngbrцst" neutrum ;
  haengbuk_nn_1 = mkN "hдngbuk" ;
  haengdal_nn_1 = mkN "hдngdal" ;
  haenge_vb_1 = mkV "hдnge" "hдnger" "hдnge" "hдngav" "hдngett" "hдngiven" ;
  haengfaerdig_av_1 = mkA "hдngfдrdig" ;
  haengig_av_1 = mkA "hдngig" ;
  haengiven_av_1 = mkA "hдngiven" "hдngivet" ;
  haenglaas_nn_1 = mkN "hдnglеs" neutrum ;
  haengning_nn_1 = mkN "hдngning" ;
  haengparti_nn_1 = mkN "hдngparti" "hдngpartit" "hдngpartier" "hдngpartierna" ;
  haengsjuk_av_1 = mkA "hдngsjuk" ;
  haengsmycke_nn_1 = mkN "hдngsmycke" ;
  haenryckt_av_1 = mkA "hдnryckt" "hдnryckt" ;
  haenseende_nn_1 = mkN "hдnseende" ;
  haensjunken_av_1 = mkA "hдnsjunken" "hдnsjunket" ;
  haenskjuta_vb_1 = mkV "hдnskjuta" "hдnskцt" "hдnskjutit" ;
  haensoven_av_1 = mkA "hдnsoven" "hдnsovet" ;
  haensyftning_nn_1 = mkN "hдnsyftning" ;
  haensyn_nn_1 = mkN "hдnsyn" "hдnsynen" "hдnsyn" "hдnsynen" ;
  haensynsfull_av_1 = mkA "hдnsynsfull" ;
  haensynsloes_av_1 = mkA "hдnsynslцs" ;
  haensynstagande_nn_1 = mkN "hдnsynstagande" ;
  haentydning_nn_1 = mkN "hдntydning" ;
  haenvaendelse_nn_1 = mkN "hдnvдndelse" "hдnvдndelser" ;
  haenvisning_nn_1 = mkN "hдnvisning" ;
  haepen_av_1 = mkA "hдpen" "hдpet" ;
  haepnad_nn_1 = mkN "hдpnad" "hдpnader" ;
  haepnadsvaeckande_av_1 = mkA "hдpnadsvдckande" ;
  haer_ab_1 = mkAdv "hдr" ;
  haer_nn_1 = mkN "hдr" ;
  haeraat_ab_1 = mkAdv "hдrеt" ;
  haerad_nn_1 = mkN "hдrad" "hдradet" "hдrad" "hдradena" ;
  haeradshoevding_nn_1 = mkN "hдradshцvding" ;
  haeradsraett_nn_1 = mkN "hдradsrдtt" "hдradsrдtter" ;
  haeradsskrivare_nn_1 = mkN "hдradsskrivare" "hдradsskrivare" ;
  haerav_ab_1 = mkAdv "hдrav" ;
  haerd_nn_1 = mkN "hдrd" ;
  haerdig_av_1 = mkA "hдrdig" ;
  haerdighet_nn_1 = mkN "hдrdighet" "hдrdigheter" ;
  haerdighetskrav_nn_1 = mkN "hдrdighetskrav" neutrum ;
  haerdlack_nn_1 = mkN "hдrdlack" "hдrdlacker" ;
  haerdning_nn_1 = mkN "hдrdning" ;
  haerdplast_nn_1 = mkN "hдrdplast" "hдrdplaster" ;
  haerefter_ab_1 = mkAdv "hдrefter" ;
  haeremot_ab_1 = mkAdv "hдremot" ;
  haerfaagel_nn_1 = mkN "hдrfеgel" ;
  haerflyta_vb_1 = mkV "hдrflyta" "hдrflцt" "hдrflutit" ;
  haerfoer_ab_1 = mkAdv "hдrfцr" ;
  haerfoerare_nn_1 = mkN "hдrfцrare" "hдrfцrare" ;
  haerfoerleden_ab_1 = mkAdv "hдrfцrleden" ;
  haeri_ab_1 = mkAdv "hдri" ;
  haerifraan_ab_1 = mkAdv "hдrifrеn" ;
  haerigenom_ab_1 = mkAdv "hдrigenom" ;
  haerjaemte_ab_1 = mkAdv "hдrjдmte" ;
  haerjedaling_nn_1 = mkN "hдrjedaling" ;
  haerjedalsk_av_1 = mkA "hдrjedalsk" ;
  haerjning_nn_1 = mkN "hдrjning" ;
  haerk_nn_1 = mkN "hдrk" ;
  haerledning_nn_1 = mkN "hдrledning" ;
  haerlig_av_1 = mkA "hдrlig" ;
  haerlighet_nn_1 = mkN "hдrlighet" "hдrligheter" ;
  haermask_nn_1 = mkN "hдrmask" ;
  haermed_ab_1 = mkAdv "hдrmed" ;
  haermfaagel_nn_1 = mkN "hдrmfеgel" ;
  haernad_nn_1 = mkN "hдrnad" "hдrnader" ;
  haernaest_ab_1 = mkAdv "hдrnдst" ;
  haerold_nn_1 = mkN "hдrold" "hдrolder" ;
  haerom_ab_1 = mkAdv "hдrom" ;
  haeromaaret_ab_1 = mkAdv "hдromеret" ;
  haeromdagen_ab_1 = mkAdv "hдromdagen" ;
  haeromsistens_ab_1 = mkAdv "hдromsistens" ;
  haerordning_nn_1 = mkN "hдrordning" ;
  haerpaa_ab_1 = mkAdv "hдrpе" ;
  haerskare_nn_1 = mkN "hдrskare" "hдrskare" ;
  haerskarinna_nn_1 = mkN "hдrskarinna" ;
  haerskarklass_nn_1 = mkN "hдrskarklass" "hдrskarklasser" ;
  haersken_av_1 = mkA "hдrsken" "hдrsket" ;
  haersklysten_av_1 = mkA "hдrsklysten" "hдrsklystet" ;
  haerskri_nn_1 = mkN "hдrskri" "hдrskrit" "hдrskrin" "hдrskrien" ;
  haerstaedes_ab_1 = mkAdv "hдrstдdes" ;
  haerstamning_nn_1 = mkN "hдrstamning" ;
  haertagen_av_1 = mkA "hдrtagen" "hдrtaget" ;
  haertill_ab_1 = mkAdv "hдrtill" ;
  haeruppe_ab_1 = mkAdv "hдruppe" ;
  haerutinnan_ab_1 = mkAdv "hдrutinnan" ;
  haerutoever_ab_1 = mkAdv "hдrutцver" ;
  haervel_nn_1 = mkN "hдrvel" ;
  haervid_ab_1 = mkAdv "hдrvid" ;
  haervidlag_ab_1 = mkAdv "hдrvidlag" ;
  haessja_nn_1 = mkN "hдssja" ;
  haest_nn_1 = mkN "hдst" ;
  haestben_nn_1 = mkN "hдstben" neutrum ;
  haestdjur_nn_1 = mkN "hдstdjur" neutrum ;
  haestdragen_av_1 = mkA "hдstdragen" "hдstdraget" ;
  haestdressyr_nn_1 = mkN "hдstdressyr" "hдstdressyrer" ;
  haesthov_nn_1 = mkN "hдsthov" ;
  haesthovsoert_nn_1 = mkN "hдsthovsцrt" "hдsthovsцrter" ;
  haesthuvud_nn_1 = mkN "hдsthuvud" "hдsthuvudet" "hдsthuvuden" "hдsthuvudena" ;
  haestkapploepning_nn_1 = mkN "hдstkapplцpning" ;
  haestkastanj_nn_1 = mkN "hдstkastanj" "hдstkastanjer" ;
  haestkraft_nn_1 = mkN "hдstkraft" "hдstkrafter" ;
  haestkrake_nn_1 = mkN "hдstkrake" utrum ;
  haestkur_nn_1 = mkN "hдstkur" "hдstkurer" ;
  haestlaengd_nn_1 = mkN "hдstlдngd" "hдstlдngder" ;
  haestlass_nn_1 = mkN "hдstlass" neutrum ;
  haestliknande_av_1 = mkA "hдstliknande" ;
  haestrygg_nn_1 = mkN "hдstrygg" ;
  haestskjuts_nn_1 = mkN "hдstskjuts" ;
  haestsko_nn_1 = mkN "hдstsko" "hдstskor" ;
  haestskobaage_nn_1 = mkN "hдstskobеge" utrum ;
  haestskojare_nn_1 = mkN "hдstskojare" "hдstskojare" ;
  haestskomagnet_nn_1 = mkN "hдstskomagnet" "hдstskomagneter" ;
  haestskosoem_nn_1 = mkN "hдstskosцm" "hдstskosцmmet" "hдstskosцm" "hдstskosцmmen" ;
  haestspann_nn_1 = mkN "hдstspann" neutrum ;
  haeststyng_nn_1 = mkN "hдststyng" neutrum ;
  haestsvans_nn_1 = mkN "hдstsvans" ;
  haestvagn_nn_1 = mkN "hдstvagn" ;
  haetsk_av_1 = mkA "hдtsk" ;
  haetskhet_nn_1 = mkN "hдtskhet" "hдtskheter" ;
  haevarm_nn_1 = mkN "hдvarm" ;
  haevd_nn_1 = mkN "hдvd" "hдvder" ;
  haevdatecknare_nn_1 = mkN "hдvdatecknare" "hдvdatecknare" ;
  haevdvunnen_av_1 = mkA "hдvdvunnen" "hдvdvunnet" "hдvdvunna" "hдvdvunna" "hдvdvunnare" "hдvdvunnast" "hдvdvunnaste" ;
  haevel_nn_1 = mkN "hдvel" ;
  haevert_nn_1 = mkN "hдvert" ;
  haevstaang_nn_1 = mkN "hдvstеng" "hдvstдnger" ;
  haevstaangsarm_nn_1 = mkN "hдvstеngsarm" ;
  haexdans_nn_1 = mkN "hдxdans" "hдxdanser" ;
  haexeri_nn_1 = mkN "hдxeri" "hдxerit" "hдxerier" "hдxerierna" ;
  haexjakt_nn_1 = mkN "hдxjakt" "hдxjakter" ;
  haexkittel_nn_1 = mkN "hдxkittel" ;
  haexmaestare_nn_1 = mkN "hдxmдstare" "hдxmдstare" ;
  haexprocess_nn_1 = mkN "hдxprocess" "hдxprocesser" ;
  haexsabbat_nn_1 = mkN "hдxsabbat" "hдxsabbater" ;
  hafsig_av_1 = mkA "hafsig" ;
  hafsverk_nn_1 = mkN "hafsverk" neutrum ;
  hagalen_av_1 = mkA "hagalen" "hagalet" ;
  hage_nn_1 = mkN "hage" utrum ;
  hagel_nn_1 = mkN "hagel" neutrum ;
  hagelgevaer_nn_1 = mkN "hagelgevдr" neutrum ;
  hagelkorn_nn_1 = mkN "hagelkorn" neutrum ;
  hagmark_nn_1 = mkN "hagmark" "hagmarker" ;
  hagtorn_nn_1 = mkN "hagtorn" ;
  haiku_nn_1 = mkN "haiku" "haikun" "haikuer" "haikuerna" ;
  haitier_nn_1 = mkN "haitier" "haitiern" "haitier" "haitierna" ;
  haitisk_av_1 = mkA "haitisk" ;
  haj_av_1 = mkA "haj" ;
  haj_nn_1 = mkN "haj" ;
  hajk_nn_1 = mkN "hajk" ;
  hak_nn_1 = mkN "hak" neutrum ;
  hake_nn_1 = mkN "hake" utrum ;
  hakkors_nn_1 = mkN "hakkors" neutrum ;
  haklapp_nn_1 = mkN "haklapp" ;
  hakning_nn_1 = mkN "hakning" ;
  hakparentes_nn_1 = mkN "hakparentes" "hakparenteser" ;
  hal_av_1 = mkA "hal" ;
  halgatt_nn_1 = mkN "halgatt" neutrum ;
  halkfri_av_1 = mkA "halkfri" "halkfritt" ;
  halkig_av_1 = mkA "halkig" ;
  halkskydd_nn_1 = mkN "halkskydd" neutrum ;
  hall_nn_1 = mkN "hall" ;
  hallaaman_nn_1 = mkN "hallеman" "hallеmannen" "hallеmдn" "hallеmдnnen" ;
  hallaendsk_av_1 = mkA "hallдndsk" ;
  hallaendska_nn_2 = mkN "hallдndska" ;
  hallaenning_nn_1 = mkN "hallдnning" ;
  hallelujamoete_nn_1 = mkN "hallelujamцte" ;
  hallick_nn_1 = mkN "hallick" ;
  halling_nn_1 = mkN "halling" ;
  hallkyrka_nn_1 = mkN "hallkyrka" ;
  hallon_nn_1 = mkN "hallon" neutrum ;
  hallonbuske_nn_1 = mkN "hallonbuske" utrum ;
  hallonmask_nn_1 = mkN "hallonmask" ;
  hallonsaft_nn_1 = mkN "hallonsaft" "hallonsafter" ;
  hallstaempel_nn_1 = mkN "hallstдmpel" ;
  hallucination_nn_1 = mkN "hallucination" "hallucinationer" ;
  hallucinatorisk_av_1 = mkA "hallucinatorisk" ;
  hallucinogen_av_1 = mkA "hallucinogen" ;
  hallucinogen_nn_1 = mkN "hallucinogen" "hallucinogener" ;
  halmhatt_nn_1 = mkN "halmhatt" ;
  halmskakare_nn_1 = mkN "halmskakare" "halmskakare" ;
  halmstack_nn_1 = mkN "halmstack" ;
  halmstraa_nn_1 = mkN "halmstrе" "halmstrеet" "halmstrеn" "halmstrеna" ;
  halo_nn_1 = mkN "halo" "halor" ;
  haloeffekt_nn_1 = mkN "haloeffekt" "haloeffekter" ;
  halofenomen_nn_1 = mkN "halofenomen" neutrum ;
  halogen_nn_1 = mkN "halogen" "halogener" ;
  hals_nn_1 = mkN "hals" ;
  halsband_nn_1 = mkN "halsband" neutrum ;
  halsbloss_nn_1 = mkN "halsbloss" neutrum ;
  halsboeld_nn_1 = mkN "halsbцld" "halsbцlder" ;
  halsbrytande_av_1 = mkA "halsbrytande" ;
  halsduk_nn_1 = mkN "halsduk" ;
  halsfluss_nn_1 = mkN "halsfluss" "halsflusser" ;
  halsgrop_nn_1 = mkN "halsgrop" ;
  halshugga_vb_1 = mkV "halshugga" "halshцgg" "halshuggit" ;
  halskatarr_nn_1 = mkN "halskatarr" "halskatarrer" ;
  halskraas_nn_1 = mkN "halskrеs" neutrum ;
  halsmandel_nn_1 = mkN "halsmandel" ;
  halsring_nn_1 = mkN "halsring" ;
  halsstarrig_av_1 = mkA "halsstarrig" ;
  halstablett_nn_1 = mkN "halstablett" "halstabletter" ;
  halster_nn_1 = mkN "halster" neutrum ;
  halt_av_1 = mkA "halt" "halt" ;
  halt_nn_1 = mkN "halt" "halter" ;
  halv_av_1 = mkA "halv" ;
  halvaar_nn_1 = mkN "halvеr" neutrum ;
  halvaedelsten_nn_1 = mkN "halvдdelsten" "halvдdelstenen" "halvдdelstenar" "halvдdelstenarna" ;
  halvankare_nn_1 = mkN "halvankare" "halvankare" ;
  halvautomatisk_av_1 = mkA "halvautomatisk" ;
  halvback_nn_1 = mkN "halvback" ;
  halvbild_nn_1 = mkN "halvbild" "halvbilder" ;
  halvblod_nn_1 = mkN "halvblod" neutrum ;
  halvbroder_nn_1 = mkN "halvbroder" "halvbrodern" "halvbrцder" "halvbrцderna" ;
  halvbuske_nn_1 = mkN "halvbuske" utrum ;
  halvbutelj_nn_1 = mkN "halvbutelj" "halvbuteljer" ;
  halvcirkel_nn_1 = mkN "halvcirkel" ;
  halvdaeck_nn_1 = mkN "halvdдck" neutrum ;
  halvdaeckare_nn_1 = mkN "halvdдckare" "halvdдckare" ;
  halvdaglig_av_1 = mkA "halvdaglig" ;
  halvdan_av_1 = mkA "halvdan" ;
  halvdoed_av_1 = mkA "halvdцd" ;
  halvdunkel_av_1 = mkA "halvdunkel" "halvdunkelt" "halvdunkla" "halvdunkla" "halvdunklare" "halvdunklast" "halvdunklaste" ;
  halvdussin_nn_1 = mkN "halvdussin" neutrum ;
  halvenskild_av_1 = mkA "halvenskild" "halvenskilt" ;
  halvfabrikat_nn_1 = mkN "halvfabrikat" neutrum ;
  halvfaerdig_av_1 = mkA "halvfдrdig" ;
  halvfet_av_1 = mkA "halvfet" ;
  halvfigur_nn_1 = mkN "halvfigur" "halvfigurer" ;
  halvflytande_av_1 = mkA "halvflytande" ;
  halvfransk_av_1 = mkA "halvfransk" ;
  halvfylld_av_1 = mkA "halvfylld" "halvfyllt" ;
  halvgaangen_av_1 = mkA "halvgеngen" "halvgеnget" ;
  halvgenomskinlig_av_1 = mkA "halvgenomskinlig" ;
  halvgraes_nn_1 = mkN "halvgrдs" neutrum ;
  halvgud_nn_1 = mkN "halvgud" ;
  halvhet_nn_1 = mkN "halvhet" "halvheter" ;
  halvklar_av_1 = mkA "halvklar" ;
  halvklass_nn_1 = mkN "halvklass" "halvklasser" ;
  halvklot_nn_1 = mkN "halvklot" neutrum ;
  halvknop_nn_1 = mkN "halvknop" ;
  halvkolonn_nn_1 = mkN "halvkolonn" "halvkolonner" ;
  halvkonserv_nn_1 = mkN "halvkonserv" "halvkonserver" ;
  halvkvaeden_av_1 = mkA "halvkvдden" "halvkvдdet" ;
  halvkvaevd_av_1 = mkA "halvkvдvd" "halvkvдvt" ;
  halvledardiod_nn_1 = mkN "halvledardiod" "halvledardioder" ;
  halvledare_nn_1 = mkN "halvledare" "halvledare" ;
  halvlek_nn_1 = mkN "halvlek" ;
  halvliter_nn_1 = mkN "halvliter" "halvlitern" "halvliter" "halvliterna" ;
  halvljus_nn_1 = mkN "halvljus" neutrum ;
  halvmaane_nn_1 = mkN "halvmеne" utrum ;
  halvmesyr_nn_1 = mkN "halvmesyr" "halvmesyrer" ;
  halvmetall_nn_1 = mkN "halvmetall" "halvmetaller" ;
  halvmetallisk_av_1 = mkA "halvmetallisk" ;
  halvmeter_nn_1 = mkN "halvmeter" ;
  halvmeterbred_av_1 = mkA "halvmeterbred" ;
  halvmil_nn_1 = mkN "halvmil" "halvmilen" "halvmil" "halvmilen" ;
  halvmodern_av_1 = mkA "halvmodern" ;
  halvnaken_av_1 = mkA "halvnaken" "halvnaket" ;
  halvnot_nn_1 = mkN "halvnot" "halvnoter" ;
  halvoe_nn_1 = mkN "halvц" ;
  halvoeppen_av_1 = mkA "halvцppen" "halvцppet" ;
  halvofficiell_av_1 = mkA "halvofficiell" ;
  halvpart_nn_1 = mkN "halvpart" "halvparter" ;
  halvprofil_nn_1 = mkN "halvprofil" "halvprofiler" ;
  halvrim_nn_1 = mkN "halvrim" "halvrimmet" "halvrim" "halvrimmen" ;
  halvsanning_nn_1 = mkN "halvsanning" ;
  halvsekel_nn_1 = mkN "halvsekel" neutrum ;
  halvslag_nn_1 = mkN "halvslag" neutrum ;
  halvsluten_av_1 = mkA "halvsluten" "halvslutet" ;
  halvsmaelt_av_1 = mkA "halvsmдlt" "halvsmдlt" ;
  halvspraakig_av_1 = mkA "halvsprеkig" ;
  halvstatlig_av_1 = mkA "halvstatlig" ;
  halvstop_nn_1 = mkN "halvstop" neutrum ;
  halvsur_av_1 = mkA "halvsur" ;
  halvsyskon_nn_1 = mkN "halvsyskon" neutrum ;
  halvsyster_nn_1 = mkN "halvsyster" ;
  halvtid_nn_1 = mkN "halvtid" "halvtider" ;
  halvtimme_nn_1 = mkN "halvtimme" utrum ;
  halvton_nn_1 = mkN "halvton" "halvtoner" ;
  halvtorr_av_1 = mkA "halvtorr" ;
  halvtum_nn_1 = mkN "halvtum" "halvtummen" "halvtum" "halvtummen" ;
  halvvaegs_ab_1 = mkAdv "halvvдgs" ;
  halvvaerld_nn_1 = mkN "halvvдrld" ;
  halvvokal_nn_1 = mkN "halvvokal" "halvvokaler" ;
  halvvuxen_av_1 = mkA "halvvuxen" "halvvuxet" ;
  hambo_nn_1 = mkN "hambo" "hambor" ;
  hamburgare_nn_1 = mkN "hamburgare" "hamburgare" ;
  hamburgerbar_nn_1 = mkN "hamburgerbar" "hamburgerbarer" ;
  hamit_nn_1 = mkN "hamit" "hamiter" ;
  hamitisk_av_1 = mkA "hamitisk" ;
  hammarband_nn_1 = mkN "hammarband" neutrum ;
  hammare_nn_1 = mkN "hammare" "hammaren" "hamrar" "hamrarna" ;
  hammarhaj_nn_1 = mkN "hammarhaj" ;
  hammarslag_nn_1 = mkN "hammarslag" neutrum ;
  hammel_nn_1 = mkN "hammel" "hammeln" "hammlar" "hammlarna" ;
  hammelsadel_nn_1 = mkN "hammelsadel" ;
  hammerless_nn_1 = mkN "hammerless" "hammerlessen" "hammerless" "hammerlessen" ;
  hammock_nn_1 = mkN "hammock" ;
  hammondorgel_nn_1 = mkN "hammondorgel" ;
  hamn_nn_1 = mkN "hamn" ;
  hamnarbetare_nn_1 = mkN "hamnarbetare" "hamnarbetare" ;
  hamnbassaeng_nn_1 = mkN "hamnbassдng" "hamnbassдnger" ;
  hamndirektion_nn_1 = mkN "hamndirektion" "hamndirektioner" ;
  hamnfoerhaallande_nn_1 = mkN "hamnfцrhеllande" ;
  hamnkapten_nn_1 = mkN "hamnkapten" "hamnkaptener" ;
  hamnkontor_nn_1 = mkN "hamnkontor" neutrum ;
  hamnkvarter_nn_1 = mkN "hamnkvarter" "hamnkvarteret" "hamnkvarter" "hamnkvarteren" ;
  hamnstad_nn_1 = mkN "hamnstad" "hamnstдder" ;
  hamnstyrelse_nn_1 = mkN "hamnstyrelse" "hamnstyrelser" ;
  hampfroe_nn_1 = mkN "hampfrц" "hampfrцt" "hampfrцn" "hampfrцen" ;
  hamster_nn_1 = mkN "hamster" ;
  hanbjaelke_nn_1 = mkN "hanbjдlke" utrum ;
  hand_nn_1 = mkN "hand" "hдnder" ;
  handalfabet_nn_1 = mkN "handalfabet" neutrum ;
  handbagage_nn_1 = mkN "handbagage" "handbagaget" "handbagage" "handbagagen" ;
  handbok_nn_1 = mkN "handbok" "handbцcker" ;
  handboll_nn_1 = mkN "handboll" ;
  handbrev_nn_1 = mkN "handbrev" neutrum ;
  handbroms_nn_1 = mkN "handbroms" ;
  handduk_nn_1 = mkN "handduk" ;
  handeldvapen_nn_1 = mkN "handeldvapen" "handeldvapnet" "handeldvapen" "handeldvapnen" ;
  handelsavtal_nn_1 = mkN "handelsavtal" "handelsavtalet" "handelsavtalen" "handelsavtalena" ;
  handelsbank_nn_1 = mkN "handelsbank" "handelsbanker" ;
  handelsbod_nn_1 = mkN "handelsbod" ;
  handelsbolag_nn_1 = mkN "handelsbolag" neutrum ;
  handelsdepartement_nn_1 = mkN "handelsdepartement" "handelsdepartementet" "handelsdepartementen" "handelsdepartementena" ;
  handelsfartyg_nn_1 = mkN "handelsfartyg" neutrum ;
  handelsfoeretag_nn_1 = mkN "handelsfцretag" neutrum ;
  handelshus_nn_1 = mkN "handelshus" neutrum ;
  handelskammare_nn_1 = mkN "handelskammare" "handelskammaren" "handelskamrar" "handelskamrarna" ;
  handelskoep_nn_1 = mkN "handelskцp" neutrum ;
  handelskompani_nn_1 = mkN "handelskompani" "handelskompanit" "handelskompanier" "handelskompanierna" ;
  handelsled_nn_1 = mkN "handelsled" "handelsleder" ;
  handelsman_nn_1 = mkN "handelsman" "handelsmannen" "handelsmдn" "handelsmдnnen" ;
  handelsminister_nn_1 = mkN "handelsminister" ;
  handelspolitisk_av_1 = mkA "handelspolitisk" ;
  handelsregister_nn_1 = mkN "handelsregister" neutrum ;
  handelsresande_nn_1 = mkN "handelsresande" "handelsresanden" "handelsresande" "handelsresandena" ;
  handelstraedgaard_nn_1 = mkN "handelstrдdgеrd" ;
  handelsutbyte_nn_1 = mkN "handelsutbyte" ;
  handfallen_av_1 = mkA "handfallen" "handfallet" ;
  handfallenhet_nn_1 = mkN "handfallenhet" "handfallenheter" ;
  handfast_av_1 = mkA "handfast" "handfast" ;
  handfat_nn_1 = mkN "handfat" neutrum ;
  handflikig_av_1 = mkA "handflikig" ;
  handfull_nn_1 = mkN "handfull" ;
  handgaangen_av_1 = mkA "handgеngen" "handgеnget" ;
  handgemaeng_nn_1 = mkN "handgemдng" neutrum ;
  handgjord_av_1 = mkA "handgjord" "handgjort" ;
  handgranat_nn_1 = mkN "handgranat" "handgranater" ;
  handgrepp_nn_1 = mkN "handgrepp" neutrum ;
  handgriplig_av_1 = mkA "handgriplig" ;
  handgripligen_ab_1 = mkAdv "handgripligen" ;
  handgriplighet_nn_1 = mkN "handgriplighet" "handgripligheter" ;
  handikapp_nn_1 = mkN "handikapp" neutrum ;
  handikappvaard_nn_1 = mkN "handikappvеrd" ;
  handjagare_nn_1 = mkN "handjagare" "handjagare" ;
  handjur_nn_1 = mkN "handjur" neutrum ;
  handkassa_nn_1 = mkN "handkassa" ;
  handklappning_nn_1 = mkN "handklappning" ;
  handklaver_nn_1 = mkN "handklaver" "handklaveret" "handklaver" "handklaveren" ;
  handklove_nn_1 = mkN "handklove" utrum ;
  handkyss_nn_1 = mkN "handkyss" ;
  handlaan_nn_1 = mkN "handlеn" neutrum ;
  handlaeggning_nn_1 = mkN "handlдggning" ;
  handlande_nn_1 = mkN "handlande" "handlanden" "handlande" "handlandena" ;
  handlare_nn_1 = mkN "handlare" "handlare" ;
  handled_nn_1 = mkN "handled" "handleder" ;
  handledare_nn_1 = mkN "handledare" "handledare" ;
  handledning_nn_1 = mkN "handledning" ;
  handling_nn_1 = mkN "handling" ;
  handlingsfrihet_nn_1 = mkN "handlingsfrihet" "handlingsfriheter" ;
  handlingskraftig_av_1 = mkA "handlingskraftig" ;
  handlingsmaenniska_nn_1 = mkN "handlingsmдnniska" ;
  handlingsprogram_nn_1 = mkN "handlingsprogram" "handlingsprogrammet" "handlingsprogram" "handlingsprogrammen" ;
  handlingsregel_nn_1 = mkN "handlingsregel" "handlingsregeln" "handlingsregler" "handlingsreglerna" ;
  handlingssaett_nn_1 = mkN "handlingssдtt" neutrum ;
  handloest_ab_1 = mkAdv "handlцst" ;
  handlov_nn_1 = mkN "handlov" ;
  handout_nn_1 = mkN "handout" "handouten" "handouts" "handoutsen" ;
  handpaalaeggning_nn_1 = mkN "handpеlдggning" ;
  handpenning_nn_1 = mkN "handpenning" ;
  handraeckning_nn_1 = mkN "handrдckning" ;
  handrem_nn_1 = mkN "handrem" "handremmen" "handremmar" "handremmarna" ;
  handsaag_nn_1 = mkN "handsеg" ;
  handsbredd_nn_1 = mkN "handsbredd" "handsbredder" ;
  handsekreterare_nn_1 = mkN "handsekreterare" "handsekreterare" ;
  handskakning_nn_1 = mkN "handskakning" ;
  handske_nn_1 = mkN "handske" utrum ;
  handskrift_nn_1 = mkN "handskrift" "handskrifter" ;
  handskriftsrulle_nn_1 = mkN "handskriftsrulle" utrum ;
  handskriftssamling_nn_1 = mkN "handskriftssamling" ;
  handskriven_av_1 = mkA "handskriven" "handskrivet" ;
  handslag_nn_1 = mkN "handslag" neutrum ;
  handstil_nn_1 = mkN "handstil" ;
  handtag_nn_1 = mkN "handtag" neutrum ;
  handtryckning_nn_1 = mkN "handtryckning" ;
  handuppraeckning_nn_1 = mkN "handupprдckning" ;
  handvolt_nn_1 = mkN "handvolt" "handvolter" ;
  hane_nn_1 = mkN "hane" utrum ;
  hanegaell_nn_1 = mkN "hanegдll" neutrum ;
  hang_nn_1 = mkN "hang" neutrum ;
  hangar_nn_1 = mkN "hangar" "hangarer" ;
  hangarfartyg_nn_1 = mkN "hangarfartyg" neutrum ;
  hank_nn_1 = mkN "hank" ;
  hanlig_av_1 = mkA "hanlig" ;
  hanne_nn_1 = mkN "hanne" utrum ;
  hanorgan_nn_1 = mkN "hanorgan" neutrum ;
  hanrej_nn_1 = mkN "hanrej" ;
  hantel_nn_1 = mkN "hantel" ;
  hantering_nn_1 = mkN "hantering" ;
  hanteringskostnad_nn_1 = mkN "hanteringskostnad" "hanteringskostnader" ;
  hanteringsrisk_nn_1 = mkN "hanteringsrisk" "hanteringsrisker" ;
  hanterlig_av_1 = mkA "hanterlig" ;
  hantlangare_nn_1 = mkN "hantlangare" "hantlangare" ;
  hantverk_nn_1 = mkN "hantverk" neutrum ;
  hantverkare_nn_1 = mkN "hantverkare" "hantverkare" ;
  hantverksarbetare_nn_1 = mkN "hantverksarbetare" "hantverksarbetare" ;
  hantverksfoerening_nn_1 = mkN "hantverksfцrening" ;
  hantverksmaessig_av_1 = mkA "hantverksmдssig" ;
  hantverksskicklighet_nn_1 = mkN "hantverksskicklighet" "hantverksskickligheter" ;
  happening_nn_1 = mkN "happening" ;
  haptoglobin_nn_1 = mkN "haptoglobin" "haptoglobiner" ;
  harang_nn_1 = mkN "harang" "haranger" ;
  hardangersoem_nn_1 = mkN "hardangersцm" "hardangersцmmen" "hardangersцmmar" "hardangersцmmarna" ;
  hare_nn_1 = mkN "hare" utrum ;
  harem_nn_1 = mkN "harem" neutrum ;
  harhanne_nn_1 = mkN "harhanne" utrum ;
  harig_av_1 = mkA "harig" ;
  harkling_nn_1 = mkN "harkling" ;
  harkrank_nn_1 = mkN "harkrank" ;
  harlekin_nn_1 = mkN "harlekin" "harlekiner" ;
  harmfull_av_1 = mkA "harmfull" ;
  harmfylld_av_1 = mkA "harmfylld" "harmfyllt" ;
  harmlig_av_1 = mkA "harmlig" ;
  harmloes_av_1 = mkA "harmlцs" ;
  harmoni_nn_1 = mkN "harmoni" "harmonier" ;
  harmonisk_av_1 = mkA "harmonisk" ;
  harmonium_nn_1 = mkN "harmonium" "harmoniet" "harmonier" "harmonierna" ;
  harmsen_av_1 = mkA "harmsen" "harmset" ;
  harmynt_av_1 = mkA "harmynt" "harmynt" ;
  harnesk_nn_1 = mkN "harnesk" neutrum ;
  harpalt_nn_1 = mkN "harpalt" ;
  harpist_nn_1 = mkN "harpist" "harpister" ;
  harpun_nn_1 = mkN "harpun" "harpuner" ;
  harr_nn_1 = mkN "harr" ;
  harskramla_nn_1 = mkN "harskramla" ;
  harspaar_nn_1 = mkN "harspеr" neutrum ;
  harstig_nn_1 = mkN "harstig" ;
  hartass_nn_1 = mkN "hartass" ;
  harts_nn_1 = mkN "harts" "hartset" "hartser" "hartserna" ;
  hartsfiol_nn_1 = mkN "hartsfiol" "hartsfioler" ;
  harv_nn_1 = mkN "harv" ;
  harvaerja_nn_1 = mkN "harvдrja" ;
  has_nn_1 = mkN "has" ;
  hasardspel_nn_1 = mkN "hasardspel" "hasardspelet" "hasardspel" "hasardspelen" ;
  haschcigarett_nn_1 = mkN "haschcigarett" "haschcigaretter" ;
  hasp_nn_1 = mkN "hasp" ;
  haspel_nn_1 = mkN "haspel" ;
  hassel_nn_1 = mkN "hassel" ;
  hasselmus_nn_1 = mkN "hasselmus" "hasselmusen" "hasselmцss" "hasselmцssen" ;
  hasselnoet_nn_1 = mkN "hasselnцt" "hasselnцtter" ;
  hasselsnok_nn_1 = mkN "hasselsnok" ;
  hastig_av_1 = mkA "hastig" ;
  hastighet_nn_1 = mkN "hastighet" "hastigheter" ;
  hastighetsaakning_nn_1 = mkN "hastighetsеkning" ;
  hastighetsgraens_nn_1 = mkN "hastighetsgrдns" "hastighetsgrдnser" ;
  hastighetskontroll_nn_1 = mkN "hastighetskontroll" "hastighetskontroller" ;
  hastighetsmaetare_nn_1 = mkN "hastighetsmдtare" "hastighetsmдtare" ;
  hastighetstaevling_nn_1 = mkN "hastighetstдvling" ;
  hastverk_nn_1 = mkN "hastverk" neutrum ;
  hatfull_av_1 = mkA "hatfull" ;
  hatfylld_av_1 = mkA "hatfylld" "hatfyllt" ;
  hatisk_av_1 = mkA "hatisk" ;
  hatkaerlek_nn_1 = mkN "hatkдrlek" ;
  hatt_nn_1 = mkN "hatt" ;
  hattig_av_1 = mkA "hattig" ;
  hattkulle_nn_1 = mkN "hattkulle" utrum ;
  hattstock_nn_1 = mkN "hattstock" ;
  hattsvamp_nn_1 = mkN "hattsvamp" ;
  haubits_nn_1 = mkN "haubits" ;
  haubitz_nn_1 = mkN "haubitz" ;
  hausse_nn_1 = mkN "hausse" "hausser" ;
  hav_nn_1 = mkN "hav" neutrum ;
  havande_av_1 = mkA "havande" ;
  havandeskap_nn_1 = mkN "havandeskap" "havandeskapet" "havandeskapen" "havandeskapena" ;
  haveri_nn_1 = mkN "haveri" "haverit" "haverier" "haverierna" ;
  haverikommission_nn_1 = mkN "haverikommission" "haverikommissioner" ;
  haverist_nn_1 = mkN "haverist" "haverister" ;
  havreflarn_nn_1 = mkN "havreflarn" neutrum ;
  havregryn_nn_1 = mkN "havregryn" neutrum ;
  havregrynsgroet_nn_1 = mkN "havregrynsgrцt" ;
  havrekorn_nn_1 = mkN "havrekorn" neutrum ;
  havreliknande_av_1 = mkA "havreliknande" ;
  havsabborre_nn_1 = mkN "havsabborre" utrum ;
  havsanemon_nn_1 = mkN "havsanemon" "havsanemoner" ;
  havsbad_nn_1 = mkN "havsbad" neutrum ;
  havsbotten_nn_1 = mkN "havsbotten" ;
  havsbris_nn_1 = mkN "havsbris" ;
  havsdjup_nn_1 = mkN "havsdjup" neutrum ;
  havsfaagel_nn_1 = mkN "havsfеgel" ;
  havsfru_nn_1 = mkN "havsfru" ;
  havsgud_nn_1 = mkN "havsgud" ;
  havsis_nn_1 = mkN "havsis" ;
  havskappsegling_nn_1 = mkN "havskappsegling" ;
  havskatt_nn_1 = mkN "havskatt" "havskatter" ;
  havskraeftstjaert_nn_1 = mkN "havskrдftstjдrt" ;
  havskryssare_nn_1 = mkN "havskryssare" "havskryssare" ;
  havslax_nn_1 = mkN "havslax" ;
  havsmus_nn_1 = mkN "havsmus" ;
  havsnivaa_nn_1 = mkN "havsnivе" "havsnivеer" ;
  havsoern_nn_1 = mkN "havsцrn" ;
  havsomraade_nn_1 = mkN "havsomrеde" ;
  havsstrand_nn_1 = mkN "havsstrand" "havsstrдnder" ;
  havsstroem_nn_1 = mkN "havsstrцm" "havsstrцmmen" "havsstrцmmar" "havsstrцmmarna" ;
  havstrut_nn_1 = mkN "havstrut" ;
  havstulpan_nn_1 = mkN "havstulpan" "havstulpaner" ;
  havsutter_nn_1 = mkN "havsutter" ;
  havsvaext_nn_1 = mkN "havsvдxt" "havsvдxter" ;
  havsvatten_nn_1 = mkN "havsvatten" "havsvattnet" "havsvatten" "havsvattnen" ;
  havsvik_nn_1 = mkN "havsvik" ;
  havtorn_nn_1 = mkN "havtorn" ;
  hawaiiansk_av_1 = mkA "hawaiiansk" ;
  hawaiisk_av_1 = mkA "hawaiisk" ;
  he_man_nn_1 = mkN "he-man" "he-mannen" "he-mдn" "he-mдnnen" ;
  hearing_nn_1 = mkN "hearing" ;
  heat_nn_1 = mkN "heat" neutrum ;
  hebre_nn_1 = mkN "hebrй" "hebrйer" ;
  hebreisk_av_1 = mkA "hebreisk" ;
  hed_nn_1 = mkN "hed" ;
  heden_av_1 = mkA "heden" "hedet" ;
  hedendom_nn_1 = mkN "hedendom" ;
  hederlig_av_1 = mkA "hederlig" ;
  hedersam_av_1 = mkA "hedersam" "hedersamt" "hedersamma" "hedersamma" "hedersammare" "hedersammast" "hedersammaste" ;
  hedersbetygelse_nn_1 = mkN "hedersbetygelse" "hedersbetygelser" ;
  hedersbevisning_nn_1 = mkN "hedersbevisning" ;
  hedersdoktor_nn_1 = mkN "hedersdoktor" "hedersdoktorer" ;
  hedersgaest_nn_1 = mkN "hedersgдst" "hedersgдster" ;
  hedersknyffel_nn_1 = mkN "hedersknyffel" ;
  hederskodex_nn_1 = mkN "hederskodex" ;
  hederskompani_nn_1 = mkN "hederskompani" "hederskompanit" "hederskompanier" "hederskompanierna" ;
  hedersledamot_nn_1 = mkN "hedersledamot" "hedersledamцter" ;
  hedersman_nn_1 = mkN "hedersman" "hedersmannen" "hedersmдn" "hedersmдnnen" ;
  hedersmedlem_nn_1 = mkN "hedersmedlem" "hedersmedlemmen" "hedersmedlemmar" "hedersmedlemmarna" ;
  hedersomnaemnande_nn_1 = mkN "hedersomnдmnande" ;
  hedersord_nn_1 = mkN "hedersord" neutrum ;
  hederspris_nn_1 = mkN "hederspris" neutrum ;
  hederssak_nn_1 = mkN "hederssak" "hederssaker" ;
  hedersskuld_nn_1 = mkN "hedersskuld" "hedersskulder" ;
  hedervaerd_av_1 = mkA "hedervдrd" "hedervдrt" ;
  hedning_nn_1 = mkN "hedning" ;
  hednisk_av_1 = mkA "hednisk" ;
  hedonist_nn_1 = mkN "hedonist" "hedonister" ;
  hedonistisk_av_1 = mkA "hedonistisk" ;
  hedrande_av_1 = mkA "hedrande" ;
  hegemoni_nn_1 = mkN "hegemoni" "hegemonier" ;
  hejaklack_nn_1 = mkN "hejaklack" ;
  hejare_nn_1 = mkN "hejare" "hejare" ;
  hejarklack_nn_1 = mkN "hejarklack" ;
  hejdloes_av_1 = mkA "hejdlцs" ;
  hejduk_nn_1 = mkN "hejduk" ;
  hejdundrande_av_1 = mkA "hejdundrande" ;
  hejig_av_1 = mkA "hejig" ;
  hekatomb_nn_1 = mkN "hekatomb" "hekatomber" ;
  hektar_nn_1 = mkN "hektar" neutrum ;
  hektisk_av_1 = mkA "hektisk" ;
  hekto_nn_1 = mkN "hekto" "hektot" "hekto" "hektona" ;
  hektograf_nn_1 = mkN "hektograf" "hektografer" ;
  hektogram_nn_1 = mkN "hektogram" "hektogrammet" "hektogram" "hektogrammen" ;
  hektoliter_nn_1 = mkN "hektoliter" "hektolitern" "hektoliter" "hektoliterna" ;
  hel_av_1 = mkA "hel" ;
  helaakersbygd_nn_1 = mkN "helеkersbygd" "helеkersbygder" ;
  helafton_nn_1 = mkN "helafton" "helaftonen" "helaftnar" "helaftnarna" ;
  helautomatisk_av_1 = mkA "helautomatisk" ;
  helbild_nn_1 = mkN "helbild" "helbilder" ;
  helbraegda_av_1 = mkA "helbrдgda" ;
  helbraegdagoerelse_nn_1 = mkN "helbrдgdagцrelse" "helbrдgdagцrelser" ;
  heldag_nn_1 = mkN "heldag" ;
  heldaglig_av_1 = mkA "heldaglig" ;
  heldragen_av_1 = mkA "heldragen" "heldraget" ;
  helfabrikat_nn_1 = mkN "helfabrikat" neutrum ;
  helfet_av_1 = mkA "helfet" ;
  helfigur_nn_1 = mkN "helfigur" "helfigurer" ;
  helfoersaekring_nn_1 = mkN "helfцrsдkring" ;
  helfransk_av_1 = mkA "helfransk" ;
  helg_nn_1 = mkN "helg" "helger" ;
  helgdag_nn_1 = mkN "helgdag" ;
  helgedom_nn_1 = mkN "helgedom" ;
  helgeraan_nn_1 = mkN "helgerеn" neutrum ;
  helgfri_av_1 = mkA "helgfri" "helgfritt" ;
  helgjuten_av_1 = mkA "helgjuten" "helgjutet" ;
  helgmaalsringning_nn_1 = mkN "helgmеlsringning" ;
  helgon_nn_1 = mkN "helgon" neutrum ;
  helgonlegend_nn_1 = mkN "helgonlegend" "helgonlegender" ;
  helhet_nn_1 = mkN "helhet" "helheter" ;
  helhetsbild_nn_1 = mkN "helhetsbild" "helhetsbilder" ;
  helhetsintryck_nn_1 = mkN "helhetsintryck" neutrum ;
  helhetssyn_nn_1 = mkN "helhetssyn" "helhetssyner" ;
  helig_av_1 = mkA "helig" ;
  helikon_nn_1 = mkN "helikon" neutrum ;
  helikopter_nn_1 = mkN "helikopter" ;
  helinackordering_nn_1 = mkN "helinackordering" ;
  heliocentrisk_av_1 = mkA "heliocentrisk" ;
  heliofob_av_1 = mkA "heliofob" ;
  heliograf_nn_1 = mkN "heliograf" "heliografer" ;
  heliostat_nn_1 = mkN "heliostat" "heliostater" ;
  heliotrop_nn_1 = mkN "heliotrop" "heliotroper" ;
  helkonserv_nn_1 = mkN "helkonserv" "helkonserver" ;
  helkroppsdos_nn_1 = mkN "helkroppsdos" "helkroppsdoser" ;
  helkvaell_nn_1 = mkN "helkvдll" ;
  hellen_nn_1 = mkN "hellen" "hellener" ;
  hellenistisk_av_1 = mkA "hellenistisk" ;
  hellensk_av_1 = mkA "hellensk" ;
  heller_ab_1 = mkAdv "heller" ;
  helljus_nn_1 = mkN "helljus" neutrum ;
  hellre_ab_1 = mkAdv "hellre" ;
  helnot_nn_1 = mkN "helnot" "helnoter" ;
  helnykter_av_1 = mkA "helnykter" "helnyktert" "helnyktra" "helnyktra" "helnyktrare" "helnyktrast" "helnyktraste" ;
  helomvaendning_nn_1 = mkN "helomvдndning" ;
  helsida_nn_1 = mkN "helsida" ;
  helskaegg_nn_1 = mkN "helskдgg" neutrum ;
  helskaeggsluffare_nn_1 = mkN "helskдggsluffare" "helskдggsluffare" ;
  helst_ab_1 = mkAdv "helst" ;
  helstekt_av_1 = mkA "helstekt" "helstekt" ;
  helsyskon_nn_1 = mkN "helsyskon" neutrum ;
  heltaeckande_av_1 = mkA "heltдckande" ;
  heltal_nn_1 = mkN "heltal" "heltalet" "heltalen" "heltalena" ;
  heltid_nn_1 = mkN "heltid" "heltider" ;
  heltidsloen_nn_1 = mkN "heltidslцn" "heltidslцner" ;
  helton_nn_1 = mkN "helton" "heltoner" ;
  helvete_nn_1 = mkN "helvete" ;
  helvetesmaskin_nn_1 = mkN "helvetesmaskin" "helvetesmaskiner" ;
  helvetisk_av_1 = mkA "helvetisk" ;
  hem_ab_1 = mkAdv "hem" ;
  hem_nn_1 = mkN "hem" "hemmet" "hem" "hemmen" ;
  hemaat_ab_1 = mkAdv "hemеt" ;
  hemarbetande_av_1 = mkA "hemarbetande" ;
  hematit_nn_1 = mkN "hematit" "hematiter" ;
  hembaera_vb_1 = mkV "hembдra" "hembar" "hemburit" ;
  hembageri_nn_1 = mkN "hembageri" "hembagerit" "hembagerier" "hembagerierna" ;
  hembakt_av_1 = mkA "hembakt" "hembakt" ;
  hembesoek_nn_1 = mkN "hembesцk" neutrum ;
  hembitraede_nn_1 = mkN "hembitrдde" ;
  hembjuda_vb_1 = mkV "hembjuda" "hembjцd" "hembjudit" ;
  hembraennare_nn_1 = mkN "hembrдnnare" "hembrдnnare" ;
  hembud_nn_1 = mkN "hembud" neutrum ;
  hembygd_nn_1 = mkN "hembygd" "hembygder" ;
  hembygdsfoerening_nn_1 = mkN "hembygdsfцrening" ;
  hembygdsgaard_nn_1 = mkN "hembygdsgеrd" ;
  hemdator_nn_1 = mkN "hemdator" "hemdatorer" ;
  hemdragande_av_1 = mkA "hemdragande" ;
  hemfalla_vb_1 = mkV "hemfalla" "hemfцll" "hemfallit" ;
  hemfoersaekring_nn_1 = mkN "hemfцrsдkring" ;
  hemfridsbrott_nn_1 = mkN "hemfridsbrott" neutrum ;
  hemgaang_nn_1 = mkN "hemgеng" ;
  hemgalax_nn_1 = mkN "hemgalax" "hemgalaxer" ;
  hemgift_nn_1 = mkN "hemgift" "hemgifter" ;
  hemgjord_av_1 = mkA "hemgjord" "hemgjort" ;
  hemhjaelp_nn_1 = mkN "hemhjдlp" ;
  hemifraan_ab_1 = mkAdv "hemifrеn" ;
  heminredning_nn_1 = mkN "heminredning" ;
  hemisfaer_nn_1 = mkN "hemisfдr" "hemisfдrer" ;
  hemkaer_av_1 = mkA "hemkдr" ;
  hemkonsulent_nn_1 = mkN "hemkonsulent" "hemkonsulenter" ;
  hemlaan_nn_1 = mkN "hemlеn" neutrum ;
  hemland_nn_1 = mkN "hemland" "hemlandet" "hemlдnder" "hemlдnderna" ;
  hemlig_av_1 = mkA "hemlig" ;
  hemligen_ab_1 = mkAdv "hemligen" ;
  hemlighaalla_vb_1 = mkV "hemlighеlla" "hemlighцll" "hemlighеllit" ;
  hemlighet_nn_1 = mkN "hemlighet" "hemligheter" ;
  hemlighetsfull_av_1 = mkA "hemlighetsfull" ;
  hemlighetsmakeri_nn_1 = mkN "hemlighetsmakeri" "hemlighetsmakerit" "hemlighetsmakerier" "hemlighetsmakerierna" ;
  hemlighus_nn_1 = mkN "hemlighus" neutrum ;
  hemligstaempel_nn_1 = mkN "hemligstдmpel" ;
  hemlock_nn_1 = mkN "hemlock" ;
  hemloes_av_1 = mkA "hemlцs" ;
  hemma_ab_1 = mkAdv "hemma" ;
  hemmadotter_nn_1 = mkN "hemmadotter" "hemmadottern" "hemmadцttrar" "hemmadцttrarna" ;
  hemmafru_nn_1 = mkN "hemmafru" ;
  hemmagjord_av_1 = mkA "hemmagjord" "hemmagjort" ;
  hemmahoerande_av_1 = mkA "hemmahцrande" ;
  hemmakvaell_nn_1 = mkN "hemmakvдll" ;
  hemmalag_nn_1 = mkN "hemmalag" neutrum ;
  hemmaman_nn_1 = mkN "hemmaman" "hemmamannen" "hemmamдn" "hemmamдnnen" ;
  hemman_nn_1 = mkN "hemman" neutrum ;
  hemmansaegare_nn_1 = mkN "hemmansдgare" "hemmansдgare" ;
  hemmaplan_nn_1 = mkN "hemmaplan" "hemmaplaner" ;
  hemmarock_nn_1 = mkN "hemmarock" ;
  hemmastadd_av_1 = mkA "hemmastadd" ;
  hemmavid_ab_1 = mkAdv "hemmavid" ;
  hemmiljoe_nn_1 = mkN "hemmiljц" "hemmiljцn" "hemmiljцer" "hemmiljцerna" ;
  hemoglobin_nn_1 = mkN "hemoglobin" "hemoglobiner" ;
  hemort_nn_1 = mkN "hemort" "hemorter" ;
  hemsamarit_nn_1 = mkN "hemsamarit" "hemsamariter" ;
  hemsjukvaardsbidrag_nn_1 = mkN "hemsjukvеrdsbidrag" neutrum ;
  hemsk_av_1 = mkA "hemsk" ;
  hemskillnad_nn_1 = mkN "hemskillnad" "hemskillnader" ;
  hemsoekelse_nn_1 = mkN "hemsцkelse" "hemsцkelser" ;
  hemspraak_nn_1 = mkN "hemsprеk" neutrum ;
  hemstad_nn_1 = mkN "hemstad" "hemstдder" ;
  hemstaellning_nn_1 = mkN "hemstдllning" ;
  hemtam_av_1 = mkA "hemtam" ;
  hemtjaenst_nn_1 = mkN "hemtjдnst" "hemtjдnster" ;
  hemtrakt_nn_1 = mkN "hemtrakt" "hemtrakter" ;
  hemtrevlig_av_1 = mkA "hemtrevlig" ;
  hemtrevnad_nn_1 = mkN "hemtrevnad" "hemtrevnader" ;
  hemulsman_nn_1 = mkN "hemulsman" "hemulsmannen" "hemulsmдn" "hemulsmдnnen" ;
  hemuppgift_nn_1 = mkN "hemuppgift" "hemuppgifter" ;
  hemvaern_nn_1 = mkN "hemvдrn" neutrum ;
  hemvaevd_av_1 = mkA "hemvдvd" "hemvдvt" ;
  hemvist_nn_1 = mkN "hemvist" neutrum ;
  hen_nn_1 = mkN "hen" "henen" "henar" "henarna" ;
  henry_nn_1 = mkN "henry" "henryn" "henry" "henryna" ;
  heparin_nn_1 = mkN "heparin" "hepariner" ;
  hepatit_nn_1 = mkN "hepatit" "hepatiter" ;
  heraldiker_nn_1 = mkN "heraldiker" "heraldikern" "heraldiker" "heraldikerna" ;
  heraldisk_av_1 = mkA "heraldisk" ;
  herbarium_nn_1 = mkN "herbarium" "herbariet" "herbarier" "herbarierna" ;
  herbicid_nn_1 = mkN "herbicid" "herbicider" ;
  herdabrev_nn_1 = mkN "herdabrev" neutrum ;
  herdaminne_nn_1 = mkN "herdaminne" ;
  herde_nn_1 = mkN "herde" utrum ;
  herdedikt_nn_1 = mkN "herdedikt" "herdedikter" ;
  herdefolk_nn_1 = mkN "herdefolk" neutrum ;
  herdestund_nn_1 = mkN "herdestund" "herdestunder" ;
  hereditaer_av_1 = mkA "hereditдr" ;
  heresi_nn_1 = mkN "heresi" "heresier" ;
  heretiker_nn_1 = mkN "heretiker" "heretikern" "heretiker" "heretikerna" ;
  heretisk_av_1 = mkA "heretisk" ;
  herkulisk_av_1 = mkA "herkulisk" ;
  herm_nn_1 = mkN "herm" "hermer" ;
  hermafrodit_nn_1 = mkN "hermafrodit" "hermafroditer" ;
  hermelin_nn_1 = mkN "hermelin" "hermeliner" ;
  hermeneutiker_nn_1 = mkN "hermeneutiker" "hermeneutikern" "hermeneutiker" "hermeneutikerna" ;
  hermeneutisk_av_1 = mkA "hermeneutisk" ;
  hermetisk_av_1 = mkA "hermetisk" ;
  heroin_nn_1 = mkN "heroin" "heroiner" ;
  heroinist_nn_1 = mkN "heroinist" "heroinister" ;
  heroisk_av_1 = mkA "heroisk" ;
  heros_nn_1 = mkN "heros" "heroser" ;
  herostratisk_av_1 = mkA "herostratisk" ;
  herradoeme_nn_1 = mkN "herradцme" ;
  herrcykel_nn_1 = mkN "herrcykel" ;
  herrdubbel_nn_1 = mkN "herrdubbel" ;
  herre_nn_1 = mkN "herre" utrum ;
  herrefolk_nn_1 = mkN "herrefolk" neutrum ;
  herrekipering_nn_1 = mkN "herrekipering" ;
  herreloes_av_1 = mkA "herrelцs" ;
  herresaete_nn_1 = mkN "herresдte" ;
  herrgaard_nn_1 = mkN "herrgеrd" ;
  herrgaardsost_nn_1 = mkN "herrgеrdsost" ;
  herrgaardsvagn_nn_1 = mkN "herrgеrdsvagn" ;
  herrnhutare_nn_1 = mkN "herrnhutare" "herrnhutare" ;
  herrsida_nn_1 = mkN "herrsida" ;
  herrsingel_nn_1 = mkN "herrsingel" ;
  herrskap_nn_1 = mkN "herrskap" "herrskapet" "herrskapen" "herrskapena" ;
  herrtidning_nn_1 = mkN "herrtidning" ;
  hertig_nn_1 = mkN "hertig" ;
  hertigdoeme_nn_1 = mkN "hertigdцme" ;
  hertiginna_nn_1 = mkN "hertiginna" ;
  hertz_nn_1 = mkN "hertz" "hertzen" "hertz" "hertzen" ;
  hes_av_1 = mkA "hes" ;
  heshet_nn_1 = mkN "heshet" "hesheter" ;
  het_av_1 = mkA "het" ;
  hetaer_nn_1 = mkN "hetдr" "hetдrer" ;
  heterodox_av_1 = mkA "heterodox" ;
  heterogen_av_1 = mkA "heterogen" ;
  heteroklis_nn_1 = mkN "heteroklis" "heterokliser" ;
  heteroklitisk_av_1 = mkA "heteroklitisk" ;
  heterosexuell_av_1 = mkA "heterosexuell" ;
  heterotematisk_av_1 = mkA "heterotematisk" ;
  heterozygot_av_1 = mkA "heterozygot" "heterozygot" ;
  heterozygot_nn_1 = mkN "heterozygot" "heterozygoter" ;
  hetman_nn_1 = mkN "hetman" "hetmaner" ;
  hetsig_av_1 = mkA "hetsig" ;
  hetsjakt_nn_1 = mkN "hetsjakt" "hetsjakter" ;
  hetsporre_nn_1 = mkN "hetsporre" utrum ;
  hettit_nn_1 = mkN "hettit" "hettiter" ;
  hettitisk_av_1 = mkA "hettitisk" ;
  hetvatten_nn_1 = mkN "hetvatten" "hetvattnet" "hetvatten" "hetvattnen" ;
  hetvin_nn_1 = mkN "hetvin" "hetvinet" "hetviner" "hetvinerna" ;
  heuristisk_av_1 = mkA "heuristisk" ;
  hexameter_nn_1 = mkN "hexameter" ;
  hibiskus_nn_1 = mkN "hibiskus" ;
  hickning_nn_1 = mkN "hickning" ;
  hierarki_nn_1 = mkN "hierarki" "hierarkier" ;
  hierarkisk_av_1 = mkA "hierarkisk" ;
  hieratisk_av_1 = mkA "hieratisk" ;
  hieroglyf_nn_1 = mkN "hieroglyf" "hieroglyfer" ;
  higgspartikel_nn_1 = mkN "higgspartikel" ;
  hillebard_nn_1 = mkN "hillebard" "hillebarder" ;
  himla_av_1 = mkA "himla" ;
  himlaboren_av_1 = mkA "himlaboren" "himlaboret" ;
  himlakropp_nn_1 = mkN "himlakropp" ;
  himlastege_nn_1 = mkN "himlastege" utrum ;
  himlastormande_av_1 = mkA "himlastormande" ;
  himlastormare_nn_1 = mkN "himlastormare" "himlastormare" ;
  himmel_nn_1 = mkN "himmel" ;
  himmelsblaa_av_1 = mkA "himmelsblе" "himmelsblеtt" ;
  himmelsfaerd_nn_1 = mkN "himmelsfдrd" "himmelsfдrder" ;
  himmelsk_av_1 = mkA "himmelsk" ;
  himmelsobjekt_nn_1 = mkN "himmelsobjekt" neutrum ;
  himmelspol_nn_1 = mkN "himmelspol" "himmelspoler" ;
  himmelssaeng_nn_1 = mkN "himmelssдng" ;
  himmelssfaer_nn_1 = mkN "himmelssfдr" "himmelssfдrer" ;
  himmelsskriande_av_1 = mkA "himmelsskriande" ;
  himmelsvid_av_1 = mkA "himmelsvid" ;
  hind_nn_1 = mkN "hind" ;
  hinder_nn_1 = mkN "hinder" neutrum ;
  hinderbock_nn_1 = mkN "hinderbock" ;
  hinderloepning_nn_1 = mkN "hinderlцpning" ;
  hinderloes_av_1 = mkA "hinderlцs" ;
  hindersam_av_1 = mkA "hindersam" "hindersamt" "hindersamma" "hindersamma" "hindersammare" "hindersammast" "hindersammaste" ;
  hindersproevning_nn_1 = mkN "hindersprцvning" ;
  hindertrick_nn_1 = mkN "hindertrick" neutrum ;
  hindu_nn_1 = mkN "hindu" "hinduer" ;
  hinduisk_av_1 = mkA "hinduisk" ;
  hingst_nn_1 = mkN "hingst" ;
  hink_nn_1 = mkN "hink" ;
  hinkvis_ab_1 = mkAdv "hinkvis" ;
  hinna_vb_1 = mkV "hinna" "hann" "hunnit" ;
  hipp_av_1 = mkA "hipp" ;
  hippie_nn_1 = mkN "hippie" "hippien" "hippies" "hippiesen" ;
  hippodrom_nn_1 = mkN "hippodrom" "hippodromer" ;
  hippolog_nn_1 = mkN "hippolog" "hippologer" ;
  hippologisk_av_1 = mkA "hippologisk" ;
  hird_nn_1 = mkN "hird" "hirder" ;
  hisklig_av_1 = mkA "hisklig" ;
  hispig_av_1 = mkA "hispig" ;
  hiss_nn_1 = mkN "hiss" ;
  hissinstallation_nn_1 = mkN "hissinstallation" "hissinstallationer" ;
  hisskorg_nn_1 = mkN "hisskorg" ;
  histamin_nn_1 = mkN "histamin" "histaminet" "histaminer" "histaminerna" ;
  histolog_nn_1 = mkN "histolog" "histologer" ;
  historia_nn_1 = mkN "historia" "historien" "historier" "historierna" ;
  historiebok_nn_1 = mkN "historiebok" "historiebцcker" ;
  historieloes_av_1 = mkA "historielцs" ;
  historieskrivare_nn_1 = mkN "historieskrivare" "historieskrivare" ;
  historiett_nn_1 = mkN "historiett" "historietter" ;
  historik_nn_1 = mkN "historik" "historiker" ;
  historiker_nn_1 = mkN "historiker" "historikern" "historiker" "historikerna" ;
  historiograf_nn_1 = mkN "historiograf" "historiografer" ;
  historisk_av_1 = mkA "historisk" ;
  histrion_nn_1 = mkN "histrion" "histrioner" ;
  hit_ab_1 = mkAdv "hit" ;
  hit_nn_1 = mkN "hit" "hiten" "hits" "hitsen" ;
  hitaat_ab_1 = mkAdv "hitеt" ;
  hithoerande_av_1 = mkA "hithцrande" ;
  hitintills_ab_1 = mkAdv "hitintills" ;
  hittebarn_nn_1 = mkN "hittebarn" neutrum ;
  hittilldags_ab_1 = mkAdv "hittilldags" ;
  hittills_ab_1 = mkAdv "hittills" ;
  hittillsvarande_av_1 = mkA "hittillsvarande" ;
  hjaelm_nn_1 = mkN "hjдlm" ;
  hjaelmprydnad_nn_1 = mkN "hjдlmprydnad" "hjдlmprydnader" ;
  hjaelp_nn_1 = mkN "hjдlp" ;
  hjaelpare_nn_1 = mkN "hjдlpare" "hjдlpare" ;
  hjaelpbaat_nn_1 = mkN "hjдlpbеt" ;
  hjaelpfartyg_nn_1 = mkN "hjдlpfartyg" neutrum ;
  hjaelpklass_nn_1 = mkN "hjдlpklass" "hjдlpklasser" ;
  hjaelpkryssare_nn_1 = mkN "hjдlpkryssare" "hjдlpkryssare" ;
  hjaelplig_av_1 = mkA "hjдlplig" ;
  hjaelplinje_nn_1 = mkN "hjдlplinje" "hjдlplinjer" ;
  hjaelploes_av_1 = mkA "hjдlplцs" ;
  hjaelpmedel_nn_1 = mkN "hjдlpmedel" neutrum ;
  hjaelpmotor_nn_1 = mkN "hjдlpmotor" "hjдlpmotorer" ;
  hjaelpsaendning_nn_1 = mkN "hjдlpsдndning" ;
  hjaelpsam_av_1 = mkA "hjдlpsam" "hjдlpsamt" "hjдlpsamma" "hjдlpsamma" "hjдlpsammare" "hjдlpsammast" "hjдlpsammaste" ;
  hjaelpsamhet_nn_1 = mkN "hjдlpsamhet" "hjдlpsamheter" ;
  hjaelpspraak_nn_1 = mkN "hjдlpsprеk" neutrum ;
  hjaelpverb_nn_1 = mkN "hjдlpverb" neutrum ;
  hjaelpvetenskap_nn_1 = mkN "hjдlpvetenskap" "hjдlpvetenskaper" ;
  hjaelte_nn_1 = mkN "hjдlte" utrum ;
  hjaeltedaad_nn_1 = mkN "hjдltedеd" neutrum ;
  hjaeltemodig_av_1 = mkA "hjдltemodig" ;
  hjaeltesaga_nn_1 = mkN "hjдltesaga" ;
  hjaernaktivitet_nn_1 = mkN "hjдrnaktivitet" "hjдrnaktiviteter" ;
  hjaernatrofi_nn_1 = mkN "hjдrnatrofi" "hjдrnatrofier" ;
  hjaernbalk_nn_1 = mkN "hjдrnbalk" ;
  hjaernbloedning_nn_1 = mkN "hjдrnblцdning" ;
  hjaernbyte_nn_1 = mkN "hjдrnbyte" ;
  hjaerncell_nn_1 = mkN "hjдrncell" "hjдrnceller" ;
  hjaerndel_nn_1 = mkN "hjдrndel" "hjдrndelen" "hjдrndelar" "hjдrndelarna" ;
  hjaerndoed_av_1 = mkA "hjдrndцd" ;
  hjaernhinna_nn_1 = mkN "hjдrnhinna" ;
  hjaernhinneinflammation_nn_1 = mkN "hjдrnhinneinflammation" "hjдrnhinneinflammationer" ;
  hjaerninflammation_nn_1 = mkN "hjдrninflammation" "hjдrninflammationer" ;
  hjaernoperation_nn_1 = mkN "hjдrnoperation" "hjдrnoperationer" ;
  hjaernsjukdom_nn_1 = mkN "hjдrnsjukdom" ;
  hjaernskaal_nn_1 = mkN "hjдrnskеl" ;
  hjaernskakning_nn_1 = mkN "hjдrnskakning" ;
  hjaernstam_nn_1 = mkN "hjдrnstam" "hjдrnstammen" "hjдrnstammar" "hjдrnstammarna" ;
  hjaernstorm_nn_1 = mkN "hjдrnstorm" ;
  hjaerntrust_nn_1 = mkN "hjдrntrust" "hjдrntruster" ;
  hjaerntumoer_nn_1 = mkN "hjдrntumцr" "hjдrntumцrer" ;
  hjaernvindling_nn_1 = mkN "hjдrnvindling" ;
  hjaertaengslig_av_1 = mkA "hjдrtдngslig" ;
  hjaertaktivitet_nn_1 = mkN "hjдrtaktivitet" "hjдrtaktiviteter" ;
  hjaertans_ab_1 = mkAdv "hjдrtans" ;
  hjaertas_av_1 = mkA "hjдrtas" ;
  hjaertattack_nn_1 = mkN "hjдrtattack" "hjдrtattacker" ;
  hjaertblad_nn_1 = mkN "hjдrtblad" neutrum ;
  hjaerteangelaegenhet_nn_1 = mkN "hjдrteangelдgenhet" "hjдrteangelдgenheter" ;
  hjaertegod_av_1 = mkA "hjдrtegod" ;
  hjaertegryn_nn_1 = mkN "hjдrtegryn" neutrum ;
  hjaertegull_nn_1 = mkN "hjдrtegull" neutrum ;
  hjaertekrossare_nn_1 = mkN "hjдrtekrossare" "hjдrtekrossare" ;
  hjaerter_nn_1 = mkN "hjдrter" "hjдrtern" "hjдrter" "hjдrterna" ;
  hjaertesak_nn_1 = mkN "hjдrtesak" "hjдrtesaker" ;
  hjaertesuck_nn_1 = mkN "hjдrtesuck" ;
  hjaertevaen_nn_1 = mkN "hjдrtevдn" "hjдrtevдnnen" "hjдrtevдnner" "hjдrtevдnnerna" ;
  hjaertfel_nn_1 = mkN "hjдrtfel" "hjдrtfelet" "hjдrtfel" "hjдrtfelen" ;
  hjaertformig_av_1 = mkA "hjдrtformig" ;
  hjaertinfarkt_nn_1 = mkN "hjдrtinfarkt" "hjдrtinfarkter" ;
  hjaertinnerlig_av_1 = mkA "hjдrtinnerlig" ;
  hjaertklaff_nn_1 = mkN "hjдrtklaff" ;
  hjaertklappning_nn_1 = mkN "hjдrtklappning" ;
  hjaertknipande_av_1 = mkA "hjдrtknipande" ;
  hjaertkramp_nn_1 = mkN "hjдrtkramp" "hjдrtkramper" ;
  hjaertlig_av_1 = mkA "hjдrtlig" ;
  hjaertligen_ab_1 = mkAdv "hjдrtligen" ;
  hjaertljud_nn_1 = mkN "hjдrtljud" neutrum ;
  hjaertloes_av_1 = mkA "hjдrtlцs" ;
  hjaertlungmaskin_nn_1 = mkN "hjдrtlungmaskin" "hjдrtlungmaskiner" ;
  hjaertmussla_nn_1 = mkN "hjдrtmussla" ;
  hjaertnupen_av_1 = mkA "hjдrtnupen" "hjдrtnupet" ;
  hjaertoperation_nn_1 = mkN "hjдrtoperation" "hjдrtoperationer" ;
  hjaertpunkt_nn_1 = mkN "hjдrtpunkt" "hjдrtpunkter" ;
  hjaertsaeck_nn_1 = mkN "hjдrtsдck" ;
  hjaertskaerande_av_1 = mkA "hjдrtskдrande" ;
  hjaertslag_nn_1 = mkN "hjдrtslag" neutrum ;
  hjaertslitande_av_1 = mkA "hjдrtslitande" ;
  hjaertstillande_av_1 = mkA "hjдrtstillande" ;
  hjaerttransplantation_nn_1 = mkN "hjдrttransplantation" "hjдrttransplantationer" ;
  hjaertverksamhet_nn_1 = mkN "hjдrtverksamhet" "hjдrtverksamheter" ;
  hjaessbjudning_nn_1 = mkN "hjдssbjudning" ;
  hjon_nn_1 = mkN "hjon" neutrum ;
  hjonelag_nn_1 = mkN "hjonelag" neutrum ;
  hjord_nn_1 = mkN "hjord" ;
  hjort_nn_1 = mkN "hjort" ;
  hjortdjur_nn_1 = mkN "hjortdjur" neutrum ;
  hjortron_nn_1 = mkN "hjortron" neutrum ;
  hjortsadel_nn_1 = mkN "hjortsadel" ;
  hjul_nn_1 = mkN "hjul" neutrum ;
  hjulaangare_nn_1 = mkN "hjulеngare" "hjulеngare" ;
  hjulbas_nn_1 = mkN "hjulbas" "hjulbaser" ;
  hjulbent_av_1 = mkA "hjulbent" "hjulbent" ;
  hjuldjur_nn_1 = mkN "hjuldjur" neutrum ;
  hjulfjaedring_nn_1 = mkN "hjulfjдdring" ;
  hjulfoenster_nn_1 = mkN "hjulfцnster" neutrum ;
  hjulkors_nn_1 = mkN "hjulkors" neutrum ;
  hjullager_nn_1 = mkN "hjullager" neutrum ;
  hjulnav_nn_1 = mkN "hjulnav" neutrum ;
  hjulspaar_nn_1 = mkN "hjulspеr" neutrum ;
  hjulupphaengning_nn_1 = mkN "hjulupphдngning" ;
  ho_nn_1 = mkN "ho" ;
  hobby_nn_1 = mkN "hobby" "hobbyn" "hobbies" "hobbyerna" ;
  hoeft_nn_1 = mkN "hцft" "hцfter" ;
  hoeftben_nn_1 = mkN "hцftben" neutrum ;
  hoefthaallare_nn_1 = mkN "hцfthеllare" "hцfthеllare" ;
  hoeftled_nn_1 = mkN "hцftled" "hцftleder" ;
  hoeftparti_nn_1 = mkN "hцftparti" "hцftpartit" "hцftpartier" "hцftpartierna" ;
  hoeg_av_1 = mkA "hцg" "hцgre" "hцgst" ;
  hoeg_nn_1 = mkN "hцg" ;
  hoegaffel_nn_1 = mkN "hцgaffel" ;
  hoegaktiv_av_1 = mkA "hцgaktiv" ;
  hoegaktningsfull_av_1 = mkA "hцgaktningsfull" ;
  hoegaktuell_av_1 = mkA "hцgaktuell" ;
  hoegaltare_nn_1 = mkN "hцgaltare" "hцgaltaret" "hцgaltaren" "hцgaltarna" ;
  hoegbaenk_nn_1 = mkN "hцgbдnk" ;
  hoegben_nn_1 = mkN "hцgben" neutrum ;
  hoegblad_nn_1 = mkN "hцgblad" neutrum ;
  hoegboren_av_1 = mkA "hцgboren" "hцgboret" ;
  hoegborg_nn_1 = mkN "hцgborg" ;
  hoegborgerlig_av_1 = mkA "hцgborgerlig" ;
  hoegburen_av_1 = mkA "hцgburen" "hцgburet" ;
  hoegdjur_nn_1 = mkN "hцgdjur" neutrum ;
  hoegdragen_av_1 = mkA "hцgdragen" "hцgdraget" ;
  hoegeligen_ab_1 = mkAdv "hцgeligen" ;
  hoegenergikollision_nn_1 = mkN "hцgenergikollision" "hцgenergikollisioner" ;
  hoegerextremistisk_av_1 = mkA "hцgerextremistisk" ;
  hoegerflygel_nn_1 = mkN "hцgerflygel" ;
  hoegerhaent_av_1 = mkA "hцgerhдnt" "hцgerhдnt" ;
  hoegerhand_nn_1 = mkN "hцgerhand" "hцgerhдnder" ;
  hoegerkrok_nn_1 = mkN "hцgerkrok" ;
  hoegerledare_nn_1 = mkN "hцgerledare" "hцgerledare" ;
  hoegerman_nn_1 = mkN "hцgerman" "hцgermannen" "hцgermдn" "hцgermдnnen" ;
  hoegerparti_nn_1 = mkN "hцgerparti" "hцgerpartit" "hцgerpartier" "hцgerpartierna" ;
  hoegervind_nn_1 = mkN "hцgervind" ;
  hoegervridning_nn_1 = mkN "hцgervridning" ;
  hoegexplosiv_av_1 = mkA "hцgexplosiv" ;
  hoegfaerdig_av_1 = mkA "hцgfдrdig" ;
  hoegfjaell_nn_1 = mkN "hцgfjдll" neutrum ;
  hoegfjaellsomraade_nn_1 = mkN "hцgfjдllsomrеde" ;
  hoegfoernaem_av_1 = mkA "hцgfцrnдm" ;
  hoegfoerraedare_nn_1 = mkN "hцgfцrrдdare" "hцgfцrrдdare" ;
  hoegfoerraederi_nn_1 = mkN "hцgfцrrдderi" "hцgfцrrдderit" "hцgfцrrдderier" "hцgfцrrдderierna" ;
  hoegfrekvens_nn_1 = mkN "hцgfrekvens" "hцgfrekvenser" ;
  hoegfrekvent_av_1 = mkA "hцgfrekvent" "hцgfrekvent" ;
  hoeggradig_av_1 = mkA "hцggradig" ;
  hoeghastighetskamera_nn_1 = mkN "hцghastighetskamera" ;
  hoeghet_nn_1 = mkN "hцghet" "hцgheter" ;
  hoeghus_nn_1 = mkN "hцghus" neutrum ;
  hoeginkomsttagare_nn_1 = mkN "hцginkomsttagare" "hцginkomsttagare" ;
  hoegklassig_av_1 = mkA "hцgklassig" ;
  hoegkonjunktur_nn_1 = mkN "hцgkonjunktur" "hцgkonjunkturer" ;
  hoegkultur_nn_1 = mkN "hцgkultur" "hцgkulturer" ;
  hoegkvarter_nn_1 = mkN "hцgkvarter" "hцgkvarteret" "hцgkvarter" "hцgkvarteren" ;
  hoegkyrklig_av_1 = mkA "hцgkyrklig" ;
  hoeglaendare_nn_1 = mkN "hцglдndare" "hцglдndare" ;
  hoegland_nn_1 = mkN "hцgland" "hцglandet" "hцglдnder" "hцglдnderna" ;
  hoegljudd_av_1 = mkA "hцgljudd" ;
  hoegmaalsbrott_nn_1 = mkN "hцgmеlsbrott" neutrum ;
  hoegmodig_av_1 = mkA "hцgmodig" ;
  hoegmolekylaer_av_1 = mkA "hцgmolekylдr" ;
  hoegoensklig_av_1 = mkA "hцgцnsklig" ;
  hoegoktanig_av_1 = mkA "hцgoktanig" ;
  hoegplataa_nn_1 = mkN "hцgplatе" "hцgplatеer" ;
  hoegrest_av_1 = mkA "hцgrest" "hцgrest" ;
  hoegrestaandskultur_nn_1 = mkN "hцgrestеndskultur" "hцgrestеndskulturer" ;
  hoegrev_nn_1 = mkN "hцgrev" neutrum ;
  hoegroed_av_1 = mkA "hцgrцd" ;
  hoegsaesong_nn_1 = mkN "hцgsдsong" "hцgsдsonger" ;
  hoegsaete_nn_1 = mkN "hцgsдte" ;
  hoegsint_av_1 = mkA "hцgsint" "hцgsint" ;
  hoegskoleadjunkt_nn_1 = mkN "hцgskoleadjunkt" "hцgskoleadjunkter" ;
  hoegskolelektor_nn_1 = mkN "hцgskolelektor" "hцgskolelektorer" ;
  hoegslaett_nn_1 = mkN "hцgslдtt" "hцgslдtter" ;
  hoegsommar_nn_1 = mkN "hцgsommar" "hцgsommarn" "hцgsommrar" "hцgsommrarna" ;
  hoegspaend_av_1 = mkA "hцgspдnd" ;
  hoegspaenning_nn_1 = mkN "hцgspдnning" ;
  hoegst_ab_1 = mkAdv "hцgst" ;
  hoegstadium_nn_1 = mkN "hцgstadium" "hцgstadiet" "hцgstadier" "hцgstadierna" ;
  hoegstaemd_av_1 = mkA "hцgstдmd" "hцgstдmt" ;
  hoegstbjudande_av_1 = mkA "hцgstbjudande" ;
  hoegtalare_nn_1 = mkN "hцgtalare" "hцgtalare" ;
  hoegteknologisk_av_1 = mkA "hцgteknologisk" ;
  hoegtflygande_av_1 = mkA "hцgtflygande" ;
  hoegtid_nn_1 = mkN "hцgtid" "hцgtider" ;
  hoegtidlig_av_1 = mkA "hцgtidlig" ;
  hoegtidlighaalla_vb_1 = mkV "hцgtidlighеlla" "hцgtidlighцll" "hцgtidlighеllit" ;
  hoegtidlighet_nn_1 = mkN "hцgtidlighet" "hцgtidligheter" ;
  hoegtidsaar_nn_1 = mkN "hцgtidsеr" neutrum ;
  hoegtidsdag_nn_1 = mkN "hцgtidsdag" ;
  hoegtidsdraekt_nn_1 = mkN "hцgtidsdrдkt" "hцgtidsdrдkter" ;
  hoegtidsstund_nn_1 = mkN "hцgtidsstund" "hцgtidsstunder" ;
  hoegtidstal_nn_1 = mkN "hцgtidstal" "hцgtidstalet" "hцgtidstalen" "hцgtidstalena" ;
  hoegtravande_av_1 = mkA "hцgtravande" ;
  hoegtryck_nn_1 = mkN "hцgtryck" neutrum ;
  hoegtrycksrygg_nn_1 = mkN "hцgtrycksrygg" ;
  hoegtstaaende_av_1 = mkA "hцgtstеende" ;
  hoegtysk_av_1 = mkA "hцgtysk" ;
  hoegvaelboren_av_1 = mkA "hцgvдlboren" "hцgvдlboret" ;
  hoegvaerdig_av_1 = mkA "hцgvдrdig" ;
  hoegvaext_av_1 = mkA "hцgvдxt" "hцgvдxt" ;
  hoegvakt_nn_1 = mkN "hцgvakt" "hцgvakter" ;
  hoegvall_nn_1 = mkN "hцgvall" ;
  hoegvallskloever_nn_1 = mkN "hцgvallsklцver" "hцgvallsklцvern" "hцgvallsklцver" "hцgvallsklцverna" ;
  hoegvatten_nn_1 = mkN "hцgvatten" "hцgvattnet" "hцgvatten" "hцgvattnen" ;
  hoegvoerdig_av_1 = mkA "hцgvцrdig" ;
  hoegvoerdighet_nn_1 = mkN "hцgvцrdighet" "hцgvцrdigheter" ;
  hoegvuxen_av_1 = mkA "hцgvuxen" "hцgvuxet" ;
  hoejd_nn_1 = mkN "hцjd" "hцjder" ;
  hoejdare_nn_1 = mkN "hцjdare" "hцjdare" ;
  hoejdbestaemning_nn_1 = mkN "hцjdbestдmning" ;
  hoejdhopp_nn_1 = mkN "hцjdhopp" neutrum ;
  hoejdhoppare_nn_1 = mkN "hцjdhoppare" "hцjdhoppare" ;
  hoejdhoppstaevling_nn_1 = mkN "hцjdhoppstдvling" ;
  hoejdlaege_nn_1 = mkN "hцjdlдge" ;
  hoejdmaetare_nn_1 = mkN "hцjdmдtare" "hцjdmдtare" ;
  hoejdmaetning_nn_1 = mkN "hцjdmдtning" ;
  hoejdpunkt_nn_1 = mkN "hцjdpunkt" "hцjdpunkter" ;
  hoejdrygg_nn_1 = mkN "hцjdrygg" ;
  hoejdskillnad_nn_1 = mkN "hцjdskillnad" "hцjdskillnader" ;
  hoejdstraeckning_nn_1 = mkN "hцjdstrдckning" ;
  hoejning_nn_1 = mkN "hцjning" ;
  hoek_nn_1 = mkN "hцk" ;
  hoekare_nn_1 = mkN "hцkare" "hцkare" ;
  hoekeri_nn_1 = mkN "hцkeri" "hцkerit" "hцkerier" "hцkerierna" ;
  hoeknatt_nn_1 = mkN "hцknatt" "hцknдtter" ;
  hoelja_nn_1 = mkN "hцlja" ;
  hoelster_nn_1 = mkN "hцlster" neutrum ;
  hoens_nn_1 = mkN "hцns" neutrum ;
  hoensaegg_nn_1 = mkN "hцnsдgg" neutrum ;
  hoensbaer_nn_1 = mkN "hцnsbдr" neutrum ;
  hoenseri_nn_1 = mkN "hцnseri" "hцnserit" "hцnserier" "hцnserierna" ;
  hoensfaagel_nn_1 = mkN "hцnsfеgel" ;
  hoensgaard_nn_1 = mkN "hцnsgеrd" ;
  hoensig_av_1 = mkA "hцnsig" ;
  hoensnaet_nn_1 = mkN "hцnsnдt" neutrum ;
  hoerapparat_nn_1 = mkN "hцrapparat" "hцrapparater" ;
  hoerbar_av_1 = mkA "hцrbar" ;
  hoerbarhet_nn_1 = mkN "hцrbarhet" "hцrbarheter" ;
  hoerbarligen_ab_1 = mkAdv "hцrbarligen" ;
  hoerlur_nn_1 = mkN "hцrlur" ;
  hoern_nn_1 = mkN "hцrn" neutrum ;
  hoernhus_nn_1 = mkN "hцrnhus" neutrum ;
  hoernpelare_nn_1 = mkN "hцrnpelare" "hцrnpelare" ;
  hoernsten_nn_1 = mkN "hцrnsten" "hцrnstenen" "hцrnstenar" "hцrnstenarna" ;
  hoerntand_nn_1 = mkN "hцrntand" "hцrntдnder" ;
  hoersaegen_nn_1 = mkN "hцrsдgen" "hцrsдgenn" "hцrsдgner" "hцrsдgnerna" ;
  hoersaga_nn_1 = mkN "hцrsaga" ;
  hoersal_nn_1 = mkN "hцrsal" ;
  hoersam_av_1 = mkA "hцrsam" "hцrsamt" "hцrsamma" "hцrsamma" "hцrsammare" "hцrsammast" "hцrsammaste" ;
  hoerselben_nn_1 = mkN "hцrselben" neutrum ;
  hoerselklass_nn_1 = mkN "hцrselklass" "hцrselklasser" ;
  hoerselorgan_nn_1 = mkN "hцrselorgan" neutrum ;
  hoerspel_nn_1 = mkN "hцrspel" "hцrspelet" "hцrspel" "hцrspelen" ;
  hoertelefon_nn_1 = mkN "hцrtelefon" "hцrtelefoner" ;
  hoesaate_nn_1 = mkN "hцsеte" utrum ;
  hoesaeck_nn_1 = mkN "hцsдck" ;
  hoeskulle_nn_1 = mkN "hцskulle" utrum ;
  hoest_nn_1 = mkN "hцst" ;
  hoestack_nn_1 = mkN "hцstack" ;
  hoestdagjaemning_nn_1 = mkN "hцstdagjдmning" ;
  hoestlig_av_1 = mkA "hцstlig" ;
  hoestsaesong_nn_1 = mkN "hцstsдsong" "hцstsдsonger" ;
  hoestslakt_nn_1 = mkN "hцstslakt" "hцstslakter" ;
  hoesttermin_nn_1 = mkN "hцsttermin" "hцstterminer" ;
  hoestvaeder_nn_1 = mkN "hцstvдder" neutrum ;
  hoetapp_nn_1 = mkN "hцtapp" ;
  hoetork_nn_1 = mkN "hцtork" ;
  hoevaalm_nn_1 = mkN "hцvеlm" ;
  hoevaendare_nn_1 = mkN "hцvдndare" "hцvдndare" ;
  hoevding_nn_1 = mkN "hцvding" ;
  hoevisk_av_1 = mkA "hцvisk" ;
  hoevitsman_nn_1 = mkN "hцvitsman" "hцvitsmannen" "hцvitsmдn" "hцvitsmдnnen" ;
  hoevlig_av_1 = mkA "hцvlig" ;
  hoevlighet_nn_1 = mkN "hцvlighet" "hцvligheter" ;
  hoevlighetsvisit_nn_1 = mkN "hцvlighetsvisit" "hцvlighetsvisiter" ;
  hoj_nn_1 = mkN "hoj" ;
  holdingbolag_nn_1 = mkN "holdingbolag" neutrum ;
  holistisk_av_1 = mkA "holistisk" ;
  holk_nn_1 = mkN "holk" ;
  hollaendare_nn_1 = mkN "hollдndare" "hollдndare" ;
  hollaendsk_av_1 = mkA "hollдndsk" ;
  hollaendska_nn_2 = mkN "hollдndska" ;
  holme_nn_1 = mkN "holme" utrum ;
  holmgaang_nn_1 = mkN "holmgеng" ;
  hologram_nn_1 = mkN "hologram" "hologrammet" "hologram" "hologrammen" ;
  holt_nn_1 = mkN "holt" neutrum ;
  homeopat_nn_1 = mkN "homeopat" "homeopater" ;
  homeopatisk_av_1 = mkA "homeopatisk" ;
  homerisk_av_1 = mkA "homerisk" ;
  homilet_nn_1 = mkN "homilet" "homileter" ;
  homiletisk_av_1 = mkA "homiletisk" ;
  homofil_nn_1 = mkN "homofil" "homofiler" ;
  homofon_av_1 = mkA "homofon" ;
  homofon_nn_1 = mkN "homofon" "homofoner" ;
  homogen_av_1 = mkA "homogen" ;
  homogenitet_nn_1 = mkN "homogenitet" "homogeniteter" ;
  homograf_av_1 = mkA "homograf" ;
  homograf_nn_1 = mkN "homograf" "homografer" ;
  homolog_av_1 = mkA "homolog" ;
  homonym_av_1 = mkA "homonym" ;
  homonym_nn_1 = mkN "homonym" "homonymer" ;
  homonymi_nn_1 = mkN "homonymi" "homonymier" ;
  homosexualitet_nn_1 = mkN "homosexualitet" "homosexualiteter" ;
  homosexuell_av_1 = mkA "homosexuell" ;
  homozygot_av_1 = mkA "homozygot" "homozygot" ;
  homozygot_nn_1 = mkN "homozygot" "homozygoter" ;
  honduran_nn_1 = mkN "honduran" "honduraner" ;
  honduransk_av_1 = mkA "honduransk" ;
  honlig_av_1 = mkA "honlig" ;
  honnett_av_1 = mkA "honnett" ;
  honnoer_nn_1 = mkN "honnцr" "honnцrer" ;
  honnoersbetyg_nn_1 = mkN "honnцrsbetyg" neutrum ;
  honnoersbord_nn_1 = mkN "honnцrsbord" neutrum ;
  honnoersord_nn_1 = mkN "honnцrsord" neutrum ;
  honnoerspost_nn_1 = mkN "honnцrspost" "honnцrsposter" ;
  honoraer_av_1 = mkA "honorдr" ;
  honorar_nn_1 = mkN "honorar" neutrum ;
  honungslen_av_1 = mkA "honungslen" ;
  honungsmelon_nn_1 = mkN "honungsmelon" "honungsmeloner" ;
  honungsskivling_nn_1 = mkN "honungsskivling" ;
  hop_nn_1 = mkN "hop" ;
  hopbiten_av_1 = mkA "hopbiten" "hopbitet" ;
  hopblandning_nn_1 = mkN "hopblandning" ;
  hopbyggd_av_1 = mkA "hopbyggd" "hopbyggt" ;
  hopdragning_nn_1 = mkN "hopdragning" ;
  hopfaellbar_av_1 = mkA "hopfдllbar" ;
  hopfaelld_av_1 = mkA "hopfдlld" "hopfдllt" ;
  hopklumpning_nn_1 = mkN "hopklumpning" ;
  hopknaeppt_av_1 = mkA "hopknдppt" "hopknдppt" ;
  hopknyta_vb_1 = mkV "hopknyta" "hopknцt" "hopknutit" ;
  hopkok_nn_1 = mkN "hopkok" neutrum ;
  hopkommen_av_1 = mkA "hopkommen" "hopkommet" "hopkomna" "hopkomna" "hopkomnare" "hopkomnast" "hopkomnaste" ;
  hopkoppling_nn_1 = mkN "hopkoppling" ;
  hopkrupen_av_1 = mkA "hopkrupen" "hopkrupet" ;
  hoplit_nn_1 = mkN "hoplit" "hopliter" ;
  hopp_i_landkalle_nn_1 = mkN "hopp-i-landkalle" utrum ;
  hopp_nn_1 = mkN "hopp" neutrum ;
  hoppare_nn_1 = mkN "hoppare" "hoppare" ;
  hoppbacke_nn_1 = mkN "hoppbacke" utrum ;
  hoppeligen_ab_1 = mkAdv "hoppeligen" ;
  hoppfoersoek_nn_1 = mkN "hoppfцrsцk" neutrum ;
  hoppfull_av_1 = mkA "hoppfull" ;
  hoppig_av_1 = mkA "hoppig" ;
  hoppingivande_av_1 = mkA "hoppingivande" ;
  hoppledare_nn_1 = mkN "hoppledare" "hoppledare" ;
  hopploes_av_1 = mkA "hopplцs" ;
  hopploeshet_nn_1 = mkN "hopplцshet" "hopplцsheter" ;
  hopprep_nn_1 = mkN "hopprep" neutrum ;
  hoppstaellning_nn_1 = mkN "hoppstдllning" ;
  hoppstjaert_nn_1 = mkN "hoppstjдrt" ;
  hopptorn_nn_1 = mkN "hopptorn" neutrum ;
  hopptraening_nn_1 = mkN "hopptrдning" ;
  hopsjunken_av_1 = mkA "hopsjunken" "hopsjunket" ;
  hopslagen_av_1 = mkA "hopslagen" "hopslaget" ;
  hopsnodd_av_1 = mkA "hopsnodd" ;
  hopsnoerd_av_1 = mkA "hopsnцrd" "hopsnцrt" ;
  hopsnoerpt_av_1 = mkA "hopsnцrpt" "hopsnцrpt" ;
  hopvaext_av_1 = mkA "hopvдxt" "hopvдxt" ;
  hopvika_vb_1 = mkV "hopvika" "hopvek" "hopvikit" ;
  hopvuxen_av_1 = mkA "hopvuxen" "hopvuxet" ;
  horbock_nn_1 = mkN "horbock" ;
  hord_nn_1 = mkN "hord" "horder" ;
  horhus_nn_1 = mkN "horhus" neutrum ;
  horisont_nn_1 = mkN "horisont" "horisonter" ;
  horisontal_av_1 = mkA "horisontal" ;
  horisontalplan_nn_1 = mkN "horisontalplan" neutrum ;
  horisontell_av_1 = mkA "horisontell" ;
  horisontproblem_nn_1 = mkN "horisontproblem" neutrum ;
  hormon_nn_1 = mkN "hormon" neutrum ;
  hormonbalans_nn_1 = mkN "hormonbalans" "hormonbalanser" ;
  hormonell_av_1 = mkA "hormonell" ;
  hormonfunktion_nn_1 = mkN "hormonfunktion" "hormonfunktioner" ;
  hormonproduktion_nn_1 = mkN "hormonproduktion" "hormonproduktioner" ;
  hormonsystem_nn_1 = mkN "hormonsystem" neutrum ;
  horn_nn_1 = mkN "horn" neutrum ;
  hornbaage_nn_1 = mkN "hornbеge" utrum ;
  hornhinna_nn_1 = mkN "hornhinna" ;
  hornist_nn_1 = mkN "hornist" "hornister" ;
  hornliknande_av_1 = mkA "hornliknande" ;
  hornloes_av_1 = mkA "hornlцs" ;
  horologium_nn_1 = mkN "horologium" "horologiet" "horologier" "horologierna" ;
  horoskop_nn_1 = mkN "horoskop" neutrum ;
  horribel_av_1 = mkA "horribel" "horribelt" "horribla" "horribla" "horriblare" "horriblast" "horriblaste" ;
  horroer_nn_1 = mkN "horrцr" "horrцrer" ;
  horsgoek_nn_1 = mkN "horsgцk" ;
  horst_nn_1 = mkN "horst" ;
  hortonom_nn_1 = mkN "hortonom" "hortonomer" ;
  hospital_nn_1 = mkN "hospital" neutrum ;
  hospits_nn_1 = mkN "hospits" neutrum ;
  hostanfall_nn_1 = mkN "hostanfall" neutrum ;
  hostattack_nn_1 = mkN "hostattack" "hostattacker" ;
  hostig_av_1 = mkA "hostig" ;
  hostning_nn_1 = mkN "hostning" ;
  hot_nn_1 = mkN "hot" neutrum ;
  hotbild_nn_1 = mkN "hotbild" "hotbilder" ;
  hotell_nn_1 = mkN "hotell" neutrum ;
  hotellbrand_nn_1 = mkN "hotellbrand" "hotellbrдnder" ;
  hotellgaest_nn_1 = mkN "hotellgдst" "hotellgдster" ;
  hotellpojke_nn_1 = mkN "hotellpojke" utrum ;
  hotellrum_nn_1 = mkN "hotellrum" "hotellrummet" "hotellrum" "hotellrummen" ;
  hotelse_nn_1 = mkN "hotelse" "hotelser" ;
  hotfull_av_1 = mkA "hotfull" ;
  hottentotsk_av_1 = mkA "hottentotsk" ;
  hottentotska_nn_2 = mkN "hottentotska" ;
  hottentott_nn_1 = mkN "hottentott" "hottentotter" ;
  hov_nn_1 = mkN "hov" ;
  hov_nn_2 = mkN "hov" neutrum ;
  hovbeslag_nn_1 = mkN "hovbeslag" neutrum ;
  hovbetjaent_nn_1 = mkN "hovbetjдnt" "hovbetjдnter" ;
  hovdam_nn_1 = mkN "hovdam" "hovdamer" ;
  hovdjur_nn_1 = mkN "hovdjur" neutrum ;
  hovkapell_nn_1 = mkN "hovkapell" neutrum ;
  hovleverantoer_nn_1 = mkN "hovleverantцr" "hovleverantцrer" ;
  hovmaestare_nn_1 = mkN "hovmдstare" "hovmдstare" ;
  hovman_nn_1 = mkN "hovman" "hovmannen" "hovmдn" "hovmдnnen" ;
  hovmarskalk_nn_1 = mkN "hovmarskalk" ;
  hovnarr_nn_1 = mkN "hovnarr" ;
  hovnigning_nn_1 = mkN "hovnigning" ;
  hovraett_nn_1 = mkN "hovrдtt" "hovrдtter" ;
  hovraettspresident_nn_1 = mkN "hovrдttspresident" "hovrдttspresidenter" ;
  hovraettsraad_nn_1 = mkN "hovrдttsrеd" neutrum ;
  hovsam_av_1 = mkA "hovsam" "hovsamt" "hovsamma" "hovsamma" "hovsammare" "hovsammast" "hovsammaste" ;
  hovslag_nn_1 = mkN "hovslag" neutrum ;
  hovslagare_nn_1 = mkN "hovslagare" "hovslagare" ;
  hovstat_nn_1 = mkN "hovstat" "hovstater" ;
  hovtaang_nn_1 = mkN "hovtеng" "hovtдnger" ;
  hud_nn_1 = mkN "hud" ;
  hudfaerg_nn_1 = mkN "hudfдrg" "hudfдrger" ;
  hudflaeck_nn_1 = mkN "hudflдck" ;
  hudinflammation_nn_1 = mkN "hudinflammation" "hudinflammationer" ;
  hudkraem_nn_1 = mkN "hudkrдm" "hudkrдmer" ;
  hudlager_nn_1 = mkN "hudlager" neutrum ;
  hudloes_av_1 = mkA "hudlцs" ;
  hudmedel_nn_1 = mkN "hudmedel" neutrum ;
  hudnaera_av_1 = mkA "hudnдra" ;
  hudoemsning_nn_1 = mkN "hudцmsning" ;
  hudolja_nn_1 = mkN "hudolja" ;
  hudsjukdom_nn_1 = mkN "hudsjukdom" ;
  hudtransplantation_nn_1 = mkN "hudtransplantation" "hudtransplantationer" ;
  hudutslag_nn_1 = mkN "hudutslag" neutrum ;
  hudvaenlig_av_1 = mkA "hudvдnlig" ;
  hudveck_nn_1 = mkN "hudveck" neutrum ;
  hugenott_nn_1 = mkN "hugenott" "hugenotter" ;
  hugg_nn_1 = mkN "hugg" neutrum ;
  hugga_vb_1 = mkV "hugga" "hцgg" "huggit" ;
  huggare_nn_1 = mkN "huggare" "huggare" ;
  huggkrok_nn_1 = mkN "huggkrok" ;
  huggkubb_nn_1 = mkN "huggkubb" ;
  huggmejsel_nn_1 = mkN "huggmejsel" ;
  huggorm_nn_1 = mkN "huggorm" ;
  huggtand_nn_1 = mkN "huggtand" "huggtдnder" ;
  hugnad_nn_1 = mkN "hugnad" "hugnader" ;
  hugnesam_av_1 = mkA "hugnesam" "hugnesamt" "hugnesamma" "hugnesamma" "hugnesammare" "hugnesammast" "hugnesammaste" ;
  hugskott_nn_1 = mkN "hugskott" neutrum ;
  huld_av_1 = mkA "huld" "hult" ;
  huldra_nn_1 = mkN "huldra" ;
  huligan_nn_1 = mkN "huligan" "huliganer" ;
  hulk_nn_1 = mkN "hulk" ;
  hulling_nn_1 = mkN "hulling" ;
  hult_nn_1 = mkN "hult" ;
  human_av_1 = mkA "human" ;
  humanekologisk_av_1 = mkA "humanekologisk" ;
  humaniora_nn_1 = mkN "humaniora" "humanioran" "humaniora" "humaniorana" ;
  humanist_nn_1 = mkN "humanist" "humanister" ;
  humanistisk_av_1 = mkA "humanistisk" ;
  humanitaer_av_1 = mkA "humanitдr" ;
  humanitet_nn_1 = mkN "humanitet" "humaniteter" ;
  humanvetenskap_nn_1 = mkN "humanvetenskap" "humanvetenskaper" ;
  humbug_nn_1 = mkN "humbug" ;
  humla_nn_1 = mkN "humla" ;
  humleblomster_nn_1 = mkN "humleblomster" neutrum ;
  hummer_nn_1 = mkN "hummer" "hummern" "hummrar" "hummrarna" ;
  humoer_nn_1 = mkN "humцr" neutrum ;
  humoermaenniska_nn_1 = mkN "humцrmдnniska" ;
  humoerspelare_nn_1 = mkN "humцrspelare" "humцrspelare" ;
  humoresk_nn_1 = mkN "humoresk" "humoresker" ;
  humorist_nn_1 = mkN "humorist" "humorister" ;
  humoristisk_av_1 = mkA "humoristisk" ;
  humusaemne_nn_1 = mkN "humusдmne" ;
  humusbunden_av_1 = mkA "humusbunden" "humusbundet" ;
  humusfoerening_nn_1 = mkN "humusfцrening" ;
  humushalt_nn_1 = mkN "humushalt" "humushalter" ;
  humushaltig_av_1 = mkA "humushaltig" ;
  humuskomponent_nn_1 = mkN "humuskomponent" "humuskomponenter" ;
  humuskoncentration_nn_1 = mkN "humuskoncentration" "humuskoncentrationer" ;
  humussubstans_nn_1 = mkN "humussubstans" "humussubstanser" ;
  humusvatten_nn_1 = mkN "humusvatten" "humusvattnet" "humusvatten" "humusvattnen" ;
  hund_nn_1 = mkN "hund" ;
  hundaar_nn_1 = mkN "hundеr" neutrum ;
  hundaexing_nn_1 = mkN "hundдxing" ;
  hundben_nn_1 = mkN "hundben" neutrum ;
  hundblick_nn_1 = mkN "hundblick" ;
  hunddjur_nn_1 = mkN "hunddjur" neutrum ;
  hundhalsband_nn_1 = mkN "hundhalsband" neutrum ;
  hundhuvud_nn_1 = mkN "hundhuvud" "hundhuvudet" "hundhuvuden" "hundhuvudena" ;
  hundhuvudet_ab_1 = mkAdv "hundhuvudet" ;
  hundkaex_nn_2 = mkN "hundkдx" neutrum ;
  hundkapploepning_nn_1 = mkN "hundkapplцpning" ;
  hundkex_nn_1 = mkN "hundkex" neutrum ;
  hundlort_nn_1 = mkN "hundlort" ;
  hundoera_nn_1 = mkN "hundцra" "hundцrat" "hundцron" "hundцronen" ;
  hundradel_nn_1 = mkN "hundradel" "hundradelen" "hundradelar" "hundradelarna" ;
  hundrafalt_ab_1 = mkAdv "hundrafalt" ;
  hundrakronorssedel_nn_1 = mkN "hundrakronorssedel" ;
  hundralapp_nn_1 = mkN "hundralapp" ;
  hundraprocentig_av_1 = mkA "hundraprocentig" ;
  hundras_nn_1 = mkN "hundras" "hundraser" ;
  hundratal_nn_1 = mkN "hundratal" "hundratalet" "hundratalen" "hundratalena" ;
  hundratals_ab_1 = mkAdv "hundratals" ;
  hundratusental_nn_1 = mkN "hundratusental" "hundratusentalet" "hundratusentalen" "hundratusentalena" ;
  hundratusentonnare_nn_1 = mkN "hundratusentonnare" "hundratusentonnare" ;
  hundring_nn_1 = mkN "hundring" ;
  hundskatt_nn_1 = mkN "hundskatt" "hundskatter" ;
  hundslaede_nn_1 = mkN "hundslдde" utrum ;
  hundvakt_nn_1 = mkN "hundvakt" "hundvakter" ;
  hundvalp_nn_1 = mkN "hundvalp" ;
  hungerstrejk_nn_1 = mkN "hungerstrejk" "hungerstrejker" ;
  hungrig_av_1 = mkA "hungrig" ;
  hunner_nn_1 = mkN "hunner" "hunnern" "hunner" "hunnerna" ;
  hur_ab_1 = mkAdv "hur" ;
  hurra_nn_1 = mkN "hurra" "hurrat" "hurra" "hurrana" ;
  hurrarop_nn_1 = mkN "hurrarop" neutrum ;
  hurril_nn_1 = mkN "hurril" ;
  hursomhelst_ab_1 = mkAdv "hursomhelst" ;
  hurtbulle_nn_1 = mkN "hurtbulle" utrum ;
  hurtfrisk_av_1 = mkA "hurtfrisk" ;
  hurtig_av_1 = mkA "hurtig" ;
  hurts_nn_1 = mkN "hurts" ;
  huru_ab_1 = mkAdv "huru" ;
  huruledes_ab_1 = mkAdv "huruledes" ;
  hus_nn_1 = mkN "hus" neutrum ;
  husaegare_nn_1 = mkN "husдgare" "husдgare" ;
  husandakt_nn_1 = mkN "husandakt" "husandakter" ;
  husapotek_nn_1 = mkN "husapotek" neutrum ;
  husar_nn_1 = mkN "husar" "husarer" ;
  husbaat_nn_1 = mkN "husbеt" ;
  husbehov_nn_1 = mkN "husbehov" neutrum ;
  husbil_nn_1 = mkN "husbil" ;
  husbock_nn_1 = mkN "husbock" ;
  husbonde_nn_1 = mkN "husbonde" "husbцnder" ;
  husbygge_nn_1 = mkN "husbygge" ;
  husdjur_nn_1 = mkN "husdjur" neutrum ;
  husesyn_nn_1 = mkN "husesyn" "husesyner" ;
  husfader_nn_1 = mkN "husfader" "husfadern" "husfдder" "husfдderna" ;
  husfoerestaandarinna_nn_1 = mkN "husfцrestеndarinna" ;
  husfoerhoer_nn_1 = mkN "husfцrhцr" neutrum ;
  husfru_nn_1 = mkN "husfru" ;
  husgavel_nn_1 = mkN "husgavel" ;
  husgeraad_nn_1 = mkN "husgerеd" neutrum ;
  husgrund_nn_1 = mkN "husgrund" "husgrunder" ;
  husgud_nn_1 = mkN "husgud" ;
  hushaall_nn_1 = mkN "hushеll" neutrum ;
  hushaallerska_nn_1 = mkN "hushеllerska" ;
  hushaallningssaellskap_nn_1 = mkN "hushеllningssдllskap" "hushеllningssдllskapet" "hushеllningssдllskapen" "hushеllningssдllskapena" ;
  hushaallsassistent_nn_1 = mkN "hushеllsassistent" "hushеllsassistenter" ;
  hushaallsost_nn_1 = mkN "hushеllsost" ;
  hushaallsrulle_nn_1 = mkN "hushеllsrulle" utrum ;
  hushaallsvaag_nn_1 = mkN "hushеllsvеg" ;
  husknut_nn_1 = mkN "husknut" ;
  huskors_nn_1 = mkN "huskors" neutrum ;
  huskropp_nn_1 = mkN "huskropp" ;
  huskur_nn_1 = mkN "huskur" "huskurer" ;
  huslaekare_nn_1 = mkN "huslдkare" "huslдkare" ;
  huslig_av_1 = mkA "huslig" ;
  husmor_nn_1 = mkN "husmoder" "husmodern" "husmцdrar" "husmцdrarna" ;
  husorgan_nn_1 = mkN "husorgan" neutrum ;
  husrannsakning_nn_1 = mkN "husrannsakning" ;
  husse_nn_1 = mkN "husse" utrum ;
  hustimmer_nn_1 = mkN "hustimmer" neutrum ;
  hustomte_nn_1 = mkN "hustomte" utrum ;
  hustru_nn_1 = mkN "hustru" "hustrun" "hustrur" "hustrurna" ;
  hustrutillaegg_nn_1 = mkN "hustrutillдgg" neutrum ;
  hustyrann_nn_1 = mkN "hustyrann" "hustyranner" ;
  husundersoekning_nn_1 = mkN "husundersцkning" ;
  husvagn_nn_1 = mkN "husvagn" ;
  husvill_av_1 = mkA "husvill" ;
  hutch_nn_1 = mkN "hutch" ;
  hutloes_av_1 = mkA "hutlцs" ;
  hutt_nn_1 = mkN "hutt" ;
  huv_nn_1 = mkN "huv" ;
  huvud_nn_1 = mkN "huvud" "huvudet" "huvuden" "huvudena" ;
  huvudaemne_nn_1 = mkN "huvudдmne" ;
  huvudanstalt_nn_1 = mkN "huvudanstalt" "huvudanstalter" ;
  huvudavtal_nn_1 = mkN "huvudavtal" "huvudavtalet" "huvudavtalen" "huvudavtalena" ;
  huvudaxel_nn_1 = mkN "huvudaxel" ;
  huvudbjudning_nn_1 = mkN "huvudbjudning" ;
  huvudbok_nn_1 = mkN "huvudbok" "huvudbцcker" ;
  huvudbonad_nn_1 = mkN "huvudbonad" "huvudbonader" ;
  huvudbyggnad_nn_1 = mkN "huvudbyggnad" "huvudbyggnader" ;
  huvuddel_nn_1 = mkN "huvuddel" "huvuddelen" "huvuddelar" "huvuddelarna" ;
  huvuddrag_nn_1 = mkN "huvuddrag" neutrum ;
  huvudentre_nn_1 = mkN "huvudentrй" "huvudentrйer" ;
  huvudfigur_nn_1 = mkN "huvudfigur" "huvudfigurer" ;
  huvudfoerhandling_nn_1 = mkN "huvudfцrhandling" ;
  huvudform_nn_1 = mkN "huvudform" ;
  huvudfunktion_nn_1 = mkN "huvudfunktion" "huvudfunktioner" ;
  huvudgaerd_nn_1 = mkN "huvudgдrd" "huvudgдrder" ;
  huvudingaang_nn_1 = mkN "huvudingеng" ;
  huvudinkomst_nn_1 = mkN "huvudinkomst" "huvudinkomster" ;
  huvudinnehaall_nn_1 = mkN "huvudinnehеll" neutrum ;
  huvudjaegare_nn_1 = mkN "huvudjдgare" "huvudjдgare" ;
  huvudkontor_nn_1 = mkN "huvudkontor" neutrum ;
  huvudkvarter_nn_1 = mkN "huvudkvarter" "huvudkvarteret" "huvudkvarter" "huvudkvarteren" ;
  huvudlaerare_nn_1 = mkN "huvudlдrare" "huvudlдrare" ;
  huvudlag_nn_1 = mkN "huvudlag" neutrum ;
  huvudled_nn_1 = mkN "huvudled" "huvudleder" ;
  huvudledning_nn_1 = mkN "huvudledning" ;
  huvudlinje_nn_1 = mkN "huvudlinje" "huvudlinjer" ;
  huvudloes_av_1 = mkA "huvudlцs" ;
  huvudman_nn_1 = mkN "huvudman" "huvudmannen" "huvudmдn" "huvudmдnnen" ;
  huvudmoment_nn_1 = mkN "huvudmoment" neutrum ;
  huvudnaering_nn_1 = mkN "huvudnдring" ;
  huvudnyckel_nn_1 = mkN "huvudnyckel" ;
  huvudord_nn_1 = mkN "huvudord" neutrum ;
  huvudorsak_nn_1 = mkN "huvudorsak" "huvudorsaker" ;
  huvudperson_nn_1 = mkN "huvudperson" "huvudpersoner" ;
  huvudpunkt_nn_1 = mkN "huvudpunkt" "huvudpunkter" ;
  huvudraett_nn_1 = mkN "huvudrдtt" "huvudrдtter" ;
  huvudregel_nn_1 = mkN "huvudregel" "huvudregeln" "huvudregler" "huvudreglerna" ;
  huvudroll_nn_1 = mkN "huvudroll" "huvudroller" ;
  huvudrollsinnehavare_nn_1 = mkN "huvudrollsinnehavare" "huvudrollsinnehavare" ;
  huvudsak_nn_1 = mkN "huvudsak" "huvudsaker" ;
  huvudsaklig_av_1 = mkA "huvudsaklig" ;
  huvudsakligen_ab_1 = mkAdv "huvudsakligen" ;
  huvudsats_nn_1 = mkN "huvudsats" "huvudsatser" ;
  huvudskaal_nn_1 = mkN "huvudskеl" ;
  huvudskael_nn_1 = mkN "huvudskдl" neutrum ;
  huvudskakning_nn_1 = mkN "huvudskakning" ;
  huvudstad_nn_1 = mkN "huvudstad" "huvudstдder" ;
  huvudstol_nn_1 = mkN "huvudstol" ;
  huvudstroembrytare_nn_1 = mkN "huvudstrцmbrytare" "huvudstrцmbrytare" ;
  huvudstupa_ab_1 = mkAdv "huvudstupa" ;
  huvudsvaal_nn_1 = mkN "huvudsvеl" ;
  huvudtema_nn_1 = mkN "huvudtema" "huvudtemat" "huvudteman" "huvudtemana" ;
  huvudtitel_nn_1 = mkN "huvudtitel" ;
  huvudton_nn_1 = mkN "huvudton" "huvudtoner" ;
  huvuduppgift_nn_1 = mkN "huvuduppgift" "huvuduppgifter" ;
  huvudverb_nn_1 = mkN "huvudverb" neutrum ;
  huvudvittne_nn_1 = mkN "huvudvittne" ;
  hyacint_nn_1 = mkN "hyacint" "hyacinter" ;
  hybrid_nn_1 = mkN "hybrid" "hybrider" ;
  hycklare_nn_1 = mkN "hycklare" "hycklare" ;
  hyckleri_nn_1 = mkN "hyckleri" "hycklerit" "hycklerier" "hycklerierna" ;
  hydrat_nn_1 = mkN "hydrat" neutrum ;
  hydraulisk_av_1 = mkA "hydraulisk" ;
  hydrodynamisk_av_1 = mkA "hydrodynamisk" ;
  hydrofob_av_1 = mkA "hydrofob" ;
  hydrofon_nn_1 = mkN "hydrofon" "hydrofoner" ;
  hydrofor_nn_1 = mkN "hydrofor" "hydroforen" "hydroforer" "hydroforerna" ;
  hydrofyt_nn_1 = mkN "hydrofyt" "hydrofyter" ;
  hydrokopter_nn_1 = mkN "hydrokopter" ;
  hydrokultur_nn_1 = mkN "hydrokultur" "hydrokulturer" ;
  hydrolog_nn_1 = mkN "hydrolog" "hydrologer" ;
  hydrologisk_av_1 = mkA "hydrologisk" ;
  hydrolys_nn_1 = mkN "hydrolys" "hydrolyser" ;
  hydroplan_nn_1 = mkN "hydroplan" neutrum ;
  hydrostatisk_av_1 = mkA "hydrostatisk" ;
  hydroxid_nn_1 = mkN "hydroxid" "hydroxider" ;
  hydroxidjon_nn_1 = mkN "hydroxidjon" "hydroxidjoner" ;
  hyende_nn_1 = mkN "hyende" ;
  hyf_nn_1 = mkN "hyf" "hyfer" ;
  hygge_nn_1 = mkN "hygge" ;
  hyggesbraenning_nn_1 = mkN "hyggesbrдnning" ;
  hygglig_av_1 = mkA "hygglig" ;
  hygglo_nn_1 = mkN "hygglo" "hygglot" "hygglon" "hygglona" ;
  hygienisk_av_1 = mkA "hygienisk" ;
  hygienist_nn_1 = mkN "hygienist" "hygienister" ;
  hygrograf_nn_1 = mkN "hygrograf" "hygrografer" ;
  hygrometer_nn_1 = mkN "hygrometer" ;
  hygroskopisk_av_1 = mkA "hygroskopisk" ;
  hyllmeter_nn_1 = mkN "hyllmeter" ;
  hyllning_nn_1 = mkN "hyllning" ;
  hyllningsdikt_nn_1 = mkN "hyllningsdikt" "hyllningsdikter" ;
  hyllningssaang_nn_1 = mkN "hyllningssеng" "hyllningssеnger" ;
  hymn_nn_1 = mkN "hymn" "hymner" ;
  hyperbel_nn_1 = mkN "hyperbel" "hyperbeln" "hyperbler" "hyperblerna" ;
  hyperbol_nn_1 = mkN "hyperbol" "hyperboler" ;
  hyperbolisk_av_1 = mkA "hyperbolisk" ;
  hyperbore_nn_1 = mkN "hyperborй" "hyperborйer" ;
  hyperit_nn_1 = mkN "hyperit" "hyperiter" ;
  hyperkaenslig_av_1 = mkA "hyperkдnslig" ;
  hyperkatalektisk_av_1 = mkA "hyperkatalektisk" ;
  hyperkorrekt_av_1 = mkA "hyperkorrekt" "hyperkorrekt" ;
  hypermodern_av_1 = mkA "hypermodern" ;
  hypersvecism_nn_1 = mkN "hypersvecism" "hypersvecismer" ;
  hypertrofi_nn_1 = mkN "hypertrofi" "hypertrofier" ;
  hypnos_nn_1 = mkN "hypnos" "hypnoser" ;
  hypnotisk_av_1 = mkA "hypnotisk" ;
  hypnotisoer_nn_1 = mkN "hypnotisцr" "hypnotisцrer" ;
  hypofys_nn_1 = mkN "hypofys" "hypofyser" ;
  hypofyshormon_nn_1 = mkN "hypofyshormon" neutrum ;
  hypokonder_nn_1 = mkN "hypokonder" "hypokondern" "hypokondrer" "hypokondrerna" ;
  hypokondri_nn_1 = mkN "hypokondri" "hypokondrier" ;
  hypokondriker_nn_1 = mkN "hypokondriker" "hypokondrikern" "hypokondriker" "hypokondrikerna" ;
  hypokondrisk_av_1 = mkA "hypokondrisk" ;
  hypokrit_nn_1 = mkN "hypokrit" "hypokriter" ;
  hypokritisk_av_1 = mkA "hypokritisk" ;
  hypotaktisk_av_1 = mkA "hypotaktisk" ;
  hypotek_nn_1 = mkN "hypotek" neutrum ;
  hypotekslaan_nn_1 = mkN "hypotekslеn" neutrum ;
  hypotes_nn_1 = mkN "hypotes" "hypoteser" ;
  hypotetisk_av_1 = mkA "hypotetisk" ;
  hypsometer_nn_1 = mkN "hypsometer" ;
  hyresgaest_nn_1 = mkN "hyresgдst" "hyresgдster" ;
  hyreshaj_nn_1 = mkN "hyreshaj" ;
  hyreshus_nn_1 = mkN "hyreshus" neutrum ;
  hyreskasern_nn_1 = mkN "hyreskasern" "hyreskaserner" ;
  hyreskontrakt_nn_1 = mkN "hyreskontrakt" neutrum ;
  hyreslaegenhet_nn_1 = mkN "hyreslдgenhet" "hyreslдgenheter" ;
  hyresnaemnd_nn_1 = mkN "hyresnдmnd" "hyresnдmnder" ;
  hyresreglering_nn_1 = mkN "hyresreglering" ;
  hyrestillaegg_nn_1 = mkN "hyrestillдgg" neutrum ;
  hyrestvist_nn_1 = mkN "hyrestvist" "hyrestvister" ;
  hyresvaerd_nn_1 = mkN "hyresvдrd" ;
  hyss_nn_1 = mkN "hyss" neutrum ;
  hysteriker_nn_1 = mkN "hysteriker" "hysterikern" "hysteriker" "hysterikerna" ;
  hysterisk_av_1 = mkA "hysterisk" ;
  hytt_nn_1 = mkN "hytt" "hytter" ;
  hyvel_nn_1 = mkN "hyvel" ;
  hyvelbaenk_nn_1 = mkN "hyvelbдnk" ;
  hyveljaern_nn_1 = mkN "hyveljдrn" neutrum ;
  hyvelspaan_nn_1 = mkN "hyvelspеn" neutrum ;
  hyvelstaal_nn_1 = mkN "hyvelstеl" neutrum ;
  hyvens_av_1 = mkA "hyvens" ;
  i_ab_1 = mkAdv "i" ;
  i_land_nn_1 = mkN "i-land" "i-landet" "i-lдnder" "i-lдnderna" ;
  iaktta_vb_1 = mkV "iaktta" "iakttar" "iaktta" "iakttog" "iakttagit" "iakttagen" ;
  iakttagare_nn_1 = mkN "iakttagare" "iakttagare" ;
  iakttagelse_nn_1 = mkN "iakttagelse" "iakttagelser" ;
  iberisk_av_1 = mkA "iberisk" ;
  ibero_amerikansk_av_1 = mkA "ibero-amerikansk" ;
  ibidem_ab_1 = mkAdv "ibidem" ;
  ibis_nn_1 = mkN "ibis" ;
  ibisfaagel_nn_1 = mkN "ibisfеgel" ;
  ibland_ab_1 = mkAdv "ibland" ;
  icing_nn_1 = mkN "icing" ;
  icke_ab_1 = mkAdv "icke" ;
  icke_angreppspakt_nn_1 = mkN "icke-angreppspakt" "icke-angreppspakter" ;
  icke_darwinistisk_av_1 = mkA "icke-darwinistisk" ;
  icke_euklidisk_av_1 = mkA "icke-euklidisk" ;
  icke_existerande_av_1 = mkA "icke-existerande" ;
  icke_haendelse_nn_1 = mkN "icke-hдndelse" "icke-hдndelser" ;
  icke_individuell_av_1 = mkA "icke-individuell" ;
  icke_kristen_av_1 = mkA "icke-kristen" "icke-kristet" ;
  icke_linjaer_av_1 = mkA "icke-linjдr" ;
  icke_metall_nn_1 = mkN "icke-metall" "icke-metaller" ;
  icke_periodisk_av_1 = mkA "icke-periodisk" ;
  icke_spridningsavtal_nn_1 = mkN "icke-spridningsavtal" "icke-spridningsavtalet" "icke-spridningsavtalen" "icke-spridningsavtalena" ;
  icke_symmetrisk_av_1 = mkA "icke-symmetrisk" ;
  id_nn_1 = mkN "id" ;
  idag_ab_1 = mkAdv "idag" ;
  ide_nn_1 = mkN "idй" "idйer" ;
  ideal_av_1 = mkA "ideal" ;
  ideal_nn_1 = mkN "ideal" neutrum ;
  idealisering_nn_1 = mkN "idealisering" ;
  idealisk_av_1 = mkA "idealisk" ;
  idealist_nn_1 = mkN "idealist" "idealister" ;
  idealistisk_av_1 = mkA "idealistisk" ;
  idealitet_nn_1 = mkN "idealitet" "idealiteter" ;
  idealvaerld_nn_1 = mkN "idealvдrld" ;
  ideassociation_nn_1 = mkN "idйassociation" "idйassociationer" ;
  idedrama_nn_1 = mkN "idйdrama" "idйdramat" "idйdraman" "idйdramana" ;
  ideell_av_1 = mkA "ideell" ;
  idegivare_nn_1 = mkN "idйgivare" "idйgivare" ;
  idegran_nn_1 = mkN "idegran" ;
  ideklaeckning_nn_1 = mkN "idйklдckning" ;
  idel_ab_1 = mkAdv "idel" ;
  idelig_av_1 = mkA "idelig" ;
  ideligen_ab_1 = mkAdv "ideligen" ;
  idemoete_nn_1 = mkN "idйmцte" ;
  identifiering_nn_1 = mkN "identifiering" ;
  identifikation_nn_1 = mkN "identifikation" "identifikationer" ;
  identisk_av_1 = mkA "identisk" ;
  identitet_nn_1 = mkN "identitet" "identiteter" ;
  identitetskort_nn_1 = mkN "identitetskort" neutrum ;
  ideografisk_av_1 = mkA "ideografisk" ;
  ideogram_nn_1 = mkN "ideogram" "ideogrammet" "ideogram" "ideogrammen" ;
  ideolog_nn_1 = mkN "ideolog" "ideologer" ;
  ideologi_nn_1 = mkN "ideologi" "ideologier" ;
  ideologisk_av_1 = mkA "ideologisk" ;
  iderik_av_1 = mkA "idйrik" ;
  idevaerld_nn_1 = mkN "idйvдrld" ;
  idiolekt_nn_1 = mkN "idiolekt" "idiolekter" ;
  idiom_nn_1 = mkN "idiom" neutrum ;
  idiomatisk_av_1 = mkA "idiomatisk" ;
  idiopatisk_av_1 = mkA "idiopatisk" ;
  idiosynkrasi_nn_1 = mkN "idiosynkrasi" "idiosynkrasier" ;
  idiot_nn_1 = mkN "idiot" "idioter" ;
  idioti_nn_1 = mkN "idioti" "idiotier" ;
  idiotisk_av_1 = mkA "idiotisk" ;
  idiotsaeker_av_1 = mkA "idiotsдker" "idiotsдkert" "idiotsдkra" "idiotsдkra" "idiotsдkrare" "idiotsдkrast" "idiotsдkraste" ;
  idisslare_nn_1 = mkN "idisslare" "idisslare" ;
  idkare_nn_1 = mkN "idkare" "idkare" ;
  idog_av_1 = mkA "idog" ;
  idol_nn_1 = mkN "idol" "idoler" ;
  idrott_nn_1 = mkN "idrott" "idrotter" ;
  idrottsdag_nn_1 = mkN "idrottsdag" ;
  idrottsdraekt_nn_1 = mkN "idrottsdrдkt" "idrottsdrдkter" ;
  idrottsfoerening_nn_1 = mkN "idrottsfцrening" ;
  idrottsgren_nn_1 = mkN "idrottsgren" "idrottsgrenen" "idrottsgrenar" "idrottsgrenarna" ;
  idrottsgymnasium_nn_1 = mkN "idrottsgymnasium" "idrottsgymnasiet" "idrottsgymnasier" "idrottsgymnasierna" ;
  idrottshall_nn_1 = mkN "idrottshall" ;
  idrottsklubb_nn_1 = mkN "idrottsklubb" ;
  idrottskompani_nn_1 = mkN "idrottskompani" "idrottskompanit" "idrottskompanier" "idrottskompanierna" ;
  idrottskvinna_nn_1 = mkN "idrottskvinna" ;
  idrottslig_av_1 = mkA "idrottslig" ;
  idrottsman_nn_1 = mkN "idrottsman" "idrottsmannen" "idrottsmдn" "idrottsmдnnen" ;
  idrottsplats_nn_1 = mkN "idrottsplats" "idrottsplatser" ;
  idrottsroerelse_nn_1 = mkN "idrottsrцrelse" "idrottsrцrelser" ;
  idrottssko_nn_1 = mkN "idrottssko" "idrottsskor" ;
  idrottstaevling_nn_1 = mkN "idrottstдvling" ;
  idyll_nn_1 = mkN "idyll" "idyller" ;
  idylliker_nn_1 = mkN "idylliker" "idyllikern" "idylliker" "idyllikerna" ;
  idyllisk_av_1 = mkA "idyllisk" ;
  ifatt_ab_1 = mkAdv "ifatt" ;
  ifjol_ab_1 = mkAdv "ifjol" ;
  ifraaga_ab_1 = mkAdv "ifrеga" ;
  ifraagakomma_vb_1 = mkV "ifrеgakomma" "ifrеgakom" "ifrеgakommit" ;
  ifraagavarande_av_1 = mkA "ifrеgavarande" ;
  ifraan_ab_1 = mkAdv "ifrеn" ;
  ifred_ab_1 = mkAdv "ifred" ;
  ifyllnadsprov_nn_1 = mkN "ifyllnadsprov" neutrum ;
  igaang_ab_1 = mkAdv "igеng" ;
  igaangsaettning_nn_1 = mkN "igеngsдttning" ;
  igaar_ab_1 = mkAdv "igеr" ;
  igel_nn_1 = mkN "igel" ;
  igelkott_nn_1 = mkN "igelkott" ;
  igen_ab_1 = mkAdv "igen" ;
  igengrodd_av_1 = mkA "igengrodd" "igengrodtt" ;
  igenkaennande_av_1 = mkA "igenkдnnande" ;
  igenkaenningstecken_nn_1 = mkN "igenkдnningstecken" "igenkдnningstecknet" "igenkдnningstecken" "igenkдnningstecknen" ;
  igenkaennlig_av_1 = mkA "igenkдnnlig" ;
  igenmulen_av_1 = mkA "igenmulen" "igenmulet" ;
  igenom_ab_1 = mkAdv "igenom" ;
  igenvaext_av_1 = mkA "igenvдxt" "igenvдxt" ;
  igenvuxen_av_1 = mkA "igenvuxen" "igenvuxet" ;
  igloo_nn_1 = mkN "igloo" "igloor" ;
  ignorant_av_1 = mkA "ignorant" "ignorant" ;
  ignorant_nn_1 = mkN "ignorant" "ignoranter" ;
  ihaag_ab_1 = mkAdv "ihеg" ;
  ihaagkomma_vb_1 = mkV "ihеgkomma" "ihеgkom" "ihеgkommit" ;
  ihaalig_av_1 = mkA "ihеlig" ;
  ihaalighet_nn_1 = mkN "ihеlighet" "ihеligheter" ;
  ihaallande_av_1 = mkA "ihеllande" ;
  ihaerdig_av_1 = mkA "ihдrdig" ;
  ihjael_ab_1 = mkAdv "ihjдl" ;
  ihop_ab_1 = mkAdv "ihop" ;
  ikapp_ab_1 = mkAdv "ikapp" ;
  ikon_nn_1 = mkN "ikon" "ikoner" ;
  ikonostas_nn_1 = mkN "ikonostas" "ikonostaser" ;
  ikosaeder_nn_1 = mkN "ikosaeder" ;
  ikraft_ab_1 = mkAdv "ikraft" ;
  iktus_nn_1 = mkN "iktus" "iktusen" "iktus" "iktusen" ;
  iktyolog_nn_1 = mkN "iktyolog" "iktyologer" ;
  iktyologisk_av_1 = mkA "iktyologisk" ;
  ikull_ab_1 = mkAdv "ikull" ;
  ikvaell_ab_1 = mkAdv "ikvдll" ;
  il_nn_1 = mkN "il" ;
  iland_ab_1 = mkAdv "iland" ;
  ilbud_nn_1 = mkN "ilbud" neutrum ;
  ilex_nn_1 = mkN "ilex" ;
  illa_ab_1 = mkAdv "illa" ;
  illaluktande_av_1 = mkA "illaluktande" ;
  illamaaende_av_1 = mkA "illamеende" ;
  illande_ab_1 = mkAdv "illande" ;
  illasmakande_av_1 = mkA "illasmakande" ;
  illavarslande_av_1 = mkA "illavarslande" ;
  illavulen_av_1 = mkA "illavulen" "illavulet" ;
  illbatting_nn_1 = mkN "illbatting" ;
  illdaad_nn_1 = mkN "illdеd" neutrum ;
  illegal_av_1 = mkA "illegal" ;
  illegitim_av_1 = mkA "illegitim" ;
  iller_nn_1 = mkN "iller" ;
  illfundig_av_1 = mkA "illfundig" ;
  illgaerning_nn_1 = mkN "illgдrning" ;
  illistig_av_1 = mkA "illistig" ;
  illitterat_av_1 = mkA "illitterat" "illitterat" ;
  illmarig_av_1 = mkA "illmarig" ;
  illojal_av_1 = mkA "illojal" ;
  illparig_av_1 = mkA "illparig" ;
  illroed_av_1 = mkA "illrцd" ;
  illtjut_nn_1 = mkN "illtjut" neutrum ;
  illumination_nn_1 = mkN "illumination" "illuminationer" ;
  illusion_nn_1 = mkN "illusion" "illusioner" ;
  illusionist_nn_1 = mkN "illusionist" "illusionister" ;
  illusionsfri_av_1 = mkA "illusionsfri" "illusionsfritt" ;
  illusionsloes_av_1 = mkA "illusionslцs" ;
  illusionsnummer_nn_1 = mkN "illusionsnummer" neutrum ;
  illusorisk_av_1 = mkA "illusorisk" ;
  illuster_av_1 = mkA "illuster" "illustert" "illustra" "illustra" "illustrare" "illustrast" "illustraste" ;
  illustration_nn_1 = mkN "illustration" "illustrationer" ;
  illustrativ_av_1 = mkA "illustrativ" ;
  illustratoer_nn_1 = mkN "illustratцr" "illustratцrer" ;
  illvillig_av_1 = mkA "illvillig" ;
  illvraal_nn_1 = mkN "illvrеl" neutrum ;
  illyr_nn_1 = mkN "illyr" "illyrer" ;
  illyrisk_av_1 = mkA "illyrisk" ;
  ilmarsch_nn_1 = mkN "ilmarsch" "ilmarscher" ;
  ilning_nn_1 = mkN "ilning" ;
  ilsamtal_nn_1 = mkN "ilsamtal" "ilsamtalet" "ilsamtalen" "ilsamtalena" ;
  ilsk_av_1 = mkA "ilsk" ;
  ilsken_av_1 = mkA "ilsken" "ilsket" ;
  imaginaer_av_1 = mkA "imaginдr" ;
  imbecill_av_1 = mkA "imbecill" ;
  imitation_nn_1 = mkN "imitation" "imitationer" ;
  imitatoer_nn_1 = mkN "imitatцr" "imitatцrer" ;
  immanent_av_1 = mkA "immanent" "immanent" ;
  immateriell_av_1 = mkA "immateriell" ;
  immatrikulation_nn_1 = mkN "immatrikulation" "immatrikulationer" ;
  immig_av_1 = mkA "immig" ;
  immigrant_nn_1 = mkN "immigrant" "immigranter" ;
  immobil_av_1 = mkA "immobil" ;
  immun_av_1 = mkA "immun" ;
  immunitet_nn_1 = mkN "immunitet" "immuniteter" ;
  immunolog_nn_1 = mkN "immunolog" "immunologer" ;
  immunologisk_av_1 = mkA "immunologisk" ;
  impediment_nn_1 = mkN "impediment" "impedimentet" "impedimenten" "impedimentena" ;
  imperativ_nn_1 = mkN "imperativ" "imperativer" ;
  imperativ_nn_2 = mkN "imperativ" neutrum ;
  imperativisk_av_1 = mkA "imperativisk" ;
  imperator_nn_1 = mkN "imperator" "imperatorer" ;
  imperatorisk_av_1 = mkA "imperatorisk" ;
  imperfektum_nn_1 = mkN "imperfektum" "imperfektet" "imperfekter" "imperfekterna" ;
  imperialformat_nn_1 = mkN "imperialformat" neutrum ;
  imperialist_nn_1 = mkN "imperialist" "imperialister" ;
  imperialistisk_av_1 = mkA "imperialistisk" ;
  imperialoktav_nn_1 = mkN "imperialoktav" "imperialoktaver" ;
  imperialsaeng_nn_1 = mkN "imperialsдng" ;
  imperium_nn_1 = mkN "imperium" "imperiet" "imperier" "imperierna" ;
  impertinens_nn_1 = mkN "impertinens" "impertinenser" ;
  impertinent_av_1 = mkA "impertinent" "impertinent" ;
  implicit_av_1 = mkA "implicit" "implicit" ;
  implikation_nn_1 = mkN "implikation" "implikationer" ;
  implosion_nn_1 = mkN "implosion" "implosioner" ;
  imponderabilia_nn_1 = mkN "imponderabilia" "imponderabilian" "imponderabilia" "imponderabiliana" ;
  imponerande_av_1 = mkA "imponerande" ;
  impopulaer_av_1 = mkA "impopulдr" ;
  impopularitet_nn_1 = mkN "impopularitet" "impopulariteter" ;
  import_nn_1 = mkN "import" "importer" ;
  importavgift_nn_1 = mkN "importavgift" "importavgifter" ;
  importfoerbud_nn_1 = mkN "importfцrbud" neutrum ;
  importkvot_nn_1 = mkN "importkvot" "importkvoter" ;
  importoer_nn_1 = mkN "importцr" "importцrer" ;
  imposant_av_1 = mkA "imposant" "imposant" ;
  impost_nn_1 = mkN "impost" "imposter" ;
  impotent_av_1 = mkA "impotent" "impotent" ;
  impregnering_nn_1 = mkN "impregnering" ;
  impressario_nn_1 = mkN "impressario" "impressarion" "impressarier" "impressarierna" ;
  impressionist_nn_1 = mkN "impressionist" "impressionister" ;
  impressionistisk_av_1 = mkA "impressionistisk" ;
  improduktiv_av_1 = mkA "improduktiv" ;
  impromptu_nn_1 = mkN "impromptu" "impromptut" "impromptun" "impromptuna" ;
  improvisation_nn_1 = mkN "improvisation" "improvisationer" ;
  improvisatoer_nn_1 = mkN "improvisatцr" "improvisatцrer" ;
  improvisatorisk_av_1 = mkA "improvisatorisk" ;
  impuls_nn_1 = mkN "impuls" "impulser" ;
  impulsiv_av_1 = mkA "impulsiv" ;
  impulsivitet_nn_1 = mkN "impulsivitet" "impulsiviteter" ;
  impulskoep_nn_1 = mkN "impulskцp" neutrum ;
  imroer_nn_1 = mkN "imrцr" neutrum ;
  in_ab_1 = mkAdv "in" ;
  inaat_ab_1 = mkAdv "inеt" ;
  inaatvaend_av_1 = mkA "inеtvдnd" ;
  inackordering_nn_1 = mkN "inackordering" ;
  inackorderingshem_nn_1 = mkN "inackorderingshem" "inackorderingshemmet" "inackorderingshem" "inackorderingshemmen" ;
  inadekvat_av_1 = mkA "inadekvat" "inadekvat" ;
  inadvertens_nn_1 = mkN "inadvertens" "inadvertenser" ;
  inaega_nn_1 = mkN "inдga" ;
  inaelvsmask_nn_1 = mkN "inдlvsmask" ;
  inaktiv_av_1 = mkA "inaktiv" ;
  inaktivitet_nn_1 = mkN "inaktivitet" "inaktiviteter" ;
  inaktuell_av_1 = mkA "inaktuell" ;
  inalles_ab_1 = mkAdv "inalles" ;
  inandning_nn_1 = mkN "inandning" ;
  inauguration_nn_1 = mkN "inauguration" "inaugurationer" ;
  inbegrepp_nn_1 = mkN "inbegrepp" neutrum ;
  inbegripa_vb_1 = mkV "inbegripa" "inbegrep" "inbegripit" ;
  inbegripen_av_1 = mkA "inbegripen" "inbegripet" ;
  inbesparing_nn_1 = mkN "inbesparing" ;
  inbetalning_nn_1 = mkN "inbetalning" ;
  inbetalningskort_nn_1 = mkN "inbetalningskort" neutrum ;
  inbillning_nn_1 = mkN "inbillning" ;
  inbillningsfoster_nn_1 = mkN "inbillningsfoster" neutrum ;
  inbillningssjuk_av_1 = mkA "inbillningssjuk" ;
  inbilsk_av_1 = mkA "inbilsk" ;
  inbiten_av_1 = mkA "inbiten" "inbitet" ;
  inbjuda_vb_1 = mkV "inbjuda" "inbjцd" "inbjudit" ;
  inbjudande_av_1 = mkA "inbjudande" ;
  inbjudning_nn_1 = mkN "inbjudning" ;
  inbjudningskort_nn_1 = mkN "inbjudningskort" neutrum ;
  inbjudningsskrift_nn_1 = mkN "inbjudningsskrift" "inbjudningsskrifter" ;
  inblandning_nn_1 = mkN "inblandning" ;
  inblick_nn_1 = mkN "inblick" ;
  inboerdes_av_1 = mkA "inbцrdes" ;
  inboerdeskrig_nn_1 = mkN "inbцrdeskrig" neutrum ;
  inbokning_nn_1 = mkN "inbokning" ;
  inbringande_av_1 = mkA "inbringande" ;
  inbromsning_nn_1 = mkN "inbromsning" ;
  inbrott_nn_1 = mkN "inbrott" neutrum ;
  inbrottstjuv_nn_1 = mkN "inbrottstjuv" ;
  inbrytning_nn_1 = mkN "inbrytning" ;
  inbuktning_nn_1 = mkN "inbuktning" ;
  inbunden_av_1 = mkA "inbunden" "inbundet" ;
  inbyggare_nn_1 = mkN "inbyggare" "inbyggare" ;
  inbyggd_av_1 = mkA "inbyggd" "inbyggt" ;
  inbyte_nn_1 = mkN "inbyte" ;
  incest_nn_1 = mkN "incest" "incester" ;
  incestuoes_av_1 = mkA "incestuцs" ;
  incident_nn_1 = mkN "incident" "incidenter" ;
  incitament_nn_1 = mkN "incitament" "incitamentet" "incitamenten" "incitamentena" ;
  indefinit_av_1 = mkA "indefinit" "indefinit" ;
  indelning_nn_1 = mkN "indelning" ;
  indelningsgrund_nn_1 = mkN "indelningsgrund" "indelningsgrunder" ;
  indelningsverk_nn_1 = mkN "indelningsverk" neutrum ;
  indelt_av_1 = mkA "indelt" "indelt" ;
  independent_nn_1 = mkN "independent" "independenter" ;
  index_nn_1 = mkN "index" neutrum ;
  indexavtal_nn_1 = mkN "indexavtal" "indexavtalet" "indexavtalen" "indexavtalena" ;
  indian_nn_1 = mkN "indian" "indianer" ;
  indianfolk_nn_1 = mkN "indianfolk" neutrum ;
  indianhoevding_nn_1 = mkN "indianhцvding" ;
  indiankvinna_nn_1 = mkN "indiankvinna" ;
  indianreservat_nn_1 = mkN "indianreservat" neutrum ;
  indiansk_av_1 = mkA "indiansk" ;
  indianska_nn_1 = mkN "indianska" ;
  indiansommar_nn_1 = mkN "indiansommar" "indiansommarn" "indiansommrar" "indiansommrarna" ;
  indianstam_nn_1 = mkN "indianstam" "indianstammen" "indianstammar" "indianstammarna" ;
  indiantjut_nn_1 = mkN "indiantjut" neutrum ;
  indicium_nn_1 = mkN "indicium" "indiciet" "indicier" "indicierna" ;
  indier_nn_1 = mkN "indier" "indiern" "indier" "indierna" ;
  indifferent_av_1 = mkA "indifferent" "indifferent" ;
  indifferentism_nn_1 = mkN "indifferentism" "indifferentismer" ;
  indikation_nn_1 = mkN "indikation" "indikationer" ;
  indikativ_av_1 = mkA "indikativ" ;
  indikativ_nn_1 = mkN "indikativ" "indikativer" ;
  indikator_nn_1 = mkN "indikator" "indikatorer" ;
  indikering_nn_1 = mkN "indikering" ;
  indirekt_av_1 = mkA "indirekt" "indirekt" ;
  indisk_av_1 = mkA "indisk" ;
  indiska_nn_1 = mkN "indiska" ;
  indiskret_av_1 = mkA "indiskret" "indiskret" ;
  indiskretion_nn_1 = mkN "indiskretion" "indiskretioner" ;
  indisponibel_av_1 = mkA "indisponibel" "indisponibelt" "indisponibla" "indisponibla" "indisponiblare" "indisponiblast" "indisponiblaste" ;
  individ_nn_1 = mkN "individ" neutrum ;
  individualist_nn_1 = mkN "individualist" "individualister" ;
  individualistisk_av_1 = mkA "individualistisk" ;
  individualitet_nn_1 = mkN "individualitet" "individualiteter" ;
  individuell_av_1 = mkA "individuell" ;
  indoeurope_nn_1 = mkN "indoeuropй" "indoeuropйer" ;
  indoeuropeisk_av_1 = mkA "indoeuropeisk" ;
  indokinesisk_av_1 = mkA "indokinesisk" ;
  indoktrinering_nn_1 = mkN "indoktrinering" ;
  indolent_av_1 = mkA "indolent" "indolent" ;
  indolog_nn_1 = mkN "indolog" "indologer" ;
  indones_nn_1 = mkN "indones" "indoneser" ;
  indonesisk_av_1 = mkA "indonesisk" ;
  indra_vb_1 = mkV "indra" "indrar" "indra" "indrog" "indragit" "indragen" ;
  indraektig_av_1 = mkA "indrдktig" ;
  indrag_nn_1 = mkN "indrag" neutrum ;
  indragning_nn_1 = mkN "indragning" ;
  indriva_vb_1 = mkV "indriva" "indrev" "indrivit" ;
  indrivning_nn_1 = mkN "indrivning" ;
  induktion_nn_1 = mkN "induktion" "induktioner" ;
  induktionsapparat_nn_1 = mkN "induktionsapparat" "induktionsapparater" ;
  induktionsspole_nn_1 = mkN "induktionsspole" utrum ;
  induktiv_av_1 = mkA "induktiv" ;
  induktor_nn_1 = mkN "induktor" "induktorer" ;
  industri_nn_1 = mkN "industri" "industrier" ;
  industriaktie_nn_1 = mkN "industriaktie" "industriaktier" ;
  industrialisering_nn_1 = mkN "industrialisering" ;
  industriarbetare_nn_1 = mkN "industriarbetare" "industriarbetare" ;
  industriell_av_1 = mkA "industriell" ;
  industrifoerbund_nn_1 = mkN "industrifцrbund" neutrum ;
  industriland_nn_1 = mkN "industriland" "industrilandet" "industrilдnder" "industrilдnderna" ;
  industriolja_nn_1 = mkN "industriolja" ;
  industriomraade_nn_1 = mkN "industriomrеde" ;
  industriprodukt_nn_1 = mkN "industriprodukt" "industriprodukter" ;
  industriregion_nn_1 = mkN "industriregion" "industriregioner" ;
  industrirobot_nn_1 = mkN "industrirobot" ;
  industrisemester_nn_1 = mkN "industrisemester" ;
  ineffektiv_av_1 = mkA "ineffektiv" ;
  inexakt_av_1 = mkA "inexakt" "inexakt" ;
  infall_nn_1 = mkN "infall" neutrum ;
  infalla_vb_1 = mkV "infalla" "infцll" "infallit" ;
  infallen_av_1 = mkA "infallen" "infallet" ;
  infallsrik_av_1 = mkA "infallsrik" ;
  infallsvinkel_nn_1 = mkN "infallsvinkel" ;
  infam_av_1 = mkA "infam" ;
  infami_nn_1 = mkN "infami" "infamier" ;
  infant_nn_1 = mkN "infant" "infanter" ;
  infanterikompani_nn_1 = mkN "infanterikompani" "infanterikompanit" "infanterikompanier" "infanterikompanierna" ;
  infanterist_nn_1 = mkN "infanterist" "infanterister" ;
  infantil_av_1 = mkA "infantil" ;
  infantinna_nn_1 = mkN "infantinna" ;
  infarkt_nn_1 = mkN "infarkt" "infarkter" ;
  infart_nn_1 = mkN "infart" "infarter" ;
  infartsled_nn_1 = mkN "infartsled" "infartsleder" ;
  infartsport_nn_1 = mkN "infartsport" ;
  infattning_nn_1 = mkN "infattning" ;
  infektioes_av_1 = mkA "infektiцs" ;
  infektion_nn_1 = mkN "infektion" "infektioner" ;
  infektionshaerd_nn_1 = mkN "infektionshдrd" ;
  infektionssjukdom_nn_1 = mkN "infektionssjukdom" ;
  infernalisk_av_1 = mkA "infernalisk" ;
  inferno_nn_1 = mkN "inferno" "infernot" "infernon" "infernona" ;
  infiltration_nn_1 = mkN "infiltration" "infiltrationer" ;
  infiltratoer_nn_1 = mkN "infiltratцr" "infiltratцrer" ;
  infinit_av_1 = mkA "infinit" "infinit" ;
  infinitiv_nn_1 = mkN "infinitiv" "infinitiver" ;
  infinitivmaerke_nn_1 = mkN "infinitivmдrke" ;
  infinna_vb_1 = mkV "infinna" "infann" "infunnit" ;
  infix_nn_1 = mkN "infix" neutrum ;
  inflammation_nn_1 = mkN "inflammation" "inflammationer" ;
  inflammationshaerd_nn_1 = mkN "inflammationshдrd" ;
  inflammatorisk_av_1 = mkA "inflammatorisk" ;
  inflationistisk_av_1 = mkA "inflationistisk" ;
  inflationsdrivande_av_1 = mkA "inflationsdrivande" ;
  inflationsfas_nn_1 = mkN "inflationsfas" "inflationsfaser" ;
  inflationsmodell_nn_1 = mkN "inflationsmodell" "inflationsmodeller" ;
  inflationsskydd_nn_1 = mkN "inflationsskydd" neutrum ;
  inflationsspiral_nn_1 = mkN "inflationsspiral" "inflationsspiraler" ;
  inflationstakt_nn_1 = mkN "inflationstakt" "inflationstakter" ;
  inflationsteori_nn_1 = mkN "inflationsteori" "inflationsteorier" ;
  inflatorisk_av_1 = mkA "inflatorisk" ;
  influens_nn_1 = mkN "influens" "influenser" ;
  influensmaskin_nn_1 = mkN "influensmaskin" "influensmaskiner" ;
  inflygning_nn_1 = mkN "inflygning" ;
  inflyta_vb_1 = mkV "inflyta" "inflцt" "influtit" ;
  inflytande_nn_1 = mkN "inflytande" ;
  inflytelse_nn_1 = mkN "inflytelse" "inflytelser" ;
  inflytelserik_av_1 = mkA "inflytelserik" ;
  inflyttning_nn_1 = mkN "inflyttning" ;
  infoedd_av_1 = mkA "infцdd" ;
  infoeding_nn_1 = mkN "infцding" ;
  infoerande_nn_1 = mkN "infцrande" ;
  infoerstaadd_av_1 = mkA "infцrstеdd" "infцrstеdtt" ;
  infordring_nn_1 = mkN "infordring" ;
  informant_nn_1 = mkN "informant" "informanter" ;
  information_nn_1 = mkN "information" "informationer" ;
  informationsbehandling_nn_1 = mkN "informationsbehandling" ;
  informationsbyraa_nn_1 = mkN "informationsbyrе" "informationsbyrеer" ;
  informationsrik_av_1 = mkA "informationsrik" ;
  informationssoekning_nn_1 = mkN "informationssцkning" ;
  informativ_av_1 = mkA "informativ" ;
  informatoer_nn_1 = mkN "informatцr" "informatцrer" ;
  informator_nn_1 = mkN "informator" "informatorer" ;
  informell_av_1 = mkA "informell" ;
  infragrill_nn_1 = mkN "infragrill" ;
  infraljud_nn_1 = mkN "infraljud" neutrum ;
  infraroed_av_1 = mkA "infrarцd" ;
  infrastruktur_nn_1 = mkN "infrastruktur" "infrastrukturer" ;
  infrusen_av_1 = mkA "infrusen" "infruset" ;
  infusion_nn_1 = mkN "infusion" "infusioner" ;
  infusionsdjur_nn_1 = mkN "infusionsdjur" neutrum ;
  ingaa_vb_1 = mkV "ingе" "ingеr" "ingе" "ingick" "ingеtt" "ingеngen" ;
  ingaaende_av_1 = mkA "ingеende" ;
  ingaang_nn_1 = mkN "ingеng" ;
  ingaangsmarsch_nn_1 = mkN "ingеngsmarsch" "ingеngsmarscher" ;
  ingaangspsalm_nn_1 = mkN "ingеngspsalm" "ingеngspsalmer" ;
  ingaeld_nn_1 = mkN "ingдld" "ingдlder" ;
  ingalunda_ab_1 = mkAdv "ingalunda" ;
  inge_vb_1 = mkV "inge" "inger" "inge" "ingav" "ingett" "ingiven" ;
  ingefaersvaext_nn_1 = mkN "ingefдrsvдxt" "ingefдrsvдxter" ;
  ingenium_nn_1 = mkN "ingenium" "ingeniet" "ingenier" "ingenierna" ;
  ingenjoer_nn_1 = mkN "ingenjцr" "ingenjцrer" ;
  ingenjoerstrupp_nn_1 = mkN "ingenjцrstrupp" "ingenjцrstrupper" ;
  ingenjoersvetenskap_nn_1 = mkN "ingenjцrsvetenskap" "ingenjцrsvetenskaper" ;
  ingenjoersvetenskapsakademi_nn_1 = mkN "ingenjцrsvetenskapsakademi" "ingenjцrsvetenskapsakademier" ;
  ingenstaedes_ab_1 = mkAdv "ingenstдdes" ;
  ingenstans_ab_1 = mkAdv "ingenstans" ;
  ingenvart_ab_1 = mkAdv "ingenvart" ;
  ingeny_nn_1 = mkN "ingeny" "ingenyer" ;
  ingift_av_1 = mkA "ingift" "ingift" ;
  ingifte_nn_1 = mkN "ingifte" ;
  ingivelse_nn_1 = mkN "ingivelse" "ingivelser" ;
  ingjuta_vb_1 = mkV "ingjuta" "ingцt" "ingjutit" ;
  ingoet_nn_1 = mkN "ingцt" neutrum ;
  ingrediens_nn_1 = mkN "ingrediens" "ingredienser" ;
  ingredierande_av_1 = mkA "ingredierande" ;
  ingrepp_nn_1 = mkN "ingrepp" neutrum ;
  ingress_nn_1 = mkN "ingress" "ingresser" ;
  ingripande_nn_1 = mkN "ingripande" ;
  ingrodd_av_1 = mkA "ingrodd" "ingrodtt" ;
  inhaegnad_nn_1 = mkN "inhдgnad" "inhдgnader" ;
  inhalation_nn_1 = mkN "inhalation" "inhalationer" ;
  inhalator_nn_1 = mkN "inhalator" "inhalatorer" ;
  inhamn_nn_1 = mkN "inhamn" ;
  inhav_nn_1 = mkN "inhav" neutrum ;
  inhemsk_av_1 = mkA "inhemsk" ;
  inherent_av_1 = mkA "inherent" "inherent" ;
  inhibitor_nn_1 = mkN "inhibitor" "inhibitorer" ;
  inhopp_nn_1 = mkN "inhopp" neutrum ;
  inhoppare_nn_1 = mkN "inhoppare" "inhoppare" ;
  inhuman_av_1 = mkA "inhuman" ;
  inhysing_nn_1 = mkN "inhysing" ;
  inifraan_ab_1 = mkAdv "inifrеn" ;
  initial_av_1 = mkA "initial" ;
  initial_nn_1 = mkN "initial" "initialer" ;
  initialord_nn_1 = mkN "initialord" neutrum ;
  initiation_nn_1 = mkN "initiation" "initiationer" ;
  initiationsrit_nn_1 = mkN "initiationsrit" "initiationsriter" ;
  initiativ_nn_1 = mkN "initiativ" neutrum ;
  initiativrik_av_1 = mkA "initiativrik" ;
  initiativtagare_nn_1 = mkN "initiativtagare" "initiativtagare" ;
  injektion_nn_1 = mkN "injektion" "injektioner" ;
  injektor_nn_1 = mkN "injektor" "injektorer" ;
  injurie_nn_1 = mkN "injurie" "injurier" ;
  ink_nn_1 = mkN "ink" ;
  inka_nn_1 = mkN "inka" ;
  inkaennande_av_1 = mkA "inkдnnande" ;
  inkaindian_nn_1 = mkN "inkaindian" "inkaindianer" ;
  inkallelse_nn_1 = mkN "inkallelse" "inkallelser" ;
  inkallelsebrev_nn_1 = mkN "inkallelsebrev" neutrum ;
  inkallelseorder_nn_1 = mkN "inkallelseorder" ;
  inkapabel_av_1 = mkA "inkapabel" "inkapabelt" "inkapabla" "inkapabla" "inkapablare" "inkapablast" "inkapablaste" ;
  inkapsling_nn_1 = mkN "inkapsling" ;
  inkarnation_nn_1 = mkN "inkarnation" "inkarnationer" ;
  inkast_nn_1 = mkN "inkast" neutrum ;
  inkiett_av_1 = mkA "inkiett" ;
  inklination_nn_1 = mkN "inklination" "inklinationer" ;
  inklinationsnaal_nn_1 = mkN "inklinationsnеl" ;
  inkoativ_av_1 = mkA "inkoativ" ;
  inkoep_nn_1 = mkN "inkцp" neutrum ;
  inkoepare_nn_1 = mkN "inkцpare" "inkцpare" ;
  inkoepsavdelning_nn_1 = mkN "inkцpsavdelning" ;
  inkoepspris_nn_1 = mkN "inkцpspris" neutrum ;
  inkoerd_av_1 = mkA "inkцrd" "inkцrt" ;
  inkoerning_nn_1 = mkN "inkцrning" ;
  inkoerningsperiod_nn_1 = mkN "inkцrningsperiod" "inkцrningsperioder" ;
  inkoersport_nn_1 = mkN "inkцrsport" ;
  inkognito_ab_1 = mkAdv "inkognito" ;
  inkomma_vb_1 = mkV "inkomma" "inkom" "inkommit" ;
  inkommensurabel_av_1 = mkA "inkommensurabel" "inkommensurabelt" "inkommensurabla" "inkommensurabla" "inkommensurablare" "inkommensurablast" "inkommensurablaste" ;
  inkompatibel_av_1 = mkA "inkompatibel" "inkompatibelt" "inkompatibla" "inkompatibla" "inkompatiblare" "inkompatiblast" "inkompatiblaste" ;
  inkompetent_av_1 = mkA "inkompetent" "inkompetent" ;
  inkomst_nn_1 = mkN "inkomst" "inkomster" ;
  inkomstbegrepp_nn_1 = mkN "inkomstbegrepp" neutrum ;
  inkomstberoende_av_1 = mkA "inkomstberoende" ;
  inkomstbeskattning_nn_1 = mkN "inkomstbeskattning" ;
  inkomstbortfall_nn_1 = mkN "inkomstbortfall" neutrum ;
  inkomstbringande_av_1 = mkA "inkomstbringande" ;
  inkomstintervall_nn_1 = mkN "inkomstintervall" neutrum ;
  inkomstkort_nn_1 = mkN "inkomstkort" neutrum ;
  inkomstmaatt_nn_1 = mkN "inkomstmеtt" neutrum ;
  inkomstoekning_nn_1 = mkN "inkomstцkning" ;
  inkomstskatt_nn_1 = mkN "inkomstskatt" "inkomstskatter" ;
  inkomstslag_nn_1 = mkN "inkomstslag" neutrum ;
  inkomsttagare_nn_1 = mkN "inkomsttagare" "inkomsttagare" ;
  inkomsttaxering_nn_1 = mkN "inkomsttaxering" ;
  inkongruens_nn_1 = mkN "inkongruens" "inkongruenser" ;
  inkongruent_av_1 = mkA "inkongruent" "inkongruent" ;
  inkonsekvens_nn_1 = mkN "inkonsekvens" "inkonsekvenser" ;
  inkonsekvent_av_1 = mkA "inkonsekvent" "inkonsekvent" ;
  inkontinent_av_1 = mkA "inkontinent" "inkontinent" ;
  inkorrekt_av_1 = mkA "inkorrekt" "inkorrekt" ;
  inkraektare_nn_1 = mkN "inkrдktare" "inkrдktare" ;
  inkroekt_av_1 = mkA "inkrцkt" "inkrцkt" ;
  inkrustation_nn_1 = mkN "inkrustation" "inkrustationer" ;
  inkubationstid_nn_1 = mkN "inkubationstid" "inkubationstider" ;
  inkunabel_nn_1 = mkN "inkunabel" "inkunabeln" "inkunabler" "inkunablerna" ;
  inkurant_av_1 = mkA "inkurant" "inkurant" ;
  inkvartering_nn_1 = mkN "inkvartering" ;
  inkvisitor_nn_1 = mkN "inkvisitor" "inkvisitorer" ;
  inkvisitorisk_av_1 = mkA "inkvisitorisk" ;
  inlaaning_nn_1 = mkN "inlеning" ;
  inlaegg_nn_1 = mkN "inlдgg" neutrum ;
  inlaeggning_nn_1 = mkN "inlдggning" ;
  inlaemning_nn_1 = mkN "inlдmning" ;
  inlaemningsdag_nn_1 = mkN "inlдmningsdag" ;
  inlaendsk_av_1 = mkA "inlдndsk" ;
  inlaerningsplataa_nn_1 = mkN "inlдrningsplatе" "inlдrningsplatеer" ;
  inlaerningsresultat_nn_1 = mkN "inlдrningsresultat" neutrum ;
  inlaerningsstudio_nn_1 = mkN "inlдrningsstudio" "inlдrningsstudior" ;
  inlaesning_nn_1 = mkN "inlдsning" ;
  inlaest_av_1 = mkA "inlдst" "inlдst" ;
  inlagd_av_1 = mkA "inlagd" "inlagt" ;
  inlandsis_nn_1 = mkN "inlandsis" ;
  inledande_av_1 = mkA "inledande" ;
  inledare_nn_1 = mkN "inledare" "inledare" ;
  inledning_nn_1 = mkN "inledning" ;
  inledningsvis_ab_1 = mkAdv "inledningsvis" ;
  inljud_nn_1 = mkN "inljud" neutrum ;
  inlopp_nn_1 = mkN "inlopp" neutrum ;
  inmaetning_nn_1 = mkN "inmдtning" ;
  inmarsch_nn_1 = mkN "inmarsch" "inmarscher" ;
  inmatning_nn_1 = mkN "inmatning" ;
  inmoenstring_nn_1 = mkN "inmцnstring" ;
  inmutning_nn_1 = mkN "inmutning" ;
  innan_ab_1 = mkAdv "innan" ;
  innandoeme_nn_1 = mkN "innandцme" ;
  innanfoer_ab_1 = mkAdv "innanfцr" ;
  innanhav_nn_1 = mkN "innanhav" neutrum ;
  innanlaar_nn_1 = mkN "innanlеr" neutrum ;
  innanlaesning_nn_1 = mkN "innanlдsning" ;
  innanmaete_nn_1 = mkN "innanmдte" ;
  innantill_ab_1 = mkAdv "innantill" ;
  inne_ab_1 = mkAdv "inne" ;
  inne_av_1 = mkA "inne" ;
  inneboende_av_1 = mkA "inneboende" ;
  inneboerd_nn_1 = mkN "innebцrd" "innebцrder" ;
  innebyggare_nn_1 = mkN "innebyggare" "innebyggare" ;
  innegrej_nn_1 = mkN "innegrej" "innegrejer" ;
  innehaall_nn_1 = mkN "innehеll" neutrum ;
  innehaalla_vb_1 = mkV "innehеlla" "innehцll" "innehеllit" ;
  innehaallsanalys_nn_1 = mkN "innehеllsanalys" "innehеllsanalyser" ;
  innehaallsdeklaration_nn_1 = mkN "innehеllsdeklaration" "innehеllsdeklarationer" ;
  innehaallsfoerteckning_nn_1 = mkN "innehеllsfцrteckning" ;
  innehaallslig_av_1 = mkA "innehеllslig" ;
  innehaallsloes_av_1 = mkA "innehеllslцs" ;
  innehaallsobjekt_nn_1 = mkN "innehеllsobjekt" neutrum ;
  innehaallsoeversikt_nn_1 = mkN "innehеllsцversikt" "innehеllsцversikter" ;
  innehaallsrik_av_1 = mkA "innehеllsrik" ;
  innehaallstom_av_1 = mkA "innehеllstom" "innehеllstomt" "innehеllstomma" "innehеllstomma" "innehеllstommare" "innehеllstommast" "innehеllstommaste" ;
  innehav_nn_1 = mkN "innehav" neutrum ;
  innehavare_nn_1 = mkN "innehavare" "innehavare" ;
  innehavarpapper_nn_1 = mkN "innehavarpapper" neutrum ;
  inneliggande_av_1 = mkA "inneliggande" ;
  inner_nn_1 = mkN "inner" ;
  innerdoerr_nn_1 = mkN "innerdцrr" ;
  innerlig_av_1 = mkA "innerlig" ;
  innerligen_ab_1 = mkAdv "innerligen" ;
  inneroera_nn_1 = mkN "innerцra" "innerцrat" "innerцron" "innerцronen" ;
  innerskaer_nn_1 = mkN "innerskдr" neutrum ;
  innerslang_nn_1 = mkN "innerslang" ;
  innerstad_nn_1 = mkN "innerstad" "innerstдder" ;
  innertak_nn_1 = mkN "innertak" neutrum ;
  innervaegg_nn_1 = mkN "innervдgg" ;
  innervation_nn_1 = mkN "innervation" "innervationer" ;
  innesittare_nn_1 = mkN "innesittare" "innesittare" ;
  innesluta_vb_1 = mkV "innesluta" "inneslцt" "inneslutit" ;
  inneslutning_nn_1 = mkN "inneslutning" ;
  innestaaende_av_1 = mkA "innestеende" ;
  innevaanare_nn_1 = mkN "innevеnare" "innevеnare" ;
  innevarande_av_1 = mkA "innevarande" ;
  innoetning_nn_1 = mkN "innцtning" ;
  innovation_nn_1 = mkN "innovation" "innovationer" ;
  innovativ_av_1 = mkA "innovativ" ;
  innovatoer_nn_1 = mkN "innovatцr" "innovatцrer" ;
  inofficiell_av_1 = mkA "inofficiell" ;
  inokulation_nn_1 = mkN "inokulation" "inokulationer" ;
  inombordare_nn_1 = mkN "inombordare" "inombordare" ;
  inombords_ab_1 = mkAdv "inombords" ;
  inombordsmotor_nn_1 = mkN "inombordsmotor" "inombordsmotorer" ;
  inomhus_ab_1 = mkAdv "inomhus" ;
  inomhusforskning_nn_1 = mkN "inomhusforskning" ;
  inomhusgolv_nn_1 = mkN "inomhusgolv" neutrum ;
  inomhusidrott_nn_1 = mkN "inomhusidrott" "inomhusidrotter" ;
  inomhusluft_nn_1 = mkN "inomhusluft" "inomhuslufter" ;
  inomlands_ab_1 = mkAdv "inomlands" ;
  inomskaers_ab_1 = mkAdv "inomskдrs" ;
  inomvetenskaplig_av_1 = mkA "inomvetenskaplig" ;
  inopportun_av_1 = mkA "inopportun" ;
  inpackning_nn_1 = mkN "inpackning" ;
  inpass_nn_1 = mkN "inpass" neutrum ;
  inpetning_nn_1 = mkN "inpetning" ;
  inpiskare_nn_1 = mkN "inpiskare" "inpiskare" ;
  inpyrd_av_1 = mkA "inpyrd" "inpyrt" ;
  inraekning_nn_1 = mkN "inrдkning" ;
  inraettning_nn_1 = mkN "inrдttning" ;
  inramning_nn_1 = mkN "inramning" ;
  inredning_nn_1 = mkN "inredning" ;
  inredningsdetalj_nn_1 = mkN "inredningsdetalj" "inredningsdetaljer" ;
  inremedicinsk_av_1 = mkA "inremedicinsk" ;
  inremission_nn_1 = mkN "inremission" "inremissioner" ;
  inresekretorisk_av_1 = mkA "inresekretorisk" ;
  inresetillstaand_nn_1 = mkN "inresetillstеnd" neutrum ;
  inresevisum_nn_1 = mkN "inresevisum" neutrum ;
  inriggare_nn_1 = mkN "inriggare" "inriggare" ;
  inrikes_ab_1 = mkAdv "inrikes" ;
  inrikes_av_1 = mkA "inrikes" ;
  inrikesdepartement_nn_1 = mkN "inrikesdepartement" "inrikesdepartementet" "inrikesdepartementen" "inrikesdepartementena" ;
  inrikesminister_nn_1 = mkN "inrikesminister" ;
  inrikespolitisk_av_1 = mkA "inrikespolitisk" ;
  inriktning_nn_1 = mkN "inriktning" ;
  inrim_nn_1 = mkN "inrim" "inrimmet" "inrim" "inrimmen" ;
  inristning_nn_1 = mkN "inristning" ;
  inroestning_nn_1 = mkN "inrцstning" ;
  inrop_nn_1 = mkN "inrop" neutrum ;
  inropare_nn_1 = mkN "inropare" "inropare" ;
  inropning_nn_1 = mkN "inropning" ;
  inryckning_nn_1 = mkN "inryckning" ;
  insaendare_nn_1 = mkN "insдndare" "insдndare" ;
  insaettning_nn_1 = mkN "insдttning" ;
  insamling_nn_1 = mkN "insamling" ;
  insats_nn_1 = mkN "insats" "insatser" ;
  insatslaegenhet_nn_1 = mkN "insatslдgenhet" "insatslдgenheter" ;
  inscenering_nn_1 = mkN "inscenering" ;
  insegel_nn_1 = mkN "insegel" neutrum ;
  inseglingsfyr_nn_1 = mkN "inseglingsfyr" ;
  insekt_nn_1 = mkN "insekt" "insekter" ;
  insekticid_nn_1 = mkN "insekticid" "insekticider" ;
  insektsaetande_av_1 = mkA "insektsдtande" ;
  insektsaetare_nn_1 = mkN "insektsдtare" "insektsдtare" ;
  insektsbefruktning_nn_1 = mkN "insektsbefruktning" ;
  insektsbett_nn_1 = mkN "insektsbett" neutrum ;
  insektsgift_nn_1 = mkN "insektsgift" "insektsgiftet" "insektsgifter" "insektsgifterna" ;
  insektsmedel_nn_1 = mkN "insektsmedel" neutrum ;
  insektsnaal_nn_1 = mkN "insektsnеl" ;
  insektssamling_nn_1 = mkN "insektssamling" ;
  insektssax_nn_1 = mkN "insektssax" ;
  insemination_nn_1 = mkN "insemination" "inseminationer" ;
  insida_nn_1 = mkN "insida" ;
  insikt_nn_1 = mkN "insikt" "insikter" ;
  insiktsfull_av_1 = mkA "insiktsfull" ;
  insinuant_av_1 = mkA "insinuant" "insinuant" ;
  insinuation_nn_1 = mkN "insinuation" "insinuationer" ;
  insjoe_nn_1 = mkN "insjц" ;
  insjoefisk_nn_1 = mkN "insjцfisk" ;
  insjungning_nn_1 = mkN "insjungning" ;
  insjunken_av_1 = mkA "insjunken" "insjunket" ;
  inskaerning_nn_1 = mkN "inskдrning" ;
  inskjuta_vb_1 = mkV "inskjuta" "inskцt" "inskjutit" ;
  inskjutning_nn_1 = mkN "inskjutning" ;
  inskolning_nn_1 = mkN "inskolning" ;
  inskott_nn_1 = mkN "inskott" neutrum ;
  inskottsvokal_nn_1 = mkN "inskottsvokal" "inskottsvokaler" ;
  inskraenkning_nn_1 = mkN "inskrдnkning" ;
  inskraenkt_av_1 = mkA "inskrдnkt" "inskrдnkt" ;
  inskrift_nn_1 = mkN "inskrift" "inskrifter" ;
  inskription_nn_1 = mkN "inskription" "inskriptioner" ;
  inskriva_vb_1 = mkV "inskriva" "inskrev" "inskrivit" ;
  inskrivning_nn_1 = mkN "inskrivning" ;
  inskrivningsbok_nn_1 = mkN "inskrivningsbok" "inskrivningsbцcker" ;
  inskrivningsdomare_nn_1 = mkN "inskrivningsdomare" "inskrivningsdomare" ;
  inslaepp_nn_1 = mkN "inslдpp" neutrum ;
  inslag_nn_1 = mkN "inslag" neutrum ;
  inslagen_av_1 = mkA "inslagen" "inslaget" ;
  insmickrande_av_1 = mkA "insmickrande" ;
  insmuggling_nn_1 = mkN "insmuggling" ;
  insmyga_vb_1 = mkV "insmyga" "insmцg" "insmugit" ;
  insnitt_nn_1 = mkN "insnitt" neutrum ;
  insnodd_av_1 = mkA "insnodd" ;
  insoendring_nn_1 = mkN "insцndring" ;
  insolvent_av_1 = mkA "insolvent" "insolvent" ;
  inspark_nn_1 = mkN "inspark" ;
  inspektion_nn_1 = mkN "inspektion" "inspektioner" ;
  inspektoer_nn_1 = mkN "inspektцr" "inspektцrer" ;
  inspektor_nn_1 = mkN "inspektor" "inspektorer" ;
  inspelning_nn_1 = mkN "inspelning" ;
  inspelningsstudio_nn_1 = mkN "inspelningsstudio" "inspelningsstudior" ;
  inspicient_nn_1 = mkN "inspicient" "inspicienter" ;
  inspiration_nn_1 = mkN "inspiration" "inspirationer" ;
  inspiratoer_nn_1 = mkN "inspiratцr" "inspiratцrer" ;
  inspraengd_av_1 = mkA "insprдngd" "insprдngt" ;
  insprutning_nn_1 = mkN "insprutning" ;
  insprutningsmotor_nn_1 = mkN "insprutningsmotor" "insprutningsmotorer" ;
  instabil_av_1 = mkA "instabil" ;
  instaellbar_av_1 = mkA "instдllbar" ;
  instaellelse_nn_1 = mkN "instдllelse" "instдllelser" ;
  instaellning_nn_1 = mkN "instдllning" ;
  instaellsam_av_1 = mkA "instдllsam" "instдllsamt" "instдllsamma" "instдllsamma" "instдllsammare" "instдllsammast" "instдllsammaste" ;
  instaellsamhet_nn_1 = mkN "instдllsamhet" "instдllsamheter" ;
  instaemmande_nn_1 = mkN "instдmmande" ;
  instaengd_av_1 = mkA "instдngd" "instдngt" ;
  installand_nn_1 = mkN "installand" "installander" ;
  installation_nn_1 = mkN "installation" "installationer" ;
  installationsfoerelaesning_nn_1 = mkN "installationsfцrelдsning" ;
  installatoer_nn_1 = mkN "installatцr" "installatцrer" ;
  installator_nn_1 = mkN "installator" "installatorer" ;
  instans_nn_1 = mkN "instans" "instanser" ;
  instiftare_nn_1 = mkN "instiftare" "instiftare" ;
  instiftelse_nn_1 = mkN "instiftelse" "instiftelser" ;
  instinkt_nn_1 = mkN "instinkt" "instinkter" ;
  instinktiv_av_1 = mkA "instinktiv" ;
  institut_nn_1 = mkN "institut" neutrum ;
  institution_nn_1 = mkN "institution" "institutioner" ;
  institutionell_av_1 = mkA "institutionell" ;
  instraalning_nn_1 = mkN "instrеlning" ;
  instroem_nn_1 = mkN "instrцm" "instrцmmen" "instrцmmar" "instrцmmarna" ;
  instruktion_nn_1 = mkN "instruktion" "instruktioner" ;
  instruktiv_av_1 = mkA "instruktiv" ;
  instruktoer_nn_1 = mkN "instruktцr" "instruktцrer" ;
  instrument_nn_1 = mkN "instrument" neutrum ;
  instrumental_av_1 = mkA "instrumental" ;
  instrumentalist_nn_1 = mkN "instrumentalist" "instrumentalister" ;
  instrumentarium_nn_1 = mkN "instrumentarium" "instrumentariet" "instrumentarier" "instrumentarierna" ;
  instrumentation_nn_1 = mkN "instrumentation" "instrumentationer" ;
  instrumentell_av_1 = mkA "instrumentell" ;
  instrumentering_nn_1 = mkN "instrumentering" ;
  instrumentflygning_nn_1 = mkN "instrumentflygning" ;
  instrumentpanel_nn_1 = mkN "instrumentpanel" "instrumentpaneler" ;
  instudering_nn_1 = mkN "instudering" ;
  insufficiens_nn_1 = mkN "insufficiens" "insufficienser" ;
  insuga_vb_1 = mkV "insuga" "insцg" "insugit" ;
  insugningsventil_nn_1 = mkN "insugningsventil" "insugningsventiler" ;
  insulaer_av_1 = mkA "insulдr" ;
  insulin_nn_1 = mkN "insulin" "insuliner" ;
  insulinchock_nn_1 = mkN "insulinchock" "insulinchocker" ;
  insupa_vb_1 = mkV "insupa" "insцp" "insupit" ;
  insurgent_nn_1 = mkN "insurgent" "insurgenter" ;
  insvaengd_av_1 = mkA "insvдngd" "insvдngt" ;
  insvaengning_nn_1 = mkN "insvдngning" ;
  insydd_av_1 = mkA "insydd" ;
  inta_vb_1 = mkV "inta" "intar" "inta" "intog" "intagit" "intagen" ;
  intaag_nn_1 = mkN "intеg" neutrum ;
  intaekt_nn_1 = mkN "intдkt" "intдkter" ;
  intaektschablon_nn_1 = mkN "intдktschablon" "intдktschabloner" ;
  intag_nn_1 = mkN "intag" neutrum ;
  intagande_av_1 = mkA "intagande" ;
  intagen_av_1 = mkA "intagen" "intaget" ;
  intagning_nn_1 = mkN "intagning" ;
  intagsdamm_nn_1 = mkN "intagsdamm" ;
  intakt_av_1 = mkA "intakt" "intakt" ;
  intalan_nn_1 = mkN "intalan" "intalan" "intalanden" "intalandena" ;
  inte_ab_1 = mkAdv "inte" ;
  inteckning_nn_1 = mkN "inteckning" ;
  inteckningslaan_nn_1 = mkN "inteckningslеn" neutrum ;
  integral_nn_1 = mkN "integral" "integraler" ;
  integralkalkyl_nn_1 = mkN "integralkalkyl" "integralkalkyler" ;
  integrand_nn_1 = mkN "integrand" "integrander" ;
  integration_nn_1 = mkN "integration" "integrationer" ;
  integrerande_av_1 = mkA "integrerande" ;
  integrering_nn_1 = mkN "integrering" ;
  integritet_nn_1 = mkN "integritet" "integriteter" ;
  intellekt_nn_1 = mkN "intellekt" neutrum ;
  intellektualist_nn_1 = mkN "intellektualist" "intellektualister" ;
  intellektuell_av_1 = mkA "intellektuell" ;
  intelligens_nn_1 = mkN "intelligens" "intelligenser" ;
  intelligensaalder_nn_1 = mkN "intelligensеlder" ;
  intelligensaristokrat_nn_1 = mkN "intelligensaristokrat" "intelligensaristokrater" ;
  intelligenskvot_nn_1 = mkN "intelligenskvot" "intelligenskvoter" ;
  intelligensmaetning_nn_1 = mkN "intelligensmдtning" ;
  intelligenstest_nn_1 = mkN "intelligenstest" neutrum ;
  intelligent_av_1 = mkA "intelligent" "intelligent" ;
  intendent_nn_1 = mkN "intendent" "intendenter" ;
  intendentur_nn_1 = mkN "intendentur" "intendenturer" ;
  intendenturtjaenst_nn_1 = mkN "intendenturtjдnst" "intendenturtjдnster" ;
  intensitet_nn_1 = mkN "intensitet" "intensiteter" ;
  intensiv_av_1 = mkA "intensiv" ;
  intensiv_nn_1 = mkN "intensiv" "intensiver" ;
  intensivundersoekning_nn_1 = mkN "intensivundersцkning" ;
  intensivvaardsavdelning_nn_1 = mkN "intensivvеrdsavdelning" ;
  intention_nn_1 = mkN "intention" "intentioner" ;
  intentionsdjup_nn_1 = mkN "intentionsdjup" neutrum ;
  interaktion_nn_1 = mkN "interaktion" "interaktioner" ;
  interaktiv_av_1 = mkA "interaktiv" ;
  intercitytaag_nn_1 = mkN "intercitytеg" neutrum ;
  interdental_av_1 = mkA "interdental" ;
  interdental_nn_1 = mkN "interdental" "interdentaler" ;
  interdikt_nn_1 = mkN "interdikt" neutrum ;
  interferens_nn_1 = mkN "interferens" "interferenser" ;
  interferensmoenster_nn_1 = mkN "interferensmцnster" neutrum ;
  interglacial_av_1 = mkA "interglacial" ;
  interglacial_nn_1 = mkN "interglacial" "interglacialer" ;
  interimistisk_av_1 = mkA "interimistisk" ;
  interimsbevis_nn_1 = mkN "interimsbevis" neutrum ;
  interimsregering_nn_1 = mkN "interimsregering" ;
  interimsstyrelse_nn_1 = mkN "interimsstyrelse" "interimsstyrelser" ;
  interioer_nn_1 = mkN "interiцr" "interiцrer" ;
  interjektion_nn_1 = mkN "interjektion" "interjektioner" ;
  interkontinental_av_1 = mkA "interkontinental" ;
  interlokutoer_nn_1 = mkN "interlokutцr" "interlokutцrer" ;
  interludium_nn_1 = mkN "interludium" "interludiet" "interludier" "interludierna" ;
  intermezzo_nn_1 = mkN "intermezzo" "intermezzot" "intermezzon" "intermezzona" ;
  intermittent_av_1 = mkA "intermittent" "intermittent" ;
  intern_av_1 = mkA "intern" ;
  intern_nn_1 = mkN "intern" "interner" ;
  internat_nn_1 = mkN "internat" neutrum ;
  international_nn_1 = mkN "international" "internationaler" ;
  internationalist_nn_1 = mkN "internationalist" "internationalister" ;
  internationell_av_1 = mkA "internationell" ;
  internering_nn_1 = mkN "internering" ;
  interneringslaeger_nn_1 = mkN "interneringslдger" neutrum ;
  internist_nn_1 = mkN "internist" "internister" ;
  internordisk_av_1 = mkA "internordisk" ;
  internutbildning_nn_1 = mkN "internutbildning" ;
  interpellant_nn_1 = mkN "interpellant" "interpellanter" ;
  interpellation_nn_1 = mkN "interpellation" "interpellationer" ;
  interplanetarisk_av_1 = mkA "interplanetarisk" ;
  interpolation_nn_1 = mkN "interpolation" "interpolationer" ;
  interpret_nn_1 = mkN "interpret" "interpreter" ;
  interpretation_nn_1 = mkN "interpretation" "interpretationer" ;
  interregnum_nn_1 = mkN "interregnum" neutrum ;
  interrogativ_av_1 = mkA "interrogativ" ;
  interstellaer_av_1 = mkA "interstellдr" ;
  interurban_av_1 = mkA "interurban" ;
  intervall_nn_1 = mkN "intervall" neutrum ;
  intervention_nn_1 = mkN "intervention" "interventioner" ;
  intervju_nn_1 = mkN "intervju" "intervjun" "intervjuer" "intervjuerna" ;
  intervjuare_nn_1 = mkN "intervjuare" "intervjuare" ;
  intervjuoffer_nn_1 = mkN "intervjuoffer" neutrum ;
  intervjuundersoekning_nn_1 = mkN "intervjuundersцkning" ;
  intervokalisk_av_1 = mkA "intervokalisk" ;
  intestatarv_nn_1 = mkN "intestatarv" neutrum ;
  intetsaegande_av_1 = mkA "intetsдgande" ;
  intig_av_1 = mkA "intig" ;
  intighet_nn_1 = mkN "intighet" "intigheter" ;
  intill_ab_1 = mkAdv "intill" ;
  intilliggande_av_1 = mkA "intilliggande" ;
  intim_av_1 = mkA "intim" ;
  intimist_nn_1 = mkN "intimist" "intimister" ;
  intimitet_nn_1 = mkN "intimitet" "intimiteter" ;
  intjaenandetid_nn_1 = mkN "intjдnandetid" "intjдnandetider" ;
  intolerabel_av_1 = mkA "intolerabel" "intolerabelt" "intolerabla" "intolerabla" "intolerablare" "intolerablast" "intolerablaste" ;
  intolerant_av_1 = mkA "intolerant" "intolerant" ;
  intonation_nn_1 = mkN "intonation" "intonationer" ;
  intorkning_nn_1 = mkN "intorkning" ;
  intoxikation_nn_1 = mkN "intoxikation" "intoxikationer" ;
  intraede_nn_1 = mkN "intrдde" ;
  intraedesavgift_nn_1 = mkN "intrдdesavgift" "intrдdesavgifter" ;
  intraedesprov_nn_1 = mkN "intrдdesprov" neutrum ;
  intraedestal_nn_1 = mkN "intrдdestal" "intrдdestalet" "intrдdestalen" "intrдdestalena" ;
  intraengande_av_1 = mkA "intrдngande" ;
  intraengling_nn_1 = mkN "intrдngling" ;
  intransigent_av_1 = mkA "intransigent" "intransigent" ;
  intransitiv_av_1 = mkA "intransitiv" ;
  intravenoes_av_1 = mkA "intravenцs" ;
  intressant_av_1 = mkA "intressant" "intressant" ;
  intresse_nn_1 = mkN "intresse" ;
  intressegemenskap_nn_1 = mkN "intressegemenskap" "intressegemenskaper" ;
  intressegrupp_nn_1 = mkN "intressegrupp" "intressegrupper" ;
  intressekonflikt_nn_1 = mkN "intressekonflikt" "intressekonflikter" ;
  intresseloes_av_1 = mkA "intresselцs" ;
  intressent_nn_1 = mkN "intressent" "intressenter" ;
  intresseomraade_nn_1 = mkN "intresseomrеde" ;
  intresseorganisation_nn_1 = mkN "intresseorganisation" "intresseorganisationer" ;
  intressesfaer_nn_1 = mkN "intressesfдr" "intressesfдrer" ;
  intressevaeckande_av_1 = mkA "intressevдckande" ;
  intrig_nn_1 = mkN "intrig" "intriger" ;
  intrigant_av_1 = mkA "intrigant" "intrigant" ;
  intrigant_nn_1 = mkN "intrigant" "intriganter" ;
  intrigoer_nn_1 = mkN "intrigцr" "intrigцrer" ;
  intrikat_av_1 = mkA "intrikat" "intrikat" ;
  intrimning_nn_1 = mkN "intrimning" ;
  introduktion_nn_1 = mkN "introduktion" "introduktioner" ;
  introduktionsbrev_nn_1 = mkN "introduktionsbrev" neutrum ;
  introduktionserbjudande_nn_1 = mkN "introduktionserbjudande" ;
  introduktionskurs_nn_1 = mkN "introduktionskurs" "introduktionskurser" ;
  introduktoer_nn_1 = mkN "introduktцr" "introduktцrer" ;
  introspektiv_av_1 = mkA "introspektiv" ;
  introvert_av_1 = mkA "introvert" "introvert" ;
  intryck_nn_1 = mkN "intryck" neutrum ;
  intubation_nn_1 = mkN "intubation" "intubationer" ;
  intuition_nn_1 = mkN "intuition" "intuitioner" ;
  intuitiv_av_1 = mkA "intuitiv" ;
  intumning_nn_1 = mkN "intumning" ;
  intyg_nn_1 = mkN "intyg" neutrum ;
  inuit_nn_1 = mkN "inuit" "inuiter" ;
  inuti_ab_1 = mkAdv "inuti" ;
  invaanare_nn_1 = mkN "invеnare" "invеnare" ;
  invaegning_nn_1 = mkN "invдgning" ;
  invaendig_av_1 = mkA "invдndig" ;
  invaendning_nn_1 = mkN "invдndning" ;
  invaendningsfri_av_1 = mkA "invдndningsfri" "invдndningsfritt" ;
  invaertes_ab_1 = mkAdv "invдrtes" ;
  invaertes_av_1 = mkA "invдrtes" ;
  inval_nn_1 = mkN "inval" neutrum ;
  invalid_nn_1 = mkN "invalid" "invalider" ;
  invaliditet_nn_1 = mkN "invaliditet" "invaliditeter" ;
  invand_av_1 = mkA "invand" ;
  invandrare_nn_1 = mkN "invandrare" "invandrare" ;
  invandrarverk_nn_1 = mkN "invandrarverk" neutrum ;
  invandring_nn_1 = mkN "invandring" ;
  invandringskvot_nn_1 = mkN "invandringskvot" "invandringskvoter" ;
  invariabel_av_1 = mkA "invariabel" "invariabelt" "invariabla" "invariabla" "invariablare" "invariablast" "invariablaste" ;
  invariant_av_1 = mkA "invariant" "invariant" ;
  invasion_nn_1 = mkN "invasion" "invasioner" ;
  invektiv_nn_1 = mkN "invektiv" neutrum ;
  inventariebok_nn_1 = mkN "inventariebok" "inventariebцcker" ;
  inventariefoerteckning_nn_1 = mkN "inventariefцrteckning" ;
  inventarium_nn_1 = mkN "inventarium" "inventariet" "inventarier" "inventarierna" ;
  inventering_nn_1 = mkN "inventering" ;
  inventioes_av_1 = mkA "inventiцs" ;
  inverkning_nn_1 = mkN "inverkning" ;
  invers_nn_1 = mkN "invers" "inverser" ;
  inversion_nn_1 = mkN "inversion" "inversioner" ;
  invertebrat_nn_1 = mkN "invertebrat" "invertebrater" ;
  investerare_nn_1 = mkN "investerare" "investerare" ;
  investering_nn_1 = mkN "investering" ;
  investeringsbank_nn_1 = mkN "investeringsbank" "investeringsbanker" ;
  investeringsfond_nn_1 = mkN "investeringsfond" "investeringsfonder" ;
  investmentbolag_nn_1 = mkN "investmentbolag" neutrum ;
  invigning_nn_1 = mkN "invigning" ;
  invintring_nn_1 = mkN "invintring" ;
  invintringsprocess_nn_1 = mkN "invintringsprocess" "invintringsprocesser" ;
  invit_nn_1 = mkN "invit" "inviter" ;
  invitation_nn_1 = mkN "invitation" "invitationer" ;
  invokation_nn_1 = mkN "invokation" "invokationer" ;
  ioegonenfallande_av_1 = mkA "iцgonenfallande" ;
  ioegonfallande_av_1 = mkA "iцgonfallande" ;
  irakier_nn_1 = mkN "irakier" "irakiern" "irakier" "irakierna" ;
  irakisk_av_1 = mkA "irakisk" ;
  irakiska_nn_1 = mkN "irakiska" ;
  iranier_nn_1 = mkN "iranier" "iraniern" "iranier" "iranierna" ;
  iransk_av_1 = mkA "iransk" ;
  iranska_nn_2 = mkN "iranska" ;
  irer_nn_1 = mkN "irer" "irern" "irer" "irerna" ;
  iridiumlager_nn_1 = mkN "iridiumlager" neutrum ;
  iris_nn_1 = mkN "iris" ;
  irisblaendare_nn_1 = mkN "irisblдndare" "irisblдndare" ;
  irisk_av_1 = mkA "irisk" ;
  iriska_nn_2 = mkN "iriska" ;
  irlaendare_nn_1 = mkN "irlдndare" "irlдndare" ;
  irlaendsk_av_1 = mkA "irlдndsk" ;
  irlaendska_nn_2 = mkN "irlдndska" ;
  ironi_nn_1 = mkN "ironi" "ironier" ;
  ironiker_nn_1 = mkN "ironiker" "ironikern" "ironiker" "ironikerna" ;
  ironisk_av_1 = mkA "ironisk" ;
  irrationell_av_1 = mkA "irrationell" ;
  irrbloss_nn_1 = mkN "irrbloss" neutrum ;
  irreal_av_1 = mkA "irreal" ;
  irreguljaer_av_1 = mkA "irreguljдr" ;
  irrelevant_av_1 = mkA "irrelevant" "irrelevant" ;
  irreparabel_av_1 = mkA "irreparabel" "irreparabelt" "irreparabla" "irreparabla" "irreparablare" "irreparablast" "irreparablaste" ;
  irreversibel_av_1 = mkA "irreversibel" "irreversibelt" "irreversibla" "irreversibla" "irreversiblare" "irreversiblast" "irreversiblaste" ;
  irrfaerd_nn_1 = mkN "irrfдrd" "irrfдrder" ;
  irrgaang_nn_1 = mkN "irrgеng" ;
  irritabel_av_1 = mkA "irritabel" "irritabelt" "irritabla" "irritabla" "irritablare" "irritablast" "irritablaste" ;
  irritament_nn_1 = mkN "irritament" "irritamentet" "irritamenten" "irritamentena" ;
  irritation_nn_1 = mkN "irritation" "irritationer" ;
  irritationsmoment_nn_1 = mkN "irritationsmoment" neutrum ;
  irrlaera_nn_1 = mkN "irrlдra" ;
  irrlaerig_av_1 = mkA "irrlдrig" ;
  is_nn_1 = mkN "is" ;
  isaelv_nn_1 = mkN "isдlv" ;
  isaender_ab_1 = mkAdv "isдnder" ;
  isaer_ab_1 = mkAdv "isдr" ;
  isaettning_nn_1 = mkN "isдttning" ;
  isagogisk_av_1 = mkA "isagogisk" ;
  isbaelte_nn_1 = mkN "isbдlte" ;
  isberg_nn_1 = mkN "isberg" neutrum ;
  isbildning_nn_1 = mkN "isbildning" ;
  isbill_nn_1 = mkN "isbill" ;
  isbit_nn_1 = mkN "isbit" ;
  isbjoern_nn_1 = mkN "isbjцrn" ;
  isblaa_av_1 = mkA "isblе" "isblеtt" ;
  isblock_nn_1 = mkN "isblock" neutrum ;
  isboj_nn_1 = mkN "isboj" ;
  isbrodd_nn_1 = mkN "isbrodd" ;
  isbrytare_nn_1 = mkN "isbrytare" "isbrytare" ;
  isbrytning_nn_1 = mkN "isbrytning" ;
  iscensaettning_nn_1 = mkN "iscensдttning" ;
  ischiasnerv_nn_1 = mkN "ischiasnerv" "ischiasnerver" ;
  ischuri_nn_1 = mkN "ischuri" "ischurier" ;
  isdubb_nn_1 = mkN "isdubb" ;
  isfaagel_nn_1 = mkN "isfеgel" ;
  isflak_nn_1 = mkN "isflak" neutrum ;
  isfoerhaallande_nn_1 = mkN "isfцrhеllande" ;
  isfri_av_1 = mkA "isfri" "isfritt" ;
  isfront_nn_1 = mkN "isfront" "isfronter" ;
  isglass_nn_1 = mkN "isglass" ;
  ishall_nn_1 = mkN "ishall" ;
  ishav_nn_1 = mkN "ishav" neutrum ;
  ishockeyroer_nn_1 = mkN "ishockeyrцr" neutrum ;
  ishockeyspelare_nn_1 = mkN "ishockeyspelare" "ishockeyspelare" ;
  isig_av_1 = mkA "isig" ;
  isjakt_nn_1 = mkN "isjakt" "isjakter" ;
  iskall_av_1 = mkA "iskall" ;
  iskant_nn_1 = mkN "iskant" "iskanter" ;
  iskonvalj_nn_1 = mkN "iskonvalj" "iskonvaljer" ;
  iskorn_nn_1 = mkN "iskorn" neutrum ;
  iskravning_nn_1 = mkN "iskravning" ;
  iskristall_nn_1 = mkN "iskristall" "iskristaller" ;
  islaendare_nn_1 = mkN "islдndare" "islдndare" ;
  islaendsk_av_1 = mkA "islдndsk" ;
  islaendska_nn_2 = mkN "islдndska" ;
  islaenning_nn_1 = mkN "islдnning" ;
  islamisk_av_1 = mkA "islamisk" ;
  islamsk_av_1 = mkA "islamsk" ;
  islandslav_nn_1 = mkN "islandslav" ;
  islandssill_nn_1 = mkN "islandssill" ;
  islossning_nn_1 = mkN "islossning" ;
  ism_nn_1 = mkN "ism" "ismer" ;
  isobar_nn_1 = mkN "isobar" "isobarer" ;
  isogon_nn_1 = mkN "isogon" "isogoner" ;
  isolat_nn_1 = mkN "isolat" neutrum ;
  isolationistisk_av_1 = mkA "isolationistisk" ;
  isolator_nn_1 = mkN "isolator" "isolatorer" ;
  isolerband_nn_1 = mkN "isolerband" neutrum ;
  isolerglas_nn_1 = mkN "isolerglas" neutrum ;
  isolering_nn_1 = mkN "isolering" ;
  isoleringsavdelning_nn_1 = mkN "isoleringsavdelning" ;
  isoleringsband_nn_1 = mkN "isoleringsband" neutrum ;
  isoleringscell_nn_1 = mkN "isoleringscell" "isoleringsceller" ;
  isoleringsmaterial_nn_1 = mkN "isoleringsmaterial" neutrum ;
  isomer_av_1 = mkA "isomer" ;
  isomer_nn_1 = mkN "isomer" "isomerer" ;
  isomeri_nn_1 = mkN "isomeri" "isomerier" ;
  isomorf_av_1 = mkA "isomorf" ;
  isomorfi_nn_1 = mkN "isomorfi" "isomorfier" ;
  isooktan_nn_1 = mkN "isooktan" neutrum ;
  isoterm_nn_1 = mkN "isoterm" "isotermer" ;
  isotop_nn_1 = mkN "isotop" "isotoper" ;
  isperiod_nn_1 = mkN "isperiod" "isperioder" ;
  ispigg_nn_1 = mkN "ispigg" ;
  ispik_nn_1 = mkN "ispik" ;
  israeffla_nn_1 = mkN "isrдffla" ;
  israel_nn_1 = mkN "israel" "israeler" ;
  israelisk_av_1 = mkA "israelisk" ;
  israelit_nn_1 = mkN "israelit" "israeliter" ;
  israelitisk_av_1 = mkA "israelitisk" ;
  isrand_nn_1 = mkN "isrand" "isrдnder" ;
  isranunkel_nn_1 = mkN "isranunkel" ;
  israpport_nn_1 = mkN "israpport" "israpporter" ;
  isrevy_nn_1 = mkN "isrevy" "isrevyer" ;
  issjoe_nn_1 = mkN "issjц" ;
  isskruvning_nn_1 = mkN "isskruvning" ;
  issmaeltning_nn_1 = mkN "issmдltning" ;
  istadig_av_1 = mkA "istadig" ;
  istaecke_nn_1 = mkN "istдcke" ;
  istaeckt_av_1 = mkA "istдckt" "istдckt" ;
  istaellet_ab_1 = mkAdv "istдllet" ;
  istapp_nn_1 = mkN "istapp" ;
  isterband_nn_1 = mkN "isterband" neutrum ;
  isterbuk_nn_1 = mkN "isterbuk" ;
  istid_nn_1 = mkN "istid" "istider" ;
  istidsforskare_nn_1 = mkN "istidsforskare" "istidsforskare" ;
  istryck_nn_1 = mkN "istryck" neutrum ;
  isvak_nn_1 = mkN "isvak" ;
  italer_nn_1 = mkN "italer" "italern" "italer" "italerna" ;
  italienare_nn_1 = mkN "italienare" "italienare" ;
  italiensk_av_1 = mkA "italiensk" ;
  italienska_nn_2 = mkN "italienska" ;
  italiker_nn_1 = mkN "italiker" "italikern" "italiker" "italikerna" ;
  italisk_av_1 = mkA "italisk" ;
  iteration_nn_1 = mkN "iteration" "iterationer" ;
  iterativ_av_1 = mkA "iterativ" ;
  itu_ab_1 = mkAdv "itu" ;
  ity_ab_1 = mkAdv "ity" ;
  ivaeg_ab_1 = mkAdv "ivдg" ;
  ivorian_nn_1 = mkN "ivorian" "ivorianer" ;
  ivoriansk_av_1 = mkA "ivoriansk" ;
  ivrande_nn_1 = mkN "ivrande" ;
  ivrare_nn_1 = mkN "ivrare" "ivrare" ;
  ivrig_av_1 = mkA "ivrig" ;
  ja_nn_1 = mkN "ja" "jaet" "jan" "jana" ;
  jaakk_nn_1 = mkN "jеkk" ;
  jab_nn_1 = mkN "jab" "jabben" "jabbar" "jabbarna" ;
  jabot_nn_1 = mkN "jabot" "jaboter" ;
  jack_nn_1 = mkN "jack" neutrum ;
  jack_nn_2 = mkN "jack" ;
  jackett_nn_1 = mkN "jackett" "jacketter" ;
  jackig_av_1 = mkA "jackig" ;
  jackpot_nn_1 = mkN "jackpot" ;
  jackpropp_nn_1 = mkN "jackpropp" ;
  jackuttag_nn_1 = mkN "jackuttag" neutrum ;
  jadegroen_av_1 = mkA "jadegrцn" ;
  jaedra_av_1 = mkA "jдdra" ;
  jaedrans_av_1 = mkA "jдdrans" ;
  jaegarbiff_nn_1 = mkN "jдgarbiff" ;
  jaegare_nn_1 = mkN "jдgare" "jдgare" ;
  jaegarfolk_nn_1 = mkN "jдgarfolk" neutrum ;
  jaegarhatt_nn_1 = mkN "jдgarhatt" ;
  jaegarhorn_nn_1 = mkN "jдgarhorn" neutrum ;
  jaegmaestare_nn_1 = mkN "jдgmдstare" "jдgmдstare" ;
  jaekel_nn_1 = mkN "jдkel" ;
  jaekelskap_nn_1 = mkN "jдkelskap" "jдkelskaper" ;
  jaekla_av_1 = mkA "jдkla" ;
  jaeklig_av_1 = mkA "jдklig" ;
  jaektig_av_1 = mkA "jдktig" ;
  jaemboerdig_av_1 = mkA "jдmbцrdig" ;
  jaemfoerande_av_1 = mkA "jдmfцrande" ;
  jaemfoerbar_av_1 = mkA "jдmfцrbar" ;
  jaemfoerelse_nn_1 = mkN "jдmfцrelse" "jдmfцrelser" ;
  jaemfoerelsetal_nn_1 = mkN "jдmfцrelsetal" "jдmfцrelsetalet" "jдmfцrelsetalen" "jдmfцrelsetalena" ;
  jaemfoerelsevis_ab_1 = mkAdv "jдmfцrelsevis" ;
  jaemfoerlig_av_1 = mkA "jдmfцrlig" ;
  jaemfoerpris_nn_1 = mkN "jдmfцrpris" neutrum ;
  jaemfota_ab_1 = mkAdv "jдmfota" ;
  jaemgod_av_1 = mkA "jдmgod" ;
  jaemkning_nn_1 = mkN "jдmkning" ;
  jaemlik_av_1 = mkA "jдmlik" ;
  jaemlike_nn_1 = mkN "jдmlike" utrum ;
  jaemlikhet_nn_1 = mkN "jдmlikhet" "jдmlikheter" ;
  jaemmerdal_nn_1 = mkN "jдmmerdal" ;
  jaemmerlig_av_1 = mkA "jдmmerlig" ;
  jaemn_av_1 = mkA "jдmn" ;
  jaemnaarig_av_1 = mkA "jдmnеrig" ;
  jaemngod_av_1 = mkA "jдmngod" ;
  jaemnstark_av_1 = mkA "jдmnstark" ;
  jaemnstor_av_1 = mkA "jдmnstor" ;
  jaemntjock_av_1 = mkA "jдmntjock" ;
  jaemnvarm_av_1 = mkA "jдmnvarm" ;
  jaems_ab_1 = mkAdv "jдms" ;
  jaemsides_ab_1 = mkAdv "jдmsides" ;
  jaemspelt_av_1 = mkA "jдmspelt" "jдmspelt" ;
  jaemstaelld_av_1 = mkA "jдmstдlld" "jдmstдllt" ;
  jaemstaelldhet_nn_1 = mkN "jдmstдlldhet" "jдmstдlldheter" ;
  jaemstark_av_1 = mkA "jдmstark" ;
  jaemt_ab_1 = mkAdv "jдmt" ;
  jaemte_nn_1 = mkN "jдmte" utrum ;
  jaemthund_nn_1 = mkN "jдmthund" ;
  jaemtjock_av_1 = mkA "jдmtjock" ;
  jaemtlaendsk_av_1 = mkA "jдmtlдndsk" ;
  jaemtlaenning_nn_1 = mkN "jдmtlдnning" ;
  jaemtsk_av_1 = mkA "jдmtsk" ;
  jaemvael_ab_1 = mkAdv "jдmvдl" ;
  jaemviktslaege_nn_1 = mkN "jдmviktslдge" ;
  jaemviktsorgan_nn_1 = mkN "jдmviktsorgan" neutrum ;
  jaenkare_nn_1 = mkN "jдnkare" "jдnkare" ;
  jaern_nn_1 = mkN "jдrn" neutrum ;
  jaernaaldersbonde_nn_1 = mkN "jдrnеldersbonde" "jдrnеldersbцnder" ;
  jaernaaldersbygd_nn_1 = mkN "jдrnеldersbygd" "jдrnеldersbygder" ;
  jaernaaldersfiskare_nn_1 = mkN "jдrnеldersfiskare" "jдrnеldersfiskare" ;
  jaernaar_nn_1 = mkN "jдrnеr" neutrum ;
  jaernaffaer_nn_1 = mkN "jдrnaffдr" "jдrnaffдrer" ;
  jaernbakterie_nn_1 = mkN "jдrnbakterie" "jдrnbakterier" ;
  jaernbalk_nn_1 = mkN "jдrnbalk" ;
  jaernbeslag_nn_1 = mkN "jдrnbeslag" neutrum ;
  jaernblad_nn_1 = mkN "jдrnblad" neutrum ;
  jaernbroellop_nn_1 = mkN "jдrnbrцllop" neutrum ;
  jaernbruk_nn_1 = mkN "jдrnbruk" neutrum ;
  jaernek_nn_1 = mkN "jдrnek" ;
  jaernfoeremaal_nn_1 = mkN "jдrnfцremеl" neutrum ;
  jaernframstaellning_nn_1 = mkN "jдrnframstдllning" ;
  jaerngrepp_nn_1 = mkN "jдrngrepp" neutrum ;
  jaernhaard_av_1 = mkA "jдrnhеrd" "jдrnhеrt" ;
  jaernhake_nn_1 = mkN "jдrnhake" utrum ;
  jaernhand_nn_1 = mkN "jдrnhand" "jдrnhдnder" ;
  jaernhandel_nn_1 = mkN "jдrnhandel" ;
  jaernhantering_nn_1 = mkN "jдrnhantering" ;
  jaernindustri_nn_1 = mkN "jдrnindustri" "jдrnindustrier" ;
  jaernjungfru_nn_1 = mkN "jдrnjungfru" "jдrnjungfrun" "jдrnjungfrur" "jдrnjungfrurna" ;
  jaernkatastrof_nn_1 = mkN "jдrnkatastrof" "jдrnkatastrofer" ;
  jaernklump_nn_1 = mkN "jдrnklump" ;
  jaernkors_nn_1 = mkN "jдrnkors" neutrum ;
  jaernlegering_nn_1 = mkN "jдrnlegering" ;
  jaernmalm_nn_1 = mkN "jдrnmalm" "jдrnmalmer" ;
  jaernmanufaktur_nn_1 = mkN "jдrnmanufaktur" "jдrnmanufakturer" ;
  jaernnatt_nn_1 = mkN "jдrnnatt" "jдrnnдtter" ;
  jaernoert_nn_1 = mkN "jдrnцrt" "jдrnцrter" ;
  jaernoxid_nn_1 = mkN "jдrnoxid" "jдrnoxider" ;
  jaernpinne_nn_1 = mkN "jдrnpinne" utrum ;
  jaernplaat_nn_1 = mkN "jдrnplеt" ;
  jaernproduktion_nn_1 = mkN "jдrnproduktion" "jдrnproduktioner" ;
  jaernredskap_nn_1 = mkN "jдrnredskap" "jдrnredskapet" "jдrnredskapen" "jдrnredskapena" ;
  jaernridaa_nn_1 = mkN "jдrnridе" "jдrnridеer" ;
  jaernrik_av_1 = mkA "jдrnrik" ;
  jaernring_nn_1 = mkN "jдrnring" ;
  jaernsalt_nn_1 = mkN "jдrnsalt" "jдrnsaltet" "jдrnsalter" "jдrnsalterna" ;
  jaernsparv_nn_1 = mkN "jдrnsparv" ;
  jaernspis_nn_1 = mkN "jдrnspis" ;
  jaernstaang_nn_1 = mkN "jдrnstеng" "jдrnstдnger" ;
  jaernstag_nn_1 = mkN "jдrnstag" neutrum ;
  jaernsulfid_nn_1 = mkN "jдrnsulfid" "jдrnsulfider" ;
  jaerntillverkning_nn_1 = mkN "jдrntillverkning" ;
  jaerntraad_nn_1 = mkN "jдrntrеd" ;
  jaernvaeg_nn_1 = mkN "jдrnvдg" ;
  jaernvaegare_nn_1 = mkN "jдrnvдgare" "jдrnvдgare" ;
  jaernvaegsbiljett_nn_1 = mkN "jдrnvдgsbiljett" "jдrnvдgsbiljetter" ;
  jaernvaegsknut_nn_1 = mkN "jдrnvдgsknut" ;
  jaernvaegsoevergaang_nn_1 = mkN "jдrnvдgsцvergеng" ;
  jaernvaegsraels_nn_1 = mkN "jдrnvдgsrдls" ;
  jaernvaegssignal_nn_1 = mkN "jдrnvдgssignal" "jдrnvдgssignaler" ;
  jaernvaegsspaar_nn_1 = mkN "jдrnvдgsspеr" neutrum ;
  jaernvaegsstation_nn_1 = mkN "jдrnvдgsstation" "jдrnvдgsstationer" ;
  jaernvaegstjaensteman_nn_1 = mkN "jдrnvдgstjдnsteman" "jдrnvдgstjдnstemannen" "jдrnvдgstjдnstemдn" "jдrnvдgstjдnstemдnnen" ;
  jaernvaegsvagn_nn_1 = mkN "jдrnvдgsvagn" ;
  jaernvapen_nn_1 = mkN "jдrnvapen" "jдrnvapnet" "jдrnvapen" "jдrnvapnen" ;
  jaernvara_nn_1 = mkN "jдrnvara" ;
  jaernvaruaffaer_nn_1 = mkN "jдrnvaruaffдr" "jдrnvaruaffдrer" ;
  jaernverk_nn_1 = mkN "jдrnverk" neutrum ;
  jaerpe_nn_1 = mkN "jдrpe" utrum ;
  jaertecken_nn_1 = mkN "jдrtecken" "jдrtecknet" "jдrtecken" "jдrtecknen" ;
  jaerv_nn_1 = mkN "jдrv" ;
  jaesig_av_1 = mkA "jдsig" ;
  jaesning_nn_1 = mkN "jдsning" ;
  jaestsvamp_nn_1 = mkN "jдstsvamp" ;
  jaette_nn_1 = mkN "jдtte" utrum ;
  jaettebra_av_1 = mkA "jдttebra" ;
  jaettedum_av_1 = mkA "jдttedum" "jдttedumt" "jдttedumma" "jдttedumma" "jдttedummare" "jдttedummast" "jдttedummaste" ;
  jaettekast_nn_1 = mkN "jдttekast" neutrum ;
  jaettelaenge_ab_1 = mkAdv "jдttelдnge" ;
  jaettelik_av_1 = mkA "jдttelik" ;
  jaetteorm_nn_1 = mkN "jдtteorm" ;
  jaettesnaell_av_1 = mkA "jдttesnдll" ;
  jaettesnygg_av_1 = mkA "jдttesnygg" ;
  jaetteval_nn_1 = mkN "jдtteval" ;
  jaettinna_nn_1 = mkN "jдttinna" ;
  jaev_nn_1 = mkN "jдv" neutrum ;
  jaevel_nn_1 = mkN "jдvel" ;
  jaevelskap_nn_1 = mkN "jдvelskap" "jдvelskapet" "jдvelskapen" "jдvelskapena" ;
  jaevig_av_1 = mkA "jдvig" ;
  jaevla_av_1 = mkA "jдvla" ;
  jaevlig_av_1 = mkA "jдvlig" ;
  jag_nn_1 = mkN "jag" neutrum ;
  jagare_nn_1 = mkN "jagare" "jagare" ;
  jagfoerestaellning_nn_1 = mkN "jagfцrestдllning" ;
  jaggernaut_nn_1 = mkN "jaggernaut" ;
  jagisk_av_1 = mkA "jagisk" ;
  jagsvaghet_nn_1 = mkN "jagsvaghet" "jagsvagheter" ;
  jaguar_nn_1 = mkN "jaguar" "jaguarer" ;
  jak_nn_1 = mkN "jak" ;
  jakande_av_1 = mkA "jakande" ;
  jakobin_nn_1 = mkN "jakobin" "jakobiner" ;
  jakobskamp_nn_1 = mkN "jakobskamp" "jakobskamper" ;
  jakobsstege_nn_1 = mkN "jakobsstege" utrum ;
  jakt_nn_1 = mkN "jakt" "jakter" ;
  jaktbar_av_1 = mkA "jaktbar" ;
  jaktbyte_nn_1 = mkN "jaktbyte" ;
  jaktexpedition_nn_1 = mkN "jaktexpedition" "jaktexpeditioner" ;
  jaktfalk_nn_1 = mkN "jaktfalk" ;
  jaktgevaer_nn_1 = mkN "jaktgevдr" neutrum ;
  jakthistoria_nn_1 = mkN "jakthistoria" "jakthistorien" "jakthistorier" "jakthistorierna" ;
  jakthorn_nn_1 = mkN "jakthorn" neutrum ;
  jakthund_nn_1 = mkN "jakthund" ;
  jaktkort_nn_1 = mkN "jaktkort" neutrum ;
  jaktlag_nn_1 = mkN "jaktlag" neutrum ;
  jaktleopard_nn_1 = mkN "jaktleopard" "jaktleoparder" ;
  jaktlig_av_1 = mkA "jaktlig" ;
  jaktlopp_nn_1 = mkN "jaktlopp" neutrum ;
  jaktmark_nn_1 = mkN "jaktmark" "jaktmarker" ;
  jaktplan_nn_1 = mkN "jaktplan" neutrum ;
  jaktprov_nn_1 = mkN "jaktprov" neutrum ;
  jaktridning_nn_1 = mkN "jaktridning" ;
  jaktrobot_nn_1 = mkN "jaktrobot" ;
  jaktsignal_nn_1 = mkN "jaktsignal" "jaktsignaler" ;
  jaktslott_nn_1 = mkN "jaktslott" neutrum ;
  jaktspaar_nn_1 = mkN "jaktspеr" neutrum ;
  jaktspindel_nn_1 = mkN "jaktspindel" ;
  jakttabell_nn_1 = mkN "jakttabell" "jakttabeller" ;
  jakttid_nn_1 = mkN "jakttid" "jakttider" ;
  jakttrofe_nn_1 = mkN "jakttrofй" "jakttrofйer" ;
  jaktvapen_nn_1 = mkN "jaktvapen" "jaktvapnet" "jaktvapen" "jaktvapnen" ;
  jalu_av_1 = mkA "jalu" ;
  jalusi_nn_1 = mkN "jalusi" "jalusier" ;
  jamaican_nn_1 = mkN "jamaican" "jamaicaner" ;
  jamaicansk_av_1 = mkA "jamaicansk" ;
  jamare_nn_1 = mkN "jamare" "jamare" ;
  jamb_nn_1 = mkN "jamb" "jamber" ;
  jambisk_av_1 = mkA "jambisk" ;
  jamboree_nn_1 = mkN "jamboree" "jamboreer" ;
  jan_nn_1 = mkN "jan" ;
  janitsjar_nn_1 = mkN "janitsjar" "janitsjarer" ;
  japan_nn_1 = mkN "japan" "japaner" ;
  japanes_nn_1 = mkN "japanes" "japaneser" ;
  japansk_av_1 = mkA "japansk" ;
  japanska_nn_2 = mkN "japanska" ;
  japroposition_nn_1 = mkN "japroposition" "japropositioner" ;
  jardinjaer_nn_1 = mkN "jardinjдr" "jardinjдrer" ;
  jargong_nn_1 = mkN "jargong" "jargonger" ;
  jarl_nn_1 = mkN "jarl" ;
  jarop_nn_1 = mkN "jarop" neutrum ;
  jasaegare_nn_1 = mkN "jasдgare" "jasдgare" ;
  jasmin_nn_1 = mkN "jasmin" "jasminer" ;
  jaspis_nn_1 = mkN "jaspis" ;
  javan_nn_1 = mkN "javan" "javaner" ;
  javanes_nn_1 = mkN "javanes" "javaneser" ;
  javanesisk_av_1 = mkA "javanesisk" ;
  javansk_av_1 = mkA "javansk" ;
  jazzbalett_nn_1 = mkN "jazzbalett" "jazzbaletter" ;
  jazzig_av_1 = mkA "jazzig" ;
  jazzorkester_nn_1 = mkN "jazzorkester" ;
  jeep_nn_1 = mkN "jeep" ;
  jehu_nn_1 = mkN "jehu" "jehut" "jehun" "jehuna" ;
  jeppe_nn_1 = mkN "jeppe" utrum ;
  jeremiad_nn_1 = mkN "jeremiad" "jeremiader" ;
  jerseyko_nn_1 = mkN "jerseyko" "jerseykor" ;
  jesuit_nn_1 = mkN "jesuit" "jesuiter" ;
  jesuitgeneral_nn_1 = mkN "jesuitgeneral" "jesuitgeneraler" ;
  jesuitisk_av_1 = mkA "jesuitisk" ;
  jesuitorden_nn_1 = mkN "jesuitorden" ;
  jetflygplan_nn_1 = mkN "jetflygplan" neutrum ;
  jetmotor_nn_1 = mkN "jetmotor" "jetmotorer" ;
  jetong_nn_1 = mkN "jetong" "jetonger" ;
  jetplan_nn_1 = mkN "jetplan" neutrum ;
  jetstroem_nn_1 = mkN "jetstrцm" "jetstrцmmen" "jetstrцmmar" "jetstrцmmarna" ;
  jig_nn_1 = mkN "jig" ;
  jigg_nn_1 = mkN "jigg" ;
  jingoism_nn_1 = mkN "jingoism" "jingoismer" ;
  jippo_nn_1 = mkN "jippo" "jippot" "jippon" "jippona" ;
  jobb_nn_1 = mkN "jobb" neutrum ;
  jobbare_nn_1 = mkN "jobbare" "jobbare" ;
  jobberi_nn_1 = mkN "jobberi" "jobberit" "jobberier" "jobberierna" ;
  jobbig_av_1 = mkA "jobbig" ;
  jobspost_nn_1 = mkN "jobspost" "jobsposter" ;
  jockej_nn_1 = mkN "jockej" "jockejer" ;
  jockey_nn_1 = mkN "jockey" ;
  jodtablett_nn_1 = mkN "jodtablett" "jodtabletter" ;
  joekel_nn_1 = mkN "jцkel" ;
  joekelport_nn_1 = mkN "jцkelport" ;
  joens_nn_1 = mkN "jцns" ;
  joensig_av_1 = mkA "jцnsig" ;
  joesse_nn_1 = mkN "jцsse" utrum ;
  johannesoert_nn_1 = mkN "johannesцrt" "johannesцrter" ;
  johannit_nn_1 = mkN "johannit" "johanniter" ;
  johanniterkors_nn_1 = mkN "johanniterkors" neutrum ;
  johanniterorden_nn_1 = mkN "johanniterorden" ;
  joint_nn_1 = mkN "joint" "jointer" ;
  jojk_nn_1 = mkN "jojk" ;
  jojo_nn_1 = mkN "jojo" ;
  joker_nn_1 = mkN "joker" ;
  jokk_nn_1 = mkN "jokk" ;
  jolle_nn_1 = mkN "jolle" utrum ;
  jolmig_av_1 = mkA "jolmig" ;
  jolster_nn_1 = mkN "jolster" ;
  jon_nn_1 = mkN "jon" "joner" ;
  jonbildning_nn_1 = mkN "jonbildning" ;
  jonbindning_nn_1 = mkN "jonbindning" ;
  jonbytare_nn_1 = mkN "jonbytare" "jonbytare" ;
  jonflaeck_nn_1 = mkN "jonflдck" ;
  jonfoerening_nn_1 = mkN "jonfцrening" ;
  jongitter_nn_1 = mkN "jongitter" neutrum ;
  jongloer_nn_1 = mkN "jonglцr" "jonglцrer" ;
  jonier_nn_1 = mkN "jonier" "joniern" "jonier" "jonierna" ;
  jonisation_nn_1 = mkN "jonisation" "jonisationer" ;
  jonisering_nn_1 = mkN "jonisering" ;
  joniseringsenergi_nn_1 = mkN "joniseringsenergi" "joniseringsenergier" ;
  joniseringstendens_nn_1 = mkN "joniseringstendens" "joniseringstendenser" ;
  jonisk_av_1 = mkA "jonisk" ;
  jonkvill_nn_1 = mkN "jonkvill" "jonkviller" ;
  jonstraale_nn_1 = mkN "jonstrеle" utrum ;
  jord_nn_1 = mkN "jord" ;
  jordabalk_nn_1 = mkN "jordabalk" ;
  jordaegare_nn_1 = mkN "jordдgare" "jordдgare" ;
  jordafaerd_nn_1 = mkN "jordafдrd" "jordafдrder" ;
  jordagods_nn_1 = mkN "jordagods" neutrum ;
  jordanalys_nn_1 = mkN "jordanalys" "jordanalyser" ;
  jordande_nn_1 = mkN "jordande" utrum ;
  jordanier_nn_1 = mkN "jordanier" "jordaniern" "jordanier" "jordanierna" ;
  jordansk_av_1 = mkA "jordansk" ;
  jordart_nn_1 = mkN "jordart" "jordarter" ;
  jordartsmetall_nn_1 = mkN "jordartsmetall" "jordartsmetaller" ;
  jordatmosfaer_nn_1 = mkN "jordatmosfдr" "jordatmosfдrer" ;
  jordavsoendring_nn_1 = mkN "jordavsцndring" ;
  jordbaevning_nn_1 = mkN "jordbдvning" ;
  jordbegravning_nn_1 = mkN "jordbegravning" ;
  jordbi_nn_1 = mkN "jordbi" "jordbit" "jordbin" "jordbien" ;
  jordblad_nn_1 = mkN "jordblad" neutrum ;
  jordbruk_nn_1 = mkN "jordbruk" neutrum ;
  jordbrukare_nn_1 = mkN "jordbrukare" "jordbrukare" ;
  jordbruksbebyggelse_nn_1 = mkN "jordbruksbebyggelse" "jordbruksbebyggelser" ;
  jordbruksbefolkning_nn_1 = mkN "jordbruksbefolkning" ;
  jordbruksbygd_nn_1 = mkN "jordbruksbygd" "jordbruksbygder" ;
  jordbrukslandskap_nn_1 = mkN "jordbrukslandskap" "jordbrukslandskapet" "jordbrukslandskapen" "jordbrukslandskapena" ;
  jordbruksmark_nn_1 = mkN "jordbruksmark" "jordbruksmarker" ;
  jordbruksmaskin_nn_1 = mkN "jordbruksmaskin" "jordbruksmaskiner" ;
  jordbruksminister_nn_1 = mkN "jordbruksminister" ;
  jordbruksprodukt_nn_1 = mkN "jordbruksprodukt" "jordbruksprodukter" ;
  jordbruksredskap_nn_1 = mkN "jordbruksredskap" "jordbruksredskapet" "jordbruksredskapen" "jordbruksredskapena" ;
  jordbunden_av_1 = mkA "jordbunden" "jordbundet" ;
  jorddelning_nn_1 = mkN "jorddelning" ;
  jorddrott_nn_1 = mkN "jorddrott" ;
  jordebok_nn_1 = mkN "jordebok" "jordebцcker" ;
  jordegendom_nn_1 = mkN "jordegendom" ;
  jordekorre_nn_1 = mkN "jordekorre" utrum ;
  jorden_runt_seglare_nn_1 = mkN "jorden-runt-seglare" "jorden-runt-seglare" ;
  jordfaerg_nn_1 = mkN "jordfдrg" "jordfдrger" ;
  jordfaergaemne_nn_1 = mkN "jordfдrgдmne" ;
  jordfaestning_nn_1 = mkN "jordfдstning" ;
  jordfast_av_1 = mkA "jordfast" "jordfast" ;
  jordfly_nn_1 = mkN "jordfly" "jordflyt" "jordflyn" "jordflyen" ;
  jordfraes_nn_1 = mkN "jordfrдs" ;
  jordgeting_nn_1 = mkN "jordgeting" ;
  jordglob_nn_1 = mkN "jordglob" "jordglober" ;
  jordgolv_nn_1 = mkN "jordgolv" neutrum ;
  jordgubbe_nn_1 = mkN "jordgubbe" utrum ;
  jordgubbssaft_nn_1 = mkN "jordgubbssaft" "jordgubbssafter" ;
  jordig_av_1 = mkA "jordig" ;
  jordisk_av_1 = mkA "jordisk" ;
  jordkabel_nn_1 = mkN "jordkabel" ;
  jordkaellare_nn_1 = mkN "jordkдllare" "jordkдllare" ;
  jordlager_nn_1 = mkN "jordlager" neutrum ;
  jordledning_nn_1 = mkN "jordledning" ;
  jordlik_av_1 = mkA "jordlik" ;
  jordloepare_nn_1 = mkN "jordlцpare" "jordlцpare" ;
  jordlott_nn_1 = mkN "jordlott" "jordlotter" ;
  jordmateria_nn_1 = mkN "jordmateria" "jordmaterian" "jordmaterier" "jordmaterierna" ;
  jordmaterial_nn_1 = mkN "jordmaterial" neutrum ;
  jordmetall_nn_1 = mkN "jordmetall" "jordmetaller" ;
  jordnaera_av_1 = mkA "jordnдra" ;
  jordnoet_nn_1 = mkN "jordnцt" "jordnцtter" ;
  jordomraade_nn_1 = mkN "jordomrеde" ;
  jordpartikel_nn_1 = mkN "jordpartikel" ;
  jordreform_nn_1 = mkN "jordreform" "jordreformer" ;
  jordregister_nn_1 = mkN "jordregister" neutrum ;
  jordrotation_nn_1 = mkN "jordrotation" "jordrotationer" ;
  jordskalv_nn_1 = mkN "jordskalv" neutrum ;
  jordskott_nn_1 = mkN "jordskott" neutrum ;
  jordskred_nn_1 = mkN "jordskred" neutrum ;
  jordskredsseger_nn_1 = mkN "jordskredsseger" ;
  jordskyld_nn_1 = mkN "jordskyld" "jordskylder" ;
  jordstam_nn_1 = mkN "jordstam" "jordstammen" "jordstammar" "jordstammarna" ;
  jordstoet_nn_1 = mkN "jordstцt" ;
  jordstroem_nn_1 = mkN "jordstrцm" "jordstrцmmen" "jordstrцmmar" "jordstrцmmarna" ;
  jordsvin_nn_1 = mkN "jordsvin" neutrum ;
  jordtaekt_nn_1 = mkN "jordtдkt" "jordtдkter" ;
  jordtag_nn_1 = mkN "jordtag" neutrum ;
  jordtroetthet_nn_1 = mkN "jordtrцtthet" "jordtrцttheter" ;
  jordvaerdestegring_nn_1 = mkN "jordvдrdestegring" ;
  jordvall_nn_1 = mkN "jordvall" ;
  jos_nn_1 = mkN "jos" "joser" ;
  joule_nn_1 = mkN "joule" "joulen" "joule" "joulena" ;
  jour_nn_1 = mkN "jour" "jourer" ;
  jourbutik_nn_1 = mkN "jourbutik" "jourbutiker" ;
  jourhavande_av_1 = mkA "jourhavande" ;
  jourhavande_nn_1 = mkN "jourhavande" "jourhavanden" "jourhavande" "jourhavandena" ;
  journal_nn_1 = mkN "journal" "journaler" ;
  journalfilm_nn_1 = mkN "journalfilm" "journalfilmer" ;
  journalist_nn_1 = mkN "journalist" "journalister" ;
  journalistisk_av_1 = mkA "journalistisk" ;
  jovial_av_1 = mkA "jovial" ;
  jovialisk_av_1 = mkA "jovialisk" ;
  jovialitet_nn_1 = mkN "jovialitet" "jovialiteter" ;
  joxig_av_1 = mkA "joxig" ;
  ju_ab_1 = mkAdv "ju" ;
  jubelaar_nn_1 = mkN "jubelеr" neutrum ;
  jubelaasna_nn_1 = mkN "jubelеsna" ;
  jubeldag_nn_1 = mkN "jubeldag" ;
  jubeldoktor_nn_1 = mkN "jubeldoktor" "jubeldoktorer" ;
  jubelidiot_nn_1 = mkN "jubelidiot" "jubelidioter" ;
  jubilar_nn_1 = mkN "jubilar" "jubilarer" ;
  jubileum_nn_1 = mkN "jubileum" "jubileet" "jubileer" "jubileerna" ;
  jubileumsmynt_nn_1 = mkN "jubileumsmynt" neutrum ;
  jublande_av_1 = mkA "jublande" ;
  judasgaerning_nn_1 = mkN "judasgдrning" ;
  judaskyss_nn_1 = mkN "judaskyss" ;
  judaspeng_nn_1 = mkN "judaspeng" ;
  jude_nn_1 = mkN "jude" utrum ;
  judebroed_nn_1 = mkN "judebrцd" neutrum ;
  judefoerfoeljelse_nn_1 = mkN "judefцrfцljelse" "judefцrfцljelser" ;
  judekristen_av_1 = mkA "judekristen" "judekristet" ;
  judendom_nn_1 = mkN "judendom" ;
  judenhet_nn_1 = mkN "judenhet" "judenheter" ;
  judiciell_av_1 = mkA "judiciell" ;
  judinna_nn_1 = mkN "judinna" ;
  judisk_av_1 = mkA "judisk" ;
  jugoslav_nn_1 = mkN "jugoslav" "jugoslaver" ;
  jugoslavisk_av_1 = mkA "jugoslavisk" ;
  juice_nn_1 = mkN "juice" "juicer" ;
  jukebox_nn_1 = mkN "jukebox" ;
  jul_nn_1 = mkN "jul" ;
  julafton_nn_1 = mkN "julafton" "julaftonen" "julaftnar" "julaftnarna" ;
  julbock_nn_1 = mkN "julbock" ;
  julboen_nn_1 = mkN "julbцn" "julbцner" ;
  julbord_nn_1 = mkN "julbord" neutrum ;
  juldag_nn_1 = mkN "juldag" ;
  juldagsmorgon_nn_1 = mkN "juldagsmorgon" "juldagsmorgonen" "juldagsmorgnar" "juldagsmorgnarna" ;
  julevangelium_nn_1 = mkN "julevangelium" "julevangeliet" "julevangelier" "julevangelierna" ;
  julgran_nn_1 = mkN "julgran" ;
  julgransfot_nn_1 = mkN "julgransfot" "julgransfцtter" ;
  julgranskaramell_nn_1 = mkN "julgranskaramell" "julgranskarameller" ;
  julgransplundring_nn_1 = mkN "julgransplundring" ;
  julgransprydnad_nn_1 = mkN "julgransprydnad" "julgransprydnader" ;
  julgris_nn_1 = mkN "julgris" ;
  julgrupp_nn_1 = mkN "julgrupp" "julgrupper" ;
  julhelg_nn_1 = mkN "julhelg" "julhelger" ;
  juliansk_av_1 = mkA "juliansk" ;
  julkaerve_nn_1 = mkN "julkдrve" utrum ;
  julkaktus_nn_1 = mkN "julkaktus" ;
  julklapp_nn_1 = mkN "julklapp" ;
  julkort_nn_1 = mkN "julkort" neutrum ;
  julle_nn_1 = mkN "julle" utrum ;
  julp_nn_1 = mkN "julp" ;
  julskyltning_nn_1 = mkN "julskyltning" ;
  jultidning_nn_1 = mkN "jultidning" ;
  jultomte_nn_1 = mkN "jultomte" utrum ;
  jumbojet_nn_1 = mkN "jumbojet" ;
  jumper_nn_1 = mkN "jumper" ;
  jungfru_nn_1 = mkN "jungfru" "jungfrun" "jungfrur" "jungfrurna" ;
  jungfrualstring_nn_1 = mkN "jungfrualstring" ;
  jungfruben_nn_1 = mkN "jungfruben" neutrum ;
  jungfruboerd_nn_1 = mkN "jungfrubцrd" "jungfrubцrder" ;
  jungfrubroest_nn_1 = mkN "jungfrubrцst" neutrum ;
  jungfrubur_nn_1 = mkN "jungfrubur" ;
  jungfrudom_nn_1 = mkN "jungfrudom" ;
  jungfrufoedsel_nn_1 = mkN "jungfrufцdsel" ;
  jungfrukammare_nn_1 = mkN "jungfrukammare" "jungfrukammaren" "jungfrukamrar" "jungfrukamrarna" ;
  jungfrulig_av_1 = mkA "jungfrulig" ;
  jungfrustift_nn_1 = mkN "jungfrustift" neutrum ;
  jungfrusvaerm_nn_1 = mkN "jungfrusvдrm" ;
  jungfrutal_nn_1 = mkN "jungfrutal" "jungfrutalet" "jungfrutalen" "jungfrutalena" ;
  jungman_nn_1 = mkN "jungman" "jungmannen" "jungmдn" "jungmдnnen" ;
  junior_av_1 = mkA "junior" ;
  junior_nn_1 = mkN "junior" "junioren" "juniorer" "juniorerna" ;
  junker_nn_1 = mkN "junker" ;
  junonisk_av_1 = mkA "junonisk" ;
  juridisk_av_1 = mkA "juridisk" ;
  juris_av_1 = mkA "juris" ;
  jurist_nn_1 = mkN "jurist" "jurister" ;
  jurt_nn_1 = mkN "jurt" neutrum ;
  jury_nn_1 = mkN "jury" "juryer" ;
  jus_nn_1 = mkN "jus" "juser" ;
  just_ab_1 = mkAdv "just" ;
  just_av_1 = mkA "just" "just" ;
  juste_av_1 = mkA "juste" "justt" ;
  justerare_nn_1 = mkN "justerare" "justerare" ;
  justering_nn_1 = mkN "justering" ;
  justeringsman_nn_1 = mkN "justeringsman" "justeringsmannen" "justeringsmдn" "justeringsmдnnen" ;
  justitiedepartement_nn_1 = mkN "justitiedepartement" "justitiedepartementet" "justitiedepartementen" "justitiedepartementena" ;
  justitieminister_nn_1 = mkN "justitieminister" ;
  justitiemord_nn_1 = mkN "justitiemord" neutrum ;
  justitieombudsman_nn_1 = mkN "justitieombudsman" "justitieombudsmannen" "justitieombudsmдn" "justitieombudsmдnnen" ;
  justitieraad_nn_1 = mkN "justitierеd" neutrum ;
  jute_nn_2 = mkN "jute" utrum ;
  jutlaendsk_av_1 = mkA "jutlдndsk" ;
  jutsk_av_1 = mkA "jutsk" ;
  juvel_nn_1 = mkN "juvel" "juveler" ;
  juvelerare_nn_1 = mkN "juvelerare" "juvelerare" ;
  juvenil_av_1 = mkA "juvenil" ;
  juver_nn_1 = mkN "juver" neutrum ;
  juverinflammation_nn_1 = mkN "juverinflammation" "juverinflammationer" ;
  juvervaevnad_nn_1 = mkN "juvervдvnad" "juvervдvnader" ;
  juxtaposition_nn_1 = mkN "juxtaposition" "juxtapositioner" ;
  jycke_nn_1 = mkN "jycke" utrum ;
  jyllaendsk_av_1 = mkA "jyllдndsk" ;
  jyllaenning_nn_1 = mkN "jyllдnning" ;
  kaadig_av_1 = mkA "kеdig" ;
  kaadrik_av_1 = mkA "kеdrik" ;
  kaak_nn_1 = mkN "kеk" ;
  kaakfarare_nn_1 = mkN "kеkfarare" "kеkfarare" ;
  kaaldolma_nn_1 = mkN "kеldolma" "kеldolman" "kеldolmaar" "kеldolmaarna" ;
  kaalfjaeril_nn_1 = mkN "kеlfjдril" ;
  kaalhuvud_nn_1 = mkN "kеlhuvud" "kеlhuvudet" "kеlhuvuden" "kеlhuvudena" ;
  kaallapp_nn_1 = mkN "kеllapp" ;
  kaalmask_nn_1 = mkN "kеlmask" ;
  kaalrot_nn_1 = mkN "kеlrot" "kеlrцtter" ;
  kaalsupare_nn_1 = mkN "kеlsupare" "kеlsupare" ;
  kaar_nn_1 = mkN "kеr" "kеrer" ;
  kaare_nn_1 = mkN "kеre" utrum ;
  kaarhus_nn_1 = mkN "kеrhus" neutrum ;
  kaarknutte_nn_1 = mkN "kеrknutte" utrum ;
  kaarordfoerande_nn_1 = mkN "kеrordfцrande" "kеrordfцranden" "kеrordfцrande" "kеrordfцrandena" ;
  kaarpamp_nn_1 = mkN "kеrpamp" ;
  kaaseri_nn_1 = mkN "kеseri" "kеserit" "kеserier" "kеserierna" ;
  kaasoer_nn_1 = mkN "kеsцr" "kеsцrer" ;
  kabal_nn_1 = mkN "kabal" "kabaler" ;
  kabare_nn_1 = mkN "kabarй" "kabarйer" ;
  kabareorkester_nn_1 = mkN "kabarйorkester" ;
  kabbalist_nn_1 = mkN "kabbalist" "kabbalister" ;
  kabel_nn_1 = mkN "kabel" ;
  kabelbro_nn_1 = mkN "kabelbro" ;
  kabelbrunn_nn_1 = mkN "kabelbrunn" ;
  kabelgatt_nn_1 = mkN "kabelgatt" neutrum ;
  kabellaengd_nn_1 = mkN "kabellдngd" "kabellдngder" ;
  kabelskaap_nn_1 = mkN "kabelskеp" neutrum ;
  kabelslagen_av_1 = mkA "kabelslagen" "kabelslaget" ;
  kabin_nn_1 = mkN "kabin" "kabiner" ;
  kabinbaat_nn_1 = mkN "kabinbеt" ;
  kabinett_nn_1 = mkN "kabinett" neutrum ;
  kabinettsformat_nn_1 = mkN "kabinettsformat" neutrum ;
  kabinettsfraaga_nn_1 = mkN "kabinettsfrеga" ;
  kabinettskort_nn_1 = mkN "kabinettskort" neutrum ;
  kabinettsorder_nn_1 = mkN "kabinettsorder" ;
  kabinettspass_nn_1 = mkN "kabinettspass" neutrum ;
  kabinettssekreterare_nn_1 = mkN "kabinettssekreterare" "kabinettssekreterare" ;
  kabyl_nn_1 = mkN "kabyl" "kabyler" ;
  kabylisk_av_1 = mkA "kabylisk" ;
  kabyss_nn_1 = mkN "kabyss" "kabysser" ;
  kadaver_nn_1 = mkN "kadaver" neutrum ;
  kadaverlydnad_nn_1 = mkN "kadaverlydnad" "kadaverlydnader" ;
  kadens_nn_1 = mkN "kadens" "kadenser" ;
  kader_nn_1 = mkN "kader" ;
  kaderoevning_nn_1 = mkN "kaderцvning" ;
  kadersystem_nn_1 = mkN "kadersystem" neutrum ;
  kadett_nn_1 = mkN "kadett" "kadetter" ;
  kadettfartyg_nn_1 = mkN "kadettfartyg" neutrum ;
  kadettkaar_nn_1 = mkN "kadettkеr" "kadettkеrer" ;
  kadi_nn_1 = mkN "kadi" "kadin" "kadier" "kadierna" ;
  kadmiumgul_av_1 = mkA "kadmiumgul" ;
  kadmiumjon_nn_1 = mkN "kadmiumjon" "kadmiumjoner" ;
  kadrilj_nn_1 = mkN "kadrilj" "kadriljer" ;
  kaeck_av_1 = mkA "kдck" ;
  kaeft_nn_1 = mkN "kдft" ;
  kaegel_nn_1 = mkN "kдgel" ;
  kaegelformig_av_1 = mkA "kдgelformig" ;
  kaegelsnitt_nn_1 = mkN "kдgelsnitt" neutrum ;
  kaegla_nn_1 = mkN "kдgla" ;
  kaekben_nn_1 = mkN "kдkben" neutrum ;
  kaeke_nn_1 = mkN "kдke" utrum ;
  kaekled_nn_1 = mkN "kдkled" "kдkleder" ;
  kaekrem_nn_1 = mkN "kдkrem" "kдkremmen" "kдkremmar" "kдkremmarna" ;
  kael_nn_1 = mkN "kдl" ;
  kaelkbacke_nn_1 = mkN "kдlkbacke" utrum ;
  kaelkborgare_nn_1 = mkN "kдlkborgare" "kдlkborgare" ;
  kaelke_nn_1 = mkN "kдlke" utrum ;
  kaellaader_nn_1 = mkN "kдllеder" "kдllеdern" "kдllеdror" "kдllеdrorna" ;
  kaellaadra_nn_1 = mkN "kдllеdra" ;
  kaellare_nn_1 = mkN "kдllare" "kдllare" ;
  kaellarhals_nn_1 = mkN "kдllarhals" ;
  kaellarmaestare_nn_1 = mkN "kдllarmдstare" "kдllarmдstare" ;
  kaellarvaaning_nn_1 = mkN "kдllarvеning" ;
  kaelldrag_nn_1 = mkN "kдlldrag" neutrum ;
  kaellfloede_nn_1 = mkN "kдllflцde" ;
  kaellfoerteckning_nn_1 = mkN "kдllfцrteckning" ;
  kaellhaenvisning_nn_1 = mkN "kдllhдnvisning" ;
  kaelling_nn_1 = mkN "kдlling" ;
  kaellmaterial_nn_1 = mkN "kдllmaterial" neutrum ;
  kaellsjoe_nn_1 = mkN "kдllsjц" ;
  kaellskrift_nn_1 = mkN "kдllskrift" "kдllskrifter" ;
  kaellspraang_nn_1 = mkN "kдllsprеng" neutrum ;
  kaellvatten_nn_1 = mkN "kдllvatten" "kдllvattnet" "kдllvatten" "kдllvattnen" ;
  kaemnaersraett_nn_1 = mkN "kдmnдrsrдtt" "kдmnдrsrдtter" ;
  kaempagrav_nn_1 = mkN "kдmpagrav" ;
  kaempalek_nn_1 = mkN "kдmpalek" ;
  kaempalik_av_1 = mkA "kдmpalik" ;
  kaempatag_nn_1 = mkN "kдmpatag" neutrum ;
  kaempe_nn_1 = mkN "kдmpe" utrum ;
  kaempig_av_1 = mkA "kдmpig" ;
  kaend_av_1 = mkA "kдnd" ;
  kaendis_nn_1 = mkN "kдndis" ;
  kaenguru_nn_1 = mkN "kдnguru" "kдngurun" "kдngurur" "kдngururna" ;
  kaengurupung_nn_1 = mkN "kдngurupung" ;
  kaennare_nn_1 = mkN "kдnnare" "kдnnare" ;
  kaennbar_av_1 = mkA "kдnnbar" ;
  kaennedom_nn_1 = mkN "kдnnedom" ;
  kaennemaerke_nn_1 = mkN "kдnnemдrke" ;
  kaennetecken_nn_1 = mkN "kдnnetecken" "kдnnetecknet" "kдnnetecken" "kдnnetecknen" ;
  kaenning_nn_1 = mkN "kдnning" ;
  kaenselhaar_nn_1 = mkN "kдnselhеr" neutrum ;
  kaenselorgan_nn_1 = mkN "kдnselorgan" neutrum ;
  kaenselsproet_nn_1 = mkN "kдnselsprцt" neutrum ;
  kaensla_nn_1 = mkN "kдnsla" ;
  kaenslig_av_1 = mkA "kдnslig" ;
  kaenslighet_nn_1 = mkN "kдnslighet" "kдnsligheter" ;
  kaenslofylld_av_1 = mkA "kдnslofylld" "kдnslofyllt" ;
  kaenslokall_av_1 = mkA "kдnslokall" ;
  kaenslolaege_nn_1 = mkN "kдnslolдge" ;
  kaensloloes_av_1 = mkA "kдnslolцs" ;
  kaenslomaenniska_nn_1 = mkN "kдnslomдnniska" ;
  kaenslomaessig_av_1 = mkA "kдnslomдssig" ;
  kaenslosam_av_1 = mkA "kдnslosam" "kдnslosamt" "kдnslosamma" "kдnslosamma" "kдnslosammare" "kдnslosammast" "kдnslosammaste" ;
  kaenslosamhet_nn_1 = mkN "kдnslosamhet" "kдnslosamheter" ;
  kaenslostraeng_nn_1 = mkN "kдnslostrдng" ;
  kaepp_nn_1 = mkN "kдpp" ;
  kaepphaest_nn_1 = mkN "kдpphдst" ;
  kaeppraett_ab_1 = mkAdv "kдpprдtt" ;
  kaepprak_av_1 = mkA "kдpprak" ;
  kaer_av_1 = mkA "kдr" ;
  kaeraelskelig_av_1 = mkA "kдrдlskelig" ;
  kaerande_nn_1 = mkN "kдrande" "kдranden" "kдrande" "kдrandena" ;
  kaeril_nn_1 = mkN "kдril" neutrum ;
  kaering_nn_1 = mkN "kдring" ;
  kaeringknop_nn_1 = mkN "kдringknop" ;
  kaeringknut_nn_1 = mkN "kдringknut" ;
  kaeringkrok_nn_1 = mkN "kдringkrok" ;
  kaerkommen_av_1 = mkA "kдrkommen" "kдrkommet" "kдrkomna" "kдrkomna" "kдrkomnare" "kдrkomnast" "kдrkomnaste" ;
  kaerl_nn_1 = mkN "kдrl" neutrum ;
  kaerlek_nn_1 = mkN "kдrlek" ;
  kaerleksaffaer_nn_1 = mkN "kдrleksaffдr" "kдrleksaffдrer" ;
  kaerleksakt_nn_1 = mkN "kдrleksakt" "kдrleksakter" ;
  kaerleksbarn_nn_1 = mkN "kдrleksbarn" neutrum ;
  kaerleksbetygelse_nn_1 = mkN "kдrleksbetygelse" "kдrleksbetygelser" ;
  kaerleksbud_nn_1 = mkN "kдrleksbud" neutrum ;
  kaerleksdikt_nn_1 = mkN "kдrleksdikt" "kдrleksdikter" ;
  kaerleksdryck_nn_1 = mkN "kдrleksdryck" "kдrleksdrycker" ;
  kaerleksfoerbindelse_nn_1 = mkN "kдrleksfцrbindelse" "kдrleksfцrbindelser" ;
  kaerleksfoerhaallande_nn_1 = mkN "kдrleksfцrhеllande" ;
  kaerleksfull_av_1 = mkA "kдrleksfull" ;
  kaerleksgud_nn_1 = mkN "kдrleksgud" ;
  kaerlekshistoria_nn_1 = mkN "kдrlekshistoria" "kдrlekshistorien" "kдrlekshistorier" "kдrlekshistorierna" ;
  kaerlekskonflikt_nn_1 = mkN "kдrlekskonflikt" "kдrlekskonflikter" ;
  kaerlekskrank_av_1 = mkA "kдrlekskrank" ;
  kaerlekskval_nn_1 = mkN "kдrlekskval" neutrum ;
  kaerleksloes_av_1 = mkA "kдrlekslцs" ;
  kaerleksmoete_nn_1 = mkN "kдrleksmцte" ;
  kaerlekspar_nn_1 = mkN "kдrlekspar" neutrum ;
  kaerleksrelation_nn_1 = mkN "kдrleksrelation" "kдrleksrelationer" ;
  kaerleksroman_nn_1 = mkN "kдrleksroman" "kдrleksromaner" ;
  kaerlekssaga_nn_1 = mkN "kдrlekssaga" ;
  kaerlig_av_1 = mkA "kдrlig" ;
  kaerligen_ab_1 = mkAdv "kдrligen" ;
  kaerlsjukdom_nn_1 = mkN "kдrlsjukdom" ;
  kaerlsvulst_nn_1 = mkN "kдrlsvulst" "kдrlsvulster" ;
  kaernfamilj_nn_1 = mkN "kдrnfamilj" "kдrnfamiljer" ;
  kaernfoerande_av_1 = mkA "kдrnfцrande" ;
  kaernfri_av_1 = mkA "kдrnfri" "kдrnfritt" ;
  kaernfrisk_av_1 = mkA "kдrnfrisk" ;
  kaernfrukt_nn_1 = mkN "kдrnfrukt" "kдrnfrukter" ;
  kaernfull_av_1 = mkA "kдrnfull" ;
  kaerngubbe_nn_1 = mkN "kдrngubbe" utrum ;
  kaernhus_nn_1 = mkN "kдrnhus" neutrum ;
  kaernkraftinspektion_nn_1 = mkN "kдrnkraftinspektion" "kдrnkraftinspektioner" ;
  kaernkraftsaekerhet_nn_1 = mkN "kдrnkraftsдkerhet" "kдrnkraftsдkerheter" ;
  kaernkraftsoperatoer_nn_1 = mkN "kдrnkraftsoperatцr" "kдrnkraftsoperatцrer" ;
  kaernkraftverk_nn_1 = mkN "kдrnkraftverk" neutrum ;
  kaernladdning_nn_1 = mkN "kдrnladdning" ;
  kaernlinje_nn_1 = mkN "kдrnlinje" "kдrnlinjer" ;
  kaernminne_nn_1 = mkN "kдrnminne" ;
  kaernpartikel_nn_1 = mkN "kдrnpartikel" ;
  kaernpunkt_nn_1 = mkN "kдrnpunkt" "kдrnpunkter" ;
  kaernreaktion_nn_1 = mkN "kдrnreaktion" "kдrnreaktioner" ;
  kaernreaktor_nn_1 = mkN "kдrnreaktor" "kдrnreaktorer" ;
  kaernsoenderfall_nn_1 = mkN "kдrnsцnderfall" neutrum ;
  kaerntrupp_nn_1 = mkN "kдrntrupp" "kдrntrupper" ;
  kaernvapen_nn_1 = mkN "kдrnvapen" "kдrnvapnet" "kдrnvapen" "kдrnvapnen" ;
  kaernvapenarsenal_nn_1 = mkN "kдrnvapenarsenal" "kдrnvapenarsenaler" ;
  kaernvapenbaerande_av_1 = mkA "kдrnvapenbдrande" ;
  kaernvapenexplosion_nn_1 = mkN "kдrnvapenexplosion" "kдrnvapenexplosioner" ;
  kaernvapenfri_av_1 = mkA "kдrnvapenfri" "kдrnvapenfritt" ;
  kaernvapenkrig_nn_1 = mkN "kдrnvapenkrig" neutrum ;
  kaernvapenmakt_nn_1 = mkN "kдrnvapenmakt" "kдrnvapenmakter" ;
  kaernvapenparaply_nn_1 = mkN "kдrnvapenparaply" "kдrnvapenparaplyer" ;
  kaernvapenprov_nn_1 = mkN "kдrnvapenprov" neutrum ;
  kaernvapenstrategi_nn_1 = mkN "kдrnvapenstrategi" "kдrnvapenstrategier" ;
  kaeromaal_nn_1 = mkN "kдromеl" neutrum ;
  kaerr_nn_1 = mkN "kдrr" neutrum ;
  kaerraeng_nn_1 = mkN "kдrrдng" ;
  kaerrhoek_nn_1 = mkN "kдrrhцk" ;
  kaerring_nn_1 = mkN "kдrring" ;
  kaerrvial_nn_1 = mkN "kдrrvial" "kдrrvialer" ;
  kaerv_av_1 = mkA "kдrv" ;
  kaervaenlig_av_1 = mkA "kдrvдnlig" ;
  kaerve_nn_1 = mkN "kдrve" utrum ;
  kaettarbaal_nn_1 = mkN "kдttarbеl" neutrum ;
  kaettare_nn_1 = mkN "kдttare" "kдttare" ;
  kaette_nn_1 = mkN "kдtte" utrum ;
  kaetteri_nn_1 = mkN "kдtteri" "kдtterit" "kдtterier" "kдtterierna" ;
  kaettersk_av_1 = mkA "kдttersk" ;
  kaetting_nn_1 = mkN "kдtting" ;
  kaettjefull_av_1 = mkA "kдttjefull" ;
  kaex_nn_1 = mkN "kдx" neutrum ;
  kafe_nn_1 = mkN "kafй" "kafйt" "kafйer" "kafйerna" ;
  kaferoerelse_nn_1 = mkN "kafйrцrelse" "kafйrцrelser" ;
  kafevagn_nn_1 = mkN "kafйvagn" ;
  kaffeautomat_nn_1 = mkN "kaffeautomat" "kaffeautomater" ;
  kaffebal_nn_1 = mkN "kaffebal" ;
  kaffebord_nn_1 = mkN "kaffebord" neutrum ;
  kaffebrun_av_1 = mkA "kaffebrun" ;
  kaffebryggare_nn_1 = mkN "kaffebryggare" "kaffebryggare" ;
  kaffebuske_nn_1 = mkN "kaffebuske" utrum ;
  kaffedags_ab_1 = mkAdv "kaffedags" ;
  kaffedrickande_nn_1 = mkN "kaffedrickande" ;
  kaffeduk_nn_1 = mkN "kaffeduk" ;
  kaffeersaettning_nn_1 = mkN "kaffeersдttning" ;
  kaffefat_nn_1 = mkN "kaffefat" neutrum ;
  kaffefilter_nn_1 = mkN "kaffefilter" neutrum ;
  kaffegoek_nn_1 = mkN "kaffegцk" ;
  kaffekask_nn_1 = mkN "kaffekask" ;
  kaffekittel_nn_1 = mkN "kaffekittel" ;
  kaffekokare_nn_1 = mkN "kaffekokare" "kaffekokare" ;
  kaffekopp_nn_1 = mkN "kaffekopp" ;
  kaffekvarn_nn_1 = mkN "kaffekvarn" ;
  kaffemoster_nn_1 = mkN "kaffemoster" ;
  kaffepetter_nn_1 = mkN "kaffepetter" ;
  kaffepulver_nn_1 = mkN "kaffepulver" neutrum ;
  kaffer_nn_1 = mkN "kaffer" "kaffern" "kaffrer" "kaffrerna" ;
  kafferast_nn_1 = mkN "kafferast" "kafferaster" ;
  kafferbuffel_nn_1 = mkN "kafferbuffel" ;
  kafferep_nn_1 = mkN "kafferep" neutrum ;
  kafferosteri_nn_1 = mkN "kafferosteri" "kafferosterit" "kafferosterier" "kafferosterierna" ;
  kafferspjut_nn_1 = mkN "kafferspjut" neutrum ;
  kafferspraak_nn_1 = mkN "kaffersprеk" neutrum ;
  kaffeservering_nn_1 = mkN "kaffeservering" ;
  kaffesked_nn_1 = mkN "kaffesked" ;
  kaffetaar_nn_1 = mkN "kaffetеr" ;
  kaffetant_nn_1 = mkN "kaffetant" "kaffetanter" ;
  kaffetraed_nn_1 = mkN "kaffetrдd" neutrum ;
  kaftan_nn_1 = mkN "kaftan" "kaftaner" ;
  kagge_nn_1 = mkN "kagge" utrum ;
  kaj_nn_1 = mkN "kaj" "kajer" ;
  kajak_nn_1 = mkN "kajak" "kajaker" ;
  kajavgift_nn_1 = mkN "kajavgift" "kajavgifter" ;
  kajdjup_nn_1 = mkN "kajdjup" neutrum ;
  kajfritt_ab_1 = mkAdv "kajfritt" ;
  kajman_nn_1 = mkN "kajman" "kajmaner" ;
  kajplats_nn_1 = mkN "kajplats" "kajplatser" ;
  kajskoning_nn_1 = mkN "kajskoning" ;
  kajutdaeck_nn_1 = mkN "kajutdдck" neutrum ;
  kajutpost_nn_1 = mkN "kajutpost" "kajutposter" ;
  kakafoni_nn_1 = mkN "kakafoni" "kakafonier" ;
  kakaolikoer_nn_1 = mkN "kakaolikцr" "kakaolikцrer" ;
  kakaotraed_nn_1 = mkN "kakaotrдd" neutrum ;
  kakbak_nn_1 = mkN "kakbak" neutrum ;
  kakburk_nn_1 = mkN "kakburk" ;
  kakel_nn_1 = mkN "kakel" neutrum ;
  kakelugn_nn_1 = mkN "kakelugn" ;
  kakelugnsmakare_nn_1 = mkN "kakelugnsmakare" "kakelugnsmakare" ;
  kakelugnsnisch_nn_1 = mkN "kakelugnsnisch" "kakelugnsnischer" ;
  kakelugnssaettare_nn_1 = mkN "kakelugnssдttare" "kakelugnssдttare" ;
  kakelugnsventil_nn_1 = mkN "kakelugnsventil" "kakelugnsventiler" ;
  kakfat_nn_1 = mkN "kakfat" neutrum ;
  kakform_nn_1 = mkN "kakform" ;
  kakmaatt_nn_1 = mkN "kakmеtt" neutrum ;
  kakmix_nn_1 = mkN "kakmix" ;
  kakofoni_nn_1 = mkN "kakofoni" "kakofonier" ;
  kaksmet_nn_1 = mkN "kaksmet" "kaksmeter" ;
  kaktaang_nn_1 = mkN "kaktеng" "kaktдnger" ;
  kakte_nn_1 = mkN "kaktй" "kaktйer" ;
  kaktus_nn_1 = mkN "kaktus" ;
  kaktusfikon_nn_1 = mkN "kaktusfikon" neutrum ;
  kakuminal_av_1 = mkA "kakuminal" ;
  kakuminal_nn_1 = mkN "kakuminal" "kakuminaler" ;
  kal_av_1 = mkA "kal" ;
  kalabalik_nn_1 = mkN "kalabalik" "kalabaliker" ;
  kalabass_nn_1 = mkN "kalabass" "kalabasser" ;
  kalaeta_vb_1 = mkV "kalдta" "kalеt" "kalдtit" ;
  kalamitet_nn_1 = mkN "kalamitet" "kalamiteter" ;
  kalander_nn_1 = mkN "kalander" ;
  kalas_nn_1 = mkN "kalas" neutrum ;
  kalaspingla_nn_1 = mkN "kalaspingla" ;
  kalcedon_nn_1 = mkN "kalcedon" "kalcedoner" ;
  kalciumhydroxid_nn_1 = mkN "kalciumhydroxid" "kalciumhydroxider" ;
  kalciumoxid_nn_1 = mkN "kalciumoxid" "kalciumoxider" ;
  kalciumsilikat_nn_1 = mkN "kalciumsilikat" "kalciumsilikater" ;
  kalde_nn_1 = mkN "kaldй" "kaldйer" ;
  kalebass_nn_1 = mkN "kalebass" "kalebasser" ;
  kaledonisk_av_1 = mkA "kaledonisk" ;
  kalejdoskop_nn_1 = mkN "kalejdoskop" neutrum ;
  kalejdoskopisk_av_1 = mkA "kalejdoskopisk" ;
  kalendarisk_av_1 = mkA "kalendarisk" ;
  kalendarium_nn_1 = mkN "kalendarium" "kalendariet" "kalendarier" "kalendarierna" ;
  kalender_nn_1 = mkN "kalender" ;
  kalenderaar_nn_1 = mkN "kalenderеr" neutrum ;
  kalenderbitare_nn_1 = mkN "kalenderbitare" "kalenderbitare" ;
  kalenderdygn_nn_1 = mkN "kalenderdygn" neutrum ;
  kalendermaanad_nn_1 = mkN "kalendermеnad" "kalendermеnader" ;
  kalenderstav_nn_1 = mkN "kalenderstav" ;
  kalendervecka_nn_1 = mkN "kalendervecka" ;
  kalesch_nn_1 = mkN "kalesch" "kalescher" ;
  kalfaktor_nn_1 = mkN "kalfaktor" "kalfaktorer" ;
  kalfjaell_nn_1 = mkN "kalfjдll" neutrum ;
  kalhugga_vb_1 = mkV "kalhugga" "kalhцgg" "kalhuggit" ;
  kalhygge_nn_1 = mkN "kalhygge" ;
  kaliber_nn_1 = mkN "kaliber" ;
  kaliberborr_nn_1 = mkN "kaliberborr" ;
  kalibertolk_nn_1 = mkN "kalibertolk" ;
  kalif_nn_1 = mkN "kalif" "kalifer" ;
  kalifat_nn_1 = mkN "kalifat" neutrum ;
  kalisalt_nn_1 = mkN "kalisalt" "kalisaltet" "kalisalter" "kalisalterna" ;
  kaliumhydroxid_nn_1 = mkN "kaliumhydroxid" "kaliumhydroxider" ;
  kaliumjon_nn_1 = mkN "kaliumjon" "kaliumjoner" ;
  kalk_nn_2 = mkN "kalk" ;
  kalkalg_nn_1 = mkN "kalkalg" "kalkalger" ;
  kalkanhopning_nn_1 = mkN "kalkanhopning" ;
  kalkbraenneri_nn_1 = mkN "kalkbrдnneri" "kalkbrдnnerit" "kalkbrдnnerier" "kalkbrдnnerierna" ;
  kalkbrott_nn_1 = mkN "kalkbrott" neutrum ;
  kalkbruk_nn_1 = mkN "kalkbruk" neutrum ;
  kalkerpapper_nn_1 = mkN "kalkerpapper" neutrum ;
  kalkfaerg_nn_1 = mkN "kalkfдrg" "kalkfдrger" ;
  kalkfattig_av_1 = mkA "kalkfattig" ;
  kalkgrund_nn_1 = mkN "kalkgrund" "kalkgrunder" ;
  kalkhalt_nn_1 = mkN "kalkhalt" "kalkhalter" ;
  kalkhaltig_av_1 = mkA "kalkhaltig" ;
  kalkjon_nn_1 = mkN "kalkjon" "kalkjoner" ;
  kalkmaalning_nn_1 = mkN "kalkmеlning" ;
  kalkomani_nn_1 = mkN "kalkomani" "kalkomanier" ;
  kalkon_nn_1 = mkN "kalkon" "kalkoner" ;
  kalkrest_nn_1 = mkN "kalkrest" "kalkrester" ;
  kalkrik_av_1 = mkA "kalkrik" ;
  kalkskal_nn_1 = mkN "kalkskal" neutrum ;
  kalktuff_nn_1 = mkN "kalktuff" "kalktuffer" ;
  kalkugn_nn_1 = mkN "kalkugn" ;
  kalkyl_nn_1 = mkN "kalkyl" "kalkyler" ;
  kalkylator_nn_1 = mkN "kalkylator" "kalkylatorer" ;
  kalkylerbar_av_1 = mkA "kalkylerbar" ;
  kall_av_1 = mkA "kall" ;
  kall_nn_1 = mkN "kall" neutrum ;
  kallbad_nn_1 = mkN "kallbad" neutrum ;
  kallbaenk_nn_1 = mkN "kallbдnk" ;
  kallblod_nn_1 = mkN "kallblod" neutrum ;
  kallblodig_av_1 = mkA "kallblodig" ;
  kallblodighet_nn_1 = mkN "kallblodighet" "kallblodigheter" ;
  kalldra_vb_1 = mkV "kalldra" "kalldrar" "kalldra" "kalldrog" "kalldragit" "kalldragen" ;
  kalldusch_nn_1 = mkN "kalldusch" ;
  kallelse_nn_1 = mkN "kallelse" "kallelser" ;
  kallelsebeslut_nn_1 = mkN "kallelsebeslut" neutrum ;
  kallelsebrev_nn_1 = mkN "kallelsebrev" neutrum ;
  kallelsefoerslag_nn_1 = mkN "kallelsefцrslag" neutrum ;
  kallelsegaerning_nn_1 = mkN "kallelsegдrning" ;
  kallelsetid_nn_1 = mkN "kallelsetid" "kallelsetider" ;
  kallflytande_av_1 = mkA "kallflytande" ;
  kallfront_nn_1 = mkN "kallfront" "kallfronter" ;
  kallgarage_nn_1 = mkN "kallgarage" "kallgaraget" "kallgarage" "kallgaragen" ;
  kallgrin_nn_1 = mkN "kallgrin" neutrum ;
  kallhus_nn_1 = mkN "kallhus" neutrum ;
  kallmangel_nn_1 = mkN "kallmangel" ;
  kallmur_nn_1 = mkN "kallmur" ;
  kallnaal_nn_1 = mkN "kallnеl" ;
  kallortstillaegg_nn_1 = mkN "kallortstillдgg" neutrum ;
  kallpunkt_nn_1 = mkN "kallpunkt" "kallpunkter" ;
  kallsaag_nn_1 = mkN "kallsеg" ;
  kallsinnig_av_1 = mkA "kallsinnig" ;
  kallskaenk_nn_1 = mkN "kallskдnk" ;
  kallskuren_av_1 = mkA "kallskuren" "kallskuret" ;
  kallstart_nn_1 = mkN "kallstart" "kallstarter" ;
  kallsup_nn_1 = mkN "kallsup" ;
  kallvatten_nn_1 = mkN "kallvatten" "kallvattnet" "kallvatten" "kallvattnen" ;
  kalmark_nn_1 = mkN "kalmark" "kalmarker" ;
  kalmuck_nn_1 = mkN "kalmuck" "kalmucker" ;
  kalori_nn_1 = mkN "kalori" "kalorier" ;
  kaloribehov_nn_1 = mkN "kaloribehov" neutrum ;
  kalorifattig_av_1 = mkA "kalorifattig" ;
  kalorijakt_nn_1 = mkN "kalorijakt" "kalorijakter" ;
  kalorimeter_nn_1 = mkN "kalorimeter" ;
  kaloririk_av_1 = mkA "kaloririk" ;
  kaloritabell_nn_1 = mkN "kaloritabell" "kaloritabeller" ;
  kalorivaerde_nn_1 = mkN "kalorivдrde" ;
  kalott_nn_1 = mkN "kalott" "kalotter" ;
  kalstammig_av_1 = mkA "kalstammig" ;
  kalufs_nn_1 = mkN "kalufs" "kalufser" ;
  kalv_nn_1 = mkN "kalv" ;
  kalvfaerdig_av_1 = mkA "kalvfдrdig" ;
  kalvfrikasse_nn_1 = mkN "kalvfrikassй" "kalvfrikassйer" ;
  kalvill_nn_1 = mkN "kalvill" "kalviller" ;
  kalvinist_nn_1 = mkN "kalvinist" "kalvinister" ;
  kalvinistisk_av_1 = mkA "kalvinistisk" ;
  kalvinsk_av_1 = mkA "kalvinsk" ;
  kalvjaerpe_nn_1 = mkN "kalvjдrpe" utrum ;
  kalvko_nn_1 = mkN "kalvko" "kalvkor" ;
  kalvrulad_nn_1 = mkN "kalvrulad" "kalvrulader" ;
  kalvskinn_nn_1 = mkN "kalvskinn" neutrum ;
  kalvskinnsband_nn_1 = mkN "kalvskinnsband" neutrum ;
  kalvstek_nn_1 = mkN "kalvstek" ;
  kam_nn_1 = mkN "kam" "kammen" "kammar" "kammarna" ;
  kamaxel_nn_1 = mkN "kamaxel" ;
  kambodjan_nn_1 = mkN "kambodjan" "kambodjaner" ;
  kambrisk_av_1 = mkA "kambrisk" ;
  kame_nn_1 = mkN "kamй" "kamйer" ;
  kamel_nn_1 = mkN "kamel" "kameler" ;
  kameldjur_nn_1 = mkN "kameldjur" neutrum ;
  kameleont_nn_1 = mkN "kameleont" "kameleonter" ;
  kamelforskare_nn_1 = mkN "kamelforskare" "kamelforskare" ;
  kamelforskning_nn_1 = mkN "kamelforskning" ;
  kamelforskningsprojekt_nn_1 = mkN "kamelforskningsprojekt" neutrum ;
  kamelherde_nn_1 = mkN "kamelherde" utrum ;
  kamelhjord_nn_1 = mkN "kamelhjord" ;
  kamelmedicin_nn_1 = mkN "kamelmedicin" "kamelmediciner" ;
  kamelopard_nn_1 = mkN "kamelopard" "kameloparder" ;
  kamelpoesi_nn_1 = mkN "kamelpoesi" "kamelpoesier" ;
  kamelsadel_nn_1 = mkN "kamelsadel" ;
  kamelsaeck_nn_1 = mkN "kamelsдck" ;
  kamera_nn_1 = mkN "kamera" ;
  kamerajakt_nn_1 = mkN "kamerajakt" "kamerajakter" ;
  kameral_av_1 = mkA "kameral" ;
  kameraman_nn_1 = mkN "kameraman" "kameramannen" "kameramдn" "kameramдnnen" ;
  kameraobjektiv_nn_1 = mkN "kameraobjektiv" neutrum ;
  kamerunare_nn_1 = mkN "kamerunare" "kamerunare" ;
  kamerunsk_av_1 = mkA "kamerunsk" ;
  kamin_nn_1 = mkN "kamin" "kaminer" ;
  kammanet_nn_1 = mkN "kammanet" "kammaneter" ;
  kammaraaklagare_nn_1 = mkN "kammarеklagare" "kammarеklagare" ;
  kammardressyr_nn_1 = mkN "kammardressyr" "kammardressyrer" ;
  kammare_nn_1 = mkN "kammare" "kammaren" "kamrar" "kamrarna" ;
  kammarherre_nn_1 = mkN "kammarherre" utrum ;
  kammarjungfru_nn_1 = mkN "kammarjungfru" "kammarjungfrun" "kammarjungfrur" "kammarjungfrurna" ;
  kammarjunkare_nn_1 = mkN "kammarjunkare" "kammarjunkare" ;
  kammarlaerd_av_1 = mkA "kammarlдrd" "kammarlдrt" ;
  kammarmusiker_nn_1 = mkN "kammarmusiker" "kammarmusikern" "kammarmusiker" "kammarmusikerna" ;
  kammarorkester_nn_1 = mkN "kammarorkester" ;
  kammarpiano_nn_1 = mkN "kammarpiano" "kammarpianot" "kammarpianon" "kammarpianona" ;
  kammarraett_nn_1 = mkN "kammarrдtt" "kammarrдtter" ;
  kammarskjutning_nn_1 = mkN "kammarskjutning" ;
  kammarskrivare_nn_1 = mkN "kammarskrivare" "kammarskrivare" ;
  kammarskruv_nn_1 = mkN "kammarskruv" ;
  kammarspel_nn_1 = mkN "kammarspel" "kammarspelet" "kammarspel" "kammarspelen" ;
  kammussla_nn_1 = mkN "kammussla" ;
  kamomill_nn_1 = mkN "kamomill" "kamomiller" ;
  kamouflering_nn_1 = mkN "kamouflering" ;
  kamp_nn_1 = mkN "kamp" "kamper" ;
  kamp_nn_2 = mkN "kamp" ;
  kampanil_nn_1 = mkN "kampanil" "kampaniler" ;
  kampanj_nn_1 = mkN "kampanj" "kampanjer" ;
  kampare_nn_1 = mkN "kampare" "kampare" ;
  kampegraes_nn_1 = mkN "kampegrдs" neutrum ;
  kampeschtraed_nn_1 = mkN "kampeschtrдd" neutrum ;
  kamporganisation_nn_1 = mkN "kamporganisation" "kamporganisationer" ;
  kampsaang_nn_1 = mkN "kampsеng" "kampsеnger" ;
  kampsport_nn_1 = mkN "kampsport" "kampsporter" ;
  kampuchean_nn_1 = mkN "kampuchean" "kampucheaner" ;
  kampucheansk_av_1 = mkA "kampucheansk" ;
  kampvilja_nn_1 = mkN "kampvilja" ;
  kamrat_nn_1 = mkN "kamrat" "kamrater" ;
  kamratlig_av_1 = mkA "kamratlig" ;
  kamratpaaverkning_nn_1 = mkN "kamratpеverkning" ;
  kamrer_nn_1 = mkN "kamrer" "kamrerer" ;
  kamrerare_nn_1 = mkN "kamrerare" "kamrerare" ;
  kams_nn_1 = mkN "kams" ;
  kamtsjadal_nn_1 = mkN "kamtsjadal" "kamtsjadaler" ;
  kan_nn_1 = mkN "kan" "kaner" ;
  kanadagaas_nn_1 = mkN "kanadagеs" "kanadagеsen" "kanadagдss" "kanadagдssen" ;
  kanadensare_nn_1 = mkN "kanadensare" "kanadensare" ;
  kanadensisk_av_1 = mkA "kanadensisk" ;
  kanadick_nn_1 = mkN "kanadick" "kanadicker" ;
  kanak_nn_1 = mkN "kanak" "kanaker" ;
  kanal_nn_1 = mkN "kanal" "kanaler" ;
  kanalaangare_nn_1 = mkN "kanalеngare" "kanalеngare" ;
  kanalje_nn_1 = mkN "kanalje" "kanaljer" ;
  kanalkrock_nn_1 = mkN "kanalkrock" ;
  kanalljus_nn_1 = mkN "kanalljus" neutrum ;
  kanalsystem_nn_1 = mkN "kanalsystem" neutrum ;
  kanalvaeljare_nn_1 = mkN "kanalvдljare" "kanalvдljare" ;
  kanane_nn_1 = mkN "kananй" "kananйer" ;
  kanape_nn_1 = mkN "kanapй" "kanapйer" ;
  kanariefaagel_nn_1 = mkN "kanariefеgel" ;
  kanariefroe_nn_1 = mkN "kanariefrц" "kanariefrцt" "kanariefrцn" "kanariefrцen" ;
  kanariegul_av_1 = mkA "kanariegul" ;
  kandar_nn_1 = mkN "kandar" neutrum ;
  kandelaber_nn_1 = mkN "kandelaber" ;
  kandidat_nn_1 = mkN "kandidat" "kandidater" ;
  kandidatur_nn_1 = mkN "kandidatur" "kandidaturer" ;
  kanelbrun_av_1 = mkA "kanelbrun" ;
  kanelstaang_nn_1 = mkN "kanelstеng" "kanelstдnger" ;
  kanfas_nn_1 = mkN "kanfas" "kanfaser" ;
  kanhaenda_ab_1 = mkAdv "kanhдnda" ;
  kanik_nn_1 = mkN "kanik" "kaniker" ;
  kanin_nn_1 = mkN "kanin" "kaniner" ;
  kanister_nn_1 = mkN "kanister" ;
  kanjon_nn_1 = mkN "kanjon" "kanjoner" ;
  kannbrosk_nn_1 = mkN "kannbrosk" neutrum ;
  kannelyr_nn_1 = mkN "kannelyr" "kannelyrer" ;
  kannibal_nn_1 = mkN "kannibal" "kannibaler" ;
  kannibalisk_av_1 = mkA "kannibalisk" ;
  kannstoepare_nn_1 = mkN "kannstцpare" "kannstцpare" ;
  kannstoeperi_nn_1 = mkN "kannstцperi" "kannstцperit" "kannstцperier" "kannstцperierna" ;
  kanon_nn_1 = mkN "kanon" "kanoner" ;
  kanon_nn_2 = mkN "kanon" "kanoner" ;
  kanonad_nn_1 = mkN "kanonad" "kanonader" ;
  kanonbaat_nn_1 = mkN "kanonbеt" ;
  kanonbra_av_1 = mkA "kanonbra" ;
  kanonfotograf_nn_1 = mkN "kanonfotograf" "kanonfotografer" ;
  kanongjuteri_nn_1 = mkN "kanongjuteri" "kanongjuterit" "kanongjuterier" "kanongjuterierna" ;
  kanonisation_nn_1 = mkN "kanonisation" "kanonisationer" ;
  kanonisering_nn_1 = mkN "kanonisering" ;
  kanonisk_av_1 = mkA "kanonisk" ;
  kanonjaer_nn_1 = mkN "kanonjдr" "kanonjдrer" ;
  kanonlock_nn_1 = mkN "kanonlock" ;
  kanonlopp_nn_1 = mkN "kanonlopp" neutrum ;
  kanonport_nn_1 = mkN "kanonport" ;
  kanontorn_nn_1 = mkN "kanontorn" neutrum ;
  kanot_nn_1 = mkN "kanot" "kanoter" ;
  kanotist_nn_1 = mkN "kanotist" "kanotister" ;
  kanske_ab_1 = mkAdv "kanske" ;
  kansler_nn_1 = mkN "kansler" "kanslern" "kanslerer" "kanslererna" ;
  kansli_nn_1 = mkN "kansli" "kanslit" "kanslier" "kanslierna" ;
  kansliraad_nn_1 = mkN "kanslirеd" neutrum ;
  kanslisekreterare_nn_1 = mkN "kanslisekreterare" "kanslisekreterare" ;
  kanslist_nn_1 = mkN "kanslist" "kanslister" ;
  kant_nn_1 = mkN "kant" "kanter" ;
  kantabel_av_1 = mkA "kantabel" "kantabelt" "kantabla" "kantabla" "kantablare" "kantablast" "kantablaste" ;
  kantaenka_ab_1 = mkAdv "kantдnka" ;
  kantarell_nn_1 = mkN "kantarell" "kantareller" ;
  kantat_nn_1 = mkN "kantat" "kantater" ;
  kantband_nn_1 = mkN "kantband" neutrum ;
  kantbeslag_nn_1 = mkN "kantbeslag" neutrum ;
  kantele_nn_1 = mkN "kantele" "kanteler" ;
  kanthugga_vb_1 = mkV "kanthugga" "kanthцgg" "kanthuggit" ;
  kantig_av_1 = mkA "kantig" ;
  kantin_nn_1 = mkN "kantin" "kantiner" ;
  kantnaal_nn_1 = mkN "kantnеl" ;
  kanton_nn_1 = mkN "kanton" "kantoner" ;
  kantor_nn_1 = mkN "kantor" "kantorer" ;
  kantrep_nn_1 = mkN "kantrep" neutrum ;
  kantsoem_nn_1 = mkN "kantsцm" "kantsцmmen" "kantsцmmar" "kantsцmmarna" ;
  kantsten_nn_1 = mkN "kantsten" "kantstenen" "kantstenar" "kantstenarna" ;
  kantstoett_av_1 = mkA "kantstцtt" ;
  kantvaext_nn_1 = mkN "kantvдxt" "kantvдxter" ;
  kanvasband_nn_1 = mkN "kanvasband" neutrum ;
  kanvasduk_nn_1 = mkN "kanvasduk" ;
  kanyl_nn_1 = mkN "kanyl" "kanyler" ;
  kaotisk_av_1 = mkA "kaotisk" ;
  kap_nn_2 = mkN "kap" neutrum ;
  kapabel_av_1 = mkA "kapabel" "kapabelt" "kapabla" "kapabla" "kapablare" "kapablast" "kapablaste" ;
  kapacitet_nn_1 = mkN "kapacitet" "kapaciteter" ;
  kapare_nn_1 = mkN "kapare" "kapare" ;
  kapell_nn_1 = mkN "kapell" neutrum ;
  kapellmaestare_nn_1 = mkN "kapellmдstare" "kapellmдstare" ;
  kaperi_nn_1 = mkN "kaperi" "kaperit" "kaperier" "kaperierna" ;
  kapfaar_nn_1 = mkN "kapfеr" neutrum ;
  kapillaer_av_1 = mkA "kapillдr" ;
  kapillaer_nn_1 = mkN "kapillдr" "kapillдrer" ;
  kapillaerroer_nn_1 = mkN "kapillдrrцr" neutrum ;
  kapillaritet_nn_1 = mkN "kapillaritet" "kapillariteter" ;
  kapitael_nn_1 = mkN "kapitдl" neutrum ;
  kapitael_nn_2 = mkN "kapitдl" "kapitдler" ;
  kapital_av_1 = mkA "kapital" ;
  kapital_nn_1 = mkN "kapital" neutrum ;
  kapitalbeskattning_nn_1 = mkN "kapitalbeskattning" ;
  kapitalbildning_nn_1 = mkN "kapitalbildning" ;
  kapitalbudget_nn_1 = mkN "kapitalbudget" ;
  kapitalfoerlust_nn_1 = mkN "kapitalfцrlust" "kapitalfцrluster" ;
  kapitalfoersaekring_nn_1 = mkN "kapitalfцrsдkring" ;
  kapitalinkomst_nn_1 = mkN "kapitalinkomst" "kapitalinkomster" ;
  kapitalinkomstbeskattning_nn_1 = mkN "kapitalinkomstbeskattning" ;
  kapitalintensiv_av_1 = mkA "kapitalintensiv" ;
  kapitalist_nn_1 = mkN "kapitalist" "kapitalister" ;
  kapitalistisk_av_1 = mkA "kapitalistisk" ;
  kapitalkonto_nn_1 = mkN "kapitalkonto" "kapitalkontot" "kapitalkonton" "kapitalkontona" ;
  kapitalmarknad_nn_1 = mkN "kapitalmarknad" "kapitalmarknader" ;
  kapitalvaerde_nn_1 = mkN "kapitalvдrde" ;
  kapitalvinst_nn_1 = mkN "kapitalvinst" "kapitalvinster" ;
  kapitel_nn_1 = mkN "kapitel" neutrum ;
  kapitelsal_nn_1 = mkN "kapitelsal" ;
  kapitelvis_ab_1 = mkAdv "kapitelvis" ;
  kapitulation_nn_1 = mkN "kapitulation" "kapitulationer" ;
  kaplan_nn_1 = mkN "kaplan" "kaplaner" ;
  kapott_nn_1 = mkN "kapott" "kapotter" ;
  kapp_nn_1 = mkN "kapp" ;
  kappe_nn_1 = mkN "kappe" utrum ;
  kappkoerning_nn_1 = mkN "kappkцrning" ;
  kapploepning_nn_1 = mkN "kapplцpning" ;
  kapprak_av_1 = mkA "kapprak" ;
  kapprock_nn_1 = mkN "kapprock" ;
  kapprum_nn_1 = mkN "kapprum" "kapprummet" "kapprum" "kapprummen" ;
  kapprustning_nn_1 = mkN "kapprustning" ;
  kappsaeck_nn_1 = mkN "kappsдck" ;
  kappseglare_nn_1 = mkN "kappseglare" "kappseglare" ;
  kappsegling_nn_1 = mkN "kappsegling" ;
  kappseglingsbaat_nn_1 = mkN "kappseglingsbеt" ;
  kappsimning_nn_1 = mkN "kappsimning" ;
  kapricioes_av_1 = mkA "kapriciцs" ;
  kaprifol_nn_1 = mkN "kaprifol" "kaprifoler" ;
  kaprifolium_nn_1 = mkN "kaprifolium" "kaprifolien" "kaprifolier" "kaprifolierna" ;
  kapriol_nn_1 = mkN "kapriol" "kaprioler" ;
  kapris_nn_1 = mkN "kapris" "kapriser" ;
  kapsaag_nn_1 = mkN "kapsеg" ;
  kapsel_nn_1 = mkN "kapsel" ;
  kapson_nn_1 = mkN "kapson" "kapsoner" ;
  kapsyl_nn_1 = mkN "kapsyl" "kapsyler" ;
  kapten_nn_1 = mkN "kapten" "kaptener" ;
  kapucin_nn_1 = mkN "kapucin" "kapuciner" ;
  kapucinorden_nn_1 = mkN "kapucinorden" ;
  kapun_nn_1 = mkN "kapun" "kapuner" ;
  kapuschong_nn_1 = mkN "kapuschong" "kapuschonger" ;
  kaputt_av_1 = mkA "kaputt" ;
  kapverdier_nn_1 = mkN "kapverdier" "kapverdiern" "kapverdier" "kapverdierna" ;
  kapverdisk_av_1 = mkA "kapverdisk" ;
  kar_nn_1 = mkN "kar" neutrum ;
  karabinjaer_nn_1 = mkN "karabinjдr" "karabinjдrer" ;
  karaff_nn_1 = mkN "karaff" "karaffer" ;
  karaffin_nn_1 = mkN "karaffin" "karaffiner" ;
  karaktaer_nn_1 = mkN "karaktдr" "karaktдrer" ;
  karaktaeristik_nn_1 = mkN "karaktдristik" "karaktдristiker" ;
  karaktaeristika_nn_2 = mkN "karaktдristika" "karaktдristikan" "karaktдristika" "karaktдristikana" ;
  karaktaeristisk_av_1 = mkA "karaktдristisk" ;
  karaktaersart_nn_1 = mkN "karaktдrsart" "karaktдrsarter" ;
  karaktaersdrag_nn_1 = mkN "karaktдrsdrag" neutrum ;
  karaktaersdrama_nn_1 = mkN "karaktдrsdrama" "karaktдrsdramat" "karaktдrsdraman" "karaktдrsdramana" ;
  karaktaersfast_av_1 = mkA "karaktдrsfast" "karaktдrsfast" ;
  karaktaersfel_nn_1 = mkN "karaktдrsfel" "karaktдrsfelet" "karaktдrsfel" "karaktдrsfelen" ;
  karaktaersroll_nn_1 = mkN "karaktдrsroll" "karaktдrsroller" ;
  karaktaersskaadespelare_nn_1 = mkN "karaktдrsskеdespelare" "karaktдrsskеdespelare" ;
  karaktaerstyp_nn_1 = mkN "karaktдrstyp" "karaktдrstyper" ;
  karakteristik_nn_1 = mkN "karakteristik" "karakteristiker" ;
  karakteristika_nn_2 = mkN "karakteristika" "karakteristikan" "karakteristika" "karakteristikana" ;
  karakteristisk_av_1 = mkA "karakteristisk" ;
  karamboll_nn_1 = mkN "karamboll" "karamboller" ;
  karamell_nn_1 = mkN "karamell" "karameller" ;
  karamellfaerg_nn_1 = mkN "karamellfдrg" "karamellfдrger" ;
  karamellpapper_nn_1 = mkN "karamellpapper" neutrum ;
  karamellpudding_nn_1 = mkN "karamellpudding" ;
  karamellsaas_nn_1 = mkN "karamellsеs" "karamellsеser" ;
  karantaen_nn_1 = mkN "karantдn" "karantдner" ;
  karat_nn_1 = mkN "karat" neutrum ;
  karatering_nn_1 = mkN "karatering" ;
  karatstaempel_nn_1 = mkN "karatstдmpel" ;
  karavan_nn_1 = mkN "karavan" "karavaner" ;
  karavanseraj_nn_1 = mkN "karavanseraj" "karavanserajer" ;
  karavell_nn_1 = mkN "karavell" "karaveller" ;
  karbad_nn_1 = mkN "karbad" neutrum ;
  karbamid_nn_1 = mkN "karbamid" "karbamider" ;
  karbas_nn_1 = mkN "karbas" "karbaser" ;
  karbin_nn_1 = mkN "karbin" "karbiner" ;
  karbinhake_nn_1 = mkN "karbinhake" utrum ;
  karbonat_nn_1 = mkN "karbonat" neutrum ;
  karbonatjon_nn_1 = mkN "karbonatjon" "karbonatjoner" ;
  karbonatsmaeltecell_nn_1 = mkN "karbonatsmдltecell" "karbonatsmдlteceller" ;
  karbonkopia_nn_1 = mkN "karbonkopia" ;
  karbonpapper_nn_1 = mkN "karbonpapper" neutrum ;
  karborundumduk_nn_1 = mkN "karborundumduk" ;
  karbunkel_nn_1 = mkN "karbunkel" ;
  karburator_nn_1 = mkN "karburator" "karburatorer" ;
  karcinogen_av_1 = mkA "karcinogen" ;
  karcinom_nn_1 = mkN "karcinom" neutrum ;
  kardan_nn_1 = mkN "kardan" "kardaner" ;
  kardanaxel_nn_1 = mkN "kardanaxel" ;
  kardanknut_nn_1 = mkN "kardanknut" ;
  kardansk_av_1 = mkA "kardansk" ;
  kardanupphaengning_nn_1 = mkN "kardanupphдngning" ;
  kardborrband_nn_1 = mkN "kardborrband" neutrum ;
  kardborre_nn_1 = mkN "kardborre" utrum ;
  kardborreknaeppning_nn_1 = mkN "kardborreknдppning" ;
  kardel_nn_1 = mkN "kardel" "kardeler" ;
  kardinal_nn_1 = mkN "kardinal" "kardinaler" ;
  kardinalbiskop_nn_1 = mkN "kardinalbiskop" ;
  kardinaldygd_nn_1 = mkN "kardinaldygd" "kardinaldygder" ;
  kardinalfel_nn_1 = mkN "kardinalfel" "kardinalfelet" "kardinalfel" "kardinalfelen" ;
  kardinalstreck_nn_1 = mkN "kardinalstreck" neutrum ;
  kardinaltal_nn_1 = mkN "kardinaltal" "kardinaltalet" "kardinaltalen" "kardinaltalena" ;
  kardiograf_nn_1 = mkN "kardiograf" "kardiografer" ;
  kardiogram_nn_1 = mkN "kardiogram" "kardiogrammet" "kardiogram" "kardiogrammen" ;
  kardiolog_nn_1 = mkN "kardiolog" "kardiologer" ;
  kardnubb_nn_1 = mkN "kardnubb" ;
  kardus_nn_1 = mkN "kardus" "karduser" ;
  karel_nn_1 = mkN "karel" "kareler" ;
  karelare_nn_1 = mkN "karelare" "karelare" ;
  karelsk_av_1 = mkA "karelsk" ;
  karensdag_nn_1 = mkN "karensdag" ;
  karess_nn_1 = mkN "karess" "karesser" ;
  karet_nn_1 = mkN "karet" "kareter" ;
  karg_av_1 = mkA "karg" ;
  karikatyr_nn_1 = mkN "karikatyr" "karikatyrer" ;
  karikatyrtecknare_nn_1 = mkN "karikatyrtecknare" "karikatyrtecknare" ;
  karisma_nn_1 = mkN "karisma" "karisman" "karismer" "karismerna" ;
  karismatisk_av_1 = mkA "karismatisk" ;
  karkas_nn_1 = mkN "karkas" "karkaser" ;
  karl_nn_1 = mkN "karl" ;
  karlakarl_nn_1 = mkN "karlakarl" ;
  karlaktig_av_1 = mkA "karlaktig" ;
  karlatag_nn_1 = mkN "karlatag" neutrum ;
  karlavulen_av_1 = mkA "karlavulen" "karlavulet" ;
  karldagsverke_nn_1 = mkN "karldagsverke" ;
  karled_nn_1 = mkN "karled" "karleder" ;
  karlgalen_av_1 = mkA "karlgalen" "karlgalet" ;
  karljohanssvamp_nn_1 = mkN "karljohanssvamp" ;
  karlsbaderbroed_nn_1 = mkN "karlsbaderbrцd" neutrum ;
  karlslok_nn_1 = mkN "karlslok" ;
  karltokig_av_1 = mkA "karltokig" ;
  karm_nn_1 = mkN "karm" ;
  karmelit_nn_1 = mkN "karmelit" "karmeliter" ;
  karmelitorden_nn_1 = mkN "karmelitorden" ;
  karmstol_nn_1 = mkN "karmstol" ;
  karnap_nn_1 = mkN "karnap" neutrum ;
  karneol_nn_1 = mkN "karneol" "karneoler" ;
  karneval_nn_1 = mkN "karneval" "karnevaler" ;
  karnis_nn_1 = mkN "karnis" "karniser" ;
  karnivor_nn_1 = mkN "karnivor" "karnivoren" "karnivorer" "karnivorerna" ;
  karolin_nn_1 = mkN "karolin" "karoliner" ;
  karoling_nn_1 = mkN "karoling" "karolinger" ;
  karolinsk_av_1 = mkA "karolinsk" ;
  kaross_nn_1 = mkN "kaross" "karosser" ;
  karosseri_nn_1 = mkN "karosseri" "karosserit" "karosserier" "karosserierna" ;
  karotin_nn_1 = mkN "karotin" "karotinet" "karotiner" "karotinerna" ;
  karott_nn_1 = mkN "karott" "karotter" ;
  karottunderlaegg_nn_1 = mkN "karottunderlдgg" neutrum ;
  karp_nn_1 = mkN "karp" ;
  karpfisk_nn_1 = mkN "karpfisk" ;
  karre_nn_1 = mkN "karrй" "karrйer" ;
  karriaer_nn_1 = mkN "karriдr" "karriдrer" ;
  karriaerdiplomat_nn_1 = mkN "karriдrdiplomat" "karriдrdiplomater" ;
  karriaerist_nn_1 = mkN "karriдrist" "karriдrister" ;
  karronad_nn_1 = mkN "karronad" "karronader" ;
  karsk_av_1 = mkA "karsk" ;
  karst_nn_1 = mkN "karst" "karster" ;
  karstbildning_nn_1 = mkN "karstbildning" ;
  kart_nn_1 = mkN "kart" ;
  kartagisk_av_1 = mkA "kartagisk" ;
  kartbild_nn_1 = mkN "kartbild" "kartbilder" ;
  kartbok_nn_1 = mkN "kartbok" "kartbцcker" ;
  kartell_nn_1 = mkN "kartell" "karteller" ;
  kartering_nn_1 = mkN "kartering" ;
  kartesch_nn_1 = mkN "kartesch" "kartescher" ;
  kartig_av_1 = mkA "kartig" ;
  kartlaeggning_nn_1 = mkN "kartlдggning" ;
  kartlaesare_nn_1 = mkN "kartlдsare" "kartlдsare" ;
  kartmaetare_nn_1 = mkN "kartmдtare" "kartmдtare" ;
  kartnagel_nn_1 = mkN "kartnagel" ;
  kartong_nn_1 = mkN "kartong" "kartonger" ;
  kartonist_nn_1 = mkN "kartonist" "kartonister" ;
  kartotek_nn_1 = mkN "kartotek" neutrum ;
  kartprojektion_nn_1 = mkN "kartprojektion" "kartprojektioner" ;
  kartspecial_nn_1 = mkN "kartspecial" "kartspecialer" ;
  karttecken_nn_1 = mkN "karttecken" "karttecknet" "karttecken" "karttecknen" ;
  kartusch_nn_1 = mkN "kartusch" "kartuscher" ;
  kartusian_nn_1 = mkN "kartusian" "kartusianer" ;
  kartusianorden_nn_1 = mkN "kartusianorden" ;
  karusell_nn_1 = mkN "karusell" "karuseller" ;
  karvsnitt_nn_1 = mkN "karvsnitt" neutrum ;
  karvstock_nn_1 = mkN "karvstock" ;
  karyatid_nn_1 = mkN "karyatid" "karyatider" ;
  kas_nn_1 = mkN "kas" ;
  kasack_nn_1 = mkN "kasack" "kasacker" ;
  kaschmirsjal_nn_1 = mkN "kaschmirsjal" ;
  kase_nn_1 = mkN "kase" utrum ;
  kasein_nn_1 = mkN "kasein" "kaseiner" ;
  kasematt_nn_1 = mkN "kasematt" "kasematter" ;
  kasern_nn_1 = mkN "kasern" "kaserner" ;
  kasernfoerbud_nn_1 = mkN "kasernfцrbud" neutrum ;
  kaserngaard_nn_1 = mkN "kaserngеrd" ;
  kashmir_nn_1 = mkN "kashmir" "kashmirer" ;
  kasino_nn_1 = mkN "kasino" "kasinot" "kasinon" "kasinona" ;
  kask_nn_1 = mkN "kask" ;
  kaskad_nn_1 = mkN "kaskad" "kaskader" ;
  kaskelot_nn_1 = mkN "kaskelot" "kaskeloter" ;
  kaskett_nn_1 = mkN "kaskett" "kasketter" ;
  kasko_nn_1 = mkN "kasko" "kaskot" "kaskon" "kaskona" ;
  kaskofoersaekring_nn_1 = mkN "kaskofцrsдkring" ;
  kasperteater_nn_1 = mkN "kasperteater" ;
  kass_av_1 = mkA "kass" ;
  kassa_nn_1 = mkN "kassa" ;
  kassaaffaer_nn_1 = mkN "kassaaffдr" "kassaaffдrer" ;
  kassaapparat_nn_1 = mkN "kassaapparat" "kassaapparater" ;
  kassabel_av_1 = mkA "kassabel" "kassabelt" "kassabla" "kassabla" "kassablare" "kassablast" "kassablaste" ;
  kassabok_nn_1 = mkN "kassabok" "kassabцcker" ;
  kassabrist_nn_1 = mkN "kassabrist" "kassabrister" ;
  kassakoep_nn_1 = mkN "kassakцp" neutrum ;
  kassakontrollapparat_nn_1 = mkN "kassakontrollapparat" "kassakontrollapparater" ;
  kassakreditiv_nn_1 = mkN "kassakreditiv" neutrum ;
  kassakvitto_nn_1 = mkN "kassakvitto" "kassakvittot" "kassakvitton" "kassakvittona" ;
  kassapjaes_nn_1 = mkN "kassapjдs" "kassapjдser" ;
  kassarabatt_nn_1 = mkN "kassarabatt" "kassarabatter" ;
  kassareserv_nn_1 = mkN "kassareserv" "kassareserver" ;
  kassaskaap_nn_1 = mkN "kassaskеp" neutrum ;
  kassaskrin_nn_1 = mkN "kassaskrin" neutrum ;
  kassation_nn_1 = mkN "kassation" "kassationer" ;
  kassationsdomstol_nn_1 = mkN "kassationsdomstol" ;
  kassavalv_nn_1 = mkN "kassavalv" neutrum ;
  kasse_nn_1 = mkN "kasse" utrum ;
  kassett_nn_1 = mkN "kassett" "kassetter" ;
  kassettband_nn_1 = mkN "kassettband" neutrum ;
  kassettbandspelare_nn_1 = mkN "kassettbandspelare" "kassettbandspelare" ;
  kassettdaeck_nn_1 = mkN "kassettdдck" neutrum ;
  kassoer_nn_1 = mkN "kassцr" "kassцrer" ;
  kassoerska_nn_1 = mkN "kassцrska" ;
  kassun_nn_1 = mkN "kassun" "kassuner" ;
  kast_nn_1 = mkN "kast" "kaster" ;
  kast_nn_2 = mkN "kast" neutrum ;
  kastal_nn_1 = mkN "kastal" "kastaler" ;
  kastanj_nn_1 = mkN "kastanj" "kastanjer" ;
  kastanje_nn_1 = mkN "kastanje" "kastanjer" ;
  kastanjebrun_av_1 = mkA "kastanjebrun" ;
  kastanjett_nn_1 = mkN "kastanjett" "kastanjetter" ;
  kastblock_nn_1 = mkN "kastblock" neutrum ;
  kastby_nn_1 = mkN "kastby" "kastbyn" "kastbyar" "kastbyarna" ;
  kastell_nn_1 = mkN "kastell" neutrum ;
  kastellan_nn_1 = mkN "kastellan" "kastellaner" ;
  kastilian_nn_1 = mkN "kastilian" "kastilianer" ;
  kastilianare_nn_1 = mkN "kastilianare" "kastilianare" ;
  kastilianska_nn_2 = mkN "kastilianska" ;
  kastloes_av_1 = mkA "kastlцs" ;
  kastmaerke_nn_1 = mkN "kastmдrke" ;
  kastmaskin_nn_1 = mkN "kastmaskin" "kastmaskiner" ;
  kastpjaes_nn_1 = mkN "kastpjдs" "kastpjдser" ;
  kastrat_nn_1 = mkN "kastrat" "kastrater" ;
  kastratsaangare_nn_1 = mkN "kastratsеngare" "kastratsеngare" ;
  kastrull_nn_1 = mkN "kastrull" "kastruller" ;
  kastsoem_nn_1 = mkN "kastsцm" "kastsцmmen" "kastsцmmar" "kastsцmmarna" ;
  kastspjut_nn_1 = mkN "kastspjut" neutrum ;
  kastspoe_nn_1 = mkN "kastspц" "kastspцet" "kastspцn" "kastspцna" ;
  kaststygn_nn_1 = mkN "kaststygn" neutrum ;
  kasttrae_nn_1 = mkN "kasttrд" "kasttrдet" "kasttrдn" "kasttrдna" ;
  kastvapen_nn_1 = mkN "kastvapen" "kastvapnet" "kastvapen" "kastvapnen" ;
  kastvind_nn_1 = mkN "kastvind" ;
  kasuar_nn_1 = mkN "kasuar" "kasuarer" ;
  kasuell_av_1 = mkA "kasuell" ;
  kasun_nn_1 = mkN "kasun" "kasuner" ;
  kasus_nn_1 = mkN "kasus" neutrum ;
  kasus_nn_2 = mkN "kasus" "kasus" "kasus" "kasusen" ;
  katabatisk_av_1 = mkA "katabatisk" ;
  katafalk_nn_1 = mkN "katafalk" "katafalker" ;
  kataforisk_av_1 = mkA "kataforisk" ;
  katakomb_nn_1 = mkN "katakomb" "katakomber" ;
  katakres_nn_1 = mkN "katakres" "katakreser" ;
  katalan_nn_1 = mkN "katalan" "katalaner" ;
  katalanska_nn_2 = mkN "katalanska" ;
  katalektisk_av_1 = mkA "katalektisk" ;
  katalepsi_nn_1 = mkN "katalepsi" "katalepsier" ;
  katalog_nn_1 = mkN "katalog" "kataloger" ;
  katalognummer_nn_1 = mkN "katalognummer" neutrum ;
  katalogpris_nn_1 = mkN "katalogpris" neutrum ;
  katalysator_nn_1 = mkN "katalysator" "katalysatorer" ;
  katalytisk_av_1 = mkA "katalytisk" ;
  katamaran_nn_1 = mkN "katamaran" "katamaraner" ;
  katapult_nn_1 = mkN "katapult" "katapulter" ;
  katapultstol_nn_1 = mkN "katapultstol" ;
  katarakt_nn_1 = mkN "katarakt" "katarakter" ;
  katarr_nn_1 = mkN "katarr" "katarrer" ;
  katastrof_nn_1 = mkN "katastrof" "katastrofer" ;
  katastrofal_av_1 = mkA "katastrofal" ;
  katastrofteori_nn_1 = mkN "katastrofteori" "katastrofteorier" ;
  kateder_nn_1 = mkN "kateder" ;
  katedral_nn_1 = mkN "katedral" "katedraler" ;
  kategori_nn_1 = mkN "kategori" "kategorier" ;
  kategoriklyvning_nn_1 = mkN "kategoriklyvning" ;
  kategorisk_av_1 = mkA "kategorisk" ;
  katekes_nn_1 = mkN "katekes" "katekeser" ;
  kateket_nn_1 = mkN "kateket" "kateketer" ;
  kateketisk_av_1 = mkA "kateketisk" ;
  katet_nn_1 = mkN "katet" "kateter" ;
  kateter_nn_1 = mkN "kateter" ;
  katig_av_1 = mkA "katig" ;
  katjon_nn_1 = mkN "katjon" "katjoner" ;
  katod_nn_1 = mkN "katod" "katoder" ;
  katodstraale_nn_1 = mkN "katodstrеle" utrum ;
  katodstraaleroer_nn_1 = mkN "katodstrеlerцr" neutrum ;
  katolik_nn_1 = mkN "katolik" "katoliker" ;
  katolsk_av_1 = mkA "katolsk" ;
  katrinplommon_nn_1 = mkN "katrinplommon" neutrum ;
  katse_nn_1 = mkN "katse" utrum ;
  katt_nn_1 = mkN "katt" "katter" ;
  kattaktig_av_1 = mkA "kattaktig" ;
  kattass_nn_1 = mkN "kattass" ;
  kattdjur_nn_1 = mkN "kattdjur" neutrum ;
  kattoega_nn_1 = mkN "kattцga" "kattцgat" "kattцgon" "kattцgonen" ;
  kattras_nn_1 = mkN "kattras" "kattraser" ;
  kattun_nn_1 = mkN "kattun" "kattuner" ;
  kattunge_nn_1 = mkN "kattunge" utrum ;
  kaukasier_nn_1 = mkN "kaukasier" "kaukasiern" "kaukasier" "kaukasierna" ;
  kaukasisk_av_1 = mkA "kaukasisk" ;
  kaukasiska_nn_1 = mkN "kaukasiska" ;
  kauri_nn_1 = mkN "kauri" "kaurin" "kaurier" "kaurierna" ;
  kaus_nn_1 = mkN "kaus" "kauser" ;
  kausal_av_1 = mkA "kausal" ;
  kausalfoerhaallande_nn_1 = mkN "kausalfцrhеllande" ;
  kausalitet_nn_1 = mkN "kausalitet" "kausaliteter" ;
  kausalsats_nn_1 = mkN "kausalsats" "kausalsatser" ;
  kausativ_av_1 = mkA "kausativ" ;
  kaustik_av_1 = mkA "kaustik" ;
  kaution_nn_1 = mkN "kaution" "kautioner" ;
  kautschuk_nn_1 = mkN "kautschuk" ;
  kautschukparagraf_nn_1 = mkN "kautschukparagraf" "kautschukparagrafer" ;
  kautschuktraed_nn_1 = mkN "kautschuktrдd" neutrum ;
  kav_ab_1 = mkAdv "kav" ;
  kavaj_nn_1 = mkN "kavaj" "kavajer" ;
  kavajkrage_nn_1 = mkN "kavajkrage" utrum ;
  kavalett_nn_1 = mkN "kavalett" "kavaletter" ;
  kavaljer_nn_1 = mkN "kavaljer" "kavaljerer" ;
  kavaljersflygel_nn_1 = mkN "kavaljersflygel" ;
  kavalkad_nn_1 = mkN "kavalkad" "kavalkader" ;
  kavall_nn_1 = mkN "kavall" "kavaller" ;
  kavalleri_nn_1 = mkN "kavalleri" "kavallerit" "kavallerier" "kavallerierna" ;
  kavallerichock_nn_1 = mkN "kavallerichock" "kavallerichocker" ;
  kavallerist_nn_1 = mkN "kavallerist" "kavallerister" ;
  kavalleritrupp_nn_1 = mkN "kavalleritrupp" "kavalleritrupper" ;
  kavat_av_1 = mkA "kavat" "kavat" ;
  kavel_nn_1 = mkN "kavel" ;
  kavelbro_nn_1 = mkN "kavelbro" ;
  kavern_nn_1 = mkN "kavern" "kaverner" ;
  kavitet_nn_1 = mkN "kavitet" "kaviteter" ;
  kavitetsdjur_nn_1 = mkN "kavitetsdjur" neutrum ;
  kavle_nn_1 = mkN "kavle" utrum ;
  kavring_nn_1 = mkN "kavring" ;
  kaxe_nn_1 = mkN "kaxe" utrum ;
  kaxig_av_1 = mkA "kaxig" ;
  ked_nn_1 = mkN "ked" "keder" ;
  kediv_nn_1 = mkN "kediv" "kediver" ;
  kedja_nn_1 = mkN "kedja" ;
  kedjebraak_nn_1 = mkN "kedjebrеk" neutrum ;
  kedjebrev_nn_1 = mkN "kedjebrev" neutrum ;
  kedjehjul_nn_1 = mkN "kedjehjul" neutrum ;
  kedjehus_nn_1 = mkN "kedjehus" neutrum ;
  kedjemolekyl_nn_1 = mkN "kedjemolekyl" "kedjemolekyler" ;
  kedjereaktion_nn_1 = mkN "kedjereaktion" "kedjereaktioner" ;
  kedjeskydd_nn_1 = mkN "kedjeskydd" neutrum ;
  kedjesoem_nn_1 = mkN "kedjesцm" "kedjesцmmen" "kedjesцmmar" "kedjesцmmarna" ;
  kedjestygn_nn_1 = mkN "kedjestygn" neutrum ;
  kedjevaexel_nn_1 = mkN "kedjevдxel" ;
  kejsardoeme_nn_1 = mkN "kejsardцme" ;
  kejsare_nn_1 = mkN "kejsare" "kejsare" ;
  kejsarhaer_nn_1 = mkN "kejsarhдr" ;
  kejsarinna_nn_1 = mkN "kejsarinna" ;
  kejsaroern_nn_1 = mkN "kejsarцrn" ;
  kejsarsnitt_nn_1 = mkN "kejsarsnitt" neutrum ;
  kejserlig_av_1 = mkA "kejserlig" ;
  kelen_av_1 = mkA "kelen" "kelet" ;
  kelgris_nn_1 = mkN "kelgris" ;
  kelig_av_1 = mkA "kelig" ;
  kelim_nn_1 = mkN "kelim" "kelimer" ;
  kelsjuk_av_1 = mkA "kelsjuk" ;
  kelt_nn_1 = mkN "kelt" "kelter" ;
  keltisk_av_1 = mkA "keltisk" ;
  keltiska_nn_2 = mkN "keltiska" ;
  kelvin_nn_1 = mkN "kelvin" "kelvinen" "kelvin" "kelvinen" ;
  kemiindustri_nn_1 = mkN "kemiindustri" "kemiindustrier" ;
  kemisk_av_1 = mkA "kemisk" ;
  kemist_nn_1 = mkN "kemist" "kemister" ;
  kemomat_nn_1 = mkN "kemomat" "kemomater" ;
  kemoterapi_nn_1 = mkN "kemoterapi" "kemoterapier" ;
  kemtvaett_nn_1 = mkN "kemtvдtt" ;
  kennel_nn_1 = mkN "kennel" ;
  kenning_nn_1 = mkN "kenning" ;
  kentaur_nn_1 = mkN "kentaur" "kentaurer" ;
  kenyan_nn_1 = mkN "kenyan" "kenyaner" ;
  keps_nn_1 = mkN "keps" ;
  keramiker_nn_1 = mkN "keramiker" "keramikern" "keramiker" "keramikerna" ;
  keramikform_nn_1 = mkN "keramikform" "keramikformer" ;
  kerub_nn_1 = mkN "kerub" "keruber" ;
  ketch_nn_1 = mkN "ketch" "ketcher" ;
  kex_nn_1 = mkN "kex" neutrum ;
  khan_nn_1 = mkN "khan" "khaner" ;
  khmer_nn_1 = mkN "khmer" "khmerer" ;
  kiasm_nn_1 = mkN "kiasm" "kiasmer" ;
  kibbutz_nn_1 = mkN "kibbutz" "kibbutzer" ;
  kick_nn_1 = mkN "kick" ;
  kickstart_nn_1 = mkN "kickstart" "kickstarter" ;
  kid_nn_1 = mkN "kid" neutrum ;
  kidnappare_nn_1 = mkN "kidnappare" "kidnappare" ;
  kikaert_nn_1 = mkN "kikдrt" "kikдrter" ;
  kikare_nn_1 = mkN "kikare" "kikare" ;
  kikhaal_nn_1 = mkN "kikhеl" neutrum ;
  kikkran_nn_1 = mkN "kikkran" ;
  kil_nn_1 = mkN "kil" ;
  kilben_nn_1 = mkN "kilben" neutrum ;
  kilhael_nn_1 = mkN "kilhдl" ;
  kilklack_nn_1 = mkN "kilklack" ;
  kille_nn_1 = mkN "kille" utrum ;
  killespel_nn_1 = mkN "killespel" "killespelet" "killespel" "killespelen" ;
  killig_av_1 = mkA "killig" ;
  killing_nn_1 = mkN "killing" ;
  kilo_nn_1 = mkN "kilo" "kilot" "kilo" "kilona" ;
  kilobyte_nn_1 = mkN "kilobyte" "kilobyten" "kilobyte" "kilobytena" ;
  kilogram_nn_1 = mkN "kilogram" "kilogrammet" "kilogram" "kilogrammen" ;
  kilogrammeter_nn_1 = mkN "kilogrammeter" ;
  kilometer_nn_1 = mkN "kilometer" ;
  kilometertjock_av_1 = mkA "kilometertjock" ;
  kilopond_nn_1 = mkN "kilopond" neutrum ;
  kilopondmeter_nn_1 = mkN "kilopondmeter" "kilopondmetern" "kilopondmeter" "kilopondmeterna" ;
  kilopris_nn_1 = mkN "kilopris" neutrum ;
  kiloton_nn_1 = mkN "kiloton" "kilotonnet" "kiloton" "kilotonnen" ;
  kilowatt_nn_1 = mkN "kilowatt" "kilowatten" "kilowatt" "kilowatten" ;
  kilram_nn_1 = mkN "kilram" ;
  kilt_nn_1 = mkN "kilt" ;
  kimono_nn_1 = mkN "kimono" "kimonon" "kimonos" "kimonosen" ;
  kinaalkaloid_nn_1 = mkN "kinaalkaloid" "kinaalkaloider" ;
  kind_nn_1 = mkN "kind" "kinder" ;
  kindben_nn_1 = mkN "kindben" neutrum ;
  kindkedja_nn_1 = mkN "kindkedja" ;
  kindpaase_nn_1 = mkN "kindpеse" utrum ;
  kindpust_nn_1 = mkN "kindpust" ;
  kindtand_nn_1 = mkN "kindtand" "kindtдnder" ;
  kinematograf_nn_1 = mkN "kinematograf" "kinematografer" ;
  kines_nn_1 = mkN "kines" "kineser" ;
  kineseri_nn_1 = mkN "kineseri" "kineserit" "kineserier" "kineserierna" ;
  kinesisk_av_1 = mkA "kinesisk" ;
  kinesiska_nn_2 = mkN "kinesiska" ;
  kinestetisk_av_1 = mkA "kinestetisk" ;
  kinetisk_av_1 = mkA "kinetisk" ;
  king_size_av_1 = mkA "king-size" ;
  kink_nn_1 = mkN "kink" ;
  kinkig_av_1 = mkA "kinkig" ;
  kiosk_nn_1 = mkN "kiosk" "kiosker" ;
  kip_nn_1 = mkN "kip" ;
  kippsko_nn_1 = mkN "kippsko" "kippskor" ;
  kippskodd_av_1 = mkA "kippskodd" "kippskodtt" ;
  kirgis_nn_1 = mkN "kirgis" "kirgiser" ;
  kiribatier_nn_1 = mkN "kiribatier" "kiribatiern" "kiribatier" "kiribatierna" ;
  kiribatisk_av_1 = mkA "kiribatisk" ;
  kiropraktiker_nn_1 = mkN "kiropraktiker" "kiropraktikern" "kiropraktiker" "kiropraktikerna" ;
  kiropraktor_nn_1 = mkN "kiropraktor" "kiropraktorer" ;
  kirurg_nn_1 = mkN "kirurg" "kirurger" ;
  kirurgisk_av_1 = mkA "kirurgisk" ;
  kis_nn_1 = mkN "kis" "kiser" ;
  kis_nn_2 = mkN "kis" ;
  kiselalg_nn_1 = mkN "kiselalg" "kiselalger" ;
  kiselfoerening_nn_1 = mkN "kiselfцrening" ;
  kiselkristall_nn_1 = mkN "kiselkristall" "kiselkristaller" ;
  kiselsten_nn_1 = mkN "kiselsten" "kiselstenen" "kiselstenar" "kiselstenarna" ;
  kisse_nn_1 = mkN "kisse" utrum ;
  kissekatt_nn_1 = mkN "kissekatt" "kissekatter" ;
  kissemiss_nn_1 = mkN "kissemiss" ;
  kissnoedig_av_1 = mkA "kissnцdig" ;
  kistbotten_nn_1 = mkN "kistbotten" ;
  kistebrev_nn_1 = mkN "kistebrev" neutrum ;
  kiton_nn_1 = mkN "kiton" "kitoner" ;
  kitslig_av_1 = mkA "kitslig" ;
  kittel_nn_1 = mkN "kittel" ;
  kitteldal_nn_1 = mkN "kitteldal" ;
  kittelflickare_nn_1 = mkN "kittelflickare" "kittelflickare" ;
  kittlare_nn_1 = mkN "kittlare" "kittlare" ;
  kittlig_av_1 = mkA "kittlig" ;
  kivi_nn_1 = mkN "kivi" "kivin" "kivier" "kivierna" ;
  kiwi_nn_1 = mkN "kiwi" "kiwin" "kiwier" "kiwierna" ;
  kjol_nn_1 = mkN "kjol" ;
  kjoltyg_nn_1 = mkN "kjoltyg" neutrum ;
  kjortel_nn_1 = mkN "kjortel" ;
  kjortelvaegen_ab_1 = mkAdv "kjortelvдgen" ;
  klaafingrig_av_1 = mkA "klеfingrig" ;
  klaapare_nn_1 = mkN "klеpare" "klеpare" ;
  klabb_nn_1 = mkN "klabb" ;
  klabbe_nn_1 = mkN "klabbe" utrum ;
  klabbskoet_nn_1 = mkN "klabbskцt" ;
  klabbstroemming_nn_1 = mkN "klabbstrцmming" ;
  klack_nn_1 = mkN "klack" ;
  klackbar_nn_1 = mkN "klackbar" "klackbarer" ;
  klackjaern_nn_1 = mkN "klackjдrn" neutrum ;
  klackring_nn_1 = mkN "klackring" ;
  klackspark_nn_1 = mkN "klackspark" ;
  kladd_nn_1 = mkN "kladd" ;
  kladdig_av_1 = mkA "kladdig" ;
  klaedd_av_1 = mkA "klдdd" ;
  klaededraekt_nn_1 = mkN "klдdedrдkt" "klдdedrдkter" ;
  klaedespersedel_nn_1 = mkN "klдdespersedel" ;
  klaedesplagg_nn_1 = mkN "klдdesplagg" neutrum ;
  klaedgalen_av_1 = mkA "klдdgalen" "klдdgalet" ;
  klaedhaengare_nn_1 = mkN "klдdhдngare" "klдdhдngare" ;
  klaedkammare_nn_1 = mkN "klдdkammare" "klдdkammaren" "klдdkamrar" "klдdkamrarna" ;
  klaedkorg_nn_1 = mkN "klдdkorg" ;
  klaedlus_nn_1 = mkN "klдdlus" "klдdlusen" "klдdlцss" "klдdlцssen" ;
  klaedmal_nn_1 = mkN "klдdmal" ;
  klaednad_nn_1 = mkN "klдdnad" "klдdnader" ;
  klaedsam_av_1 = mkA "klдdsam" "klдdsamt" "klдdsamma" "klдdsamma" "klдdsammare" "klдdsammast" "klдdsammaste" ;
  klaedsel_nn_1 = mkN "klдdsel" ;
  klaedskaap_nn_1 = mkN "klдdskеp" neutrum ;
  klaedstreck_nn_1 = mkN "klдdstreck" neutrum ;
  klaedtvaett_nn_1 = mkN "klдdtvдtt" ;
  klaem_nn_1 = mkN "klдm" "klдmmen" "klдmmar" "klдmmarna" ;
  klaemdag_nn_1 = mkN "klдmdag" ;
  klaemmare_nn_1 = mkN "klдmmare" "klдmmare" ;
  klaemmig_av_1 = mkA "klдmmig" ;
  klaemtare_nn_1 = mkN "klдmtare" "klдmtare" ;
  klaengig_av_1 = mkA "klдngig" ;
  klaengvaext_nn_1 = mkN "klдngvдxt" "klдngvдxter" ;
  klaenning_nn_1 = mkN "klдnning" ;
  klaenningsliv_nn_1 = mkN "klдnningsliv" neutrum ;
  klaepp_nn_1 = mkN "klдpp" ;
  klaervoajant_av_1 = mkA "klдrvoajant" "klдrvoajant" ;
  klaett_nn_1 = mkN "klдtt" ;
  klaetterfaagel_nn_1 = mkN "klдtterfеgel" ;
  klaetterfot_nn_1 = mkN "klдtterfot" "klдtterfцtter" ;
  klaetterjaern_nn_1 = mkN "klдtterjдrn" neutrum ;
  klaettersko_nn_1 = mkN "klдttersko" "klдtterskor" ;
  klaetterstaellning_nn_1 = mkN "klдtterstдllning" ;
  klaettervaext_nn_1 = mkN "klдttervдxt" "klдttervдxter" ;
  klaettrare_nn_1 = mkN "klдttrare" "klдttrare" ;
  klaettring_nn_1 = mkN "klдttring" ;
  klaff_nn_1 = mkN "klaff" ;
  klaffbord_nn_1 = mkN "klaffbord" neutrum ;
  klaffbro_nn_1 = mkN "klaffbro" ;
  klaffel_nn_1 = mkN "klaffel" "klaffelet" "klaffel" "klaffelen" ;
  klagande_nn_1 = mkN "klagande" "klaganden" "klagande" "klagandena" ;
  klagomaal_nn_1 = mkN "klagomеl" neutrum ;
  klagomur_nn_1 = mkN "klagomur" ;
  klagorop_nn_1 = mkN "klagorop" neutrum ;
  klagosaang_nn_1 = mkN "klagosеng" "klagosеnger" ;
  klagotid_nn_1 = mkN "klagotid" "klagotider" ;
  klam_nn_1 = mkN "klam" "klammen" "klammar" "klammarna" ;
  klammer_nn_1 = mkN "klammer" "klammern" "klammer" "klammerna" ;
  klammeri_nn_1 = mkN "klammeri" "klammerit" "klammerier" "klammerierna" ;
  klamp_nn_1 = mkN "klamp" ;
  klan_nn_1 = mkN "klan" "klaner" ;
  klanderfri_av_1 = mkA "klanderfri" "klanderfritt" ;
  klandervaerd_av_1 = mkA "klandervдrd" "klandervдrt" ;
  klang_nn_1 = mkN "klang" "klanger" ;
  klangbotten_nn_1 = mkN "klangbotten" ;
  klangfaerg_nn_1 = mkN "klangfдrg" "klangfдrger" ;
  klangfull_av_1 = mkA "klangfull" ;
  klanglig_av_1 = mkA "klanglig" ;
  klangloes_av_1 = mkA "klanglцs" ;
  klant_nn_1 = mkN "klant" ;
  klantig_av_1 = mkA "klantig" ;
  klantskalle_nn_1 = mkN "klantskalle" utrum ;
  klapp_nn_1 = mkN "klapp" ;
  klappbraede_nn_1 = mkN "klappbrдde" ;
  klappersten_nn_1 = mkN "klappersten" "klapperstenen" "klapperstenar" "klapperstenarna" ;
  klapperstenstrand_nn_1 = mkN "klapperstenstrand" "klapperstenstrдnder" ;
  klappjakt_nn_1 = mkN "klappjakt" "klappjakter" ;
  klapptrae_nn_1 = mkN "klapptrд" "klapptrдet" "klapptrдn" "klapptrдna" ;
  klar_av_1 = mkA "klar" ;
  klarbaer_nn_1 = mkN "klarbдr" neutrum ;
  klarblaa_av_1 = mkA "klarblе" "klarblеtt" ;
  klarhet_nn_1 = mkN "klarhet" "klarheter" ;
  klarinett_nn_1 = mkN "klarinett" "klarinetter" ;
  klarligen_ab_1 = mkAdv "klarligen" ;
  klarmedel_nn_1 = mkN "klarmedel" neutrum ;
  klaroegd_av_1 = mkA "klarцgd" "klarцgt" ;
  klarroed_av_1 = mkA "klarrцd" ;
  klarsignal_nn_1 = mkN "klarsignal" "klarsignaler" ;
  klarskinn_nn_1 = mkN "klarskinn" neutrum ;
  klarsynt_av_1 = mkA "klarsynt" "klarsynt" ;
  klartaenkt_av_1 = mkA "klartдnkt" "klartдnkt" ;
  klartecken_nn_1 = mkN "klartecken" "klartecknet" "klartecken" "klartecknen" ;
  klarvaken_av_1 = mkA "klarvaken" "klarvaket" ;
  klase_nn_1 = mkN "klase" utrum ;
  klass_nn_1 = mkN "klass" "klasser" ;
  klassbok_nn_1 = mkN "klassbok" "klassbцcker" ;
  klassfoerestaandare_nn_1 = mkN "klassfцrestеndare" "klassfцrestеndare" ;
  klassicitet_nn_1 = mkN "klassicitet" "klassiciteter" ;
  klassificering_nn_1 = mkN "klassificering" ;
  klassifikation_nn_1 = mkN "klassifikation" "klassifikationer" ;
  klassik_nn_1 = mkN "klassik" "klassiker" ;
  klassiker_nn_1 = mkN "klassiker" "klassikern" "klassiker" "klassikerna" ;
  klassiserande_av_1 = mkA "klassiserande" ;
  klassisk_av_1 = mkA "klassisk" ;
  klasskamp_nn_1 = mkN "klasskamp" "klasskamper" ;
  klasskamrat_nn_1 = mkN "klasskamrat" "klasskamrater" ;
  klasskillnad_nn_1 = mkN "klasskillnad" "klasskillnader" ;
  klasskonferens_nn_1 = mkN "klasskonferens" "klasskonferenser" ;
  klasslaerare_nn_1 = mkN "klasslдrare" "klasslдrare" ;
  klasslag_nn_1 = mkN "klasslag" ;
  klasslag_nn_2 = mkN "klasslag" neutrum ;
  klassloes_av_1 = mkA "klasslцs" ;
  klassmaerke_nn_1 = mkN "klassmдrke" ;
  klassmamma_nn_1 = mkN "klassmamma" ;
  klassmedveten_av_1 = mkA "klassmedveten" "klassmedvetet" ;
  klassmoerj_nn_1 = mkN "klassmцrj" neutrum ;
  klassmotsaettning_nn_1 = mkN "klassmotsдttning" ;
  klasspappa_nn_1 = mkN "klasspappa" ;
  klassrum_nn_1 = mkN "klassrum" "klassrummet" "klassrum" "klassrummen" ;
  klatsch_nn_1 = mkN "klatsch" ;
  klatschig_av_1 = mkA "klatschig" ;
  klausul_nn_1 = mkN "klausul" "klausuler" ;
  klav_nn_1 = mkN "klav" "klaver" ;
  klavbinda_vb_1 = mkV "klavbinda" "klavband" "klavbundit" ;
  klave_nn_1 = mkN "klave" utrum ;
  klavecin_nn_1 = mkN "klavecin" "klaveciner" ;
  klaver_nn_1 = mkN "klaver" "klaveret" "klaver" "klaveren" ;
  klavertramp_nn_1 = mkN "klavertramp" neutrum ;
  klaverutdrag_nn_1 = mkN "klaverutdrag" neutrum ;
  klaviatur_nn_1 = mkN "klaviatur" "klaviaturer" ;
  klavikord_nn_1 = mkN "klavikord" neutrum ;
  klematis_nn_1 = mkN "klematis" ;
  klementin_nn_1 = mkN "klementin" "klementiner" ;
  klemig_av_1 = mkA "klemig" ;
  klen_av_1 = mkA "klen" ;
  klenaet_nn_1 = mkN "klenдt" "klenдter" ;
  klenhus_nn_1 = mkN "klenhus" neutrum ;
  klenod_nn_1 = mkN "klenod" "klenoder" ;
  klensmed_nn_1 = mkN "klensmed" "klensmeder" ;
  klensmide_nn_1 = mkN "klensmide" ;
  klenspaenning_nn_1 = mkN "klenspдnning" ;
  klentrogen_av_1 = mkA "klentrogen" "klentroget" ;
  klenvuxen_av_1 = mkA "klenvuxen" "klenvuxet" ;
  kleptoman_nn_1 = mkN "kleptoman" "kleptomaner" ;
  klerikal_av_1 = mkA "klerikal" ;
  klerk_nn_1 = mkN "klerk" "klerker" ;
  kletig_av_1 = mkA "kletig" ;
  klev_nn_1 = mkN "klev" neutrum ;
  klibbal_nn_1 = mkN "klibbal" ;
  klibbig_av_1 = mkA "klibbig" ;
  kliche_nn_1 = mkN "klichй" "klichйer" ;
  klick_nn_1 = mkN "klick" ;
  klick_nn_2 = mkN "klick" neutrum ;
  klient_nn_1 = mkN "klient" "klienter" ;
  klientel_nn_1 = mkN "klientel" "klientelet" "klientel" "klientelen" ;
  klimat_nn_1 = mkN "klimat" neutrum ;
  klimatfoeraendring_nn_1 = mkN "klimatfцrдndring" ;
  klimatforskare_nn_1 = mkN "klimatforskare" "klimatforskare" ;
  klimatgraens_nn_1 = mkN "klimatgrдns" "klimatgrдnser" ;
  klimatkammare_nn_1 = mkN "klimatkammare" "klimatkammaren" "klimatkamrar" "klimatkamrarna" ;
  klimatmodell_nn_1 = mkN "klimatmodell" "klimatmodeller" ;
  klimatologisk_av_1 = mkA "klimatologisk" ;
  klimatombyte_nn_1 = mkN "klimatombyte" ;
  klimatskael_nn_1 = mkN "klimatskдl" neutrum ;
  klimatsystem_nn_1 = mkN "klimatsystem" neutrum ;
  klimatvariation_nn_1 = mkN "klimatvariation" "klimatvariationer" ;
  klimatzon_nn_1 = mkN "klimatzon" "klimatzoner" ;
  klimax_nn_1 = mkN "klimax" ;
  klimp_nn_1 = mkN "klimp" ;
  klinhus_nn_1 = mkN "klinhus" neutrum ;
  klinik_nn_1 = mkN "klinik" "kliniker" ;
  kliniker_nn_1 = mkN "kliniker" "klinikern" "kliniker" "klinikerna" ;
  klinisk_av_1 = mkA "klinisk" ;
  klinkbyggd_av_1 = mkA "klinkbyggd" "klinkbyggt" ;
  klint_nn_1 = mkN "klint" ;
  klipp_nn_1 = mkN "klipp" neutrum ;
  klippare_nn_1 = mkN "klippare" "klippare" ;
  klippblock_nn_1 = mkN "klippblock" neutrum ;
  klippdass_nn_1 = mkN "klippdass" ;
  klipper_nn_1 = mkN "klipper" ;
  klipperstaev_nn_1 = mkN "klipperstдv" ;
  klippfisk_nn_1 = mkN "klippfisk" ;
  klippformation_nn_1 = mkN "klippformation" "klippformationer" ;
  klippfyr_nn_1 = mkN "klippfyr" ;
  klippgrav_nn_1 = mkN "klippgrav" ;
  klippig_av_1 = mkA "klippig" ;
  klipping_nn_1 = mkN "klipping" ;
  klippkort_nn_1 = mkN "klippkort" neutrum ;
  klippljus_nn_1 = mkN "klippljus" neutrum ;
  klippmaalning_nn_1 = mkN "klippmеlning" ;
  klippmassiv_nn_1 = mkN "klippmassiv" neutrum ;
  klippning_nn_1 = mkN "klippning" ;
  klippotek_nn_1 = mkN "klippotek" neutrum ;
  klippspik_nn_1 = mkN "klippspik" ;
  klipptaang_nn_1 = mkN "klipptеng" "klipptдnger" ;
  klippvaegg_nn_1 = mkN "klippvдgg" ;
  klipsk_av_1 = mkA "klipsk" ;
  klistrig_av_1 = mkA "klistrig" ;
  klitoris_nn_1 = mkN "klitoris" ;
  kliv_nn_1 = mkN "kliv" neutrum ;
  klo_nn_1 = mkN "klo" "klor" ;
  kloak_nn_1 = mkN "kloak" "kloaker" ;
  kloakdjur_nn_1 = mkN "kloakdjur" neutrum ;
  kloasongvaegg_nn_1 = mkN "kloasongvдgg" ;
  klockare_nn_1 = mkN "klockare" "klockare" ;
  klockarkaerlek_nn_1 = mkN "klockarkдrlek" ;
  klockarkatt_nn_1 = mkN "klockarkatt" "klockarkatter" ;
  klockboj_nn_1 = mkN "klockboj" ;
  klockformig_av_1 = mkA "klockformig" ;
  klockkedja_nn_1 = mkN "klockkedja" ;
  klockklaepp_nn_1 = mkN "klockklдpp" ;
  klockren_av_1 = mkA "klockren" ;
  klockringning_nn_1 = mkN "klockringning" ;
  klocksignal_nn_1 = mkN "klocksignal" "klocksignaler" ;
  klockslag_nn_1 = mkN "klockslag" neutrum ;
  klockspel_nn_1 = mkN "klockspel" "klockspelet" "klockspel" "klockspelen" ;
  klockstapel_nn_1 = mkN "klockstapel" ;
  klockstraeng_nn_1 = mkN "klockstrдng" ;
  klocktid_nn_1 = mkN "klocktid" "klocktider" ;
  klocktorn_nn_1 = mkN "klocktorn" neutrum ;
  kloev_nn_1 = mkN "klцv" ;
  kloever_nn_1 = mkN "klцver" "klцvern" "klцver" "klцverna" ;
  kloeverblad_nn_1 = mkN "klцverblad" neutrum ;
  kloeverliknande_av_1 = mkA "klцverliknande" ;
  kloeversnaerja_nn_1 = mkN "klцversnдrja" ;
  kloevertroett_av_1 = mkA "klцvertrцtt" ;
  kloevjeren_nn_1 = mkN "klцvjeren" "klцvjerenen" "klцvjerenar" "klцvjerenarna" ;
  kloevjesadel_nn_1 = mkN "klцvjesadel" ;
  kloevsadel_nn_1 = mkN "klцvsadel" ;
  kloevsadelkyrka_nn_1 = mkN "klцvsadelkyrka" ;
  kloevsadelsbyggnad_nn_1 = mkN "klцvsadelsbyggnad" "klцvsadelsbyggnader" ;
  kloevsadelskyrka_nn_1 = mkN "klцvsadelskyrka" ;
  klok_av_1 = mkA "klok" ;
  klokhuvud_nn_1 = mkN "klokhuvud" "klokhuvudet" "klokhuvuden" "klokhuvudena" ;
  klon_nn_1 = mkN "klon" "kloner" ;
  klonering_nn_1 = mkN "klonering" ;
  klorat_nn_1 = mkN "klorat" neutrum ;
  kloratom_nn_1 = mkN "kloratom" "kloratomer" ;
  klorfenol_nn_1 = mkN "klorfenol" "klorfenoler" ;
  klorid_nn_1 = mkN "klorid" "klorider" ;
  klosett_nn_1 = mkN "klosett" "klosetter" ;
  kloss_ab_1 = mkAdv "kloss" ;
  kloss_nn_1 = mkN "kloss" ;
  klossig_av_1 = mkA "klossig" ;
  kloster_nn_1 = mkN "kloster" neutrum ;
  klosterbroder_nn_1 = mkN "klosterbroder" "klosterbrodern" "klosterbrцder" "klosterbrцderna" ;
  klostercell_nn_1 = mkN "klostercell" "klosterceller" ;
  klosterkyrka_nn_1 = mkN "klosterkyrka" ;
  klosterlikoer_nn_1 = mkN "klosterlikцr" "klosterlikцrer" ;
  klosterorden_nn_1 = mkN "klosterorden" ;
  klosterregel_nn_1 = mkN "klosterregel" "klosterregeln" "klosterregler" "klosterreglerna" ;
  klostersyster_nn_1 = mkN "klostersyster" ;
  klot_nn_1 = mkN "klot" neutrum ;
  klotblixt_nn_1 = mkN "klotblixt" ;
  klotrund_av_1 = mkA "klotrund" ;
  klots_nn_1 = mkN "klots" ;
  klotterplank_nn_1 = mkN "klotterplank" neutrum ;
  klottrig_av_1 = mkA "klottrig" ;
  klove_nn_1 = mkN "klove" utrum ;
  klubb_nn_1 = mkN "klubb" ;
  klubbafton_nn_1 = mkN "klubbafton" "klubbaftonen" "klubbaftnar" "klubbaftnarna" ;
  klubblaengd_nn_1 = mkN "klubblдngd" "klubblдngder" ;
  klubbmaerke_nn_1 = mkN "klubbmдrke" ;
  klubbmaestare_nn_1 = mkN "klubbmдstare" "klubbmдstare" ;
  klubbsandwich_nn_1 = mkN "klubbsandwich" ;
  klubbslag_nn_1 = mkN "klubbslag" neutrum ;
  kludd_nn_2 = mkN "kludd" ;
  klump_nn_1 = mkN "klump" ;
  klumpackord_nn_1 = mkN "klumpackord" neutrum ;
  klumpedump_nn_1 = mkN "klumpedump" ;
  klumpeduns_nn_1 = mkN "klumpeduns" ;
  klumpfisk_nn_1 = mkN "klumpfisk" ;
  klumpig_av_1 = mkA "klumpig" ;
  klumpsoem_nn_1 = mkN "klumpsцm" "klumpsцmmen" "klumpsцmmar" "klumpsцmmarna" ;
  klumpsumma_nn_1 = mkN "klumpsumma" ;
  klumpvis_ab_1 = mkAdv "klumpvis" ;
  klunk_nn_1 = mkN "klunk" ;
  kluns_nn_1 = mkN "kluns" ;
  klunsig_av_1 = mkA "klunsig" ;
  klurig_av_1 = mkA "klurig" ;
  kluring_nn_1 = mkN "kluring" ;
  klusil_nn_1 = mkN "klusil" "klusiler" ;
  klut_nn_1 = mkN "klut" ;
  kluven_av_1 = mkA "kluven" "kluvet" ;
  klyft_nn_1 = mkN "klyft" "klyfter" ;
  klyftig_av_1 = mkA "klyftig" ;
  klys_nn_1 = mkN "klys" neutrum ;
  klyva_vb_1 = mkV "klyva" "klyver" "klyv" "klцv" "kluvit" "klyven" ;
  klyvarbom_nn_1 = mkN "klyvarbom" "klyvarbommen" "klyvarbommar" "klyvarbommarna" ;
  klyvare_nn_1 = mkN "klyvare" "klyvare" ;
  klyvbar_av_1 = mkA "klyvbar" ;
  klyvning_nn_1 = mkN "klyvning" ;
  klyvningsreaktion_nn_1 = mkN "klyvningsreaktion" "klyvningsreaktioner" ;
  klyvoeppning_nn_1 = mkN "klyvцppning" ;
  knack_nn_1 = mkN "knack" neutrum ;
  knackig_av_1 = mkA "knackig" ;
  knackning_nn_1 = mkN "knackning" ;
  knackvurst_nn_1 = mkN "knackvurst" ;
  knae_nn_1 = mkN "knд" "knдet" "knдn" "knдna" ;
  knaeck_nn_1 = mkN "knдck" ;
  knaeck_nn_2 = mkN "knдck" neutrum ;
  knaeckebroed_nn_1 = mkN "knдckebrцd" neutrum ;
  knaeckepil_nn_1 = mkN "knдckepil" ;
  knaeckform_nn_1 = mkN "knдckform" ;
  knaeckfraaga_nn_1 = mkN "knдckfrеga" ;
  knaeckt_av_1 = mkA "knдckt" "knдckt" ;
  knaefalla_vb_1 = mkV "knдfalla" "knдfцll" "knдfallit" ;
  knaehoeg_av_1 = mkA "knдhцg" ;
  knaehund_nn_1 = mkN "knдhund" ;
  knaekort_av_1 = mkA "knдkort" "knдkort" ;
  knaelaang_av_1 = mkA "knдlеng" ;
  knaeled_nn_1 = mkN "knдled" "knдleder" ;
  knaepp_av_1 = mkA "knдpp" ;
  knaepp_nn_1 = mkN "knдpp" ;
  knaeppbagge_nn_1 = mkN "knдppbagge" utrum ;
  knaeppning_nn_1 = mkN "knдppning" ;
  knaeroer_nn_1 = mkN "knдrцr" neutrum ;
  knaeskaal_nn_1 = mkN "knдskеl" ;
  knaeskydd_nn_1 = mkN "knдskydd" neutrum ;
  knaeslut_nn_1 = mkN "knдslut" neutrum ;
  knaesvag_av_1 = mkA "knдsvag" ;
  knaetofs_nn_1 = mkN "knдtofs" ;
  knaeveck_nn_1 = mkN "knдveck" neutrum ;
  knaevelborr_nn_1 = mkN "knдvelborr" ;
  knaevring_nn_1 = mkN "knдvring" ;
  knagg_nn_1 = mkN "knagg" ;
  knagglig_av_1 = mkA "knagglig" ;
  knal_av_1 = mkA "knal" ;
  knall_av_1 = mkA "knall" "knall" ;
  knall_nn_1 = mkN "knall" ;
  knalle_nn_1 = mkN "knalle" utrum ;
  knallhaard_av_1 = mkA "knallhеrd" "knallhеrt" ;
  knallhatt_nn_1 = mkN "knallhatt" ;
  knalltransport_nn_1 = mkN "knalltransport" "knalltransporter" ;
  knap_nn_1 = mkN "knap" ;
  knape_nn_1 = mkN "knape" utrum ;
  knaper_av_1 = mkA "knaper" "knapert" "knapra" "knapra" "knaprare" "knaprast" "knapraste" ;
  knapp_av_1 = mkA "knapp" ;
  knapp_nn_1 = mkN "knapp" ;
  knappast_ab_1 = mkAdv "knappast" ;
  knapphaal_nn_1 = mkN "knapphеl" neutrum ;
  knapphaendig_av_1 = mkA "knapphдndig" ;
  knapphet_nn_1 = mkN "knapphet" "knappheter" ;
  knappnaal_nn_1 = mkN "knappnеl" ;
  knappnaalshuvud_nn_1 = mkN "knappnеlshuvud" "knappnеlshuvudet" "knappnеlshuvuden" "knappnеlshuvudena" ;
  knappt_ab_1 = mkAdv "knappt" ;
  knapptelefon_nn_1 = mkN "knapptelefon" "knapptelefoner" ;
  knaprig_av_1 = mkA "knaprig" ;
  knarkare_nn_1 = mkN "knarkare" "knarkare" ;
  knarkarkvart_nn_1 = mkN "knarkarkvart" ;
  knarr_nn_2 = mkN "knarr" ;
  knarrig_av_1 = mkA "knarrig" ;
  knasig_av_1 = mkA "knasig" ;
  knasprig_av_1 = mkA "knasprig" ;
  knast_nn_1 = mkN "knast" ;
  knaster_nn_2 = mkN "knaster" ;
  knastrig_av_1 = mkA "knastrig" ;
  knatte_nn_1 = mkN "knatte" utrum ;
  knatting_nn_1 = mkN "knatting" ;
  kneg_nn_1 = mkN "kneg" neutrum ;
  knegare_nn_1 = mkN "knegare" "knegare" ;
  knejpkur_nn_1 = mkN "knejpkur" "knejpkurer" ;
  knekt_nn_1 = mkN "knekt" ;
  knep_nn_1 = mkN "knep" neutrum ;
  knepig_av_1 = mkA "knepig" ;
  knick_nn_1 = mkN "knick" ;
  knip_nn_1 = mkN "knip" neutrum ;
  knipa_vb_1 = mkV "knipa" "knep" "knipit" ;
  knipslug_av_1 = mkA "knipslug" ;
  kniptaang_nn_1 = mkN "kniptеng" "kniptдnger" ;
  kniptaangsmanoever_nn_1 = mkN "kniptеngsmanцver" ;
  kniv_nn_1 = mkN "kniv" ;
  knivblad_nn_1 = mkN "knivblad" neutrum ;
  knivbladslik_av_1 = mkA "knivbladslik" ;
  knivhugg_nn_1 = mkN "knivhugg" neutrum ;
  knivig_av_1 = mkA "knivig" ;
  knivkastning_nn_1 = mkN "knivkastning" ;
  knivkontakt_nn_1 = mkN "knivkontakt" "knivkontakter" ;
  knivlaeggare_nn_1 = mkN "knivlдggare" "knivlдggare" ;
  knivrygg_nn_1 = mkN "knivrygg" ;
  knivskaft_nn_1 = mkN "knivskaft" neutrum ;
  knivskarp_av_1 = mkA "knivskarp" ;
  knivskuren_av_1 = mkA "knivskuren" "knivskuret" ;
  knivsrygg_nn_1 = mkN "knivsrygg" ;
  knivsudd_nn_1 = mkN "knivsudd" ;
  knix_nn_1 = mkN "knix" ;
  knockdown_nn_1 = mkN "knockdown" "knockdowner" ;
  knockout_nn_1 = mkN "knockout" "knockouter" ;
  knodd_nn_1 = mkN "knodd" ;
  knoddaen_av_1 = mkA "knoddдn" ;
  knoedel_nn_1 = mkN "knцdel" ;
  knoel_nn_1 = mkN "knцl" ;
  knoelaktig_av_1 = mkA "knцlaktig" ;
  knoelig_av_1 = mkA "knцlig" ;
  knoelpaak_nn_1 = mkN "knцlpеk" ;
  knoelrot_nn_1 = mkN "knцlrot" "knцlrцtter" ;
  knoelstam_nn_1 = mkN "knцlstam" "knцlstammen" "knцlstammar" "knцlstammarna" ;
  knoelsvan_nn_1 = mkN "knцlsvan" ;
  knoes_nn_1 = mkN "knцs" ;
  knog_nn_1 = mkN "knog" neutrum ;
  knoge_nn_1 = mkN "knoge" utrum ;
  knogig_av_1 = mkA "knogig" ;
  knogjaern_nn_1 = mkN "knogjдrn" neutrum ;
  knollrig_av_1 = mkA "knollrig" ;
  knop_nn_1 = mkN "knop" ;
  knop_nn_2 = mkN "knop" "knopen" "knop" "knopen" ;
  knopp_nn_1 = mkN "knopp" ;
  knoppig_av_1 = mkA "knoppig" ;
  knoppsaettning_nn_1 = mkN "knoppsдttning" ;
  knoppsprickning_nn_1 = mkN "knoppsprickning" ;
  knorr_nn_1 = mkN "knorr" ;
  knorrhane_nn_1 = mkN "knorrhane" utrum ;
  knoster_nn_1 = mkN "knoster" neutrum ;
  knot_nn_1 = mkN "knot" ;
  knotig_av_1 = mkA "knotig" ;
  knott_nn_1 = mkN "knott" neutrum ;
  knottrig_av_1 = mkA "knottrig" ;
  knubbig_av_1 = mkA "knubbig" ;
  knubbsael_nn_1 = mkN "knubbsдl" ;
  knuff_nn_1 = mkN "knuff" ;
  knull_nn_1 = mkN "knull" neutrum ;
  knusslig_av_1 = mkA "knusslig" ;
  knut_nn_1 = mkN "knut" ;
  knutbroderi_nn_1 = mkN "knutbroderi" "knutbroderit" "knutbroderier" "knutbroderierna" ;
  knuten_av_1 = mkA "knuten" "knutet" ;
  knutig_av_1 = mkA "knutig" ;
  knutpunkt_nn_1 = mkN "knutpunkt" "knutpunkter" ;
  knutte_nn_1 = mkN "knutte" utrum ;
  knyck_nn_1 = mkN "knyck" ;
  knyckig_av_1 = mkA "knyckig" ;
  knyst_nn_1 = mkN "knyst" neutrum ;
  knyta_vb_1 = mkV "knyta" "knцt" "knutit" ;
  knytkalas_nn_1 = mkN "knytkalas" neutrum ;
  knytnaeve_nn_1 = mkN "knytnдve" utrum ;
  knytnaevsslag_nn_1 = mkN "knytnдvsslag" neutrum ;
  knytskaerp_nn_1 = mkN "knytskдrp" neutrum ;
  ko_nn_1 = mkN "ko" "kor" ;
  koalition_nn_1 = mkN "koalition" "koalitioner" ;
  koalitionsregering_nn_1 = mkN "koalitionsregering" ;
  koaxialkabel_nn_1 = mkN "koaxialkabel" ;
  kobbe_nn_1 = mkN "kobbe" utrum ;
  kobbel_nn_1 = mkN "kobbel" ;
  kobent_av_1 = mkA "kobent" "kobent" ;
  kobolthalt_nn_1 = mkN "kobolthalt" "kobolthalter" ;
  kobolthaltig_av_1 = mkA "kobolthaltig" ;
  koboltkanon_nn_1 = mkN "koboltkanon" "koboltkanoner" ;
  kock_nn_1 = mkN "kock" ;
  kock_nn_2 = mkN "kock" "kocker" ;
  kod_nn_1 = mkN "kod" "koder" ;
  kodex_nn_1 = mkN "kodex" ;
  kodicill_nn_1 = mkN "kodicill" "kodiciller" ;
  kodifikation_nn_1 = mkN "kodifikation" "kodifikationer" ;
  koe_nn_1 = mkN "kц" "kцn" "kцer" "kцerna" ;
  koefficient_nn_1 = mkN "koefficient" "koefficienter" ;
  koek_nn_1 = mkN "kцk" neutrum ;
  koekkenmoedding_nn_1 = mkN "kцkkenmцdding" ;
  koeksbord_nn_1 = mkN "kцksbord" neutrum ;
  koeksflaekt_nn_1 = mkN "kцksflдkt" ;
  koekshandduk_nn_1 = mkN "kцkshandduk" ;
  koeksingaang_nn_1 = mkN "kцksingеng" ;
  koeksmaestare_nn_1 = mkN "kцksmдstare" "kцksmдstare" ;
  koeksmaskin_nn_1 = mkN "kцksmaskin" "kцksmaskiner" ;
  koeksrulle_nn_1 = mkN "kцksrulle" utrum ;
  koekssax_nn_1 = mkN "kцkssax" ;
  koeksspis_nn_1 = mkN "kцksspis" ;
  koekstraedgaard_nn_1 = mkN "kцkstrдdgеrd" ;
  koeksvaext_nn_1 = mkN "kцksvдxt" "kцksvдxter" ;
  koel_nn_1 = mkN "kцl" ;
  koelbaat_nn_1 = mkN "kцlbеt" ;
  koeldbestaendig_av_1 = mkA "kцldbestдndig" ;
  koeldblandning_nn_1 = mkN "kцldblandning" ;
  koeldgrad_nn_1 = mkN "kцldgrad" "kцldgrader" ;
  koeldhaerdig_av_1 = mkA "kцldhдrdig" ;
  koeldknaepp_nn_1 = mkN "kцldknдpp" ;
  koeldpol_nn_1 = mkN "kцldpol" "kцldpoler" ;
  koeldpunkt_nn_1 = mkN "kцldpunkt" "kцldpunkter" ;
  koelsvin_nn_1 = mkN "kцlsvin" neutrum ;
  koen_nn_1 = mkN "kцn" neutrum ;
  koenlig_av_1 = mkA "kцnlig" ;
  koenloes_av_1 = mkA "kцnlцs" ;
  koensakt_nn_1 = mkN "kцnsakt" "kцnsakter" ;
  koensbunden_av_1 = mkA "kцnsbunden" "kцnsbundet" ;
  koensbyte_nn_1 = mkN "kцnsbyte" ;
  koenscell_nn_1 = mkN "kцnscell" "kцnsceller" ;
  koenshormon_nn_1 = mkN "kцnshormon" neutrum ;
  koenskaraktaer_nn_1 = mkN "kцnskaraktдr" "kцnskaraktдrer" ;
  koenskoertel_nn_1 = mkN "kцnskцrtel" ;
  koenslig_av_1 = mkA "kцnslig" ;
  koensmogen_av_1 = mkA "kцnsmogen" "kцnsmoget" ;
  koensmognad_nn_1 = mkN "kцnsmognad" "kцnsmognader" ;
  koensord_nn_1 = mkN "kцnsord" neutrum ;
  koensorgan_nn_1 = mkN "kцnsorgan" neutrum ;
  koensroll_nn_1 = mkN "kцnsroll" "kцnsroller" ;
  koenssjukdom_nn_1 = mkN "kцnssjukdom" ;
  koensumgaenge_nn_1 = mkN "kцnsumgдnge" ;
  koensvarelse_nn_1 = mkN "kцnsvarelse" "kцnsvarelser" ;
  koep_nn_1 = mkN "kцp" neutrum ;
  koepare_nn_1 = mkN "kцpare" "kцpare" ;
  koepcentrum_nn_1 = mkN "kцpcentrum" neutrum ;
  koepebrev_nn_1 = mkN "kцpebrev" neutrum ;
  koepebroed_nn_1 = mkN "kцpebrцd" neutrum ;
  koepekontrakt_nn_1 = mkN "kцpekontrakt" neutrum ;
  koepenickiad_nn_1 = mkN "kцpenickiad" "kцpenickiader" ;
  koepenskap_nn_1 = mkN "kцpenskap" "kцpenskaper" ;
  koepeskilling_nn_1 = mkN "kцpeskilling" ;
  koeping_nn_1 = mkN "kцping" ;
  koepkort_nn_1 = mkN "kцpkort" neutrum ;
  koepkurs_nn_1 = mkN "kцpkurs" "kцpkurser" ;
  koepman_nn_1 = mkN "kцpman" "kцpmannen" "kцpmдn" "kцpmдnnen" ;
  koepslut_nn_1 = mkN "kцpslut" neutrum ;
  koepstad_nn_1 = mkN "kцpstad" "kцpstдder" ;
  koepstark_av_1 = mkA "kцpstark" ;
  koer_nn_1 = mkN "kцr" "kцrer" ;
  koerare_nn_1 = mkN "kцrare" "kцrare" ;
  koerbar_av_1 = mkA "kцrbar" ;
  koeregenskap_nn_1 = mkN "kцregenskap" "kцregenskaper" ;
  koerfaelt_nn_1 = mkN "kцrfдlt" neutrum ;
  koerfoerbud_nn_1 = mkN "kцrfцrbud" neutrum ;
  koerig_av_1 = mkA "kцrig" ;
  koerkarl_nn_1 = mkN "kцrkarl" ;
  koerkort_nn_1 = mkN "kцrkort" neutrum ;
  koerkortsprov_nn_1 = mkN "kцrkortsprov" neutrum ;
  koerledare_nn_1 = mkN "kцrledare" "kцrledare" ;
  koerlektion_nn_1 = mkN "kцrlektion" "kцrlektioner" ;
  koernare_nn_1 = mkN "kцrnare" "kцrnare" ;
  koerning_nn_1 = mkN "kцrning" ;
  koerriktningsvisare_nn_1 = mkN "kцrriktningsvisare" "kцrriktningsvisare" ;
  koersbaer_nn_1 = mkN "kцrsbдr" neutrum ;
  koersbaerstraed_nn_1 = mkN "kцrsbдrstrдd" neutrum ;
  koersnaer_nn_1 = mkN "kцrsnдr" "kцrsnдrer" ;
  koersven_nn_1 = mkN "kцrsven" "kцrsvennen" "kцrsvenner" "kцrsvennerna" ;
  koertel_nn_1 = mkN "kцrtel" ;
  koertelcell_nn_1 = mkN "kцrtelcell" "kцrtelceller" ;
  koerteloeppning_nn_1 = mkN "kцrtelцppning" ;
  koertid_nn_1 = mkN "kцrtid" "kцrtider" ;
  koervaeg_nn_1 = mkN "kцrvдg" ;
  koettaetande_av_1 = mkA "kцttдtande" ;
  koettaetare_nn_1 = mkN "kцttдtare" "kцttдtare" ;
  koettben_nn_1 = mkN "kцttben" neutrum ;
  koettbulle_nn_1 = mkN "kцttbulle" utrum ;
  koetted_nn_1 = mkN "kцtted" "kцtteder" ;
  koettig_av_1 = mkA "kцttig" ;
  koettkvarn_nn_1 = mkN "kцttkvarn" ;
  koettmarknad_nn_1 = mkN "kцttmarknad" "kцttmarknader" ;
  koettsaar_nn_1 = mkN "kцttsеr" neutrum ;
  koettsida_nn_1 = mkN "kцttsida" ;
  koettslig_av_1 = mkA "kцttslig" ;
  kofaangare_nn_1 = mkN "kofеngare" "kofеngare" ;
  koff_nn_1 = mkN "koff" ;
  kofferdamm_nn_1 = mkN "kofferdamm" ;
  kofferdist_nn_1 = mkN "kofferdist" "kofferdister" ;
  koffernagel_nn_1 = mkN "koffernagel" ;
  koffert_nn_1 = mkN "koffert" ;
  koffertfisk_nn_1 = mkN "koffertfisk" ;
  kofot_nn_1 = mkN "kofot" ;
  koger_nn_1 = mkN "koger" neutrum ;
  kogg_nn_1 = mkN "kogg" ;
  kognat_nn_1 = mkN "kognat" "kognater" ;
  kognatisk_av_1 = mkA "kognatisk" ;
  kognitiv_av_1 = mkA "kognitiv" ;
  koherent_av_1 = mkA "koherent" "koherent" ;
  kohort_nn_1 = mkN "kohort" "kohorter" ;
  kohud_nn_1 = mkN "kohud" ;
  koj_nn_1 = mkN "koj" "kojer" ;
  kok_nn_1 = mkN "kok" neutrum ;
  kokapparat_nn_1 = mkN "kokapparat" "kokapparater" ;
  kokard_nn_1 = mkN "kokard" "kokarder" ;
  kokare_nn_1 = mkN "kokare" "kokare" ;
  kokarreaktor_nn_1 = mkN "kokarreaktor" "kokarreaktorer" ;
  kokbok_nn_1 = mkN "kokbok" "kokbцcker" ;
  kokeri_nn_1 = mkN "kokeri" "kokerit" "kokerier" "kokerierna" ;
  kokerska_nn_1 = mkN "kokerska" ;
  kokett_av_1 = mkA "kokett" ;
  kokett_nn_1 = mkN "kokett" "koketter" ;
  koketteri_nn_1 = mkN "koketteri" "koketterit" "koketterier" "koketterierna" ;
  kokgrop_nn_1 = mkN "kokgrop" ;
  kokhet_av_1 = mkA "kokhet" ;
  kokill_nn_1 = mkN "kokill" "kokiller" ;
  kokkaerl_nn_1 = mkN "kokkдrl" neutrum ;
  kokkorv_nn_1 = mkN "kokkorv" ;
  kokong_nn_1 = mkN "kokong" "kokonger" ;
  kokosboll_nn_1 = mkN "kokosboll" ;
  kokosfiber_nn_1 = mkN "kokosfiber" "kokosfibern" "kokosfibrer" "kokosfibrerna" ;
  kokosnoet_nn_1 = mkN "kokosnцt" "kokosnцtter" ;
  kokospalm_nn_1 = mkN "kokospalm" "kokospalmer" ;
  kokott_nn_1 = mkN "kokott" "kokotter" ;
  kokpunkt_nn_1 = mkN "kokpunkt" "kokpunkter" ;
  koktid_nn_1 = mkN "koktid" "koktider" ;
  kokvagn_nn_1 = mkN "kokvagn" ;
  kokvraa_nn_1 = mkN "kokvrе" "kokvrеn" "kokvrеr" "kokvrеrna" ;
  kol_14_laboratorium_nn_1 = mkN "kol-14-laboratorium" "kol-14-laboratoriet" "kol-14-laboratorier" "kol-14-laboratorierna" ;
  kol_nn_1 = mkN "kol" neutrum ;
  kolare_nn_1 = mkN "kolare" "kolare" ;
  kolatom_nn_1 = mkN "kolatom" "kolatomer" ;
  kolatraed_nn_1 = mkN "kolatrдd" neutrum ;
  kolbaerare_nn_1 = mkN "kolbдrare" "kolbдrare" ;
  kolbit_nn_1 = mkN "kolbit" ;
  kolborste_nn_1 = mkN "kolborste" utrum ;
  kolbotten_nn_1 = mkN "kolbotten" ;
  kolbox_nn_1 = mkN "kolbox" ;
  kolbrikett_nn_1 = mkN "kolbrikett" "kolbriketter" ;
  kolbulle_nn_1 = mkN "kolbulle" utrum ;
  kolchos_nn_1 = mkN "kolchos" "kolchoser" ;
  koldioxidfri_av_1 = mkA "koldioxidfri" "koldioxidfritt" ;
  koldioxidkanal_nn_1 = mkN "koldioxidkanal" "koldioxidkanaler" ;
  koldioxidmolekyl_nn_1 = mkN "koldioxidmolekyl" "koldioxidmolekyler" ;
  koleld_nn_1 = mkN "koleld" ;
  kolerabakterie_nn_1 = mkN "kolerabakterie" "kolerabakterier" ;
  kolerakyrkogaard_nn_1 = mkN "kolerakyrkogеrd" ;
  koleriker_nn_1 = mkN "koleriker" "kolerikern" "koleriker" "kolerikerna" ;
  kolerisk_av_1 = mkA "kolerisk" ;
  kolfloets_nn_1 = mkN "kolflцts" "kolflцtser" ;
  kolfoerening_nn_1 = mkN "kolfцrening" ;
  kolhaemtare_nn_1 = mkN "kolhдmtare" "kolhдmtare" ;
  kolhalt_nn_1 = mkN "kolhalt" "kolhalter" ;
  kolhaltig_av_1 = mkA "kolhaltig" ;
  kolhoeg_nn_1 = mkN "kolhцg" ;
  kolhydrat_nn_1 = mkN "kolhydrat" neutrum ;
  kolibakterie_nn_1 = mkN "kolibakterie" "kolibakterier" ;
  kolibri_nn_1 = mkN "kolibri" "kolibrin" "kolibrier" "kolibrierna" ;
  koling_nn_1 = mkN "koling" ;
  kolisotop_nn_1 = mkN "kolisotop" "kolisotoper" ;
  kolje_nn_1 = mkN "koljй" "koljйer" ;
  kolkaellare_nn_1 = mkN "kolkдllare" "kolkдllare" ;
  koll_nn_1 = mkN "koll" ;
  kollaboratoer_nn_1 = mkN "kollaboratцr" "kollaboratцrer" ;
  kollage_nn_1 = mkN "kollage" "kollaget" "kollage" "kollagen" ;
  kollaps_nn_1 = mkN "kollaps" "kollapser" ;
  kollation_nn_1 = mkN "kollation" "kollationer" ;
  kollega_nn_1 = mkN "kollega" ;
  kollegial_av_1 = mkA "kollegial" ;
  kollegialitet_nn_1 = mkN "kollegialitet" "kollegialiteter" ;
  kollegieblock_nn_1 = mkN "kollegieblock" neutrum ;
  kollegium_nn_1 = mkN "kollegium" "kollegiet" "kollegier" "kollegierna" ;
  kollekt_nn_1 = mkN "kollekt" "kollekter" ;
  kollektion_nn_1 = mkN "kollektion" "kollektioner" ;
  kollektiv_av_1 = mkA "kollektiv" ;
  kollektiv_nn_1 = mkN "kollektiv" neutrum ;
  kollektivanslutning_nn_1 = mkN "kollektivanslutning" ;
  kollektivanstaelld_av_1 = mkA "kollektivanstдlld" "kollektivanstдllt" ;
  kollektivanstaellning_nn_1 = mkN "kollektivanstдllning" ;
  kollektivavtal_nn_1 = mkN "kollektivavtal" "kollektivavtalet" "kollektivavtalen" "kollektivavtalena" ;
  kollektivfil_nn_1 = mkN "kollektivfil" "kollektivfiler" ;
  kollektivfoersaekring_nn_1 = mkN "kollektivfцrsдkring" ;
  kollektivhus_nn_1 = mkN "kollektivhus" neutrum ;
  kollektivjordbruk_nn_1 = mkN "kollektivjordbruk" neutrum ;
  kollektivnot_nn_1 = mkN "kollektivnot" "kollektivnoter" ;
  kollektor_nn_1 = mkN "kollektor" "kollektorer" ;
  kolli_nn_1 = mkN "kolli" "kollit" "kolli" "kollina" ;
  kollision_nn_1 = mkN "kollision" "kollisioner" ;
  kollisionskurs_nn_1 = mkN "kollisionskurs" "kollisionskurser" ;
  kollisionsskott_nn_1 = mkN "kollisionsskott" neutrum ;
  kollo_nn_1 = mkN "kollo" "kollot" "kollon" "kollona" ;
  kolloid_nn_1 = mkN "kolloid" "kolloider" ;
  kolloidal_av_1 = mkA "kolloidal" ;
  kollokvium_nn_1 = mkN "kollokvium" "kollokviet" "kollokvier" "kollokvierna" ;
  kollrig_av_1 = mkA "kollrig" ;
  kolmoerk_av_1 = mkA "kolmцrk" ;
  kolning_nn_1 = mkN "kolning" ;
  kolofon_nn_1 = mkN "kolofon" "kolofoner" ;
  kolokvint_nn_1 = mkN "kolokvint" "kolokvinter" ;
  kolon_nn_1 = mkN "kolon" neutrum ;
  kolonat_nn_1 = mkN "kolonat" neutrum ;
  koloni_nn_1 = mkN "koloni" "kolonier" ;
  kolonial_av_1 = mkA "kolonial" ;
  kolonialarme_nn_1 = mkN "kolonialarmй" "kolonialarmйer" ;
  kolonialkrig_nn_1 = mkN "kolonialkrig" neutrum ;
  kolonialmakt_nn_1 = mkN "kolonialmakt" "kolonialmakter" ;
  kolonialvaelde_nn_1 = mkN "kolonialvдlde" ;
  kolonilott_nn_1 = mkN "kolonilott" "kolonilotter" ;
  kolonisation_nn_1 = mkN "kolonisation" "kolonisationer" ;
  kolonisationstid_nn_1 = mkN "kolonisationstid" "kolonisationstider" ;
  kolonisatoer_nn_1 = mkN "kolonisatцr" "kolonisatцrer" ;
  kolonistuga_nn_1 = mkN "kolonistuga" ;
  kolonn_nn_1 = mkN "kolonn" "kolonner" ;
  kolonnad_nn_1 = mkN "kolonnad" "kolonnader" ;
  kolonnett_nn_1 = mkN "kolonnett" "kolonnetter" ;
  kolonnordning_nn_1 = mkN "kolonnordning" ;
  koloradoskalbagge_nn_1 = mkN "koloradoskalbagge" utrum ;
  koloratur_nn_1 = mkN "koloratur" "koloraturer" ;
  koloratursaangerska_nn_1 = mkN "koloratursеngerska" ;
  kolorist_nn_1 = mkN "kolorist" "kolorister" ;
  kolorit_nn_1 = mkN "kolorit" "koloriter" ;
  koloss_nn_1 = mkN "koloss" "kolosser" ;
  kolossal_av_1 = mkA "kolossal" ;
  kolportagemaessig_av_1 = mkA "kolportagemдssig" ;
  kolportoer_nn_1 = mkN "kolportцr" "kolportцrer" ;
  kolryss_nn_1 = mkN "kolryss" ;
  kolstaal_nn_1 = mkN "kolstеl" neutrum ;
  kolstift_nn_1 = mkN "kolstift" neutrum ;
  kolsvart_av_1 = mkA "kolsvart" "kolsvart" ;
  kolsyraassimilation_nn_1 = mkN "kolsyraassimilation" "kolsyraassimilationer" ;
  kolt_nn_1 = mkN "kolt" ;
  koltablett_nn_1 = mkN "koltablett" "koltabletter" ;
  koltavdelning_nn_1 = mkN "koltavdelning" ;
  koltbarn_nn_1 = mkN "koltbarn" neutrum ;
  kolteckning_nn_1 = mkN "kolteckning" ;
  koltraad_nn_1 = mkN "koltrеd" ;
  koltrast_nn_1 = mkN "koltrast" ;
  kolugn_av_1 = mkA "kolugn" ;
  kolumbarium_nn_1 = mkN "kolumbarium" "kolumbariet" "kolumbarier" "kolumbarierna" ;
  kolumn_nn_1 = mkN "kolumn" "kolumner" ;
  kolumnist_nn_1 = mkN "kolumnist" "kolumnister" ;
  kolumntitel_nn_1 = mkN "kolumntitel" ;
  kolv_nn_1 = mkN "kolv" ;
  kolvhals_nn_1 = mkN "kolvhals" ;
  kolvmotor_nn_1 = mkN "kolvmotor" "kolvmotorer" ;
  komatoes_av_1 = mkA "komatцs" ;
  kombattant_nn_1 = mkN "kombattant" "kombattanter" ;
  kombinat_nn_1 = mkN "kombinat" neutrum ;
  kombination_nn_1 = mkN "kombination" "kombinationer" ;
  kombinationslaas_nn_1 = mkN "kombinationslеs" neutrum ;
  kombinationsmaattsats_nn_1 = mkN "kombinationsmеttsats" "kombinationsmеttsatser" ;
  kombinationstaevling_nn_1 = mkN "kombinationstдvling" ;
  kombinatorisk_av_1 = mkA "kombinatorisk" ;
  komedi_nn_1 = mkN "komedi" "komedier" ;
  komediant_nn_1 = mkN "komediant" "komedianter" ;
  komedienn_nn_1 = mkN "komedienn" "komedienner" ;
  komet_nn_1 = mkN "komet" "kometer" ;
  kometmoln_nn_1 = mkN "kometmoln" neutrum ;
  komfortabel_av_1 = mkA "komfortabel" "komfortabelt" "komfortabla" "komfortabla" "komfortablare" "komfortablast" "komfortablaste" ;
  komiker_nn_1 = mkN "komiker" "komikern" "komiker" "komikerna" ;
  komisk_av_1 = mkA "komisk" ;
  komma_nn_1 = mkN "komma" "kommat" "komman" "kommana" ;
  komma_vb_1 = mkV "komma" "kom" "kommit" ;
  kommabacill_nn_1 = mkN "kommabacill" "kommabaciller" ;
  kommande_av_1 = mkA "kommande" ;
  kommanditbolag_nn_1 = mkN "kommanditbolag" neutrum ;
  kommanditdelaegare_nn_1 = mkN "kommanditdelдgare" "kommanditdelдgare" ;
  kommando_nn_1 = mkN "kommando" "kommandot" "kommandon" "kommandona" ;
  kommandomaal_nn_1 = mkN "kommandomеl" neutrum ;
  kommandoord_nn_1 = mkN "kommandoord" neutrum ;
  kommandoroest_nn_1 = mkN "kommandorцst" "kommandorцster" ;
  kommatering_nn_1 = mkN "kommatering" ;
  kommendant_nn_1 = mkN "kommendant" "kommendanter" ;
  kommendantur_nn_1 = mkN "kommendantur" "kommendanturer" ;
  kommendering_nn_1 = mkN "kommendering" ;
  kommendoer_nn_1 = mkN "kommendцr" "kommendцrer" ;
  kommendoerkapten_nn_1 = mkN "kommendцrkapten" "kommendцrkaptener" ;
  kommensurabel_av_1 = mkA "kommensurabel" "kommensurabelt" "kommensurabla" "kommensurabla" "kommensurablare" "kommensurablast" "kommensurablaste" ;
  kommentar_nn_1 = mkN "kommentar" "kommentarer" ;
  kommentator_nn_1 = mkN "kommentator" "kommentatorer" ;
  kommers_nn_1 = mkN "kommers" "kommerser" ;
  kommerseraad_nn_1 = mkN "kommerserеd" neutrum ;
  kommersialisering_nn_1 = mkN "kommersialisering" ;
  kommersiell_av_1 = mkA "kommersiell" ;
  kommerskollegium_nn_1 = mkN "kommerskollegium" "kommerskollegiet" "kommerskollegier" "kommerskollegierna" ;
  komminister_nn_1 = mkN "komminister" ;
  kommissariat_nn_1 = mkN "kommissariat" neutrum ;
  kommissarie_nn_1 = mkN "kommissarie" "kommissarier" ;
  kommission_nn_1 = mkN "kommission" "kommissioner" ;
  kommissionaer_nn_1 = mkN "kommissionдr" "kommissionдrer" ;
  kommitte_nn_1 = mkN "kommittй" "kommittйer" ;
  kommod_nn_1 = mkN "kommod" "kommoder" ;
  kommun_nn_1 = mkN "kommun" "kommuner" ;
  kommunaegd_av_1 = mkA "kommunдgd" "kommunдgt" ;
  kommunal_av_1 = mkA "kommunal" ;
  kommunalfoervaltning_nn_1 = mkN "kommunalfцrvaltning" ;
  kommunalfullmaektig_nn_1 = mkN "kommunalfullmдktig" "kommunalfullmдktigen" "kommunalfullmдktige" "kommunalfullmдktigena" ;
  kommunalhus_nn_1 = mkN "kommunalhus" neutrum ;
  kommunallag_nn_1 = mkN "kommunallag" ;
  kommunalman_nn_1 = mkN "kommunalman" "kommunalmannen" "kommunalmдn" "kommunalmдnnen" ;
  kommunalnaemnd_nn_1 = mkN "kommunalnдmnd" "kommunalnдmnder" ;
  kommunalnaemndsordfoerande_nn_1 = mkN "kommunalnдmndsordfцrande" "kommunalnдmndsordfцranden" "kommunalnдmndsordfцrande" "kommunalnдmndsordfцrandena" ;
  kommunalordfoerande_nn_1 = mkN "kommunalordfцrande" "kommunalordfцranden" "kommunalordfцrande" "kommunalordfцrandena" ;
  kommunalpolitiker_nn_1 = mkN "kommunalpolitiker" "kommunalpolitikern" "kommunalpolitiker" "kommunalpolitikerna" ;
  kommunalpolitisk_av_1 = mkA "kommunalpolitisk" ;
  kommunalraad_nn_1 = mkN "kommunalrеd" neutrum ;
  kommunalskatt_nn_1 = mkN "kommunalskatt" "kommunalskatter" ;
  kommunalstyrelse_nn_1 = mkN "kommunalstyrelse" "kommunalstyrelser" ;
  kommunalval_nn_1 = mkN "kommunalval" neutrum ;
  kommunard_nn_1 = mkN "kommunard" "kommunarder" ;
  kommunblock_nn_1 = mkN "kommunblock" neutrum ;
  kommundel_nn_1 = mkN "kommundel" "kommundelen" "kommundelar" "kommundelarna" ;
  kommundelsraad_nn_1 = mkN "kommundelsrеd" neutrum ;
  kommunfoerbund_nn_1 = mkN "kommunfцrbund" neutrum ;
  kommunfullmaektig_nn_1 = mkN "kommunfullmдktig" "kommunfullmдktigen" "kommunfullmдktige" "kommunfullmдktigena" ;
  kommunikant_nn_1 = mkN "kommunikant" "kommunikanter" ;
  kommunikation_nn_1 = mkN "kommunikation" "kommunikationer" ;
  kommunikationsakt_nn_1 = mkN "kommunikationsakt" "kommunikationsakter" ;
  kommunikationsdepartement_nn_1 = mkN "kommunikationsdepartement" "kommunikationsdepartementet" "kommunikationsdepartementen" "kommunikationsdepartementena" ;
  kommunikationsmedel_nn_1 = mkN "kommunikationsmedel" neutrum ;
  kommunikationsminister_nn_1 = mkN "kommunikationsminister" ;
  kommunikationsnaet_nn_1 = mkN "kommunikationsnдt" neutrum ;
  kommunikationsradio_nn_1 = mkN "kommunikationsradio" "kommunikationsradior" ;
  kommunikationssatellit_nn_1 = mkN "kommunikationssatellit" "kommunikationssatelliter" ;
  kommunikationstabell_nn_1 = mkN "kommunikationstabell" "kommunikationstabeller" ;
  kommunikativ_av_1 = mkA "kommunikativ" ;
  kommunikatoer_nn_1 = mkN "kommunikatцr" "kommunikatцrer" ;
  kommunikator_nn_1 = mkN "kommunikator" "kommunikatorer" ;
  kommunike_nn_1 = mkN "kommunikй" "kommunikйer" ;
  kommuninnevaanare_nn_1 = mkN "kommuninnevеnare" "kommuninnevеnare" ;
  kommuninvaanare_nn_1 = mkN "kommuninvеnare" "kommuninvеnare" ;
  kommunion_nn_1 = mkN "kommunion" "kommunioner" ;
  kommunist_nn_1 = mkN "kommunist" "kommunister" ;
  kommunistisk_av_1 = mkA "kommunistisk" ;
  kommunistland_nn_1 = mkN "kommunistland" "kommunistlandet" "kommunistlдnder" "kommunistlдnderna" ;
  kommunistparti_nn_1 = mkN "kommunistparti" "kommunistpartit" "kommunistpartier" "kommunistpartierna" ;
  kommunistregim_nn_1 = mkN "kommunistregim" "kommunistregimer" ;
  kommunistvaerld_nn_1 = mkN "kommunistvдrld" ;
  kommunpolitiker_nn_1 = mkN "kommunpolitiker" "kommunpolitikern" "kommunpolitiker" "kommunpolitikerna" ;
  kommunsammanslagning_nn_1 = mkN "kommunsammanslagning" ;
  kommunstyrelse_nn_1 = mkN "kommunstyrelse" "kommunstyrelser" ;
  kommutativ_av_1 = mkA "kommutativ" ;
  kommutator_nn_1 = mkN "kommutator" "kommutatorer" ;
  kompakt_av_1 = mkA "kompakt" "kompakt" ;
  kompani_nn_1 = mkN "kompani" "kompanit" "kompanier" "kompanierna" ;
  kompaniadjutant_nn_1 = mkN "kompaniadjutant" "kompaniadjutanter" ;
  kompaniofficer_nn_1 = mkN "kompaniofficer" "kompaniofficern" "kompaniofficerare" "kompaniofficerarna" ;
  kompaniorder_nn_1 = mkN "kompaniorder" ;
  kompanjon_nn_1 = mkN "kompanjon" "kompanjoner" ;
  komparabel_av_1 = mkA "komparabel" "komparabelt" "komparabla" "komparabla" "komparablare" "komparablast" "komparablaste" ;
  komparation_nn_1 = mkN "komparation" "komparationer" ;
  komparativ_av_1 = mkA "komparativ" ;
  komparativ_nn_1 = mkN "komparativ" "komparativer" ;
  kompars_nn_1 = mkN "kompars" "komparser" ;
  kompass_nn_1 = mkN "kompass" "kompasser" ;
  kompasshus_nn_1 = mkN "kompasshus" neutrum ;
  kompasskurs_nn_1 = mkN "kompasskurs" "kompasskurser" ;
  kompassnaal_nn_1 = mkN "kompassnеl" ;
  kompatibel_av_1 = mkA "kompatibel" "kompatibelt" "kompatibla" "kompatibla" "kompatiblare" "kompatiblast" "kompatiblaste" ;
  kompendium_nn_1 = mkN "kompendium" "kompendiet" "kompendier" "kompendierna" ;
  kompensation_nn_1 = mkN "kompensation" "kompensationer" ;
  kompensator_nn_1 = mkN "kompensator" "kompensatorer" ;
  kompensatorisk_av_1 = mkA "kompensatorisk" ;
  kompetens_nn_1 = mkN "kompetens" "kompetenser" ;
  kompetent_av_1 = mkA "kompetent" "kompetent" ;
  kompilat_nn_1 = mkN "kompilat" neutrum ;
  kompilation_nn_1 = mkN "kompilation" "kompilationer" ;
  kompilator_nn_1 = mkN "kompilator" "kompilatorer" ;
  kompis_nn_1 = mkN "kompis" ;
  kompledig_av_1 = mkA "kompledig" ;
  komplement_nn_1 = mkN "komplement" neutrum ;
  komplementaer_av_1 = mkA "komplementдr" ;
  komplementaer_nn_1 = mkN "komplementдr" "komplementдrer" ;
  komplementfaerg_nn_1 = mkN "komplementfдrg" "komplementfдrger" ;
  komplementmaengd_nn_1 = mkN "komplementmдngd" "komplementmдngder" ;
  komplementsystem_nn_1 = mkN "komplementsystem" neutrum ;
  komplementvinkel_nn_1 = mkN "komplementvinkel" ;
  komplett_av_1 = mkA "komplett" ;
  komplettering_nn_1 = mkN "komplettering" ;
  kompletteringstest_nn_1 = mkN "kompletteringstest" neutrum ;
  komplex_av_1 = mkA "komplex" ;
  komplex_nn_1 = mkN "komplex" neutrum ;
  komplexig_av_1 = mkA "komplexig" ;
  komplexitet_nn_1 = mkN "komplexitet" "komplexiteter" ;
  komplikation_nn_1 = mkN "komplikation" "komplikationer" ;
  komplimang_nn_1 = mkN "komplimang" "komplimanger" ;
  komplott_nn_1 = mkN "komplott" "komplotter" ;
  komponent_nn_1 = mkN "komponent" "komponenter" ;
  komponist_nn_1 = mkN "komponist" "komponister" ;
  komposant_nn_1 = mkN "komposant" "komposanter" ;
  komposit_nn_1 = mkN "komposit" "kompositer" ;
  komposition_nn_1 = mkN "komposition" "kompositioner" ;
  kompositoer_nn_1 = mkN "kompositцr" "kompositцrer" ;
  kompositum_nn_1 = mkN "kompositum" "kompositum" "komposita" "kompositerna" ;
  kompost_nn_1 = mkN "kompost" "komposter" ;
  kompott_nn_1 = mkN "kompott" "kompotter" ;
  kompress_nn_1 = mkN "kompress" "kompresser" ;
  kompression_nn_1 = mkN "kompression" "kompressioner" ;
  kompressor_nn_1 = mkN "kompressor" "kompressorer" ;
  komprimator_nn_1 = mkN "komprimator" "komprimatorer" ;
  kompromiss_nn_1 = mkN "kompromiss" "kompromisser" ;
  kompulsiv_av_1 = mkA "kompulsiv" ;
  kon_nn_1 = mkN "kon" "koner" ;
  koncentrat_nn_1 = mkN "koncentrat" neutrum ;
  koncentration_nn_1 = mkN "koncentration" "koncentrationer" ;
  koncentrationsdag_nn_1 = mkN "koncentrationsdag" ;
  koncentrationslaeger_nn_1 = mkN "koncentrationslдger" neutrum ;
  koncentrisk_av_1 = mkA "koncentrisk" ;
  koncept_nn_1 = mkN "koncept" neutrum ;
  koncept_nn_2 = mkN "koncept" neutrum ;
  konception_nn_1 = mkN "konception" "konceptioner" ;
  konceptiv_av_1 = mkA "konceptiv" ;
  konceptpapper_nn_1 = mkN "konceptpapper" neutrum ;
  konceptuell_av_1 = mkA "konceptuell" ;
  koncern_nn_1 = mkN "koncern" "koncerner" ;
  koncession_nn_1 = mkN "koncession" "koncessioner" ;
  koncessiv_av_1 = mkA "koncessiv" ;
  konciliant_av_1 = mkA "konciliant" "konciliant" ;
  koncis_av_1 = mkA "koncis" ;
  kondensat_nn_1 = mkN "kondensat" neutrum ;
  kondensation_nn_1 = mkN "kondensation" "kondensationer" ;
  kondensator_nn_1 = mkN "kondensator" "kondensatorer" ;
  kondensor_nn_1 = mkN "kondensor" "kondensorer" ;
  kondis_nn_1 = mkN "kondis" neutrum ;
  kondition_nn_1 = mkN "kondition" "konditioner" ;
  konditional_av_1 = mkA "konditional" ;
  konditor_nn_1 = mkN "konditor" "konditorer" ;
  konditori_nn_1 = mkN "konditori" "konditorit" "konditorier" "konditorierna" ;
  kondoleans_nn_1 = mkN "kondoleans" "kondoleanser" ;
  kondom_nn_1 = mkN "kondom" "kondomer" ;
  kondor_nn_1 = mkN "kondor" "kondoren" "kondorer" "kondorerna" ;
  kondottiaer_nn_1 = mkN "kondottiдr" "kondottiдrer" ;
  konduktivitet_nn_1 = mkN "konduktivitet" "konduktiviteter" ;
  konduktoer_nn_1 = mkN "konduktцr" "konduktцrer" ;
  konduktor_nn_1 = mkN "konduktor" "konduktorer" ;
  konfederal_av_1 = mkA "konfederal" ;
  konfederation_nn_1 = mkN "konfederation" "konfederationer" ;
  konfektskaal_nn_1 = mkN "konfektskеl" ;
  konferenciaer_nn_1 = mkN "konferenciдr" "konferenciдrer" ;
  konferencier_nn_1 = mkN "konferencier" "konferencierer" ;
  konferens_nn_1 = mkN "konferens" "konferenser" ;
  konfession_nn_1 = mkN "konfession" "konfessioner" ;
  konfessionarie_nn_1 = mkN "konfessionarie" "konfessionarier" ;
  konfessionell_av_1 = mkA "konfessionell" ;
  konfessionsloes_av_1 = mkA "konfessionslцs" ;
  konfidentiell_av_1 = mkA "konfidentiell" ;
  konfiguration_nn_1 = mkN "konfiguration" "konfigurationer" ;
  konfirmand_nn_1 = mkN "konfirmand" "konfirmander" ;
  konfirmation_nn_1 = mkN "konfirmation" "konfirmationer" ;
  konfirmationsbibel_nn_1 = mkN "konfirmationsbibel" ;
  konfirmationsklaenning_nn_1 = mkN "konfirmationsklдnning" ;
  konfirmationspraest_nn_1 = mkN "konfirmationsprдst" "konfirmationsprдster" ;
  konfiskation_nn_1 = mkN "konfiskation" "konfiskationer" ;
  konfiskatorisk_av_1 = mkA "konfiskatorisk" ;
  konflikt_nn_1 = mkN "konflikt" "konflikter" ;
  konfliktvarsel_nn_1 = mkN "konfliktvarsel" neutrum ;
  konform_av_1 = mkA "konform" ;
  konformig_av_1 = mkA "konformig" ;
  konformitet_nn_1 = mkN "konformitet" "konformiteter" ;
  konfrontation_nn_1 = mkN "konfrontation" "konfrontationer" ;
  konfys_av_1 = mkA "konfys" ;
  kongenial_av_1 = mkA "kongenial" ;
  kongenital_av_1 = mkA "kongenital" ;
  konglomerat_nn_1 = mkN "konglomerat" neutrum ;
  kongoles_nn_1 = mkN "kongoles" "kongoleser" ;
  kongregation_nn_1 = mkN "kongregation" "kongregationer" ;
  kongress_nn_1 = mkN "kongress" "kongresser" ;
  kongressman_nn_1 = mkN "kongressman" "kongressmannen" "kongressmдn" "kongressmдnnen" ;
  kongruens_nn_1 = mkN "kongruens" "kongruenser" ;
  kongruensboejning_nn_1 = mkN "kongruensbцjning" ;
  kongruensfall_nn_1 = mkN "kongruensfall" neutrum ;
  kongruent_av_1 = mkA "kongruent" "kongruent" ;
  konicitet_nn_1 = mkN "konicitet" "koniciteter" ;
  konisk_av_1 = mkA "konisk" ;
  konjakskrans_nn_1 = mkN "konjakskrans" ;
  konjektur_nn_1 = mkN "konjektur" "konjekturer" ;
  konjugation_nn_1 = mkN "konjugation" "konjugationer" ;
  konjunktion_nn_1 = mkN "konjunktion" "konjunktioner" ;
  konjunktiv_nn_1 = mkN "konjunktiv" "konjunktiver" ;
  konjunktur_nn_1 = mkN "konjunktur" "konjunkturer" ;
  konjunkturinstitut_nn_1 = mkN "konjunkturinstitut" neutrum ;
  konjunkturomslag_nn_1 = mkN "konjunkturomslag" neutrum ;
  konjunkturraad_nn_1 = mkN "konjunkturrеd" neutrum ;
  konkav_av_1 = mkA "konkav" ;
  konkavkonvex_av_1 = mkA "konkavkonvex" ;
  konklav_nn_1 = mkN "konklav" "konklaver" ;
  konklusion_nn_1 = mkN "konklusion" "konklusioner" ;
  konklusiv_av_1 = mkA "konklusiv" ;
  konkordans_nn_1 = mkN "konkordans" "konkordanser" ;
  konkordat_nn_1 = mkN "konkordat" neutrum ;
  konkrement_nn_1 = mkN "konkrement" neutrum ;
  konkret_av_1 = mkA "konkret" "konkret" ;
  konkretion_nn_1 = mkN "konkretion" "konkretioner" ;
  konkubin_nn_1 = mkN "konkubin" "konkubiner" ;
  konkurrenskraftig_av_1 = mkA "konkurrenskraftig" ;
  konkurrent_nn_1 = mkN "konkurrent" "konkurrenter" ;
  konkurs_nn_1 = mkN "konkurs" "konkurser" ;
  konkursbevakning_nn_1 = mkN "konkursbevakning" ;
  konkursbo_nn_1 = mkN "konkursbo" "konkursbot" "konkursbon" "konkursboen" ;
  konkursdividend_nn_1 = mkN "konkursdividend" "konkursdividender" ;
  konkursfoervaltare_nn_1 = mkN "konkursfцrvaltare" "konkursfцrvaltare" ;
  konkursmaessig_av_1 = mkA "konkursmдssig" ;
  konkursrealisation_nn_1 = mkN "konkursrealisation" "konkursrealisationer" ;
  konnaessans_nn_1 = mkN "konnдssans" "konnдssanser" ;
  konnaessoer_nn_1 = mkN "konnдssцr" "konnдssцrer" ;
  konnotation_nn_1 = mkN "konnotation" "konnotationer" ;
  konnotativ_av_1 = mkA "konnotativ" ;
  konossement_nn_1 = mkN "konossement" "konossementet" "konossementen" "konossementena" ;
  konprick_nn_1 = mkN "konprick" ;
  konsekutiv_av_1 = mkA "konsekutiv" ;
  konsekvens_nn_1 = mkN "konsekvens" "konsekvenser" ;
  konsekvent_av_1 = mkA "konsekvent" "konsekvent" ;
  konselj_nn_1 = mkN "konselj" "konseljer" ;
  konseljpresident_nn_1 = mkN "konseljpresident" "konseljpresidenter" ;
  konsert_nn_1 = mkN "konsert" "konserter" ;
  konserthus_nn_1 = mkN "konserthus" neutrum ;
  konsertmaestare_nn_1 = mkN "konsertmдstare" "konsertmдstare" ;
  konserv_nn_1 = mkN "konserv" "konserver" ;
  konservativ_av_1 = mkA "konservativ" ;
  konservator_nn_1 = mkN "konservator" "konservatorer" ;
  konservatorium_nn_1 = mkN "konservatorium" "konservatoriet" "konservatorier" "konservatorierna" ;
  konservburk_nn_1 = mkN "konservburk" ;
  konservering_nn_1 = mkN "konservering" ;
  konserveringsapparat_nn_1 = mkN "konserveringsapparat" "konserveringsapparater" ;
  konserveringsmedel_nn_1 = mkN "konserveringsmedel" neutrum ;
  konservoeppnare_nn_1 = mkN "konservцppnare" "konservцppnare" ;
  konsideration_nn_1 = mkN "konsideration" "konsiderationer" ;
  konsignation_nn_1 = mkN "konsignation" "konsignationer" ;
  konsilians_nn_1 = mkN "konsilians" "konsilianser" ;
  konsiliant_av_1 = mkA "konsiliant" "konsiliant" ;
  konsilium_nn_1 = mkN "konsilium" "konsiliet" "konsilier" "konsilierna" ;
  konsistens_nn_1 = mkN "konsistens" "konsistenser" ;
  konsistensgivare_nn_1 = mkN "konsistensgivare" "konsistensgivare" ;
  konsistorial_av_1 = mkA "konsistorial" ;
  konsistorium_nn_1 = mkN "konsistorium" "konsistoriet" "konsistorier" "konsistorierna" ;
  konsol_nn_1 = mkN "konsol" "konsoler" ;
  konsolidering_nn_1 = mkN "konsolidering" ;
  konsomme_nn_1 = mkN "konsommй" "konsommйer" ;
  konsonans_nn_1 = mkN "konsonans" "konsonanser" ;
  konsonant_av_1 = mkA "konsonant" "konsonant" ;
  konsonant_nn_1 = mkN "konsonant" "konsonanter" ;
  konsonantstam_nn_1 = mkN "konsonantstam" "konsonantstammen" "konsonantstammar" "konsonantstammarna" ;
  konsonantsystem_nn_1 = mkN "konsonantsystem" neutrum ;
  konsortium_nn_1 = mkN "konsortium" "konsortiet" "konsortier" "konsortierna" ;
  konspiration_nn_1 = mkN "konspiration" "konspirationer" ;
  konspirativ_av_1 = mkA "konspirativ" ;
  konspiratoer_nn_1 = mkN "konspiratцr" "konspiratцrer" ;
  konspiratorisk_av_1 = mkA "konspiratorisk" ;
  konst_nn_1 = mkN "konst" "konster" ;
  konstaakare_nn_1 = mkN "konstеkare" "konstеkare" ;
  konstaelskare_nn_1 = mkN "konstдlskare" "konstдlskare" ;
  konstansfenomen_nn_1 = mkN "konstansfenomen" neutrum ;
  konstant_av_1 = mkA "konstant" "konstant" ;
  konstant_nn_1 = mkN "konstant" "konstanter" ;
  konstapel_nn_1 = mkN "konstapel" ;
  konstart_nn_1 = mkN "konstart" "konstarter" ;
  konstaterande_nn_1 = mkN "konstaterande" ;
  konstberidare_nn_1 = mkN "konstberidare" "konstberidare" ;
  konstbevattning_nn_1 = mkN "konstbevattning" ;
  konstellation_nn_1 = mkN "konstellation" "konstellationer" ;
  konstfaerdig_av_1 = mkA "konstfдrdig" ;
  konstfiber_nn_1 = mkN "konstfiber" "konstfibern" "konstfibrer" "konstfibrerna" ;
  konstflygning_nn_1 = mkN "konstflygning" ;
  konstfoerening_nn_1 = mkN "konstfцrening" ;
  konstfoerfaren_av_1 = mkA "konstfцrfaren" "konstfцrfaret" ;
  konstfoervant_nn_1 = mkN "konstfцrvant" "konstfцrvanter" ;
  konstfrusen_av_1 = mkA "konstfrusen" "konstfruset" ;
  konstfull_av_1 = mkA "konstfull" ;
  konstgalleri_nn_1 = mkN "konstgalleri" "konstgallerit" "konstgallerier" "konstgallerierna" ;
  konstgjord_av_1 = mkA "konstgjord" "konstgjort" ;
  konstgrepp_nn_1 = mkN "konstgrepp" neutrum ;
  konsthall_nn_1 = mkN "konsthall" ;
  konsthantverk_nn_1 = mkN "konsthantverk" neutrum ;
  konstharts_nn_1 = mkN "konstharts" "konsthartset" "konsthartser" "konsthartserna" ;
  konsthistorisk_av_1 = mkA "konsthistorisk" ;
  konstifik_av_1 = mkA "konstifik" ;
  konstig_av_1 = mkA "konstig" ;
  konstindustri_nn_1 = mkN "konstindustri" "konstindustrier" ;
  konstitution_nn_1 = mkN "konstitution" "konstitutioner" ;
  konstitutionell_av_1 = mkA "konstitutionell" ;
  konstitutiv_av_1 = mkA "konstitutiv" ;
  konstitutorial_nn_1 = mkN "konstitutorial" neutrum ;
  konstkritiker_nn_1 = mkN "konstkritiker" "konstkritikern" "konstkritiker" "konstkritikerna" ;
  konstliv_nn_1 = mkN "konstliv" neutrum ;
  konstloes_av_1 = mkA "konstlцs" ;
  konstmaalare_nn_1 = mkN "konstmеlare" "konstmеlare" ;
  konstmaalning_nn_1 = mkN "konstmеlning" ;
  konstmuseum_nn_1 = mkN "konstmuseum" "konstmuseet" "konstmuseer" "konstmuseerna" ;
  konstnaer_nn_1 = mkN "konstnдr" "konstnдrer" ;
  konstnaerlig_av_1 = mkA "konstnдrlig" ;
  konstnaerssjael_nn_1 = mkN "konstnдrssjдl" ;
  konstpaus_nn_1 = mkN "konstpaus" "konstpauser" ;
  konstridning_nn_1 = mkN "konstridning" ;
  konstrik_av_1 = mkA "konstrik" ;
  konstriktning_nn_1 = mkN "konstriktning" ;
  konstruktion_nn_1 = mkN "konstruktion" "konstruktioner" ;
  konstruktionsdetalj_nn_1 = mkN "konstruktionsdetalj" "konstruktionsdetaljer" ;
  konstruktionslexikon_nn_1 = mkN "konstruktionslexikon" neutrum ;
  konstruktionsmaterial_nn_1 = mkN "konstruktionsmaterial" neutrum ;
  konstruktionsritning_nn_1 = mkN "konstruktionsritning" ;
  konstruktiv_av_1 = mkA "konstruktiv" ;
  konstruktoer_nn_1 = mkN "konstruktцr" "konstruktцrer" ;
  konstryttare_nn_1 = mkN "konstryttare" "konstryttare" ;
  konstsalong_nn_1 = mkN "konstsalong" "konstsalonger" ;
  konstskicklig_av_1 = mkA "konstskicklig" ;
  konstskojare_nn_1 = mkN "konstskojare" "konstskojare" ;
  konststil_nn_1 = mkN "konststil" ;
  konstutstaellning_nn_1 = mkN "konstutstдllning" ;
  konstverk_nn_1 = mkN "konstverk" neutrum ;
  konsul_nn_1 = mkN "konsul" "konsuln" "konsuler" "konsulerna" ;
  konsulaer_av_1 = mkA "konsulдr" ;
  konsularjurisdiktion_nn_1 = mkN "konsularjurisdiktion" "konsularjurisdiktioner" ;
  konsulat_nn_1 = mkN "konsulat" neutrum ;
  konsulent_nn_1 = mkN "konsulent" "konsulenter" ;
  konsulinna_nn_1 = mkN "konsulinna" ;
  konsult_nn_1 = mkN "konsult" "konsulter" ;
  konsultation_nn_1 = mkN "konsultation" "konsultationer" ;
  konsultativ_av_1 = mkA "konsultativ" ;
  konsulterande_av_1 = mkA "konsulterande" ;
  konsument_nn_1 = mkN "konsument" "konsumenter" ;
  konsumentfoerening_nn_1 = mkN "konsumentfцrening" ;
  konsumentombudsman_nn_1 = mkN "konsumentombudsman" "konsumentombudsmannen" "konsumentombudsmдn" "konsumentombudsmдnnen" ;
  konsumentpris_nn_1 = mkN "konsumentpris" neutrum ;
  konsumentprisindex_nn_1 = mkN "konsumentprisindex" neutrum ;
  konsumentverk_nn_1 = mkN "konsumentverk" neutrum ;
  konsumtionsmoejlighet_nn_1 = mkN "konsumtionsmцjlighet" "konsumtionsmцjligheter" ;
  konsumtionsskatt_nn_1 = mkN "konsumtionsskatt" "konsumtionsskatter" ;
  konsumtionsskillnad_nn_1 = mkN "konsumtionsskillnad" "konsumtionsskillnader" ;
  kont_nn_1 = mkN "kont" ;
  kontagioes_av_1 = mkA "kontagiцs" ;
  kontakt_nn_1 = mkN "kontakt" "kontakter" ;
  kontaktannons_nn_1 = mkN "kontaktannons" "kontaktannonser" ;
  kontaktborste_nn_1 = mkN "kontaktborste" utrum ;
  kontaktinfektion_nn_1 = mkN "kontaktinfektion" "kontaktinfektioner" ;
  kontaktkopia_nn_1 = mkN "kontaktkopia" ;
  kontaktledning_nn_1 = mkN "kontaktledning" ;
  kontaktlins_nn_1 = mkN "kontaktlins" "kontaktlinser" ;
  kontamination_nn_1 = mkN "kontamination" "kontaminationer" ;
  kontant_av_1 = mkA "kontant" "kontant" ;
  kontemplation_nn_1 = mkN "kontemplation" "kontemplationer" ;
  kontemplativ_av_1 = mkA "kontemplativ" ;
  konteramiral_nn_1 = mkN "konteramiral" "konteramiraler" ;
  konterfej_nn_1 = mkN "konterfej" neutrum ;
  kontext_nn_1 = mkN "kontext" "kontexter" ;
  kontinent_nn_1 = mkN "kontinent" "kontinenter" ;
  kontinental_av_1 = mkA "kontinental" ;
  kontinentalplataa_nn_1 = mkN "kontinentalplatе" "kontinentalplatеer" ;
  kontinentalsockel_nn_1 = mkN "kontinentalsockel" ;
  kontingent_nn_1 = mkN "kontingent" "kontingenter" ;
  kontinuerlig_av_1 = mkA "kontinuerlig" ;
  kontinuitet_nn_1 = mkN "kontinuitet" "kontinuiteter" ;
  kontinuum_nn_1 = mkN "kontinuum" neutrum ;
  konto_nn_1 = mkN "konto" "kontot" "konton" "kontona" ;
  kontoinnehavare_nn_1 = mkN "kontoinnehavare" "kontoinnehavare" ;
  kontokort_nn_1 = mkN "kontokort" neutrum ;
  kontokurant_nn_1 = mkN "kontokurant" "kontokuranter" ;
  kontonummer_nn_1 = mkN "kontonummer" neutrum ;
  kontor_nn_1 = mkN "kontor" neutrum ;
  kontorist_nn_1 = mkN "kontorist" "kontorister" ;
  kontorschef_nn_1 = mkN "kontorschef" "kontorschefer" ;
  kontorshus_nn_1 = mkN "kontorshus" neutrum ;
  kontorslandskap_nn_1 = mkN "kontorslandskap" "kontorslandskapet" "kontorslandskapen" "kontorslandskapena" ;
  kontorsplats_nn_1 = mkN "kontorsplats" "kontorsplatser" ;
  kontorspulpet_nn_1 = mkN "kontorspulpet" "kontorspulpeter" ;
  kontorsrum_nn_1 = mkN "kontorsrum" "kontorsrummet" "kontorsrum" "kontorsrummen" ;
  kontorsslav_nn_1 = mkN "kontorsslav" ;
  kontorsstol_nn_1 = mkN "kontorsstol" ;
  kontorstid_nn_1 = mkN "kontorstid" "kontorstider" ;
  kontorsvana_nn_1 = mkN "kontorsvana" ;
  kontoutdrag_nn_1 = mkN "kontoutdrag" neutrum ;
  kontraalt_nn_1 = mkN "kontraalt" ;
  kontrabas_nn_1 = mkN "kontrabas" ;
  kontrabok_nn_1 = mkN "kontrabok" "kontrabцcker" ;
  kontradans_nn_1 = mkN "kontradans" "kontradanser" ;
  kontradiktion_nn_1 = mkN "kontradiktion" "kontradiktioner" ;
  kontradiktorisk_av_1 = mkA "kontradiktorisk" ;
  kontraer_av_1 = mkA "kontrдr" ;
  kontrahent_nn_1 = mkN "kontrahent" "kontrahenter" ;
  kontraindikation_nn_1 = mkN "kontraindikation" "kontraindikationer" ;
  kontrakt_nn_1 = mkN "kontrakt" neutrum ;
  kontraktil_av_1 = mkA "kontraktil" ;
  kontraktion_nn_1 = mkN "kontraktion" "kontraktioner" ;
  kontraktsbrott_nn_1 = mkN "kontraktsbrott" neutrum ;
  kontraktsenlig_av_1 = mkA "kontraktsenlig" ;
  kontraktsprost_nn_1 = mkN "kontraktsprost" ;
  kontraktstid_nn_1 = mkN "kontraktstid" "kontraktstider" ;
  kontraktsvidrig_av_1 = mkA "kontraktsvidrig" ;
  kontramaerke_nn_1 = mkN "kontramдrke" ;
  kontraorder_nn_1 = mkN "kontraorder" ;
  kontraproposition_nn_1 = mkN "kontraproposition" "kontrapropositioner" ;
  kontrarevolution_nn_1 = mkN "kontrarevolution" "kontrarevolutioner" ;
  kontrast_nn_1 = mkN "kontrast" "kontraster" ;
  kontrastmedel_nn_1 = mkN "kontrastmedel" neutrum ;
  kontribution_nn_1 = mkN "kontribution" "kontributioner" ;
  kontring_nn_1 = mkN "kontring" ;
  kontroll_nn_1 = mkN "kontroll" "kontroller" ;
  kontrollant_nn_1 = mkN "kontrollant" "kontrollanter" ;
  kontrollavgift_nn_1 = mkN "kontrollavgift" "kontrollavgifter" ;
  kontrollbesiktning_nn_1 = mkN "kontrollbesiktning" ;
  kontrollbord_nn_1 = mkN "kontrollbord" neutrum ;
  kontrollgrupp_nn_1 = mkN "kontrollgrupp" "kontrollgrupper" ;
  kontrollinstrument_nn_1 = mkN "kontrollinstrument" neutrum ;
  kontrollmaerke_nn_1 = mkN "kontrollmдrke" ;
  kontrollnummer_nn_1 = mkN "kontrollnummer" neutrum ;
  kontrolloer_nn_1 = mkN "kontrollцr" "kontrollцrer" ;
  kontrollrum_nn_1 = mkN "kontrollrum" "kontrollrummet" "kontrollrum" "kontrollrummen" ;
  kontrollstaempel_nn_1 = mkN "kontrollstдmpel" ;
  kontrolluppgift_nn_1 = mkN "kontrolluppgift" "kontrolluppgifter" ;
  kontrollvaegning_nn_1 = mkN "kontrollvдgning" ;
  kontrovers_nn_1 = mkN "kontrovers" "kontroverser" ;
  kontroversiell_av_1 = mkA "kontroversiell" ;
  kontumaciedom_nn_1 = mkN "kontumaciedom" ;
  kontur_nn_1 = mkN "kontur" "konturer" ;
  konturloes_av_1 = mkA "konturlцs" ;
  konturskarp_av_1 = mkA "konturskarp" ;
  kontusion_nn_1 = mkN "kontusion" "kontusioner" ;
  konung_nn_1 = mkN "konung" ;
  konungaaett_nn_1 = mkN "konungaдtt" "konungaдtter" ;
  konungabok_nn_1 = mkN "konungabok" "konungabцcker" ;
  konungadoeme_nn_1 = mkN "konungadцme" ;
  konungaed_nn_1 = mkN "konungaed" "konungaeder" ;
  konungahus_nn_1 = mkN "konungahus" neutrum ;
  konungalaengd_nn_1 = mkN "konungalдngd" "konungalдngder" ;
  konungarike_nn_1 = mkN "konungarike" ;
  konungasaete_nn_1 = mkN "konungasдte" ;
  konungsk_av_1 = mkA "konungsk" ;
  konungslig_av_1 = mkA "konungslig" ;
  konvalescent_av_1 = mkA "konvalescent" "konvalescent" ;
  konvalescent_nn_1 = mkN "konvalescent" "konvalescenter" ;
  konvalescenthem_nn_1 = mkN "konvalescenthem" "konvalescenthemmet" "konvalescenthem" "konvalescenthemmen" ;
  konvalj_nn_1 = mkN "konvalj" "konvaljer" ;
  konvalje_nn_1 = mkN "konvalje" "konvaljer" ;
  konvenansparti_nn_1 = mkN "konvenansparti" "konvenanspartit" "konvenanspartier" "konvenanspartierna" ;
  konvent_nn_1 = mkN "konvent" neutrum ;
  konventikel_nn_1 = mkN "konventikel" ;
  konvention_nn_1 = mkN "konvention" "konventioner" ;
  konventionell_av_1 = mkA "konventionell" ;
  konvergent_av_1 = mkA "konvergent" "konvergent" ;
  konversabel_av_1 = mkA "konversabel" "konversabelt" "konversabla" "konversabla" "konversablare" "konversablast" "konversablaste" ;
  konversation_nn_1 = mkN "konversation" "konversationer" ;
  konversationslexikon_nn_1 = mkN "konversationslexikon" neutrum ;
  konversion_nn_1 = mkN "konversion" "konversioner" ;
  konversiv_av_1 = mkA "konversiv" ;
  konverter_nn_1 = mkN "konverter" ;
  konvertibel_av_1 = mkA "konvertibel" "konvertibelt" "konvertibla" "konvertibla" "konvertiblare" "konvertiblast" "konvertiblaste" ;
  konvertit_nn_1 = mkN "konvertit" "konvertiter" ;
  konvex_av_1 = mkA "konvex" ;
  konvexkonkav_av_1 = mkA "konvexkonkav" ;
  konviktorium_nn_1 = mkN "konviktorium" "konviktoriet" "konviktorier" "konviktorierna" ;
  konvoj_nn_1 = mkN "konvoj" "konvojer" ;
  konvolut_nn_1 = mkN "konvolut" neutrum ;
  konvulsion_nn_1 = mkN "konvulsion" "konvulsioner" ;
  konvulsivisk_av_1 = mkA "konvulsivisk" ;
  kooega_nn_1 = mkN "koцga" "koцgat" "koцgon" "koцgonen" ;
  kooperativ_av_1 = mkA "kooperativ" ;
  kooperativ_nn_1 = mkN "kooperativ" neutrum ;
  kooperatoer_nn_1 = mkN "kooperatцr" "kooperatцrer" ;
  koordinat_nn_1 = mkN "koordinat" "koordinater" ;
  koordinataxel_nn_1 = mkN "koordinataxel" ;
  koordinator_nn_1 = mkN "koordinator" "koordinatorer" ;
  koordinatsystem_nn_1 = mkN "koordinatsystem" neutrum ;
  kopek_nn_1 = mkN "kopek" "kopeken" "kopek" "kopeken" ;
  kopernikansk_av_1 = mkA "kopernikansk" ;
  kopia_nn_1 = mkN "kopia" ;
  kopiator_nn_1 = mkN "kopiator" "kopiatorer" ;
  kopiepapper_nn_1 = mkN "kopiepapper" neutrum ;
  kopiering_nn_1 = mkN "kopiering" ;
  kopieringsapparat_nn_1 = mkN "kopieringsapparat" "kopieringsapparater" ;
  kopieringsmaskin_nn_1 = mkN "kopieringsmaskin" "kopieringsmaskiner" ;
  kopiesvarv_nn_1 = mkN "kopiesvarv" ;
  kopioes_av_1 = mkA "kopiцs" ;
  kopist_nn_1 = mkN "kopist" "kopister" ;
  kopp_nn_1 = mkN "kopp" ;
  koppaerr_nn_1 = mkN "koppдrr" neutrum ;
  koppaerrig_av_1 = mkA "koppдrrig" ;
  kopparbrun_av_1 = mkA "kopparbrun" ;
  kopparledning_nn_1 = mkN "kopparledning" ;
  kopparmynt_nn_1 = mkN "kopparmynt" neutrum ;
  kopparorm_nn_1 = mkN "kopparorm" ;
  kopparplaat_nn_1 = mkN "kopparplеt" ;
  kopparroed_av_1 = mkA "kopparrцd" ;
  kopparslagare_nn_1 = mkN "kopparslagare" "kopparslagare" ;
  kopparspiral_nn_1 = mkN "kopparspiral" "kopparspiraler" ;
  kopparstick_nn_1 = mkN "kopparstick" neutrum ;
  kopparsulfat_nn_1 = mkN "kopparsulfat" "kopparsulfater" ;
  koppel_nn_1 = mkN "koppel" neutrum ;
  koppelvan_av_1 = mkA "koppelvan" ;
  kopplare_nn_1 = mkN "kopplare" "kopplare" ;
  koppleri_nn_1 = mkN "koppleri" "kopplerit" "kopplerier" "kopplerierna" ;
  koppling_nn_1 = mkN "koppling" ;
  kopplingspedal_nn_1 = mkN "kopplingspedal" "kopplingspedaler" ;
  kopplingsschema_nn_1 = mkN "kopplingsschema" "kopplingsschemat" "kopplingsscheman" "kopplingsschemana" ;
  kopplingston_nn_1 = mkN "kopplingston" "kopplingstoner" ;
  koppympning_nn_1 = mkN "koppympning" ;
  kopter_nn_1 = mkN "kopter" "koptern" "kopter" "kopterna" ;
  koptisk_av_1 = mkA "koptisk" ;
  kopulation_nn_1 = mkN "kopulation" "kopulationer" ;
  kopulativ_av_1 = mkA "kopulativ" ;
  kor_nn_1 = mkN "kor" neutrum ;
  koral_nn_1 = mkN "koral" "koraler" ;
  koralbok_nn_1 = mkN "koralbok" "koralbцcker" ;
  korall_nn_1 = mkN "korall" "koraller" ;
  koralldjur_nn_1 = mkN "koralldjur" neutrum ;
  korallhalsband_nn_1 = mkN "korallhalsband" neutrum ;
  koralloe_nn_1 = mkN "korallц" ;
  korallorm_nn_1 = mkN "korallorm" ;
  korallrev_nn_1 = mkN "korallrev" neutrum ;
  korallroed_av_1 = mkA "korallrцd" ;
  kordial_av_1 = mkA "kordial" ;
  kordong_nn_1 = mkN "kordong" "kordonger" ;
  kordongskruv_nn_1 = mkN "kordongskruv" ;
  korean_nn_1 = mkN "korean" "koreaner" ;
  koreanska_nn_2 = mkN "koreanska" ;
  koreograf_nn_1 = mkN "koreograf" "koreografer" ;
  koreografisk_av_1 = mkA "koreografisk" ;
  korg_nn_1 = mkN "korg" ;
  korgblommig_av_1 = mkA "korgblommig" ;
  korgosse_nn_1 = mkN "korgosse" utrum ;
  korgstol_nn_1 = mkN "korgstol" ;
  korint_nn_1 = mkN "korint" "korinter" ;
  korinter_nn_1 = mkN "korinter" "korintern" "korinter" "korinterna" ;
  korintisk_av_1 = mkA "korintisk" ;
  korist_nn_1 = mkN "korist" "korister" ;
  kork_nn_1 = mkN "kork" ;
  korkcell_nn_1 = mkN "korkcell" "korkceller" ;
  korkek_nn_1 = mkN "korkek" ;
  korkgolv_nn_1 = mkN "korkgolv" neutrum ;
  korklager_nn_1 = mkN "korklager" neutrum ;
  korkpistol_nn_1 = mkN "korkpistol" "korkpistoler" ;
  korkskoerd_nn_1 = mkN "korkskцrd" ;
  korkskruv_nn_1 = mkN "korkskruv" ;
  korkskruvslock_nn_1 = mkN "korkskruvslock" ;
  korksmak_nn_1 = mkN "korksmak" "korksmaker" ;
  korkvaevnad_nn_1 = mkN "korkvдvnad" "korkvдvnader" ;
  kormaestare_nn_1 = mkN "kormдstare" "kormдstare" ;
  kormoran_nn_1 = mkN "kormoran" "kormoraner" ;
  korn_nn_1 = mkN "korn" neutrum ;
  kornaaker_nn_1 = mkN "kornеker" ;
  kornblaa_av_1 = mkA "kornblе" "kornblеtt" ;
  kornblixt_nn_1 = mkN "kornblixt" ;
  kornbod_nn_1 = mkN "kornbod" ;
  kornbroed_nn_1 = mkN "kornbrцd" neutrum ;
  kornett_nn_1 = mkN "kornett" "kornetter" ;
  kornettist_nn_1 = mkN "kornettist" "kornettister" ;
  korngryn_nn_1 = mkN "korngryn" neutrum ;
  korngul_av_1 = mkA "korngul" ;
  kornig_av_1 = mkA "kornig" ;
  kornisch_nn_1 = mkN "kornisch" "kornischer" ;
  kornknarr_nn_1 = mkN "kornknarr" ;
  korollarium_nn_1 = mkN "korollarium" "korollariet" "korollarier" "korollarierna" ;
  korp_nn_1 = mkN "korp" ;
  korporation_nn_1 = mkN "korporation" "korporationer" ;
  korporativ_av_1 = mkA "korporativ" ;
  korpral_nn_1 = mkN "korpral" "korpraler" ;
  korpsvart_av_1 = mkA "korpsvart" "korpsvart" ;
  korpulent_av_1 = mkA "korpulent" "korpulent" ;
  korpus_nn_1 = mkN "korpus" ;
  korpuskel_nn_1 = mkN "korpuskel" "korpuskeln" "korpuskler" "korpusklerna" ;
  korr_nn_1 = mkN "korr" neutrum ;
  korrekt_av_1 = mkA "korrekt" "korrekt" ;
  korrektion_nn_1 = mkN "korrektion" "korrektioner" ;
  korrektionsanstalt_nn_1 = mkN "korrektionsanstalt" "korrektionsanstalter" ;
  korrektiv_nn_1 = mkN "korrektiv" neutrum ;
  korrektur_nn_1 = mkN "korrektur" neutrum ;
  korrekturfel_nn_1 = mkN "korrekturfel" "korrekturfelet" "korrekturfel" "korrekturfelen" ;
  korrekturtecken_nn_1 = mkN "korrekturtecken" "korrekturtecknet" "korrekturtecken" "korrekturtecknen" ;
  korrelat_nn_1 = mkN "korrelat" neutrum ;
  korrelation_nn_1 = mkN "korrelation" "korrelationer" ;
  korrespondens_nn_1 = mkN "korrespondens" "korrespondenser" ;
  korrespondenskort_nn_1 = mkN "korrespondenskort" neutrum ;
  korrespondenskurs_nn_1 = mkN "korrespondenskurs" "korrespondenskurser" ;
  korrespondent_nn_1 = mkN "korrespondent" "korrespondenter" ;
  korridor_nn_1 = mkN "korridor" "korridoren" "korridorer" "korridorerna" ;
  korridorsystem_nn_1 = mkN "korridorsystem" neutrum ;
  korrupt_av_1 = mkA "korrupt" "korrupt" ;
  kors_nn_1 = mkN "kors" neutrum ;
  korsar_nn_1 = mkN "korsar" "korsarer" ;
  korsband_nn_1 = mkN "korsband" neutrum ;
  korsbefruktning_nn_1 = mkN "korsbefruktning" ;
  korsben_nn_1 = mkN "korsben" neutrum ;
  korsblommig_av_1 = mkA "korsblommig" ;
  korselett_nn_1 = mkN "korselett" "korseletter" ;
  korsett_nn_1 = mkN "korsett" "korsetter" ;
  korsettfjaeder_nn_1 = mkN "korsettfjдder" ;
  korsfaestelse_nn_1 = mkN "korsfдstelse" "korsfдstelser" ;
  korsfarare_nn_1 = mkN "korsfarare" "korsfarare" ;
  korsfoerhoer_nn_1 = mkN "korsfцrhцr" neutrum ;
  korsgaang_nn_1 = mkN "korsgеng" ;
  korshaenvisning_nn_1 = mkN "korshдnvisning" ;
  korsikan_nn_1 = mkN "korsikan" "korsikaner" ;
  korsikanare_nn_1 = mkN "korsikanare" "korsikanare" ;
  korskrank_nn_1 = mkN "korskrank" neutrum ;
  korskyrka_nn_1 = mkN "korskyrka" ;
  korsnaebb_nn_1 = mkN "korsnдbb" ;
  korsning_nn_1 = mkN "korsning" ;
  korso_nn_1 = mkN "korso" "korsor" ;
  korsord_nn_1 = mkN "korsord" neutrum ;
  korspollination_nn_1 = mkN "korspollination" "korspollinationer" ;
  korsriddare_nn_1 = mkN "korsriddare" "korsriddare" ;
  korsrygg_nn_1 = mkN "korsrygg" ;
  korsspindel_nn_1 = mkN "korsspindel" ;
  korsstygn_nn_1 = mkN "korsstygn" neutrum ;
  korstaag_nn_1 = mkN "korstеg" neutrum ;
  korstecken_nn_1 = mkN "korstecken" "korstecknet" "korstecken" "korstecknen" ;
  korsvaeg_nn_1 = mkN "korsvдg" ;
  korsvalv_nn_1 = mkN "korsvalv" neutrum ;
  korsvirkeshus_nn_1 = mkN "korsvirkeshus" neutrum ;
  kort_av_1 = mkA "kort" "kort" ;
  kort_nn_1 = mkN "kort" neutrum ;
  kortaenda_nn_1 = mkN "kortдnda" "kortдndan" "kortдndar" "kortдndarna" ;
  kortbent_av_1 = mkA "kortbent" "kortbent" ;
  kortdistans_nn_1 = mkN "kortdistans" "kortdistanser" ;
  kortdistansloepare_nn_1 = mkN "kortdistanslцpare" "kortdistanslцpare" ;
  kortege_nn_1 = mkN "kortege" "korteger" ;
  korteligen_ab_1 = mkAdv "korteligen" ;
  kortfilm_nn_1 = mkN "kortfilm" "kortfilmer" ;
  kortform_nn_1 = mkN "kortform" "kortformer" ;
  kortfristig_av_1 = mkA "kortfristig" ;
  korthet_nn_1 = mkN "korthet" "kortheter" ;
  korthuggen_av_1 = mkA "korthuggen" "korthugget" ;
  korthus_nn_1 = mkN "korthus" neutrum ;
  kortison_nn_1 = mkN "kortison" "kortisoner" ;
  kortkatalog_nn_1 = mkN "kortkatalog" "kortkataloger" ;
  kortklippt_av_1 = mkA "kortklippt" "kortklippt" ;
  kortkonst_nn_1 = mkN "kortkonst" "kortkonster" ;
  kortkort_av_1 = mkA "kortkort" "kortkort" ;
  kortlek_nn_1 = mkN "kortlek" ;
  kortoxe_nn_1 = mkN "kortoxe" utrum ;
  kortpipig_av_1 = mkA "kortpipig" ;
  kortregister_nn_1 = mkN "kortregister" neutrum ;
  kortroman_nn_1 = mkN "kortroman" "kortromaner" ;
  kortsida_nn_1 = mkN "kortsida" ;
  kortsiktig_av_1 = mkA "kortsiktig" ;
  kortskallig_av_1 = mkA "kortskallig" ;
  kortsluta_vb_1 = mkV "kortsluta" "kortslцt" "kortslutit" ;
  kortslutning_nn_1 = mkN "kortslutning" ;
  kortspel_nn_1 = mkN "kortspel" "kortspelet" "kortspel" "kortspelen" ;
  kortspelare_nn_1 = mkN "kortspelare" "kortspelare" ;
  kortsynt_av_1 = mkA "kortsynt" "kortsynt" ;
  korttaenkt_av_1 = mkA "korttдnkt" "korttдnkt" ;
  kortvaagsbehandling_nn_1 = mkN "kortvеgsbehandling" ;
  kortvaagsradio_nn_1 = mkN "kortvеgsradio" "kortvеgsradior" ;
  kortvaegg_nn_1 = mkN "kortvдgg" ;
  kortvaext_av_1 = mkA "kortvдxt" "kortvдxt" ;
  kortvara_nn_1 = mkN "kortvara" ;
  kortvarig_av_1 = mkA "kortvarig" ;
  kortvuxen_av_1 = mkA "kortvuxen" "kortvuxet" ;
  korum_nn_1 = mkN "korum" neutrum ;
  korund_nn_1 = mkN "korund" "korunder" ;
  korus_nn_1 = mkN "korus" neutrum ;
  korv_nn_1 = mkN "korv" ;
  korvett_nn_1 = mkN "korvett" "korvetter" ;
  korvgubbe_nn_1 = mkN "korvgubbe" utrum ;
  korvig_av_1 = mkA "korvig" ;
  korvkiosk_nn_1 = mkN "korvkiosk" "korvkiosker" ;
  korvoere_nn_1 = mkN "korvцre" ;
  korvsjoe_nn_1 = mkN "korvsjц" ;
  korvskinn_nn_1 = mkN "korvskinn" neutrum ;
  korvstaand_nn_1 = mkN "korvstеnd" neutrum ;
  koryfe_nn_1 = mkN "koryfй" "koryfйer" ;
  kosack_nn_1 = mkN "kosack" "kosacker" ;
  kosackdans_nn_1 = mkN "kosackdans" "kosackdanser" ;
  koscher_av_1 = mkA "koscher" ;
  kosmetisk_av_1 = mkA "kosmetisk" ;
  kosmetolog_nn_1 = mkN "kosmetolog" "kosmetologer" ;
  kosmisk_av_1 = mkA "kosmisk" ;
  kosmodrom_nn_1 = mkN "kosmodrom" "kosmodromer" ;
  kosmogoni_nn_1 = mkN "kosmogoni" "kosmogonier" ;
  kosmolog_nn_1 = mkN "kosmolog" "kosmologer" ;
  kosmologi_nn_1 = mkN "kosmologi" "kosmologier" ;
  kosmologisk_av_1 = mkA "kosmologisk" ;
  kosmonaut_nn_1 = mkN "kosmonaut" "kosmonauter" ;
  kosmopolit_nn_1 = mkN "kosmopolit" "kosmopoliter" ;
  kosmopolitisk_av_1 = mkA "kosmopolitisk" ;
  kosmos_nn_1 = mkN "kosmos" neutrum ;
  kostbar_av_1 = mkA "kostbar" ;
  koster_nn_1 = mkN "koster" ;
  kostig_nn_1 = mkN "kostig" ;
  kostlig_av_1 = mkA "kostlig" ;
  kostnad_nn_1 = mkN "kostnad" "kostnader" ;
  kostnadsersaettning_nn_1 = mkN "kostnadsersдttning" ;
  kostnadsfri_av_1 = mkA "kostnadsfri" "kostnadsfritt" ;
  kostnadsram_nn_1 = mkN "kostnadsram" ;
  kostsam_av_1 = mkA "kostsam" "kostsamt" "kostsamma" "kostsamma" "kostsammare" "kostsammast" "kostsammaste" ;
  kostvana_nn_1 = mkN "kostvana" ;
  kostym_nn_1 = mkN "kostym" "kostymer" ;
  kostymbal_nn_1 = mkN "kostymbal" "kostymbaler" ;
  kostymering_nn_1 = mkN "kostymering" ;
  kostympjaes_nn_1 = mkN "kostympjдs" "kostympjдser" ;
  kotben_nn_1 = mkN "kotben" neutrum ;
  kotiljong_nn_1 = mkN "kotiljong" "kotiljonger" ;
  kotknackare_nn_1 = mkN "kotknackare" "kotknackare" ;
  kotled_nn_1 = mkN "kotled" "kotleder" ;
  kotlett_nn_1 = mkN "kotlett" "kotletter" ;
  kotlettfisk_nn_1 = mkN "kotlettfisk" ;
  kotlettrad_nn_1 = mkN "kotlettrad" "kotlettrader" ;
  kotpelare_nn_1 = mkN "kotpelare" "kotpelare" ;
  kotte_nn_1 = mkN "kotte" utrum ;
  kotteri_nn_1 = mkN "kotteri" "kotterit" "kotterier" "kotterierna" ;
  koturn_nn_1 = mkN "koturn" "koturner" ;
  kovaendning_nn_1 = mkN "kovдndning" ;
  kovalent_av_1 = mkA "kovalent" "kovalent" ;
  kovall_nn_1 = mkN "kovall" "kovaller" ;
  kovert_av_1 = mkA "kovert" "kovert" ;
  koyot_nn_1 = mkN "koyot" "koyoter" ;
  kpist_nn_1 = mkN "kpist" ;
  kraakbaer_nn_1 = mkN "krеkbдr" neutrum ;
  kraakfaagel_nn_1 = mkN "krеkfеgel" ;
  kraakliknande_av_1 = mkA "krеkliknande" ;
  kraakslott_nn_1 = mkN "krеkslott" neutrum ;
  kraal_nn_1 = mkN "kraal" "kraaler" ;
  kraangelmakare_nn_1 = mkN "krеngelmakare" "krеngelmakare" ;
  kraanglig_av_1 = mkA "krеnglig" ;
  kraas_nn_2 = mkN "krеs" neutrum ;
  kraasnaal_nn_1 = mkN "krеsnеl" ;
  krabat_nn_1 = mkN "krabat" "krabater" ;
  kraeftbur_nn_1 = mkN "krдftbur" ;
  kraeftdjur_nn_1 = mkN "krдftdjur" neutrum ;
  kraeftsvulst_nn_1 = mkN "krдftsvulst" "krдftsvulster" ;
  kraek_nn_1 = mkN "krдk" neutrum ;
  kraekfaerdig_av_1 = mkA "krдkfдrdig" ;
  kraekmedel_nn_1 = mkN "krдkmedel" neutrum ;
  kraekning_nn_1 = mkN "krдkning" ;
  kraeldjur_nn_1 = mkN "krдldjur" neutrum ;
  kraeldjurstyp_nn_1 = mkN "krдldjurstyp" "krдldjurstyper" ;
  kraem_nn_1 = mkN "krдm" "krдmer" ;
  kraemare_nn_1 = mkN "krдmare" "krдmare" ;
  kraemig_av_1 = mkA "krдmig" ;
  kraengning_nn_1 = mkN "krдngning" ;
  kraengningshaemmare_nn_1 = mkN "krдngningshдmmare" "krдngningshдmmare" ;
  kraengningsprov_nn_1 = mkN "krдngningsprov" neutrum ;
  kraenkande_av_1 = mkA "krдnkande" ;
  kraenkning_nn_1 = mkN "krдnkning" ;
  kraesen_av_1 = mkA "krдsen" "krдset" ;
  kraeslig_av_1 = mkA "krдslig" ;
  kraesligen_ab_1 = mkAdv "krдsligen" ;
  kraevande_av_1 = mkA "krдvande" ;
  krafsig_av_1 = mkA "krafsig" ;
  kraft_nn_1 = mkN "kraft" "krafter" ;
  kraftaatgaerd_nn_1 = mkN "kraftеtgдrd" "kraftеtgдrder" ;
  kraftaggregat_nn_1 = mkN "kraftaggregat" neutrum ;
  kraftanstraengning_nn_1 = mkN "kraftanstrдngning" ;
  kraftbaerare_nn_1 = mkN "kraftbдrare" "kraftbдrare" ;
  kraftbehov_nn_1 = mkN "kraftbehov" neutrum ;
  kraftbolag_nn_1 = mkN "kraftbolag" neutrum ;
  kraftcentral_nn_1 = mkN "kraftcentral" "kraftcentraler" ;
  kraftcentrum_nn_1 = mkN "kraftcentrum" neutrum ;
  kraftekvation_nn_1 = mkN "kraftekvation" "kraftekvationer" ;
  kraftfaelt_nn_1 = mkN "kraftfдlt" neutrum ;
  kraftfoder_nn_1 = mkN "kraftfoder" neutrum ;
  kraftfoeretag_nn_1 = mkN "kraftfцretag" neutrum ;
  kraftfull_av_1 = mkA "kraftfull" ;
  kraftig_av_1 = mkA "kraftig" ;
  kraftkarl_nn_1 = mkN "kraftkarl" ;
  kraftkraevande_av_1 = mkA "kraftkrдvande" ;
  kraftledning_nn_1 = mkN "kraftledning" ;
  kraftlinje_nn_1 = mkN "kraftlinje" "kraftlinjer" ;
  kraftloes_av_1 = mkA "kraftlцs" ;
  kraftloeshet_nn_1 = mkN "kraftlцshet" "kraftlцsheter" ;
  kraftmaetning_nn_1 = mkN "kraftmдtning" ;
  kraftnaet_nn_1 = mkN "kraftnдt" neutrum ;
  kraftoeverfoering_nn_1 = mkN "kraftцverfцring" ;
  kraftord_nn_1 = mkN "kraftord" neutrum ;
  kraftpaket_nn_1 = mkN "kraftpaket" neutrum ;
  kraftparallellogram_nn_1 = mkN "kraftparallellogram" "kraftparallellogrammen" "kraftparallellogrammer" "kraftparallellogrammerna" ;
  kraftpartikel_nn_1 = mkN "kraftpartikel" ;
  kraftprov_nn_1 = mkN "kraftprov" neutrum ;
  kraftsport_nn_1 = mkN "kraftsport" "kraftsporter" ;
  kraftstation_nn_1 = mkN "kraftstation" "kraftstationer" ;
  krafttag_nn_1 = mkN "krafttag" neutrum ;
  kraftuttryck_nn_1 = mkN "kraftuttryck" neutrum ;
  kraftvaermeverk_nn_1 = mkN "kraftvдrmeverk" neutrum ;
  kraftverk_nn_1 = mkN "kraftverk" neutrum ;
  kraftverksbygge_nn_1 = mkN "kraftverksbygge" ;
  kraftvunnen_av_1 = mkA "kraftvunnen" "kraftvunnet" "kraftvunna" "kraftvunna" "kraftvunnare" "kraftvunnast" "kraftvunnaste" ;
  krage_nn_1 = mkN "krage" utrum ;
  kraghandske_nn_1 = mkN "kraghandske" utrum ;
  kragknapp_nn_1 = mkN "kragknapp" ;
  kragloes_av_1 = mkA "kraglцs" ;
  kragsnibb_nn_1 = mkN "kragsnibb" ;
  kragsten_nn_1 = mkN "kragsten" "kragstenen" "kragstenar" "kragstenarna" ;
  kragstoevel_nn_1 = mkN "kragstцvel" ;
  krake_nn_1 = mkN "krake" utrum ;
  krakel_nn_1 = mkN "krakel" "krakelet" "krakel" "krakelen" ;
  krakmandel_nn_1 = mkN "krakmandel" ;
  kral_nn_1 = mkN "kral" "kraler" ;
  kram_av_1 = mkA "kram" ;
  kram_nn_1 = mkN "kram" ;
  kramp_nn_1 = mkN "kramp" "kramper" ;
  krampaktig_av_1 = mkA "krampaktig" ;
  kramploesande_av_1 = mkA "kramplцsande" ;
  krampstillande_av_1 = mkA "krampstillande" ;
  kramsfaagel_nn_1 = mkN "kramsfеgel" ;
  kran_nn_1 = mkN "kran" ;
  kranbalk_nn_1 = mkN "kranbalk" ;
  kranbalksvis_ab_1 = mkAdv "kranbalksvis" ;
  kranium_nn_1 = mkN "kranium" "kraniet" "kranier" "kranierna" ;
  krank_av_1 = mkA "krank" ;
  krankik_nn_1 = mkN "krankik" ;
  krans_nn_1 = mkN "krans" ;
  kransartaer_nn_1 = mkN "kransartдr" "kransartдrer" ;
  kransband_nn_1 = mkN "kransband" neutrum ;
  kranskaerl_nn_1 = mkN "kranskдrl" neutrum ;
  kransnedlaeggning_nn_1 = mkN "kransnedlдggning" ;
  kranvatten_nn_1 = mkN "kranvatten" "kranvattnet" "kranvatten" "kranvattnen" ;
  krasch_nn_2 = mkN "krasch" "krascher" ;
  kraschan_nn_1 = mkN "kraschan" "kraschaner" ;
  krass_av_1 = mkA "krass" ;
  krasslig_av_1 = mkA "krasslig" ;
  krater_nn_1 = mkN "krater" ;
  kraterberg_nn_1 = mkN "kraterberg" neutrum ;
  kratersjoe_nn_1 = mkN "kratersjц" ;
  krats_nn_1 = mkN "krats" ;
  krav_nn_1 = mkN "krav" neutrum ;
  kravall_nn_1 = mkN "kravall" "kravaller" ;
  kravallstaket_nn_1 = mkN "kravallstaket" neutrum ;
  kravatt_nn_1 = mkN "kravatt" "kravatter" ;
  kravattnaal_nn_1 = mkN "kravattnеl" ;
  kravbrev_nn_1 = mkN "kravbrev" neutrum ;
  kravell_nn_1 = mkN "kravell" "kraveller" ;
  kravloes_av_1 = mkA "kravlцs" ;
  krax_nn_1 = mkN "krax" neutrum ;
  kreation_nn_1 = mkN "kreation" "kreationer" ;
  kreativ_av_1 = mkA "kreativ" ;
  kreativitet_nn_1 = mkN "kreativitet" "kreativiteter" ;
  kreatur_nn_1 = mkN "kreatur" neutrum ;
  kreatursbesaettning_nn_1 = mkN "kreatursbesдttning" ;
  kreatursloes_av_1 = mkA "kreaturslцs" ;
  kredit_nn_1 = mkN "kredit" "krediter" ;
  kreditinstitut_nn_1 = mkN "kreditinstitut" neutrum ;
  kreditiv_nn_1 = mkN "kreditiv" neutrum ;
  kreditkort_nn_1 = mkN "kreditkort" neutrum ;
  kreditmarknad_nn_1 = mkN "kreditmarknad" "kreditmarknader" ;
  kreditor_nn_1 = mkN "kreditor" "kreditorer" ;
  kreditupplysning_nn_1 = mkN "kreditupplysning" ;
  krematorium_nn_1 = mkN "krematorium" "krematoriet" "krematorier" "krematorierna" ;
  kremering_nn_1 = mkN "kremering" ;
  kremlolog_nn_1 = mkN "kremlolog" "kremlologer" ;
  krenelering_nn_1 = mkN "krenelering" ;
  kreol_nn_1 = mkN "kreol" "kreoler" ;
  kreolspraak_nn_1 = mkN "kreolsprеk" neutrum ;
  kreosotolja_nn_1 = mkN "kreosotolja" ;
  krestomati_nn_1 = mkN "krestomati" "krestomatier" ;
  kretensare_nn_1 = mkN "kretensare" "kretensare" ;
  kretensisk_av_1 = mkA "kretensisk" ;
  kreter_nn_1 = mkN "kreter" "kretern" "kreter" "kreterna" ;
  kretin_nn_1 = mkN "kretin" "kretiner" ;
  kretisk_av_1 = mkA "kretisk" ;
  kretong_nn_1 = mkN "kretong" "kretonger" ;
  krets_nn_1 = mkN "krets" ;
  kretsgaang_nn_1 = mkN "kretsgеng" ;
  kretskort_nn_1 = mkN "kretskort" neutrum ;
  kretslopp_nn_1 = mkN "kretslopp" neutrum ;
  krevad_nn_1 = mkN "krevad" "krevader" ;
  krig_nn_1 = mkN "krig" neutrum ;
  krigare_nn_1 = mkN "krigare" "krigare" ;
  krigargrav_nn_1 = mkN "krigargrav" ;
  krigfoerande_av_1 = mkA "krigfцrande" ;
  krigfoering_nn_1 = mkN "krigfцring" ;
  krigisk_av_1 = mkA "krigisk" ;
  krigsaar_nn_1 = mkN "krigsеr" neutrum ;
  krigsbarn_nn_1 = mkN "krigsbarn" neutrum ;
  krigsberedskap_nn_1 = mkN "krigsberedskap" "krigsberedskaper" ;
  krigsbuss_nn_1 = mkN "krigsbuss" ;
  krigsbyte_nn_1 = mkN "krigsbyte" ;
  krigsdans_nn_1 = mkN "krigsdans" "krigsdanser" ;
  krigsdekoration_nn_1 = mkN "krigsdekoration" "krigsdekorationer" ;
  krigsfaange_nn_1 = mkN "krigsfеnge" utrum ;
  krigsfartyg_nn_1 = mkN "krigsfartyg" neutrum ;
  krigsfoerbrytare_nn_1 = mkN "krigsfцrbrytare" "krigsfцrbrytare" ;
  krigsfoerbrytelse_nn_1 = mkN "krigsfцrbrytelse" "krigsfцrbrytelser" ;
  krigsfoerklaring_nn_1 = mkN "krigsfцrklaring" ;
  krigsgud_nn_1 = mkN "krigsgud" ;
  krigsherre_nn_1 = mkN "krigsherre" utrum ;
  krigshierarki_nn_1 = mkN "krigshierarki" "krigshierarkier" ;
  krigskorrespondent_nn_1 = mkN "krigskorrespondent" "krigskorrespondenter" ;
  krigsmaalning_nn_1 = mkN "krigsmеlning" ;
  krigsmakt_nn_1 = mkN "krigsmakt" "krigsmakter" ;
  krigsman_nn_1 = mkN "krigsman" "krigsmannen" "krigsmдn" "krigsmдnnen" ;
  krigsmiljoe_nn_1 = mkN "krigsmiljц" "krigsmiljцn" "krigsmiljцer" "krigsmiljцerna" ;
  krigsplacering_nn_1 = mkN "krigsplacering" ;
  krigsraad_nn_1 = mkN "krigsrеd" neutrum ;
  krigsraedd_av_1 = mkA "krigsrдdd" ;
  krigsroman_nn_1 = mkN "krigsroman" "krigsromaner" ;
  krigsskaadeplats_nn_1 = mkN "krigsskеdeplats" "krigsskеdeplatser" ;
  krigsskadestaand_nn_1 = mkN "krigsskadestеnd" neutrum ;
  krigsskepp_nn_1 = mkN "krigsskepp" neutrum ;
  krigsslut_nn_1 = mkN "krigsslut" neutrum ;
  krigsspel_nn_1 = mkN "krigsspel" "krigsspelet" "krigsspel" "krigsspelen" ;
  krigstaag_nn_1 = mkN "krigstеg" neutrum ;
  krigstillstaand_nn_1 = mkN "krigstillstеnd" neutrum ;
  krigstjaenstgoering_nn_1 = mkN "krigstjдnstgцring" ;
  krigsutbrott_nn_1 = mkN "krigsutbrott" neutrum ;
  krikon_nn_1 = mkN "krikon" neutrum ;
  krillaetare_nn_1 = mkN "krillдtare" "krillдtare" ;
  krillstim_nn_1 = mkN "krillstim" "krillstimmet" "krillstim" "krillstimmen" ;
  kriminalare_nn_1 = mkN "kriminalare" "kriminalare" ;
  kriminaldaare_nn_1 = mkN "kriminaldеre" utrum ;
  kriminalitet_nn_1 = mkN "kriminalitet" "kriminaliteter" ;
  kriminalpolis_nn_1 = mkN "kriminalpolis" "kriminalpoliser" ;
  kriminalregister_nn_1 = mkN "kriminalregister" neutrum ;
  kriminalroman_nn_1 = mkN "kriminalroman" "kriminalromaner" ;
  kriminell_av_1 = mkA "kriminell" ;
  kriminologisk_av_1 = mkA "kriminologisk" ;
  kring_ab_1 = mkAdv "kring" ;
  kringboende_av_1 = mkA "kringboende" ;
  kringbyggd_av_1 = mkA "kringbyggd" "kringbyggt" ;
  kringfarande_av_1 = mkA "kringfarande" ;
  kringflackande_av_1 = mkA "kringflackande" ;
  kringgaa_vb_1 = mkV "kringgе" "kringgеr" "kringgе" "kringgick" "kringgеtt" "kringgеngen" ;
  kringla_nn_1 = mkN "kringla" ;
  kringliggande_av_1 = mkA "kringliggande" ;
  kringresande_av_1 = mkA "kringresande" ;
  kringsjuk_av_1 = mkA "kringsjuk" ;
  kringskaera_vb_1 = mkV "kringskдra" "kringskar" "kringskurit" ;
  kringspringande_av_1 = mkA "kringspringande" ;
  kringstaaende_av_1 = mkA "kringstеende" ;
  kringsynt_av_1 = mkA "kringsynt" "kringsynt" ;
  kringutrustning_nn_1 = mkN "kringutrustning" ;
  kringvaervd_av_1 = mkA "kringvдrvd" "kringvдrvt" ;
  kringvandrande_av_1 = mkA "kringvandrande" ;
  krinolin_nn_1 = mkN "krinolin" "krinoliner" ;
  kris_nn_1 = mkN "kris" "kriser" ;
  kris_nn_2 = mkN "kris" ;
  krismedel_nn_1 = mkN "krismedel" neutrum ;
  krispaket_nn_1 = mkN "krispaket" neutrum ;
  kristall_nn_1 = mkN "kristall" "kristaller" ;
  kristallaxel_nn_1 = mkN "kristallaxel" ;
  kristallform_nn_1 = mkN "kristallform" "kristallformer" ;
  kristallglas_nn_1 = mkN "kristallglas" neutrum ;
  kristallin_av_1 = mkA "kristallin" ;
  kristallinisk_av_1 = mkA "kristallinisk" ;
  kristallins_nn_1 = mkN "kristallins" "kristallinser" ;
  kristallisation_nn_1 = mkN "kristallisation" "kristallisationer" ;
  kristallisk_av_1 = mkA "kristallisk" ;
  kristallklar_av_1 = mkA "kristallklar" ;
  kristallmoenster_nn_1 = mkN "kristallmцnster" neutrum ;
  kristallmottagare_nn_1 = mkN "kristallmottagare" "kristallmottagare" ;
  kristallografisk_av_1 = mkA "kristallografisk" ;
  kristallsystem_nn_1 = mkN "kristallsystem" neutrum ;
  kristen_av_1 = mkA "kristen" "kristet" ;
  kristendom_nn_1 = mkN "kristendom" ;
  kristenhet_nn_1 = mkN "kristenhet" "kristenheter" ;
  kristid_nn_1 = mkN "kristid" "kristider" ;
  kristidsfoeretag_nn_1 = mkN "kristidsfцretag" neutrum ;
  kristlig_av_1 = mkA "kristlig" ;
  kristtorn_nn_1 = mkN "kristtorn" ;
  kristtrogen_av_1 = mkA "kristtrogen" "kristtroget" ;
  kristusmonogram_nn_1 = mkN "kristusmonogram" "kristusmonogrammet" "kristusmonogram" "kristusmonogrammen" ;
  kriterium_nn_1 = mkN "kriterium" "kriteriet" "kriterier" "kriterierna" ;
  kritig_av_1 = mkA "kritig" ;
  kritik_nn_1 = mkN "kritik" "kritiker" ;
  kritiker_nn_1 = mkN "kritiker" "kritikern" "kritiker" "kritikerna" ;
  kritikloes_av_1 = mkA "kritiklцs" ;
  kritikstorm_nn_1 = mkN "kritikstorm" ;
  kritisk_av_1 = mkA "kritisk" ;
  kritstreck_nn_1 = mkN "kritstreck" neutrum ;
  kritstrecksrandig_av_1 = mkA "kritstrecksrandig" ;
  kritter_nn_1 = mkN "kritter" neutrum ;
  kritvit_av_1 = mkA "kritvit" ;
  kroat_nn_1 = mkN "kroat" "kroater" ;
  kroatiska_nn_2 = mkN "kroatiska" ;
  krock_nn_1 = mkN "krock" ;
  kroegare_nn_1 = mkN "krцgare" "krцgare" ;
  kroek_nn_1 = mkN "krцk" ;
  kroekning_nn_1 = mkN "krцkning" ;
  kroekt_av_1 = mkA "krцkt" "krцkt" ;
  kroen_nn_1 = mkN "krцn" neutrum ;
  kroenika_nn_1 = mkN "krцnika" ;
  kroenikebok_nn_1 = mkN "krцnikebok" "krцnikebцcker" ;
  kroenikespel_nn_1 = mkN "krцnikespel" "krцnikespelet" "krцnikespel" "krцnikespelen" ;
  kroenikoer_nn_1 = mkN "krцnikцr" "krцnikцrer" ;
  kroening_nn_1 = mkN "krцning" ;
  kroeson_nn_1 = mkN "krцson" neutrum ;
  kroesus_nn_1 = mkN "krцsus" ;
  krog_nn_1 = mkN "krog" ;
  krogkund_nn_1 = mkN "krogkund" "krogkunder" ;
  krogrond_nn_1 = mkN "krogrond" "krogronder" ;
  krogshow_nn_1 = mkN "krogshow" "krogshower" ;
  krogsvaeng_nn_1 = mkN "krogsvдng" ;
  krok_nn_1 = mkN "krok" ;
  krokan_nn_1 = mkN "krokan" "krokaner" ;
  krokben_ab_1 = mkAdv "krokben" ;
  krokett_nn_1 = mkN "krokett" "kroketter" ;
  kroki_nn_1 = mkN "kroki" "krokier" ;
  krokig_av_1 = mkA "krokig" ;
  krokighet_nn_1 = mkN "krokighet" "krokigheter" ;
  kroknaest_av_1 = mkA "kroknдst" "kroknдst" ;
  krokodil_nn_1 = mkN "krokodil" "krokodiler" ;
  krokryggig_av_1 = mkA "krokryggig" ;
  kroksabel_nn_1 = mkN "kroksabel" ;
  krokus_nn_1 = mkN "krokus" ;
  krokvaeg_nn_1 = mkN "krokvдg" ;
  krokvuxen_av_1 = mkA "krokvuxen" "krokvuxet" ;
  kromat_nn_1 = mkN "kromat" neutrum ;
  kromatisk_av_1 = mkA "kromatisk" ;
  kromolitografi_nn_1 = mkN "kromolitografi" "kromolitografier" ;
  kromosom_nn_1 = mkN "kromosom" "kromosomer" ;
  kromosompar_nn_1 = mkN "kromosompar" neutrum ;
  kromosomuppsaettning_nn_1 = mkN "kromosomuppsдttning" ;
  kronblad_nn_1 = mkN "kronblad" neutrum ;
  kronbrud_nn_1 = mkN "kronbrud" ;
  krondike_nn_1 = mkN "krondike" ;
  kronhaest_nn_1 = mkN "kronhдst" ;
  kronhjort_nn_1 = mkN "kronhjort" ;
  kroniker_nn_1 = mkN "kroniker" "kronikern" "kroniker" "kronikerna" ;
  kronikerhem_nn_1 = mkN "kronikerhem" "kronikerhemmet" "kronikerhem" "kronikerhemmen" ;
  kronisk_av_1 = mkA "kronisk" ;
  kronjurist_nn_1 = mkN "kronjurist" "kronjurister" ;
  kronjuvel_nn_1 = mkN "kronjuvel" "kronjuveler" ;
  kronkoloni_nn_1 = mkN "kronkoloni" "kronkolonier" ;
  kronmutter_nn_1 = mkN "kronmutter" ;
  kronofogde_nn_1 = mkN "kronofogde" utrum ;
  kronojaegare_nn_1 = mkN "kronojдgare" "kronojдgare" ;
  kronojord_nn_1 = mkN "kronojord" ;
  kronologi_nn_1 = mkN "kronologi" "kronologier" ;
  kronologisk_av_1 = mkA "kronologisk" ;
  kronometer_nn_1 = mkN "kronometer" ;
  kronopark_nn_1 = mkN "kronopark" "kronoparker" ;
  kronoutskyld_nn_1 = mkN "kronoutskyld" "kronoutskylder" ;
  kronprins_nn_1 = mkN "kronprins" ;
  krontal_nn_1 = mkN "krontal" "krontalet" "krontalen" "krontalena" ;
  kronvittne_nn_1 = mkN "kronvittne" ;
  kronvrak_nn_1 = mkN "kronvrak" neutrum ;
  kropp_nn_1 = mkN "kropp" ;
  kroppaas_nn_1 = mkN "kroppеs" ;
  kroppsarbetare_nn_1 = mkN "kroppsarbetare" "kroppsarbetare" ;
  kroppsbild_nn_1 = mkN "kroppsbild" "kroppsbilder" ;
  kroppsbyggare_nn_1 = mkN "kroppsbyggare" "kroppsbyggare" ;
  kroppsbyggnad_nn_1 = mkN "kroppsbyggnad" "kroppsbyggnader" ;
  kroppscell_nn_1 = mkN "kroppscell" "kroppsceller" ;
  kroppsdel_nn_1 = mkN "kroppsdel" "kroppsdelen" "kroppsdelar" "kroppsdelarna" ;
  kroppsfett_nn_1 = mkN "kroppsfett" "kroppsfettet" "kroppsfetter" "kroppsfetterna" ;
  kroppsform_nn_1 = mkN "kroppsform" "kroppsformer" ;
  kroppsfunktion_nn_1 = mkN "kroppsfunktion" "kroppsfunktioner" ;
  kroppskanal_nn_1 = mkN "kroppskanal" "kroppskanaler" ;
  kroppslig_av_1 = mkA "kroppslig" ;
  kroppsligen_ab_1 = mkAdv "kroppsligen" ;
  kroppsnaera_av_1 = mkA "kroppsnдra" ;
  kroppsoeppning_nn_1 = mkN "kroppsцppning" ;
  kroppsoevning_nn_1 = mkN "kroppsцvning" ;
  kroppsorgan_nn_1 = mkN "kroppsorgan" neutrum ;
  kroppsroerelse_nn_1 = mkN "kroppsrцrelse" "kroppsrцrelser" ;
  kroppsstaellning_nn_1 = mkN "kroppsstдllning" ;
  kroppsstyrka_nn_1 = mkN "kroppsstyrka" ;
  kroppstemperatur_nn_1 = mkN "kroppstemperatur" "kroppstemperaturer" ;
  kroppsvaetska_nn_1 = mkN "kroppsvдtska" ;
  kroppsvaevnad_nn_1 = mkN "kroppsvдvnad" "kroppsvдvnader" ;
  kroppsvikt_nn_1 = mkN "kroppsvikt" "kroppsvikter" ;
  kroppsvisitation_nn_1 = mkN "kroppsvisitation" "kroppsvisitationer" ;
  kross_nn_1 = mkN "kross" ;
  krossaar_nn_1 = mkN "krossеr" neutrum ;
  krossfri_av_1 = mkA "krossfri" "krossfritt" ;
  krossmaskin_nn_1 = mkN "krossmaskin" "krossmaskiner" ;
  krubbitare_nn_1 = mkN "krubbitare" "krubbitare" ;
  krucifix_nn_1 = mkN "krucifix" neutrum ;
  krukgods_nn_1 = mkN "krukgods" neutrum ;
  krukmakare_nn_1 = mkN "krukmakare" "krukmakare" ;
  krukmakeri_nn_1 = mkN "krukmakeri" "krukmakerit" "krukmakerier" "krukmakerierna" ;
  krukvaext_nn_1 = mkN "krukvдxt" "krukvдxter" ;
  krullhaarig_av_1 = mkA "krullhеrig" ;
  krullig_av_1 = mkA "krullig" ;
  krum_av_1 = mkA "krum" "krumt" "krumma" "krumma" "krummare" "krummast" "krummaste" ;
  krumbukt_nn_1 = mkN "krumbukt" "krumbukter" ;
  krumelur_nn_1 = mkN "krumelur" "krumelurer" ;
  krumhorn_nn_1 = mkN "krumhorn" neutrum ;
  krumpen_av_1 = mkA "krumpen" "krumpet" ;
  krumspraang_nn_1 = mkN "krumsprеng" neutrum ;
  krumstav_nn_1 = mkN "krumstav" ;
  krus_nn_1 = mkN "krus" neutrum ;
  krusbaer_nn_1 = mkN "krusbдr" neutrum ;
  krusbaersbuske_nn_1 = mkN "krusbдrsbuske" utrum ;
  kruserlig_av_1 = mkA "kruserlig" ;
  krushaarig_av_1 = mkA "krushеrig" ;
  krusidull_nn_1 = mkN "krusidull" "krusiduller" ;
  krusidullig_av_1 = mkA "krusidullig" ;
  krusig_av_1 = mkA "krusig" ;
  krustaang_nn_1 = mkN "krustеng" "krustдnger" ;
  krustaatel_nn_1 = mkN "krustеtel" ;
  krustad_nn_1 = mkN "krustad" "krustader" ;
  krutdurk_nn_1 = mkN "krutdurk" ;
  krutgas_nn_1 = mkN "krutgas" "krutgaser" ;
  krutgubbe_nn_1 = mkN "krutgubbe" utrum ;
  kruthorn_nn_1 = mkN "kruthorn" neutrum ;
  krutkorn_nn_1 = mkN "krutkorn" neutrum ;
  krutmotor_nn_1 = mkN "krutmotor" "krutmotorer" ;
  krutong_nn_1 = mkN "krutong" "krutonger" ;
  krutsort_nn_1 = mkN "krutsort" "krutsorter" ;
  kruttorr_av_1 = mkA "kruttorr" ;
  krux_nn_1 = mkN "krux" neutrum ;
  kry_av_1 = mkA "kry" "krytt" ;
  kryckig_av_1 = mkA "kryckig" ;
  kryddbod_nn_1 = mkN "kryddbod" ;
  kryddgroensak_nn_1 = mkN "kryddgrцnsak" "kryddgrцnsaker" ;
  kryddoert_nn_1 = mkN "kryddцrt" "kryddцrter" ;
  kryddsaas_nn_1 = mkN "kryddsеs" "kryddsеser" ;
  kryddstark_av_1 = mkA "kryddstark" ;
  kryddvaext_nn_1 = mkN "kryddvдxt" "kryddvдxter" ;
  krympfilm_nn_1 = mkN "krympfilm" "krympfilmer" ;
  krympfri_av_1 = mkA "krympfri" "krympfritt" ;
  krympling_nn_1 = mkN "krympling" ;
  krympmaan_nn_1 = mkN "krympmеn" "krympmеner" ;
  kryogen_av_1 = mkA "kryogen" ;
  kryostat_nn_1 = mkN "kryostat" "kryostater" ;
  kryoteknik_nn_1 = mkN "kryoteknik" "kryotekniker" ;
  kryp_nn_1 = mkN "kryp" neutrum ;
  kryperi_nn_1 = mkN "kryperi" "kryperit" "kryperier" "kryperierna" ;
  krypfil_nn_1 = mkN "krypfil" "krypfiler" ;
  kryphaal_nn_1 = mkN "kryphеl" neutrum ;
  kryphaallfasthet_nn_1 = mkN "kryphеllfasthet" "kryphеllfastheter" ;
  krypin_nn_1 = mkN "krypin" "krypinnet" "krypin" "krypinnen" ;
  krypskytt_nn_1 = mkN "krypskytt" ;
  kryptisk_av_1 = mkA "kryptisk" ;
  krypto_nn_1 = mkN "krypto" "kryptot" "krypton" "kryptona" ;
  kryptofascist_nn_1 = mkN "kryptofascist" "kryptofascister" ;
  kryptogam_av_1 = mkA "kryptogam" ;
  kryptogam_nn_1 = mkN "kryptogam" "kryptogamer" ;
  krysantem_nn_1 = mkN "krysantem" "krysantemer" ;
  krysantemum_nn_1 = mkN "krysantemum" ;
  krysolit_nn_1 = mkN "krysolit" "krysoliter" ;
  krysopras_nn_1 = mkN "krysopras" "krysopraser" ;
  kryss_nn_1 = mkN "kryss" neutrum ;
  kryssare_nn_1 = mkN "kryssare" "kryssare" ;
  kryssfoerband_nn_1 = mkN "kryssfцrband" neutrum ;
  krysshult_nn_1 = mkN "krysshult" ;
  kryssmast_nn_1 = mkN "kryssmast" "kryssmaster" ;
  kryssning_nn_1 = mkN "kryssning" ;
  kryssningsraket_nn_1 = mkN "kryssningsraket" "kryssningsraketer" ;
  kryssningsrobot_nn_1 = mkN "kryssningsrobot" ;
  krysstag_nn_1 = mkN "krysstag" neutrum ;
  kryssvalv_nn_1 = mkN "kryssvalv" neutrum ;
  krystvaerk_nn_1 = mkN "krystvдrk" ;
  kub_nn_1 = mkN "kub" "kuber" ;
  kuban_nn_1 = mkN "kuban" "kubaner" ;
  kubansk_av_1 = mkA "kubansk" ;
  kubb_nn_1 = mkN "kubb" ;
  kubbe_nn_1 = mkN "kubbe" utrum ;
  kubik_nn_1 = mkN "kubik" "kubiken" "kubik" "kubiken" ;
  kubikdecimeter_nn_1 = mkN "kubikdecimeter" ;
  kubikmeter_nn_1 = mkN "kubikmeter" ;
  kubikmillimeter_nn_1 = mkN "kubikmillimeter" ;
  kubikrot_nn_1 = mkN "kubikrot" "kubikrцtter" ;
  kubisk_av_1 = mkA "kubisk" ;
  kubist_nn_1 = mkN "kubist" "kubister" ;
  kubistisk_av_1 = mkA "kubistisk" ;
  kudde_nn_1 = mkN "kudde" utrum ;
  kuddkrig_nn_1 = mkN "kuddkrig" neutrum ;
  kuddvar_nn_1 = mkN "kuddvar" neutrum ;
  kuf_nn_1 = mkN "kuf" ;
  kufisk_av_1 = mkA "kufisk" ;
  kugg_nn_1 = mkN "kugg" ;
  kugge_nn_1 = mkN "kugge" utrum ;
  kuggfraaga_nn_1 = mkN "kuggfrеga" ;
  kugghjul_nn_1 = mkN "kugghjul" neutrum ;
  kuggstaang_nn_1 = mkN "kuggstеng" "kuggstдnger" ;
  kuggvaexel_nn_1 = mkN "kuggvдxel" ;
  kujon_nn_1 = mkN "kujon" "kujoner" ;
  kuk_nn_1 = mkN "kuk" ;
  kul_av_1 = mkA "kul" ;
  kulak_nn_1 = mkN "kulak" "kulaker" ;
  kulen_av_1 = mkA "kulen" "kulet" ;
  kulfaang_nn_1 = mkN "kulfеng" neutrum ;
  kulgevaer_nn_1 = mkN "kulgevдr" neutrum ;
  kulhaal_nn_1 = mkN "kulhеl" neutrum ;
  kuli_nn_1 = mkN "kuli" "kulin" "kulier" "kulierna" ;
  kulig_av_1 = mkA "kulig" ;
  kulinarisk_av_1 = mkA "kulinarisk" ;
  kuling_nn_1 = mkN "kuling" ;
  kuliss_nn_1 = mkN "kuliss" "kulisser" ;
  kulkaerve_nn_1 = mkN "kulkдrve" utrum ;
  kulkvarn_nn_1 = mkN "kulkvarn" ;
  kull_ab_1 = mkAdv "kull" ;
  kull_nn_1 = mkN "kull" ;
  kullager_nn_1 = mkN "kullager" neutrum ;
  kulle_nn_1 = mkN "kulle" utrum ;
  kulled_nn_1 = mkN "kulled" "kulleder" ;
  kullersten_nn_1 = mkN "kullersten" "kullerstenen" "kullerstenar" "kullerstenarna" ;
  kullig_av_1 = mkA "kullig" ;
  kullkamrat_nn_1 = mkN "kullkamrat" "kullkamrater" ;
  kullko_nn_1 = mkN "kullko" "kullkor" ;
  kullrig_av_1 = mkA "kullrig" ;
  kullsyskon_nn_1 = mkN "kullsyskon" neutrum ;
  kulmage_nn_1 = mkN "kulmage" utrum ;
  kulmination_nn_1 = mkN "kulmination" "kulminationer" ;
  kuloer_nn_1 = mkN "kulцr" "kulцrer" ;
  kuloert_av_1 = mkA "kulцrt" "kulцrt" ;
  kuloertvaett_nn_1 = mkN "kulцrtvдtt" ;
  kulram_nn_1 = mkN "kulram" ;
  kulskrivmaskin_nn_1 = mkN "kulskrivmaskin" "kulskrivmaskiner" ;
  kulspel_nn_1 = mkN "kulspel" "kulspelet" "kulspel" "kulspelen" ;
  kulsprutegevaer_nn_1 = mkN "kulsprutegevдr" neutrum ;
  kulsprutepistol_nn_1 = mkN "kulsprutepistol" "kulsprutepistoler" ;
  kulstoetare_nn_1 = mkN "kulstцtare" "kulstцtare" ;
  kulstoetning_nn_1 = mkN "kulstцtning" ;
  kult_nn_1 = mkN "kult" "kulter" ;
  kult_nn_2 = mkN "kult" ;
  kultfoeremaal_nn_1 = mkN "kultfцremеl" neutrum ;
  kulthandling_nn_1 = mkN "kulthandling" ;
  kulting_nn_1 = mkN "kulting" ;
  kultisk_av_1 = mkA "kultisk" ;
  kultivator_nn_1 = mkN "kultivator" "kultivatorer" ;
  kultplats_nn_1 = mkN "kultplats" "kultplatser" ;
  kultur_nn_1 = mkN "kultur" "kulturer" ;
  kulturaktivitet_nn_1 = mkN "kulturaktivitet" "kulturaktiviteter" ;
  kulturarbetare_nn_1 = mkN "kulturarbetare" "kulturarbetare" ;
  kulturartikel_nn_1 = mkN "kulturartikel" ;
  kulturarv_nn_1 = mkN "kulturarv" neutrum ;
  kulturattache_nn_1 = mkN "kulturattachй" "kulturattachйer" ;
  kulturbaerare_nn_1 = mkN "kulturbдrare" "kulturbдrare" ;
  kulturbygd_nn_1 = mkN "kulturbygd" "kulturbygder" ;
  kulturcentrum_nn_1 = mkN "kulturcentrum" neutrum ;
  kulturchock_nn_1 = mkN "kulturchock" "kulturchocker" ;
  kulturdebatt_nn_1 = mkN "kulturdebatt" "kulturdebatter" ;
  kulturell_av_1 = mkA "kulturell" ;
  kulturfientlig_av_1 = mkA "kulturfientlig" ;
  kulturfolk_nn_1 = mkN "kulturfolk" neutrum ;
  kulturform_nn_1 = mkN "kulturform" "kulturformer" ;
  kulturgaerning_nn_1 = mkN "kulturgдrning" ;
  kulturhistorisk_av_1 = mkA "kulturhistorisk" ;
  kulturhus_nn_1 = mkN "kulturhus" neutrum ;
  kulturinstitut_nn_1 = mkN "kulturinstitut" neutrum ;
  kulturknutte_nn_1 = mkN "kulturknutte" utrum ;
  kulturkollision_nn_1 = mkN "kulturkollision" "kulturkollisioner" ;
  kulturkrets_nn_1 = mkN "kulturkrets" ;
  kulturlager_nn_1 = mkN "kulturlager" neutrum ;
  kulturland_nn_1 = mkN "kulturland" "kulturlandet" "kulturlдnder" "kulturlдnderna" ;
  kulturlandskap_nn_1 = mkN "kulturlandskap" "kulturlandskapet" "kulturlandskapen" "kulturlandskapena" ;
  kulturminne_nn_1 = mkN "kulturminne" ;
  kulturminnesmaerke_nn_1 = mkN "kulturminnesmдrke" ;
  kulturminnesvaard_nn_1 = mkN "kulturminnesvеrd" ;
  kulturmoenster_nn_1 = mkN "kulturmцnster" neutrum ;
  kulturperson_nn_1 = mkN "kulturperson" "kulturpersoner" ;
  kulturpersonlighet_nn_1 = mkN "kulturpersonlighet" "kulturpersonligheter" ;
  kulturraad_nn_1 = mkN "kulturrеd" neutrum ;
  kulturradikal_nn_1 = mkN "kulturradikal" "kulturradikaler" ;
  kulturreservat_nn_1 = mkN "kulturreservat" neutrum ;
  kulturrevolution_nn_1 = mkN "kulturrevolution" "kulturrevolutioner" ;
  kultursida_nn_1 = mkN "kultursida" ;
  kulturskribent_nn_1 = mkN "kulturskribent" "kulturskribenter" ;
  kulturutbyte_nn_1 = mkN "kulturutbyte" ;
  kulturvaext_nn_1 = mkN "kulturvдxt" "kulturvдxter" ;
  kulventil_nn_1 = mkN "kulventil" "kulventiler" ;
  kulvert_nn_1 = mkN "kulvert" ;
  kummel_nn_1 = mkN "kummel" "kummlet" "kummel" "kummlen" ;
  kummel_nn_2 = mkN "kummel" "kummeln" "kummlar" "kummlarna" ;
  kumpan_nn_1 = mkN "kumpan" "kumpaner" ;
  kumulativ_av_1 = mkA "kumulativ" ;
  kumulering_nn_1 = mkN "kumulering" ;
  kund_nn_1 = mkN "kund" "kunder" ;
  kundkrets_nn_1 = mkN "kundkrets" ;
  kundvagn_nn_1 = mkN "kundvagn" ;
  kung_nn_1 = mkN "kung" ;
  kungaaett_nn_1 = mkN "kungaдtt" "kungaдtter" ;
  kungadoeme_nn_1 = mkN "kungadцme" ;
  kungaed_nn_1 = mkN "kungaed" "kungaeder" ;
  kungahus_nn_1 = mkN "kungahus" neutrum ;
  kungalaengd_nn_1 = mkN "kungalдngd" "kungalдngder" ;
  kungasaete_nn_1 = mkN "kungasдte" ;
  kungaval_nn_1 = mkN "kungaval" neutrum ;
  kunglig_av_1 = mkA "kunglig" ;
  kunglighet_nn_1 = mkN "kunglighet" "kungligheter" ;
  kungoerelse_nn_1 = mkN "kungцrelse" "kungцrelser" ;
  kungsaadra_nn_1 = mkN "kungsеdra" ;
  kungsaengslilja_nn_1 = mkN "kungsдngslilja" ;
  kungsblaa_av_1 = mkA "kungsblе" "kungsblеtt" ;
  kungsbonde_nn_1 = mkN "kungsbonde" "kungsbцnder" ;
  kungsfaagel_nn_1 = mkN "kungsfеgel" ;
  kungsfiskare_nn_1 = mkN "kungsfiskare" "kungsfiskare" ;
  kungsgaard_nn_1 = mkN "kungsgеrd" ;
  kungsgambit_nn_1 = mkN "kungsgambit" ;
  kungshoeg_nn_1 = mkN "kungshцg" ;
  kungsljus_nn_1 = mkN "kungsljus" neutrum ;
  kungsoern_nn_1 = mkN "kungsцrn" ;
  kungsord_nn_1 = mkN "kungsord" neutrum ;
  kungstanke_nn_1 = mkN "kungstanke" utrum ;
  kungstiger_nn_1 = mkN "kungstiger" ;
  kungsvaeg_nn_1 = mkN "kungsvдg" ;
  kunnig_av_1 = mkA "kunnig" ;
  kunskap_nn_1 = mkN "kunskap" "kunskaper" ;
  kunskapare_nn_1 = mkN "kunskapare" "kunskapare" ;
  kunskapskontroll_nn_1 = mkN "kunskapskontroll" "kunskapskontroller" ;
  kunskapsnivaa_nn_1 = mkN "kunskapsnivе" "kunskapsnivеer" ;
  kunskapsstoff_nn_1 = mkN "kunskapsstoff" neutrum ;
  kupe_nn_1 = mkN "kupй" "kupйer" ;
  kupevaermare_nn_1 = mkN "kupйvдrmare" "kupйvдrmare" ;
  kupidon_nn_1 = mkN "kupidon" "kupidoner" ;
  kupig_av_1 = mkA "kupig" ;
  kuplett_nn_1 = mkN "kuplett" "kupletter" ;
  kupol_nn_1 = mkN "kupol" "kupoler" ;
  kupolformig_av_1 = mkA "kupolformig" ;
  kupolgrav_nn_1 = mkN "kupolgrav" ;
  kupong_nn_1 = mkN "kupong" "kuponger" ;
  kupongklippare_nn_1 = mkN "kupongklippare" "kupongklippare" ;
  kupp_nn_1 = mkN "kupp" "kupper" ;
  kuppfoersoek_nn_1 = mkN "kuppfцrsцk" neutrum ;
  kur_nn_1 = mkN "kur" "kurer" ;
  kur_nn_2 = mkN "kur" ;
  kuranstalt_nn_1 = mkN "kuranstalt" "kuranstalter" ;
  kurant_av_1 = mkA "kurant" "kurant" ;
  kuratel_nn_1 = mkN "kuratel" "kuratelet" "kuratel" "kuratelen" ;
  kurativ_av_1 = mkA "kurativ" ;
  kurator_nn_1 = mkN "kurator" "kuratorer" ;
  kurbits_nn_1 = mkN "kurbits" ;
  kurd_nn_1 = mkN "kurd" "kurder" ;
  kurdiska_nn_2 = mkN "kurdiska" ;
  kurfurste_nn_1 = mkN "kurfurste" utrum ;
  kurhus_nn_1 = mkN "kurhus" neutrum ;
  kurioes_av_1 = mkA "kuriцs" ;
  kuriositet_nn_1 = mkN "kuriositet" "kuriositeter" ;
  kuriosum_nn_1 = mkN "kuriosum" "kuriosum" "kuriosa" "kuriosana" ;
  kurir_nn_1 = mkN "kurir" "kurirer" ;
  kurirpass_nn_1 = mkN "kurirpass" neutrum ;
  kurort_nn_1 = mkN "kurort" "kurorter" ;
  kurr_nn_2 = mkN "kurr" neutrum ;
  kurre_nn_1 = mkN "kurre" utrum ;
  kurs_nn_1 = mkN "kurs" "kurser" ;
  kursare_nn_1 = mkN "kursare" "kursare" ;
  kursiv_av_1 = mkA "kursiv" ;
  kursiv_nn_1 = mkN "kursiv" "kursiver" ;
  kurskamrat_nn_1 = mkN "kurskamrat" "kurskamrater" ;
  kursnotering_nn_1 = mkN "kursnotering" ;
  kursor_nn_1 = mkN "kursor" "kursorer" ;
  kursorisk_av_1 = mkA "kursorisk" ;
  kursstegring_nn_1 = mkN "kursstegring" ;
  kurtage_nn_1 = mkN "kurtage" "kurtaget" "kurtage" "kurtagen" ;
  kurtis_nn_1 = mkN "kurtis" "kurtiser" ;
  kurtisan_nn_1 = mkN "kurtisan" "kurtisaner" ;
  kurtisoer_nn_1 = mkN "kurtisцr" "kurtisцrer" ;
  kurvatur_nn_1 = mkN "kurvatur" "kurvaturer" ;
  kurvig_av_1 = mkA "kurvig" ;
  kurvstabil_av_1 = mkA "kurvstabil" ;
  kurvtagning_nn_1 = mkN "kurvtagning" ;
  kuse_nn_1 = mkN "kuse" utrum ;
  kusin_nn_1 = mkN "kusin" "kusiner" ;
  kusinaektenskap_nn_1 = mkN "kusinдktenskap" "kusinдktenskapet" "kusinдktenskapen" "kusinдktenskapena" ;
  kusk_nn_1 = mkN "kusk" ;
  kuskbock_nn_1 = mkN "kuskbock" ;
  kuslig_av_1 = mkA "kuslig" ;
  kust_nn_1 = mkN "kust" "kuster" ;
  kustbygd_nn_1 = mkN "kustbygd" "kustbygder" ;
  kustfisk_nn_1 = mkN "kustfisk" ;
  kustjaegare_nn_1 = mkN "kustjдgare" "kustjдgare" ;
  kustlinje_nn_1 = mkN "kustlinje" "kustlinjer" ;
  kustod_nn_1 = mkN "kustod" "kustoder" ;
  kustomraade_nn_1 = mkN "kustomrеde" ;
  kustort_nn_1 = mkN "kustort" "kustorter" ;
  kustslaett_nn_1 = mkN "kustslдtt" "kustslдtter" ;
  kut_nn_1 = mkN "kut" ;
  kutig_av_1 = mkA "kutig" ;
  kutryggig_av_1 = mkA "kutryggig" ;
  kutter_nn_2 = mkN "kutter" ;
  kutting_nn_1 = mkN "kutting" ;
  kuttrasju_nn_1 = mkN "kuttrasju" "kuttrasjut" "kuttrasjun" "kuttrasjuna" ;
  kutym_nn_1 = mkN "kutym" "kutymer" ;
  kuvert_nn_1 = mkN "kuvert" neutrum ;
  kuvertavgift_nn_1 = mkN "kuvertavgift" "kuvertavgifter" ;
  kuvertbroed_nn_1 = mkN "kuvertbrцd" neutrum ;
  kuvoes_nn_1 = mkN "kuvцs" "kuvцser" ;
  kuwaitier_nn_1 = mkN "kuwaitier" "kuwaitiern" "kuwaitier" "kuwaitierna" ;
  kuwaitisk_av_1 = mkA "kuwaitisk" ;
  kvackare_nn_1 = mkN "kvackare" "kvackare" ;
  kvacksalvare_nn_1 = mkN "kvacksalvare" "kvacksalvare" ;
  kvacksalveri_nn_1 = mkN "kvacksalveri" "kvacksalverit" "kvacksalverier" "kvacksalverierna" ;
  kvader_nn_1 = mkN "kvader" ;
  kvadrant_nn_1 = mkN "kvadrant" "kvadranter" ;
  kvadrat_nn_1 = mkN "kvadrat" "kvadrater" ;
  kvadratisk_av_1 = mkA "kvadratisk" ;
  kvadratkilometer_nn_1 = mkN "kvadratkilometer" ;
  kvadratmeter_nn_1 = mkN "kvadratmeter" ;
  kvadratrot_nn_1 = mkN "kvadratrot" "kvadratrцtter" ;
  kvadriljon_nn_1 = mkN "kvadriljon" "kvadriljoner" ;
  kvadrupelallians_nn_1 = mkN "kvadrupelallians" "kvadrupelallianser" ;
  kvaeda_vb_1 = mkV "kvдda" "kvad" "kvдdit" ;
  kvaekare_nn_1 = mkN "kvдkare" "kvдkare" ;
  kvaeljning_nn_1 = mkN "kvдljning" ;
  kvaell_nn_1 = mkN "kvдll" ;
  kvaellsbris_nn_1 = mkN "kvдllsbris" ;
  kvaellsignal_nn_1 = mkN "kvдllsignal" "kvдllsignaler" ;
  kvaellskurs_nn_1 = mkN "kvдllskurs" "kvдllskurser" ;
  kvaellslig_av_1 = mkA "kvдllslig" ;
  kvaellsmaaltid_nn_1 = mkN "kvдllsmеltid" "kvдllsmеltider" ;
  kvaellsmaenniska_nn_1 = mkN "kvдllsmдnniska" ;
  kvaellsoeppen_av_1 = mkA "kvдllsцppen" "kvдllsцppet" ;
  kvaellssammankomst_nn_1 = mkN "kvдllssammankomst" "kvдllssammankomster" ;
  kvaellsunderhaallning_nn_1 = mkN "kvдllsunderhеllning" ;
  kvaellsvard_nn_1 = mkN "kvдllsvard" "kvдllsvarder" ;
  kvaevande_av_1 = mkA "kvдvande" ;
  kvaevegoedselmedel_nn_1 = mkN "kvдvegцdselmedel" neutrum ;
  kvaeveoxid_nn_1 = mkN "kvдveoxid" "kvдveoxider" ;
  kval_nn_1 = mkN "kval" neutrum ;
  kvalfull_av_1 = mkA "kvalfull" ;
  kvalfylld_av_1 = mkA "kvalfylld" "kvalfyllt" ;
  kvalificering_nn_1 = mkN "kvalificering" ;
  kvalifikation_nn_1 = mkN "kvalifikation" "kvalifikationer" ;
  kvalifikationsaar_nn_1 = mkN "kvalifikationsеr" neutrum ;
  kvalitativ_av_1 = mkA "kvalitativ" ;
  kvalite_nn_1 = mkN "kvalitй" "kvalitйer" ;
  kvalitet_nn_1 = mkN "kvalitet" "kvaliteter" ;
  kvalitetsauktion_nn_1 = mkN "kvalitetsauktion" "kvalitetsauktioner" ;
  kvalitetskontroll_nn_1 = mkN "kvalitetskontroll" "kvalitetskontroller" ;
  kvalmig_av_1 = mkA "kvalmig" ;
  kvalster_nn_1 = mkN "kvalster" neutrum ;
  kvantitativ_av_1 = mkA "kvantitativ" ;
  kvantitet_nn_1 = mkN "kvantitet" "kvantiteter" ;
  kvanttal_nn_1 = mkN "kvanttal" "kvanttalet" "kvanttalen" "kvanttalena" ;
  kvantum_nn_1 = mkN "kvantum" neutrum ;
  kvar_ab_1 = mkAdv "kvar" ;
  kvargloemd_av_1 = mkA "kvarglцmd" "kvarglцmt" ;
  kvarhaalla_vb_1 = mkV "kvarhеlla" "kvarhцll" "kvarhеllit" ;
  kvark_nn_1 = mkN "kvark" ;
  kvarkklimp_nn_1 = mkN "kvarkklimp" ;
  kvarn_nn_1 = mkN "kvarn" ;
  kvarndamm_nn_1 = mkN "kvarndamm" ;
  kvarnhjul_nn_1 = mkN "kvarnhjul" neutrum ;
  kvarnsten_nn_1 = mkN "kvarnsten" "kvarnstenen" "kvarnstenar" "kvarnstenarna" ;
  kvarnvinge_nn_1 = mkN "kvarnvinge" utrum ;
  kvarsittare_nn_1 = mkN "kvarsittare" "kvarsittare" ;
  kvarskatt_nn_1 = mkN "kvarskatt" "kvarskatter" ;
  kvarstad_nn_1 = mkN "kvarstad" "kvarstader" ;
  kvart_nn_1 = mkN "kvart" ;
  kvart_nn_2 = mkN "kvart" "kvarter" ;
  kvart_nn_3 = mkN "kvart" ;
  kvartal_nn_1 = mkN "kvartal" "kvartalet" "kvartalen" "kvartalena" ;
  kvarter_nn_1 = mkN "kvarter" "kvarteret" "kvarter" "kvarteren" ;
  kvartermaestare_nn_1 = mkN "kvartermдstare" "kvartermдstare" ;
  kvarterspolis_nn_1 = mkN "kvarterspolis" "kvarterspoliser" ;
  kvartett_nn_1 = mkN "kvartett" "kvartetter" ;
  kvartil_nn_1 = mkN "kvartil" "kvartiler" ;
  kvarting_nn_1 = mkN "kvarting" ;
  kvarts_nn_1 = mkN "kvarts" "kvartser" ;
  kvartsbutelj_nn_1 = mkN "kvartsbutelj" "kvartsbuteljer" ;
  kvartsfigur_nn_1 = mkN "kvartsfigur" "kvartsfigurer" ;
  kvartsfinal_nn_1 = mkN "kvartsfinal" "kvartsfinaler" ;
  kvartsit_nn_1 = mkN "kvartsit" "kvartsiter" ;
  kvartskristall_nn_1 = mkN "kvartskristall" "kvartskristaller" ;
  kvartssamtal_nn_1 = mkN "kvartssamtal" "kvartssamtalet" "kvartssamtalen" "kvartssamtalena" ;
  kvartssekel_nn_1 = mkN "kvartssekel" neutrum ;
  kvartston_nn_1 = mkN "kvartston" "kvartstoner" ;
  kvartsur_nn_1 = mkN "kvartsur" neutrum ;
  kvarvarande_av_1 = mkA "kvarvarande" ;
  kvasar_nn_1 = mkN "kvasar" "kvasarer" ;
  kvasikontrakt_nn_1 = mkN "kvasikontrakt" neutrum ;
  kvasikristall_nn_1 = mkN "kvasikristall" "kvasikristaller" ;
  kvass_nn_1 = mkN "kvass" ;
  kvast_nn_1 = mkN "kvast" ;
  kvastfening_nn_1 = mkN "kvastfening" ;
  kvastprick_nn_1 = mkN "kvastprick" ;
  kvastskaft_nn_1 = mkN "kvastskaft" neutrum ;
  kvav_av_1 = mkA "kvav" ;
  kved_nn_1 = mkN "kved" ;
  kverulant_nn_1 = mkN "kverulant" "kverulanter" ;
  kverulantisk_av_1 = mkA "kverulantisk" ;
  kvick_av_1 = mkA "kvick" ;
  kvickhet_nn_1 = mkN "kvickhet" "kvickheter" ;
  kvickhuvud_nn_1 = mkN "kvickhuvud" "kvickhuvudet" "kvickhuvuden" "kvickhuvudena" ;
  kvickoegd_av_1 = mkA "kvickцgd" "kvickцgt" ;
  kvicksilverfoerening_nn_1 = mkN "kvicksilverfцrening" ;
  kvicksilverpelare_nn_1 = mkN "kvicksilverpelare" "kvicksilverpelare" ;
  kvicktaenkt_av_1 = mkA "kvicktдnkt" "kvicktдnkt" ;
  kvidande_nn_1 = mkN "kvidande" ;
  kvidd_nn_1 = mkN "kvidd" "kvidder" ;
  kvigkalv_nn_1 = mkN "kvigkalv" ;
  kvinna_nn_1 = mkN "kvinna" ;
  kvinnfolk_nn_1 = mkN "kvinnfolk" neutrum ;
  kvinnlig_av_1 = mkA "kvinnlig" ;
  kvinnoben_nn_1 = mkN "kvinnoben" neutrum ;
  kvinnobild_nn_1 = mkN "kvinnobild" "kvinnobilder" ;
  kvinnobroest_nn_1 = mkN "kvinnobrцst" neutrum ;
  kvinnodraekt_nn_1 = mkN "kvinnodrдkt" "kvinnodrдkter" ;
  kvinnofaengelse_nn_1 = mkN "kvinnofдngelse" "kvinnofдngelset" "kvinnofдngelser" "kvinnofдngelserna" ;
  kvinnofoerfoerare_nn_1 = mkN "kvinnofцrfцrare" "kvinnofцrfцrare" ;
  kvinnofraaga_nn_1 = mkN "kvinnofrеga" ;
  kvinnofrisyr_nn_1 = mkN "kvinnofrisyr" "kvinnofrisyrer" ;
  kvinnograv_nn_1 = mkN "kvinnograv" ;
  kvinnohus_nn_1 = mkN "kvinnohus" neutrum ;
  kvinnoklinik_nn_1 = mkN "kvinnoklinik" "kvinnokliniker" ;
  kvinnolaeger_nn_1 = mkN "kvinnolдger" neutrum ;
  kvinnolaekare_nn_1 = mkN "kvinnolдkare" "kvinnolдkare" ;
  kvinnonamn_nn_1 = mkN "kvinnonamn" neutrum ;
  kvinnoplagg_nn_1 = mkN "kvinnoplagg" neutrum ;
  kvinnopraest_nn_1 = mkN "kvinnoprдst" "kvinnoprдster" ;
  kvinnoroerelse_nn_1 = mkN "kvinnorцrelse" "kvinnorцrelser" ;
  kvinnoroll_nn_1 = mkN "kvinnoroll" "kvinnoroller" ;
  kvinnorov_nn_1 = mkN "kvinnorov" neutrum ;
  kvinnosakskvinna_nn_1 = mkN "kvinnosakskvinna" ;
  kvinnosjukdom_nn_1 = mkN "kvinnosjukdom" ;
  kvinnoskulptur_nn_1 = mkN "kvinnoskulptur" "kvinnoskulpturer" ;
  kvinnotjusare_nn_1 = mkN "kvinnotjusare" "kvinnotjusare" ;
  kvint_nn_1 = mkN "kvint" "kvinter" ;
  kvintett_nn_1 = mkN "kvintett" "kvintetter" ;
  kvisslig_av_1 = mkA "kvisslig" ;
  kvist_nn_1 = mkN "kvist" ;
  kvistfri_av_1 = mkA "kvistfri" "kvistfritt" ;
  kvisthaal_nn_1 = mkN "kvisthеl" neutrum ;
  kvistig_av_1 = mkA "kvistig" ;
  kvistliknande_av_1 = mkA "kvistliknande" ;
  kvistloes_av_1 = mkA "kvistlцs" ;
  kvitt_ab_1 = mkAdv "kvitt" ;
  kvitt_av_1 = mkA "kvitt" ;
  kvitten_nn_1 = mkN "kvitten" "kvitten" "kvitten" "kvittena" ;
  kvittens_nn_1 = mkN "kvittens" "kvittenser" ;
  kvitteringsmaal_nn_1 = mkN "kvitteringsmеl" neutrum ;
  kvittning_nn_1 = mkN "kvittning" ;
  kvitto_nn_1 = mkN "kvitto" "kvittot" "kvitton" "kvittona" ;
  kvittrig_av_1 = mkA "kvittrig" ;
  kvot_nn_1 = mkN "kvot" "kvoter" ;
  kvotering_nn_1 = mkN "kvotering" ;
  kybernetik_nn_1 = mkN "kybernetik" "kybernetiker" ;
  kybernetisk_av_1 = mkA "kybernetisk" ;
  kyckling_nn_1 = mkN "kyckling" ;
  kycklingmoder_nn_1 = mkN "kycklingmoder" "kycklingmodern" "kycklingmцdrar" "kycklingmцdrarna" ;
  kyffig_av_1 = mkA "kyffig" ;
  kyl_nn_1 = mkN "kyl" ;
  kylare_nn_1 = mkN "kylare" "kylare" ;
  kylargaller_nn_1 = mkN "kylargaller" neutrum ;
  kylargardin_nn_1 = mkN "kylargardin" "kylargardiner" ;
  kyldisk_nn_1 = mkN "kyldisk" ;
  kylhus_nn_1 = mkN "kylhus" neutrum ;
  kylig_av_1 = mkA "kylig" ;
  kylklamp_nn_1 = mkN "kylklamp" ;
  kylkonserv_nn_1 = mkN "kylkonserv" "kylkonserver" ;
  kylledning_nn_1 = mkN "kylledning" ;
  kyller_nn_1 = mkN "kyller" neutrum ;
  kylning_nn_1 = mkN "kylning" ;
  kylsig_av_1 = mkA "kylsig" ;
  kylskaap_nn_1 = mkN "kylskеp" neutrum ;
  kylslagen_av_1 = mkA "kylslagen" "kylslaget" ;
  kylvagn_nn_1 = mkN "kylvagn" ;
  kymation_nn_1 = mkN "kymation" "kymatiet" "kymatier" "kymatierna" ;
  kymig_av_1 = mkA "kymig" ;
  kymograf_nn_1 = mkN "kymograf" "kymografer" ;
  kymrer_nn_1 = mkN "kymrer" "kymrern" "kymrer" "kymrerna" ;
  kyniker_nn_1 = mkN "kyniker" "kynikern" "kyniker" "kynikerna" ;
  kynisk_av_1 = mkA "kynisk" ;
  kynolog_nn_1 = mkN "kynolog" "kynologer" ;
  kyp_nn_1 = mkN "kyp" ;
  kypare_nn_1 = mkN "kypare" "kypare" ;
  kypert_nn_1 = mkN "kypert" ;
  kyrass_nn_1 = mkN "kyrass" "kyrasser" ;
  kyrassiaer_nn_1 = mkN "kyrassiдr" "kyrassiдrer" ;
  kyrillisk_av_1 = mkA "kyrillisk" ;
  kyrka_nn_1 = mkN "kyrka" ;
  kyrkbaat_nn_1 = mkN "kyrkbеt" ;
  kyrkbacke_nn_1 = mkN "kyrkbacke" utrum ;
  kyrkbaenk_nn_1 = mkN "kyrkbдnk" ;
  kyrkbesoek_nn_1 = mkN "kyrkbesцk" neutrum ;
  kyrkbibel_nn_1 = mkN "kyrkbibel" ;
  kyrkbok_nn_1 = mkN "kyrkbok" "kyrkbцcker" ;
  kyrkbroellop_nn_1 = mkN "kyrkbrцllop" neutrum ;
  kyrkby_nn_1 = mkN "kyrkby" "kyrkbyn" "kyrkbyar" "kyrkbyarna" ;
  kyrkfoenster_nn_1 = mkN "kyrkfцnster" neutrum ;
  kyrklig_av_1 = mkA "kyrklig" ;
  kyrkoaar_nn_1 = mkN "kyrkoеr" neutrum ;
  kyrkoadjunkt_nn_1 = mkN "kyrkoadjunkt" "kyrkoadjunkter" ;
  kyrkobesoek_nn_1 = mkN "kyrkobesцk" neutrum ;
  kyrkobesoekare_nn_1 = mkN "kyrkobesцkare" "kyrkobesцkare" ;
  kyrkobok_nn_1 = mkN "kyrkobok" "kyrkobцcker" ;
  kyrkobroder_nn_1 = mkN "kyrkobroder" "kyrkobrodern" "kyrkobrцder" "kyrkobrцderna" ;
  kyrkofader_nn_1 = mkN "kyrkofader" "kyrkofadern" "kyrkofдder" "kyrkofдderna" ;
  kyrkofullmaektig_nn_1 = mkN "kyrkofullmдktig" "kyrkofullmдktigen" "kyrkofullmдktige" "kyrkofullmдktigena" ;
  kyrkogaard_nn_1 = mkN "kyrkogеrd" ;
  kyrkohandbok_nn_1 = mkN "kyrkohandbok" "kyrkohandbцcker" ;
  kyrkoherde_nn_1 = mkN "kyrkoherde" utrum ;
  kyrkoman_nn_1 = mkN "kyrkoman" "kyrkomannen" "kyrkomдn" "kyrkomдnnen" ;
  kyrkomoete_nn_1 = mkN "kyrkomцte" ;
  kyrkomusiker_nn_1 = mkN "kyrkomusiker" "kyrkomusikern" "kyrkomusiker" "kyrkomusikerna" ;
  kyrkoraad_nn_1 = mkN "kyrkorеd" neutrum ;
  kyrkorum_nn_1 = mkN "kyrkorum" "kyrkorummet" "kyrkorum" "kyrkorummen" ;
  kyrkosaang_nn_1 = mkN "kyrkosеng" "kyrkosеnger" ;
  kyrkosamfund_nn_1 = mkN "kyrkosamfund" neutrum ;
  kyrkospraak_nn_1 = mkN "kyrkosprеk" neutrum ;
  kyrkostaemma_nn_1 = mkN "kyrkostдmma" ;
  kyrkoton_nn_1 = mkN "kyrkoton" "kyrkotoner" ;
  kyrkotonart_nn_1 = mkN "kyrkotonart" "kyrkotonarter" ;
  kyrkoverksamhet_nn_1 = mkN "kyrkoverksamhet" "kyrkoverksamheter" ;
  kyrksal_nn_1 = mkN "kyrksal" ;
  kyrksam_av_1 = mkA "kyrksam" "kyrksamt" "kyrksamma" "kyrksamma" "kyrksammare" "kyrksammast" "kyrksammaste" ;
  kyrkskriva_vb_1 = mkV "kyrkskriva" "kyrkskrev" "kyrkskrivit" ;
  kyrksocken_nn_1 = mkN "kyrksocken" "kyrksockenn" "kyrksocknar" "kyrksocknarna" ;
  kyrkstoet_nn_1 = mkN "kyrkstцt" ;
  kyrktagning_nn_1 = mkN "kyrktagning" ;
  kyrktorn_nn_1 = mkN "kyrktorn" neutrum ;
  kyrktupp_nn_1 = mkN "kyrktupp" ;
  kyrkvaerd_nn_1 = mkN "kyrkvдrd" ;
  kyrkvaktmaestare_nn_1 = mkN "kyrkvaktmдstare" "kyrkvaktmдstare" ;
  kysk_av_1 = mkA "kysk" ;
  kyskhet_nn_1 = mkN "kyskhet" "kyskheter" ;
  kyskhetsbaelte_nn_1 = mkN "kyskhetsbдlte" ;
  kyskhetsloefte_nn_1 = mkN "kyskhetslцfte" ;
  kyss_nn_1 = mkN "kyss" ;
  kyssaekta_av_1 = mkA "kyssдkta" ;
  kysstaeck_av_1 = mkA "kysstдck" ;
  kytt_nn_1 = mkN "kytt" neutrum ;
  laadaemne_nn_1 = mkN "lеdдmne" ;
  laadkamera_nn_1 = mkN "lеdkamera" ;
  laadspik_nn_1 = mkN "lеdspik" ;
  laag_av_1 = mkA "lеg" "lдgre" "lдgst" ;
  laagblad_nn_1 = mkN "lеgblad" neutrum ;
  laagfaerg_nn_1 = mkN "lеgfдrg" "lеgfдrger" ;
  laagfjaell_nn_1 = mkN "lеgfjдll" neutrum ;
  laagfrekvens_nn_1 = mkN "lеgfrekvens" "lеgfrekvenser" ;
  laagfrekvent_av_1 = mkA "lеgfrekvent" "lеgfrekvent" ;
  laaghalt_av_1 = mkA "lеghalt" "lеghalt" ;
  laaghet_nn_1 = mkN "lеghet" "lеgheter" ;
  laaghus_nn_1 = mkN "lеghus" neutrum ;
  laaginkomsttagare_nn_1 = mkN "lеginkomsttagare" "lеginkomsttagare" ;
  laagkonjunktur_nn_1 = mkN "lеgkonjunktur" "lеgkonjunkturer" ;
  laagkyrklig_av_1 = mkA "lеgkyrklig" ;
  laaglaent_av_1 = mkA "lеglдnt" "lеglдnt" ;
  laaglandsras_nn_1 = mkN "lеglandsras" "lеglandsraser" ;
  laagloeneprofil_nn_1 = mkN "lеglцneprofil" "lеglцneprofiler" ;
  laagmaeld_av_1 = mkA "lеgmдld" "lеgmдlt" ;
  laagmosse_nn_1 = mkN "lеgmosse" utrum ;
  laagpresterande_av_1 = mkA "lеgpresterande" ;
  laagpris_nn_1 = mkN "lеgpris" neutrum ;
  laagpriskort_nn_1 = mkN "lеgpriskort" neutrum ;
  laagproduktiv_av_1 = mkA "lеgproduktiv" ;
  laagrelief_nn_1 = mkN "lеgrelief" "lеgreliefer" ;
  laagsaesong_nn_1 = mkN "lеgsдsong" "lеgsдsonger" ;
  laagsint_av_1 = mkA "lеgsint" "lеgsint" ;
  laagsko_nn_1 = mkN "lеgsko" "lеgskor" ;
  laagslaett_nn_1 = mkN "lеgslдtt" "lеgslдtter" ;
  laagsniff_nn_1 = mkN "lеgsniff" ;
  laagspaend_av_1 = mkA "lеgspдnd" ;
  laagspaenning_nn_1 = mkN "lеgspдnning" ;
  laagstadium_nn_1 = mkN "lеgstadium" "lеgstadiet" "lеgstadier" "lеgstadierna" ;
  laagsvavlig_av_1 = mkA "lеgsvavlig" ;
  laagtryck_nn_1 = mkN "lеgtryck" neutrum ;
  laagtstaaende_av_1 = mkA "lеgtstеende" ;
  laagtysk_av_1 = mkA "lеgtysk" ;
  laagvaerdig_av_1 = mkA "lеgvдrdig" ;
  laagvaext_av_1 = mkA "lеgvдxt" "lеgvдxt" ;
  laagvatten_nn_1 = mkN "lеgvatten" "lеgvattnet" "lеgvatten" "lеgvattnen" ;
  laagvattenmaerke_nn_1 = mkN "lеgvattenmдrke" ;
  laagvuxen_av_1 = mkA "lеgvuxen" "lеgvuxet" ;
  laan_nn_1 = mkN "lеn" neutrum ;
  laaneansoekning_nn_1 = mkN "lеneansцkning" ;
  laanebibliotek_nn_1 = mkN "lеnebibliotek" neutrum ;
  laaneexpedition_nn_1 = mkN "lеneexpedition" "lеneexpeditioner" ;
  laaneform_nn_1 = mkN "lеneform" "lеneformer" ;
  laanegaranti_nn_1 = mkN "lеnegaranti" "lеnegarantier" ;
  laanekoep_nn_1 = mkN "lеnekцp" neutrum ;
  laanekontor_nn_1 = mkN "lеnekontor" neutrum ;
  laanekort_nn_1 = mkN "lеnekort" neutrum ;
  laanetak_nn_1 = mkN "lеnetak" neutrum ;
  laanfaangen_av_1 = mkA "lеnfеngen" "lеnfеnget" ;
  laang_av_1 = mkA "lеng" "lдngre" "lдngst" ;
  laangbaenk_nn_1 = mkN "lеngbдnk" ;
  laangbent_av_1 = mkA "lеngbent" "lеngbent" ;
  laangboll_nn_1 = mkN "lеngboll" ;
  laangbord_nn_1 = mkN "lеngbord" neutrum ;
  laangdans_nn_1 = mkN "lеngdans" "lеngdanser" ;
  laangdistans_nn_1 = mkN "lеngdistans" "lеngdistanser" ;
  laangdistansloepning_nn_1 = mkN "lеngdistanslцpning" ;
  laangdistansraket_nn_1 = mkN "lеngdistansraket" "lеngdistansraketer" ;
  laangdragen_av_1 = mkA "lеngdragen" "lеngdraget" ;
  laangduk_nn_1 = mkN "lеngduk" ;
  laangeman_nn_1 = mkN "lеngeman" "lеngemannen" "lеngemдn" "lеngemдnnen" ;
  laangfaerd_nn_1 = mkN "lеngfдrd" "lеngfдrder" ;
  laangfarare_nn_1 = mkN "lеngfarare" "lеngfarare" ;
  laangfilm_nn_1 = mkN "lеngfilm" "lеngfilmer" ;
  laangfinger_nn_1 = mkN "lеngfinger" ;
  laangfranska_nn_1 = mkN "lеngfranska" ;
  laangfredag_nn_1 = mkN "lеngfredag" ;
  laangfristig_av_1 = mkA "lеngfristig" ;
  laanggardin_nn_1 = mkN "lеnggardin" "lеnggardiner" ;
  laanggrogg_nn_1 = mkN "lеnggrogg" ;
  laanggrund_av_1 = mkA "lеnggrund" ;
  laanghaarig_av_1 = mkA "lеnghеrig" ;
  laanghelg_nn_1 = mkN "lеnghelg" "lеnghelger" ;
  laanghus_nn_1 = mkN "lеnghus" neutrum ;
  laangivande_av_1 = mkA "lеngivande" ;
  laangivare_nn_1 = mkN "lеngivare" "lеngivare" ;
  laangkoerare_nn_1 = mkN "lеngkцrare" "lеngkцrare" ;
  laangkok_nn_1 = mkN "lеngkok" neutrum ;
  laangledig_av_1 = mkA "lеngledig" ;
  laanglig_av_1 = mkA "lеnglig" ;
  laangliggare_nn_1 = mkN "lеngliggare" "lеngliggare" ;
  laanglopp_nn_1 = mkN "lеnglopp" neutrum ;
  laanglotsning_nn_1 = mkN "lеnglotsning" ;
  laangmodig_av_1 = mkA "lеngmodig" ;
  laangnaebb_nn_1 = mkN "lеngnдbb" ;
  laangnaest_av_1 = mkA "lеngnдst" "lеngnдst" ;
  laangperiodisk_av_1 = mkA "lеngperiodisk" ;
  laangpromenad_nn_1 = mkN "lеngpromenad" "lеngpromenader" ;
  laangrandig_av_1 = mkA "lеngrandig" ;
  laangrev_nn_1 = mkN "lеngrev" ;
  laangsalning_nn_1 = mkN "lеngsalning" ;
  laangsam_av_1 = mkA "lеngsam" "lеngsamt" "lеngsamma" "lеngsamma" "lеngsammare" "lеngsammast" "lеngsammaste" ;
  laangschal_nn_1 = mkN "lеngschal" ;
  laangsida_nn_1 = mkN "lеngsida" ;
  laangsides_ab_1 = mkAdv "lеngsides" ;
  laangsiktig_av_1 = mkA "lеngsiktig" ;
  laangsint_av_1 = mkA "lеngsint" "lеngsint" ;
  laangsjal_nn_1 = mkN "lеngsjal" ;
  laangskallig_av_1 = mkA "lеngskallig" ;
  laangskepp_nn_1 = mkN "lеngskepp" neutrum ;
  laangskepps_ab_1 = mkAdv "lеngskepps" ;
  laangskott_nn_1 = mkN "lеngskott" neutrum ;
  laangsmal_av_1 = mkA "lеngsmal" ;
  laangsoekt_av_1 = mkA "lеngsцkt" "lеngsцkt" ;
  laangspant_nn_1 = mkN "lеngspant" neutrum ;
  laangspel_nn_1 = mkN "lеngspel" "lеngspelet" "lеngspel" "lеngspelen" ;
  laangstraeckt_av_1 = mkA "lеngstrдckt" "lеngstrдckt" ;
  laangsynt_av_1 = mkA "lеngsynt" "lеngsynt" ;
  laangsynthet_nn_1 = mkN "lеngsynthet" "lеngsyntheter" ;
  laangtgaaende_av_1 = mkA "lеngtgеende" ;
  laangtidsparkering_nn_1 = mkN "lеngtidsparkering" ;
  laangtidsprognos_nn_1 = mkN "lеngtidsprognos" "lеngtidsprognoser" ;
  laangtidsvikariat_nn_1 = mkN "lеngtidsvikariat" neutrum ;
  laangtifraan_ab_1 = mkAdv "lеngtifrеn" ;
  laangtraadig_av_1 = mkA "lеngtrеdig" ;
  laangtraakig_av_1 = mkA "lеngtrеkig" ;
  laangtradare_nn_1 = mkN "lеngtradare" "lеngtradare" ;
  laangtradig_av_1 = mkA "lеngtradig" ;
  laangtur_nn_1 = mkN "lеngtur" "lеngturer" ;
  laangvaagig_av_1 = mkA "lеngvеgig" ;
  laangvaega_av_1 = mkA "lеngvдga" ;
  laangvarig_av_1 = mkA "lеngvarig" ;
  laanord_nn_1 = mkN "lеnord" neutrum ;
  laantagare_nn_1 = mkN "lеntagare" "lеntagare" ;
  laar_nn_1 = mkN "lеr" neutrum ;
  laar_nn_2 = mkN "lеr" ;
  laarben_nn_1 = mkN "lеrben" neutrum ;
  laarbensbrott_nn_1 = mkN "lеrbensbrott" neutrum ;
  laarbenshals_nn_1 = mkN "lеrbenshals" ;
  laarding_nn_1 = mkN "lеrding" ;
  laaring_nn_1 = mkN "lеring" ;
  laaringsvind_nn_1 = mkN "lеringsvind" ;
  laas_nn_1 = mkN "lеs" ;
  laaskolv_nn_1 = mkN "lеskolv" ;
  laasmutter_nn_1 = mkN "lеsmutter" ;
  laasning_nn_1 = mkN "lеsning" ;
  laassmed_nn_1 = mkN "lеssmed" "lеssmeder" ;
  laassprint_nn_1 = mkN "lеssprint" ;
  laasvred_nn_1 = mkN "lеsvred" neutrum ;
  laat_nn_1 = mkN "lеt" ;
  laatgaasystem_nn_1 = mkN "lеtgеsystem" neutrum ;
  laatsaslek_nn_1 = mkN "lеtsaslek" ;
  laatsasvaerld_nn_1 = mkN "lеtsasvдrld" ;
  labb_nn_1 = mkN "labb" ;
  labb_nn_2 = mkN "labb" neutrum ;
  labbe_nn_1 = mkN "labbe" utrum ;
  laber_av_1 = mkA "laber" "labert" "labra" "labra" "labrare" "labrast" "labraste" ;
  labial_av_1 = mkA "labial" ;
  labial_nn_1 = mkN "labial" "labialer" ;
  labialstaemma_nn_1 = mkN "labialstдmma" ;
  labil_av_1 = mkA "labil" ;
  labilitet_nn_1 = mkN "labilitet" "labiliteter" ;
  labiodental_av_1 = mkA "labiodental" ;
  labiodental_nn_1 = mkN "labiodental" "labiodentaler" ;
  laborant_nn_1 = mkN "laborant" "laboranter" ;
  laboration_nn_1 = mkN "laboration" "laborationer" ;
  laborativ_av_1 = mkA "laborativ" ;
  laborator_nn_1 = mkN "laborator" "laboratorer" ;
  laboratorieassistent_nn_1 = mkN "laboratorieassistent" "laboratorieassistenter" ;
  laboratorieexperiment_nn_1 = mkN "laboratorieexperiment" neutrum ;
  laboratorieresultat_nn_1 = mkN "laboratorieresultat" neutrum ;
  laboratorierock_nn_1 = mkN "laboratorierock" ;
  laboratorium_nn_1 = mkN "laboratorium" "laboratoriet" "laboratorier" "laboratorierna" ;
  labourregering_nn_1 = mkN "labourregering" ;
  labrador_nn_1 = mkN "labrador" "labradoren" "labradorer" "labradorerna" ;
  labyrint_nn_1 = mkN "labyrint" "labyrinter" ;
  labyrintisk_av_1 = mkA "labyrintisk" ;
  lack_nn_1 = mkN "lack" neutrum ;
  lackering_nn_1 = mkN "lackering" ;
  lackfaerg_nn_1 = mkN "lackfдrg" "lackfдrger" ;
  lacksko_nn_1 = mkN "lacksko" "lackskor" ;
  lackskoeldlus_nn_1 = mkN "lackskцldlus" "lackskцldlusen" "lackskцldlцss" "lackskцldlцssen" ;
  lackviol_nn_1 = mkN "lackviol" "lackvioler" ;
  lad_nn_1 = mkN "lad" neutrum ;
  laddning_nn_1 = mkN "laddning" ;
  laddram_nn_1 = mkN "laddram" ;
  laddstock_nn_1 = mkN "laddstock" ;
  ladugaard_nn_1 = mkN "ladugеrd" ;
  lady_nn_1 = mkN "lady" "ladyn" "ladies" "ladies" ;
  laeck_av_1 = mkA "lдck" ;
  laeckage_nn_1 = mkN "lдckage" "lдckaget" "lдckage" "lдckagen" ;
  laeckageproblem_nn_1 = mkN "lдckageproblem" neutrum ;
  laecker_av_1 = mkA "lдcker" "lдckert" "lдckra" "lдckra" "lдckrare" "lдckrast" "lдckraste" ;
  laeckerbit_nn_1 = mkN "lдckerbit" ;
  laeckergom_nn_1 = mkN "lдckergom" "lдckergommen" "lдckergommar" "lдckergommarna" ;
  laeckerhet_nn_1 = mkN "lдckerhet" "lдckerheter" ;
  laederlapp_nn_1 = mkN "lдderlapp" ;
  laege_nn_1 = mkN "lдge" ;
  laegel_nn_1 = mkN "lдgel" ;
  laegenhet_nn_1 = mkN "lдgenhet" "lдgenheter" ;
  laegenhetsbyte_nn_1 = mkN "lдgenhetsbyte" ;
  laegenhetshotell_nn_1 = mkN "lдgenhetshotell" neutrum ;
  laeger_ab_1 = mkAdv "lдger" ;
  laeger_nn_1 = mkN "lдger" neutrum ;
  laegerbaal_nn_1 = mkN "lдgerbеl" neutrum ;
  laegereld_nn_1 = mkN "lдgereld" ;
  laegesbestaemning_nn_1 = mkN "lдgesbestдmning" ;
  laegesfoeraendring_nn_1 = mkN "lдgesfцrдndring" ;
  laegesrapport_nn_1 = mkN "lдgesrapport" "lдgesrapporter" ;
  laegessinne_nn_1 = mkN "lдgessinne" ;
  laegg_nn_1 = mkN "lдgg" neutrum ;
  laegg_nn_2 = mkN "lдgg" ;
  laeggdags_ab_1 = mkAdv "lдggdags" ;
  laeggning_nn_1 = mkN "lдggning" ;
  laeggspel_nn_1 = mkN "lдggspel" "lдggspelet" "lдggspel" "lдggspelen" ;
  laeglig_av_1 = mkA "lдglig" ;
  laekarbok_nn_1 = mkN "lдkarbok" "lдkarbцcker" ;
  laekarcentral_nn_1 = mkN "lдkarcentral" "lдkarcentraler" ;
  laekare_nn_1 = mkN "lдkare" "lдkare" ;
  laekarhjaelp_nn_1 = mkN "lдkarhjдlp" ;
  laekarhus_nn_1 = mkN "lдkarhus" neutrum ;
  laekarintyg_nn_1 = mkN "lдkarintyg" neutrum ;
  laekarmottagning_nn_1 = mkN "lдkarmottagning" ;
  laekarordination_nn_1 = mkN "lдkarordination" "lдkarordinationer" ;
  laekarrecept_nn_1 = mkN "lдkarrecept" neutrum ;
  laekarrock_nn_1 = mkN "lдkarrock" ;
  laekarsekreterare_nn_1 = mkN "lдkarsekreterare" "lдkarsekreterare" ;
  laekarundersoekning_nn_1 = mkN "lдkarundersцkning" ;
  laekedom_nn_1 = mkN "lдkedom" ;
  laekemedel_nn_1 = mkN "lдkemedel" neutrum ;
  laekemedelskontroll_nn_1 = mkN "lдkemedelskontroll" "lдkemedelskontroller" ;
  laekemedelslag_nn_1 = mkN "lдkemedelslag" ;
  laekevaext_nn_1 = mkN "lдkevдxt" "lдkevдxter" ;
  laekt_nn_1 = mkN "lдkt" "lдkter" ;
  laektare_nn_1 = mkN "lдktare" "lдktare" ;
  laem_nn_1 = mkN "lдm" "lдmmen" "lдmmar" "lдmmarna" ;
  laemmel_nn_1 = mkN "lдmmel" "lдmmeln" "lдmmlar" "lдmmlarna" ;
  laemmelaar_nn_1 = mkN "lдmmelеr" neutrum ;
  laemmeltaag_nn_1 = mkN "lдmmeltеg" neutrum ;
  laemning_nn_1 = mkN "lдmning" ;
  laempare_nn_1 = mkN "lдmpare" "lдmpare" ;
  laemplig_av_1 = mkA "lдmplig" ;
  laempligen_ab_1 = mkAdv "lдmpligen" ;
  laemplighet_nn_1 = mkN "lдmplighet" "lдmpligheter" ;
  laemplighetsintyg_nn_1 = mkN "lдmplighetsintyg" neutrum ;
  laen_nn_1 = mkN "lдn" neutrum ;
  laend_nn_1 = mkN "lдnd" "lдnder" ;
  laenderval_nn_1 = mkN "lдnderval" neutrum ;
  laengd_nn_1 = mkN "lдngd" "lдngder" ;
  laengdaxel_nn_1 = mkN "lдngdaxel" ;
  laengdenhet_nn_1 = mkN "lдngdenhet" "lдngdenheter" ;
  laengdgrad_nn_1 = mkN "lдngdgrad" "lдngdgrader" ;
  laengdhopp_nn_1 = mkN "lдngdhopp" neutrum ;
  laengdhoppare_nn_1 = mkN "lдngdhoppare" "lдngdhoppare" ;
  laengdloepning_nn_1 = mkN "lдngdlцpning" ;
  laengdmaatt_nn_1 = mkN "lдngdmеtt" neutrum ;
  laengdmarkering_nn_1 = mkN "lдngdmarkering" ;
  laengdmeter_nn_1 = mkN "lдngdmeter" "lдngdmetern" "lдngdmeter" "lдngdmeterna" ;
  laengdprofil_nn_1 = mkN "lдngdprofil" "lдngdprofiler" ;
  laengdriktning_nn_1 = mkN "lдngdriktning" ;
  laengdsnitt_nn_1 = mkN "lдngdsnitt" neutrum ;
  laengdstreck_nn_1 = mkN "lдngdstreck" neutrum ;
  laengdtecken_nn_1 = mkN "lдngdtecken" "lдngdtecknet" "lдngdtecken" "lдngdtecknen" ;
  laengdutvidgning_nn_1 = mkN "lдngdutvidgning" ;
  laenge_ab_1 = mkAdv "lдnge" ;
  laengesedan_ab_1 = mkAdv "lдngesedan" ;
  laengs_ab_1 = mkAdv "lдngs" ;
  laengsdal_nn_1 = mkN "lдngsdal" ;
  laengsgaaende_av_1 = mkA "lдngsgеende" ;
  laengstfoerfluten_av_1 = mkA "lдngstfцrfluten" "lдngstfцrflutet" ;
  laengtansfull_av_1 = mkA "lдngtansfull" ;
  laenk_nn_1 = mkN "lдnk" ;
  laenkroerelse_nn_1 = mkN "lдnkrцrelse" "lдnkrцrelser" ;
  laenkstation_nn_1 = mkN "lдnkstation" "lдnkstationer" ;
  laens_av_1 = mkA "lдns" ;
  laens_nn_1 = mkN "lдns" ;
  laensaaklagare_nn_1 = mkN "lдnsеklagare" "lдnsеklagare" ;
  laensarbetsdirektoer_nn_1 = mkN "lдnsarbetsdirektцr" "lдnsarbetsdirektцrer" ;
  laensarbetsnaemnd_nn_1 = mkN "lдnsarbetsnдmnd" "lдnsarbetsnдmnder" ;
  laensarkitekt_nn_1 = mkN "lдnsarkitekt" "lдnsarkitekter" ;
  laensbeteckning_nn_1 = mkN "lдnsbeteckning" ;
  laensbokstav_nn_1 = mkN "lдnsbokstav" "lдnsbokstдver" ;
  laensherre_nn_1 = mkN "lдnsherre" utrum ;
  laenskod_nn_1 = mkN "lдnskod" "lдnskoder" ;
  laenslasarett_nn_1 = mkN "lдnslasarett" neutrum ;
  laensman_nn_1 = mkN "lдnsman" "lдnsmannen" "lдnsmдn" "lдnsmдnnen" ;
  laenspump_nn_1 = mkN "lдnspump" ;
  laensraad_nn_1 = mkN "lдnsrеd" neutrum ;
  laensraett_nn_1 = mkN "lдnsrдtt" "lдnsrдtter" ;
  laensresidens_nn_1 = mkN "lдnsresidens" neutrum ;
  laensskatteraett_nn_1 = mkN "lдnsskatterдtt" "lдnsskatterдtter" ;
  laensskolnaemnd_nn_1 = mkN "lдnsskolnдmnd" "lдnsskolnдmnder" ;
  laensstyrelse_nn_1 = mkN "lдnsstyrelse" "lдnsstyrelser" ;
  laenstol_nn_1 = mkN "lдnstol" ;
  laensvaeg_nn_1 = mkN "lдnsvдg" ;
  laensvis_ab_1 = mkAdv "lдnsvis" ;
  laentagare_nn_1 = mkN "lдntagare" "lдntagare" ;
  laepp_nn_1 = mkN "lдpp" ;
  laeppljud_nn_1 = mkN "lдppljud" neutrum ;
  laepproerelse_nn_1 = mkN "lдpprцrelse" "lдpprцrelser" ;
  laeppsmink_nn_1 = mkN "lдppsmink" "lдppsminket" "lдppsminker" "lдppsminkerna" ;
  laeppsnus_nn_1 = mkN "lдppsnus" "lдppsnuset" "lдppsnuser" "lдppsnuserna" ;
  laeppstift_nn_1 = mkN "lдppstift" neutrum ;
  laera_nn_1 = mkN "lдra" ;
  laeraktig_av_1 = mkA "lдraktig" ;
  laerare_nn_1 = mkN "lдrare" "lдrare" ;
  laerarfortbildning_nn_1 = mkN "lдrarfortbildning" ;
  laerarinna_nn_1 = mkN "lдrarinna" ;
  laerarkandidat_nn_1 = mkN "lдrarkandidat" "lдrarkandidater" ;
  laerarledd_av_1 = mkA "lдrarledd" ;
  laerarlinje_nn_1 = mkN "lдrarlinje" "lдrarlinjer" ;
  laerarloes_av_1 = mkA "lдrarlцs" ;
  laerarroll_nn_1 = mkN "lдrarroll" "lдrarroller" ;
  laerarrum_nn_1 = mkN "lдrarrum" "lдrarrummet" "lдrarrum" "lдrarrummen" ;
  laerd_av_1 = mkA "lдrd" "lдrt" ;
  laerdom_nn_1 = mkN "lдrdom" ;
  laerdomsprov_nn_1 = mkN "lдrdomsprov" neutrum ;
  laerdomsstad_nn_1 = mkN "lдrdomsstad" "lдrdomsstдder" ;
  laerft_nn_1 = mkN "lдrft" "lдrfter" ;
  laerjunge_nn_1 = mkN "lдrjunge" utrum ;
  laerk_nn_1 = mkN "lдrk" ;
  laerkfalk_nn_1 = mkN "lдrkfalk" ;
  laerktraed_nn_1 = mkN "lдrktrдd" neutrum ;
  laerkvinge_nn_1 = mkN "lдrkvinge" utrum ;
  laerling_nn_1 = mkN "lдrling" ;
  laeroaar_nn_1 = mkN "lдroеr" neutrum ;
  laeroaemne_nn_1 = mkN "lдroдmne" ;
  laeroanstalt_nn_1 = mkN "lдroanstalt" "lдroanstalter" ;
  laerobok_nn_1 = mkN "lдrobok" "lдrobцcker" ;
  laeroboksnaemnd_nn_1 = mkN "lдroboksnдmnd" "lдroboksnдmnder" ;
  laerobokssats_nn_1 = mkN "lдrobokssats" "lдrobokssatser" ;
  laerobyggnad_nn_1 = mkN "lдrobyggnad" "lдrobyggnader" ;
  laerodikt_nn_1 = mkN "lдrodikt" "lдrodikter" ;
  laerofader_nn_1 = mkN "lдrofader" "lдrofadern" "lдrofдder" "lдrofдderna" ;
  laeromaestare_nn_1 = mkN "lдromдstare" "lдromдstare" ;
  laeromedel_nn_1 = mkN "lдromedel" neutrum ;
  laeromedelspaket_nn_1 = mkN "lдromedelspaket" neutrum ;
  laeroplan_nn_1 = mkN "lдroplan" "lдroplaner" ;
  laerorik_av_1 = mkA "lдrorik" ;
  laerosaete_nn_1 = mkN "lдrosдte" ;
  laerosal_nn_1 = mkN "lдrosal" ;
  laerosats_nn_1 = mkN "lдrosats" "lдrosatser" ;
  laerospaan_nn_1 = mkN "lдrospеn" neutrum ;
  laerostol_nn_1 = mkN "lдrostol" ;
  laeroverk_nn_1 = mkN "lдroverk" neutrum ;
  laerpeng_nn_1 = mkN "lдrpeng" ;
  laesaar_nn_1 = mkN "lдsеr" neutrum ;
  laesaemne_nn_1 = mkN "lдsдmne" ;
  laesapparat_nn_1 = mkN "lдsapparat" "lдsapparater" ;
  laesare_nn_1 = mkN "lдsare" "lдsare" ;
  laesart_nn_1 = mkN "lдsart" "lдsarter" ;
  laesbar_av_1 = mkA "lдsbar" ;
  laesbarhet_nn_1 = mkN "lдsbarhet" "lдsbarheter" ;
  laesbarhetsindex_nn_1 = mkN "lдsbarhetsindex" neutrum ;
  laesbarn_nn_1 = mkN "lдsbarn" neutrum ;
  laesbegaavning_nn_1 = mkN "lдsbegеvning" ;
  laesdag_nn_1 = mkN "lдsdag" ;
  laesdrama_nn_1 = mkN "lдsdrama" "lдsdramat" "lдsdraman" "lдsdramana" ;
  laesebok_nn_1 = mkN "lдsebok" "lдsebцcker" ;
  laesecirkel_nn_1 = mkN "lдsecirkel" ;
  laesekrets_nn_1 = mkN "lдsekrets" ;
  laesesal_nn_1 = mkN "lдsesal" ;
  laesfaerdighet_nn_1 = mkN "lдsfдrdighet" "lдsfдrdigheter" ;
  laesglas_nn_1 = mkN "lдsglas" neutrum ;
  laeshuvud_nn_1 = mkN "lдshuvud" "lдshuvudet" "lдshuvuden" "lдshuvudena" ;
  laesida_nn_1 = mkN "lдsida" ;
  laesion_nn_1 = mkN "lдsion" "lдsioner" ;
  laesk_nn_1 = mkN "lдsk" "lдsken" "lдsk" "lдsken" ;
  laeskamrat_nn_1 = mkN "lдskamrat" "lдskamrater" ;
  laeskedryck_nn_1 = mkN "lдskedryck" "lдskedrycker" ;
  laeskig_av_1 = mkA "lдskig" ;
  laesklass_nn_1 = mkN "lдsklass" "lдsklasser" ;
  laesklinik_nn_1 = mkN "lдsklinik" "lдskliniker" ;
  laeskpapper_nn_1 = mkN "lдskpapper" neutrum ;
  laeskstaang_nn_1 = mkN "lдskstеng" "lдskstдnger" ;
  laeskunnig_av_1 = mkA "lдskunnig" ;
  laeskunnighet_nn_1 = mkN "lдskunnighet" "lдskunnigheter" ;
  laeslig_av_1 = mkA "lдslig" ;
  laesning_nn_1 = mkN "lдsning" ;
  laespljud_nn_1 = mkN "lдspljud" neutrum ;
  laespraest_nn_1 = mkN "lдsprдst" "lдsprдster" ;
  laesrum_nn_1 = mkN "lдsrum" "lдsrummet" "lдsrum" "lдsrummen" ;
  laessvaarighet_nn_1 = mkN "lдssvеrighet" "lдssvеrigheter" ;
  laessvag_av_1 = mkA "lдssvag" ;
  laest_nn_1 = mkN "lдst" "lдster" ;
  laestadian_nn_1 = mkN "lдstadian" "lдstadianer" ;
  laestadianism_nn_1 = mkN "lдstadianism" "lдstadianismer" ;
  laestblock_nn_1 = mkN "lдstblock" neutrum ;
  laesuttal_nn_1 = mkN "lдsuttal" "lдsuttalet" "lдsuttalen" "lдsuttalena" ;
  laesvaerd_av_1 = mkA "lдsvдrd" "lдsvдrt" ;
  laesvaerde_nn_1 = mkN "lдsvдrde" ;
  laete_nn_1 = mkN "lдte" ;
  laett_av_1 = mkA "lдtt" ;
  laettantaendlig_av_1 = mkA "lдttantдndlig" ;
  laettbegriplig_av_1 = mkA "lдttbegriplig" ;
  laetteligen_ab_1 = mkAdv "lдtteligen" ;
  laettfaangen_av_1 = mkA "lдttfеngen" "lдttfеnget" ;
  laettfaerdig_av_1 = mkA "lдttfдrdig" ;
  laettfattlig_av_1 = mkA "lдttfattlig" ;
  laettflyktig_av_1 = mkA "lдttflyktig" ;
  laettflytande_av_1 = mkA "lдttflytande" ;
  laettfoerklarlig_av_1 = mkA "lдttfцrklarlig" ;
  laettfoerstaaelig_av_1 = mkA "lдttfцrstеelig" ;
  laettfoertjaent_av_1 = mkA "lдttfцrtjдnt" "lдttfцrtjдnt" ;
  laettframkomlig_av_1 = mkA "lдttframkomlig" ;
  laettfunnen_av_1 = mkA "lдttfunnen" "lдttfunnet" "lдttfunna" "lдttfunna" "lдttfunnare" "lдttfunnast" "lдttfunnaste" ;
  laettgrogg_nn_1 = mkN "lдttgrogg" ;
  laetthanterlig_av_1 = mkA "lдtthanterlig" ;
  laetthet_nn_1 = mkN "lдtthet" "lдttheter" ;
  laettillgaenglig_av_1 = mkA "lдttillgдnglig" ;
  laetting_nn_1 = mkN "lдtting" ;
  laettjefull_av_1 = mkA "lдttjefull" ;
  laettjord_nn_1 = mkN "lдttjord" ;
  laettklaedd_av_1 = mkA "lдttklдdd" "lдttklдdtt" ;
  laettkloev_nn_1 = mkN "lдttklцv" ;
  laettkoept_av_1 = mkA "lдttkцpt" "lдttkцpt" ;
  laettkokt_av_1 = mkA "lдttkokt" "lдttkokt" ;
  laettlaest_av_1 = mkA "lдttlдst" "lдttlдst" ;
  laettledd_av_1 = mkA "lдttledd" ;
  laettloeslig_av_1 = mkA "lдttlцslig" ;
  laettloest_av_1 = mkA "lдttlцst" "lдttlцst" ;
  laettmargarin_nn_1 = mkN "lдttmargarin" "lдttmargarinet" "lдttmargariner" "lдttmargarinerna" ;
  laettmatros_nn_1 = mkN "lдttmatros" "lдttmatroser" ;
  laettmetall_nn_1 = mkN "lдttmetall" "lдttmetaller" ;
  laettnad_nn_1 = mkN "lдttnad" "lдttnader" ;
  laettoel_nn_1 = mkN "lдttцl" neutrum ;
  laettoeverskaadlig_av_1 = mkA "lдttцverskеdlig" ;
  laettretlig_av_1 = mkA "lдttretlig" ;
  laettroekt_av_1 = mkA "lдttrцkt" "lдttrцkt" ;
  laettroerd_av_1 = mkA "lдttrцrd" "lдttrцrt" ;
  laettroerlig_av_1 = mkA "lдttrцrlig" ;
  laettrogen_av_1 = mkA "lдttrogen" "lдttroget" ;
  laettsam_av_1 = mkA "lдttsam" "lдttsamt" "lдttsamma" "lдttsamma" "lдttsammare" "lдttsammast" "lдttsammaste" ;
  laettsinnig_av_1 = mkA "lдttsinnig" ;
  laettskoett_av_1 = mkA "lдttskцtt" ;
  laettskraemd_av_1 = mkA "lдttskrдmd" "lдttskrдmt" ;
  laettsmaelt_av_1 = mkA "lдttsmдlt" "lдttsmдlt" ;
  laettstekt_av_1 = mkA "lдttstekt" "lдttstekt" ;
  laettstoett_av_1 = mkA "lдttstцtt" ;
  laettvattenreaktor_nn_1 = mkN "lдttvattenreaktor" "lдttvattenreaktorer" ;
  laettviktare_nn_1 = mkN "lдttviktare" "lдttviktare" ;
  laettviktig_av_1 = mkA "lдttviktig" ;
  laettviktsmotorcykel_nn_1 = mkN "lдttviktsmotorcykel" ;
  laettvin_nn_1 = mkN "lдttvin" "lдttvinet" "lдttviner" "lдttvinerna" ;
  laettvindig_av_1 = mkA "lдttvindig" ;
  laettvunnen_av_1 = mkA "lдttvunnen" "lдttvunnet" "lдttvunna" "lдttvunna" "lдttvunnare" "lдttvunnast" "lдttvunnaste" ;
  laexfoerhoer_nn_1 = mkN "lдxfцrhцr" neutrum ;
  lafsig_av_1 = mkA "lafsig" ;
  lag_nn_1 = mkN "lag" ;
  lag_nn_2 = mkN "lag" neutrum ;
  laga_av_1 = mkA "laga" ;
  lagaard_nn_1 = mkN "lagеrd" ;
  lagbalk_nn_1 = mkN "lagbalk" ;
  lagberedning_nn_1 = mkN "lagberedning" ;
  lagbok_nn_1 = mkN "lagbok" "lagbцcker" ;
  lagbunden_av_1 = mkA "lagbunden" "lagbundet" ;
  lagd_av_1 = mkA "lagd" "lagt" ;
  lagenlig_av_1 = mkA "lagenlig" ;
  lager_nn_1 = mkN "lager" neutrum ;
  lager_nn_2 = mkN "lager" ;
  lager_nn_3 = mkN "lager" "lagern" "lager" "lagerna" ;
  lagerbaersblad_nn_1 = mkN "lagerbдrsblad" neutrum ;
  lagerblad_nn_1 = mkN "lagerblad" neutrum ;
  lagerbok_nn_1 = mkN "lagerbok" "lagerbцcker" ;
  lagerbox_nn_1 = mkN "lagerbox" ;
  lagerfoeljd_nn_1 = mkN "lagerfцljd" "lagerfцljder" ;
  lagergaang_nn_1 = mkN "lagergеng" ;
  lagerkostnad_nn_1 = mkN "lagerkostnad" "lagerkostnader" ;
  lagerkrans_nn_1 = mkN "lagerkrans" ;
  lageroel_nn_1 = mkN "lagerцl" neutrum ;
  lagerserie_nn_1 = mkN "lagerserie" "lagerserier" ;
  lagfaangen_av_1 = mkA "lagfеngen" "lagfеnget" ;
  lagfara_vb_1 = mkV "lagfara" "lagfor" "lagfarit" ;
  lagfaren_av_1 = mkA "lagfaren" "lagfaret" ;
  lagfart_nn_1 = mkN "lagfart" "lagfarter" ;
  lagfoerslag_nn_1 = mkN "lagfцrslag" neutrum ;
  lagg_nn_1 = mkN "lagg" ;
  laggband_nn_1 = mkN "laggband" neutrum ;
  laggdike_nn_1 = mkN "laggdike" ;
  laggkaerl_nn_1 = mkN "laggkдrl" neutrum ;
  lagisk_av_1 = mkA "lagisk" ;
  lagkapp_nn_1 = mkN "lagkapp" "lagkapper" ;
  lagkappsimning_nn_1 = mkN "lagkappsimning" ;
  lagkapten_nn_1 = mkN "lagkapten" "lagkaptener" ;
  lagkarl_nn_1 = mkN "lagkarl" ;
  lagklok_av_1 = mkA "lagklok" ;
  lagledare_nn_1 = mkN "lagledare" "lagledare" ;
  laglig_av_1 = mkA "laglig" ;
  lagligen_ab_1 = mkAdv "lagligen" ;
  lagloes_av_1 = mkA "laglцs" ;
  lagloeshet_nn_1 = mkN "laglцshet" "laglцsheter" ;
  laglott_nn_1 = mkN "laglott" "laglotter" ;
  laglydig_av_1 = mkA "laglydig" ;
  lagman_nn_1 = mkN "lagman" "lagmannen" "lagmдn" "lagmдnnen" ;
  lagn_nn_1 = mkN "lagn" neutrum ;
  lagom_ab_1 = mkAdv "lagom" ;
  lagom_av_1 = mkA "lagom" ;
  lagraad_nn_1 = mkN "lagrеd" neutrum ;
  lagring_nn_1 = mkN "lagring" ;
  lagringsfoerlust_nn_1 = mkN "lagringsfцrlust" "lagringsfцrluster" ;
  lagringskostnad_nn_1 = mkN "lagringskostnad" "lagringskostnader" ;
  lagrum_nn_1 = mkN "lagrum" "lagrummet" "lagrum" "lagrummen" ;
  lagsaga_nn_1 = mkN "lagsaga" ;
  lagskipning_nn_1 = mkN "lagskipning" ;
  lagspel_nn_1 = mkN "lagspel" "lagspelet" "lagspel" "lagspelen" ;
  lagspraak_nn_1 = mkN "lagsprеk" neutrum ;
  lagstiftare_nn_1 = mkN "lagstiftare" "lagstiftare" ;
  lagstiftning_nn_1 = mkN "lagstiftning" ;
  lagstridig_av_1 = mkA "lagstridig" ;
  lagtempo_nn_1 = mkN "lagtempo" "lagtempot" "lagtempon" "lagtempona" ;
  lagtempolopp_nn_1 = mkN "lagtempolopp" neutrum ;
  lagtext_nn_1 = mkN "lagtext" "lagtexter" ;
  lagtima_av_1 = mkA "lagtima" ;
  lagun_nn_1 = mkN "lagun" "laguner" ;
  lagunsjoe_nn_1 = mkN "lagunsjц" ;
  lagutskott_nn_1 = mkN "lagutskott" neutrum ;
  lagvigd_av_1 = mkA "lagvigd" "lagvigt" ;
  lagvraengare_nn_1 = mkN "lagvrдngare" "lagvrдngare" ;
  lagvunnen_av_1 = mkA "lagvunnen" "lagvunnet" "lagvunna" "lagvunna" "lagvunnare" "lagvunnast" "lagvunnaste" ;
  lakan_nn_1 = mkN "lakan" neutrum ;
  lakanspaase_nn_1 = mkN "lakanspеse" utrum ;
  lakansspets_nn_1 = mkN "lakansspets" ;
  lake_nn_1 = mkN "lake" utrum ;
  lakej_nn_1 = mkN "lakej" "lakejer" ;
  lakonisk_av_1 = mkA "lakonisk" ;
  lakonism_nn_1 = mkN "lakonism" "lakonismer" ;
  lakritsrot_nn_1 = mkN "lakritsrot" "lakritsrцtter" ;
  laktalbumin_nn_1 = mkN "laktalbumin" "laktalbuminer" ;
  laktation_nn_1 = mkN "laktation" "laktationer" ;
  laktovegetarian_nn_1 = mkN "laktovegetarian" "laktovegetarianer" ;
  lakun_nn_1 = mkN "lakun" "lakuner" ;
  lam_av_1 = mkA "lam" ;
  lama_nn_3 = mkN "lama" ;
  lamadjur_nn_1 = mkN "lamadjur" neutrum ;
  lame_nn_1 = mkN "lamй" "lamйer" ;
  lamell_nn_1 = mkN "lamell" "lameller" ;
  lamellhus_nn_1 = mkN "lamellhus" neutrum ;
  lamellkoppling_nn_1 = mkN "lamellkoppling" ;
  lamentation_nn_1 = mkN "lamentation" "lamentationer" ;
  laminaer_av_1 = mkA "laminдr" ;
  laminat_nn_1 = mkN "laminat" neutrum ;
  lamm_nn_1 = mkN "lamm" neutrum ;
  lammsadel_nn_1 = mkN "lammsadel" ;
  lammskinn_nn_1 = mkN "lammskinn" neutrum ;
  lammunge_nn_1 = mkN "lammunge" utrum ;
  lampett_nn_1 = mkN "lampett" "lampetter" ;
  lampfot_nn_1 = mkN "lampfot" "lampfцtter" ;
  lamphaallare_nn_1 = mkN "lamphеllare" "lamphеllare" ;
  lampskaerm_nn_1 = mkN "lampskдrm" ;
  lan_nn_1 = mkN "lan" "laner" ;
  land_nn_1 = mkN "land" "landet" "lдnder" "lдnderna" ;
  land_nn_2 = mkN "land" neutrum ;
  landaa_nn_1 = mkN "landе" "landеer" ;
  landamaere_nn_1 = mkN "landamдre" ;
  landbo_nn_1 = mkN "landbo" "landbor" ;
  landborg_nn_1 = mkN "landborg" ;
  landbris_nn_1 = mkN "landbris" ;
  landdriven_av_1 = mkA "landdriven" "landdrivet" ;
  landgaang_nn_1 = mkN "landgеng" ;
  landhoejning_nn_1 = mkN "landhцjning" ;
  landis_nn_1 = mkN "landis" ;
  landkaenning_nn_1 = mkN "landkдnning" ;
  landledes_ab_1 = mkAdv "landledes" ;
  landmaerke_nn_1 = mkN "landmдrke" ;
  landning_nn_1 = mkN "landning" ;
  landningsfoerbud_nn_1 = mkN "landningsfцrbud" neutrum ;
  landningshjul_nn_1 = mkN "landningshjul" neutrum ;
  landningsmaerke_nn_1 = mkN "landningsmдrke" ;
  landningsstaell_nn_1 = mkN "landningsstдll" neutrum ;
  landnot_nn_1 = mkN "landnot" ;
  landomraade_nn_1 = mkN "landomrеde" ;
  landrygg_nn_1 = mkN "landrygg" ;
  landsaenda_nn_1 = mkN "landsдnda" "landsдndan" "landsдndar" "landsдndarna" ;
  landsaettning_nn_1 = mkN "landsдttning" ;
  landsantikvarie_nn_1 = mkN "landsantikvarie" "landsantikvarier" ;
  landsarkiv_nn_1 = mkN "landsarkiv" neutrum ;
  landsarkivarie_nn_1 = mkN "landsarkivarie" "landsarkivarier" ;
  landsdel_nn_1 = mkN "landsdel" "landsdelen" "landsdelar" "landsdelarna" ;
  landsfader_nn_1 = mkN "landsfader" "landsfadern" "landsfдder" "landsfдderna" ;
  landsfiskal_nn_1 = mkN "landsfiskal" "landsfiskaler" ;
  landsflyktig_av_1 = mkA "landsflyktig" ;
  landsfoerraedare_nn_1 = mkN "landsfцrrдdare" "landsfцrrдdare" ;
  landsfoerraederi_nn_1 = mkN "landsfцrrдderi" "landsfцrrдderit" "landsfцrrдderier" "landsfцrrдderierna" ;
  landsfoervisning_nn_1 = mkN "landsfцrvisning" ;
  landsfogde_nn_1 = mkN "landsfogde" utrum ;
  landshoevding_nn_1 = mkN "landshцvding" ;
  landshoevdingehus_nn_1 = mkN "landshцvdingehus" neutrum ;
  landskamp_nn_1 = mkN "landskamp" "landskamper" ;
  landskansli_nn_1 = mkN "landskansli" "landskanslit" "landskanslier" "landskanslierna" ;
  landskap_nn_1 = mkN "landskap" "landskapet" "landskapen" "landskapena" ;
  landskapslag_nn_1 = mkN "landskapslag" ;
  landskapsvapen_nn_1 = mkN "landskapsvapen" "landskapsvapnet" "landskapsvapen" "landskapsvapnen" ;
  landsknekt_nn_1 = mkN "landsknekt" ;
  landskommun_nn_1 = mkN "landskommun" "landskommuner" ;
  landslag_nn_1 = mkN "landslag" neutrum ;
  landslag_nn_2 = mkN "landslag" ;
  landsmaal_nn_1 = mkN "landsmеl" neutrum ;
  landsmaalsalfabet_nn_1 = mkN "landsmеlsalfabet" neutrum ;
  landsman_nn_1 = mkN "landsman" "landsmannen" "landsmдn" "landsmдnnen" ;
  landsnummer_nn_1 = mkN "landsnummer" neutrum ;
  landsomfattande_av_1 = mkA "landsomfattande" ;
  landsortsstad_nn_1 = mkN "landsortsstad" "landsortsstдder" ;
  landsplaaga_nn_1 = mkN "landsplеga" ;
  landssekretariat_nn_1 = mkN "landssekretariat" neutrum ;
  landstiga_vb_1 = mkV "landstiga" "landsteg" "landstigit" ;
  landstigning_nn_1 = mkN "landstigning" ;
  landstigningsbaat_nn_1 = mkN "landstigningsbеt" ;
  landsting_nn_1 = mkN "landsting" neutrum ;
  landstingsdirektoer_nn_1 = mkN "landstingsdirektцr" "landstingsdirektцrer" ;
  landstingsfoerbund_nn_1 = mkN "landstingsfцrbund" neutrum ;
  landstingskatalog_nn_1 = mkN "landstingskatalog" "landstingskataloger" ;
  landstingskommun_nn_1 = mkN "landstingskommun" "landstingskommuner" ;
  landstingsman_nn_1 = mkN "landstingsman" "landstingsmannen" "landstingsmдn" "landstingsmдnnen" ;
  landstingsraad_nn_1 = mkN "landstingsrеd" neutrum ;
  landstrykare_nn_1 = mkN "landstrykare" "landstrykare" ;
  landsvaeg_nn_1 = mkN "landsvдg" ;
  landsvaegsbuss_nn_1 = mkN "landsvдgsbuss" ;
  landsvaegsriddare_nn_1 = mkN "landsvдgsriddare" "landsvдgsriddare" ;
  landtunga_nn_1 = mkN "landtunga" ;
  landvad_nn_1 = mkN "landvad" ;
  landvind_nn_1 = mkN "landvind" ;
  landvinning_nn_1 = mkN "landvinning" ;
  langare_nn_1 = mkN "langare" "langare" ;
  langarn_nn_1 = mkN "langarn" "langarnet" "langarner" "langarnerna" ;
  langett_nn_1 = mkN "langett" "langetter" ;
  langettstygn_nn_1 = mkN "langettstygn" neutrum ;
  langobard_nn_1 = mkN "langobard" "langobarder" ;
  langust_nn_1 = mkN "langust" "languster" ;
  lankes_nn_1 = mkN "lankes" "lankeser" ;
  lans_nn_1 = mkN "lans" ;
  lansett_nn_1 = mkN "lansett" "lansetter" ;
  lansettfisk_nn_1 = mkN "lansettfisk" ;
  lansiaer_nn_1 = mkN "lansiдr" "lansiдrer" ;
  lantarbetare_nn_1 = mkN "lantarbetare" "lantarbetare" ;
  lantbrevbaerare_nn_1 = mkN "lantbrevbдrare" "lantbrevbдrare" ;
  lantbruk_nn_1 = mkN "lantbruk" neutrum ;
  lantbrukare_nn_1 = mkN "lantbrukare" "lantbrukare" ;
  lantbruksdirektoer_nn_1 = mkN "lantbruksdirektцr" "lantbruksdirektцrer" ;
  lantbruksfoerbund_nn_1 = mkN "lantbruksfцrbund" neutrum ;
  lantbrukskonsulent_nn_1 = mkN "lantbrukskonsulent" "lantbrukskonsulenter" ;
  lantbruksnaemnd_nn_1 = mkN "lantbruksnдmnd" "lantbruksnдmnder" ;
  lantbruksstyrelse_nn_1 = mkN "lantbruksstyrelse" "lantbruksstyrelser" ;
  lantbruksuniversitet_nn_1 = mkN "lantbruksuniversitet" neutrum ;
  lantdag_nn_1 = mkN "lantdag" ;
  lantegendom_nn_1 = mkN "lantegendom" ;
  lanternin_nn_1 = m