--# -path=.:prelude

concrete LexiconIna of Lexicon = CatIna ** 
  open (R=ResIna), ParadigmsIna, IrregIna, Prelude in {

  flags 
    optimize=values ;

  lin
    airplane_N = regN "avion";
    answer_V2S = prepV2 aP (regV "responder");
    apartment_N = regN "appartamento";
    apple_N = regN "pomo";
    art_N = regN "arte" ;
    ask_V2Q = mkV2Q aP (regV "demandar") ;
    baby_N = regN "bebe" ;
    bad_A = regA "mal";
    bank_N = regN "banca" ;
    beautiful_A = regA "belle" ;
    become_VA = mkVA (regV "devenir") ;
    beer_N = regN "bira" ;
    beg_V2V = mkV2V noPrep aP (regV "rogar") ;
    big_A = regA "magne" ;
    bike_N = regN "bicycletta" ;
    bird_N = regN "ave" ;
    black_A = regA "nigre" ;
    blue_A = regA "blau" ;
    boat_N = regN "barca" ;
    book_N = regN "libro" ;
    boot_N = regN "botta";
    boss_N = regN "chef"  ;
    boy_N = regN "puero"  ;
    bread_N = regN "pan"  ;
    break_V2 = dirV2 (regV "rumper") ;
    broad_A = regA "large" ;
    brother_N2 = regN2 "fratre";
    brown_A = regA "brun" ;
    butter_N = regN "butyro" ;
    buy_V2 = dirV2 (regV "compra");
    camera_N = compN (regN "apparato" ) ["photographic"] ;
    cap_N = regN "bonetto"  ;
    car_N = regN "automobile"  ;
    carpet_N = regN "tapete"  ;
    cat_N = regN "catto"  ;
    ceiling_N = regN "tecto" ; -- of room ???
    chair_N = regN "sede";
    cheese_N = regN "caseo";
    child_N = regN "infante"  ;
    church_N = regN "ecclesia" ;
    city_N = regN "urbe"  ; -- ??? citate
    clean_A = regA "munde" ;
    clever_A = regA "intelligente" ;
    close_V2 = dirV2 (regV "clauder") ;
    coat_N = regN "mantello"  ;
    cold_A = regA "frigide" ;
    come_V = regV "venir" ;
    computer_N = regN "computator"   ;
    country_N = regN "pais"  ;
    cousin_N = regN "cosino"  ; ---- cosina
    cow_N = regN "vacca"  ;
    die_V = regV "morir" ;
    dirty_A = regA "immunde" ;
    distance_N3 = prepN3 aP (prepN2 deP (regN "distantia")) ; --- ??? wtf
    doctor_N = regN "medico";
    dog_N = regN "can";
    door_N = regN "porta";
    drink_V2 = dirV2 (regV "biber");
    easy_A2V = mkA2V (regA "facile") aP ;
    eat_V2 = dirV2 (regV "eder");
    empty_A = regA "vacue" ;
    enemy_N = regN "inimico" ;
    factory_N = regN "fabrica" ;
    father_N2 = regN2 "patre" ;
    fear_VS = mkVS (regV "timer") ;
    find_V2 = dirV2 (regV "trovar") ;
    fish_N = regN "pisce" ;
    floor_N = regN "pavimento" ;
    forget_V2 = dirV2 (regV "oblidar");
    fridge_N = regN "refrigerator";
    friend_N = regN "amico" ;
    fruit_N = regN "fructo" ;
    fun_AV = mkAV (regA "famusante") ;
    garden_N = regN "horto" ;
    girl_N = regN "puera" ;
    glove_N = regN "guanto" ;
    go_V = regV "ir";
    gold_N = regN "auro" ;
    good_A = R.mkAdjective "bon" "melior" "optime";
    green_A = regA "verde" ;
    harbour_N = regN "porto" ;
    hate_V2 = dirV2 (regV "detestar0") ;
    hat_N = regN "cappello" ;
    hear_V2 = dirV2 (regV "audir");
    hill_N = regN "monticulo" ;
    hope_VS = mkVS (regV "sperar") ;
    horse_N = regN "cavallo" ;
    hot_A = regA "calide" ;
    house_N = regN "domo" ;
    important_A = regA "importante" ;
    industry_N = regN "industria" ;
    iron_N = regN "ferro" ;
    king_N = regN "rege" ;
    know_V2 = dirV2 (regV "cognoscer") ; -- ???
    lake_N = regN "laco" ;
    lamp_N = regN "lampa" ;
    learn_V2 = dirV2 (regV "apprender") ;
    leather_N = regN "corio" ;
    leave_V2 = prepV2 deP (regV "partir");
    like_V2 = dirV2 (regV "amar") ;
    listen_V2 = dirV2 (regV "ascoltar") ;
    live_V = (regV "vive") ;
    long_A = regA "longe" ;
    lose_V2 = dirV2 (regV "perder");
    love_N = regN "amor" ;
    love_V2 = dirV2 (regV "adorar") ;
    man_N = regN "viro";
    married_A2 = mkA2 (regA "sponsate") aP ;
    meat_N = regN "carne" ;
    milk_N = regN "lacte" ;
    moon_N = regN "luna" ;
    mother_N2 = regN2 "matre" ;
    mountain_N = regN "montania" ;
    music_N = regN "musica" ;
    narrow_A = regA "stricte" ;
    new_A = regA "nove" ;
    newspaper_N = regN "jornal" ;
    oil_N = regN "oleo" ;
    old_A = regA "vetule" ;
    open_V2 = dirV2 (regV "operir") ;
    paint_V2A = mkV2A noPrep inP (regV "pinger") ; -- ??? preposition might be wrong. (did not find a sample usage)
    paper_N = regN "papiro" ;
    paris_PN = regPN "Paris" ;
    peace_N = regN "pace" ;
    pen_N = regN "penna" ;
    planet_N = regN "planeta" ;
    plastic_N = regN "plastico" ;
    play_V2 = dirV2 (regV "sonar") ; -- ??? eg. play the piano
    policeman_N = regN "policero" ;
    priest_N = regN "prestre" ;
    probable_AS = mkAS (regA "probabile") ;
    queen_N = regN "regina" ;
  radio_N = regN "radio" ;
  rain_V0 = mkV0 (regV "pluvar") ;
  read_V2 = dirV2 (regV "leger");
  red_A = regA "rubie" ;
  religion_N = regN "religion" ;
  restaurant_N = regN "restaurant" ;
  river_N = regN "riviera" ;
  rock_N = regN "rocca" ;
  roof_N = regN "tecto" ;
  rubber_N = regN "cauchu" ;
  run_V = regV "currer";
  say_VS = mkVS (regV "dicer");
  school_N = regN "schola" ;
  science_N = regN "scientia";
  sea_N = regN "mar" ;
  seek_V2 = dirV2 (regV "cercar");
  see_V2 = dirV2 (regV "vider");
  sell_V3 = prepV3 aP (dirV2 (regV "vender"));
  send_V3 = prepV3 aP (dirV2 (regV "inviar"));
  sheep_N = regN "ove";
  ship_N = regN "nave" ;
  shirt_N = regN "camisa" ;
  shoe_N = regN "scapra" ;
  shop_N = regN "boteca" ;
  short_A = regA "curte" ;
  silver_N = regN "argento" ;
  sister_N = regN "soror" ;
  sleep_V = regV "dormir";
  small_A = regA "parve" ; -- !!! This one should be preferably a prefix adjective
  snake_N = regN "serpente" ;
  sock_N = regN "calcetta" ;
  speak_V2 = dirV2 (regV "parlar") ;-- ???
  star_N = regN "stella" ;
  steel_N = regN "aciero" ;
  stone_N = regN "petra" ;
  stove_N = regN "estufa" ;
  student_N = regN "studente" ;
  stupid_A = regA "nescie" ;
  sun_N = regN "sol" ;
  switch8off_V2 = dirV2 (regV "extinguer");
  switch8on_V2 = dirV2 (regV "accender") ;
  table_N = regN "tablula" ;
  talk_V3 = (prepV3 deP (prepV2 aP (regV "parlar"))) ;
  teacher_N = regN "professor" ;
  teach_V2 = dirV2 (regV "inseniar"); -- ??? aP (preposition is what?)
  television_N = regN "television" ;
  thick_A = regA "spisse" ;
  thin_A = regA "magre" ;
  train_N = regN "convoyo" ; -- ???
  travel_V = regV "viagiar" ;
  tree_N = regN "tarbore" ;
  ---- trousers_N = regN "pantalon" ; --- ??? funky plural in the Abstract lexicon...
  ugly_A = regA "ugly" ;
  understand_V2 = dirV2 (regV "comprender");
  university_N = regN "universitate" ;
  village_N = regN "village" ;
  wait_V2 = dirV2 (regV "wait") ;
  walk_V = (regV "ambular") ;
  warm_A = regA "calde" ;
  war_N = regN "guerra" ;
  watch_V2 = dirV2 (regV "spectar") ;
  water_N = regN "aqua" ;
  white_A = regA "albe" ;
  window_N = regN "fenestra" ;
  wine_N = regN "vino" ;
  win_V2 = dirV2 (regV "ganiar");
  woman_N = regN "femina";
  wonder_VQ = mkVQ (reflV (regV "demandar")) ;
  wood_N = regN "ligno"; -- or silva ...
  write_V2 = dirV2 (regV "scriber");
  yellow_A = regA "jalne" ;
  young_A = regA "juvene" ;

lin
  do_V2 = dirV2 (regV "facer");
  add_V3 = prepV3 aP (dirV2 (regV "additionar"));
  already_Adv = mkAdv "jam" ;
  animal_N = regN "animal" ; 
  ashes_N = regN "cinere" ; --  plural only???
  back_N = regN "dorso" ;
  bark_N = regN "cortice" ;
  belly_N = regN "ventre" ;
  bite_V2 = dirV2 (regV "morder");
  blood_N = regN "sanguine" ;
  blow_V = regV "sufflar";
  bone_N = regN "osso" ;
  breast_N = regN "pectore" ;
  breathe_V = dirV2 (regV "respirar") ;
  burn_V = regV "arder";
  cloud_N = regN "nube" ;
  correct_A = (regA "correcte") ;
  count_V2 = dirV2 (regV "numerar") ;
  cut_V2 = dirV2 (regV "secar");
  day_N = regN "die" ;
  dig_V = regV "fossar";
  dry_A = regA "sic" ;
  dull_A = regA "enoiose" ;
  dust_N = regN "pulvere" ;
  ear_N = regN "aure" ;
  earth_N = regN "terra" ;
  egg_N = regN "ovo" ;
  eye_N = regN "oculo" ;
  fall_V = regV "cader" ;
  far_Adv = mkAdv "lontano" ;
  fat_N = regN "grasse" ;
  fear_V2 = dirV2 (regV "timer") ;
  feather_N = regN "pluma" ;
  fight_V2 = dirV2 (regV "combattar");
  fingernail_N = regN "ungual";
  fire_N = regN "foco" ;
  float_V = regV "flottar" ;
  flow_V = regV "flucto" ;
  flower_N = regN "flore" ;
  fly_V = regV "volar" ;
  fog_N = regN "bruma" ;
  foot_N = regN "pede";
  forest_N = regN "silva" ;
  freeze_V = regV "gelar";
  full_A = regA "plen" ;
  give_V3 = prepV3 aP (dirV2 (regV "dar")) ;
  grammar_N = regN "grammatica" ;
  grass_N = regN "herba" ;
  guts_N = regN "tripas" ; -- !!!: no singular
  hair_N = regN "pilo" ;
  hand_N = regN "mano" ;
  head_N = regN "capite" ;
  heart_N = regN "corde" ;
  heavy_A = regA "pesante" ;
  hit_V2 = dirV2 (regV "frappar") ;
  hold_V2 = dirV2 (regV "retener") ;
  horn_N = regN "corno" ;
  hunt_V2 = dirV2 (regV "chassar") ;
  husband_N = regN "sposo";
  ice_N = regN "glacie" ;
  john_PN = regPN "John" ;
  jump_V = regV "saltar" ;
  kill_V2 = dirV2 (regV "occider") ;
  knee_N = regN "genu" ;
  language_N = regN "linguage" ;
  laugh_V = regV "rider" ;
  leaf_N = regN "folio" ;
  left_Ord = ss "leve" ;
  leg_N = regN "gamba" ;
  lie_V = regV "mentir";
  liver_N = regN "hepate" ;
  louse_N = regN "pediculo";
  mouth_N = regN "bucca" ;
  name_N = regN "nomine" ;
  near_A = regA "proxime" ;
  neck_N = regN "collo" ;
  night_N = regN "nocte" ;
  nose_N = regN "naso" ;
  now_Adv = mkAdv "nunc" ;
  number_N = regN "numero" ;
  person_N = regN "homine" ;
  play_V = regV "jocar" ;
  pull_V2 = dirV2 (regV "traher") ;
  push_V2 = dirV2 (regV "pulsar") ;
  put_V2 = dirV2 (regV "placar");
  question_N = regN "question" ;
  rain_N = regN "pluvia" ;
  ready_A = regA "preste" ;
  reason_N = regN "ration" ;
  right_Ord = ss "dextra" ;
  road_N = regN "via" ;
  root_N = regN "radice" ;
  rope_N = regN "corda" ;
  rotten_A = (regA "corrupte") ;
  round_A = regA "ronde" ;
  rub_V2 = dirV2 (regV "fircar") ;
  rule_N = regN "regula" ;
  salt_N = regN "sal" ;
  sand_N = regN "sablo" ;
  scratch_V2 = dirV2 (regV "grattar") ;
  seed_N = regN "semine" ;
  sew_V = regV "suer";
  sharp_A = regA "trenchante" ;
  sing_V = regV "cantar";
  sit_V = regV "seder";
  skin_N = regN "pelle" ;
  sky_N = regN "celo" ;
  smell_V = regV "oler" ;
  smoke_N = regN "fumar" ;
  smooth_A = regA "lisie" ;
  snow_N = regN "niva" ;
  song_N = regN "canto" ;
  spit_V = regV "sputar";
  split_V2 = dirV2 (regV "finder");
  squeeze_V2 = dirV2 (regV "comprimer") ;
  stab_V2 = dirV2 (regV "dagar") ;
  stand_V = regV "star";
  stick_N = regN "baston" ;
  stop_V = regV "stoppar" ;
  straight_A = regA "directe" ;
  suck_V2 = dirV2 (regV "suger") ;
  swell_V = (regV "turger");
  swim_V = (regV "natada");
  tail_N = regN "cauda" ;
  think_V = regV "pensar";
  throw_V2 = dirV2 (regV "jectar") ;
  tie_V2 = dirV2 (regV "ligar") ;
  today_Adv = mkAdv "hodie" ;
  tongue_N = regN "lingua" ;
  tooth_N = regN "dente";
  turn_V = regV "tornar" ;
  uncertain_A = regA "incerte" ;
  vomit_V = regV "vomir" ;
  wash_V2 = dirV2 (regV "abluer") ;
  wet_A = regA "humid" ; ----
  wide_A = regA "large" ;
  wife_N = regN "sposa";
  wind_N = regN "vento" ;
  wing_N = regN "ala" ;
  wipe_V2 = dirV2 (regV "essugar") ;
  worm_N = regN "verme" ;
  year_N = regN "anno" ;
--  other_A = regA "altere" ;
---- added 4/6/2007
--
  oper
--  aboutP = mkPrep "about" ;
--  atP = mkPrep "at" ;
--  forP = mkPrep "for" ;
--  fromP = mkPrep "from" ;
    inP = mkPrep "in" accusative;
--  onP = mkPrep "on" ;
    aP = mkPrep "" dative;       -- can     generate clitics, fuses with the def. det. "le" 
    deP = mkPrep "" ablative;    -- can not generate clitics, fuses with the def. det. "le", pronoun form: "de mi".
} ;
