--# -path=.:prelude

concrete LexiconFin of Lexicon = CatFin ** open MorphoFin, ParadigmsFin in {

flags 
  optimize=values ;


lin
  airplane_N = mkN "lentokone" ;
  answer_V2S = mkV2 (mkV "vastata") (casePrep allative) ;
  apartment_N = mkN "asunto" ;
  apple_N = mkN "omena" ; --- omenia, not omenoita
  art_N = mkN "taide" ;
  ask_V2Q = mkV2 (mkV "kysy") (casePrep ablative) ;
  baby_N = mkN "vauva" ;
  bad_A = mkA (mkN "paha") "pahempi" "pahin" ;
  bank_N = mkN "pankki" ;
  beautiful_A = mkA (mkN "kaunis") "kauniimpi" "kaunein" ;
  become_VA = mkVA (mkV "tulla") (casePrep translative) ;
  beer_N = mkN "olut" "oluita" ;
  beg_V2V = mkV2V (mk2V "pyyt" "pyysi") (casePrep partitive) ;
  big_A = mkA (mkN "suuri" "suuria") "suurempi" "suurin" ;
  bike_N = mkN "polkupyr" ; --- for correct vowel harmony
  bird_N = mkN "lintu" ;
  black_A = mkA (mkN "musta") "mustempi" "mustin" ;
  blue_A = mkA (mkN "sininen") "sinisempi" "sinisin" ;
  boat_N = mkN "vene" ;
  book_N = mkN "kirja" ;
  boot_N = mkN "saapas" ;
  boss_N = mkN "pomo" ;
  boy_N = mkN "poika" "pojan" "poikia" ;
  bread_N = mkN "leip" ;
  break_V2 = mkV2 (mkV "rikkoa") ;
  broad_A = mkA (mkN "leve") "levempi" "levein" ;
  brother_N2 = mkN2 (
    mkN "veli" "veljen" "veljen" "velje" "veljeen" 
        "veljin" "veljiss" "veljien" "velji" "veljiin") ;
  brown_A = mkA (mkN "ruskea") "ruskeampi" "ruskein" ;
  butter_N = mk3N "voi" "voin" "voita" ;  ---- errors in Part
  buy_V2 = mkV2 (mkV "ostaa") ;
  camera_N = mkN "kamera" ;
  cap_N = mkN "lakki" ;
  car_N = mkN "auto" "auton" "autoja" ; -- mkN: audon
  carpet_N = mkN "matto" ;
  cat_N = mkN "kissa" ;
  ceiling_N = mkN "katto" ;
  chair_N = mkN "tuoli" ;
  cheese_N = mkN "juusto" ;
  child_N = mkN "lapsi" "lapsen" "lasta" "lapsena" "lapseen" 
              "lasten" "lapsia" "lapsina" "lapsissa" "lapsiin" ;
  church_N = mkN "kirkko" ;
  city_N = mkN "kaupunki" ;
  clean_A = mkA (mkN "puhdas") ;
  clever_A = mkA (mkN "viisas") ;
  close_V2 = mkV2 (mkV "sulkea") ;
  coat_N = mkN "takki" ;
  cold_A = mkA (mkN "kylm") "kylmempi" "kylmin" ;
  come_V = mkV "tulla" ;
  computer_N = mkN "tietokone" ;
  country_N = mkN "maa" ;
  cousin_N = mkN "serkku" ;
  cow_N = mkN "lehm" ;
  die_V = mkV "kuolla" ;
  dirty_A = mkA (mkN "likainen") "likaisempi" "likaisin" ;
  distance_N3 = mkN3 (mkN "etisyys") (casePrep elative) (casePrep illative) ;
  doctor_N = mk2N "tohtori" "tohtoreita" ;
  dog_N = mkN "koira" ;
  door_N = mkN "ovi" "ovia" ;
  drink_V2 = mkV2 (mkV "juoda") ;
  easy_A2V = mkA2 (mkA (mkN "helppo") "helpompi" "helpoin") 
    (casePrep allative) ;
  eat_V2 = mkV2 (mkV "syd") ;
  empty_A = mkA (mkN "tyhj") "tyhjempi" "tyhjin" ;
  enemy_N = mkN "vihollinen" ;
  factory_N = mkN "tehdas" ;
  father_N2 = mkN2 (mkN "is") ;
  fear_VS = mkVS (mk2V "pelt" "pelksi") ;
  find_V2 = mkV2 (mk2V "lyt" "lysi") ;
  fish_N = mkN "kala" ;
  floor_N = mk2N "lattia" "lattioita" ;
  forget_V2 = mkV2 (mkV "unohtaa") ;
  fridge_N = mkN "jkaappi" ;
  friend_N = mkN "ystv" ;
  fruit_N = mkN "hedelm" ;
  fun_AV = mkAV (mkA (mkN "hauska") "hauskempi" "hauskin") ;
  garden_N = mkN "puutarha" "puutarhan" "puutarhoja" ;
  girl_N = mkN "tytt" ;
  glove_N = mkN "ksine" ;
  gold_N = mkN "kulta" ;
  good_A = mkA (mkN "hyv") "parempi" "parhain" ; --- paras
  go_V = mkV "menn" ;
  green_A = mkA (mkN "vihre") "vihrempi" "vihrein" ;
  harbour_N = mkN "satama" "sataman" "satamia" ;
  hate_V2 = mkV2 (mkV "vihata") cpartitive ;
  hat_N = mkN "hattu" ;
  hear_V2 = mkV2 (mkV "kuulla") ;
  hill_N = mkN "kukkula" ;
  hope_VS = mkVS (mkV "toivoa") ;
  horse_N = mkN "hevonen" ;
  hot_A = mkA (mkN "kuuma") "kuumempi" "kuumin" ;
  house_N = mkN "talo" ;
  important_A = mkA (mkN "trke") "trkempi" "trkein" ;
  industry_N = mkN "teollisuus" ;
  iron_N = mkN "rauta" ;
  king_N = mkN "kuningas" ;
  know_VS = mkVS (mkV "tiet" "tiesi") ;
  know_V2 = mkV2 (mkV "tuntea" "tunsi") ;
  lake_N = mkN "jrvi" "jrvi" ;
  lamp_N = mkN "lamppu" ;
  learn_V2 = 
    mkV2 (mk12V "oppia" "opin" "oppii" "oppivat" "oppikaa" "opitaan"
      "opin" "oppi" "oppisi" "oppinut" "opittu" "opitun") ;
  leather_N = mkN "nahka" ; --- nahan
  leave_V2 = mkV2 (mkV "jtt") ;
  like_V2 = mkV2 (mkV "pit") elative ;
  listen_V2 = mkV2 (mkV "kuunnella" "kuunteli") partitive ;
  live_V = mkV "el" ;
  long_A = mkA (mkN "pitk") "pitempi" "pisin" ;
  lose_V2 = mkV2 (mkV "hvit" "hvisi") ; --- hukata
  love_N = mk3N "rakkaus" "rakkauden" "rakkauksia" ;
  love_V2 = mkV2 (mkV "rakastaa") partitive ;
  man_N = mkN "mies" "miehen" "miest" "miehen" "mieheen" 
              "miesten" "miehi" "miehin" "miehiss" "miehiin" ; 
  married_A2 = mkA2 (mkA "avioitunut") (postPrep genitive "kanssa") ; ---- infl
  meat_N = mkN "liha" ;
  milk_N = mkN "maito" ;
  moon_N = mkN "kuu" ;
  mother_N2 = mkN2 (mkN "iti") ;
  mountain_N = mkN "vuori" "vuoria" ;
  music_N = mkN "musiikki" ;
  narrow_A = mkA (mkN "kapea") "kapeampi" "kapein" ;
  new_A = mkA (mk3N "uusi" "uuden" "uusia") "uudempi" "uusin" ;
  newspaper_N = mkN "sanoma" (mkN "lehti" "lehti") ; --- for correct vowel harmony
  oil_N = mkN "ljy" ;
  old_A = mkA (mkN "vanha") "vanhempi" "vanhin" ;
  open_V2 = mkV2 (mkV "avata" "avasi") ;
  paint_V2A = mkV2A (mkV "maalata") accPrep (casePrep translative) ;
  paper_N = mk2N "paperi" "papereita" ;
  paris_PN = mkPN (mkN "Pariisi") ;
  peace_N = mkN "rauha" ;
  pen_N = mkN "kyn" ;
  planet_N = mkN "planeetta" ;
  plastic_N = mkN "muovi" ;
  play_V2 = mkV2 (mkV "pelata") cpartitive ; --- leikki, soittaa
  policeman_N = mkN "poliisi" ;
  priest_N = mkN "pappi" ;
  probable_AS = mkAS --- for vowel harmony
    (mkA (mkN "todennkinen") "tonennkisempi" "todennlisin") ; ---- sta
  queen_N = mkN "kuningatar" ;
  radio_N = mk2N "radio" "radioita" ;
  rain_V0 = mkV0 (mk2V "sataa" "satoi") ;
  read_V2 = mkV2 (mkV "lukea") ;
  red_A = mkA "punainen" ;
  religion_N = mkN "uskonto" ;
  restaurant_N = mkN "ravintola" ;
  river_N = mkN "joki" "jokia" ;
  rock_N = mk2N "kallio" "kallioita" ;
  roof_N = mkN "katto" ;
  rubber_N = mkN "kumi" ;
  run_V = mk2V "juosta" "juoksi" ;
  say_VS = mkVS (mkV "sanoa") ;
  school_N = mkN "koulu" ;
  science_N = mkN "tiede" ;
  sea_N = mkN "meri" "meren" "meri" "merta" ;
  seek_V2 = mkV2 (mkV "etsi") cpartitive ;
  see_V2 = mkV2 (
    mk12V "nhd" "nen" "nkee" "nkevt" "nhk" "nhdn"
      "nin" "nki" "nkisi" "nhnyt" "nhty" "nhdyn") ; 
  sell_V3 = mkV3 (mkV "myyd") accPrep (casePrep allative) ;
  send_V3 = mkV3 (mkV "lhett") accPrep (casePrep allative) ;
  sheep_N = mkN "lammas" ;
  ship_N = mkN "laiva" ;
  shirt_N = mkN "paita" ;
  shoe_N = mkN "kenk" ;
  shop_N = mkN "kauppa" ;
  short_A = mkA (mkN "lyhyt" "lyhyit") ;
  silver_N = mkN "hopea" ;
  sister_N = mkN "sisko" ;
  sleep_V = mkV "nukkua" ;
  small_A = mkA (mk2N "pieni" "pieni") "pienempi" "pienin" ;
  snake_N = mkN "krme" ;
  sock_N = mkN "sukka" ;
  speak_V2 = mkV2 (mkV "puhua") cpartitive ;
  star_N = mkN "thti" "thti" ;
  steel_N = mkN "ters" ;
  stone_N = mkN "kivi" "kivi" ;
  stove_N = mk3N "liesi" "lieden" "liesi" ;
  student_N = mk2N "opiskelija" "opiskelijoita" ;
  stupid_A = mkA "tyhm" ;
  sun_N = mkN "aurinko" ;
  switch8off_V2 = mkV2 (mkV "sammuttaa") ; ---
  switch8on_V2 = mkV2 (mkV "sytytt") ; ---
  table_N = mkN "pyt" ;
  talk_V3 = mkV3 (mkV "puhua") (casePrep allative) (casePrep elative) ;
  teacher_N = mkN "opettaja" ;
  teach_V2 = mkV2 (mkV "opettaa") ;
  television_N = mk2N "televisio" "televisioita" ;
  thick_A = mkA "paksu" ;
  thin_A = mkA (mkN "ohut" "ohuita") ;
  train_N = mkN "juna" ;
  travel_V = mkV "matkustaa" ;
  tree_N = mkN "puu" ;
 ---- trousers_N = mkN "trousers" ;
  ugly_A = mkA (mkN "ruma") "rumempi" "rumin" ;
  understand_V2 = mkV2 (mkV "ymmrt" "ymmrrn" "ymmrsi") ;
  university_N = mkN "yliopisto" ;
  village_N = mkN "kyl" ;
  wait_V2 = mkV2 (mkV "odottaa") partitive ;
  walk_V = mkV "kvell" "kveli" ;
  warm_A = mkA 
    (mkN "lmmin" "lmpimn" "lmmint" "lmpimn" "lmpimn" 
         "lmpimin" "lmpimi" "lmpimien" "lmpimiss" "lmpimiin"
	 ) 
    "lmpimmpi" "lmpimin" ;
  war_N = mkN "sota" ;
  watch_V2 = mkV2 (mkV "katsella") cpartitive ;
  water_N = mk3N "vesi" "veden" "vesi" ;
  white_A = mkA "valkoinen" ;
  window_N = mk2N "ikkuna" "ikkunoita" ;
  wine_N = mkN "viini" ;
  win_V2 = mkV2 (mkV "voittaa") ;
  woman_N = mkN "nainen" ;
  wonder_VQ = mkVQ (mkV "ihmetell") ;
  wood_N = mkN "puu" ;
  write_V2 = mkV2 (mkV "kirjoittaa") ;
  yellow_A = mkA "keltainen" ;
  young_A = mkA (mkN "nuori" "nuoria") "nuorempi" "nuorin" ;

  do_V2 = mkV2 (
    mkV "tehd" "teen" "tekee" "tekevt" "tehk" "tehdn"
      "tein" "teki" "tekisi" "tehnyt" "tehty" "tehdyn") ; 

  now_Adv = mkAdv "nyt" ;
  already_Adv = mkAdv "jo" ;
  song_N = mkN "laulu" ;
  add_V3 = mkV3 (mkV "list") accPrep (casePrep illative) ;
  number_N = mk2N "numero" "numeroita" ;
  put_V2 = mkV2 (mkV "panna") ;
  stop_V = mkV "pyshty" ;
  jump_V = mkV "hypt" ;
  left_Ord = mkOrd (mkN "vasen") ;
  right_Ord = mkOrd (mkN "oikea") ;
  far_Adv = mkAdv "kaukana" ;
  correct_A = mkA "oikea" ;
  dry_A = mkA (mkN "kuiva") "kuivempi" "kuivin" ;
  dull_A = mkA (mkN "tyls") "tylsempi" "tylsin" ;
  full_A = mkA (mk3N "tysi" "tyden" "tysi") "tydempi" "tysin" ;
  heavy_A = mkA "raskas" ;
  near_A = mkA (mkN "lheinen") ;
  rotten_A = mkA "mt" ;
  round_A = mkA "pyre" ;
  sharp_A = mkA "terv" ;
  smooth_A = mkA "sile" ;
  straight_A = mkA (mkN "suora") "suorempi" "suorin" ;
  wet_A = mkA (mkN "mrk") "mrempi" "mrin" ;
  wide_A = mkA "leve" ;
  animal_N = mk3N "elin" "elimen" "elimi" ;
  ashes_N = mkN "tuhka" ;
  back_N = mkN "selk" ;
  bark_N = mkN "kaarna" ;
  belly_N = mkN "vatsa" ;
  blood_N = mkN "veri" "veren" "veri" "verta" ;
  bone_N = mkN "luu" ;
  breast_N = mkN "rinta" ;
  cloud_N = mk2N "pilvi" "pilvi" ;
  day_N = mkN "piv" ;
  dust_N = mkN "ply" ;
  ear_N = mkN "korva" ;
  earth_N = mkN "maa" ;
  egg_N = mkN "muna" ;
  eye_N = mkN "silm" ;
  fat_N = mkN "rasva" ;
  feather_N = mk3N "hyhen" "hyhenen" "hyheni" ;
  fingernail_N = mk3N "kynsi" "kynnen" "kynsi" ;
  fire_N = mk2N "tuli" "tulia" ;
  flower_N = mkN "kukka" ;
  fog_N = mkN "sumu" ;
  foot_N = mkN "jalka" ;
  forest_N = mkN "mets" ;
  grass_N = mkN "ruoho" ;
  guts_N = mkN "sislmys" ; --- suoli
  hair_N = mkN "hius" ;
  hand_N = mk3N "ksi" "kden" "ksi" ;
  head_N = mkN "p" ;
  heart_N = mkN "sydn" "sydmen" "sydnt" "sydmen" "sydmeen"
                "sydnten" "sydmi" "sydmin" "sydmiss" "sydmiin" ;
  horn_N = mk2N "sarvi" "sarvia" ;
  husband_N = mkN "mies" "miehen" "miest" "miehen" "mieheen" 
                  "miesten" "miehi" "miehin" "miehiss" "miehiin" ; 
  ice_N = mkN "j" ;
  knee_N = mk2N "polvi" "polvia" ;
  leaf_N = mk2N "lehti" "lehti" ;
  leg_N = mkN "jalka" ; --- sri
  liver_N = mkN "maksa" ;
  louse_N = mkN "lude" ;
  mouth_N = mkN "suu" ;
  name_N = mk2N "nimi" "nimi" ;
  neck_N = mkN "niska" ;
  night_N = mkN "y" ;
  nose_N = mkN "nen" ;
  person_N = mkN "henkil" ;
  rain_N = mkN "sade" ;
  road_N = mkN "tie" ;
  root_N = mk2N "juuri" "juuria" ;
  rope_N = mk3N "kysi" "kyden" "kysi" ;
  salt_N = mkN "suola" ;
  sand_N = mkN "hiekka" ;
  seed_N = mkN "siemen" ;
  skin_N = mkN "nahka" ;
  sky_N = mk3N "taivas" "taivaan" "taivaita" ;
  smoke_N = mkN "savu" ;
  snow_N = mkN "lumi" "lumen" "lumia" "lunta" ;
  stick_N = mkN "keppi" ;
  tail_N = mkN "hnt" ;
  tongue_N = mk2N "kieli" "kieli" ;
  tooth_N = mkN "hammas" ;
  wife_N = mkN "vaimo" ;
  wind_N = mk2N "tuuli" "tuulia" ;
  wing_N = mk2N "siipi" "siipi" ;
  worm_N = mkN "mato" ;
  year_N = mk3N "vuosi" "vuoden" "vuosia" ;
  bite_V2 = mkV2 (mkV "purra") ;
  blow_V = mkV "puhaltaa" ;
  burn_V = mkV "palaa" ;
  count_V2 = mkV2 (mkV "laskea") ;
  cut_V2 = mkV2 (mk2V "leikata" "leikkasi") ;
  dig_V = mkV "kaivaa" ;
  fall_V = mkV "pudota" "putoan" "putosi" ;
  fear_V2 = mkV2 (mkV "pelt" "pelkn" "pelksi") cpartitive ;
  fight_V2 = mkV2 (mkV "taistella") (postPrep partitive "vastaan") ;
  float_V = mkV "kellua" ;
  flow_V = mkV "virrata" "virtaan" "virtasi" ;
  fly_V = mkV "lent" ;
  freeze_V = mkV "jty" ;
  give_V3 = mkV3 (mkV "antaa" "annan" "antoi") accPrep (casePrep allative) ;
  hit_V2 = mkV2 (mkV "lyd") cpartitive ;
  hold_V2 = mkV2 (mkV "pit") cpartitive ;
  hunt_V2 = mkV2 (mkV "metsst") cpartitive ;
  kill_V2 = mkV2 (mkV "tappaa") ;
  laugh_V = mkV "nauraa" "nauroi" ;
  lie_V = mkV "maata" "makasi" ;
  play_V = mkV "pelata" ;
  pull_V2 = mkV2 (mkV "vet") ;
  push_V2 = mkV2 (mkV "tynt") ;
  rub_V2 = mkV2 (mkV "hieroa") cpartitive ;
  scratch_V2 = mkV2 (mkV "raapia") cpartitive ;
  sew_V = mkV "kylv" ;
  sing_V = mkV "laulaa" ;
  sit_V = mkV "istua" ;
  smell_V = mk2V "haista" "haisi" ;
  spit_V = mkV "sylke" ;
  split_V2 = mkV2 (mk2V "halkaista" "halkaisi") ;
  squeeze_V2 = mkV2 (mkV "puristaa") cpartitive ;
  stab_V2 = mkV2 (mkV "pist") cpartitive ;
  stand_V = mk12V "seist" "seison" "seisoo" "seisovat" "seisk" "seistn"
      "seisoin" "seisoi" "seisoisi" "seissyt" "seisty" "seistyn" ; --- *seisoivt
  suck_V2 = mkV2 (mkV "ime") cpartitive ;
  swell_V = mkV "turvota" "turposi" ;
  swim_V = mkV "uida" "uin" "ui" ;
  think_V = mkV "ajatella" "ajattelen" "ajatteli" ;
  throw_V2 = mkV2 (mkV "heitt") ;
  tie_V2 = mkV2 (mkV "sitoa") ;
  turn_V = mkV "knty" ;
  vomit_V = mkV "oksentaa" ;
  wash_V2 = mkV2 (mkV "pest") ;
  wipe_V2 = mkV2 (mkV "pyyhki") ;

  breathe_V = mkV "hengitt" ;

  grammar_N = mkN "kielioppi" ;
  language_N = mk2N "kieli" "kieli" ;
  rule_N = mkN "snt" ;

    john_PN = mkPN "Jussi" ;
    question_N = mkN "kysymys" ;
    ready_A = mkA (mkN "valmis") ;
    reason_N = mkN "syy" ;
    today_Adv = mkAdv "tnn" ;
    uncertain_A = mkA "epvarma" ;

 oper
    mkOrd : N -> Ord ;
    mkOrd x = {s = x.s ; lock_Ord = <> } ;
    cpartitive = casePrep partitive ;

} ;
