/*  **************************************************************************
 * 
 * --- File: errors.c
 * 
 * --- Purpose: error handling for gexpr.
 * 
 * --- Copyright (C) Guido Gonzato, guido@ibogeo.df.unibo.it
 * 
 * --- Last updated: 8 January 1999
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * ************************************************************************ */

#include <stdio.h>
#include <signal.h>
#include "gexpr.h"

/* ----- */

/* error() is called by several routines to notify the user of an error
 * in the expression.
 */

void flush_stdin (void)
{
  
  int ch;
  
  while ((ch = getchar()) != '\n') /* flush current line of input */
    ;
  
} /* --- flush_stdin () --- */

void error (const char *msg, TOKEN_TYPE flag)
{
  
  fprintf (stderr, "%s\n", msg);

  /* chuck out all pending line input */
  if (flag != T_EOL && flag != T_EOF && input_source == STDIN)
    flush_stdin ();
  
  longjmp (jump, 0); /* start over again */
  
} /* --- error () --- */

/* ----- */

/* --- End of file errors.c --- */
