/*  **************************************************************************
 * 
 * --- File: commands.c
 * 
 * --- Purpose: routines for executing commands in gexpr.
 * 
 * --- Copyright (C) Guido Gonzato, guido@ibogeo.df.unibo.it
 * 
 * --- Last updated: 8 January 1999
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * ************************************************************************ */

#include <stdio.h>
#include <string.h>
#include "gexpr.h"

extern void check_token(TOKEN_TYPE, TOKEN_TYPE);
extern int output_base;
extern int decimal_pos;

static void help(void);

/* ----- */

static void help(void)
{
  printf("This is gexpr, version %s\n\nFunctions:\n", VERSION);
  puts("acos asin atan atan2 ceil cos cosh exp fabs fact floor fmod ldexp");
  puts("log log10 pow rand rnd sin sinh sqr sqrt tan tanh");
  printf("\nConstants:\n");
  puts("M_1_PI M_2_PI M_2_SQRTPI M_E M_LN10 M_LN2 M_LOG10E");
  puts("M_LOG2E M_PI M_PI_2 M_PI_4 M_SQRT1_2 M_SQRT2 PI PI2");
  printf("\nCommands:\n");
  puts("base dec(imals) help q(uit)");

} /* help() */

/* ----- */

void handle_command(const char *cmd)
{
  
  TOKEN tok;
  int n;
  BOOL flag_error = FALSE;
  
  if (strcmp(cmd, "base") == 0) {
    tok = read_token();
    if (tok.type != T_DIGIT) 
      {
	fprintf(stderr, "syntax error in command!\n");
	flag_error = TRUE;
      }
    else {
      n = (int) tok.value;
      if (n < 2 || n > 16)
	fprintf(stderr, "output base must be >=2 and <=16\n");
      else {
	printf("output base is now %d\n", n);
	output_base = n;
      }
    } /* else */
    if (flag_error == FALSE) 
      {
	tok = read_token();
	check_token(tok.type, T_EOL);
      }
  } /* if (strcmp(cmd, "base") == 0) */
  
  else
  
  if (strcmp(cmd, "help") == 0) {
    help();
    tok = read_token();
    check_token(tok.type, T_EOL);
  }
  
  else
  
  if (strcmp(cmd, "quit") == 0) {
    program_over = TRUE;
    tok = read_token();
    check_token(tok.type, T_EOL);
  }
  
  else

  if ( (strcmp(cmd, "decimals") == 0) || (strcmp(cmd, "dec") == 0)) {
    tok = read_token();
    if (tok.type != T_DIGIT) 
      {
	fprintf(stderr, "syntax error in command!\n");
	flag_error = TRUE;
      }
    else {
      n = (int) tok.value;
      if (n < 0)
	fprintf(stderr, "nonsense. Default decimals = %d\n", n = 10);
      else {
	printf("decimal positions now %d\n", n);
	decimal_pos = n;
      }
    } /* else */
    if (flag_error == FALSE) 
      {
	tok = read_token();
	check_token(tok.type, T_EOL);
      }
  } /* if (strcmp(cmd, "decimals") == 0) */

  else {
    fprintf(stderr, "unknown command\n");
    flush_stdin ();
  }
  
} /* handle_command() */

/* ----- */

/* --- End of file commands.c --- */
