find_path(OPENMPI_INCLUDE_DIR mpi.h
	PATHS /usr/lib/openmpi/include/
	DOC	"OpenMPI include dir (with mpi.h)")

FIND_PATH(
	PETSC_DIR include/petsc.h
	PATHS /net/cv/lib64/petscdir/
)

SET(PETSC_INCLUDE_DIR "${OPENMPI_INCLUDE_DIR};${PETSC_DIR}/include/")

#INCLUDE(CheckIncludeFile)
#CHECK_INCLUDE_FILE("${PETSC_INCLUDE_DIR}/petsc.h" HAVE_PETSC_H)

FIND_LIBRARY(PETSC_LIBRARIES petsc PATHS "${PETSC_DIR}/lib/")

#if (HAVE_PETSC_H AND PETSC_DIR AND PETSC_LIBRARIES)
if (OPENMPI_INCLUDE_DIR AND PETSC_DIR AND PETSC_LIBRARIES)
  set(HAVE_SLEPC 1)
  set(PETSC_FOUND ON)
endif()

MARK_AS_ADVANCED(PETSC_DIR PETSC_INCLUDE_DIR PETSC_LIBRARIES)
