// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef HEPREP_HEPREPWRITER_H
#define HEPREP_HEPREPWRITER_H 1

// Copyright 2002-2005, Freehep.

#include <string>
#include <vector>

namespace HEPREP {

class HepRep;
class HepRepAction;
class HepRepAttDef;
class HepRepAttValue;
class HepRepAttribute;
class HepRepDefinition;
class HepRepInstance;
class HepRepInstanceTree;
class HepRepPoint;
class HepRepTreeID;
class HepRepType;
class HepRepTypeTree;

/**
 * HepRepWriter interface.
 *
 * @author Mark Donszelmann
 */
class HepRepWriter {

public: 
    /// Destructor.
    virtual ~HepRepWriter() { /* nop */; }

    /**
     * Adds a property, to be written to the HepRep file when closed.
     *
     * @param key
     * @param value
     * @return false in case of a stream problem.
     */
    virtual bool addProperty(std::string key, std::string value) = 0;

    /**
     * Closes the writer and its underlying stream.
     *
     * @return false in case of a stream problem.
     */
    virtual bool close() = 0;

    /**
     * Writes a HepRep.
     *
     * @param heprep to be written.
     * @param name for the heprep to be written (for tagged access), may be ommited.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRep * heprep, std::string name) = 0;

    /**
     * Writes the layerOrder.
     *
     * @param layerOrder to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(std::vector<std::string>  layerOrder) = 0;

    /**
     * Writes a HepRepTypeTree.
     *
     * @param typeTree to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepTypeTree * typeTree) = 0;

    /**
     * Writes a HepRepType.
     *
     * @param type to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepType * type) = 0;

    /**
     * Writes a HepRepTreeID.
     *
     * @param treeID to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepTreeID * treeID) = 0;

    /**
     * Writes a HepRepAction.
     *
     * @param action to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepAction * action) = 0;

    /**
     * Writes a HepRepInstanceTree.
     *
     * @param instanceTree to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepInstanceTree * instanceTree) = 0;

    /**
     * Writes a HepRepInstance.
     *
     * @param instance to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepInstance * instance) = 0;

    /**
     * Writes a HepRepPoint.
     *
     * @param point to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepPoint * point) = 0;

    /**
     * Writes a HepRepAttribute.
     *
     * @param attribute to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepAttribute * attribute) = 0;

    /**
     * Writes a HepRepDefinition.
     *
     * @param definition to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepDefinition * definition) = 0;

    /**
     * Writes a HepRepAttValue.
     *
     * @param attValue to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepAttValue * attValue) = 0;

    /**
     * Writes a HepRepAttDef.
     *
     * @param attDef to be written.
     * @return false in case of a stream problem.
     */
    virtual bool write(HepRepAttDef * attDef) = 0;
}; // class
} // namespace HEPREP
#endif /* ifndef HEPREP_HEPREPWRITER_H */
