#------------------------------------------------------------------------------
# sources.cmake
# Module : G4hits
# Package: Geant4.src.G4digits_hits.G4hits
#
# Sources description for a library.
# Lists the sources and headers of the code explicitely.
# Lists include paths needed.
# Lists the internal granular and global dependencies of the library.
# Source specific properties should be added at the end.
#
# Generated on : 24/9/2010
#
#
#------------------------------------------------------------------------------

# List external includes needed.
include_directories(${CLHEP_INCLUDE_DIRS})

# List internal includes needed.
include_directories(${CMAKE_SOURCE_DIR}/source/global/HEPGeometry/include)
include_directories(${CMAKE_SOURCE_DIR}/source/global/HEPRandom/include)
include_directories(${CMAKE_SOURCE_DIR}/source/global/management/include)

#
# Define the Geant4 Module.
#
include(Geant4MacroDefineModule)
GEANT4_DEFINE_MODULE(NAME G4hits
    HEADERS
        G4HCofThisEvent.hh
        G4THitsCollection.hh
        G4THitsMap.hh
        G4THitsVector.hh
        G4VHit.hh
        G4VHitsCollection.hh
    SOURCES
        G4HCofThisEvent.cc
        G4THitsCollection.cc
        G4VHit.cc
        G4VHitsCollection.cc
    GRANULAR_DEPENDENCIES
        G4globman
    GLOBAL_DEPENDENCIES
        G4global
    LINK_LIBRARIES
)

# List any source specific properties here

