//$Id: PhysicsAbstTable.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
// 1999 June 23
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

package GPE;



import javax.swing.*;

import javax.swing.table.*;

import javax.swing.event.*;

import java.util.*;

import java.awt.*;

import java.awt.event.*;



abstract public class PhysicsAbstTable extends JTable implements ActionListener {

  protected JButton createButton, deleteButton, openProcButton, openHProcButton;

  protected String tableTitle;

  PhysicsFrame parent;

  protected GPETableModel model;



  PhysicsAbstTable(GPETableModel model, PhysicsFrame parent){



    super(model);

    this.model = model;

    this.parent = parent;



    setAutoCreateColumnsFromModel(false);

    setColumnSelectionAllowed(false);

    setRowSelectionAllowed(true);

    setFont(new Font("Serif", Font.BOLD, 11));



    getTableHeader().setReorderingAllowed(false);

    setSelectionMode(ListSelectionModel.SINGLE_SELECTION);



    JTextField tf = new JTextField();



    //DefaultTableCellRenderer useCellRenderer = new DefaultTableCellRenderer();

    //useCellRenderer.setForeground(Color.red);

    //DefaultTableCellRenderer nameCellRenderer = new DefaultTableCellRenderer();

    //nameCellRenderer.setBackground(Color.pink);



    TableColumn column = new TableColumn();



         column = getColumn("Particle");



    //column.setCellEditor(new ParCellEditor(parent));

              column.sizeWidthToFit();

              column.setResizable(true);



          column = getColumn("Process");

    //column.setCellEditor(new ProCellEditor(parent));

    //column.setCellEditor(new NewProCellEditor(new JTextField()));

    //column.setCellEditor(new NewProCellEditor(tf, parent));

              column.sizeWidthToFit();

              column.setResizable(true);



	      //column = getColumn("Model");

              //column.setCellEditor(new DefaultCellEditor(tf));

              //column.sizeWidthToFit();

              //column.setResizable(true);



          column = getColumn("AtRest");

              column.setCellEditor(new DefaultCellEditor(tf));

              column.sizeWidthToFit();

              column.setResizable(true);



          column = getColumn("AlongStep");

              column.setCellEditor(new DefaultCellEditor(tf));

              column.sizeWidthToFit();

              column.setResizable(true);



        column = getColumn("PostStep");

              column.setCellEditor(new DefaultCellEditor(tf));

              column.sizeWidthToFit();

              column.setResizable(true);

  }



  public void delMatCloseAct(){

     deleteButton.setForeground(Color.black);

     deleteButton.repaint();

  }



  public void createMatCloseAct(){



     createButton.setForeground(Color.black);

     createButton.repaint();

  }



    //abstract void create();

    //abstract void delete();



  public boolean isCellEditable(int row, int column){

    if(column == 0 || column == 1){

        return false;

    }else{

        return true;

    }

  }

    

  void stopEditing(){

    if (isEditing()){

      cellEditor.stopCellEditing();

    }

    clearSelection();

  }

    

  Object getSelectedName(){

    if (isEditing()) cellEditor.stopCellEditing();

    Vector data = model.getDataVector();

    int row = getSelectedRow();

    if (row < 0) return null;

    return ((Vector)data.elementAt(row)).elementAt(0);

  }



  public void valueChanged(ListSelectionEvent lse){



    super.valueChanged(lse);



    if (lse.getValueIsAdjusting()==true) {

      selected();

    }

    //if (lse.getFirstIndex() < 0) return;

    //if (lse.getLastIndex() < 0) return;



    //debug for row selection

    //System.out.println(lse);



  }



  public void columnSelectionChanged(ListSelectionEvent e){

    super.columnSelectionChanged(e);

    if(e.getValueIsAdjusting()==true) return;

  }



  protected abstract void selected();



}







