//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//// 2001 Dec integration into MOMO

//2003 May XML I/O

package GGE;
//   2000 12 Dec    H. YOSHIDA
// 


import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;


import javax.swing.filechooser.*;
import GPE.ExampleFileFilter;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.Serializable;
import java.lang.StringBuffer;

import javax.naming.spi.*;
//import java.net.jxta.impl.document.XMLDocument.*;
import javax.xml.parsers.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.w3c.dom.*;

//MOMO public?
//MOMO no more AbstractGGEFrame?? serializable is not yet in

public class VolumesFrame extends AbstractGGEPanel implements ActionListener {

//public class VolumesFrame extends JPanel implements ActionListener, Serializable {
public  MaterialFrame matFrame; 
    Date today = new Date();
    public SourceFrame sf, includesf, xmlf;       // XML added
  DAWNSourceFrame dawnSFrame;
public  LogicalPanel logPanel;
public  VisAtbPanel visPanel;
  PhysicalPanel phyPanel;
    //MOMO the followings were private but are now public
   ReplicasFrame repFrame;   //8.20 Replicas 
   RepeatedVolume repeatVol; //8.20 RepeatedVolume
   RepeatedRotateVolume repeatRotVol; //9.14 Rotate
   SingleVolume singleVol;   //8.21 Single Positioned Volume
   SlicingAxialFrame slicingFrame; //1998 10.26
   TransParameFrame transParameFrame;
   AxiParameFrame axiParameFrame;
   ElementsTable et;
    private JMenuItem load, append, save, clear, exit, loadXML, saveXML; //XML added

//, mat;
//Makes C++ code
    private JMenuItem CPP, CHH, closeCPP, XML, closeXML;  // XML added
//Preview
//  private JMenuItem dawn , david;
//Elements Table
  private JMenuItem tOpen ,tClose; 
//  private JCheckBoxMenuItem sourceWin, materialWin;
  JLabel label;
 public  JTextField classNameField;
  private JFileChooser loadGGE, saveGGE;
  private String fileName;
  static String fileDir;
  public String workdirpath = ".";

public  VolumesFrame(){
    super();   // JPanel constructor can't take a string
    //MOMO
    //    setLayout(new BorderLayout(10, 10));
    setLayout(new FlowLayout(FlowLayout.LEFT, 15,5));

    matFrame = new MaterialFrame();
    sf = new SourceFrame();
    includesf = new SourceFrame();
    xmlf  = new SourceFrame();   //XML add
    dawnSFrame = new DAWNSourceFrame();
    repFrame = new ReplicasFrame(this);  //8.21 Replicas 
    slicingFrame = new SlicingAxialFrame(this); //1998 10.26 SlicingAxial
    repeatVol = new RepeatedVolume(this); // 8.21 Repeated Volume  
    repeatRotVol = new RepeatedRotateVolume(this); // 9.14 Rotate
    singleVol = new SingleVolume(this);   // 8.21 SinglePositionedVolume
    transParameFrame = new TransParameFrame(); //1999.12.10
    axiParameFrame = new AxiParameFrame(); //1999.12.10 
    logPanel = new LogicalPanel(this);
    visPanel = new VisAtbPanel(this);
    phyPanel = new PhysicalPanel(this);
    JPanel panel1 = new JPanel(new BorderLayout());

    //    JPanel panel2 = new JPanel(new BorderLayout());
    JTabbedPane panel2 = new JTabbedPane();   // MOMO 

    panel1.add("Center", logPanel);
    panel1.add("East", visPanel);
    //    panel2.add("Center", phyPanel);
    //MOMO
    ImageIcon icon = new ImageIcon("yellow-ball.gif");
    panel2.addTab("Single", icon, singleVol);   //MOMO
    panel2.addTab("RepeatTrans", icon, repeatVol);   //MOMO
    panel2.addTab("RepeatRotate", icon, repeatRotVol);   //MOMO
    panel2.addTab("ReplicaTrans", icon, repFrame);   //MOMO
    panel2.addTab("ReplicaAxial", icon, slicingFrame);   //MOMO
    panel2.setSize(200, 450);

    //    JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, panel1, panel2);
    JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,true,
                                                         panel1, panel2);
    splitPane.setDividerLocation(310);
    JPanel panel3 = new JPanel();
      panel3.add(createMenubar());
      panel3.add(makeClassNamePanel());
    //add(createMenubar(), "North" );
    //add(makeClassNamePanel(), "Center");
    //add(splitPane, "South");
    add( panel3, "North");
    add( splitPane, "Center");

    //setSize(680, 450);
    setSize(700,580);
    setVisible(true);
//    setBackground(Color.green);
//    setForeground(Color.black);
  }
  private JMenuBar createMenubar(){
    JMenu file ,mkCode;     
    JMenuBar mb = new JMenuBar();
    file = new JMenu("File");
    file.setForeground(Color.cyan);
    file.add(load = new JMenuItem("Load a Volumes File"));
    file.add(loadXML = new JMenuItem("Load a XML Volumes File"));
    file.add(append = new JMenuItem("Append a Volumes File"));
    file.add(save = new JMenuItem("Save Volumes"));
    file.add(saveXML = new JMenuItem("Save XML Volumes"));
    file.add(clear = new JMenuItem("Clear Volumes"));
    file.addSeparator();
    //file.add(exit = new JMenuItem("Exit"));
    load.addActionListener(this);
    loadXML.addActionListener(this);
    append.addActionListener(this);
    save.addActionListener(this);
    saveXML.addActionListener(this);
    clear.addActionListener(this);
    //exit.addActionListener(this);
    mb.add(file);
    mkCode = new JMenu("MakeSource");
    mkCode.setForeground(Color.cyan);
    mkCode.add(CPP = new JMenuItem("Make C++ code"));
    mkCode.add(CHH = new JMenuItem("Make Header File"));
    mkCode.add(XML = new JMenuItem("Make XML code File"));
    CPP.addActionListener(this);
    CHH.addActionListener(this);
    XML.addActionListener(this);
    mb.add(mkCode);
    return mb;
  }

  public JPanel makeClassNamePanel(){      //1999.11.09
    JLabel textFieldTitle = new JLabel("ClassName", JLabel.CENTER);
    textFieldTitle.setFont(new Font("Serif", Font.BOLD, 12));
    Dimension titlesize = textFieldTitle.getPreferredSize();
    textFieldTitle.setSize(titlesize);

    JPanel textFieldPanel = new JPanel();
    //MOMO 2002 setSize
    textFieldPanel.setSize(640, 60); // must be a little larger than titlesize
    textFieldPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 15, 2));
    textFieldPanel.add(textFieldTitle);
    classNameField = new JTextField(20);

    textFieldPanel.add(classNameField);
    return textFieldPanel;
  }

  public void actionPerformed(ActionEvent ae){
    Object o = ae.getSource();
    if( o == load ){GGEfileLoad();}
    if( o == loadXML ){XMLfileLoad();}
    if( o == append ){GGEfileAppend();}
    if( o == save ){GGEfileSave();}
    if( o == saveXML ){XMLfileSave();}
    if( o == clear ){ volClear();}
    if( o == exit ){ System.exit(0); }
    if( o == CPP && (makeCPP() != "")){
//for debug      System.out.println(makeCPP());
        sf.setVisible(true);
        sf.editor.setText(makeCPP());
    }
    if( o == XML && (makeXML() != "")){
	//System.out.println(makeXML());   // XML DEBUG
        xmlf.setVisible(true);
        xmlf.editor.setText(makeXML());
    }
    if( o == CHH && (makeCHH() != "")){

        includesf.setVisible(true);
        includesf.editor.setText(makeCHH());

}
  }
//------single, replica, repeated Volume -----open method---------
  public void singleOpen(){
    singleVol.setVisible(true);
  }
  public void replicaOpen(){
    repFrame.setVisible(true);
  }
  public void slicingOpen(){  // 1998 10.26 SlicingAxial
    slicingFrame.setVisible(true);
  }
  public void repeatOpen(){
    repeatVol.setVisible(true);
  }
  public void repeatRotateOpen(){
    repeatRotVol.setVisible(true);
  }
  public void transParameOpen(){
    transParameFrame.setVisible(true);
  }
  public void axiParameOpen(){
    axiParameFrame.setVisible(true);
  }

//Create C++ -------------------------------------------------
// Create header file


  String makeCHH(){


        String myName = classNameField.getText();
        StringTokenizer st = new StringTokenizer(myName);
     
        if (!st.hasMoreTokens()){
          JOptionPane opane = new JOptionPane();
          opane.showMessageDialog(this, 
                             "Type in your ClassName",
                             "Warning Dialog", JOptionPane.WARNING_MESSAGE);
          JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
          return "";
        }



       StringBuffer smatchh = new StringBuffer("\n// Geometry Header File \n");
        smatchh.append("//   " + myName + ".hh generated by Geant4 Geometry Editor at " + 
                today.toString() + "  \n\n");
        smatchh.append("\n#ifndef " + myName + "_h\n");
        smatchh.append("#define  " + myName + "_h  1\n\n");
        smatchh.append("class G4VPhysicalVolume;\n");

        smatchh.append("#include \"G4VUserDetectorConstruction.hh\"\n");

        smatchh.append("class  " + myName + ":  public G4VUserDetectorConstruction\n");
        smatchh.append("   {");
        smatchh.append("      public:\n");
        smatchh.append("      " + myName + "();\n");
        smatchh.append("     ~" + myName + "();\n\n");
        smatchh.append("      public:\n");
        smatchh.append("      G4VPhysicalVolume* Construct();\n");
        smatchh.append("  };\n");
        smatchh.append("#endif\n");
   
   return smatchh.toString();

  }  //end of makeCHH

// Create *.cc file

  String makeCPP(){
	StringBuffer smatcpp = new StringBuffer();

        String myName = classNameField.getText();
        StringTokenizer token = new StringTokenizer(myName);
     
        if (!token.hasMoreTokens()){
          JOptionPane opane = new JOptionPane();
          opane.showMessageDialog(this, 
                          "Type in your ClassName",
                          "Warning Dialog", JOptionPane.WARNING_MESSAGE);
          JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
           return "";
        }


        smatcpp.append("//***** Geant4.9.4: Generated by Geant4 Geometry Editor at  " + 
               today.toString() + " *****\n\n");
        smatcpp.append(headerCPP());
	smatcpp.append(matFrame.getCPP());
        smatcpp.append(visPanel.getCPP());
	smatcpp.append(logPanel.getCPP());
        smatcpp.append(phyPanel.getCPP());
        smatcpp.append(singleVol.getCPP());
        smatcpp.append(repeatVol.getCPP());
        smatcpp.append(repeatRotVol.getCPP());
        smatcpp.append(repFrame.getCPP());
        smatcpp.append(slicingFrame.getCPP()); //1998 10.26 
        smatcpp.append(getCPP());
        return smatcpp.toString();
  }


    // TEST XML
  String makeXML(){
	StringBuffer smatxml = new StringBuffer();
	StringBuffer logxml = new StringBuffer(logPanel.getXML());

        String myName = classNameField.getText();
        StringTokenizer st = new StringTokenizer(myName);
        String noSldName = logPanel.noSldName();    
	int option = 0;

        if (!st.hasMoreTokens()){
          JOptionPane opane = new JOptionPane();
          opane.showMessageDialog(this, 
                          "Type in your ClassName",
                          "Warning Dialog", JOptionPane.WARNING_MESSAGE);
          JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
           return "";
        }
	if (logPanel.isSaveOk() ){
	  Object[] options = {"OK", "Cancel"};
          JOptionPane opane = new JOptionPane();
	   option = opane.showOptionDialog(this, 
					"Can not create \n"
					+noSldName
					+" in GDML,\nChoose OK to save",
					"Warning",
					JOptionPane.DEFAULT_OPTION,
					JOptionPane.WARNING_MESSAGE,
					null, options, options[0]);
          JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
        }

	if(option == 0 ){

        /*smatxml.append("<!--Generated by Geant4 Geometry Editor at  " + 
               today.toString() + " *****-->\n\n");*/
        smatxml.append(headerXML());
	smatxml.append(matFrame.getXML());
        //smatxml.append(visPanel.getXML());
	smatxml.append(logxml);
        //smatxml.append(phyPanel.getCPP());
        //smatxml.append(singleVol.getCPP());
        //smatxml.append(repeatVol.getCPP());
        //smatxml.append(repeatRotVol.getCPP());
        //smatxml.append(repFrame.getCPP());
        //smatxml.append(slicingFrame.getCPP()); //1998 10.26 
        //smatxml.append(getXML());
	smatxml.append("</gdml>");
        return smatxml.toString();

	}else{  return ""; }
  }





  private synchronized void resume(){
    notify();
  }

  String getCPP(){
    StringBuffer cpp = new StringBuffer("\n// return the physical World\n\n");
    if(singleVol.singleTable.getRowCount()==0){
      return cpp.toString();
    }else{
      String mother;
      for (int i=0;i<singleVol.singleDataModel.getRowCount();i++){
        mother = ((String)singleVol.singleDataModel.getValueAt(i,3));
        if(!mother.equals("NULL")){
           //next single data
        }else if(mother.equals("NULL")){
          cpp.append("\n return "
            +singleVol.singleDataModel.getValueAt(i,1)+";\n}");            
        }
      }
    }
    return cpp.toString();
  }


    // testing XML
  String getXML(){
    StringBuffer xml = new StringBuffer("\n// Physical world \n\n");
    if(singleVol.singleTable.getRowCount()==0){
      return xml.toString();
    }else{
      String mother;
      for (int i=0;i<singleVol.singleDataModel.getRowCount();i++){
        mother = ((String)singleVol.singleDataModel.getValueAt(i,3));
        if(!mother.equals("NULL")){
           //next single data
        }else if(mother.equals("NULL")){
          xml.append("\n <physical"
            +singleVol.singleDataModel.getValueAt(i,1)+"/physical\n}");            
        }
      }
    }
    return xml.toString();
  }

    // test empty now

//Create HeaderFile ----------------------------------------------------

    //String headerXML(){return "Test XML Header part\n\n";}
    String headerXML(){
	String xmls =  new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"	   +"<gdml xmlns:gdml=\"http://cern.ch/2001/Schemas/GDML\"\n"
	   +"     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n"
	   +"     xsi:noNamespaceSchemaLocation=\"../schema/gdml_1.0.xsd\">\n"
	   +"  <define>\n"
	   +"    <constant name=\"HALFPI\" value=\"pi/2.\"/>\n"
	   +"    <constant name=\"PI\" value=\"1.*pi\"/>\n"
	   +"    <constant name=\"TWOPI\" value=\"2.*pi\"/>\n"
	   +"    <position name=\"center\"/>\n"
	   +"    <rotation name=\"identity\"/>\n"
	   +"    <position name=\"shiftbyx\" x=\"20.0\"/>\n"
	   +"    <rotation name=\"rotatebyx\" x=\"HALFPI\"/>\n"
	   +"    <rotation name=\"rotatebyall\" x=\"HALFPI\" y=\"PI\" z=\"TWOPI\"/>\n"
	   +"   </define>\n\n");
	return xmls;
    }


  String headerCPP(){
    String myName = classNameField.getText();//1999.11.09
    StringBuffer cpp = new StringBuffer("//------HeaderFile-\n ");
    //cpp.append("#include \"MyDetectorConstruction.hh\"\n\n");
    cpp.append("#include \"" + myName + ".hh\"\n\n");//1999.11.09

    cpp.append("#include \"G4UnitsTable.hh\"\n\n");   // 8.17

//    cpp.append("#include \"MyCalorimeterSD.cc\"\n");
//    cpp.append("#include \"MyCalorimeterHit.cc\"\n");
//    cpp.append("#include \"MyCalorimeterHitsCollection.cc\"\n\n");
    cpp.append("#include \"G4VUserDetectorConstruction.hh\"\n\n");
    cpp.append("#include \"globals.hh\"\n");
    cpp.append("#include \"G4Material.hh\"\n");
    cpp.append("#include \"G4MaterialTable.hh\"\n");
    cpp.append("#include \"G4Element.hh\"\n");
    cpp.append("#include \"G4ElementTable.hh\"\n");
//   G4Solid

//   solid selected

    SolidItem solidItem;
    Object solidData;
    int a=0,b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;
    for (int s=0; s<logPanel.logDataModel.getRowCount();s++){
      solidItem = ((SolidItem)logPanel.logDataModel.getValueAt(s,1));
      if(solidItem instanceof CSGItem){
        solidData = new CSGItem(solidItem.getSolidType());

         if(solidData.toString()=="Box"){
            a++;
         }else if(solidData.toString()=="TubeSegment"){
            b++;
         }else if(solidData.toString()=="ConeSegment"){
            c++;
         }else if(solidData.toString()=="SymTrapezoid"){
            d++;
         }else if(solidData.toString()=="SphereSegment"){
            e++;
         }else if(solidData.toString()=="Parallelepiped"){
            f++;
         }else if(solidData.toString()=="TorusSegment"){
            g++;
         }else if(solidData.toString()=="Hype"){
            h++;
         }
      }else if(solidItem instanceof BREPItem){
        solidData = new BREPItem(solidItem.getSolidType());
        if(solidData.toString()=="PolyConeSegment"){
         i++;
        }else if(solidData.toString()=="PolyGonSegment"){
         j++;
        }      

      }
    }
    if(a!=0)cpp.append("#include \"G4Box.hh\"\n");
    if(b!=0)cpp.append("#include \"G4Tubs.hh\"\n");
    if(c!=0)cpp.append("#include \"G4Cons.hh\"\n");
    if(d!=0)cpp.append("#include \"G4Trd.hh\"\n");
    if(e!=0)cpp.append("#include \"G4Sphere.hh\"\n");
    if(f!=0)cpp.append("#include \"G4Para.hh\"\n");
    if(g!=0)cpp.append("#include \"G4Torus.hh\"\n");
    if(h!=0)cpp.append("#include \"G4Hype.hh\"\n");    
    if(i!=0)cpp.append("#include \"G4BREPSolidPCone.hh\"\n");
    if(j!=0)cpp.append("#include \"G4BREPSolidPolyhedra.hh\"\n");
    cpp.append("#include \"G4LogicalVolume.hh\"\n");
    cpp.append("#include \"G4ThreeVector.hh\"\n");
    cpp.append("#include \"G4PVPlacement.hh\"\n");
    cpp.append("#include \"G4PVReplica.hh\"\n");
    cpp.append("#include \"G4SDManager.hh\"\n");
    cpp.append("#include \"G4VisAttributes.hh\"\n");
    cpp.append("#include \"G4Colour.hh\"\n\n");
    //cpp.append("MyDetectorConstruction::MyDetectorConstruction( )\n{ ; }\n");
    cpp.append(myName + "::" + myName + "()\n{ ; }\n");//1999.11.09
    //cpp.append("MyDetectorConstruction::~MyDetectorConstruction( )\n{ ; }\n");
    cpp.append(myName + "::~" + myName + "()\n{ ; }\n");//1999.11.09 
    //cpp.append("G4VPhysicalVolume* MyDetectorConstruction::Construct( )\n{\n");
    cpp.append("G4VPhysicalVolume* " + myName + "::Construct( )\n{\n");//1999.11.09
    return cpp.toString();
  }
//Detector Clear-------------------------------------------------

  void volClear(){
      logPanel.logClear();
      visPanel.visClear();
      singleVol.singleClear();
      repFrame.replicasClear();
      slicingFrame.slicingClear(); //1998 10.26 SlicingAxial
      repeatVol.repeatedClear();
      repeatRotVol.repeatedRotClear();
      transParameFrame.transParameClear();
      axiParameFrame.axiParameClear();
  }

//Detector load--------------------------------------------------


    void XMLfileLoad(){
	JFileChooser loadXML = new JFileChooser( workdirpath );
        ExampleFileFilter xmlFile = new ExampleFileFilter("xml", "XML Source");
        loadXML.setFileFilter(xmlFile);
        loadXML.setDialogTitle("Load XML");
        //loadXML.showOpenDialog(this);
        if(loadXML.showOpenDialog(this) != JFileChooser.APPROVE_OPTION) return;
        loadXML.setMultiSelectionEnabled(true);
        File fl = loadXML.getSelectedFile();
        et = new ElementsTable();   
        //ElementItem el[] = et.makeElements();

        if (fl.isFile()){
           fileName = fl.getPath();

           try{
		DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = dbfactory.newDocumentBuilder();
		Document doc = builder.parse(new File(fileName));
		Element root = doc.getDocumentElement();
		NodeList nodelist = root.getChildNodes();
                Vector logStrData = new Vector();
		Vector logSldData = new Vector();
		Vector defineData = new Vector();
		Vector mtrScrData = new Vector();
		Vector mtrComData = new Vector();
		for(int i=0; i <  nodelist.getLength(); i++){
		  Node node = nodelist.item(i);
		  NamedNodeMap attrs = node.getAttributes();
		  if(attrs != null){
	
		  String volName = "";
                  String materialStr ="";
                  String solidStr ="";
	////structure
		    if( node.getNodeName() == "structure"){
		      NodeList strList = node.getChildNodes();
		      for(int j=0; j < strList.getLength(); j++){
			Node strNode = strList.item(j);
			NamedNodeMap strAttrs = strNode.getAttributes();
			if(strAttrs != null){
			  if( strNode.getNodeName() == "volume"){
			    Vector v = new Vector();
			    volName = strAttrs.getNamedItem("name")
							.getNodeValue();
			    NodeList volList = strNode.getChildNodes();
			    for(int k=0; k < volList.getLength(); k++){
				Node child = volList.item(k);
				NamedNodeMap volAttrs = child.getAttributes();
				if(volAttrs != null){
				  if( child.getNodeName() == "solidref"){
				     solidStr = volAttrs.getNamedItem("ref")
							.getNodeValue();
				  }else if(child.getNodeName() == "materialref"){
				     materialStr = volAttrs.getNamedItem("ref")
							   .getNodeValue();
				  }
				}
			     }
		             v.addElement(volName);
		             v.addElement(solidStr);
	 	             v.addElement(materialStr);
	 	             v.addElement("");
			     logStrData.addElement(v);
			  }
			}
		      }
		    }
	////solid
                      if(node.getNodeName() == "solids"){
                        NodeList sldList = node.getChildNodes();
                        for(int j=0; j < sldList.getLength(); j++){
                          Node sldNode = sldList.item(j);
                          Vector v = new Vector();
                          String sldName = sldNode.getNodeName();
                          NamedNodeMap sldAttrs = sldNode.getAttributes();
                          if(sldAttrs != null){
                            if(sldName == "define"){
                              NodeList defList = sldNode.getChildNodes();
                              for(int k=0; k < defList.getLength(); k++){
                                Node defNode = defList.item(k);
                                Vector quav = new Vector();
                                NamedNodeMap defAttrs = defNode.getAttributes();
                                if(defAttrs != null){
                                  quav.addElement(getAttrName(defAttrs,"name"));
                                  quav.addElement(getAttrName(defAttrs,"value"));
                                  quav.addElement(getAttrName(defAttrs,"unit"));
                                  defineData.addElement(quav);
                                }
                              }

                            }else if(sldName == "box"){
                              v.addElement("0");
                              v.addElement(getAttrName(sldAttrs,"name"));
                              v.addElement(getAttrName(sldAttrs,"x"));
                              v.addElement(getAttrName(sldAttrs,"y"));
                              v.addElement(getAttrName(sldAttrs,"z"));
                            }else if(sldName == "trd"){
                              v.addElement("1");
                              v.addElement(getAttrName(sldAttrs,"name"));
                              v.addElement(getAttrName(sldAttrs,"x1"));
                              v.addElement(getAttrName(sldAttrs,"x2"));
                              v.addElement(getAttrName(sldAttrs,"y1"));
                              v.addElement(getAttrName(sldAttrs,"y2"));
                              v.addElement(getAttrName(sldAttrs,"z"));
                           }else if(sldName =="tube"){
                              v.addElement("2");
                              v.addElement(getAttrName(sldAttrs,"name"));
                              v.addElement(getAttrName(sldAttrs,"rmin"));
                              v.addElement(getAttrName(sldAttrs,"rmax"));
                              v.addElement(getAttrName(sldAttrs,"z"));
                              v.addElement(getAttrName(sldAttrs,"startphi"));
                              v.addElement(getAttrName(sldAttrs,"deltaphi"));
			    }else if(sldName =="cone"){
			      v.addElement("3");
			      v.addElement(getAttrName(sldAttrs,"name"));
			      v.addElement(getAttrName(sldAttrs,"rmin1"));
			      v.addElement(getAttrName(sldAttrs,"rmax1"));
			      v.addElement(getAttrName(sldAttrs,"rmin2"));
			      v.addElement(getAttrName(sldAttrs,"rmax2"));
			      v.addElement(getAttrName(sldAttrs,"z"));
			      v.addElement(getAttrName(sldAttrs,"startphi"));
			      v.addElement(getAttrName(sldAttrs,"deltaphi"));
                            }else if(sldName =="sphere"){
                              v.addElement("4");
                              v.addElement(getAttrName(sldAttrs,"name"));
                              v.addElement(getAttrName(sldAttrs, "rmin"));
                              v.addElement(getAttrName(sldAttrs,"rmax"));
                              v.addElement(getAttrName(sldAttrs,"startphi"));
                              v.addElement(getAttrName(sldAttrs,"deltaphi"));
                              v.addElement(getAttrName(sldAttrs,"starttheta"));
                              v.addElement(getAttrName(sldAttrs,"deltatheta"));
                            }else if(sldName =="para"){
                              v.addElement("5");
                              v.addElement(getAttrName(sldAttrs,"name"));
                              v.addElement(getAttrName(sldAttrs,"x"));
                              v.addElement(getAttrName(sldAttrs,"y"));
                              v.addElement(getAttrName(sldAttrs,"z"));
                              v.addElement(getAttrName(sldAttrs,"alpha"));
                              v.addElement(getAttrName(sldAttrs,"theta"));
                              v.addElement(getAttrName(sldAttrs,"phi"));
                            }
                            if(v.size() != 0){
                              logSldData.addElement(v);
                            }
                          }
                        }
                      }
        ////materials
                      if(node.getNodeName() == "materials"){
                        NodeList mtrList = node.getChildNodes();
                        for(int j=0; j < mtrList.getLength(); j++){
                          Node mtrNode = mtrList.item(j);
                          String mtrName = mtrNode.getNodeName();
                          NamedNodeMap mtrAttrs = mtrNode.getAttributes();
                          if(mtrAttrs != null){

                           if( mtrName == "material"){
                            NodeList mtrCList = mtrNode.getChildNodes();
                            boolean isScratch = true;
                            for(int k=0; k < mtrCList.getLength(); k++){
                              Node mtrCNode = mtrCList.item(k);
                              NamedNodeMap mtrCAttrs
                                                = mtrCNode.getAttributes();
                                  if( mtrCAttrs != null){
                                   if(mtrCNode.getNodeName()=="composite" ||
                                        mtrCNode.getNodeName()=="fraction"){
                                      isScratch = false;
                                   }
                                  }
                             }

                //scratch materials
                             if( isScratch ){
                                  String dValue =""; String dUnit ="";
                                  String aValue ="";
                                  String tValue =""; String tUnit="";
                                  String pValue =""; String pUnit="";
                                  for(int k=0; k < mtrCList.getLength(); k++){
                                   Node mtrCNode = mtrCList.item(k);
                                   NamedNodeMap mtrCAttrs
                                                = mtrCNode.getAttributes();
                                  if( mtrCAttrs != null){
                                   if(mtrCNode.getNodeName() == "D"){
                                    dValue = getAttrName(mtrCAttrs,"value");
                                    dUnit =  getAttrName(mtrCAttrs,"unit");
                                  }else if(mtrCNode.getNodeName() =="atom"){
                                    aValue = getAttrName(mtrCAttrs,"value");
                                  }else if(mtrCNode.getNodeName() =="T"){
                                    tValue = getAttrName(mtrCAttrs, "value");
                                    tUnit =  getAttrName(mtrCAttrs,"unit");
                                  }else if(mtrCNode.getNodeName() =="P"){
                                    pValue = getAttrName(mtrCAttrs,"value");
                                    pUnit = getAttrName(mtrCAttrs,"unit");
                                  }
                                }
                              }

                              Vector mtrData = new Vector();
                              String stateStr
                               = getAttrName(mtrAttrs, "state");
                              String state ="";
                              if(stateStr.equals("unknown")){
                                state = MaterialItem.stateCode[0];
                              }else if(stateStr.equals("solid")){
                                state = MaterialItem.stateCode[1];
                              }else if(stateStr.equals("liquid")){
                                state = MaterialItem.stateCode[2];
                              }else if(stateStr.equals("gas")){
                                state = MaterialItem.stateCode[3];
                              }else{ state = MaterialItem.stateCode[0]; }

                              mtrData.addElement("Used");
                              mtrData.addElement(getAttrName(mtrAttrs,"name"));
                              mtrData.addElement(getAttrName(mtrAttrs, "Z"));
                              mtrData.addElement(aValue);
                              mtrData.addElement(dValue);
                              mtrData.addElement(dUnit);
                              mtrData.addElement(state);
                              mtrData.addElement(tValue);
                              mtrData.addElement(tUnit);
                              mtrData.addElement(pValue);
                              mtrData.addElement(pUnit);
                              mtrScrData.addElement(mtrData);
                            }else {
                //combination materials
                              String dValue =""; String dUnit ="";
                              String tValue =""; String tUnit ="";
                              String pValue =""; String pUnit ="";
                              Vector elemV = new Vector();
                              int symbolNum = 0;
                              //NodeList mtrCList = mtrNode.getChildNodes();
                              for(int k=0; k < mtrCList.getLength(); k++){
                                Node mtrCNode = mtrCList.item(k);
                                NamedNodeMap mtrCAttrs
                                                = mtrCNode.getAttributes();
                                if( mtrCAttrs != null){
                                  if(mtrCNode.getNodeName() == "D"){
                                    dValue = mtrCAttrs.getNamedItem("value").getNodeValue();
                                    dUnit =  getAttrName(mtrCAttrs, "unit");
                                  }else if(mtrCNode.getNodeName() =="T"){
                                    tValue = getAttrName(mtrCAttrs, "value");
                                    tUnit =  getAttrName(mtrCAttrs,"unit");
                                  }else if(mtrCNode.getNodeName() =="P"){
                                    pValue = getAttrName(mtrCAttrs, "value");
                                    pUnit = getAttrName(mtrCAttrs,"unit");
                                  }else{
                                    Vector v = new Vector();
                                    String elem = getAttrName(mtrCAttrs,"ref");
                                    v.addElement(mtrCNode.getNodeName());
                                    v.addElement(getAttrName(mtrCAttrs,"n"));
                                    v.addElement(elem);
                                    elemV.addElement(v);
                                    for(int l=0; l<104; l++){
                                      //if( el[l].symbol.equals(elem) ){
                                      if( et.getSymbol(l).equals(elem) ){
                                        symbolNum++;
                                      }else if(et.getName(l).equals(elem)){
                                        symbolNum++;
                                      }
                                     }
                                  }
                                }
                              }
                              if(((Vector)elemV.elementAt(0)).elementAt(2).toString()!=""){
                                RatioItem ratioItem;
                                int isfraction = 0;
                                int num = 0;
                                boolean isUnknown = true;
                                float  ratioNum[] = new float[symbolNum];
                                ElementItem ei[] = new ElementItem[symbolNum];
                                for(int k=0; k < elemV.size(); k++){
                                 String fraction = getStr(elemV, k, 0);
                                 String ratioStr = getStr(elemV, k, 1);
                                 String elem     = getStr(elemV, k, 2);
                                 for(int l=0; l < 104; l++){
                                   //if( el[l].symbol.equals(elem) ){
                                   if( et.getSymbol(l).equals(elem) ){
                                        //ei[num] = el[l];
                                        ei[num] = et.getElement(l);
                                        isUnknown = false;
                                        if(ratioStr!=""){
                                          ratioNum[num] = Float.valueOf(ratioStr)
                                                                .floatValue();
                                        }else{ ratioNum[num] =0.0f; }
                                        num++;

                                   //}else if( el[l].name.equals(elem) ){
                                   }else if( et.getName(l).equals(elem) ){
                                        //ei[num] = el[l];
                                        ei[num] = et.getElement(l);
                                        isUnknown = false;
                                        if(ratioStr!=""){
                                          ratioNum[num] = Float.valueOf(ratioStr)
                                                                .floatValue();
                                        }else{ ratioNum[num] =0.0f; }
                                        num++;
                                   }
                                 }

                                 if(fraction=="fraction"){ isfraction=1; }
                                 else if(fraction=="composite"){ isfraction=0; }
                               }
                                if(!isUnknown){
                                  ratioItem = new RatioItem(ei);
                                  ratioItem.ratio = ratioNum;
                                  ratioItem.isEmpty = false;
                                  ratioItem.isFraction = isfraction;


                                  Vector mtrData = new Vector();
                                  mtrData.addElement("Used");
                                  mtrData.addElement(getAttrName(mtrAttrs,"name"));
                                  mtrData.addElement(ratioItem);
                                  mtrData.addElement(dValue);
                                  mtrData.addElement(dUnit);
                                  mtrData.addElement("kStateUndefined");
                                  mtrData.addElement(tValue);
                                  mtrData.addElement(tUnit);
                                  mtrData.addElement(pValue);
                                  mtrData.addElement(pUnit);
                                  mtrComData.addElement(mtrData);
                                }
                              }

                            }
                           }
                          }
                        }
                      }
                   }
                }
        //logicalPanel
                logPanel.logClear();
                SolidCellEditor sce = new SolidCellEditor(this);
                for(int j=0; j < logStrData.size(); j++){
                   Vector logData = new Vector();
		   int solidType = 0;
		   int sldnum = 0;
		   boolean knownSld = false;
		   for(int k=0; k < logSldData.size(); k++){
		     if(getStr(logSldData,k,1).equals(getStr(logStrData,j,1))){
            		solidType = Integer.parseInt(getStr(logSldData,j,0));
                   	//sldnum = ((Vector)logSldData.elementAt(j)).size();
			sldnum = k;
			knownSld = true;
		      }else if(getStr(logSldData,k,1)
				.equals(getStr(logStrData,j,0))){
			solidType = Integer.parseInt(getStr(logSldData,j,0));
                        //sldnum = ((Vector)logSldData.elementAt(j)).size();
			sldnum = k;
			knownSld = true;
		      }
		   }
		   if(knownSld){
                     CSGItem csgItem = new CSGItem(solidType);
                     for (int k=0; k < ((Vector)logSldData
					.elementAt(sldnum)).size() -2 ; k++){
                        String values ="";
        	        String unit ="";
                        String valuesStr = getStr(logSldData, sldnum, k+2);
                        for(int l=0; l < defineData.size(); l++){
                          Vector defv = (Vector)defineData.elementAt(l);
                          if( valuesStr.equals(defv.elementAt(0).toString())){
                             values = defv.elementAt(1).toString();
                             unit   = defv.elementAt(2).toString();
                          }
                        }
                        double doubleValue=0.0;
                        if(values !=""){
                          doubleValue = Double.valueOf(values).doubleValue();
                        }else{ doubleValue =0.0; }

                        csgItem.setValuesUnits( k,
                                doubleValue,
                                unit);
                     }
                     sce.getTableCellEditorComponent(logPanel.logTable,
                                        csgItem,
                                        true, sldnum, 1);

                     logData.addElement(((Vector)logStrData.elementAt(j)).elementAt(0));
                     logData.addElement(csgItem);
                     logData.addElement(((Vector)logStrData.elementAt(j)).elementAt(2));
                     logData.addElement("");
                     logPanel.logDataModel.addRow(logData);
		   }
                }
                logPanel.repaint();
        //ScratchMaterials
                matFrame.MaterialfileClear();
                for(int j=0; j < mtrScrData.size(); j++){
                  Vector scratch = (Vector)mtrScrData.elementAt(j);
                  matFrame.msDataModel.addRow(scratch);
                }
                matFrame.repaint();
        //CombiMaterials
                for(int j=0; j < mtrComData.size(); j++){
                  Vector combi = (Vector)mtrComData.elementAt(j);
                  matFrame.mcDataModel.addRow(combi);
                }
                matFrame.repaint();
           }catch(Exception e){ /*e.printStackTrace();*/ }
        }else{
           //System.out.println("error="+fl.toString()+"isNotaFile");
        }
        return;

    }

  String getAttrName(NamedNodeMap attrs, String name){
        if(attrs.getNamedItem(name) !=null){
           return attrs.getNamedItem(name).getNodeValue();
        }else{
           return "";
        }
  }
  String getStr(Vector v, int i, int j){
        if(((Vector)v.elementAt(i)).elementAt(j)!= ""){
            return ((Vector)v.elementAt(i)).elementAt(j).toString();
        }else{
            return "";
        }
   }




    void XMLfileSave(){
	JFileChooser saveXML = new JFileChooser(workdirpath);
        ExampleFileFilter xmlFile = new ExampleFileFilter("xml","XML Source");
        saveXML.setFileFilter(xmlFile);
        saveXML.setDialogTitle("Save XML");
        if(saveXML.showSaveDialog(this) != JFileChooser.APPROVE_OPTION) return;
        File fs = saveXML.getSelectedFile();
        fileName = fs.getPath();
        if (fileName != null){
           try{
                FileOutputStream fileout = new FileOutputStream(fileName);
		PrintWriter outf = new PrintWriter(new DataOutputStream(fileout));
		outf.println(makeXML());
                outf.close();
           }catch(IOException e){ /*System.out.println(e.getMessage());*/}
                return;
        }
        if (fileName == null){ return;}
   }

  void GGEfileLoad(){
      JFileChooser loadGGE = new JFileChooser(workdirpath);
      ExampleFileFilter dtFile = new ExampleFileFilter("g4dt","DetectorSource");
      loadGGE.setFileFilter(dtFile);
      loadGGE.setDialogTitle("Load Detector");
      //loadGGE.showOpenDialog(this);
      if( loadGGE.showOpenDialog(this) != JFileChooser.APPROVE_OPTION ) return;
      loadGGE.setMultiSelectionEnabled(true);
      File fl = loadGGE.getSelectedFile();

      if (fl.isFile()) {
        fileName = fl.getPath();

        try{
          FileInputStream filein = new FileInputStream(fileName);
          ObjectInputStream objin =new ObjectInputStream(filein);
          Vector detectorData = (Vector)objin.readObject();
          Vector logData =  (Vector)detectorData.elementAt(0);
          Vector visData =  (Vector)detectorData.elementAt(1);
          Vector replicaData = (Vector)detectorData.elementAt(2);
          Vector repeatData = (Vector)detectorData.elementAt(3);
          Vector repeatRotData = (Vector)detectorData.elementAt(4);
          Vector singleData = (Vector)detectorData.elementAt(5);
          Vector matSData = (Vector)detectorData.elementAt(6);
          Vector matCData = (Vector)detectorData.elementAt(7);
          Vector slicingData = (Vector)detectorData.elementAt(8);//1998 10.26  
          Vector transParameData = (Vector)detectorData.elementAt(9);//1999.12.13
          Vector axiParameData = (Vector)detectorData.elementAt(10);//1999.12.13
          Object classNameFieldObject = (Object)detectorData.elementAt(11);//1999.11.09
// Logical
          logPanel.logClear();
          int logVectorCount = logData.size();
          for(int i=0; i<logVectorCount; i++){
           Vector lt = (Vector)logData.elementAt(i);
           logPanel.logDataModel.addRow(lt);
          }
          logPanel.repaint();
// VisAtb
          visPanel.visClear();
          int visVectorCount = visData.size();
          for(int i=0; i<visVectorCount; i++){
           Object vis = (Object)visData.elementAt(i);
           visPanel.listModel.addElement(vis);
          }
          visPanel.repaint();
// Replicas
          repFrame.replicasClear();
          int replicaVectorCount = replicaData.size();
          for(int i=0; i<replicaVectorCount; i++){
           Vector replica = (Vector)replicaData.elementAt(i);
           repFrame.repDataModel.addRow(replica);
          }
          repFrame.repaint();
// Repeated Volume
          repeatVol.repeatedClear();
          int repeatVectorCount = repeatData.size();
          for(int i=0; i<repeatVectorCount; i++){
           Vector repeat = (Vector)repeatData.elementAt(i);
           repeatVol.pDataModel.addRow(repeat);
          }
          repeatVol.repaint();

// RepeatedRotate Volume
          repeatRotVol.repeatedRotClear();
          int repeatRotVectorCount = repeatRotData.size();
          for(int i=0; i<repeatRotVectorCount; i++){
           Vector repeatRot = (Vector)repeatRotData.elementAt(i);
           repeatRotVol.pDataModel.addRow(repeatRot);
          }
          repeatRotVol.repaint();

// Single Positioned Volume
          singleVol.singleClear();
          int singleVectorCount = singleData.size();
          for(int i=0; i<singleVectorCount; i++){
           Vector single = (Vector)singleData.elementAt(i);
           singleVol.singleDataModel.addRow(single);
          }
          singleVol.repaint();
// Used Scratch Materials
          matFrame.MaterialfileClear();
          int msVectorCount = matSData.size();
          for(int i=0; i<msVectorCount; i++){
           Vector scratch = (Vector)matSData.elementAt(i);
           matFrame.msDataModel.addRow(scratch);
          }
// Used Combi Materials
          int mcVectorCount = matCData.size();
          for(int i=0; i<mcVectorCount; i++){
           Vector combi = (Vector)matCData.elementAt(i);
           matFrame.mcDataModel.addRow(combi);
          }
// SlicingAxial
          slicingFrame.slicingClear();
          int slicingVectorCount = slicingData.size();
          for(int i=0; i<slicingVectorCount; i++){
           Vector slicing = (Vector)slicingData.elementAt(i);
           slicingFrame.slicingDataModel.addRow(slicing);
          }
// TransParametrisation
          transParameFrame.transParameClear();
          int transParameCount = transParameData.size();
          for(int i=0; i<transParameCount; i++){
           Vector trans = (Vector)transParameData.elementAt(i);
           transParameFrame.pDataModel.addRow(trans);
	  }
// AxisialParametrisation
          axiParameFrame.axiParameClear();
          int axiParameCount = axiParameData.size();
          for(int i=0; i<axiParameCount; i++){
           Vector axi = (Vector)axiParameData.elementAt(i);
           axiParameFrame.pDataModel.addRow(axi);
	  }
// classNameField //1999.11.09
          String classNameFieldString = classNameFieldObject.toString();
          classNameField.setText(classNameFieldString);

          slicingFrame.repaint();


          objin.close();
        }catch(Exception e){
          //System.out.println(e.toString());
        }
      }else{
        //System.out.println("error="+fl.toString()+"isNotaFile");
      }
      return;
  }

//Detector Append--------------------------------------------------
  void GGEfileAppend(){
      JFileChooser loadGGE = new JFileChooser(workdirpath);
      ExampleFileFilter dtFile = 
                         new ExampleFileFilter("g4dt","DetectorSource");
      loadGGE.setFileFilter(dtFile);
      loadGGE.setDialogTitle("Load Detector");
      //loadGGE.showOpenDialog(this);
      int returnVal = loadGGE.showOpenDialog(this);
      loadGGE.setMultiSelectionEnabled(true);
      File fl = loadGGE.getSelectedFile();

      //if (fl.isFile()) {
      if(returnVal == JFileChooser.APPROVE_OPTION){
        fileName = fl.getPath();

        try{
          FileInputStream filein = new FileInputStream(fileName);
          ObjectInputStream objin =new ObjectInputStream(filein);
          Vector detectorData = (Vector)objin.readObject();
          Vector logData =  (Vector)detectorData.elementAt(0);
          Vector visData =  (Vector)detectorData.elementAt(1);
          Vector replicaData = (Vector)detectorData.elementAt(2);
          Vector repeatData = (Vector)detectorData.elementAt(3);
          Vector repeatRotData = (Vector)detectorData.elementAt(4);
          Vector singleData = (Vector)detectorData.elementAt(5);
          Vector matSData = (Vector)detectorData.elementAt(6);
          Vector matCData = (Vector)detectorData.elementAt(7);
          Vector slicingData = (Vector)detectorData.elementAt(8);     
          Vector transParameData = (Vector)detectorData.elementAt(9);//1999.12.13
          Vector axiParameData = (Vector)detectorData.elementAt(10);//1999.12.13
          Object classNameFieldObject = (Object)detectorData.elementAt(11);//1999.11.09

// Logical
          int logVectorCount = logData.size();
          for(int i=0; i<logVectorCount; i++){
           Vector lt = (Vector)logData.elementAt(i);
           logPanel.logDataModel.addRow(lt);
          }
          logPanel.repaint();
// VisAtb
          int visVectorCount = visData.size();
          for(int i=0; i<visVectorCount; i++){
           Object vis = (Object)visData.elementAt(i);
           visPanel.listModel.addElement(vis);
          }
          visPanel.repaint();
// Replicas
          int replicaVectorCount = replicaData.size();
          for(int i=0; i<replicaVectorCount; i++){
           Vector replica = (Vector)replicaData.elementAt(i);
           repFrame.repDataModel.addRow(replica);
          }
          repFrame.repaint();
// Repeated Volume
          int repeatVectorCount = repeatData.size();
          for(int i=0; i<repeatVectorCount; i++){
           Vector repeat = (Vector)repeatData.elementAt(i);
           repeatVol.pDataModel.addRow(repeat);
          }
          repeatVol.repaint();
// RepeatedRotate Volume
          int repeatRotVectorCount = repeatRotData.size();
          for(int i=0; i<repeatRotVectorCount; i++){
           Vector repeatRot = (Vector)repeatRotData.elementAt(i);
           repeatVol.pDataModel.addRow(repeatRot);
          }
          repeatRotVol.repaint();

// Single Positioned Volume
          int singleVectorCount = singleData.size();
          for(int i=0; i<singleVectorCount; i++){
           Vector single = (Vector)singleData.elementAt(i);
           singleVol.singleDataModel.addRow(single);
          }
          singleVol.repaint();
// Used Scratch Materials
          int msVectorCount = matSData.size();
          for(int i=0; i<msVectorCount; i++){
           Vector scratch = (Vector)matSData.elementAt(i);
           matFrame.msDataModel.addRow(scratch);
          }
// Used Combi Materials
          int mcVectorCount = matCData.size();
          for(int i=0; i<mcVectorCount; i++){
           Vector combi = (Vector)matCData.elementAt(i);
           matFrame.mcDataModel.addRow(combi);
          }
// SlicingAxial
          int slicingVectorCount = slicingData.size();
          for(int i=0; i<slicingVectorCount; i++){
           Vector slicing = (Vector)slicingData.elementAt(i);
           slicingFrame.slicingDataModel.addRow(slicing);
          }
// TransParametrisation
          int transParameCount = transParameData.size();
          for(int i=0; i<transParameCount; i++){
           Vector trans = (Vector)transParameData.elementAt(i);
           transParameFrame.pDataModel.addRow(trans);
          }
// AxialParametrisation
          int axiParameCount = axiParameData.size();
          for(int i=0; i<axiParameCount; i++){
           Vector axi = (Vector)axiParameData.elementAt(i);
           axiParameFrame.pDataModel.addRow(axi);
          }

//classNameField //1999.11.09
          String classNameFieldString = classNameFieldObject.toString();
          classNameField.setText(classNameFieldString);

          slicingFrame.repaint();


          objin.close();
        }catch(Exception e){
          //System.out.println(e.toString());
        }
      }else{
        //System.out.println("error="+fl.toString()+"isNotaFile");
      }
      return;
  }


//Detector Save----------------------------------------------------
  void GGEfileSave(){
    JFileChooser saveGGE = new JFileChooser(workdirpath);
    ExampleFileFilter dtFile = new ExampleFileFilter("g4dt","DetectorSource");
    saveGGE.setFileFilter(dtFile);
    saveGGE.setDialogTitle("Save Detector");
    if ( saveGGE.showSaveDialog(this) != JFileChooser.APPROVE_OPTION) return;
    File fs = saveGGE.getSelectedFile();
    fileName = fs.getPath();
   if (fileName != null){
     try{
      FileOutputStream fileout = new FileOutputStream(fileName);
      ObjectOutputStream objout = new ObjectOutputStream(fileout);
      Vector detectorVector = new Vector();
// Logical Save
      detectorVector.addElement((Object)logPanel.logDataModel.getDataVector());

// VisAtb Save
      Vector visVector = new Vector();
      for (int i=0; i<visPanel.listModel.getSize(); i++){
        visVector.addElement((Object)visPanel.listModel.elementAt(i));
      }
      detectorVector.addElement((Object)visVector);
// Replicas Save
      detectorVector.addElement((Object)repFrame.repDataModel.getDataVector());
// Repeated Volume Save
      detectorVector.addElement((Object)repeatVol.pDataModel.getDataVector());
// RepeatedRotate Volume Save
    detectorVector.addElement((Object)repeatRotVol.pDataModel.getDataVector());
// Single Positioned Volume
  detectorVector.addElement((Object)singleVol.singleDataModel.getDataVector());

// Used ScratchMaterials ----- Start --------------------------------
      Vector msdata = matFrame.msDataModel.getDataVector();
      Vector msRowData;
      Vector msUsed = new Vector();
// Density must be checked before generating C++ code. 8.21 not yet!!

      for (int i=0; i<msdata.size(); i++){
        msRowData = (Vector)msdata.elementAt(i);
        if(!msRowData.elementAt(0).equals("Used")){
//Use G4 Units
        }else if(msRowData.elementAt(0).equals("Used")){
           msUsed.addElement((Vector)msdata.elementAt(i));
        }
      }
      detectorVector.addElement((Object)msUsed);
// Used ScratchMaterials ----- End --------------------------------

// Used CombiMaterial -------- Start ------------------------------
      Vector mcdata = matFrame.mcDataModel.getDataVector();
      Vector mcRowData; 
      Vector mcUsed = new Vector();
// Density must be checked before generating C++ code. 8.21 not yet!!

      for (int i=0; i<mcdata.size(); i++){
        mcRowData = (Vector)mcdata.elementAt(i);
        if(!mcRowData.elementAt(0).equals("Used")){
//Use G4 Units
        }else if(mcRowData.elementAt(0).equals("Used")){
           mcUsed.addElement((Vector)mcdata.elementAt(i));
        }
      }
      detectorVector.addElement((Object)mcUsed);
// Used ScratchMaterials ----- End --------------------------------

// SlicingAxial Save
      detectorVector.addElement((Object)slicingFrame.slicingDataModel.getDataVector());

// TransParametrisation Save //1999.12.13
      detectorVector.addElement((Object)transParameFrame.pDataModel.getDataVector());

// AxialParametrisation Save //1999.12.13
      detectorVector.addElement((Object)axiParameFrame.pDataModel.getDataVector());

// classNameField Save  //1999.11.09
      detectorVector.addElement((Object)classNameField.getText());

      objout.writeObject(detectorVector);
      objout.flush();
      fileout.close();
     }catch(IOException e){ /*System.out.println(e.getMessage());*/ }
      return;
   }
   if (fileName == null){   return;}
   
  }
//
//Used Material----------------------------------------------------
//
  public void okCommand(){
    Object mtclear[] = new Object[1];
    mtclear[0] = "";
    for (int i=0; i<matFrame.msTable.getRowCount(); i++){
       matFrame.msTable.setValueAt(mtclear[0],i,0);
    }    

    //MOMO DEBUG
     //System.out.println("matScratch row count : ");
     //System.out.println(matFrame.msTable.getRowCount());
    for (int i=0; i<matFrame.mcTable.getRowCount(); i++){
       matFrame.mcTable.setValueAt(mtclear[0],i,0);
    }
     //System.out.println("matCombi row count : ");
     //System.out.println(matFrame.mcTable.getRowCount());

    String logMaterial, msMaterial, mcMaterial;
    for (int i=0;i<logPanel.logTable.getRowCount();i++){
     logMaterial = ((String)logPanel.logDataModel.getValueAt(i,2));

     //MOMO DEBUG OK this point passed
     //System.out.println("Logmaterial = "+ logMaterial);
      if(matFrame.msDataModel.getRowCount()!=-1){
       for (int j=0;j<matFrame.msDataModel.getRowCount();j++){
           msMaterial = ((String)matFrame.msDataModel.getValueAt(j,1));
	   //MOMO
     //System.out.println("msmaterial = "+ msMaterial);
           if(!logMaterial.equals(msMaterial)){
           }else if(logMaterial.equals(msMaterial)){
            matFrame.msDataModel.setValueAt("Used",j,0);
           }
       }
      }
      if(matFrame.mcDataModel.getRowCount()!=-1){
        for (int h=0;h<matFrame.mcDataModel.getRowCount();h++){
          mcMaterial = ((String)matFrame.mcDataModel.getValueAt(h,1));
	  //MOMO
     //System.out.println("mcmaterial = "+ mcMaterial);
          if(!logMaterial.equals(mcMaterial)){
          }else if(logMaterial.equals(mcMaterial)){
           matFrame.mcDataModel.setValueAt("Used",h,0);
          }
        }
      }
    }  
  }

  public String[] getMaterialName(){
   GGETableModel msModel = matFrame.msDataModel;
   GGETableModel mcModel = matFrame.mcDataModel;
   int sRow = msModel.getRowCount();
   int cRow  = mcModel.getRowCount();
   int scratchRow = 0; int combiRow = 0;    //number of "used"
   //check "used"
   for( int i=0; i < sRow; i++ ){
     if(msModel.getValueAt(i,0).equals("Used")){ scratchRow++; }
   }
   for( int i=0; i < cRow; i++ ){
     if(mcModel.getValueAt(i,0).equals("Used")){ combiRow++; }
   }

   int matRow = scratchRow + combiRow;
   String materialName[] = new String[matRow];
   matRow = 0;

   for( int i=0; i < sRow; i++ ){
     if( msModel.getValueAt(i,0).equals("Used")){
        materialName[matRow] = msModel.getValueAt(i,1).toString();
        matRow++;
      }
   }
   for( int i=0; i < cRow;  i++ ){
     if( mcModel.getValueAt(i,0).equals("Used")){
         materialName[matRow] = mcModel.getValueAt(i,1).toString();
         matRow++;
     }
   }
   return materialName;
  }

  public String[] getVolumesName(){
   GGETableModel logModel = logPanel.logDataModel;
   int logRow = logModel.getRowCount();
   String volumesName[] = new String[logRow];
   for(int i=0; i < logRow; i++ ){
     volumesName[i] = logModel.getValueAt(i,0).toString();
   }
   return volumesName;
  }
}
