//$Id: GGEListModel.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import javax.swing.*;
import java.io.*;
import java.util.*;

public class GGEListModel extends AbstractListModel implements Serializable{

  private Vector list;

  public GGEListModel(){
    list = new Vector();
  }

  public void addElement(Object obj){
    list.addElement(obj);
    int index = list.size();
    fireIntervalAdded(this, index, index);
  }

  public Object elementAt(int index){
     return list.elementAt(index);
  }

  public Object getElementAt(int index){
    return list.elementAt(index);
  }

  public int getSize(){
     return list.size();
  }

  public void removeElementAt(int index){
     fireIntervalRemoved( this, index, index);
     list.removeElementAt(index);
  }

  public void setElementAt(Object obj, int index){
     list.setElementAt(obj, index);
     fireIntervalAdded(this, index, index);
  }
}
