//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
#include "G4AntiOmegabMinusInelasticProcess.hh"
#include "G4AntiOmegabMinus.hh"
#include <iostream>


G4AntiOmegabMinusInelasticProcess::G4AntiOmegabMinusInelasticProcess( const G4String& name )
 :G4HadronInelasticProcess( name, G4AntiOmegabMinus::Definition() ) {}


void G4AntiOmegabMinusInelasticProcess::ProcessDescription( std::ostream& outFile ) const {
  outFile << "G4AntiOmegabMinusInelasticProcess handles the inelastic scattering of\n" 
          << "anti_omega_b- from nuclei by invoking one or more hadronic models and one\n"
          << "or more hadronic cross section sets.\n";
}

