//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4 Hadron Physics class G4HadronCrossSections
// F.W. Jones, TRIUMF, 03-DEC-96
// 
// This class encapsulates cross section data and calculations
// from the Geant3/Gheisha routine GHESIG.
// The overloaded method MakePhysicsVector can be used to Generate 
// Physics Tables for different processes.
//
// Note: this is implemented as a SINGLETON class
//

#include "G4HadronCrossSections.hh"
#include "G4ios.hh"
#include "G4SystemOfUnits.hh"
#include "G4Pow.hh"
#include "G4Threading.hh"
 
// Initialize static pointer for singleton instance
G4ThreadLocal G4HadronCrossSections* G4HadronCrossSections::instance = nullptr;

// Cross section tables from G3.21/GHEISHA routine GHESIG

//---------------------------------------------------------------------
// Lab Momentum in GeV/c
//---------------------------------------------------------------------
const G4float G4HadronCrossSections::plab[TSIZE] = {
       0.00000f       , 0.10000f   , 0.15000f   , 0.20000f   , 0.25000f   ,
       0.30000f       , 0.35000f   , 0.40000f   , 0.45000f   , 0.50000f   ,
       0.55000f       , 0.60000f   , 0.65000f   , 0.70000f   , 0.75000f   ,
       0.80000f       , 0.85000f   , 0.90000f   , 0.95000f   ,  1.0000f   ,
        1.1000f       ,  1.2000f   ,  1.3000f   ,  1.4000f   ,  1.5000f   ,
        1.6000f       ,  1.8000f   ,  2.0000f   ,  2.2000f   ,  2.4000f   ,
        2.6000f       ,  2.8000f   ,  3.0000f   ,  4.0000f   ,  5.0000f   ,
        6.0000f       ,  8.0000f   ,  10.000f   ,  20.000f   ,  100.00f   ,
        1000.0f       
};

//---------------------------------------------------------------------
// Elastic scattering on free protons
//---------------------------------------------------------------------

const G4float G4HadronCrossSections::csel[NPARTS][TSIZE] = {
      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //1
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //2
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //3
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //4
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //5
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //6
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

// Elastic cross section for piplus - p
      {0.00000f   ,  6.0000f   ,  20.000f   ,  71.000f   ,  155.00f   , //7
        195.00f   ,  130.00f   ,  78.000f   ,  60.000f   ,  32.000f   ,
        23.500f   ,  18.500f   ,  15.000f   ,  12.500f   ,  10.000f   ,
        9.1000f   ,  8.6000f   ,  8.8000f   ,  9.5000f   ,  10.600f   ,
        13.000f   ,  15.500f   ,  17.100f   ,  17.200f   ,  16.200f   ,
        15.000f   ,  12.300f   ,  10.200f   ,  9.0000f   ,  8.0000f   ,
        7.3000f   ,  6.8000f   ,  6.5000f   ,  5.8000f   ,  5.4000f   ,
        5.2000f   ,  5.0000f   ,  4.9000f   ,  3.8000f   ,  3.2000f   ,
        3.5000f},

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //8
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

// Elastic cross section for piminus - p
      {0.00000f   ,  1.0000f   ,  3.0000f   ,  8.0000f   ,  18.000f   , //9
        25.000f   ,  27.500f   ,  12.300f   ,  10.600f   ,  11.000f   ,
        12.500f   ,  14.500f   ,  17.000f   ,  19.400f   ,  19.800f   ,
        16.800f   ,  14.000f   ,  14.800f   ,  20.000f   ,  26.100f   ,
        19.500f   ,  15.000f   ,  12.800f   ,  11.500f   ,  10.500f   ,
        9.8000f   ,  8.8000f   ,  8.2000f   ,  7.8000f   ,  7.5000f   ,
        7.2000f   ,  7.0000f   ,  6.8000f   ,  6.1000f   ,  5.7000f   ,
        5.4000f   ,  4.9000f   ,  4.6000f   ,  4.0000f   ,  3.3000f   ,
        3.5000f},

       {10.000f   ,  11.200f   ,  11.300f   ,  11.400f   ,  11.500f   , //10
        11.600f   ,  11.800f   ,  12.000f   ,  12.100f   ,  12.200f   ,
        12.300f   ,  12.400f   ,  12.500f   ,  12.500f   ,  12.500f   ,
        12.400f   ,  12.300f   ,  12.200f   ,  12.000f   ,  11.800f   ,
        11.200f   ,  11.500f   ,  9.9000f   ,  9.4000f   ,  8.8000f   ,
        8.4000f   ,  7.5000f   ,  6.9000f   ,  6.3000f   ,  5.9000f   ,
        5.5000f   ,  5.2000f   ,  5.0000f   ,  4.0000f   ,  3.5000f   ,
        3.3000f   ,  3.1000f   ,  3.1000f   ,  3.0000f   ,  2.5000f   ,
        3.0000f},

       {10.000f   ,  11.200f   ,  11.300f   ,  11.400f   ,  11.500f   , //11
        11.600f   ,  11.800f   ,  12.000f   ,  12.100f   ,  12.200f   ,
        12.300f   ,  12.400f   ,  12.500f   ,  12.500f   ,  12.500f   ,
        12.400f   ,  12.300f   ,  12.200f   ,  12.000f   ,  11.800f   ,
        11.200f   ,  11.500f   ,  9.9000f   ,  9.4000f   ,  8.8000f   ,
        8.4000f   ,  7.5000f   ,  6.9000f   ,  6.3000f   ,  5.9000f   ,
        5.5000f   ,  5.2000f   ,  5.0000f   ,  4.0000f   ,  3.5000f   ,
        3.3000f   ,  3.1000f   ,  3.1000f   ,  3.0000f   ,  2.5000f   ,
        3.0000f},

       {160.83f   ,  82.800f   ,  58.575f   ,  43.683f   ,  34.792f   , //12
        28.650f   ,  24.367f   ,  20.917f   ,  18.192f   ,  16.300f   ,
        14.608f   ,  13.017f   ,  12.250f   ,  11.700f   ,  12.017f   ,
        14.075f   ,  15.842f   ,  16.433f   ,  16.042f   ,  15.008f   ,
        12.575f   ,  10.708f   ,  9.2000f   ,  8.0167f   ,  7.2833f   ,
        7.0750f   ,  6.6333f   ,  6.1250f   ,  5.6583f   ,  5.2750f   ,
        4.9333f   ,  4.6250f   ,  4.4583f   ,  3.7333f   ,  3.3833f   ,
        3.1833f   ,  2.9833f   ,  2.7500f   ,  2.3667f   ,  2.2000f   ,
        2.6000f},

       {300.00f   ,  140.00f   ,  97.000f   ,  70.000f   ,  55.000f   , //13
        45.000f   ,  37.000f   ,  31.000f   ,  26.000f   ,  23.000f   ,
        20.000f   ,  17.000f   ,  15.500f   ,  14.500f   ,  14.700f   ,
        18.500f   ,  22.000f   ,  23.000f   ,  22.500f   ,  20.700f   ,
        16.500f   ,  14.000f   ,  11.500f   ,  9.6000f   ,  8.6000f   ,
        8.5000f   ,  8.3000f   ,  7.6000f   ,  7.0000f   ,  6.4000f   ,
        5.9000f   ,  5.5000f   ,  5.3000f   ,  4.4000f   ,  4.1000f   ,
        3.9000f   ,  3.7000f   ,  3.3000f   ,  2.6000f   ,  2.5000f   ,
        3.0000f},

// Elastic cross section for p-p
       {1100.0f   ,  115.00f   ,  105.00f   ,  100.00f   ,  56.000f   , //14
        40.000f   ,  27.000f   ,  22.000f   ,  21.000f   ,  20.000f   ,
        20.000f   ,  20.000f   ,  20.500f   ,  21.000f   ,  22.000f   ,
        23.000f   ,  24.000f   ,  24.000f   ,  24.400f   ,  24.500f   ,
        25.000f   ,  25.500f   ,  26.000f   ,  26.500f   ,  27.000f   ,
        27.000f   ,  26.000f   ,  23.000f   ,  21.500f   ,  20.000f   ,
        19.000f   ,  18.000f   ,  17.000f   ,  13.000f   ,  11.500f   ,
        10.300f   ,  9.4000f   ,  9.0000f   ,  8.8000f   ,  7.0000f   ,
        7.5000f},

       {200.00f   ,  163.00f   ,  141.00f   ,  120.00f   ,  111.00f   , //15
        99.500f   ,  92.500f   ,  86.500f   ,  82.000f   ,  78.000f   ,
        74.000f   ,  71.000f   ,  67.500f   ,  65.000f   ,  62.500f   ,
        59.700f   ,  58.100f   ,  56.300f   ,  54.700f   ,  52.700f   ,
        50.000f   ,  48.400f   ,  47.000f   ,  46.000f   ,  45.200f   ,
        42.800f   ,  39.200f   ,  36.300f   ,  32.800f   ,  30.400f   ,
        28.100f   ,  26.300f   ,  24.500f   ,  19.250f   ,  16.840f   ,
        14.600f   ,  12.340f   ,  11.210f   ,  8.8500f   ,  7.5000f   ,
        7.5000f}    ,

       {4200.0f   ,  440.00f   ,  420.00f   ,  400.00f   ,  230.00f   , //16
        160.00f   ,  105.00f   ,  80.000f   ,  62.000f   ,  50.000f   ,
        45.000f   ,  41.000f   ,  38.000f   ,  36.000f   ,  35.000f   ,
        34.000f   ,  33.000f   ,  32.000f   ,  31.500f   ,  31.000f   ,
        30.500f   ,  30.000f   ,  29.500f   ,  29.000f   ,  28.500f   ,
        28.000f   ,  26.000f   ,  23.000f   ,  21.500f   ,  20.000f   ,
        19.000f   ,  18.000f   ,  17.000f   ,  13.000f   ,  11.500f   ,
        10.300f   ,  9.4000f   ,  9.0000f   ,  8.8000f   ,  7.0000f   ,
        7.5000f}    ,

       {185.88f   ,  133.23f   ,  119.37f   ,  102.86f   ,  93.102f   , //17
        82.752f   ,  76.205f   ,  71.008f   ,  67.366f   ,  64.096f   ,
        60.891f   ,  58.501f   ,  55.735f   ,  53.773f   ,  51.839f   ,
        49.671f   ,  48.485f   ,  47.045f   ,  45.803f   ,  44.306f   ,
        42.623f   ,  41.786f   ,  41.115f   ,  40.630f   ,  40.129f   ,
        38.242f   ,  35.233f   ,  32.662f   ,  29.639f   ,  27.573f   ,
        25.536f   ,  23.948f   ,  22.356f   ,  17.723f   ,  15.614f   ,
        13.653f   ,  11.675f   ,  10.653f   ,  8.6198f   ,  7.4464f   ,
        7.4821f}   ,

       {1100.0f   ,  115.00f   ,  105.00f   ,  100.00f   ,  56.000f   , //18
        40.000f   ,  27.000f   ,  22.000f   ,  21.000f   ,  20.000f   ,
        20.000f   ,  19.067f   ,  19.333f   ,  19.500f   ,  19.833f   ,
        20.567f   ,  21.800f   ,  22.900f   ,  23.869f   ,  23.809f   ,
        22.161f   ,  21.488f   ,  19.732f   ,  19.433f   ,  19.345f   ,
        19.029f   ,  18.121f   ,  16.280f   ,  15.258f   ,  14.280f   ,
        13.644f   ,  12.963f   ,  12.316f   ,  9.5333f   ,  8.4333f   ,
        7.5728f   ,  6.9696f   ,  6.7518f   ,  6.6175f   ,  5.6000f   ,
        6.1145f}   ,

       {157.65f   ,  73.701f   ,  76.096f   ,  68.571f   ,  57.305f   , //19
        49.257f   ,  43.616f   ,  40.024f   ,  38.098f   ,  36.287f   ,
        34.674f   ,  33.105f   ,  31.712f   ,  30.685f   ,  29.613f   ,
        28.602f   ,  28.336f   ,  28.075f   ,  27.786f   ,  27.215f   ,
        26.380f   ,  26.146f   ,  25.108f   ,  24.783f   ,  24.360f   ,
        23.219f   ,  21.431f   ,  20.095f   ,  18.382f   ,  17.267f   ,
        16.100f   ,  15.175f   ,  14.271f   ,  11.573f   ,  10.305f   ,
        9.1471f   ,  8.0149f   ,  7.4349f   ,  6.2499f   ,  5.8928f   ,
        6.0774f}   ,

       {1100.0f   ,  115.00f   ,  105.00f   ,  100.00f   ,  56.000f   , //20
        40.000f   ,  27.000f   ,  22.000f   ,  21.000f   ,  20.000f   ,
        20.000f   ,  19.067f   ,  19.333f   ,  19.500f   ,  19.833f   ,
        20.567f   ,  21.800f   ,  22.900f   ,  23.869f   ,  23.809f   ,
        22.161f   ,  21.488f   ,  19.732f   ,  19.433f   ,  19.345f   ,
        19.029f   ,  18.121f   ,  16.280f   ,  15.258f   ,  14.280f   ,
        13.644f   ,  12.963f   ,  12.316f   ,  9.5333f   ,  8.4333f   ,
        7.5728f   ,  6.9696f   ,  6.7518f   ,  6.6175f   ,  5.6000f   ,
        6.1145f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //21
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

       {1100.0f   ,  115.00f   ,  105.00f   ,  100.00f   ,  56.000f   , //22
        40.000f   ,  27.000f   ,  22.000f   ,  21.000f   ,  20.000f   ,
        20.000f   ,  19.067f   ,  19.333f   ,  19.500f   ,  19.833f   ,
        20.567f   ,  21.800f   ,  22.900f   ,  23.869f   ,  23.809f   ,
        22.161f   ,  21.488f   ,  19.732f   ,  19.433f   ,  19.345f   ,
        19.029f   ,  18.121f   ,  16.280f   ,  15.258f   ,  14.280f   ,
        13.644f   ,  12.963f   ,  12.316f   ,  9.5333f   ,  8.4333f   ,
        7.5728f   ,  6.9696f   ,  6.7518f   ,  6.6175f   ,  5.6000f   ,
        6.1145f}   ,

       {185.88f   ,  133.23f   ,  119.37f   ,  102.86f   ,  93.102f   , //23
        82.752f   ,  76.205f   ,  71.008f   ,  67.366f   ,  64.096f   ,
        60.891f   ,  58.104f   ,  55.241f   ,  53.140f   ,  50.934f   ,
        48.660f   ,  47.566f   ,  46.585f   ,  45.581f   ,  44.003f   ,
        41.134f   ,  39.374f   ,  36.878f   ,  35.523f   ,  34.503f   ,
        32.334f   ,  29.365f   ,  27.370f   ,  24.705f   ,  22.921f   ,
        21.229f   ,  19.879f   ,  18.559f   ,  14.625f   ,  12.758f   ,
        11.041f   ,  9.3440f   ,  8.5484f   ,  6.7104f   ,  6.0000f   ,
        6.1131f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //24
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

       {157.65f   ,  73.701f   ,  76.096f   ,  68.571f   ,  57.305f   , //25
        49.257f   ,  43.616f   ,  40.024f   ,  38.098f   ,  36.287f   ,
        34.674f   ,  33.105f   ,  31.712f   ,  30.685f   ,  29.613f   ,
        28.602f   ,  28.336f   ,  28.075f   ,  27.786f   ,  27.215f   ,
        26.380f   ,  26.146f   ,  25.108f   ,  24.783f   ,  24.360f   ,
        23.219f   ,  21.431f   ,  20.095f   ,  18.382f   ,  17.267f   ,
        16.100f   ,  15.175f   ,  14.271f   ,  11.573f   ,  10.305f   ,
        9.1471f   ,  8.0149f   ,  7.4349f   ,  6.2499f   ,  5.8928f   ,
        6.0774f}   ,

       {1100.0f   ,  115.00f   ,  105.00f   ,  100.00f   ,  56.000f   , //26
        40.000f   ,  27.000f   ,  22.000f   ,  21.000f   ,  20.000f   ,
        20.000f   ,  18.133f   ,  18.167f   ,  18.000f   ,  17.667f   ,
        18.133f   ,  19.600f   ,  21.800f   ,  23.338f   ,  23.118f   ,
        19.323f   ,  17.476f   ,  13.464f   ,  12.367f   ,  11.691f   ,
        11.057f   ,  10.242f   ,  9.5593f   ,  9.0151f   ,  8.5591f   ,
        8.2884f   ,  7.9253f   ,  7.6311f   ,  6.0667f   ,  5.3667f   ,
        4.8456f   ,  4.5392f   ,  4.5036f   ,  4.4351f   ,  4.2000f   ,
        4.7289f}   ,

       {1100.0f   ,  115.00f   ,  105.00f   ,  100.00f   ,  56.000f   , //27
        40.000f   ,  27.000f   ,  22.000f   ,  21.000f   ,  20.000f   ,
        20.000f   ,  18.133f   ,  18.167f   ,  18.000f   ,  17.667f   ,
        18.133f   ,  19.600f   ,  21.800f   ,  23.338f   ,  23.118f   ,
        19.323f   ,  17.476f   ,  13.464f   ,  12.367f   ,  11.691f   ,
        11.057f   ,  10.242f   ,  9.5593f   ,  9.0151f   ,  8.5591f   ,
        8.2884f   ,  7.9253f   ,  7.6311f   ,  6.0667f   ,  5.3667f   ,
        4.8456f   ,  4.5392f   ,  4.5036f   ,  4.4351f   ,  4.2000f   ,
        4.7289f}   ,

       {157.65f   ,  73.701f   ,  76.096f   ,  68.571f   ,  57.305f   , //28
        49.257f   ,  43.616f   ,  40.024f   ,  38.098f   ,  36.287f   ,
        34.674f   ,  32.708f   ,  31.218f   ,  30.052f   ,  28.707f   ,
        27.591f   ,  27.417f   ,  27.615f   ,  27.564f   ,  26.913f   ,
        24.891f   ,  23.734f   ,  20.871f   ,  19.677f   ,  18.734f   ,
        17.311f   ,  15.563f   ,  14.803f   ,  13.448f   ,  12.615f   ,
        11.794f   ,  11.106f   ,  10.474f   ,  8.4745f   ,  7.4498f   ,
        6.5350f   ,  5.6835f   ,  5.3300f   ,  4.3406f   ,  4.4464f   ,
        4.7083f}   ,

       {143.53f   ,  43.935f   ,  54.462f   ,  51.429f   ,  39.407f   , //29
        32.510f   ,  27.321f   ,  24.532f   ,  23.465f   ,  22.383f   ,
        21.566f   ,  20.209f   ,  19.453f   ,  18.825f   ,  18.046f   ,
        17.562f   ,  17.802f   ,  18.360f   ,  18.667f   ,  18.519f   ,
        17.514f   ,  17.120f   ,  14.985f   ,  14.306f   ,  13.663f   ,
        12.753f   ,  11.596f   ,  11.165f   ,  10.287f   ,  9.7882f   ,
        9.2294f   ,  8.7539f   ,  8.3300f   ,  6.9480f   ,  6.2234f   ,
        5.5881f   ,  5.0189f   ,  4.7733f   ,  4.1104f   ,  4.3929f   ,
        4.6905f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //30
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //31
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //32
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

       {1100.0f   ,  115.00f   ,  105.00f   ,  100.00f   ,  56.000f   , //33
        40.000f   ,  27.000f   ,  22.000f   ,  21.000f   ,  20.000f   ,
        20.000f   ,  18.133f   ,  18.167f   ,  18.000f   ,  17.667f   ,
        18.133f   ,  19.600f   ,  21.800f   ,  23.338f   ,  23.118f   ,
        19.323f   ,  17.476f   ,  13.464f   ,  12.367f   ,  11.691f   ,
        11.057f   ,  10.242f   ,  9.5593f   ,  9.0151f   ,  8.5591f   ,
        8.2884f   ,  7.9253f   ,  7.6311f   ,  6.0667f   ,  5.3667f   ,
        4.8456f   ,  4.5392f   ,  4.5036f   ,  4.4351f   ,  4.2000f   ,
        4.7289f}  ,

       {143.53f   ,  43.935f   ,  54.462f   ,  51.429f   ,  39.407f   , //34
        32.510f   ,  27.321f   ,  24.532f   ,  23.465f   ,  22.383f   ,
        21.566f   ,  20.209f   ,  19.453f   ,  18.825f   ,  18.046f   ,
        17.562f   ,  17.802f   ,  18.360f   ,  18.667f   ,  18.519f   ,
        17.514f   ,  17.120f   ,  14.985f   ,  14.306f   ,  13.663f   ,
        12.753f   ,  11.596f   ,  11.165f   ,  10.287f   ,  9.7882f   ,
        9.2294f   ,  8.7539f   ,  8.3300f   ,  6.9480f   ,  6.2234f   ,
        5.5881f   ,  5.0189f   ,  4.7733f   ,  4.1104f   ,  4.3929f   ,
        4.6905f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //35
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   }
};

//---------------------------------------------------------------------
// Inelastic scattering on free protons
//---------------------------------------------------------------------

const G4float G4HadronCrossSections::csin[NPARTS][TSIZE] = {

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //1
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //2
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //3
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //4
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //5
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //6
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

// Inelastic cross section for piplus - p
      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //7
       0.00000f   , 0.00000f   , 0.50000f   ,  1.2000f   ,  1.7000f   ,
        2.2500f   ,  3.0000f   ,  3.6000f   ,  4.5000f   ,  5.4000f   ,
        6.3000f   ,  8.6000f   ,  9.0000f   ,  10.000f   ,  11.500f   ,
        14.000f   ,  17.000f   ,  19.500f   ,  22.000f   ,  24.000f   ,
        21.500f   ,  18.500f   ,  19.000f   ,  20.500f   ,  22.200f   ,
        23.000f   ,  23.300f   ,  23.000f   ,  21.000f   ,  20.500f   ,
        20.200f   ,  20.100f   ,  20.000f   ,  20.000f   ,  20.000f   ,
        21.000f}   ,


      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //8
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

// Inelastic cross section for piminus - p
      {0.00000f   ,  3.0000f   ,  9.2000f   ,  20.500f   ,  36.500f   , //9
        45.000f   ,  28.000f   ,  19.500f   ,  15.500f   ,  14.200f   ,
        15.500f   ,  17.500f   ,  20.000f   ,  23.000f   ,  26.000f   ,
        20.000f   ,  23.000f   ,  26.500f   ,  32.000f   ,  35.000f   ,
        28.500f   ,  22.000f   ,  22.500f   ,  23.500f   ,  24.000f   ,
        24.500f   ,  26.000f   ,  27.500f   ,  27.500f   ,  27.000f   ,
        26.500f   ,  25.500f   ,  25.000f   ,  23.000f   ,  22.500f   ,
        22.200f   ,  22.000f   ,  22.000f   ,  21.200f   ,  20.700f   ,
        21.000f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //10
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.50000f   ,  1.5000f   ,  2.7000f   ,  3.8000f   ,  4.8000f   ,
        6.5000f   ,  7.6000f   ,  8.4000f   ,  9.0000f   ,  9.4000f   ,
        9.8000f   ,  10.500f   ,  11.000f   ,  11.500f   ,  11.800f   ,
        12.200f   ,  12.400f   ,  12.600f   ,  13.200f   ,  13.500f   ,
        13.700f   ,  14.000f   ,  14.200f   ,  14.500f   ,  16.400f   ,
        17.000f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //11
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.50000f   ,  1.5000f   ,  2.7000f   ,  3.8000f   ,  4.8000f   ,
        6.5000f   ,  7.6000f   ,  8.4000f   ,  9.0000f   ,  9.4000f   ,
        9.8000f   ,  10.500f   ,  11.000f   ,  11.500f   ,  11.800f   ,
        12.200f   ,  12.400f   ,  12.600f   ,  13.200f   ,  13.500f   ,
        13.700f   ,  14.000f   ,  14.200f   ,  14.500f   ,  16.400f   ,
        17.000f}   ,

       {266.67f   ,  133.33f   ,  83.333f   ,  57.083f   ,  44.500f   , //12
        33.250f   ,  24.583f   ,  20.833f   ,  18.333f   ,  16.083f   ,
        15.625f   ,  15.083f   ,  14.833f   ,  15.083f   ,  15.833f   ,
        17.042f   ,  18.958f   ,  20.758f   ,  22.533f   ,  22.825f   ,
        21.250f   ,  18.567f   ,  17.767f   ,  18.100f   ,  19.933f   ,
        20.783f   ,  21.225f   ,  21.000f   ,  20.558f   ,  20.258f   ,
        20.017f   ,  19.767f   ,  19.600f   ,  19.183f   ,  18.850f   ,
        18.575f   ,  18.350f   ,  18.175f   ,  17.808f   ,  17.558f   ,
        19.250f}   ,

       {400.00f   ,  200.00f   ,  120.00f   ,  81.000f   ,  62.000f   , //13
        47.000f   ,  35.000f   ,  28.000f   ,  24.000f   ,  21.000f   ,
        19.500f   ,  19.000f   ,  18.800f   ,  19.000f   ,  20.000f   ,
        21.000f   ,  23.000f   ,  25.000f   ,  27.000f   ,  27.500f   ,
        25.500f   ,  22.000f   ,  20.800f   ,  21.000f   ,  23.000f   ,
        24.000f   ,  24.000f   ,  23.800f   ,  23.000f   ,  22.500f   ,
        22.000f   ,  21.600f   ,  21.400f   ,  21.000f   ,  20.500f   ,
        20.200f   ,  19.800f   ,  19.500f   ,  18.600f   ,  17.500f   ,
        20.000f}   ,

// Inelastic cross section for p - p
      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //14
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.10000f   ,  1.5000f   ,
        7.0000f   ,  12.000f   ,  17.000f   ,  19.500f   ,  20.500f   ,
        22.000f   ,  23.500f   ,  24.800f   ,  25.800f   ,  26.500f   ,
        27.000f   ,  27.500f   ,  28.000f   ,  30.000f   ,  31.000f   ,
        32.000f   ,  32.500f   ,  32.500f   ,  33.000f   ,  33.500f   ,
        33.500f}   ,

       {1500.0f   ,  1160.0f   ,  310.00f   ,  230.00f   ,  178.00f   , //15
        153.00f   ,  134.00f   ,  124.00f   ,  113.00f   ,  106.00f   ,
        101.00f   ,  96.000f   ,  92.000f   ,  89.000f   ,  87.000f   ,
        84.000f   ,  81.000f   ,  78.500f   ,  76.500f   ,  75.000f   ,
        72.000f   ,  70.000f   ,  68.000f   ,  64.500f   ,  63.000f   ,
        62.000f   ,  61.000f   ,  59.500f   ,  58.500f   ,  56.500f   ,
        56.500f   ,  56.000f   ,  55.500f   ,  52.000f   ,  50.000f   ,
        48.000f   ,  45.000f   ,  44.000f   ,  39.200f   ,  34.500f   ,
        34.500f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //16
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.10000f   ,  1.5000f   ,
        7.0000f   ,  12.000f   ,  17.000f   ,  19.500f   ,  20.500f   ,
        22.000f   ,  23.500f   ,  24.800f   ,  25.800f   ,  26.500f   ,
        27.000f   ,  27.500f   ,  28.000f   ,  30.000f   ,  31.000f   ,
        32.000f   ,  32.500f   ,  32.500f   ,  33.000f   ,  33.500f   ,
        34.000f}   ,

       {1394.1f   ,  948.17f   ,  262.43f   ,  197.14f   ,  149.30f   , //17
        127.25f   ,  110.39f   ,  101.79f   ,  92.834f   ,  87.104f   ,
        83.109f   ,  79.099f   ,  75.965f   ,  73.627f   ,  72.161f   ,
        69.889f   ,  67.595f   ,  65.595f   ,  64.057f   ,  63.054f   ,
        61.377f   ,  60.434f   ,  59.485f   ,  56.970f   ,  55.931f   ,
        55.398f   ,  54.827f   ,  53.538f   ,  52.861f   ,  51.247f   ,
        51.344f   ,  50.992f   ,  50.644f   ,  47.876f   ,  46.358f   ,
        44.887f   ,  42.577f   ,  41.815f   ,  38.180f   ,  34.254f   ,
        34.418f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //18
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.97815E-01f,  1.4577f   ,
        6.2052f   ,  10.112f   ,  12.902f   ,  14.300f   ,  14.688f   ,
        15.505f   ,  16.379f   ,  17.554f   ,  18.309f   ,  18.920f   ,
        19.389f   ,  19.804f   ,  20.284f   ,  22.000f   ,  22.733f   ,
        23.527f   ,  24.097f   ,  24.382f   ,  24.816f   ,  26.800f   ,
        27.719f}   ,

       {1182.4f   ,  524.50f   ,  167.30f   ,  131.43f   ,  91.895f   , //19
        75.743f   ,  63.184f   ,  57.376f   ,  52.502f   ,  49.313f   ,
        47.326f   ,  44.762f   ,  43.222f   ,  42.015f   ,  41.221f   ,
        40.244f   ,  39.504f   ,  39.145f   ,  38.860f   ,  38.731f   ,
        37.987f   ,  37.814f   ,  36.326f   ,  34.750f   ,  33.953f   ,
        33.635f   ,  33.349f   ,  32.938f   ,  32.785f   ,  32.092f   ,
        32.373f   ,  32.312f   ,  32.329f   ,  31.261f   ,  30.597f   ,
        30.073f   ,  29.228f   ,  29.182f   ,  27.683f   ,  27.107f   ,
        27.956f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //20
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.97815E-01f,  1.4577f   ,
        6.2052f   ,  10.112f   ,  12.902f   ,  14.300f   ,  14.688f   ,
        15.505f   ,  16.379f   ,  17.554f   ,  18.309f   ,  18.920f   ,
        19.389f   ,  19.804f   ,  20.284f   ,  22.000f   ,  22.733f   ,
        23.527f   ,  24.097f   ,  24.382f   ,  24.816f   ,  26.800f   ,
        27.719f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //21
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //22
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.97815E-01f,  1.4577f   ,
        6.2052f   ,  10.112f   ,  12.902f   ,  14.300f   ,  14.688f   ,
        15.505f   ,  16.379f   ,  17.554f   ,  18.309f   ,  18.920f   ,
        19.389f   ,  19.804f   ,  20.284f   ,  22.000f   ,  22.733f   ,
        23.527f   ,  24.097f   ,  24.382f   ,  24.816f   ,  26.800f   ,
        27.719f}   ,

       {1394.1f   ,  948.17f   ,  262.43f   ,  197.14f   ,  149.30f   , //23
        127.25f   ,  110.39f   ,  101.79f   ,  92.834f   ,  87.104f   ,
        83.109f   ,  78.563f   ,  75.292f   ,  72.760f   ,  70.900f   ,
        68.467f   ,  66.314f   ,  64.955f   ,  63.746f   ,  62.623f   ,
        59.233f   ,  56.946f   ,  53.355f   ,  49.810f   ,  48.090f   ,
        46.839f   ,  45.695f   ,  44.863f   ,  44.062f   ,  42.599f   ,
        42.684f   ,  42.328f   ,  42.041f   ,  39.508f   ,  37.880f   ,
        36.299f   ,  34.075f   ,  33.553f   ,  29.723f   ,  27.600f   ,
        28.120f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //24
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000    },

       {1182.4f   ,  524.50f   ,  167.30f   ,  131.43f   ,  91.895f   , //25
        75.743f   ,  63.184f   ,  57.376f   ,  52.502f   ,  49.313f   ,
        47.326f   ,  44.762f   ,  43.222f   ,  42.015f   ,  41.221f   ,
        40.244f   ,  39.504f   ,  39.145f   ,  38.860f   ,  38.731f   ,
        37.987f   ,  37.814f   ,  36.326f   ,  34.750f   ,  33.953f   ,
        33.635f   ,  33.349f   ,  32.938f   ,  32.785f   ,  32.092f   ,
        32.373f   ,  32.312f   ,  32.329f   ,  31.261f   ,  30.597f   ,
        30.073f   ,  29.228f   ,  29.182f   ,  27.683f   ,  27.107f   ,
        27.956f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //26
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.95639E-01f,  1.4154f   ,
        5.4104f   ,  8.2240f   ,  8.8031f   ,  9.1000f   ,  8.8761f   ,
        9.0095f   ,  9.2576f   ,  10.307f   ,  10.818f   ,  11.341f   ,
        11.778f   ,  12.108f   ,  12.569f   ,  14.000f   ,  14.467f   ,
        15.054f   ,  15.694f   ,  16.263f   ,  16.632f   ,  20.100f   ,
        21.438f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //27
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.95639E-01f,  1.4154f   ,
        5.4104f   ,  8.2240f   ,  8.8031f   ,  9.1000f   ,  8.8761f   ,
        9.0095f   ,  9.2576f   ,  10.307f   ,  10.818f   ,  11.341f   ,
        11.778f   ,  12.108f   ,  12.569f   ,  14.000f   ,  14.467f   ,
        15.054f   ,  15.694f   ,  16.263f   ,  16.632f   ,  20.100f   ,
        21.438f}   ,

       {1182.4f   ,  524.50f   ,  167.30f   ,  131.43f   ,  91.895f   , //28
        75.743f   ,  63.184f   ,  57.376f   ,  52.502f   ,  49.313f   ,
        47.326f   ,  44.225f   ,  42.549f   ,  41.148f   ,  39.960f   ,
        38.822f   ,  38.223f   ,  38.505f   ,  38.549f   ,  38.301f   ,
        35.843f   ,  34.326f   ,  30.196f   ,  27.590f   ,  26.112f   ,
        25.076f   ,  24.217f   ,  24.264f   ,  23.985f   ,  23.445f   ,
        23.713f   ,  23.647f   ,  23.726f   ,  22.892f   ,  22.119f   ,
        21.485f   ,  20.726f   ,  20.921f   ,  19.226f   ,  20.454f   ,
        21.658f}   ,

       {1076.5f   ,  312.66f   ,  119.74f   ,  98.571f   ,  63.193f   , //29
        49.990f   ,  39.579f   ,  35.168f   ,  32.335f   ,  30.417f   ,
        29.434f   ,  27.325f   ,  26.514f   ,  25.775f   ,  25.120f   ,
        24.711f   ,  24.818f   ,  25.600f   ,  26.106f   ,  26.355f   ,
        25.220f   ,  24.760f   ,  21.681f   ,  20.060f   ,  19.044f   ,
        18.474f   ,  18.044f   ,  18.301f   ,  18.347f   ,  18.192f   ,
        18.557f   ,  18.639f   ,  18.870f   ,  18.769f   ,  18.478f   ,
        18.372f   ,  18.302f   ,  18.735f   ,  18.206f   ,  20.207f   ,
        21.576f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //30
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //31
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //32
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //33
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.95639E-01f,  1.4154f   ,
        5.4104f   ,  8.2240f   ,  8.8031f   ,  9.1000f   ,  8.8761f   ,
        9.0095f   ,  9.2576f   ,  10.307f   ,  10.818f   ,  11.341f   ,
        11.778f   ,  12.108f   ,  12.569f   ,  14.000f   ,  14.467f   ,
        15.054f   ,  15.694f   ,  16.263f   ,  16.632f   ,  20.100f   ,
        21.438f}    ,

       {1076.5f   ,  312.66f   ,  119.74f   ,  98.571f   ,  63.193f   , //34
        49.990f   ,  39.579f   ,  35.168f   ,  32.335f   ,  30.417f   ,
        29.434f   ,  27.325f   ,  26.514f   ,  25.775f   ,  25.120f   ,
        24.711f   ,  24.818f   ,  25.600f   ,  26.106f   ,  26.355f   ,
        25.220f   ,  24.760f   ,  21.681f   ,  20.060f   ,  19.044f   ,
        18.474f   ,  18.044f   ,  18.301f   ,  18.347f   ,  18.192f   ,
        18.557f   ,  18.639f   ,  18.870f   ,  18.769f   ,  18.478f   ,
        18.372f   ,  18.302f   ,  18.735f   ,  18.206f   ,  20.207f   ,
        21.576f}   ,

      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //35
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   }

};

//---------------------------------------------------------------------
// Elastic scattering of pion on nucleus
//---------------------------------------------------------------------

const G4float G4HadronCrossSections::cspiel[3][TSIZE] = {

// Elastic cross section for Pi on Al (mb)
      {0.00000f   ,  350.00f   ,  580.00f   ,  600.00f   ,  550.00f   , //1
        450.00f   ,  410.00f   ,  370.00f   ,  340.00f   ,  230.00f   ,
        220.00f   ,  205.00f   ,  180.00f   ,  155.00f   ,  145.00f   ,
        140.00f   ,  160.00f   ,  195.00f   ,  235.00f   ,  250.00f   ,
        270.00f   ,  280.00f   ,  300.00f   ,  300.00f   ,  290.00f   ,
        285.00f   ,  265.00f   ,  240.00f   ,  230.00f   ,  222.00f   ,
        204.00f   ,  196.00f   ,  190.00f   ,  170.00f   ,  170.00f   ,
        160.00f   ,  150.00f   ,  140.00f   ,  120.00f   ,  80.000f   ,
        80.000f},

// Elastic cross section for Pi on Cu (mb)
      {0.00000f   ,  700.00f   ,  1000.0f   ,  1200.0f   ,  1300.0f   , //2
        1300.0f   ,  1250.0f   ,  1250.0f   ,  1100.0f   ,  1000.0f   ,
        940.00f   ,  740.00f   ,  700.00f   ,  670.00f   ,  660.00f   ,
        670.00f   ,  680.00f   ,  700.00f   ,  735.00f   ,  800.00f   ,
        810.00f   ,  820.00f   ,  820.00f   ,  810.00f   ,  800.00f   ,
        800.00f   ,  700.00f   ,  600.00f   ,  500.00f   ,  470.00f   ,
        440.00f   ,  410.00f   ,  380.00f   ,  330.00f   ,  330.00f   ,
        330.00f   ,  330.00f   ,  330.00f   ,  285.00f   ,  240.00f   ,
        240.00f},

// Elastic cross section for Pi on Pb (mb)
      {0.00000f   ,  1700.0f   ,  2200.0f   ,  2200.0f   ,  1800.0f   , //3
        1300.0f   ,  1200.0f   ,  900.00f   ,  900.00f   ,  1000.0f   ,
        1100.0f   ,  1300.0f   ,  1400.0f   ,  1420.0f   ,  1490.0f   ,
        1560.0f   ,  1580.0f   ,  1690.0f   ,  1795.0f   ,  2000.0f   ,
        2070.0f   ,  2140.0f   ,  2050.0f   ,  2010.0f   ,  1970.0f   ,
        1880.0f   ,  1690.0f   ,  1500.0f   ,  1420.0f   ,  1390.0f   ,
        1350.0f   ,  1360.0f   ,  1370.0f   ,  1280.0f   ,  1290.0f   ,
        1295.0f   ,  1250.0f   ,  1200.0f   ,  1050.0f   ,  900.00f   ,
        900.00f}
};

//---------------------------------------------------------------------
// Inelastic scattering of pion on nucleus
//---------------------------------------------------------------------

const G4float G4HadronCrossSections::cspiin[3][TSIZE] = {

// Inelastic cross section for Pi on Al (mb)
      {0.00000f   ,  200.00f   ,  320.00f   ,  500.00f   ,  600.00f   , //1
        600.00f   ,  590.00f   ,  530.00f   ,  510.00f   ,  470.00f   ,
        430.00f   ,  425.00f   ,  420.00f   ,  425.00f   ,  425.00f   ,
        430.00f   ,  430.00f   ,  435.00f   ,  435.00f   ,  440.00f   ,
        430.00f   ,  430.00f   ,  420.00f   ,  420.00f   ,  420.00f   ,
        415.00f   ,  415.00f   ,  410.00f   ,  410.00f   ,  408.00f   ,
        406.00f   ,  404.00f   ,  400.00f   ,  380.00f   ,  340.00f   ,
        340.00f   ,  340.00f   ,  340.00f   ,  340.00f   ,  340.00f   ,
        340.00f}    ,

// Inelastic cross section for Pi on Cu (mb)
      {0.00000f   ,  400.00f   ,  800.00f   ,  1000.0f   ,  1100.0f   , //2
        1200.0f   ,  1150.0f   ,  1050.0f   ,  1000.0f   ,  900.00f   ,
        860.00f   ,  860.00f   ,  850.00f   ,  850.00f   ,  840.00f   ,
        830.00f   ,  820.00f   ,  810.00f   ,  805.00f   ,  800.00f   ,
        800.00f   ,  800.00f   ,  800.00f   ,  800.00f   ,  800.00f   ,
        800.00f   ,  800.00f   ,  800.00f   ,  800.00f   ,  780.00f   ,
        760.00f   ,  740.00f   ,  720.00f   ,  720.00f   ,  700.00f   ,
        690.00f   ,  680.00f   ,  670.00f   ,  665.00f   ,  660.00f   ,
        660.00f}    ,

// Inelastic cross section for Pi on Pb (mb)
      {0.00000f   ,  1000.0f   ,  1900.0f   ,  2600.0f   ,  2900.0f   , //3
        3000.0f   ,  2800.0f   ,  2600.0f   ,  2500.0f   ,  2300.0f   ,
        2200.0f   ,  2000.0f   ,  1900.0f   ,  1880.0f   ,  1860.0f   ,
        1840.0f   ,  1820.0f   ,  1810.0f   ,  1805.0f   ,  1800.0f   ,
        1780.0f   ,  1760.0f   ,  1750.0f   ,  1740.0f   ,  1730.0f   ,
        1720.0f   ,  1710.0f   ,  1700.0f   ,  1680.0f   ,  1660.0f   ,
        1650.0f   ,  1640.0f   ,  1630.0f   ,  1620.0f   ,  1610.0f   ,
        1605.0f   ,  1600.0f   ,  1600.0f   ,  1550.0f   ,  1500.0f   ,
        1500.0f}    
};

//---------------------------------------------------------------------
// Elastic scattering of proton on nucleus
//---------------------------------------------------------------------

const G4float G4HadronCrossSections::cspnel[3][TSIZE] = {

// Elastic cross section for P on Al (mb)
       {2100.0f   ,  1800.0f   ,  1500.0f   ,  1050.0f   ,  900.00f   , //1
        950.00f   ,  800.00f   ,  650.00f   ,  570.00f   ,  390.00f   ,
        300.00f   ,  240.00f   ,  230.00f   ,  230.00f   ,  220.00f   ,
        220.00f   ,  225.00f   ,  225.00f   ,  240.00f   ,  240.00f   ,
        290.00f   ,  330.00f   ,  335.00f   ,  350.00f   ,  355.00f   ,
        370.00f   ,  350.00f   ,  330.00f   ,  310.00f   ,  290.00f   ,
        270.00f   ,  265.00f   ,  260.00f   ,  230.00f   ,  210.00f   ,
        210.00f   ,  200.00f   ,  200.00f   ,  190.00f   ,  180.00f   ,
        180.00f},

// Elastic cross section for P on Cu (mb)
       {3800.0f   ,  2900.0f   ,  1850.0f   ,  1550.0f   ,  1450.0f   , //2
        1520.0f   ,  1460.0f   ,  1300.0f   ,  1140.0f   ,  880.00f   ,
        700.00f   ,  620.00f   ,  540.00f   ,  560.00f   ,  460.00f   ,
        460.00f   ,  470.00f   ,  470.00f   ,  480.00f   ,  480.00f   ,
        580.00f   ,  600.00f   ,  610.00f   ,  620.00f   ,  620.00f   ,
        620.00f   ,  590.00f   ,  580.00f   ,  460.00f   ,  440.00f   ,
        420.00f   ,  400.00f   ,  480.00f   ,  430.00f   ,  380.00f   ,
        380.00f   ,  380.00f   ,  380.00f   ,  380.00f   ,  380.00f   ,
        380.00f},

// Elastic cross section for P on Pb (mb)
       {7000.0f   ,  6000.0f   ,  4500.0f   ,  3350.0f   ,  2700.0f   , //3
        3000.0f   ,  3550.0f   ,  3970.0f   ,  3280.0f   ,  2490.0f   ,
        2100.0f   ,  1510.0f   ,  1440.0f   ,  1370.0f   ,  1370.0f   ,
        1370.0f   ,  1400.0f   ,  1400.0f   ,  1420.0f   ,  1420.0f   ,
        1440.0f   ,  1460.0f   ,  1460.0f   ,  1450.0f   ,  1450.0f   ,
        1470.0f   ,  1400.0f   ,  1400.0f   ,  1380.0f   ,  1370.0f   ,
        1360.0f   ,  1350.0f   ,  1340.0f   ,  1330.0f   ,  1320.0f   ,
        1310.0f   ,  1305.0f   ,  1300.0f   ,  1300.0f   ,  1300.0f   ,
        1300.0f}
};

//---------------------------------------------------------------------
// Inelastic scattering of proton on nucleus
//---------------------------------------------------------------------

const G4float G4HadronCrossSections::cspnin[3][TSIZE] = {

// Inelastic cross section for P on Al (mb)
      {0.00000f   ,  200.00f   ,  400.00f   ,  800.00f   ,  800.00f   , //1
        550.00f   ,  500.00f   ,  450.00f   ,  430.00f   ,  410.00f   ,
        400.00f   ,  390.00f   ,  380.00f   ,  370.00f   ,  370.00f   ,
        370.00f   ,  365.00f   ,  365.00f   ,  360.00f   ,  360.00f   ,
        360.00f   ,  360.00f   ,  365.00f   ,  370.00f   ,  375.00f   ,
        380.00f   ,  400.00f   ,  410.00f   ,  420.00f   ,  430.00f   ,
        440.00f   ,  440.00f   ,  440.00f   ,  440.00f   ,  440.00f   ,
        440.00f   ,  440.00f   ,  440.00f   ,  440.00f   ,  440.00f   ,
        440.00f}    ,

// Inelastic cross section for P on Cu (mb)
      {0.00000f   ,  400.00f   ,  950.00f   ,  1050.0f   ,  1050.0f   , //2
        980.00f   ,  940.00f   ,  900.00f   ,  860.00f   ,  820.00f   ,
        800.00f   ,  780.00f   ,  760.00f   ,  740.00f   ,  740.00f   ,
        740.00f   ,  730.00f   ,  730.00f   ,  720.00f   ,  720.00f   ,
        720.00f   ,  720.00f   ,  730.00f   ,  740.00f   ,  750.00f   ,
        760.00f   ,  800.00f   ,  820.00f   ,  820.00f   ,  820.00f   ,
        820.00f   ,  820.00f   ,  820.00f   ,  820.00f   ,  820.00f   ,
        820.00f   ,  820.00f   ,  820.00f   ,  820.00f   ,  820.00f   ,
        820.00f}   ,

// Inelastic cross section for P on Pb (mb)
      {0.00000f   , 0.00000f   ,  500.00f   ,  1450.0f   ,  1700.0f   , //3
        1800.0f   ,  1750.0f   ,  1730.0f   ,  1720.0f   ,  1710.0f   ,
        1700.0f   ,  1690.0f   ,  1660.0f   ,  1630.0f   ,  1630.0f   ,
        1630.0f   ,  1600.0f   ,  1600.0f   ,  1580.0f   ,  1580.0f   ,
        1580.0f   ,  1580.0f   ,  1600.0f   ,  1630.0f   ,  1650.0f   ,
        1670.0f   ,  1760.0f   ,  1800.0f   ,  1800.0f   ,  1800.0f   ,
        1800.0f   ,  1800.0f   ,  1800.0f   ,  1800.0f   ,  1800.0f   ,
        1800.0f   ,  1800.0f   ,  1800.0f   ,  1800.0f   ,  1800.0f   ,
        1800.0f}    
};

//---------------------------------------------------------------------
// Lab kinetic energy in GeV
//---------------------------------------------------------------------
const G4float G4HadronCrossSections::elab[NELAB] = {
       0.10000E-03f, 0.20000E-03f, 0.30000E-03f, 0.40000E-03f, 0.50000E-03f,
       0.70000E-03f, 0.10000E-02f, 0.20000E-02f, 0.30000E-02f, 0.40000E-02f,
       0.50000E-02f, 0.70000E-02f, 0.10000E-01f, 0.15000E-01f, 0.20000E-01f,
       0.25000E-01f, 0.32700E-01f
};

//---------------------------------------------------------------------
// Tables for low-energy (< 32.7 MeV) neutrons
//---------------------------------------------------------------------

// Atomic weight
const G4float G4HadronCrossSections::cnlwat[NCNLW] = {
        1.0000f   ,  16.000f   ,  27.000f   ,  56.000f   ,  59.000f   ,
        64.000f   ,  91.000f   ,  112.00f   ,  119.00f   ,  127.00f   ,
        137.00f   ,  181.00f   ,  207.00f   ,  209.00f   ,  238.00f   
};
// Elastic cross section
const G4float G4HadronCrossSections::cnlwel[NCNLW][NELAB] = {
       {6000.0f   ,  5500.0f   ,  5200.0f   ,  4900.0f   ,  4800.0f   , //1
        4400.0f   ,  4000.0f   ,  2900.0f   ,  2200.0f   ,  1800.0f   ,
        1400.0f   ,  1100.0f   ,  900.00f   ,  700.00f   ,  600.00f   ,
        560.00f   ,  520.00f}    ,
       {5400.0f   ,  5050.0f   ,  4800.0f   ,  4600.0f   ,  4399.0f   , //2
        4090.0f   ,  3700.0f   ,  2600.0f   ,  1950.0f   ,  1600.0f   ,
        1300.0f   ,  900.00f   ,  700.00f   ,  800.00f   ,  1050.0f   ,
        1250.0f   ,  1320.0f}    ,
       {5500.0f   ,  5150.0f   ,  4900.0f   ,  4699.0f   ,  4490.0f   , //3
        4150.0f   ,  3750.0f   ,  2790.0f   ,  2100.0f   ,  1650.0f   ,
        1300.0f   ,  950.00f   ,  800.00f   ,  860.00f   ,  1000.0f   ,
        1090.0f   ,  1080.0f}    ,
       {5499.0f   ,  4970.0f   ,  4450.0f   ,  4080.0f   ,  3750.0f   , //4
        3380.0f   ,  2900.0f   ,  2400.0f   ,  2380.0f   ,  2350.0f   ,
        2300.0f   ,  2100.0f   ,  1720.0f   ,  1370.0f   ,  1200.0f   ,
        1060.0f   ,  870.00f}    ,
       {5399.0f   ,  4710.0f   ,  4180.0f   ,  3760.0f   ,  3460.0f   , //5
        3150.0f   ,  2730.0f   ,  2270.0f   ,  1850.0f   ,  1850.0f   ,
        2130.0f   ,  2330.0f   ,  2120.0f   ,  1640.0f   ,  1310.0f   ,
        1100.0f   ,  1050.0f}    ,
       {5099.0f   ,  4405.0f   ,  3825.0f   ,  3455.0f   ,  3125.0f   , //6
        2695.0f   ,  2350.0f   ,  1850.0f   ,  1580.0f   ,  1820.0f   ,
        2050.0f   ,  2210.0f   ,  2000.0f   ,  1590.0f   ,  1310.0f   ,
        1120.0f   ,  1040.0f}  ,
       {6290.0f   ,  5960.0f   ,  5640.0f   ,  5370.0f   ,  5150.0f   , //7
        4800.0f   ,  4250.0f   ,  3150.0f   ,  2470.0f   ,  2100.0f   ,
        2230.0f   ,  2420.0f   ,  2450.0f   ,  2050.0f   ,  1760.0f   ,
        1550.0f   ,  1330.0f}  ,
       {6885.0f   ,  6650.0f   ,  6350.0f   ,  6150.0f   ,  6000.0f   , //8
        5700.0f   ,  5360.0f   ,  4250.0f   ,  2800.0f   ,  1870.0f   ,
        1810.0f   ,  1820.0f   ,  2170.0f   ,  2450.0f   ,  2150.0f   ,
        1700.0f   ,  1390.0f}  ,
       {6600.0f   ,  6500.0f   ,  6400.0f   ,  6249.0f   ,  6190.0f   , //9
        5950.0f   ,  5520.0f   ,  4250.0f   ,  2750.0f   ,  1900.0f   ,
        1850.0f   ,  1950.0f   ,  2340.0f   ,  2800.0f   ,  2540.0f   ,
        2100.0f   ,  1760.0f}  ,
       {7400.0f   ,  7200.0f   ,  6999.0f   ,  6840.0f   ,  6655.0f   , //10
        6320.0f   ,  5820.0f   ,  4400.0f   ,  2850.0f   ,  2000.0f   ,
        1800.0f   ,  1800.0f   ,  2150.0f   ,  2600.0f   ,  2350.0f   ,
        1950.0f   ,  2100.0f}  ,
       {7900.0f   ,  7700.0f   ,  7499.0f   ,  7390.0f   ,  7202.0f   , //11
        6810.0f   ,  6360.0f   ,  4920.0f   ,  3450.0f   ,  2600.0f   ,
        2200.0f   ,  1950.0f   ,  2300.0f   ,  2800.0f   ,  2650.0f   ,
        2250.0f   ,  2050.0f}  ,
       {7900.0f   ,  7750.0f   ,  7699.0f   ,  7590.0f   ,  7450.0f   , //12
        7200.0f   ,  6850.0f   ,  5650.0f   ,  4400.0f   ,  3700.0f   ,
        3400.0f   ,  2800.0f   ,  2700.0f   ,  3100.0f   ,  3250.0f   ,
        3100.0f   ,  2750.0f}  ,
       {6100.0f   ,  5950.0f   ,  5750.0f   ,  5599.0f   ,  5440.0f   , //13
        5200.0f   ,  4800.0f   ,  4300.0f   ,  5800.0f   ,  5750.0f   ,
        4800.0f   ,  3420.0f   ,  2650.0f   ,  3200.0f   ,  3650.0f   ,
        3500.0f   ,  2980.0f}  ,
       {6100.0f   ,  5950.0f   ,  5750.0f   ,  5599.0f   ,  5440.0f   , //14
        5200.0f   ,  4800.0f   ,  4300.0f   ,  5800.0f   ,  5750.0f   ,
        4800.0f   ,  3420.0f   ,  2650.0f   ,  3200.0f   ,  3650.0f   ,
        3500.0f   ,  2980.0f}  ,
       {6600.0f   ,  6350.0f   ,  6100.0f   ,  5899.0f   ,  5690.0f   , //15
        5300.0f   ,  4850.0f   ,  4450.0f   ,  5650.0f   ,  5700.0f   ,
        4950.0f   ,  3850.0f   ,  3050.0f   ,  3050.0f   ,  3460.0f   ,
        3650.0f   ,  3340.0f}
};
// Inelastic cross section
const G4float G4HadronCrossSections::cnlwin[NCNLW][NELAB] = {
      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //1
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   },
      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,  1.0000f   , //2
        10.000f   ,  50.000f   ,  100.00f   ,  200.00f   ,  300.00f   ,
        400.00f   ,  600.00f   ,  700.00f   ,  750.00f   ,  700.00f   ,
        700.00f   ,  680.00f}  ,
      {0.00000f   , 0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   , //3
        50.000f   ,  100.00f   ,  260.00f   ,  450.00f   ,  600.00f   ,
        700.00f   ,  800.00f   ,  900.00f   ,  940.00f   ,  900.00f   ,
        860.00f   ,  820.00f}  ,
       {1.0000f   ,  80.000f   ,  200.00f   ,  320.00f   ,  400.00f   , //4
        520.00f   ,  700.00f   ,  1000.0f   ,  1120.0f   ,  1200.0f   ,
        1200.0f   ,  1200.0f   ,  1180.0f   ,  1130.0f   ,  1100.0f   ,
        1090.0f   ,  1080.0f}  ,
       {1.0000f   ,  90.000f   ,  220.00f   ,  340.00f   ,  420.00f   , //5
        550.00f   ,  720.00f   ,  1080.0f   ,  1300.0f   ,  1400.0f   ,
        1420.0f   ,  1420.0f   ,  1380.0f   ,  1260.0f   ,  1190.0f   ,
        1150.0f   ,  1100.0f}  ,
       {1.0000f   ,  95.000f   ,  225.00f   ,  345.00f   ,  425.00f   , //6
        555.00f   ,  750.00f   ,  1150.0f   ,  1500.0f   ,  1680.0f   ,
        1700.0f   ,  1690.0f   ,  1550.0f   ,  1360.0f   ,  1240.0f   ,
        1180.0f   ,  1120.0f}  ,
       {10.000f   ,  140.00f   ,  260.00f   ,  380.00f   ,  450.00f   , //7
        600.00f   ,  750.00f   ,  1200.0f   ,  1580.0f   ,  1800.0f   ,
        1820.0f   ,  1830.0f   ,  1800.0f   ,  1750.0f   ,  1690.0f   ,
        1650.0f   ,  1620.0f}  ,
       {15.000f   ,  150.00f   ,  300.00f   ,  400.00f   ,  500.00f   , //8
        650.00f   ,  840.00f   ,  1500.0f   ,  2100.0f   ,  2130.0f   ,
        2140.0f   ,  2130.0f   ,  2080.0f   ,  2000.0f   ,  1950.0f   ,
        1900.0f   ,  1860.0f}  ,
      {0.00000f   , 0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   , //9
        150.00f   ,  380.00f   ,  1000.0f   ,  1650.0f   ,  2100.0f   ,
        2100.0f   ,  2100.0f   ,  2060.0f   ,  1950.0f   ,  1860.0f   ,
        1800.0f   ,  1740.0f}  ,
      {0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   ,  45.000f   , //10
        180.00f   ,  380.00f   ,  1050.0f   ,  1900.0f   ,  2300.0f   ,
        2300.0f   ,  2200.0f   ,  2150.0f   ,  2000.0f   ,  1900.0f   ,
        1800.0f   ,  1750.0f}  ,
      {0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   ,  48.000f   , //11
        190.00f   ,  390.00f   ,  1080.0f   ,  2000.0f   ,  2400.0f   ,
        2400.0f   ,  2300.0f   ,  2200.0f   ,  2100.0f   ,  1950.0f   ,
        1850.0f   ,  1800.0f}  ,
      {0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   ,  50.000f   , //12
        200.00f   ,  400.00f   ,  1100.0f   ,  2100.0f   ,  2500.0f   ,
        2500.0f   ,  2450.0f   ,  2300.0f   ,  2100.0f   ,  2000.0f   ,
        1900.0f   ,  1850.0f}  ,
      {0.00000f   , 0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   , //13
        100.00f   ,  350.00f   ,  900.00f   ,  1400.0f   ,  2000.0f   ,
        2300.0f   ,  2380.0f   ,  2400.0f   ,  2300.0f   ,  2250.0f   ,
        2200.0f   ,  2120.0f}  ,
      {0.00000f   , 0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   , //14
        100.00f   ,  350.00f   ,  900.00f   ,  1400.0f   ,  2000.0f   ,
        2300.0f   ,  2380.0f   ,  2400.0f   ,  2300.0f   ,  2250.0f   ,
        2200.0f   ,  2120.0f}  ,
      {0.00000f   , 0.00000f   , 0.00000f   ,  1.0000f   ,  10.000f   , //15
        100.00f   ,  400.00f   ,  950.00f   ,  1600.0f   ,  2200.0f   ,
        2550.0f   ,  2750.0f   ,  2700.0f   ,  2600.0f   ,  2540.0f   ,
        2450.0f   ,  2360.0f}
};
// Capture cross section indexed by Z
const G4float G4HadronCrossSections::cscap[100] = {
        6.0000f   ,  5.7000f   ,  5.5000f   ,  5.3000f   ,  5.2000f   ,
        5.1000f   ,  5.0000f   ,  4.9000f   ,  4.8000f   ,  4.8000f   ,
        4.8000f   ,  4.8000f   ,  4.8000f   ,  4.8000f   ,  4.8000f   ,
        4.8000f   ,  4.9000f   ,  5.0000f   ,  5.2000f   ,  5.5000f   ,
        6.0000f   ,  6.7000f   ,  7.5000f   ,  8.5000f   ,  10.000f   ,
        12.000f   ,  14.500f   ,  19.000f   ,  26.500f   ,  40.000f   ,
        75.000f   ,  120.00f   ,  180.00f   ,  260.00f   ,  360.00f   ,
        330.00f   ,  60.000f   ,  7.0000f   ,  9.5000f   ,  20.000f   ,
        75.000f   ,  140.00f   ,  250.00f   ,  360.00f   ,  480.00f   ,
        580.00f   ,  590.00f   ,  500.00f   ,  300.00f   ,  100.00f   ,
        200.00f   ,  300.00f   ,  400.00f   ,  470.00f   ,  500.00f   ,
        430.00f   ,  100.00f   ,  20.000f   ,  22.000f   ,  40.000f   ,
        560.00f   ,  950.00f   ,  1000.0f   ,  1000.0f   ,  1000.0f   ,
        990.00f   ,  920.00f   ,  860.00f   ,  790.00f   ,  740.00f   ,
        650.00f   ,  600.00f   ,  540.00f   ,  470.00f   ,  440.00f   ,
        390.00f   ,  360.00f   ,  340.00f   ,  320.00f   ,  310.00f   ,
        280.00f   ,  2.0000f   ,  2.5000f   ,  6.0000f   ,  13.000f   ,
        38.000f   ,  65.000f   ,  140.00f   ,  280.00f   ,  300.00f   ,
        430.00f   ,  580.00f   ,  650.00f   ,  800.00f   ,  920.00f   ,
        1100.0f   ,  1250.0f   ,  1400.0f   ,  1550.0f   ,  1700.0f   
};

//---------------------------------------------------------------------
// Tables for fission cross sections
//---------------------------------------------------------------------

// Lab kinetic energy in GeV
const G4float G4HadronCrossSections::ekfiss[NFISS] = {
       0.10000E-03f, 0.20000E-03f, 0.30000E-03f, 0.50000E-03f, 0.70000E-03f,
       0.10000E-02f, 0.15000E-02f, 0.20000E-02f, 0.30000E-02f, 0.50000E-02f,
       0.70000E-02f, 0.10000E-01f, 0.15000E-01f, 0.20000E-01f, 0.50000E-01f,
       0.10000f    , 0.20000f    , 0.30000f    , 0.40000f    , 0.50000f    ,
        1000.0f    
};
// Fission cross sections
const G4float G4HadronCrossSections::csfiss[4][NFISS] = {
       {2600.0f   ,  2300.0f   ,  2300.0f   ,  2100.0f   ,  2000.0f   , //1
        1950.0f   ,  1930.0f   ,  1900.0f   ,  1800.0f   ,  1600.0f   ,
        2100.0f   ,  2300.0f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },
       {1850.0f   ,  1400.0f   ,  1300.0f   ,  1150.0f   ,  1100.0f   , //2
        1200.0f   ,  1250.0f   ,  1300.0f   ,  1250.0f   ,  1150.0f   ,
        1600.0f   ,  1900.0f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },
       {1700.0f   ,  1650.0f   ,  1650.0f   ,  1700.0f   ,  1700.0f   , //3
        1800.0f   ,  1900.0f   ,  2000.0f   ,  1950.0f   ,  1800.0f   ,
        2150.0f   ,  2450.0f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   ,
       0.00000f   },
      {0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , 0.00000f   , //4
       0.00000f   ,  250.00f   ,  550.00f   ,  550.00f   ,  550.00f   ,
        550.00f   ,  550.00f   ,  1000.0f   ,  1400.0f   ,  1600.0f   ,
        1500.0f   ,  1400.0f   ,  1300.0f   ,  1200.0f   ,  1100.0f   ,
        1000.0f}
};

const G4float G4HadronCrossSections::alpha[NPARTS] = {
                     0.7f,0.7f,0.7f,0.7f,0.7f,0.7f,
                     0.75f,0.75f,0.75f,
                     0.76f,0.76f,0.76f,0.76f,
                     0.685f,0.63f,0.685f,0.63f,0.685f,0.63f,
                     0.685f,0.685f,0.685f,0.63f,0.63f,0.63f,0.685f,0.685f,0.63f,0.63f,
                     0.7f,0.7f,0.7f,0.685f,0.63f,0.7f
};

const G4float G4HadronCrossSections::alphac[TSIZE] = {
                     1.2f,1.2f,1.2f,1.15f,0.90f,0.91f,0.98f,1.06f,1.10f,1.11f,
                     1.10f,1.08f,1.05f,1.01f,0.985f,0.962f,0.945f,0.932f,
                     0.925f,0.920f,0.920f,0.921f,0.922f,0.923f,0.928f,0.931f,
                     0.940f,0.945f,0.950f,0.955f,0.958f,0.962f,0.965f,0.976f,
                     0.982f,0.988f,0.992f,1.010f,1.020f,1.030f,1.040f
};

const G4float G4HadronCrossSections::partel[NPARTS] = {
                  0.f,0.f,0.f,0.f,0.f,0.f,
                  1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f,
                  1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f,
                  1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f,1.f
};

const G4float G4HadronCrossSections::partin[NPARTS] = {
                  0.f,0.f,0.f,0.f,0.f,0.f,
                  1.00f,0.00f,1.05f,1.20f,1.35f,1.30f,1.20f,1.00f,1.30f,
                  1.00f,1.30f,1.00f,1.30f,1.00f,1.00f,1.00f,1.30f,1.30f,1.30f,
                  1.00f,1.00f,1.30f,1.30f,1.00f,1.f,1.f,1.f,1.3f,1.f
};

// Enabling flags for corrections for compounds
const G4int G4HadronCrossSections::icorr[NPARTS] = {
                  1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                  0,1,0,1,0,1,1,1,0,0,0,1,1,0,0,1,1,1,1,0,0
};

// Enabling flags for interaction to occur
const G4int G4HadronCrossSections::intrc[NPARTS] = {
                  0,0,0,0,0,0,
                  1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,0,
                  1,1,1,1,1,1,1,1,1,1,0
};

const G4float G4HadronCrossSections::csa[4] = {1.f, 27.00f, 63.54f, 207.19f};

const G4int G4HadronCrossSections::ipart2[7] = {9, 8, 7, 11, 10, 13, 12};

G4HadronCrossSections::G4HadronCrossSections()
  : prevParticleDefinition(0),
    prevZZ(0), prevAA(0), 
    prevKineticEnergy(DBL_MAX), lastEkx(0.), lastEkxPower(0.), verboseLevel(0)
{
  siginelastic = sigelastic = 0.0;
  correctInelasticNearZero = false;
  g4pow = G4Pow::GetInstance();
}

G4HadronCrossSections::~G4HadronCrossSections() 
{}

G4HadronCrossSections* G4HadronCrossSections::Instance()
{
  if (!instance) {
    static G4ThreadLocalSingleton<G4HadronCrossSections> inst;
    instance = inst.Instance();
  }
  return instance;
}

G4bool G4HadronCrossSections::IsApplicable(const G4DynamicParticle* aParticle)
{
  return (GetParticleCode(aParticle) > 0);
}

G4double
G4HadronCrossSections::GetInelasticCrossSection(const G4DynamicParticle* particle,
                                                G4int ZZ, G4int AA)
{
  if (particle->GetDefinition() != prevParticleDefinition ||
      particle->GetKineticEnergy() != prevKineticEnergy ||
      ZZ != prevZZ || AA != prevAA)
    { CalcScatteringCrossSections(particle, ZZ, AA); }
  if (verboseLevel > 1) {
    G4cout << "        x-section inelastic(mb)= " 
	   << siginelastic/millibarn << G4endl; 
  }

  return siginelastic;
}


G4double
G4HadronCrossSections::GetElasticCrossSection(const G4DynamicParticle* particle,
                                              G4int ZZ, G4int AA)
{
  if (particle->GetDefinition() != prevParticleDefinition ||
      particle->GetKineticEnergy() != prevKineticEnergy ||
      ZZ != prevZZ || AA != prevAA)
    { CalcScatteringCrossSections(particle, ZZ, AA); }

  if (verboseLevel > 1) {
    G4cout << "        x-section elastic(mb)= " 
	   << sigelastic/millibarn << G4endl; 
  }
  return sigelastic;
}


// Method to calculate cross sections for all processes.
// To facilitate comparison with the original Fortran source, and because
// of the interdependence of the elastic and inelastic cross section
// calculations, this has not been split into separate processes.

void
G4HadronCrossSections::CalcScatteringCrossSections(
                          const G4DynamicParticle* aParticle,
                          G4int ZZ, G4int AA)
{
   G4double sigel, sigin, sigtot;
   G4double xsecel, xsecin=0;
   xsecel = 0;
   G4double dx, dy, rc, rca, b;
   G4double crel, crin;
   G4double xspiel, xspiin;

   G4int ipart = GetParticleCode(aParticle);

   // Protection in the case "IsApplicable" is not invoked
   if ( ipart <= 0 ) {
     G4ExceptionDescription ed;
     ed << aParticle->GetDefinition()->GetParticleName() << " NOT allowed ! ";
     G4Exception( "G4HadronCrossSections::CalcScatteringCrossSections(...)", 
                  "hadXsec001", JustWarning, ed );
     return;
   }

   prevAA = AA;
   prevZZ = ZZ;
   prevParticleDefinition = aParticle->GetDefinition(); 
   prevKineticEnergy = aParticle->GetKineticEnergy(); 

   if (verboseLevel > 1) {
     G4cout << "G4HadronCrossSections::ScatteringCrossSections: " 
	    << aParticle->GetDefinition()->GetParticleName()
	    << " E(MeV)= " << aParticle->GetKineticEnergy()/MeV 
	    << " Z= " << ZZ << " A= " << AA << G4endl;
   }

   // Ions...

   if (ipart >= 30 && ipart <= 32) {

      G4double apart=0;
      if (ipart == 30) apart = g4pow->Z13(2);
      else if (ipart == 31) apart = g4pow->Z13(3);
      else if (ipart == 32) apart = g4pow->Z13(4);

      G4double term = apart + g4pow->Z13(AA);
      sigin = 49.*term*term;
      // Convert cross section from mb to default units
      siginelastic = sigin*millibarn;
      if(prevKineticEnergy < 6*MeV) siginelastic = 0;
      sigelastic = 0.;
      return;
   }

   G4double ek = prevKineticEnergy/GeV;

// Low energy neutrons...

   if (ipart == 16 && ek <= 0.0327) {

     //      G4int je2 = NELAB;
     //      for (G4int j = 2; j <= NELAB; j++) {
     //         if (ek < elab[j - 1]) {
     //            je2 = j;
     //            break;
     //         }
     //      }
     //      G4int je1 = je2 -1;
     //      je1 = je1 - 1;      // For array indexing
     //      je2 = je2 - 1;      // For array indexing
     
      G4int je1 = 0;
      G4int je2 = NELAB - 1;
      do {
         G4int midBin = (je1 + je2)/2;
         if (ek < elab[midBin])
           je2 = midBin;
         else
           je1 = midBin;
      } while (je2 - je1 > 1); /* Loop checking, 08.01.2016, W. Pokorski */

      G4double delab = elab[je2] - elab[je1];

      //      G4int ja2 = NCNLW;
      //      for (G4int jj = 2; jj <= NCNLW; jj++) {
      //         if (a < cnlwat[jj - 1]) {
      //            ja2 = jj;
      //            break;
      //         }
      //      }
      //      G4int ja1 = ja2 - 1;
      //      ja1 = ja1 - 1;      // For array indexing
      //      ja2 = ja2 - 1;      // For array indexing

      G4int ja1 = 0;
      G4int ja2 = NCNLW - 1;
      do {
         G4int midBin = (ja1 + ja2)/2;
         if (AA < cnlwat[midBin])
           ja2 = midBin;
         else
           ja1 = midBin;
      } while (ja2 - ja1 > 1); /* Loop checking, 08.01.2016, W. Pokorski */

      G4double dnlwat = cnlwat[ja2] - cnlwat[ja1];

// Elastic cross section:
      // E interpolation or extrapolation at JA1
      dy = cnlwel[ja1][je2] - cnlwel[ja1][je1];
      G4double rce = dy/delab;
      // A interpolation or extrapolation at JE1
      dy = cnlwel[ja2][je1] - cnlwel[ja1][je1];
      rca = dy/dnlwat;
      b = cnlwel[ja1][je1] - rce*elab[je1] - rca*cnlwat[ja1];
      sigelastic = rce*ek + rca*AA + b;
// Inelastic cross section:
      // E interpolation or extrapolation at JA1
      dy = cnlwin[ja1][je2] - cnlwin[ja1][je1];
      rce = dy/delab;
      // A interpolation or extrapolation at JE1
      dy = cnlwin[ja2][je1] - cnlwin[ja1][je1];
      rca = dy/dnlwat;
      b = cnlwin[ja1][je1] - rce*elab[je1] - rca*cnlwat[ja1];
      siginelastic = rce*ek + rca*AA + b;
   // Convert cross sections from mb to default units
      sigelastic = sigelastic*millibarn;
      siginelastic = siginelastic*millibarn;
      return;
   }

// Remaining particles...

// Get momentum bin
   G4double p = aParticle->GetTotalMomentum()/GeV;

   //   G4int j = TSIZE - 1;
   //   for (G4int i = 2; i <= TSIZE; i++) {
   //      if (p < plab[i]) {
   //         j = i - 1;
   //         break;
   //      }
   //   }
   //   j = j - 1;                     // For array indexing

   G4int je1 = 0;
   G4int je2 = TSIZE - 1;
   do {
      G4int midBin = (je1 + je2)/2;
      if (p < plab[midBin])
        je2 = midBin;
      else
        je1 = midBin;
   } while (je2 - je1 > 1); /* Loop checking, 08.01.2016, W. Pokorski */

   G4int ipart1 = ipart - 1;      // For array indexing

// Get cross sections for scattering on free protons
   dx = plab[je2] - plab[je1];
// Elastic cross section
   dy = csel[ipart1][je2] - csel[ipart1][je1];
   rc = dy/dx;
   b = csel[ipart1][je1] - rc*plab[je1];
   sigel = rc*p + b;
// Inelastic cross section
   dy = csin[ipart1][je2] - csin[ipart1][je1];
   rc = dy/dx;
   b = csin[ipart1][je1] - rc*plab[je1];
   sigin = rc*p + b;
   if (verboseLevel > 1) {
      G4cout << "sigel " << sigel << G4endl;
      G4cout << "sigin " << sigin << G4endl;
   }
   G4double alph = alpha[ipart1];
   if (ipart < 14) {
      dy = alphac[je2] - alphac[je1];
      rc = dy/dx;
      b = alphac[je1] - rc*plab[je1];
      G4double corfac = rc*p + b;
      alph = alph*corfac;
      G4int ipart3 = ipart2[ipart - 7];
      ipart3 = ipart3 - 1;      // For array indexing
      // Elastic cross section
      dy = csel[ipart3][je2] - csel[ipart3][je1];
      rc = dy/dx;
      b = csel[ipart3][je1] - rc*plab[je1];
      xsecel = rc*p + b;
      // Inelastic cross section
      dy = csin[ipart3][je2] - csin[ipart3][je1];
      rc = dy/dx;
      b = csin[ipart3][je1] - rc*plab[je1];
      xsecin = rc*p + b;
   }

// A-dependence from parameterization...

   if (AA >= 2) {

      crel = 1.;
      crin = 1.;

      G4int i = 2;
      if (AA < 50) i = 1;
      else if (AA > 100) i = 3;

// Protons and neutrons
      if (ipart == 14 || ipart == 16) {
         dy = cspnel[i - 1][je2] - cspnel[i - 1][je1];
         rc = dy/dx;
         b = cspnel[i - 1][je1] - rc*plab[je1];
         xsecel = rc*p + b;
         dy = cspnin[i - 1][je2] - cspnin[i - 1][je1];
         rc = dy/dx;
         b = cspnin[i - 1][je1] - rc*plab[je1];
         xsecin = rc*p + b;
         // The following is a first-order correction to Gheisha (GHESIG)
         // behaviour, where for the lighter elements the inelastic cross
         // section is not realistic for particles in the first momentum
         // bin.  In the first momentum bin, it better to interpolate 
         // in K.E.  Subject to further improvements.
         if (correctInelasticNearZero && je1 == 0 && i <= 3) {
            G4double m0 = aParticle->GetMass()/GeV;
            G4double T = std::sqrt(m0*m0 + p*p) - m0;
            dx = std::sqrt(m0*m0 + plab[1]*plab[1]) - m0;
            rc = dy/dx;
            xsecin = rc*T + b;
         }

         if (sigel >= 0.001) 
            crel = xsecel/(0.36*sigel*G4Pow::GetInstance()->powA(G4double(csa[i]), 1.17));
         sigtot = sigel + sigin;
         if (sigtot >= 0.001) 
            crin = xsecin/(sigtot*G4Pow::GetInstance()->powA(G4double(csa[i]), alph));
      }

      else if (ipart < 15) {
// Calculate correction factors (crel, crin) from values
// on Al, Cu, Pb.  Note that data is only available for pions and protons.
         G4double wgch = 0.5;
         if (AA < 20) { wgch = 0.5 + 0.5*G4Exp(-G4double(AA - 1)); }
         sigel = wgch*sigel + (1. - wgch)*xsecel;
         sigin = wgch*sigin + (1. - wgch)*xsecin;
         
// This section not for kaons
         if (ipart < 10) {
            dy = cspiel[i - 1][je2] - cspiel[i - 1][je1];
            rc = dy/dx;
            b = cspiel[i - 1][je1] - rc*plab[je1];
            xspiel = rc*p + b;
            dy = cspiin[i - 1][je2] - cspiin[i - 1][je1];
            rc = dy/dx;
            b = cspiin[i - 1][je1] - rc*plab[je1];
            xspiin = rc*p + b;
            if (verboseLevel > 1) {
               G4cout << "xspiel " << xspiel << G4endl;
               G4cout << "xspiin " << xspiin << G4endl;
            }               
            if (sigel >= 0.001) 
               crel = xspiel/(0.36*sigel*G4Pow::GetInstance()->powA(G4double(csa[i]),1.17));
            sigtot = sigel + sigin;
            if (sigtot >= 0.001) 
               crin = xspiin/(sigtot*G4Pow::GetInstance()->powA(G4double(csa[i]), alph));
         }
      }

// Apply correction factors
      sigin = crin*(sigin + sigel)*g4pow->powZ(AA, alph);
      sigel = crel*0.36*sigel*g4pow->powZ(AA, 1.17);
      sigel = sigel*partel[ipart1];
      sigin = sigin*partin[ipart1];
   }

// Correction factor for high (p > 100 GeV/c) energies:
   G4double corh = 1.;
   if (p > 100.) corh = 0.1085736156*G4Log(p) + 0.5;

   sigel = corh*sigel;
   sigin = corh*sigin;
   // Convert cross section from mb to default units
   sigelastic = sigel*millibarn;
   siginelastic = sigin*millibarn;

   return;
}
   

G4double
G4HadronCrossSections::GetCaptureCrossSection(const G4DynamicParticle* aParticle,
                                              G4int ZZ)
{
  if (GetParticleCode(aParticle) != 16) return 0.;
  G4double ek = aParticle->GetKineticEnergy()/GeV;
  if (ek > 0.0327)  { return 0.; }

  G4double ekx = std::max(ek, 1.e-9);
  if (ekx != lastEkx) {
    lastEkx = ekx;
    lastEkxPower = G4Pow::GetInstance()->powA(ekx*1.e6, 0.577);
  }

  G4int izno = ZZ;
  if (izno > 100) izno = 100;      // Not in GHESIG
  izno = izno - 1;      // For array indexing
  G4double sigcap = 11.12*cscap[izno]/lastEkxPower;

  // Convert cross section from mb to default units
  sigcap = sigcap*millibarn;
  return sigcap;
}


G4double
G4HadronCrossSections::GetFissionCrossSection(const G4DynamicParticle* aParticle,
                                              G4int ZZ, G4int AA)
{
  if (AA < 230) return 0;

  G4double ek = aParticle->GetKineticEnergy()/GeV;      

  G4int ie1 = 0;
  G4int ie2 = NFISS - 1;
  do {
    G4int midBin = (ie1 + ie2)/2;
    if (ek < ekfiss[midBin])
      ie2 = midBin;
    else
      ie1 = midBin;
  } while (ie2 - ie1 > 1); /* Loop checking, 08.01.2016, W. Pokorski */
  G4int i = ie2;
  if (ek < ekfiss[0]) i = 0;

  G4int j = 4;
  if (ek <= 0.01) {
    if (ZZ == 92 && AA == 233) j = 1;
    else if (ZZ == 92 && AA == 235) j = 2;
    else if (ZZ == 94 && AA == 239) j = 3;
  }

  G4double z43ba;
  if (j == 4) {
    z43ba = ZZ*g4pow->Z13(ZZ)/G4double(AA);
    z43ba = std::max(-67. + 38.7*z43ba, 0.);
  } else {
    z43ba = 1.;
  }
  j = j - 1;      // For array indexing

  G4double sigfiss = csfiss[j][i]*z43ba;
  sigfiss = sigfiss*millibarn;
  return sigfiss;
}


G4int
G4HadronCrossSections::GetParticleCode(const G4DynamicParticle* aParticle)
{
  // Returns GHEISHA code for particle
  // Case entries ordered by estimated frequency

  G4int ipart = 0;

  switch( aParticle->GetPDGcode()) {
    case 111:
      ipart = 8;   // pi0
      break;
    case 211:
      ipart = 7;   // pi+
      break;
    case -211:
      ipart = 9;   // pi-
      break;
    case 2112:
      ipart = 16;  // neutron
      break;
    case 2212:
      ipart = 14;  // proton
      break;
    case 321:        
      ipart = 10;  // K+
      break;
    case -321:
      ipart = 13;  // K-
      break;
    case 130:
      ipart = 12;  // K0L
      break;
    case 310:     
      ipart = 11;  // K0S
      break;
    case 1000010020:
      ipart = 30;  // deuteron
      break;
    case 1000010030:
      ipart = 31;  // triton
      break;
    case 1000020040:
      ipart = 32;  // alpha
      break;
    case 3122:
      ipart = 18;  // lambda
      break;
    case -2112:
      ipart = 17;  // anti-neutron
      break;
    case -2212:
      ipart = 15;  // anti-proton
      break;
    case -3122:
      ipart = 19;  // anti-lambda
      break;
    case 3222:
      ipart = 20;  // sigma+
      break;
    case 3212:
      ipart = 21;  // sigma0
      break;
    case 3112:
      ipart = 22;  // sigma-
      break;
    case 3322:
      ipart = 26;  // xi0
      break;
    case 3312:
      ipart = 27;  // xi-
      break;
    case 3334:
      ipart = 33;  // omega-
      break;
    case -3222:
      ipart = 23;  // anti-sigma+
      break;
    case -3212:
      ipart = 24;  // anti-sigma0
      break;
    case -3112:
      ipart = 25;  // anti-sigma-
      break;
    case -3322:
      ipart = 28;  // anti-xi0
      break;
    case -3312:
      ipart = 29;  // anti-xi-
      break;
    case -3334:
      ipart = 34;  // anti-omega-
      break;
  }

  return ipart;
}
