////////////////////////////2919 Nov 16 hacking
/// visibility added




//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//***** Generated by Geant4 Geometry Editor at  Fri Nov 26 11:51:46 JST 2004 *****

//------HeaderFile-
 #include "flatteningFilter.hh"

#include "G4UnitsTable.hh"

#include "G4VUserDetectorConstruction.hh"

#include "globals.hh"
#include "G4Material.hh"
#include "G4MaterialTable.hh"
#include "G4Element.hh"
#include "G4ElementTable.hh"
#include "G4Box.hh"
#include "G4Tubs.hh"
#include "G4Cons.hh"
#include "G4LogicalVolume.hh"
#include "G4ThreeVector.hh"
#include "G4PVPlacement.hh"
#include "G4PVReplica.hh"
#include "G4SDManager.hh"
#include "G4VisAttributes.hh"
#include "G4Colour.hh"

flatteningFilter::flatteningFilter()
{ ; }
flatteningFilter::~flatteningFilter()
{ ; }
G4VPhysicalVolume* flatteningFilter::Construct( )
{
// Elements
G4Element* elementN = new G4Element( "Nitrogen", "N", 7. , 14.00674*g/mole );
G4Element* elementO = new G4Element( "Oxygen", "O", 8. , 15.9994*g/mole );
G4Element* elementH = new G4Element( "Hydrogen", "H", 1. , 1.00794*g/mole );

// Materials from Combination

G4Material* Air = new G4Material("Air",  1.205*mg/cm3, 2, kStateUndefined, 293.15*kelvin, 1.0*atmosphere );
Air->AddElement( elementN, 1 );
Air->AddElement( elementO, 0 );
G4Material* H2O = new G4Material("H2O",  1.0*g/cm3, 2, kStateUndefined, 273.15*kelvin, 1.0*atmosphere );
H2O->AddElement( elementH, 2 );
H2O->AddElement( elementO, 1 );

// Materials from Scratch

G4Material* Aluminum = new G4Material("Aluminum", 13, 26.981539*g/mole, 2.7*g/cm3,kStateSolid, 273.15*kelvin, 1.0*atmosphere );

// Visualization attributes


G4VisAttributes * b1= new G4VisAttributes( G4Colour(0/255. ,238/255. ,238/255. ));
b1->SetVisibility(true);
G4VisAttributes * b2= new G4VisAttributes( G4Colour(10/255. ,238/255. ,238/255. ));
b2->SetVisibility(true);
G4VisAttributes * b3= new G4VisAttributes( G4Colour(20/255. ,238/255. ,238/255. ));
b3->SetVisibility(true);
G4VisAttributes * b4= new G4VisAttributes( G4Colour(30/255. ,238/255. ,238/255. ));
b4->SetVisibility(true);
G4VisAttributes * b5= new G4VisAttributes( G4Colour(39/255. ,238/255. ,238/255. ));
b5->SetVisibility(true);
G4VisAttributes * b6= new G4VisAttributes( G4Colour(49/255. ,238/255. ,238/255. ));
b6->SetVisibility(true);
G4VisAttributes * b7= new G4VisAttributes( G4Colour(57/255. ,238/255. ,238/255. ));
b7->SetVisibility(true);
G4VisAttributes * b8= new G4VisAttributes( G4Colour(67/255. ,238/255. ,238/255. ));
b8->SetVisibility(true);
G4VisAttributes * b9= new G4VisAttributes( G4Colour(77/255. ,238/255. ,238/255. ));
b9->SetVisibility(true);
G4VisAttributes * b10= new G4VisAttributes( G4Colour(87/255. ,238/255. ,238/255. ));
b10->SetVisibility(true);
G4VisAttributes * b11= new G4VisAttributes( G4Colour(94/255. ,238/255. ,238/255. ));
b11->SetVisibility(true);
G4VisAttributes * b12= new G4VisAttributes( G4Colour(101/255. ,238/255. ,238/255. ));
b12->SetVisibility(true);
G4VisAttributes * b13= new G4VisAttributes( G4Colour(109/255. ,238/255. ,238/255. ));
b13->SetVisibility(true);
G4VisAttributes * b14= new G4VisAttributes( G4Colour(117/255. ,238/255. ,238/255. ));
b14->SetVisibility(true);
G4VisAttributes * b15= new G4VisAttributes( G4Colour(126/255. ,238/255. ,238/255. ));
b15->SetVisibility(true);
G4VisAttributes * b16= new G4VisAttributes( G4Colour(135/255. ,238/255. ,238/255. ));
b16->SetVisibility(true);
G4VisAttributes * b17= new G4VisAttributes( G4Colour(146/255. ,238/255. ,238/255. ));
b17->SetVisibility(true);
G4VisAttributes * b18= new G4VisAttributes( G4Colour(156/255. ,238/255. ,238/255. ));
b18->SetVisibility(true);
G4VisAttributes * g1= new G4VisAttributes( G4Colour(156/255. ,255/255. ,41/255. ));
g1->SetVisibility(true);
G4VisAttributes * g2= new G4VisAttributes( G4Colour(156/255. ,255/255. ,64/255. ));
g2->SetVisibility(true);
G4VisAttributes * g3= new G4VisAttributes( G4Colour(156/255. ,255/255. ,84/255. ));
g2->SetVisibility(true);
G4VisAttributes * pink= new G4VisAttributes( G4Colour(255/255. ,153/255. ,153/255. ));
pink->SetVisibility(true);
G4VisAttributes * b19= new G4VisAttributes( G4Colour(216/255. ,248/255. ,246/255. ));
b19->SetVisibility(true);
// Logical  Volumes

G4Box *solidworld= new G4Box("solidworld", 1000.0*mm, 1000.0*mm, 4000.0*mm );
G4LogicalVolume * world = new G4LogicalVolume(solidworld, 	 //its solid
			 Air, 		 //its material
			"world" ,		 //its name
			 0,0,0);
  world->SetVisAttributes (G4VisAttributes::Invisible);
G4Box *solidwaterbox= new G4Box("solidwaterbox", 200.0*mm, 200.0*mm, 200.0*mm );
G4LogicalVolume * waterbox = new G4LogicalVolume(solidwaterbox, 	 //its solid
			 H2O, 		 //its material
			"waterbox" ,		 //its name
			 0,0,0);

waterbox->SetVisAttributes(pink);

G4Cons *solidcon1= new G4Cons("solidcon1", 0.0*mm, 1.0E-7*mm, 0.0*mm, 0.25*mm, 0.06*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con1 = new G4LogicalVolume(solidcon1, 	 //its solid
			 Aluminum, 		 //its material
			"con1" ,		 //its name
			 0,0,0);

con1->SetVisAttributes(b1);

G4Cons *solidcon2= new G4Cons("solidcon2", 0.0*mm, 0.51*mm, 0.0*mm, 0.25*mm, 0.065*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con2 = new G4LogicalVolume(solidcon2, 	 //its solid
			 Aluminum, 		 //its material
			"con2" ,		 //its name
			 0,0,0);

con2->SetVisAttributes(b2);

G4Cons *solidcon3= new G4Cons("solidcon3", 0.0*mm, 0.77*mm, 0.0*mm, 0.51*mm, 0.075*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con3 = new G4LogicalVolume(solidcon3, 	 //its solid
			 Aluminum, 		 //its material
			"con3" ,		 //its name
			 0,0,0);

con3->SetVisAttributes(b3);

G4Cons *solidcon4= new G4Cons("solidcon4", 0.0*mm, 1.03*mm, 0.0*mm, 0.77*mm, 0.09*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con4 = new G4LogicalVolume(solidcon4, 	 //its solid
			 Aluminum, 		 //its material
			"con4" ,		 //its name
			 0,0,0);

con4->SetVisAttributes(b4);

G4Cons *solidcon5= new G4Cons("solidcon5", 0.0*mm, 1.54*mm, 0.0*mm, 1.03*mm, 0.22*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con5 = new G4LogicalVolume(solidcon5, 	 //its solid
			 Aluminum, 		 //its material
			"con5" ,		 //its name
			 0,0,0);

con5->SetVisAttributes(b5);

G4Cons *solidcon6= new G4Cons("solidcon6", 0.0*mm, 2.05*mm, 0.0*mm, 1.54*mm, 0.24*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con6 = new G4LogicalVolume(solidcon6, 	 //its solid
			 Aluminum, 		 //its material
			"con6" ,		 //its name
			 0,0,0);

con6->SetVisAttributes(b6);

G4Cons *solidcon7= new G4Cons("solidcon7", 0.0*mm, 2.56*mm, 0.0*mm, 2.05*mm, 0.23*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con7 = new G4LogicalVolume(solidcon7, 	 //its solid
			 Aluminum, 		 //its material
			"con7" ,		 //its name
			 0,0,0);

con7->SetVisAttributes(b7);

G4Cons *solidcon8= new G4Cons("solidcon8", 0.0*mm, 3.07*mm, 0.0*mm, 2.56*mm, 0.23*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con8 = new G4LogicalVolume(solidcon8, 	 //its solid
			 Aluminum, 		 //its material
			"con8" ,		 //its name
			 0,0,0);

con8->SetVisAttributes(b8);

G4Cons *solidcon9= new G4Cons("solidcon9", 0.0*mm, 3.58*mm, 0.0*mm, 3.07*mm, 0.225*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con9 = new G4LogicalVolume(solidcon9, 	 //its solid
			 Aluminum, 		 //its material
			"con9" ,		 //its name
			 0,0,0);

con9->SetVisAttributes(b9);

G4Cons *solidcon10= new G4Cons("solidcon10", 0.0*mm, 4.09*mm, 0.0*mm, 3.58*mm, 0.22*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con10 = new G4LogicalVolume(solidcon10, 	 //its solid
			 Aluminum, 		 //its material
			"con10" ,		 //its name
			 0,0,0);

con10->SetVisAttributes(b10);

G4Cons *solidcon11= new G4Cons("solidcon11", 0.0*mm, 5.1*mm, 0.0*mm, 4.09*mm, 0.425*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con11 = new G4LogicalVolume(solidcon11, 	 //its solid
			 Aluminum, 		 //its material
			"con11" ,		 //its name
			 0,0,0);

con11->SetVisAttributes(b11);

G4Cons *solidcon12= new G4Cons("solidcon12", 0.0*mm, 6.2*mm, 0.0*mm, 5.1*mm, 0.395*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con12 = new G4LogicalVolume(solidcon12, 	 //its solid
			 Aluminum, 		 //its material
			"con12" ,		 //its name
			 0,0,0);

con12->SetVisAttributes(b12);

G4Cons *solidcon13= new G4Cons("solidcon13", 0.0*mm, 7.3*mm, 0.0*mm, 6.2*mm, 0.38*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con13 = new G4LogicalVolume(solidcon13, 	 //its solid
			 Aluminum, 		 //its material
			"con13" ,		 //its name
			 0,0,0);

con13->SetVisAttributes(b13);

G4Cons *solidcon14= new G4Cons("solidcon14", 0.0*mm, 8.4*mm, 0.0*mm, 7.3*mm, 0.335*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con14 = new G4LogicalVolume(solidcon14, 	 //its solid
			 Aluminum, 		 //its material
			"con14" ,		 //its name
			 0,0,0);

con14->SetVisAttributes(b14);

G4Cons *solidcon15= new G4Cons("solidcon15", 0.0*mm, 9.5*mm, 0.0*mm, 8.4*mm, 0.325*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con15 = new G4LogicalVolume(solidcon15, 	 //its solid
			 Aluminum, 		 //its material
			"con15" ,		 //its name
			 0,0,0);

con15->SetVisAttributes(b15);

G4Cons *solidcon16= new G4Cons("solidcon16", 0.0*mm, 10.5*mm, 0.0*mm, 9.5*mm, 0.28*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con16 = new G4LogicalVolume(solidcon16, 	 //its solid
			 Aluminum, 		 //its material
			"con16" ,		 //its name
			 0,0,0);

con16->SetVisAttributes(b16);

G4Cons *solidcon17= new G4Cons("solidcon17", 0.0*mm, 11.5*mm, 0.0*mm, 10.5*mm, 0.275*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con17 = new G4LogicalVolume(solidcon17, 	 //its solid
			 Aluminum, 		 //its material
			"con17" ,		 //its name
			 0,0,0);

con17->SetVisAttributes(b17);

G4Cons *solidcon18= new G4Cons("solidcon18", 0.0*mm, 12.15*mm, 0.0*mm, 11.5*mm, 0.19*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * con18 = new G4LogicalVolume(solidcon18, 	 //its solid
			 Aluminum, 		 //its material
			"con18" ,		 //its name
			 0,0,0);

con18->SetVisAttributes(b18);

G4Cons *solidcons19= new G4Cons("solidcons19", 0.0*mm, 13.01*mm, 0.0*mm, 13.35*mm, 0.225*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * cons19 = new G4LogicalVolume(solidcons19, 	 //its solid
			 Aluminum, 		 //its material
			"cons19" ,		 //its name
			 0,0,0);

cons19->SetVisAttributes(b19);

G4Tubs *solidtub1= new G4Tubs("solidtub1", 0.0*mm, 13.35*mm, 0.4*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * tub1 = new G4LogicalVolume(solidtub1, 	 //its solid
			 Aluminum, 		 //its material
			"tub1" ,		 //its name
			 0,0,0);

tub1->SetVisAttributes(g1);

G4Tubs *solidtub2= new G4Tubs("solidtub2", 13.0*mm, 13.35*mm, 0.225*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * tub2 = new G4LogicalVolume(solidtub2, 	 //its solid
			 Aluminum, 		 //its material
			"tub2" ,		 //its name
			 0,0,0);

tub2->SetVisAttributes(g2);

G4Tubs *solidtub3= new G4Tubs("solidtub3", 13.35*mm, 16.0*mm, 0.625*mm, 0.0*rad, 360.0*deg );
G4LogicalVolume * tub3 = new G4LogicalVolume(solidtub3, 	 //its solid
			 Aluminum, 		 //its material
			"tub3" ,		 //its name
			 0,0,0);

tub3->SetVisAttributes(g3);


// Physical Volumes ----  Single Positioned Placement,   Repeated Placement,   Slicing  --------------------------- 


// Single Positioned Placement 

G4RotationMatrix rotMatrixpworld;   // unit rotation matrix
G4double anglepworld = 0.0*deg;   // rotational angle
rotMatrixpworld.rotateX(anglepworld);  // rot matrix

G4VPhysicalVolume *  pworld= new G4PVPlacement(G4Transform3D(rotMatrixpworld,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 0.0*mm)),
		 "pworld",   //its name  (2nd constructor)
		 world,         //its logical volume 
		 NULL,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixphantom;   // unit rotation matrix
G4double anglephantom = 0.0*deg;   // rotational angle
rotMatrixphantom.rotateX(anglephantom);  // rot matrix

G4VPhysicalVolume *  phantom= new G4PVPlacement(G4Transform3D(rotMatrixphantom,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 0.0*mm)),
		 "phantom",   //its name  (2nd constructor)
		 waterbox,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon1;   // unit rotation matrix
G4double anglepcon1 = 0.0*deg;   // rotational angle
rotMatrixpcon1.rotateX(anglepcon1);  // rot matrix

G4VPhysicalVolume *  pcon1= new G4PVPlacement(G4Transform3D(rotMatrixpcon1,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1034.04*mm)),
		 "pcon1",   //its name  (2nd constructor)
		 con1,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon2;   // unit rotation matrix
G4double anglepcon2 = 0.0*deg;   // rotational angle
rotMatrixpcon2.rotateX(anglepcon2);  // rot matrix

G4VPhysicalVolume *  pcon2= new G4PVPlacement(G4Transform3D(rotMatrixpcon2,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1033.888*mm)),
		 "pcon2",   //its name  (2nd constructor)
		 con2,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon3;   // unit rotation matrix
G4double anglepcon3 = 0.0*deg;   // rotational angle
rotMatrixpcon3.rotateX(anglepcon3);  // rot matrix

G4VPhysicalVolume *  pcon3= new G4PVPlacement(G4Transform3D(rotMatrixpcon3,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1033.748*mm)),
		 "pcon3",   //its name  (2nd constructor)
		 con3,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon4;   // unit rotation matrix
G4double anglepcon4 = 0.0*deg;   // rotational angle
rotMatrixpcon4.rotateX(anglepcon4);  // rot matrix

G4VPhysicalVolume *  pcon4= new G4PVPlacement(G4Transform3D(rotMatrixpcon4,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1033.583*mm)),
		 "pcon4",   //its name  (2nd constructor)
		 con4,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon5;   // unit rotation matrix
G4double anglepcon5 = 0.0*deg;   // rotational angle
rotMatrixpcon5.rotateX(anglepcon5);  // rot matrix

G4VPhysicalVolume *  pcon5= new G4PVPlacement(G4Transform3D(rotMatrixpcon5,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1033.273*mm)),
		 "pcon5",   //its name  (2nd constructor)
		 con5,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon6;   // unit rotation matrix
G4double anglepcon6 = 0.0*deg;   // rotational angle
rotMatrixpcon6.rotateX(anglepcon6);  // rot matrix

G4VPhysicalVolume *  pcon6= new G4PVPlacement(G4Transform3D(rotMatrixpcon6,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1032.813*mm)),
		 "pcon6",   //its name  (2nd constructor)
		 con6,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon7;   // unit rotation matrix
G4double anglepcon7 = 0.0*deg;   // rotational angle
rotMatrixpcon7.rotateX(anglepcon7);  // rot matrix

G4VPhysicalVolume *  pcon7= new G4PVPlacement(G4Transform3D(rotMatrixpcon7,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1032.343*mm)),
		 "pcon7",   //its name  (2nd constructor)
		 con7,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon8;   // unit rotation matrix
G4double anglepcon8 = 0.0*deg;   // rotational angle
rotMatrixpcon8.rotateX(anglepcon8);  // rot matrix

G4VPhysicalVolume *  pcon8= new G4PVPlacement(G4Transform3D(rotMatrixpcon8,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1031.883*mm)),
		 "pcon8",   //its name  (2nd constructor)
		 con8,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon9;   // unit rotation matrix
G4double anglepcon9 = 0.0*deg;   // rotational angle
rotMatrixpcon9.rotateX(anglepcon9);  // rot matrix

G4VPhysicalVolume *  pcon9= new G4PVPlacement(G4Transform3D(rotMatrixpcon9,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1031.428*mm)),
		 "pcon9",   //its name  (2nd constructor)
		 con9,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon10;   // unit rotation matrix
G4double anglepcon10 = 0.0*deg;   // rotational angle
rotMatrixpcon10.rotateX(anglepcon10);  // rot matrix

G4VPhysicalVolume *  pcon10= new G4PVPlacement(G4Transform3D(rotMatrixpcon10,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1030.983*mm)),
		 "pcon10",   //its name  (2nd constructor)
		 con10,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon11;   // unit rotation matrix
G4double anglepcon11 = 0.0*deg;   // rotational angle
rotMatrixpcon11.rotateX(anglepcon11);  // rot matrix

G4VPhysicalVolume *  pcon11= new G4PVPlacement(G4Transform3D(rotMatrixpcon11,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1030.338*mm)),
		 "pcon11",   //its name  (2nd constructor)
		 con11,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon12;   // unit rotation matrix
G4double anglepcon12 = 0.0*deg;   // rotational angle
rotMatrixpcon12.rotateX(anglepcon12);  // rot matrix

G4VPhysicalVolume *  pcon12= new G4PVPlacement(G4Transform3D(rotMatrixpcon12,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1029.518*mm)),
		 "pcon12",   //its name  (2nd constructor)
		 con12,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon13;   // unit rotation matrix
G4double anglepcon13 = 0.0*deg;   // rotational angle
rotMatrixpcon13.rotateX(anglepcon13);  // rot matrix

G4VPhysicalVolume *  pcon13= new G4PVPlacement(G4Transform3D(rotMatrixpcon13,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1028.743*mm)),
		 "pcon13",   //its name  (2nd constructor)
		 con13,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon14;   // unit rotation matrix
G4double anglepcon14 = 0.0*deg;   // rotational angle
rotMatrixpcon14.rotateX(anglepcon14);  // rot matrix

G4VPhysicalVolume *  pcon14= new G4PVPlacement(G4Transform3D(rotMatrixpcon14,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1028.028*mm)),
		 "pcon14",   //its name  (2nd constructor)
		 con14,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon15;   // unit rotation matrix
G4double anglepcon15 = 0.0*deg;   // rotational angle
rotMatrixpcon15.rotateX(anglepcon15);  // rot matrix

G4VPhysicalVolume *  pcon15= new G4PVPlacement(G4Transform3D(rotMatrixpcon15,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1027.368*mm)),
		 "pcon15",   //its name  (2nd constructor)
		 con15,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon16;   // unit rotation matrix
G4double anglepcon16 = 0.0*deg;   // rotational angle
rotMatrixpcon16.rotateX(anglepcon16);  // rot matrix

G4VPhysicalVolume *  pcon16= new G4PVPlacement(G4Transform3D(rotMatrixpcon16,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1026.763*mm)),
		 "pcon16",   //its name  (2nd constructor)
		 con16,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon17;   // unit rotation matrix
G4double anglepcon17 = 0.0*deg;   // rotational angle
rotMatrixpcon17.rotateX(anglepcon17);  // rot matrix

G4VPhysicalVolume *  pcon17= new G4PVPlacement(G4Transform3D(rotMatrixpcon17,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1025.6208*mm)),
		 "pcon17",   //its name  (2nd constructor)
		 con17,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon18;   // unit rotation matrix
G4double anglepcon18 = 0.0*deg;   // rotational angle
rotMatrixpcon18.rotateX(anglepcon18);  // rot matrix

G4VPhysicalVolume *  pcon18= new G4PVPlacement(G4Transform3D(rotMatrixpcon18,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1024.743*mm)),
		 "pcon18",   //its name  (2nd constructor)
		 con18,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixpcon19;   // unit rotation matrix
G4double anglepcon19 = 0.0*deg;   // rotational angle
rotMatrixpcon19.rotateX(anglepcon19);  // rot matrix

G4VPhysicalVolume *  pcon19= new G4PVPlacement(G4Transform3D(rotMatrixpcon19,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1024.778*mm)),
		 "pcon19",   //its name  (2nd constructor)
		 cons19,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixptub1;   // unit rotation matrix
G4double angleptub1 = 0.0*deg;   // rotational angle
rotMatrixptub1.rotateX(angleptub1);  // rot matrix

G4VPhysicalVolume *  ptub1= new G4PVPlacement(G4Transform3D(rotMatrixptub1,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1024.153*mm)),
		 "ptub1",   //its name  (2nd constructor)
		 tub1,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixptub2;   // unit rotation matrix
G4double angleptub2 = 0.0*deg;   // rotational angle
rotMatrixptub2.rotateX(angleptub2);  // rot matrix

G4VPhysicalVolume *  ptub2= new G4PVPlacement(G4Transform3D(rotMatrixptub2,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1024.153*mm)),
		 "ptub2",   //its name  (2nd constructor)
		 tub2,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 

G4RotationMatrix rotMatrixptub3;   // unit rotation matrix
G4double angleptub3 = 0.0*deg;   // rotational angle
rotMatrixptub3.rotateX(angleptub3);  // rot matrix

G4VPhysicalVolume *  ptub3= new G4PVPlacement(G4Transform3D(rotMatrixptub3,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 1024.378*mm)),
		 "ptub3",   //its name  (2nd constructor)
		 tub3,         //its logical volume 
		 pworld,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 


// Repeated Placement Translation 


// Repeated Placement AxialSymmetoric


// Slicing Translation 


// Slicing AxialSymmetric 


// return the physical World


 return pworld;
}
