//$Id: HadParticlesTable.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GPE;



import java.awt.*;



import java.awt.event.*;



import javax.swing.*;



import javax.swing.table.*;



import javax.swing.event.*;



import java.util.*;







class HadParticlesTable extends AbstractGPEFrame implements ActionListener {



    private ParticleCell parcel[];



    PhysicsFrame phyFrame;







    JButton appendButton;



    JButton insertButton;



    JButton closeTableButton;



    private Color buttonColor;







    HadParticlesTable(PhysicsFrame phyFrame){



        super("Particles Table");



        this.phyFrame = phyFrame;



        GridBagLayout gbl = new GridBagLayout();



        GridBagConstraints gbc = new GridBagConstraints();



        buttonColor = new Color(230, 200, 140);



        int elemPosX[] = {0, 1, 2,



		             1, 2, 3, 4, 5, 6,



		          0, 1, 2, 3, 4, 



		             1, 2, 3, 4, 5, 6, 7,



                             1, 2, 3, 4, 5, 6, 7,



                          0, 1, 2, 3, 4, 5



                          };







        int elemPosY[] = {0, 0, 0,



	       	             1, 1, 1, 1, 1, 1,



		          2, 2, 2, 2, 2,



		             3, 3, 3, 3, 3, 3, 3,



		             4, 4, 4, 4, 4, 4, 4,



		          5, 5, 5, 5, 5, 5,



		          };







        ParticleItem pari[] = makeParticle();



        gbc.insets = new Insets(1,1,1,1);



        gbc.fill = GridBagConstraints.BOTH;



        gbc.weightx = 1.0; gbc.weighty = 1.0;







        parcel = new ParticleCell[pari.length];







        JLabel columnLabel = new JLabel("Particle(s) ==>", JLabel.CENTER);



          columnLabel.setFont(new Font("Serif", Font.BOLD, 12));



        JLabel tableLabel = new JLabel("ThisTable ==>", JLabel.CENTER);



          tableLabel.setFont(new Font("Serif", Font.BOLD, 12)); 







        appendButton = new JButton("Append");



          appendButton.setBackground(Color.green);







        insertButton = new JButton("Insert");



          insertButton.setBackground(Color.green);







        closeTableButton = new JButton("CloseTable");



          closeTableButton.setBackground(Color.yellow);    







        JPanel buttonPanel = new JPanel();



          buttonPanel.setLayout(new GridLayout(1, 5));



          buttonPanel.setBackground(new Color(230, 250, 230));



          buttonPanel.add(columnLabel);



          buttonPanel.add(appendButton);



          buttonPanel.add(insertButton);



          buttonPanel.add(tableLabel);



          buttonPanel.add(closeTableButton);



        JPanel tablePanel = new JPanel();



        JPanel mainPanel = new JPanel();



          mainPanel.setLayout(new BorderLayout(1, 1));



          mainPanel.add(buttonPanel, "North");



          mainPanel.add(tablePanel, "Center");



          tablePanel.setLayout(gbl);



          tablePanel.setBackground(new Color(100, 250, 230));



             ///////   R= 230 -> 100 (lightblue)







        appendButton.addActionListener(this);



        insertButton.addActionListener(this);



        closeTableButton.addActionListener(this);







        for (int i = 0; i<pari.length; i++){



            gbc.gridx = elemPosX[i]; gbc.gridy = elemPosY[i];



            parcel[i] = new ParticleCell(pari[i]);



  



        gbl.setConstraints(parcel[i], gbc); tablePanel.add(parcel[i]);



        add(mainPanel);







	}



        setSize(830, 180);



        //setResizable(false);



    }







  



    public void actionPerformed(ActionEvent e){



        if (e.getSource() == appendButton) {



	    phyFrame.appendHadParticle();



    



        }else if (e.getSource() == insertButton) {



            phyFrame.insertHadParticle();



    



        }else if (e.getSource() == closeTableButton) {



            this.setVisible(false);



            phyFrame.phyHadTable.createMatCloseAct();







            getSelectedElements();



	}



    }



    







    ParticleItem[] getSelectedElements(){



        int k = 0;



        if (ParticleCell.selectedElems == 0) return null;



        ParticleItem parItem[] = new ParticleItem[ParticleCell.selectedElems];



        for (int i=0; i<parcel.length; i++){



            if(parcel[i].isSelected()){



	        parItem[k] = parcel[i].parItem;



	        parcel[i].clear();



	        k++;



	    }



	}



        return parItem;



    }



    ParticleItem[] makeParticle(){



        ParticleItem pari[] = new ParticleItem[34];







        //pari[0] = new ParticleItem("all_bosons","all bosons");



        //pari[1] = new ParticleItem("gamma","\u03B3");



        //pari[2] = new ParticleItem("geantino","geantino");



        //pari[3] = new ParticleItem("chargedgeantino","chargedgeantino");







        pari[0] = new ParticleItem("all_mesons","all mesons");



        pari[1] = new ParticleItem("pi+","\u03C0+");



        pari[2] = new ParticleItem("pi-","\u03C0-");



        //pari[3] = new ParticleItem("pi0","\u03C00");



        //pari[8] = new ParticleItem("eta","\u03B7");



        //pari[9] = new ParticleItem("eta_prime","\u03B7\u0374");



        //pari[10] = new ParticleItem("rho0","\u03C10");







        pari[3] = new ParticleItem("kaon+","K+");



        pari[4] = new ParticleItem("kaon-","K-");



        pari[5] = new ParticleItem("kaon0","K0");



        pari[6] = new ParticleItem("kaon0S","K0S");



        pari[7] = new ParticleItem("kaon0L","K0L");



        pari[8] = new ParticleItem("anti_kaon0","anti-K0");







        pari[9] = new ParticleItem("all_baryons","all baryons");



        pari[10] = new ParticleItem("proton","p");



        pari[11] = new ParticleItem("neutron","n");



        pari[12] = new ParticleItem("anti_proton","anti-p");



        pari[13] = new ParticleItem("anti_neutron","anti-n");







        pari[14] = new ParticleItem("lambda","\u039B");



        pari[15] = new ParticleItem("sigma+","\u03A3+");



        pari[16] = new ParticleItem("sigma0","\u03A30");



        pari[17] = new ParticleItem("sigma-","\u03A3-");



        pari[18] = new ParticleItem("xi0","\u039E0");



        pari[19] = new ParticleItem("xi-","\u039E-");



        pari[20] = new ParticleItem("omega-","\u03A9-");







        pari[21] = new ParticleItem("anti_lambda","anti-\u039B");



        pari[22] = new ParticleItem("anti_sigma+","anti-\u03A3+");



        pari[23] = new ParticleItem("anti_sigma0","anti-\u03A30");



        pari[24] = new ParticleItem("anti_sigma-","anti-\u03A3-");



        pari[25] = new ParticleItem("anti_xi0","anti-\u039E0");



        pari[26] = new ParticleItem("anti_xi-","anti-\u039E-");



        pari[27] = new ParticleItem("anti_omega-","anti-\u03A9-");







        pari[28] = new ParticleItem("all_ions","all ions");



        pari[29] = new ParticleItem("alpha","\u03B1");



        pari[30] = new ParticleItem("deuteron","d");



        pari[31] = new ParticleItem("He3","He3");



        pari[32] = new ParticleItem("triton","triton");



        pari[33] = new ParticleItem("GenericIon","GenericIon");







        //pari[35] = new ParticleItem("all_shortlived","all shortlived");



        return pari;



    }



}























