/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.AbstractGGEFrame;
import GGE.ElementCell;
import GGE.ElementItem;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;

public class ElementsTable
extends AbstractGGEFrame {
    private ElementCell[] ecel;
    private ElementItem[] el;

    public ElementsTable() {
        super("Elements");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.getContentPane().setLayout(gbl);
        this.setBackground(new Color(230, 250, 230));
        int[] elemPosX = new int[]{1, 0, 17, 0, 1, 12, 13, 14, 15, 16, 17, 0, 1, 12, 13, 14, 15, 16, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
        int[] elemPosY = new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        this.el = this.makeElements();
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.ecel = new ElementCell[this.el.length];
        for (int i = 0; i < this.el.length; ++i) {
            gbc.gridx = elemPosX[i];
            gbc.gridy = elemPosY[i];
            this.ecel[i] = new ElementCell(this.el[i]);
            gbl.setConstraints(this.ecel[i], gbc);
            this.getContentPane().add(this.ecel[i]);
        }
        Color lightRed = new Color(255, 200, 200);
        Color lightYellow = new Color(255, 255, 96);
        JLabel lan = new JLabel("L", 0);
        lan.setOpaque(true);
        lan.setBackground(lightRed);
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbl.setConstraints(lan, gbc);
        this.getContentPane().add(lan);
        JLabel act = new JLabel("A", 0);
        act.setOpaque(true);
        act.setBackground(lightRed);
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbl.setConstraints(act, gbc);
        this.getContentPane().add(act);
        JLabel lt = new JLabel("PERIODIC TABLE OF THE ELEMENTS", 0);
        lt.setOpaque(true);
        lt.setBackground(Color.white);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 10;
        gbc.gridheight = 2;
        gbl.setConstraints(lt, gbc);
        this.getContentPane().add(lt);
        JLabel lla = new JLabel("Lanthanides", 0);
        lla.setOpaque(true);
        lla.setBackground(lightRed);
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbl.setConstraints(lla, gbc);
        this.getContentPane().add(lla);
        JLabel lac = new JLabel("Actinides", 0);
        lac.setOpaque(true);
        lac.setBackground(lightRed);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbl.setConstraints(lac, gbc);
        this.getContentPane().add(lac);
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        JLabel[] num = new JLabel[15];
        for (int i = 0; i < 15; ++i) {
            num[i] = new JLabel(i + 3 + "", 0);
            num[i].setBackground(lightYellow);
            num[i].setOpaque(true);
            gbc.gridx = 2 + i;
            gbc.gridy = i < 10 ? 2 : 0;
            gbl.setConstraints(num[i], gbc);
            this.getContentPane().add(num[i]);
        }
        this.pack();
        this.setResizable(false);
    }

    ElementItem[] getSelectedElements() {
        int k = 0;
        if (ElementCell.selectedElems == 0) {
            return null;
        }
        ElementItem[] ei = new ElementItem[ElementCell.selectedElems];
        for (int i = 0; i < this.ecel.length; ++i) {
            if (!this.ecel[i].isSelected()) continue;
            ei[k] = this.ecel[i].ei;
            this.ecel[i].clear();
            ++k;
        }
        return ei;
    }

    String getSymbol(int num) {
        return this.el[num].symbol;
    }

    String getName(int num) {
        return this.el[num].name;
    }

    ElementItem getElement(int num) {
        return this.el[num];
    }

    ElementItem[] makeElements() {
        ElementItem[] el = new ElementItem[]{new ElementItem("Deuterium", "D", 1, 2.014, false), new ElementItem("Hydrogen", "H", 1, 1.00794, false), new ElementItem("Helium", "He", 2, 4.002602, false), new ElementItem("Lithium", "Li", 3, 6.941, true), new ElementItem("Beryllium", "Be", 4, 9.012182, true), new ElementItem("Boron", "B", 5, 10.811, false), new ElementItem("Carbon", "C", 6, 12.011, false), new ElementItem("Nitrogen", "N", 7, 14.00674, false), new ElementItem("Oxygen", "O", 8, 15.9994, false), new ElementItem("Fluorine", "F", 9, 18.9984032, false), new ElementItem("Neon", "Ne", 10, 20.1797, false), new ElementItem("Sodium", "Na", 11, 22.989768, true), new ElementItem("Magnesium", "Mg", 12, 24.305, true), new ElementItem("Aluminum", "Al", 13, 26.981539, true), new ElementItem("Silicon", "Si", 14, 28.0855, false), new ElementItem("Phosphorus", "P", 15, 30.973762, false), new ElementItem("Sulfur", "S", 16, 32.066, false), new ElementItem("Chlorine", "Cl", 17, 35.4527, false), new ElementItem("Argon", "Ar", 18, 39.948, false), new ElementItem("Potassium", "K", 19, 39.0983, true), new ElementItem("Calcium", "Ca", 20, 40.078, true), new ElementItem("Scandium", "Sc", 21, 44.95591, true), new ElementItem("Titanium", "Ti", 22, 47.867, true), new ElementItem("Vanadium", "V", 23, 50.9415, true), new ElementItem("Chromium", "Cr", 24, 51.9961, true), new ElementItem("Manganese", "Mn", 25, 54.93805, true), new ElementItem("Iron", "Fe", 26, 55.845, true), new ElementItem("Cobalt", "Co", 27, 58.9332, true), new ElementItem("Nickel", "Ni", 28, 58.69, true), new ElementItem("Copper", "Cu", 29, 63.546, true), new ElementItem("Zinc", "Zn", 30, 65.39, true), new ElementItem("Gallium", "Ga", 31, 69.723, true), new ElementItem("Germanium", "Ge", 32, 72.61, true), new ElementItem("Arsenic", "As", 33, 74.92159, false), new ElementItem("Selenium", "Se", 34, 78.96, false), new ElementItem("Bromine", "Br", 35, 79.904, false), new ElementItem("Krypton", "Kr", 36, 83.8, false), new ElementItem("Rubidium", "Rb", 37, 85.4678, true), new ElementItem("Strontium", "Sr", 38, 87.62, true), new ElementItem("Yttrium", "Y", 39, 88.90585, true), new ElementItem("Zirconium", "Zr", 40, 91.224, true), new ElementItem("Niobium", "Nb", 41, 92.90638, true), new ElementItem("Molybdenum", "Mo", 42, 95.94, true), new ElementItem("Technetium", "Tc", 43, 98.91, true), new ElementItem("Ruthenium", "Ru", 44, 101.07, true), new ElementItem("Rhodium", "Rh", 45, 102.9055, true), new ElementItem("Palladium", "Pd", 46, 106.42, true), new ElementItem("Silver", "Ag", 47, 107.8682, true), new ElementItem("Cadmium", "Cd", 48, 112.411, true), new ElementItem("Indium", "In", 49, 114.82, true), new ElementItem("Tin", "Sn", 50, 118.71, true), new ElementItem("Antimony", "Sb", 51, 121.75, true), new ElementItem("Tellurium", "Te", 52, 127.6, false), new ElementItem("Iodine", "I", 53, 126.90447, false), new ElementItem("Xenon", "Xe", 54, 131.29, false), new ElementItem("Cesium", "Cs", 55, 132.90543, true), new ElementItem("Barium", "Ba", 56, 137.327, true), new ElementItem("Lanthanum", "La", 57, 138.9055, true), new ElementItem("Cerium", "Ce", 58, 140.115, true), new ElementItem("Praseodymium", "Pr", 59, 140.90765, true), new ElementItem("Neodymium", "Nd", 60, 144.24, true), new ElementItem("Promethium", "Pm", 61, 145.0, true), new ElementItem("Samarium", "Sm", 62, 150.36, true), new ElementItem("Europium", "Eu", 63, 151.965, true), new ElementItem("Gadolinium", "Gd", 64, 157.25, true), new ElementItem("Terbium", "Tb", 65, 158.92534, true), new ElementItem("Dysprosium", "Dy", 66, 162.5, true), new ElementItem("Holmium", "Ho", 67, 164.93032, true), new ElementItem("Erbium", "Er", 68, 167.26, true), new ElementItem("Thulium", "Tm", 69, 168.93421, true), new ElementItem("Ytterbium", "Yb", 70, 173.04, true), new ElementItem("Lutetium", "Lu", 71, 174.967, true), new ElementItem("Hafnium", "Hf", 72, 178.49, true), new ElementItem("Tantalum", "Ta", 73, 180.9479, true), new ElementItem("Tungsten", "W", 74, 183.85, true), new ElementItem("Rhenium", "Re", 75, 186.207, true), new ElementItem("Osmium", "Os", 76, 190.2, true), new ElementItem("Iridium", "Ir", 77, 192.22, true), new ElementItem("Platinum", "Pt", 78, 195.08, true), new ElementItem("Gold", "Au", 79, 196.96654, true), new ElementItem("Mercury", "Hg", 80, 200.59, true), new ElementItem("Thallium", "Tl", 81, 204.3833, true), new ElementItem("Lead", "Pb", 82, 207.2, true), new ElementItem("Bismuth", "Bi", 83, 208.98037, true), new ElementItem("Polonium", "Po", 84, 209.0, true), new ElementItem("Astatine", "At", 85, 210.0, false), new ElementItem("Radon", "Rn", 86, 222.0, false), new ElementItem("Francium", "Fr", 87, 223.0, true), new ElementItem("Radium", "Ra", 88, 226.025, true), new ElementItem("Actinium", "Ac", 89, 227.028, true), new ElementItem("Thorium", "Th", 90, 232.0381, true), new ElementItem("Protactinium", "Pa", 91, 231.03588, true), new ElementItem("Uranium", "U", 92, 238.0289, true), new ElementItem("Neptunium", "Np", 93, 237.048, true), new ElementItem("Plutonium", "Pu", 94, 244.0, true), new ElementItem("Americium", "Am", 95, 243.0, true), new ElementItem("Curium", "Cm", 96, 247.0, true), new ElementItem("Berkelium", "Bk", 97, 247.0, true), new ElementItem("Californium", "Cf", 98, 251.0, true), new ElementItem("Einsteinium", "Es", 99, 254.0, true), new ElementItem("Fermium", "Fm", 100, 257.0, true), new ElementItem("Mendelevium", "Md", 101, 258.0, true), new ElementItem("Nobelium", "No", 102, 259.0, true), new ElementItem("Lawrencium", "Lr", 103, 260.0, true)};
        return el;
    }
}

