//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: XrayFluoAnalysisMessenger.hh
// GEANT4 tag $Name: xray_fluo-V03-02-00
//
// Author: Elena Guardincerri (Elena.Guardincerri@ge.infn.it)
//
// History:
// -----------
//  28 Nov 2001  Elena Guardincerri   Created
//
// -------------------------------------------------------------------




//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....

#ifndef XrayFluoAnalysisMessenger_h
#define XrayFluoAnalysisMessenger_h 1

#include "globals.hh"
#include "G4UImessenger.hh"
#include "G4UIcmdWithAString.hh"
#include "XrayFluoAnalysisManager.hh"
#include "G4UIdirectory.hh"
#include "G4UIcmdWithABool.hh"
class XrayFluoAnalysisManager;

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo....


class XrayFluoAnalysisMessenger: public G4UImessenger

{
public:
  XrayFluoAnalysisMessenger(XrayFluoAnalysisManager*);
  ~XrayFluoAnalysisMessenger();
  
  void SetNewValue(G4UIcommand*, G4String);
  
private:

  //pointer to XrayFluoAnalysisManager
  XrayFluoAnalysisManager* xrayFluoAnalysis;
  G4UIdirectory* XrayFluoAnalysisDir;
  G4UIcmdWithAString* outputFileCommand; 
  G4UIcmdWithABool* physicFlagCmd;

};
#endif



