//$Id: ParticleCell.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
// 1999 June 23

//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//


// Table of particles



package GPE;





import java.awt.*;



import java.awt.event.*;



import javax.swing.*;





class ParticleCell extends JPanel implements ActionListener {



  static int selectedElems = 0;



  ParticleItem parItem;



  private boolean isSelected;



  private JButton e;



  private Color bg;



  ParticleCell(ParticleItem parItem){



    this.parItem = parItem;



    isSelected = false;



    setLayout(new GridLayout(1,1));



    bg  = new Color(255, 175, 175);



    e = new JButton(parItem.symbol);



    e.setFont(new Font("Serif", Font.BOLD, 12));



    e.setBackground(bg);



    e.setMargin(new Insets(1,3,1,3));



    e.setToolTipText(parItem.name);



    e.addActionListener(this);



    add(e);







  }



  public void actionPerformed(ActionEvent ev){



    Object source = ev.getSource();



    if (isSelected){



      selectedElems--;



      isSelected = false;



      e.setBackground(bg);



    }else{



      if (selectedElems >= 1) return;



        selectedElems++;



        isSelected = true;



        e.setBackground(Color.red);



     }



     repaint();



    }



    void clear(){



      selectedElems = 0;



      isSelected = false;



      e.setBackground(bg);



      repaint();



    }



    boolean isSelected(){



      return isSelected;



  }



}















































