/*
 * Decompiled with CFR 0.152.
 */
package GGE;

import GGE.ElementItem;
import java.io.Serializable;

class RatioItem
implements Serializable {
    ElementItem[] elems;
    float[] ratio;
    int isFraction;
    boolean isEmpty;

    public RatioItem(ElementItem[] eis) {
        this.elems = eis;
        this.ratio = new float[this.elems.length];
        this.isEmpty = true;
    }

    int getLength() {
        return this.elems.length;
    }

    String getEleName(int pos) {
        return this.elems[pos].name;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < this.elems.length; ++i) {
            stb.append(this.elems[i].symbol);
            if (!this.isEmpty) {
                stb.append(":" + this.getRatioStr(i) + " ");
                continue;
            }
            stb.append("  ");
        }
        return stb.toString();
    }

    String getRatioStr(int pos) {
        if (this.isFraction == 1) {
            return "" + this.ratio[pos];
        }
        return "" + Math.round(this.ratio[pos]);
    }

    String getCPP(String name) {
        StringBuffer cpp = new StringBuffer();
        for (int i = 0; i < this.elems.length; ++i) {
            cpp.append(name + "->AddElement( element" + this.elems[i].symbol + ", ");
            cpp.append(this.getRatioStr(i) + " );\n");
        }
        return cpp.toString();
    }

    String getXML(String name) {
        StringBuffer xml = new StringBuffer();
        for (int i = 0; i < this.elems.length; ++i) {
            if (this.isFraction == 1) {
                xml.append("         <franction n=\"" + this.getRatioStr(i) + "\" ");
                xml.append("ref=\"" + this.elems[i] + "\"/>\n");
                continue;
            }
            xml.append("         <composite n=\"" + this.getRatioStr(i) + "\" ");
            xml.append("ref=\"" + this.elems[i] + "\"/>\n");
        }
        return xml.toString();
    }
}

