//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: G4AtomicShells.cc 95972 2016-03-04 19:04:49Z vnivanch $
//
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

// 24-04-98, implementation of the first version, V. Grichine
// 16-11-98, GetBindingEnergy(Z,ShellNb), M.Maire
// 19-07-04, add a protection in GetNumberOfShells(), mma
// 11-02-05, GetNumberOfElectrons(Z,ShellNb), V.Ivanchenko
// 30-04-10, added fIndexOfShells, V.Ivanchenko
// 20-10-15, Complete re-write of the class. Same methods but
//           values modified to match EADL source data up to
//           element Z=120, L.G. Sarmiento

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

#include "G4AtomicShells_EADL.hh"
#include "G4SystemOfUnits.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

const G4int
G4AtomicShells_EADL::fNumberOfShells[121] =
{
    1 ,   // nonexisting zero element

    1 ,     1 ,     2 ,     2 ,     3 ,     3 ,     4 ,     4 ,     4 ,     4 ,  //   1 -  10

    5 ,     5 ,     6 ,     6 ,     7 ,     7 ,     7 ,     7 ,     8 ,     8 ,  //  11 -  20

    9 ,     9 ,     9 ,    10 ,    10 ,    10 ,    10 ,    10 ,    10 ,    10 ,  //  21 -  30

   11 ,    11 ,    12 ,    12 ,    12 ,    12 ,    13 ,    13 ,    14 ,    14 ,  //  31 -  40

   14 ,    15 ,    15 ,    15 ,    15 ,    14 ,    15 ,    15 ,    16 ,    16 ,  //  41 -  50

   17 ,    17 ,    17 ,    17 ,    18 ,    18 ,    19 ,    20 ,    20 ,    19 ,  //  51 -  60

   19 ,    19 ,    20 ,    21 ,    21 ,    20 ,    20 ,    20 ,    20 ,    20 ,  //  61 -  70

   21 ,    21 ,    21 ,    21 ,    22 ,    22 ,    22 ,    22 ,    22 ,    22 ,  //  71 -  80

   23 ,    23 ,    24 ,    24 ,    24 ,    24 ,    25 ,    25 ,    26 ,    26 ,  //  81 -  90

   27 ,    27 ,    27 ,    26 ,    27 ,    28 ,    28 ,    27 ,    27 ,    27 ,  //  91 - 100

   27 ,    27 ,    28 ,    28 ,    28 ,    28 ,    29 ,    29 ,    29 ,    29 ,  // 101 - 110

   29 ,    29 ,    30 ,    30 ,    31 ,    31 ,    31 ,    31 ,    32 ,    32    // 111 - 120

};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

const G4int
G4AtomicShells_EADL::fIndexOfShells[121] =
  {
    0 ,   // nonexisting zero element

    1 ,     2 ,     3 ,     5 ,     7 ,    10 ,    13 ,    17 ,    21 ,    25 ,  //   1 -  10

   29 ,    34 ,    39 ,    45 ,    51 ,    58 ,    65 ,    72 ,    79 ,    87 ,  //  11 -  20

   95 ,   104 ,   113 ,   122 ,   132 ,   142 ,   152 ,   162 ,   172 ,   182 ,  //  21 -  30

  192 ,   203 ,   214 ,   226 ,   238 ,   250 ,   262 ,   275 ,   288 ,   302 ,  //  31 -  40

  316 ,   330 ,   345 ,   360 ,   375 ,   390 ,   404 ,   419 ,   434 ,   450 ,  //  41 -  50

  466 ,   483 ,   500 ,   517 ,   534 ,   552 ,   570 ,   589 ,   609 ,   629 ,  //  51 -  60

  648 ,   667 ,   686 ,   706 ,   727 ,   748 ,   768 ,   788 ,   808 ,   828 ,  //  61 -  70

  848 ,   869 ,   890 ,   911 ,   932 ,   954 ,   976 ,   998 ,  1020 ,  1042 ,  //  71 -  80

 1064 ,  1087 ,  1110 ,  1134 ,  1158 ,  1182 ,  1206 ,  1231 ,  1256 ,  1282 ,  //  81 -  90

 1308 ,  1335 ,  1362 ,  1389 ,  1415 ,  1442 ,  1470 ,  1498 ,  1525 ,  1552 ,  //  91 - 100

 1579 ,  1606 ,  1633 ,  1661 ,  1689 ,  1717 ,  1745 ,  1774 ,  1803 ,  1832 ,  // 101 - 110

 1861 ,  1890 ,  1919 ,  1949 ,  1979 ,  2010 ,  2041 ,  2072 ,  2103 ,  2135    // 111 - 120

};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

const G4double
G4AtomicShells_EADL::fBindingEnergies[2167] =
{
  // 0     ----------------------------------------------
    0.0000,  // nonexisting zero element

  // H     ----------------------------------------------
    0.0136,

  // He    ----------------------------------------------
    0.0246,

  // Li    ----------------------------------------------
    0.0580,    0.0054,

  // Be    ----------------------------------------------
    0.1150,    0.0093,

  // B     ----------------------------------------------
    0.1880,    0.0126,    0.0047,

  // C     ----------------------------------------------
    0.2841,    0.0181,    0.0090,

  // N     ----------------------------------------------
    0.4005,    0.0243,    0.0097,    0.0089,

  // O     ----------------------------------------------
    0.5320,    0.0237,    0.0074,    0.0068,

  // F     ----------------------------------------------
    0.6854,    0.0340,    0.0087,    0.0084,

  // Ne    ----------------------------------------------
    0.8701,    0.0485,    0.0217,    0.0216,

  // Na    ----------------------------------------------
    1.0721,    0.0633,    0.0311,    0.0310,    0.0007,

  // Mg    ----------------------------------------------
    1.3050,    0.0894,    0.0515,    0.0513,    0.0021,

  // Al    ----------------------------------------------
    1.5596,    0.1177,    0.0732,    0.0727,    0.0060,
    0.0007,

  // Si    ----------------------------------------------
    1.8389,    0.1487,    0.0995,    0.0989,    0.0076,
    0.0030,

  // P     ----------------------------------------------
    2.1455,    0.1893,    0.1362,    0.1353,    0.0162,
    0.0101,    0.0096,

  // S     ----------------------------------------------
    2.4720,    0.2292,    0.1654,    0.1642,    0.0158,
    0.0082,    0.0078,

  // Cl    ----------------------------------------------
    2.8224,    0.2702,    0.2016,    0.2000,    0.0175,
    0.0067,    0.0067,

  // Ar    ----------------------------------------------
    3.2029,    0.3260,    0.2506,    0.2485,    0.0292,
    0.0159,    0.0158,

  // K     ----------------------------------------------
    3.6074,    0.3771,    0.2963,    0.2936,    0.0339,
    0.0181,    0.0178,    0.0001,

  // Ca    ----------------------------------------------
    4.0381,    0.4378,    0.3500,    0.3464,    0.0437,
    0.0258,    0.0255,    0.0018,

  // Sc    ----------------------------------------------
    4.4928,    0.5004,    0.4067,    0.4022,    0.0538,
    0.0338,    0.0315,    0.0066,    0.0017,

  // Ti    ----------------------------------------------
    4.9664,    0.5637,    0.4615,    0.4555,    0.0603,
    0.0356,    0.0322,    0.0037,    0.0016,

  // V     ----------------------------------------------
    5.4651,    0.6282,    0.5205,    0.5129,    0.0665,
    0.0400,    0.0350,    0.0022,    0.0017,

  // Cr    ----------------------------------------------
    5.9892,    0.6946,    0.5837,    0.5745,    0.0741,
    0.0459,    0.0399,    0.0029,    0.0022,    0.0010,

  // Mn    ----------------------------------------------
    6.5390,    0.7690,    0.6514,    0.6403,    0.0839,
    0.0531,    0.0464,    0.0035,    0.0027,    0.0019,

  // Fe    ----------------------------------------------
    7.1130,    0.8461,    0.7211,    0.7081,    0.0929,
    0.0581,    0.0520,    0.0039,    0.0031,    0.0021,

  // Co    ----------------------------------------------
    7.7089,    0.9256,    0.7936,    0.7786,    0.1007,
    0.0632,    0.0577,    0.0033,    0.0027,    0.0019,

  // Ni    ----------------------------------------------
    8.3328,    1.0081,    0.8719,    0.8547,    0.1118,
    0.0712,    0.0697,    0.0039,    0.0033,    0.0022,

  // Cu    ----------------------------------------------
    8.9789,    1.0961,    0.9510,    0.9311,    0.1198,
    0.0753,    0.0728,    0.0018,    0.0015,    0.0012,

  // Zn    ----------------------------------------------
    9.6586,    1.1936,    1.0428,    1.0197,    0.1359,
    0.0886,    0.0856,    0.0080,    0.0079,    0.0013,

  // Ga    ----------------------------------------------
   10.3671,    1.2977,    1.1423,    1.1154,    0.1581,
    0.1068,    0.1029,    0.0207,    0.0157,    0.0056,
    0.0008,

  // Ge    ----------------------------------------------
   11.1031,    1.4143,    1.2478,    1.2167,    0.1800,
    0.1279,    0.1208,    0.0292,    0.0285,    0.0090,
    0.0023,

  // As    ----------------------------------------------
   11.8667,    1.5265,    1.3586,    1.3231,    0.2035,
    0.1464,    0.1405,    0.0417,    0.0409,    0.0125,
    0.0025,    0.0025,

  // Se    ----------------------------------------------
   12.6578,    1.6539,    1.4762,    1.4358,    0.2315,
    0.1682,    0.1619,    0.0574,    0.0564,    0.0162,
    0.0056,    0.0056,

  // Br    ----------------------------------------------
   13.4737,    1.7820,    1.5960,    1.5499,    0.2565,
    0.1893,    0.1815,    0.0701,    0.0690,    0.0273,
    0.0052,    0.0046,

  // Kr    ----------------------------------------------
   14.3256,    1.9210,    1.7272,    1.6749,    0.2921,
    0.2221,    0.2144,    0.0950,    0.0938,    0.0275,
    0.0147,    0.0140,

  // Rb    ----------------------------------------------
   15.1997,    2.0651,    1.8639,    1.8044,    0.3221,
    0.2474,    0.2385,    0.1118,    0.1103,    0.0293,
    0.0148,    0.0140,    0.0040,

  // Sr    ----------------------------------------------
   16.1046,    2.2163,    2.0068,    1.9396,    0.3575,
    0.2798,    0.2691,    0.1350,    0.1331,    0.0377,
    0.0207,    0.0195,    0.0050,

  // Y     ----------------------------------------------
   17.0384,    2.3725,    2.1555,    2.0800,    0.3936,
    0.3124,    0.3003,    0.1596,    0.1574,    0.0454,
    0.0251,    0.0228,    0.0060,    0.0024,

  // Zr    ----------------------------------------------
   17.9976,    2.5316,    2.3067,    2.2223,    0.4303,
    0.3442,    0.3305,    0.1824,    0.1800,    0.0513,
    0.0293,    0.0257,    0.0070,    0.0030,

  // Nb    ----------------------------------------------
   18.9856,    2.6977,    2.4647,    2.3705,    0.4684,
    0.3784,    0.3630,    0.2074,    0.2046,    0.0581,
    0.0356,    0.0296,    0.0070,    0.0032,

  // Mo    ----------------------------------------------
   19.9995,    2.8655,    2.6251,    2.5202,    0.5046,
    0.4097,    0.3923,    0.2303,    0.2270,    0.0618,
    0.0383,    0.0323,    0.0070,    0.0019,    0.0012,

  // Tc    ----------------------------------------------
   21.0440,    3.0425,    2.7932,    2.6769,    0.5440,
    0.4449,    0.4250,    0.2564,    0.2529,    0.0688,
    0.0428,    0.0369,    0.0070,    0.0020,    0.0012,

  // Ru    ----------------------------------------------
   22.1172,    3.2240,    2.9669,    2.8379,    0.5850,
    0.4828,    0.4606,    0.2836,    0.2794,    0.0749,
    0.0470,    0.0412,    0.0070,    0.0024,    0.0018,

  // Rh    ----------------------------------------------
   23.2199,    3.4119,    3.1461,    3.0038,    0.6271,
    0.5210,    0.4962,    0.3117,    0.3070,    0.0810,
    0.0519,    0.0463,    0.0070,    0.0028,    0.0022,

  // Pd    ----------------------------------------------
   24.3503,    3.6043,    3.3303,    3.1733,    0.6699,
    0.5591,    0.5315,    0.3400,    0.3347,    0.0864,
    0.0544,    0.0500,    0.0017,    0.0013,

  // Ag    ----------------------------------------------
   25.5140,    3.8058,    3.5237,    3.3511,    0.7175,
    0.6024,    0.5714,    0.3728,    0.3667,    0.0952,
    0.0626,    0.0559,    0.0080,    0.0036,    0.0031,

  // Cd    ----------------------------------------------
   26.7112,    4.0180,    3.7270,    3.5375,    0.7702,
    0.6507,    0.6165,    0.4105,    0.4037,    0.1076,
    0.0708,    0.0650,    0.0097,    0.0090,    0.0090,

  // In    ----------------------------------------------
   27.9399,    4.2375,    3.9380,    3.7301,    0.8256,
    0.7022,    0.6643,    0.4508,    0.4431,    0.1219,
    0.0819,    0.0751,    0.0168,    0.0158,    0.0008,
    0.0001,

  // Sn    ----------------------------------------------
   29.2001,    4.4647,    4.1561,    3.9288,    0.8838,
    0.7564,    0.7144,    0.4933,    0.4848,    0.1365,
    0.0939,    0.0860,    0.0246,    0.0234,    0.0011,
    0.0009,

  // Sb    ----------------------------------------------
   30.4912,    4.6983,    4.3804,    4.1323,    0.9437,
    0.8119,    0.7656,    0.5369,    0.5275,    0.1520,
    0.1043,    0.0954,    0.0322,    0.0308,    0.0067,
    0.0022,    0.0020,

  // Te    ----------------------------------------------
   31.8138,    4.9392,    4.6120,    4.3414,    1.0060,
    0.8697,    0.8187,    0.5825,    0.5721,    0.1683,
    0.1168,    0.0969,    0.0408,    0.0392,    0.0116,
    0.0026,    0.0020,

  // I     ----------------------------------------------
   33.1694,    5.1881,    4.8521,    4.5571,    1.0721,
    0.9305,    0.8746,    0.6313,    0.6194,    0.1864,
    0.1301,    0.1190,    0.0507,    0.0489,    0.0136,
    0.0038,    0.0029,

  // Xe    ----------------------------------------------
   34.5644,    5.4528,    5.1037,    4.7822,    1.1487,
    0.9990,    0.9370,    0.6906,    0.6747,    0.2177,
    0.1639,    0.1565,    0.0695,    0.0676,    0.0234,
    0.0134,    0.0121,

  // Cs    ----------------------------------------------
   35.9846,    5.7143,    5.3594,    5.0119,    1.2171,
    1.0650,    0.9976,    0.7395,    0.7255,    0.2308,
    0.1723,    0.1616,    0.0788,    0.0765,    0.0227,
    0.0131,    0.0114,    0.0040,

  // Ba    ----------------------------------------------
   37.4406,    5.9888,    5.6236,    5.2470,    1.2928,
    1.1367,    1.0622,    0.7961,    0.7807,    0.2530,
    0.1918,    0.1797,    0.0925,    0.0899,    0.0291,
    0.0166,    0.0146,    0.0050,

  // La    ----------------------------------------------
   38.9246,    6.2663,    5.8906,    5.4827,    1.3613,
    1.2044,    1.1234,    0.8485,    0.8317,    0.2704,
    0.2058,    0.1914,    0.1007,    0.0977,    0.0323,
    0.0166,    0.0133,    0.0060,    0.0050,

  // Ce    ----------------------------------------------
   40.4430,    6.5488,    6.1642,    5.7234,    1.4346,
    1.2728,    1.1854,    0.9013,    0.8833,    0.2896,
    0.2233,    0.2072,    0.1136,    0.1076,    0.0378,
    0.0218,    0.0188,    0.0060,    0.0050,    0.0001,

  // Pr    ----------------------------------------------
   41.9906,    6.8348,    6.4404,    5.9643,    1.5110,
    1.3374,    1.2422,    0.9511,    0.9310,    0.3045,
    0.2363,    0.2176,    0.1179,    0.1101,    0.0374,
    0.0246,    0.0212,    0.0060,    0.0050,    0.0020,

  // Nd    ----------------------------------------------
   43.5689,    7.1260,    6.7215,    6.2079,    1.5753,
    1.4028,    1.2974,    0.9999,    0.9777,    0.3152,
    0.2433,    0.2246,    0.1234,    0.1135,    0.0375,
    0.0236,    0.0198,    0.0050,    0.0015,

  // Pm    ----------------------------------------------
   45.1840,    7.4279,    7.0128,    6.4593,    1.6486,
    1.4714,    1.3569,    1.0515,    1.0269,    0.3314,
    0.2547,    0.2362,    0.1276,    0.1156,    0.0360,
    0.0245,    0.0201,    0.0050,    0.0035,

  // Sm    ----------------------------------------------
   46.8342,    7.7368,    7.3118,    6.7162,    1.7228,
    1.5407,    1.4198,    1.1060,    1.0802,    0.3457,
    0.2656,    0.2474,    0.1375,    0.1233,    0.0374,
    0.0236,    0.0189,    0.0055,    0.0050,

  // Eu    ----------------------------------------------
   48.5190,    8.0520,    7.6171,    6.9769,    1.8000,
    1.6139,    1.4806,    1.1606,    1.1309,    0.3602,
    0.2839,    0.2566,    0.1414,    0.1277,    0.0318,
    0.0252,    0.0204,    0.0060,    0.0015,    0.0012,

  // Gd    ----------------------------------------------
   50.2391,    8.3756,    7.9303,    7.2428,    1.8808,
    1.6883,    1.5440,    1.2172,    1.1852,    0.3758,
    0.2885,    0.2709,    0.1495,    0.1345,    0.0361,
    0.0243,    0.0183,    0.0060,    0.0060,    0.0020,
    0.0013,

  // Tb    ----------------------------------------------
   51.9957,    8.7080,    8.2516,    7.5140,    1.9675,
    1.7677,    1.6113,    1.2750,    1.2412,    0.3979,
    0.3102,    0.2850,    0.1545,    0.1420,    0.0390,
    0.0263,    0.0213,    0.0060,    0.0060,    0.0040,
    0.0016,

  // Dy    ----------------------------------------------
   53.7885,    9.0458,    8.5806,    7.7901,    2.0468,
    1.8418,    1.6756,    1.3325,    1.2949,    0.4163,
    0.3318,    0.2929,    0.1614,    0.1494,    0.0629,
    0.0282,    0.0229,    0.0060,    0.0055,    0.0033,

  // Ho    ----------------------------------------------
   55.6177,    9.3942,    8.9178,    8.0711,    2.1283,
    1.9228,    1.7412,    1.3915,    1.3514,    0.4357,
    0.3435,    0.3066,    0.1678,    0.1568,    0.0512,
    0.0249,    0.0195,    0.0060,    0.0048,    0.0028,

  // Er    ----------------------------------------------
   57.4855,    9.7513,    9.2643,    8.3579,    2.2167,
    2.0058,    1.8118,    1.4533,    1.4093,    0.4491,
    0.3662,    0.3200,    0.1767,    0.1676,    0.0598,
    0.0279,    0.0223,    0.0060,    0.0053,    0.0036,

  // Tm    ----------------------------------------------
   59.3896,   10.1157,    9.6169,    8.6480,    2.3068,
    2.0898,    1.8845,    1.5146,    1.4677,    0.4717,
    0.3859,    0.3366,    0.1855,    0.1757,    0.0532,
    0.0362,    0.0304,    0.0062,    0.0060,    0.0047,

  // Yb    ----------------------------------------------
   61.3323,   10.4864,    9.9782,    8.9436,    2.3981,
    2.1730,    1.9498,    1.5763,    1.5278,    0.4872,
    0.3967,    0.3435,    0.1981,    0.1849,    0.0541,
    0.0274,    0.0214,    0.0070,    0.0060,    0.0058,

  // Lu    ----------------------------------------------
   63.3138,   10.8704,   10.3486,    9.2441,    2.4912,
    2.2635,    2.0236,    1.6394,    1.5885,    0.5062,
    0.4101,    0.3593,    0.2048,    0.1950,    0.0568,
    0.0330,    0.0255,    0.0078,    0.0070,    0.0062,
    0.0046,

  // Hf    ----------------------------------------------
   65.3508,   11.2707,   10.7394,    9.5607,    2.6009,
    2.3654,    2.1076,    1.7164,    1.6617,    0.5381,
    0.4370,    0.3804,    0.2238,    0.2137,    0.0649,
    0.0382,    0.0290,    0.0182,    0.0163,    0.0070,
    0.0066,

  // Ta    ----------------------------------------------
   67.4164,   11.6815,   11.1361,    9.8811,    2.7080,
    2.4687,    2.1940,    1.7932,    1.7351,    0.5655,
    0.4648,    0.4045,    0.2413,    0.2293,    0.0711,
    0.0437,    0.0347,    0.0275,    0.0256,    0.0080,
    0.0057,

  // W     ----------------------------------------------
   69.5250,   12.0998,   11.5440,   10.2068,    2.8196,
    2.5749,    2.2810,    1.8716,    1.8092,    0.5950,
    0.4916,    0.4253,    0.2588,    0.2454,    0.0771,
    0.0467,    0.0374,    0.0365,    0.0351,    0.0080,
    0.0061,

  // Re    ----------------------------------------------
   71.6764,   12.5267,   11.9587,   10.5353,    2.9317,
    2.6816,    2.3673,    1.9489,    1.8829,    0.6250,
    0.5179,    0.4444,    0.2737,    0.2602,    0.0828,
    0.0484,    0.0481,    0.0457,    0.0368,    0.0080,
    0.0038,    0.0025,

  // Os    ----------------------------------------------
   73.8708,   12.9680,   12.3850,   10.8702,    3.0485,
    2.7922,    2.4572,    2.0308,    1.9601,    0.6543,
    0.5465,    0.4682,    0.2894,    0.2728,    0.0837,
    0.0580,    0.0538,    0.0510,    0.0454,    0.0080,
    0.0009,    0.0004,

  // Ir    ----------------------------------------------
   76.1110,   13.4185,   12.8241,   11.2152,    3.1737,
    2.9087,    2.5507,    2.1161,    2.0404,    0.6901,
    0.5771,    0.4943,    0.3114,    0.2949,    0.0952,
    0.0638,    0.0630,    0.0608,    0.0496,    0.0090,
    0.0042,    0.0032,

  // Pt    ----------------------------------------------
   78.3948,   13.8801,   13.2726,   11.5637,    3.2972,
    3.0267,    2.6457,    2.2017,    2.1214,    0.7228,
    0.6084,    0.5190,    0.3307,    0.3134,    0.1017,
    0.0743,    0.0709,    0.0653,    0.0516,    0.0090,
    0.0028,    0.0014,

  // Au    ----------------------------------------------
   80.7249,   14.3528,   13.7336,   11.9187,    3.4249,
    3.1478,    2.7430,    2.2911,    2.2057,    0.7588,
    0.6437,    0.5454,    0.3520,    0.3339,    0.1078,
    0.0873,    0.0837,    0.0717,    0.0569,    0.0090,
    0.0033,    0.0018,

  // Hg    ----------------------------------------------
   83.1023,   14.8393,   14.2087,   12.2839,    3.5616,
    3.2785,    2.8471,    2.3849,    2.2949,    0.8030,
    0.6769,    0.5710,    0.3783,    0.3598,    0.1203,
    0.1033,    0.0994,    0.0805,    0.0618,    0.0090,
    0.0075,    0.0057,

  // Tl    ----------------------------------------------
   85.5304,   15.3467,   14.6979,   12.6575,    3.7041,
    3.4157,    2.9566,    2.4851,    2.3893,    0.8455,
    0.7213,    0.6090,    0.4066,    0.3862,    0.1363,
    0.1230,    0.1187,    0.0996,    0.0745,    0.0153,
    0.0131,    0.0060,    0.0008,

  // Pb    ----------------------------------------------
   88.0045,   15.8608,   15.2000,   13.0352,    3.8507,
    3.5542,    3.0664,    2.5856,    2.4840,    0.8936,
    0.7639,    0.6445,    0.4352,    0.4129,    0.1473,
    0.1418,    0.1369,    0.1048,    0.0845,    0.0218,
    0.0192,    0.0031,    0.0007,

  // Bi    ----------------------------------------------
   90.5259,   16.3875,   15.7111,   13.4186,    3.9991,
    3.6963,    3.1769,    2.6876,    2.5796,    0.9382,
    0.8053,    0.6789,    0.4636,    0.4400,    0.1623,
    0.1593,    0.1572,    0.1168,    0.0929,    0.0265,
    0.0244,    0.0075,    0.0012,    0.0002,

  // Po    ----------------------------------------------
   93.0999,   16.9279,   16.2380,   13.8106,    4.1535,
    3.8443,    3.2934,    2.7936,    2.6792,    0.9875,
    0.8509,    0.7152,    0.4957,    0.4699,    0.1846,
    0.1789,    0.1775,    0.1318,    0.1037,    0.0338,
    0.0306,    0.0110,    0.0032,    0.0014,

  // At    ----------------------------------------------
   95.7240,   17.4815,   16.7773,   14.2080,    4.3117,
    3.9958,    3.4105,    2.9018,    2.7807,    1.0382,
    0.8977,    0.7537,    0.5276,    0.5001,    0.2070,
    0.2008,    0.1934,    0.1456,    0.1136,    0.0409,
    0.0374,    0.0150,    0.0057,    0.0028,

  // Rn    ----------------------------------------------
   98.3972,   18.0487,   17.3297,   14.6114,    4.4743,
    4.1515,    3.5305,    3.0123,    2.8842,    1.0905,
    0.9462,    0.7912,    0.5604,    0.5311,    0.2301,
    0.2236,    0.2096,    0.1595,    0.1239,    0.0480,
    0.0442,    0.0187,    0.0076,    0.0041,

  // Fr    ----------------------------------------------
  101.1299,   18.6341,   17.9005,   15.0256,    4.6457,
    4.3160,    3.6573,    3.1297,    2.9949,    1.1490,
    1.0007,    0.8351,    0.5987,    0.5675,    0.2586,
    0.2516,    0.2309,    0.1787,    0.1387,    0.0600,
    0.0556,    0.0263,    0.0132,    0.0088,    0.0040,

  // Ra    ----------------------------------------------
  103.9162,   19.2367,   18.4843,   15.4444,    4.8220,
    4.4850,    3.7866,    3.2484,    3.1049,    1.2084,
    1.0576,    0.8791,    0.6359,    0.6027,    0.2879,
    0.2804,    0.2544,    0.2004,    0.1528,    0.0694,
    0.0638,    0.0355,    0.0192,    0.0137,    0.0050,

  // Ac    ----------------------------------------------
  106.7563,   19.8459,   19.0830,   15.8712,    5.0006,
    4.6568,    3.9167,    3.3701,    3.2197,    1.2694,
    1.1128,    0.9243,    0.6739,    0.6411,    0.3164,
    0.3084,    0.2735,    0.2169,    0.1678,    0.0833,
    0.0777,    0.0398,    0.0241,    0.0170,    0.0060,
    0.0060,

  // Th    ----------------------------------------------
  109.6491,   20.4721,   19.6932,   16.3003,    5.1823,
    4.8304,    4.0461,    3.4908,    3.3320,    1.3295,
    1.1682,    0.9672,    0.7137,    0.6766,    0.3444,
    0.3350,    0.2902,    0.2320,    0.1808,    0.0941,
    0.0873,    0.0414,    0.0258,    0.0173,    0.0060,
    0.0060,

  // Pa    ----------------------------------------------
  112.5961,   21.1114,   20.3137,   16.7291,    5.3669,
    5.0027,    4.1738,    3.6064,    3.4394,    1.3871,
    1.2243,    1.0067,    0.7434,    0.7082,    0.3712,
    0.3595,    0.3096,    0.2446,    0.1863,    0.0973,
    0.0892,    0.0467,    0.0281,    0.0189,    0.0060,
    0.0060,    0.0060,

  // U     ----------------------------------------------
  115.6006,   21.7574,   20.9476,   17.1663,    5.5480,
    5.1822,    4.3034,    3.7276,    3.5517,    1.4408,
    1.2718,    1.0449,    0.7802,    0.7377,    0.3907,
    0.3799,    0.3233,    0.2593,    0.1959,    0.1044,
    0.0952,    0.0495,    0.0308,    0.0186,    0.0060,
    0.0060,    0.0060,

  // Np    ----------------------------------------------
  118.6686,   22.4281,   21.6013,   17.6106,    5.7396,
    5.3667,    4.4334,    3.8498,    3.6652,    1.5001,
    1.3277,    1.0860,    0.8161,    0.7708,    0.4143,
    0.4034,    0.3398,    0.2834,    0.2062,    0.1093,
    0.1012,    0.0500,    0.0293,    0.0175,    0.0060,
    0.0060,    0.0060,

  // Pu    ----------------------------------------------
  121.7911,   23.0978,   22.2668,   18.0570,    5.9329,
    5.5412,    4.5566,    3.9726,    3.7781,    1.5593,
    1.3774,    1.1209,    0.8489,    0.8015,    0.4374,
    0.4252,    0.3519,    0.2825,    0.2153,    0.1160,
    0.1052,    0.0486,    0.0306,    0.0184,    0.0060,
    0.0060,

  // Am    ----------------------------------------------
  124.9809,   23.8051,   22.9494,   18.5062,    6.1326,
    5.7470,    4.7060,    4.0921,    3.8869,    1.6192,
    1.4351,    1.1680,    0.8804,    0.8300,    0.4633,
    0.4490,    0.3730,    0.3030,    0.2164,    0.1180,
    0.1079,    0.0504,    0.0311,    0.0181,    0.0060,
    0.0060,    0.0060,

  // Cm    ----------------------------------------------
  128.2000,   24.5200,   23.6600,   18.9700,    6.3350,
    5.9400,    4.8500,    4.2300,    4.0150,    1.6850,
    1.4950,    1.2050,    0.9250,    0.8700,    0.4950,
    0.4850,    0.3970,    0.2350,    0.1350,    0.1200,
    0.0970,    0.0920,    0.0670,    0.0500,    0.0060,
    0.0060,    0.0060,    0.0060,

  // Bk    ----------------------------------------------
  131.6000,   25.2600,   24.3800,   19.4400,    6.5450,
    6.1450,    4.9900,    4.3600,    4.1350,    1.7450,
    1.5550,    1.2450,    0.9600,    0.9000,    0.5250,
    0.5100,    0.4150,    0.3300,    0.2430,    0.1400,
    0.1250,    0.0960,    0.0700,    0.0500,    0.0060,
    0.0060,    0.0060,    0.0044,

  // Cf    ----------------------------------------------
  135.0000,   26.0100,   25.1200,   19.9100,    6.7550,
    6.3500,    5.1350,    4.4950,    4.2600,    1.8100,
    1.6150,    1.2850,    0.9950,    0.9300,    0.5550,
    0.5400,    0.4300,    0.3450,    0.2500,    0.1450,
    0.1300,    0.1000,    0.0700,    0.0500,    0.0060,
    0.0060,    0.0060,

  // Es    ----------------------------------------------
  138.4000,   26.7800,   25.8800,   20.3900,    6.9750,
    6.5600,    5.2800,    4.6300,    4.3850,    1.8750,
    1.6750,    1.3250,    1.0300,    0.9650,    0.5850,
    0.5700,    0.4450,    0.3600,    0.2600,    0.1550,
    0.1350,    0.1000,    0.0700,    0.0500,    0.0060,
    0.0060,    0.0060,

  // Fm    ----------------------------------------------
  142.0000,   27.5700,   26.6600,   20.8700,    7.2000,
    6.7800,    5.4250,    4.7650,    4.5100,    1.9400,
    1.7400,    1.3700,    1.0650,    1.0000,    0.6150,
    0.6000,    0.4600,    0.3750,    0.2700,    0.1650,
    0.1400,    0.1000,    0.0800,    0.0500,    0.0060,
    0.0060,    0.0060,

  // Md    ----------------------------------------------
  145.6000,   28.3800,   27.4600,   21.3600,    7.4300,
    7.0000,    5.5750,    4.9050,    4.6330,    2.0050,
    1.8050,    1.4150,    1.1050,    1.0350,    0.6450,
    0.6300,    0.4800,    0.3900,    0.2800,    0.1750,
    0.1450,    0.1100,    0.0800,    0.0500,    0.0070,
    0.0070,    0.0060,

  // No    ----------------------------------------------
  149.3000,   29.2220,   28.2800,   21.8500,    7.6700,
    7.2300,    5.7300,    5.0500,    4.7650,    2.0750,
    1.8750,    1.4600,    1.1450,    1.0700,    0.6800,
    0.6500,    0.5000,    0.4100,    0.2900,    0.1850,
    0.1550,    0.1100,    0.0800,    0.0500,    0.0100,
    0.0100,    0.0060,

  // Lr    ----------------------------------------------
  153.0000,   30.0800,   29.1300,   22.3500,    7.9200,
    7.4700,    5.8900,    5.2000,    4.9000,    2.1500,
    1.9500,    1.5050,    1.1900,    1.1100,    0.7200,
    0.6900,    0.5200,    0.4300,    0.3000,    0.2000,
    0.1600,    0.1200,    0.0900,    0.0600,    0.0150,
    0.0150,    0.0070,    0.0070,

  // Rf    ----------------------------------------------
  156.9000,   30.9600,   30.0000,   22.8600,    8.1700,
    7.7200,    6.0550,    5.3500,    5.0400,    2.2250,
    2.0250,    1.5550,    1.2350,    1.1500,    0.7600,
    0.7200,    0.5400,    0.4550,    0.3150,    0.2150,
    0.1700,    0.1200,    0.0900,    0.0600,    0.0200,
    0.0200,    0.0080,    0.0080,

  // Db    ----------------------------------------------
  160.8000,   31.8700,   30.9000,   23.3800,    8.4300,
    7.9800,    6.6250,    5.5050,    5.1850,    2.3050,
    2.1050,    1.6050,    1.2800,    1.1900,    0.8000,
    0.7500,    0.5600,    0.4800,    0.3300,    0.2300,
    0.1800,    0.1300,    0.1000,    0.0600,    0.0250,
    0.0250,    0.0090,    0.0080,

  // Sg    ----------------------------------------------
  164.9000,   32.8000,   31.8200,   23.9100,    8.7000,
    8.2400,    6.4000,    5.6650,    5.3300,    2.3850,
    2.1900,    1.6600,    1.3250,    1.2350,    0.8400,
    0.7800,    0.5850,    0.5050,    0.3450,    0.2450,
    0.1900,    0.1400,    0.1100,    0.0600,    0.0300,
    0.0300,    0.0090,    0.0080,

  // Bh    ----------------------------------------------
  169.0000,   33.7600,   32.7700,   24.4400,    8.9800,
    8.5100,    6.5800,    5.8300,    5.4750,    2.4700,
    2.2750,    1.7150,    1.3700,    1.2800,    0.8800,
    0.8200,    0.6100,    0.5300,    0.3600,    0.2600,
    0.2000,    0.1400,    0.1100,    0.0700,    0.0400,
    0.0400,    0.0100,    0.0100,    0.0090,

  // Hs    ----------------------------------------------
  173.2000,   34.7500,   33.7400,   24.9200,    9.2700,
    8.7900,    6.7600,    5.9950,    5.6200,    2.5550,
    2.3650,    1.7700,    1.4200,    1.3250,    0.9200,
    0.8600,    0.6350,    0.5550,    0.3750,    0.2750,
    0.2100,    0.1500,    0.1200,    0.0700,    0.0500,
    0.0500,    0.0100,    0.0100,    0.0090,

  // Mt    ----------------------------------------------
  177.6000,   35.7700,   34.7400,   25.5200,    9.5700,
    9.0800,    6.9400,    6.1600,    5.7700,    2.6450,
    2.4600,    1.8250,    1.4700,    1.3700,    0.9600,
    0.9000,    0.6600,    0.5800,    0.3900,    0.2900,
    0.2200,    0.1600,    0.1200,    0.0700,    0.0600,
    0.0600,    0.0100,    0.0100,    0.0100,

  // Ds    ----------------------------------------------
  182.0000,   36.8100,   35.7700,   26.0700,    9.8700,
    9.3700,    7.1200,    6.3300,    5.9200,    2.7350,
    2.5600,    1.8800,    1.5200,    1.4150,    1.0000,
    0.9400,    0.6900,    0.6100,    0.4050,    0.3050,
    0.2300,    0.1600,    0.1300,    0.0800,    0.0700,
    0.0700,    0.0100,    0.0100,    0.0100,

  // Rg    ----------------------------------------------
  186.1360,   37.8810,   36.7990,   26.6480,   10.1870,
    9.6870,    7.2240,    6.4470,    6.0250,    2.9260,
    2.6730,    1.9780,    1.5970,    1.4830,    0.9604,
    0.9267,    0.7283,    0.6450,    0.2810,    0.2510,
    0.2445,    0.1267,    0.0901,    0.0671,    0.0614,
    0.0498,    0.0094,    0.0094,    0.0066,

  // Cp    ----------------------------------------------
  190.7170,   38.9840,   37.8960,   27.2130,   10.5080,
   10.0020,    7.4060,    6.6180,    6.1780,    3.0330,
    2.7760,    2.0390,    1.6520,    1.5320,    1.0016,
    0.9662,    0.7624,    0.6770,    0.2960,    0.2650,
    0.2577,    0.1349,    0.0969,    0.0753,    0.0690,
    0.0528,    0.0104,    0.0098,    0.0073,

  // Uut   ----------------------------------------------
  195.4100,   40.1210,   39.0340,   27.7880,   10.8420,
   10.3310,    7.5930,    6.7930,    6.3350,    3.1460,
    2.8860,    2.1070,    1.7120,    1.5870,    1.0464,
    1.0092,    0.8006,    0.7140,    0.3150,    0.2820,
    0.2740,    0.1464,    0.1069,    0.0866,    0.0798,
    0.0586,    0.0138,    0.0116,    0.0101,    0.0049,

  // Fl    ----------------------------------------------
  200.2140,   41.2940,   40.2070,   28.3700,   11.1840,
   10.6720,    7.7830,    6.9720,    6.4950,    3.2640,
    2.9990,    2.1740,    1.7740,    1.6420,    1.0923,
    1.0533,    0.8409,    0.7530,    0.3350,    0.3000,
    0.2910,    0.1583,    0.1174,    0.0984,    0.0911,
    0.0646,    0.0173,    0.0135,    0.0130,    0.0057,

  // Uup   ----------------------------------------------
  205.1360,   42.5010,   41.4200,   28.9590,   11.5410,
   11.0220,    7.9790,    7.1550,    6.6580,    3.3860,
    3.1180,    2.2450,    1.8380,    1.7010,    1.1410,
    1.1000,    0.8831,    0.7940,    0.3570,    0.3200,
    0.3100,    0.1726,    0.1301,    0.1124,    0.1045,
    0.0724,    0.0227,    0.0177,    0.0169,    0.0078,
    0.0038,

  // Lv    ----------------------------------------------
  210.1770,   43.7500,   42.6740,   29.5560,   11.9070,
   11.3870,    8.1760,    7.3410,    6.8240,    3.5130,
    3.2410,    2.3160,    1.9030,    1.7590,    1.1907,
    1.1477,    0.9275,    0.8380,    0.3790,    0.3400,
    0.3296,    0.1874,    0.1434,    0.1269,    0.1184,
    0.0805,    0.0282,    0.0226,    0.0203,    0.0101,
    0.0044,

  // Uus   ----------------------------------------------
  215.3370,   44.0310,   43.9750,   30.1580,   12.2830,
   11.7620,    8.3760,    7.5300,    6.9910,    3.6430,
    3.4690,    2.3900,    1.9700,    1.8190,    1.2413,
    1.1962,    0.9733,    0.8820,    0.4020,    0.3610,
    0.3496,    0.2026,    0.1571,    0.1417,    0.1327,
    0.0886,    0.0337,    0.0275,    0.0237,    0.0124,
    0.0052,

  // Uuo   ----------------------------------------------
  220.6300,   46.3540,   45.3540,   30.7670,   12.6700,
   12.1510,    8.5790,    7.7200,    7.1610,    3.7780,
    3.5000,    2.4640,    2.0370,    1.8800,    1.2928,
    1.2455,    1.0205,    0.9280,    0.4250,    0.3820,
    0.3699,    0.2183,    0.1714,    0.1570,    0.1472,
    0.0968,    0.0394,    0.0324,    0.0272,    0.0149,
    0.0060,

  // Uue   ----------------------------------------------
  226.0630,   47.7240,   46.7140,   31.3860,   13.0740,
   12.5560,    8.7890,    7.9180,    7.3360,    3.9200,
    3.6390,    2.5430,    2.1090,    1.9440,    1.3476,
    1.2982,    1.0720,    0.9800,    0.4520,    0.4060,
    0.3931,    0.2371,    0.1887,    0.1751,    0.1646,
    0.1075,    0.0476,    0.0399,    0.0331,    0.0197,
    0.0084,    0.0036,

  // Ubn   ----------------------------------------------
  231.6340,   49.1390,   48.1580,   32.0130,   13.4890,
   12.9750,    9.0000,    8.1170,    7.5130,    4.0660,
    3.7840,    2.6220,    2.1820,    2.0100,    1.4040,
    1.3523,    1.1256,    1.0330,    0.4790,    0.4310,
    0.4173,    0.2570,    0.2071,    0.1941,    0.1830,
    0.1190,    0.0565,    0.0479,    0.0396,    0.0251,
    0.0113,    0.0042
};

const G4int
G4AtomicShells_EADL::fNumberOfElectrons[2167] =
{
  // 0     ----------------------------------------------
       0,  // nonexisting zero element

  // H     ----------------------------------------------
       1,

  // He    ----------------------------------------------
       2,

  // Li    ----------------------------------------------
       2,       1,

  // Be    ----------------------------------------------
       2,       2,

  // B     ----------------------------------------------
       2,       2,       1,

  // C     ----------------------------------------------
       2,       2,       2,

  // N     ----------------------------------------------
       2,       2,       1,       2,

  // O     ----------------------------------------------
       2,       2,       2,       2,

  // F     ----------------------------------------------
       2,       2,       3,       2,

  // Ne    ----------------------------------------------
       2,       2,       2,       4,

  // Na    ----------------------------------------------
       2,       2,       2,       4,       1,

  // Mg    ----------------------------------------------
       2,       2,       2,       4,       2,

  // Al    ----------------------------------------------
       2,       2,       2,       4,       1,
       2,

  // Si    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,

  // P     ----------------------------------------------
       2,       2,       2,       4,       2,
       1,       2,

  // S     ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       2,

  // Cl    ----------------------------------------------
       2,       2,       2,       4,       2,
       3,       2,

  // Ar    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,

  // K     ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       1,

  // Ca    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       2,

  // Sc    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       1,       2,

  // Ti    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       2,       2,

  // V     ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       3,       2,

  // Cr    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       1,       1,

  // Mn    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       1,       2,

  // Fe    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       2,       2,

  // Co    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       3,       4,       2,

  // Ni    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       4,       2,

  // Cu    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       1,

  // Zn    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       6,       4,       2,

  // Ga    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       1,

  // Ge    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,

  // As    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       1,       2,

  // Se    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       2,

  // Br    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       3,

  // Kr    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,

  // Rb    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,

  // Sr    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,

  // Y     ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       1,

  // Zr    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       2,

  // Nb    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       4,

  // Mo    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       4,       1,

  // Tc    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       4,       1,

  // Ru    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       4,       3,

  // Rh    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       4,       4,

  // Pd    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,

  // Ag    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       4,       6,

  // Cd    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,

  // In    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       1,
       2,

  // Sn    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,

  // Sb    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       1,

  // Te    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       2,

  // I     ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       3,

  // Xe    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,

  // Cs    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,

  // Ba    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,

  // La    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       2,

  // Ce    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       2,       1,

  // Pr    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       2,       2,

  // Nd    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       4,

  // Pm    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       5,

  // Sm    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       6,       2,

  // Eu    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       6,       1,

  // Gd    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       2,       6,
       1,

  // Tb    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       1,       2,       6,
       2,

  // Dy    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       6,       4,

  // Ho    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       6,       5,

  // Er    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       2,       6,       6,

  // Tm    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       6,       2,       7,

  // Yb    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       6,       2,       8,

  // Lu    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       6,       2,       8,
       1,

  // Hf    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       6,       8,       2,
       2,

  // Ta    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       4,       6,       8,       2,
       3,

  // W     ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       6,       4,       8,       2,
       4,

  // Re    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       6,       8,       4,       2,
       4,       1,

  // Os    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       2,       6,       8,       4,       2,
       2,       4,

  // Ir    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       6,       2,       8,       4,       2,
       4,       3,

  // Pt    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       6,       8,       2,       4,       1,
       4,       5,

  // Au    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       6,       8,       2,       4,       1,
       4,       6,

  // Hg    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       6,       8,       2,       4,       2,
       4,       6,

  // Tl    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       6,       8,       2,       4,       4,
       6,       1,       2,

  // Pb    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       2,
       6,       8,       2,       4,       4,
       6,       2,       2,

  // Bi    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       2,       8,       2,       4,       4,
       6,       2,       2,       1,

  // Po    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       2,

  // At    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       3,

  // Rn    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,

  // Fr    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       1,

  // Ra    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,

  // Ac    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       1,

  // Th    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       2,

  // Pa    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       1,       2,

  // U     ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       1,       3,

  // Np    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       1,       4,

  // Pu    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       6,

  // Am    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       1,       6,

  // Cm    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       2,       1,       2,       2,       6,
       4,       1,       6,

  // Bk    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       2,       6,       1,

  // Cf    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       4,       6,

  // Es    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       5,       6,

  // Fm    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       2,
       6,       6,

  // Md    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       7,
       6,       2,

  // No    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       2,

  // Lr    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       2,       1,

  // Rf    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       2,       2,

  // Db    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       3,       2,

  // Sg    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       4,       2,

  // Bh    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       4,       1,       2,

  // Hs    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       4,       2,       2,

  // Mt    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       2,       4,       3,

  // Ds    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       4,       8,
       6,       1,       4,       5,

  // Rg    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       1,       4,       6,

  // Cp    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       2,       6,

  // Uut   ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       2,       6,       1,

  // Fl    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       2,       6,       2,

  // Uup   ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       6,       2,       2,
       1,

  // Lv    ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       6,       2,       2,
       2,

  // Uus   ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       6,       2,       2,
       3,

  // Uuo   ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       6,       2,       2,
       4,

  // Uue   ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       6,       2,       2,
       4,       1,

  // Ubn   ----------------------------------------------
       2,       2,       2,       4,       2,
       2,       4,       4,       6,       2,
       2,       4,       4,       6,       6,
       8,       2,       2,       4,       4,
       6,       2,       2,       6,       8,
       4,       4,       6,       2,       2,
       4,       2
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

G4int
G4AtomicShells_EADL::GetNumberOfShells(G4int Z)
{
#ifdef G4VERBOSE
  if(Z<0 || Z>100) { Z = PrintErrorZ(Z, "GetNumberOfShells"); }
#endif
  return fNumberOfShells[Z];
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

G4double
G4AtomicShells_EADL::GetBindingEnergy(G4int Z, G4int ShellNb)
{
#ifdef G4VERBOSE
  if(Z<0 || Z>120) { Z = PrintErrorZ(Z, "GetBindingEnergy"); }
  if(ShellNb < 0 || ShellNb>=fNumberOfShells[Z]) {
    ShellNb = PrintErrorShell(Z, ShellNb, "GetBindingEnergy");
  }
#endif
  return fBindingEnergies[fIndexOfShells[Z] + ShellNb]*CLHEP::keV;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

G4int
G4AtomicShells_EADL::GetNumberOfElectrons(G4int Z, G4int ShellNb)
{
#ifdef G4VERBOSE
  if(Z<0 || Z>120) { Z = PrintErrorZ(Z, "GetNumberOfElectrons"); }
  if(ShellNb < 0 || ShellNb>=fNumberOfShells[Z]) {
    ShellNb = PrintErrorShell(Z, ShellNb, "GetNumberOfElectrons");
  }
#endif
  return fNumberOfElectrons[fIndexOfShells[Z] + ShellNb];
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

G4double G4AtomicShells_EADL::GetTotalBindingEnergy(G4int Z)
{
#ifdef G4VERBOSE
  if(Z<0 || Z>120) { Z = PrintErrorZ(Z, "GetTotalBindingEnergy"); }
#endif
  G4int idx = fIndexOfShells[Z];
  G4int idxmax = idx +  fNumberOfShells[Z];
  G4double energy = 0.0;
  for (G4int i=idx; i<idxmax; ++i) {energy += fBindingEnergies[i];}
  return energy*CLHEP::keV;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

#ifdef G4VERBOSE

G4int G4AtomicShells_EADL::PrintErrorZ(G4int Z, const G4String& ss)
{
  G4String sss = "G4AtomicShells::"+ss+"()";
  G4ExceptionDescription ed;
  ed << "Atomic number out of range Z= " << Z;
  G4Exception(sss,"mat060",FatalException,ed,"");
  return 1;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....

G4int
G4AtomicShells_EADL::PrintErrorShell(G4int Z, G4int n, const G4String& ss)
{
  G4String sss = "G4AtomicShells::"+ss+"()";
  G4ExceptionDescription ed;
  ed << "Shell number out of range Nshell= " << n << "  Z= " << Z;
  G4Exception(sss,"mat061",FatalException,ed,"");
  return 0;
}
#endif

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo.... ....oooOO0OOooo....